<?php
/**
 * 设定用函数
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wzy<wangzhenya@suxuantech.cn> 2017-10-27
 */
namespace app\vip\lib;
use think\Controller;
class Setting extends Controller{
    //获取品牌列表
    function getBrandList(){
        return db('CBrandclass')->order('id desc')->select();
    }
    //获取店面列表
    function getShopList($id = 0,$shop_name = ''){
        if($id){
            $result = db('CShopset')->where('id','<>',$id)->order('id desc')->select();
        }else{
            if($shop_name){
                $result = db('CShopset')->where('shop_name',''%'.','%'.$shop_name.'%')->order('id desc')->select();
            }else{
                $result = db('CShopset')->order('id desc')->select();
            }
        }
        return $result;
    }
    function  getShopListByFP(){
        $result = db('CShopset')->order('id desc')->select();
        return $result;
    }
    //获取店面列表
    function getShopListCount($id = 0,$shop_name = ''){
        if($id){
            $result = db('CShopset')->where('id','<>',$id)->order('id desc')->count();
        }else{
            if($shop_name){
                $result = db('CShopset')->where('shop_name','like','%'.$shop_name.'%')->order('id desc')->count();
            }else{
                $result = db('CShopset')->order('id desc')->count();
            }
        }
        return $result;
    }
    //获取店面列表接口
    function getStoreJson($shop_name = ''){
        $result['code'] = 0;
        $result['msg'] = '';
        if($shop_name){
                $result['count'] = db('CShopset')->where('shop_code',session('shop_code'))->where('shop_name','like','%'.$shop_name.'%')->field('id,brandclass,shop_name,shop_code,sn,numberorder,shopaddress,receiv_shop_code')->order('id desc')->count();
                $result['data'] = db('CShopset')->where('shop_code',session('shop_code'))->where('shop_name','like','%'.$shop_name.'%')->order('id desc')->select();
            }else{
                $result['count'] = db('CShopset')->order('id desc')->count();
                $result['data'] = db('CShopset')->field('id,brandclass,shop_name,shop_code,sn,numberorder,shopaddress,receiv_shop_code')->order('id desc')->select();
            }
        return(($result)) ;
    }
    function setStore($params){
        $db = db('CShopset');
        $db->insert($params);
        $id = $db->getLastInsID();
        $db->startTrans();
        if($id){
            //action_log($params,'',session(['staff_id']),0,session(['staff_name']));
            $db->commit();
            return $id;
        }else{
            $db->rollback();
            $res = array('error'=>1,'code'=>400,'msg'=>'店面设置有误！');
            return $res;
        }
    }
    function remindList1(){
        $res = db('SReminditemset')->where('shop_code',session('shop_code'))->where('id','remind1')->find();
        if($res){
            return $res;
        }else{
            return false;
        }
    }
    function remindList2(){
        $res = db('SReminditemset')->where('shop_code',session('shop_code'))->where('id','remind2')->find();
        if($res){
            return $res;
        }else{
            return false;
        }
    }
    function editRemind($param){
        db()->startTrans();

        for($i=1;$i<=2;$i++){
            if($param['isopen'.$i] == '' || $param['isopen'.$i] == null){
                $param['isopen'.$i] = 0;
            }
            $info = db('SReminditemset')->where('id',$param['id'.$i])->where('shop_code',session('shop_code'))->find();
            if($info['id']){
                $data = array(
                    'isopen' => $param['isopen'.$i],
                    'remind_type' => $param['remind_type'.$i],
                    'advancehour' => $param['advancehour'.$i],
                );
                $up = db('SReminditemset')->where('id',$param['id'.$i])->where('shop_code',session('shop_code'))->update($data);
                if($up){
                    db()->commit();
                }else{
                    db()->rollback();
                }
            }else{
                $data = array(
                    'id' => $param['id'.$i],
                    'isopen' => $param['isopen'.$i],
                    'remind_type' => $param['remind_type'.$i],
                    'advancehour' => $param['advancehour'.$i],
                    'shop_name' => session('shop_name'),
                    'shop_code' => session('shop_code'),
                    'setkey' => session('setkey'),
                );
               $res = db('SReminditemset')->insert($data);
                if($res){
                    db()->commit();
                }else{
                    db()->rollback();
                }
            }

        }
        return true;
    }
    function delRemind($id){
        $res = db('SReminditemset')->where('id',$id)->delete();
        return $res;
    }
    function remindAdd($param){
        $param['shop_name'] = session('shop_name');
        $param['shop_code'] = session('shop_code');
        $param['setkey'] = session('setkey');
        $db = db('SReminditemset');
        if($param['id']){
            $res = $db->where('id',$param['id'])->update($param);
        }else{
            $db->insert($param);
            $res = $db->getLastInsID();
        }
        $db->startTrans();
        if($res){
            //action_log($param,'',session(['staff_id']),0,session(['staff_name']));
            $db->commit();
            return true;
        }else{
            $db->rollback();
            return false;
        }
    }
    function getShopSN($code){
       $res = db('CShopset')->where('receiv_shop_code','in',$code)->field('sn')->select();
        return implode(',',array_column($res, 'sn'));
    }
    function updateStore($param){
        $db = db('CShopset');
        $res = $db->where('id',$param['id'])->update($param);
        if($res){
            //action_log($param,'',session(['staff_id']),0,session(['staff_name']));
            $db->commit();
            return $res;
        }else{
            $db->rollback();
            return false;
        }

    }
    function delStore($id){
        $db = db('CShopset');
        $res = $db->where('id',$id)->delete();
        if($res){
            //action_log($id,'',session(['staff_id']),0,session(['staff_name']));
            $db->commit();
            return true;
        }else{
            $db->rollback();
            return false;
        }
    }
    function editStore($id){
        $db = db('CShopset');
        $res = $db->where('id',$id)->find();
        if($res){
            //action_log($id,'',session(['staff_id']),0,session(['staff_name']));
            $db->commit();
            return ($res);
        }else{
            $db->rollback();
            return false;
        }
    }
 
    function getGoalJSON($position_name){
        $result['code'] = 0;
        $result['msg'] = '';
        if($position_name){
            $result['data'] = db('SKpiStaffgoal')->where('shop_code',session('shop_code'))->where('position_name','like','%'.$position_name.'%')->field('id,position_name,year,month,kpi_name,kpi_value,kpi_unit')->order('id desc')->select();
            $result['count'] = db('SKpiStaffgoal')->where('shop_code',session('shop_code'))->where('main_position_name','like','%'.$position_name.'%')->count();
        }else{
            $result['data'] = db('SKpiStaffgoal')->where('shop_code',session('shop_code'))->field('id,position_name,year,month,kpi_name,kpi_value,kpi_unit')->order('id desc')->select();
            $result['count'] = db('SKpiStaffgoal')->where('shop_code',session('shop_code'))->count();
        }
        return ($result);
    }
    function updateGoal($param){
        $res = db('SKpiStaffgoal')->where('shop_code',session('shop_code'))->where('month',$param['month'])->where('kpi_id',$param['kpi_id'])->where('position_id',$param['position_id'])->count();
        if($res){
            $arr = array(
                'code'=>150,
                'msg'=>'此岗位本月已存在此目标，不能设置',
                'data'=>array()
            );
            return $arr;
        }
        $count = db('SKpiStaffgoal')->where('shop_code',session('shop_code'))->where('month',$param['month'])->where('position_id',$param['position_id'])->count();

        if($count >= 5){
            $arr = array(
                'code'=>120,
                'msg'=>'此岗位本月的目标数量已到最大值，不能设置',
                'data'=>array()
            );
            return $arr;
        }

                $data = array(
                    'position_name'  =>  $param['position_name'],
                    'position_id'  =>  $param['position_id'],
                    'year' =>  $param['year'],
                    'month' =>  $param['month'],
                    'kpi_id' =>  $param['kpi_id'],
                    'kpi_name' =>  $param['kpi_name'],
                    'kpi_value' =>  $param['kpi_value'],
                    'kpi_unit' =>  $param['kpi_unit']
                );
        db()->startTrans();
        $db = db('SKpiStaffgoal');
        $res = $db->where('id',$param['id'])->update($data);


        if($res){
            //action_log($param,'',session(['staff_id']),0,session(['staff_name']));
            $arr = array(
                'code'=>200,
                'msg'=>'修改成功',
                'data'=>$data
            );
            db()->commit();
            return $arr;
        }else{
            $arr = array(
                'code'=>100,
                'msg'=>'修改失败',
                'data'=>array()
            );
            db()->rollback();
            return $arr;
        }
    }
    function delGoal($id){
        $res = db('SKpiStaffgoal')->where('id',$id)->delete();
        return $res;
    }
    function editGoal($id){
        $res = db('SKpiStaffgoal')->where('id',$id)->find();
        return $res;
    }

    //店面列表
    function get_shop($data){

        $url="5a005e0038270";
        $res=sx_call($url,$data);
        if($res['code']==200){
            $info=$res['data'];
        }
        return $info;
    }

    //岗位列表
    function get_position_list($data){
        $url = '5a0b96b65c111';
        $res = sx_call($url,$data);
        if($res['code'] == 200){
            return $res['data'];
        }else{
            return false;
        }
    }

    //品牌列表
    function brandclass_list(){
        $url="5a44c4782c1b6";
        $res=sx_call($url,'');
        if($res['code']==200){
            $info=$res['data'];

        }
        return $info;
    }

    //部门列表
    function department_list($data){
        $url = '5a0aef152b750';
        $res = sx_call($url,$data);
        if($res['code'] == 200){
            return $res['data'];
        }else{
            return false;
        }
    }

    /**
     * 方法描述：事业部列表
     * @return [type] [description]
     * @author  Zhaojiepeng <[<zhaojiepeng@suxuantech.cn>]> 2018:09:10 15:16
     */
    function get_brandlist(){
        $url = "5a38840b15ba9";
        $brandList = sx_call($url,array(),'sx_mc');
        if($brandList['code'] == 200){
            return $brandList['data'];
        }else{
            return false;
        }
    }
    /**
     * 方法描述：查询店信息
     * @return $brandid    事业部id
     * @author zhaojiepeng <[<Zhaojiepeng@suxuantech.cn>]> 2018:09:10 17:29
     */
    function get_shoplist($brandid){
        if(!$brandid){
            return false;
        }
        $url = "5a37a1503264d";
        $data['brandclass_id'] = $brandid;
        $brandList = sx_call($url,$data,'sx_mc');
        if($brandList['code'] == 200){
            return $brandList['data'];
        }else{
            return false;
        }
    }
    /**
     * 方法描述：查询部门信息
     * @param  [type] $shop_code [description]  店面code
     * @return [type]            [description]
     * @author  Zhaojiepeng <[<zhaojiepeng@suxuantech.cn>]>
     */
    function get_bumenlist($shop_code){
        if(!$shop_code){
            return false;
        }
        $url = '5a0aef152b750';
        $res = sx_call($url,array('shop_code'=>$shop_code));
        if($res['code'] == 200){
            return $res['data'];
        }else{
            return false;
        }
    }
    //岗位列表
/*    function get_position_list($department_id,$shop_code){
        if(!$department_id && !$shop_code){
            return false;
        }
        if($shop_code){
            $data['shop_code'] = $shop_code;
        }
        if($department_id){
            $data['department_id'] = $department_id;
        }
        $url = '5a0b96b65c111';
        $res = sx_call($url,$data);
        if($res['code'] == 200){
            return $res['data'];
        }else{
            return false;
        }
    }*/
    //部门列表
    function get_department_list(){
//      $res = db('SDepartmentinfo')->where('gradeType',4)->where('shop_code',session('shop_code'))->field('id,department_name')->select();
        $url = '5a0b96b65c111';
        $res = sx_call($url,array('shop_code'=>session('shop_code')));
        if($res['code'] == 200){
            return $res['data'];
        }else{
            return false;
        }
    }
    function getStaffList(){
        $url = '59ff2d5de2cb6';
        return sx_call($url,'');
    }
    function getGroupList(){
        $res = db('CStaffGroup')->where('shop_code',session('shop_code'))->select();
        return $res;
    }
    function getdepartment(){
        $url = '5a0aef152b750';
        return sx_call($url,array('shop_code'=>session('shop_code')));
    }
    function getposition(){
        $url = '5a0b96b65c111';
        return sx_call($url,array('shop_code'=>session('shop_code')));
    }
    function delFPSet($id){
        $db = db('SAllocationRule');
        $res = $db->where('id',$id)->delete();
        if($res){
            //action_log($id,'',session(['staff_id']),0,session(['staff_name']));
            //清除cache
            cache('fpRule_'.session('shop_code'),null);
            $db->commit();
            return true;
        }else{
            $db->rollback();
            return false;
        }
    }
    function getDefaultRule(){
        $res = db('SAllocationRule')->where('shop_code',session('shop_code'))->where('order_sort',9999)->find();
        $tar = new \app\crm\lib\Target();
        $res['name'] = $tar->get_target_name_by_id($res['allocationtype_value']);
        return $res;
    }
    function addDefaultFPSet($param){
        if($param['allocationtype'] == 0){
            $param['active_time'] = null;
            $param['allocationtype_value'] = null;
        }
        $data = array();
        if($param['dpg'] == 'position_name'){
            $data = array(
            'allocationtype' => $param['allocationtype'],
            'allocationtype_value' => $param['allocationtype_value'],
            'position_id' => $param['d_dpg'],
            'position_name' => $param['name'],
            'active_time' => $param['active_time'],
            'shop_name' => session('shop_name'),
            'shop_code' => session('shop_code'),
            'setkey' => session('setkey'),
            'order_sort' => $param['order_sort'],
        );
        }elseif($param['dpg'] == 'department_name'){
            $data = array(
                'allocationtype' => $param['allocationtype'],
                'allocationtype_value' => $param['allocationtype_value'],
                'department_id' => $param['d_dpg'],
                'department_name' => $param['name'],
                'active_time' => $param['active_time'],
                'shop_name' => session('shop_name'),
                'shop_code' => session('shop_code'),
                'setkey' => session('setkey'),
                'order_sort' => $param['order_sort'],
            );
        }elseif($param['dpg'] == 'group_name'){
            $data = array(
                'allocationtype' => $param['allocationtype'],
                'allocationtype_value' => $param['allocationtype_value'],
                'group_id' => $param['d_dpg'],
                'group_name' => $param['name'],
                'active_time' => $param['active_time'],
                'shop_name' => session('shop_name'),
                'shop_code' => session('shop_code'),
                'setkey' => session('setkey'),
                'order_sort' => $param['order_sort'],
            );
        }

        if($param['id']){
            $data1 = array(
                'department_name' => '',
                'position_name' => '',
                'position_id' => '',
                'department_id' => '',
                'group_id' => '',
                'group_name' => '',
                'active_time' =>'',
                'allocationtype_value' =>'',
                'customer_condition' =>'',
                'customer_value' =>''
            );
            db('SAllocationRule')->where('id',$param['id'])->update($data1);
            db('SAllocationRule')->where('id',$param['id'])->update($data);

        }else{
            db('SAllocationRule')->insert($data);
            $res = db_config('fp_timeout_'.session('shop_code'),60);
            if($res){
                cache('fp_timeout_'.session('shop_code'),60);
            }
        }
        return true;
    }
    //上移
    function upOrderSort($param){
        $order_sort = db('SAllocationRule')->where('order_sort','>',$param['order_sort'])->limit(1)->order('order_sort asc')->select();
        $res = db('SAllocationRule')->where('id',$param['id'])->update(array('order_sort'=>$order_sort[0]['order_sort']+1));
        return $res;
    }
    //下移
    function downOrderSort($param){
        $order_sort = db('SAllocationRule')->where('order_sort','<',$param['order_sort'])->limit(1)->order('order_sort desc')->select();
        $res = db('SAllocationRule')->where('id',$param['id'])->update(array('order_sort'=>$order_sort[0]['order_sort']-1));
        return $res;
    }
    function addFPSet($param){
        if($param['allocationtype'] == 0){
            $param['allocationtype_value'] = '';
            $param['active_time'] = '';
        }
        $data = array(
            'isopen' => $param['isopen'],
            'allocationtype' => $param['allocationtype'],
            'allocationtype_value' => $param['allocationtype_value'],
            'customer_condition' => $param['customer_condition'],
            'customer_value' => $param['customer_value'],
            'order_sort' => $param['order_sort'],
            'group_id' => $param['group_id'],
            'group_name' => $param['group_name'],
            'position_id' => $param['position_id'],
            'position_name' => $param['position_name'],
            'department_id' => $param['department_id'],
            'department_name' => $param['department_name'],
            'active_time' => $param['active_time'],
            'shop_name' => session('shop_name'),
            'shop_code' => session('shop_code'),
            'setkey' => session('setkey')
        );
        db()->startTrans();
        if($param['id']){//修改
            $res = db('SAllocationRule')->where('id','=',$param['id'])->update($data);
        }else{//添加
            db('SAllocationRule')->insert($data);
            $res = db('SAllocationRule')->getLastInsID();
        }
        if($res){
            db()->commit();
            //清除cache
            cache('fpRule_'.session('shop_code'),null);
            //action_log($param,'',session(['staff_id']),0,session(['staff_name']));
            return true;
        }else{
            db()->rollback();
            return false;
        }
    }
    //渠道类型
    function getChannelclass(){
        $url = '5a2757c0a9810';
        $res = sx_call($url,array());
        return $res['data'];
    }
    //渠道名
    function getChannelInfo($channelclass){
        $url = '59fd5e729e5a8';
        $res = sx_call($url,array('channelclass'=>$channelclass));
        return $res['data'];
    }
    //渠道名
    function getQudao(){
        $url = '59fd5e729e5a8';
        $res = sx_call($url,array('shop_code'=>session('shop_code')));
        return $res['data'];
    }
    //来源
    function getcustomer_cource(){
        $url = '59fd5ec462c88';
        $res = sx_call($url,array('shop_code'=>session('shop_code')));
        return $res['data'];
    }
    //根据id获取相应的渠道名
    function getChannelByName($channelclass){
        $url = '59fd5e729e5a8';
        $res = sx_call($url,array('channelclass'=>$channelclass['channelclass'],'shop_code'=>session('shop_code')));
        return $res['data'];
    }
    //分区
    function getcustomer_area(){
        $url = '5a004e9c3e030';
        $res = sx_call($url,array('shop_code'=>session('shop_code')));
        return $res['data'];
    }
    //地域
    function getcustomer_region(){
        $url = '59fd5fa926b98';
        $res = sx_call($url,array('shop_code'=>session('shop_code')));
        return $res['data'];
    }
    //渠道名称
    function getQudaoInfo($channelclass){
        $res = db('SChannelinfo')->where('shop_code','=',session('shop_code'))->where('channelclass',$channelclass)->field('id,channelclass,channel_name')->select();
        return $res;
    }

    //人员
    function getRenyuan(){
        $url = '5a02666c9935d';
        $res = sx_call($url,array('shop_code'=>session('shop_code')));
        return $res['data'];
    }
    function FPListJSON($shop_code){
        $shopCode = $shop_code ? $shop_code : session('shop_code');
        $result['code'] = 0;
        $result['msg'] = '';
        $res = db('SAllocationRule')->where('shop_code',$shopCode)->field('id,department_name,position_name,allocationtype,allocationtype_value,active_time,customer_condition,customer_value,group_name,order_sort,isopen')->where('order_sort','<>',9999)->order('order_sort desc')->select();

        $count = db('SAllocationRule')->where('shop_code',$shopCode)->count();
        if($res){
            $tt = new Target();
            foreach($res as $k=>$v){
                $res[$k]['allocationtype_value'] = $tt->get_target_name_by_id($v['allocationtype_value']);
                if($v['active_time'] == 'this_week'){
                    $res[$k]['active_time'] = '本周';
                }elseif($v['active_time'] == 'last_week'){
                    $res[$k]['active_time'] = '上周';
                }elseif($v['active_time'] == 'this_month'){
                    $res[$k]['active_time'] = '本月';
                }elseif($v['active_time'] == 'last_month'){
                    $res[$k]['active_time'] = '上月';
                }elseif($v['active_time'] == 'near_week'){
                    $res[$k]['active_time'] = '最近一周';
                }elseif($v['active_time'] == 'near_month'){
                    $res[$k]['active_time'] = '最近一月';
                }
                if($v['customer_condition'] == 'customer_channel'){
                    $res[$k]['customer_condition'] = '渠道';
                }elseif($v['customer_condition'] == 'customer_cource'){
                    $res[$k]['customer_condition'] = '来源';
                }elseif($v['customer_condition'] == 'customer_area'){
                    $res[$k]['customer_condition'] = '分区';
                }elseif($v['customer_condition'] == 'customer_region'){
                    $res[$k]['customer_condition'] = '地域';
                }
            }
            $result['data'] = $res;
            $result['count'] = $count;
        }else{
            $result['data'] = array();
        }
        return ($result);
    }
    //追踪失败原因
    function fileReason($reason)
    {
        $res = db('SFileReason')->where('reason','like','%'.$reason.'%')->select();
        if($res){
            return ($res);
        }else{
            return false;
        }
    }
    function setReason($param){
        $data['shop_name'] = session('shop_name');
        $data['shop_code'] = session('shop_code');
        $data['setkey'] = session('setkey');
        $data['reason'] = $param['reason'];
        db()->startTrans();
        db('SFileReason')->insert($data);
        if(db('SFileReason')->getLastInsID()){
            db()->commit();
            //action_log($param,'',session(['staff_id']),0,session(['staff_name']));
            return db('SFileReason')->getLastInsID();
        }else{
            db()->rollback();
            return false;
        }

    }
    //微信模板
    function getWXModalToJSON($wx_template_name)
    {
        $result['code'] = 0;
        $result['msg'] = '';
        $res = db('SWxTemplateModel')->where('shop_code',session('shop_code'))->where('wx_template_name','like','%'.$wx_template_name.'%')->field('id,wx_template_name,wx_template_title,wx_template_content,status')->select();
        $count = db('SWxTemplateModel')->where('shop_code',session('shop_code'))->where('wx_template_name','like','%'.$wx_template_name.'%')->count();
        if($res){
            $result['data'] = $res;
            $result['count'] = $count;
        }else{
            $result['data'] = array();
        }
        return ($result);
    }
    //短信模板
    function getModalToJSON($mtemplate_name)
    {
        $result['code'] = 0;
        $result['msg'] = '';
        $res = db('SMessageTemplateinfo')->where('shop_code',session('shop_code'))->where('mtemplate_name','like','%'.$mtemplate_name.'%')->field('id,mtemplate_name,mtemplate_content,status')->select();
        $count = db('SMessageTemplateinfo')->where('shop_code',session('shop_code'))->where('mtemplate_name','like','%'.$mtemplate_name.'%')->count();
        if($res){
            $result['data'] = $res;
            $result['count'] = $count;
        }else{
            $result['data'] = array();
        }
        return ($result);
    }
    //短信模板增加
    function addModal($param){
        $param['shop_name'] = session('shop_name');
        $param['shop_code'] = session('shop_code');
        $param['setkey'] = session('setkey');
        db()->startTrans();
        db('SMessageTemplateinfo')->insert($param);
        $id = db('SMessageTemplateinfo')->getLastInsID();
        if($id){
            db()->commit();
            //action_log($param,'',session(['staff_id']),0,session(['staff_name']));
            return true;
        }else{
            db()->rollback();
            return false;
        }
    }
    function findMModal($id){
        $res = db('SMessageTemplateinfo')->where('id',$id)->find();
        if($res){
            return $res;
        }else{
            return false;
        }
    }
    //微信模板增加
    function addWXModal($param){
        $param['shop_name'] = session('shop_name');
        $param['shop_code'] = session('shop_code');
        $param['setkey'] = session('setkey');
        db()->startTrans();
        db('SWxTemplateModel')->insert($param);
        $id = db('SWxTemplateModel')->getLastInsID();
        if($id){
            db()->commit();
            //action_log($param,'',session(['staff_id']),0,session(['staff_name']));
            return true;
        }else{
            db()->rollback();
            return false;
        }
    }
    function editMModal($param){
        db()->startTrans();
        $res = db('SMessageTemplateinfo')->where('id',$param['id'])->update($param);
        if($res){
            db()->commit();
            //action_log($param,'',session(['staff_id']),0,session(['staff_name']));
            return $res;
        }else{
            db()->rollback();
            return false;
        }
    }
    function editWXModal($param){
        db()->startTrans();
        $res = db('SWxTemplateModel')->where('id',$param['id'])->update($param);
        if($res){
            db()->commit();
            //action_log($param,'',session(['staff_id']),0,session(['staff_name']));
            return $res;
        }else{
            db()->rollback();
            return false;
        }
    }
    function delMModal($id){
        db()->startTrans();
        $res = db('SMessageTemplateinfo')->where('id',$id)->delete();
        if($res){
            db()->commit();
            //action_log($id,'',session(['staff_id']),0,session(['staff_name']));
            return true;
        }else{
            db()->rollback();
            return false;
        }
    }
    function delWXModal($id){
        db()->startTrans();
        $res = db('SWxTemplateModel')->where('id',$id)->delete();
        if($res){
            db()->commit();
            //action_log($id,'',session(['staff_id']),0,session(['staff_name']));
            return true;
        }else{
            db()->rollback();
            return false;
        }
    }
    //追踪失败原因
    function getReasonToJSON($reason)
    {
        $result['code'] = 0;
        $result['msg'] = '';
        $res = db('SFileReason')->where('shop_code',session('shop_code'))->where('reason','like','%'.$reason.'%')->select();
        $count = db('SFileReason')->where('shop_code',session('shop_code'))->where('reason','like','%'.$reason.'%')->count();
        if($res){
            $result['data'] = $res;
            $result['count'] = $count;
        }else{
            $result['data'] = array();
        }
        return ($result);
    }
    function editWalkFlow($param){
        db()->startTrans();
        $res = db('SSalesRoutines')->where('id',$param['id'])->update($param);
        if($res){
            db()->commit();
            return $res;
        }else{
            db()->rollback();
            return false;
        }
    }
    function delWalkFlow($id){
        db()->startTrans();
        $res = db('SSalesRoutines')->where('id',$id)->delete();
        if($res){
            db()->commit();
            return $res;
        }else{
            db()->rollback();
            return false;
        }
    }
    //业务流程
    function getworkflowToJSON($step_content)
    {
        $result['code'] = 0;
        $result['msg'] = '';
        $res = db('SSalesRoutines')->where('shop_code',session('shop_code'))->column('id,step_name,step_content,step_stage');
        $count = db('SSalesRoutines')->where('shop_code',session('shop_code'))->count();
        if($res){
            $result['data'] = $res;
            $result['count'] = $count;
        }else{
            $result['data'] = array();
        }
        return ($result);
    }
    function addWorkFlow($param){
        $param['shop_name'] = session('shop_name');
        $param['shop_code'] = session('shop_code');
        $param['setkey'] = session('setkey');
        db()->startTrans();
        db('SSalesRoutines')->insert($param);
        if(db('SSalesRoutines')->getLastInsID()){
            db()->commit();
            //action_log($param,'',session(['staff_id']),0,session(['staff_name']));
            return db('SSalesRoutines')->getLastInsID();
        }else{
            db()->rollback();
            return false;
        }

    }
    //渠道类型列表
    function getchannelclassToJSON($reason)
    {
        $result['code'] = 0;
        $result['msg'] = '';
        $res = db('SChannelCost')->where('shop_code',session('shop_code'))->where('channel_name','like','%'.$reason.'%')->select();
        $count = db('SChannelCost')->where('shop_code',session('shop_code'))->where('channel_name','like','%'.$reason.'%')->count();
        if($res){
            $result['data'] = $res;
            $result['count'] = $count;
        }else{
            $result['data'] = array();
        }
        return ($result);
    }
    function getQD(){
        $url = '59fd5e729e5a8';
        $res = sx_call($url,array('shop_code'=>session('shop_code')));
        if($res['code'] == 200){
            return $res;
        }else{
            return false;
        }
    }
    function addQDType($channelclass){
        if($channelclass['channel_id'] == 0){
            $channelclass['channel_id'] = null;
            $channelclass['channel_name'] = null;
        }
        $channelclass['shop_name'] = session('shop_name');
        $channelclass['shop_code'] = session('shop_code');
        $channelclass['setkey'] = session('setkey');
        $channelclass['create_time'] = date('Y-m-d H:i:s',time());


        $days = cal_days_in_month(CAL_GREGORIAN, $channelclass['month'], $channelclass['year']);//当月天数
        $channelclass['cost_avg'] = round($channelclass['cost']/$days,2);//平均每天花费
        db()->startTrans();
        db('SChannelCost')->insert($channelclass);
        $id = db('SChannelCost')->getLastInsID();
        if($id){
            db()->commit();
            //action_log($channelclass,'',session(['staff_id']),0,session(['staff_name']));
            return $id;
        }else{
            db()->rollback();
            return false;
        }
    }

    function delQDType($id){
        db()->startTrans();
        $res = db('SChannelCost')->where('id',$id)->delete();
        if($res){
            db()->commit();
            //action_log($id,'',session(['staff_id']),0,session(['staff_name']));
            return true;
        }else{
            db()->rollback();
            return false;
        }
    }
    function editQDType($param){
        if($param['channel_id'] == 0){
            $param['channel_id'] = null;
            $param['channel_name'] = null;
        }
        $param['update_time'] = date('Y-m-d H:i:s',time());
        $days = cal_days_in_month(CAL_GREGORIAN, $param['month'], $param['year']);//当月天数
        $param['cost_avg'] = round($param['cost']/$days,2);//平均每天花费
        db()->startTrans();
        $res = db('SChannelCost')->where('id',$param['id'])->update($param);

        if($res){
            db()->commit();
            //action_log($param,'',session(['staff_id']),0,session(['staff_name']));
            return $res;
        }else{
            db()->rollback();
            return false;
        }
    }
    function delFileReason($id){
        db()->startTrans();
        $res = db('SFileReason')->where('id',$id)->delete();
        if($res){
            db()->commit();
            //action_log($id,'',session(['staff_id']),0,session(['staff_name']));
            return true;
        }else{
            db()->rollback();
            return false;
        }
    }
    function editReason($param){
        db()->startTrans();
        $res = db('SFileReason')->where('id',$param['id'])->update($param);
        if($res){
            db()->commit();
            //action_log($param,'',session(['staff_id']),0,session(['staff_name']));
            return $res;
        }else{
            db()->rollback();
            return false;
        }
    }
    function getPostitionList(){
        $res = db('SPositionset')->where('gradeType',4)->select();
        if($res){
            return $res;
        }else{
            return false;
        }
    }
    function getTuCount(){
        $res = db('SStaffAbility')->where('shop_code',session('shop_code'))->field('id')->select();
        return $res;
    }
    function get_staff_photo($staff_id){
        $file = "/public/upload/pic/".$staff_id.'.jpg';
        if(is_file($file)){
            return $file;
        }else{
            return '/public/img/user_tt_b.jpg';
        }
    }
    //分配开关
    function auto_fp($value){//开关状态：1：开；2：关;默认1：自动分配(空值)
        $val = db_config('fp_switch_'.session('shop_code'));
            if ($val == 1) {
                $value = 2;
            } else {
                //查询有无默认规则
                $id = db('SAllocationRule')->where('order_sort',9999)->where('shop_code',session('shop_code'))->field('id')->find();
                if($id){
                    $value = 1;
                }else{
                    $arr = array('error'=>1,'msg'=>'没有默认规则，不能开启自动');
                    return json($arr);
                }
            }
        $res = db_config('fp_switch_'.session('shop_code'),$value);
        if($res){
            $arr = array('error'=>0,'msg'=>'操作成功');
        }else{
            $arr = array('error'=>0,'msg'=>'操作成功');
        }
        return json($arr);
    }
    //分配过期时间
    function auto_fp_timeout($time){
        $res = db_config('fp_timeout_'.session('shop_code'),$time);
        if($res){
            cache('fp_timeout_'.session('shop_code'),$time);
        }
        return json_encode($res);
    }
    //无小组人员
    function getNoGroupStaff($dep){
        $res = db('CStaffGroupRelation')->field('staff_id')->select();//有小组人员.
        $ar = array();
        foreach($res as $ke=>$va){
            array_push($ar,$va['staff_id']);
        }
        $url = '5a0e6f272bb38';
        $info = sx_call($url,$dep);//所有人员
        if($info['code'] == 200){
            $a = array();
            foreach($info['data'] as $k=>$v){
                array_push($a,$v['id']);
            }
            $arr = array_diff($a,$ar);//差集
            $ids = implode(',',$arr);
            $noGroup = sx_call('5a18e3fa516a1',array('staff_id'=>$ids));//所有无组人员
            if($noGroup['code'] == 200){
                return $noGroup;
            }else{
                return false;
            }
        }else{
            return false;
        }
    }
    //查看是否是小组管理员
    function isGroupAdmin(){
        return db('CStaffGroupRelation')->where('staff_id',session('staff_id'))->field('is_admin')->find();
    }
    //查看有无小组
    function isGroupStaff(){
        return db('CStaffGroupRelation')->where('staff_id',session('staff_id'))->field('group_id')->find();
    }
    function getGroupInfo(){
        return db('CStaffGroup')->where('create_staff_id',session('staff_id'))->find();
    }
    //小组内所有人员
    function getInGroupStaffInfo(){
        $group = db('CStaffGroupRelation')->where('staff_id',session('staff_id'))->find();
        $info = db('CStaffGroupRelation')->where('group_id',$group['group_id'])->field('staff_id')->select();
        $ar = array();
        foreach($info as $ke=>$va){
            array_push($ar,$va['staff_id']);
        }
        $ids = implode(',',$ar);
        //请求接口，通过id获取名字
        $url = "5a18e3fa516a1";
        $res = sx_call($url,array('staff_id'=>$ids));
        return $res;
    }
    //添加或编辑小组
    function addGroup($param){
        if($param['id']){//编辑
            db()->startTrans();
            $member = $param['member'];
            unset($param['member']);
            if($member){
                $arr = explode(',',$member);
                foreach($arr as $k=>$v){
                    $g = db('CStaffGroupRelation')->where('staff_id','<>',$v)->field('staff_id')->find();
                    if(empty($g['staff_id'])){
                        $data = array(
                            'group_id'=>$param['id'],
                            'staff_id'=>$v
                        );
                        db('CStaffGroupRelation')->insert($data);
                    }
                }
            }
            $res = db('CStaffGroup')->where('id',$param['id'])->update($param);
            if($res){
                db()->commit();
                $js = array('code'=>200,'msg'=>'编辑小组表成功');
                return json($js);
            }else{
                db()->rollback();
                $js = array('code'=>300,'msg'=>'编辑小组失败，已回滚');
                return json($js);
            }
        }else{//添加
            if(empty($param['department_name']) || $param['department_name'] == ''){
                $js = array('code'=>600,'msg'=>'部门不能为空');
                return json($js);
            }
            $member = $param['member'];
            unset($param['member']);
            $param['create_staff_id'] = session('staff_id');
            $param['create_staff_name'] = session('staff_name');
            $param['shop_name'] = session('shop_name');
            $param['shop_code'] = session('shop_code');
            $param['setkey'] = session('setkey');
            $param['create_time'] = date('Y-m-d H:i:s',time());
            db()->startTrans();
            db('CStaffGroup')->insert($param);
            $id = db()->getLastInsID();
            if($id){
                db('CStaffGroupRelation')->insert(array('group_id'=>$id,'staff_id'=>session('staff_id'),'is_admin'=>1));
                if(!$member){
                    $js = array('code'=>200,'msg'=>'修改小组成功');
                    db()->commit();
                    return json($js);
                }else{
                    $arr = explode(',',$member);
                    foreach($arr as $k=>$v){
                        db('CStaffGroupRelation')->insert(array('group_id'=>$id,'staff_id'=>$v));
                    }
                    db()->commit();
                    $js = array('code'=>200,'msg'=>'插入小组表成功,员工关系表插入成功');
                    return json($js);
                }
            }else{
                db()->rollback();
                $js = array('code'=>700,'msg'=>'编辑小组失败,已回滚');
                return json($js);
            }
        }
    }
    //删除并清空小组
    function delGroup(){
        $info = db('CStaffGroup')->where('create_staff_id',session('staff_id'))->find();
        if($info['id']){
            db()->startTrans();
            $del = db('CStaffGroupRelation')->where('group_id',$info['id'])->delete();
            if($del){
                db('CStaffGroup')->where('id',$info['id'])->delete();
                db()->commit();
                return true;
            }else{
                db()->rollback();
                return false;
            }
        }else{
            return false;
        }
    }
    function delFromGroup($staff_id){
        $res = db('CStaffGroup')->where('create_staff_id',session('staff_id'))->field('id,create_staff_id')->find();
        if($res['create_staff_id'] == $staff_id){
            return json(array('msg'=>'您是创建人，不能删除'));
        }
        if($res['id']){
            db()->startTrans();
            $del = db('CStaffGroupRelation')->where('staff_id',$staff_id)->delete();
            if($del){
                db()->commit();
                return json(array('msg'=>'删除成功'));
            }else{
                db()->rollback();
                return json(array('msg'=>'删除失败'));
            }
        }else{
            return json(array('msg'=>'小组不存在'));
        }
    }
    function addToGroup($staff_id){
        $res = db('CStaffGroup')->where('create_staff_id',session('staff_id'))->field('id,create_staff_id')->find();
        if(empty($res['id'])){
            return json(array('msg'=>'您还没创建小组，不能添加人员'));
        }
        if($res['create_staff_id'] == session('staff_id')){
            $data = array(
                'staff_id'=>$staff_id,
                'group_id'=>$res['id']
                );
            db()->startTrans();
            $id = db('CStaffGroupRelation')->insert($data);
            if($id){
                db()->commit();
                return json(array('msg'=>'添加人员成功'));
            }else{
                db()->rollback();
                return json(array('msg'=>'添加人员失败'));
            }
        }else{
            return json(array('msg'=>'您无权限添加人员'));
        }

    }
    function getTu(){
        $res = db('SStaffAbility')->where('shop_code',session('shop_code'))->field('id,position_name,abilityItem,max,times')->select();
        if($res){
            $t = new Target();
                foreach ($res as $k => $v) {
                    $arr = explode(',', $v['abilityItem']);
                    $max = explode(',', $v['max']);
                    $res[$k]['abilityItem'] = $arr;
                    $arr1 = array();
                    $arr2 = array();
                    foreach ($arr as $ke => $va) {
                        $a = $t->get_target_name_by_id($va);
                        $arr1[] = "{name: '" . $a . "', max: ".$max[$ke]."}";
                        $va = 6000;
                        if($va > $max[$ke]){
                            $va = $max[$ke];
                        }
                        $arr2[] = $va;
                    }
                    if($v['times'] == 'week'){
                        $a = '本周';
                    }elseif($v['times'] == 'last_week'){
                        $a = '上周';
                    }elseif($v['times'] == 'month'){
                        $a = '本月';
                    }elseif($v['times'] == 'last_month'){
                        $a = '上月';
                    }elseif($v['times'] == 'near_month'){
                        $a = '最近一月';
                    }elseif($v['times'] == 'near_week'){
                        $a = '最近一周';
                    }
                    $res[$k] = array('a'=> "[".implode(',',$arr1)."]",'b'=>"[".implode(',',$arr2)."]",'c'=>$v['position_name'].'['.$a.']');
                }
                return $res;
        }else{
            return  array('a'=> "[{ name: '成交量', max: 50},{ name: '进客量', max: 60},{ name: '有效量', max: 60},{ name: '电访量', max: 80},{ name: '客资量', max: 50},]",'b'=>"[30,30,30,30,30]",'c'=>'默认五维图');
        }
    }
    function abilitySet($param){
        if(count($param['ability'])<3){
            return $this->error('最少要选择3个能力','/crm/setting/biao');
        }
        $data['shop_name'] = session('shop_name');
        $data['shop_code'] = session('shop_code');
        $data['setkey'] = session('setkey');
        $data['position_name'] = $param['position_name'];
        $data['times'] = $param['times'];
        $data['abilityItem'] = implode(',',$param['ability']);

        $max = array();
        for($i=1;$i<=15;$i++){
            if($param['max'.$i] != ''){
                array_push($max,$param['max'.$i]);
            }
        }
        if(count($max) < 3 && count($max) != count($param['ability'])){
            return $this->error('选择的能力和最大值不对应！','/crm/setting/biao');
        }
        $data['max'] = implode(',',$max);
        //查询此岗位本时间段是否有设定
        $count = db('SStaffAbility')->where('position_name','=',$param['position_name'])->where('times',$param['times'])->count();
        db()->startTrans();
        if($count){
            $res = db('SStaffAbility')->where('position_name','=',$param['position_name'])->update($data);
        }else{
            db('SStaffAbility')->insert($data);
            $res = db('SStaffAbility')->getLastInsID();
        }
        if($res){
            db()->commit();
            //action_log($param,'',session(['staff_id']),0,session(['staff_name']));
        }else{
            db()->rollback();
        }
    }
    function getAbilityList(){
        $res = db('SStaffAbility')->select();
        $res['abilityItem'] = explode(',',$res);
        return $res;
    }
    public function getTuToJSON(){
        $result['code'] = 0;
        $result['msg'] = '';
        $res = db('s_staff_ability')->where('shop_code',session('shop_code'))->select();
        $count = db('s_staff_ability')->where('shop_code',session('shop_code'))->count();
        if($res){
            $t = new Target();
            foreach ($res as $k => $v) {
                $arr = explode(',', $v['abilityItem']);
                $a = array();
                foreach($arr as $ke=>$ve){
                    $a[$ke] = $t->get_target_name_by_id($ve);
                }
                $res[$k]['abilityItem'] = implode(',',$a);
                if($v['times'] == 'week'){
                    $res[$k]['times'] = '本周';
                }elseif($v['times'] == 'last_week'){
                    $res[$k]['times'] = '上周';
                }elseif($v['times'] == 'month'){
                    $res[$k]['times'] = '本月';
                }elseif($v['times'] == 'last_month'){
                    $res[$k]['times'] = '上月';
                }elseif($v['times'] == 'near_month'){
                    $res[$k]['times'] = '最近一月';
                }elseif($v['times'] == 'near_week'){
                    $res[$k]['times'] = '最近一周';
                }
            }

            $result['data'] = $res;
            $result['count'] = $count;
        }else{
            $result['data'] = array();
        }
        return ($result);
    }

    //删除五维图
    function delTu($id){
        db()->startTrans();
        $res = db('s_staff_ability')->where('id',$id)->delete();
        if($res){
            db()->commit();
            return true;
        }else{
            db()->rollback();
            return false;
        }
    }
    //电访设定
    function addtelphoneRemark($param){
        $param['shop_name'] = session('shop_name');
        $param['shop_code'] = session('shop_code');
        $param['setkey'] = session('setkey');
        db()->startTrans();
        db('STelremark')->insert($param);
        $id = db('STelremark')->getLastInsID();
        if($id){
            db()->commit();
            //action_log($param,'',session(['staff_id']),0,session(['staff_name']));
            return true;
        }else{
            db()->rollback();
            return false;
        }
    }
    function  getRemarkList(){
        $res = db('STelremark')->select();
        if($res){
            return $res;
        }else{
            return false;
        }
    }
    function  gettrackingKmarkerList(){
        $res = db('STracksign')->select();
        if($res){
            return $res;
        }else{
            return false;
        }
    }


    //追踪标记设定
    function addtrackingKmarker($param){
        $param['shop_name'] = session('shop_name');
        $param['shop_code'] = session('shop_code');
        $param['setkey'] = session('setkey');
        db()->startTrans();
        db('STracksign')->insert($param);
        $id = db('STracksign')->getLastInsID();
        if($id){
            db()->commit();
            //action_log($param,'',session(['staff_id']),0,session(['staff_name']));
            return true;
        }else{
            db()->rollback();
            return false;
        }
    }
    //电访备注
    function getTelphoneRemarkToJSON($telremark)
    {
        $result['code'] = 0;
        $result['msg'] = '';
        $res = db('STelremark')->where('shop_code',session('shop_code'))->where('telremark','like','%'.$telremark.'%')->select();
        $count = db('STelremark')->where('shop_code',session('shop_code'))->where('telremark','like','%'.$telremark.'%')->count();
        if($res){
            $result['data'] = $res;
            $result['count'] = $count;
        }else{
            $result['data'] = array();
        }
        return ($result);
    }
    //追踪标记
    function getTrackingKmarkerToJSON($tracksign)
    {
        $result['code'] = 0;
        $result['msg'] = '';
        $res = db('STracksign')->where('shop_code',session('shop_code'))->where('tracksign','like','%'.$tracksign.'%')->select();
        $count = db('STracksign')->where('shop_code',session('shop_code'))->where('tracksign','like','%'.$tracksign.'%')->count();
        if($res){
            $result['data'] = $res;
            $result['count'] = $count;
        }else{
            $result['data'] = array();
        }
        return ($result);
    }
    function deltelphoneRemark($id){
        db()->startTrans();
        $res = db('STelremark')->where('id',$id)->delete();
        if($res){
            db()->commit();
            //action_log($id,'',session(['staff_id']),0,session(['staff_name']));
            return true;
        }else{
            db()->rollback();
            return false;
        }
    }
    function edittelphoneRemark($param){
        db()->startTrans();
        $res = db('STelremark')->where(array('id'=>$param['id']))->update($param);
        if($res){
            db()->commit();
            //action_log($param,'',session(['staff_id']),0,session(['staff_name']));
            return $res;
        }else{
            db()->rollback();
            return false;
        }
    }
    function deledittrackingKmarker($id){
        db()->startTrans();
        $res = db('STracksign')->where('id',$id)->delete();
        if($res){
            db()->commit();
            //action_log($id,'',session(['staff_id']),0,session(['staff_name']));
            return true;
        }else{
            db()->rollback();
            return false;
        }
    }
    function edittrackingKmarker($param){
        db()->startTrans();
        $res = db('STracksign')->where(array('id'=>$param['id']))->update($param);
        if($res){
            db()->commit();
            //action_log($param,'',session(['staff_id']),0,session(['staff_name']));
            return $res;
        }else{
            db()->rollback();
            return false;
        }
    }

    // 根据shopCode获取规则集合
    function getRule($shopCode){
        $result['code'] = 0;
        $result['msg'] = '';
        $where = array(
            'shop_code' => $shopCode,
            'isopen'    => 1
        );
        $res = db('s_allocationRule')->where($where)->select();

        // 按照 order_sort 排序
        $res = my_sort($res,'order_sort');
        return $res;
        // //取到客资信息
        // //确定要更新的数据沉淀
        // //取到客资的。luruid  shaikeid   jieshouid

        // $dataup[$lurid] = 'lurushijian';
        // $dataup[$shaikeid] = 'shaikeshijian';

        // $dataup[$jieshouid] = 'jieshoushijian';
        // foreach ($dataup as $key => $value) {
        //     # code...
        //     //判断value是当天还是非当天。。。日表、时表
        //     //更新数据。条件是，员工ID=$key，时间=$value

        // }

    }

    //菜单数据列表
    function getMenuList(){
        $data = db('SMenu')->order('sort asc')->select();
        $res=formatTree(listToTree($data));
        if($res){
            return $res;
        }else{
            return false;
        }
    }

    //查询菜单数据
    function getMenuJSON($param){
        //$page = $param['page'] ? $param['page'] : 1;
        //$limit = $param['limit'] ? $param['limit'] : 1;
        $result['code'] = 0;
        $result['msg'] = '';
        $res = db('SMenu')->where('menu_name','like','%'.$param['menu_name'].'%')
            //->limit($limit)
            //->page($page)
            ->order('sort asc')->select();
        $count = db('SMenu')->where('menu_name','like','%'.$param['menu_name'].'%')->count();
        if($res){
           
            $result['data'] = formatTree(listToTree($res));
            $result['count'] = $count;
        }else{
            $result['data'] = array();
        }
        return ($result);
    }

    //功能菜单增加
    function addMenu($param){

        if($param['id']){
            $res = db('SMenu')->where('id',$param['id'])->update($param);
            if($res===false){
                $this->error('失败', '/');
            }else{
                action_log($param);     //写日志
                //action_log($param,'',session(['staff_id']),0,session(['staff_name']));
                cache('VIP_child_menu_*',null);
                cache('VIP_child_menuAll',null);
                $this->success('成功', '/');
            }
        }else{
            $param['menu_code']='menu'.time();
            $res=db('SMenu')->insert($param);

            $id = db('SMenu')->getLastInsID();
            if(!$id){
                $this->error('失败', '/');
            }else{
                action_log($param);          //写日志
                //action_log($param,'',session(['staff_id']),0,session(['staff_name']));
                cache('VIP_child_menu_*',null);
                cache('VIP_child_menuAll',null);
                $this->success('成功', '/');
            }
        }

    }

    //功能菜单编辑
    function editMenu($param){
        $res = db('SMenu')->where('id',$param['id'])->update($param);
        if($res===false){
            $this->error('功能编辑失败', '/');
        }else{
            action_log($param);         //写日志
            //action_log($param,'',session(['staff_id']),0,session(['staff_name']));
            cache('VIP_child_menu_*',null);
            cache('VIP_child_menuAll',null);
            $this->success('功能编辑成功', '/');

        }
    }

    //功能菜单删除
    function delMenu($id){
        $id = (int)$id;
        if(!$id){
            return false;
        }
        $where = "id=$id or fid=$id";
        $arr = db('SMenu')->where($where)->find();
        $res = db('SMenu')->where($where)->delete();
        if($res!==false){
            action_log($arr);           //写日志
            //action_log($id,'',session(['staff_id']),0,session(['staff_name']));
            cache('VIP_child_menu_*',null);
            cache('VIP_child_menuAll',null);
            return true;
        }else{
            return false;
        }
    }

    //权限设定页面
    function getPermissionJSON(){
        $permission=db('SMenu')->select();
         foreach($permission as $k => $v){
            $permission[$k]['text']=$v['menu_name'];
        }
        $fid=0;
        $res=treeData($permission,$fid);
        echo json_encode($res);
    }

    //授权
   public function authorise($params){
        $data=db('SMenu')->where('id','in',$params['id'])->select();
        if($params['position_code']){
            $detail['position_code']=$params['position_code'];
            $detail['menu_code']=implode(',',array_column($data,'menu_code'));
            if(db('s_position_menu')->where('position_code',$params['position_code'])->find()){
                $res=db('s_position_menu')->where('position_code',$params['position_code'])->update($detail);
                cache('VIP_child_menu_'.$params['position_code'],null);
            }else{
                $res=db('s_position_menu')->insert($detail);
            }
            if($res===false){
                $this->error('授权失败', '/');
            }else{
                action_log($detail);      //写日志
                cache('VIP_child_menu_'.$params['position_code'],null);
                $this->success('授权成功','/');
            }
        }else{
            $this->error('请选择岗位','/');
        }
   }

    //根据岗位查询其功能权限
    public function getPositionMenu($position_code){
        $data=db('s_position_menu')->where('position_code',$position_code)->find();
        $menu=db('s_menu')->where('menu_code','in',$data['menu_code'])->select();
        //$menu_id=array_column($menu,'id');
       
        $this->success('查询成功','/',$menu);
    }

//提醒快捷开关
    public function remindSwitch($param){
        $count = db('SReminditemset')->where('id',$param['id'])->where('shop_code',session('shop_code'))->count();
        if(!$count){
            $param['shop_code'] = session('shop_code');
            $param['shop_name'] = session('shop_name');
            $param['setkey'] = session('setkey');
            $res = db('SReminditemset')->insert($param);
        }else{
            $res = db('SReminditemset')->where('id',$param['id'])->where('shop_code',session('shop_code'))->update($param);
        }

        return $res;
    }
//获取分配规则信息
    public function getFPIframeInfo($id){
        $res = db('s_allocation_rule')->where('id',$id)->where('shop_code',session('shop_code'))->find();
        return $res;
    }
    //获取标记
    public function getMark($id){
        $res = db('s_markset')->where('shop_code',session('shop_code'))->where('id',$id)->find();
        return $res;
    }
    //获取标记
    public function delMark($id){
        db()->startTrans();
        $res = db('s_markset')->where('shop_code',session('shop_code'))->where('id',$id)->delete();
        if($res){
            db()->commit();
            $arr = array('code'=>200,'msg'=>'删除成功');
        }else{
            db()->rollback();
            $arr = array('code'=>300,'msg'=>'删除成功');
        }
        //action_log($id,'',session(['staff_id']),0,session(['staff_name']));
        return $arr;
    }
    public function getMarkToJSON($param){
        $result['code'] = 0;
        $result['msg'] = '';
        if($param['mark_name']){
            $result['count'] = db('s_markset')->where('shop_code',session('shop_code'))->where('mark_name','like','%'.$param['mark_name'].'%')->field('id,mark_name,mark_color')->order('id desc')->count();
            $result['data'] = db('s_markset')->where('shop_code',session('shop_code'))->where('mark_name','like','%'.$param['mark_name'].'%')->order('id desc')->select();
        }else{
            $result['count'] = db('s_markset')->order('id desc')->count();
            $result['data'] = db('s_markset')->field('id,mark_name,mark_color')->order('id desc')->select();
        }
        return(($result)) ;
    }
    //获取标记
    public function editMark($param){
        if(empty($param['mark_name']) || empty($param['mark_color'])){
            return array('code'=>100,'msg'=>'标记名称或颜色不能为空！');
        }
        db()->startTrans();
        if($param['id']){
            $res = db('s_markset')->where('shop_code',session('shop_code'))->where('id',$param['id'])->update($param);
        }else{
            $param['shop_name'] = session('shop_name');
            $param['shop_code'] = session('shop_code');
            $param['setkey'] = session('setkey');
            $res = db('s_markset')->insert($param);
        }
        if($res){
            db()->commit();
            $arr = array('code'=>200,'msg'=>'编辑成功');
        }else{
            db()->rollback();
            $arr = array('code'=>100,'msg'=>'编辑失败');
        }
        //action_log($param,'',session(['staff_id']),0,session(['staff_name']));
        return $arr;
    }
}