<?php
/**
 * 分享记录类
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Lei Shao Ju <leishaoju@suxuantech.cn>  2017年11月23日 下午12:36:20
 */
namespace app\vip\lib;
use think\Controller;
use app\vip\model\ShareDetail;
//use app\index\controller\Base;

class Share extends Controller{
    
    /**
     * 方法描述: 所有数据
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getlist($c){
        $limit    = isset($c['limit'])?$c['limit']:5;
        $pagenum  = isset($c['page'])?($c['page']-1)*$limit:0;
        // 如果等于1,读取活动分享的记录
        if($c['sourceid']==1){
            return $this->getActivitySharelist($c,$limit,$pagenum);
        }else{
            // 如果不等于1,读取任务的分享的记录
            return $this->getTaskSharelist($c,$limit,$pagenum);
        }
    }
    
    /**
     * 方法描述: 获取活动分享的所有数据
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getActivitySharelist($c,$limit,$pagenum){
        $w = ['s.sourceid'=>1];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }
        $d = ShareDetail::alias('s')->where('')
        ->field('s.id,s.userid,a.title,m.username,m.phone,s.create_time,s.score,s.shareid')
        ->join('__A_ACTIVITY_LIST__ a','a.id=s.shareid','left')
        ->join('__M_USERS__ m','m.id=s.userid','left')
        ->limit($pagenum,$limit)
        ->order('s.create_time desc')
        ->select();
        return $d;
    }
    

    /**
     * 方法描述: 获取任务分享的所有数据
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getTaskSharelist($c,$limit,$pagenum){
        $w = ['s.sourceid'=>2];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['t.brandid'] = $this->brandId;
            }
        }
        $d = ShareDetail::alias('s')->where($w)
        ->field('s.id,s.userid,t.title,m.username,m.phone,s.create_time,s.score,s.shareid')
        ->join('__T_TASK_LIST__ t','t.id=s.shareid','left')
        ->join('__M_USERS__ m','m.id=s.userid','left')
        ->limit($pagenum,$limit)
        ->order('s.create_time desc')
        ->select();
        return $d;
    }
     
    
    /**
     * 方法描述: 获取数据的总数
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getCount($c){
        if(!$c || !$c['sourceid']){
            return false;
        }
        if($c['sourceid']==1){
          return  $this->getActivityShareCount($c);
        }else{
          return  $this->getTaskShareCount($c);
        }
    }
    
     /**
     * 方法描述: 获取任务分享数据的总数
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getTaskShareCount($c){
        $w = ['s.sourceid'=>2];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['t.brandid'] = $this->brandId;
            }
        }
        $d = ShareDetail::alias('s')->where($w)
        ->join('__T_TASK_LIST__ t','t.id=s.shareid','left')
        ->count('s.id');
        return $d;
    }
 
    /**
     * 方法描述: 获取活动分享数据的总数
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getActivityShareCount($c){
        $w = ['s.sourceid'=>1];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['a.brandid'] = $this->brandId;
            }
        }
        $d = ShareDetail::alias('s')->where($w)
        ->join('__A_ACTIVITY_LIST__ a','a.id=s.shareid','left')
        ->count('s.id');
        return $d;
    }
    
    
    
    

 
}