<?php

/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace app\vip\lib;
use think\Controller;
 
use think\db;
class System extends Controller {

    /*
    * 优惠券到期提醒
    */
    public function couponRemind(){

        if(date('H:i:s') == '10:00:00'){
            $configInfo = db('c_sysconfig')->where('ckey','coupon_expire')->value('cvalue');
            $coupon_expire = json_decode($configInfo,true);
            $type = $coupon_expire['type'];
            $days = $coupon_expire['days'];

            if(!$type || empty($days)){
                return false;
            }

            $now = date('Y-m-d');
            $dateArr = [];
            foreach($days as $k => $v){
                if($v)  $dateArr[] = date("Y-m-d 00:00:00",strtotime("$now + $v days"));
            }

            $user_coupon = db('c_coupon_list')
                ->alias('c')
                ->where('c.expire_time','in',$dateArr)
                ->where('c.status','in',[0,4])
                ->join('m_users u','c.userid = u.id','left')
                ->field('c.*,u.phone,u.openid')
                ->select();
            //print_r($user_coupon);die;
            if($user_coupon){

                $url = url('front/order/shopinfo',['slide'=>0],'',true);

                foreach($user_coupon as $key => $val){
                    $date = date('Y-m-d',strtotime($val['expire_time']));
                    if($type == 2){//发短信

                        $param = [
                            '_mobile' => $val['phone'],
                            '_template_id' => config('coupon_remind'),
                            '_brand_id'    => $val['brandid'],
                            'coupon'       => '【'.$val['name'].'】',
                            'date'         => $date
                        ];
                        $smsRes = sx_call('5d78e60eeb6a2',$param,'sx_mc');
                        //print_r($smsRes);die;
                    }else{//发微信模板消息
                        $content = [
                            'touser'       => $val['openid'],
                            'template_id'  => COUPON_REMIND,
                            'url'          => $url,
                            'data'         => [
                                'first'=>[
                                    'value'=> '您好，您的优惠券即将过期，点击立即下单使用',
                                    'color'=> '#173177'
                                ],
                                'keyword1'=>[
                                    'value'=> '优惠券：'.$val['name'],
                                    'color'=> '#173177'
                                ],
                                'keyword2'=>[
                                    'value'=> '将于'.date('Y-m-d',strtotime($val['expire_time'])).'过期',
                                    'color'=> '#173177'
                                ],
                                'remark'=>[
                                    'value'=> '进入会员系统 “个人中心-卡券” 可查看此优惠券。',
                                    'color'=> '#173177'
                                ]
                            ]
                        ];
                        $send_data['content'] = json_encode($content);
                        $send_data['brandclass_id'] = $val['brandid'];
                        $res = sendMemberWxMsg($send_data);
                        //print_r($res);die;
                    }
                }
            }

        }
    }

}  