<?php
/**
 * 任务管理 增删改查处理类
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Lei Shao Ju <leishaoju@suxuantech.cn>  2017年11月14日 下午12:36:20
 */
namespace app\vip\lib;
use app\vip\model\TTaskList;
use app\vip\model\TTaskUserList;
use app\vip\model\TTaskDetail;
use app\index\controller\Base;

class Tasks extends Base{
    
    /**
     * 方法描述: 所有数据
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getlist($c){
        $limit    = isset($c['limit'])?$c['limit']:5;
        $pagenum  = isset($c['page'])?($c['page']-1)*$limit:0;
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }
        $d = db('t_task_list')->where($w)
        ->field('
                 id,title,scontent,index_img,
                 typeid,reward_score,share_score,
                 start_time,end_time,days,create_time,status,
                 receive_total,done_total,share_total,view_num,
                 order_num,business,create_user,content,share_title,share_content,share_img
             ')
        ->limit($pagenum,$limit)
        ->order('create_time desc')
        ->select();
        return $d;
    }
    
    /**
     * 方法描述: 获取数据的总数
     * @param  array $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getCount($c){
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }
        if($c && $c['nobody']){
            $w['receive_total'] = 0;
        }
        return db('t_task_list')->where($w)->count('id');
    }
    
    /**
     * 获取单条数据
     */
    public function getOneData($d){
        $d['brandid'] = $this->brandId;
        $data = db('t_task_list')->where($d)->find();
        if($data){
            return $data;
        }else{
            return false;
        }
    }
    /**
     * 方法描述: 获取今日执行的任务的用户总数
     * @param  array $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getTodayDoTaskCount($c){
        $w = [
            'create_time' => [
                ['>=',date('Y-m-d',time())],
                ['<', date('Y-m-d',time()+86400)],
            ]
        ];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }
        return TTaskDetail::where($w)->group('userid')->count('id');
    }
    
    /**
     * 方法描述: 获取用户领取任务的数量
     * @param  array $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getUserTaskCount($c){
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['t.brandid'] = $this->brandId;
            }
        }
        if($c){
            if($c['nodo']){
                $w['u.done_total'] = 0;
                $w['u.status'] = 0;
            }
            if($c['done']){
                $w['u.status'] = 1;
            }
            if($c['todaydone']){
                $w['u.update_time'] = [
                    ['>=',date('Y-m-d',time())],
                    ['<', date('Y-m-d',time()+86400)],
                ];
                $w['u.status'] = 1;
            }
        }
        $res = TTaskUserList::alias('u')
                            ->where($w)
                            ->join('__T_TASK_LIST__ t', 't.id=u.taskid')
                            ->count();
        return $res;
    }
 
    /**
     * 添加处理方法
     * @param array $d 数据数组
     * @return mixed 
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function add($d){
       if(!$d){
           return false;
       }else{
           $model = new TTaskList();
           $d['brandid'] = $this->brandId;
           $d['create_user'] = $this->staffName;
           $d['create_time'] = date("Y-m-d H:i:s",time());
           $res = $model->save($d);
           return $res!==false?true:false;
       }
    }
    
    /**
     * 修改处理方法
     * @param array $d 数据数组
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function edit($d){
        if(!$d){
            return false;
        }else{
            $w = ['id'=>$d['id']];
            unset($d['id']);
            if(!$this->root){
                if(!$this->brandId){
                    return false;
                }else{
                    $w['brandid'] = $this->brandId;
                }
            }
            $res = TTaskList::where($w)->update($d);
            return $res!==false?true:false;
        }
    }
    
    /**
     * 获取一条信息处理方法
     * @param array $d 数据数组
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function getOne($id){
        
        if(!$id){
            return false;
        }else{
            $w = ['id'=>$id];
            if(!$this->root){
                if(!$this->brandId){
                    return false;
                }else{
                    $w['brandid'] = $this->brandId;
                }
            }
            $res = db('t_task_list')->where($w)
                    // ->field('
                    //          id,title,scontent,index_img,
                    //          typeid,reward_score,share_score,
                    //          start_time,end_time,days,create_time,status,
                    //          receive_total,done_total,share_total,view_num,
                    //          order_num,business,content,share_title,share_content,share_img,style_detail,task_url,
                    //          package_id,package_name,counpon_id,counpon_name
                    //         ')
                    ->find();
            return $res?$res:false;
        }
    }
    
    /**
     * 设置一条数据状态处理方法
     * @param int $id 活动id
     * @param int $status 状态值
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function setStatus($id,$status){
        if(!$id){
            return false;  
        }else{
            $w = ['id'=>$id];
            if(!$this->root){
                if(!$this->brandId){
                    return false;
                }else{
                    $w['brandid'] = $this->brandId;
                }
            }
            
            $res = db('t_task_list')->where($w)->update(['status'=>$status]);
            return $res!==false?true:false;
        }
    }
    
    /**
     * 删除一条活动记录处理方法
     * @param int $id 活动id
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function del($id){
        if(!$id){
            return false;
        }else{
            $w = ['id'=>$id];
            if(!$this->root){
                if(!$this->brandId){
                    return false;
                }else{
                    $w['brandid'] = $this->brandId;
                }
            }
            $hasdata = db('t_task_list')->where($w)->count();
            if($hasdata){
                $res = db('t_task_list')->delete($id);
                return $res?true:false;
            }
        }
    }
    
    
    /**
     * 方法描述: 获取用户领取任务的所有数据
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getTaskDetailList($c){
        $limit    = isset($c['limit'])?$c['limit']:5;
        $pagenum  = isset($c['page'])?($c['page']-1)*$limit:1;
        
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['t.brandid'] = $this->brandId;
            }
        }
        if(isset($c['searchtypeid']) && isset($c['searchkey'])){
            $name = $c['searchtypeid']==1?'t.title':($c['searchtypeid']==2?'d.userid':'u.phone');
            if($name=='t.title'){
                $w['t.title'] = ['like',$c['searchkey']];
            }else{
                $w[$name] = $c['searchkey'];
            }
        }
        if(isset($c['taskid'])){
            $w['d.taskid'] = $c['taskid'];
        }
        if(isset($c['userid'])){
            $w['d.userid'] = $c['userid'];
        } 
        
        return TTaskUserList::alias('d')
                ->where($w)
                ->field('
                        d.id,t.title,d.create_time,d.status,
                        d.done_total,u.username,u.phone,d.userid,d.taskid
                       ')
                 ->join('__M_USERS__ u','u.id=d.userid','left')
                 ->join('__T_TASK_LIST__ t','t.id=d.taskid','left')
                 ->limit($pagenum,$limit)
                 ->select();
    }
    
    /**
     * 方法描述: 获取用户领取任务的总数
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getTaskDetailCount($c){
        
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['t.brandid'] = $this->brandId;
            }
        }
        if(isset($c['searchtypeid']) && isset($c['searchkey'])){
            $name = $c['searchtypeid']==1?'t.title':($c['searchtypeid']==2?'d.userid':'u.phone');
            if($name=='t.title'){
                $w['t.title'] = ['like',$c['searchkey']];
            }else{
                $w[$name] = $c['searchkey'];
            }
        }
        if(isset($c['taskid'])){
            $w['d.taskid'] = $c['taskid'];
        }
        if(isset($c['userid'])){
            $w['d.userid'] = $c['userid'];
        }
        return TTaskUserList::alias('d')
        ->where($w)
       ->join('__M_USERS__ u','u.id=d.userid','left')
       ->join('__T_TASK_LIST__ t','t.id=d.taskid','left')
       ->count('d.id');
        
    }
    

    /**
     * 方法描述: 获取用户执行任务的所有数据
     * @param  array $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getDoTaskDetail($c){
        
        $limit    = isset($c['limit'])?$c['limit']:5;
        $pagenum  = isset($c['page'])?($c['page']-1)*$limit:1;
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['t.brandid'] = $this->brandId;
            }
        }
        if(isset($c['searchtypeid']) && isset($c['searchkey'])){
            $name = $c['searchtypeid']==1?'t.title':($c['searchtypeid']==2?'d.userid':'u.phone');
            if($name=='t.title'){
                $w['t.title'] = ['like',$c['searchkey']];
            }else{
                $w[$name] = $c['searchkey'];
            }
        }
        
        if(isset($c['taskid'])){
            $w['d.taskid'] = $c['taskid'];
        }
        if(isset($c['userid'])){
            $w['d.userid'] = $c['userid'];
        }
        return TTaskDetail::alias('d')
                ->where($w)
                ->field('d.id,t.title,d.create_time,u.username,u.phone,d.userid,d.taskid')
                ->join('__M_USERS__ u','u.id=d.userid','left')
                ->join('__T_TASK_LIST__ t','t.id=d.taskid','left')
                ->limit($pagenum,$limit)
                ->select();

    }
    
    /**
     * 方法描述: 获取用户执行任务的所有数据的总数
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getDoTaskDetailCount($c){
        $w = [];
        if(isset($c['searchtypeid']) && isset($c['searchkey'])){
            $name = $c['searchtypeid']==1?'t.title':($c['searchtypeid']==2?'d.userid':'u.phone');
            if($name=='t.title'){
                $w['t.title'] = ['like',$c['searchkey']];
            }else{
                $w[$name] = $c['searchkey'];
            }
        }
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['t.brandid'] = $this->brandId;
            }
        }
        return TTaskDetail::alias('d')
        ->where($w)
        ->join('__M_USERS__ u','u.id=d.userid','left')
        ->join('__T_TASK_LIST__ t','t.id=d.taskid','left')
        ->count('d.id');
    }
    
    
    /**
     * 方法描述: 获取最近一周的数据
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getWeekList($c){
        $w    = [];
        // 判断当前的用户权限如果是root 选择全部
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['t.brandid'] = $this->brandId;
            }
        }
        $data = [];
        for($i=6;$i>=0;$i--){
            $currenttime = time();
            $starttime   = date('Y-m-d',$currenttime+86400-$i*86400);
            $endtime     = date('Y-m-d',$currenttime-$i*86400);
            $w['d.create_time'] = [
                        ['<=',$starttime],
                        ['>', $endtime],
            ];
            $data[$endtime] = TTaskDetail::alias('d')
                                        ->where($w)
                                        ->join('__T_TASK_LIST__ t','t.id=d.taskid')
                                        ->count('d.id');
        }
        return $data;
    }
    
    
}