<?php
/**
 * 用户管理统计类
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Lei Shao Ju <leishaoju@suxuantech.cn>  2017年11月14日 下午12:36:20
 */
namespace app\vip\lib;
use app\vip\model\MUsers;
use app\index\controller\Base;
use app\vip\model\MUsersPhone;
use app\vip\model\WxEventLog;

class Userscount extends Base{
    
    /**
     * 方法描述  获取正式会员总数和粉丝总数
     * @param  array $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getUsersCount($c){
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
                $w1['brandid'] = $this->brandId;
            }

            if($this->brandId == db_config('sx_brand')){
                $w['brandid'] = 0;
                $w1['brandid'] = 0;
            }
        }

        if($c['day'] && $c['month'] && $c['year']) {
            $day = (int)$c['day'];
            $month = (int)$c['month'];
            $day = $day >= 10 ? $day : '0' . $day;
            $month = $month >= 10 ? $month : '0' . $month;

            $starttime = $c['year'] . '-' . $month . '-' . $day;
            $endtime = date('Y-m-d', strtotime($starttime) + 86400);

        }else if($c['year'] && $c['month']){
            $year  = $c['year'];
            $month = $c['month'];
            $currenttime = strtotime($year.'-'.$month.'-01');
            $starttime = date('Y-m-d',$currenttime);
            if($month==12){
                $year  += 1;
                $month = 1;
            }else{
                $month += 1;
            }
            $endtime   = date('Y-m-d',strtotime($year.'-'.$month.'-01'));

        }else if($c['year']) {

            // 获取某年的数据
            $starttime = $c['year'] . '-01-01';
            $endtime = ($c['year'] + 1) . '-01-01';

        }

        $w['reg_time'] = [
            ['>=', $starttime],
            ['<', $endtime]
        ];
        $w1['create_time'] = [
            ['>=', $starttime],
            ['<', $endtime]
        ];



        //会员数量(已绑定手机号的用户为会员)
        $usersTotal = db('m_users')->where('phone is not null or phone <> ""')->where($w)->count();

        //粉丝（进入系统但没有绑定手机号）
        $phoneTotal = db('m_users')->where('phone is null or phone = ""')->where($w1)->count();

        // 统计粉丝的数量
        //$phoneTotal  = db('m_users_phone')->where(['userid'=>['<',1]])->where($w)->count('id');
        // 统计会员的总数
        //$usersTotal   = MUsers::where($w)->distinct('openid')->count('id');
   
        return ['phoneTotal'=>$phoneTotal,'usersTotal'=>$usersTotal];
    }
 
    /**
     * 方法描述: 获取最近一周的粉丝数据
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getUsersWeekCount($c){
        $w = [];
        // 判断当前的用户权限如果是root 选择全部
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid']      = $this->brandId;
                $preW['p.brandid']   = $w['brandid'];
            }
        }
 
        // 默认取一个星期的数据
        $lenth       = 6;
        $currenttime = time();
        
        // 定义记录总数的变量
        $newUsersToPhoneAll = [];
        $phoneUsersAll = [];
        $addUsersAll   = [];
        $delUsersAll = [];
        $oldUsersTophoneAll = [];
        $shopToPhoneAll = [];
        
        if($c['addY']){
            $perYM[] = $c['year'];
        }
        if($c['addM']){
            $perYM[] = $c['month'];
        }
        $preYM =$perYM?implode('-', $perYM):'';
        
        if($c['week']){
            if($c['week']['endtime']){
                $currenttime = strtotime($c['week']['endtime']);
            }
        }else if($c['year'] && $c['month']){
            $lastday = date('t',strtotime($c['year'].'-'.$c['month'].'-01'));
            $lenth   = $lastday-1;
            $currenttime = strtotime($c['year'].'-'.$c['month'].'-'.$lastday);
        }else if($c['year']){
            
            // 缓存按年查询的数据
            $trueYear  = date('Y',time());
            $trueMonth = (int)date('m',time());
            $trueDay   = (int)date('d',time());
            $cachekey = 'count_brandid_'.$this->brandId.'_'.$c['year'];
            //cache($cachekey,'');
            $data = cache($cachekey);
            //print_r($data);die;
            
  
            if($data){
      
                
                if($trueYear == $c['year']){
                    $starttime = date('Y-m-d',time());
                    $w['create_time'] = [
                        ['>=',$starttime],
                        ['<', date('Y-m-d',time()+86400)],
                    ];
                    $preW['p.create_time'] = $w['create_time'];
  
                    
                    $oldphoneUsersday   = $data['phoneUsers'][$trueMonth][$starttime];
                    $oldnewUsersToPhoneday = $data['newUsersToPhone'][$trueMonth][$starttime];
                    
                    $oldphoneUsersday   = $data['phoneUsers'][$trueMonth][$starttime];
                    $oldnewUsersToPhoneday = $data['newUsersToPhone'][$trueMonth][$starttime];

                    // 当天正式会员的数据
                    $phoneUsersData = MUsersPhone::alias('p')->where($preW)->join('m_users m','m.id=p.userid','left')->field('p.userid,m.create_time')->select();
                    //echo db()->getLastSql();die;
                    
                    
                    
                    
//                     'phoneUsers'=>$phoneUsers,
//                     'addUsers'=>$addusers,
//                     'delUsers'=>$delusers,
//                     'mdays'=>$mDays,
//                     'newUsersToPhone' => $newUsersToPhone,
//                     'oldUsersTophone' => $oldUsersToPhone,
//                     'shopToPhone' => $shopToPhone,
                    
//                     'newUsersToPhoneAllTotal' =>array_sum($newUsersToPhoneAll),  // 今年新增成为粉丝后立即转成正式会员的总数
//                     'phoneUsersAllTotal' => array_sum($phoneUsersAll), // 今年新增正式会员总数
//                     'addUsersAllTotal'   => array_sum($addUsersAll),  // 今年新增新增粉丝总数
//                     'delUsersAllTotal'   => array_sum($delUsersAll),  // 今年新增跑路粉丝总数
//                     'oldUsersTophoneAllTotal' => array_sum($oldUsersTophoneAll), // 今年新增老粉丝转成正式会员的总数
//                     'shopToPhoneAll'          => array_sum($shopToPhoneAll), //今年新增 商城直接注册的会员总数
                    
//                     'newUsersToPhoneAll' =>implode(',', $newUsersToPhoneAll),  // 成为粉丝后立即转成正式会员的总数
//                     'phoneUsersAll' => implode(',', $phoneUsersAll), // 正式会员总数
//                     'addUsersAll' => implode(',', $addUsersAll),  // 新增粉丝总数
//                     'delUsersAll' => implode(',', $delUsersAll),  // 跑路粉丝总数
//                     'oldUsersTophoneAll' => implode(',', $oldUsersTophoneAll), // 老粉丝转成正式会员的总数
//                     'shopToPhoneAll' => implode(',', $shopToPhoneAll), // 商城直接注册的会员总数
                  
 
                    $data[$trueMonth][$starttime] = count($phoneUsersData);
 
                    // 统计当天成为会员的数量
                    $phoneUsers[$trueMonth][$starttime] = count($phoneUsersData);
                    //$phoneUsersAll[$trueMonth] += $phoneUsers[$trueMonth][$starttime];
                    
                    
                    
                    // 统计当天成为粉丝后立马注册成会员的数量
                    $data['newUsersToPhone'][$trueMonth][$starttime] = 0;
 
                    // 老粉丝转成正式会员的数量
                    $data['oldUsersTophone'][$trueMonth][$starttime] = 0;
                    // 商城直接注册正式会员的数量
                    $shopToPhone[$trueMonth][$starttime] = 0;
                    foreach ($phoneUsersData as $v){
                        if(substr($v['create_time'],0,10) == $starttime){
                            $data['newUsersToPhone'][$trueMonth][$starttime]++;
                            $newUsersToPhoneAll[$trueMonth]++;
                    
                        }else{
                            if(!$v['userid']){
                                $data['shopToPhone'][$trueMonth][$starttime]++;
                                $shopToPhoneAll[$trueMonth]++;
                            }else{
                                $data['oldUsersTophone'][$trueMonth][$starttime]++;
                                $oldUsersTophoneAll[$trueMonth]++;
                            }
                        }
                    }
                    
                    // 今日新粉丝,包含已经成为正式会员的数量
                    $usersTotal = MUsers::where($w)->count('id');
                    
                    $data['addUsers'][$trueMonth][$starttime]  = $usersTotal- $data['newUsersToPhone'][$trueMonth][$starttime]-$data['oldUsersTophone'][$trueMonth][$starttime];
                    // 统计这段时间新增粉丝总数
                    $addUsersAll[$trueMonth] += $data['addUsers'][$trueMonth][$starttime];
                    
                    // 增加的粉丝数
                    // $addusers[$k+1][$endtime] = WxEventLog::where($w)->where(['event_type'=>1])->count()-$phoneUsers[$endtime];
                    // 减少的粉丝数
                    $data['delUsers'][$trueMonth][$starttime] = WxEventLog::where($w)->where(['event_type'=>0])->count();
                    //$mDays[$trueMonth][] = $starttime;
                    // 统计这段是时间总粉丝减少量
                    $delUsersAll[$trueMonth] += $data['delUsers'][$trueMonth][$starttime];
                    
                    
//                     $data[addUsers] =>
//                     $data[delUsers] =>
//                     $data[mdays] => Array
//                     (
//                     )
                    
//                     $data[newUsersToPhone] =>
//                     $data[oldUsersTophone] =>
//                     $data[shopToPhone] =>
//                     $data[newUsersToPhoneAllTotal] => 0
//                     $data[phoneUsersAllTotal] => 0
//                     $data[addUsersAllTotal] => 0
//                     $data[delUsersAllTotal] => 0
//                     $data[oldUsersTophoneAllTotal] => 0
 
                    
                    $data[newUsersToPhoneAll]  = explode(',',$newUsersToPhoneAll);
                    $data[phoneUsersAll]   = explode(',',$phoneUsersAll);
                    $data[shopToPhoneAll]  = explode(',',$shopToPhoneAll);
                    $data[delUsersAll]     = explode(',',$delUsersAll);
                    $data[oldUsersTophoneAll]  = explode(',',$oldUsersTophoneAll);
                    $data[addUsersAll]  = explode(',',$addUsersAll);
                    
                    
//                     $data[shopToPhoneAll] => 0,0,0,0,0,0,0,0,0,0,0,0
//                     $data[newUsersToPhoneAll] => 0,0,0,0,0,0,0,0,0,0,0,0
//                     $data[phoneUsersAll] => 0,0,0,0,0,0,0,0,0,0,0,0
//                     $data[addUsersAll] => 0,0,0,0,0,0,0,0,0,0,0,0
//                     $data[delUsersAll] => 0,0,0,0,0,0,0,0,0,0,0,0
//                     $data[oldUsersTophoneAll] => 0,0,0,0,0,0,0,0,0,0,0,0
                    
  
                    
                    
  
                }else{
                    return $data;
                }
            }
            
            // 一年的每天的数据
            $month = 0;
            $mDays = []; // 一个月的日期
            for($k = 0;$k<12;$k++){
                $lastday = date('t',strtotime($c['year'].'-'.($k+1).'-01'));
                $currenttime = strtotime($c['year'].'-'.($k+1).'-'.$lastday);
                $newCurrenttime =  strtotime($c['year'].'-'.($k+1).'-01');
                
                // 定义记录总数的变量
                $newUsersToPhoneAll[$k+1] = 0;
                $phoneUsersAll[$k+1] = 0;
                $addUsersAll[$k+1] = 0;
                $delUsersAll[$k+1] = 0;
                $oldUsersTophoneAll[$k+1] = 0;
                $shopToPhoneAll[$k+1] = 0;
                for($i=0;$i<$lastday;$i++){

                    $starttime   = date('Y-m-d',$newCurrenttime+$i*86400);
                    $endtime     = date('Y-m-d',$newCurrenttime+86400+$i*86400);

                    $w['create_time'] = [
                        ['>=',$starttime],
                        ['<', $endtime],
                    ];
                    
                 
                    $preW['p.create_time'] = $w['create_time'];
                    
                    // 当天正式会员的数据
                    $phoneUsersData = MUsersPhone::alias('p')->where($preW)->join('m_users m','m.id=p.userid','left')->field('p.userid,m.create_time')->select();
                    //echo db()->getLastSql();die;
 
                    // 统计当天成为会员的数量
                    $phoneUsers[$k+1][$starttime] = count($phoneUsersData);
                    $phoneUsersAll[$k+1] += $phoneUsers[$k+1][$starttime];
                    
                    // 统计当天成为粉丝后立马注册成会员的数量
                    $newUsersToPhone[$k+1][$starttime] = 0;
                    // 老粉丝转成正式会员的数量
                    $oldUsersToPhone[$k+1][$starttime] = 0;
                    // 商城直接注册正式会员的数量
                    $shopToPhone[$k+1][$starttime] = 0;
                    foreach ($phoneUsersData as $v){
                        if(substr($v['create_time'],0,10) == $starttime){
                            $newUsersToPhone[$k+1][$starttime]++;
                            $newUsersToPhoneAll[$k+1]++;
                            
                        }else{
                            if(!$v['userid']){
                                $shopToPhone[$k+1][$starttime]++;
                                $shopToPhoneAll[$k+1]++;
                            }else{
                                $oldUsersToPhone[$k+1][$starttime]++;
                                $oldUsersTophoneAll[$k+1]++;
                            }
                        }
                    }

                    // 今日新粉丝,包含已经成为正式会员的数量
                    $usersTotal = MUsers::where($w)->count('id');
 
                    $addusers[$k+1][$starttime]  = $usersTotal- $newUsersToPhone[$k+1][$starttime]-$oldUsersToPhone[$k+1][$starttime];
                    // 统计这段时间新增粉丝总数
                    $addUsersAll[$k+1] += $addusers[$k+1][$starttime];
                    
                    // 增加的粉丝数
                    // $addusers[$k+1][$endtime] = WxEventLog::where($w)->where(['event_type'=>1])->count()-$phoneUsers[$endtime];
                    // 减少的粉丝数
                    $delusers[$k+1][$starttime] = WxEventLog::where($w)->where(['event_type'=>0])->count();
                    $mDays[$k+1][] = $starttime;
                    // 统计这段是时间总粉丝减少量
                    $delUsersAll[$k+1] += $delusers[$k+1][$starttime];

 
                }
   
            }
             
            $data =   [
                'phoneUsers'=>$phoneUsers,
                'addUsers'=>$addusers,
                'delUsers'=>$delusers,
                'mdays'=>$mDays,
                'newUsersToPhone' => $newUsersToPhone,
                'oldUsersTophone' => $oldUsersToPhone,
                'shopToPhone' => $shopToPhone,
 
                'newUsersToPhoneAllTotal' =>array_sum($newUsersToPhoneAll),  // 今年新增成为粉丝后立即转成正式会员的总数
                'phoneUsersAllTotal' => array_sum($phoneUsersAll), // 今年新增正式会员总数
                'addUsersAllTotal'   => array_sum($addUsersAll),  // 今年新增新增粉丝总数
                'delUsersAllTotal'   => array_sum($delUsersAll),  // 今年新增跑路粉丝总数
                'oldUsersTophoneAllTotal' => array_sum($oldUsersTophoneAll), // 今年新增老粉丝转成正式会员的总数
                'shopToPhoneAll'          => array_sum($shopToPhoneAll), //今年新增 商城直接注册的会员总数
 
                'newUsersToPhoneAll' =>implode(',', $newUsersToPhoneAll),  // 成为粉丝后立即转成正式会员的总数
                'phoneUsersAll' => implode(',', $phoneUsersAll), // 正式会员总数
                'addUsersAll' => implode(',', $addUsersAll),  // 新增粉丝总数
                'delUsersAll' => implode(',', $delUsersAll),  // 跑路粉丝总数
                'oldUsersTophoneAll' => implode(',', $oldUsersTophoneAll), // 老粉丝转成正式会员的总数
                'shopToPhoneAll' => implode(',', $shopToPhoneAll), // 商城直接注册的会员总数
            ];
            
            //print_r($data);die;

            cache($cachekey,$data);
            return $data;
        }
        
        
        // 定义记录总数的变量
        $newUsersToPhoneAll = 0;
        $phoneUsersAll = 0;
        $addUsersAll   = 0;
        $delUsersAll = 0;
        $oldUsersTophoneAll = 0;
        $shopToPhoneAll = 0;
        $days = []; 
        
        
        for($i=$lenth;$i>=0;$i--){
            //$currenttime = time();
            $starttime   = date('Y-m-d',$currenttime+86400-$i*86400);
            $endtime     = date('Y-m-d',$currenttime-$i*86400);
            $w['create_time'] = [
                ['<=',$starttime],
                ['>', $endtime],
            ];
            $preW['p.create_time'] =  $w['create_time'];

            // 当天正式会员的数据
            $phoneUsersData = MUsersPhone::alias('p')->where($preW)->join('m_users m','m.id=p.userid','left')->field('p.userid,m.create_time')->select();
 
            // 统计当天成为会员的数量
            $phoneUsers[$endtime] = count($phoneUsersData);
            $phoneUsersAll += $phoneUsers[$endtime];
            
            // 统计当天成为粉丝后立马注册成会员的数量
            $newUsersToPhone[$endtime] = 0;
            // 老粉丝转成正式会员的数量
            $oldUsersToPhone[$endtime] = 0;
            // 商城直接注册正式会员的数量
            $shopToPhone[$endtime] = 0;
            foreach ($phoneUsersData as $v){
                if(substr($v['create_time'],0,10) == $endtime){
                    // 这里统计的是当天成为粉丝当天成为会员的数量
                    $newUsersToPhone[$endtime]++;
                    $newUsersToPhoneAll++;
                }else{
                    if(!$v['userid']){
                        // 如果用户没有userid说明没有微信的信息,说明是从商城注册成正式会员的
                        $shopToPhone[$endtime]++;
                        $shopToPhoneAll++;
                    }else{
                        // 当userid存在的时候,说明是微信的老粉丝转成会员的
                        $oldUsersToPhone[$endtime]++;
                        $oldUsersTophoneAll++;
                    }
                }
            }
            
            // 今日新粉丝,包含已经成为正式会员的数量
            $usersTotal = MUsers::where($w)->count('id');
            // 当天新增粉丝量  = 今日总粉丝量 - 今日粉丝转正式会员的数量
            $addusers[$endtime]  = $usersTotal- $newUsersToPhone[$endtime]-$oldUsersToPhone[$endtime];

            
            // 统计新增总粉丝
            $addUsersAll += $addusers[$endtime];

            // 增加的粉丝数
            // $addusers[$endtime] = WxEventLog::where($w)->where(['event_type'=>1])->count()-$phoneUsers[$endtime];
            
            // 减少的粉丝数总数据
            $todayDelUsers = WxEventLog::where($w)->field('openid')->select();
            
             // 统计今天总共粉丝走的数量
             $delusers[$endtime] = count($todayDelUsers);
             
             // 计算当天净增会员
             $jingzeng[$endtime] = $usersTotal-$delusers[$endtime]-count(array_unique($delusers[$endtime]));
            
             $jingzengAll += $jingzeng[$endtime];
             
            // 统计这段时间总的粉丝减少量
            $delUsersAll += $delusers[$endtime];
 
            // 统计新增总粉丝
            $addUsersAll += $delusers[$endtime];
            
            
            // 保存日期数据js端用
            $days[] = !$perYM?'\''.substr($endtime,5,5).'\'':$endtime;
        }

        return [
            'phoneUsers'=> implode(',', $phoneUsers),
            'addUsers'=> implode(',', $addusers),
            'delUsers'=>implode(',', $delusers),
            'days'=>implode(',', $days),
            'newUsersToPhone' => implode(',', $newUsersToPhone),
            'oldUsersTophone' => implode(',', $oldUsersToPhone),


            'newUsersToPhoneAllTotal' => $newUsersToPhoneAll,  // 成为粉丝后立即转成正式会员的总数
            'phoneUsersAllTotal' => $phoneUsersAll, // 正式会员总数
            'addUsersAllTotal' => $addUsersAll,  // 新增粉丝总数
            'delUsersAllTotal' => $delUsersAll,  // 跑路粉丝总数
            'oldUsersTophoneAllTotal' => $oldUsersTophoneAll, // 老粉丝转成正式会员的总数
            'shopToPhoneAllTotal' => $shopToPhoneAll, // 商城直接注册的会员总数
            
        ];
    }
 
    /**
     * 方法描述: 获取最近一段时间的记录数据
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getUsersCountData($c){
        $w = [];
        // 判断当前的用户权限如果是root 选择全部
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid']   = $this->brandId;
                $w1['brandid']  = $this->brandId;
                $brand_id = $this->brandId;
                //$preW['p.brandid']   = $w['brandid'];
                if($this->brandId == db_config('sx_brand')){
                    $brand_id = 0;//查询m_users表用
                }
            }
        }


        $currenttime = time();
        // 判断日期是否需要加上年月日
        if($c['addY']){
            $perYM[] = $c['year'];
        }
        if($c['addM']){
            $perYM[] = $c['month'];
        }
        $preYM =$perYM?implode('-', $perYM):'';

        // 获取某年某月某日的数据
        if($c['day'] && $c['month'] && $c['year']){
                $day   = (int)$c['day'];
                $month = (int)$c['month'];
                $day   = $day>=10?$day:'0'.$day;
                $month = $month>=10?$month:'0'.$month;
                
                $currentDate = $c['year'].'-'.$month.'-'.$day;
                $endtime     = date('Y-m-d',strtotime($currentDate)+86400);
                $w['reg_time'] = [
                    ['>=',$currentDate],
                    ['<', $endtime],
                ];
                
                $w1['create_time'] = [
                    ['>=',$currentDate],
                    ['<', $endtime],
                ];
                //$preW['p.create_time'] = $w['create_time'];
                
                // 当天粉丝的数据
                $addPhoneUsersData = db('m_users_phone')
                ->where($w1)
                ->where(['userid'=>['<',1]])
                ->field('create_time,password')
                ->select();

                // 当天新增粉丝总数
                $addPhoneUsersaAll = count($addPhoneUsersData);
                
                //新增会员数 = wx_event_log表中关注人  +  m_users中除了wx_event_log中重复的数据
                //m_users中除了wx_event_log中重复的数据
                //$where = db('wx_event_log')->where($w1)->where('event_type','1')->fetchSql()->select();
                // 当月新会员数据,包含已经成为正式会员的数量
                //$addUsersData = db('m_users')->where($w1)->where('openid','not in',$where)->distinct('openid')->field('id,openid,reg_time')->select();
            if($brand_id){
                $sql = 'SELECT id,openid,create_time FROM m_users WHERE brandid = "'.$brand_id.'" AND ( `create_time` >= "'.$currentDate.'" AND `create_time` < "'.$endtime.'" )
                AND openid NOT IN(
                SELECT openid FROM `wx_event_log` WHERE `brandid` = '.$brand_id.' AND ( `create_time` >= "'.$currentDate.'" AND `create_time` < "'.$endtime.'" ) AND `event_type` = 1
                )';
            }else{
                $sql = 'SELECT id,openid,create_time FROM m_users WHERE  `create_time` >= "'.$currentDate.'" AND `create_time` < "'.$endtime.'"
                AND openid NOT IN(
                SELECT openid FROM `wx_event_log` WHERE  `create_time` >= "'.$currentDate.'" AND `create_time` < "'.$endtime.'"  AND `event_type` = 1
                )';
            }


            $addUsersData = db()->query($sql);
                // 当月新关注的人
                $addUser_data = db('wx_event_log')->where($w1)->where('event_type','1')->select();
                foreach($addUser_data as $k=>$v){
                    foreach($v as $k2=>$v2){
                        $addUser_data[$k]['reg_time'] = $addUser_data[$k]['create_time'];
                    }
                }
                // 当月新增人
                $addUsersData = array_merge($addUsersData,$addUser_data);
                
                // 当天新增的会员总数
                $addUsersAll  = count($addUsersData);
                
                // 当天跑路会员数据
                $delUsersData = db('wx_event_log')->where($w1)->where(['event_type'=>0])->distinct('openid')->field('openid,create_time,event_type')->select();

                // 当天跑路会员总数
                $delUsersAll   = count($delUsersData);
                
                // 当天净增会员数量
                $netGrowthAddUsersAll = $addUsersAll - $delUsersAll;
                
                
                // 存新粉丝立即转成会员的数量
                $newUsersToPhoneAll = 0;

                // 通过商城注册的会员
                $shopToPhoneAll = 0;

                // 循环数据 新增粉丝的数据
                $addPhoneUsers_H = [];  // 每小时的数据总计
                
                foreach ($addPhoneUsersData as $k=>$v){
                    $h = substr($v['create_time'],11,2);
                    $h = (int)$h;
                    $addPhoneUsers_H[$h] += 1;
 
                }
 
                // 循环数据 新增粉丝的数据
                $addUsers_H = [];  // 每小时的数据总计
                $addOpenids = [];  // 取出当天新粉丝的openid;
                foreach ($addUsersData as $k=>$v){
                    $h = substr($v['create_time'],11,2);
                    $h = (int)$h;
                    $addUsers_H[$h] += 1;
                    
                    // 存当天关注的用户openid
                    $addOpenids[] = $v['openid'];
                }
                
                // 循环数据 跑路粉丝的数据
                $delUsers_H = [];  // 每小时的数据总计
                $addUsersToDelAll = 0; // 存储当天关注当天跑路的用户数据
                
                foreach ($delUsersData as $k=>$v){
                    $h = substr($v['create_time'],11,2);
                    $h = (int)$h;
                    $delUsers_H[$h] += 1;
 
                    // 判断会员是不是当天关注，当天跑路
                    if(in_array($v['openid'],$addOpenids)){
                        $addUsersToDelAll +=1;
                    }
 
                }
  
                // 为没有数据的时段充填为零
                
                // 统计每小时净增量
                $netGrowthAddUsers_H = []; 
                for($i=0;$i<24;$i++){
                    $addPhoneUsers_H[$i] += 0;
                    $addUsers_H[$i]      += 0;
                    $delUsers_H[$i]      += 0;
                    $netGrowthAddUsers_H[$i] = $addUsers_H[$i] - $delUsers_H[$i];
                }
                
                // 排序
                ksort($addPhoneUsers_H);
                ksort($addUsers_H);
                ksort($delUsers_H);
                ksort($netGrowthAddUsers_H);
             
            
                $data =   [
                            // 上方展示的总数 
                            "phoneUsersAllTotal"    => $addPhoneUsersaAll, // 今日新增粉丝总数
                            'addUsersAllTotal'      => $addUsersAll,  // 今日新增新增会员总数
                            'delUsersAllTotal'      => $delUsersAll,  // 今日新增跑路会员总数
                            'netGrowthAddUsersAllTotal'  => $netGrowthAddUsersAll, // 计算会员净增数据
                            
                            // 统计图用的数据
                            'phoneUsersAll'        => implode(',', $addPhoneUsers_H), // 正式会员总数
                            'addUsersAll'          => implode(',', $addUsers_H),  // 新增粉丝总数
                            'delUsersAll'          => implode(',', $delUsers_H),  // 跑路粉丝总数
                            'netGrowthAddUsersAll' => implode(',', $netGrowthAddUsers_H),  // 跑路粉丝总数
                            ];
    
            
        }elseif($c['year'] && $c['month']){
            // 获取某年某月的数据
            $year  = $c['year'];
            $month = $c['month'];
            $currenttime = strtotime($year.'-'.$month.'-01');
            $lastday   = date('t',$currenttime);
            $starttime = date('Y-m-d',$currenttime);
            if($month==12){
                $year  += 1; 
                $month = 1;
            }else{
                $month += 1;
            }
            $endtime   = date('Y-m-d',strtotime($year.'-'.$month.'-01'));
            $sql = '';
 
            $w['reg_time'] = [
                ['>=',$starttime],
                ['<',$endtime]
            ];
            $w1['create_time'] = [
                ['>=',$starttime],
                ['<',$endtime]
            ];
            
            // 当月粉丝的数据
            $addPhoneUsersData = db('m_users_phone')
            ->where($w1)
            ->where(['userid'=>['<',1]])
            ->field('create_time,password')
            ->select();
            
            // 当月新增粉丝总数
            $addPhoneUsersaAll = count($addPhoneUsersData);
            
            //新增会员数 = wx_event_log表中关注人  +  m_users中除了wx_event_log中重复的数据
            //m_users中除了wx_event_log中重复的数据
            //$where = db('wx_event_log')->where($w1)->where('event_type','1')->fetchSql()->select();
            //当月新会员数据,包含已经成为正式会员的数量
            //$addUsersData = db('m_users')->where($w1)->where('openid','not in',$where)->distinct('openid')->field('id,openid,reg_time')->select();
            if($brand_id){
                $sql = 'SELECT id,openid,create_time FROM m_users WHERE brandid = "'.$brand_id.'" AND ( `create_time` >= "'.$starttime.'" AND `create_time` < "'.$endtime.'" )
                AND openid NOT IN(
                SELECT openid FROM `wx_event_log` WHERE `brandid` = '.$brand_id.' AND ( `create_time` >= "'.$starttime.'" AND `create_time` < "'.$endtime.'" ) AND `event_type` = 1
                )';
            }else{
                $sql = 'SELECT id,openid,create_time FROM m_users WHERE  `create_time` >= "'.$starttime.'" AND `create_time` < "'.$endtime.'"
                AND openid NOT IN(
                SELECT openid FROM `wx_event_log` WHERE  `create_time` >= "'.$starttime.'" AND `create_time` < "'.$endtime.'"  AND `event_type` = 1
                )';
            }

            $addUsersData = db()->query($sql);
            //$sql = 'SELECT openid FROM `wx_event_log` WHERE `brandid` = '.$this->brandId.' AND ( `create_time` >= "'.$starttime.'" AND `create_time` < "'.$endtime.'" ) AND `event_type` = 1';
            //$addUsersData  = db('m_users')->where($w1)->where('openid','not in',$sql)->field('id,openid,create_time')->select();

            // 当月新关注的人
            $addUser_data = db('wx_event_log')->where($w1)->where('event_type','1')->select();
            foreach($addUser_data as $k=>$v){
                foreach($v as $k2=>$v2){
                    $addUser_data[$k]['reg_time'] = $addUser_data[$k]['create_time'];
                }
            }
            // 当月新增人
            $addUsersData = array_merge($addUsersData,$addUser_data);
            
            // 当月新增的会员总数
            $addUsersAll  = count($addUsersData);
            
            // 当月跑路会员数据
            $delUsersData = db('wx_event_log')->where($w1)->where(['event_type'=>0])->distinct('openid')->field('openid,create_time,event_type')->select();

            // 当月跑路会员总数
            $delUsersAll   = count($delUsersData);
 
            // 当月净增会员总数
            $netGrowthAddUsersAll = $addUsersAll - $delUsersAll;
            
            // 循环数据 新增粉丝的数据2018-09-09
            $addPhoneUsers_day = [];  // 每天的数据总计
            foreach ($addPhoneUsersData as $k=>$v){
                $day = (int)substr($v['create_time'],8,2);
                $addPhoneUsers_day[$day] += 1;
            }
            // 循环数据 新增粉丝的数据 2107-08-09
            $addUsers_day = [];  // 每天的数据总计
            $addOpenidsd   = [];  // 取出新粉丝的openid;
            foreach ($addUsersData as $k=>$v){
                $day = (int)substr($v['create_time'],8,2);
                $addUsers_day[$day] += 1;
                // 存当天关注的用户openid
                $addOpenids[] = $v['openid'];
            }
            
            // 循环数据 跑路粉丝的数据
            $delUsers_day = [];  // 每小时的数据总计
            $addUsersToDelAll_day = []; // 存储当天关注当天跑路的用户数据

            foreach ($delUsersData as $k=>$v){
                $day = (int)substr($v['create_time'],8,2);
                $delUsers_day[$day] += 1;
                // 判断会员是不是当天关注，当天跑路
                if(in_array($v['openid'],$addOpenids)){
                    $addUsersToDelAll_day[$day] +=1;
                }
            
            }
            // 统计每天净增量
            $netGrowthAddUsers_day = [];
            for($i=1;$i<=$lastday;$i++){
                $addPhoneUsers_day[$i] += 0;
                $addUsers_day[$i]     += 0;
                $delUsers_day[$i]     += 0;
                $netGrowthAddUsers_day[$i] = $addUsers_day[$i] - $delUsers_day[$i];
                $days[] = $c['month'].'月'.$i.'日';
            }
            // 排序
            ksort($addPhoneUsers_day);
            ksort($addUsers_day);
            ksort($delUsers_day);
            ksort($netGrowthAddUsers_day);
            
            $data =   [
                // 上方展示的总数
                "phoneUsersAllTotal"    => $addPhoneUsersaAll, // 今日新增粉丝总数
                'addUsersAllTotal'      => $addUsersAll,  // 今日新增新增会员总数
                'delUsersAllTotal'      => $delUsersAll,  // 今日新增跑路会员总数
                'netGrowthAddUsersAllTotal'  => $netGrowthAddUsersAll, // 计算会员净增数据
            
                // 统计图用的数据
                'phoneUsersAll'        => implode(',', $addPhoneUsers_day), // 正式会员总数
                'addUsersAll'          => implode(',', $addUsers_day),  // 新增粉丝总数
                'delUsersAll'          => implode(',', $delUsers_day),  // 跑路粉丝总数
                'netGrowthAddUsersAll' => implode(',', $netGrowthAddUsers_day),  // 跑路粉丝总数
                'days'                 => '"'.implode('","',$days).'"',
            ];
            
            
        }else if($c['year']){
            
            // 获取某年的数据
            $starttime = $c['year'].'-01-01';
            $endtime   = ($c['year']+1).'-01-01';
            $length    = 12;
            $sql       = '';
            
            $w['reg_time'] = [
                ['>=',$starttime],
                ['<',$endtime]
            ];
            $w1['create_time'] = [
                ['>=',$starttime],
                ['<',$endtime]
            ];
            
            // 当年粉丝的数据
            $addPhoneUsersData = db('m_users_phone')
            ->where($w1)
            ->where(['userid'=>['<',1]])
            ->field('create_time,password')
            ->select();
            
            // 当年新增粉丝总数
            $addPhoneUsersaAll = count($addPhoneUsersData);
            
            //新增会员数 = wx_event_log表中关注人  +  m_users中除了wx_event_log中重复的数据
            //m_users中除了wx_event_log中重复的数据
            //$where = db('wx_event_log')->where($w1)->where('event_type','1')->fetchSql()->select();
            // 当月新会员数据,包含已经成为正式会员的数量
           // $addUsersData = db('m_users')->where($w1)->where('openid','not in',$where)->distinct('openid')->field('id,openid,reg_time')->select();

            if($brand_id){
                $sql = 'SELECT id,openid,create_time FROM m_users WHERE brandid = "'.$brand_id.'" AND ( `create_time` >= "'.$starttime.'" AND `create_time` < "'.$endtime.'" )
                AND openid NOT IN(
                SELECT openid FROM `wx_event_log` WHERE `brandid` = '.$brand_id.' AND ( `create_time` >= "'.$starttime.'" AND `create_time` < "'.$endtime.'" ) AND `event_type` = 1
                )';
            }else{
                $sql = 'SELECT id,openid,create_time FROM m_users WHERE  `create_time` >= "'.$starttime.'" AND `create_time` < "'.$endtime.'"
                AND openid NOT IN(
                SELECT openid FROM `wx_event_log` WHERE  `create_time` >= "'.$starttime.'" AND `create_time` < "'.$endtime.'"  AND `event_type` = 1
                )';
            }
            $addUsersData = db()->query($sql);

            // 当月新关注的人
            $addUser_data = db('wx_event_log')->where($w1)->where('event_type','1')->select();
            foreach($addUser_data as $k=>$v){
                foreach($v as $k2=>$v2){
                    $addUser_data[$k]['reg_time'] = $addUser_data[$k]['create_time'];
                }
            }
            // 当月新增人
            $addUsersData = array_merge($addUsersData,$addUser_data);

            // 当年新增的会员总数
            $addUsersAll  = count($addUsersData);
            
            // 当年跑路会员数据
            $delUsersData = db('wx_event_log')->where($w1)->where(['event_type'=>0])->distinct('openid')->field('openid,create_time')->select();
            
            // 当年跑路会员总数
            $delUsersAll   = count($delUsersData);
            
            // 当年净增会员总数
            $netGrowthAddUsersAll = $addUsersAll - $delUsersAll;
            
            // 循环数据 新增粉丝的数据2018-09-09
            $addPhoneUsers_month = [];  // 每月的数据总计
            foreach ($addPhoneUsersData as $k=>$v){
                $month = (int)substr($v['create_time'],5,2);
                $addPhoneUsers_month[$month] += 1;
            }
            // 循环数据 新增粉丝的数据 
            $addUsers_day = [];  // 每月的数据总计
            $addOpenidsd   = [];  // 取出新粉丝的openid;
            foreach ($addUsersData as $k=>$v){
                $month = (int)substr($v['create_time'],5,2);
                $addUsers_month[$month] += 1;
                // 存当月关注的用户openid
                $addOpenids[] = $v['openid'];
            }
            
            // 循环数据 跑路粉丝的数据
            $delUsers_month = [];  // 每月的数据总计
            $addUsersToDelAll_month = []; // 存储当月跑路的用户数据
            
            foreach ($delUsersData as $k=>$v){
                $month = (int)substr($v['create_time'],5,2);
                $delUsers_month[$month] += 1;
                // 判断会员是不是当天关注，当天跑路
                if(in_array($v['openid'],$addOpenids)){
                    $addUsersToDelAll_month[$month] +=1;
                }
            
            }
            
            // 统计每天净增量
            $netGrowthAddUsers_month = [];
            for($i=1;$i<=$length;$i++){
                $addPhoneUsers_month[$i] += 0;
                $addUsers_month[$i]     += 0;
                $delUsers_month[$i]     += 0;
                $netGrowthAddUsers_month[$i] = $addUsers_month[$i] - $delUsers_month[$i];
 
            }
            
            // 排序
            ksort($addPhoneUsers_month);
            ksort($addUsers_month);
            ksort($delUsers_month);
            ksort($netGrowthAddUsers_month);

           
            $data =   [
                // 上方展示的总数
                "phoneUsersAllTotal"    => $addPhoneUsersaAll, // 今日新增粉丝总数
                'addUsersAllTotal'      => $addUsersAll,  // 今日新增新增会员总数
                'delUsersAllTotal'      => $delUsersAll,  // 今日新增跑路会员总数
                'netGrowthAddUsersAllTotal'  => $netGrowthAddUsersAll, // 计算会员净增数据
            
                // 统计图用的数据
                'phoneUsersAll'        => implode(',', $addPhoneUsers_month), // 正式会员总数
                'addUsersAll'          => implode(',', $addUsers_month),  // 新增粉丝总数
                'delUsersAll'          => implode(',', $delUsers_month),  // 跑路粉丝总数
                'netGrowthAddUsersAll' => implode(',', $netGrowthAddUsers_month),  // 跑路粉丝总数
            ];
            
        }
        //print_r($data);die;
        return $data;
    }
    
    
 
}