<?php
/**
 * 微信公众号相关设定接口
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Wangyining <Wangyining@suxuantech.cn>  2018-01-18
 */
namespace app\vip\lib;
use app\index\controller\Base;

class WechatSetting extends Base{

    /*获取微信接口调用凭证access_token
     *
     */
    public function getAccessToken(){
        $url="5a60436d631a4";
        //$data = [];
        $data['brandclass_id'] = session('brandid');
        //店配置
        $shopData = isShopMain();
        if(!empty($shopData)){
            $data['shop_code'] = $shopData['shop_code'];
        }
        $res=sx_call($url,$data);
        if($res['code']==200){
            $accessData=$res['data'];
            return $accessData;
        }else{
            return $res;
        }

    }


    /*
     * 自定义菜单
     * @param String  $brandclass_id 品牌id
     * @param String  $content       自定义菜单内容 jons格式
     * 例:
     *  $content='{
             "button":[
             {
                "name": "发图",
                "sub_button": [
                    {
                        "type": "pic_sysphoto",
                        "name": "系统拍照发图",
                        "key": "rselfmenu_1_0",
                       "sub_button": [ ]
                     },
                    {
                        "type": "pic_photo_or_album",
                        "name": "拍照或者相册发图",
                        "key": "rselfmenu_1_1",
                        "sub_button": [ ]
                    },
                    {
                        "type": "pic_weixin",
                        "name": "微信相册发图",
                        "key": "rselfmenu_1_2",
                        "sub_button": [ ]
                    }
                ]
             },
             {
                  "type":"view",
                  "name":"公司简介",
                  "url":"http://www.suxuantech.com/"
             },
             {
                   "name":"菜单",
                   "sub_button":[
                   {
                       "type":"click",
                       "name":"赞一下我们",
                       "key":"V1001_GOOD"
                   }]
             }]
         }';
     *
     */
    public function menuSet($brandclass_id,$content){
        $accessTokenData=$this->getAccessToken();
        if(!$accessTokenData['access_token']){
            return ['errcode'=>$accessTokenData['code'],'errmsg'=>$accessTokenData['msg']];
        }
        $url='https://api.weixin.qq.com/cgi-bin/menu/create?access_token='.$accessTokenData['access_token'];
        $result=http_request($url,'POST',$content);
        $res=json_decode($result['response'],true);
        return $res;
    }

    /*已定义菜单查询
     *@param String  $brandclass_id 品牌id
     */
    public function getMenu($brandclass_id){
        $accessTokenData=controller('WechatSetting','lib')->getAccessToken(array('brandclass_id'=>$brandclass_id));
        $url='https://api.weixin.qq.com/cgi-bin/menu/get?access_token='.$accessTokenData['access_token'];
        $result=http_request($url,'GET');
        $res=json_decode($result['response'],true);
        return $res;

    }


    /*已定义菜单删除
     *@param String  $brandclass_id 品牌id
     */
    public function delMenu($brandclass_id){
        $accessTokenData=controller('WechatSetting','lib')->getAccessToken(array('brandclass_id'=>$brandclass_id));
        $url='https://api.weixin.qq.com/cgi-bin/menu/delete?access_token='.$accessTokenData['access_token'];
        $result=http_request($url,'GET');
        $res=json_decode($result['response'],true);
        return $res;

    }


    /*
    *通过ticket获取二维码
    */
    public function getShowQrCode($param){
        $getTicket=$this->getTicket($param);
        $ticket=$getTicket['ticket'];
        if(!$ticket){
            return array('error'=>1,'code'=>1001,'msg'=>'未获取ticket！');
        }
        return $ticket;
        //$url='https://mp.weixin.qq.com/cgi-bin/showqrcode?ticket='.urlencode($ticket);
        //$result=http_request($url,'GET');
        //$qrCode=$result['response'];
        //echo $qrCode;die;
//        $file ='./public/abc.jpg';
//        file_put_contents($file,$result['response']);
//        $str = "<img src=".$file.">";echo $str;die;


    }

}