<?php

namespace app\vip\model;

class Packageorder extends \think\Model {
        
    /**
     * 套系订单列表
     * 
     * @param  page       页数
     * @param  limit      分页数量
     * @param  order      排序
     * @param  brand_id   事业部id
     *
     * @return array
     * @author lilong
     */
    public function getLimit($param) {
        
        $field = 'o.*,p.package_name';
        $order = 'o.create_time desc';

        //$where['o.is_del'] = 1;
        $where['o.brand_id'] = $param['brand_id'];
        if ($param['pid']) {
            $where['o.p_id'] = $param['pid'];
        }

        $res = db('s_package_order')->alias('o')
            ->join('s_package_info p', 'o.p_id=p.id')
            ->field($field)
            ->where($where)
            ->where('delete_time is null')
            ->order($order)
            ->limit($param['page'], $param['limit'])
            ->select();

        return $res;
    }

    /**
     * 套系列表
     * 
     * @param  brand_id   事业部id
     *
     * @return int
     * @author lilong
     */
    public function getCount($param){
        $field = 'o.*,p.package_name';
        $order = 'o.create_time desc';

        //$where['o.is_del'] = 1;
        $where['o.brand_id'] = $param['brand_id'];
        if ($param['p_id']) {
            $where['o.pid'] = $param['pid'];
        }

        $res = db('s_package_order')->alias('o')
            ->join('s_package_info p', 'o.p_id=p.id')
            ->where($where)
            ->where('delete_time is null')
            ->count();
        return $res;
    }

    /**
     * 套系订单详情
     * 
     * @param  id   套系id
     *
     * @return int
     * @author lilong
     */
    public function getOnePackageorder($param){
        $id = (int)$param['id'];

        $field = 'o.*,p.package_name';

        //$where['o.is_del'] = 1;
        $where['o.id'] = $id;

        $res = db('s_package_order')->alias('o')
            ->join('s_package_info p', 'o.pid=p.id')
            ->field($field)
            ->where($where)
            ->where('delete_time is null')
            ->find();

        return $res;
    }

    /**
     * 新增订单
     * 
     * @param  brand_id   事业部id
     *
     * @return int
     * @author lilong
     */
    public function addPackageorder($param){
        $res = '';
        return $res;
    }

    /**
     * 删除套系
     * 
     * @param  id   套系id
     *
     * @return view
     * @author int
     */
    public function delPackageorder($param){
        $id = (int)$param['id'];

        $data['is_del'] = 2;
        $data['update_time'] = date('Y-m-d H:i:s');

        $res = db('s_order_info')->where('id', $id)->update($data);
        return $res;
    }

    /**
     * 编辑套系
     * 
     * @param  id   套系id 及其他
     *
     * @return int
     * @author lilong
     */
    public function editPackageorder($param){
        $id = (int)$param['id'];
        
        $data['user_name']   = trim($param['user_name']);
        $data['user_tel']    = trim($param['user_tel']);
        $data['user_wechat'] = trim($param['user_wechat']);
        $data['user_address']= trim($param['user_address']);

        $data['update_time'] = date('Y-m-d H:i:s');

        $res = db('s_order_info')->where('id', $id)->update($data);
        return $res;
    }
}

