$(function () {
    //select事件
    (function(){
        $(".dropdown a").on("click",function() {
            $(this).parents(".dropdown").find("ul").toggle();
            $(this).toggleClass("dropdown-up");
        });
        $(".dropdown ul li a").on("click",function() {
            var text = $(this).html();
            $(this).parents(".dropdown").find(".dropdown-span").html(text);
            $(this).parents(".dropdown").find("ul").hide();
            $(".dropdown a").removeClass("dropdown-up");
        });
        $(document).bind('click', function(e) {
            var $clicked = $(e.target);
            if(!$clicked.parents().hasClass("dropdown"))
                $(".dropdown ul").hide();
        });
    })();
    pageInit();
    //表单
    layui.use('form', function () {
        var form = layui.form;
    });
    //日历
    layui.use('laydate', function () {
        var laydate = layui.laydate;
        //单控件
        lay('.test-item').each(function () {
            laydate.render({
                elem: this
                , format: 'yyyyMMdd'
                , value: new Date()
                , trigger: 'click'
            });
        });
        lay('.hour-item').each(function () {
            laydate.render({
                elem: this
                , type: 'time'
                , done: function (value, date, endDate) {
                    console.log(value, date, endDate);
                }
                , change: function (value, date, endDate) {
                    //this.elem.val(value)
                }
            });
        });

    });
    //弹窗
    layui.use('layer', function () {
        var $ = layui.jquery, layer = layui.layer; //独立版的layer无需执行这一句

        //触发事件
        var active = {
            add: function () {
                layer.open({
                    title: '客资登记',
                    type: 1,
                    skin: 'layui-layer-rim',
                    area: ['740px', '550px'],
                    content: $('#add-box'),
                    btn: ['导出', '取消']
                });
            },
            delete: function () {
                layer.confirm('确定删除？', {
                    title: '删除提醒',
                    btn: ['确定', '取消'], //按钮
                    area: ['400px', '176px']
                });
            },
            allot: function () {
                layer.open({
                    title: '客资分配',
                    type: 1,
                    skin: 'layui-layer-rim',
                    area: ['400px', '200px'],
                    content: $('#allot-box'),
                    btn: ['确定', '取消']
                });
            },
            export: function () {
                layer.confirm('确定导出？', {
                    title: '客资导出',
                    btn: ['导出', '取消'], //按钮
                    area: ['400px', '176px']
                });
            },
            import: function () {
                layer.confirm('请按照模板填写您要导入的客户资料，点击<a href="#" style="color: #41a8b4">查看模板</a>。', {
                    title: '客资导入',
                    btn: ['导入客资'], //按钮
                    area: ['400px', '176px']
                });
            },
            detail: function () {
                layer.open({
                    title: '客资详情',
                    type: 1,
                    skin: 'layui-layer-rim',
                    area: ['740px', '550px'],
                    content: $('#kz-detail'),
                    btn: ['确定', '取消']
                });
            },
            flag: function () {
                layer.open({
                    title: '快速标记',
                    type: 1,
                    skin: 'layui-layer-rim',
                    area: ['500px', '362px'],
                    content: $('#quick-flag'),
                    btn: ['保存']
                });
            },
            msgsend: function () {
                layer.open({
                    title: '资源客户即时短信发送',
                    type: 1,
                    skin: 'layui-layer-rim',
                    area: ['500px', '380px'],
                    content: $('#sms-sending'),
                    btn: ['确定', '取消']
                });
            },
            interview: function () {
                layer.open({
                    title: '电访情况',
                    type: 1,
                    skin: 'layui-layer-rim',
                    area: ['400px', '420px'],
                    content: $('#power-interview')
                });
            },
            newCus: function () {
                layer.open({
                    title: '来电显示提醒',
                    type: 1,
                    skin: 'layui-layer-rim',
                    area: ['500px', '380px'],
                    content: $('#new-customer')
                });
            },
            oldCus: function () {
                layer.open({
                    title: '来电显示提醒',
                    type: 1,
                    skin: 'layui-layer-rim',
                    area: ['500px', '500px'],
                    content: $('#old-customer')
                });
            },
            cusMsg: function () {
                layer.open({
                    offset: 'rb',
                    title: '客户信息',
                    type: 1,
                    skin: 'layui-layer-rim',
                    area: ['500px', '436px'],
                    content: $('#customer-sms')
                });
            }
        };
        $('.cus-model-btn').on('click', function () {
            var type = $(this).data('type');
            active[type] ? active[type].call(this) : '';
            $(this).addClass("active").siblings(".cus-model-btn").removeClass("active");
            if (type == "allot") {
                $("#allot-box").parent().css("overflow", "inherit");
            }
        });
        //鼠标双击事件
        $('.ui-jqgrid-btable').delegate("tr", "dblclick", function () {
            active["detail"] ? active["detail"].call(this) : '';
        });
        //    鼠标右击事件
        $('.ui-jqgrid-btable').contextPopup({
            //title: 'My Popup Menu',
            items: [
                {
                    label: '追踪', icon: 'img/mr_menu01.png', action: function () {
                    active["interview"] ? active["interview"].call(this) : '';
                }
                },
                {
                    label: '标记', icon: 'img/mr_menu02.png', action: function () {
                    active["flag"] ? active["flag"].call(this) : '';
                }
                },
                {
                    label: '客资分配', icon: 'img/mr_menu01.png', action: function () {
                    active["allot"] ? active["allot"].call(this) : '';
                }
                },
                {
                    label: '追踪记录', icon: 'img/mr_menu03.png', action: function () {
                    active["cusMsg"] ? active["cusMsg"].call(this) : '';
                }
                },
                null, // divider
                {
                    label: '新建', icon: 'img/mr_menu04.png', action: function () {
                    active["add"] ? active["add"].call(this) : '';
                }
                },
                {
                    label: '修改', icon: 'img/mr_menu05.png', action: function () {
                    active["detail"] ? active["detail"].call(this) : '';
                }
                },
                {
                    label: '删除', icon: 'img/mr_menu06.png', action: function () {
                    active["delete"] ? active["delete"].call(this) : '';
                }
                },
                null, // divider
                {
                    label: '导入', icon: 'img/mr_menu07.png', action: function () {
                    active["import"] ? active["import"].call(this) : '';
                }
                },
                {
                    label: '导出', icon: 'img/mr_menu08.png', action: function () {
                    active["export"] ? active["export"].call(this) : '';
                }
                }
            ]
        });
    });
    //选项卡
    layui.use('element', function () {
        var element = layui.element;
    });

//    滚动条问题
    $(".layui-layer-content").scroll(function(){
        console.log(1);
        $("body").preventDefault();
    })


//   筛选条件添加
    layui.use('form', function(){
        var form = layui.form;
        var name1,name2;
        form.on('select(choose01)', function(data){
            name1=data.value;
        });
        form.on('select(choose02)', function(data){
            name2=data.value;
            var filterwrap='<div class="filter-wrap"><span class="filter-text">'+name1+'：'+name2+'</span><span class="cus-close">&times;</span></div>';
            $(".cus-filter").append(filterwrap);
        });

    //    删除筛选条件
        $('.cus-close').live("click",function(){
            $(this).parent().remove();
        })
    });



});
function pageInit() {
    //创建jqGrid组件
    jQuery("#Example").jqGrid(
        {
            url: 'data/JSONData.json',//组件创建完成之后请求数据的url
            datatype: "json",//请求数据返回的类型。可选json,xml,txt
            colNames: ['Inv No', 'Date', 'Client', 'Amount', 'Tax', 'Total', 'Notes', '我'],//jqGrid的列显示名字
            colModel: [ //jqGrid每一列的配置信息。包括名字，索引，宽度,对齐方式.....
                {
                    name: 'id',
                    index: 'id',
                    //width: 55,
                    frozen: true,
                    search: true,
                    hidedlg: true,
                    stype: 'select',
                    searchoptions: {dataUrl: './select/module', sopt: ['eq', 'ne']},
                    editoptions: {readonly: true, size: 10}
                }, //列冻结 frozen : true
                {
                    name: 'invdate',
                    index: 'invdate',
                    //width: 90,
                    frozen: true,
                    editable: true,
                    editoptions: {size: 10},
                    search: true,
                    stype: 'select',
                    searchoptions: {
                        value: " :[All];ALFKI:ALFKI;ANATR:ANATR;ANTON:ANTON;AROUT:AROUT;BERGS:BERGS;BLAUS:BLAUS;BLONP:BLONP;BOLID:BOLID;BONAP:BONAP;BOTTM:BOTTM;BSBEV:BSBEV;CACTU:CACTU;CENTC:CENTC;CHOPS:CHOPS;COMMI:COMMI;CONSH:CONSH;DRACD:DRACD;DUMON:DUMON;EASTC:EASTC;ERNSH:ERNSH;FAMIA:FAMIA;FOLIG:FOLIG;FOLKO:FOLKO;FRANK:FRANK;FRANR:FRANR;FRANS:FRANS;FURIB:FURIB;GALED:GALED;GODOS:GODOS;GOURL:GOURL;GREAL:GREAL;GROSR:GROSR;HANAR:HANAR;HILAA:HILAA;HUNGC:HUNGC;HUNGO:HUNGO;ISLAT:ISLAT;KOENE:KOENE;LACOR:LACOR;LAMAI:LAMAI;LAUGB:LAUGB;LAZYK:LAZYK;LEHMS:LEHMS;LETSS:LETSS;LILAS:LILAS;LINOD:LINOD;LONEP:LONEP;MAGAA:MAGAA;MAISD:MAISD;MEREP:MEREP;MORGK:MORGK;NORTS:NORTS;OCEAN:OCEAN;OLDWO:OLDWO;OTTIK:OTTIK;PERIC:PERIC;PICCO:PICCO;PRINI:PRINI;QUEDE:QUEDE;QUEEN:QUEEN;QUICK:QUICK;RANCH:RANCH;RATTC:RATTC;REGGC:REGGC;RICAR:RICAR;RICSU:RICSU;ROMEY:ROMEY;SANTG:SANTG;SAVEA:SAVEA;SEVES:SEVES;SIMOB:SIMOB;SPECD:SPECD;SPLIR:SPLIR;SUPRD:SUPRD;THEBI:THEBI;THECR:THECR;TOMSP:TOMSP;TORTU:TORTU;TRADH:TRADH;TRAIH:TRAIH;VAFFE:VAFFE;VICTE:VICTE;VINET:VINET;WANDK:WANDK;WARTH:WARTH;WELLI:WELLI;WHITC:WHITC;WILMK:WILMK;WOLZA:WOLZA"
                    }
                },
                {name: 'name', index: 'name asc, invdate', width: 100, editable: true, editoptions: {size: 25}},
                {name: 'amount', index: 'amount', width: 80, align: "right", editoptions: {readonly: true, size: 10}},
                {
                    name: 'tax',
                    index: 'tax',
                    //width: 80,
                    align: "right",
                    editable: true,
                    edittype: "checkbox",
                    editoptions: {value: "Yes:No"}
                },
                {name: 'total', index: 'total', width: 80, align: "right", editable: true, editoptions: {size: 10}},
                {
                    name: 'note',
                    index: 'note',
                    //width: 150,
                    editable: true,
                    edittype: "textarea",
                    editoptions: {rows: "2", cols: "20"}
                },

                {name: '我', index: 'total', align: "right", editoptions: {readonly: true, size: 10}}
            ],
            height: 500,//默认高度
            width: "100%",//默认宽度
            autowidth:true,
            rowNum: 10,//一页显示多少条
            rowList: [10, 20, 30],//可供用户选择一页显示多少条
            pager: '#pager',//表格页脚的占位符(一般是div)的id
            sortname: 'id',//初始化的时候排序的字段
            sortorder: "desc",//排序方式,可选desc,asc
            mtype: "post",//向后台请求数据的ajax的类型。可选post,get
            viewrecords: true,
            multiselect : true,//tr行多选
            sortable: true//列排序
            //caption: "table Example"//表格的标题名字
            //editurl : ctx+"/RowEditing"
        });
    /*创建jqGrid的操作按钮容器*/
    jQuery("#Example").jqGrid('gridResize', {minWidth: 350, maxWidth: 1130, minHeight: 80, maxHeight: 650});//grid改变大小
    //jQuery("#Example").jqGrid('setFrozenColumns');//冻结列,与列排序sortable冲突

    jQuery("#Example").jqGrid('navGrid', '#pager', //列表底部 新增，编辑，删除
        {}, //options
        {height: 300, reloadAfterSubmit: false}, // edit options
        {height: 300, reloadAfterSubmit: false}, // add options
        {reloadAfterSubmit: false}, // del options
        {}// search options
    );
    jQuery("#Example").jqGrid('navButtonAdd', '#pager', {//列选择
        caption: "Columns",
        title: "Reorder Columns",
        onClickButton: function () {
            jQuery("#Example").jqGrid('columnChooser');
        }
    });

    jQuery("#Example").jqGrid('filterToolbar', {
        //searchOperators : true
    });

}
