/*
Navicat MySQL Data Transfer

Source Server         : 127.0.0.1
Source Server Version : 50719
Source Host           : 127.0.0.1:3306
Source Database       : sx_vip_child

Target Server Type    : MYSQL
Target Server Version : 50719
File Encoding         : 65001

Date: 2019-08-08 10:05:31
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for action_log
-- ----------------------------
DROP TABLE IF EXISTS `action_log`;
CREATE TABLE `action_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `old_score` int(11) DEFAULT NULL,
  `new_score` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `brand_id` int(11) DEFAULT NULL,
  `staff_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `old_level_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `new_level_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `up_time` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=102 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of action_log
-- ----------------------------

-- ----------------------------
-- Table structure for advertising
-- ----------------------------
DROP TABLE IF EXISTS `advertising`;
CREATE TABLE `advertising` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//广告位id',
  `adv_name` varchar(100) CHARACTER SET utf8 DEFAULT '' COMMENT '//广告位名称',
  `adv_img` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '//广告位头像',
  `adv_count` varchar(255) CHARACTER SET utf8 DEFAULT '' COMMENT '//广告位描述',
  `adv_status` int(5) DEFAULT '0' COMMENT '//当前广告使用状态',
  `adv_staff` int(11) DEFAULT '0' COMMENT '//添加当前广告员工',
  `adv_cause` int(11) DEFAULT '0' COMMENT '//所属事业部',
  `create_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//广告添加时间',
  `adv_seat` int(11) DEFAULT '0' COMMENT '//广告位投放位置说明 1DIY 2是任务大厅 3是我的任务 4推荐新人 5是推荐新人列表\r\n1 首页上方 2 首页下方 3积分商城 4优惠卷 5粉丝日 6会员活动 7我的订单',
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  `adv_detail` text COLLATE utf8_unicode_ci COMMENT '广告js',
  `adv_typeid` tinyint(2) DEFAULT NULL COMMENT '广告类型1是普通广告，2是轮播广告',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=193 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of advertising
-- ----------------------------

-- ----------------------------
-- Table structure for api_app
-- ----------------------------
DROP TABLE IF EXISTS `api_app`;
CREATE TABLE `api_app` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `app_id` varchar(50) NOT NULL DEFAULT '' COMMENT '应用id',
  `app_secret` varchar(50) NOT NULL DEFAULT '' COMMENT '应用密码',
  `app_name` varchar(50) NOT NULL DEFAULT '' COMMENT '应用名称',
  `app_status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '应用状态：0表示禁用，1表示启用',
  `app_type` tinyint(2) NOT NULL DEFAULT '1' COMMENT '应用类型',
  `app_info` tinytext NOT NULL COMMENT '应用说明',
  PRIMARY KEY (`id`),
  UNIQUE KEY `app_id` (`app_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='appId和appSecret表';

-- ----------------------------
-- Records of api_app
-- ----------------------------
INSERT INTO api_app VALUES ('3', '94201193', 'DCGJduSGIceYUFNtWloBzzXhShXERsqH', '管理中心APP', '1', '1', '');
INSERT INTO api_app VALUES ('4', '44793168', 'oUWKYeqCEojOvbmsynvWTctJSAVeoMZv', '客资系统', '1', '1', '客资CRM系统');
INSERT INTO api_app VALUES ('5', '64255735', 'GjnkCcPgSjDXwRaruVAzcyCEJfloMtee', 'ERP系统', '1', '1', '');


-- ----------------------------
-- Table structure for api_auth_group
-- ----------------------------
DROP TABLE IF EXISTS `api_auth_group`;
CREATE TABLE `api_auth_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `description` varchar(5) COLLATE utf8_unicode_ci DEFAULT '',
  `status` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of api_auth_group
-- ----------------------------

-- ----------------------------
-- Table structure for api_auth_group_access
-- ----------------------------
DROP TABLE IF EXISTS `api_auth_group_access`;
CREATE TABLE `api_auth_group_access` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` mediumint(8) DEFAULT '0',
  `groupId` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of api_auth_group_access
-- ----------------------------

-- ----------------------------
-- Table structure for api_auth_rule
-- ----------------------------
DROP TABLE IF EXISTS `api_auth_rule`;
CREATE TABLE `api_auth_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `url` varchar(80) COLLATE utf8_unicode_ci DEFAULT '',
  `groupId` int(11) DEFAULT '0',
  `auth` int(11) DEFAULT '0',
  `status` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of api_auth_rule
-- ----------------------------

-- ----------------------------
-- Table structure for api_fields
-- ----------------------------
DROP TABLE IF EXISTS `api_fields`;
CREATE TABLE `api_fields` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `fieldName` varchar(50) NOT NULL DEFAULT '' COMMENT '字段名称',
  `hash` varchar(50) NOT NULL DEFAULT '' COMMENT '对应接口的唯一标识',
  `dataType` tinyint(2) NOT NULL DEFAULT '0' COMMENT '数据类型，来源于DataType类库',
  `default` varchar(500) NOT NULL DEFAULT '' COMMENT '默认值',
  `isMust` tinyint(2) NOT NULL DEFAULT '0' COMMENT '是否必须 0为不必须，1为必须',
  `range` varchar(500) NOT NULL DEFAULT '' COMMENT '范围，Json字符串，根据数据类型有不一样的含义',
  `info` varchar(500) NOT NULL DEFAULT '' COMMENT '字段说明',
  `type` tinyint(2) NOT NULL DEFAULT '0' COMMENT '字段用处：0为request，1为response',
  `showName` varchar(50) NOT NULL DEFAULT '' COMMENT 'wiki显示用字段',
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=149 DEFAULT CHARSET=utf8 COMMENT='用于保存各个API的字段规则';

-- ----------------------------
-- Records of api_fields
-- ----------------------------
INSERT INTO api_fields VALUES ('1', 'aaa', '', '8', '123123', '1', 'fsdf', 'sf', '0', 'aaa');
INSERT INTO api_fields VALUES ('2', 'sdf', '', '1', 'asdf', '1', '', '', '0', 'sdf');
INSERT INTO api_fields VALUES ('3', '123', '', '1', '`12', '1', '`12', '', '0', '123');
INSERT INTO api_fields VALUES ('10', 'ergerger', '59ea0cd052201', '1', '324234', '0', '2342342', '34234', '1', 'ergerger');
INSERT INTO api_fields VALUES ('11', 'username', '59eb02fb401b1', '2', '', '1', 'test', '我是说明\n', '0', 'username');
INSERT INTO api_fields VALUES ('12', 'password', '59eb02fb401b1', '2', '', '1', '', '密码', '0', 'password');
INSERT INTO api_fields VALUES ('13', 'username', '59eb2c9d9b723', '2', '', '1', '', '用于登录的用户名，可以是手机号，或staff表内的登录名。', '0', 'username');
INSERT INTO api_fields VALUES ('14', 'password', '59eb2c9d9b723', '2', '', '1', '', '登录密码', '0', 'password');
INSERT INTO api_fields VALUES ('16', 'code', '59eb2c9d9b723', '1', '200', '1', '', '返回200表示成功。其他为失败', '1', 'code');
INSERT INTO api_fields VALUES ('17', 'staffid', '59eb382d6af16', '1', '', '1', '', '', '0', 'staffid');
INSERT INTO api_fields VALUES ('18', 'username', '59ec9360b6861', '2', '', '1', '', '用户名', '0', 'username');
INSERT INTO api_fields VALUES ('19', 'password', '59ec9360b6861', '2', '', '1', '', 'password', '0', 'password');
INSERT INTO api_fields VALUES ('20', 'username', '59f15d141e7e2', '2', '', '1', '', '', '0', 'username');
INSERT INTO api_fields VALUES ('21', 'oldpwd', '59f15d141e7e2', '2', '', '1', '', '', '0', 'oldpwd');
INSERT INTO api_fields VALUES ('22', 'newpwd', '59f15d141e7e2', '2', '', '1', '', '新密码', '0', 'newpwd');
INSERT INTO api_fields VALUES ('31', 'abc', '59f83a849c87d', '7', '', '1', '123', '456', '0', 'abc');
INSERT INTO api_fields VALUES ('48', 'test2', '5a4df22370da2', '2', '', '1', '', 'adfasdf', '0', 'test2');
INSERT INTO api_fields VALUES ('49', 'tel', '5a4dfeae25990', '2', '', '1', '', '用户手机号', '0', 'tel');
INSERT INTO api_fields VALUES ('50', 'brandid', '5a4dfc37a4318', '1', '0', '1', '', '品牌id或者叫事业部id，必填', '0', 'brandid');
INSERT INTO api_fields VALUES ('51', 'brand_id', '5a4dfeae25990', '1', '0', '1', '', '事业部id', '0', 'brand_id');
INSERT INTO api_fields VALUES ('52', 'tel', '5a4e02a78f110', '2', '', '1', '', '用户手机号', '0', 'tel');
INSERT INTO api_fields VALUES ('53', 'brand_id', '5a4e02a78f110', '1', '0', '1', '', '事业部id', '0', 'brand_id');
INSERT INTO api_fields VALUES ('54', 'order_code', '5a4e02a78f110', '2', '', '1', '', '订单号', '0', 'order_code');
INSERT INTO api_fields VALUES ('55', 'one_money', '5a4e02a78f110', '1', '0', '1', '', '一销金额', '0', 'one_money');
INSERT INTO api_fields VALUES ('56', 'two_money', '5a4e02a78f110', '1', '0', '1', '', '二销金额', '0', 'two_money');
INSERT INTO api_fields VALUES ('57', 'one_detail', '5a4e02a78f110', '1', '0', '1', '', '一销明细', '0', 'one_detail');
INSERT INTO api_fields VALUES ('58', 'two_detail', '5a4e02a78f110', '1', '0', '1', '', '二销明细', '0', 'two_detail');
INSERT INTO api_fields VALUES ('59', 'order_time', '5a4e02a78f110', '2', '', '1', '', '订单时间', '0', 'order_time');
INSERT INTO api_fields VALUES ('60', 'phone', '5a4dfc37a4318', '2', '', '1', '', '手机号码必须填写', '0', 'phone');
INSERT INTO api_fields VALUES ('61', 'couponcode', '5a4dfc37a4318', '2', '', '1', '', '输入优惠券码', '0', 'couponcode');
INSERT INTO api_fields VALUES ('62', 'checkuser', '5a4dfc37a4318', '2', '', '1', '', '操作人的名称', '0', 'checkuser');
INSERT INTO api_fields VALUES ('64', 'money', '5a5193acf18d8', '1', '', '1', '', '充值金额', '0', 'money');
INSERT INTO api_fields VALUES ('65', 'pay_money', '5a51eef9e0b50', '1', '', '1', '', '扣款金额', '0', 'pay_money');
INSERT INTO api_fields VALUES ('66', 'code', '5a51eef9e0b50', '2', '', '1', '', '支付二维码串码', '0', 'code');
INSERT INTO api_fields VALUES ('67', 'user_id', '5a51eef9e0b50', '1', '', '1', '', '当前员工id', '0', 'user_id');
INSERT INTO api_fields VALUES ('68', 'tel', '5a530aad88798', '2', '', '1', '', '用户电话', '0', 'tel');
INSERT INTO api_fields VALUES ('69', 'brand_id', '5a530aad88798', '1', '', '1', '', '事业部id', '0', 'brand_id');
INSERT INTO api_fields VALUES ('70', 'tel', '5a530b4e66c88', '2', '', '1', '', '用户电话', '0', 'tel');
INSERT INTO api_fields VALUES ('71', 'user_code', '5a530b4e66c88', '2', '', '1', '', '当前会员卡号码', '0', 'user_code');
INSERT INTO api_fields VALUES ('72', 'brand_id', '5a530b4e66c88', '1', '', '1', '', '事业部id', '0', 'brand_id');
INSERT INTO api_fields VALUES ('73', 'tel', '5a530bceb7980', '2', '', '1', '', '用户电话', '0', 'tel');
INSERT INTO api_fields VALUES ('74', 'user_code', '5a530bceb7980', '2', '', '1', '', '会员卡号码', '0', 'user_code');
INSERT INTO api_fields VALUES ('75', 'brand_id', '5a530bceb7980', '1', '', '1', '', '事业部id', '0', 'brand_id');
INSERT INTO api_fields VALUES ('76', 'day', '5a530bceb7980', '1', '', '1', '', '延长多少天', '0', 'day');
INSERT INTO api_fields VALUES ('77', 'tel', '5a530cdf0a7f8', '2', '', '1', '', '用户电话', '0', 'tel');
INSERT INTO api_fields VALUES ('78', 'user_code', '5a530cdf0a7f8', '2', '', '1', '', '会员卡号码', '0', 'user_code');
INSERT INTO api_fields VALUES ('79', 'brand_id', '5a530cdf0a7f8', '1', '', '1', '', '事业部id', '0', 'brand_id');
INSERT INTO api_fields VALUES ('80', 'money', '5a530cdf0a7f8', '1', '', '1', '', '扣除金额', '0', 'money');
INSERT INTO api_fields VALUES ('81', 'staff_name', '5a530cdf0a7f8', '2', '', '1', '', '员工名称', '0', 'staff_name');
INSERT INTO api_fields VALUES ('82', 'staff_number', '5a530cdf0a7f8', '2', '', '1', '', '员工编号', '0', 'staff_number');
INSERT INTO api_fields VALUES ('83', 'order_code', '5a530cdf0a7f8', '2', '', '1', '', '订单编号', '0', 'order_code');
INSERT INTO api_fields VALUES ('84', 'order_title', '5a530cdf0a7f8', '2', '', '1', '', '该订单简标题', '0', 'order_title');
INSERT INTO api_fields VALUES ('85', 'phone', '5a5193acf18d8', '1', '', '1', '', '用户电话', '0', 'phone');
INSERT INTO api_fields VALUES ('86', 'shop_name', '5a5193acf18d8', '2', '', '1', '', '充值店面', '0', 'shop_name');
INSERT INTO api_fields VALUES ('87', 'brand_id', '5a5193acf18d8', '1', '', '1', '', '事业部id', '0', 'brand_id');
INSERT INTO api_fields VALUES ('88', 'staff_name', '5a5193acf18d8', '2', '', '1', '', '充值员工', '0', 'staff_name');
INSERT INTO api_fields VALUES ('89', 'shop_name', '5a51eef9e0b50', '1', '', '1', '', '扣款店面', '0', 'shop_name');
INSERT INTO api_fields VALUES ('90', 'brand_id', '5a51eef9e0b50', '1', '', '1', '', '事业部id', '0', 'brand_id');
INSERT INTO api_fields VALUES ('91', 'staff_name', '5a51eef9e0b50', '2', '', '1', '', '员工名称', '0', 'staff_name');
INSERT INTO api_fields VALUES ('92', 'order_code', '5a51eef9e0b50', '2', '', '1', '', '消费单号', '0', 'order_code');
INSERT INTO api_fields VALUES ('93', 'staff_name', '5a56f074ad188', '2', '', '1', '', '当前需要查询的员工姓名', '0', 'staff_name');
INSERT INTO api_fields VALUES ('94', 'brand_id', '5a56f074ad188', '1', '', '1', '', '事业部id', '0', 'brand_id');
INSERT INTO api_fields VALUES ('95', 'shop_name', '5a56f074ad188', '2', '', '1', '', '门店名称', '0', 'shop_name');
INSERT INTO api_fields VALUES ('96', 'shop_name', '5a56f9c6831a8', '2', '', '1', '', '查询门店', '0', 'shop_name');
INSERT INTO api_fields VALUES ('97', 'phone', '5a56f9c6831a8', '2', '', '1', '', '查询会员电话', '0', 'phone');
INSERT INTO api_fields VALUES ('98', 'brand_id', '5a56f9c6831a8', '1', '', '1', '', '事业部id', '0', 'brand_id');
INSERT INTO api_fields VALUES ('99', 'shop_name', '5a530cdf0a7f8', '2', '', '1', '', '消费门店', '0', 'shop_name');
INSERT INTO api_fields VALUES ('100', 'phone', '5a570f481c908', '2', '', '1', '', '用户电话', '0', 'phone');
INSERT INTO api_fields VALUES ('101', 'shop_name', '5a570f481c908', '2', '', '1', '', '门店名称', '0', 'shop_name');
INSERT INTO api_fields VALUES ('102', 'brand_id', '5a570f481c908', '1', '', '1', '', '事业部id', '0', 'brand_id');
INSERT INTO api_fields VALUES ('103', 'card_code', '5a570f481c908', '2', '', '1', '', '要查询的卡号', '0', 'card_code');
INSERT INTO api_fields VALUES ('104', 'code_password', '5a530cdf0a7f8', '2', '', '1', '', '会员卡密码', '0', 'code_password');
INSERT INTO api_fields VALUES ('105', 'total_money', '5a4e02a78f110', '2', '', '1', '', '总金额', '0', 'total_money');
INSERT INTO api_fields VALUES ('106', 'package_name', '5a4e02a78f110', '2', '', '1', '', '套系名称', '0', 'package_name');
INSERT INTO api_fields VALUES ('107', 'phone', '5c492daeb7408', '2', '', '1', '', '订单手机号', '0', 'phone');
INSERT INTO api_fields VALUES ('108', 'from_phone', '5c492daeb7408', '2', '', '1', '', '推荐人手机号', '0', 'from_phone');
INSERT INTO api_fields VALUES ('109', 'brandid', '5c492daeb7408', '2', '', '1', '', '事业部id', '0', 'brandid');
INSERT INTO api_fields VALUES ('110', 'order_no', '5c6271195f758', '2', '', '1', '', '支付流水号', '0', 'order_no');
INSERT INTO api_fields VALUES ('111', 'pay_status', '5c6271195f758', '2', '', '1', '', '支付状态', '0', 'pay_status');
INSERT INTO api_fields VALUES ('112', 'pay_fee', '5c6271195f758', '2', '', '1', '', '支付金额', '0', 'pay_fee');
INSERT INTO api_fields VALUES ('113', 'order_no', '5c74f15751c98', '2', '', '1', '', '支付流水号', '0', 'order_no');
INSERT INTO api_fields VALUES ('114', 'pay_status', '5c74f15751c98', '2', '', '1', '', '支付状态', '0', 'pay_status');
INSERT INTO api_fields VALUES ('115', 'pay_fee', '5c74f15751c98', '2', '', '1', '', '支付金额', '0', 'pay_fee');
INSERT INTO api_fields VALUES ('116', 'attach', '5c74f15751c98', '2', '', '1', '', '区分订单类型', '0', 'pay_fee');
INSERT INTO api_fields VALUES ('120', 'order_number', '5c998876e0830', '2', '', '1', '', '订单号', '0', 'order_number');
INSERT INTO api_fields VALUES ('121', 'phone', '5c998876e0830', '2', '', '1', '', '用户开单手机号，若男士手机号女士手机号都存在，以女士手机号为主', '0', 'phone');
INSERT INTO api_fields VALUES ('122', 'order_no', '5c9c6e01550f0', '2', '', '1', '', '支付流水号', '0', 'order_no');
INSERT INTO api_fields VALUES ('123', 'pay_status', '5c9c6e01550f0', '2', '', '1', '', '支付状态', '0', 'pay_status');
INSERT INTO api_fields VALUES ('124', 'pay_fee', '5c9c6e01550f0', '2', '', '1', '', '支付金额', '0', 'pay_fee');
INSERT INTO api_fields VALUES ('125', 'tel', '5cd8c419df958', '2', '', '1', '', '手机号', '0', 'tel');
INSERT INTO api_fields VALUES ('126', 'order_code', '5cd8c419df958', '2', '', '1', '', '订单编号', '0', 'order_code');
INSERT INTO api_fields VALUES ('127', 'brand_id', '5cd8c419df958', '1', '', '1', '', '事业部id', '0', 'brand_id');
INSERT INTO api_fields VALUES ('128', 'package_name', '5cd8c419df958', '2', '', '1', '', '套系名称', '0', 'package_name');
INSERT INTO api_fields VALUES ('129', 'one_money', '5cd8c419df958', '2', '', '1', '', '一销应付金额', '0', 'one_money');
INSERT INTO api_fields VALUES ('130', 'two_money', '5cd8c419df958', '2', '', '1', '', '二销应付金额', '0', 'two_money');
INSERT INTO api_fields VALUES ('131', 'one_detail', '5cd8c419df958', '2', '', '1', '', '一销实付', '0', 'one_detail');
INSERT INTO api_fields VALUES ('132', 'two_detail', '5cd8c419df958', '2', '', '1', '', '二销实付', '0', 'two_detail');
INSERT INTO api_fields VALUES ('133', 'total_money', '5cd8c419df958', '2', '', '1', '', '总金额', '0', 'total_money');
INSERT INTO api_fields VALUES ('134', 'order_time', '5cd8c419df958', '2', '', '1', '', '订单时间', '0', 'order_time');
INSERT INTO api_fields VALUES ('135', 'tel', '5cd8cf0c5a870', '2', '', '1', '', '手机号（女士为先）', '0', 'tel');
INSERT INTO api_fields VALUES ('136', 'order_code', '5cd8cf0c5a870', '2', '', '1', '', '订单编号', '0', 'order_code');
INSERT INTO api_fields VALUES ('137', 'brand_id', '5cd8cf0c5a870', '1', '', '1', '', '事业部id', '0', 'brand_id');
INSERT INTO api_fields VALUES ('138', 'one_money', '5cd8cf0c5a870', '2', '', '1', '', '一销应付金额', '0', 'one_money');
INSERT INTO api_fields VALUES ('139', 'two_money', '5cd8cf0c5a870', '2', '', '1', '', '二销应付金额', '0', 'two_money');
INSERT INTO api_fields VALUES ('140', 'one_detail', '5cd8cf0c5a870', '2', '', '1', '', '一销实付', '0', 'one_detail');
INSERT INTO api_fields VALUES ('141', 'two_detail', '5cd8cf0c5a870', '2', '', '1', '', '二销实付', '0', 'two_detail');
INSERT INTO api_fields VALUES ('142', 'total_money', '5cd8cf0c5a870', '2', '', '1', '', '订单总金额', '0', 'total_money');
INSERT INTO api_fields VALUES ('143', 'package_name', '5cd8cf0c5a870', '2', '', '1', '', '套系名称', '0', 'package_name');
INSERT INTO api_fields VALUES ('144', 'order_time', '5cd8cf0c5a870', '2', '', '1', '', '订单时间', '0', 'order_time');
INSERT INTO api_fields VALUES ('145', 'brand_id', '5c998876e0830', '1', '', '1', '', '事业部id', '0', 'brand_id');
INSERT INTO api_fields VALUES ('146', ' order_no', '5cd954ce63510', '2', '', '1', '', '支付单号', '0', ' order_no');
INSERT INTO api_fields VALUES ('147', 'pay_status', '5cd954ce63510', '2', '', '1', '', '支付状态。PAYED为支付成功', '0', 'pay_status');
INSERT INTO api_fields VALUES ('148', 'pay_fee', '5cd954ce63510', '2', '', '1', '', '支付金额（单位分）', '0', 'pay_fee');
INSERT INTO api_fields VALUES ('149', 'phone', '5d4d2cbb7f710', '2', '', '1', '', '更换的新手机号', '0', 'phone');
INSERT INTO api_fields VALUES ('150', 'order_number', '5d4d2cbb7f710', '2', '', '1', '', '订单号', '0', 'order_number');
INSERT INTO api_fields VALUES ('152', 'orderId', '5d68f33396190', '2', '', '1', '', '订单号', '0', 'orderId');
INSERT INTO api_fields VALUES ('153', 'fc', '5d68f33396190', '2', '', '1', '', '服次', '0', 'fc');


-- ----------------------------
-- Table structure for api_list
-- ----------------------------
DROP TABLE IF EXISTS `api_list`;
CREATE TABLE `api_list` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `apiName` varchar(50) NOT NULL DEFAULT '' COMMENT 'api索引，保存了类和方法',
  `apiUrl` varchar(50) DEFAULT NULL,
  `app_id` int(11) NOT NULL DEFAULT '0' COMMENT '应用ID',
  `hash` varchar(50) NOT NULL DEFAULT '' COMMENT 'api唯一标识',
  `accessToken` tinyint(2) NOT NULL DEFAULT '1' COMMENT '是否需要认证AccessToken 1：需要，0：不需要',
  `needLogin` tinyint(2) NOT NULL DEFAULT '1' COMMENT '是否需要认证用户token  1：需要 0：不需要',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT 'API状态：0表示禁用，1表示启用',
  `method` tinyint(2) NOT NULL DEFAULT '2' COMMENT '请求方式0：不限1：Post，2：Get',
  `info` varchar(500) NOT NULL DEFAULT '' COMMENT 'api中文说明',
  `isTest` tinyint(2) NOT NULL DEFAULT '0' COMMENT '是否是测试模式：0:生产模式，1：测试模式',
  `returnStr` text COMMENT '返回数据示例',
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8 COMMENT='用于维护接口信息';

-- ----------------------------
-- Records of api_list
-- ----------------------------
INSERT INTO api_list VALUES ('15', '测试接口', 'Test/testApi', '4', '5a4df22370da2', '1', '0', '1', '1', '', '0', null);
INSERT INTO api_list VALUES ('16', '优惠券核销', 'User/useCoupon', '5', '5a4dfc37a4318', '1', '0', '1', '1', '优惠券核销操作', '1', null);
INSERT INTO api_list VALUES ('17', '验证ERP会员等级', 'Port/popUserGrade', '5', '5a4dfeae25990', '1', '0', '1', '1', '验证是否是会员并反回等级与折扣信息', '0', null);
INSERT INTO api_list VALUES ('18', 'ERP下单后自动成为会员接口', 'Port/defaultVip', '5', '5a4e02a78f110', '1', '0', '1', '1', 'ERP会员自动转为会员', '0', null);
INSERT INTO api_list VALUES ('19', '会员线下充值', 'Port/popMoney', '5', '5a5193acf18d8', '1', '0', '1', '1', '会员充值接口', '0', null);
INSERT INTO api_list VALUES ('20', '会员扣款', 'Port/codePay', '5', '5a51eef9e0b50', '1', '0', '1', '1', '会员支付码扣款', '0', null);
INSERT INTO api_list VALUES ('21', '获取当前用户名下所有卡信息', 'Port/userCardList', '5', '5a530aad88798', '1', '0', '1', '1', '获取当前会员下的所有卡信息', '0', null);
INSERT INTO api_list VALUES ('22', '获取当前单张卡片的余额', 'Port/cardOneBalance', '5', '5a530b4e66c88', '1', '0', '1', '1', '获取单卡余额', '0', null);
INSERT INTO api_list VALUES ('23', '延长有效期', 'Port/extendTime', '5', '5a530bceb7980', '1', '0', '1', '1', '延长会员卡的有效期', '0', null);
INSERT INTO api_list VALUES ('24', '会员使用帐号密码扣款', 'Port/cardDebit', '5', '5a530cdf0a7f8', '1', '0', '1', '1', '使用帐号密码扣款', '0', null);
INSERT INTO api_list VALUES ('25', '充值记录查询接口', 'Port/popMoneyRecord', '5', '5a56f074ad188', '1', '0', '1', '1', '调用会员储值记录接口', '0', null);
INSERT INTO api_list VALUES ('26', '会员在门店消费记录查询', 'Port/codePayRecord', '5', '5a56f9c6831a8', '1', '0', '1', '1', '会员扫码支付查询', '0', null);
INSERT INTO api_list VALUES ('27', '储值卡消费记录', 'Port/cardDebitRecord', '5', '5a570f481c908', '1', '0', '1', '1', '通过会员卡支付查询', '0', null);
INSERT INTO api_list VALUES ('28', 'erp绑定推荐人接口', 'Port/recommendPhone', '5', '5c492daeb7408', '0', '0', '1', '1', 'erp绑定推荐人接口', '0', null);
INSERT INTO api_list VALUES ('29', '支付回调通知并且erp开单', 'Order/setErpOrder', '5', '5c6271195f758', '0', '0', '1', '1', '支付回调通知并且erp开单', '0', null);
INSERT INTO api_list VALUES ('30', '更改上门拍活动报名订单状态', 'Order/activeSmp', '3', '5c6a55901adb0', '0', '0', '1', '1', '', '0', null);
INSERT INTO api_list VALUES ('31', '更改99会员订单状态,得到会员权益', 'Order/jgqVip', '5', '5c74f15751c98', '0', '0', '1', '1', '更改99会员订单状态,得到会员权益', '0', null);
INSERT INTO api_list VALUES ('32', '解除vip绑定订单（删除订单）', 'Port/removeBindOrder', '5', '5c998876e0830', '0', '0', '1', '1', '解除vip绑定订单（删除订单）', '0', null);
INSERT INTO api_list VALUES ('33', 'erp线下订单支付-mc支付通知', 'Order/paymentErpOrder', '5', '5c9c6e01550f0', '0', '0', '1', '1', 'erp线下订单支付-mc支付通知', '0', null);
INSERT INTO api_list VALUES ('34', 'erp开单通知vip接口', 'Port/addOrder', '5', '5cd8c419df958', '0', '0', '1', '1', '', '0', null);
INSERT INTO api_list VALUES ('35', '订单完成通知vip接口', 'Port/endOrder', '5', '5cd8cf0c5a870', '0', '0', '1', '1', '', '0', null);
INSERT INTO api_list VALUES ('36', '订单支付状态回调', 'Order/setChildPackageOrder', '3', '5cd954ce63510', '0', '0', '1', '1', '修改vip儿童套系订单状态，调erp开单', '0', null);
INSERT INTO api_list VALUES ('37', 'erp更换订单手机号', 'Port/orderPhoneChange', '5', '5d4d2cbb7f710', '0', '0', '1', '1', 'erp更换订单手机号', '0', null);


-- ----------------------------
-- Table structure for app_version
-- ----------------------------
DROP TABLE IF EXISTS `app_version`;
CREATE TABLE `app_version` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `version` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `up_time` datetime DEFAULT NULL,
  `up_sql` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='应用版本管理';

-- ----------------------------
-- Records of app_version
-- ----------------------------
INSERT INTO app_version VALUES ('2', '0.0.1', '2019-04-12 15:35:07', ' ALTER TABLE `mc_brand_story`  ADD COLUMN `title_image` varchar(255)  NULL  COLLATE \'utf8_unicode_ci\' ');
INSERT INTO app_version VALUES ('3', '0.0.2', '2019-06-26 17:26:37', ' INSERT INTO `s_menu`  (menu_name,fid,menu_code,menu_url,menu_icon,status,sort)  SELECT \'评价题目\',\'211\',\'menu1561540818\',\'/vip/Evaluationquestionnaire/index\',\'fa-database\',\'1\',\'2\' ');
INSERT INTO app_version VALUES ('4', '0.0.3', '2019-07-25 17:54:25', ' ALTER TABLE `wx_menu`  ADD COLUMN `type` varchar(50)  NOT NULL  DEFAULT \'view\'  COLLATE \'utf8_unicode_ci\' , ADD COLUMN `appid` varchar(100)  NOT NULL  COLLATE \'utf8_unicode_ci\' , ADD COLUMN `pagepath` varchar(100)  NOT NULL  COLLATE \'utf8_unicode_ci\' , ADD COLUMN `key` varchar(100)  NOT NULL  COLLATE \'utf8_unicode_ci\' ');
INSERT INTO app_version VALUES ('5', '0.0.6', '2019-08-15 15:50:25', 'CREATE TABLE `guest_photo_tip`(`id` int  NOT NULL  AUTO_INCREMENT ,`tip_name` varchar(100)  NOT NULL  COLLATE \'utf8_unicode_ci\' ,`brand_id` int  NULL ,`staff_id` int  NULL ,`staff_name` varchar(200)  NULL  COLLATE \'utf8_unicode_ci\' ,`create_time` datetime  NULL ,PRIMARY KEY (`id`)) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB \r\n ALTER TABLE `guest_photo_type`  ADD COLUMN `sort` int(11)  NULL , ADD COLUMN `is_show` tinyint(2)  NULL \r\n INSERT INTO `api_list`  (apiName,apiUrl,app_id,hash,accessToken,needLogin,status,method,info,isTest)  SELECT \'erp更换订单手机号\',\'Port/orderPhoneChange\',\'5\',\'5d4d2cbb7f710\',\'0\',\'0\',\'1\',\'1\',\'erp更换订单手机号\',\'0\' \r\n INSERT INTO `api_fields`  (fieldName,hash,dataType,isMust,info,type,showName)  SELECT \'phone\',\'5d4d2cbb7f710\',\'2\',\'1\',\'更换的新手机号\',\'0\',\'phone\' union  SELECT \'order_number\',\'5d4d2cbb7f710\',\'2\',\'1\',\'订单号\',\'0\',\'order_number\' ');
INSERT INTO app_version VALUES ('6', '0.0.6', '2019-08-15 15:50:25', null);
INSERT INTO app_version VALUES ('7', '0.0.6', '2019-08-15 15:50:25', null);
INSERT INTO app_version VALUES ('8', '0.0.6', '2019-08-15 15:50:25', null);
INSERT INTO app_version VALUES ('9', '0.0.6', '2019-08-15 15:50:25', null);
INSERT INTO app_version VALUES ('10', '0.0.6', '2019-08-15 15:50:25', null);
INSERT INTO app_version VALUES ('11', '0.0.6', '2019-08-15 15:50:25', null);
INSERT INTO app_version VALUES ('12', '0.0.6', '2019-08-15 15:50:25', null);
INSERT INTO app_version VALUES ('13', '0.0.6', '2019-08-15 15:50:25', null);
INSERT INTO app_version VALUES ('14', '0.0.6', '2019-08-15 15:50:25', null);
INSERT INTO app_version VALUES ('15', '0.0.6', '2019-08-15 15:50:25', null);
INSERT INTO app_version VALUES ('16', '0.0.6', '2019-08-15 15:50:25', null);
INSERT INTO app_version VALUES ('17', '0.0.6', '2019-08-15 15:50:25', null);
INSERT INTO app_version VALUES ('18', '0.0.6', '2019-08-15 15:50:25', null);
INSERT INTO app_version VALUES ('19', '0.0.6', '2019-08-15 15:50:25', null);
INSERT INTO app_version VALUES ('20', '0.0.6', '2019-08-15 15:50:25', null);
INSERT INTO app_version VALUES ('21', '0.0.6', '2019-08-15 15:50:26', null);
INSERT INTO app_version VALUES ('22', '0.0.6', '2019-08-15 15:50:26', null);
INSERT INTO app_version VALUES ('23', '0.0.8', '2019-08-30 09:49:32', ' ALTER TABLE `m_order`  ADD COLUMN `award_score` int(11)  NULL  DEFAULT 0 \r\nCREATE TABLE `p_photo_notice`(`id` int  NOT NULL  AUTO_INCREMENT ,`name` varchar(255)  NULL  COLLATE \'utf8_unicode_ci\' ,`img` varchar(255)  NULL  COLLATE \'utf8_unicode_ci\' ,`sort` int(10)  NULL  DEFAULT 0 ,`brandid` int(10)  NULL ,`create_time` datetime  NULL ,`update_time` datetime  NULL ,PRIMARY KEY (`id`)) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB \r\n INSERT INTO `s_menu`  (id,menu_name,fid,menu_code,menu_url,menu_icon,status,sort)  SELECT \'764\',\'拍摄需知\',\'715\',\'menu1566625552\',\'/vip/Photonotice/index\',\'\',\'1\',\'0\' union  SELECT \'765\',\'添加拍摄须知\',\'764\',\'menu1566787251\',\'/vip/photonotice/add\',\'\',\'0\',\'0\' union  SELECT \'766\',\'修改拍摄须知\',\'764\',\'menu1566787259\',\'/vip/photonotice/edit\',\'\',\'0\',\'0\' union  SELECT \'767\',\'删除拍摄须知\',\'764\',\'menu1566787267\',\'/vip/photonotice/del\',\'\',\'0\',\'0\' union  SELECT \'768\',\'复制数据\',\'725\',\'menu1566897564\',\'/vip/package/copypackage\',\'\',\'0\',\'0\' ');
INSERT INTO app_version VALUES ('24', '0.0.10', '2019-09-03 18:56:04', ' ALTER TABLE `recommend`  ADD COLUMN `crm_status` tinyint(2)  NULL  DEFAULT 0 , ADD COLUMN `crm_error_msg` text  NULL  COLLATE \'utf8_unicode_ci\' \r\n INSERT INTO `api_list`  (apiName,apiUrl,app_id,hash,accessToken,needLogin,status,method,info,isTest)  SELECT \'获取先睹为快中摄影师评价\',\'Erpapi/getOrderCameramanScore\',\'5\',\'5d68f33396190\',\'0\',\'0\',\'1\',\'1\',\'获取先睹为快中摄影师评价\',\'0\' \r\n INSERT INTO `api_fields`  (fieldName,hash,dataType,isMust,info,type,showName)  SELECT \'orderId\',\'5d68f33396190\',\'2\',\'1\',\'订单号\',\'0\',\'orderId\' union  SELECT \'fc\',\'5d68f33396190\',\'2\',\'1\',\'服次\',\'0\',\'fc\' ');


-- ----------------------------
-- Table structure for a_activity_link
-- ----------------------------
DROP TABLE IF EXISTS `a_activity_link`;
CREATE TABLE `a_activity_link` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `activityid` int(11) DEFAULT '0' COMMENT '活动id ',
  `link` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '连接地址',
  `qrcode` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '二维码图片',
  `create_user` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '添加的人',
  `create_time` datetime DEFAULT NULL,
  `delete_time` datetime DEFAULT NULL,
  `brandid` int(11) DEFAULT '0' COMMENT '品牌id',
  `visit_total` int(11) DEFAULT '0' COMMENT '观看总数',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '是否删除1表示删除，0表示正常',
  `name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of a_activity_link
-- ----------------------------

-- ----------------------------
-- Table structure for a_activity_list
-- ----------------------------
DROP TABLE IF EXISTS `a_activity_list`;
CREATE TABLE `a_activity_list` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(150) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '活动标题',
  `scontent` varchar(200) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '简要说明',
  `content` text COLLATE utf8_unicode_ci COMMENT '详细说明',
  `couponid` int(11) DEFAULT '0' COMMENT '优惠券id',
  `share_score` int(11) DEFAULT '0' COMMENT '分享赠送的积分数量',
  `index_img` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '活动首页图片',
  `status` tinyint(1) DEFAULT '0' COMMENT '是否启用',
  `start_time` datetime DEFAULT NULL COMMENT '//当前活动所属事业部',
  `end_time` datetime DEFAULT NULL COMMENT '活动结束时间',
  `order_num` int(11) DEFAULT '0' COMMENT '排序数字',
  `share_total` int(11) DEFAULT '0' COMMENT '分享次数',
  `view_total` int(11) DEFAULT '0' COMMENT '浏览记录',
  `delete_time` datetime DEFAULT NULL COMMENT '是否删除',
  `create_time` datetime DEFAULT NULL COMMENT '活动添加时间',
  `update_time` datetime DEFAULT NULL,
  `create_user` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '//活动添加人',
  `share_title` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '分享时的标题',
  `share_img` varchar(200) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '分享时显示的图片',
  `share_content` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '分享时的详细介绍',
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或者事业部id',
  `permit_level` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '只允许查看的用户级别',
  `signup_total` int(11) DEFAULT '0' COMMENT '// 报名数量',
  `style_detail` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '样式详情',
  `iswid` int(11) DEFAULT '0',
  `ishot` tinyint(1) DEFAULT '0',
  `hot_img` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `cource_id` int(11) DEFAULT NULL COMMENT '客户来源id',
  `cource_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户来源name',
  `default_staff_id` int(11) DEFAULT NULL,
  `default_staff_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '默认归属员工姓名',
  `affiliation_shop_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '归属店面',
  `affiliation_shop_code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shareqr_img` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '分享二维码背景图',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=137 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='活动列表';

-- ----------------------------
-- Records of a_activity_list
-- ----------------------------

-- ----------------------------
-- Table structure for a_activity_msg
-- ----------------------------
DROP TABLE IF EXISTS `a_activity_msg`;
CREATE TABLE `a_activity_msg` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `activity_id` int(11) DEFAULT '0',
  `userid` int(11) DEFAULT NULL,
  `content` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `status` tinyint(1) DEFAULT '0',
  `check_time` datetime DEFAULT NULL,
  `staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `staff_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `user_del` tinyint(1) DEFAULT '0' COMMENT '用户删除，0正常,1删除',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=71 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of a_activity_msg
-- ----------------------------

-- ----------------------------
-- Table structure for a_activity_share_num
-- ----------------------------
DROP TABLE IF EXISTS `a_activity_share_num`;
CREATE TABLE `a_activity_share_num` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `share_userid` int(10) DEFAULT NULL,
  `activityid` int(10) DEFAULT NULL,
  `create_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of a_activity_share_num
-- ----------------------------

-- ----------------------------
-- Table structure for a_activity_share_qr
-- ----------------------------
DROP TABLE IF EXISTS `a_activity_share_qr`;
CREATE TABLE `a_activity_share_qr` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `userid` int(10) DEFAULT NULL,
  `staff_id` int(10) DEFAULT NULL,
  `staff_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `create_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `is_staff` tinyint(1) DEFAULT NULL COMMENT '是否是  员工 ',
  `activityid` int(10) DEFAULT NULL,
  `brandid` int(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of a_activity_share_qr
-- ----------------------------

-- ----------------------------
-- Table structure for a_activity_sign_up
-- ----------------------------
DROP TABLE IF EXISTS `a_activity_sign_up`;
CREATE TABLE `a_activity_sign_up` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `activityid` int(11) DEFAULT '0' COMMENT '活动id',
  `userid` int(11) DEFAULT '0' COMMENT '用户id',
  `b_username` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '预约用户名',
  `b_phone` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '预约电话',
  `wename` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '微信用户名',
  `photo_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '预约的拍照类别',
  `shopid` varchar(100) COLLATE utf8_unicode_ci DEFAULT '0' COMMENT '预约店铺',
  `status` tinyint(1) DEFAULT '0' COMMENT '预约状态',
  `check_userid` int(11) DEFAULT '0' COMMENT '审核人',
  `check_time` datetime DEFAULT NULL COMMENT '审核时间',
  `delete_time` datetime DEFAULT NULL COMMENT '是否删除',
  `create_time` datetime DEFAULT NULL COMMENT '添加时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `brandid` int(11) DEFAULT '0' COMMENT '品牌id',
  `sign_total` int(11) DEFAULT '0' COMMENT '活动报名总数',
  `check_name` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//处理人名称',
  `b_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//报名时间',
  `b_type` tinyint(5) DEFAULT '0' COMMENT '//展示类别 1是报名 2是报价',
  `shop_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '//店铺名称',
  `b_say` varchar(150) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '拍摄类型的备注',
  `iswid` int(11) DEFAULT '0',
  `b_content` varchar(256) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `activity_link` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ext_data` text COLLATE utf8_unicode_ci NOT NULL,
  `parent_id` int(11) DEFAULT '0',
  `share_num` int(11) DEFAULT '0',
  `fission_num` int(11) DEFAULT '0',
  `site` tinyint(11) DEFAULT '0',
  `parent_ids` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `share_userid` int(10) DEFAULT NULL,
  `cancel` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `baby_birthday` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1100 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='活动预约和获取报价表';

-- ----------------------------
-- Records of a_activity_sign_up
-- ----------------------------

-- ----------------------------
-- Table structure for a_activity_smp
-- ----------------------------
DROP TABLE IF EXISTS `a_activity_smp`;
CREATE TABLE `a_activity_smp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `activity_id` int(11) DEFAULT NULL COMMENT '1百天，2新生、满月',
  `user_id` int(11) DEFAULT NULL,
  `phone` varchar(200) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '手机号',
  `birthday` datetime DEFAULT NULL COMMENT '生日',
  `month` datetime DEFAULT NULL COMMENT '满月时间',
  `hundred` datetime DEFAULT NULL COMMENT '百天时间',
  `brand_id` int(11) DEFAULT NULL,
  `order_sn` varchar(200) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '订单号',
  `price` decimal(10,2) DEFAULT '0.00',
  `pay_status` tinyint(1) DEFAULT '1' COMMENT '支付状态，（1未支付，2支付完成）',
  `create_time` datetime DEFAULT NULL,
  `pay_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of a_activity_smp
-- ----------------------------

-- ----------------------------
-- Table structure for a_activity_visit
-- ----------------------------
DROP TABLE IF EXISTS `a_activity_visit`;
CREATE TABLE `a_activity_visit` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `activityid` int(11) DEFAULT '0' COMMENT '活动id',
  `userid` int(11) DEFAULT '0' COMMENT '访问用户id',
  `linkid` int(11) DEFAULT '0' COMMENT '来自连接的id',
  `link_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `from_brandid` int(11) DEFAULT '0' COMMENT '来自品牌id',
  `create_time` datetime DEFAULT NULL,
  `delete_time` datetime DEFAULT NULL,
  `add_time` datetime DEFAULT NULL COMMENT '添加时间',
  `iswid` tinyint(1) DEFAULT '0' COMMENT '0表示userid就是m_users里的id,1表示userid是m_we_users里的wid',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of a_activity_visit
-- ----------------------------

-- ----------------------------
-- Table structure for bespeaks_photo
-- ----------------------------
DROP TABLE IF EXISTS `bespeaks_photo`;
CREATE TABLE `bespeaks_photo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(11) DEFAULT '0' COMMENT '预约用户id',
  `shopid` int(11) DEFAULT '0' COMMENT '预约店铺id',
  `b_type` tinyint(1) DEFAULT '0' COMMENT '预约类别1拍照，2选片',
  `status` tinyint(1) DEFAULT '0' COMMENT '状态',
  `check_userid` int(11) DEFAULT '0' COMMENT '审核人',
  `check_time` datetime DEFAULT NULL COMMENT '审核时间',
  `delete_time` datetime DEFAULT NULL COMMENT '是否删除',
  `create_time` datetime DEFAULT NULL COMMENT '预约拍照日期',
  `update_time` datetime DEFAULT NULL,
  `brandid` int(11) DEFAULT '0' COMMENT '品牌id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='预约拍照和选片表';

-- ----------------------------
-- Records of bespeaks_photo
-- ----------------------------

-- ----------------------------
-- Table structure for bg_imgs
-- ----------------------------
DROP TABLE IF EXISTS `bg_imgs`;
CREATE TABLE `bg_imgs` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `brandid` int(11) DEFAULT NULL,
  `img` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `add_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=341 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of bg_imgs
-- ----------------------------

-- ----------------------------
-- Table structure for brithdaygift
-- ----------------------------
DROP TABLE IF EXISTS `brithdaygift`;
CREATE TABLE `brithdaygift` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `userid` int(10) DEFAULT NULL,
  `couponids` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `create_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `year` int(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of brithdaygift
-- ----------------------------

-- ----------------------------
-- Table structure for cameraman
-- ----------------------------
DROP TABLE IF EXISTS `cameraman`;
CREATE TABLE `cameraman` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//摄影师表id',
  `c_name` varchar(50) CHARACTER SET utf8 DEFAULT '' COMMENT '//摄影师名称',
  `c_age` int(255) DEFAULT '0' COMMENT '//摄影师年龄',
  `c_tel` char(11) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '//摄影师电话',
  `c_shop` varchar(100) CHARACTER SET utf8 DEFAULT '' COMMENT '//摄影师门店',
  `c_img` varchar(255) CHARACTER SET utf8 DEFAULT '' COMMENT '//摄影师头像',
  `c_brief` text CHARACTER SET utf8 COMMENT '//摄影师简介',
  `c_address` varchar(50) CHARACTER SET utf8 DEFAULT '' COMMENT '//摄影师地点',
  `c_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT '0' COMMENT '//摄影师类型',
  `c_work` int(11) DEFAULT '1' COMMENT '//摄影师工作年限',
  `c_production` varchar(255) CHARACTER SET utf8 DEFAULT '' COMMENT '//摄影师作品封面',
  `c_rank` varchar(50) COLLATE utf8_unicode_ci DEFAULT '0' COMMENT '//摄影师等级',
  `c_money` decimal(10,0) DEFAULT '0' COMMENT '//摄影师价格',
  `brandid` int(11) DEFAULT '0' COMMENT '//所属门店',
  `c_detail` varchar(200) COLLATE utf8_unicode_ci DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=57 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of cameraman
-- ----------------------------

-- ----------------------------
-- Table structure for cam_attention
-- ----------------------------
DROP TABLE IF EXISTS `cam_attention`;
CREATE TABLE `cam_attention` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '关注表id',
  `cam_id` int(11) DEFAULT NULL COMMENT '//摄影师id',
  `userid` int(11) DEFAULT NULL COMMENT '//用户id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of cam_attention
-- ----------------------------

-- ----------------------------
-- Table structure for cam_evaluate
-- ----------------------------
DROP TABLE IF EXISTS `cam_evaluate`;
CREATE TABLE `cam_evaluate` (
  `e_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '//摄影师评价id',
  `userid` int(11) DEFAULT '0' COMMENT '//用户id',
  `camid` int(11) DEFAULT '0' COMMENT '摄影师id',
  `counts` varchar(255) CHARACTER SET utf8 DEFAULT '' COMMENT '//评价内容',
  `evaluate_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//评价时间',
  `several_star` int(11) DEFAULT '0' COMMENT '//几星',
  `evaluate_title` varchar(100) CHARACTER SET utf8 DEFAULT '' COMMENT '//几字精简评价',
  `evaluate_img` varchar(255) CHARACTER SET utf8 DEFAULT '' COMMENT '//评价图片',
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  `evaluate_count` int(11) DEFAULT '0' COMMENT '//有多少人回复了此评论',
  PRIMARY KEY (`e_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of cam_evaluate
-- ----------------------------

-- ----------------------------
-- Table structure for cam_order
-- ----------------------------
DROP TABLE IF EXISTS `cam_order`;
CREATE TABLE `cam_order` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//预约订单表',
  `o_odd` varchar(255) CHARACTER SET utf8 DEFAULT '' COMMENT '//订单号',
  `o_name` varchar(200) CHARACTER SET utf8 DEFAULT '' COMMENT '//订单名称',
  `create_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//下单时间',
  `pay_type` tinyint(4) DEFAULT '0' COMMENT '//付款方式',
  `pay_money` decimal(10,0) DEFAULT '0' COMMENT '//付款金额',
  `o_status` tinyint(4) DEFAULT '0' COMMENT '//支付状态',
  `userid` int(11) DEFAULT '0' COMMENT '//支付人',
  `o_about_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//订单预约时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of cam_order
-- ----------------------------

-- ----------------------------
-- Table structure for cam_production
-- ----------------------------
DROP TABLE IF EXISTS `cam_production`;
CREATE TABLE `cam_production` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//摄影师id',
  `cam_id` int(11) DEFAULT NULL COMMENT '//摄影师id',
  `cam_img` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//摄影师内容',
  `production_count` int(11) DEFAULT '0' COMMENT '//作品点赞数量统计',
  `cam_cover` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//作品封面',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of cam_production
-- ----------------------------

-- ----------------------------
-- Table structure for cam_reply
-- ----------------------------
DROP TABLE IF EXISTS `cam_reply`;
CREATE TABLE `cam_reply` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//评论回复表',
  `e_id` int(11) DEFAULT NULL COMMENT '//评论人自增id',
  `userid` int(11) DEFAULT NULL COMMENT '//评论人id',
  `r_count` int(11) DEFAULT NULL COMMENT '//回复内容',
  `r_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//回复时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of cam_reply
-- ----------------------------

-- ----------------------------
-- Table structure for cam_reservation
-- ----------------------------
DROP TABLE IF EXISTS `cam_reservation`;
CREATE TABLE `cam_reservation` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//摄影师预约表',
  `userid` int(11) DEFAULT '0' COMMENT '//预约用户id',
  `camid` int(11) DEFAULT '0' COMMENT '//摄影师id',
  `about_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//预约时间',
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of cam_reservation
-- ----------------------------

-- ----------------------------
-- Table structure for cam_spot
-- ----------------------------
DROP TABLE IF EXISTS `cam_spot`;
CREATE TABLE `cam_spot` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//点赞表id',
  `e_id` int(11) DEFAULT '0' COMMENT '//哪条评论',
  `userid` int(11) DEFAULT '0' COMMENT '//点赞人id',
  `spot_time` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '//点赞时间',
  `spot_type` tinyint(4) DEFAULT '0' COMMENT '//点赞类型 1是评论 2是作品',
  `cam_id` int(11) DEFAULT '0' COMMENT '//摄影师id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of cam_spot
-- ----------------------------

-- ----------------------------
-- Table structure for cam_type
-- ----------------------------
DROP TABLE IF EXISTS `cam_type`;
CREATE TABLE `cam_type` (
  `typeid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//摄影师类别id',
  `type_name` varchar(100) CHARACTER SET utf8 DEFAULT NULL COMMENT '//级别名称',
  PRIMARY KEY (`typeid`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of cam_type
-- ----------------------------

-- ----------------------------
-- Table structure for card_rule
-- ----------------------------
DROP TABLE IF EXISTS `card_rule`;
CREATE TABLE `card_rule` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//卡号生成规则id',
  `card_lenght` tinyint(1) DEFAULT '16' COMMENT '//默认卡号长度',
  `card_prefix` char(50) CHARACTER SET utf8 DEFAULT NULL COMMENT '//卡片前缀',
  `brandid` int(11) DEFAULT NULL COMMENT '//事业部id',
  `staffid` int(11) DEFAULT NULL COMMENT '//添加员工',
  `card_next` char(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '//会员卡后缀',
  `this_phone` tinyint(1) DEFAULT '2' COMMENT '//是否默认手机号',
  `card_number` char(50) CHARACTER SET utf8 DEFAULT NULL COMMENT '//可选长度数字',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of card_rule
-- ----------------------------

-- ----------------------------
-- Table structure for c_card_list
-- ----------------------------
DROP TABLE IF EXISTS `c_card_list`;
CREATE TABLE `c_card_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_phone_id` int(11) DEFAULT '0',
  `card_type_id` int(11) DEFAULT '0',
  `card_no` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `card_value` decimal(12,2) DEFAULT '0.00',
  `balance` decimal(12,2) DEFAULT '0.00',
  `status` tinyint(1) DEFAULT '1',
  `create_time` datetime DEFAULT NULL,
  `expire_time` datetime DEFAULT NULL,
  `create_staff_id` int(11) DEFAULT '0',
  `create_staff_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `card_password` varchar(200) CHARACTER SET utf8 DEFAULT '666666' COMMENT '//会员卡密码',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of c_card_list
-- ----------------------------

-- ----------------------------
-- Table structure for c_card_log
-- ----------------------------
DROP TABLE IF EXISTS `c_card_log`;
CREATE TABLE `c_card_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `consume_money` decimal(12,2) DEFAULT '0.00',
  `consume_time` datetime DEFAULT NULL,
  `card_list_id` int(11) NOT NULL,
  `consume_order_code` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `consume_title` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `create_staff_number` varchar(120) COLLATE utf8_unicode_ci DEFAULT '',
  `create_staff_name` varchar(120) COLLATE utf8_unicode_ci DEFAULT '',
  `shop_name` varchar(100) CHARACTER SET utf8 DEFAULT NULL COMMENT '//门店名称',
  `brand_id` int(11) DEFAULT NULL COMMENT '//所属事业部',
  `user_phone_id` int(11) DEFAULT NULL COMMENT '//手机表id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of c_card_log
-- ----------------------------

-- ----------------------------
-- Table structure for c_card_type
-- ----------------------------
DROP TABLE IF EXISTS `c_card_type`;
CREATE TABLE `c_card_type` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `card_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '卡类型名称',
  `card_img` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '卡图片',
  `status` tinyint(1) DEFAULT '1' COMMENT '卡状态',
  `price` decimal(12,2) DEFAULT '0.00' COMMENT '卡片售价',
  `discount` decimal(5,2) DEFAULT '100.00' COMMENT '享受的折扣',
  `card_desc` text COLLATE utf8_unicode_ci COMMENT '卡片说明',
  `order_num` int(11) DEFAULT '0' COMMENT '排序数',
  `card_prefix` varchar(11) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '卡片前缀',
  `card_balance` decimal(10,0) DEFAULT '0' COMMENT '//卡内余额',
  `expire_days` int(11) DEFAULT '0' COMMENT '//卡片有效时间天数',
  `create_time` datetime DEFAULT NULL COMMENT '添加日期',
  `update_time` datetime DEFAULT NULL COMMENT '最后修改时间',
  `delete_time` datetime DEFAULT NULL COMMENT '是否删除',
  `business_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '//所属事业部',
  `create_user` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '添加用户',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '是否删除',
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  `add_time` datetime DEFAULT NULL COMMENT '卡片添加时间',
  `card_type` tinyint(1) DEFAULT '3' COMMENT '//选择卡的类型',
  `card_num` int(11) DEFAULT '1' COMMENT '//卡片生成数量',
  `card_pass` int(11) DEFAULT '666666' COMMENT '//卡密码',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=53 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='会员卡类型表';

-- ----------------------------
-- Records of c_card_type
-- ----------------------------

-- ----------------------------
-- Table structure for c_coupon_bag
-- ----------------------------
DROP TABLE IF EXISTS `c_coupon_bag`;
CREATE TABLE `c_coupon_bag` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `cid` text COLLATE utf8_unicode_ci,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '卡包名称',
  `create_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `brandid` int(10) DEFAULT NULL,
  `sort` int(10) DEFAULT NULL COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of c_coupon_bag
-- ----------------------------

-- ----------------------------
-- Table structure for c_coupon_list
-- ----------------------------
DROP TABLE IF EXISTS `c_coupon_list`;
CREATE TABLE `c_coupon_list` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `userid` int(11) DEFAULT '0' COMMENT '用户id',
  `shopid` int(11) DEFAULT '0' COMMENT '优惠券使用店铺的id',
  `coupon_num_id` int(11) DEFAULT '0' COMMENT '优惠券批次id',
  `coupon_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '优惠券号',
  `status` tinyint(1) DEFAULT '0' COMMENT '0未消费，1消费，2已失效，3已分享，4通过分享得到的优惠券，5已分享待领取优惠券',
  `use_time` datetime DEFAULT NULL COMMENT '使用时间',
  `create_time` datetime DEFAULT NULL COMMENT '获取优惠券时间',
  `update_time` datetime DEFAULT NULL,
  `delete_time` datetime DEFAULT NULL COMMENT '是否删除',
  `check_user` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '更改状态的人',
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  `iswid` tinyint(1) DEFAULT '0' COMMENT '0表示userid就是m_users里的id,1表示userid是m_we_users里的wid',
  `activityid` int(11) DEFAULT '0',
  `discount_type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '优惠券类型，1直减2折扣,3兑换',
  `expire_time` datetime DEFAULT NULL,
  `discount_value` int(11) NOT NULL DEFAULT '0' COMMENT '优惠金额',
  `condition_value` decimal(10,2) DEFAULT NULL COMMENT '使用条件',
  `share_phone` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '已分享出去，待领取的优惠券的 手机号',
  `share_userid` int(10) DEFAULT NULL COMMENT '分享者的id',
  `product_info` text COLLATE utf8_unicode_ci COMMENT '可兑换产品  名称|数量;',
  `package_ids` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='优惠券表 ';

-- ----------------------------
-- Records of c_coupon_list
-- ----------------------------

-- ----------------------------
-- Table structure for c_coupon_num
-- ----------------------------
DROP TABLE IF EXISTS `c_coupon_num`;
CREATE TABLE `c_coupon_num` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(150) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT '' COMMENT '优惠券标题',
  `coupon_num` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '优惠券编号',
  `img` varchar(150) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '优惠券图片',
  `coupon_typeid` int(11) DEFAULT '0' COMMENT '优惠券类别',
  `money` int(11) DEFAULT '0' COMMENT '优惠金额',
  `content` varchar(200) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '优惠详细介绍',
  `total_num` int(11) DEFAULT '0' COMMENT '优惠券总数量',
  `start_time` datetime DEFAULT NULL COMMENT '优惠券开始使用时间',
  `end_time` datetime DEFAULT NULL COMMENT '优惠券截至使用时间',
  `min_consume` int(11) DEFAULT '0' COMMENT '最低消费',
  `status` tinyint(1) DEFAULT '0' COMMENT '是否启用',
  `receive_total` int(11) DEFAULT '0' COMMENT '领取数量',
  `order_num` int(11) DEFAULT '0' COMMENT '排序数字',
  `create_time` datetime DEFAULT NULL COMMENT '添加优惠券时间',
  `delete_time` datetime DEFAULT NULL COMMENT '软删除',
  `update_time` datetime DEFAULT NULL,
  `each_max_total` int(11) unsigned DEFAULT '1' COMMENT '0代表不限制，1代表1张',
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  `create_user` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '添加的用户名称',
  `discount_type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '优惠券类型，1直减2折扣',
  `expire_time` int(11) DEFAULT '0',
  `is_show` tinyint(2) DEFAULT '1' COMMENT '是否展示在海量优惠券',
  `convert_money` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '兑换券面值(最多为三个）',
  `can_share` tinyint(2) DEFAULT '1',
  `product_info` text COLLATE utf8_unicode_ci COMMENT '可兑换商品信息，产品名|数量;',
  `package_ids` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=71 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='优惠券批次表';

-- ----------------------------
-- Records of c_coupon_num
-- ----------------------------

-- ----------------------------
-- Table structure for c_coupon_type
-- ----------------------------
DROP TABLE IF EXISTS `c_coupon_type`;
CREATE TABLE `c_coupon_type` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '用户id',
  `create_time` datetime DEFAULT NULL COMMENT '获取优惠券时间',
  `delete_time` datetime DEFAULT NULL COMMENT '是否删除',
  `update_time` datetime DEFAULT NULL,
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='优惠券表 ';

-- ----------------------------
-- Records of c_coupon_type
-- ----------------------------

-- ----------------------------
-- Table structure for c_excel_import
-- ----------------------------
DROP TABLE IF EXISTS `c_excel_import`;
CREATE TABLE `c_excel_import` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `file_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `file_url` varchar(300) COLLATE utf8_unicode_ci DEFAULT '',
  `fail_file_url` varchar(300) COLLATE utf8_unicode_ci DEFAULT '',
  `addtime` datetime DEFAULT NULL,
  `status` tinyint(1) DEFAULT '0' COMMENT '导入状态，0未导入，1已导入，2正在导入，3导入失败，默认为0',
  `all_number` int(11) DEFAULT '0',
  `import_number` int(11) DEFAULT '0',
  `fail_number` int(11) DEFAULT '0',
  `brandid` int(11) DEFAULT '0',
  `staff_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `excel_type` tinyint(2) DEFAULT NULL COMMENT '导入文件类型，1会员粉丝，2财务打款记录',
  `import_fail` text COLLATE utf8_unicode_ci COMMENT '导入错误信息',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=84 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of c_excel_import
-- ----------------------------

-- ----------------------------
-- Table structure for c_kf
-- ----------------------------
DROP TABLE IF EXISTS `c_kf`;
CREATE TABLE `c_kf` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `url` varchar(250) COLLATE utf8_unicode_ci DEFAULT '',
  `brandid` int(11) DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `phone` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `kf_key` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `info_key` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of c_kf
-- ----------------------------

-- ----------------------------
-- Table structure for c_sysconfig
-- ----------------------------
DROP TABLE IF EXISTS `c_sysconfig`;
CREATE TABLE `c_sysconfig` (
  `ckey` varchar(50) COLLATE utf8_unicode_ci NOT NULL COMMENT '配置KEY，系统写死',
  `cvalue` text COLLATE utf8_unicode_ci COMMENT '配置内容',
  PRIMARY KEY (`ckey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of c_sysconfig
-- ----------------------------

-- ----------------------------
-- Table structure for c_type_pro
-- ----------------------------
DROP TABLE IF EXISTS `c_type_pro`;
CREATE TABLE `c_type_pro` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '//礼品卡类型关联表id',
  `card_id` int(11) DEFAULT NULL COMMENT '//当前会员卡的id',
  `card_pro` varchar(255) CHARACTER SET utf8 NOT NULL COMMENT '//所属产品名称',
  `card_shop` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//当前产品所属店面',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of c_type_pro
-- ----------------------------

-- ----------------------------
-- Table structure for c_vip_save
-- ----------------------------
DROP TABLE IF EXISTS `c_vip_save`;
CREATE TABLE `c_vip_save` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `url` varchar(250) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `data` text COLLATE utf8_unicode_ci,
  `create_time` datetime DEFAULT NULL,
  `error_count` int(11) NOT NULL DEFAULT '4',
  `call_time` varchar(11) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1085 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of c_vip_save
-- ----------------------------

-- ----------------------------
-- Table structure for erp_pay
-- ----------------------------
DROP TABLE IF EXISTS `erp_pay`;
CREATE TABLE `erp_pay` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pay_code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `order_number` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `order_time` datetime DEFAULT NULL,
  `price_content` text COLLATE utf8_unicode_ci,
  `price` decimal(10,2) DEFAULT '0.00',
  `pay_status` tinyint(2) DEFAULT '1',
  `pay_time` datetime DEFAULT NULL,
  `pay_money` decimal(10,2) DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of erp_pay
-- ----------------------------

-- ----------------------------
-- Table structure for erp_pay_serial
-- ----------------------------
DROP TABLE IF EXISTS `erp_pay_serial`;
CREATE TABLE `erp_pay_serial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `erp_pay_code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `serial_number` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pay_price` decimal(10,2) DEFAULT NULL,
  `pay_status` tinyint(2) DEFAULT '1',
  `add_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of erp_pay_serial
-- ----------------------------

-- ----------------------------
-- Table structure for grade
-- ----------------------------
DROP TABLE IF EXISTS `grade`;
CREATE TABLE `grade` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `grade_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '//会员等级名称',
  `create_value` int(10) DEFAULT NULL COMMENT '//当前卡的初始分值',
  `end_value` int(10) DEFAULT NULL COMMENT '//当前卡的终止分值',
  `division` int(11) DEFAULT NULL COMMENT '//当前等级所属事业部',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of grade
-- ----------------------------

-- ----------------------------
-- Table structure for group_activity
-- ----------------------------
DROP TABLE IF EXISTS `group_activity`;
CREATE TABLE `group_activity` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `activity_title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '活动标题',
  `front_money` decimal(11,0) DEFAULT '0' COMMENT '报名定金要求',
  `starttime` datetime DEFAULT NULL COMMENT '开始时间',
  `endtime` datetime DEFAULT NULL COMMENT '结束时间',
  `wedding_price` decimal(11,0) DEFAULT NULL COMMENT '套系价格',
  `discount` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '团购折扣率',
  `list_img` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '列表页图片',
  `share_img` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '分享显示图片',
  `share_title` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '分享标题',
  `share_desc` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '分享描述',
  `permit_level` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '参与用户等级',
  `user_require` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '参与用户要求(>=多少人才能成团)',
  `brandid` int(10) DEFAULT NULL,
  `info_img` text COLLATE utf8_unicode_ci COMMENT '详情图',
  `apply_img` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '报名图',
  `couponid` int(10) DEFAULT NULL COMMENT '优惠券id',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `delete_time` datetime DEFAULT NULL COMMENT '删除时间',
  `status` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '活动状态（1发布 0不发布）',
  `ordernum` int(10) DEFAULT NULL COMMENT '排序（数字越大显示越靠前）',
  `update_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `price` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '套系原价',
  `coupon_num` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '优惠券批次（编号）',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of group_activity
-- ----------------------------

-- ----------------------------
-- Table structure for group_buy
-- ----------------------------
DROP TABLE IF EXISTS `group_buy`;
CREATE TABLE `group_buy` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `activity_id` int(10) DEFAULT NULL COMMENT '活动id',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `broker_id` int(10) DEFAULT NULL COMMENT '经纪人id',
  `brandid` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '事业部',
  `activity_title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '活动标题',
  `info_img` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '详情图',
  `apply_img` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '报名图',
  `broker_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '经纪人姓名',
  `status` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '团的状态（1进行中 2结束了）',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of group_buy
-- ----------------------------

-- ----------------------------
-- Table structure for group_cause
-- ----------------------------
DROP TABLE IF EXISTS `group_cause`;
CREATE TABLE `group_cause` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `cause` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '取消原因',
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '姓名',
  `phone` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '手机号码',
  `groupuser_id` int(10) DEFAULT NULL COMMENT '团购成员id',
  `create_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of group_cause
-- ----------------------------

-- ----------------------------
-- Table structure for group_user
-- ----------------------------
DROP TABLE IF EXISTS `group_user`;
CREATE TABLE `group_user` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户昵称',
  `join_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '参加时间',
  `front_money` int(30) DEFAULT '0' COMMENT '定金',
  `pay_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '支付时间',
  `phone` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '参与人手机号',
  `wedding_day` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '结婚日期',
  `broker_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '经纪人姓名',
  `brandid` int(10) DEFAULT NULL COMMENT '事业部id',
  `groupbuy_id` int(10) DEFAULT NULL COMMENT '团购id',
  `img` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '头像',
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户姓名',
  `user_id` int(10) DEFAULT NULL COMMENT '客户id(m_users 主键id）',
  `order_no` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单号',
  `pay_status` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '支付状态(1 已支付 0 代付款 )',
  `status` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '拼团状态（0待成团 1已成团 2超时失败 3已取消）',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of group_user
-- ----------------------------

-- ----------------------------
-- Table structure for growth_log
-- ----------------------------
DROP TABLE IF EXISTS `growth_log`;
CREATE TABLE `growth_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//成长值日志表',
  `userid` int(11) DEFAULT '0' COMMENT '//用户id',
  `graowth_num` int(11) DEFAULT '0' COMMENT '//成长值分数',
  `graowth_type` int(11) DEFAULT '0' COMMENT '//成长值类型 1每天登录2每天签到3领取任务4做任务5推荐新人6报名活动7浏览活动8是分享',
  `graowth_tid` int(11) DEFAULT '0' COMMENT '//任务或者活动id',
  `graowth_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `iswid` smallint(1) DEFAULT '0' COMMENT '0表示userid就是m_users里的id,1表示userid是m_phone_users里的wid',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=376 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ROW_FORMAT=COMPACT;

-- ----------------------------
-- Records of growth_log
-- ----------------------------

-- ----------------------------
-- Table structure for growth_rule
-- ----------------------------
DROP TABLE IF EXISTS `growth_rule`;
CREATE TABLE `growth_rule` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '规则id',
  `levelid` int(11) DEFAULT '0' COMMENT '级别id对应level表id',
  `detail` text COLLATE utf8_unicode_ci COMMENT 'json格式的数据，包含签到规则详细信息',
  `delete_time` datetime DEFAULT NULL COMMENT '删除',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  `create_user` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '添加数据的人',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ROW_FORMAT=COMPACT COMMENT='积分规则表';

-- ----------------------------
-- Records of growth_rule
-- ----------------------------

-- ----------------------------
-- Table structure for guest_photo
-- ----------------------------
DROP TABLE IF EXISTS `guest_photo`;
CREATE TABLE `guest_photo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type_id` int(11) DEFAULT NULL COMMENT '客片类型id',
  `title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客片标题',
  `content_text` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '文字',
  `cover_img` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '封面图',
  `content_img` text COLLATE utf8_unicode_ci,
  `package_id` int(11) DEFAULT NULL COMMENT '绑定套系',
  `package_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '套系名称',
  `sort` int(11) DEFAULT NULL COMMENT '排序',
  `brand_id` int(11) DEFAULT NULL COMMENT '事业部id',
  `create_time` datetime DEFAULT NULL,
  `staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '员工id',
  `user_id` int(11) DEFAULT NULL COMMENT 'user表主键id',
  `check_time` datetime DEFAULT NULL COMMENT '审核时间',
  `check_staff` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '审核人',
  `status` tinyint(4) DEFAULT '3' COMMENT '是否展示，1展示，2不展示，3未审核（不展示），4展示在首页',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=97 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of guest_photo
-- ----------------------------

-- ----------------------------
-- Table structure for guest_photo_tip
-- ----------------------------
DROP TABLE IF EXISTS `guest_photo_tip`;
CREATE TABLE `guest_photo_tip` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tip_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `brand_id` int(11) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `staff_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of guest_photo_tip
-- ----------------------------

-- ----------------------------
-- Table structure for guest_photo_type
-- ----------------------------
DROP TABLE IF EXISTS `guest_photo_type`;
CREATE TABLE `guest_photo_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '分类名称',
  `brand_id` int(11) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '操作人',
  `create_time` datetime DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  `is_show` tinyint(2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of guest_photo_type
-- ----------------------------

-- ----------------------------
-- Table structure for img_code
-- ----------------------------
DROP TABLE IF EXISTS `img_code`;
CREATE TABLE `img_code` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//二维码表id',
  `c_img` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//图片地址',
  `staff_id` int(11) DEFAULT NULL COMMENT '//员工id',
  `c_tyid` int(11) DEFAULT NULL COMMENT '//二维码类型',
  `c_code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '//二维码串码',
  `brandid` int(11) DEFAULT NULL COMMENT '//品牌id',
  `staff_name` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//员工姓名',
  `create_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//二维码生成时间',
  `qrcode` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '//二维码名称',
  `delete_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//删除时间',
  `link_site` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//链接地址',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of img_code
-- ----------------------------

-- ----------------------------
-- Table structure for jgq_vip_coupon
-- ----------------------------
DROP TABLE IF EXISTS `jgq_vip_coupon`;
CREATE TABLE `jgq_vip_coupon` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `brand_id` int(11) DEFAULT NULL,
  `coupon_data` text COLLATE utf8_unicode_ci,
  `price` decimal(10,2) DEFAULT '0.00',
  `create_time` datetime DEFAULT NULL,
  `create_staff_id` int(11) DEFAULT NULL,
  `create_staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of jgq_vip_coupon
-- ----------------------------

-- ----------------------------
-- Table structure for jgq_vip_list
-- ----------------------------
DROP TABLE IF EXISTS `jgq_vip_list`;
CREATE TABLE `jgq_vip_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `vip_id` int(11) DEFAULT NULL,
  `brand_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `coupon_data` text COLLATE utf8_unicode_ci,
  `order_sn` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `price` decimal(10,2) DEFAULT '0.00',
  `pay_status` tinyint(1) DEFAULT '1',
  `create_time` datetime DEFAULT NULL,
  `pay_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of jgq_vip_list
-- ----------------------------

-- ----------------------------
-- Table structure for master_make
-- ----------------------------
DROP TABLE IF EXISTS `master_make`;
CREATE TABLE `master_make` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '//预约id',
  `master_id` int(11) NOT NULL COMMENT '//预约师id',
  `user_id` int(11) NOT NULL COMMENT '//预约人id',
  `make_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '预约时间',
  `make_status` tinyint(1) DEFAULT '1' COMMENT '//预约状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of master_make
-- ----------------------------

-- ----------------------------
-- Table structure for mc_brand_information
-- ----------------------------
DROP TABLE IF EXISTS `mc_brand_information`;
CREATE TABLE `mc_brand_information` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(255) COLLATE utf8_bin NOT NULL COMMENT '名称',
  `image` varchar(255) COLLATE utf8_bin NOT NULL DEFAULT '' COMMENT '图片',
  `parent_id` tinyint(1) NOT NULL COMMENT '父节点id',
  `sort` int(11) NOT NULL DEFAULT '100' COMMENT '排序',
  `url` varchar(255) COLLATE utf8_bin NOT NULL DEFAULT '' COMMENT 'url',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='品牌信息表';

-- ----------------------------
-- Records of mc_brand_information
-- ----------------------------

-- ----------------------------
-- Table structure for mc_brand_story
-- ----------------------------
DROP TABLE IF EXISTS `mc_brand_story`;
CREATE TABLE `mc_brand_story` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `image` varchar(255) COLLATE utf8_bin NOT NULL COMMENT '图片',
  `brand_id` int(11) NOT NULL COMMENT '部门id',
  `title_image` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='品牌故事表';

-- ----------------------------
-- Records of mc_brand_story
-- ----------------------------

-- ----------------------------
-- Table structure for mc_column
-- ----------------------------
DROP TABLE IF EXISTS `mc_column`;
CREATE TABLE `mc_column` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(255) COLLATE utf8_bin NOT NULL COMMENT '名称',
  `image` varchar(255) COLLATE utf8_bin NOT NULL DEFAULT '' COMMENT '图片',
  `mc_sort` int(11) NOT NULL DEFAULT '100' COMMENT '排序,倒叙',
  `create_time` int(10) NOT NULL COMMENT '创建时间',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '1启用,0停用',
  `brand_id` int(11) NOT NULL COMMENT '部门id',
  `icon` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT '0',
  `is_del` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='结婚圈栏目表';

-- ----------------------------
-- Records of mc_column
-- ----------------------------

-- ----------------------------
-- Table structure for mc_comment
-- ----------------------------
DROP TABLE IF EXISTS `mc_comment`;
CREATE TABLE `mc_comment` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `tid` int(11) NOT NULL COMMENT '话题id',
  `content` varchar(255) COLLATE utf8_unicode_ci NOT NULL COMMENT '内容',
  `uid` int(11) NOT NULL COMMENT '创建人 id',
  `create_time` int(10) NOT NULL COMMENT '创建时间',
  `mc_sort` int(11) NOT NULL DEFAULT '100' COMMENT '排序,倒叙',
  `is_examine` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1已审核,0未审核',
  `brand_id` int(11) NOT NULL COMMENT '部门id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=141 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='结婚圈 评论表';

-- ----------------------------
-- Records of mc_comment
-- ----------------------------

-- ----------------------------
-- Table structure for mc_evaluation_questionnaire
-- ----------------------------
DROP TABLE IF EXISTS `mc_evaluation_questionnaire`;
CREATE TABLE `mc_evaluation_questionnaire` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `title` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '标题',
  `type_id` tinyint(1) DEFAULT NULL COMMENT '类型id,1服务评价,2选样评价,3取件评价',
  `brand_id` int(11) DEFAULT NULL COMMENT '部门id',
  `is_del` tinyint(1) DEFAULT '1' COMMENT '1存在,0删除',
  `create_time` int(10) DEFAULT NULL COMMENT '创建时间',
  `sort` int(11) DEFAULT '100' COMMENT '倒叙',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=267 DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='评价问卷表';

-- ----------------------------
-- Records of mc_evaluation_questionnaire
-- ----------------------------

-- ----------------------------
-- Table structure for mc_evaluation_questionnaire_answer
-- ----------------------------
DROP TABLE IF EXISTS `mc_evaluation_questionnaire_answer`;
CREATE TABLE `mc_evaluation_questionnaire_answer` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `eq_id` int(11) DEFAULT NULL COMMENT 'evaluation_questionnaire表主键',
  `text` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '答案',
  `is_del` tinyint(1) DEFAULT '1' COMMENT '1存在,0删除',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=974 DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='评价问卷答案表';

-- ----------------------------
-- Records of mc_evaluation_questionnaire_answer
-- ----------------------------

-- ----------------------------
-- Table structure for mc_evaluation_questionnaire_user
-- ----------------------------
DROP TABLE IF EXISTS `mc_evaluation_questionnaire_user`;
CREATE TABLE `mc_evaluation_questionnaire_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `order_id` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '订单id',
  `equ_name` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '姓名',
  `phone` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '用户手机',
  `create_time` int(10) DEFAULT NULL COMMENT '创建时间',
  `is_del` tinyint(1) DEFAULT '1' COMMENT '1存在,0删除',
  `type_id` tinyint(1) DEFAULT NULL COMMENT '类型id,1服务评价,2选样评价,3取件评价',
  `userid` int(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=175 DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='评价问卷用户表';

-- ----------------------------
-- Records of mc_evaluation_questionnaire_user
-- ----------------------------

-- ----------------------------
-- Table structure for mc_evaluation_questionnaire_user_answer
-- ----------------------------
DROP TABLE IF EXISTS `mc_evaluation_questionnaire_user_answer`;
CREATE TABLE `mc_evaluation_questionnaire_user_answer` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `eq_id` int(11) DEFAULT NULL COMMENT '题表 mc_evaluation_questionnaire 主键',
  `equ_id` int(11) DEFAULT NULL COMMENT '评价问卷用户表id  ,evaluation_questionnaire_user表主键',
  `eqa_id` int(11) DEFAULT NULL COMMENT '答案id  ,evaluation_questionnaire_answer 表主键',
  `is_del` tinyint(1) DEFAULT '1' COMMENT '1存在,0删除',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=211 DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='评价问卷用户答案表';

-- ----------------------------
-- Records of mc_evaluation_questionnaire_user_answer
-- ----------------------------

-- ----------------------------
-- Table structure for mc_examine
-- ----------------------------
DROP TABLE IF EXISTS `mc_examine`;
CREATE TABLE `mc_examine` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `brand_id` int(11) NOT NULL COMMENT '部门id',
  `topic_is_examine` tinyint(1) NOT NULL DEFAULT '1' COMMENT '帖子是否需要审核,1需要,0不需要',
  `comment_is_examine` tinyint(1) NOT NULL DEFAULT '1' COMMENT '帖子是否需要审核,1需要,0不需要',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='结婚圈 审核表';

-- ----------------------------
-- Records of mc_examine
-- ----------------------------

-- ----------------------------
-- Table structure for mc_give_thumbs_up
-- ----------------------------
DROP TABLE IF EXISTS `mc_give_thumbs_up`;
CREATE TABLE `mc_give_thumbs_up` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `tid` int(11) NOT NULL COMMENT 'Topic表主键',
  `uid` int(11) NOT NULL COMMENT '创建人 id',
  `create_time` int(10) NOT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=279 DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='结婚圈点赞表';

-- ----------------------------
-- Records of mc_give_thumbs_up
-- ----------------------------

-- ----------------------------
-- Table structure for mc_hot_search
-- ----------------------------
DROP TABLE IF EXISTS `mc_hot_search`;
CREATE TABLE `mc_hot_search` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(255) COLLATE utf8_bin NOT NULL COMMENT '名称',
  `is_show` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否显示,1显示,0隐藏',
  `sort` int(11) NOT NULL DEFAULT '100' COMMENT '排序,倒叙',
  `brand_id` int(11) NOT NULL COMMENT '部门id',
  `create_time` int(10) NOT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='热门搜索表';

-- ----------------------------
-- Records of mc_hot_search
-- ----------------------------

-- ----------------------------
-- Table structure for mc_play_integral
-- ----------------------------
DROP TABLE IF EXISTS `mc_play_integral`;
CREATE TABLE `mc_play_integral` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `image` varchar(255) COLLATE utf8_bin NOT NULL COMMENT '图片',
  `brand_id` int(11) NOT NULL COMMENT '部门id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='玩转积分表';

-- ----------------------------
-- Records of mc_play_integral
-- ----------------------------

-- ----------------------------
-- Table structure for mc_play_platina
-- ----------------------------
DROP TABLE IF EXISTS `mc_play_platina`;
CREATE TABLE `mc_play_platina` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `image` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brand_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of mc_play_platina
-- ----------------------------

-- ----------------------------
-- Table structure for mc_post_image
-- ----------------------------
DROP TABLE IF EXISTS `mc_post_image`;
CREATE TABLE `mc_post_image` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `tid` int(11) NOT NULL COMMENT 'Topic表主键',
  `image` varchar(255) COLLATE utf8_bin NOT NULL COMMENT '图片',
  `thumbnail` varchar(255) COLLATE utf8_bin NOT NULL COMMENT '缩略图',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=212 DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='结婚圈帖子图片表';

-- ----------------------------
-- Records of mc_post_image
-- ----------------------------

-- ----------------------------
-- Table structure for mc_prompt_text
-- ----------------------------
DROP TABLE IF EXISTS `mc_prompt_text`;
CREATE TABLE `mc_prompt_text` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `content` varchar(255) COLLATE utf8_bin NOT NULL COMMENT '内容',
  `type_id` int(11) NOT NULL COMMENT '类型id',
  `brand_id` int(11) NOT NULL COMMENT '部门id',
  `create_time` int(10) NOT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='提示文字表';

-- ----------------------------
-- Records of mc_prompt_text
-- ----------------------------

-- ----------------------------
-- Table structure for mc_topic
-- ----------------------------
DROP TABLE IF EXISTS `mc_topic`;
CREATE TABLE `mc_topic` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `title` varchar(255) COLLATE utf8_bin NOT NULL COMMENT '标题',
  `content` text COLLATE utf8_bin NOT NULL COMMENT '内容',
  `uid` int(11) NOT NULL COMMENT '创建人 id',
  `create_time` int(10) NOT NULL COMMENT '创建时间',
  `mc_sort` int(11) NOT NULL DEFAULT '100' COMMENT '排序,倒叙',
  `is_examine` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1已审核,0未审核',
  `cid` int(11) NOT NULL COMMENT '栏目id',
  `brand_id` int(11) NOT NULL COMMENT '部门id',
  `staff_id` int(11) DEFAULT '0',
  `staff_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT '0',
  `is_del` tinyint(4) DEFAULT '1',
  `is_top` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=256 DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='结婚圈 话题表';

-- ----------------------------
-- Records of mc_topic
-- ----------------------------

-- ----------------------------
-- Table structure for mc_user_photos
-- ----------------------------
DROP TABLE IF EXISTS `mc_user_photos`;
CREATE TABLE `mc_user_photos` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `title` varchar(255) COLLATE utf8_bin NOT NULL COMMENT '标题',
  `content` varchar(255) COLLATE utf8_bin NOT NULL COMMENT '内容',
  `image` varchar(255) COLLATE utf8_bin NOT NULL COMMENT '图片',
  `url` varchar(255) COLLATE utf8_bin NOT NULL COMMENT '链接',
  `is_show` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否显示,1显示,0隐藏',
  `sort` int(11) NOT NULL DEFAULT '100' COMMENT '排序,倒叙',
  `brand_id` int(11) NOT NULL COMMENT '部门id',
  `create_time` int(10) NOT NULL COMMENT '创建时间',
  `is_weiying` tinyint(1) DEFAULT '0' COMMENT '是否为唯映像',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='客照表';

-- ----------------------------
-- Records of mc_user_photos
-- ----------------------------

-- ----------------------------
-- Table structure for mc_video
-- ----------------------------
DROP TABLE IF EXISTS `mc_video`;
CREATE TABLE `mc_video` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `title` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '标题',
  `content` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '内容',
  `image` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '图片',
  `url` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '链接',
  `is_show` tinyint(1) DEFAULT '0' COMMENT '是否显示,1显示,0隐藏',
  `sort` int(11) DEFAULT '100' COMMENT '排序,倒叙',
  `brand_id` int(11) DEFAULT NULL COMMENT '部门id',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `is_weiying` tinyint(1) DEFAULT '0' COMMENT '是否为唯映像视频',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='视频表';

-- ----------------------------
-- Records of mc_video
-- ----------------------------

-- ----------------------------
-- Table structure for membereq
-- ----------------------------
DROP TABLE IF EXISTS `membereq`;
CREATE TABLE `membereq` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//会员权益说明id',
  `eq_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '//权益名称(类型)',
  `eq_count` text CHARACTER SET utf8 COMMENT '//权益类型说明',
  `eq_card_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '//哪种会员享受',
  `eq_img` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '//权益图片',
  `create_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//添加时间',
  `brandid` int(11) DEFAULT '0' COMMENT '//品牌id',
  `card_type_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '权益类别名称（生日礼）',
  `card_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '权益类别id',
  `couponids` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=91 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of membereq
-- ----------------------------

-- ----------------------------
-- Table structure for message
-- ----------------------------
DROP TABLE IF EXISTS `message`;
CREATE TABLE `message` (
  `m_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//消息表id',
  `mes_title` varchar(150) CHARACTER SET utf8 DEFAULT NULL COMMENT '//消息标题',
  `mes_count` text CHARACTER SET utf8 COMMENT '//消息内容',
  `mes_status` tinyint(4) DEFAULT NULL COMMENT '//是否查看 1查看 0 未查看',
  `mes_type` int(11) DEFAULT NULL COMMENT '//提醒类型 1投诉',
  `mes_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//阅读时间',
  `staff_id` int(11) DEFAULT NULL COMMENT '//员工id',
  `com_id` int(11) DEFAULT NULL COMMENT '//关联投诉建议表id',
  `brand_id` int(11) DEFAULT NULL COMMENT '//品牌id',
  `time_out` int(11) DEFAULT NULL COMMENT '//过期时间',
  PRIMARY KEY (`m_id`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of message
-- ----------------------------

-- ----------------------------
-- Table structure for minute_log
-- ----------------------------
DROP TABLE IF EXISTS `minute_log`;
CREATE TABLE `minute_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//积分日志id',
  `m_title` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//积分消费标题',
  `m_num` int(11) DEFAULT '0' COMMENT '//积分加减值',
  `m_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//操作时间',
  `m_executor` int(11) DEFAULT NULL COMMENT '//执行人',
  `m_type` int(11) DEFAULT NULL COMMENT '//积分类型(0后台修改，1首次登录、每日登录，2完成任务，3绑定手机，8推荐用户，9修改资料，11分享活动，12分享任务，13分享助力活动，14线下订单积分，15经纪人佣金)',
  `iswid` smallint(1) DEFAULT '0' COMMENT '0表示userid就是m_users里的id,1表示userid是m_we_users里的wid',
  `users_phone_id` int(11) DEFAULT NULL COMMENT 'users_phone表主键',
  `delete_time` datetime DEFAULT NULL,
  `create_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT '0' COMMENT '对应操作的标识',
  `is_get` tinyint(4) DEFAULT '1' COMMENT '是否领取，1已领取，2未领取',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=386301 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of minute_log
-- ----------------------------

-- ----------------------------
-- Table structure for money_log
-- ----------------------------
DROP TABLE IF EXISTS `money_log`;
CREATE TABLE `money_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `money` decimal(10,2) DEFAULT NULL,
  `m_type` tinyint(2) DEFAULT NULL COMMENT '类型，1充值，2提现，3佣金，4商城消费扣款，5商城取消订单退款',
  `m_type_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '记录类型名',
  `number` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '进出账流水号，提现：提现编号，佣金：推荐表id，商城：订单号',
  `user_id` int(11) DEFAULT NULL COMMENT 'm_users表id',
  `user_phone_id` int(11) DEFAULT NULL COMMENT 'm_user_phone表id',
  `create_time` datetime DEFAULT NULL COMMENT '操作时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of money_log
-- ----------------------------

-- ----------------------------
-- Table structure for m_address
-- ----------------------------
DROP TABLE IF EXISTS `m_address`;
CREATE TABLE `m_address` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '我的地址表id',
  `site_name` varchar(100) CHARACTER SET utf8 DEFAULT NULL COMMENT '//名称',
  `site_tel` varchar(100) CHARACTER SET utf8 DEFAULT NULL COMMENT '//电话',
  `site_address` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//地址',
  `site_home_type` tinyint(1) DEFAULT '2' COMMENT '//属于 1家2公司3父母家',
  `site_default` tinyint(1) DEFAULT '1' COMMENT '//是否设置当前地址为默认地址 1默认 2不默认',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of m_address
-- ----------------------------

-- ----------------------------
-- Table structure for m_admin_logs
-- ----------------------------
DROP TABLE IF EXISTS `m_admin_logs`;
CREATE TABLE `m_admin_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `userid` int(11) DEFAULT NULL COMMENT '用户id',
  `action_type` tinyint(1) DEFAULT NULL COMMENT '操作类型，增加1，修改2，删除3，登陆4',
  `operation_type` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '操作类别，1表示活动，2任务，3优惠券，4推荐管理',
  `operation_id` int(11) DEFAULT NULL COMMENT '操作的对象的id',
  `old_content` text COLLATE utf8_unicode_ci COMMENT '修改前的内容',
  `new_content` text COLLATE utf8_unicode_ci COMMENT '修改后的数据',
  `ip` varchar(25) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '登录ip地址',
  `create_time` datetime DEFAULT NULL COMMENT '操作时间',
  `update_time` datetime DEFAULT NULL,
  `delete_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='后台日志表';

-- ----------------------------
-- Records of m_admin_logs
-- ----------------------------

-- ----------------------------
-- Table structure for m_gift
-- ----------------------------
DROP TABLE IF EXISTS `m_gift`;
CREATE TABLE `m_gift` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '礼物名字',
  `money` decimal(10,2) DEFAULT '0.00',
  `score` int(11) unsigned zerofill DEFAULT '00000000000' COMMENT '送礼获得积分',
  `img` text COLLATE utf8_unicode_ci COMMENT '礼物图片',
  `sort` int(11) DEFAULT NULL COMMENT '排序，越小越靠前',
  `brand_id` int(11) DEFAULT NULL COMMENT '事业部id',
  `add_time` datetime DEFAULT NULL COMMENT '添加时间',
  `add_staff` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '添加人',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of m_gift
-- ----------------------------

-- ----------------------------
-- Table structure for m_money_log
-- ----------------------------
DROP TABLE IF EXISTS `m_money_log`;
CREATE TABLE `m_money_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '//储值金额日志id',
  `u_number` char(100) CHARACTER SET utf8 DEFAULT NULL COMMENT '//会员编号',
  `u_money` decimal(10,2) DEFAULT '0.00' COMMENT '//充值金额',
  `u_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//充值时间',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `staff_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `phone_id` int(11) DEFAULT NULL,
  `brand_id` int(11) DEFAULT NULL,
  `u_title` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of m_money_log
-- ----------------------------

-- ----------------------------
-- Table structure for m_mp_log
-- ----------------------------
DROP TABLE IF EXISTS `m_mp_log`;
CREATE TABLE `m_mp_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//扣费记录表',
  `m_id` int(11) DEFAULT NULL COMMENT '//消费用户',
  `m_money` decimal(10,2) DEFAULT '0.00' COMMENT '//扣费金额',
  `m_code` char(100) CHARACTER SET utf8 DEFAULT NULL COMMENT '//消费码',
  `m_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//扣款时间',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `order_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `m_title` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=65 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of m_mp_log
-- ----------------------------

-- ----------------------------
-- Table structure for m_order
-- ----------------------------
DROP TABLE IF EXISTS `m_order`;
CREATE TABLE `m_order` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//用户订单表',
  `order_time` datetime DEFAULT NULL COMMENT '//订单时间',
  `order_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '//订单编号',
  `one_money` decimal(10,2) DEFAULT NULL,
  `two_money` decimal(10,2) DEFAULT NULL,
  `one_detail` decimal(10,2) DEFAULT NULL,
  `two_detail` decimal(10,2) DEFAULT NULL,
  `order_userid` int(11) DEFAULT NULL COMMENT '//该订单消费人，user_phone表的id',
  `recommend_id` int(11) DEFAULT NULL COMMENT '关联介绍表id',
  `can_check` tinyint(2) DEFAULT '2' COMMENT '是否可审核，1是，2否，默认2',
  `is_check` tinyint(2) DEFAULT '0' COMMENT '是否通过审核，3可审核，1通过，2失败，默认0',
  `phone` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '手机号',
  `brandid` int(11) DEFAULT NULL,
  `package_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `total_money` decimal(10,2) DEFAULT '0.00',
  `create_time` datetime DEFAULT NULL,
  `order_type` tinyint(2) DEFAULT '2',
  `coupon_id` int(11) DEFAULT NULL COMMENT '优惠券id',
  `delete_time` datetime DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `award_money` decimal(10,2) DEFAULT NULL COMMENT '奖励金额',
  `is_get` tinyint(2) DEFAULT '2' COMMENT '领取奖励，1以领取，2未领取',
  `get_type` tinyint(2) DEFAULT NULL COMMENT '获取类型，1金额，2积分',
  `get_award` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '领取的奖励',
  `negative` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `video` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of m_order
-- ----------------------------

-- ----------------------------
-- Table structure for m_order_cameraman_score
-- ----------------------------
DROP TABLE IF EXISTS `m_order_cameraman_score`;
CREATE TABLE `m_order_cameraman_score` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orderId` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fc` int(11) DEFAULT NULL,
  `cameraman` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '摄影师',
  `score` int(11) DEFAULT NULL COMMENT '评分',
  `text` text COLLATE utf8_unicode_ci COMMENT '评价语',
  `add_time` datetime DEFAULT NULL COMMENT '添加时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='先睹为快 摄影师平分';

-- ----------------------------
-- Records of m_order_cameraman_score
-- ----------------------------

-- ----------------------------
-- Table structure for m_order_gift
-- ----------------------------
DROP TABLE IF EXISTS `m_order_gift`;
CREATE TABLE `m_order_gift` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orderId` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单号',
  `fc` int(11) DEFAULT NULL COMMENT '服次',
  `gift_id` int(11) DEFAULT NULL COMMENT '礼物id',
  `gift_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '礼物名称',
  `gift_img` text COLLATE utf8_unicode_ci COMMENT '礼物图片',
  `gift_money` decimal(10,2) DEFAULT NULL COMMENT '礼物价值',
  `gift_score` int(11) DEFAULT '0' COMMENT '操作赠送的人 获得的积分',
  `give_userid` int(11) DEFAULT NULL COMMENT '赠送人',
  `get_userid` int(11) DEFAULT NULL COMMENT '获得人',
  `add_time` datetime DEFAULT NULL COMMENT '添加入库时间',
  `pay_number` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '支付单号',
  `pay_time` datetime DEFAULT NULL COMMENT '支付时间（赠送成功时间）',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='订单服次先睹为快的礼物打赏记录';

-- ----------------------------
-- Records of m_order_gift
-- ----------------------------

-- ----------------------------
-- Table structure for m_order_wish
-- ----------------------------
DROP TABLE IF EXISTS `m_order_wish`;
CREATE TABLE `m_order_wish` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orderId` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fc` int(11) DEFAULT NULL,
  `wish` text COLLATE utf8_unicode_ci COMMENT '祝福语',
  `add_time` datetime DEFAULT NULL COMMENT '添加祝福时间',
  `user_id` int(11) DEFAULT NULL COMMENT '赠送祝福的人',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of m_order_wish
-- ----------------------------

-- ----------------------------
-- Table structure for m_users
-- ----------------------------
DROP TABLE IF EXISTS `m_users`;
CREATE TABLE `m_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户id',
  `phone` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '手机号',
  `username` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '用户名称',
  `password` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '密码',
  `sex` tinyint(1) DEFAULT '0' COMMENT '性别0女1男',
  `brithday` varchar(10) COLLATE utf8_unicode_ci DEFAULT '0' COMMENT '生日',
  `simg` varchar(255) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '头像',
  `merryday` int(8) DEFAULT '0' COMMENT '结婚日期',
  `openid` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '用户微信id',
  `ip` varchar(15) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '登录ip地址',
  `total_consumption` decimal(10,2) DEFAULT NULL COMMENT '总消费',
  `total_score` int(11) DEFAULT '0' COMMENT '总积分',
  `total_sign` int(11) DEFAULT '0' COMMENT '签到总数',
  `level` int(11) DEFAULT '1' COMMENT '用户级别',
  `growth_value` int(11) DEFAULT '0' COMMENT '成长值',
  `money` decimal(10,2) DEFAULT '0.00' COMMENT '账户余额',
  `brandid` int(10) DEFAULT '0' COMMENT '//用户所属事业部',
  `user_number` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '//会员卡号码',
  `status` tinyint(1) DEFAULT '1' COMMENT '是否停用0停用，1启用',
  `reg_time` datetime DEFAULT NULL COMMENT '注册时间（绑定手机号）',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '//修改时间',
  `delete_time` datetime DEFAULT NULL,
  `last_land_time` datetime DEFAULT NULL COMMENT '最后登陆的时间',
  `qq` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `weixin` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `address` varchar(300) COLLATE utf8_unicode_ci DEFAULT NULL,
  `remark` varchar(400) COLLATE utf8_unicode_ci DEFAULT NULL,
  `yun_user_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `yun_password` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `share_userid` int(10) DEFAULT '0' COMMENT '分享者id',
  `province` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '省',
  `real_address` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `real_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '真实姓名',
  `agent_type` tinyint(2) DEFAULT NULL COMMENT '申请类型，',
  `agent_status` tinyint(2) DEFAULT NULL COMMENT '1审核中，2审核通过，3审核不通过',
  `apply_time` datetime DEFAULT NULL COMMENT '经纪人申请时间',
  `check_apply_time` datetime DEFAULT NULL COMMENT '审核时间',
  `check_apply_user` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '审核人',
  `babysex` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=102 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='注册表';

-- ----------------------------
-- Records of m_users
-- ----------------------------

-- ----------------------------
-- Table structure for m_users_phone
-- ----------------------------
DROP TABLE IF EXISTS `m_users_phone`;
CREATE TABLE `m_users_phone` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '用户id',
  `phone` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '手机号',
  `total_score` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '积分',
  `level_id` int(11) DEFAULT NULL COMMENT '会员等级',
  `total_consumption` decimal(10,2) DEFAULT NULL COMMENT '总消费',
  `money` decimal(10,2) DEFAULT '0.00' COMMENT '账户余额',
  `username` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '用户名称',
  `reg_time` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '登陆的时间',
  `total_sign` int(11) DEFAULT '0' COMMENT '签到总数',
  `userid` int(11) DEFAULT '0' COMMENT 'm_users表的id',
  `growth_value` int(11) DEFAULT '0' COMMENT '成长值',
  `brithday` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '生日',
  `merryday` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '结婚日期',
  `sex` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '性别0女1男',
  `bind_time` int(11) DEFAULT '0' COMMENT '绑定的时间',
  `brandid` int(11) DEFAULT '0',
  `password` varchar(80) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '密码',
  `user_number` varchar(100) CHARACTER SET utf8 DEFAULT '' COMMENT '//会员编号',
  `update_time` datetime DEFAULT NULL,
  `last_land_time` datetime DEFAULT NULL,
  `pay_password` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `status` tinyint(1) DEFAULT '1' COMMENT '用户状态1表示正常，0表示冻结',
  `c_excel_import_id` int(11) DEFAULT '0',
  `truename` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `agent_status` tinyint(2) DEFAULT NULL COMMENT '1审核中，2审核通过，3审核不通过',
  `agent_type` tinyint(2) DEFAULT NULL,
  `real_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `apply_time` datetime DEFAULT NULL,
  `check_apply_user` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '审核人',
  `check_apply_time` datetime DEFAULT NULL,
  `freeze_money` decimal(10,2) DEFAULT '0.00' COMMENT '冻结金额，求可动用余额时需用money-freeze_money',
  `shareholderid` int(10) DEFAULT NULL COMMENT '股东码id',
  `shareholder_money` decimal(10,2) DEFAULT NULL,
  `agent_payment` tinyint(2) DEFAULT '0' COMMENT '聚光圈 （99会员 1 为会员 0 不是）',
  PRIMARY KEY (`id`),
  KEY `phone` (`phone`),
  KEY `userid` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='注册表';

-- ----------------------------
-- Records of m_users_phone
-- ----------------------------

-- ----------------------------
-- Table structure for m_users_recommend
-- ----------------------------
DROP TABLE IF EXISTS `m_users_recommend`;
CREATE TABLE `m_users_recommend` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL COMMENT '会员表id',
  `recommend_shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '推荐店',
  `recommend_staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '推荐人名字',
  `recommend_order_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '推荐订单',
  `add_time` datetime DEFAULT NULL COMMENT '添加时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of m_users_recommend
-- ----------------------------

-- ----------------------------
-- Table structure for m_withdraw
-- ----------------------------
DROP TABLE IF EXISTS `m_withdraw`;
CREATE TABLE `m_withdraw` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_phone_id` int(11) DEFAULT NULL,
  `user_true_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `user_number` varchar(200) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '用户 编号',
  `user_bank` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `bank_code` char(200) COLLATE utf8_unicode_ci DEFAULT '',
  `bank_status` tinyint(1) DEFAULT '1',
  `brandid` int(11) DEFAULT '0',
  `bank_time` datetime NOT NULL,
  `userid` int(11) DEFAULT NULL COMMENT 'm_users表id',
  `id_card` char(25) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '身份证',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of m_withdraw
-- ----------------------------

-- ----------------------------
-- Table structure for m_withdraw_log
-- ----------------------------
DROP TABLE IF EXISTS `m_withdraw_log`;
CREATE TABLE `m_withdraw_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `get_money` decimal(10,2) DEFAULT '0.00',
  `get_time` datetime DEFAULT NULL,
  `user_phone_id` int(11) DEFAULT NULL COMMENT 'm_user_phone表主键id',
  `money_status` tinyint(1) DEFAULT '2' COMMENT '1是到账成功2是处理中3是失败',
  `staff_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `exe_time` datetime DEFAULT NULL,
  `error_state` varchar(225) COLLATE utf8_unicode_ci DEFAULT '',
  `brandid` int(11) DEFAULT '0',
  `get_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '提现编号',
  `userid` int(11) DEFAULT NULL COMMENT 'm_users表主键id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of m_withdraw_log
-- ----------------------------

-- ----------------------------
-- Table structure for open_verify
-- ----------------------------
DROP TABLE IF EXISTS `open_verify`;
CREATE TABLE `open_verify` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//是否开启手机验证码',
  `status` int(11) DEFAULT '1' COMMENT '// 0是关闭 1是开启',
  `type` int(11) DEFAULT NULL COMMENT '//验证码类型  1是手机2是其它',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of open_verify
-- ----------------------------

-- ----------------------------
-- Table structure for payment_log
-- ----------------------------
DROP TABLE IF EXISTS `payment_log`;
CREATE TABLE `payment_log` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `action` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '日志标题',
  `create_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `userid` int(11) DEFAULT NULL,
  `newdata` text COLLATE utf8_unicode_ci,
  `olddata` text COLLATE utf8_unicode_ci,
  `updatetime` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `phoneid` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of payment_log
-- ----------------------------

-- ----------------------------
-- Table structure for praise
-- ----------------------------
DROP TABLE IF EXISTS `praise`;
CREATE TABLE `praise` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `userid` int(10) DEFAULT NULL,
  `img` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `create_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `status` tinyint(2) DEFAULT NULL COMMENT '1 已审核 2未通过审核 3未审核',
  `brandid` int(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of praise
-- ----------------------------

-- ----------------------------
-- Table structure for recommend
-- ----------------------------
DROP TABLE IF EXISTS `recommend`;
CREATE TABLE `recommend` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `r_username` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '被推荐姓名',
  `r_phone` char(11) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '被推荐手机',
  `r_sex` tinyint(3) DEFAULT '1' COMMENT '//推荐人性别 1男2女',
  `userid` int(11) DEFAULT '0' COMMENT '推荐人的userid',
  `create_time` datetime DEFAULT NULL COMMENT '推荐时间',
  `status` tinyint(1) DEFAULT '0' COMMENT '状态  //3是审核中 2 是通过 1是未通过',
  `check_user` varchar(30) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '审核人',
  `check_msg` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '审核说明',
  `update_time` datetime DEFAULT NULL COMMENT '审核时间',
  `recom_num` int(11) DEFAULT '0' COMMENT '//推荐积分',
  `delete_time` datetime DEFAULT NULL,
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  `iswid` smallint(1) DEFAULT '0' COMMENT '0表示userid就是m_users里的id,1表示userid是m_we_users里的wid',
  `price_type` tinyint(1) DEFAULT '1',
  `sell_counselor` varchar(150) COLLATE utf8_unicode_ci DEFAULT '',
  `remark` text COLLATE utf8_unicode_ci,
  `servant_money` decimal(10,2) DEFAULT '0.00' COMMENT '//佣金',
  `secretary_id` int(11) DEFAULT NULL COMMENT '会员秘书，暂时不用了',
  `is_ok` tinyint(2) DEFAULT '0' COMMENT '次推荐是否成单，1是，0否（订单是否通过审核，1是，2否，0审核中）',
  `order_time` datetime DEFAULT NULL,
  `order_money` decimal(10,2) DEFAULT NULL,
  `award_money` decimal(10,0) DEFAULT NULL COMMENT '可领取现金奖励',
  `is_get` tinyint(2) DEFAULT '2' COMMENT '是否领取奖励，1是，2否',
  `get_type` tinyint(2) DEFAULT NULL COMMENT '领取奖励类型，1现金，2积分',
  `get_award` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '获得的奖励',
  `user_phone` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=74 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='推荐表';

-- ----------------------------
-- Records of recommend
-- ----------------------------

-- ----------------------------
-- Table structure for recommend_photo_type
-- ----------------------------
DROP TABLE IF EXISTS `recommend_photo_type`;
CREATE TABLE `recommend_photo_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brand_id` int(11) DEFAULT NULL,
  `staff_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of recommend_photo_type
-- ----------------------------

-- ----------------------------
-- Table structure for recommend_rule
-- ----------------------------
DROP TABLE IF EXISTS `recommend_rule`;
CREATE TABLE `recommend_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule` text COLLATE utf8_unicode_ci,
  `brand_id` int(11) DEFAULT NULL,
  `staff_id` int(100) DEFAULT NULL,
  `staff_name` varchar(11) COLLATE utf8_unicode_ci DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of recommend_rule
-- ----------------------------

-- ----------------------------
-- Table structure for recommend_user
-- ----------------------------
DROP TABLE IF EXISTS `recommend_user`;
CREATE TABLE `recommend_user` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `username` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '股东帐号名称',
  `password` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `create_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `staff_id` int(11) DEFAULT NULL,
  `staff_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `b_id` int(10) DEFAULT NULL COMMENT '卡包id',
  `brandid` int(10) DEFAULT NULL,
  `amount` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sort` int(10) NOT NULL,
  `is_del` tinyint(1) DEFAULT '1' COMMENT '1（未删除）2（已删除）',
  `userid` int(10) DEFAULT NULL,
  `user_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '被注册会员昵称',
  `is_get` int(10) DEFAULT NULL COMMENT '是否被注册（2 已注册 1 未被注册）',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of recommend_user
-- ----------------------------

-- ----------------------------
-- Table structure for record
-- ----------------------------
DROP TABLE IF EXISTS `record`;
CREATE TABLE `record` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//兑换类型表',
  `user_id` int(11) DEFAULT '0' COMMENT '//用户id',
  `card_id` int(11) DEFAULT '0' COMMENT '//卡级别',
  `create_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//兑换日期',
  `way` int(255) DEFAULT '0' COMMENT '//兑换方式(1购买，2兑换)',
  `consume` decimal(10,0) DEFAULT NULL,
  `ditch` int(11) DEFAULT '0' COMMENT '//支付渠道(1微信，2成长值,3支付宝)',
  `orderid` varchar(80) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '//订单号',
  `status` int(255) DEFAULT '0' COMMENT '//状态(1成功2失败)',
  `status_explain` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '\\\\状态说明',
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of record
-- ----------------------------

-- ----------------------------
-- Table structure for rule_money
-- ----------------------------
DROP TABLE IF EXISTS `rule_money`;
CREATE TABLE `rule_money` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '//提现说明',
  `money_explain` text COLLATE utf8_unicode_ci,
  `monry_time` text COLLATE utf8_unicode_ci,
  `staff_id` int(11) DEFAULT '0' COMMENT '//员工id',
  `brand_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of rule_money
-- ----------------------------

-- ----------------------------
-- Table structure for secretary
-- ----------------------------
DROP TABLE IF EXISTS `secretary`;
CREATE TABLE `secretary` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `phone` varchar(11) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandid` int(11) DEFAULT '0',
  `create_time` datetime NOT NULL,
  `staff_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='会员秘书';

-- ----------------------------
-- Records of secretary
-- ----------------------------

-- ----------------------------
-- Table structure for share_detail
-- ----------------------------
DROP TABLE IF EXISTS `share_detail`;
CREATE TABLE `share_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(11) DEFAULT '0' COMMENT '用户id',
  `sourceid` tinyint(1) DEFAULT '0' COMMENT '1表示活动，2表示任务，3表示助力活动',
  `score` int(11) DEFAULT '0' COMMENT '积分数量',
  `shareid` int(11) NOT NULL DEFAULT '0' COMMENT '被分享id',
  `status` tinyint(1) DEFAULT '0' COMMENT '1成功0失败',
  `share_url` varchar(200) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '分享的url地址',
  `ip` varchar(20) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '用户ip',
  `create_time` datetime DEFAULT NULL COMMENT '分享时间',
  `delete_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  `iswid` smallint(1) DEFAULT '0' COMMENT '0表示userid就是m_users里的id,1表示userid是m_we_users里的wid',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='分享积分记录表';

-- ----------------------------
-- Records of share_detail
-- ----------------------------

-- ----------------------------
-- Table structure for share_setup
-- ----------------------------
DROP TABLE IF EXISTS `share_setup`;
CREATE TABLE `share_setup` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `adduserid` int(11) DEFAULT '0' COMMENT '用户id',
  `addusername` varchar(100) COLLATE utf8_unicode_ci DEFAULT '0' COMMENT '1表示活动，2表示任务',
  `title` int(11) DEFAULT '0' COMMENT '积分数量',
  `content` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0' COMMENT '被分享id',
  `keywords` varchar(150) COLLATE utf8_unicode_ci DEFAULT '0' COMMENT '1成功0失败',
  `share_img` varchar(200) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '分享的时的图片',
  `brandid` int(11) DEFAULT '0' COMMENT '品牌id',
  `create_time` datetime DEFAULT NULL COMMENT '分享时间',
  `delete_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='分享积分记录表';

-- ----------------------------
-- Records of share_setup
-- ----------------------------

-- ----------------------------
-- Table structure for sign
-- ----------------------------
DROP TABLE IF EXISTS `sign`;
CREATE TABLE `sign` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '//签到展示id',
  `userid` int(11) DEFAULT NULL COMMENT '//用户id',
  `num` int(11) DEFAULT NULL COMMENT '//所得积分',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of sign
-- ----------------------------

-- ----------------------------
-- Table structure for sign_awa
-- ----------------------------
DROP TABLE IF EXISTS `sign_awa`;
CREATE TABLE `sign_awa` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//签到额外奖励表',
  `userid` int(11) DEFAULT '0' COMMENT '//用户id',
  `sign_day` int(11) DEFAULT '0' COMMENT '//连续天数',
  `sign_num` int(11) DEFAULT '0' COMMENT '//所得积分',
  `create_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//领取时间',
  `sign_type` int(11) DEFAULT '2' COMMENT '//1积分2是优惠券',
  `type` tinyint(1) DEFAULT NULL COMMENT '//1是累计2是连续',
  `iswid` smallint(1) DEFAULT '0' COMMENT '0表示userid就是m_users里的id,1表示userid是m_we_users里的wid',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of sign_awa
-- ----------------------------

-- ----------------------------
-- Table structure for sign_continuous
-- ----------------------------
DROP TABLE IF EXISTS `sign_continuous`;
CREATE TABLE `sign_continuous` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//连续奖励列表id',
  `sign_type` int(11) DEFAULT '0' COMMENT '//奖励类型  积分还是优惠券',
  `sign_days` int(11) DEFAULT '0' COMMENT '//连续几天',
  `sign_miun` int(11) DEFAULT '0' COMMENT '//连续奖励的分值/面额',
  `sign_grand` int(11) DEFAULT '0' COMMENT '//是签到还是累计',
  `iswid` smallint(1) DEFAULT '0' COMMENT '0表示userid就是m_users里的id,1表示userid是m_we_users里的wid',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of sign_continuous
-- ----------------------------

-- ----------------------------
-- Table structure for sign_detail
-- ----------------------------
DROP TABLE IF EXISTS `sign_detail`;
CREATE TABLE `sign_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '签到id',
  `userid` int(11) DEFAULT NULL COMMENT '用户id',
  `sign_time` datetime DEFAULT NULL COMMENT '签到日期',
  `sign_sum` int(11) DEFAULT NULL COMMENT '//会员连续签到次数',
  `sign_create` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//初始时间',
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of sign_detail
-- ----------------------------

-- ----------------------------
-- Table structure for sign_detail_201903
-- ----------------------------
DROP TABLE IF EXISTS `sign_detail_201903`;
CREATE TABLE `sign_detail_201903` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(11) DEFAULT NULL,
  `sign_time` datetime DEFAULT NULL,
  `sign_sum` int(11) DEFAULT NULL,
  `sign_create` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of sign_detail_201903
-- ----------------------------

-- ----------------------------
-- Table structure for sign_detail_201904
-- ----------------------------
DROP TABLE IF EXISTS `sign_detail_201904`;
CREATE TABLE `sign_detail_201904` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(11) DEFAULT NULL,
  `sign_time` datetime DEFAULT NULL,
  `sign_sum` int(11) DEFAULT NULL,
  `sign_create` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of sign_detail_201904
-- ----------------------------

-- ----------------------------
-- Table structure for sign_detail_201905
-- ----------------------------
DROP TABLE IF EXISTS `sign_detail_201905`;
CREATE TABLE `sign_detail_201905` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(11) DEFAULT NULL,
  `sign_time` datetime DEFAULT NULL,
  `sign_sum` int(11) DEFAULT NULL,
  `sign_create` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of sign_detail_201905
-- ----------------------------

-- ----------------------------
-- Table structure for sign_detail_201906
-- ----------------------------
DROP TABLE IF EXISTS `sign_detail_201906`;
CREATE TABLE `sign_detail_201906` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(11) DEFAULT NULL,
  `sign_time` datetime DEFAULT NULL,
  `sign_sum` int(11) DEFAULT NULL,
  `sign_create` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of sign_detail_201906
-- ----------------------------

-- ----------------------------
-- Table structure for sign_detail_201907
-- ----------------------------
DROP TABLE IF EXISTS `sign_detail_201907`;
CREATE TABLE `sign_detail_201907` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(11) DEFAULT NULL,
  `sign_time` datetime DEFAULT NULL,
  `sign_sum` int(11) DEFAULT NULL,
  `sign_create` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of sign_detail_201907
-- ----------------------------

-- ----------------------------
-- Table structure for sign_detail_201908
-- ----------------------------
DROP TABLE IF EXISTS `sign_detail_201908`;
CREATE TABLE `sign_detail_201908` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(11) DEFAULT NULL,
  `sign_time` datetime DEFAULT NULL,
  `sign_sum` int(11) DEFAULT NULL,
  `sign_create` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of sign_detail_201908
-- ----------------------------

-- ----------------------------
-- Table structure for sign_detail_201909
-- ----------------------------
DROP TABLE IF EXISTS `sign_detail_201909`;
CREATE TABLE `sign_detail_201909` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(11) DEFAULT NULL,
  `sign_time` datetime DEFAULT NULL,
  `sign_sum` int(11) DEFAULT NULL,
  `sign_create` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of sign_detail_201909
-- ----------------------------

-- ----------------------------
-- Table structure for sign_detail_201912
-- ----------------------------
DROP TABLE IF EXISTS `sign_detail_201912`;
CREATE TABLE `sign_detail_201912` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(11) DEFAULT NULL,
  `sign_time` datetime DEFAULT NULL,
  `sign_sum` int(11) DEFAULT NULL,
  `sign_create` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of sign_detail_201912
-- ----------------------------

-- ----------------------------
-- Table structure for sign_detail_202001
-- ----------------------------
DROP TABLE IF EXISTS `sign_detail_202001`;
CREATE TABLE `sign_detail_202001` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(11) DEFAULT NULL,
  `sign_time` datetime DEFAULT NULL,
  `sign_sum` int(11) DEFAULT NULL,
  `sign_create` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of sign_detail_202001
-- ----------------------------

-- ----------------------------
-- Table structure for sign_get
-- ----------------------------
DROP TABLE IF EXISTS `sign_get`;
CREATE TABLE `sign_get` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//领取表',
  `awa_id` int(11) DEFAULT '0' COMMENT '//领取id',
  `userid` int(11) DEFAULT NULL COMMENT '//用户id',
  `type` tinyint(1) DEFAULT NULL COMMENT '//1累计2是签到',
  `iswid` tinyint(1) DEFAULT '0' COMMENT '0表示userid就是m_users里的id,1表示userid是m_we_users里的wid',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of sign_get
-- ----------------------------

-- ----------------------------
-- Table structure for s_cat
-- ----------------------------
DROP TABLE IF EXISTS `s_cat`;
CREATE TABLE `s_cat` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` tinyint(1) DEFAULT '1' COMMENT '是否使用：1：使用；2：禁用',
  `is_delete` tinyint(1) DEFAULT '1' COMMENT '是否删除：1：不删除；2：删除',
  `sort` int(5) DEFAULT '1' COMMENT '排序',
  `brandclass_id` int(11) DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='产品分类表';

-- ----------------------------
-- Records of s_cat
-- ----------------------------

-- ----------------------------
-- Table structure for s_history
-- ----------------------------
DROP TABLE IF EXISTS `s_history`;
CREATE TABLE `s_history` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '搜索的标题',
  `userid` int(10) NOT NULL COMMENT '用户的id(m_user主键id）',
  `username` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT ' 用户名',
  `brandid` int(10) DEFAULT NULL COMMENT '事业部',
  `create_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=67 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_history
-- ----------------------------

-- ----------------------------
-- Table structure for s_index
-- ----------------------------
DROP TABLE IF EXISTS `s_index`;
CREATE TABLE `s_index` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '标题',
  `img` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '图标',
  `cateid` int(10) DEFAULT NULL COMMENT '类别id',
  `brandid` int(10) DEFAULT NULL,
  `staff_id` int(10) DEFAULT NULL COMMENT '操作员id',
  `staff_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '操作员名称',
  `create_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '添加时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_index
-- ----------------------------

-- ----------------------------
-- Table structure for s_married
-- ----------------------------
DROP TABLE IF EXISTS `s_married`;
CREATE TABLE `s_married` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandid` int(10) DEFAULT NULL,
  `create_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_married
-- ----------------------------

-- ----------------------------
-- Table structure for s_menu
-- ----------------------------
DROP TABLE IF EXISTS `s_menu`;
CREATE TABLE `s_menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `fid` int(11) DEFAULT '0',
  `menu_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `menu_url` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `menu_icon` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `status` tinyint(1) DEFAULT '1',
  `sort` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=764 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_menu
-- ----------------------------
INSERT INTO `s_menu` VALUES ('1', '首页', '716', 'menu1523192496', '/vip/index/index', 'fa-home', '1', '1');
INSERT INTO `s_menu` VALUES ('2', '会员统计', '716', 'menu1555739896', '/vip/ucount/index', 'fa-line-chart', '1', '2');
INSERT INTO `s_menu` VALUES ('5', '会员列表', '716', 'menu1555738002', '/vip/users/index', 'fa-user', '1', '1');
INSERT INTO `s_menu` VALUES ('6', '会员规则设置', '716', 'menu1555727144', '/vip/level/index', 'fa-suitcase', '1', '3');
INSERT INTO `s_menu` VALUES ('7', '会员卡管理', '716', 'menu1557977302', '/vip/card/index', 'fa-credit-card', '0', '5');
INSERT INTO `s_menu` VALUES ('8', '摄影师管理', '718', 'menu1557978261', '/vip/cameraman/index', 'fa-camera', '0', '6');
INSERT INTO `s_menu` VALUES ('9', '会员活动', '717', 'menu1555738170', '/vip/activity/index', 'fa-gift', '1', '1');
INSERT INTO `s_menu` VALUES ('10', '活动报名管理', '9', 'menu1555738065', '/vip/signup/index', 'fa-tags', '1', '2');
INSERT INTO `s_menu` VALUES ('12', '优惠券列表', '727', 'menu1555650549', '/vip/coupon/index', 'fa-money', '1', '2');
INSERT INTO `s_menu` VALUES ('13', '任务管理', '719', 'menu1555651100', '/vip/task/index', 'fa-tags', '1', '1');
INSERT INTO `s_menu` VALUES ('14', '分享管理', '719', 'menu1557978137', '/vip/share/index', 'fa-share-alt', '0', '3');
INSERT INTO `s_menu` VALUES ('15', '客户推荐管理', '719', 'menu1555651120', '/vip/recommend/index', 'fa-user-plus', '1', '2');
INSERT INTO `s_menu` VALUES ('16', '投诉建议管理', '718', 'menu1555651218', '/vip/commend/index', 'fa-envelope-o', '1', '0');
INSERT INTO `s_menu` VALUES ('27', '财务管理', '718', 'menu1555651279', '/vip/disposemoney/index', 'fa-money', '1', '0');
INSERT INTO `s_menu` VALUES ('30', '会员秘书管理', '718', 'menu1555651294', '/vip/secretary/index', 'fa-user-plus', '0', '0');
INSERT INTO `s_menu` VALUES ('36', '广告位管理', '715', 'menu1555740495', '/vip/advertising/index', 'fa-map-marker', '1', '2');
INSERT INTO `s_menu` VALUES ('37', '微信菜单', '720', 'menu1555651653', '/vip/weixinconfig/menu', 'fa-database', '1', '0');
INSERT INTO `s_menu` VALUES ('38', '权限设定', '722', 'menu1555653164', '/vip/setting/permission', 'fa-cog', '1', '0');
INSERT INTO `s_menu` VALUES ('45', '添加用户级别', '3', 'menu1515979054', '/vip/level/add', '', '0', '0');
INSERT INTO `s_menu` VALUES ('46', '修改用户级别', '3', 'menu1516069919', '/vip/level/edit', '', '0', '0');
INSERT INTO `s_menu` VALUES ('47', '删除用户级别', '3', 'menu1516069926', '/vip/level/del', '', '0', '0');
INSERT INTO `s_menu` VALUES ('49', '修改积分规则', '6', 'menu1515979203', '/vip/scorerule/edit', '', '0', '0');
INSERT INTO `s_menu` VALUES ('51', '会员权益', '716', 'menu1555740054', '/vip/memberq/index', 'fa-vcard-o', '1', '4');
INSERT INTO `s_menu` VALUES ('52', '添加会员权益', '6', 'menu1515979594', '/vip/memberq/add', '', '0', '0');
INSERT INTO `s_menu` VALUES ('53', '删除会员权益', '6', 'menu1555734082', '/vip/memberq/del', '', '0', '0');
INSERT INTO `s_menu` VALUES ('54', '成长值规则设置', '3', 'menu1515979841', '/vip/level/setgrowthrule', '', '1', '0');
INSERT INTO `s_menu` VALUES ('55', '查看会员导入记录', '5', 'menu1555737908', '/vip/users/importlist', '', '0', '0');
INSERT INTO `s_menu` VALUES ('56', '下载导入源文件和导出出错的文件', '5', 'menu1555734211', '/vip/users/downexcel', '', '0', '0');
INSERT INTO `s_menu` VALUES ('57', '导入会员', '5', 'menu1555734218', '/vip/users/upexcel', '', '0', '0');
INSERT INTO `s_menu` VALUES ('58', '设置会员状态', '5', 'menu1555734223', '/vip/users/setstatus', '', '0', '0');
INSERT INTO `s_menu` VALUES ('59', '删除会员', '5', 'menu1517477622', '/vip/users/del', '', '0', '0');
INSERT INTO `s_menu` VALUES ('60', '添加会员卡', '4', 'menu1516078657', '/vip/card/add', '', '0', '0');
INSERT INTO `s_menu` VALUES ('61', '修改会员卡信息', '4', 'menu1516006440', '/vip/card/edit', '', '0', '0');
INSERT INTO `s_menu` VALUES ('62', '删除会员卡', '4', 'menu1516006491', '/vip/card/del', '', '0', '0');
INSERT INTO `s_menu` VALUES ('63', '查看卡片出售列表', '4', 'menu1516078682', '/vip/card/detail', '', '1', '0');
INSERT INTO `s_menu` VALUES ('64', '添加摄影师', '8', 'menu1517477763', '/vip/cameraman/add', '', '0', '0');
INSERT INTO `s_menu` VALUES ('65', '修改摄影师信息', '8', 'menu1517477784', '/vip/cameraman/edit', '', '0', '0');
INSERT INTO `s_menu` VALUES ('66', '删除摄影师信息', '8', 'menu1517477799', '/vip/cameraman/del', '', '0', '0');
INSERT INTO `s_menu` VALUES ('67', '查看摄影师预约表', '8', 'menu1555736273', '/vip/cameraman/make', '', '0', '0');
INSERT INTO `s_menu` VALUES ('68', '查看摄影师订单表', '8', 'menu1555736286', '/vip/cameraman/order', '', '0', '0');
INSERT INTO `s_menu` VALUES ('69', '添加新活动', '726', 'menu1555737095', '/vip/activity/add', '', '0', '1');
INSERT INTO `s_menu` VALUES ('70', '修改活动信息', '726', 'menu1555737109', '/vip/activity/edit', '', '0', '2');
INSERT INTO `s_menu` VALUES ('71', '设置活动状态', '726', 'menu1555737125', '/vip/activity/setstatus', '', '0', '3');
INSERT INTO `s_menu` VALUES ('72', '删除活动信息', '726', 'menu1555737139', '/vip/activity/del', '', '0', '4');
INSERT INTO `s_menu` VALUES ('73', '活动推广链接', '9', 'menu1555737497', '/vip/activity/linkcenter', '', '1', '6');
INSERT INTO `s_menu` VALUES ('74', '生成活动推广链接', '726', 'menu1555737156', '/vip/activity/makecode', '', '0', '5');
INSERT INTO `s_menu` VALUES ('75', '更改活动报名信息状态', '10', 'menu1555735604', '/vip/signup/setstatus', '', '0', '0');
INSERT INTO `s_menu` VALUES ('76', '删除活动报名信息', '10', 'menu1517478181', '/vip/signup/del', '', '0', '0');
INSERT INTO `s_menu` VALUES ('79', '新增优惠券', '12', 'menu1517478285', '/vip/coupon/addcoupon', '', '0', '0');
INSERT INTO `s_menu` VALUES ('80', '修改优惠券信息', '12', 'menu1517478315', '/vip/coupon/editcoupon', '', '0', '0');
INSERT INTO `s_menu` VALUES ('81', '删除优惠券', '12', 'menu1517478336', '/vip/coupon/delcoupon', '', '0', '0');
INSERT INTO `s_menu` VALUES ('82', '优惠券类型', '727', 'menu1555739117', '/vip/coupontype/index', '', '1', '2');
INSERT INTO `s_menu` VALUES ('83', '添加优惠券类型', '82', 'menu1555739144', '/vip/coupontype/add', '', '0', '1');
INSERT INTO `s_menu` VALUES ('84', '删除优惠券类型', '82', 'menu1555739160', '/vip/coupontype/del', '', '0', '2');
INSERT INTO `s_menu` VALUES ('85', '查看优惠券领取详情', '12', 'menu1555735789', '/vip/coupon/receivedetail', '', '0', '0');
INSERT INTO `s_menu` VALUES ('86', '更改优惠券使用状态', '12', 'menu1555735798', '/vip/coupon/setcouponstatus', '', '0', '0');
INSERT INTO `s_menu` VALUES ('87', '添加新任务', '13', 'menu1517484906', '/vip/task/add', '', '0', '0');
INSERT INTO `s_menu` VALUES ('88', '修改任务信息', '13', 'menu1517484936', '/vip/task/edit', '', '0', '0');
INSERT INTO `s_menu` VALUES ('89', '删除任务信息', '13', 'menu1517484956', '/vip/task/del', '', '0', '0');
INSERT INTO `s_menu` VALUES ('90', '查看任务领取详情', '10', 'menu1555735640', '/vip/task/taskdetail', '', '0', '0');
INSERT INTO `s_menu` VALUES ('91', '查看用户做任务详情', '10', 'menu1555735666', '/vip/task/dodetail', '', '0', '0');
INSERT INTO `s_menu` VALUES ('92', '设置活动状态', '10', 'menu1555735674', '/vip/task/setstatus', '', '0', '0');
INSERT INTO `s_menu` VALUES ('93', '审核用户推荐信息的状态', '15', 'menu1526565876', '/vip/recommend/setstatus', '', '0', '2');
INSERT INTO `s_menu` VALUES ('94', '删除转推荐信息', '15', 'menu1517485027', '/vip/recommend/del', '', '0', '0');
INSERT INTO `s_menu` VALUES ('95', '查看投诉建议详情', '16', 'menu1555736208', '/vip/commend/view', '', '0', '0');
INSERT INTO `s_menu` VALUES ('96', '删除投诉建议', '16', 'menu1517485088', '/vip/commend/del', '', '0', '0');
INSERT INTO `s_menu` VALUES ('97', '更改投诉建议状态', '16', 'menu1555736221', '/vip/commend/setstatus', '', '0', '0');
INSERT INTO `s_menu` VALUES ('98', '查看积分规则列表', '3', 'menu1516073874', '/vip/scorerule/index', '', '1', '0');
INSERT INTO `s_menu` VALUES ('99', '修改会员权益', '6', 'menu1555734013', '/vip/memberq/edit', '', '0', '0');
INSERT INTO `s_menu` VALUES ('100', '设置卡状态', '4', 'menu1516079786', '/vip/card/setstatus', '', '1', '0');
INSERT INTO `s_menu` VALUES ('101', '查看活动推广链接浏览详情', '73', 'menu1555737549', '/vip/activity/visitdetail', '', '0', '1');
INSERT INTO `s_menu` VALUES ('102', '删除活动推广链接', '73', 'menu1555737577', '/vip/activity/linkdel', '', '0', '2');
INSERT INTO `s_menu` VALUES ('103', '修改优惠信息', '12', 'menu1517484785', '/vip/coupontype/edit', '', '0', '0');
INSERT INTO `s_menu` VALUES ('104', '添加广告位', '36', 'menu1517485296', '/vip/advertising/add', '', '0', '0');
INSERT INTO `s_menu` VALUES ('105', '修改广告位信息', '36', 'menu1516094971', '/vip/advertising/edit', '', '0', '0');
INSERT INTO `s_menu` VALUES ('106', '删除广告位信息', '36', 'menu1516095023', '/vip/advertising/del', '', '0', '0');
INSERT INTO `s_menu` VALUES ('108', '添加菜单功能', '38', 'menu1516096262', '/vip/setting/addmenu', '', '0', '0');
INSERT INTO `s_menu` VALUES ('110', '删除菜单', '38', 'menu1516096247', '/vip/setting/delmenu', '', '0', '0');
INSERT INTO `s_menu` VALUES ('114', '添加微信菜单', '37', 'menu1517485146', '/vip/weixinconfig/addmenu', '', '0', '0');
INSERT INTO `s_menu` VALUES ('115', '修改微信菜单', '37', 'menu1517485174', '/vip/weixinconfig/editmenu', '', '0', '0');
INSERT INTO `s_menu` VALUES ('116', '删除微信菜单', '37', 'menu1516256523', '/vip/weixinconfig/delmenu', '', '0', '0');
INSERT INTO `s_menu` VALUES ('117', '查看会员系统固定菜单连接', '720', 'menu1555735901', '/vip/weixinconfig/wxlink', '', '0', '1');
INSERT INTO `s_menu` VALUES ('118', '关键词自动回复', '729', 'menu1555741030', '/vip/weixinconfig/relay', 'fa-flash', '1', '2');
INSERT INTO `s_menu` VALUES ('119', '修改回复消息', '118', 'menu1555651512', '/vip/weixinconfig/editrelay', '', '0', '0');
INSERT INTO `s_menu` VALUES ('120', '添加回复信息', '118', 'menu1555651538', '/vip/weixinconfig/addrelay', '', '0', '0');
INSERT INTO `s_menu` VALUES ('121', '删除回复信息', '118', 'menu1555651556', '/vip/weixinconfig/delrelay', '', '0', '0');
INSERT INTO `s_menu` VALUES ('122', '更新微信公众号菜单', '37', 'menu1555735849', '/vip/weixinconfig/setwxmenu', '', '0', '0');
INSERT INTO `s_menu` VALUES ('123', '关注自动回复', '729', 'menu1555741057', '/vip/weixinconfig/setdefault', '', '1', '2');
INSERT INTO `s_menu` VALUES ('133', '添加会员秘书', '30', 'menu1517470908', '/vip/secretary/add', '', '0', '0');
INSERT INTO `s_menu` VALUES ('134', '修改会员秘书', '30', 'menu1517470944', '/vip/secretary/edit', '', '0', '0');
INSERT INTO `s_menu` VALUES ('135', '删除会员秘书', '30', 'menu1517470986', '/vip/secretary/del', '', '0', '0');
INSERT INTO `s_menu` VALUES ('136', '修改用户积分', '5', 'menu1555733994', '/vip/users/setscore', '', '0', '0');
INSERT INTO `s_menu` VALUES ('137', '设置用户级别', '5', 'menu1555734232', '/vip/users/setgrowth', '', '0', '0');
INSERT INTO `s_menu` VALUES ('138', '微信渠道管理', '717', 'menu1555652151', '/vip/wxextend/index', 'fa-share-alt', '1', '90');
INSERT INTO `s_menu` VALUES ('140', '给会员群发短信', '5', 'menu1555734238', '/vip/users/sendmsg', '', '0', '0');
INSERT INTO `s_menu` VALUES ('141', '活动留言', '9', 'menu1555738110', '/vip/activity/activitymsg', '', '1', '4');
INSERT INTO `s_menu` VALUES ('142', '修改活动留言内容', '9', 'menu1517993309', '/vip/activity/editactivitymsg', '', '0', '0');
INSERT INTO `s_menu` VALUES ('143', '审核活动留言', '9', 'menu1517991576', '/vip/activity/setmsgstatus', '', '0', '0');
INSERT INTO `s_menu` VALUES ('144', '删除活动留言', '9', 'menu1517991607', '/vip/activity/delactivitymsg', '', '0', '0');
INSERT INTO `s_menu` VALUES ('146', '积分商城', '0', 'menu1555655962', 'http://shop.com/index.php/Admin/Index/index', 'fa-cart-plus', '1', '999');
INSERT INTO `s_menu` VALUES ('147', '经纪人管理', '15', 'menu1526565846', '/vip/recommend/agent', '', '1', '1');
INSERT INTO `s_menu` VALUES ('148', '审核经纪人', '147', 'menu1520773491', '/vip/recommend/checkAgent', '', '0', '0');
INSERT INTO `s_menu` VALUES ('150', '修改会员资料', '5', 'menu1555734004', '/vip/users/editusers', '', '0', '0');
INSERT INTO `s_menu` VALUES ('151', '微信接力活动', '717', 'menu1555652136', '/vip/wxhelp/index', 'fa-user-plus', '1', '89');
INSERT INTO `s_menu` VALUES ('152', '会员一键通', '16', 'menu1523158355', '/vip/commend/kf', '', '0', '0');
INSERT INTO `s_menu` VALUES ('155', '团购活动', '717', 'menu1557977659', '/vip/groupbuy/index', 'fa-cart-plus', '0', '2');
INSERT INTO `s_menu` VALUES ('156', '活动管理', '155', 'menu1555734558', '/vip/groupbuy/index', '', '1', '0');
INSERT INTO `s_menu` VALUES ('157', '团购管理', '155', 'menu1523325971', '/vip/groupbuy/group_buy', '', '1', '0');
INSERT INTO `s_menu` VALUES ('158', '参团人员管理', '155', 'menu1527126910', '/vip/groupbuy/group_user', '', '0', '0');
INSERT INTO `s_menu` VALUES ('159', '添加活动', '155', 'menu1523330101', '/vip/groupbuy/activityadd', '', '0', '0');
INSERT INTO `s_menu` VALUES ('160', '活动修改', '155', 'menu1523410978', '/vip/groupbuy/activityedit', '', '0', '0');
INSERT INTO `s_menu` VALUES ('161', '活动删除', '155', 'menu1523411953', '/vip/groupbuy/activitydel', '', '0', '0');
INSERT INTO `s_menu` VALUES ('162', '推荐规则设定', '15', 'menu1526565915', '/vip/recommend/configset', '', '1', '4');
INSERT INTO `s_menu` VALUES ('163', '转介绍订单审核', '15', 'menu1555735944', '/vip/recommend/orderlist', '', '1', '3');
INSERT INTO `s_menu` VALUES ('164', '审核订单操作', '163', 'menu1526634943', '/vip/recommend/checkorder', '', '0', '0');
INSERT INTO `s_menu` VALUES ('168', '集团会员事业部设置', '38', 'menu1555736427', '/vip/setting/setbrand', 'fa-home', '0', '0');
INSERT INTO `s_menu` VALUES ('172', '话题管理', '724', 'menu1555734764', '/vip/Marriagecircle/index', 'fa-money', '1', '0');
INSERT INTO `s_menu` VALUES ('173', '新增话题', '172', 'menu1555734266', '/vip/Marriagecircle/add', '', '0', '0');
INSERT INTO `s_menu` VALUES ('174', '修改话题', '172', 'menu1533287322', '/vip/Marriagecircle/edit ', '', '0', '0');
INSERT INTO `s_menu` VALUES ('175', '修改话题状态 ', '172', 'menu1533287415', '/vip/Marriagecircle/editStatus', '', '0', '0');
INSERT INTO `s_menu` VALUES ('176', '删除话题', '172', 'menu1533287433', '/vip/Marriagecircle/del', '', '0', '0');
INSERT INTO `s_menu` VALUES ('177', '帖子管理', '724', 'menu1555734964', '/vip/Mcpost/index', 'fa-database', '1', '0');
INSERT INTO `s_menu` VALUES ('178', '删除', '177', 'menu1533447356', '/vip/McPost/del', '', '0', '0');
INSERT INTO `s_menu` VALUES ('179', '改变状态', '177', 'menu1533447382', '/vip/McPost/setstatus', '', '0', '0');
INSERT INTO `s_menu` VALUES ('180', '评论管理', '724', 'menu1555734941', '/vip/McComment/index', '', '1', '0');
INSERT INTO `s_menu` VALUES ('181', '修改状态', '180', 'menu1533449224', '/vip/McComment/setstatus', '', '0', '0');
INSERT INTO `s_menu` VALUES ('182', '删除', '180', 'menu1533449241', '/vip/McComment/del', '', '0', '0');
INSERT INTO `s_menu` VALUES ('183', '系统设定', '722', 'menu1558073329', '/vip/Systemsetup/index', 'fa-calendar-minus-o', '1', '0');
INSERT INTO `s_menu` VALUES ('184', '品牌信息', '715', 'menu1557977995', '/vip/Brandinformation/index', '', '0', '4');
INSERT INTO `s_menu` VALUES ('185', '首页导航', '715', 'menu1557977929', '/vip/setindex/index', 'fa-paper-plane', '0', '1');
INSERT INTO `s_menu` VALUES ('186', '添加', '184', 'menu1533604931', 'vip/Brandinformation/add', '', '0', '0');
INSERT INTO `s_menu` VALUES ('187', '修改', '184', 'menu1533605586', 'vip/Brandinformation/edit', '', '0', '0');
INSERT INTO `s_menu` VALUES ('188', '删除', '184', 'menu1533605621', 'vip/Brandinformation/del', '', '0', '0');
INSERT INTO `s_menu` VALUES ('189', '品牌信息子集列表', '184', 'menu1533887354', 'vip/Brandinformation/subsetList', '', '0', '0');
INSERT INTO `s_menu` VALUES ('190', '子集添加', '184', 'menu1533605676', 'vip/Brandinformation/subsetadd', '', '0', '0');
INSERT INTO `s_menu` VALUES ('191', '品牌信息子集删除', '184', 'menu1533887366', 'vip/Brandinformation/subsetDel', '', '0', '0');
INSERT INTO `s_menu` VALUES ('192', '添加导航', '185', 'menu1555734862', '/vip/setindex/add', 'fa-user-plus', '0', '0');
INSERT INTO `s_menu` VALUES ('193', '客照', '715', 'menu1557978018', '/vip/Userphotos/index', 'fa-camera', '0', '7');
INSERT INTO `s_menu` VALUES ('194', '新增客照', '193', 'menu1535373996', '/vip/Userphotos/add', '', '0', '0');
INSERT INTO `s_menu` VALUES ('195', '客照编辑可见状态', '193', 'menu1555735432', '/vip/Userphotos/editStatus', '', '0', '0');
INSERT INTO `s_menu` VALUES ('196', '删除客照', '193', 'menu1535374018', '/vip/Userphotos/del', '', '0', '0');
INSERT INTO `s_menu` VALUES ('197', '视频', '718', 'menu1557978238', '/vip/Mcvideo/index', 'fa-user-plus', '0', '0');
INSERT INTO `s_menu` VALUES ('198', '添加视频', '197', 'menu1535374979', '/vip/Mcvideo/add', '', '0', '0');
INSERT INTO `s_menu` VALUES ('199', '修改视频状态', '197', 'menu1533714401', '/vip/Mcvideo/editStatus', '', '0', '0');
INSERT INTO `s_menu` VALUES ('200', '删除视频', '197', 'menu1533714430', '/vip/Mcvideo/del', '', '0', '0');
INSERT INTO `s_menu` VALUES ('201', '修改视频', '197', 'menu1533714614', 'vip/Mcvideo/edit', '', '0', '0');
INSERT INTO `s_menu` VALUES ('202', '品牌故事', '715', 'menu1555740512', '/vip/Brand/index', 'fa-flag-o', '1', '5');
INSERT INTO `s_menu` VALUES ('203', '积分介绍', '718', 'menu1561623065', '/vip/Integral/index', 'fa-share-alt', '0', '0');
INSERT INTO `s_menu` VALUES ('204', '结婚热点', '724', 'menu1555735355', '/vip/married/index', 'fa-user-plus', '1', '0');
INSERT INTO `s_menu` VALUES ('205', '添加热点', '204', 'menu1555734134', '/vip/married/add', 'fa-id-badge', '0', '0');
INSERT INTO `s_menu` VALUES ('206', '删除热点', '204', 'menu1534213313', '/vip/married/del', 'fa-money', '0', '0');
INSERT INTO `s_menu` VALUES ('207', '修改热点', '204', 'menu1534213323', '/vip/married/edit', 'fa-envelope-o', '0', '0');
INSERT INTO `s_menu` VALUES ('208', '热门搜索', '715', 'menu1555740819', '/vip/Totsearch/index', 'fa-fire', '1', '0');
INSERT INTO `s_menu` VALUES ('210', '页面提示信息', '721', 'menu1557978201', '/vip/HintTextOperation/index', 'fa-tags', '0', '6');
INSERT INTO `s_menu` VALUES ('211', '评价问卷', '721', 'menu1558925109', '/vip/Evaluationquestionnaire/index', 'fa-file-text-o', '1', '5');
INSERT INTO `s_menu` VALUES ('212', '唯映像客照', '193', 'menu1555740605', '/vip/Userphotos/wei_index', 'fa-credit-card', '0', '0');
INSERT INTO `s_menu` VALUES ('213', '唯映像视频', '197', 'menu1535375059', '/vip/Mcvideo/wei_index', 'fa-money', '1', '0');
INSERT INTO `s_menu` VALUES ('214', '白金会员专区', '715', 'menu1557977914', '/vip/Platina/index', 'fa-credit-card', '0', '0');
INSERT INTO `s_menu` VALUES ('215', '帖子审核', '183', 'menu1555734312', '/vip/systemsetup/post', '', '0', '0');
INSERT INTO `s_menu` VALUES ('216', '评论审核', '183', 'menu1536830007', '/vip/systemsetup/comment', '', '0', '0');
INSERT INTO `s_menu` VALUES ('217', '儿童会员事业部设置', '183', 'menu1536830015', '/vip/systemsetup/setertong', '', '1', '0');
INSERT INTO `s_menu` VALUES ('218', '集团会员事业部设置', '183', 'menu1536830329', '/vip/systemsetup/setbrand', '', '1', '0');
INSERT INTO `s_menu` VALUES ('219', '百度统计', '183', 'menu1555734292', '/vip/systemsetup/setbaidu', '', '0', '0');
INSERT INTO `s_menu` VALUES ('226', '套系管理', '721', 'menu1555738614', '/vip/Package', 'fa-calendar-minus-o', '1', '2');
INSERT INTO `s_menu` VALUES ('227', '新增套系', '725', 'menu1555736126', '/vip/Package/addPackage', '', '0', '0');
INSERT INTO `s_menu` VALUES ('228', '编辑套系', '725', 'menu1555736140', '/vip/Package/editPackage', '', '0', '0');
INSERT INTO `s_menu` VALUES ('229', '删除套系', '725', 'menu1555736152', '/vip/Package/delPackage', '', '0', '0');
INSERT INTO `s_menu` VALUES ('671', '作品管理', '721', 'menu1557978152', '/vip/style/index', 'fa-user-plus', '0', '4');
INSERT INTO `s_menu` VALUES ('677', '修改作品', '671', 'menu1539671533', '/vip/style/production_edit', '', '0', '0');
INSERT INTO `s_menu` VALUES ('678', '删除作品', '671', 'menu1539671568', '/vip/style/production_del', '', '0', '0');
INSERT INTO `s_menu` VALUES ('679', '设置网站logo', '183', 'menu1539950068', '/vip/systemsetup/setlogo', '', '1', '0');
INSERT INTO `s_menu` VALUES ('680', '新增帖子', '177', 'menu1539413685', '/vip/mcpost/addtopic', '', '0', '0');
INSERT INTO `s_menu` VALUES ('681', '查询帖子', '177', 'menu1555735579', '/vip/mcpost/classificationdata', '', '0', '0');
INSERT INTO `s_menu` VALUES ('682', '帖子置顶', '177', 'menu1555735472', '/vip/Mcpost/topicTop', '', '0', '0');
INSERT INTO `s_menu` VALUES ('683', '短信管理', '718', 'menu1555651750', '/vip/note/index', 'fa-credit-card', '1', '0');
INSERT INTO `s_menu` VALUES ('684', '短信删除', '683', 'menu1541752165', '/vip/note/del', '', '0', '0');
INSERT INTO `s_menu` VALUES ('685', '短信内容设置', '683', 'menu1541752202', '/vip/note/dreamsend', '', '1', '0');
INSERT INTO `s_menu` VALUES ('686', '新活动报名统计', '9', 'menu1555738091', '/vip/signup/newindex', '', '1', '3');
INSERT INTO `s_menu` VALUES ('687', '店长名片', '718', 'menu1557978343', '/vip/namecard/edit', 'fa-home', '0', '0');
INSERT INTO `s_menu` VALUES ('688', '团队介绍', '718', 'menu1561623107', '/vip/team/edit', 'fa-home', '0', '0');
INSERT INTO `s_menu` VALUES ('691', '新增分类', '694', 'menu1555753670', '/vip/Package/addCat', '', '0', '1');
INSERT INTO `s_menu` VALUES ('692', '编辑分类', '694', 'menu1555753690', '/vip/Package/editCat', '', '0', '2');
INSERT INTO `s_menu` VALUES ('693', '删除分类', '694', 'menu1555753706', '/vip/Package/delCat', '', '0', '3');
INSERT INTO `s_menu` VALUES ('694', '分类列表', '226', 'menu1543209922', '/vip/Package/indexCat', '', '1', '0');
INSERT INTO `s_menu` VALUES ('695', '卡包管理', '727', 'menu1555739047', '/vip/couponbag/index', '', '1', '4');
INSERT INTO `s_menu` VALUES ('696', '添加卡包', '695', 'menu1555739199', '/vip/couponbag/add', '', '0', '1');
INSERT INTO `s_menu` VALUES ('697', '修改卡包', '695', 'menu1555739214', '/vip/couponbag/edit', '', '0', '2');
INSERT INTO `s_menu` VALUES ('698', '删除卡包', '695', 'menu1555739228', '/vip/couponbag/del', 'fa-home', '0', '3');
INSERT INTO `s_menu` VALUES ('705', '作品类别管理', '671', 'menu1546665818', '/vip/style/style_index', '', '1', '0');
INSERT INTO `s_menu` VALUES ('706', '添加作品分类', '671', 'menu1546665870', '/vip/style/style_add', '', '0', '0');
INSERT INTO `s_menu` VALUES ('707', '修改分类', '671', 'menu1546665926', '/vip/style/style_edit', '', '0', '0');
INSERT INTO `s_menu` VALUES ('708', '分类删除', '671', 'menu1546665946', '/vip/style/style_del', '', '0', '0');
INSERT INTO `s_menu` VALUES ('709', '作品添加', '671', 'menu1539671467', '/vip/style/production_add', '', '0', '0');
INSERT INTO `s_menu` VALUES ('710', '上门拍活动报名', '718', 'menu1561623054', '/vip/Activesmp/index', 'fa-share-alt', '0', '91');
INSERT INTO `s_menu` VALUES ('711', '未注册客资', '718', 'menu1561623042', '/vip/Customer/notVipCustomer', 'fa-share-alt', '0', '91');
INSERT INTO `s_menu` VALUES ('713', '99会员权益', '6', 'menu1555734172', '/vip/level/vipCoupon', '', '0', '9');
INSERT INTO `s_menu` VALUES ('715', '前台素材', '0', 'menu1555739702', '', 'fa-file-photo-o', '1', '3');
INSERT INTO `s_menu` VALUES ('716', '会员', '0', 'menu1555665915', '', 'fa-user', '1', '1');
INSERT INTO `s_menu` VALUES ('717', '营销', '0', 'menu1555654502', '', 'fa-share-alt', '1', '2');
INSERT INTO `s_menu` VALUES ('718', '其他', '0', 'menu1555653473', '', 'fa-home', '1', '7');
INSERT INTO `s_menu` VALUES ('719', '积分', '0', 'menu1555655102', '', 'fa-database', '1', '5');
INSERT INTO `s_menu` VALUES ('720', '微信相关', '0', 'menu1561627036', '', 'fa-weixin', '1', '4');
INSERT INTO `s_menu` VALUES ('721', '订单管理', '0', 'menu1555656113', '', 'fa-list-ul', '1', '6');
INSERT INTO `s_menu` VALUES ('722', '系统设置', '0', 'menu1555654808', '', 'fa-cogs', '1', '7');
INSERT INTO `s_menu` VALUES ('724', '结婚圈', '717', 'menu1557977643', '', 'fa-heart-o', '0', '0');
INSERT INTO `s_menu` VALUES ('725', '套系列表', '226', 'menu1555736100', '/vip/Package/index', '', '1', '1');
INSERT INTO `s_menu` VALUES ('726', '活动列表', '9', 'menu1555736958', '/vip/activity/index', 'fa-user-plus', '1', '1');
INSERT INTO `s_menu` VALUES ('727', '优惠券管理', '721', 'menu1555738639', '', 'fa-money', '1', '3');
INSERT INTO `s_menu` VALUES ('728', '客片大赏', '715', 'menu1556069350', '', 'fa-camera', '1', '3');
INSERT INTO `s_menu` VALUES ('729', '自动回复', '720', 'menu1555741014', '', 'fa-flash', '1', '2');
INSERT INTO `s_menu` VALUES ('730', '线上订单管理', '721', 'menu1557123003', '/vip/packageorder/index', 'fa-list-ul', '1', '3');
INSERT INTO `s_menu` VALUES ('731', '查看套系订单', '730', 'menu1555752487', '/vip/packageorder/getpackorderlist', '', '0', '1');
INSERT INTO `s_menu` VALUES ('732', '后台客片管理', '728', 'menu1557978075', '/vip/Guestphoto/photoList', 'fa-camera', '1', '1');
INSERT INTO `s_menu` VALUES ('734', '添加客片', '728', 'menu1555912622', '/vip/Guestphoto/photoAdd', 'fa-user-plus', '0', '2');
INSERT INTO `s_menu` VALUES ('735', '编辑客片', '728', 'menu1555912650', '/vip/Guestphoto/photoEdit', '', '0', '3');
INSERT INTO `s_menu` VALUES ('736', '删除客片', '728', 'menu1555912723', '/vip/guestphoto/photodel', '', '0', '4');
INSERT INTO `s_menu` VALUES ('737', '用户客片管理', '728', 'menu1557978106', '/vip/Guestphoto/userPhotoList', 'fa-file-photo-o', '1', '2');
INSERT INTO `s_menu` VALUES ('738', '用户客片审核', '737', 'menu1555989351', '/vip/Guestphoto/photoCheck', '', '0', '1');
INSERT INTO `s_menu` VALUES ('739', '口碑管理', '715', 'menu1557974354', '/vip/praise/index', 'fa-share-alt', '1', '6');
INSERT INTO `s_menu` VALUES ('740', '店面详情', '721', 'menu1556163893', '/vip/shopInfo/shopList', 'fa-home', '1', '1');
INSERT INTO `s_menu` VALUES ('741', '添加店面详情', '740', 'menu1556169574', '/vip/shopinfo/shopadd', '', '0', '1');
INSERT INTO `s_menu` VALUES ('742', '编辑店面详情', '740', 'menu1556169594', '/vip/shopinfo/shopedit', '', '0', '2');
INSERT INTO `s_menu` VALUES ('743', '删除店面详情', '740', 'menu1556169615', '/vip/shopinfo/shopdel', '', '0', '3');
INSERT INTO `s_menu` VALUES ('744', '套系订单退款', '730', 'menu1557050525', '/vip/packageorder/refund', '', '0', '4');
INSERT INTO `s_menu` VALUES ('745', '会员卡生成规则', '716', 'menu1557977324', '/vip/scorerule/setcardnumrule', 'fa-id-badge', '1', '5');
INSERT INTO `s_menu` VALUES ('746', '全局设定', '183', 'menu1558073354', '/vip/Systemsetup/index', '', '1', '0');
INSERT INTO `s_menu` VALUES ('747', '打赏礼物设定', '721', 'menu1558685016', '/vip/gift/giftlist', 'fa-gift', '1', '6');
INSERT INTO `s_menu` VALUES ('748', '添加礼物', '747', 'menu1558685054', '/vip/gift/giftadd', 'fa-gift', '0', '1');
INSERT INTO `s_menu` VALUES ('749', '修改礼物', '747', 'menu1558685078', '/vip/gift/giftedit', 'fa-gift', '0', '2');
INSERT INTO `s_menu` VALUES ('750', '删除礼物', '747', 'menu1558685102', '/vip/gift/giftdel', 'fa-gift', '0', '3');
INSERT INTO `s_menu` VALUES ('751', '礼物赠送/购买记录', '747', 'menu1558685272', '/vip/gift/giftbuylist', '', '0', '4');
INSERT INTO `s_menu` VALUES ('752', '评价详情', '211', 'menu1559545273', '/vip/Evaluationquestionnaire/userinfo', '', '1', '0');
INSERT INTO `s_menu` VALUES ('753', '订单默认设置', '721', 'menu1560590739', '/vip/packageorder/orderDefault', 'fa-file-text-o', '1', '7');
INSERT INTO `s_menu` VALUES ('755', '评价题目', '211', 'menu1561540818', '/vip/Evaluationquestionnaire/index', 'fa-database', '1', '2');
INSERT INTO `s_menu` VALUES ('756', '添加评价题目', '211', 'menu1562580431', '/vip/Evaluationquestionnaire/add', 'fa-user', '0', '0');
INSERT INTO `s_menu` VALUES ('757', '修改评价题目', '211', 'menu1562580445', '/vip/Evaluationquestionnaire/edit', 'fa-user', '0', '0');
INSERT INTO `s_menu` VALUES ('758', '添加接力活动', '151', 'menu1563168038', '/vip/wxhelp/add', '', '0', '1');
INSERT INTO `s_menu` VALUES ('759', '评价题目', '211', 'menu1561540818', '/vip/Evaluationquestionnaire/index', 'fa-database', '1', '2');
INSERT INTO `s_menu` VALUES ('760', '客片分类', '728', 'menu1564987816', '/vip/guestphoto/phototypelist', 'fa-tags', '0', '0');
INSERT INTO `s_menu` VALUES ('761', '添加客片分类', '760', 'menu1564987783', '/vip/guestphoto/phototypeadd', '', '0', '0');
INSERT INTO `s_menu` VALUES ('762', '首页展示客片', '728', 'menu1564991326', '/vip/guestphoto/photoindex', 'fa-file-photo-o', '1', '3');
INSERT INTO `s_menu` VALUES ('763', '首页视频', '715', 'menu1565002426', '/vip/brand/indexVideo', 'fa-camera', '1', '6');

-- ----------------------------
-- Table structure for s_namecard
-- ----------------------------
DROP TABLE IF EXISTS `s_namecard`;
CREATE TABLE `s_namecard` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `cover_img` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '封面图',
  `qr_img` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '二维码',
  `head_img` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '头像',
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '名称',
  `post` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '职位',
  `create_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `brandid` int(10) DEFAULT NULL,
  `phone` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `address` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '地址',
  `longitude` decimal(10,6) DEFAULT NULL COMMENT '经度',
  `latitude` decimal(10,6) DEFAULT NULL COMMENT '纬度',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_namecard
-- ----------------------------

-- ----------------------------
-- Table structure for s_note
-- ----------------------------
DROP TABLE IF EXISTS `s_note`;
CREATE TABLE `s_note` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `phone` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `send` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '发送对象',
  `status` tinyint(1) DEFAULT NULL COMMENT '发送状态 1 成功  2失败',
  `create_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `delete_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `userid` int(10) DEFAULT NULL,
  `brandid` int(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_note
-- ----------------------------

-- ----------------------------
-- Table structure for s_order
-- ----------------------------
DROP TABLE IF EXISTS `s_order`;
CREATE TABLE `s_order` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `orderId` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `package_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '套系名称',
  `total_money` decimal(10,2) DEFAULT NULL COMMENT '套系金额',
  `targetdate` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '下单时间',
  `phone` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandid` int(10) DEFAULT NULL,
  `phoneid` int(10) DEFAULT NULL,
  `create_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_order
-- ----------------------------

-- ----------------------------
-- Table structure for s_order_info
-- ----------------------------
DROP TABLE IF EXISTS `s_order_info`;
CREATE TABLE `s_order_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) DEFAULT NULL,
  `user_phone_id` int(11) DEFAULT NULL,
  `order_sn` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user_tel` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user_address` text COLLATE utf8_unicode_ci,
  `user_wechat` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `price` decimal(10,2) DEFAULT NULL,
  `total_price` decimal(10,2) DEFAULT NULL,
  `number` int(11) DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `is_del` tinyint(4) NOT NULL DEFAULT '1',
  `brand_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL COMMENT 'userid',
  `payment_order_sn` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '支付单号',
  `payment_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '支付时间',
  `payment_status` int(11) DEFAULT NULL COMMENT '支付状态，（1未支付，2支付完成）',
  `coupon_id` int(11) DEFAULT NULL,
  `pay_type` tinyint(2) DEFAULT NULL COMMENT '支付类型，1全额，2定金',
  `pay_money` decimal(10,2) DEFAULT NULL COMMENT '实际支付金额',
  `preferential_money` decimal(10,2) DEFAULT NULL COMMENT '优惠金额',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_order_info
-- ----------------------------

-- ----------------------------
-- Table structure for s_order_serial
-- ----------------------------
DROP TABLE IF EXISTS `s_order_serial`;
CREATE TABLE `s_order_serial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_number` varchar(155) COLLATE utf8_unicode_ci DEFAULT NULL,
  `serial_number` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pay_price` decimal(10,2) DEFAULT NULL,
  `pay_status` tinyint(2) DEFAULT NULL,
  `add_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_order_serial
-- ----------------------------

-- ----------------------------
-- Table structure for s_package_cart
-- ----------------------------
DROP TABLE IF EXISTS `s_package_cart`;
CREATE TABLE `s_package_cart` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `package_id` int(11) DEFAULT NULL COMMENT '套系id',
  `package_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '套系名称',
  `cat_id` int(11) DEFAULT NULL COMMENT '套系分类',
  `price_type` tinyint(2) DEFAULT NULL COMMENT '付费类型，1全款，2定金',
  `price` decimal(10,2) DEFAULT NULL COMMENT '价格,若price_type为1则全款，若price_type为2则定金',
  `user_id` int(11) DEFAULT NULL COMMENT 'm_users表主键',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `add_time` datetime DEFAULT NULL COMMENT '加入选购清单时间',
  `pay_time` datetime DEFAULT NULL COMMENT '购买时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=72 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='购物车';

-- ----------------------------
-- Records of s_package_cart
-- ----------------------------

-- ----------------------------
-- Table structure for s_package_info
-- ----------------------------
DROP TABLE IF EXISTS `s_package_info`;
CREATE TABLE `s_package_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `package_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '套系名称',
  `erp_package_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'ERP套系名称',
  `package_price` decimal(10,2) DEFAULT NULL COMMENT 'package_price',
  `erp_package_price` decimal(10,2) DEFAULT NULL COMMENT 'ERP package_price',
  `package_title_img` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '套系标题图片',
  `package_contents` text COLLATE utf8_unicode_ci COMMENT '套系描述',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `is_del` tinyint(4) NOT NULL DEFAULT '1' COMMENT '是否删除 1：未删除； 2：删除',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brand_id` int(11) DEFAULT NULL,
  `p_sort` int(11) DEFAULT NULL,
  `shop_sn` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cat_id` int(11) DEFAULT NULL COMMENT '产品类别id，同s_cat表id',
  `is_recommend` tinyint(4) DEFAULT '2' COMMENT '是否店长推荐（1推荐，2不推）',
  `rec_img` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '店长推荐封面图',
  `cam_ids` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '套系内摄影师列表  摄影师表（cameraman）id，用逗号（,）分隔',
  `pro_ids` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '套系内作品列表  作品表（s_styleproduction）id，用逗号（,）分隔',
  `package_price_down` decimal(10,2) DEFAULT NULL COMMENT '定金',
  `consumption_type` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '消费类型',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_package_info
-- ----------------------------

-- ----------------------------
-- Table structure for s_package_order
-- ----------------------------
DROP TABLE IF EXISTS `s_package_order`;
CREATE TABLE `s_package_order` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `p_id` int(11) DEFAULT NULL COMMENT '套系id',
  `cart_id` int(11) DEFAULT NULL COMMENT '购物车id',
  `erp_order_sn` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'erp订单号',
  `user_id` int(11) DEFAULT NULL COMMENT 'users表主键id',
  `package_price` decimal(10,2) DEFAULT NULL COMMENT '套系原价',
  `vip_discount` decimal(10,2) DEFAULT NULL COMMENT '会员折扣',
  `vip_diff` decimal(10,2) DEFAULT NULL COMMENT '会员折扣便宜了多少钱',
  `coupon_id` int(11) DEFAULT NULL COMMENT '优惠券id',
  `coupon_diff` decimal(10,2) DEFAULT NULL COMMENT '优惠券便宜了多少钱',
  `order_package_price` decimal(10,2) DEFAULT NULL COMMENT '此订单中套系应付金额',
  `order_pay_type` tinyint(2) DEFAULT NULL COMMENT '支付类型，1全款，2定金',
  `order_pay_price` decimal(10,2) DEFAULT NULL COMMENT '本订单应付金额',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '店面code',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '店面名称',
  `brand_id` int(11) DEFAULT NULL COMMENT '事业部id',
  `reach_shop_date` datetime DEFAULT NULL COMMENT '到店时间',
  `bb_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '宝宝姓名',
  `bb_birthday` date DEFAULT NULL COMMENT '宝宝生日',
  `bb_sex` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tel` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '手机号',
  `wname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `wphone` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '妈妈手机号',
  `yc_day` date DEFAULT NULL COMMENT '预产日期',
  `payment_order_sn` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单支付单号',
  `payment_status` tinyint(2) DEFAULT NULL COMMENT '支付状态，（1未支付，2支付完成）',
  `payment_time` datetime DEFAULT NULL COMMENT '支付时间',
  `refund_fee` decimal(10,2) DEFAULT '0.00' COMMENT '总退款金额',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `delete_time` datetime DEFAULT NULL COMMENT '取消时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=48 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_package_order
-- ----------------------------

-- ----------------------------
-- Table structure for s_package_order_refund
-- ----------------------------
DROP TABLE IF EXISTS `s_package_order_refund`;
CREATE TABLE `s_package_order_refund` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `serial_sn` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '支付流水号',
  `refund_fee` decimal(10,2) DEFAULT NULL COMMENT '退款金额',
  `vip_order_sn` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '线上支付订单号',
  `erp_order_sn` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'erp订单号',
  `user_id` int(11) DEFAULT NULL COMMENT '退款给谁，m_users表主键',
  `staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '操作人',
  `refund_time` datetime DEFAULT NULL COMMENT '退款时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='套系订单微信退款';

-- ----------------------------
-- Records of s_package_order_refund
-- ----------------------------

-- ----------------------------
-- Table structure for s_position_menu
-- ----------------------------
DROP TABLE IF EXISTS `s_position_menu`;
CREATE TABLE `s_position_menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `position_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `menu_code` text COLLATE utf8_unicode_ci,
  `menu_url` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `status` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_position_menu
-- ----------------------------

-- ----------------------------
-- Table structure for s_praise
-- ----------------------------
DROP TABLE IF EXISTS `s_praise`;
CREATE TABLE `s_praise` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL COMMENT '作品id',
  `userid` int(11) NOT NULL,
  `phoneid` int(11) DEFAULT NULL,
  `username` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `createtime` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `brandid` int(11) DEFAULT NULL,
  `is_del` int(10) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_praise
-- ----------------------------

-- ----------------------------
-- Table structure for s_score_detail
-- ----------------------------
DROP TABLE IF EXISTS `s_score_detail`;
CREATE TABLE `s_score_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `rule_name` int(11) DEFAULT '0' COMMENT '积分规则名称取（s_score_rule里的detail字段，里的对应k值如sign_fist）',
  `userid` int(11) DEFAULT '0' COMMENT '用户id',
  `score_num` int(11) DEFAULT '0' COMMENT '积分数量',
  `create_time` datetime DEFAULT NULL COMMENT '获得时间',
  `ip` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '登录ip地址',
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  `iswid` smallint(1) DEFAULT '0' COMMENT '0表示userid就是m_users里的id,1表示userid是m_we_users里的wid',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=100 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='积分详情表';

-- ----------------------------
-- Records of s_score_detail
-- ----------------------------

-- ----------------------------
-- Table structure for s_score_rule
-- ----------------------------
DROP TABLE IF EXISTS `s_score_rule`;
CREATE TABLE `s_score_rule` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '规则id',
  `levelid` int(11) DEFAULT '0' COMMENT '级别id对应level表id',
  `detail` text COLLATE utf8_unicode_ci COMMENT 'json格式的数据，包含签到规则详细信息',
  `delete_time` datetime DEFAULT NULL COMMENT '删除',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  `create_user` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '添加数据的人',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='积分规则表';

-- ----------------------------
-- Records of s_score_rule
-- ----------------------------

-- ----------------------------
-- Table structure for s_score_type
-- ----------------------------
DROP TABLE IF EXISTS `s_score_type`;
CREATE TABLE `s_score_type` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '类别id',
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '类型名称',
  `unit` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '单位',
  `create_time` datetime DEFAULT NULL COMMENT '添加时间',
  `update_time` datetime DEFAULT NULL,
  `delete_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='积分类型表';

-- ----------------------------
-- Records of s_score_type
-- ----------------------------

-- ----------------------------
-- Table structure for s_session
-- ----------------------------
DROP TABLE IF EXISTS `s_session`;
CREATE TABLE `s_session` (
  `staff_id` int(11) NOT NULL,
  `session_id` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `ip` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  `login_type` varchar(20) COLLATE utf8_unicode_ci NOT NULL COMMENT '登录类型',
  `login_method` varchar(30) COLLATE utf8_unicode_ci NOT NULL COMMENT '登录方式',
  `logout_time` datetime DEFAULT NULL COMMENT '退出登录时间',
  `expiry` datetime NOT NULL COMMENT 'session过期时间',
  `status` tinyint(4) DEFAULT '1' COMMENT '登录状态:1:正常，2：忙碌;3:离线'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='crm session表';

-- ----------------------------
-- Records of s_session
-- ----------------------------

-- ----------------------------
-- Table structure for s_shareholder
-- ----------------------------
DROP TABLE IF EXISTS `s_shareholder`;
CREATE TABLE `s_shareholder` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '股东码',
  `create_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `status` tinyint(1) DEFAULT NULL COMMENT '1 未领取，2已注册，3待审核',
  `is_del` tinyint(1) DEFAULT '1' COMMENT '1 没删除  2 已删除',
  `brandid` int(10) DEFAULT NULL,
  `phoneid` int(10) DEFAULT NULL,
  `quota` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '额度',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_shareholder
-- ----------------------------

-- ----------------------------
-- Table structure for s_share_status
-- ----------------------------
DROP TABLE IF EXISTS `s_share_status`;
CREATE TABLE `s_share_status` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '操作类型',
  `money` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '金额',
  `create_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `status` tinyint(1) DEFAULT NULL COMMENT '1完成 2 进行中 3失败',
  `phoneid` int(10) DEFAULT NULL,
  `userid` int(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_share_status
-- ----------------------------

-- ----------------------------
-- Table structure for s_shop_info
-- ----------------------------
DROP TABLE IF EXISTS `s_shop_info`;
CREATE TABLE `s_shop_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_img` text COLLATE utf8_unicode_ci COMMENT '店面照片',
  `shop_info_img` text COLLATE utf8_unicode_ci COMMENT '店面详情',
  `wx_qr_code` text COLLATE utf8_unicode_ci COMMENT '店长微信二维码',
  `shop_tel` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '店面联系电话',
  `brand_id` int(11) DEFAULT NULL COMMENT '所属事业部',
  `sort` int(11) DEFAULT NULL COMMENT '排序',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `add_staff` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '创建人',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_shop_info
-- ----------------------------

-- ----------------------------
-- Table structure for s_style
-- ----------------------------
DROP TABLE IF EXISTS `s_style`;
CREATE TABLE `s_style` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `image` varchar(255) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '五大风格图片',
  `content` varchar(255) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '内容',
  `title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `create_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `brandid` int(11) DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_style
-- ----------------------------

-- ----------------------------
-- Table structure for s_styleproduction
-- ----------------------------
DROP TABLE IF EXISTS `s_styleproduction`;
CREATE TABLE `s_styleproduction` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `sid` int(11) DEFAULT NULL,
  `image` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '展示图',
  `title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '展示标题',
  `user_img` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '发布者头像',
  `user` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '发布者名称',
  `praise` int(11) DEFAULT '0',
  `create_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `brandid` int(11) DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  `c_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '摄影师',
  `detail` text COLLATE utf8_unicode_ci COMMENT '作品详情图',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_styleproduction
-- ----------------------------

-- ----------------------------
-- Table structure for s_team
-- ----------------------------
DROP TABLE IF EXISTS `s_team`;
CREATE TABLE `s_team` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `cover_img` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '标题图',
  `cont_img` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '内容图',
  `create_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `brandid` int(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_team
-- ----------------------------

-- ----------------------------
-- Table structure for t_task_detail
-- ----------------------------
DROP TABLE IF EXISTS `t_task_detail`;
CREATE TABLE `t_task_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(11) DEFAULT '0' COMMENT '用户id',
  `taskid` int(11) DEFAULT '0' COMMENT '任务列表id',
  `status` tinyint(1) DEFAULT '0' COMMENT '执行状态1成功0失败',
  `create_time` datetime DEFAULT NULL COMMENT '执行时间',
  `update_time` datetime DEFAULT NULL,
  `delete_time` datetime DEFAULT NULL,
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  `iswid` tinyint(1) DEFAULT '0' COMMENT '0表示userid就是m_users里的id,1表示userid是m_we_users里的wid',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='任务详情记录';

-- ----------------------------
-- Records of t_task_detail
-- ----------------------------

-- ----------------------------
-- Table structure for t_task_list
-- ----------------------------
DROP TABLE IF EXISTS `t_task_list`;
CREATE TABLE `t_task_list` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business` int(11) DEFAULT NULL COMMENT '//当前任务所属事业部',
  `title` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '任务名称',
  `typeid` tinyint(1) DEFAULT '0' COMMENT '任务类别',
  `index_img` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '首页图片',
  `scontent` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '简要说明',
  `content` longtext COLLATE utf8_unicode_ci COMMENT '详细介绍',
  `reward_score` int(11) DEFAULT '0' COMMENT '奖励积分',
  `share_score` int(11) DEFAULT '0' COMMENT '分享积分',
  `days` int(11) DEFAULT '0' COMMENT '活动周期',
  `start_time` datetime DEFAULT NULL COMMENT '开始时间',
  `end_time` datetime DEFAULT NULL COMMENT '结束日期',
  `status` tinyint(1) DEFAULT '0' COMMENT '1开启0关闭',
  `receive_total` int(11) DEFAULT '0' COMMENT '被领取总数',
  `done_total` int(11) DEFAULT '0' COMMENT '已完成总数',
  `share_total` int(11) DEFAULT '0' COMMENT '分享总数',
  `view_num` int(11) DEFAULT '0' COMMENT '查看次数',
  `order_num` int(11) DEFAULT '0' COMMENT '排序数',
  `create_time` datetime DEFAULT NULL COMMENT '任务添加的时间',
  `delete_time` datetime DEFAULT NULL COMMENT '是否删除',
  `update_time` datetime DEFAULT NULL,
  `create_user` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '//任务添加人',
  `share_img` varchar(200) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '分享时显示的图片',
  `share_title` varchar(150) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '分享的标题',
  `share_content` varchar(255) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '分享的介绍',
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  `style_detail` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '样式记录表',
  `task_url` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '任务的外部连接',
  `package_id` int(11) DEFAULT NULL COMMENT '任务绑定套系id',
  `package_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '套系名',
  `counpon_id` int(11) DEFAULT NULL COMMENT '优惠券id',
  `counpon_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '优惠券名',
  `activityid` int(11) DEFAULT NULL,
  `share_num` int(10) DEFAULT NULL COMMENT '分享点击次数 算完成任务',
  `detail` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=86 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='总任务列表';

-- ----------------------------
-- Records of t_task_list
-- ----------------------------

-- ----------------------------
-- Table structure for t_task_user_list
-- ----------------------------
DROP TABLE IF EXISTS `t_task_user_list`;
CREATE TABLE `t_task_user_list` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '完成任务记录表',
  `userid` int(11) DEFAULT '0' COMMENT '用户id',
  `taskid` int(11) DEFAULT '0' COMMENT '任务id',
  `status` tinyint(1) DEFAULT '0' COMMENT '是否完成',
  `delete_time` datetime DEFAULT NULL COMMENT '是否删除',
  `create_time` datetime DEFAULT NULL COMMENT '领取时间',
  `done_total` int(11) DEFAULT '0' COMMENT '已经完成次数',
  `update_time` datetime DEFAULT NULL,
  `t_task_integral` int(11) DEFAULT '0' COMMENT '//所得积分',
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  `iswid` tinyint(1) DEFAULT '0' COMMENT '0表示userid就是m_users里的id,1表示userid是m_we_users里的wid',
  `t_title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `typeid` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '1 签到（1_1首次签到，1_2连续签到，1_3累计签到），2完善信息（2_1宝宝姓名，2_2手机号，2_3宝宝生日，2_4宝宝性别），3分享任务',
  `couponid` int(10) DEFAULT NULL COMMENT '优惠券ID',
  `t_days` int(11) DEFAULT NULL COMMENT '累计或者 连续签到的天数',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='用户参与任务记录表';

-- ----------------------------
-- Records of t_task_user_list
-- ----------------------------

-- ----------------------------
-- Table structure for user_card
-- ----------------------------
DROP TABLE IF EXISTS `user_card`;
CREATE TABLE `user_card` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(11) DEFAULT '0' COMMENT '//用户id',
  `cardid` int(11) DEFAULT '0' COMMENT '//会员卡类型id',
  `card_number` varchar(80) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '//会员卡号码',
  `create_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//会员卡创建时间',
  `update_time` datetime DEFAULT NULL,
  `delete_time` datetime DEFAULT NULL,
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of user_card
-- ----------------------------

-- ----------------------------
-- Table structure for user_commend
-- ----------------------------
DROP TABLE IF EXISTS `user_commend`;
CREATE TABLE `user_commend` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(150) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '投诉建议标题',
  `userid` int(11) DEFAULT '0' COMMENT '用户id',
  `content` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '详细说明',
  `imgs` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '建议图片',
  `status` tinyint(1) DEFAULT '0' COMMENT '0未查看，1已查看',
  `check_user` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '后台审查人员',
  `create_time` datetime DEFAULT NULL COMMENT '添加时间 ',
  `update_time` datetime DEFAULT NULL,
  `delete_time` datetime DEFAULT NULL COMMENT '是否删除',
  `typeid` tinyint(4) DEFAULT '0' COMMENT '1表示投诉，2表示建议',
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  `iswid` tinyint(1) DEFAULT '0' COMMENT '0表示userid就是m_users里的id,1表示userid是m_we_users里的wid',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='用户建议表';

-- ----------------------------
-- Records of user_commend
-- ----------------------------

-- ----------------------------
-- Table structure for user_level
-- ----------------------------
DROP TABLE IF EXISTS `user_level`;
CREATE TABLE `user_level` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '级别名称',
  `min_once_pay` decimal(10,2) DEFAULT NULL COMMENT '一次性消费多少元，最少',
  `max_once_pay` decimal(10,2) DEFAULT NULL COMMENT '一次性消费多少元，最多',
  `total_pay` decimal(10,2) DEFAULT NULL COMMENT '累计消费多少元',
  `deduct_score` int(11) DEFAULT NULL COMMENT '抵扣多少积分',
  `min_value` int(11) DEFAULT '0' COMMENT '最少成长值----废弃',
  `max_value` int(11) DEFAULT '0' COMMENT '最高成长值----废弃',
  `create_time` datetime DEFAULT NULL,
  `delete_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id----废弃',
  `create_staff` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '添加数据的人',
  `img` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '级别图片',
  `discount` decimal(10,2) DEFAULT '10.00' COMMENT '等级折扣',
  `sort` int(11) DEFAULT '0' COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of user_level
-- ----------------------------

-- ----------------------------
-- Table structure for user_logs
-- ----------------------------
DROP TABLE IF EXISTS `user_logs`;
CREATE TABLE `user_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(11) DEFAULT '0' COMMENT '登陆的用户id',
  `create_time` datetime DEFAULT NULL,
  `ip` varchar(60) COLLATE utf8_unicode_ci DEFAULT '' COMMENT 'ip地址',
  `typeid` int(11) DEFAULT '0' COMMENT '类型0 代表登陆',
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  `iswid` tinyint(1) DEFAULT '0' COMMENT '0表示userid就是m_users里的id,1表示userid是m_we_users里的wid',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1103 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of user_logs
-- ----------------------------

-- ----------------------------
-- Table structure for verify_code
-- ----------------------------
DROP TABLE IF EXISTS `verify_code`;
CREATE TABLE `verify_code` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `phone` varchar(11) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '手机号',
  `code` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '验证码',
  `craete_time` datetime DEFAULT NULL COMMENT '发送时间',
  `end_time` datetime DEFAULT NULL COMMENT '结束时间',
  `status` tinyint(1) DEFAULT NULL COMMENT '状态是否使用',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=113 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='手机验证码表';

-- ----------------------------
-- Records of verify_code
-- ----------------------------

-- ----------------------------
-- Table structure for video
-- ----------------------------
DROP TABLE IF EXISTS `video`;
CREATE TABLE `video` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `brandid` int(11) DEFAULT NULL COMMENT '品牌的id',
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '视频地址',
  `add_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '添加的时间',
  `create_user` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '添加的人员',
  `type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '媒体类型',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=50 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of video
-- ----------------------------

-- ----------------------------
-- Table structure for wedding_desk
-- ----------------------------
DROP TABLE IF EXISTS `wedding_desk`;
CREATE TABLE `wedding_desk` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '婚礼座位表id',
  `desk_name` varchar(100) CHARACTER SET utf8 DEFAULT NULL COMMENT '//桌号名称',
  `desk_content` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//当前桌子简介',
  `desk_mans` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//坐席宾客',
  `desk_user` int(11) DEFAULT NULL COMMENT '//添加人',
  `iswid` tinyint(1) DEFAULT '0' COMMENT '0表示userid就是m_users里的id,1表示userid是m_we_users里的wid',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of wedding_desk
-- ----------------------------

-- ----------------------------
-- Table structure for wedding_flow
-- ----------------------------
DROP TABLE IF EXISTS `wedding_flow`;
CREATE TABLE `wedding_flow` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//婚礼流程表id',
  `this_time` time DEFAULT NULL,
  `this_work` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//流程事项',
  `this_man` varchar(150) CHARACTER SET utf8 DEFAULT NULL COMMENT '//参与流程事项的人员',
  `this_user` int(11) DEFAULT NULL COMMENT '//当前添加人',
  `this_type` int(11) DEFAULT '0' COMMENT '//属于哪个分类下',
  `iswid` tinyint(1) DEFAULT '0' COMMENT '0表示userid就是m_users里的id,1表示userid是m_we_users里的wid',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1024 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of wedding_flow
-- ----------------------------

-- ----------------------------
-- Table structure for wedding_flowtype
-- ----------------------------
DROP TABLE IF EXISTS `wedding_flowtype`;
CREATE TABLE `wedding_flowtype` (
  `flow_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//婚礼流程id',
  `flow_type` varchar(100) CHARACTER SET utf8 DEFAULT NULL COMMENT '//流程类型名称',
  `flow_user` int(11) DEFAULT NULL COMMENT '//创建人',
  `flow_status` tinyint(1) DEFAULT '1' COMMENT '//该流程状态 1是显示 2是不显示',
  `iswid` tinyint(1) DEFAULT '0' COMMENT '0表示userid就是m_users里的id,1表示userid是m_we_users里的wid',
  PRIMARY KEY (`flow_id`)
) ENGINE=InnoDB AUTO_INCREMENT=358 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of wedding_flowtype
-- ----------------------------

-- ----------------------------
-- Table structure for wedding_lovecard
-- ----------------------------
DROP TABLE IF EXISTS `wedding_lovecard`;
CREATE TABLE `wedding_lovecard` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//微喜帖id',
  `invitation_title` varchar(200) CHARACTER SET utf8 DEFAULT NULL COMMENT '//标题',
  `invitation_describe` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//相册描述',
  `invitation_img` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//封面图片',
  `invitation_music` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//背景音乐',
  `invitation_site` varchar(200) CHARACTER SET utf8 DEFAULT NULL COMMENT '//地图地点',
  `brand_id` int(11) DEFAULT '0' COMMENT '//事业部id',
  `template_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '0' COMMENT '//模版关联id',
  `user_phone_id` int(11) DEFAULT '0' COMMENT '//添加用户id',
  `invitation_site_lat` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `invitation_site_lng` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `cate` int(10) DEFAULT NULL COMMENT '类别（1婚纱 2儿童）',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of wedding_lovecard
-- ----------------------------
INSERT INTO `wedding_lovecard` VALUES ('1', '热带雨林', '带上爱一路旅行,阳光和你.', 'public/cardtemplate/template1/imgs/view-img12.png', '/public/front/muise/徐海俏 - 南下.mp3', '', '0', 'template1', '0', '', '', '1');
INSERT INTO `wedding_lovecard` VALUES ('2', '告白气球', '幸福的气球带上我的爱去寻找你', 'public\\front\\imgnew\\inv2\\love.png', '/public/front/muise/徐海俏 - 南下.mp3', '', '0', 'template2', '0', '', '', '1');
INSERT INTO `wedding_lovecard` VALUES ('3', '情书', '不要愁老之将至，你老了一定很可爱。', 'public/front/imgnew/inv3/inv3-page4-img4.jpg', '/public/front/muise/徐海俏 - 南下.mp3', null, '0', 'template3', '0', '', '', '1');
INSERT INTO `wedding_lovecard` VALUES ('4', '凤凰于飞', '凤凰于飞，翙翙其羽', 'public/front/imgnew/inv5/inv5-page2-img2.jpg', '/public/front/muise/徐海俏 - 南下.mp3', null, '0', 'template5', '0', '', '', '1');
INSERT INTO `wedding_lovecard` VALUES ('5', '动物世界', '亲爱的宝贝，生日快乐', 'public/front/imgnew/child1/child1-page5-img4.jpg', '/public/front/muise/魏巡 - 崇拜.mp3', null, '0', 'childtemplate1', '0', '', '', '2');
INSERT INTO `wedding_lovecard` VALUES ('6', 'Summer Vocation', 'Summer Vocation', 'public/front/imgnew/child2/child2-page5-img5.jpg', '/public/front/muise/胡66 - 空空如也.mp3', null, '0', 'childtemplate2', '0', '', '', '2');
INSERT INTO `wedding_lovecard` VALUES ('7', '我们结婚啦', '我们结婚啦', 'public/front/imgnew/inv4/5a5476ec972d6.jpg', '/public/front/muise/徐海俏 - 南下.mp3', null, '0', 'template4', '0', '', '', '1');
INSERT INTO `wedding_lovecard` VALUES ('8', 'It\'s My Baby', '亲爱的宝贝，生日快乐', 'public/front/child3/img/mybaby.jpg', '/public/front/muise/cef.mp3', '', '0', 'childtemplate3', '0', '', '', '2');
INSERT INTO `wedding_lovecard` VALUES ('9', 'serious', '宝宝生日快乐', 'public/front/child4/img/child4_07.jpg', '/public/front/muise/lll.mp3', null, '0', 'childtemplate4', '0', '', '', '2');
INSERT INTO `wedding_lovecard` VALUES ('10', '动物世界', '亲爱的宝贝，生日快乐', 'public/front/imgnew/child1/child1-page5-img4.jpg', '/public/front/muise/lll.mp3', '', '14', 'childtemplate1', '99', '', '', null);

-- ----------------------------
-- Table structure for wedding_lovedata
-- ----------------------------
DROP TABLE IF EXISTS `wedding_lovedata`;
CREATE TABLE `wedding_lovedata` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//模版数据表',
  `wedding_lovecard_id` int(11) DEFAULT NULL COMMENT '//关联主表id',
  `wedding_data` text CHARACTER SET utf8 COMMENT '//当前页面数据',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=137 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of wedding_lovedata
-- ----------------------------

-- ----------------------------
-- Table structure for wedding_lovejoin
-- ----------------------------
DROP TABLE IF EXISTS `wedding_lovejoin`;
CREATE TABLE `wedding_lovejoin` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//参加婚礼帖子id',
  `wedding_lovecard_id` int(11) NOT NULL DEFAULT '0' COMMENT '//关联主表id',
  `join_name` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//参加姓名',
  `join_phone` varchar(100) CHARACTER SET utf8 DEFAULT NULL COMMENT '//参加者电话',
  `join_num` int(11) DEFAULT '0' COMMENT '//参与人数',
  `join_message` text CHARACTER SET utf8 COMMENT '//参与者留言',
  `join_message_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//留言时间',
  `join_user_phone_id` int(11) DEFAULT NULL COMMENT '//关联当前用户id',
  `join_wish_status` tinyint(1) DEFAULT '2' COMMENT '//是否祝福过  1是祝福 2是未祝福',
  `join_wish_time` datetime DEFAULT NULL COMMENT '//祝福时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=91 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of wedding_lovejoin
-- ----------------------------

-- ----------------------------
-- Table structure for wedding_lovephotos
-- ----------------------------
DROP TABLE IF EXISTS `wedding_lovephotos`;
CREATE TABLE `wedding_lovephotos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//微喜帖照片集id',
  `wedding_lovecard_id` int(11) DEFAULT NULL COMMENT '//关联主帖子id',
  `card_img` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//帖子单张照片',
  `this_several` tinyint(1) DEFAULT NULL COMMENT '//当前属于第几页',
  `this_seat` tinyint(1) DEFAULT NULL COMMENT '//显示位置',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=88 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of wedding_lovephotos
-- ----------------------------
INSERT INTO `wedding_lovephotos` VALUES ('1', '1', 'public/cardtemplate/template1/imgs/inv-load-img.jpg', '1', '1');
INSERT INTO `wedding_lovephotos` VALUES ('2', '1', 'template1/imgs/Jellyfish.jpg', '5', '1');
INSERT INTO `wedding_lovephotos` VALUES ('3', '1', 'public/cardtemplate/template1/imgs/page5-img.jpg', '4', '1');
INSERT INTO `wedding_lovephotos` VALUES ('4', '1', 'public/cardtemplate/template1/imgs/page4-img.jpg', '3', '1');
INSERT INTO `wedding_lovephotos` VALUES ('5', '1', 'public/cardtemplate/template1/imgs/page5-img.jpg', '2', '2');
INSERT INTO `wedding_lovephotos` VALUES ('6', '1', 'public/cardtemplate/template1/imgs/page3-img02.jpg', '2', '1');
INSERT INTO `wedding_lovephotos` VALUES ('7', '2', 'public/cardtemplate/template2/imgs/inv2-page5-img01.jpg', '4', '2');
INSERT INTO `wedding_lovephotos` VALUES ('8', '2', 'public/cardtemplate/template2/imgs/inv2-page5-img02.jpg', '4', '1');
INSERT INTO `wedding_lovephotos` VALUES ('9', '2', 'public/cardtemplate/template2/imgs/inv2-page4-img01.jpg', '3', '2');
INSERT INTO `wedding_lovephotos` VALUES ('10', '2', 'public/cardtemplate/template2/imgs/inv2-page4-img02.jpg', '3', '1');
INSERT INTO `wedding_lovephotos` VALUES ('11', '2', 'public/cardtemplate/template2/imgs/inv2-page3-img03.jpg', '2', '4');
INSERT INTO `wedding_lovephotos` VALUES ('12', '2', 'public/cardtemplate/template2/imgs/inv2-page1-img.jpg', '1', '1');
INSERT INTO `wedding_lovephotos` VALUES ('13', '2', 'public/cardtemplate/template2/imgs/inv2-page3-img04.jpg', '2', '1');
INSERT INTO `wedding_lovephotos` VALUES ('14', '2', 'public/cardtemplate/template2/imgs/inv2-page3-img01.jpg', '2', '2');
INSERT INTO `wedding_lovephotos` VALUES ('15', '2', 'public/cardtemplate/template2/imgs/inv2-page3-img02.jpg', '2', '3');
INSERT INTO `wedding_lovephotos` VALUES ('16', '3', 'public/front/imgnew/inv3/inv3-page2-img2.jpg', '2', '1');
INSERT INTO `wedding_lovephotos` VALUES ('17', '3', 'public/front/imgnew/inv3/inv3-page1-img4.jpg', '1', '1');
INSERT INTO `wedding_lovephotos` VALUES ('18', '3', 'public/front/imgnew/inv3/inv3-page3-img2.jpg', '3', '1');
INSERT INTO `wedding_lovephotos` VALUES ('19', '3', 'public/front/imgnew/inv3/inv3-page3-img6.jpg', '3', '2');
INSERT INTO `wedding_lovephotos` VALUES ('20', '3', 'public/front/imgnew/inv3/inv3-page5-img4.jpg', '5', '1');
INSERT INTO `wedding_lovephotos` VALUES ('21', '3', 'public/front/imgnew/inv3/inv3-page2-img5.jpg', '2', '2');
INSERT INTO `wedding_lovephotos` VALUES ('22', '3', 'public/front/imgnew/inv3/inv3-page4-img4.jpg', '4', '1');
INSERT INTO `wedding_lovephotos` VALUES ('23', '4', 'public/front/imgnew/inv5/inv5-page5-img1.jpg', '4', '1');
INSERT INTO `wedding_lovephotos` VALUES ('24', '4', 'public/front/imgnew/inv5/inv5-page3-img1.jpg', '2', '1');
INSERT INTO `wedding_lovephotos` VALUES ('25', '4', 'public/front/imgnew/inv5/inv5-page2-img2.jpg', '1', '1');
INSERT INTO `wedding_lovephotos` VALUES ('26', '4', 'public/front/imgnew/inv5/inv5-page4-img3.jpg', '3', '1');
INSERT INTO `wedding_lovephotos` VALUES ('27', '4', 'public/front/imgnew/inv5/inv5-page4-img4.jpg', '3', '2');
INSERT INTO `wedding_lovephotos` VALUES ('28', '5', 'public/front/imgnew/child1/child1-page2-img2.jpg', '2', '1');
INSERT INTO `wedding_lovephotos` VALUES ('29', '5', 'public/front/imgnew/child1/child1-page2-img4.jpg', '2', '2');
INSERT INTO `wedding_lovephotos` VALUES ('30', '5', 'public/front/imgnew/child1/child1-page3-img2.jpg', '3', '1');
INSERT INTO `wedding_lovephotos` VALUES ('31', '5', 'public/front/imgnew/child1/child1-page4-img2.jpg', '4', '1');
INSERT INTO `wedding_lovephotos` VALUES ('32', '5', 'public/front/imgnew/child1/child1-page5-img2.jpg', '5', '1');
INSERT INTO `wedding_lovephotos` VALUES ('33', '5', 'public/front/imgnew/child1/child1-page5-img4.jpg', '5', '2');
INSERT INTO `wedding_lovephotos` VALUES ('34', '5', 'public/front/imgnew/child1/child1-page3-img4.jpg', '3', '2');
INSERT INTO `wedding_lovephotos` VALUES ('35', '5', 'public/front/imgnew/child1/child1-page1-img3.jpg', '1', '1');
INSERT INTO `wedding_lovephotos` VALUES ('36', '6', 'public/front/imgnew/child2/child2-page2-img9.jpg', '2', '2');
INSERT INTO `wedding_lovephotos` VALUES ('37', '6', 'public/front/imgnew/child2/child2-page5-img5.jpg', '5', '1');
INSERT INTO `wedding_lovephotos` VALUES ('38', '6', 'public/front/imgnew/child2/child2-page3-img5.jpg', '3', '1');
INSERT INTO `wedding_lovephotos` VALUES ('39', '6', 'public/front/imgnew/child2/child2-page4-img8.jpg', '4', '2');
INSERT INTO `wedding_lovephotos` VALUES ('40', '6', 'public/front/imgnew/child2/child2-page2-img8.jpg', '2', '1');
INSERT INTO `wedding_lovephotos` VALUES ('41', '6', 'public/front/imgnew/child2/child2-page1-img7.jpg', '1', '1');
INSERT INTO `wedding_lovephotos` VALUES ('42', '6', 'public/front/imgnew/child2/child2-page4-img7.jpg', '4', '1');
INSERT INTO `wedding_lovephotos` VALUES ('43', '7', 'public/front/imgnew/inv4/5a547451cc042.jpg', '1', '1');
INSERT INTO `wedding_lovephotos` VALUES ('44', '7', 'public/front/imgnew/inv4/5a5475314e997.jpg', '2', '1');
INSERT INTO `wedding_lovephotos` VALUES ('45', '7', 'public/front/imgnew/inv4/5a547531976dc.jpg', '2', '2');
INSERT INTO `wedding_lovephotos` VALUES ('46', '7', 'public/front/imgnew/inv4/5a54764cecd30.jpg', '3', '1');
INSERT INTO `wedding_lovephotos` VALUES ('47', '7', 'public/front/imgnew/inv4/5a5476ec972d6.jpg', '4', '2');
INSERT INTO `wedding_lovephotos` VALUES ('48', '7', 'public/front/imgnew/inv4/5a5476ec5e6da.jpg', '4', '3');
INSERT INTO `wedding_lovephotos` VALUES ('49', '7', 'public/front/imgnew/inv4/5a5476eb50136.jpg', '4', '1');
INSERT INTO `wedding_lovephotos` VALUES ('50', '8', 'public/front/child3/img/child1-page2-img4.jpg', '2', '2');
INSERT INTO `wedding_lovephotos` VALUES ('51', '8', 'public/front/child3/img/child1-page2-img2.jpg', '2', '1');
INSERT INTO `wedding_lovephotos` VALUES ('52', '8', 'public/front/child3/img/child1-page1-img3.jpg', '1', '1');
INSERT INTO `wedding_lovephotos` VALUES ('53', '8', 'public/front/child3/img/child1-page4-img2.jpg', '5', '4');
INSERT INTO `wedding_lovephotos` VALUES ('54', '8', 'public/front/child3/img/child1-page4-img2.jpg', '5', '3');
INSERT INTO `wedding_lovephotos` VALUES ('55', '8', 'public/front/child3/img/child1-page4-img1.jpg', '5', '2');
INSERT INTO `wedding_lovephotos` VALUES ('56', '8', 'public/front/child3/img/child1-page4-img1.jpg', '5', '1');
INSERT INTO `wedding_lovephotos` VALUES ('57', '8', 'public/front/child3/img/child1-page4-img3.jpg', '4', '3');
INSERT INTO `wedding_lovephotos` VALUES ('58', '8', 'public/front/child3/img/child1-page4-img2.jpg', '4', '2');
INSERT INTO `wedding_lovephotos` VALUES ('59', '8', 'public/front/child3/img/child1-page4-img1.jpg', '4', '1');
INSERT INTO `wedding_lovephotos` VALUES ('60', '8', 'public/front/child3/img/child1-page3-img3.jpg', '3', '3');
INSERT INTO `wedding_lovephotos` VALUES ('61', '8', 'public/front/child3/img/child1-page3-img2.jpg', '3', '2');
INSERT INTO `wedding_lovephotos` VALUES ('62', '8', 'public/front/child3/img/child1-page3-img1.jpg', '3', '1');
INSERT INTO `wedding_lovephotos` VALUES ('63', '9', 'public/front/child4/img/child4_03.jpg', '2', '2');
INSERT INTO `wedding_lovephotos` VALUES ('64', '9', 'public/front/child4/img/child4_05.jpg', '5', '3');
INSERT INTO `wedding_lovephotos` VALUES ('65', '9', 'public/front/child4/img/child4_04.jpg', '5', '2');
INSERT INTO `wedding_lovephotos` VALUES ('66', '9', 'public/front/child4/img/child4_06.jpg', '5', '4');
INSERT INTO `wedding_lovephotos` VALUES ('67', '9', 'public/front/child4/img/child4_03.jpg', '5', '1');
INSERT INTO `wedding_lovephotos` VALUES ('68', '9', 'public/front/child4/img/child4_11.jpg', '4', '5');
INSERT INTO `wedding_lovephotos` VALUES ('69', '9', 'public/front/child4/img/child4_05.jpg', '3', '3');
INSERT INTO `wedding_lovephotos` VALUES ('70', '9', 'public/front/child4/img/child4_10.jpg', '4', '4');
INSERT INTO `wedding_lovephotos` VALUES ('71', '9', 'public/front/child4/img/child4_09.jpg', '4', '3');
INSERT INTO `wedding_lovephotos` VALUES ('72', '9', 'public/front/child4/img/child4_08.jpg', '4', '2');
INSERT INTO `wedding_lovephotos` VALUES ('73', '9', 'public/front/child4/img/child4_04.jpg', '2', '1');
INSERT INTO `wedding_lovephotos` VALUES ('74', '9', 'public/front/child4/img/child4_01.jpg', '1', '1');
INSERT INTO `wedding_lovephotos` VALUES ('75', '9', 'public/front/child4/img/child4_04.jpg', '2', '3');
INSERT INTO `wedding_lovephotos` VALUES ('76', '9', 'public/front/child4/img/child4_03.jpg', '3', '1');
INSERT INTO `wedding_lovephotos` VALUES ('77', '9', 'public/front/child4/img/child4_04.jpg', '3', '2');
INSERT INTO `wedding_lovephotos` VALUES ('78', '9', 'public/front/child4/img/child4_06.jpg', '3', '4');
INSERT INTO `wedding_lovephotos` VALUES ('79', '9', 'public/front/child4/img/child4_07.jpg', '4', '1');
INSERT INTO `wedding_lovephotos` VALUES ('80', '10', 'public/front/imgnew/child1/child1-page5-img2.jpg', '5', '1');
INSERT INTO `wedding_lovephotos` VALUES ('81', '10', 'public/front/imgnew/child1/child1-page4-img2.jpg', '4', '1');
INSERT INTO `wedding_lovephotos` VALUES ('82', '10', 'public/front/imgnew/child1/child1-page3-img4.jpg', '3', '2');
INSERT INTO `wedding_lovephotos` VALUES ('83', '10', 'public/front/imgnew/child1/child1-page3-img2.jpg', '3', '1');
INSERT INTO `wedding_lovephotos` VALUES ('84', '10', 'public/front/imgnew/child1/child1-page2-img4.jpg', '2', '2');
INSERT INTO `wedding_lovephotos` VALUES ('85', '10', 'public/front/imgnew/child1/child1-page2-img2.jpg', '2', '1');
INSERT INTO `wedding_lovephotos` VALUES ('86', '10', 'public/front/imgnew/child1/child1-page1-img3.jpg', '1', '1');
INSERT INTO `wedding_lovephotos` VALUES ('87', '10', 'public/front/imgnew/child1/child1-page5-img4.jpg', '5', '2');

-- ----------------------------
-- Table structure for wedding_lovetemplate
-- ----------------------------
DROP TABLE IF EXISTS `wedding_lovetemplate`;
CREATE TABLE `wedding_lovetemplate` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//帖子模板id',
  `template_name` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//模版名称',
  `template_path` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//模版路径',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of wedding_lovetemplate
-- ----------------------------

-- ----------------------------
-- Table structure for wedding_money
-- ----------------------------
DROP TABLE IF EXISTS `wedding_money`;
CREATE TABLE `wedding_money` (
  `wed_project` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '//婚礼消费类型',
  `wed_name` varchar(50) CHARACTER SET utf8 DEFAULT NULL COMMENT '//消费项目',
  `wed_money` int(11) DEFAULT '0' COMMENT '//消费金额',
  `wed_status` tinyint(1) DEFAULT NULL COMMENT '//当前价格状态',
  `wed_remark` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '//备注',
  `wed_user` int(11) NOT NULL COMMENT '//当前执行人',
  `wed_per` char(10) CHARACTER SET utf8 DEFAULT NULL COMMENT '//百分比',
  `wed_show` tinyint(1) DEFAULT NULL COMMENT '//是否显示',
  `sort` tinyint(4) DEFAULT NULL COMMENT 'sort排序',
  `w_id` int(11) NOT NULL AUTO_INCREMENT,
  `wed_consume` tinyint(1) DEFAULT '1' COMMENT '//是否消费',
  `iswid` tinyint(1) DEFAULT '0' COMMENT '0表示userid就是m_users里的id,1表示userid是m_we_users里的wid',
  PRIMARY KEY (`w_id`),
  KEY `wed_user` (`wed_user`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2700 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of wedding_money
-- ----------------------------

-- ----------------------------
-- Table structure for wedding_moneytype
-- ----------------------------
DROP TABLE IF EXISTS `wedding_moneytype`;
CREATE TABLE `wedding_moneytype` (
  `wed_id` tinyint(2) unsigned NOT NULL AUTO_INCREMENT COMMENT '//结婚预算表类型id',
  `wed_type` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//消费类型',
  `wed_st` tinyint(1) DEFAULT '1' COMMENT '//当前项目状态',
  PRIMARY KEY (`wed_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of wedding_moneytype
-- ----------------------------

-- ----------------------------
-- Table structure for wedding_music
-- ----------------------------
DROP TABLE IF EXISTS `wedding_music`;
CREATE TABLE `wedding_music` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of wedding_music
-- ----------------------------

-- ----------------------------
-- Table structure for wed_money
-- ----------------------------
DROP TABLE IF EXISTS `wed_money`;
CREATE TABLE `wed_money` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//当前预算总和',
  `money_sum` int(11) DEFAULT '0' COMMENT '//预算总数',
  `money_user` int(11) DEFAULT '0' COMMENT '//设置总额的人',
  `iswid` tinyint(1) DEFAULT '0' COMMENT '0表示userid就是m_users里的id,1表示userid是m_we_users里的wid',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=69 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of wed_money
-- ----------------------------

-- ----------------------------
-- Table structure for wed_phos
-- ----------------------------
DROP TABLE IF EXISTS `wed_phos`;
CREATE TABLE `wed_phos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//相册id',
  `p_id` int(11) DEFAULT NULL COMMENT '//关联相册标题表的id',
  `p_name` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//作品路径',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=148 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of wed_phos
-- ----------------------------

-- ----------------------------
-- Table structure for wed_photoman
-- ----------------------------
DROP TABLE IF EXISTS `wed_photoman`;
CREATE TABLE `wed_photoman` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//相册点赞表id',
  `p_id` int(11) DEFAULT NULL COMMENT '//关联的相册表id',
  `p_user` int(11) DEFAULT NULL COMMENT '//哪个用户赞的id',
  `p_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//点赞时间',
  `iswid` tinyint(1) DEFAULT '0' COMMENT '0表示userid就是m_users里的id,1表示userid是m_we_users里的wid',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of wed_photoman
-- ----------------------------

-- ----------------------------
-- Table structure for wed_photos
-- ----------------------------
DROP TABLE IF EXISTS `wed_photos`;
CREATE TABLE `wed_photos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//婚礼相册id',
  `book_title` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//相册标题',
  `book_coutent` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//相册描述',
  `book_img` varchar(100) CHARACTER SET utf8 DEFAULT NULL COMMENT '//相册封面',
  `book_muise` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//相册播放音乐',
  `book_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//上传时间',
  `book_user` int(11) DEFAULT '0' COMMENT '//该相册添加人',
  `book_id` int(11) DEFAULT NULL COMMENT '//选择模版id',
  `book_sta` tinyint(1) DEFAULT '1' COMMENT '//当前模版状态',
  `iswid` tinyint(1) DEFAULT '0' COMMENT '0表示userid就是m_users里的id,1表示userid是m_we_users里的wid',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=67 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of wed_photos
-- ----------------------------

-- ----------------------------
-- Table structure for wed_ptem
-- ----------------------------
DROP TABLE IF EXISTS `wed_ptem`;
CREATE TABLE `wed_ptem` (
  `tem_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//模版id',
  `tem_name` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//模版名称',
  PRIMARY KEY (`tem_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of wed_ptem
-- ----------------------------

-- ----------------------------
-- Table structure for wx_auto_relay
-- ----------------------------
DROP TABLE IF EXISTS `wx_auto_relay`;
CREATE TABLE `wx_auto_relay` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `content` varchar(1000) COLLATE utf8_unicode_ci DEFAULT '',
  `brandid` int(11) DEFAULT '0',
  `create_time` datetime NOT NULL,
  `staff_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of wx_auto_relay
-- ----------------------------

-- ----------------------------
-- Table structure for wx_default_info
-- ----------------------------
DROP TABLE IF EXISTS `wx_default_info`;
CREATE TABLE `wx_default_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `follow_msg` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  `relay_msg` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `brandid` int(11) DEFAULT '0',
  `create_time` datetime NOT NULL,
  `staff_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `appid` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `appsecret` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of wx_default_info
-- ----------------------------

-- ----------------------------
-- Table structure for wx_event_log
-- ----------------------------
DROP TABLE IF EXISTS `wx_event_log`;
CREATE TABLE `wx_event_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `from_openid` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `openid` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `event_type` tinyint(1) DEFAULT '0',
  `brandid` int(11) DEFAULT '0',
  `create_time` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of wx_event_log
-- ----------------------------

-- ----------------------------
-- Table structure for wx_extend
-- ----------------------------
DROP TABLE IF EXISTS `wx_extend`;
CREATE TABLE `wx_extend` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ticket` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `scene` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `scaned_num` int(11) DEFAULT '0',
  `follow_num` int(11) DEFAULT '0',
  `brandid` int(11) DEFAULT '0',
  `create_time` datetime DEFAULT NULL,
  `delete_time` datetime DEFAULT NULL,
  `staff_id` int(11) DEFAULT '0',
  `staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of wx_extend
-- ----------------------------

-- ----------------------------
-- Table structure for wx_extend_detail
-- ----------------------------
DROP TABLE IF EXISTS `wx_extend_detail`;
CREATE TABLE `wx_extend_detail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `extend_id` int(11) DEFAULT '0',
  `openid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `state` tinyint(4) DEFAULT '0',
  `scan_time` datetime DEFAULT NULL,
  `follow_time` datetime DEFAULT NULL,
  `event` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `event_key` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1440 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of wx_extend_detail
-- ----------------------------

-- ----------------------------
-- Table structure for wx_help
-- ----------------------------
DROP TABLE IF EXISTS `wx_help`;
CREATE TABLE `wx_help` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `help_scene` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `help_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  `help_info` text COLLATE utf8_unicode_ci,
  `template_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `help_img` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  `brand_id` int(11) DEFAULT '0',
  `start_time` datetime DEFAULT NULL,
  `end_time` datetime DEFAULT NULL,
  `params` text COLLATE utf8_unicode_ci,
  `status` tinyint(4) DEFAULT NULL COMMENT '1有效，2无效/停止',
  `talk_code` text COLLATE utf8_unicode_ci,
  `subscribe_rule` text COLLATE utf8_unicode_ci,
  `sale_rule` text COLLATE utf8_unicode_ci,
  `share_title` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `share_content` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `root_ticket` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `test_ticket` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `award_top_image` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `award_foot_image` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `staff_name` varchar(11) COLLATE utf8_unicode_ci DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `delete_time` datetime DEFAULT NULL,
  `share_score` int(11) DEFAULT NULL COMMENT '分享得积分',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=50 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of wx_help
-- ----------------------------

-- ----------------------------
-- Table structure for wx_help_award
-- ----------------------------
DROP TABLE IF EXISTS `wx_help_award`;
CREATE TABLE `wx_help_award` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `help_id` int(11) DEFAULT NULL,
  `award_type` tinyint(4) DEFAULT NULL COMMENT '1优惠券2自定义',
  `award_value` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '如果是优惠券，则为优惠券名称,否则为奖品名称',
  `coupon_id` int(11) DEFAULT NULL COMMENT '优惠券批次号',
  `rule_type` int(11) DEFAULT NULL COMMENT '1排名，2邀请量',
  `rule_value` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '规则值',
  `pay_amount` decimal(10,2) DEFAULT NULL COMMENT '需要支付的钱，0表示不需要支付',
  `stock` int(11) DEFAULT '9999999' COMMENT '库存',
  `image` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `desc` text COLLATE utf8_unicode_ci,
  `create_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='用户奖项表，设置助力的奖项';

-- ----------------------------
-- Records of wx_help_award
-- ----------------------------

-- ----------------------------
-- Table structure for wx_help_templates
-- ----------------------------
DROP TABLE IF EXISTS `wx_help_templates`;
CREATE TABLE `wx_help_templates` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `title` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bg_image` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `top_image` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '领奖头部图片',
  `foot_image` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '领奖成功图片',
  `psd_url` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `params` text COLLATE utf8_unicode_ci,
  `status` tinyint(4) DEFAULT '1',
  `add_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='助力模板表';

-- ----------------------------
-- Records of wx_help_templates
-- ----------------------------
INSERT INTO `wx_help_templates` VALUES ('14', 'yungger', '萌宝表情包（儿童）', '/public/resource/images/6acdd1e7af65f002e251142a0c6e555a.jpg', '', '', '', '{\n        \"bg\": {\"scale\": \"1\", \"x\": \"0\", \"y\": \"0\"},\n        \"avatar\": {\"scale\": \"1\", \"x\": \"50\", \"y\": \"34\", \"color\": \"#ab9898\"},\n        \"qrcode\": {\"scale\": \"1\", \"x\": \"75\", \"y\": \"1164\"},\n        \"is_show_avatar\": \"1\"\n}', '1', '2018-03-08 19:52:31');
INSERT INTO `wx_help_templates` VALUES ('15', 'autumn', '你的爱情，我来记录（婚纱）', '/public/resource/images/373b67c6323e9d9ef72f10a44bfdb63c.jpg', '', '', '', '{\n        \"bg\": {\"scale\": \"1\", \"x\": \"0\", \"y\": \"0\"},\n        \"avatar\": {\"scale\": \"1\", \"x\": \"50\", \"y\": \"34\", \"color\": \"#ab9898\"},\n        \"qrcode\": {\"scale\": \"1\", \"x\": \"75\", \"y\": \"1164\"},\n        \"is_show_avatar\": \"1\"\n}', '1', '2018-03-08 19:52:31');
INSERT INTO `wx_help_templates` VALUES ('16', 'love', '有缘，相惠', '/public/resource/images/4737fdbc76c8a48640378922060afb0e.jpg', '', '', '', '{\n        \"bg\": {\"scale\": \"1\", \"x\": \"0\", \"y\": \"0\"},\n        \"avatar\": {\"scale\": \"1\", \"x\": \"50\", \"y\": \"34\", \"color\": \"#ab9898\"},\n        \"qrcode\": {\"scale\": \"1\", \"x\": \"75\", \"y\": \"1164\"},\n        \"is_show_avatar\": \"1\"\n}', '1', '2018-03-08 19:52:31');

-- ----------------------------
-- Table structure for wx_help_user
-- ----------------------------
DROP TABLE IF EXISTS `wx_help_user`;
CREATE TABLE `wx_help_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) DEFAULT NULL,
  `help_id` int(11) DEFAULT NULL,
  `head_img` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `help_num` int(11) DEFAULT '0',
  `fission_num` int(11) DEFAULT '0',
  `award_num` int(11) DEFAULT '0' COMMENT '领奖人数',
  `openid` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `phone` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `nick_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `parent_nick_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `parent_head_img` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `parent_ids` text COLLATE utf8_unicode_ci COMMENT '所有父ID',
  `ticket` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  `img` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  `add_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of wx_help_user
-- ----------------------------

-- ----------------------------
-- Table structure for wx_help_user_award
-- ----------------------------
DROP TABLE IF EXISTS `wx_help_user_award`;
CREATE TABLE `wx_help_user_award` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `openid` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `help_id` int(11) DEFAULT NULL,
  `award_id` int(11) DEFAULT NULL,
  `award_title` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '奖品名称',
  `award_image` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '奖品图片',
  `status` tinyint(4) DEFAULT NULL COMMENT '状态，1已领取，2已发放（自定义类）3支付中（需要支付才能领取的。默认是3支付成功后，变成已领取）',
  `get_time` datetime DEFAULT NULL,
  `send_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of wx_help_user_award
-- ----------------------------

-- ----------------------------
-- Table structure for wx_menu
-- ----------------------------
DROP TABLE IF EXISTS `wx_menu`;
CREATE TABLE `wx_menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parentid` int(11) DEFAULT '0',
  `name` varchar(60) COLLATE utf8_unicode_ci DEFAULT '',
  `url` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandid` int(11) DEFAULT '0',
  `create_time` datetime DEFAULT NULL,
  `staff_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `type` varchar(50) COLLATE utf8_unicode_ci DEFAULT 'view',
  `appid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pagepath` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `key` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of wx_menu
-- ----------------------------
