/*
Navicat MySQL Data Transfer

Source Server         : 127.0.0.1
Source Server Version : 50719
Source Host           : 127.0.0.1:3306
Source Database       : vipshop

Target Server Type    : MYSQL
Target Server Version : 50719
File Encoding         : 65001

Date: 2018-10-19 18:11:33
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for app_version
-- ----------------------------
DROP TABLE IF EXISTS `app_version`;
CREATE TABLE `app_version` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `version` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `up_time` datetime DEFAULT NULL,
  `up_sql` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='应用版本管理';

-- ----------------------------
-- Records of app_version
-- ----------------------------

-- ----------------------------
-- Table structure for tp_account_log
-- ----------------------------
DROP TABLE IF EXISTS `tp_account_log`;
CREATE TABLE `tp_account_log` (
  `log_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '日志id',
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `user_money` decimal(10,2) DEFAULT '0.00' COMMENT '用户金额',
  `frozen_money` decimal(10,2) DEFAULT '0.00' COMMENT '冻结金额',
  `pay_points` mediumint(9) NOT NULL DEFAULT '0' COMMENT '支付积分',
  `change_time` int(10) unsigned NOT NULL COMMENT '变动时间',
  `desc` varchar(255) NOT NULL DEFAULT '' COMMENT '描述',
  `order_sn` varchar(50) DEFAULT NULL COMMENT '订单编号',
  `order_id` int(10) DEFAULT NULL COMMENT '订单id',
  PRIMARY KEY (`log_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=685 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tp_account_log
-- ----------------------------

-- ----------------------------
-- Table structure for tp_ad
-- ----------------------------
DROP TABLE IF EXISTS `tp_ad`;
CREATE TABLE `tp_ad` (
  `ad_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '广告id',
  `pid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '广告位置ID',
  `media_type` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '广告类型',
  `ad_name` varchar(60) NOT NULL DEFAULT '' COMMENT '广告名称',
  `ad_link` varchar(255) NOT NULL DEFAULT '' COMMENT '链接地址',
  `ad_code` text NOT NULL COMMENT '图片地址',
  `start_time` int(11) NOT NULL DEFAULT '0' COMMENT '投放时间',
  `end_time` int(11) NOT NULL DEFAULT '0' COMMENT '结束时间',
  `link_man` varchar(60) NOT NULL DEFAULT '' COMMENT '添加人',
  `link_email` varchar(60) NOT NULL DEFAULT '' COMMENT '添加人邮箱',
  `link_phone` varchar(60) NOT NULL DEFAULT '' COMMENT '添加人联系电话',
  `click_count` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '点击量',
  `enabled` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '是否显示',
  `orderby` smallint(6) DEFAULT '50' COMMENT '排序',
  `target` tinyint(1) DEFAULT '0' COMMENT '是否开启浏览器新窗口',
  `bgcolor` varchar(20) DEFAULT NULL COMMENT '背景颜色',
  PRIMARY KEY (`ad_id`),
  KEY `enabled` (`enabled`),
  KEY `position_id` (`pid`)
) ENGINE=InnoDB AUTO_INCREMENT=104 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tp_ad
-- ----------------------------

-- ----------------------------
-- Table structure for tp_admin
-- ----------------------------
DROP TABLE IF EXISTS `tp_admin`;
CREATE TABLE `tp_admin` (
  `admin_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户id',
  `user_name` varchar(60) NOT NULL DEFAULT '' COMMENT '用户名',
  `email` varchar(60) NOT NULL DEFAULT '' COMMENT 'email',
  `password` varchar(32) NOT NULL DEFAULT '' COMMENT '密码',
  `ec_salt` varchar(10) DEFAULT NULL COMMENT '秘钥',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间',
  `last_login` int(11) NOT NULL DEFAULT '0' COMMENT '最后登录时间',
  `last_ip` varchar(15) NOT NULL DEFAULT '' COMMENT '最后登录ip',
  `nav_list` text COMMENT '权限',
  `lang_type` varchar(50) NOT NULL DEFAULT '' COMMENT 'lang_type',
  `agency_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'agency_id',
  `suppliers_id` smallint(5) unsigned DEFAULT '0' COMMENT 'suppliers_id',
  `todolist` longtext COMMENT 'todolist',
  `role_id` smallint(5) DEFAULT '0' COMMENT '角色id',
  `province_id` int(8) unsigned DEFAULT '0' COMMENT '加盟商省级id',
  `city_id` int(8) unsigned DEFAULT '0' COMMENT '加盟商市级id',
  `district_id` int(8) unsigned DEFAULT '0' COMMENT '加盟商区级id',
  PRIMARY KEY (`admin_id`),
  KEY `user_name` (`user_name`) USING BTREE,
  KEY `agency_id` (`agency_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tp_admin
-- ----------------------------

-- ----------------------------
-- Table structure for tp_admin_log
-- ----------------------------
DROP TABLE IF EXISTS `tp_admin_log`;
CREATE TABLE `tp_admin_log` (
  `log_id` bigint(16) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `admin_id` int(10) DEFAULT NULL COMMENT '管理员id',
  `log_info` varchar(255) DEFAULT NULL COMMENT '日志描述',
  `log_ip` varchar(30) DEFAULT NULL COMMENT 'ip地址',
  `log_url` varchar(50) DEFAULT NULL COMMENT 'url',
  `log_time` int(10) DEFAULT NULL COMMENT '日志时间',
  PRIMARY KEY (`log_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1291 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tp_admin_log
-- ----------------------------

-- ----------------------------
-- Table structure for tp_admin_role
-- ----------------------------
DROP TABLE IF EXISTS `tp_admin_role`;
CREATE TABLE `tp_admin_role` (
  `role_id` smallint(6) unsigned NOT NULL AUTO_INCREMENT COMMENT '角色ID',
  `role_name` varchar(30) DEFAULT NULL COMMENT '角色名称',
  `act_list` text COMMENT '权限列表',
  `role_desc` varchar(255) DEFAULT NULL COMMENT '角色描述',
  `code` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`role_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tp_admin_role
-- ----------------------------

-- ----------------------------
-- Table structure for tp_ad_position
-- ----------------------------
DROP TABLE IF EXISTS `tp_ad_position`;
CREATE TABLE `tp_ad_position` (
  `position_id` int(3) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `position_name` varchar(60) NOT NULL DEFAULT '' COMMENT '广告位置名称',
  `ad_width` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '广告位宽度',
  `ad_height` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '广告位高度',
  `position_desc` varchar(255) NOT NULL DEFAULT '' COMMENT '广告描述',
  `position_style` text COMMENT '模板',
  `is_open` tinyint(1) DEFAULT '0' COMMENT '0关闭1开启',
  PRIMARY KEY (`position_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5173 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tp_ad_position
-- ----------------------------

-- ----------------------------
-- Table structure for tp_app_version
-- ----------------------------
DROP TABLE IF EXISTS `tp_app_version`;
CREATE TABLE `tp_app_version` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `version` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `up_time` datetime DEFAULT NULL,
  `up_sql` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='应用版本管理';

-- ----------------------------
-- Records of tp_app_version
-- ----------------------------

-- ----------------------------
-- Table structure for tp_area_region
-- ----------------------------
DROP TABLE IF EXISTS `tp_area_region`;
CREATE TABLE `tp_area_region` (
  `shipping_area_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '物流配置id',
  `region_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '地区id对应region表id',
  PRIMARY KEY (`shipping_area_id`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tp_area_region
-- ----------------------------

-- ----------------------------
-- Table structure for tp_article
-- ----------------------------
DROP TABLE IF EXISTS `tp_article`;
CREATE TABLE `tp_article` (
  `article_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `cat_id` smallint(5) NOT NULL DEFAULT '0' COMMENT '类别ID',
  `title` varchar(150) NOT NULL DEFAULT '' COMMENT '文章标题',
  `content` longtext NOT NULL,
  `author` varchar(30) NOT NULL DEFAULT '' COMMENT '文章作者',
  `author_email` varchar(60) NOT NULL DEFAULT '' COMMENT '作者邮箱',
  `keywords` varchar(255) NOT NULL DEFAULT '' COMMENT '关键字',
  `article_type` tinyint(1) unsigned NOT NULL DEFAULT '2',
  `is_open` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0',
  `file_url` varchar(255) NOT NULL DEFAULT '' COMMENT '附件地址',
  `open_type` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `link` varchar(255) NOT NULL DEFAULT '' COMMENT '链接地址',
  `description` mediumtext COMMENT '文章摘要',
  `click` int(11) DEFAULT '0' COMMENT '浏览量',
  `publish_time` int(11) DEFAULT NULL COMMENT '文章预告发布时间',
  `thumb` varchar(255) DEFAULT '' COMMENT '文章缩略图',
  PRIMARY KEY (`article_id`),
  KEY `cat_id` (`cat_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tp_article
-- ----------------------------

-- ----------------------------
-- Table structure for tp_article_cat
-- ----------------------------
DROP TABLE IF EXISTS `tp_article_cat`;
CREATE TABLE `tp_article_cat` (
  `cat_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cat_name` varchar(20) DEFAULT NULL COMMENT '类别名称',
  `cat_type` smallint(6) DEFAULT '0' COMMENT '默认分组',
  `parent_id` smallint(6) DEFAULT '0' COMMENT '夫级ID',
  `show_in_nav` tinyint(1) DEFAULT '0' COMMENT '是否导航显示',
  `sort_order` smallint(6) DEFAULT '50' COMMENT '排序',
  `cat_desc` varchar(255) DEFAULT NULL COMMENT '分类描述',
  `keywords` varchar(30) DEFAULT NULL COMMENT '搜索关键词',
  `cat_alias` varchar(20) DEFAULT NULL COMMENT '别名',
  PRIMARY KEY (`cat_id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tp_article_cat
-- ----------------------------

-- ----------------------------
-- Table structure for tp_article_cat_2
-- ----------------------------
DROP TABLE IF EXISTS `tp_article_cat_2`;
CREATE TABLE `tp_article_cat_2` (
  `cat_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `cat_name` varchar(20) DEFAULT NULL COMMENT '类别名称',
  `cat_type` smallint(6) DEFAULT '0' COMMENT '系统分组',
  `parent_id` smallint(6) DEFAULT '0' COMMENT '夫级ID',
  `show_in_nav` tinyint(1) DEFAULT '0' COMMENT '是否导航显示',
  `sort_order` smallint(6) DEFAULT '50' COMMENT '排序',
  `cat_desc` varchar(255) DEFAULT NULL COMMENT '分类描述',
  `keywords` varchar(30) DEFAULT NULL COMMENT '搜索关键词',
  `cat_alias` varchar(20) DEFAULT NULL COMMENT '别名',
  PRIMARY KEY (`cat_id`)
) ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tp_article_cat_2
-- ----------------------------

-- ----------------------------
-- Table structure for tp_brand
-- ----------------------------
DROP TABLE IF EXISTS `tp_brand`;
CREATE TABLE `tp_brand` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '品牌表',
  `name` varchar(60) NOT NULL DEFAULT '' COMMENT '品牌名称',
  `logo` varchar(80) NOT NULL DEFAULT '' COMMENT '品牌logo',
  `desc` text NOT NULL COMMENT '品牌描述',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '品牌地址',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '50' COMMENT '排序',
  `cat_name` varchar(128) DEFAULT '' COMMENT '品牌分类',
  `parent_cat_id` int(11) DEFAULT '0' COMMENT '分类id',
  `cat_id` int(10) DEFAULT '0' COMMENT '分类id',
  `is_hot` tinyint(1) DEFAULT '0' COMMENT '是否推荐',
  `ext_cat_id` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=457 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tp_brand
-- ----------------------------

-- ----------------------------
-- Table structure for tp_cart
-- ----------------------------
DROP TABLE IF EXISTS `tp_cart`;
CREATE TABLE `tp_cart` (
  `id` int(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '购物车表',
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `session_id` char(128) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '' COMMENT 'session',
  `goods_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '商品id',
  `goods_sn` varchar(60) NOT NULL DEFAULT '' COMMENT '商品货号',
  `goods_name` varchar(120) NOT NULL DEFAULT '' COMMENT '商品名称',
  `market_price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '市场价',
  `goods_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '本店价',
  `member_goods_price` decimal(10,2) DEFAULT '0.00' COMMENT '会员折扣价',
  `goods_num` smallint(5) unsigned DEFAULT '0' COMMENT '购买数量',
  `spec_key` varchar(64) DEFAULT '' COMMENT '商品规格key 对应tp_spec_goods_price 表',
  `spec_key_name` varchar(64) DEFAULT '' COMMENT '商品规格组合名称',
  `bar_code` varchar(64) DEFAULT '' COMMENT '商品条码',
  `selected` tinyint(1) DEFAULT '1' COMMENT '购物车选中状态',
  `add_time` int(11) DEFAULT '0' COMMENT '加入购物车的时间',
  `prom_type` tinyint(1) DEFAULT '0' COMMENT '0 普通订单,1 限时抢购, 2 团购 , 3 促销优惠',
  `prom_id` int(11) DEFAULT '0' COMMENT '活动id',
  `sku` varchar(128) DEFAULT '' COMMENT 'sku',
  PRIMARY KEY (`id`),
  KEY `session_id` (`session_id`),
  KEY `user_id` (`user_id`),
  KEY `goods_id` (`goods_id`),
  KEY `spec_key` (`spec_key`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tp_cart
-- ----------------------------

-- ----------------------------
-- Table structure for tp_comment
-- ----------------------------
DROP TABLE IF EXISTS `tp_comment`;
CREATE TABLE `tp_comment` (
  `comment_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '评论id',
  `goods_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '商品id',
  `email` varchar(60) NOT NULL DEFAULT '' COMMENT 'email邮箱',
  `username` varchar(60) NOT NULL DEFAULT '' COMMENT '用户名',
  `content` text NOT NULL COMMENT '评论内容',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `ip_address` varchar(15) NOT NULL DEFAULT '' COMMENT 'ip地址',
  `is_show` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否显示',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父id',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '评论用户',
  `img` text COMMENT '晒单图片',
  `order_id` mediumint(8) DEFAULT '0' COMMENT '订单id',
  `deliver_rank` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '物流评价等级',
  `goods_rank` tinyint(1) DEFAULT '0' COMMENT '商品评价等级',
  `service_rank` tinyint(1) DEFAULT '0' COMMENT '商家服务态度评价等级',
  `zan_num` int(10) NOT NULL DEFAULT '0' COMMENT '被赞数',
  `zan_userid` varchar(255) NOT NULL DEFAULT '' COMMENT '点赞用户id',
  `is_anonymous` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否匿名评价:0不是，1是',
  `is_single` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`comment_id`),
  KEY `parent_id` (`parent_id`),
  KEY `id_value` (`goods_id`),
  KEY `order_id` (`order_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=12253 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tp_comment
-- ----------------------------

-- ----------------------------
-- Table structure for tp_config
-- ----------------------------
DROP TABLE IF EXISTS `tp_config`;
CREATE TABLE `tp_config` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `name` varchar(50) DEFAULT NULL COMMENT '配置的key键名',
  `value` varchar(512) DEFAULT NULL COMMENT '配置的val值',
  `inc_type` varchar(64) DEFAULT NULL COMMENT '配置分组',
  `desc` varchar(50) DEFAULT NULL COMMENT '描述',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=113 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tp_config
-- ----------------------------
INSERT INTO `tp_config` VALUES ('1', 'site_url', 'http://www.tp-shop.cn', 'shop_info', null);
INSERT INTO `tp_config` VALUES ('2', 'record_no', '粤12345678号', 'shop_info', null);
INSERT INTO `tp_config` VALUES ('3', 'store_name', '素玄科技商城', 'shop_info', null);
INSERT INTO `tp_config` VALUES ('4', 'store_logo', '/public/upload/logo/2018/01-25/b70db08bdc75650559fcc0603a339eda.png', 'shop_info', null);
INSERT INTO `tp_config` VALUES ('5', 'store_title', '微商城 | B2C商城 | B2B2C商城 | 三级分销 | 多用户商城  | 微商城', 'shop_info', null);
INSERT INTO `tp_config` VALUES ('6', 'store_desc', 'suxuantech', 'shop_info', null);
INSERT INTO `tp_config` VALUES ('7', 'store_keyword', '商城', 'shop_info', null);
INSERT INTO `tp_config` VALUES ('8', 'contact', '小V', 'shop_info', null);
INSERT INTO `tp_config` VALUES ('9', 'phone', '4001618099', 'shop_info', null);
INSERT INTO `tp_config` VALUES ('10', 'address', '沈河区中街路21号', 'shop_info', null);
INSERT INTO `tp_config` VALUES ('11', 'qq', '123456789', 'shop_info', null);
INSERT INTO `tp_config` VALUES ('12', 'qq2', '123456789', 'shop_info', null);
INSERT INTO `tp_config` VALUES ('13', 'qq3', '123456789', 'shop_info', null);
INSERT INTO `tp_config` VALUES ('14', 'freight_free', '100000', 'shopping', null);
INSERT INTO `tp_config` VALUES ('15', 'point_rate', '20', 'shopping', null);
INSERT INTO `tp_config` VALUES ('16', 'is_mark', '0', 'water', null);
INSERT INTO `tp_config` VALUES ('17', 'mark_txt', '', 'water', null);
INSERT INTO `tp_config` VALUES ('18', 'mark_img', '/public/upload/water/2018/01-31/f67217882a193c2cb30c613ffa8be67d.png', 'water', null);
INSERT INTO `tp_config` VALUES ('19', 'mark_width', '', 'water', null);
INSERT INTO `tp_config` VALUES ('20', 'mark_height', '', 'water', null);
INSERT INTO `tp_config` VALUES ('21', 'mark_degree', '54', 'water', null);
INSERT INTO `tp_config` VALUES ('22', 'mark_quality', '56', 'water', null);
INSERT INTO `tp_config` VALUES ('23', 'sel', '5', 'water', null);
INSERT INTO `tp_config` VALUES ('24', 'sms_url', 'https://yunpan.cn/OcRgiKWxZFmjSJ', 'sms', null);
INSERT INTO `tp_config` VALUES ('25', 'sms_user', '', 'sms', null);
INSERT INTO `tp_config` VALUES ('26', 'sms_pwd', '访问密码 080e', 'sms', null);
INSERT INTO `tp_config` VALUES ('27', 'regis_sms_enable', '1', 'sms', null);
INSERT INTO `tp_config` VALUES ('28', 'sms_time_out', '120', 'sms', null);
INSERT INTO `tp_config` VALUES ('29', 'reg_integral', '520', 'basic', null);
INSERT INTO `tp_config` VALUES ('30', 'file_size', '1', 'basic', null);
INSERT INTO `tp_config` VALUES ('31', 'default_storage', '1', 'basic', null);
INSERT INTO `tp_config` VALUES ('32', 'warning_storage', '1', 'basic', null);
INSERT INTO `tp_config` VALUES ('33', 'tax', '6', 'basic', null);
INSERT INTO `tp_config` VALUES ('34', 'is_remind', '0', 'basic', null);
INSERT INTO `tp_config` VALUES ('35', 'order_finish_time', '', 'basic', null);
INSERT INTO `tp_config` VALUES ('36', 'order_cancel_time', '', 'basic', null);
INSERT INTO `tp_config` VALUES ('37', 'hot_keywords', '手机|小米|iphone|三星|华为|冰箱', 'basic', null);
INSERT INTO `tp_config` VALUES ('38', '__hash__', '8d9fea07e44955760d3407524e469255_6ac8706878aa807db7ffb09dd0b02453', 'sms', null);
INSERT INTO `tp_config` VALUES ('40', 'app_test', '0', 'basic', null);
INSERT INTO `tp_config` VALUES ('41', 'switch', '1', 'distribut', null);
INSERT INTO `tp_config` VALUES ('42', 'condition', '0', 'distribut', null);
INSERT INTO `tp_config` VALUES ('43', 'name', '我的分销商', 'distribut', null);
INSERT INTO `tp_config` VALUES ('44', 'pattern', '0', 'distribut', null);
INSERT INTO `tp_config` VALUES ('45', 'order_rate', '30', 'distribut', null);
INSERT INTO `tp_config` VALUES ('46', 'first_name', '我的一级分销', 'distribut', null);
INSERT INTO `tp_config` VALUES ('47', 'first_rate', '70', 'distribut', null);
INSERT INTO `tp_config` VALUES ('48', 'second_name', '我的二级分销', 'distribut', null);
INSERT INTO `tp_config` VALUES ('49', 'second_rate', '20', 'distribut', null);
INSERT INTO `tp_config` VALUES ('50', 'third_name', '我的三级分销', 'distribut', null);
INSERT INTO `tp_config` VALUES ('51', 'third_rate', '10', 'distribut', null);
INSERT INTO `tp_config` VALUES ('52', 'date', '2', 'distribut', null);
INSERT INTO `tp_config` VALUES ('53', 'need', '200', 'basic', null);
INSERT INTO `tp_config` VALUES ('54', 'min', '200', 'basic', null);
INSERT INTO `tp_config` VALUES ('55', 'auto_confirm_date', '3', 'shopping', null);
INSERT INTO `tp_config` VALUES ('56', 'sms_appkey', '123456789', 'sms', null);
INSERT INTO `tp_config` VALUES ('57', 'sms_secretKey', '123456789', 'sms', null);
INSERT INTO `tp_config` VALUES ('58', 'sms_product', 'vc-one微商城', 'sms', null);
INSERT INTO `tp_config` VALUES ('59', 'sms_templateCode', 'SMS_101234567890', 'sms', null);
INSERT INTO `tp_config` VALUES ('60', 'smtp_server', 'smtp.qq.com', 'smtp', null);
INSERT INTO `tp_config` VALUES ('61', 'smtp_port', '25', 'smtp', null);
INSERT INTO `tp_config` VALUES ('62', 'smtp_user', '123456@qq.com', 'smtp', null);
INSERT INTO `tp_config` VALUES ('63', 'smtp_pwd', '123456', 'smtp', null);
INSERT INTO `tp_config` VALUES ('64', 'regis_smtp_enable', '0', 'smtp', null);
INSERT INTO `tp_config` VALUES ('65', 'test_eamil', '123456@qq.com', 'smtp', null);
INSERT INTO `tp_config` VALUES ('66', 'mobile', '123456789', 'shop_info', null);
INSERT INTO `tp_config` VALUES ('67', 'province', '5827', 'shop_info', null);
INSERT INTO `tp_config` VALUES ('68', 'city', '5828', 'shop_info', null);
INSERT INTO `tp_config` VALUES ('69', 'district', '0', 'shop_info', null);
INSERT INTO `tp_config` VALUES ('70', 'forget_pwd_sms_enable', '1', 'sms', null);
INSERT INTO `tp_config` VALUES ('71', 'bind_mobile_sms_enable', '1', 'sms', null);
INSERT INTO `tp_config` VALUES ('72', 'order_add_sms_enable', '1', 'sms', null);
INSERT INTO `tp_config` VALUES ('73', 'order_pay_sms_enable', '1', 'sms', null);
INSERT INTO `tp_config` VALUES ('74', 'order_shipping_sms_enable', '1', 'sms', null);
INSERT INTO `tp_config` VALUES ('75', 'form_submit', 'ok', 'distribut', null);
INSERT INTO `tp_config` VALUES ('76', 'form_submit', 'ok', 'shop_info', null);
INSERT INTO `tp_config` VALUES ('77', 'form_submit', 'ok', 'shopping', null);
INSERT INTO `tp_config` VALUES ('78', 'reduce', '1', 'shopping', null);
INSERT INTO `tp_config` VALUES ('79', 'form_submit', 'ok', '', null);
INSERT INTO `tp_config` VALUES ('80', 'reg_integral', '520', 'basic', null);
INSERT INTO `tp_config` VALUES ('81', 'file_size', '1', '', null);
INSERT INTO `tp_config` VALUES ('82', 'default_storage', '1', '', null);
INSERT INTO `tp_config` VALUES ('83', 'warning_storage', '1', '', null);
INSERT INTO `tp_config` VALUES ('86', 'tax', '6', '', null);
INSERT INTO `tp_config` VALUES ('87', 'hot_keywords', '手机|小米|iphone|三星|华为|冰箱', '', null);
INSERT INTO `tp_config` VALUES ('90', 'point_min_limit', '0', 'shopping', null);
INSERT INTO `tp_config` VALUES ('91', 'point_use_percent', '100', 'shopping', null);
INSERT INTO `tp_config` VALUES ('92', 'inc_type', 'smtp', 'smtp', null);
INSERT INTO `tp_config` VALUES ('93', 'qr_back', '/public/upload/weixin/2018/01-25/891781946b64cec6ed4da26786d76f49.jpg', 'distribut', null);
INSERT INTO `tp_config` VALUES ('94', 'qr_big_back', '/public/upload/weixin/2018/01-25/2d5f0e1df341b3d6bc1a462cdf077b44.jpg', 'distribut', null);
INSERT INTO `tp_config` VALUES ('95', 'qrcode_menu_word', '', 'distribut', null);
INSERT INTO `tp_config` VALUES ('96', 'qrcode_input_word', '', 'distribut', null);
INSERT INTO `tp_config` VALUES ('97', 'invite', '1', 'basic', null);
INSERT INTO `tp_config` VALUES ('98', 'invite_integral', '520', 'basic', null);
INSERT INTO `tp_config` VALUES ('99', 'auto_service_date', '15', 'shopping', null);
INSERT INTO `tp_config` VALUES ('100', 'sign_on_off', '1', 'sign', null);
INSERT INTO `tp_config` VALUES ('101', 'sign_integral', '10', 'sign', null);
INSERT INTO `tp_config` VALUES ('102', 'sign_signcount', '3', 'sign', null);
INSERT INTO `tp_config` VALUES ('103', 'sign_award', '12', 'sign', null);
INSERT INTO `tp_config` VALUES ('104', 'store_user_logo', '', 'shop_info', null);
INSERT INTO `tp_config` VALUES ('105', 'is_bind_account', '1', 'basic', null);
INSERT INTO `tp_config` VALUES ('106', 'sms_platform', '0', 'sms', null);
INSERT INTO `tp_config` VALUES ('107', 'virtual_goods_sms_enable', '0', 'sms', null);
INSERT INTO `tp_config` VALUES ('108', 'mark_txt_size', '30', 'water', null);
INSERT INTO `tp_config` VALUES ('109', 'mark_txt_color', '#000000', 'water', null);
INSERT INTO `tp_config` VALUES ('110', 'own_rate', '0', 'distribut', null);
INSERT INTO `tp_config` VALUES ('111', 'integral_use_enable', '1', 'shopping', null);
INSERT INTO `tp_config` VALUES ('112', 'mark_type', 'img', 'water', null);

-- ----------------------------
-- Table structure for tp_coupon
-- ----------------------------
DROP TABLE IF EXISTS `tp_coupon`;
CREATE TABLE `tp_coupon` (
  `id` int(8) NOT NULL AUTO_INCREMENT COMMENT '表id',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '优惠券名字',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '发放类型 0下单赠送1 指定发放 2 免费领取 3线下发放',
  `money` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '优惠券金额',
  `condition` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '使用条件',
  `createnum` int(11) DEFAULT '0' COMMENT '发放数量',
  `send_num` int(11) DEFAULT '0' COMMENT '已领取数量',
  `use_num` int(11) DEFAULT '0' COMMENT '已使用数量',
  `send_start_time` int(11) DEFAULT NULL COMMENT '发放开始时间',
  `send_end_time` int(11) DEFAULT NULL COMMENT '发放结束时间',
  `use_start_time` int(11) DEFAULT NULL COMMENT '使用开始时间',
  `use_end_time` int(11) DEFAULT NULL COMMENT '使用结束时间',
  `add_time` int(11) DEFAULT NULL COMMENT '添加时间',
  `status` int(2) DEFAULT NULL COMMENT '状态：0无效，1有效',
  `use_type` tinyint(1) DEFAULT '0' COMMENT '使用范围：0全店通用1指定商品可用2指定分类商品可用',
  PRIMARY KEY (`id`),
  KEY `use_end_time` (`use_end_time`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tp_coupon
-- ----------------------------

-- ----------------------------
-- Table structure for tp_coupon_list
-- ----------------------------
DROP TABLE IF EXISTS `tp_coupon_list`;
CREATE TABLE `tp_coupon_list` (
  `id` int(8) NOT NULL AUTO_INCREMENT COMMENT '表id',
  `cid` int(8) NOT NULL DEFAULT '0' COMMENT '优惠券 对应coupon表id',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '发放类型 1 按订单发放 2 注册 3 邀请 4 按用户发放',
  `uid` int(8) NOT NULL DEFAULT '0' COMMENT '用户id',
  `order_id` int(8) NOT NULL DEFAULT '0' COMMENT '订单id',
  `get_order_id` int(11) DEFAULT '0' COMMENT '优惠券来自订单ID',
  `use_time` int(11) NOT NULL DEFAULT '0' COMMENT '使用时间',
  `code` varchar(10) DEFAULT '' COMMENT '优惠券兑换码',
  `send_time` int(11) NOT NULL DEFAULT '0' COMMENT '发放时间',
  `status` tinyint(1) DEFAULT '0' COMMENT '0未使用1已使用2已过期',
  PRIMARY KEY (`id`),
  KEY `cid` (`cid`),
  KEY `uid` (`uid`),
  KEY `code` (`code`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=203 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tp_coupon_list
-- ----------------------------

-- ----------------------------
-- Table structure for tp_delivery_doc
-- ----------------------------
DROP TABLE IF EXISTS `tp_delivery_doc`;
CREATE TABLE `tp_delivery_doc` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '发货单ID',
  `order_id` int(11) unsigned NOT NULL COMMENT '订单ID',
  `order_sn` varchar(64) NOT NULL DEFAULT '' COMMENT '订单编号',
  `user_id` int(11) unsigned NOT NULL COMMENT '用户ID',
  `admin_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '管理员ID',
  `consignee` varchar(64) NOT NULL DEFAULT '' COMMENT '收货人',
  `zipcode` varchar(6) DEFAULT NULL COMMENT '邮编',
  `mobile` varchar(20) NOT NULL DEFAULT '' COMMENT '联系手机',
  `country` int(11) unsigned NOT NULL COMMENT '国ID',
  `province` int(11) unsigned NOT NULL COMMENT '省ID',
  `city` int(11) unsigned NOT NULL COMMENT '市ID',
  `district` int(11) unsigned NOT NULL COMMENT '区ID',
  `address` varchar(255) NOT NULL DEFAULT '' COMMENT '地址',
  `shipping_code` varchar(32) DEFAULT NULL COMMENT '物流code',
  `shipping_name` varchar(64) DEFAULT NULL COMMENT '快递名称',
  `shipping_price` decimal(10,2) DEFAULT '0.00' COMMENT '运费',
  `invoice_no` varchar(255) NOT NULL DEFAULT '' COMMENT '物流单号',
  `tel` varchar(64) DEFAULT NULL COMMENT '座机电话',
  `note` text COMMENT '管理员添加的备注信息',
  `best_time` int(11) DEFAULT NULL COMMENT '友好收货时间',
  `create_time` int(11) NOT NULL COMMENT '创建时间',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '是否删除',
  PRIMARY KEY (`id`),
  KEY `order_id` (`order_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=80 DEFAULT CHARSET=utf8 COMMENT='发货单';

-- ----------------------------
-- Records of tp_delivery_doc
-- ----------------------------

-- ----------------------------
-- Table structure for tp_distribut_goods
-- ----------------------------
DROP TABLE IF EXISTS `tp_distribut_goods`;
CREATE TABLE `tp_distribut_goods` (
  `user_id` int(11) DEFAULT NULL,
  `goods_id` int(11) DEFAULT NULL,
  `goods_name` varchar(255) DEFAULT NULL COMMENT '商品名称',
  `goods_price` decimal(10,2) DEFAULT NULL COMMENT '商品价格',
  `sales` int(11) DEFAULT NULL COMMENT '销量'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='分销商销售表';

-- ----------------------------
-- Records of tp_distribut_goods
-- ----------------------------

-- ----------------------------
-- Table structure for tp_distribut_level
-- ----------------------------
DROP TABLE IF EXISTS `tp_distribut_level`;
CREATE TABLE `tp_distribut_level` (
  `level_id` tinyint(2) unsigned NOT NULL AUTO_INCREMENT,
  `level_type` tinyint(1) DEFAULT '0' COMMENT '分销等级类别',
  `rate1` decimal(6,2) DEFAULT '0.00' COMMENT '一级佣金比例',
  `rate2` decimal(6,2) DEFAULT '0.00' COMMENT '二级佣金比例',
  `rate3` decimal(6,2) DEFAULT '0.00' COMMENT '三级佣金比例',
  `order_money` decimal(12,2) DEFAULT '0.00' COMMENT '升级条件',
  `level_name` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`level_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tp_distribut_level
-- ----------------------------

-- ----------------------------
-- Table structure for tp_expense_log
-- ----------------------------
DROP TABLE IF EXISTS `tp_expense_log`;
CREATE TABLE `tp_expense_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `admin_id` int(11) DEFAULT NULL COMMENT '操作管理员',
  `money` decimal(10,2) DEFAULT NULL COMMENT '支出金额',
  `type` tinyint(1) DEFAULT '0' COMMENT '支出类型0用户提现,1订单退款,2其他',
  `addtime` int(11) DEFAULT NULL COMMENT '日志记录时间',
  `log_type_id` int(11) DEFAULT '0' COMMENT '业务关联ID',
  `user_id` int(10) DEFAULT '0' COMMENT '涉及会员id',
  `user_name` int(10) DEFAULT '0' COMMENT '涉及商家id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1 COMMENT='平台支出记录日志';

-- ----------------------------
-- Records of tp_expense_log
-- ----------------------------

-- ----------------------------
-- Table structure for tp_feedback
-- ----------------------------
DROP TABLE IF EXISTS `tp_feedback`;
CREATE TABLE `tp_feedback` (
  `msg_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '默认自增ID',
  `parent_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '回复留言ID',
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  `user_name` varchar(60) NOT NULL DEFAULT '',
  `msg_title` varchar(200) NOT NULL DEFAULT '' COMMENT '留言标题',
  `msg_type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '留言类型',
  `msg_status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '处理状态',
  `msg_content` text NOT NULL COMMENT '留言内容',
  `msg_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '留言时间',
  `message_img` varchar(255) NOT NULL DEFAULT '',
  `order_id` int(11) unsigned NOT NULL DEFAULT '0',
  `msg_area` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`msg_id`),
  KEY `user_id` (`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tp_feedback
-- ----------------------------

-- ----------------------------
-- Table structure for tp_flash_sale
-- ----------------------------
DROP TABLE IF EXISTS `tp_flash_sale`;
CREATE TABLE `tp_flash_sale` (
  `id` bigint(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) NOT NULL DEFAULT '' COMMENT '活动标题',
  `goods_id` int(10) NOT NULL COMMENT '参团商品ID',
  `item_id` bigint(20) DEFAULT '0' COMMENT '对应spec_goods_price商品规格id',
  `price` float(10,2) NOT NULL COMMENT '活动价格',
  `goods_num` int(10) DEFAULT '1' COMMENT '商品参加活动数',
  `buy_limit` int(11) NOT NULL DEFAULT '1' COMMENT '每人限购数',
  `buy_num` int(11) NOT NULL DEFAULT '0' COMMENT '已购买人数',
  `order_num` int(10) DEFAULT '0' COMMENT '已下单数',
  `description` text COMMENT '活动描述',
  `start_time` int(11) NOT NULL COMMENT '开始时间',
  `end_time` int(11) NOT NULL COMMENT '结束时间',
  `is_end` tinyint(1) DEFAULT '0' COMMENT '是否已结束',
  `goods_name` varchar(255) DEFAULT NULL COMMENT '商品名称',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tp_flash_sale
-- ----------------------------

-- ----------------------------
-- Table structure for tp_friend_link
-- ----------------------------
DROP TABLE IF EXISTS `tp_friend_link`;
CREATE TABLE `tp_friend_link` (
  `link_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `link_name` varchar(255) NOT NULL DEFAULT '' COMMENT '链接名称',
  `link_url` varchar(255) NOT NULL DEFAULT '' COMMENT '链接地址',
  `link_logo` varchar(255) NOT NULL DEFAULT '' COMMENT '链接logo',
  `orderby` tinyint(3) unsigned NOT NULL DEFAULT '50' COMMENT '排序',
  `is_show` tinyint(1) DEFAULT '1' COMMENT '是否显示',
  `target` tinyint(1) DEFAULT '1' COMMENT '是否新窗口打开',
  PRIMARY KEY (`link_id`),
  KEY `show_order` (`orderby`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tp_friend_link
-- ----------------------------

-- ----------------------------
-- Table structure for tp_goods
-- ----------------------------
DROP TABLE IF EXISTS `tp_goods`;
CREATE TABLE `tp_goods` (
  `goods_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '商品id',
  `cat_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '分类id',
  `extend_cat_id` int(11) DEFAULT '0' COMMENT '扩展分类id',
  `goods_sn` varchar(60) NOT NULL DEFAULT '' COMMENT '商品编号',
  `goods_name` varchar(120) NOT NULL DEFAULT '' COMMENT '商品名称',
  `click_count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点击数',
  `brand_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '品牌id',
  `store_count` smallint(5) unsigned NOT NULL DEFAULT '10' COMMENT '库存数量',
  `comment_count` smallint(5) DEFAULT '0' COMMENT '商品评论数',
  `weight` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品重量克为单位',
  `market_price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '市场价',
  `shop_price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '本店价',
  `cost_price` decimal(10,2) DEFAULT '0.00' COMMENT '商品成本价',
  `price_ladder` text COMMENT '价格阶梯',
  `keywords` varchar(255) NOT NULL DEFAULT '' COMMENT '商品关键词',
  `goods_remark` varchar(255) NOT NULL DEFAULT '' COMMENT '商品简单描述',
  `goods_content` text COMMENT '商品详细描述',
  `original_img` varchar(255) NOT NULL DEFAULT '' COMMENT '商品上传原始图',
  `is_virtual` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否为虚拟商品 1是，0否',
  `virtual_indate` int(11) DEFAULT '0' COMMENT '虚拟商品有效期',
  `virtual_limit` smallint(6) DEFAULT '0' COMMENT '虚拟商品购买上限',
  `virtual_refund` tinyint(1) DEFAULT '1' COMMENT '是否允许过期退款， 1是，0否',
  `is_on_sale` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否上架',
  `is_free_shipping` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否包邮0否1是',
  `on_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商品上架时间',
  `sort` smallint(4) unsigned NOT NULL DEFAULT '50' COMMENT '商品排序',
  `is_recommend` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否推荐',
  `is_new` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否新品',
  `is_hot` tinyint(1) DEFAULT '0' COMMENT '是否热卖',
  `last_update` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最后更新时间',
  `goods_type` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '商品所属类型id，取值表goods_type的cat_id',
  `spec_type` smallint(5) DEFAULT '0' COMMENT '商品规格类型，取值表goods_type的cat_id',
  `give_integral` mediumint(8) DEFAULT '0' COMMENT '购买商品赠送积分',
  `exchange_integral` int(10) NOT NULL DEFAULT '0' COMMENT '积分兑换：0不参与积分兑换，积分和现金的兑换比例见后台配置',
  `suppliers_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '供货商ID',
  `sales_sum` int(11) DEFAULT '0' COMMENT '商品销量',
  `prom_type` tinyint(1) DEFAULT '0' COMMENT '0默认1抢购2团购3优惠促销4预售5虚拟(5其实没用)6拼团',
  `prom_id` int(11) DEFAULT '0' COMMENT '优惠活动id',
  `commission` decimal(10,2) DEFAULT '0.00' COMMENT '佣金用于分销分成',
  `spu` varchar(128) DEFAULT '' COMMENT 'SPU',
  `sku` varchar(128) DEFAULT '' COMMENT 'SKU',
  `shipping_area_ids` varchar(255) NOT NULL DEFAULT '' COMMENT '配送物流shipping_area_id,以逗号分隔',
  `level` int(10) NOT NULL COMMENT '会员等级',
  `is_coupon` int(10) NOT NULL DEFAULT '0' COMMENT '优惠（0不是 1 是）',
  `is_burft` int(10) NOT NULL DEFAULT '0' COMMENT '爆品(0不是  1是)',
  `serve` varchar(300) NOT NULL COMMENT '商品服务',
  `brand_data_id` varchar(250) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT '0',
  `discount` int(10) DEFAULT NULL,
  `seckill` int(10) DEFAULT '0',
  `start_time` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `end_time` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `miao_price` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`goods_id`),
  KEY `goods_sn` (`goods_sn`),
  KEY `cat_id` (`cat_id`),
  KEY `last_update` (`last_update`),
  KEY `brand_id` (`brand_id`),
  KEY `goods_number` (`store_count`),
  KEY `goods_weight` (`weight`),
  KEY `sort_order` (`sort`)
) ENGINE=InnoDB AUTO_INCREMENT=577 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tp_goods
-- ----------------------------

-- ----------------------------
-- Table structure for tp_goods_activity
-- ----------------------------
DROP TABLE IF EXISTS `tp_goods_activity`;
CREATE TABLE `tp_goods_activity` (
  `act_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '活动ID',
  `act_name` varchar(255) NOT NULL DEFAULT '' COMMENT '活动名称',
  `act_desc` text NOT NULL COMMENT '活动描述',
  `act_type` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '活动类型:1预售2拼团',
  `goods_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '参加活动商品ID',
  `spec_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '商品规格ID',
  `goods_name` varchar(255) NOT NULL DEFAULT '' COMMENT '商品名称',
  `start_time` int(10) unsigned NOT NULL COMMENT '活动开始时间',
  `end_time` int(10) unsigned NOT NULL COMMENT '活动结束时间',
  `is_finished` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否已结束:0,正常；1,成功结束；2，失败结束。',
  `ext_info` text NOT NULL COMMENT '活动扩展配置',
  `act_count` mediumint(8) NOT NULL DEFAULT '0' COMMENT '商品购买数',
  PRIMARY KEY (`act_id`),
  KEY `act_name` (`act_name`,`act_type`,`goods_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tp_goods_activity
-- ----------------------------

-- ----------------------------
-- Table structure for tp_goods_attr
-- ----------------------------
DROP TABLE IF EXISTS `tp_goods_attr`;
CREATE TABLE `tp_goods_attr` (
  `goods_attr_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '商品属性id自增',
  `goods_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '商品id',
  `attr_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '属性id',
  `attr_value` text NOT NULL COMMENT '属性值',
  `attr_price` varchar(255) NOT NULL DEFAULT '' COMMENT '属性价格',
  PRIMARY KEY (`goods_attr_id`),
  KEY `goods_id` (`goods_id`),
  KEY `attr_id` (`attr_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2725 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tp_goods_attr
-- ----------------------------

-- ----------------------------
-- Table structure for tp_goods_attribute
-- ----------------------------
DROP TABLE IF EXISTS `tp_goods_attribute`;
CREATE TABLE `tp_goods_attribute` (
  `attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '属性id',
  `attr_name` varchar(60) NOT NULL DEFAULT '' COMMENT '属性名称',
  `type_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '属性分类id',
  `attr_index` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '0不需要检索 1关键字检索 2范围检索',
  `attr_type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '0唯一属性 1单选属性 2复选属性',
  `attr_input_type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT ' 0 手工录入 1从列表中选择 2多行文本框',
  `attr_values` text NOT NULL COMMENT '可选值列表',
  `order` tinyint(3) unsigned NOT NULL DEFAULT '50' COMMENT '属性排序',
  PRIMARY KEY (`attr_id`),
  KEY `cat_id` (`type_id`)
) ENGINE=InnoDB AUTO_INCREMENT=672 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tp_goods_attribute
-- ----------------------------
INSERT INTO `tp_goods_attribute` VALUES ('56', '网络制式', '4', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('57', '支持频率/网络频率', '4', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('58', '尺寸体积', '4', '0', '0', '0', '   ', '0');
INSERT INTO `tp_goods_attribute` VALUES ('59', '外观样式/手机类型', '4', '0', '0', '1', '翻盖\r\n滑盖\r\n直板\r\n折叠\r\n手写', '0');
INSERT INTO `tp_goods_attribute` VALUES ('60', '主屏参数/内屏参数', '4', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('61', '副屏参数/外屏参数', '4', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('62', '清晰度', '4', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('63', '色数/灰度', '4', '0', '0', '1', '   ', '0');
INSERT INTO `tp_goods_attribute` VALUES ('64', '长度', '4', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('65', '宽度', '4', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('66', '厚度', '4', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('67', '屏幕材质', '4', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('68', '内存容量', '4', '0', '0', '1', '8G\r\n16G\r\n32G\r\n64G', '0');
INSERT INTO `tp_goods_attribute` VALUES ('69', '操作系统', '4', '1', '0', '0', 'android4.0\r\nandroid5.0\r\nandroid6.0', '0');
INSERT INTO `tp_goods_attribute` VALUES ('70', '通话时间', '4', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('71', '待机时间', '4', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('72', '标准配置', '4', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('73', 'WAP上网', '4', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('74', '数据业务', '4', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('75', '天线位置', '4', '0', '0', '1', '内置\r\n外置', '0');
INSERT INTO `tp_goods_attribute` VALUES ('76', '随机配件', '4', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('77', '铃声', '4', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('78', '摄像头', '4', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('79', '彩信/彩e', '4', '0', '0', '1', '支持\r\n不支持', '0');
INSERT INTO `tp_goods_attribute` VALUES ('80', '红外/蓝牙', '4', '1', '0', '0', '蓝牙2.0\r\n蓝牙3.0\r\n蓝牙4.0', '0');
INSERT INTO `tp_goods_attribute` VALUES ('81', '价格等级', '4', '0', '0', '1', '高价机\r\n中价机\r\n低价机', '0');
INSERT INTO `tp_goods_attribute` VALUES ('165', '产地', '8', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('166', '产品规格/容量', '8', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('167', '主要原料', '8', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('168', '所属类别', '8', '0', '0', '1', '彩妆\r\n化妆工具\r\n护肤品\r\n香水\r\n紧肤水', '0');
INSERT INTO `tp_goods_attribute` VALUES ('169', '使用部位', '8', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('170', '适合肤质', '8', '0', '0', '1', '油性\r\n中性\r\n干性', '0');
INSERT INTO `tp_goods_attribute` VALUES ('171', '适用人群', '8', '0', '0', '1', '女性\r\n男性', '0');
INSERT INTO `tp_goods_attribute` VALUES ('172', '上市日期', '9', '1', '0', '1', '2008年01月\r\n2008年02月\r\n2008年03月\r\n2008年04月\r\n2008年05月\r\n2008年06月', '0');
INSERT INTO `tp_goods_attribute` VALUES ('173', '手机制式', '9', '1', '0', '1', 'GSM,850,900,1800,1900\r\nGSM,900,1800,1900,2100\r\nCDMA\r\n双模（GSM,900,1800,CDMA 1X）\r\n3G(GSM,900,1800,1900,TD-SCDMA )', '1');
INSERT INTO `tp_goods_attribute` VALUES ('174', '理论通话时间', '9', '0', '0', '0', '', '2');
INSERT INTO `tp_goods_attribute` VALUES ('175', '理论待机时间', '9', '0', '0', '0', '', '3');
INSERT INTO `tp_goods_attribute` VALUES ('176', '铃声', '9', '0', '0', '0', '', '4');
INSERT INTO `tp_goods_attribute` VALUES ('177', '铃声格式', '9', '0', '0', '0', '', '5');
INSERT INTO `tp_goods_attribute` VALUES ('178', '外观样式', '9', '1', '0', '1', '翻盖\r\n滑盖\r\n直板\r\n折叠', '6');
INSERT INTO `tp_goods_attribute` VALUES ('179', '中文短消息', '9', '0', '0', '0', '', '7');
INSERT INTO `tp_goods_attribute` VALUES ('180', '存储卡格式', '9', '0', '1', '2', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('181', '内存容量', '9', '2', '1', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('182', '操作系统', '9', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('183', 'K-JAVA', '9', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('184', '尺寸体积', '9', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('185', '颜色', '9', '1', '1', '1', '黑色\r\n白色\r\n蓝色\r\n金色\r\n粉色\r\n银色\r\n灰色\r\n深李色\r\n黑红色\r\n黑蓝色\r\n白紫色', '0');
INSERT INTO `tp_goods_attribute` VALUES ('186', '屏幕颜色', '9', '1', '0', '1', '1600万\r\n262144万', '0');
INSERT INTO `tp_goods_attribute` VALUES ('187', '屏幕材质', '9', '0', '0', '1', 'TFT', '0');
INSERT INTO `tp_goods_attribute` VALUES ('188', '屏幕分辨率', '9', '1', '0', '1', '320×240 像素\r\n240×400 像素\r\n240×320 像素\r\n176x220 像素', '0');
INSERT INTO `tp_goods_attribute` VALUES ('189', '屏幕大小', '9', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('190', '中文输入法', '9', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('191', '情景模式', '9', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('192', '网络链接', '9', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('193', '蓝牙接口', '9', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('194', '数据线接口', '9', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('195', '电子邮件', '9', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('196', '闹钟', '9', '0', '0', '0', '', '35');
INSERT INTO `tp_goods_attribute` VALUES ('197', '办公功能', '9', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('198', '数码相机', '9', '1', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('199', '像素', '9', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('200', '传感器', '9', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('201', '变焦模式', '9', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('202', '视频拍摄', '9', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('203', 'MP3播放器', '9', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('204', '视频播放', '9', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('205', 'CPU频率', '9', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('206', '收音机', '9', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('207', '耳机接口', '9', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('208', '闪光灯', '9', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('209', '浏览器', '9', '0', '0', '0', '', '0');
INSERT INTO `tp_goods_attribute` VALUES ('210', '配件', '9', '0', '2', '1', '线控耳机\r\n蓝牙耳机\r\n数据线', '0');
INSERT INTO `tp_goods_attribute` VALUES ('223', '操作系统', '15', '0', '0', '1', 'Android \r\nIOS\r\nWindows', '50');
INSERT INTO `tp_goods_attribute` VALUES ('224', 'CPU核数', '15', '0', '0', '1', '双核\r\n四核\r\n八核', '50');
INSERT INTO `tp_goods_attribute` VALUES ('225', '品牌', '16', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('226', '型号', '16', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('227', 'CPU', '16', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('228', 'RAM', '16', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('229', '天线', '16', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('230', 'WPS功能', '16', '1', '0', '1', '支持\r\n不支持', '50');
INSERT INTO `tp_goods_attribute` VALUES ('231', '无线速率', '16', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('232', '传输标准', '16', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('233', '无线频段', '16', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('234', '品牌', '17', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('235', '型号', '17', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('236', '处理器', '17', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('237', '内存', '17', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('238', '闪存', '17', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('239', '蓝牙', '17', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('240', '扩展存储介质', '17', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('241', '操作系统', '17', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('242', '视频播放', '17', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('243', '无线功能', '17', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('244', '网络接口', '17', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('245', 'MicroSD卡槽', '17', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('246', 'USB接口', '17', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('247', '遥控器', '17', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('248', '产品尺寸', '17', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('249', '品牌', '18', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('250', '型号', '18', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('251', '分辨率', '18', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('252', '屏幕尺寸', '18', '1', '0', '1', '30\r\n32\r\n40\r\n42\r\n50\r\n55\r\n58', '50');
INSERT INTO `tp_goods_attribute` VALUES ('253', '屏幕比例', '18', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('254', '电视3D功能', '18', '1', '0', '1', '支持\r\n不支持', '50');
INSERT INTO `tp_goods_attribute` VALUES ('255', '保修政策 ', '18', '0', '0', '1', '一年\r\n两年\r\n三年\r\n四年\r\n五年', '50');
INSERT INTO `tp_goods_attribute` VALUES ('256', '品牌', '19', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('257', '床品套件类别', '19', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('258', '尺寸', '19', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('259', '适用床尺寸', '19', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('260', '面料', '19', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('261', '包裹清单', '19', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('262', '品牌', '20', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('263', '型号', '20', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('264', '家装风格', '20', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('265', '灯具材质', '20', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('266', '光源类型', '20', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('267', '适用空间', '20', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('268', '功率', '20', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('269', '光源个数', '20', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('270', '品牌', '21', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('271', '家具材质', '21', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('272', '是否带软靠', '21', '0', '0', '1', '是\r\n否', '50');
INSERT INTO `tp_goods_attribute` VALUES ('273', '是否带储物空间', '21', '0', '0', '1', '是\r\n否', '50');
INSERT INTO `tp_goods_attribute` VALUES ('274', '型号', '21', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('275', '最大承重量', '21', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('276', '重量', '21', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('277', '体积', '21', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('278', '床尺寸', '21', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('279', '品牌', '22', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('280', '打开方式', '22', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('281', '面料', '22', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('282', '伞骨材质', '22', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('283', '功能', '22', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('284', '品牌', '23', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('285', '厨具材质', '23', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('286', '型号', '23', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('287', '产地', '23', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('288', '毛重', '23', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('289', '面料主材质', '24', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('290', '版型', '24', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('291', '适用人群', '24', '1', '0', '1', '女士\r\n男士', '50');
INSERT INTO `tp_goods_attribute` VALUES ('292', '品牌', '26', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('293', '型号', '26', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('294', '模杯厚度', '26', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('295', '侧翼面料', '26', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('296', '插片', '26', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('297', '搭扣排数', '26', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('298', '肩带样式', '26', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('299', '罩杯面料', '26', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('300', '文胸款式', '26', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('301', '罩杯款式', '26', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('302', '钢圈', '26', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('303', '品牌', '27', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('304', '类别', '27', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('305', '保质期', '27', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('306', '产地', '27', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('307', '香调', '27', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('308', '适用人群', '27', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('309', '适用场所', '27', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('310', '规格', '27', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('311', '包装尺寸', '29', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('312', '毛重', '29', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('313', '品牌', '29', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('314', '制冷方式', '29', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('315', '能效等级', '29', '1', '0', '1', '一级\r\n二级\r\n三级\r\n四级\r\n五级', '50');
INSERT INTO `tp_goods_attribute` VALUES ('316', '包装尺寸', '30', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('317', '毛重', '30', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('318', '品牌', '30', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('319', '型号', '30', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('320', '能效等级', '30', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('321', '产品名称', '31', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('322', '品牌', '31', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('323', '电池容量', '31', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('324', '品牌', '32', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('325', '单反级别', '32', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('326', '屏幕尺寸', '32', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('327', '储存介质', '32', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('328', '像素', '32', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('330', '净含量', '8', '0', '0', '2', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('331', '适用肤质', '8', '1', '0', '1', '干性\r\n油性\r\n混合性\r\n敏感肌\r\n任何肤质', '50');
INSERT INTO `tp_goods_attribute` VALUES ('332', '是否有酒精', '8', '0', '0', '1', '有 \r\n无', '50');
INSERT INTO `tp_goods_attribute` VALUES ('335', '是否保温', '37', '1', '0', '1', '是\r\n否', '50');
INSERT INTO `tp_goods_attribute` VALUES ('336', '材质', '39', '1', '0', '1', '木质\r\n塑料', '50');
INSERT INTO `tp_goods_attribute` VALUES ('337', '婚庆用品类型', '39', '1', '0', '1', '糖盒\r\n糖袋', '50');
INSERT INTO `tp_goods_attribute` VALUES ('338', '风格', '39', '1', '0', '1', '中国风', '50');
INSERT INTO `tp_goods_attribute` VALUES ('339', '材质', '40', '1', '0', '1', '高密度PVC', '50');
INSERT INTO `tp_goods_attribute` VALUES ('340', '适应人群', '40', '1', '0', '1', '大众', '50');
INSERT INTO `tp_goods_attribute` VALUES ('341', '热水袋类型', '40', '1', '0', '1', '冲水热水袋', '50');
INSERT INTO `tp_goods_attribute` VALUES ('342', '流行元素', '40', '1', '0', '1', '卡通', '50');
INSERT INTO `tp_goods_attribute` VALUES ('344', '产品颜色', '41', '1', '0', '1', '见下图', '50');
INSERT INTO `tp_goods_attribute` VALUES ('345', '产品材质', '41', '1', '0', '1', '中纤版', '50');
INSERT INTO `tp_goods_attribute` VALUES ('346', '产品包装', '41', '1', '0', '1', '无', '50');
INSERT INTO `tp_goods_attribute` VALUES ('347', '产品重量', '41', '1', '0', '1', '76g', '50');
INSERT INTO `tp_goods_attribute` VALUES ('348', '形状', '42', '1', '0', '1', '异形', '50');
INSERT INTO `tp_goods_attribute` VALUES ('349', '气球及配件类型', '42', '1', '0', '1', '铝膜气球', '50');
INSERT INTO `tp_goods_attribute` VALUES ('350', '图案', '42', '1', '0', '1', '光版', '50');
INSERT INTO `tp_goods_attribute` VALUES ('351', '气球色泽', '42', '1', '0', '1', '标准色', '50');
INSERT INTO `tp_goods_attribute` VALUES ('352', '具体规格', '42', '1', '0', '1', '16英寸', '50');
INSERT INTO `tp_goods_attribute` VALUES ('353', '适用空间', '43', '1', '0', '1', '房间 把手/扶手', '50');
INSERT INTO `tp_goods_attribute` VALUES ('354', '材质', '43', '1', '0', '1', '无纺布绒布', '50');
INSERT INTO `tp_goods_attribute` VALUES ('355', '长度', '43', '1', '0', '1', '&gt;3 M', '50');
INSERT INTO `tp_goods_attribute` VALUES ('356', '型号', '43', '1', '0', '1', 'L-1-C4', '50');
INSERT INTO `tp_goods_attribute` VALUES ('357', '背身', '37', '1', '0', '1', '优质高白料玻璃', '50');
INSERT INTO `tp_goods_attribute` VALUES ('358', '容量', '37', '1', '0', '1', '300ml\r\n350ml', '50');
INSERT INTO `tp_goods_attribute` VALUES ('359', '杯盖', '37', '1', '0', '1', '食品级PP材质', '50');
INSERT INTO `tp_goods_attribute` VALUES ('360', '颜色', '37', '1', '0', '1', '看下图', '50');
INSERT INTO `tp_goods_attribute` VALUES ('361', '适用人群', '37', '1', '0', '1', '适用各个年龄阶段', '50');
INSERT INTO `tp_goods_attribute` VALUES ('362', '适用人群', '23', '1', '0', '1', '儿童', '50');
INSERT INTO `tp_goods_attribute` VALUES ('363', '货号', '23', '1', '0', '1', '不锈钢餐具两件套', '50');
INSERT INTO `tp_goods_attribute` VALUES ('364', '材质', '23', '1', '0', '1', '金属', '50');
INSERT INTO `tp_goods_attribute` VALUES ('365', '流行元素', '23', '1', '0', '1', '卡通', '50');
INSERT INTO `tp_goods_attribute` VALUES ('366', '风格', '23', '1', '0', '1', '卡通', '50');
INSERT INTO `tp_goods_attribute` VALUES ('367', '是否有香味', '8', '1', '0', '1', '无味\r\n有香味', '50');
INSERT INTO `tp_goods_attribute` VALUES ('368', '分类', '45', '1', '0', '1', '婚庆布景', '50');
INSERT INTO `tp_goods_attribute` VALUES ('369', '试用场景', '45', '1', '0', '1', '日常\r\n结婚\r\n演出派对\r\n其它', '50');
INSERT INTO `tp_goods_attribute` VALUES ('370', '颜色 ', '45', '1', '0', '1', '红色 \r\n其他', '50');
INSERT INTO `tp_goods_attribute` VALUES ('371', '风格', '45', '1', '0', '1', '中式\r\n西式\r\n其它', '50');
INSERT INTO `tp_goods_attribute` VALUES ('372', '材质', '45', '1', '0', '1', '纸质\r\n木质\r\n纯棉\r\n塑料\r\n陶瓷\r\n银纤维\r\n绒类', '50');
INSERT INTO `tp_goods_attribute` VALUES ('373', '类别', '45', '1', '0', '1', '气球', '50');
INSERT INTO `tp_goods_attribute` VALUES ('374', '试用人群', '45', '1', '0', '1', '成人', '50');
INSERT INTO `tp_goods_attribute` VALUES ('375', '枕套材质', '45', '1', '0', '1', '棉质\r\n晴纶\r\n涤纶', '50');
INSERT INTO `tp_goods_attribute` VALUES ('376', '形状', '45', '1', '0', '1', '长方形', '50');
INSERT INTO `tp_goods_attribute` VALUES ('377', '主题', '45', '1', '0', '1', '浪漫\r\n其它', '50');
INSERT INTO `tp_goods_attribute` VALUES ('378', '操作顺滑程度', '34', '1', '0', '1', '流畅\r\n非流畅', '50');
INSERT INTO `tp_goods_attribute` VALUES ('379', '产地', '34', '1', '0', '1', '中国大陆\r\n美国\r\n法国\r\n英国', '50');
INSERT INTO `tp_goods_attribute` VALUES ('380', '连接方式', '34', '1', '0', '1', '蓝牙', '50');
INSERT INTO `tp_goods_attribute` VALUES ('381', '游戏性能', '34', '1', '0', '1', '发烧级', '50');
INSERT INTO `tp_goods_attribute` VALUES ('382', '使用对象', '34', '1', '0', '1', '手机，PC，苹果，安卓\r\n所有人群\r\n成人\r\n儿童', '50');
INSERT INTO `tp_goods_attribute` VALUES ('383', '传播方式', '34', '1', '0', '1', '无线蓝牙\r\n有线\r\n无线', '50');
INSERT INTO `tp_goods_attribute` VALUES ('384', '尺码', '46', '1', '0', '1', 'S\r\nL\r\nXL\r\nXXL', '50');
INSERT INTO `tp_goods_attribute` VALUES ('385', '类型', '34', '1', '0', '1', '居家\r\n运动\r\n娱乐', '50');
INSERT INTO `tp_goods_attribute` VALUES ('386', '季节', '46', '1', '0', '1', '夏季\r\n冬季\r\n四季通用', '50');
INSERT INTO `tp_goods_attribute` VALUES ('387', '使用年龄', '46', '1', '0', '1', '通用\r\n产后恢复期\r\n6-36个月\r\n18个月以上\r\n0-3岁', '50');
INSERT INTO `tp_goods_attribute` VALUES ('388', '最大爬坡度', '34', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('389', '功率', '34', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('390', '材质', '46', '1', '0', '1', '银纤维\r\n进口实木\r\n金属\r\n其它\r\n塑料', '50');
INSERT INTO `tp_goods_attribute` VALUES ('391', '分类', '46', '1', '0', '1', '收腹带/束腹带\r\n湿巾\r\n学步车\r\n桌椅\r\n洗衣液/皂液\r\n脚踏车/手推车\r\n自行车\r\n润肤露、油、霜\r\n沐浴露/乳\r\n湿巾', '50');
INSERT INTO `tp_goods_attribute` VALUES ('392', '功能', '46', '1', '0', '1', '清洁\r\n带玩具 可折叠\r\n带餐盘 可组合 有安全带\r\n带手柄 带吸管\r\n遮阳棚 可手推\r\n带辅助轮\r\n带餐盘\r\n可坐可躺\r\n可坐可躺，可拆卸', '50');
INSERT INTO `tp_goods_attribute` VALUES ('393', '产地', '46', '1', '0', '1', '国产', '50');
INSERT INTO `tp_goods_attribute` VALUES ('394', '包装单位', '46', '1', '0', '1', '袋装\r\n瓶装\r\n组合装', '50');
INSERT INTO `tp_goods_attribute` VALUES ('395', '高度调节', '46', '1', '0', '1', '三挡', '50');
INSERT INTO `tp_goods_attribute` VALUES ('396', '最大承重', '46', '1', '0', '1', '8-13kg\r\n15kg', '50');
INSERT INTO `tp_goods_attribute` VALUES ('397', '奶瓶口径', '46', '1', '0', '1', '宽口径', '50');
INSERT INTO `tp_goods_attribute` VALUES ('398', '奶嘴型号', '46', '1', '0', '1', '十字孔', '50');
INSERT INTO `tp_goods_attribute` VALUES ('399', '材质', '47', '1', '0', '1', '金\r\n银', '50');
INSERT INTO `tp_goods_attribute` VALUES ('400', '风格', '47', '1', '0', '1', '日韩风格\r\n其他', '50');
INSERT INTO `tp_goods_attribute` VALUES ('401', '适用人群', '47', '1', '0', '1', '情侣\r\n女性', '50');
INSERT INTO `tp_goods_attribute` VALUES ('402', '容量', '46', '1', '0', '1', '500-999ml（g）', '50');
INSERT INTO `tp_goods_attribute` VALUES ('403', '适用尺寸', '46', '1', '0', '1', '120*60cm\r\n14寸', '50');
INSERT INTO `tp_goods_attribute` VALUES ('404', '厚度', '46', '1', '0', '1', '4cm以下', '50');
INSERT INTO `tp_goods_attribute` VALUES ('405', '商品毛重', '46', '1', '0', '1', '3.54kg', '50');
INSERT INTO `tp_goods_attribute` VALUES ('406', '品牌', '46', '1', '0', '1', '好孩子', '50');
INSERT INTO `tp_goods_attribute` VALUES ('407', '性别', '46', '1', '0', '1', '男', '50');
INSERT INTO `tp_goods_attribute` VALUES ('408', '车型', '46', '1', '0', '1', '其它', '50');
INSERT INTO `tp_goods_attribute` VALUES ('409', '包装尺寸', '46', '1', '0', '1', '其它', '50');
INSERT INTO `tp_goods_attribute` VALUES ('410', '包装尺寸', '46', '1', '0', '1', '其它\r\n展开尺寸960*660*1160折叠尺寸1000*350*500包装尺寸520*350*960\r\n座位宽度380mm座位高度610mm靠背长860mm', '50');
INSERT INTO `tp_goods_attribute` VALUES ('411', '净含量', '46', '1', '0', '1', '0-99ml（g）\r\n200-399ml（g）\r\n400ml（g）以上', '50');
INSERT INTO `tp_goods_attribute` VALUES ('412', '类型', '46', '1', '0', '1', '面霜\r\n洗护套装', '50');
INSERT INTO `tp_goods_attribute` VALUES ('413', '商品毛重', '49', '1', '0', '1', '0.65kg\r\n1.4kg\r\n0.6kg\r\n0.57kg', '50');
INSERT INTO `tp_goods_attribute` VALUES ('414', '电源方式', '49', '1', '0', '1', '点烟器电源', '50');
INSERT INTO `tp_goods_attribute` VALUES ('415', '净化技术', '49', '1', '0', '1', '活性炭', '50');
INSERT INTO `tp_goods_attribute` VALUES ('416', '功能', '49', '1', '0', '1', '过滤灰尘，消除异味，杀菌', '50');
INSERT INTO `tp_goods_attribute` VALUES ('417', '规格', '46', '1', '0', '1', '200ML', '50');
INSERT INTO `tp_goods_attribute` VALUES ('418', '材质', '50', '1', '0', '1', '纯皮\r\n皮油\r\n帆布\r\n其他\r\npvc', '50');
INSERT INTO `tp_goods_attribute` VALUES ('419', '适用人群', '50', '1', '0', '1', '男性\r\n女性\r\n儿童\r\n所有人', '50');
INSERT INTO `tp_goods_attribute` VALUES ('420', '功能', '50', '1', '0', '1', '双肩包\r\n单肩包\r\n斜挎包\r\n手提包\r\n手拿包', '50');
INSERT INTO `tp_goods_attribute` VALUES ('421', '尺寸', '50', '1', '0', '1', '常规\r\n中款\r\n小款', '50');
INSERT INTO `tp_goods_attribute` VALUES ('423', '水箱容量', '49', '1', '0', '1', '0-1L', '50');
INSERT INTO `tp_goods_attribute` VALUES ('424', '档位调温', '49', '1', '0', '1', '四档至六调温', '50');
INSERT INTO `tp_goods_attribute` VALUES ('425', '适用材质', '49', '1', '0', '1', '棉麻，化纤', '50');
INSERT INTO `tp_goods_attribute` VALUES ('426', '发热锅材质', '49', '1', '0', '1', '合金铝', '50');
INSERT INTO `tp_goods_attribute` VALUES ('427', '包装', '27', '1', '0', '1', '独立装', '50');
INSERT INTO `tp_goods_attribute` VALUES ('428', '商品产地', '46', '1', '0', '1', '上海', '50');
INSERT INTO `tp_goods_attribute` VALUES ('429', '商品名称', '49', '1', '0', '1', '小米鼠标垫', '50');
INSERT INTO `tp_goods_attribute` VALUES ('430', '商品产地', '49', '1', '0', '1', '中国大陆', '50');
INSERT INTO `tp_goods_attribute` VALUES ('431', '特点', '49', '1', '0', '1', '其他', '50');
INSERT INTO `tp_goods_attribute` VALUES ('432', '人群', '50', '1', '0', '1', '女士\r\n通用', '50');
INSERT INTO `tp_goods_attribute` VALUES ('433', '包装', '46', '1', '0', '1', '组合装', '50');
INSERT INTO `tp_goods_attribute` VALUES ('434', '耳机配件', '49', '1', '0', '1', '线材', '50');
INSERT INTO `tp_goods_attribute` VALUES ('435', '佩戴方式', '49', '1', '0', '1', '头戴式', '50');
INSERT INTO `tp_goods_attribute` VALUES ('436', '连接类型', '49', '1', '0', '1', '有线', '50');
INSERT INTO `tp_goods_attribute` VALUES ('437', '表盘', '51', '1', '0', '1', '圆形', '50');
INSERT INTO `tp_goods_attribute` VALUES ('438', '表底', '51', '1', '0', '1', '不透底\r\n透底', '50');
INSERT INTO `tp_goods_attribute` VALUES ('439', '表扣', '51', '1', '0', '1', '针扣\r\n折叠扣', '50');
INSERT INTO `tp_goods_attribute` VALUES ('440', '表径', '51', '1', '0', '1', '36-40mm\r\n41-43mm', '50');
INSERT INTO `tp_goods_attribute` VALUES ('441', '表镜材质', '51', '1', '0', '1', '矿物防花玻璃', '50');
INSERT INTO `tp_goods_attribute` VALUES ('442', '产地', '50', '1', '0', '1', '美国\r\n意大利\r\n德国\r\n中国', '50');
INSERT INTO `tp_goods_attribute` VALUES ('443', '人群', '52', '1', '0', '1', '男士\r\n女士\r\n儿童\r\n情侣款', '50');
INSERT INTO `tp_goods_attribute` VALUES ('444', '产地', '52', '1', '0', '1', '瑞士\r\n美国\r\n英国\r\n德国\r\n中国', '50');
INSERT INTO `tp_goods_attribute` VALUES ('445', '机芯', '52', '1', '0', '1', '石英\r\n机械\r\n自动机械', '50');
INSERT INTO `tp_goods_attribute` VALUES ('446', '表盘', '52', '1', '0', '1', '方形\r\n圆形\r\n椭圆形', '50');
INSERT INTO `tp_goods_attribute` VALUES ('447', '系统', '4', '1', '0', '1', '苹果（IOS）', '50');
INSERT INTO `tp_goods_attribute` VALUES ('448', '机身厚度', '4', '1', '0', '1', '薄（7mm-8.5mm）\r\n7.1mm-9mm', '50');
INSERT INTO `tp_goods_attribute` VALUES ('449', '拍照特点', '4', '1', '0', '1', '光学变焦，后置双摄像头', '50');
INSERT INTO `tp_goods_attribute` VALUES ('450', '电池容量', '4', '1', '0', '1', '2000mAh-2999mAh', '50');
INSERT INTO `tp_goods_attribute` VALUES ('451', '热点', '4', '1', '0', '1', '人脸识别，无线充电', '50');
INSERT INTO `tp_goods_attribute` VALUES ('452', '前置摄像头像素', '4', '1', '0', '1', '800万-1599万', '50');
INSERT INTO `tp_goods_attribute` VALUES ('453', '屏幕配置', '4', '1', '0', '1', 'OLED屏，符合全面屏比例', '50');
INSERT INTO `tp_goods_attribute` VALUES ('454', '机芯', '51', '1', '0', '1', '自动机芯', '50');
INSERT INTO `tp_goods_attribute` VALUES ('455', '适用人群', '51', '1', '0', '1', '男性', '50');
INSERT INTO `tp_goods_attribute` VALUES ('456', '商品毛重', '31', '1', '0', '0', '30.00g', '50');
INSERT INTO `tp_goods_attribute` VALUES ('457', '商品产地', '31', '1', '0', '1', '中国大陆', '50');
INSERT INTO `tp_goods_attribute` VALUES ('459', '款式', '53', '1', '0', '1', '休闲时尚\r\n商务休闲', '50');
INSERT INTO `tp_goods_attribute` VALUES ('460', '类型', '53', '1', '0', '1', '板扣', '50');
INSERT INTO `tp_goods_attribute` VALUES ('461', '材质', '53', '1', '0', '1', '牛皮\r\n皮质', '50');
INSERT INTO `tp_goods_attribute` VALUES ('462', '尺寸', '53', '1', '0', '1', '90cm\r\n全长约135cm（含扣头） 宽度约3.2cm 扣头长度约6.5cm 宽度约4.4cm', '50');
INSERT INTO `tp_goods_attribute` VALUES ('463', '商品毛重', '4', '1', '0', '1', '480.00g\r\n0.8kg', '50');
INSERT INTO `tp_goods_attribute` VALUES ('464', '商品产地', '4', '1', '0', '1', '中国大陆', '50');
INSERT INTO `tp_goods_attribute` VALUES ('465', '商品名称', '4', '1', '0', '1', 'AppleiPhone 8 Plus', '50');
INSERT INTO `tp_goods_attribute` VALUES ('466', '商品毛重', '54', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('467', '商品产地', '54', '1', '0', '1', '美国', '50');
INSERT INTO `tp_goods_attribute` VALUES ('468', '性能', '52', '1', '0', '1', '防水\r\n防摔', '50');
INSERT INTO `tp_goods_attribute` VALUES ('469', '商品毛重', '55', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('470', '分类', '55', '1', '0', '1', '项链', '50');
INSERT INTO `tp_goods_attribute` VALUES ('471', '商品产地', '55', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('472', '适合人群', '53', '1', '0', '1', '男士', '50');
INSERT INTO `tp_goods_attribute` VALUES ('473', '腰带扣类型', '53', '1', '0', '1', '针扣', '50');
INSERT INTO `tp_goods_attribute` VALUES ('474', '产地', '56', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('475', '类型', '56', '1', '0', '1', '贴片\r\n免洗\r\n睡眠面膜', '50');
INSERT INTO `tp_goods_attribute` VALUES ('476', '人群', '56', '1', '0', '1', '通用\r\n男士\r\n女士', '50');
INSERT INTO `tp_goods_attribute` VALUES ('477', '数量', '56', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('478', '商品毛重', '57', '1', '0', '1', '2.72kg', '50');
INSERT INTO `tp_goods_attribute` VALUES ('479', '商品产地', '57', '1', '0', '1', '中国大陆', '50');
INSERT INTO `tp_goods_attribute` VALUES ('480', '加热方式', '57', '1', '0', '1', '底盘加热', '50');
INSERT INTO `tp_goods_attribute` VALUES ('481', '适用人数', '57', '1', '0', '1', '2-3人（1.2L）', '50');
INSERT INTO `tp_goods_attribute` VALUES ('482', '杯体材质', '57', '1', '0', '1', '其他', '50');
INSERT INTO `tp_goods_attribute` VALUES ('483', '防水', '52', '1', '0', '1', '50米\r\n30米', '50');
INSERT INTO `tp_goods_attribute` VALUES ('484', '风格', '52', '1', '0', '1', '商务，休闲，运动', '50');
INSERT INTO `tp_goods_attribute` VALUES ('485', '表镜材质', '52', '1', '0', '1', '人工蓝宝石水晶玻璃', '50');
INSERT INTO `tp_goods_attribute` VALUES ('486', '表扣类型', '52', '1', '0', '1', '蝴蝶型', '50');
INSERT INTO `tp_goods_attribute` VALUES ('487', '商品毛重', '58', '1', '0', '0', '5.18kg', '50');
INSERT INTO `tp_goods_attribute` VALUES ('488', '适用环境', '58', '1', '0', '1', '地板，地毯，瓷砖，沙发', '50');
INSERT INTO `tp_goods_attribute` VALUES ('489', '产品特色', '58', '1', '0', '1', '水洗尘杯，水洗滤网', '50');
INSERT INTO `tp_goods_attribute` VALUES ('490', '类型', '58', '1', '0', '1', '无线吸尘器', '50');
INSERT INTO `tp_goods_attribute` VALUES ('491', '供电方式', '58', '1', '0', '1', '充电式（无线）', '50');
INSERT INTO `tp_goods_attribute` VALUES ('492', '功率', '58', '1', '0', '1', '500W以下', '50');
INSERT INTO `tp_goods_attribute` VALUES ('493', '吸头', '58', '1', '0', '1', '电动吸头，扁嘴吸头', '50');
INSERT INTO `tp_goods_attribute` VALUES ('494', '商品毛重', '59', '1', '0', '1', '4.4kg\r\n10.0kg', '50');
INSERT INTO `tp_goods_attribute` VALUES ('495', '操作方式', '59', '1', '0', '1', '按键式\r\n智能菜单', '50');
INSERT INTO `tp_goods_attribute` VALUES ('496', '功能', '59', '1', '0', '1', '榨汁，冰淇淋奶昔，豆浆\r\n面包机', '50');
INSERT INTO `tp_goods_attribute` VALUES ('497', '机身材质', '59', '1', '0', '1', '塑料', '50');
INSERT INTO `tp_goods_attribute` VALUES ('498', '功效', '8', '1', '0', '1', '补水 保湿\r\n提拉紧致 补水 抗衰 祛皱', '50');
INSERT INTO `tp_goods_attribute` VALUES ('499', '适合肤质', '8', '1', '0', '1', '所有肤质', '50');
INSERT INTO `tp_goods_attribute` VALUES ('500', '最大容量', '59', '1', '0', '1', '750-1000g（2-6人）', '50');
INSERT INTO `tp_goods_attribute` VALUES ('501', '商品毛重', '60', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('502', '功率', '60', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('503', '商品毛重', '52', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('504', '功能', '52', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('505', '材质', '61', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('506', '功能', '61', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('507', '供电方式', '61', '1', '0', '1', '外接电源', '50');
INSERT INTO `tp_goods_attribute` VALUES ('508', '接口类型', '61', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('509', '显示屏类型', '61', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('510', '尺寸', '62', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('511', '功能', '32', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('512', '传感器尺寸', '32', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('513', '适用肌龄', '8', '1', '0', '1', '25-34', '50');
INSERT INTO `tp_goods_attribute` VALUES ('514', '材质', '63', '1', '0', '1', '织物\r\n牛皮\r\n真皮\r\n皮质', '50');
INSERT INTO `tp_goods_attribute` VALUES ('515', '功能', '63', '1', '0', '1', '单肩包\r\n双肩包\r\n短款', '50');
INSERT INTO `tp_goods_attribute` VALUES ('516', '闭合方式', '63', '1', '0', '1', '拉链\r\n敞口', '50');
INSERT INTO `tp_goods_attribute` VALUES ('517', '适合人群', '63', '1', '0', '1', '男士', '50');
INSERT INTO `tp_goods_attribute` VALUES ('518', '特点', '32', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('519', '流行元素', '63', '1', '0', '1', '纯色', '50');
INSERT INTO `tp_goods_attribute` VALUES ('520', '产品类型', '64', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('521', '开合方式', '64', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('522', '洗碗方式', '64', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('523', '总容积', '64', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('524', '类别', '65', '1', '0', '1', '旅游婚纱摄影', '50');
INSERT INTO `tp_goods_attribute` VALUES ('525', '增值服务', '65', '1', '0', '1', '无隐形消费', '50');
INSERT INTO `tp_goods_attribute` VALUES ('526', '摄影拍摄地', '65', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('527', '款式', '63', '1', '0', '1', '其它', '50');
INSERT INTO `tp_goods_attribute` VALUES ('528', '颜色', '63', '1', '0', '1', '黑色', '50');
INSERT INTO `tp_goods_attribute` VALUES ('529', '商品毛重', '66', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('530', '功能', '66', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('531', '气态污染物CCM', '66', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('532', '固态污染物CCM', '66', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('533', '固态净化CADR', '66', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('534', '分类', '60', '1', '0', '0', '智能健康，其他', '50');
INSERT INTO `tp_goods_attribute` VALUES ('535', '安装方向', '46', '1', '0', '1', '正向安装\r\n双向安装\r\n反向安装', '50');
INSERT INTO `tp_goods_attribute` VALUES ('536', '配件分类', '46', '1', '0', '1', '防滑垫/护颈枕', '50');
INSERT INTO `tp_goods_attribute` VALUES ('537', '安装方式', '46', '1', '0', '1', 'isofix接口\r\n安全带', '50');
INSERT INTO `tp_goods_attribute` VALUES ('538', '最大承重', '46', '1', '0', '1', '26KG-36KG\r\n9KG-18KG\r\n9kg以下', '50');
INSERT INTO `tp_goods_attribute` VALUES ('539', '适用年龄', '46', '1', '0', '1', '9个月-12岁\r\n0-4岁\r\n0-9个月\r\n6月到6岁\r\n全阶段（0-3岁）', '50');
INSERT INTO `tp_goods_attribute` VALUES ('540', '调节方式', '46', '1', '0', '1', '调节高度\r\n可旋转 调节高度\r\n其它\r\n可调挡', '50');
INSERT INTO `tp_goods_attribute` VALUES ('541', '商品毛重', '67', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('542', '电机数量', '67', '1', '0', '1', '单电机', '50');
INSERT INTO `tp_goods_attribute` VALUES ('543', '分类', '67', '1', '0', '1', '甩脂机', '50');
INSERT INTO `tp_goods_attribute` VALUES ('544', '分类', '67', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('545', '适用人群', '67', '1', '0', '1', '儿童', '50');
INSERT INTO `tp_goods_attribute` VALUES ('546', '外部尺寸（长宽高mm）', '50', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('547', '镶嵌材质', '68', '1', '0', '1', '白18k金', '50');
INSERT INTO `tp_goods_attribute` VALUES ('548', '隔层尺寸（长宽高mm）', '50', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('549', '闭合方式', '50', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('550', '镶嵌方式', '68', '1', '0', '1', '爪镶', '50');
INSERT INTO `tp_goods_attribute` VALUES ('551', '圈号', '68', '1', '0', '1', '7#-16#', '50');
INSERT INTO `tp_goods_attribute` VALUES ('552', '主石重量', '68', '1', '0', '1', '11-20分', '50');
INSERT INTO `tp_goods_attribute` VALUES ('553', '副石重量', '68', '1', '0', '1', '10分以下', '50');
INSERT INTO `tp_goods_attribute` VALUES ('554', '商品毛重', '49', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('555', '商品毛重', '69', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('556', '商品产地', '69', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('557', '功率', '69', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('558', '商品毛重', '70', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('559', '商品产地', '70', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('560', '功率', '70', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('561', '商品产地', '58', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('562', '类型', '58', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('563', '功率', '58', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('564', '吸头', '58', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('565', '适用环境', '58', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('566', '商品产地', '60', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('567', '商品产地', '71', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('568', '适用面积', '71', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('569', '类型', '71', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('570', '控制方式', '71', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('571', '功率', '71', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('572', '人群', '72', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('573', '风格', '72', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('574', '镜片材质', '72', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('575', '商品产地', '72', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('576', '功能', '72', '0', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('577', '类别', '31', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('578', '理论时速', '67', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('579', '理论续航', '67', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('580', '功率', '67', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('581', '商品毛重', '67', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('582', '容量', '60', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('583', 'hh', '8', '1', '0', '1', 'hhh', '50');
INSERT INTO `tp_goods_attribute` VALUES ('584', '商品毛重', '74', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('585', '辅助功能', '74', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('586', '刀片页数', '74', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('587', '操作方式', '74', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('588', '加热方式', '74', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('589', '是否配置双杯', '74', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('590', '适用人数', '74', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('591', '腰带长度', '53', '1', '0', '1', '110-130CM', '50');
INSERT INTO `tp_goods_attribute` VALUES ('592', '功能', '60', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('593', '加热方式', '60', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('594', '控温方式', '29', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('595', '产品类型', '67', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('596', '产品特点', '67', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('597', '变频/定频', '29', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('598', '冷暖类型', '29', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('599', '使用面积', '29', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('600', '洗涤容量', '30', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('601', '排水类型', '30', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('602', '流行元素', '50', '1', '0', '1', '走秀款，专柜款\r\n铆钉，纯色', '50');
INSERT INTO `tp_goods_attribute` VALUES ('603', '处理器', '67', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('604', '商品毛重', '75', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('605', '商品产地', '75', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('606', '类型', '75', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('607', '类别', '75', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('608', '水箱容量', '75', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('609', '奶泡系统', '75', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('610', '商品毛重', '76', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('611', '商品产地', '76', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('612', '发热锅材质', '76', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('613', '水箱容量', '76', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('614', '档位调温', '76', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('615', '商品产地', '77', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('616', '刀头类型', '77', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('617', '清洁类型', '77', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('618', '剃须类型', '77', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('619', '充电类型', '77', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('620', '续航时间', '77', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('621', '商品匹数', '29', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('622', '适用人数', '67', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('623', '连接方式', '67', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('624', '人体固定方式', '46', '1', '0', '1', '五点式安全带固定', '50');
INSERT INTO `tp_goods_attribute` VALUES ('625', '标准模式', '46', '1', '0', '1', '3c', '50');
INSERT INTO `tp_goods_attribute` VALUES ('626', '商品毛重', '78', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('627', '腕带材质', '78', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('628', '兼容性', '78', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('629', '操控方式', '78', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('630', '防水', '78', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('631', '待机时间', '78', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('632', '供电方式', '67', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('633', '商品毛重', '79', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('634', '连接类型', '79', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('635', '佩戴方式', '79', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('636', '电池容量', '4', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('637', '前置摄像头像素', '4', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('638', '后置摄像头像素', '4', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('639', '面料', '46', '1', '0', '1', '棉', '50');
INSERT INTO `tp_goods_attribute` VALUES ('640', '分类', '46', '1', '0', '1', '餐椅，儿童桌\r\n双胞胎推车', '50');
INSERT INTO `tp_goods_attribute` VALUES ('641', '尺码', '80', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('642', '厚度', '80', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('643', '适合季节', '80', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('644', '材质', '80', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('645', '适用人群', '80', '1', '0', '1', '男士\r\n女士', '50');
INSERT INTO `tp_goods_attribute` VALUES ('646', '车篷', '46', '1', '0', '1', '半篷\r\n其它', '50');
INSERT INTO `tp_goods_attribute` VALUES ('647', '类型', '81', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('648', '机身尺寸', '81', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('649', '商品毛重', '81', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('650', '使用环境温度', '81', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('651', '连接方式', '83', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('652', '自动双面打印', '83', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('653', '使用场景', '83', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('654', '打印速度', '83', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('655', '打印机类型', '83', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('656', '尺寸', '83', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('657', '是否带摄像头', '67', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('658', '控制类型', '67', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('659', '充电类型', '67', '1', '0', '0', '', '50');
INSERT INTO `tp_goods_attribute` VALUES ('660', '材质', '82', '1', '0', '1', '铜', '50');
INSERT INTO `tp_goods_attribute` VALUES ('661', '系列', '82', '1', '0', '1', '盔甲徽章\r\n套装系列', '50');
INSERT INTO `tp_goods_attribute` VALUES ('662', '商品产地', '82', '1', '0', '1', '美国宾西法尼亚州', '50');
INSERT INTO `tp_goods_attribute` VALUES ('663', '工艺类型', '82', '1', '0', '1', '徽章\r\n其它', '50');
INSERT INTO `tp_goods_attribute` VALUES ('664', '分类', '82', '1', '0', '1', '打火机', '50');
INSERT INTO `tp_goods_attribute` VALUES ('665', '烟嘴类型', '82', '1', '0', '1', '其它', '50');
INSERT INTO `tp_goods_attribute` VALUES ('666', '商品产地', '84', '1', '0', '1', '中国/上海', '50');
INSERT INTO `tp_goods_attribute` VALUES ('667', '类型', '84', '1', '0', '1', '钢笔', '50');
INSERT INTO `tp_goods_attribute` VALUES ('668', '笔杆材质', '84', '1', '0', '1', '金属', '50');
INSERT INTO `tp_goods_attribute` VALUES ('669', '数量', '84', '1', '0', '1', '礼盒装', '50');
INSERT INTO `tp_goods_attribute` VALUES ('670', '书写粗细', '84', '1', '0', '1', '0.5mm', '50');
INSERT INTO `tp_goods_attribute` VALUES ('671', '商品毛重', '82', '1', '0', '1', '300g\r\n320g', '50');

-- ----------------------------
-- Table structure for tp_goods_category
-- ----------------------------
DROP TABLE IF EXISTS `tp_goods_category`;
CREATE TABLE `tp_goods_category` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '商品分类id',
  `name` varchar(90) NOT NULL DEFAULT '' COMMENT '商品分类名称',
  `mobile_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT '' COMMENT '手机端显示的商品分类名',
  `parent_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '父id',
  `parent_id_path` varchar(128) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT '' COMMENT '家族图谱',
  `level` tinyint(1) DEFAULT '0' COMMENT '等级',
  `sort_order` tinyint(1) unsigned NOT NULL DEFAULT '50' COMMENT '顺序排序',
  `is_show` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否显示',
  `image` varchar(512) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT '' COMMENT '分类图片',
  `is_hot` tinyint(1) DEFAULT '0' COMMENT '是否推荐为热门分类',
  `cat_group` tinyint(1) DEFAULT '0' COMMENT '分类分组默认0',
  `commission_rate` tinyint(1) DEFAULT '0' COMMENT '分佣比例',
  `englishname` varchar(150) NOT NULL COMMENT '英文简称',
  `is_brand` tinyint(1) DEFAULT NULL,
  `is_index` tinyint(1) DEFAULT NULL,
  `brandid` int(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tp_goods_category
-- ----------------------------

-- ----------------------------
-- Table structure for tp_goods_collect
-- ----------------------------
DROP TABLE IF EXISTS `tp_goods_collect`;
CREATE TABLE `tp_goods_collect` (
  `collect_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `goods_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '商品id',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`collect_id`),
  KEY `user_id` (`user_id`),
  KEY `goods_id` (`goods_id`)
) ENGINE=InnoDB AUTO_INCREMENT=337 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tp_goods_collect
-- ----------------------------

-- ----------------------------
-- Table structure for tp_goods_consult
-- ----------------------------
DROP TABLE IF EXISTS `tp_goods_consult`;
CREATE TABLE `tp_goods_consult` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '商品咨询id',
  `goods_id` int(11) DEFAULT '0' COMMENT '商品id',
  `username` varchar(32) CHARACTER SET utf8 DEFAULT '' COMMENT '网名',
  `add_time` int(11) DEFAULT '0' COMMENT '咨询时间',
  `consult_type` tinyint(1) DEFAULT '1' COMMENT '1 商品咨询 2 支付咨询 3 配送 4 售后',
  `content` varchar(1024) CHARACTER SET utf8 DEFAULT '' COMMENT '咨询内容',
  `parent_id` int(11) DEFAULT '0' COMMENT '父id 用于管理员回复',
  `is_show` tinyint(1) DEFAULT '0' COMMENT '是否显示',
  `status` tinyint(1) DEFAULT '0' COMMENT '管理员回复状态，0未回复，1已回复',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1876 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tp_goods_consult
-- ----------------------------

-- ----------------------------
-- Table structure for tp_goods_coupon
-- ----------------------------
DROP TABLE IF EXISTS `tp_goods_coupon`;
CREATE TABLE `tp_goods_coupon` (
  `coupon_id` int(8) NOT NULL COMMENT '优惠券id',
  `goods_id` int(11) NOT NULL DEFAULT '0' COMMENT '指定的商品id：为零表示不指定商品',
  `goods_category_id` smallint(5) NOT NULL DEFAULT '0' COMMENT '指定的商品分类：为零表示不指定分类',
  PRIMARY KEY (`coupon_id`,`goods_id`,`goods_category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tp_goods_coupon
-- ----------------------------

-- ----------------------------
-- Table structure for tp_goods_images
-- ----------------------------
DROP TABLE IF EXISTS `tp_goods_images`;
CREATE TABLE `tp_goods_images` (
  `img_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '图片id 自增',
  `goods_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '商品id',
  `image_url` varchar(255) NOT NULL DEFAULT '' COMMENT '图片地址',
  PRIMARY KEY (`img_id`),
  KEY `goods_id` (`goods_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1936 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tp_goods_images
-- ----------------------------

-- ----------------------------
-- Table structure for tp_goods_type
-- ----------------------------
DROP TABLE IF EXISTS `tp_goods_type`;
CREATE TABLE `tp_goods_type` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id自增',
  `name` varchar(60) NOT NULL DEFAULT '' COMMENT '类型名称',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=85 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tp_goods_type
-- ----------------------------

-- ----------------------------
-- Table structure for tp_goods_visit
-- ----------------------------
DROP TABLE IF EXISTS `tp_goods_visit`;
CREATE TABLE `tp_goods_visit` (
  `visit_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `goods_id` int(11) NOT NULL COMMENT '商品ID',
  `user_id` int(11) NOT NULL COMMENT '会员ID',
  `visittime` int(11) NOT NULL COMMENT '浏览时间',
  `cat_id` int(11) NOT NULL COMMENT '商品分类ID',
  `extend_cat_id` int(11) NOT NULL COMMENT '商品扩展分类ID',
  PRIMARY KEY (`goods_id`,`user_id`,`visit_id`),
  KEY `visit_id` (`visit_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=546 DEFAULT CHARSET=utf8 COMMENT='商品浏览历史表';

-- ----------------------------
-- Records of tp_goods_visit
-- ----------------------------

-- ----------------------------
-- Table structure for tp_group_buy
-- ----------------------------
DROP TABLE IF EXISTS `tp_group_buy`;
CREATE TABLE `tp_group_buy` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '团购ID',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '活动名称',
  `start_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '开始时间',
  `end_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '结束时间',
  `goods_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商品ID',
  `item_id` bigint(20) DEFAULT '0' COMMENT '对应spec_goods_price商品规格id',
  `price` decimal(10,2) NOT NULL COMMENT '团购价格',
  `goods_num` int(10) DEFAULT '0' COMMENT '商品参团数',
  `buy_num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商品已购买数',
  `order_num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '已下单人数',
  `virtual_num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '虚拟购买数',
  `rebate` decimal(10,1) NOT NULL COMMENT '折扣',
  `intro` text COMMENT '本团介绍',
  `goods_price` decimal(10,2) NOT NULL COMMENT '商品原价',
  `goods_name` varchar(200) NOT NULL DEFAULT '' COMMENT '商品名称',
  `recommended` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否推荐 0.未推荐 1.已推荐',
  `views` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '查看次数',
  `is_end` tinyint(1) DEFAULT '0' COMMENT '是否结束',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COMMENT='团购商品表';

-- ----------------------------
-- Records of tp_group_buy
-- ----------------------------

-- ----------------------------
-- Table structure for tp_invoice
-- ----------------------------
DROP TABLE IF EXISTS `tp_invoice`;
CREATE TABLE `tp_invoice` (
  `invoice_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) DEFAULT NULL COMMENT '订单id',
  `user_id` int(11) DEFAULT NULL COMMENT '用户id',
  `invoice_type` tinyint(1) DEFAULT '0' COMMENT '0普通发票1电子发票2增值税发票',
  `invoice_money` decimal(10,2) DEFAULT '0.00' COMMENT '发票金额',
  `invoice_title` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '发票抬头',
  `invoice_desc` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '发票内容',
  `invoice_rate` decimal(10,4) DEFAULT NULL COMMENT '发票税率',
  `taxpayer` varchar(50) CHARACTER SET utf8 DEFAULT NULL COMMENT '纳税人识别号',
  `status` tinyint(1) DEFAULT '0' COMMENT '发票状态0待开1已开2作废',
  `atime` int(11) DEFAULT '0' COMMENT '创建时间',
  `ctime` int(11) DEFAULT NULL COMMENT '开票时间',
  PRIMARY KEY (`invoice_id`)
) ENGINE=InnoDB AUTO_INCREMENT=187 DEFAULT CHARSET=latin1 COMMENT='发票信息表';

-- ----------------------------
-- Records of tp_invoice
-- ----------------------------

-- ----------------------------
-- Table structure for tp_message
-- ----------------------------
DROP TABLE IF EXISTS `tp_message`;
CREATE TABLE `tp_message` (
  `message_id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '管理者id',
  `message` text NOT NULL COMMENT '站内信内容',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '个体消息：0，全体消息1',
  `category` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT ' 系统消息：0，活动消息：1',
  `send_time` int(10) unsigned NOT NULL COMMENT '发送时间',
  `data` text COMMENT '消息序列化内容',
  PRIMARY KEY (`message_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tp_message
-- ----------------------------

-- ----------------------------
-- Table structure for tp_navigation
-- ----------------------------
DROP TABLE IF EXISTS `tp_navigation`;
CREATE TABLE `tp_navigation` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '前台导航表',
  `name` varchar(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT '' COMMENT '导航名称',
  `is_show` tinyint(1) DEFAULT '1' COMMENT '是否显示',
  `is_new` tinyint(1) DEFAULT '1' COMMENT '是否新窗口',
  `sort` smallint(6) DEFAULT '50' COMMENT '排序',
  `url` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT '' COMMENT '链接地址',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Records of tp_navigation
-- ----------------------------

-- ----------------------------
-- Table structure for tp_oauth_users
-- ----------------------------
DROP TABLE IF EXISTS `tp_oauth_users`;
CREATE TABLE `tp_oauth_users` (
  `tu_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '表自增ID',
  `user_id` mediumint(8) NOT NULL COMMENT '用户表ID',
  `openid` varchar(255) NOT NULL COMMENT '第三方开放平台openid',
  `oauth` varchar(50) NOT NULL COMMENT '第三方授权平台',
  `unionid` varchar(255) DEFAULT NULL COMMENT 'unionid',
  `oauth_child` varchar(50) DEFAULT NULL COMMENT 'mp标识来自公众号, open标识来自开放平台,用于标识来自哪个第三方授权平台, 因为同是微信平台有来自公众号和开放平台',
  PRIMARY KEY (`tu_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tp_oauth_users
-- ----------------------------

-- ----------------------------
-- Table structure for tp_order
-- ----------------------------
DROP TABLE IF EXISTS `tp_order`;
CREATE TABLE `tp_order` (
  `order_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '订单id',
  `order_sn` varchar(20) NOT NULL DEFAULT '' COMMENT '订单编号',
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `order_status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '订单状态(1 确认订单 3取消订单)',
  `shipping_status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '发货状态(1确认发货)',
  `pay_status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '支付状态',
  `consignee` varchar(60) NOT NULL DEFAULT '' COMMENT '收货人',
  `country` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '国家',
  `province` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '省份',
  `city` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '城市',
  `district` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '县区',
  `twon` int(11) DEFAULT '0' COMMENT '乡镇',
  `address` varchar(255) NOT NULL DEFAULT '' COMMENT '地址',
  `zipcode` varchar(60) NOT NULL DEFAULT '' COMMENT '邮政编码',
  `mobile` varchar(60) NOT NULL DEFAULT '' COMMENT '手机',
  `email` varchar(60) NOT NULL DEFAULT '' COMMENT '邮件',
  `shipping_code` varchar(32) NOT NULL DEFAULT '' COMMENT '物流code',
  `shipping_name` varchar(120) NOT NULL DEFAULT '' COMMENT '物流名称',
  `pay_code` varchar(32) NOT NULL DEFAULT '' COMMENT '支付code',
  `pay_name` varchar(120) NOT NULL DEFAULT '' COMMENT '支付方式名称',
  `invoice_title` varchar(256) DEFAULT '' COMMENT '发票抬头',
  `goods_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '商品总价',
  `shipping_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '邮费',
  `user_money` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '使用余额',
  `coupon_price` decimal(10,2) DEFAULT '0.00' COMMENT '优惠券抵扣',
  `integral` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '使用积分',
  `integral_money` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '使用积分抵多少钱',
  `order_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '应付款金额',
  `total_amount` decimal(10,2) DEFAULT '0.00' COMMENT '订单总价',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '下单时间',
  `shipping_time` int(11) DEFAULT '0' COMMENT '最后新发货时间',
  `confirm_time` int(10) DEFAULT '0' COMMENT '收货确认时间',
  `pay_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '支付时间',
  `transaction_id` varchar(255) DEFAULT NULL COMMENT '第三方平台交易流水号',
  `order_prom_type` tinyint(4) DEFAULT '0' COMMENT '0默认1抢购2团购3优惠4预售5虚拟6拼团',
  `order_prom_id` smallint(6) NOT NULL DEFAULT '0' COMMENT '活动id',
  `order_prom_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '活动优惠金额',
  `discount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '价格调整',
  `user_note` varchar(255) NOT NULL DEFAULT '' COMMENT '用户备注',
  `admin_note` varchar(255) DEFAULT '' COMMENT '管理员备注',
  `parent_sn` varchar(100) DEFAULT NULL COMMENT '父单单号',
  `is_distribut` tinyint(1) DEFAULT '0' COMMENT '是否已分成0未分成1已分成',
  `paid_money` decimal(10,2) DEFAULT '0.00' COMMENT '订金',
  `deleted` tinyint(1) NOT NULL DEFAULT '0' COMMENT '用户假删除标识,1:删除,0未删除',
  `brandid` int(10) DEFAULT NULL,
  `username` varchar(200) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `vip_phone` varchar(200) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `vip_card` varchar(200) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`order_id`),
  UNIQUE KEY `order_sn` (`order_sn`),
  KEY `user_id` (`user_id`),
  KEY `add_time` (`add_time`)
) ENGINE=InnoDB AUTO_INCREMENT=2122 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tp_order
-- ----------------------------

-- ----------------------------
-- Table structure for tp_order_action
-- ----------------------------
DROP TABLE IF EXISTS `tp_order_action`;
CREATE TABLE `tp_order_action` (
  `action_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `order_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '订单ID',
  `action_user` int(11) DEFAULT '0' COMMENT '操作人 0 为用户操作，其他为管理员id',
  `order_status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '订单状态',
  `shipping_status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '配送状态',
  `pay_status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '支付状态',
  `action_note` varchar(255) NOT NULL DEFAULT '' COMMENT '操作备注',
  `log_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `status_desc` varchar(255) DEFAULT NULL COMMENT '状态描述',
  `action_username` varchar(200) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3212 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tp_order_action
-- ----------------------------

-- ----------------------------
-- Table structure for tp_order_goods
-- ----------------------------
DROP TABLE IF EXISTS `tp_order_goods`;
CREATE TABLE `tp_order_goods` (
  `rec_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id自增',
  `order_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '订单id',
  `goods_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '商品id',
  `goods_name` varchar(120) NOT NULL DEFAULT '' COMMENT '视频名称',
  `goods_sn` varchar(60) NOT NULL DEFAULT '' COMMENT '商品货号',
  `goods_num` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT '购买数量',
  `market_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '市场价',
  `goods_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '本店价',
  `cost_price` decimal(10,2) DEFAULT '0.00' COMMENT '商品成本价',
  `member_goods_price` decimal(10,2) DEFAULT '0.00' COMMENT '会员折扣价',
  `give_integral` mediumint(8) DEFAULT '0' COMMENT '购买商品赠送积分',
  `spec_key` varchar(128) DEFAULT '' COMMENT '商品规格key',
  `spec_key_name` varchar(128) DEFAULT '' COMMENT '规格对应的中文名字',
  `bar_code` varchar(64) NOT NULL DEFAULT '' COMMENT '条码',
  `is_comment` tinyint(1) DEFAULT '0' COMMENT '是否评价',
  `prom_type` tinyint(1) DEFAULT '0' COMMENT '0 普通订单,1 限时抢购, 2 团购 , 3 促销优惠,4预售',
  `prom_id` int(11) DEFAULT '0' COMMENT '活动id',
  `is_send` tinyint(1) DEFAULT '0' COMMENT '0未发货，1已发货，2已换货，3已退货',
  `delivery_id` int(11) DEFAULT '0' COMMENT '发货单ID',
  `sku` varchar(128) DEFAULT '' COMMENT 'sku',
  PRIMARY KEY (`rec_id`),
  KEY `order_id` (`order_id`),
  KEY `goods_id` (`goods_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2404 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tp_order_goods
-- ----------------------------

-- ----------------------------
-- Table structure for tp_payment
-- ----------------------------
DROP TABLE IF EXISTS `tp_payment`;
CREATE TABLE `tp_payment` (
  `pay_id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `pay_code` varchar(20) NOT NULL DEFAULT '' COMMENT '支付code',
  `pay_name` varchar(120) NOT NULL DEFAULT '' COMMENT '支付方式名称',
  `pay_fee` varchar(10) NOT NULL DEFAULT '' COMMENT '手续费',
  `pay_desc` text NOT NULL COMMENT '描述',
  `pay_order` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'pay_coder',
  `pay_config` text NOT NULL COMMENT '配置',
  `enabled` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '开启',
  `is_cod` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否货到付款',
  `is_online` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否在线支付',
  PRIMARY KEY (`pay_id`),
  UNIQUE KEY `pay_code` (`pay_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tp_payment
-- ----------------------------

-- ----------------------------
-- Table structure for tp_payment_log
-- ----------------------------
DROP TABLE IF EXISTS `tp_payment_log`;
CREATE TABLE `tp_payment_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) DEFAULT NULL,
  `order_id` int(10) DEFAULT NULL,
  `account` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `createtime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of tp_payment_log
-- ----------------------------

-- ----------------------------
-- Table structure for tp_pick_up
-- ----------------------------
DROP TABLE IF EXISTS `tp_pick_up`;
CREATE TABLE `tp_pick_up` (
  `pickup_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自提点id',
  `pickup_name` varchar(255) NOT NULL DEFAULT '' COMMENT '自提点名称',
  `pickup_address` varchar(255) NOT NULL DEFAULT '' COMMENT '自提点地址',
  `pickup_phone` varchar(30) NOT NULL DEFAULT '' COMMENT '自提点电话',
  `pickup_contact` varchar(20) NOT NULL DEFAULT '' COMMENT '自提点联系人',
  `province_id` int(11) NOT NULL COMMENT '省id',
  `city_id` int(11) NOT NULL COMMENT '市id',
  `district_id` int(11) NOT NULL COMMENT '区id',
  `suppliersid` int(11) NOT NULL COMMENT '供应商id',
  PRIMARY KEY (`pickup_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='自提点表';

-- ----------------------------
-- Records of tp_pick_up
-- ----------------------------

-- ----------------------------
-- Table structure for tp_plugin
-- ----------------------------
DROP TABLE IF EXISTS `tp_plugin`;
CREATE TABLE `tp_plugin` (
  `code` varchar(13) DEFAULT NULL COMMENT '插件编码',
  `name` varchar(55) DEFAULT NULL COMMENT '中文名字',
  `version` varchar(255) DEFAULT NULL COMMENT '插件的版本',
  `author` varchar(30) DEFAULT NULL COMMENT '插件作者',
  `config` text COMMENT '配置信息',
  `config_value` text COMMENT '配置值信息',
  `desc` varchar(255) DEFAULT NULL COMMENT '插件描述',
  `status` tinyint(1) DEFAULT '0' COMMENT '是否启用',
  `type` varchar(50) DEFAULT NULL COMMENT '插件类型 payment支付 login 登陆 shipping物流',
  `icon` varchar(255) DEFAULT NULL COMMENT '图标',
  `bank_code` text COMMENT '网银配置信息',
  `scene` tinyint(1) DEFAULT '0' COMMENT '使用场景 0PC+手机 1手机 2PC 3APP 4小程序'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tp_plugin
-- ----------------------------
INSERT INTO `tp_plugin` VALUES ('alipay', 'PC端支付宝', '1.0', 'jy_pwn', 'a:6:{i:0;a:4:{s:4:\"name\";s:14:\"alipay_account\";s:5:\"label\";s:15:\"支付宝帐户\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:1;a:4:{s:4:\"name\";s:10:\"alipay_key\";s:5:\"label\";s:21:\"交易安全校验码\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:2;a:4:{s:4:\"name\";s:14:\"alipay_partner\";s:5:\"label\";s:17:\"合作者身份ID\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:3;a:4:{s:4:\"name\";s:18:\"alipay_private_key\";s:5:\"label\";s:6:\"秘钥\";s:4:\"type\";s:8:\"textarea\";s:5:\"value\";s:0:\"\";}i:4;a:4:{s:4:\"name\";s:17:\"alipay_pay_method\";s:5:\"label\";s:19:\" 选择接口类型\";s:4:\"type\";s:6:\"select\";s:6:\"option\";a:2:{i:0;s:24:\"使用担保交易接口\";i:1;s:30:\"使用即时到帐交易接口\";}}i:5;a:4:{s:4:\"name\";s:7:\"is_bank\";s:5:\"label\";s:18:\"是否开通网银\";s:4:\"type\";s:6:\"select\";s:6:\"option\";a:2:{i:0;s:3:\"否\";i:1;s:3:\"是\";}}}', '', 'PC端支付宝插件 ', '1', 'payment', 'logo.jpg', 'a:8:{s:12:\"招商银行\";s:9:\"CMB-DEBIT\";s:18:\"中国工商银行\";s:10:\"ICBC-DEBIT\";s:12:\"交通银行\";s:10:\"COMM-DEBIT\";s:18:\"中国建设银行\";s:9:\"CCB-DEBIT\";s:18:\"中国民生银行\";s:4:\"CMBC\";s:12:\"中国银行\";s:9:\"BOC-DEBIT\";s:18:\"中国农业银行\";s:3:\"ABC\";s:12:\"上海银行\";s:6:\"SHBANK\";}', '2');
INSERT INTO `tp_plugin` VALUES ('weixin', '微信支付', '1.0', 'IT宇宙人', 'a:4:{i:0;a:4:{s:4:\"name\";s:5:\"appid\";s:5:\"label\";s:20:\"绑定支付的APPID\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:1;a:4:{s:4:\"name\";s:5:\"mchid\";s:5:\"label\";s:9:\"商户号\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:2;a:4:{s:4:\"name\";s:3:\"key\";s:5:\"label\";s:18:\"商户支付密钥\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:3;a:4:{s:4:\"name\";s:9:\"appsecret\";s:5:\"label\";s:57:\"公众帐号secert（仅JSAPI支付的时候需要配置)\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}}', 'a:4:{s:5:\"appid\";s:18:\"wxe1d66f5605ddc128\";s:5:\"mchid\";s:10:\"1496880872\";s:3:\"key\";s:32:\"42061227c9a93afe788fdb7c00f1b8d3\";s:9:\"appsecret\";s:32:\"ad1315cc82c05aea4ebdc63e20104cf0\";}', '微信支付插件 ', '1', 'payment', 'logo.jpg', 'N;', '0');
INSERT INTO `tp_plugin` VALUES ('alipay', '支付宝快捷登陆', '1.0', '彭老师', 'a:2:{i:0;a:4:{s:4:\"name\";s:14:\"alipay_partner\";s:5:\"label\";s:17:\"合作者身份ID\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:1;a:4:{s:4:\"name\";s:10:\"alipay_key\";s:5:\"label\";s:15:\"安全检验码\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}}', 'a:2:{s:14:\"alipay_partner\";s:0:\"\";s:10:\"alipay_key\";s:0:\"\";}', '支付宝快捷登陆插件 ', '1', 'login', 'logo.jpg', 'N;', '0');
INSERT INTO `tp_plugin` VALUES ('weixin', '微信登录', '1.0', '彭老师', 'a:2:{i:0;a:4:{s:4:\"name\";s:5:\"appid\";s:5:\"label\";s:17:\"开放平台appid\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:1;a:4:{s:4:\"name\";s:6:\"secret\";s:5:\"label\";s:18:\"开放平台secret\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}}', null, '微信扫码登录插件 ', '1', 'login', 'logo.jpg', 'N;', null);
INSERT INTO `tp_plugin` VALUES ('shentong', '申通物流', '1.0', '宇宙人', 'N;', null, '申通物流插件 ', '1', 'shipping', 'logo.jpg', 'N;', null);
INSERT INTO `tp_plugin` VALUES ('shunfeng', '顺丰物流', '1.0', 'shunfeng', 'a:5:{s:10:\"background\";s:70:\"/public/upload/plugins/2017/04-10/3dd0b06777c48add1fbfe1ea2cfcbf9b.jpg\";s:5:\"width\";s:3:\"840\";s:6:\"height\";s:3:\"480\";s:8:\"offset_x\";s:1:\"0\";s:8:\"offset_y\";s:1:\"0\";}', '\r\n                            \r\n                                                    <div style=\"z-index: 4; top: 100px; left: 122px;\" class=\"item\"><pre>发货点-名称</pre><div class=\"resize\"></div></div>                        <div style=\"z-index: 5; top: 255px; left: 228px;\" class=\"item\"><pre>发货点-电话</pre><div class=\"resize\"></div></div>', '顺丰物流插件 ', '1', 'shipping', 'logo.jpg', 'N;', null);
INSERT INTO `tp_plugin` VALUES ('qq', 'QQ登陆', '1.0', '彭老师', 'a:2:{i:0;a:4:{s:4:\"name\";s:6:\"app_id\";s:5:\"label\";s:6:\"app_id\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:1;a:4:{s:4:\"name\";s:10:\"app_secret\";s:5:\"label\";s:10:\"app_secret\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}}', 'a:2:{s:6:\"app_id\";s:0:\"\";s:10:\"app_secret\";s:0:\"\";}', 'QQ登陆插件 ', '1', 'login', 'logo.jpg', 'N;', '0');
INSERT INTO `tp_plugin` VALUES ('alipayMobile', '手机网站支付宝', '1.0', '宇宙人', 'a:6:{i:0;a:4:{s:4:\"name\";s:14:\"alipay_account\";s:5:\"label\";s:15:\"支付宝帐户\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:1;a:4:{s:4:\"name\";s:10:\"alipay_key\";s:5:\"label\";s:21:\"交易安全校验码\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:2;a:4:{s:4:\"name\";s:14:\"alipay_partner\";s:5:\"label\";s:17:\"合作者身份ID\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:3;a:4:{s:4:\"name\";s:18:\"alipay_private_key\";s:5:\"label\";s:6:\"秘钥\";s:4:\"type\";s:8:\"textarea\";s:5:\"value\";s:0:\"\";}i:4;a:4:{s:4:\"name\";s:17:\"alipay_pay_method\";s:5:\"label\";s:19:\" 选择接口类型\";s:4:\"type\";s:6:\"select\";s:6:\"option\";a:2:{i:0;s:24:\"使用担保交易接口\";i:1;s:30:\"使用即时到帐交易接口\";}}i:5;a:4:{s:4:\"name\";s:7:\"is_bank\";s:5:\"label\";s:18:\"是否开通网银\";s:4:\"type\";s:6:\"select\";s:6:\"option\";a:2:{i:0;s:3:\"否\";i:1;s:3:\"是\";}}}', 'a:6:{s:14:\"alipay_account\";s:0:\"\";s:10:\"alipay_key\";s:0:\"\";s:14:\"alipay_partner\";s:0:\"\";s:18:\"alipay_private_key\";s:0:\"\";s:17:\"alipay_pay_method\";s:1:\"2\";s:7:\"is_bank\";s:1:\"2\";}', '手机端网站支付宝 ', '1', 'payment', 'logo.jpg', 'N;', '1');
INSERT INTO `tp_plugin` VALUES ('unionpay', '银联在线支付', '1.0', '奇闻科技', 'a:4:{i:0;a:4:{s:4:\"name\";s:12:\"unionpay_mid\";s:5:\"label\";s:9:\"商户号\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:15:\"777290058130619\";}i:1;a:4:{s:4:\"name\";s:21:\"unionpay_cer_password\";s:5:\"label\";s:25:\" 商户私钥证书密码\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:6:\"000000\";}i:2;a:4:{s:4:\"name\";s:13:\"unionpay_user\";s:5:\"label\";s:19:\" 企业网银账号\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:12:\"123456789001\";}i:3;a:4:{s:4:\"name\";s:17:\"unionpay_password\";s:5:\"label\";s:19:\" 企业网银密码\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:6:\"789001\";}}', 'a:4:{s:12:\"unionpay_mid\";s:15:\"777290058130619\";s:21:\"unionpay_cer_password\";s:6:\"000000\";s:13:\"unionpay_user\";s:12:\"123456789001\";s:17:\"unionpay_password\";s:6:\"789001\";}', '银联在线支付插件 ', '1', 'payment', 'logo.jpg', 'N;', '0');
INSERT INTO `tp_plugin` VALUES ('helloworld', 'HelloWorld插件', 'v1.2.0,v1.2.1', 'IT宇宙人', 'N;', null, '适合v1.2.0 , v1.2.1', '0', 'function', 'logo.jpg', 'N;', null);
INSERT INTO `tp_plugin` VALUES ('tenpay', 'PC端财付通', '1.0', 'IT宇宙人', 'a:2:{i:0;a:4:{s:4:\"name\";s:7:\"partner\";s:5:\"label\";s:7:\"partner\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:1;a:4:{s:4:\"name\";s:3:\"key\";s:5:\"label\";s:3:\"key\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}}', 'a:2:{s:7:\"partner\";s:0:\"\";s:3:\"key\";s:0:\"\";}', 'PC端财付通插件 ', '1', 'payment', 'logo.jpg', 'N;', '2');
INSERT INTO `tp_plugin` VALUES ('appWeixinPay', 'App微信支付', '1.0', 'wangqh', 'a:3:{i:0;a:5:{s:4:\"name\";s:5:\"appid\";s:5:\"label\";s:20:\"绑定支付的APPID\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";s:4:\"hint\";s:0:\"\";}i:1;a:4:{s:4:\"name\";s:5:\"mchid\";s:5:\"label\";s:9:\"商户号\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:2;a:4:{s:4:\"name\";s:3:\"key\";s:5:\"label\";s:18:\"商户支付密钥\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}}', '', '微信开放平台支付信息', '1', 'payment', 'logo.jpg', 'N;', '3');
INSERT INTO `tp_plugin` VALUES ('miniAppPay', '微信小程序支付', '1.0', 'lhb', 'a:4:{i:0;a:5:{s:4:\"name\";s:5:\"appid\";s:5:\"label\";s:20:\"绑定支付的APPID\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";s:4:\"hint\";s:0:\"\";}i:1;a:4:{s:4:\"name\";s:5:\"mchid\";s:5:\"label\";s:9:\"商户号\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:2;a:4:{s:4:\"name\";s:3:\"key\";s:5:\"label\";s:18:\"商户支付密钥\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:3;a:4:{s:4:\"name\";s:9:\"appsecret\";s:5:\"label\";s:15:\"小程序secret\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}}', '', '微信小程序支付信息', '1', 'payment', 'logo.jpg', 'N;', '4');
INSERT INTO `tp_plugin` VALUES ('zhongtong', '中通快递', '1.0', '管理员', '', null, ' ', '1', 'shipping', 'logo.jpg', 'N;', null);
INSERT INTO `tp_plugin` VALUES ('cod', '到货付款', '1.0', 'IT宇宙人', 'a:1:{i:0;a:4:{s:4:\"name\";s:9:\"code_desc\";s:5:\"label\";s:12:\"配送描述\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}}', null, '货到付款插件 ', '0', 'payment', 'logo.jpg', 'N;', '0');

-- ----------------------------
-- Table structure for tp_prom_goods
-- ----------------------------
DROP TABLE IF EXISTS `tp_prom_goods`;
CREATE TABLE `tp_prom_goods` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '活动ID',
  `title` varchar(60) NOT NULL DEFAULT '' COMMENT '促销活动名称',
  `type` int(2) NOT NULL DEFAULT '0' COMMENT '促销类型',
  `expression` varchar(100) NOT NULL DEFAULT '' COMMENT '优惠体现',
  `description` text COMMENT '活动描述',
  `start_time` int(11) NOT NULL COMMENT '活动开始时间',
  `end_time` int(11) NOT NULL COMMENT '活动结束时间',
  `is_end` tinyint(1) DEFAULT '0' COMMENT '是否已结束',
  `group` varchar(255) DEFAULT NULL COMMENT '适用范围',
  `prom_img` varchar(150) DEFAULT NULL COMMENT '活动宣传图片',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tp_prom_goods
-- ----------------------------

-- ----------------------------
-- Table structure for tp_prom_order
-- ----------------------------
DROP TABLE IF EXISTS `tp_prom_order`;
CREATE TABLE `tp_prom_order` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL DEFAULT '' COMMENT '活动名称',
  `type` int(2) NOT NULL DEFAULT '0' COMMENT '活动类型',
  `money` float(10,2) DEFAULT '0.00' COMMENT '最小金额',
  `expression` varchar(100) DEFAULT NULL COMMENT '优惠体现',
  `description` text COMMENT '活动描述',
  `start_time` int(11) DEFAULT NULL COMMENT '活动开始时间',
  `end_time` int(11) DEFAULT NULL COMMENT '活动结束时间',
  `is_close` tinyint(1) DEFAULT '0',
  `group` varchar(255) DEFAULT NULL COMMENT '适用范围',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tp_prom_order
-- ----------------------------

-- ----------------------------
-- Table structure for tp_rebate_log
-- ----------------------------
DROP TABLE IF EXISTS `tp_rebate_log`;
CREATE TABLE `tp_rebate_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '分成记录表',
  `user_id` int(11) DEFAULT '0' COMMENT '获佣用户',
  `buy_user_id` int(11) DEFAULT '0' COMMENT '购买人id',
  `nickname` varchar(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT '' COMMENT '购买人名称',
  `order_sn` varchar(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT '' COMMENT '订单编号',
  `order_id` int(11) DEFAULT '0' COMMENT '订单id',
  `goods_price` decimal(10,2) DEFAULT '0.00' COMMENT '订单商品总额',
  `money` decimal(10,2) DEFAULT '0.00' COMMENT '获佣金额',
  `level` tinyint(1) DEFAULT '1' COMMENT '获佣用户级别',
  `create_time` int(11) DEFAULT '0' COMMENT '分成记录生成时间',
  `confirm` int(11) DEFAULT '0' COMMENT '确定收货时间',
  `status` tinyint(1) DEFAULT '0' COMMENT '0未付款,1已付款, 2等待分成(已收货) 3已分成, 4已取消',
  `confirm_time` int(11) DEFAULT '0' COMMENT '确定分成或者取消时间',
  `remark` varchar(1024) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT '' COMMENT '如果是取消, 有取消备注',
  PRIMARY KEY (`id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1312 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tp_rebate_log
-- ----------------------------

-- ----------------------------
-- Table structure for tp_recharge
-- ----------------------------
DROP TABLE IF EXISTS `tp_recharge`;
CREATE TABLE `tp_recharge` (
  `order_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '会员ID',
  `nickname` varchar(50) DEFAULT NULL COMMENT '会员昵称',
  `order_sn` varchar(30) NOT NULL DEFAULT '' COMMENT '充值单号',
  `account` float(10,2) DEFAULT '0.00' COMMENT '充值金额',
  `ctime` int(11) DEFAULT NULL COMMENT '充值时间',
  `pay_time` int(11) DEFAULT NULL COMMENT '支付时间',
  `pay_code` varchar(20) DEFAULT NULL,
  `pay_name` varchar(80) DEFAULT NULL COMMENT '支付方式',
  `pay_status` tinyint(1) DEFAULT '0' COMMENT '充值状态0:待支付 1:充值成功 2:交易关闭',
  PRIMARY KEY (`order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=127 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of tp_recharge
-- ----------------------------

-- ----------------------------
-- Table structure for tp_region
-- ----------------------------
DROP TABLE IF EXISTS `tp_region`;
CREATE TABLE `tp_region` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `name` varchar(32) CHARACTER SET utf8 DEFAULT NULL COMMENT '地区名称',
  `level` tinyint(4) DEFAULT '0' COMMENT '地区等级 分省市县区',
  `parent_id` int(10) DEFAULT NULL COMMENT '父id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=47498 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of tp_region
-- ----------------------------
INSERT INTO `tp_region` VALUES ('1', '北京市', '1', '0');
INSERT INTO `tp_region` VALUES ('2', '市辖区', '2', '1');
INSERT INTO `tp_region` VALUES ('3', '东城区', '3', '2');
INSERT INTO `tp_region` VALUES ('4', '东华门街道', '4', '3');
INSERT INTO `tp_region` VALUES ('5', '景山街道', '4', '3');
INSERT INTO `tp_region` VALUES ('6', '交道口街道', '4', '3');
INSERT INTO `tp_region` VALUES ('7', '安定门街道', '4', '3');
INSERT INTO `tp_region` VALUES ('8', '北新桥街道', '4', '3');
INSERT INTO `tp_region` VALUES ('9', '东四街道', '4', '3');
INSERT INTO `tp_region` VALUES ('10', '朝阳门街道', '4', '3');
INSERT INTO `tp_region` VALUES ('11', '建国门街道', '4', '3');
INSERT INTO `tp_region` VALUES ('12', '东直门街道', '4', '3');
INSERT INTO `tp_region` VALUES ('13', '和平里街道', '4', '3');
INSERT INTO `tp_region` VALUES ('14', '西城区', '3', '2');
INSERT INTO `tp_region` VALUES ('15', '西长安街街道', '4', '14');
INSERT INTO `tp_region` VALUES ('16', '新街口街道', '4', '14');
INSERT INTO `tp_region` VALUES ('17', '月坛街道', '4', '14');
INSERT INTO `tp_region` VALUES ('18', '展览路街道', '4', '14');
INSERT INTO `tp_region` VALUES ('19', '德胜街道', '4', '14');
INSERT INTO `tp_region` VALUES ('20', '金融街街道', '4', '14');
INSERT INTO `tp_region` VALUES ('21', '什刹海街道', '4', '14');
INSERT INTO `tp_region` VALUES ('22', '崇文区', '3', '2');
INSERT INTO `tp_region` VALUES ('23', '前门街道', '4', '22');
INSERT INTO `tp_region` VALUES ('24', '崇文门外街道', '4', '22');
INSERT INTO `tp_region` VALUES ('25', '东花市街道', '4', '22');
INSERT INTO `tp_region` VALUES ('26', '龙潭街道', '4', '22');
INSERT INTO `tp_region` VALUES ('27', '体育馆路街道', '4', '22');
INSERT INTO `tp_region` VALUES ('28', '天坛街道', '4', '22');
INSERT INTO `tp_region` VALUES ('29', '永定门外街道', '4', '22');
INSERT INTO `tp_region` VALUES ('30', '宣武区', '3', '2');
INSERT INTO `tp_region` VALUES ('31', '大栅栏街道', '4', '30');
INSERT INTO `tp_region` VALUES ('32', '天桥街道', '4', '30');
INSERT INTO `tp_region` VALUES ('33', '椿树街道', '4', '30');
INSERT INTO `tp_region` VALUES ('34', '陶然亭街道', '4', '30');
INSERT INTO `tp_region` VALUES ('35', '广安门内街道', '4', '30');
INSERT INTO `tp_region` VALUES ('36', '牛街街道', '4', '30');
INSERT INTO `tp_region` VALUES ('37', '白纸坊街道', '4', '30');
INSERT INTO `tp_region` VALUES ('38', '广安门外街道', '4', '30');
INSERT INTO `tp_region` VALUES ('39', '朝阳区', '3', '2');
INSERT INTO `tp_region` VALUES ('40', '建外街道', '4', '39');
INSERT INTO `tp_region` VALUES ('41', '朝外街道', '4', '39');
INSERT INTO `tp_region` VALUES ('42', '呼家楼街道', '4', '39');
INSERT INTO `tp_region` VALUES ('43', '三里屯街道', '4', '39');
INSERT INTO `tp_region` VALUES ('44', '左家庄街道', '4', '39');
INSERT INTO `tp_region` VALUES ('45', '香河园街道', '4', '39');
INSERT INTO `tp_region` VALUES ('46', '和平街街道', '4', '39');
INSERT INTO `tp_region` VALUES ('47', '安贞街道', '4', '39');
INSERT INTO `tp_region` VALUES ('48', '亚运村街道', '4', '39');
INSERT INTO `tp_region` VALUES ('49', '小关街道', '4', '39');
INSERT INTO `tp_region` VALUES ('50', '酒仙桥街道', '4', '39');
INSERT INTO `tp_region` VALUES ('51', '麦子店街道', '4', '39');
INSERT INTO `tp_region` VALUES ('52', '团结湖街道', '4', '39');
INSERT INTO `tp_region` VALUES ('53', '六里屯街道', '4', '39');
INSERT INTO `tp_region` VALUES ('54', '八里庄街道', '4', '39');
INSERT INTO `tp_region` VALUES ('55', '双井街道', '4', '39');
INSERT INTO `tp_region` VALUES ('56', '劲松街道', '4', '39');
INSERT INTO `tp_region` VALUES ('57', '潘家园街道', '4', '39');
INSERT INTO `tp_region` VALUES ('58', '垡头街道', '4', '39');
INSERT INTO `tp_region` VALUES ('59', '南磨房地区', '4', '39');
INSERT INTO `tp_region` VALUES ('60', '高碑店地区', '4', '39');
INSERT INTO `tp_region` VALUES ('61', '将台地区', '4', '39');
INSERT INTO `tp_region` VALUES ('62', '太阳宫地区', '4', '39');
INSERT INTO `tp_region` VALUES ('63', '大屯街道', '4', '39');
INSERT INTO `tp_region` VALUES ('64', '望京街道', '4', '39');
INSERT INTO `tp_region` VALUES ('65', '小红门地区', '4', '39');
INSERT INTO `tp_region` VALUES ('66', '十八里店地区', '4', '39');
INSERT INTO `tp_region` VALUES ('67', '平房地区', '4', '39');
INSERT INTO `tp_region` VALUES ('68', '东风地区', '4', '39');
INSERT INTO `tp_region` VALUES ('69', '奥运村地区', '4', '39');
INSERT INTO `tp_region` VALUES ('70', '来广营地区', '4', '39');
INSERT INTO `tp_region` VALUES ('71', '常营回族地区', '4', '39');
INSERT INTO `tp_region` VALUES ('72', '三间房地区', '4', '39');
INSERT INTO `tp_region` VALUES ('73', '管庄地区', '4', '39');
INSERT INTO `tp_region` VALUES ('74', '金盏地区', '4', '39');
INSERT INTO `tp_region` VALUES ('75', '孙河地区', '4', '39');
INSERT INTO `tp_region` VALUES ('76', '崔各庄地区', '4', '39');
INSERT INTO `tp_region` VALUES ('77', '东坝地区', '4', '39');
INSERT INTO `tp_region` VALUES ('78', '黑庄户地区', '4', '39');
INSERT INTO `tp_region` VALUES ('79', '豆各庄地区', '4', '39');
INSERT INTO `tp_region` VALUES ('80', '王四营地区', '4', '39');
INSERT INTO `tp_region` VALUES ('81', '首都机场街道', '4', '39');
INSERT INTO `tp_region` VALUES ('82', '望京开发街道', '4', '39');
INSERT INTO `tp_region` VALUES ('83', '丰台区', '3', '2');
INSERT INTO `tp_region` VALUES ('84', '右安门街道', '4', '83');
INSERT INTO `tp_region` VALUES ('85', '太平桥街道', '4', '83');
INSERT INTO `tp_region` VALUES ('86', '西罗园街道', '4', '83');
INSERT INTO `tp_region` VALUES ('87', '大红门街道', '4', '83');
INSERT INTO `tp_region` VALUES ('88', '南苑街道', '4', '83');
INSERT INTO `tp_region` VALUES ('89', '东高地街道', '4', '83');
INSERT INTO `tp_region` VALUES ('90', '东铁匠营街道', '4', '83');
INSERT INTO `tp_region` VALUES ('91', '卢沟桥街道', '4', '83');
INSERT INTO `tp_region` VALUES ('92', '丰台街道', '4', '83');
INSERT INTO `tp_region` VALUES ('93', '新村街道', '4', '83');
INSERT INTO `tp_region` VALUES ('94', '长辛店街道', '4', '83');
INSERT INTO `tp_region` VALUES ('95', '云岗街道', '4', '83');
INSERT INTO `tp_region` VALUES ('96', '方庄地区', '4', '83');
INSERT INTO `tp_region` VALUES ('97', '宛平城地区', '4', '83');
INSERT INTO `tp_region` VALUES ('98', '马家堡街道', '4', '83');
INSERT INTO `tp_region` VALUES ('99', '和义街道', '4', '83');
INSERT INTO `tp_region` VALUES ('100', '长辛店镇', '4', '83');
INSERT INTO `tp_region` VALUES ('101', '王佐镇', '4', '83');
INSERT INTO `tp_region` VALUES ('102', '卢沟桥乡', '4', '83');
INSERT INTO `tp_region` VALUES ('103', '花乡', '4', '83');
INSERT INTO `tp_region` VALUES ('104', '南苑乡', '4', '83');
INSERT INTO `tp_region` VALUES ('105', '石景山区', '3', '2');
INSERT INTO `tp_region` VALUES ('106', '八宝山街道', '4', '105');
INSERT INTO `tp_region` VALUES ('107', '老山街道', '4', '105');
INSERT INTO `tp_region` VALUES ('108', '八角街道', '4', '105');
INSERT INTO `tp_region` VALUES ('109', '古城街道', '4', '105');
INSERT INTO `tp_region` VALUES ('110', '苹果园街道', '4', '105');
INSERT INTO `tp_region` VALUES ('111', '金顶街街道', '4', '105');
INSERT INTO `tp_region` VALUES ('112', '广宁街道', '4', '105');
INSERT INTO `tp_region` VALUES ('113', '五里坨街道', '4', '105');
INSERT INTO `tp_region` VALUES ('114', '鲁谷社区行政事务管理中心', '4', '105');
INSERT INTO `tp_region` VALUES ('115', '海淀区', '3', '2');
INSERT INTO `tp_region` VALUES ('116', '万寿路街道', '4', '115');
INSERT INTO `tp_region` VALUES ('117', '永定路街道', '4', '115');
INSERT INTO `tp_region` VALUES ('118', '羊坊店街道', '4', '115');
INSERT INTO `tp_region` VALUES ('119', '甘家口街道', '4', '115');
INSERT INTO `tp_region` VALUES ('120', '八里庄街道', '4', '115');
INSERT INTO `tp_region` VALUES ('121', '紫竹院街道', '4', '115');
INSERT INTO `tp_region` VALUES ('122', '北下关街道', '4', '115');
INSERT INTO `tp_region` VALUES ('123', '北太平庄街道', '4', '115');
INSERT INTO `tp_region` VALUES ('124', '学院路街道', '4', '115');
INSERT INTO `tp_region` VALUES ('125', '中关村街道', '4', '115');
INSERT INTO `tp_region` VALUES ('126', '海淀街道', '4', '115');
INSERT INTO `tp_region` VALUES ('127', '青龙桥街道', '4', '115');
INSERT INTO `tp_region` VALUES ('128', '清华园街道', '4', '115');
INSERT INTO `tp_region` VALUES ('129', '燕园街道', '4', '115');
INSERT INTO `tp_region` VALUES ('130', '香山街道', '4', '115');
INSERT INTO `tp_region` VALUES ('131', '清河街道', '4', '115');
INSERT INTO `tp_region` VALUES ('132', '花园路街道', '4', '115');
INSERT INTO `tp_region` VALUES ('133', '西三旗街道', '4', '115');
INSERT INTO `tp_region` VALUES ('134', '马连洼街道', '4', '115');
INSERT INTO `tp_region` VALUES ('135', '田村路街道', '4', '115');
INSERT INTO `tp_region` VALUES ('136', '上地街道', '4', '115');
INSERT INTO `tp_region` VALUES ('137', '万柳地区', '4', '115');
INSERT INTO `tp_region` VALUES ('138', '东升地区', '4', '115');
INSERT INTO `tp_region` VALUES ('139', '曙光街道', '4', '115');
INSERT INTO `tp_region` VALUES ('140', '温泉镇', '4', '115');
INSERT INTO `tp_region` VALUES ('141', '四季青镇', '4', '115');
INSERT INTO `tp_region` VALUES ('142', '西北旺镇', '4', '115');
INSERT INTO `tp_region` VALUES ('143', '苏家坨镇', '4', '115');
INSERT INTO `tp_region` VALUES ('144', '上庄镇', '4', '115');
INSERT INTO `tp_region` VALUES ('145', '门头沟区', '3', '2');
INSERT INTO `tp_region` VALUES ('146', '大峪街道', '4', '145');
INSERT INTO `tp_region` VALUES ('147', '城子街道', '4', '145');
INSERT INTO `tp_region` VALUES ('148', '东辛房街道', '4', '145');
INSERT INTO `tp_region` VALUES ('149', '大台街道', '4', '145');
INSERT INTO `tp_region` VALUES ('150', '王平地区', '4', '145');
INSERT INTO `tp_region` VALUES ('151', '潭柘寺镇', '4', '145');
INSERT INTO `tp_region` VALUES ('152', '永定镇', '4', '145');
INSERT INTO `tp_region` VALUES ('153', '龙泉镇', '4', '145');
INSERT INTO `tp_region` VALUES ('154', '军庄镇', '4', '145');
INSERT INTO `tp_region` VALUES ('155', '雁翅镇', '4', '145');
INSERT INTO `tp_region` VALUES ('156', '斋堂镇', '4', '145');
INSERT INTO `tp_region` VALUES ('157', '清水镇', '4', '145');
INSERT INTO `tp_region` VALUES ('158', '妙峰山镇', '4', '145');
INSERT INTO `tp_region` VALUES ('159', '房山区', '3', '2');
INSERT INTO `tp_region` VALUES ('160', '城关街道', '4', '159');
INSERT INTO `tp_region` VALUES ('161', '新镇街道', '4', '159');
INSERT INTO `tp_region` VALUES ('162', '向阳街道', '4', '159');
INSERT INTO `tp_region` VALUES ('163', '东风街道', '4', '159');
INSERT INTO `tp_region` VALUES ('164', '迎风街道', '4', '159');
INSERT INTO `tp_region` VALUES ('165', '星城街道', '4', '159');
INSERT INTO `tp_region` VALUES ('166', '良乡地区', '4', '159');
INSERT INTO `tp_region` VALUES ('167', '周口店地区', '4', '159');
INSERT INTO `tp_region` VALUES ('168', '琉璃河地区', '4', '159');
INSERT INTO `tp_region` VALUES ('169', '拱辰街道', '4', '159');
INSERT INTO `tp_region` VALUES ('170', '西潞街道', '4', '159');
INSERT INTO `tp_region` VALUES ('171', '阎村镇', '4', '159');
INSERT INTO `tp_region` VALUES ('172', '窦店镇', '4', '159');
INSERT INTO `tp_region` VALUES ('173', '石楼镇', '4', '159');
INSERT INTO `tp_region` VALUES ('174', '长阳镇', '4', '159');
INSERT INTO `tp_region` VALUES ('175', '河北镇', '4', '159');
INSERT INTO `tp_region` VALUES ('176', '长沟镇', '4', '159');
INSERT INTO `tp_region` VALUES ('177', '大石窝镇', '4', '159');
INSERT INTO `tp_region` VALUES ('178', '张坊镇', '4', '159');
INSERT INTO `tp_region` VALUES ('179', '十渡镇', '4', '159');
INSERT INTO `tp_region` VALUES ('180', '青龙湖镇', '4', '159');
INSERT INTO `tp_region` VALUES ('181', '韩村河镇', '4', '159');
INSERT INTO `tp_region` VALUES ('182', '霞云岭乡', '4', '159');
INSERT INTO `tp_region` VALUES ('183', '南窖乡', '4', '159');
INSERT INTO `tp_region` VALUES ('184', '佛子庄乡', '4', '159');
INSERT INTO `tp_region` VALUES ('185', '大安山乡', '4', '159');
INSERT INTO `tp_region` VALUES ('186', '史家营乡', '4', '159');
INSERT INTO `tp_region` VALUES ('187', '蒲洼乡', '4', '159');
INSERT INTO `tp_region` VALUES ('188', '通州区', '3', '2');
INSERT INTO `tp_region` VALUES ('189', '中仓街道', '4', '188');
INSERT INTO `tp_region` VALUES ('190', '新华街道', '4', '188');
INSERT INTO `tp_region` VALUES ('191', '北苑街道', '4', '188');
INSERT INTO `tp_region` VALUES ('192', '玉桥街道', '4', '188');
INSERT INTO `tp_region` VALUES ('193', '永顺地区', '4', '188');
INSERT INTO `tp_region` VALUES ('194', '梨园地区', '4', '188');
INSERT INTO `tp_region` VALUES ('195', '宋庄镇', '4', '188');
INSERT INTO `tp_region` VALUES ('196', '张家湾镇', '4', '188');
INSERT INTO `tp_region` VALUES ('197', '漷县镇', '4', '188');
INSERT INTO `tp_region` VALUES ('198', '马驹桥镇', '4', '188');
INSERT INTO `tp_region` VALUES ('199', '西集镇', '4', '188');
INSERT INTO `tp_region` VALUES ('200', '台湖镇', '4', '188');
INSERT INTO `tp_region` VALUES ('201', '永乐店镇', '4', '188');
INSERT INTO `tp_region` VALUES ('202', '潞城镇', '4', '188');
INSERT INTO `tp_region` VALUES ('203', '于家务回族乡', '4', '188');
INSERT INTO `tp_region` VALUES ('204', '顺义区', '3', '2');
INSERT INTO `tp_region` VALUES ('205', '胜利街道', '4', '204');
INSERT INTO `tp_region` VALUES ('206', '光明街道', '4', '204');
INSERT INTO `tp_region` VALUES ('207', '仁和地区', '4', '204');
INSERT INTO `tp_region` VALUES ('208', '后沙峪地区', '4', '204');
INSERT INTO `tp_region` VALUES ('209', '天竺地区', '4', '204');
INSERT INTO `tp_region` VALUES ('210', '杨镇地区', '4', '204');
INSERT INTO `tp_region` VALUES ('211', '牛栏山地区', '4', '204');
INSERT INTO `tp_region` VALUES ('212', '南法信地区', '4', '204');
INSERT INTO `tp_region` VALUES ('213', '马坡地区', '4', '204');
INSERT INTO `tp_region` VALUES ('214', '石园街道', '4', '204');
INSERT INTO `tp_region` VALUES ('215', '高丽营镇', '4', '204');
INSERT INTO `tp_region` VALUES ('216', '李桥镇', '4', '204');
INSERT INTO `tp_region` VALUES ('217', '李遂镇', '4', '204');
INSERT INTO `tp_region` VALUES ('218', '南彩镇', '4', '204');
INSERT INTO `tp_region` VALUES ('219', '北务镇', '4', '204');
INSERT INTO `tp_region` VALUES ('220', '大孙各庄镇', '4', '204');
INSERT INTO `tp_region` VALUES ('221', '张镇', '4', '204');
INSERT INTO `tp_region` VALUES ('222', '龙湾屯镇', '4', '204');
INSERT INTO `tp_region` VALUES ('223', '木林镇', '4', '204');
INSERT INTO `tp_region` VALUES ('224', '北小营镇', '4', '204');
INSERT INTO `tp_region` VALUES ('225', '北石槽镇', '4', '204');
INSERT INTO `tp_region` VALUES ('226', '赵全营镇', '4', '204');
INSERT INTO `tp_region` VALUES ('227', '昌平区', '3', '2');
INSERT INTO `tp_region` VALUES ('228', '城北街道', '4', '227');
INSERT INTO `tp_region` VALUES ('229', '南口地区', '4', '227');
INSERT INTO `tp_region` VALUES ('230', '马池口地区', '4', '227');
INSERT INTO `tp_region` VALUES ('231', '沙河地区', '4', '227');
INSERT INTO `tp_region` VALUES ('232', '城南街道', '4', '227');
INSERT INTO `tp_region` VALUES ('233', '回龙观地区', '4', '227');
INSERT INTO `tp_region` VALUES ('234', '东小口地区', '4', '227');
INSERT INTO `tp_region` VALUES ('235', '阳坊镇', '4', '227');
INSERT INTO `tp_region` VALUES ('236', '小汤山镇', '4', '227');
INSERT INTO `tp_region` VALUES ('237', '南邵镇', '4', '227');
INSERT INTO `tp_region` VALUES ('238', '崔村镇', '4', '227');
INSERT INTO `tp_region` VALUES ('239', '百善镇', '4', '227');
INSERT INTO `tp_region` VALUES ('240', '北七家镇', '4', '227');
INSERT INTO `tp_region` VALUES ('241', '兴寿镇', '4', '227');
INSERT INTO `tp_region` VALUES ('242', '长陵镇', '4', '227');
INSERT INTO `tp_region` VALUES ('243', '流村镇', '4', '227');
INSERT INTO `tp_region` VALUES ('244', '十三陵镇', '4', '227');
INSERT INTO `tp_region` VALUES ('245', '大兴区', '3', '2');
INSERT INTO `tp_region` VALUES ('246', '兴丰街道', '4', '245');
INSERT INTO `tp_region` VALUES ('247', '林校路街道', '4', '245');
INSERT INTO `tp_region` VALUES ('248', '清源街道', '4', '245');
INSERT INTO `tp_region` VALUES ('249', '亦庄地区', '4', '245');
INSERT INTO `tp_region` VALUES ('250', '黄村地区', '4', '245');
INSERT INTO `tp_region` VALUES ('251', '旧宫地区', '4', '245');
INSERT INTO `tp_region` VALUES ('252', '西红门地区', '4', '245');
INSERT INTO `tp_region` VALUES ('253', '青云店镇', '4', '245');
INSERT INTO `tp_region` VALUES ('254', '采育镇', '4', '245');
INSERT INTO `tp_region` VALUES ('255', '安定镇', '4', '245');
INSERT INTO `tp_region` VALUES ('256', '礼贤镇', '4', '245');
INSERT INTO `tp_region` VALUES ('257', '榆垡镇', '4', '245');
INSERT INTO `tp_region` VALUES ('258', '庞各庄镇', '4', '245');
INSERT INTO `tp_region` VALUES ('259', '北臧村镇', '4', '245');
INSERT INTO `tp_region` VALUES ('260', '魏善庄镇', '4', '245');
INSERT INTO `tp_region` VALUES ('261', '长子营镇', '4', '245');
INSERT INTO `tp_region` VALUES ('262', '瀛海镇', '4', '245');
INSERT INTO `tp_region` VALUES ('263', '亦庄开发区', '4', '245');
INSERT INTO `tp_region` VALUES ('264', '怀柔区', '3', '2');
INSERT INTO `tp_region` VALUES ('265', '泉河街道', '4', '264');
INSERT INTO `tp_region` VALUES ('266', '龙山街道', '4', '264');
INSERT INTO `tp_region` VALUES ('267', '怀柔地区', '4', '264');
INSERT INTO `tp_region` VALUES ('268', '雁栖地区', '4', '264');
INSERT INTO `tp_region` VALUES ('269', '庙城地区', '4', '264');
INSERT INTO `tp_region` VALUES ('270', '北房镇', '4', '264');
INSERT INTO `tp_region` VALUES ('271', '杨宋镇', '4', '264');
INSERT INTO `tp_region` VALUES ('272', '桥梓镇', '4', '264');
INSERT INTO `tp_region` VALUES ('273', '怀北镇', '4', '264');
INSERT INTO `tp_region` VALUES ('274', '汤河口镇', '4', '264');
INSERT INTO `tp_region` VALUES ('275', '渤海镇', '4', '264');
INSERT INTO `tp_region` VALUES ('276', '九渡河镇', '4', '264');
INSERT INTO `tp_region` VALUES ('277', '琉璃庙镇', '4', '264');
INSERT INTO `tp_region` VALUES ('278', '宝山镇', '4', '264');
INSERT INTO `tp_region` VALUES ('279', '长哨营满族乡', '4', '264');
INSERT INTO `tp_region` VALUES ('280', '喇叭沟门满族乡', '4', '264');
INSERT INTO `tp_region` VALUES ('281', '平谷区', '3', '2');
INSERT INTO `tp_region` VALUES ('282', '滨河街道', '4', '281');
INSERT INTO `tp_region` VALUES ('283', '兴谷街道', '4', '281');
INSERT INTO `tp_region` VALUES ('284', '渔阳地区', '4', '281');
INSERT INTO `tp_region` VALUES ('285', '峪口地区', '4', '281');
INSERT INTO `tp_region` VALUES ('286', '马坊地区', '4', '281');
INSERT INTO `tp_region` VALUES ('287', '金海湖地区', '4', '281');
INSERT INTO `tp_region` VALUES ('288', '东高村镇', '4', '281');
INSERT INTO `tp_region` VALUES ('289', '山东庄镇', '4', '281');
INSERT INTO `tp_region` VALUES ('290', '南独乐河镇', '4', '281');
INSERT INTO `tp_region` VALUES ('291', '大华山镇', '4', '281');
INSERT INTO `tp_region` VALUES ('292', '夏各庄镇', '4', '281');
INSERT INTO `tp_region` VALUES ('293', '马昌营镇', '4', '281');
INSERT INTO `tp_region` VALUES ('294', '王辛庄镇', '4', '281');
INSERT INTO `tp_region` VALUES ('295', '大兴庄镇', '4', '281');
INSERT INTO `tp_region` VALUES ('296', '刘家店镇', '4', '281');
INSERT INTO `tp_region` VALUES ('297', '镇罗营镇', '4', '281');
INSERT INTO `tp_region` VALUES ('298', '黄松峪乡', '4', '281');
INSERT INTO `tp_region` VALUES ('299', '熊儿寨乡', '4', '281');
INSERT INTO `tp_region` VALUES ('300', '县', '2', '1');
INSERT INTO `tp_region` VALUES ('301', '密云县', '3', '300');
INSERT INTO `tp_region` VALUES ('302', '鼓楼街道', '4', '301');
INSERT INTO `tp_region` VALUES ('303', '果园街道', '4', '301');
INSERT INTO `tp_region` VALUES ('304', '檀营地区', '4', '301');
INSERT INTO `tp_region` VALUES ('305', '密云镇', '4', '301');
INSERT INTO `tp_region` VALUES ('306', '溪翁庄镇', '4', '301');
INSERT INTO `tp_region` VALUES ('307', '西田各庄镇', '4', '301');
INSERT INTO `tp_region` VALUES ('308', '十里堡镇', '4', '301');
INSERT INTO `tp_region` VALUES ('309', '河南寨镇', '4', '301');
INSERT INTO `tp_region` VALUES ('310', '巨各庄镇', '4', '301');
INSERT INTO `tp_region` VALUES ('311', '穆家峪镇', '4', '301');
INSERT INTO `tp_region` VALUES ('312', '太师屯镇', '4', '301');
INSERT INTO `tp_region` VALUES ('313', '高岭镇', '4', '301');
INSERT INTO `tp_region` VALUES ('314', '不老屯镇', '4', '301');
INSERT INTO `tp_region` VALUES ('315', '冯家峪镇', '4', '301');
INSERT INTO `tp_region` VALUES ('316', '古北口镇', '4', '301');
INSERT INTO `tp_region` VALUES ('317', '大城子镇', '4', '301');
INSERT INTO `tp_region` VALUES ('318', '东邵渠镇', '4', '301');
INSERT INTO `tp_region` VALUES ('319', '北庄镇', '4', '301');
INSERT INTO `tp_region` VALUES ('320', '新城子镇', '4', '301');
INSERT INTO `tp_region` VALUES ('321', '石城镇', '4', '301');
INSERT INTO `tp_region` VALUES ('322', '延庆县', '3', '300');
INSERT INTO `tp_region` VALUES ('323', '延庆镇', '4', '322');
INSERT INTO `tp_region` VALUES ('324', '康庄镇', '4', '322');
INSERT INTO `tp_region` VALUES ('325', '八达岭镇', '4', '322');
INSERT INTO `tp_region` VALUES ('326', '永宁镇', '4', '322');
INSERT INTO `tp_region` VALUES ('327', '旧县镇', '4', '322');
INSERT INTO `tp_region` VALUES ('328', '张山营镇', '4', '322');
INSERT INTO `tp_region` VALUES ('329', '四海镇', '4', '322');
INSERT INTO `tp_region` VALUES ('330', '千家店镇', '4', '322');
INSERT INTO `tp_region` VALUES ('331', '沈家营镇', '4', '322');
INSERT INTO `tp_region` VALUES ('332', '大榆树镇', '4', '322');
INSERT INTO `tp_region` VALUES ('333', '井庄镇', '4', '322');
INSERT INTO `tp_region` VALUES ('334', '大庄科乡', '4', '322');
INSERT INTO `tp_region` VALUES ('335', '刘斌堡乡', '4', '322');
INSERT INTO `tp_region` VALUES ('336', '香营乡', '4', '322');
INSERT INTO `tp_region` VALUES ('337', '珍珠泉乡', '4', '322');
INSERT INTO `tp_region` VALUES ('338', '天津市', '1', '0');
INSERT INTO `tp_region` VALUES ('339', '市辖区', '2', '338');
INSERT INTO `tp_region` VALUES ('340', '和平区', '3', '339');
INSERT INTO `tp_region` VALUES ('341', '劝业场街道', '4', '340');
INSERT INTO `tp_region` VALUES ('342', '小白楼街道', '4', '340');
INSERT INTO `tp_region` VALUES ('343', '体育馆街道', '4', '340');
INSERT INTO `tp_region` VALUES ('344', '新兴街道', '4', '340');
INSERT INTO `tp_region` VALUES ('345', '南营门社区街道', '4', '340');
INSERT INTO `tp_region` VALUES ('346', '南市街道', '4', '340');
INSERT INTO `tp_region` VALUES ('347', '河东区', '3', '339');
INSERT INTO `tp_region` VALUES ('348', '大王庄街道', '4', '347');
INSERT INTO `tp_region` VALUES ('349', '大直沽街道', '4', '347');
INSERT INTO `tp_region` VALUES ('350', '中山门街道', '4', '347');
INSERT INTO `tp_region` VALUES ('351', '富民路街道', '4', '347');
INSERT INTO `tp_region` VALUES ('352', '二号桥街道', '4', '347');
INSERT INTO `tp_region` VALUES ('353', '春华街道', '4', '347');
INSERT INTO `tp_region` VALUES ('354', '唐家口街道', '4', '347');
INSERT INTO `tp_region` VALUES ('355', '向阳楼街道', '4', '347');
INSERT INTO `tp_region` VALUES ('356', '常州道街道', '4', '347');
INSERT INTO `tp_region` VALUES ('357', '上杭路街道', '4', '347');
INSERT INTO `tp_region` VALUES ('358', '东新街道', '4', '347');
INSERT INTO `tp_region` VALUES ('359', '鲁山道街道', '4', '347');
INSERT INTO `tp_region` VALUES ('360', '天津铁厂街道', '4', '347');
INSERT INTO `tp_region` VALUES ('361', '河西区', '3', '339');
INSERT INTO `tp_region` VALUES ('362', '大营门街道', '4', '361');
INSERT INTO `tp_region` VALUES ('363', '下瓦房街道', '4', '361');
INSERT INTO `tp_region` VALUES ('364', '桃园街道', '4', '361');
INSERT INTO `tp_region` VALUES ('365', '挂甲寺街道', '4', '361');
INSERT INTO `tp_region` VALUES ('366', '马场街道', '4', '361');
INSERT INTO `tp_region` VALUES ('367', '越秀路街道', '4', '361');
INSERT INTO `tp_region` VALUES ('368', '友谊路街道', '4', '361');
INSERT INTO `tp_region` VALUES ('369', '天塔街道', '4', '361');
INSERT INTO `tp_region` VALUES ('370', '尖山街道', '4', '361');
INSERT INTO `tp_region` VALUES ('371', '陈塘庄街道', '4', '361');
INSERT INTO `tp_region` VALUES ('372', '柳林街道', '4', '361');
INSERT INTO `tp_region` VALUES ('373', '东海街道', '4', '361');
INSERT INTO `tp_region` VALUES ('374', '梅江虚拟街道', '4', '361');
INSERT INTO `tp_region` VALUES ('375', '南开区', '3', '339');
INSERT INTO `tp_region` VALUES ('376', '长虹街道', '4', '375');
INSERT INTO `tp_region` VALUES ('377', '鼓楼街道', '4', '375');
INSERT INTO `tp_region` VALUES ('378', '兴南街道', '4', '375');
INSERT INTO `tp_region` VALUES ('379', '广开街道', '4', '375');
INSERT INTO `tp_region` VALUES ('380', '万兴街道', '4', '375');
INSERT INTO `tp_region` VALUES ('381', '学府街道', '4', '375');
INSERT INTO `tp_region` VALUES ('382', '向阳路街道', '4', '375');
INSERT INTO `tp_region` VALUES ('383', '嘉陵道街道', '4', '375');
INSERT INTO `tp_region` VALUES ('384', '王顶堤街道', '4', '375');
INSERT INTO `tp_region` VALUES ('385', '水上公园街道', '4', '375');
INSERT INTO `tp_region` VALUES ('386', '体育中心街道', '4', '375');
INSERT INTO `tp_region` VALUES ('387', '华苑街道', '4', '375');
INSERT INTO `tp_region` VALUES ('388', '河北区', '3', '339');
INSERT INTO `tp_region` VALUES ('389', '光复道街道', '4', '388');
INSERT INTO `tp_region` VALUES ('390', '望海楼街道', '4', '388');
INSERT INTO `tp_region` VALUES ('391', '鸿顺里街道', '4', '388');
INSERT INTO `tp_region` VALUES ('392', '新开河街道', '4', '388');
INSERT INTO `tp_region` VALUES ('393', '铁东路街道', '4', '388');
INSERT INTO `tp_region` VALUES ('394', '建昌道街道', '4', '388');
INSERT INTO `tp_region` VALUES ('395', '宁园街道', '4', '388');
INSERT INTO `tp_region` VALUES ('396', '王串场街道', '4', '388');
INSERT INTO `tp_region` VALUES ('397', '江都路街道', '4', '388');
INSERT INTO `tp_region` VALUES ('398', '月牙河街道', '4', '388');
INSERT INTO `tp_region` VALUES ('399', '红桥区', '3', '339');
INSERT INTO `tp_region` VALUES ('400', '西于庄街道', '4', '399');
INSERT INTO `tp_region` VALUES ('401', '双环村街道', '4', '399');
INSERT INTO `tp_region` VALUES ('402', '咸阳北路街道', '4', '399');
INSERT INTO `tp_region` VALUES ('403', '丁字沽街道', '4', '399');
INSERT INTO `tp_region` VALUES ('404', '西沽街道', '4', '399');
INSERT INTO `tp_region` VALUES ('405', '三条石街道', '4', '399');
INSERT INTO `tp_region` VALUES ('406', '邵公庄街道', '4', '399');
INSERT INTO `tp_region` VALUES ('407', '芥园街道', '4', '399');
INSERT INTO `tp_region` VALUES ('408', '铃铛阁街道', '4', '399');
INSERT INTO `tp_region` VALUES ('409', '大胡同街道', '4', '399');
INSERT INTO `tp_region` VALUES ('410', '塘沽区', '3', '339');
INSERT INTO `tp_region` VALUES ('411', '新村街道', '4', '410');
INSERT INTO `tp_region` VALUES ('412', '解放路街道', '4', '410');
INSERT INTO `tp_region` VALUES ('413', '三槐路街道', '4', '410');
INSERT INTO `tp_region` VALUES ('414', '新港街道', '4', '410');
INSERT INTO `tp_region` VALUES ('415', '向阳街道', '4', '410');
INSERT INTO `tp_region` VALUES ('416', '杭州道街道', '4', '410');
INSERT INTO `tp_region` VALUES ('417', '新河街道', '4', '410');
INSERT INTO `tp_region` VALUES ('418', '大沽街道', '4', '410');
INSERT INTO `tp_region` VALUES ('419', '北塘街道', '4', '410');
INSERT INTO `tp_region` VALUES ('420', '渤海石油街道', '4', '410');
INSERT INTO `tp_region` VALUES ('421', '胡家园街道', '4', '410');
INSERT INTO `tp_region` VALUES ('422', '新城镇', '4', '410');
INSERT INTO `tp_region` VALUES ('423', '开发区虚拟街道', '4', '410');
INSERT INTO `tp_region` VALUES ('424', '保税区虚拟街道', '4', '410');
INSERT INTO `tp_region` VALUES ('425', '汉沽区', '3', '339');
INSERT INTO `tp_region` VALUES ('426', '汉沽街道', '4', '425');
INSERT INTO `tp_region` VALUES ('427', '寨上街道', '4', '425');
INSERT INTO `tp_region` VALUES ('428', '河西街道', '4', '425');
INSERT INTO `tp_region` VALUES ('429', '盐场街道', '4', '425');
INSERT INTO `tp_region` VALUES ('430', '大田镇', '4', '425');
INSERT INTO `tp_region` VALUES ('431', '杨家泊镇', '4', '425');
INSERT INTO `tp_region` VALUES ('432', '茶淀镇', '4', '425');
INSERT INTO `tp_region` VALUES ('433', '营城镇', '4', '425');
INSERT INTO `tp_region` VALUES ('434', '开发区汉沽化工小区虚拟街道', '4', '425');
INSERT INTO `tp_region` VALUES ('435', '大港区', '3', '339');
INSERT INTO `tp_region` VALUES ('436', '迎宾街道', '4', '435');
INSERT INTO `tp_region` VALUES ('437', '胜利街道', '4', '435');
INSERT INTO `tp_region` VALUES ('438', '古林街道', '4', '435');
INSERT INTO `tp_region` VALUES ('439', '海滨街道', '4', '435');
INSERT INTO `tp_region` VALUES ('440', '港西街道', '4', '435');
INSERT INTO `tp_region` VALUES ('441', '太平镇', '4', '435');
INSERT INTO `tp_region` VALUES ('442', '小王庄镇', '4', '435');
INSERT INTO `tp_region` VALUES ('443', '中塘镇', '4', '435');
INSERT INTO `tp_region` VALUES ('444', '北大港农场虚拟镇', '4', '435');
INSERT INTO `tp_region` VALUES ('445', '东丽区', '3', '339');
INSERT INTO `tp_region` VALUES ('446', '张贵庄街道', '4', '445');
INSERT INTO `tp_region` VALUES ('447', '丰年村街道', '4', '445');
INSERT INTO `tp_region` VALUES ('448', '万新街道', '4', '445');
INSERT INTO `tp_region` VALUES ('449', '无瑕街道', '4', '445');
INSERT INTO `tp_region` VALUES ('450', '新立街道', '4', '445');
INSERT INTO `tp_region` VALUES ('451', '华明街道', '4', '445');
INSERT INTO `tp_region` VALUES ('452', '军粮城镇', '4', '445');
INSERT INTO `tp_region` VALUES ('453', '大毕庄镇', '4', '445');
INSERT INTO `tp_region` VALUES ('454', '么六桥乡', '4', '445');
INSERT INTO `tp_region` VALUES ('455', '开发区西区虚拟街道', '4', '445');
INSERT INTO `tp_region` VALUES ('456', '保税区空港国际物流区虚拟街道', '4', '445');
INSERT INTO `tp_region` VALUES ('457', '保税区空港国际物流加工区虚拟街道', '4', '445');
INSERT INTO `tp_region` VALUES ('458', '东丽区开发区虚拟街道', '4', '445');
INSERT INTO `tp_region` VALUES ('459', '东丽湖虚拟街道', '4', '445');
INSERT INTO `tp_region` VALUES ('460', '西青区', '3', '339');
INSERT INTO `tp_region` VALUES ('461', '西营门街道', '4', '460');
INSERT INTO `tp_region` VALUES ('462', '李七庄街道', '4', '460');
INSERT INTO `tp_region` VALUES ('463', '中北镇', '4', '460');
INSERT INTO `tp_region` VALUES ('464', '杨柳青镇', '4', '460');
INSERT INTO `tp_region` VALUES ('465', '辛口镇', '4', '460');
INSERT INTO `tp_region` VALUES ('466', '张家窝镇', '4', '460');
INSERT INTO `tp_region` VALUES ('467', '南河镇', '4', '460');
INSERT INTO `tp_region` VALUES ('468', '大寺镇', '4', '460');
INSERT INTO `tp_region` VALUES ('469', '王稳庄镇', '4', '460');
INSERT INTO `tp_region` VALUES ('470', '开发区西青微电子小区虚拟街道', '4', '460');
INSERT INTO `tp_region` VALUES ('471', '新技术产业园区虚拟街', '4', '460');
INSERT INTO `tp_region` VALUES ('472', '西青区开发区虚拟街道', '4', '460');
INSERT INTO `tp_region` VALUES ('473', '津南区', '3', '339');
INSERT INTO `tp_region` VALUES ('474', '咸水沽镇', '4', '473');
INSERT INTO `tp_region` VALUES ('475', '葛沽镇', '4', '473');
INSERT INTO `tp_region` VALUES ('476', '小站镇', '4', '473');
INSERT INTO `tp_region` VALUES ('477', '双港镇', '4', '473');
INSERT INTO `tp_region` VALUES ('478', '辛庄镇', '4', '473');
INSERT INTO `tp_region` VALUES ('479', '双桥河镇', '4', '473');
INSERT INTO `tp_region` VALUES ('480', '八里台镇', '4', '473');
INSERT INTO `tp_region` VALUES ('481', '北闸口镇', '4', '473');
INSERT INTO `tp_region` VALUES ('482', '双林农场虚拟街', '4', '473');
INSERT INTO `tp_region` VALUES ('483', '铁路十八局虚拟街', '4', '473');
INSERT INTO `tp_region` VALUES ('484', '津南国家农业园区虚拟街', '4', '473');
INSERT INTO `tp_region` VALUES ('485', '长青办事处虚拟街', '4', '473');
INSERT INTO `tp_region` VALUES ('486', '津南开发区东区虚拟居街', '4', '473');
INSERT INTO `tp_region` VALUES ('487', '津南开发区西区虚拟居街', '4', '473');
INSERT INTO `tp_region` VALUES ('488', '北辰区', '3', '339');
INSERT INTO `tp_region` VALUES ('489', '果园新村街道', '4', '488');
INSERT INTO `tp_region` VALUES ('490', '集贤里街道', '4', '488');
INSERT INTO `tp_region` VALUES ('491', '普东街道', '4', '488');
INSERT INTO `tp_region` VALUES ('492', '佳荣里街道', '4', '488');
INSERT INTO `tp_region` VALUES ('493', '天穆镇', '4', '488');
INSERT INTO `tp_region` VALUES ('494', '北仓镇', '4', '488');
INSERT INTO `tp_region` VALUES ('495', '双街镇', '4', '488');
INSERT INTO `tp_region` VALUES ('496', '双口镇', '4', '488');
INSERT INTO `tp_region` VALUES ('497', '青光镇', '4', '488');
INSERT INTO `tp_region` VALUES ('498', '宜兴埠镇', '4', '488');
INSERT INTO `tp_region` VALUES ('499', '小淀镇', '4', '488');
INSERT INTO `tp_region` VALUES ('500', '大张庄镇', '4', '488');
INSERT INTO `tp_region` VALUES ('501', '西堤头镇', '4', '488');
INSERT INTO `tp_region` VALUES ('502', '红旗农场', '4', '488');
INSERT INTO `tp_region` VALUES ('503', '曙光农场', '4', '488');
INSERT INTO `tp_region` VALUES ('504', '武清区', '3', '339');
INSERT INTO `tp_region` VALUES ('505', '杨村街道', '4', '504');
INSERT INTO `tp_region` VALUES ('506', '下朱庄街道', '4', '504');
INSERT INTO `tp_region` VALUES ('507', '东蒲洼街道', '4', '504');
INSERT INTO `tp_region` VALUES ('508', '黄庄街道', '4', '504');
INSERT INTO `tp_region` VALUES ('509', '徐官屯街道', '4', '504');
INSERT INTO `tp_region` VALUES ('510', '运河西街道', '4', '504');
INSERT INTO `tp_region` VALUES ('511', '梅厂镇', '4', '504');
INSERT INTO `tp_region` VALUES ('512', '大碱厂镇', '4', '504');
INSERT INTO `tp_region` VALUES ('513', '崔黄口镇', '4', '504');
INSERT INTO `tp_region` VALUES ('514', '大良镇', '4', '504');
INSERT INTO `tp_region` VALUES ('515', '下伍旗镇', '4', '504');
INSERT INTO `tp_region` VALUES ('516', '南蔡村镇', '4', '504');
INSERT INTO `tp_region` VALUES ('517', '大孟庄镇', '4', '504');
INSERT INTO `tp_region` VALUES ('518', '泗村店镇', '4', '504');
INSERT INTO `tp_region` VALUES ('519', '河西务镇', '4', '504');
INSERT INTO `tp_region` VALUES ('520', '城关镇', '4', '504');
INSERT INTO `tp_region` VALUES ('521', '东马圈镇', '4', '504');
INSERT INTO `tp_region` VALUES ('522', '黄花店镇', '4', '504');
INSERT INTO `tp_region` VALUES ('523', '石各庄镇', '4', '504');
INSERT INTO `tp_region` VALUES ('524', '王庆坨镇', '4', '504');
INSERT INTO `tp_region` VALUES ('525', '汊沽港镇', '4', '504');
INSERT INTO `tp_region` VALUES ('526', '河北屯镇', '4', '504');
INSERT INTO `tp_region` VALUES ('527', '上马台镇', '4', '504');
INSERT INTO `tp_region` VALUES ('528', '大王古庄镇', '4', '504');
INSERT INTO `tp_region` VALUES ('529', '陈咀镇', '4', '504');
INSERT INTO `tp_region` VALUES ('530', '豆张庄乡', '4', '504');
INSERT INTO `tp_region` VALUES ('531', '曹子里乡', '4', '504');
INSERT INTO `tp_region` VALUES ('532', '大黄堡乡', '4', '504');
INSERT INTO `tp_region` VALUES ('533', '高村乡', '4', '504');
INSERT INTO `tp_region` VALUES ('534', '白古屯乡', '4', '504');
INSERT INTO `tp_region` VALUES ('535', '开发区武清逸仙园小区虚拟街道', '4', '504');
INSERT INTO `tp_region` VALUES ('536', '武清区开发区虚拟街道', '4', '504');
INSERT INTO `tp_region` VALUES ('537', '武清农场虚拟镇', '4', '504');
INSERT INTO `tp_region` VALUES ('538', '宝坻区', '3', '339');
INSERT INTO `tp_region` VALUES ('539', '海滨街道', '4', '538');
INSERT INTO `tp_region` VALUES ('540', '宝平街道', '4', '538');
INSERT INTO `tp_region` VALUES ('541', '钰华街道', '4', '538');
INSERT INTO `tp_region` VALUES ('542', '大口屯镇', '4', '538');
INSERT INTO `tp_region` VALUES ('543', '大白庄镇', '4', '538');
INSERT INTO `tp_region` VALUES ('544', '王卜庄镇', '4', '538');
INSERT INTO `tp_region` VALUES ('545', '方家庄镇', '4', '538');
INSERT INTO `tp_region` VALUES ('546', '林亭口镇', '4', '538');
INSERT INTO `tp_region` VALUES ('547', '八门城镇', '4', '538');
INSERT INTO `tp_region` VALUES ('548', '大钟庄镇', '4', '538');
INSERT INTO `tp_region` VALUES ('549', '新安镇', '4', '538');
INSERT INTO `tp_region` VALUES ('550', '马家店镇', '4', '538');
INSERT INTO `tp_region` VALUES ('551', '霍各庄镇', '4', '538');
INSERT INTO `tp_region` VALUES ('552', '新开口镇', '4', '538');
INSERT INTO `tp_region` VALUES ('553', '大唐庄镇', '4', '538');
INSERT INTO `tp_region` VALUES ('554', '高家庄镇', '4', '538');
INSERT INTO `tp_region` VALUES ('555', '口东镇', '4', '538');
INSERT INTO `tp_region` VALUES ('556', '牛道口镇', '4', '538');
INSERT INTO `tp_region` VALUES ('557', '史各庄镇', '4', '538');
INSERT INTO `tp_region` VALUES ('558', '郝各庄镇', '4', '538');
INSERT INTO `tp_region` VALUES ('559', '周良庄镇', '4', '538');
INSERT INTO `tp_region` VALUES ('560', '牛家牌乡', '4', '538');
INSERT INTO `tp_region` VALUES ('561', '尔王庄乡', '4', '538');
INSERT INTO `tp_region` VALUES ('562', '黄庄乡', '4', '538');
INSERT INTO `tp_region` VALUES ('563', '里自沽农场虚拟镇', '4', '538');
INSERT INTO `tp_region` VALUES ('564', '黄庄农场虚拟镇', '4', '538');
INSERT INTO `tp_region` VALUES ('565', '大钟农场虚拟镇', '4', '538');
INSERT INTO `tp_region` VALUES ('566', '天宝工业园区虚拟街', '4', '538');
INSERT INTO `tp_region` VALUES ('567', '九园工业园区虚拟街', '4', '538');
INSERT INTO `tp_region` VALUES ('568', '京津新城虚拟街', '4', '538');
INSERT INTO `tp_region` VALUES ('569', '市辖县', '2', '338');
INSERT INTO `tp_region` VALUES ('570', '宁河县', '3', '569');
INSERT INTO `tp_region` VALUES ('571', '芦台镇', '4', '570');
INSERT INTO `tp_region` VALUES ('572', '宁河镇', '4', '570');
INSERT INTO `tp_region` VALUES ('573', '苗庄镇', '4', '570');
INSERT INTO `tp_region` VALUES ('574', '丰台镇', '4', '570');
INSERT INTO `tp_region` VALUES ('575', '岳龙镇', '4', '570');
INSERT INTO `tp_region` VALUES ('576', '板桥镇', '4', '570');
INSERT INTO `tp_region` VALUES ('577', '潘庄镇', '4', '570');
INSERT INTO `tp_region` VALUES ('578', '造甲城镇', '4', '570');
INSERT INTO `tp_region` VALUES ('579', '七里海镇', '4', '570');
INSERT INTO `tp_region` VALUES ('580', '大北涧沽镇', '4', '570');
INSERT INTO `tp_region` VALUES ('581', '东棘坨镇', '4', '570');
INSERT INTO `tp_region` VALUES ('582', '北淮淀乡', '4', '570');
INSERT INTO `tp_region` VALUES ('583', '俵口乡', '4', '570');
INSERT INTO `tp_region` VALUES ('584', '廉庄子乡', '4', '570');
INSERT INTO `tp_region` VALUES ('585', '潘庄农场虚拟镇', '4', '570');
INSERT INTO `tp_region` VALUES ('586', '静海县', '3', '569');
INSERT INTO `tp_region` VALUES ('587', '静海镇', '4', '586');
INSERT INTO `tp_region` VALUES ('588', '唐官屯镇', '4', '586');
INSERT INTO `tp_region` VALUES ('589', '独流镇', '4', '586');
INSERT INTO `tp_region` VALUES ('590', '王口镇', '4', '586');
INSERT INTO `tp_region` VALUES ('591', '台头镇', '4', '586');
INSERT INTO `tp_region` VALUES ('592', '子牙镇', '4', '586');
INSERT INTO `tp_region` VALUES ('593', '陈官屯镇', '4', '586');
INSERT INTO `tp_region` VALUES ('594', '中旺镇', '4', '586');
INSERT INTO `tp_region` VALUES ('595', '大邱庄镇', '4', '586');
INSERT INTO `tp_region` VALUES ('596', '蔡公庄镇', '4', '586');
INSERT INTO `tp_region` VALUES ('597', '梁头镇', '4', '586');
INSERT INTO `tp_region` VALUES ('598', '团泊镇', '4', '586');
INSERT INTO `tp_region` VALUES ('599', '双塘镇', '4', '586');
INSERT INTO `tp_region` VALUES ('600', '大丰堆镇', '4', '586');
INSERT INTO `tp_region` VALUES ('601', '沿庄镇', '4', '586');
INSERT INTO `tp_region` VALUES ('602', '西翟庄镇', '4', '586');
INSERT INTO `tp_region` VALUES ('603', '良王庄乡', '4', '586');
INSERT INTO `tp_region` VALUES ('604', '杨成庄乡', '4', '586');
INSERT INTO `tp_region` VALUES ('605', '天津静海经济开发区虚拟街', '4', '586');
INSERT INTO `tp_region` VALUES ('606', '天津子牙工业园区虚拟街', '4', '586');
INSERT INTO `tp_region` VALUES ('607', '中国石油天然气总公司地调一处虚拟街', '4', '586');
INSERT INTO `tp_region` VALUES ('608', '蓟县', '3', '569');
INSERT INTO `tp_region` VALUES ('609', '文昌街道', '4', '608');
INSERT INTO `tp_region` VALUES ('610', '城关镇', '4', '608');
INSERT INTO `tp_region` VALUES ('611', '洇溜镇', '4', '608');
INSERT INTO `tp_region` VALUES ('612', '官庄镇', '4', '608');
INSERT INTO `tp_region` VALUES ('613', '马伸桥镇', '4', '608');
INSERT INTO `tp_region` VALUES ('614', '下营镇', '4', '608');
INSERT INTO `tp_region` VALUES ('615', '邦均镇', '4', '608');
INSERT INTO `tp_region` VALUES ('616', '别山镇', '4', '608');
INSERT INTO `tp_region` VALUES ('617', '尤古庄镇', '4', '608');
INSERT INTO `tp_region` VALUES ('618', '上仓镇', '4', '608');
INSERT INTO `tp_region` VALUES ('619', '下仓镇', '4', '608');
INSERT INTO `tp_region` VALUES ('620', '罗庄子镇', '4', '608');
INSERT INTO `tp_region` VALUES ('621', '白涧镇', '4', '608');
INSERT INTO `tp_region` VALUES ('622', '五百户镇', '4', '608');
INSERT INTO `tp_region` VALUES ('623', '侯家营镇', '4', '608');
INSERT INTO `tp_region` VALUES ('624', '桑梓镇', '4', '608');
INSERT INTO `tp_region` VALUES ('625', '东施古镇', '4', '608');
INSERT INTO `tp_region` VALUES ('626', '下窝头镇', '4', '608');
INSERT INTO `tp_region` VALUES ('627', '杨津庄镇', '4', '608');
INSERT INTO `tp_region` VALUES ('628', '出头岭镇', '4', '608');
INSERT INTO `tp_region` VALUES ('629', '西龙虎峪镇', '4', '608');
INSERT INTO `tp_region` VALUES ('630', '穿芳峪乡', '4', '608');
INSERT INTO `tp_region` VALUES ('631', '孙各庄乡', '4', '608');
INSERT INTO `tp_region` VALUES ('632', '东二营乡', '4', '608');
INSERT INTO `tp_region` VALUES ('633', '许家台乡', '4', '608');
INSERT INTO `tp_region` VALUES ('634', '礼明庄乡', '4', '608');
INSERT INTO `tp_region` VALUES ('635', '东赵各庄乡', '4', '608');
INSERT INTO `tp_region` VALUES ('636', '河北省', '1', '0');
INSERT INTO `tp_region` VALUES ('637', '石家庄市', '2', '636');
INSERT INTO `tp_region` VALUES ('638', '市辖区', '3', '637');
INSERT INTO `tp_region` VALUES ('639', '长安区', '3', '637');
INSERT INTO `tp_region` VALUES ('640', '建北街道', '4', '639');
INSERT INTO `tp_region` VALUES ('641', '青园街道', '4', '639');
INSERT INTO `tp_region` VALUES ('642', '广安街道', '4', '639');
INSERT INTO `tp_region` VALUES ('643', '育才街道', '4', '639');
INSERT INTO `tp_region` VALUES ('644', '跃进街道', '4', '639');
INSERT INTO `tp_region` VALUES ('645', '河东街道', '4', '639');
INSERT INTO `tp_region` VALUES ('646', '长丰街道', '4', '639');
INSERT INTO `tp_region` VALUES ('647', '谈固街道', '4', '639');
INSERT INTO `tp_region` VALUES ('648', '西兆通镇', '4', '639');
INSERT INTO `tp_region` VALUES ('649', '南村镇', '4', '639');
INSERT INTO `tp_region` VALUES ('650', '高营镇', '4', '639');
INSERT INTO `tp_region` VALUES ('651', '桥东区', '3', '637');
INSERT INTO `tp_region` VALUES ('652', '中山东路街道', '4', '651');
INSERT INTO `tp_region` VALUES ('653', '彭后街道', '4', '651');
INSERT INTO `tp_region` VALUES ('654', '东风街道', '4', '651');
INSERT INTO `tp_region` VALUES ('655', '东华街道', '4', '651');
INSERT INTO `tp_region` VALUES ('656', '休门街道', '4', '651');
INSERT INTO `tp_region` VALUES ('657', '阜康街道', '4', '651');
INSERT INTO `tp_region` VALUES ('658', '建安街道', '4', '651');
INSERT INTO `tp_region` VALUES ('659', '胜利北街道', '4', '651');
INSERT INTO `tp_region` VALUES ('660', '汇通街道', '4', '651');
INSERT INTO `tp_region` VALUES ('661', '桃园镇', '4', '651');
INSERT INTO `tp_region` VALUES ('662', '桥西区', '3', '637');
INSERT INTO `tp_region` VALUES ('663', '东里街道', '4', '662');
INSERT INTO `tp_region` VALUES ('664', '中山路街道', '4', '662');
INSERT INTO `tp_region` VALUES ('665', '南长街道', '4', '662');
INSERT INTO `tp_region` VALUES ('666', '维明街道', '4', '662');
INSERT INTO `tp_region` VALUES ('667', '裕西街道', '4', '662');
INSERT INTO `tp_region` VALUES ('668', '友谊街道', '4', '662');
INSERT INTO `tp_region` VALUES ('669', '红旗街道', '4', '662');
INSERT INTO `tp_region` VALUES ('670', '新石街道', '4', '662');
INSERT INTO `tp_region` VALUES ('671', '苑东街道', '4', '662');
INSERT INTO `tp_region` VALUES ('672', '西里街道', '4', '662');
INSERT INTO `tp_region` VALUES ('673', '振头街道', '4', '662');
INSERT INTO `tp_region` VALUES ('674', '留营乡', '4', '662');
INSERT INTO `tp_region` VALUES ('675', '新华区', '3', '637');
INSERT INTO `tp_region` VALUES ('676', '革新街街道', '4', '675');
INSERT INTO `tp_region` VALUES ('677', '新华路街道', '4', '675');
INSERT INTO `tp_region` VALUES ('678', '宁安路街道', '4', '675');
INSERT INTO `tp_region` VALUES ('679', '东焦街道', '4', '675');
INSERT INTO `tp_region` VALUES ('680', '西苑街道', '4', '675');
INSERT INTO `tp_region` VALUES ('681', '合作路街道', '4', '675');
INSERT INTO `tp_region` VALUES ('682', '联盟路街道', '4', '675');
INSERT INTO `tp_region` VALUES ('683', '石岗大街街道', '4', '675');
INSERT INTO `tp_region` VALUES ('684', '五七路街道', '4', '675');
INSERT INTO `tp_region` VALUES ('685', '天苑街道', '4', '675');
INSERT INTO `tp_region` VALUES ('686', '北苑街道', '4', '675');
INSERT INTO `tp_region` VALUES ('687', '大郭镇', '4', '675');
INSERT INTO `tp_region` VALUES ('688', '赵陵铺镇', '4', '675');
INSERT INTO `tp_region` VALUES ('689', '西三庄乡', '4', '675');
INSERT INTO `tp_region` VALUES ('690', '杜北乡', '4', '675');
INSERT INTO `tp_region` VALUES ('691', '井陉矿区', '3', '637');
INSERT INTO `tp_region` VALUES ('692', '矿市街街道', '4', '691');
INSERT INTO `tp_region` VALUES ('693', '四微街道', '4', '691');
INSERT INTO `tp_region` VALUES ('694', '贾庄镇', '4', '691');
INSERT INTO `tp_region` VALUES ('695', '凤山镇', '4', '691');
INSERT INTO `tp_region` VALUES ('696', '横涧乡', '4', '691');
INSERT INTO `tp_region` VALUES ('697', '裕华区', '3', '637');
INSERT INTO `tp_region` VALUES ('698', '裕兴街道', '4', '697');
INSERT INTO `tp_region` VALUES ('699', '裕强街道', '4', '697');
INSERT INTO `tp_region` VALUES ('700', '东苑街道', '4', '697');
INSERT INTO `tp_region` VALUES ('701', '建通街道', '4', '697');
INSERT INTO `tp_region` VALUES ('702', '槐底街道', '4', '697');
INSERT INTO `tp_region` VALUES ('703', '裕华路街道', '4', '697');
INSERT INTO `tp_region` VALUES ('704', '裕东街道', '4', '697');
INSERT INTO `tp_region` VALUES ('705', '长江街道办事处(高新区)', '4', '697');
INSERT INTO `tp_region` VALUES ('706', '宋营镇', '4', '697');
INSERT INTO `tp_region` VALUES ('707', '方村镇', '4', '697');
INSERT INTO `tp_region` VALUES ('708', '井陉县', '3', '637');
INSERT INTO `tp_region` VALUES ('709', '微水镇', '4', '708');
INSERT INTO `tp_region` VALUES ('710', '上安镇', '4', '708');
INSERT INTO `tp_region` VALUES ('711', '天长镇', '4', '708');
INSERT INTO `tp_region` VALUES ('712', '秀林镇', '4', '708');
INSERT INTO `tp_region` VALUES ('713', '南峪镇', '4', '708');
INSERT INTO `tp_region` VALUES ('714', '威州镇', '4', '708');
INSERT INTO `tp_region` VALUES ('715', '小作镇', '4', '708');
INSERT INTO `tp_region` VALUES ('716', '南障城镇', '4', '708');
INSERT INTO `tp_region` VALUES ('717', '苍岩山镇', '4', '708');
INSERT INTO `tp_region` VALUES ('718', '测鱼镇', '4', '708');
INSERT INTO `tp_region` VALUES ('719', '吴家窑乡', '4', '708');
INSERT INTO `tp_region` VALUES ('720', '北正乡', '4', '708');
INSERT INTO `tp_region` VALUES ('721', '于家乡', '4', '708');
INSERT INTO `tp_region` VALUES ('722', '孙庄乡', '4', '708');
INSERT INTO `tp_region` VALUES ('723', '南陉乡', '4', '708');
INSERT INTO `tp_region` VALUES ('724', '辛庄乡', '4', '708');
INSERT INTO `tp_region` VALUES ('725', '南王庄乡', '4', '708');
INSERT INTO `tp_region` VALUES ('726', '正定县', '3', '637');
INSERT INTO `tp_region` VALUES ('727', '正定镇', '4', '726');
INSERT INTO `tp_region` VALUES ('728', '诸福屯镇', '4', '726');
INSERT INTO `tp_region` VALUES ('729', '新城铺镇', '4', '726');
INSERT INTO `tp_region` VALUES ('730', '新安镇', '4', '726');
INSERT INTO `tp_region` VALUES ('731', '南牛乡', '4', '726');
INSERT INTO `tp_region` VALUES ('732', '南楼乡', '4', '726');
INSERT INTO `tp_region` VALUES ('733', '西平乐乡', '4', '726');
INSERT INTO `tp_region` VALUES ('734', '北早现乡', '4', '726');
INSERT INTO `tp_region` VALUES ('735', '曲阳桥乡', '4', '726');
INSERT INTO `tp_region` VALUES ('736', '栾城县', '3', '637');
INSERT INTO `tp_region` VALUES ('737', '栾城镇', '4', '736');
INSERT INTO `tp_region` VALUES ('738', '郄马镇', '4', '736');
INSERT INTO `tp_region` VALUES ('739', '冶河镇', '4', '736');
INSERT INTO `tp_region` VALUES ('740', '窦妪镇', '4', '736');
INSERT INTO `tp_region` VALUES ('741', '楼底镇', '4', '736');
INSERT INTO `tp_region` VALUES ('742', '南高乡', '4', '736');
INSERT INTO `tp_region` VALUES ('743', '柳林屯乡', '4', '736');
INSERT INTO `tp_region` VALUES ('744', '西营乡', '4', '736');
INSERT INTO `tp_region` VALUES ('745', '行唐县', '3', '637');
INSERT INTO `tp_region` VALUES ('746', '龙州镇', '4', '745');
INSERT INTO `tp_region` VALUES ('747', '南桥镇', '4', '745');
INSERT INTO `tp_region` VALUES ('748', '上碑镇', '4', '745');
INSERT INTO `tp_region` VALUES ('749', '口头镇', '4', '745');
INSERT INTO `tp_region` VALUES ('750', '独羊岗乡', '4', '745');
INSERT INTO `tp_region` VALUES ('751', '安香乡', '4', '745');
INSERT INTO `tp_region` VALUES ('752', '只里乡', '4', '745');
INSERT INTO `tp_region` VALUES ('753', '市同乡', '4', '745');
INSERT INTO `tp_region` VALUES ('754', '翟营乡', '4', '745');
INSERT INTO `tp_region` VALUES ('755', '城寨乡', '4', '745');
INSERT INTO `tp_region` VALUES ('756', '上方乡', '4', '745');
INSERT INTO `tp_region` VALUES ('757', '玉亭乡', '4', '745');
INSERT INTO `tp_region` VALUES ('758', '北河乡', '4', '745');
INSERT INTO `tp_region` VALUES ('759', '上闫庄乡', '4', '745');
INSERT INTO `tp_region` VALUES ('760', '九口子乡', '4', '745');
INSERT INTO `tp_region` VALUES ('761', '灵寿县', '3', '637');
INSERT INTO `tp_region` VALUES ('762', '灵寿镇', '4', '761');
INSERT INTO `tp_region` VALUES ('763', '青同镇', '4', '761');
INSERT INTO `tp_region` VALUES ('764', '塔上镇', '4', '761');
INSERT INTO `tp_region` VALUES ('765', '陈庄镇', '4', '761');
INSERT INTO `tp_region` VALUES ('766', '慈峪镇', '4', '761');
INSERT INTO `tp_region` VALUES ('767', '岔头镇', '4', '761');
INSERT INTO `tp_region` VALUES ('768', '三圣院乡', '4', '761');
INSERT INTO `tp_region` VALUES ('769', '北洼乡', '4', '761');
INSERT INTO `tp_region` VALUES ('770', '牛城乡', '4', '761');
INSERT INTO `tp_region` VALUES ('771', '狗台乡', '4', '761');
INSERT INTO `tp_region` VALUES ('772', '南寨乡', '4', '761');
INSERT INTO `tp_region` VALUES ('773', '南燕川乡', '4', '761');
INSERT INTO `tp_region` VALUES ('774', '北谭庄乡', '4', '761');
INSERT INTO `tp_region` VALUES ('775', '寨头乡', '4', '761');
INSERT INTO `tp_region` VALUES ('776', '南营乡', '4', '761');
INSERT INTO `tp_region` VALUES ('777', '高邑县', '3', '637');
INSERT INTO `tp_region` VALUES ('778', '高邑镇', '4', '777');
INSERT INTO `tp_region` VALUES ('779', '大营乡', '4', '777');
INSERT INTO `tp_region` VALUES ('780', '中韩乡', '4', '777');
INSERT INTO `tp_region` VALUES ('781', '万城乡', '4', '777');
INSERT INTO `tp_region` VALUES ('782', '西富村乡', '4', '777');
INSERT INTO `tp_region` VALUES ('783', '深泽县', '3', '637');
INSERT INTO `tp_region` VALUES ('784', '深泽镇', '4', '783');
INSERT INTO `tp_region` VALUES ('785', '铁杆镇', '4', '783');
INSERT INTO `tp_region` VALUES ('786', '白庄乡', '4', '783');
INSERT INTO `tp_region` VALUES ('787', '留村乡', '4', '783');
INSERT INTO `tp_region` VALUES ('788', '赵八乡', '4', '783');
INSERT INTO `tp_region` VALUES ('789', '桥头乡', '4', '783');
INSERT INTO `tp_region` VALUES ('790', '赞皇县', '3', '637');
INSERT INTO `tp_region` VALUES ('791', '赞皇镇', '4', '790');
INSERT INTO `tp_region` VALUES ('792', '院头镇', '4', '790');
INSERT INTO `tp_region` VALUES ('793', '西龙门乡', '4', '790');
INSERT INTO `tp_region` VALUES ('794', '南邢郭乡', '4', '790');
INSERT INTO `tp_region` VALUES ('795', '南清河乡', '4', '790');
INSERT INTO `tp_region` VALUES ('796', '西阳泽乡', '4', '790');
INSERT INTO `tp_region` VALUES ('797', '土门乡', '4', '790');
INSERT INTO `tp_region` VALUES ('798', '黄北坪乡', '4', '790');
INSERT INTO `tp_region` VALUES ('799', '嶂石岩乡', '4', '790');
INSERT INTO `tp_region` VALUES ('800', '许亭乡', '4', '790');
INSERT INTO `tp_region` VALUES ('801', '张楞乡', '4', '790');
INSERT INTO `tp_region` VALUES ('802', '无极县', '3', '637');
INSERT INTO `tp_region` VALUES ('803', '无极镇', '4', '802');
INSERT INTO `tp_region` VALUES ('804', '七汲镇', '4', '802');
INSERT INTO `tp_region` VALUES ('805', '张段固镇', '4', '802');
INSERT INTO `tp_region` VALUES ('806', '北苏镇', '4', '802');
INSERT INTO `tp_region` VALUES ('807', '郭庄镇', '4', '802');
INSERT INTO `tp_region` VALUES ('808', '大陈镇', '4', '802');
INSERT INTO `tp_region` VALUES ('809', '高头乡', '4', '802');
INSERT INTO `tp_region` VALUES ('810', '郝庄乡', '4', '802');
INSERT INTO `tp_region` VALUES ('811', '东侯坊乡', '4', '802');
INSERT INTO `tp_region` VALUES ('812', '里城道乡', '4', '802');
INSERT INTO `tp_region` VALUES ('813', '南流乡', '4', '802');
INSERT INTO `tp_region` VALUES ('814', '平山县', '3', '637');
INSERT INTO `tp_region` VALUES ('815', '平山镇', '4', '814');
INSERT INTO `tp_region` VALUES ('816', '东回舍镇', '4', '814');
INSERT INTO `tp_region` VALUES ('817', '温塘镇', '4', '814');
INSERT INTO `tp_region` VALUES ('818', '南甸镇', '4', '814');
INSERT INTO `tp_region` VALUES ('819', '岗南镇', '4', '814');
INSERT INTO `tp_region` VALUES ('820', '中古月镇', '4', '814');
INSERT INTO `tp_region` VALUES ('821', '下槐镇', '4', '814');
INSERT INTO `tp_region` VALUES ('822', '孟家庄镇', '4', '814');
INSERT INTO `tp_region` VALUES ('823', '小觉镇', '4', '814');
INSERT INTO `tp_region` VALUES ('824', '蛟潭庄镇', '4', '814');
INSERT INTO `tp_region` VALUES ('825', '西柏坡镇', '4', '814');
INSERT INTO `tp_region` VALUES ('826', '下口镇', '4', '814');
INSERT INTO `tp_region` VALUES ('827', '西大吾乡', '4', '814');
INSERT INTO `tp_region` VALUES ('828', '上三汲乡', '4', '814');
INSERT INTO `tp_region` VALUES ('829', '两河乡', '4', '814');
INSERT INTO `tp_region` VALUES ('830', '东王坡乡', '4', '814');
INSERT INTO `tp_region` VALUES ('831', '苏家庄乡', '4', '814');
INSERT INTO `tp_region` VALUES ('832', '宅北乡', '4', '814');
INSERT INTO `tp_region` VALUES ('833', '北冶乡', '4', '814');
INSERT INTO `tp_region` VALUES ('834', '上观音堂乡', '4', '814');
INSERT INTO `tp_region` VALUES ('835', '杨家桥乡', '4', '814');
INSERT INTO `tp_region` VALUES ('836', '营里乡', '4', '814');
INSERT INTO `tp_region` VALUES ('837', '合河口乡', '4', '814');
INSERT INTO `tp_region` VALUES ('838', '元氏县', '3', '637');
INSERT INTO `tp_region` VALUES ('839', '槐阳镇', '4', '838');
INSERT INTO `tp_region` VALUES ('840', '因村镇', '4', '838');
INSERT INTO `tp_region` VALUES ('841', '南佐镇', '4', '838');
INSERT INTO `tp_region` VALUES ('842', '宋曹镇', '4', '838');
INSERT INTO `tp_region` VALUES ('843', '南因镇', '4', '838');
INSERT INTO `tp_region` VALUES ('844', '姬村镇', '4', '838');
INSERT INTO `tp_region` VALUES ('845', '马村乡', '4', '838');
INSERT INTO `tp_region` VALUES ('846', '东张乡', '4', '838');
INSERT INTO `tp_region` VALUES ('847', '赵同乡', '4', '838');
INSERT INTO `tp_region` VALUES ('848', '北褚乡', '4', '838');
INSERT INTO `tp_region` VALUES ('849', '苏村乡', '4', '838');
INSERT INTO `tp_region` VALUES ('850', '苏阳乡', '4', '838');
INSERT INTO `tp_region` VALUES ('851', '北正乡', '4', '838');
INSERT INTO `tp_region` VALUES ('852', '前仙乡', '4', '838');
INSERT INTO `tp_region` VALUES ('853', '黑水河乡', '4', '838');
INSERT INTO `tp_region` VALUES ('854', '赵县', '3', '637');
INSERT INTO `tp_region` VALUES ('855', '赵州镇', '4', '854');
INSERT INTO `tp_region` VALUES ('856', '范庄镇', '4', '854');
INSERT INTO `tp_region` VALUES ('857', '北王里镇', '4', '854');
INSERT INTO `tp_region` VALUES ('858', '新寨店镇', '4', '854');
INSERT INTO `tp_region` VALUES ('859', '韩村镇', '4', '854');
INSERT INTO `tp_region` VALUES ('860', '南柏舍镇', '4', '854');
INSERT INTO `tp_region` VALUES ('861', '沙河店镇', '4', '854');
INSERT INTO `tp_region` VALUES ('862', '前大章乡', '4', '854');
INSERT INTO `tp_region` VALUES ('863', '谢庄乡', '4', '854');
INSERT INTO `tp_region` VALUES ('864', '高村乡', '4', '854');
INSERT INTO `tp_region` VALUES ('865', '王西章乡', '4', '854');
INSERT INTO `tp_region` VALUES ('866', '辛集市', '3', '637');
INSERT INTO `tp_region` VALUES ('867', '辛集镇', '4', '866');
INSERT INTO `tp_region` VALUES ('868', '旧城镇', '4', '866');
INSERT INTO `tp_region` VALUES ('869', '张古庄镇', '4', '866');
INSERT INTO `tp_region` VALUES ('870', '位伯镇', '4', '866');
INSERT INTO `tp_region` VALUES ('871', '新垒头镇', '4', '866');
INSERT INTO `tp_region` VALUES ('872', '新城镇', '4', '866');
INSERT INTO `tp_region` VALUES ('873', '南智丘镇', '4', '866');
INSERT INTO `tp_region` VALUES ('874', '王口镇', '4', '866');
INSERT INTO `tp_region` VALUES ('875', '天宫营乡', '4', '866');
INSERT INTO `tp_region` VALUES ('876', '前营乡', '4', '866');
INSERT INTO `tp_region` VALUES ('877', '马庄乡', '4', '866');
INSERT INTO `tp_region` VALUES ('878', '和睦井乡', '4', '866');
INSERT INTO `tp_region` VALUES ('879', '田家庄乡', '4', '866');
INSERT INTO `tp_region` VALUES ('880', '中里厢乡', '4', '866');
INSERT INTO `tp_region` VALUES ('881', '小辛庄乡', '4', '866');
INSERT INTO `tp_region` VALUES ('882', '藁城市', '3', '637');
INSERT INTO `tp_region` VALUES ('883', '廉州镇', '4', '882');
INSERT INTO `tp_region` VALUES ('884', '兴安镇', '4', '882');
INSERT INTO `tp_region` VALUES ('885', '贾市庄镇', '4', '882');
INSERT INTO `tp_region` VALUES ('886', '南营镇', '4', '882');
INSERT INTO `tp_region` VALUES ('887', '梅花镇', '4', '882');
INSERT INTO `tp_region` VALUES ('888', '岗上镇', '4', '882');
INSERT INTO `tp_region` VALUES ('889', '邱头镇', '4', '882');
INSERT INTO `tp_region` VALUES ('890', '南董镇', '4', '882');
INSERT INTO `tp_region` VALUES ('891', '张家庄镇', '4', '882');
INSERT INTO `tp_region` VALUES ('892', '南孟镇', '4', '882');
INSERT INTO `tp_region` VALUES ('893', '增村镇', '4', '882');
INSERT INTO `tp_region` VALUES ('894', '小常安镇', '4', '882');
INSERT INTO `tp_region` VALUES ('895', '前西关镇', '4', '882');
INSERT INTO `tp_region` VALUES ('896', '九门回族乡', '4', '882');
INSERT INTO `tp_region` VALUES ('897', '石家庄经济技术开发区虚拟乡', '4', '882');
INSERT INTO `tp_region` VALUES ('898', '晋州市', '3', '637');
INSERT INTO `tp_region` VALUES ('899', '晋州镇', '4', '898');
INSERT INTO `tp_region` VALUES ('900', '总十庄镇', '4', '898');
INSERT INTO `tp_region` VALUES ('901', '营里镇', '4', '898');
INSERT INTO `tp_region` VALUES ('902', '桃园镇', '4', '898');
INSERT INTO `tp_region` VALUES ('903', '东卓宿镇', '4', '898');
INSERT INTO `tp_region` VALUES ('904', '马于镇', '4', '898');
INSERT INTO `tp_region` VALUES ('905', '小樵镇', '4', '898');
INSERT INTO `tp_region` VALUES ('906', '槐树镇', '4', '898');
INSERT INTO `tp_region` VALUES ('907', '东里庄乡', '4', '898');
INSERT INTO `tp_region` VALUES ('908', '周家庄乡', '4', '898');
INSERT INTO `tp_region` VALUES ('909', '新乐市', '3', '637');
INSERT INTO `tp_region` VALUES ('910', '长寿街道', '4', '909');
INSERT INTO `tp_region` VALUES ('911', '化皮镇', '4', '909');
INSERT INTO `tp_region` VALUES ('912', '承安镇', '4', '909');
INSERT INTO `tp_region` VALUES ('913', '正莫镇', '4', '909');
INSERT INTO `tp_region` VALUES ('914', '南大岳镇', '4', '909');
INSERT INTO `tp_region` VALUES ('915', '杜固镇', '4', '909');
INSERT INTO `tp_region` VALUES ('916', '邯邰镇', '4', '909');
INSERT INTO `tp_region` VALUES ('917', '东王镇', '4', '909');
INSERT INTO `tp_region` VALUES ('918', '马头铺镇', '4', '909');
INSERT INTO `tp_region` VALUES ('919', '协神乡', '4', '909');
INSERT INTO `tp_region` VALUES ('920', '木村乡', '4', '909');
INSERT INTO `tp_region` VALUES ('921', '彭家庄乡', '4', '909');
INSERT INTO `tp_region` VALUES ('922', '鹿泉市', '3', '637');
INSERT INTO `tp_region` VALUES ('923', '获鹿镇', '4', '922');
INSERT INTO `tp_region` VALUES ('924', '铜冶镇', '4', '922');
INSERT INTO `tp_region` VALUES ('925', '寺家庄镇', '4', '922');
INSERT INTO `tp_region` VALUES ('926', '上庄镇', '4', '922');
INSERT INTO `tp_region` VALUES ('927', '李村镇', '4', '922');
INSERT INTO `tp_region` VALUES ('928', '宜安镇', '4', '922');
INSERT INTO `tp_region` VALUES ('929', '黄壁庄镇', '4', '922');
INSERT INTO `tp_region` VALUES ('930', '大河镇', '4', '922');
INSERT INTO `tp_region` VALUES ('931', '石井乡', '4', '922');
INSERT INTO `tp_region` VALUES ('932', '白鹿泉乡', '4', '922');
INSERT INTO `tp_region` VALUES ('933', '上寨乡', '4', '922');
INSERT INTO `tp_region` VALUES ('934', '山尹村乡', '4', '922');
INSERT INTO `tp_region` VALUES ('935', '高新技术产业园区虚拟乡', '4', '922');
INSERT INTO `tp_region` VALUES ('936', '唐山市', '2', '636');
INSERT INTO `tp_region` VALUES ('937', '市辖区', '3', '936');
INSERT INTO `tp_region` VALUES ('938', '路南区', '3', '936');
INSERT INTO `tp_region` VALUES ('939', '学院南路', '4', '938');
INSERT INTO `tp_region` VALUES ('940', '友谊', '4', '938');
INSERT INTO `tp_region` VALUES ('941', '广场', '4', '938');
INSERT INTO `tp_region` VALUES ('942', '永红桥街道', '4', '938');
INSERT INTO `tp_region` VALUES ('943', '小山街道', '4', '938');
INSERT INTO `tp_region` VALUES ('944', '文北', '4', '938');
INSERT INTO `tp_region` VALUES ('945', '钱营', '4', '938');
INSERT INTO `tp_region` VALUES ('946', '芦台开发区海北镇', '4', '938');
INSERT INTO `tp_region` VALUES ('947', '汉沽管理区汉丰镇', '4', '938');
INSERT INTO `tp_region` VALUES ('948', '女织寨乡', '4', '938');
INSERT INTO `tp_region` VALUES ('949', '芦台开发区街道', '4', '938');
INSERT INTO `tp_region` VALUES ('950', '汉沽管理区兴农', '4', '938');
INSERT INTO `tp_region` VALUES ('951', '汉沽管理区振兴街道', '4', '938');
INSERT INTO `tp_region` VALUES ('952', '路北区', '3', '936');
INSERT INTO `tp_region` VALUES ('953', '乔屯街道', '4', '952');
INSERT INTO `tp_region` VALUES ('954', '文化路街道', '4', '952');
INSERT INTO `tp_region` VALUES ('955', '钓鱼台街道', '4', '952');
INSERT INTO `tp_region` VALUES ('956', '东新村街道', '4', '952');
INSERT INTO `tp_region` VALUES ('957', '缸窑街道', '4', '952');
INSERT INTO `tp_region` VALUES ('958', '机场路街道', '4', '952');
INSERT INTO `tp_region` VALUES ('959', '河北路街道', '4', '952');
INSERT INTO `tp_region` VALUES ('960', '龙东街道', '4', '952');
INSERT INTO `tp_region` VALUES ('961', '大里街道', '4', '952');
INSERT INTO `tp_region` VALUES ('962', '光明街道', '4', '952');
INSERT INTO `tp_region` VALUES ('963', '果园乡', '4', '952');
INSERT INTO `tp_region` VALUES ('964', '河北唐山高新技术产业园区', '4', '952');
INSERT INTO `tp_region` VALUES ('965', '古冶区', '3', '936');
INSERT INTO `tp_region` VALUES ('966', '林西街道', '4', '965');
INSERT INTO `tp_region` VALUES ('967', '唐家庄街道', '4', '965');
INSERT INTO `tp_region` VALUES ('968', '古冶街道', '4', '965');
INSERT INTO `tp_region` VALUES ('969', '赵各庄街道', '4', '965');
INSERT INTO `tp_region` VALUES ('970', '吕家坨街道', '4', '965');
INSERT INTO `tp_region` VALUES ('971', '南范各庄街道', '4', '965');
INSERT INTO `tp_region` VALUES ('972', '卑家店乡', '4', '965');
INSERT INTO `tp_region` VALUES ('973', '王辇庄乡', '4', '965');
INSERT INTO `tp_region` VALUES ('974', '习家套乡', '4', '965');
INSERT INTO `tp_region` VALUES ('975', '大庄坨乡', '4', '965');
INSERT INTO `tp_region` VALUES ('976', '范各庄乡', '4', '965');
INSERT INTO `tp_region` VALUES ('977', '开平区', '3', '936');
INSERT INTO `tp_region` VALUES ('978', '马家沟', '4', '977');
INSERT INTO `tp_region` VALUES ('979', '开平', '4', '977');
INSERT INTO `tp_region` VALUES ('980', '税务庄', '4', '977');
INSERT INTO `tp_region` VALUES ('981', '陡电', '4', '977');
INSERT INTO `tp_region` VALUES ('982', '荆各庄', '4', '977');
INSERT INTO `tp_region` VALUES ('983', '开平镇', '4', '977');
INSERT INTO `tp_region` VALUES ('984', '栗园镇', '4', '977');
INSERT INTO `tp_region` VALUES ('985', '越河乡', '4', '977');
INSERT INTO `tp_region` VALUES ('986', '双桥乡', '4', '977');
INSERT INTO `tp_region` VALUES ('987', '郑庄子乡', '4', '977');
INSERT INTO `tp_region` VALUES ('988', '洼里乡', '4', '977');
INSERT INTO `tp_region` VALUES ('989', '丰南区', '3', '936');
INSERT INTO `tp_region` VALUES ('990', '稻地镇', '4', '989');
INSERT INTO `tp_region` VALUES ('991', '小集镇', '4', '989');
INSERT INTO `tp_region` VALUES ('992', '黄各庄镇', '4', '989');
INSERT INTO `tp_region` VALUES ('993', '西葛镇', '4', '989');
INSERT INTO `tp_region` VALUES ('994', '大新庄镇', '4', '989');
INSERT INTO `tp_region` VALUES ('995', '钱营镇', '4', '989');
INSERT INTO `tp_region` VALUES ('996', '唐坊镇', '4', '989');
INSERT INTO `tp_region` VALUES ('997', '王兰庄镇', '4', '989');
INSERT INTO `tp_region` VALUES ('998', '柳树酄镇', '4', '989');
INSERT INTO `tp_region` VALUES ('999', '黑沿子镇', '4', '989');
INSERT INTO `tp_region` VALUES ('1000', '滨海镇', '4', '989');
INSERT INTO `tp_region` VALUES ('1001', '丰南镇', '4', '989');
INSERT INTO `tp_region` VALUES ('1002', '大齐镇', '4', '989');
INSERT INTO `tp_region` VALUES ('1003', '南孙庄乡', '4', '989');
INSERT INTO `tp_region` VALUES ('1004', '东田庄乡', '4', '989');
INSERT INTO `tp_region` VALUES ('1005', '尖字沽乡', '4', '989');
INSERT INTO `tp_region` VALUES ('1006', '河北唐山南堡经济开发区', '4', '989');
INSERT INTO `tp_region` VALUES ('1007', '丰润区', '3', '936');
INSERT INTO `tp_region` VALUES ('1008', '太平路', '4', '1007');
INSERT INTO `tp_region` VALUES ('1009', '燕山路', '4', '1007');
INSERT INTO `tp_region` VALUES ('1010', '浭阳', '4', '1007');
INSERT INTO `tp_region` VALUES ('1011', '丰润镇', '4', '1007');
INSERT INTO `tp_region` VALUES ('1012', '老庄子镇', '4', '1007');
INSERT INTO `tp_region` VALUES ('1013', '任各庄镇', '4', '1007');
INSERT INTO `tp_region` VALUES ('1014', '左家坞镇', '4', '1007');
INSERT INTO `tp_region` VALUES ('1015', '泉河头镇', '4', '1007');
INSERT INTO `tp_region` VALUES ('1016', '王官营镇', '4', '1007');
INSERT INTO `tp_region` VALUES ('1017', '火石营镇', '4', '1007');
INSERT INTO `tp_region` VALUES ('1018', '韩城镇', '4', '1007');
INSERT INTO `tp_region` VALUES ('1019', '岔河镇', '4', '1007');
INSERT INTO `tp_region` VALUES ('1020', '新军屯镇', '4', '1007');
INSERT INTO `tp_region` VALUES ('1021', '小张各庄镇', '4', '1007');
INSERT INTO `tp_region` VALUES ('1022', '丰登坞镇', '4', '1007');
INSERT INTO `tp_region` VALUES ('1023', '李钊庄镇', '4', '1007');
INSERT INTO `tp_region` VALUES ('1024', '白官屯镇', '4', '1007');
INSERT INTO `tp_region` VALUES ('1025', '石各庄镇', '4', '1007');
INSERT INTO `tp_region` VALUES ('1026', '沙流河镇', '4', '1007');
INSERT INTO `tp_region` VALUES ('1027', '七树庄镇', '4', '1007');
INSERT INTO `tp_region` VALUES ('1028', '杨官林镇', '4', '1007');
INSERT INTO `tp_region` VALUES ('1029', '姜家营乡', '4', '1007');
INSERT INTO `tp_region` VALUES ('1030', '欢喜庄乡', '4', '1007');
INSERT INTO `tp_region` VALUES ('1031', '银城铺乡', '4', '1007');
INSERT INTO `tp_region` VALUES ('1032', '刘家营乡', '4', '1007');
INSERT INTO `tp_region` VALUES ('1033', '常庄乡', '4', '1007');
INSERT INTO `tp_region` VALUES ('1034', '滦县', '3', '936');
INSERT INTO `tp_region` VALUES ('1035', '城区街道', '4', '1034');
INSERT INTO `tp_region` VALUES ('1036', '滦州镇', '4', '1034');
INSERT INTO `tp_region` VALUES ('1037', '响堂镇', '4', '1034');
INSERT INTO `tp_region` VALUES ('1038', '东安各庄镇', '4', '1034');
INSERT INTO `tp_region` VALUES ('1039', '雷庄镇', '4', '1034');
INSERT INTO `tp_region` VALUES ('1040', '茨榆坨镇', '4', '1034');
INSERT INTO `tp_region` VALUES ('1041', '榛子镇', '4', '1034');
INSERT INTO `tp_region` VALUES ('1042', '杨柳庄镇', '4', '1034');
INSERT INTO `tp_region` VALUES ('1043', '油榨镇', '4', '1034');
INSERT INTO `tp_region` VALUES ('1044', '古马镇', '4', '1034');
INSERT INTO `tp_region` VALUES ('1045', '小马庄镇', '4', '1034');
INSERT INTO `tp_region` VALUES ('1046', '九百户镇', '4', '1034');
INSERT INTO `tp_region` VALUES ('1047', '王店子镇', '4', '1034');
INSERT INTO `tp_region` VALUES ('1048', '滦南县', '3', '936');
INSERT INTO `tp_region` VALUES ('1049', '奔城街道', '4', '1048');
INSERT INTO `tp_region` VALUES ('1050', '奔城镇', '4', '1048');
INSERT INTO `tp_region` VALUES ('1051', '宋道口镇', '4', '1048');
INSERT INTO `tp_region` VALUES ('1052', '长凝镇', '4', '1048');
INSERT INTO `tp_region` VALUES ('1053', '胡各庄镇', '4', '1048');
INSERT INTO `tp_region` VALUES ('1054', '坨里镇', '4', '1048');
INSERT INTO `tp_region` VALUES ('1055', '姚王庄镇', '4', '1048');
INSERT INTO `tp_region` VALUES ('1056', '司各庄镇', '4', '1048');
INSERT INTO `tp_region` VALUES ('1057', '安各庄镇', '4', '1048');
INSERT INTO `tp_region` VALUES ('1058', '扒齿港镇', '4', '1048');
INSERT INTO `tp_region` VALUES ('1059', '程庄镇', '4', '1048');
INSERT INTO `tp_region` VALUES ('1060', '青坨营镇', '4', '1048');
INSERT INTO `tp_region` VALUES ('1061', '柏各庄镇', '4', '1048');
INSERT INTO `tp_region` VALUES ('1062', '柳赞镇', '4', '1048');
INSERT INTO `tp_region` VALUES ('1063', '南堡镇', '4', '1048');
INSERT INTO `tp_region` VALUES ('1064', '方各庄镇', '4', '1048');
INSERT INTO `tp_region` VALUES ('1065', '东黄坨镇', '4', '1048');
INSERT INTO `tp_region` VALUES ('1066', '马城镇', '4', '1048');
INSERT INTO `tp_region` VALUES ('1067', '乐亭县', '3', '936');
INSERT INTO `tp_region` VALUES ('1068', '城区街道', '4', '1067');
INSERT INTO `tp_region` VALUES ('1069', '乐亭镇', '4', '1067');
INSERT INTO `tp_region` VALUES ('1070', '汤家河镇', '4', '1067');
INSERT INTO `tp_region` VALUES ('1071', '胡家坨镇', '4', '1067');
INSERT INTO `tp_region` VALUES ('1072', '王滩镇', '4', '1067');
INSERT INTO `tp_region` VALUES ('1073', '闫各庄镇', '4', '1067');
INSERT INTO `tp_region` VALUES ('1074', '马头营镇', '4', '1067');
INSERT INTO `tp_region` VALUES ('1075', '新寨镇', '4', '1067');
INSERT INTO `tp_region` VALUES ('1076', '汀流河镇', '4', '1067');
INSERT INTO `tp_region` VALUES ('1077', '姜各庄镇', '4', '1067');
INSERT INTO `tp_region` VALUES ('1078', '毛庄乡', '4', '1067');
INSERT INTO `tp_region` VALUES ('1079', '庞各庄乡', '4', '1067');
INSERT INTO `tp_region` VALUES ('1080', '大相各庄乡', '4', '1067');
INSERT INTO `tp_region` VALUES ('1081', '古河乡', '4', '1067');
INSERT INTO `tp_region` VALUES ('1082', '中堡王庄乡', '4', '1067');
INSERT INTO `tp_region` VALUES ('1083', '长芦大清河盐场', '4', '1067');
INSERT INTO `tp_region` VALUES ('1084', '海港区', '4', '1067');
INSERT INTO `tp_region` VALUES ('1085', '迁西县', '3', '936');
INSERT INTO `tp_region` VALUES ('1086', '栗乡街道', '4', '1085');
INSERT INTO `tp_region` VALUES ('1087', '兴城镇', '4', '1085');
INSERT INTO `tp_region` VALUES ('1088', '金厂峪镇', '4', '1085');
INSERT INTO `tp_region` VALUES ('1089', '洒河桥镇', '4', '1085');
INSERT INTO `tp_region` VALUES ('1090', '太平寨镇', '4', '1085');
INSERT INTO `tp_region` VALUES ('1091', '罗家屯镇', '4', '1085');
INSERT INTO `tp_region` VALUES ('1092', '东荒峪镇', '4', '1085');
INSERT INTO `tp_region` VALUES ('1093', '新集镇', '4', '1085');
INSERT INTO `tp_region` VALUES ('1094', '三屯营镇', '4', '1085');
INSERT INTO `tp_region` VALUES ('1095', '滦阳镇', '4', '1085');
INSERT INTO `tp_region` VALUES ('1096', '白庙子乡', '4', '1085');
INSERT INTO `tp_region` VALUES ('1097', '上营乡', '4', '1085');
INSERT INTO `tp_region` VALUES ('1098', '汉儿庄乡', '4', '1085');
INSERT INTO `tp_region` VALUES ('1099', '渔户寨乡', '4', '1085');
INSERT INTO `tp_region` VALUES ('1100', '旧城乡', '4', '1085');
INSERT INTO `tp_region` VALUES ('1101', '尹庄乡', '4', '1085');
INSERT INTO `tp_region` VALUES ('1102', '东莲花院乡', '4', '1085');
INSERT INTO `tp_region` VALUES ('1103', '新庄子乡', '4', '1085');
INSERT INTO `tp_region` VALUES ('1104', '玉田县', '3', '936');
INSERT INTO `tp_region` VALUES ('1105', '玉田镇', '4', '1104');
INSERT INTO `tp_region` VALUES ('1106', '亮甲店镇', '4', '1104');
INSERT INTO `tp_region` VALUES ('1107', '鸦鸿桥镇', '4', '1104');
INSERT INTO `tp_region` VALUES ('1108', '窝洛沽镇', '4', '1104');
INSERT INTO `tp_region` VALUES ('1109', '石臼窝镇', '4', '1104');
INSERT INTO `tp_region` VALUES ('1110', '虹桥镇', '4', '1104');
INSERT INTO `tp_region` VALUES ('1111', '散水头镇', '4', '1104');
INSERT INTO `tp_region` VALUES ('1112', '林南仓镇', '4', '1104');
INSERT INTO `tp_region` VALUES ('1113', '林西镇', '4', '1104');
INSERT INTO `tp_region` VALUES ('1114', '杨家板桥镇', '4', '1104');
INSERT INTO `tp_region` VALUES ('1115', '彩亭桥镇', '4', '1104');
INSERT INTO `tp_region` VALUES ('1116', '孤树镇', '4', '1104');
INSERT INTO `tp_region` VALUES ('1117', '大安镇', '4', '1104');
INSERT INTO `tp_region` VALUES ('1118', '唐自头镇', '4', '1104');
INSERT INTO `tp_region` VALUES ('1119', '郭家屯乡', '4', '1104');
INSERT INTO `tp_region` VALUES ('1120', '林头屯乡', '4', '1104');
INSERT INTO `tp_region` VALUES ('1121', '杨家套乡', '4', '1104');
INSERT INTO `tp_region` VALUES ('1122', '潮洛窝乡', '4', '1104');
INSERT INTO `tp_region` VALUES ('1123', '陈家铺乡', '4', '1104');
INSERT INTO `tp_region` VALUES ('1124', '郭家桥乡', '4', '1104');
INSERT INTO `tp_region` VALUES ('1125', '唐海县', '3', '936');
INSERT INTO `tp_region` VALUES ('1126', '唐海镇', '4', '1125');
INSERT INTO `tp_region` VALUES ('1127', '一农场', '4', '1125');
INSERT INTO `tp_region` VALUES ('1128', '三农场', '4', '1125');
INSERT INTO `tp_region` VALUES ('1129', '四农场', '4', '1125');
INSERT INTO `tp_region` VALUES ('1130', '五农场', '4', '1125');
INSERT INTO `tp_region` VALUES ('1131', '六农场', '4', '1125');
INSERT INTO `tp_region` VALUES ('1132', '七农场', '4', '1125');
INSERT INTO `tp_region` VALUES ('1133', '八农场', '4', '1125');
INSERT INTO `tp_region` VALUES ('1134', '九农场', '4', '1125');
INSERT INTO `tp_region` VALUES ('1135', '十农场', '4', '1125');
INSERT INTO `tp_region` VALUES ('1136', '十一农场', '4', '1125');
INSERT INTO `tp_region` VALUES ('1137', '八里滩养殖场', '4', '1125');
INSERT INTO `tp_region` VALUES ('1138', '十里海养殖场', '4', '1125');
INSERT INTO `tp_region` VALUES ('1139', '曹妃甸工业区', '4', '1125');
INSERT INTO `tp_region` VALUES ('1140', '遵化市', '3', '936');
INSERT INTO `tp_region` VALUES ('1141', '路南街道', '4', '1140');
INSERT INTO `tp_region` VALUES ('1142', '路北街道', '4', '1140');
INSERT INTO `tp_region` VALUES ('1143', '遵化镇', '4', '1140');
INSERT INTO `tp_region` VALUES ('1144', '堡子店镇', '4', '1140');
INSERT INTO `tp_region` VALUES ('1145', '马兰峪镇', '4', '1140');
INSERT INTO `tp_region` VALUES ('1146', '平安城镇', '4', '1140');
INSERT INTO `tp_region` VALUES ('1147', '东新庄镇', '4', '1140');
INSERT INTO `tp_region` VALUES ('1148', '新店子镇', '4', '1140');
INSERT INTO `tp_region` VALUES ('1149', '党峪镇', '4', '1140');
INSERT INTO `tp_region` VALUES ('1150', '地北头镇', '4', '1140');
INSERT INTO `tp_region` VALUES ('1151', '东旧寨镇', '4', '1140');
INSERT INTO `tp_region` VALUES ('1152', '铁厂镇', '4', '1140');
INSERT INTO `tp_region` VALUES ('1153', '苏家洼镇', '4', '1140');
INSERT INTO `tp_region` VALUES ('1154', '建明镇', '4', '1140');
INSERT INTO `tp_region` VALUES ('1155', '石门镇', '4', '1140');
INSERT INTO `tp_region` VALUES ('1156', '西留村乡', '4', '1140');
INSERT INTO `tp_region` VALUES ('1157', '崔家庄乡', '4', '1140');
INSERT INTO `tp_region` VALUES ('1158', '兴旺寨乡', '4', '1140');
INSERT INTO `tp_region` VALUES ('1159', '西下营满族乡', '4', '1140');
INSERT INTO `tp_region` VALUES ('1160', '汤泉满族乡', '4', '1140');
INSERT INTO `tp_region` VALUES ('1161', '东陵满族乡', '4', '1140');
INSERT INTO `tp_region` VALUES ('1162', '刘备寨乡', '4', '1140');
INSERT INTO `tp_region` VALUES ('1163', '团瓢庄乡', '4', '1140');
INSERT INTO `tp_region` VALUES ('1164', '娘娘庄乡', '4', '1140');
INSERT INTO `tp_region` VALUES ('1165', '西三里乡', '4', '1140');
INSERT INTO `tp_region` VALUES ('1166', '候家寨乡', '4', '1140');
INSERT INTO `tp_region` VALUES ('1167', '小厂乡', '4', '1140');
INSERT INTO `tp_region` VALUES ('1168', '迁安市', '3', '936');
INSERT INTO `tp_region` VALUES ('1169', '迁安镇', '4', '1168');
INSERT INTO `tp_region` VALUES ('1170', '夏官营镇', '4', '1168');
INSERT INTO `tp_region` VALUES ('1171', '杨各庄镇', '4', '1168');
INSERT INTO `tp_region` VALUES ('1172', '建昌营镇', '4', '1168');
INSERT INTO `tp_region` VALUES ('1173', '赵店子镇', '4', '1168');
INSERT INTO `tp_region` VALUES ('1174', '野鸡坨镇', '4', '1168');
INSERT INTO `tp_region` VALUES ('1175', '大崔庄镇', '4', '1168');
INSERT INTO `tp_region` VALUES ('1176', '杨店子镇', '4', '1168');
INSERT INTO `tp_region` VALUES ('1177', '蔡园镇', '4', '1168');
INSERT INTO `tp_region` VALUES ('1178', '马兰庄镇', '4', '1168');
INSERT INTO `tp_region` VALUES ('1179', '沙河驿镇', '4', '1168');
INSERT INTO `tp_region` VALUES ('1180', '木厂口镇', '4', '1168');
INSERT INTO `tp_region` VALUES ('1181', '扣庄乡', '4', '1168');
INSERT INTO `tp_region` VALUES ('1182', '彭店子乡', '4', '1168');
INSERT INTO `tp_region` VALUES ('1183', '上射雁庄乡', '4', '1168');
INSERT INTO `tp_region` VALUES ('1184', '闫家店乡', '4', '1168');
INSERT INTO `tp_region` VALUES ('1185', '五重安乡', '4', '1168');
INSERT INTO `tp_region` VALUES ('1186', '大五里乡', '4', '1168');
INSERT INTO `tp_region` VALUES ('1187', '太平庄乡', '4', '1168');
INSERT INTO `tp_region` VALUES ('1188', '秦皇岛市', '2', '636');
INSERT INTO `tp_region` VALUES ('1189', '市辖区', '3', '1188');
INSERT INTO `tp_region` VALUES ('1190', '海港区', '3', '1188');
INSERT INTO `tp_region` VALUES ('1191', '文化路街道', '4', '1190');
INSERT INTO `tp_region` VALUES ('1192', '海滨路街道', '4', '1190');
INSERT INTO `tp_region` VALUES ('1193', '北环路街道', '4', '1190');
INSERT INTO `tp_region` VALUES ('1194', '建设大街街道', '4', '1190');
INSERT INTO `tp_region` VALUES ('1195', '河东街道', '4', '1190');
INSERT INTO `tp_region` VALUES ('1196', '西港路街道', '4', '1190');
INSERT INTO `tp_region` VALUES ('1197', '燕山大街街道', '4', '1190');
INSERT INTO `tp_region` VALUES ('1198', '港城大街街道', '4', '1190');
INSERT INTO `tp_region` VALUES ('1199', '东环路街道', '4', '1190');
INSERT INTO `tp_region` VALUES ('1200', '白塔岭街道', '4', '1190');
INSERT INTO `tp_region` VALUES ('1201', '秦皇岛经济技术开发区珠江道街道', '4', '1190');
INSERT INTO `tp_region` VALUES ('1202', '东港镇', '4', '1190');
INSERT INTO `tp_region` VALUES ('1203', '海港镇', '4', '1190');
INSERT INTO `tp_region` VALUES ('1204', '西港镇', '4', '1190');
INSERT INTO `tp_region` VALUES ('1205', '海阳镇', '4', '1190');
INSERT INTO `tp_region` VALUES ('1206', '北港镇', '4', '1190');
INSERT INTO `tp_region` VALUES ('1207', '秦皇岛经济技术开发区', '4', '1190');
INSERT INTO `tp_region` VALUES ('1208', '山海关区', '3', '1188');
INSERT INTO `tp_region` VALUES ('1209', '南关街道', '4', '1208');
INSERT INTO `tp_region` VALUES ('1210', '东街街道', '4', '1208');
INSERT INTO `tp_region` VALUES ('1211', '西街街道', '4', '1208');
INSERT INTO `tp_region` VALUES ('1212', '路南街道', '4', '1208');
INSERT INTO `tp_region` VALUES ('1213', '船厂路街道', '4', '1208');
INSERT INTO `tp_region` VALUES ('1214', '第一关镇', '4', '1208');
INSERT INTO `tp_region` VALUES ('1215', '石河镇', '4', '1208');
INSERT INTO `tp_region` VALUES ('1216', '孟姜镇', '4', '1208');
INSERT INTO `tp_region` VALUES ('1217', '渤海乡', '4', '1208');
INSERT INTO `tp_region` VALUES ('1218', '北戴河区', '3', '1188');
INSERT INTO `tp_region` VALUES ('1219', '西山街道', '4', '1218');
INSERT INTO `tp_region` VALUES ('1220', '东山街道', '4', '1218');
INSERT INTO `tp_region` VALUES ('1221', '海滨镇', '4', '1218');
INSERT INTO `tp_region` VALUES ('1222', '戴河镇', '4', '1218');
INSERT INTO `tp_region` VALUES ('1223', '青龙满族自治县', '3', '1188');
INSERT INTO `tp_region` VALUES ('1224', '青龙镇', '4', '1223');
INSERT INTO `tp_region` VALUES ('1225', '祖山镇', '4', '1223');
INSERT INTO `tp_region` VALUES ('1226', '木头凳镇', '4', '1223');
INSERT INTO `tp_region` VALUES ('1227', '双山子镇', '4', '1223');
INSERT INTO `tp_region` VALUES ('1228', '马圈子镇', '4', '1223');
INSERT INTO `tp_region` VALUES ('1229', '肖营子镇', '4', '1223');
INSERT INTO `tp_region` VALUES ('1230', '凤凰山乡', '4', '1223');
INSERT INTO `tp_region` VALUES ('1231', '龙王庙乡', '4', '1223');
INSERT INTO `tp_region` VALUES ('1232', '三星口乡', '4', '1223');
INSERT INTO `tp_region` VALUES ('1233', '干沟乡', '4', '1223');
INSERT INTO `tp_region` VALUES ('1234', '大巫岚乡', '4', '1223');
INSERT INTO `tp_region` VALUES ('1235', '土门子乡', '4', '1223');
INSERT INTO `tp_region` VALUES ('1236', '大石岭乡', '4', '1223');
INSERT INTO `tp_region` VALUES ('1237', '隔河头乡', '4', '1223');
INSERT INTO `tp_region` VALUES ('1238', '官场乡', '4', '1223');
INSERT INTO `tp_region` VALUES ('1239', '茨榆山乡', '4', '1223');
INSERT INTO `tp_region` VALUES ('1240', '平方子乡', '4', '1223');
INSERT INTO `tp_region` VALUES ('1241', '安子岭乡', '4', '1223');
INSERT INTO `tp_region` VALUES ('1242', '朱杖子乡', '4', '1223');
INSERT INTO `tp_region` VALUES ('1243', '草碾乡', '4', '1223');
INSERT INTO `tp_region` VALUES ('1244', '七道河乡', '4', '1223');
INSERT INTO `tp_region` VALUES ('1245', '八道河乡', '4', '1223');
INSERT INTO `tp_region` VALUES ('1246', '娄杖子乡', '4', '1223');
INSERT INTO `tp_region` VALUES ('1247', '三拨子乡', '4', '1223');
INSERT INTO `tp_region` VALUES ('1248', '凉水河乡', '4', '1223');
INSERT INTO `tp_region` VALUES ('1249', '昌黎县', '3', '1188');
INSERT INTO `tp_region` VALUES ('1250', '昌黎镇', '4', '1249');
INSERT INTO `tp_region` VALUES ('1251', '靖安镇', '4', '1249');
INSERT INTO `tp_region` VALUES ('1252', '安山镇', '4', '1249');
INSERT INTO `tp_region` VALUES ('1253', '龙家店镇', '4', '1249');
INSERT INTO `tp_region` VALUES ('1254', '泥井镇', '4', '1249');
INSERT INTO `tp_region` VALUES ('1255', '大蒲河镇', '4', '1249');
INSERT INTO `tp_region` VALUES ('1256', '新集镇', '4', '1249');
INSERT INTO `tp_region` VALUES ('1257', '刘台庄镇', '4', '1249');
INSERT INTO `tp_region` VALUES ('1258', '茹荷镇', '4', '1249');
INSERT INTO `tp_region` VALUES ('1259', '朱各庄镇', '4', '1249');
INSERT INTO `tp_region` VALUES ('1260', '团林乡', '4', '1249');
INSERT INTO `tp_region` VALUES ('1261', '葛条港乡', '4', '1249');
INSERT INTO `tp_region` VALUES ('1262', '马坨店乡', '4', '1249');
INSERT INTO `tp_region` VALUES ('1263', '荒佃庄乡', '4', '1249');
INSERT INTO `tp_region` VALUES ('1264', '两山乡', '4', '1249');
INSERT INTO `tp_region` VALUES ('1265', '十里铺乡', '4', '1249');
INSERT INTO `tp_region` VALUES ('1266', '抚宁县', '3', '1188');
INSERT INTO `tp_region` VALUES ('1267', '抚宁镇', '4', '1266');
INSERT INTO `tp_region` VALUES ('1268', '留守营镇', '4', '1266');
INSERT INTO `tp_region` VALUES ('1269', '榆关镇', '4', '1266');
INSERT INTO `tp_region` VALUES ('1270', '牛头崖镇', '4', '1266');
INSERT INTO `tp_region` VALUES ('1271', '石门寨镇', '4', '1266');
INSERT INTO `tp_region` VALUES ('1272', '台营镇', '4', '1266');
INSERT INTO `tp_region` VALUES ('1273', '大新寨镇', '4', '1266');
INSERT INTO `tp_region` VALUES ('1274', '驻操营镇', '4', '1266');
INSERT INTO `tp_region` VALUES ('1275', '茶棚乡', '4', '1266');
INSERT INTO `tp_region` VALUES ('1276', '杜庄乡', '4', '1266');
INSERT INTO `tp_region` VALUES ('1277', '深河乡', '4', '1266');
INSERT INTO `tp_region` VALUES ('1278', '卢龙县', '3', '1188');
INSERT INTO `tp_region` VALUES ('1279', '卢龙镇', '4', '1278');
INSERT INTO `tp_region` VALUES ('1280', '潘庄镇', '4', '1278');
INSERT INTO `tp_region` VALUES ('1281', '燕河营镇', '4', '1278');
INSERT INTO `tp_region` VALUES ('1282', '双望镇', '4', '1278');
INSERT INTO `tp_region` VALUES ('1283', '刘田各庄镇', '4', '1278');
INSERT INTO `tp_region` VALUES ('1284', '石门镇', '4', '1278');
INSERT INTO `tp_region` VALUES ('1285', '下寨乡', '4', '1278');
INSERT INTO `tp_region` VALUES ('1286', '刘家营乡', '4', '1278');
INSERT INTO `tp_region` VALUES ('1287', '陈官屯乡', '4', '1278');
INSERT INTO `tp_region` VALUES ('1288', '印庄乡', '4', '1278');
INSERT INTO `tp_region` VALUES ('1289', '蛤泊乡', '4', '1278');
INSERT INTO `tp_region` VALUES ('1290', '木井乡', '4', '1278');
INSERT INTO `tp_region` VALUES ('1291', '邯郸市', '2', '636');
INSERT INTO `tp_region` VALUES ('1292', '市辖区', '3', '1291');
INSERT INTO `tp_region` VALUES ('1293', '邯山区', '3', '1291');
INSERT INTO `tp_region` VALUES ('1294', '火磨街道', '4', '1293');
INSERT INTO `tp_region` VALUES ('1295', '陵园路街道', '4', '1293');
INSERT INTO `tp_region` VALUES ('1296', '光明路街道', '4', '1293');
INSERT INTO `tp_region` VALUES ('1297', '滏东街道', '4', '1293');
INSERT INTO `tp_region` VALUES ('1298', '罗城头街道', '4', '1293');
INSERT INTO `tp_region` VALUES ('1299', '渚河路街道', '4', '1293');
INSERT INTO `tp_region` VALUES ('1300', '浴新南街道', '4', '1293');
INSERT INTO `tp_region` VALUES ('1301', '农林路街道', '4', '1293');
INSERT INTO `tp_region` VALUES ('1302', '贸东街道', '4', '1293');
INSERT INTO `tp_region` VALUES ('1303', '贸西街道', '4', '1293');
INSERT INTO `tp_region` VALUES ('1304', '马头镇', '4', '1293');
INSERT INTO `tp_region` VALUES ('1305', '北张庄镇', '4', '1293');
INSERT INTO `tp_region` VALUES ('1306', '马庄乡', '4', '1293');
INSERT INTO `tp_region` VALUES ('1307', '丛台区', '3', '1291');
INSERT INTO `tp_region` VALUES ('1308', '丛台西街道', '4', '1307');
INSERT INTO `tp_region` VALUES ('1309', '联纺西街道', '4', '1307');
INSERT INTO `tp_region` VALUES ('1310', '联纺东街道', '4', '1307');
INSERT INTO `tp_region` VALUES ('1311', '光明桥街道', '4', '1307');
INSERT INTO `tp_region` VALUES ('1312', '丛台东街道', '4', '1307');
INSERT INTO `tp_region` VALUES ('1313', '四季青街道', '4', '1307');
INSERT INTO `tp_region` VALUES ('1314', '和平街道', '4', '1307');
INSERT INTO `tp_region` VALUES ('1315', '中华街道', '4', '1307');
INSERT INTO `tp_region` VALUES ('1316', '人民路街道', '4', '1307');
INSERT INTO `tp_region` VALUES ('1317', '柳林桥街道', '4', '1307');
INSERT INTO `tp_region` VALUES ('1318', '苏曹乡', '4', '1307');
INSERT INTO `tp_region` VALUES ('1319', '复兴区', '3', '1291');
INSERT INTO `tp_region` VALUES ('1320', '胜利桥街道', '4', '1319');
INSERT INTO `tp_region` VALUES ('1321', '百家村街道', '4', '1319');
INSERT INTO `tp_region` VALUES ('1322', '铁路大院街道', '4', '1319');
INSERT INTO `tp_region` VALUES ('1323', '化林路街道', '4', '1319');
INSERT INTO `tp_region` VALUES ('1324', '庞村街道', '4', '1319');
INSERT INTO `tp_region` VALUES ('1325', '二六七二街道', '4', '1319');
INSERT INTO `tp_region` VALUES ('1326', '石化街道', '4', '1319');
INSERT INTO `tp_region` VALUES ('1327', '彭家寨乡', '4', '1319');
INSERT INTO `tp_region` VALUES ('1328', '华北冶金建设公司', '4', '1319');
INSERT INTO `tp_region` VALUES ('1329', '峰峰矿区', '3', '1291');
INSERT INTO `tp_region` VALUES ('1330', '临水镇', '4', '1329');
INSERT INTO `tp_region` VALUES ('1331', '峰峰镇', '4', '1329');
INSERT INTO `tp_region` VALUES ('1332', '新坡镇', '4', '1329');
INSERT INTO `tp_region` VALUES ('1333', '大社镇', '4', '1329');
INSERT INTO `tp_region` VALUES ('1334', '和村镇', '4', '1329');
INSERT INTO `tp_region` VALUES ('1335', '义井镇', '4', '1329');
INSERT INTO `tp_region` VALUES ('1336', '彭城镇', '4', '1329');
INSERT INTO `tp_region` VALUES ('1337', '界城镇', '4', '1329');
INSERT INTO `tp_region` VALUES ('1338', '大峪镇', '4', '1329');
INSERT INTO `tp_region` VALUES ('1339', '邯郸县', '3', '1291');
INSERT INTO `tp_region` VALUES ('1340', '尚璧镇', '4', '1339');
INSERT INTO `tp_region` VALUES ('1341', '黄粱梦镇', '4', '1339');
INSERT INTO `tp_region` VALUES ('1342', '河沙镇镇', '4', '1339');
INSERT INTO `tp_region` VALUES ('1343', '户村镇', '4', '1339');
INSERT INTO `tp_region` VALUES ('1344', '南堡乡', '4', '1339');
INSERT INTO `tp_region` VALUES ('1345', '南吕固乡', '4', '1339');
INSERT INTO `tp_region` VALUES ('1346', '兼庄乡', '4', '1339');
INSERT INTO `tp_region` VALUES ('1347', '代召乡', '4', '1339');
INSERT INTO `tp_region` VALUES ('1348', '康庄乡', '4', '1339');
INSERT INTO `tp_region` VALUES ('1349', '三陵乡', '4', '1339');
INSERT INTO `tp_region` VALUES ('1350', '临漳县', '3', '1291');
INSERT INTO `tp_region` VALUES ('1351', '临漳镇', '4', '1350');
INSERT INTO `tp_region` VALUES ('1352', '南东坊镇', '4', '1350');
INSERT INTO `tp_region` VALUES ('1353', '孙陶集镇', '4', '1350');
INSERT INTO `tp_region` VALUES ('1354', '柳园镇', '4', '1350');
INSERT INTO `tp_region` VALUES ('1355', '称勾集镇', '4', '1350');
INSERT INTO `tp_region` VALUES ('1356', '狄邱乡', '4', '1350');
INSERT INTO `tp_region` VALUES ('1357', '张村集乡', '4', '1350');
INSERT INTO `tp_region` VALUES ('1358', '西羊羔乡', '4', '1350');
INSERT INTO `tp_region` VALUES ('1359', '香菜营乡', '4', '1350');
INSERT INTO `tp_region` VALUES ('1360', '杜村集乡', '4', '1350');
INSERT INTO `tp_region` VALUES ('1361', '章里集乡', '4', '1350');
INSERT INTO `tp_region` VALUES ('1362', '习文乡', '4', '1350');
INSERT INTO `tp_region` VALUES ('1363', '砖寨营乡', '4', '1350');
INSERT INTO `tp_region` VALUES ('1364', '柏鹤集乡', '4', '1350');
INSERT INTO `tp_region` VALUES ('1365', '成安县', '3', '1291');
INSERT INTO `tp_region` VALUES ('1366', '成安镇', '4', '1365');
INSERT INTO `tp_region` VALUES ('1367', '商城镇', '4', '1365');
INSERT INTO `tp_region` VALUES ('1368', '漳河店镇', '4', '1365');
INSERT INTO `tp_region` VALUES ('1369', '李家疃镇', '4', '1365');
INSERT INTO `tp_region` VALUES ('1370', '辛义乡', '4', '1365');
INSERT INTO `tp_region` VALUES ('1371', '柏寺营乡', '4', '1365');
INSERT INTO `tp_region` VALUES ('1372', '道东堡乡', '4', '1365');
INSERT INTO `tp_region` VALUES ('1373', '北乡义乡', '4', '1365');
INSERT INTO `tp_region` VALUES ('1374', '长巷乡', '4', '1365');
INSERT INTO `tp_region` VALUES ('1375', '大名县', '3', '1291');
INSERT INTO `tp_region` VALUES ('1376', '大名镇', '4', '1375');
INSERT INTO `tp_region` VALUES ('1377', '杨桥镇', '4', '1375');
INSERT INTO `tp_region` VALUES ('1378', '万堤镇', '4', '1375');
INSERT INTO `tp_region` VALUES ('1379', '龙王庙镇', '4', '1375');
INSERT INTO `tp_region` VALUES ('1380', '束馆镇', '4', '1375');
INSERT INTO `tp_region` VALUES ('1381', '金滩镇', '4', '1375');
INSERT INTO `tp_region` VALUES ('1382', '沙圪塔乡', '4', '1375');
INSERT INTO `tp_region` VALUES ('1383', '王村乡', '4', '1375');
INSERT INTO `tp_region` VALUES ('1384', '铺上乡', '4', '1375');
INSERT INTO `tp_region` VALUES ('1385', '黄金堤乡', '4', '1375');
INSERT INTO `tp_region` VALUES ('1386', '大街乡', '4', '1375');
INSERT INTO `tp_region` VALUES ('1387', '旧治乡', '4', '1375');
INSERT INTO `tp_region` VALUES ('1388', '西未庄乡', '4', '1375');
INSERT INTO `tp_region` VALUES ('1389', '孙甘店乡', '4', '1375');
INSERT INTO `tp_region` VALUES ('1390', '西付集乡', '4', '1375');
INSERT INTO `tp_region` VALUES ('1391', '埝头乡', '4', '1375');
INSERT INTO `tp_region` VALUES ('1392', '北峰乡', '4', '1375');
INSERT INTO `tp_region` VALUES ('1393', '张集乡', '4', '1375');
INSERT INTO `tp_region` VALUES ('1394', '红庙乡', '4', '1375');
INSERT INTO `tp_region` VALUES ('1395', '营镇回族乡', '4', '1375');
INSERT INTO `tp_region` VALUES ('1396', '涉县', '3', '1291');
INSERT INTO `tp_region` VALUES ('1397', '涉城镇', '4', '1396');
INSERT INTO `tp_region` VALUES ('1398', '河南店镇', '4', '1396');
INSERT INTO `tp_region` VALUES ('1399', '索堡镇', '4', '1396');
INSERT INTO `tp_region` VALUES ('1400', '西戌镇', '4', '1396');
INSERT INTO `tp_region` VALUES ('1401', '井店镇', '4', '1396');
INSERT INTO `tp_region` VALUES ('1402', '更乐镇', '4', '1396');
INSERT INTO `tp_region` VALUES ('1403', '固新镇', '4', '1396');
INSERT INTO `tp_region` VALUES ('1404', '西达镇', '4', '1396');
INSERT INTO `tp_region` VALUES ('1405', '偏城镇', '4', '1396');
INSERT INTO `tp_region` VALUES ('1406', '神头乡', '4', '1396');
INSERT INTO `tp_region` VALUES ('1407', '辽城乡', '4', '1396');
INSERT INTO `tp_region` VALUES ('1408', '偏店乡', '4', '1396');
INSERT INTO `tp_region` VALUES ('1409', '龙虎乡', '4', '1396');
INSERT INTO `tp_region` VALUES ('1410', '木井乡', '4', '1396');
INSERT INTO `tp_region` VALUES ('1411', '关防乡', '4', '1396');
INSERT INTO `tp_region` VALUES ('1412', '合漳乡', '4', '1396');
INSERT INTO `tp_region` VALUES ('1413', '鹿头乡', '4', '1396');
INSERT INTO `tp_region` VALUES ('1414', '磁县', '3', '1291');
INSERT INTO `tp_region` VALUES ('1415', '磁州镇', '4', '1414');
INSERT INTO `tp_region` VALUES ('1416', '高臾镇', '4', '1414');
INSERT INTO `tp_region` VALUES ('1417', '西光禄镇', '4', '1414');
INSERT INTO `tp_region` VALUES ('1418', '讲武城镇', '4', '1414');
INSERT INTO `tp_region` VALUES ('1419', '岳城镇', '4', '1414');
INSERT INTO `tp_region` VALUES ('1420', '观台镇', '4', '1414');
INSERT INTO `tp_region` VALUES ('1421', '林坦镇', '4', '1414');
INSERT INTO `tp_region` VALUES ('1422', '白土镇', '4', '1414');
INSERT INTO `tp_region` VALUES ('1423', '黄沙镇', '4', '1414');
INSERT INTO `tp_region` VALUES ('1424', '路村营乡', '4', '1414');
INSERT INTO `tp_region` VALUES ('1425', '西固义乡', '4', '1414');
INSERT INTO `tp_region` VALUES ('1426', '辛庄营乡', '4', '1414');
INSERT INTO `tp_region` VALUES ('1427', '花官营乡', '4', '1414');
INSERT INTO `tp_region` VALUES ('1428', '时村营乡', '4', '1414');
INSERT INTO `tp_region` VALUES ('1429', '南城乡', '4', '1414');
INSERT INTO `tp_region` VALUES ('1430', '台城乡', '4', '1414');
INSERT INTO `tp_region` VALUES ('1431', '陶泉乡', '4', '1414');
INSERT INTO `tp_region` VALUES ('1432', '都党乡', '4', '1414');
INSERT INTO `tp_region` VALUES ('1433', '北贾壁乡', '4', '1414');
INSERT INTO `tp_region` VALUES ('1434', '肥乡县', '3', '1291');
INSERT INTO `tp_region` VALUES ('1435', '肥乡镇', '4', '1434');
INSERT INTO `tp_region` VALUES ('1436', '天台山镇', '4', '1434');
INSERT INTO `tp_region` VALUES ('1437', '大西韩乡', '4', '1434');
INSERT INTO `tp_region` VALUES ('1438', '辛安镇乡', '4', '1434');
INSERT INTO `tp_region` VALUES ('1439', '毛演堡乡', '4', '1434');
INSERT INTO `tp_region` VALUES ('1440', '元固乡', '4', '1434');
INSERT INTO `tp_region` VALUES ('1441', '屯庄营乡', '4', '1434');
INSERT INTO `tp_region` VALUES ('1442', '东漳堡乡', '4', '1434');
INSERT INTO `tp_region` VALUES ('1443', '旧店乡', '4', '1434');
INSERT INTO `tp_region` VALUES ('1444', '永年县', '3', '1291');
INSERT INTO `tp_region` VALUES ('1445', '临洺关镇', '4', '1444');
INSERT INTO `tp_region` VALUES ('1446', '大北汪镇', '4', '1444');
INSERT INTO `tp_region` VALUES ('1447', '张西堡镇', '4', '1444');
INSERT INTO `tp_region` VALUES ('1448', '广府镇', '4', '1444');
INSERT INTO `tp_region` VALUES ('1449', '南沿村镇', '4', '1444');
INSERT INTO `tp_region` VALUES ('1450', '永合会镇', '4', '1444');
INSERT INTO `tp_region` VALUES ('1451', '西苏乡', '4', '1444');
INSERT INTO `tp_region` VALUES ('1452', '界河店乡', '4', '1444');
INSERT INTO `tp_region` VALUES ('1453', '刘营乡', '4', '1444');
INSERT INTO `tp_region` VALUES ('1454', '刘汉乡', '4', '1444');
INSERT INTO `tp_region` VALUES ('1455', '正西乡', '4', '1444');
INSERT INTO `tp_region` VALUES ('1456', '讲武乡', '4', '1444');
INSERT INTO `tp_region` VALUES ('1457', '曲陌乡', '4', '1444');
INSERT INTO `tp_region` VALUES ('1458', '辛庄堡乡', '4', '1444');
INSERT INTO `tp_region` VALUES ('1459', '小龙马乡', '4', '1444');
INSERT INTO `tp_region` VALUES ('1460', '东杨庄乡', '4', '1444');
INSERT INTO `tp_region` VALUES ('1461', '小西堡乡', '4', '1444');
INSERT INTO `tp_region` VALUES ('1462', '西河庄乡', '4', '1444');
INSERT INTO `tp_region` VALUES ('1463', '姚寨乡', '4', '1444');
INSERT INTO `tp_region` VALUES ('1464', '西阳城乡', '4', '1444');
INSERT INTO `tp_region` VALUES ('1465', '邱县', '3', '1291');
INSERT INTO `tp_region` VALUES ('1466', '新马头镇', '4', '1465');
INSERT INTO `tp_region` VALUES ('1467', '邱城镇', '4', '1465');
INSERT INTO `tp_region` VALUES ('1468', '梁二庄乡', '4', '1465');
INSERT INTO `tp_region` VALUES ('1469', '南辛店乡', '4', '1465');
INSERT INTO `tp_region` VALUES ('1470', '香城固乡', '4', '1465');
INSERT INTO `tp_region` VALUES ('1471', '古城营乡', '4', '1465');
INSERT INTO `tp_region` VALUES ('1472', '陈村回族乡', '4', '1465');
INSERT INTO `tp_region` VALUES ('1473', '鸡泽县', '3', '1291');
INSERT INTO `tp_region` VALUES ('1474', '鸡泽镇', '4', '1473');
INSERT INTO `tp_region` VALUES ('1475', '小寨镇', '4', '1473');
INSERT INTO `tp_region` VALUES ('1476', '双塔镇', '4', '1473');
INSERT INTO `tp_region` VALUES ('1477', '浮图店乡', '4', '1473');
INSERT INTO `tp_region` VALUES ('1478', '吴官营乡', '4', '1473');
INSERT INTO `tp_region` VALUES ('1479', '风正乡', '4', '1473');
INSERT INTO `tp_region` VALUES ('1480', '曹庄乡', '4', '1473');
INSERT INTO `tp_region` VALUES ('1481', '广平县', '3', '1291');
INSERT INTO `tp_region` VALUES ('1482', '广平镇', '4', '1481');
INSERT INTO `tp_region` VALUES ('1483', '平固店镇', '4', '1481');
INSERT INTO `tp_region` VALUES ('1484', '双庙乡', '4', '1481');
INSERT INTO `tp_region` VALUES ('1485', '十里铺乡', '4', '1481');
INSERT INTO `tp_region` VALUES ('1486', '南韩村乡', '4', '1481');
INSERT INTO `tp_region` VALUES ('1487', '南阳堡乡', '4', '1481');
INSERT INTO `tp_region` VALUES ('1488', '东张孟乡', '4', '1481');
INSERT INTO `tp_region` VALUES ('1489', '馆陶县', '3', '1291');
INSERT INTO `tp_region` VALUES ('1490', '馆陶镇', '4', '1489');
INSERT INTO `tp_region` VALUES ('1491', '房寨镇', '4', '1489');
INSERT INTO `tp_region` VALUES ('1492', '柴堡镇', '4', '1489');
INSERT INTO `tp_region` VALUES ('1493', '魏僧寨镇', '4', '1489');
INSERT INTO `tp_region` VALUES ('1494', '寿山寺乡', '4', '1489');
INSERT INTO `tp_region` VALUES ('1495', '王桥乡', '4', '1489');
INSERT INTO `tp_region` VALUES ('1496', '南徐村乡', '4', '1489');
INSERT INTO `tp_region` VALUES ('1497', '路桥乡', '4', '1489');
INSERT INTO `tp_region` VALUES ('1498', '魏县', '3', '1291');
INSERT INTO `tp_region` VALUES ('1499', '魏城镇', '4', '1498');
INSERT INTO `tp_region` VALUES ('1500', '德政镇', '4', '1498');
INSERT INTO `tp_region` VALUES ('1501', '北皋镇', '4', '1498');
INSERT INTO `tp_region` VALUES ('1502', '双井镇', '4', '1498');
INSERT INTO `tp_region` VALUES ('1503', '牙里镇', '4', '1498');
INSERT INTO `tp_region` VALUES ('1504', '车往镇', '4', '1498');
INSERT INTO `tp_region` VALUES ('1505', '回隆镇', '4', '1498');
INSERT INTO `tp_region` VALUES ('1506', '东代固乡', '4', '1498');
INSERT INTO `tp_region` VALUES ('1507', '棘针寨乡', '4', '1498');
INSERT INTO `tp_region` VALUES ('1508', '沙口集乡', '4', '1498');
INSERT INTO `tp_region` VALUES ('1509', '野胡拐乡', '4', '1498');
INSERT INTO `tp_region` VALUES ('1510', '仕望集乡', '4', '1498');
INSERT INTO `tp_region` VALUES ('1511', '前大磨乡', '4', '1498');
INSERT INTO `tp_region` VALUES ('1512', '院堡乡', '4', '1498');
INSERT INTO `tp_region` VALUES ('1513', '南双庙乡', '4', '1498');
INSERT INTO `tp_region` VALUES ('1514', '大辛庄乡', '4', '1498');
INSERT INTO `tp_region` VALUES ('1515', '大马村乡', '4', '1498');
INSERT INTO `tp_region` VALUES ('1516', '边马乡', '4', '1498');
INSERT INTO `tp_region` VALUES ('1517', '张二庄乡', '4', '1498');
INSERT INTO `tp_region` VALUES ('1518', '北台头乡', '4', '1498');
INSERT INTO `tp_region` VALUES ('1519', '泊口乡', '4', '1498');
INSERT INTO `tp_region` VALUES ('1520', '曲周县', '3', '1291');
INSERT INTO `tp_region` VALUES ('1521', '曲周镇', '4', '1520');
INSERT INTO `tp_region` VALUES ('1522', '安寨镇', '4', '1520');
INSERT INTO `tp_region` VALUES ('1523', '侯村镇', '4', '1520');
INSERT INTO `tp_region` VALUES ('1524', '河南疃镇', '4', '1520');
INSERT INTO `tp_region` VALUES ('1525', '槐桥乡', '4', '1520');
INSERT INTO `tp_region` VALUES ('1526', '南里岳乡', '4', '1520');
INSERT INTO `tp_region` VALUES ('1527', '白寨乡', '4', '1520');
INSERT INTO `tp_region` VALUES ('1528', '大河道乡', '4', '1520');
INSERT INTO `tp_region` VALUES ('1529', '依庄乡', '4', '1520');
INSERT INTO `tp_region` VALUES ('1530', '第四疃乡', '4', '1520');
INSERT INTO `tp_region` VALUES ('1531', '武安市', '3', '1291');
INSERT INTO `tp_region` VALUES ('1532', '武安镇', '4', '1531');
INSERT INTO `tp_region` VALUES ('1533', '康二城镇', '4', '1531');
INSERT INTO `tp_region` VALUES ('1534', '午汲镇', '4', '1531');
INSERT INTO `tp_region` VALUES ('1535', '磁山镇', '4', '1531');
INSERT INTO `tp_region` VALUES ('1536', '伯延镇', '4', '1531');
INSERT INTO `tp_region` VALUES ('1537', '淑村镇', '4', '1531');
INSERT INTO `tp_region` VALUES ('1538', '大同镇', '4', '1531');
INSERT INTO `tp_region` VALUES ('1539', '邑城镇', '4', '1531');
INSERT INTO `tp_region` VALUES ('1540', '矿山镇', '4', '1531');
INSERT INTO `tp_region` VALUES ('1541', '贺进镇', '4', '1531');
INSERT INTO `tp_region` VALUES ('1542', '阳邑镇', '4', '1531');
INSERT INTO `tp_region` VALUES ('1543', '徘徊镇', '4', '1531');
INSERT INTO `tp_region` VALUES ('1544', '冶陶镇', '4', '1531');
INSERT INTO `tp_region` VALUES ('1545', '上团城乡', '4', '1531');
INSERT INTO `tp_region` VALUES ('1546', '北安庄乡', '4', '1531');
INSERT INTO `tp_region` VALUES ('1547', '北安乐乡', '4', '1531');
INSERT INTO `tp_region` VALUES ('1548', '西土山乡', '4', '1531');
INSERT INTO `tp_region` VALUES ('1549', '西寺庄乡', '4', '1531');
INSERT INTO `tp_region` VALUES ('1550', '活水乡', '4', '1531');
INSERT INTO `tp_region` VALUES ('1551', '石洞乡', '4', '1531');
INSERT INTO `tp_region` VALUES ('1552', '管陶乡', '4', '1531');
INSERT INTO `tp_region` VALUES ('1553', '马家庄乡', '4', '1531');
INSERT INTO `tp_region` VALUES ('1554', '邢台市', '2', '636');
INSERT INTO `tp_region` VALUES ('1555', '市辖区', '3', '1554');
INSERT INTO `tp_region` VALUES ('1556', '桥东区', '3', '1554');
INSERT INTO `tp_region` VALUES ('1557', '南长街街道', '4', '1556');
INSERT INTO `tp_region` VALUES ('1558', '北大街街道', '4', '1556');
INSERT INTO `tp_region` VALUES ('1559', '西大街街道', '4', '1556');
INSERT INTO `tp_region` VALUES ('1560', '西门里街道', '4', '1556');
INSERT INTO `tp_region` VALUES ('1561', '大梁庄乡', '4', '1556');
INSERT INTO `tp_region` VALUES ('1562', '东郭村乡', '4', '1556');
INSERT INTO `tp_region` VALUES ('1563', '市高新技术开发区', '4', '1556');
INSERT INTO `tp_region` VALUES ('1564', '桥西区', '3', '1554');
INSERT INTO `tp_region` VALUES ('1565', '钢铁路街道', '4', '1564');
INSERT INTO `tp_region` VALUES ('1566', '中兴路街道', '4', '1564');
INSERT INTO `tp_region` VALUES ('1567', '达活泉街道', '4', '1564');
INSERT INTO `tp_region` VALUES ('1568', '张宽街道', '4', '1564');
INSERT INTO `tp_region` VALUES ('1569', '章村街道', '4', '1564');
INSERT INTO `tp_region` VALUES ('1570', '南大郭乡', '4', '1564');
INSERT INTO `tp_region` VALUES ('1571', '李村乡', '4', '1564');
INSERT INTO `tp_region` VALUES ('1572', '邢台县', '3', '1554');
INSERT INTO `tp_region` VALUES ('1573', '豫让桥街道', '4', '1572');
INSERT INTO `tp_region` VALUES ('1574', '东汪镇', '4', '1572');
INSERT INTO `tp_region` VALUES ('1575', '王快镇', '4', '1572');
INSERT INTO `tp_region` VALUES ('1576', '祝村镇', '4', '1572');
INSERT INTO `tp_region` VALUES ('1577', '晏家屯镇', '4', '1572');
INSERT INTO `tp_region` VALUES ('1578', '南石门镇', '4', '1572');
INSERT INTO `tp_region` VALUES ('1579', '羊范镇', '4', '1572');
INSERT INTO `tp_region` VALUES ('1580', '皇寺镇', '4', '1572');
INSERT INTO `tp_region` VALUES ('1581', '会宁镇', '4', '1572');
INSERT INTO `tp_region` VALUES ('1582', '西黄村镇', '4', '1572');
INSERT INTO `tp_region` VALUES ('1583', '路罗镇', '4', '1572');
INSERT INTO `tp_region` VALUES ('1584', '将军墓镇', '4', '1572');
INSERT INTO `tp_region` VALUES ('1585', '浆水镇', '4', '1572');
INSERT INTO `tp_region` VALUES ('1586', '宋家庄镇', '4', '1572');
INSERT INTO `tp_region` VALUES ('1587', '太子井乡', '4', '1572');
INSERT INTO `tp_region` VALUES ('1588', '龙泉寺乡', '4', '1572');
INSERT INTO `tp_region` VALUES ('1589', '北小庄乡', '4', '1572');
INSERT INTO `tp_region` VALUES ('1590', '城计头乡', '4', '1572');
INSERT INTO `tp_region` VALUES ('1591', '白岸乡', '4', '1572');
INSERT INTO `tp_region` VALUES ('1592', '冀家村乡', '4', '1572');
INSERT INTO `tp_region` VALUES ('1593', '临城县', '3', '1554');
INSERT INTO `tp_region` VALUES ('1594', '临城镇', '4', '1593');
INSERT INTO `tp_region` VALUES ('1595', '东镇镇', '4', '1593');
INSERT INTO `tp_region` VALUES ('1596', '西竖镇', '4', '1593');
INSERT INTO `tp_region` VALUES ('1597', '郝庄镇', '4', '1593');
INSERT INTO `tp_region` VALUES ('1598', '黑城乡', '4', '1593');
INSERT INTO `tp_region` VALUES ('1599', '鸭鸽营乡', '4', '1593');
INSERT INTO `tp_region` VALUES ('1600', '石城乡', '4', '1593');
INSERT INTO `tp_region` VALUES ('1601', '赵庄乡', '4', '1593');
INSERT INTO `tp_region` VALUES ('1602', '内邱县', '3', '1554');
INSERT INTO `tp_region` VALUES ('1603', '内邱镇', '4', '1602');
INSERT INTO `tp_region` VALUES ('1604', '大孟村镇', '4', '1602');
INSERT INTO `tp_region` VALUES ('1605', '金店镇', '4', '1602');
INSERT INTO `tp_region` VALUES ('1606', '官庄镇', '4', '1602');
INSERT INTO `tp_region` VALUES ('1607', '柳林镇', '4', '1602');
INSERT INTO `tp_region` VALUES ('1608', '五郭店乡', '4', '1602');
INSERT INTO `tp_region` VALUES ('1609', '南赛乡', '4', '1602');
INSERT INTO `tp_region` VALUES ('1610', '獐么乡', '4', '1602');
INSERT INTO `tp_region` VALUES ('1611', '侯家庄乡', '4', '1602');
INSERT INTO `tp_region` VALUES ('1612', '柏乡县', '3', '1554');
INSERT INTO `tp_region` VALUES ('1613', '柏乡镇', '4', '1612');
INSERT INTO `tp_region` VALUES ('1614', '固城店镇', '4', '1612');
INSERT INTO `tp_region` VALUES ('1615', '王家庄乡', '4', '1612');
INSERT INTO `tp_region` VALUES ('1616', '西汪乡', '4', '1612');
INSERT INTO `tp_region` VALUES ('1617', '龙华乡', '4', '1612');
INSERT INTO `tp_region` VALUES ('1618', '内步乡', '4', '1612');
INSERT INTO `tp_region` VALUES ('1619', '隆尧县', '3', '1554');
INSERT INTO `tp_region` VALUES ('1620', '隆尧镇', '4', '1619');
INSERT INTO `tp_region` VALUES ('1621', '魏家庄镇', '4', '1619');
INSERT INTO `tp_region` VALUES ('1622', '尹村镇', '4', '1619');
INSERT INTO `tp_region` VALUES ('1623', '山口镇', '4', '1619');
INSERT INTO `tp_region` VALUES ('1624', '莲子镇', '4', '1619');
INSERT INTO `tp_region` VALUES ('1625', '固城镇', '4', '1619');
INSERT INTO `tp_region` VALUES ('1626', '北楼乡', '4', '1619');
INSERT INTO `tp_region` VALUES ('1627', '东良乡', '4', '1619');
INSERT INTO `tp_region` VALUES ('1628', '双碑乡', '4', '1619');
INSERT INTO `tp_region` VALUES ('1629', '牛家桥乡', '4', '1619');
INSERT INTO `tp_region` VALUES ('1630', '千户营乡', '4', '1619');
INSERT INTO `tp_region` VALUES ('1631', '大张庄乡', '4', '1619');
INSERT INTO `tp_region` VALUES ('1632', '柳行农场', '4', '1619');
INSERT INTO `tp_region` VALUES ('1633', '任县', '3', '1554');
INSERT INTO `tp_region` VALUES ('1634', '任城镇', '4', '1633');
INSERT INTO `tp_region` VALUES ('1635', '邢家湾镇', '4', '1633');
INSERT INTO `tp_region` VALUES ('1636', '辛店镇', '4', '1633');
INSERT INTO `tp_region` VALUES ('1637', '西固城乡', '4', '1633');
INSERT INTO `tp_region` VALUES ('1638', '永福庄乡', '4', '1633');
INSERT INTO `tp_region` VALUES ('1639', '大屯乡', '4', '1633');
INSERT INTO `tp_region` VALUES ('1640', '天口乡', '4', '1633');
INSERT INTO `tp_region` VALUES ('1641', '骆庄乡', '4', '1633');
INSERT INTO `tp_region` VALUES ('1642', '南和县', '3', '1554');
INSERT INTO `tp_region` VALUES ('1643', '和阳镇', '4', '1642');
INSERT INTO `tp_region` VALUES ('1644', '贾宋镇', '4', '1642');
INSERT INTO `tp_region` VALUES ('1645', '郝桥镇', '4', '1642');
INSERT INTO `tp_region` VALUES ('1646', '东三召乡', '4', '1642');
INSERT INTO `tp_region` VALUES ('1647', '阎里乡', '4', '1642');
INSERT INTO `tp_region` VALUES ('1648', '河郭乡', '4', '1642');
INSERT INTO `tp_region` VALUES ('1649', '史召乡', '4', '1642');
INSERT INTO `tp_region` VALUES ('1650', '三思乡', '4', '1642');
INSERT INTO `tp_region` VALUES ('1651', '宁晋县', '3', '1554');
INSERT INTO `tp_region` VALUES ('1652', '凤凰镇', '4', '1651');
INSERT INTO `tp_region` VALUES ('1653', '河渠镇', '4', '1651');
INSERT INTO `tp_region` VALUES ('1654', '北河庄镇', '4', '1651');
INSERT INTO `tp_region` VALUES ('1655', '耿庄桥镇', '4', '1651');
INSERT INTO `tp_region` VALUES ('1656', '东汪镇', '4', '1651');
INSERT INTO `tp_region` VALUES ('1657', '贾家口镇', '4', '1651');
INSERT INTO `tp_region` VALUES ('1658', '四芝兰镇', '4', '1651');
INSERT INTO `tp_region` VALUES ('1659', '大陆村镇', '4', '1651');
INSERT INTO `tp_region` VALUES ('1660', '苏家庄镇', '4', '1651');
INSERT INTO `tp_region` VALUES ('1661', '换马店镇', '4', '1651');
INSERT INTO `tp_region` VALUES ('1662', '侯口乡', '4', '1651');
INSERT INTO `tp_region` VALUES ('1663', '纪昌庄乡', '4', '1651');
INSERT INTO `tp_region` VALUES ('1664', '唐邱乡', '4', '1651');
INSERT INTO `tp_region` VALUES ('1665', '北鱼乡', '4', '1651');
INSERT INTO `tp_region` VALUES ('1666', '徐家河乡', '4', '1651');
INSERT INTO `tp_region` VALUES ('1667', '大曹庄乡', '4', '1651');
INSERT INTO `tp_region` VALUES ('1668', '大曹庄管理区', '4', '1651');
INSERT INTO `tp_region` VALUES ('1669', '巨鹿县', '3', '1554');
INSERT INTO `tp_region` VALUES ('1670', '巨鹿镇', '4', '1669');
INSERT INTO `tp_region` VALUES ('1671', '王虎寨镇', '4', '1669');
INSERT INTO `tp_region` VALUES ('1672', '西郭城镇', '4', '1669');
INSERT INTO `tp_region` VALUES ('1673', '官亭镇', '4', '1669');
INSERT INTO `tp_region` VALUES ('1674', '阎疃镇', '4', '1669');
INSERT INTO `tp_region` VALUES ('1675', '小吕寨镇', '4', '1669');
INSERT INTO `tp_region` VALUES ('1676', '堤村乡', '4', '1669');
INSERT INTO `tp_region` VALUES ('1677', '张王疃乡', '4', '1669');
INSERT INTO `tp_region` VALUES ('1678', '观寨乡', '4', '1669');
INSERT INTO `tp_region` VALUES ('1679', '苏家营乡', '4', '1669');
INSERT INTO `tp_region` VALUES ('1680', '新河县', '3', '1554');
INSERT INTO `tp_region` VALUES ('1681', '新河镇', '4', '1680');
INSERT INTO `tp_region` VALUES ('1682', '寻寨镇', '4', '1680');
INSERT INTO `tp_region` VALUES ('1683', '白神首乡', '4', '1680');
INSERT INTO `tp_region` VALUES ('1684', '荆家庄乡', '4', '1680');
INSERT INTO `tp_region` VALUES ('1685', '西流乡', '4', '1680');
INSERT INTO `tp_region` VALUES ('1686', '仁让里乡', '4', '1680');
INSERT INTO `tp_region` VALUES ('1687', '广宗县', '3', '1554');
INSERT INTO `tp_region` VALUES ('1688', '广宗镇', '4', '1687');
INSERT INTO `tp_region` VALUES ('1689', '葫芦乡', '4', '1687');
INSERT INTO `tp_region` VALUES ('1690', '大平台乡', '4', '1687');
INSERT INTO `tp_region` VALUES ('1691', '件只乡', '4', '1687');
INSERT INTO `tp_region` VALUES ('1692', '核桃园乡', '4', '1687');
INSERT INTO `tp_region` VALUES ('1693', '东召乡', '4', '1687');
INSERT INTO `tp_region` VALUES ('1694', '北塘疃乡', '4', '1687');
INSERT INTO `tp_region` VALUES ('1695', '冯家寨乡', '4', '1687');
INSERT INTO `tp_region` VALUES ('1696', '平乡县', '3', '1554');
INSERT INTO `tp_region` VALUES ('1697', '丰州镇', '4', '1696');
INSERT INTO `tp_region` VALUES ('1698', '平乡镇', '4', '1696');
INSERT INTO `tp_region` VALUES ('1699', '河古庙镇', '4', '1696');
INSERT INTO `tp_region` VALUES ('1700', '节固乡', '4', '1696');
INSERT INTO `tp_region` VALUES ('1701', '油召乡', '4', '1696');
INSERT INTO `tp_region` VALUES ('1702', '田付村乡', '4', '1696');
INSERT INTO `tp_region` VALUES ('1703', '寻召乡', '4', '1696');
INSERT INTO `tp_region` VALUES ('1704', '威县', '3', '1554');
INSERT INTO `tp_region` VALUES ('1705', '名州镇', '4', '1704');
INSERT INTO `tp_region` VALUES ('1706', '梨元屯镇', '4', '1704');
INSERT INTO `tp_region` VALUES ('1707', '章台镇', '4', '1704');
INSERT INTO `tp_region` VALUES ('1708', '侯贯镇', '4', '1704');
INSERT INTO `tp_region` VALUES ('1709', '七级镇', '4', '1704');
INSERT INTO `tp_region` VALUES ('1710', '方家营乡', '4', '1704');
INSERT INTO `tp_region` VALUES ('1711', '第什营乡', '4', '1704');
INSERT INTO `tp_region` VALUES ('1712', '枣园乡', '4', '1704');
INSERT INTO `tp_region` VALUES ('1713', '固献乡', '4', '1704');
INSERT INTO `tp_region` VALUES ('1714', '贺钊乡', '4', '1704');
INSERT INTO `tp_region` VALUES ('1715', '贺营乡', '4', '1704');
INSERT INTO `tp_region` VALUES ('1716', '张营乡', '4', '1704');
INSERT INTO `tp_region` VALUES ('1717', '常屯乡', '4', '1704');
INSERT INTO `tp_region` VALUES ('1718', '常庄乡', '4', '1704');
INSERT INTO `tp_region` VALUES ('1719', '高公庄乡', '4', '1704');
INSERT INTO `tp_region` VALUES ('1720', '赵村乡', '4', '1704');
INSERT INTO `tp_region` VALUES ('1721', '清河县', '3', '1554');
INSERT INTO `tp_region` VALUES ('1722', '葛仙庄镇', '4', '1721');
INSERT INTO `tp_region` VALUES ('1723', '连庄镇', '4', '1721');
INSERT INTO `tp_region` VALUES ('1724', '油坊镇', '4', '1721');
INSERT INTO `tp_region` VALUES ('1725', '谢炉镇', '4', '1721');
INSERT INTO `tp_region` VALUES ('1726', '王官庄镇', '4', '1721');
INSERT INTO `tp_region` VALUES ('1727', '坝营镇', '4', '1721');
INSERT INTO `tp_region` VALUES ('1728', '临西县', '3', '1554');
INSERT INTO `tp_region` VALUES ('1729', '临西镇', '4', '1728');
INSERT INTO `tp_region` VALUES ('1730', '河西镇', '4', '1728');
INSERT INTO `tp_region` VALUES ('1731', '下堡寺镇', '4', '1728');
INSERT INTO `tp_region` VALUES ('1732', '尖冢镇', '4', '1728');
INSERT INTO `tp_region` VALUES ('1733', '东枣园乡', '4', '1728');
INSERT INTO `tp_region` VALUES ('1734', '老官寨乡', '4', '1728');
INSERT INTO `tp_region` VALUES ('1735', '吕寨乡', '4', '1728');
INSERT INTO `tp_region` VALUES ('1736', '摇鞍镇乡', '4', '1728');
INSERT INTO `tp_region` VALUES ('1737', '大刘庄乡', '4', '1728');
INSERT INTO `tp_region` VALUES ('1738', '南宫市', '3', '1554');
INSERT INTO `tp_region` VALUES ('1739', '凤岗街道', '4', '1738');
INSERT INTO `tp_region` VALUES ('1740', '南杜街道', '4', '1738');
INSERT INTO `tp_region` VALUES ('1741', '北胡街道', '4', '1738');
INSERT INTO `tp_region` VALUES ('1742', '西丁街道', '4', '1738');
INSERT INTO `tp_region` VALUES ('1743', '苏村镇', '4', '1738');
INSERT INTO `tp_region` VALUES ('1744', '大高村镇', '4', '1738');
INSERT INTO `tp_region` VALUES ('1745', '垂杨镇', '4', '1738');
INSERT INTO `tp_region` VALUES ('1746', '明化镇', '4', '1738');
INSERT INTO `tp_region` VALUES ('1747', '段芦头镇', '4', '1738');
INSERT INTO `tp_region` VALUES ('1748', '紫冢镇', '4', '1738');
INSERT INTO `tp_region` VALUES ('1749', '大村乡', '4', '1738');
INSERT INTO `tp_region` VALUES ('1750', '南便村乡', '4', '1738');
INSERT INTO `tp_region` VALUES ('1751', '大屯乡', '4', '1738');
INSERT INTO `tp_region` VALUES ('1752', '王道寨乡', '4', '1738');
INSERT INTO `tp_region` VALUES ('1753', '薛吴村乡', '4', '1738');
INSERT INTO `tp_region` VALUES ('1754', '沙河市', '3', '1554');
INSERT INTO `tp_region` VALUES ('1755', '褡裢街道', '4', '1754');
INSERT INTO `tp_region` VALUES ('1756', '桥东街道', '4', '1754');
INSERT INTO `tp_region` VALUES ('1757', '桥西街道', '4', '1754');
INSERT INTO `tp_region` VALUES ('1758', '赞善街道', '4', '1754');
INSERT INTO `tp_region` VALUES ('1759', '周庄街道', '4', '1754');
INSERT INTO `tp_region` VALUES ('1760', '沙河城镇', '4', '1754');
INSERT INTO `tp_region` VALUES ('1761', '新城镇', '4', '1754');
INSERT INTO `tp_region` VALUES ('1762', '白塔镇', '4', '1754');
INSERT INTO `tp_region` VALUES ('1763', '十里亭镇', '4', '1754');
INSERT INTO `tp_region` VALUES ('1764', '綦村镇', '4', '1754');
INSERT INTO `tp_region` VALUES ('1765', '留村乡', '4', '1754');
INSERT INTO `tp_region` VALUES ('1766', '册井乡', '4', '1754');
INSERT INTO `tp_region` VALUES ('1767', '刘石岗乡', '4', '1754');
INSERT INTO `tp_region` VALUES ('1768', '柴关乡', '4', '1754');
INSERT INTO `tp_region` VALUES ('1769', '蝉房乡', '4', '1754');
INSERT INTO `tp_region` VALUES ('1770', '华北冶金矿山建设公司', '4', '1754');
INSERT INTO `tp_region` VALUES ('1771', '华北冶金设备制造厂', '4', '1754');
INSERT INTO `tp_region` VALUES ('1772', '保定市', '2', '636');
INSERT INTO `tp_region` VALUES ('1773', '市辖区', '3', '1772');
INSERT INTO `tp_region` VALUES ('1774', '新市区', '3', '1772');
INSERT INTO `tp_region` VALUES ('1775', '先锋街道', '4', '1774');
INSERT INTO `tp_region` VALUES ('1776', '新市场街道', '4', '1774');
INSERT INTO `tp_region` VALUES ('1777', '东风街道', '4', '1774');
INSERT INTO `tp_region` VALUES ('1778', '建南街道', '4', '1774');
INSERT INTO `tp_region` VALUES ('1779', '韩村北路街道', '4', '1774');
INSERT INTO `tp_region` VALUES ('1780', '颉庄乡', '4', '1774');
INSERT INTO `tp_region` VALUES ('1781', '富昌乡', '4', '1774');
INSERT INTO `tp_region` VALUES ('1782', '韩村乡', '4', '1774');
INSERT INTO `tp_region` VALUES ('1783', '南奇乡', '4', '1774');
INSERT INTO `tp_region` VALUES ('1784', '江城乡', '4', '1774');
INSERT INTO `tp_region` VALUES ('1785', '大马坊乡', '4', '1774');
INSERT INTO `tp_region` VALUES ('1786', '保定国家高新区', '4', '1774');
INSERT INTO `tp_region` VALUES ('1787', '北市区', '3', '1772');
INSERT INTO `tp_region` VALUES ('1788', '和平里街道', '4', '1787');
INSERT INTO `tp_region` VALUES ('1789', '五四路街道', '4', '1787');
INSERT INTO `tp_region` VALUES ('1790', '西关街道', '4', '1787');
INSERT INTO `tp_region` VALUES ('1791', '中华路街道', '4', '1787');
INSERT INTO `tp_region` VALUES ('1792', '东关街道', '4', '1787');
INSERT INTO `tp_region` VALUES ('1793', '韩庄乡', '4', '1787');
INSERT INTO `tp_region` VALUES ('1794', '东金庄乡', '4', '1787');
INSERT INTO `tp_region` VALUES ('1795', '百楼乡', '4', '1787');
INSERT INTO `tp_region` VALUES ('1796', '南市区', '3', '1772');
INSERT INTO `tp_region` VALUES ('1797', '联盟街道', '4', '1796');
INSERT INTO `tp_region` VALUES ('1798', '红星街道', '4', '1796');
INSERT INTO `tp_region` VALUES ('1799', '裕华街道', '4', '1796');
INSERT INTO `tp_region` VALUES ('1800', '永华街道', '4', '1796');
INSERT INTO `tp_region` VALUES ('1801', '南关街道', '4', '1796');
INSERT INTO `tp_region` VALUES ('1802', '杨庄乡', '4', '1796');
INSERT INTO `tp_region` VALUES ('1803', '南大园乡', '4', '1796');
INSERT INTO `tp_region` VALUES ('1804', '焦庄乡', '4', '1796');
INSERT INTO `tp_region` VALUES ('1805', '五尧乡', '4', '1796');
INSERT INTO `tp_region` VALUES ('1806', '满城县', '3', '1772');
INSERT INTO `tp_region` VALUES ('1807', '惠阳街道', '4', '1806');
INSERT INTO `tp_region` VALUES ('1808', '满城镇', '4', '1806');
INSERT INTO `tp_region` VALUES ('1809', '大册营镇', '4', '1806');
INSERT INTO `tp_region` VALUES ('1810', '神星镇', '4', '1806');
INSERT INTO `tp_region` VALUES ('1811', '南韩村镇', '4', '1806');
INSERT INTO `tp_region` VALUES ('1812', '方顺桥乡', '4', '1806');
INSERT INTO `tp_region` VALUES ('1813', '于家庄乡', '4', '1806');
INSERT INTO `tp_region` VALUES ('1814', '贤台乡', '4', '1806');
INSERT INTO `tp_region` VALUES ('1815', '要庄乡', '4', '1806');
INSERT INTO `tp_region` VALUES ('1816', '白龙乡', '4', '1806');
INSERT INTO `tp_region` VALUES ('1817', '石井乡', '4', '1806');
INSERT INTO `tp_region` VALUES ('1818', '坨南乡', '4', '1806');
INSERT INTO `tp_region` VALUES ('1819', '刘家台乡', '4', '1806');
INSERT INTO `tp_region` VALUES ('1820', '清苑县', '3', '1772');
INSERT INTO `tp_region` VALUES ('1821', '清苑镇', '4', '1820');
INSERT INTO `tp_region` VALUES ('1822', '冉庄镇', '4', '1820');
INSERT INTO `tp_region` VALUES ('1823', '阳城镇', '4', '1820');
INSERT INTO `tp_region` VALUES ('1824', '魏村镇', '4', '1820');
INSERT INTO `tp_region` VALUES ('1825', '温仁镇', '4', '1820');
INSERT INTO `tp_region` VALUES ('1826', '张登镇', '4', '1820');
INSERT INTO `tp_region` VALUES ('1827', '大庄镇', '4', '1820');
INSERT INTO `tp_region` VALUES ('1828', '臧村镇', '4', '1820');
INSERT INTO `tp_region` VALUES ('1829', '白团乡', '4', '1820');
INSERT INTO `tp_region` VALUES ('1830', '北店乡', '4', '1820');
INSERT INTO `tp_region` VALUES ('1831', '石桥乡', '4', '1820');
INSERT INTO `tp_region` VALUES ('1832', '李庄乡', '4', '1820');
INSERT INTO `tp_region` VALUES ('1833', '北王力乡', '4', '1820');
INSERT INTO `tp_region` VALUES ('1834', '东吕乡', '4', '1820');
INSERT INTO `tp_region` VALUES ('1835', '何桥乡', '4', '1820');
INSERT INTO `tp_region` VALUES ('1836', '孙村乡', '4', '1820');
INSERT INTO `tp_region` VALUES ('1837', '阎庄乡', '4', '1820');
INSERT INTO `tp_region` VALUES ('1838', '望亭乡', '4', '1820');
INSERT INTO `tp_region` VALUES ('1839', '涞水县', '3', '1772');
INSERT INTO `tp_region` VALUES ('1840', '城区社区管理办公室街道', '4', '1839');
INSERT INTO `tp_region` VALUES ('1841', '涞水镇', '4', '1839');
INSERT INTO `tp_region` VALUES ('1842', '永阳镇', '4', '1839');
INSERT INTO `tp_region` VALUES ('1843', '义安镇', '4', '1839');
INSERT INTO `tp_region` VALUES ('1844', '石亭镇', '4', '1839');
INSERT INTO `tp_region` VALUES ('1845', '赵各庄镇', '4', '1839');
INSERT INTO `tp_region` VALUES ('1846', '九龙镇', '4', '1839');
INSERT INTO `tp_region` VALUES ('1847', '三坡镇', '4', '1839');
INSERT INTO `tp_region` VALUES ('1848', '明义乡', '4', '1839');
INSERT INTO `tp_region` VALUES ('1849', '王村乡', '4', '1839');
INSERT INTO `tp_region` VALUES ('1850', '东文山乡', '4', '1839');
INSERT INTO `tp_region` VALUES ('1851', '娄村满族乡', '4', '1839');
INSERT INTO `tp_region` VALUES ('1852', '宋各庄乡', '4', '1839');
INSERT INTO `tp_region` VALUES ('1853', '其中口乡', '4', '1839');
INSERT INTO `tp_region` VALUES ('1854', '龙门乡', '4', '1839');
INSERT INTO `tp_region` VALUES ('1855', '胡家庄乡', '4', '1839');
INSERT INTO `tp_region` VALUES ('1856', '阜平县', '3', '1772');
INSERT INTO `tp_region` VALUES ('1857', '阜平镇', '4', '1856');
INSERT INTO `tp_region` VALUES ('1858', '龙泉关镇', '4', '1856');
INSERT INTO `tp_region` VALUES ('1859', '平阳镇', '4', '1856');
INSERT INTO `tp_region` VALUES ('1860', '城南庄镇', '4', '1856');
INSERT INTO `tp_region` VALUES ('1861', '东下关乡', '4', '1856');
INSERT INTO `tp_region` VALUES ('1862', '王林口乡', '4', '1856');
INSERT INTO `tp_region` VALUES ('1863', '台峪乡', '4', '1856');
INSERT INTO `tp_region` VALUES ('1864', '大台乡', '4', '1856');
INSERT INTO `tp_region` VALUES ('1865', '史家寨乡', '4', '1856');
INSERT INTO `tp_region` VALUES ('1866', '砂窝乡', '4', '1856');
INSERT INTO `tp_region` VALUES ('1867', '吴王口乡', '4', '1856');
INSERT INTO `tp_region` VALUES ('1868', '下庄乡', '4', '1856');
INSERT INTO `tp_region` VALUES ('1869', '北果元乡', '4', '1856');
INSERT INTO `tp_region` VALUES ('1870', '徐水县', '3', '1772');
INSERT INTO `tp_region` VALUES ('1871', '安肃镇', '4', '1870');
INSERT INTO `tp_region` VALUES ('1872', '崔庄镇', '4', '1870');
INSERT INTO `tp_region` VALUES ('1873', '大因镇', '4', '1870');
INSERT INTO `tp_region` VALUES ('1874', '遂城镇', '4', '1870');
INSERT INTO `tp_region` VALUES ('1875', '高林村镇', '4', '1870');
INSERT INTO `tp_region` VALUES ('1876', '大王店镇', '4', '1870');
INSERT INTO `tp_region` VALUES ('1877', '漕河镇', '4', '1870');
INSERT INTO `tp_region` VALUES ('1878', '东史端乡', '4', '1870');
INSERT INTO `tp_region` VALUES ('1879', '留村乡', '4', '1870');
INSERT INTO `tp_region` VALUES ('1880', '正村乡', '4', '1870');
INSERT INTO `tp_region` VALUES ('1881', '户木乡', '4', '1870');
INSERT INTO `tp_region` VALUES ('1882', '瀑河乡', '4', '1870');
INSERT INTO `tp_region` VALUES ('1883', '东釜山乡', '4', '1870');
INSERT INTO `tp_region` VALUES ('1884', '义联庄乡', '4', '1870');
INSERT INTO `tp_region` VALUES ('1885', '定兴县', '3', '1772');
INSERT INTO `tp_region` VALUES ('1886', '定兴镇', '4', '1885');
INSERT INTO `tp_region` VALUES ('1887', '固城镇', '4', '1885');
INSERT INTO `tp_region` VALUES ('1888', '贤寓镇', '4', '1885');
INSERT INTO `tp_region` VALUES ('1889', '北河镇', '4', '1885');
INSERT INTO `tp_region` VALUES ('1890', '东落堡乡', '4', '1885');
INSERT INTO `tp_region` VALUES ('1891', '高里乡', '4', '1885');
INSERT INTO `tp_region` VALUES ('1892', '张家庄乡', '4', '1885');
INSERT INTO `tp_region` VALUES ('1893', '姚村乡', '4', '1885');
INSERT INTO `tp_region` VALUES ('1894', '肖村乡', '4', '1885');
INSERT INTO `tp_region` VALUES ('1895', '柳卓乡', '4', '1885');
INSERT INTO `tp_region` VALUES ('1896', '杨村乡', '4', '1885');
INSERT INTO `tp_region` VALUES ('1897', '北田乡', '4', '1885');
INSERT INTO `tp_region` VALUES ('1898', '北南蔡乡', '4', '1885');
INSERT INTO `tp_region` VALUES ('1899', '李郁庄乡', '4', '1885');
INSERT INTO `tp_region` VALUES ('1900', '天宫寺乡', '4', '1885');
INSERT INTO `tp_region` VALUES ('1901', '小朱庄乡', '4', '1885');
INSERT INTO `tp_region` VALUES ('1902', '唐县', '3', '1772');
INSERT INTO `tp_region` VALUES ('1903', '仁厚镇', '4', '1902');
INSERT INTO `tp_region` VALUES ('1904', '王京镇', '4', '1902');
INSERT INTO `tp_region` VALUES ('1905', '高昌镇', '4', '1902');
INSERT INTO `tp_region` VALUES ('1906', '北罗镇', '4', '1902');
INSERT INTO `tp_region` VALUES ('1907', '白合镇', '4', '1902');
INSERT INTO `tp_region` VALUES ('1908', '军城镇', '4', '1902');
INSERT INTO `tp_region` VALUES ('1909', '川里镇', '4', '1902');
INSERT INTO `tp_region` VALUES ('1910', '长古城乡', '4', '1902');
INSERT INTO `tp_region` VALUES ('1911', '都亭乡', '4', '1902');
INSERT INTO `tp_region` VALUES ('1912', '南店头乡', '4', '1902');
INSERT INTO `tp_region` VALUES ('1913', '北店头乡', '4', '1902');
INSERT INTO `tp_region` VALUES ('1914', '罗庄乡', '4', '1902');
INSERT INTO `tp_region` VALUES ('1915', '雹水乡', '4', '1902');
INSERT INTO `tp_region` VALUES ('1916', '大洋乡', '4', '1902');
INSERT INTO `tp_region` VALUES ('1917', '迷城乡', '4', '1902');
INSERT INTO `tp_region` VALUES ('1918', '齐家佐乡', '4', '1902');
INSERT INTO `tp_region` VALUES ('1919', '羊角乡', '4', '1902');
INSERT INTO `tp_region` VALUES ('1920', '石门乡', '4', '1902');
INSERT INTO `tp_region` VALUES ('1921', '黄石口乡', '4', '1902');
INSERT INTO `tp_region` VALUES ('1922', '倒马关乡', '4', '1902');
INSERT INTO `tp_region` VALUES ('1923', '高阳县', '3', '1772');
INSERT INTO `tp_region` VALUES ('1924', '高阳镇', '4', '1923');
INSERT INTO `tp_region` VALUES ('1925', '庞口镇', '4', '1923');
INSERT INTO `tp_region` VALUES ('1926', '西演镇', '4', '1923');
INSERT INTO `tp_region` VALUES ('1927', '邢家南乡', '4', '1923');
INSERT INTO `tp_region` VALUES ('1928', '晋庄乡', '4', '1923');
INSERT INTO `tp_region` VALUES ('1929', '蒲口乡', '4', '1923');
INSERT INTO `tp_region` VALUES ('1930', '小王果庄乡', '4', '1923');
INSERT INTO `tp_region` VALUES ('1931', '龙化乡', '4', '1923');
INSERT INTO `tp_region` VALUES ('1932', '庞家佐乡', '4', '1923');
INSERT INTO `tp_region` VALUES ('1933', '容城县', '3', '1772');
INSERT INTO `tp_region` VALUES ('1934', '容城镇', '4', '1933');
INSERT INTO `tp_region` VALUES ('1935', '小里镇', '4', '1933');
INSERT INTO `tp_region` VALUES ('1936', '南张镇', '4', '1933');
INSERT INTO `tp_region` VALUES ('1937', '大河镇', '4', '1933');
INSERT INTO `tp_region` VALUES ('1938', '八于乡', '4', '1933');
INSERT INTO `tp_region` VALUES ('1939', '贾光乡', '4', '1933');
INSERT INTO `tp_region` VALUES ('1940', '晾马台乡', '4', '1933');
INSERT INTO `tp_region` VALUES ('1941', '平王乡', '4', '1933');
INSERT INTO `tp_region` VALUES ('1942', '涞源县', '3', '1772');
INSERT INTO `tp_region` VALUES ('1943', '涞源镇', '4', '1942');
INSERT INTO `tp_region` VALUES ('1944', '银坊镇', '4', '1942');
INSERT INTO `tp_region` VALUES ('1945', '走马驿镇', '4', '1942');
INSERT INTO `tp_region` VALUES ('1946', '水堡镇', '4', '1942');
INSERT INTO `tp_region` VALUES ('1947', '王安镇', '4', '1942');
INSERT INTO `tp_region` VALUES ('1948', '杨家庄镇', '4', '1942');
INSERT INTO `tp_region` VALUES ('1949', '下北头乡', '4', '1942');
INSERT INTO `tp_region` VALUES ('1950', '南屯乡', '4', '1942');
INSERT INTO `tp_region` VALUES ('1951', '马庄乡', '4', '1942');
INSERT INTO `tp_region` VALUES ('1952', '北石佛乡', '4', '1942');
INSERT INTO `tp_region` VALUES ('1953', '金家井乡', '4', '1942');
INSERT INTO `tp_region` VALUES ('1954', '留家庄乡', '4', '1942');
INSERT INTO `tp_region` VALUES ('1955', '上庄乡', '4', '1942');
INSERT INTO `tp_region` VALUES ('1956', '东团堡乡', '4', '1942');
INSERT INTO `tp_region` VALUES ('1957', '塔崖驿乡', '4', '1942');
INSERT INTO `tp_region` VALUES ('1958', '乌龙沟乡', '4', '1942');
INSERT INTO `tp_region` VALUES ('1959', '烟煤洞乡', '4', '1942');
INSERT INTO `tp_region` VALUES ('1960', '望都县', '3', '1772');
INSERT INTO `tp_region` VALUES ('1961', '望都镇', '4', '1960');
INSERT INTO `tp_region` VALUES ('1962', '固店镇', '4', '1960');
INSERT INTO `tp_region` VALUES ('1963', '寺庄乡', '4', '1960');
INSERT INTO `tp_region` VALUES ('1964', '赵庄乡', '4', '1960');
INSERT INTO `tp_region` VALUES ('1965', '黑堡乡', '4', '1960');
INSERT INTO `tp_region` VALUES ('1966', '高岭乡', '4', '1960');
INSERT INTO `tp_region` VALUES ('1967', '中韩庄乡', '4', '1960');
INSERT INTO `tp_region` VALUES ('1968', '贾村乡', '4', '1960');
INSERT INTO `tp_region` VALUES ('1969', '安新县', '3', '1772');
INSERT INTO `tp_region` VALUES ('1970', '安新镇', '4', '1969');
INSERT INTO `tp_region` VALUES ('1971', '大王镇', '4', '1969');
INSERT INTO `tp_region` VALUES ('1972', '三台镇', '4', '1969');
INSERT INTO `tp_region` VALUES ('1973', '端村镇', '4', '1969');
INSERT INTO `tp_region` VALUES ('1974', '赵北口镇', '4', '1969');
INSERT INTO `tp_region` VALUES ('1975', '同口镇', '4', '1969');
INSERT INTO `tp_region` VALUES ('1976', '刘李庄镇', '4', '1969');
INSERT INTO `tp_region` VALUES ('1977', '安州镇', '4', '1969');
INSERT INTO `tp_region` VALUES ('1978', '老河头镇', '4', '1969');
INSERT INTO `tp_region` VALUES ('1979', '圈头乡', '4', '1969');
INSERT INTO `tp_region` VALUES ('1980', '寨里乡', '4', '1969');
INSERT INTO `tp_region` VALUES ('1981', '芦庄乡', '4', '1969');
INSERT INTO `tp_region` VALUES ('1982', '易县', '3', '1772');
INSERT INTO `tp_region` VALUES ('1983', '易州镇', '4', '1982');
INSERT INTO `tp_region` VALUES ('1984', '梁格庄镇', '4', '1982');
INSERT INTO `tp_region` VALUES ('1985', '西陵镇', '4', '1982');
INSERT INTO `tp_region` VALUES ('1986', '裴山镇', '4', '1982');
INSERT INTO `tp_region` VALUES ('1987', '塘湖镇', '4', '1982');
INSERT INTO `tp_region` VALUES ('1988', '狼牙山镇', '4', '1982');
INSERT INTO `tp_region` VALUES ('1989', '良岗镇', '4', '1982');
INSERT INTO `tp_region` VALUES ('1990', '紫荆关镇', '4', '1982');
INSERT INTO `tp_region` VALUES ('1991', '桥头乡', '4', '1982');
INSERT INTO `tp_region` VALUES ('1992', '白马乡', '4', '1982');
INSERT INTO `tp_region` VALUES ('1993', '流井乡', '4', '1982');
INSERT INTO `tp_region` VALUES ('1994', '高村乡', '4', '1982');
INSERT INTO `tp_region` VALUES ('1995', '高陌乡', '4', '1982');
INSERT INTO `tp_region` VALUES ('1996', '大龙华乡', '4', '1982');
INSERT INTO `tp_region` VALUES ('1997', '安格庄乡', '4', '1982');
INSERT INTO `tp_region` VALUES ('1998', '凌云册乡', '4', '1982');
INSERT INTO `tp_region` VALUES ('1999', '西山北乡', '4', '1982');
INSERT INTO `tp_region` VALUES ('2000', '尉都乡', '4', '1982');
INSERT INTO `tp_region` VALUES ('2001', '独乐乡', '4', '1982');
INSERT INTO `tp_region` VALUES ('2002', '七峪乡', '4', '1982');
INSERT INTO `tp_region` VALUES ('2003', '富岗乡', '4', '1982');
INSERT INTO `tp_region` VALUES ('2004', '坡仓乡', '4', '1982');
INSERT INTO `tp_region` VALUES ('2005', '牛岗乡', '4', '1982');
INSERT INTO `tp_region` VALUES ('2006', '桥家河乡', '4', '1982');
INSERT INTO `tp_region` VALUES ('2007', '甘河净乡', '4', '1982');
INSERT INTO `tp_region` VALUES ('2008', '蔡家峪乡', '4', '1982');
INSERT INTO `tp_region` VALUES ('2009', '南城司乡', '4', '1982');
INSERT INTO `tp_region` VALUES ('2010', '曲阳县', '3', '1772');
INSERT INTO `tp_region` VALUES ('2011', '恒州镇', '4', '2010');
INSERT INTO `tp_region` VALUES ('2012', '灵山镇', '4', '2010');
INSERT INTO `tp_region` VALUES ('2013', '燕赵镇', '4', '2010');
INSERT INTO `tp_region` VALUES ('2014', '羊平镇', '4', '2010');
INSERT INTO `tp_region` VALUES ('2015', '路庄子乡', '4', '2010');
INSERT INTO `tp_region` VALUES ('2016', '下河乡', '4', '2010');
INSERT INTO `tp_region` VALUES ('2017', '庄窠乡', '4', '2010');
INSERT INTO `tp_region` VALUES ('2018', '孝墓乡', '4', '2010');
INSERT INTO `tp_region` VALUES ('2019', '文德乡', '4', '2010');
INSERT INTO `tp_region` VALUES ('2020', '东旺乡', '4', '2010');
INSERT INTO `tp_region` VALUES ('2021', '晓林乡', '4', '2010');
INSERT INTO `tp_region` VALUES ('2022', '邸村乡', '4', '2010');
INSERT INTO `tp_region` VALUES ('2023', '产德乡', '4', '2010');
INSERT INTO `tp_region` VALUES ('2024', '齐村乡', '4', '2010');
INSERT INTO `tp_region` VALUES ('2025', '党城乡', '4', '2010');
INSERT INTO `tp_region` VALUES ('2026', '郎家庄乡', '4', '2010');
INSERT INTO `tp_region` VALUES ('2027', '范家庄乡', '4', '2010');
INSERT INTO `tp_region` VALUES ('2028', '北台乡', '4', '2010');
INSERT INTO `tp_region` VALUES ('2029', '蠡县', '3', '1772');
INSERT INTO `tp_region` VALUES ('2030', '蠡吾镇', '4', '2029');
INSERT INTO `tp_region` VALUES ('2031', '留史镇', '4', '2029');
INSERT INTO `tp_region` VALUES ('2032', '大百尺镇', '4', '2029');
INSERT INTO `tp_region` VALUES ('2033', '辛兴镇', '4', '2029');
INSERT INTO `tp_region` VALUES ('2034', '北郭丹镇', '4', '2029');
INSERT INTO `tp_region` VALUES ('2035', '万安镇', '4', '2029');
INSERT INTO `tp_region` VALUES ('2036', '桑园镇', '4', '2029');
INSERT INTO `tp_region` VALUES ('2037', '南庄镇', '4', '2029');
INSERT INTO `tp_region` VALUES ('2038', '小陈乡', '4', '2029');
INSERT INTO `tp_region` VALUES ('2039', '林堡乡', '4', '2029');
INSERT INTO `tp_region` VALUES ('2040', '北埝头乡', '4', '2029');
INSERT INTO `tp_region` VALUES ('2041', '鲍墟乡', '4', '2029');
INSERT INTO `tp_region` VALUES ('2042', '大曲堤乡', '4', '2029');
INSERT INTO `tp_region` VALUES ('2043', '顺平县', '3', '1772');
INSERT INTO `tp_region` VALUES ('2044', '蒲阳镇', '4', '2043');
INSERT INTO `tp_region` VALUES ('2045', '高于铺镇', '4', '2043');
INSERT INTO `tp_region` VALUES ('2046', '腰山镇', '4', '2043');
INSERT INTO `tp_region` VALUES ('2047', '蒲上乡', '4', '2043');
INSERT INTO `tp_region` VALUES ('2048', '白云乡', '4', '2043');
INSERT INTO `tp_region` VALUES ('2049', '河口乡', '4', '2043');
INSERT INTO `tp_region` VALUES ('2050', '安阳乡', '4', '2043');
INSERT INTO `tp_region` VALUES ('2051', '台鱼乡', '4', '2043');
INSERT INTO `tp_region` VALUES ('2052', '大悲乡', '4', '2043');
INSERT INTO `tp_region` VALUES ('2053', '神南乡', '4', '2043');
INSERT INTO `tp_region` VALUES ('2054', '博野县', '3', '1772');
INSERT INTO `tp_region` VALUES ('2055', '博野镇', '4', '2054');
INSERT INTO `tp_region` VALUES ('2056', '小店镇', '4', '2054');
INSERT INTO `tp_region` VALUES ('2057', '程委镇', '4', '2054');
INSERT INTO `tp_region` VALUES ('2058', '东墟乡', '4', '2054');
INSERT INTO `tp_region` VALUES ('2059', '北杨村乡', '4', '2054');
INSERT INTO `tp_region` VALUES ('2060', '城东乡', '4', '2054');
INSERT INTO `tp_region` VALUES ('2061', '南小王乡', '4', '2054');
INSERT INTO `tp_region` VALUES ('2062', '雄县', '3', '1772');
INSERT INTO `tp_region` VALUES ('2063', '雄州镇', '4', '2062');
INSERT INTO `tp_region` VALUES ('2064', '昝岗镇', '4', '2062');
INSERT INTO `tp_region` VALUES ('2065', '大营镇', '4', '2062');
INSERT INTO `tp_region` VALUES ('2066', '龙湾镇', '4', '2062');
INSERT INTO `tp_region` VALUES ('2067', '北沙口乡', '4', '2062');
INSERT INTO `tp_region` VALUES ('2068', '朱各庄乡', '4', '2062');
INSERT INTO `tp_region` VALUES ('2069', '米家务乡', '4', '2062');
INSERT INTO `tp_region` VALUES ('2070', '双堂乡', '4', '2062');
INSERT INTO `tp_region` VALUES ('2071', '张岗乡', '4', '2062');
INSERT INTO `tp_region` VALUES ('2072', '涿州市', '3', '1772');
INSERT INTO `tp_region` VALUES ('2073', '双塔街道', '4', '2072');
INSERT INTO `tp_region` VALUES ('2074', '桃园街道', '4', '2072');
INSERT INTO `tp_region` VALUES ('2075', '清凉寺街道', '4', '2072');
INSERT INTO `tp_region` VALUES ('2076', '松林店镇', '4', '2072');
INSERT INTO `tp_region` VALUES ('2077', '码头镇', '4', '2072');
INSERT INTO `tp_region` VALUES ('2078', '东城坊镇', '4', '2072');
INSERT INTO `tp_region` VALUES ('2079', '高官庄镇', '4', '2072');
INSERT INTO `tp_region` VALUES ('2080', '东仙坡镇', '4', '2072');
INSERT INTO `tp_region` VALUES ('2081', '百尺竿乡', '4', '2072');
INSERT INTO `tp_region` VALUES ('2082', '义和庄乡', '4', '2072');
INSERT INTO `tp_region` VALUES ('2083', '林家屯乡', '4', '2072');
INSERT INTO `tp_region` VALUES ('2084', '孙庄乡', '4', '2072');
INSERT INTO `tp_region` VALUES ('2085', '豆庄乡', '4', '2072');
INSERT INTO `tp_region` VALUES ('2086', '刁窝乡', '4', '2072');
INSERT INTO `tp_region` VALUES ('2087', '开发区管理委员会', '4', '2072');
INSERT INTO `tp_region` VALUES ('2088', '定州市', '3', '1772');
INSERT INTO `tp_region` VALUES ('2089', '南城区街道', '4', '2088');
INSERT INTO `tp_region` VALUES ('2090', '北城区街道', '4', '2088');
INSERT INTO `tp_region` VALUES ('2091', '西城区街道', '4', '2088');
INSERT INTO `tp_region` VALUES ('2092', '留早镇', '4', '2088');
INSERT INTO `tp_region` VALUES ('2093', '清风店镇', '4', '2088');
INSERT INTO `tp_region` VALUES ('2094', '庞村镇', '4', '2088');
INSERT INTO `tp_region` VALUES ('2095', '砖路镇', '4', '2088');
INSERT INTO `tp_region` VALUES ('2096', '明月店镇', '4', '2088');
INSERT INTO `tp_region` VALUES ('2097', '叮咛店镇', '4', '2088');
INSERT INTO `tp_region` VALUES ('2098', '东亭镇', '4', '2088');
INSERT INTO `tp_region` VALUES ('2099', '大辛庄镇', '4', '2088');
INSERT INTO `tp_region` VALUES ('2100', '东旺镇', '4', '2088');
INSERT INTO `tp_region` VALUES ('2101', '高蓬镇', '4', '2088');
INSERT INTO `tp_region` VALUES ('2102', '邢邑镇', '4', '2088');
INSERT INTO `tp_region` VALUES ('2103', '李亲顾镇', '4', '2088');
INSERT INTO `tp_region` VALUES ('2104', '子位镇', '4', '2088');
INSERT INTO `tp_region` VALUES ('2105', '开元镇', '4', '2088');
INSERT INTO `tp_region` VALUES ('2106', '赵村乡', '4', '2088');
INSERT INTO `tp_region` VALUES ('2107', '周村乡', '4', '2088');
INSERT INTO `tp_region` VALUES ('2108', '东留春乡', '4', '2088');
INSERT INTO `tp_region` VALUES ('2109', '号头庄回族乡', '4', '2088');
INSERT INTO `tp_region` VALUES ('2110', '杨家庄乡', '4', '2088');
INSERT INTO `tp_region` VALUES ('2111', '大鹿庄乡', '4', '2088');
INSERT INTO `tp_region` VALUES ('2112', '息冢乡', '4', '2088');
INSERT INTO `tp_region` VALUES ('2113', '西城乡', '4', '2088');
INSERT INTO `tp_region` VALUES ('2114', '安国市', '3', '1772');
INSERT INTO `tp_region` VALUES ('2115', '祁州药市街道', '4', '2114');
INSERT INTO `tp_region` VALUES ('2116', '祁州镇', '4', '2114');
INSERT INTO `tp_region` VALUES ('2117', '伍仁桥镇', '4', '2114');
INSERT INTO `tp_region` VALUES ('2118', '石佛镇', '4', '2114');
INSERT INTO `tp_region` VALUES ('2119', '郑章镇', '4', '2114');
INSERT INTO `tp_region` VALUES ('2120', '大五女镇', '4', '2114');
INSERT INTO `tp_region` VALUES ('2121', '明官店乡', '4', '2114');
INSERT INTO `tp_region` VALUES ('2122', '南娄底乡', '4', '2114');
INSERT INTO `tp_region` VALUES ('2123', '西安国城乡', '4', '2114');
INSERT INTO `tp_region` VALUES ('2124', '西佛落乡', '4', '2114');
INSERT INTO `tp_region` VALUES ('2125', '北段村乡', '4', '2114');
INSERT INTO `tp_region` VALUES ('2126', '高碑店市', '3', '1772');
INSERT INTO `tp_region` VALUES ('2127', '和平街道', '4', '2126');
INSERT INTO `tp_region` VALUES ('2128', '军城街道', '4', '2126');
INSERT INTO `tp_region` VALUES ('2129', '东盛街道', '4', '2126');
INSERT INTO `tp_region` VALUES ('2130', '北城街道', '4', '2126');
INSERT INTO `tp_region` VALUES ('2131', '兴华路街道', '4', '2126');
INSERT INTO `tp_region` VALUES ('2132', '方官镇', '4', '2126');
INSERT INTO `tp_region` VALUES ('2133', '新城镇', '4', '2126');
INSERT INTO `tp_region` VALUES ('2134', '泗庄镇', '4', '2126');
INSERT INTO `tp_region` VALUES ('2135', '白沟镇', '4', '2126');
INSERT INTO `tp_region` VALUES ('2136', '辛立庄镇', '4', '2126');
INSERT INTO `tp_region` VALUES ('2137', '肖官营乡', '4', '2126');
INSERT INTO `tp_region` VALUES ('2138', '梁家营乡', '4', '2126');
INSERT INTO `tp_region` VALUES ('2139', '张六庄乡', '4', '2126');
INSERT INTO `tp_region` VALUES ('2140', '东马营乡', '4', '2126');
INSERT INTO `tp_region` VALUES ('2141', '辛桥乡', '4', '2126');
INSERT INTO `tp_region` VALUES ('2142', '张家口市', '2', '636');
INSERT INTO `tp_region` VALUES ('2143', '市辖区', '3', '2142');
INSERT INTO `tp_region` VALUES ('2144', '桥东区', '3', '2142');
INSERT INTO `tp_region` VALUES ('2145', '红旗楼街道', '4', '2144');
INSERT INTO `tp_region` VALUES ('2146', '胜利北路街道', '4', '2144');
INSERT INTO `tp_region` VALUES ('2147', '五一路街道', '4', '2144');
INSERT INTO `tp_region` VALUES ('2148', '花园街街道', '4', '2144');
INSERT INTO `tp_region` VALUES ('2149', '工业路街道', '4', '2144');
INSERT INTO `tp_region` VALUES ('2150', '南站街道', '4', '2144');
INSERT INTO `tp_region` VALUES ('2151', '马路东街道', '4', '2144');
INSERT INTO `tp_region` VALUES ('2152', '老鸦庄镇', '4', '2144');
INSERT INTO `tp_region` VALUES ('2153', '姚家庄镇', '4', '2144');
INSERT INTO `tp_region` VALUES ('2154', '桥西区', '3', '2142');
INSERT INTO `tp_region` VALUES ('2155', '新华街街道', '4', '2154');
INSERT INTO `tp_region` VALUES ('2156', '大境门街道', '4', '2154');
INSERT INTO `tp_region` VALUES ('2157', '明德北街街道', '4', '2154');
INSERT INTO `tp_region` VALUES ('2158', '明德南街街道', '4', '2154');
INSERT INTO `tp_region` VALUES ('2159', '堡子里街道', '4', '2154');
INSERT INTO `tp_region` VALUES ('2160', '南营坊街道', '4', '2154');
INSERT INTO `tp_region` VALUES ('2161', '工人新村街道', '4', '2154');
INSERT INTO `tp_region` VALUES ('2162', '东窑子镇', '4', '2154');
INSERT INTO `tp_region` VALUES ('2163', '沈家屯镇', '4', '2154');
INSERT INTO `tp_region` VALUES ('2164', '宣化区', '3', '2142');
INSERT INTO `tp_region` VALUES ('2165', '天泰寺街道', '4', '2164');
INSERT INTO `tp_region` VALUES ('2166', '皇城街道', '4', '2164');
INSERT INTO `tp_region` VALUES ('2167', '南关街道', '4', '2164');
INSERT INTO `tp_region` VALUES ('2168', '南大街街道', '4', '2164');
INSERT INTO `tp_region` VALUES ('2169', '大北街街道', '4', '2164');
INSERT INTO `tp_region` VALUES ('2170', '工业街街道', '4', '2164');
INSERT INTO `tp_region` VALUES ('2171', '建国街街道', '4', '2164');
INSERT INTO `tp_region` VALUES ('2172', '庞家堡镇', '4', '2164');
INSERT INTO `tp_region` VALUES ('2173', '河子西乡', '4', '2164');
INSERT INTO `tp_region` VALUES ('2174', '春光乡', '4', '2164');
INSERT INTO `tp_region` VALUES ('2175', '侯家庙乡', '4', '2164');
INSERT INTO `tp_region` VALUES ('2176', '下花园区', '3', '2142');
INSERT INTO `tp_region` VALUES ('2177', '城镇街道', '4', '2176');
INSERT INTO `tp_region` VALUES ('2178', '煤矿街道', '4', '2176');
INSERT INTO `tp_region` VALUES ('2179', '花园乡', '4', '2176');
INSERT INTO `tp_region` VALUES ('2180', '辛庄子乡', '4', '2176');
INSERT INTO `tp_region` VALUES ('2181', '定方水乡', '4', '2176');
INSERT INTO `tp_region` VALUES ('2182', '段家堡乡', '4', '2176');
INSERT INTO `tp_region` VALUES ('2183', '宣化县', '3', '2142');
INSERT INTO `tp_region` VALUES ('2184', '洋河南镇', '4', '2183');
INSERT INTO `tp_region` VALUES ('2185', '深井镇', '4', '2183');
INSERT INTO `tp_region` VALUES ('2186', '崞村镇', '4', '2183');
INSERT INTO `tp_region` VALUES ('2187', '沙岭子镇', '4', '2183');
INSERT INTO `tp_region` VALUES ('2188', '姚家房镇', '4', '2183');
INSERT INTO `tp_region` VALUES ('2189', '大仓盖镇', '4', '2183');
INSERT INTO `tp_region` VALUES ('2190', '贾家营镇', '4', '2183');
INSERT INTO `tp_region` VALUES ('2191', '顾家营镇', '4', '2183');
INSERT INTO `tp_region` VALUES ('2192', '赵川镇', '4', '2183');
INSERT INTO `tp_region` VALUES ('2193', '王家湾乡', '4', '2183');
INSERT INTO `tp_region` VALUES ('2194', '塔儿村乡', '4', '2183');
INSERT INTO `tp_region` VALUES ('2195', '江家屯乡', '4', '2183');
INSERT INTO `tp_region` VALUES ('2196', '东望山乡', '4', '2183');
INSERT INTO `tp_region` VALUES ('2197', '李家堡乡', '4', '2183');
INSERT INTO `tp_region` VALUES ('2198', '张北县', '3', '2142');
INSERT INTO `tp_region` VALUES ('2199', '张北镇', '4', '2198');
INSERT INTO `tp_region` VALUES ('2200', '公会镇', '4', '2198');
INSERT INTO `tp_region` VALUES ('2201', '二台镇', '4', '2198');
INSERT INTO `tp_region` VALUES ('2202', '大囫囵镇', '4', '2198');
INSERT INTO `tp_region` VALUES ('2203', '台路沟乡', '4', '2198');
INSERT INTO `tp_region` VALUES ('2204', '油篓沟乡', '4', '2198');
INSERT INTO `tp_region` VALUES ('2205', '馒头营乡', '4', '2198');
INSERT INTO `tp_region` VALUES ('2206', '二泉井乡', '4', '2198');
INSERT INTO `tp_region` VALUES ('2207', '单晶河乡', '4', '2198');
INSERT INTO `tp_region` VALUES ('2208', '大河乡', '4', '2198');
INSERT INTO `tp_region` VALUES ('2209', '海流图乡', '4', '2198');
INSERT INTO `tp_region` VALUES ('2210', '两面井乡', '4', '2198');
INSERT INTO `tp_region` VALUES ('2211', '大西湾乡', '4', '2198');
INSERT INTO `tp_region` VALUES ('2212', '郝家营乡', '4', '2198');
INSERT INTO `tp_region` VALUES ('2213', '白庙滩乡', '4', '2198');
INSERT INTO `tp_region` VALUES ('2214', '小二台乡', '4', '2198');
INSERT INTO `tp_region` VALUES ('2215', '战海乡', '4', '2198');
INSERT INTO `tp_region` VALUES ('2216', '三号乡', '4', '2198');
INSERT INTO `tp_region` VALUES ('2217', '沙沟乡', '4', '2198');
INSERT INTO `tp_region` VALUES ('2218', '宇宙营乡', '4', '2198');
INSERT INTO `tp_region` VALUES ('2219', '察北虚拟乡', '4', '2198');
INSERT INTO `tp_region` VALUES ('2220', '康保县', '3', '2142');
INSERT INTO `tp_region` VALUES ('2221', '康保镇', '4', '2220');
INSERT INTO `tp_region` VALUES ('2222', '张纪镇', '4', '2220');
INSERT INTO `tp_region` VALUES ('2223', '土城子镇', '4', '2220');
INSERT INTO `tp_region` VALUES ('2224', '邓油坊镇', '4', '2220');
INSERT INTO `tp_region` VALUES ('2225', '李家地镇', '4', '2220');
INSERT INTO `tp_region` VALUES ('2226', '照阳河镇', '4', '2220');
INSERT INTO `tp_region` VALUES ('2227', '屯垦镇', '4', '2220');
INSERT INTO `tp_region` VALUES ('2228', '阎油房乡', '4', '2220');
INSERT INTO `tp_region` VALUES ('2229', '丹清河乡', '4', '2220');
INSERT INTO `tp_region` VALUES ('2230', '哈必嘎乡', '4', '2220');
INSERT INTO `tp_region` VALUES ('2231', '二号卜乡', '4', '2220');
INSERT INTO `tp_region` VALUES ('2232', '芦家营乡', '4', '2220');
INSERT INTO `tp_region` VALUES ('2233', '忠义乡', '4', '2220');
INSERT INTO `tp_region` VALUES ('2234', '处长地乡', '4', '2220');
INSERT INTO `tp_region` VALUES ('2235', '满德堂乡', '4', '2220');
INSERT INTO `tp_region` VALUES ('2236', '康保牧场虚拟乡', '4', '2220');
INSERT INTO `tp_region` VALUES ('2237', '沽源县', '3', '2142');
INSERT INTO `tp_region` VALUES ('2238', '平定堡镇', '4', '2237');
INSERT INTO `tp_region` VALUES ('2239', '小厂镇', '4', '2237');
INSERT INTO `tp_region` VALUES ('2240', '黄盖淖镇', '4', '2237');
INSERT INTO `tp_region` VALUES ('2241', '九连城镇', '4', '2237');
INSERT INTO `tp_region` VALUES ('2242', '高山堡乡', '4', '2237');
INSERT INTO `tp_region` VALUES ('2243', '小河子乡', '4', '2237');
INSERT INTO `tp_region` VALUES ('2244', '二道渠乡', '4', '2237');
INSERT INTO `tp_region` VALUES ('2245', '大二号回族乡', '4', '2237');
INSERT INTO `tp_region` VALUES ('2246', '闪电河乡', '4', '2237');
INSERT INTO `tp_region` VALUES ('2247', '长梁乡', '4', '2237');
INSERT INTO `tp_region` VALUES ('2248', '丰源店乡', '4', '2237');
INSERT INTO `tp_region` VALUES ('2249', '西辛营乡', '4', '2237');
INSERT INTO `tp_region` VALUES ('2250', '莲花滩乡', '4', '2237');
INSERT INTO `tp_region` VALUES ('2251', '白土窑乡', '4', '2237');
INSERT INTO `tp_region` VALUES ('2252', '榆树沟虚拟乡', '4', '2237');
INSERT INTO `tp_region` VALUES ('2253', '沙埌子虚拟乡', '4', '2237');
INSERT INTO `tp_region` VALUES ('2254', '小城子虚拟乡', '4', '2237');
INSERT INTO `tp_region` VALUES ('2255', '东大门虚拟乡', '4', '2237');
INSERT INTO `tp_region` VALUES ('2256', '尚义县', '3', '2142');
INSERT INTO `tp_region` VALUES ('2257', '南壕堑镇', '4', '2256');
INSERT INTO `tp_region` VALUES ('2258', '大青沟镇', '4', '2256');
INSERT INTO `tp_region` VALUES ('2259', '八道沟镇', '4', '2256');
INSERT INTO `tp_region` VALUES ('2260', '红土梁镇', '4', '2256');
INSERT INTO `tp_region` VALUES ('2261', '小蒜沟镇', '4', '2256');
INSERT INTO `tp_region` VALUES ('2262', '三工地镇', '4', '2256');
INSERT INTO `tp_region` VALUES ('2263', '大营盘乡', '4', '2256');
INSERT INTO `tp_region` VALUES ('2264', '大苏计乡', '4', '2256');
INSERT INTO `tp_region` VALUES ('2265', '石井乡', '4', '2256');
INSERT INTO `tp_region` VALUES ('2266', '炕塄乡', '4', '2256');
INSERT INTO `tp_region` VALUES ('2267', '七甲乡', '4', '2256');
INSERT INTO `tp_region` VALUES ('2268', '套里庄乡', '4', '2256');
INSERT INTO `tp_region` VALUES ('2269', '甲石河乡', '4', '2256');
INSERT INTO `tp_region` VALUES ('2270', '下马圈乡', '4', '2256');
INSERT INTO `tp_region` VALUES ('2271', '蔚县', '3', '2142');
INSERT INTO `tp_region` VALUES ('2272', '蔚州镇', '4', '2271');
INSERT INTO `tp_region` VALUES ('2273', '代王城镇', '4', '2271');
INSERT INTO `tp_region` VALUES ('2274', '西合营镇', '4', '2271');
INSERT INTO `tp_region` VALUES ('2275', '吉家庄镇', '4', '2271');
INSERT INTO `tp_region` VALUES ('2276', '白乐镇', '4', '2271');
INSERT INTO `tp_region` VALUES ('2277', '暖泉镇', '4', '2271');
INSERT INTO `tp_region` VALUES ('2278', '南留庄镇', '4', '2271');
INSERT INTO `tp_region` VALUES ('2279', '北水泉镇', '4', '2271');
INSERT INTO `tp_region` VALUES ('2280', '桃花镇', '4', '2271');
INSERT INTO `tp_region` VALUES ('2281', '阳眷镇', '4', '2271');
INSERT INTO `tp_region` VALUES ('2282', '宋家庄镇', '4', '2271');
INSERT INTO `tp_region` VALUES ('2283', '下宫村乡', '4', '2271');
INSERT INTO `tp_region` VALUES ('2284', '南杨庄乡', '4', '2271');
INSERT INTO `tp_region` VALUES ('2285', '柏树乡', '4', '2271');
INSERT INTO `tp_region` VALUES ('2286', '常宁乡', '4', '2271');
INSERT INTO `tp_region` VALUES ('2287', '涌泉庄乡', '4', '2271');
INSERT INTO `tp_region` VALUES ('2288', '杨庄窠乡', '4', '2271');
INSERT INTO `tp_region` VALUES ('2289', '南岭庄乡', '4', '2271');
INSERT INTO `tp_region` VALUES ('2290', '陈家洼乡', '4', '2271');
INSERT INTO `tp_region` VALUES ('2291', '黄梅乡', '4', '2271');
INSERT INTO `tp_region` VALUES ('2292', '白草村乡', '4', '2271');
INSERT INTO `tp_region` VALUES ('2293', '草沟堡乡', '4', '2271');
INSERT INTO `tp_region` VALUES ('2294', '阳原县', '3', '2142');
INSERT INTO `tp_region` VALUES ('2295', '西城镇', '4', '2294');
INSERT INTO `tp_region` VALUES ('2296', '东城镇', '4', '2294');
INSERT INTO `tp_region` VALUES ('2297', '化稍营镇', '4', '2294');
INSERT INTO `tp_region` VALUES ('2298', '揣骨疃镇', '4', '2294');
INSERT INTO `tp_region` VALUES ('2299', '东井集镇', '4', '2294');
INSERT INTO `tp_region` VALUES ('2300', '要家庄乡', '4', '2294');
INSERT INTO `tp_region` VALUES ('2301', '东坊城堡乡', '4', '2294');
INSERT INTO `tp_region` VALUES ('2302', '井儿沟乡', '4', '2294');
INSERT INTO `tp_region` VALUES ('2303', '三马坊乡', '4', '2294');
INSERT INTO `tp_region` VALUES ('2304', '高墙乡', '4', '2294');
INSERT INTO `tp_region` VALUES ('2305', '大田洼乡', '4', '2294');
INSERT INTO `tp_region` VALUES ('2306', '辛堡乡', '4', '2294');
INSERT INTO `tp_region` VALUES ('2307', '马圈堡乡', '4', '2294');
INSERT INTO `tp_region` VALUES ('2308', '浮图讲乡', '4', '2294');
INSERT INTO `tp_region` VALUES ('2309', '怀安县', '3', '2142');
INSERT INTO `tp_region` VALUES ('2310', '柴沟堡镇', '4', '2309');
INSERT INTO `tp_region` VALUES ('2311', '左卫镇', '4', '2309');
INSERT INTO `tp_region` VALUES ('2312', '头百户镇', '4', '2309');
INSERT INTO `tp_region` VALUES ('2313', '怀安城镇', '4', '2309');
INSERT INTO `tp_region` VALUES ('2314', '渡口堡乡', '4', '2309');
INSERT INTO `tp_region` VALUES ('2315', '第六屯乡', '4', '2309');
INSERT INTO `tp_region` VALUES ('2316', '西湾堡乡', '4', '2309');
INSERT INTO `tp_region` VALUES ('2317', '西沙城乡', '4', '2309');
INSERT INTO `tp_region` VALUES ('2318', '太平庄乡', '4', '2309');
INSERT INTO `tp_region` VALUES ('2319', '王虎屯乡', '4', '2309');
INSERT INTO `tp_region` VALUES ('2320', '第三堡乡', '4', '2309');
INSERT INTO `tp_region` VALUES ('2321', '万全县', '3', '2142');
INSERT INTO `tp_region` VALUES ('2322', '孔家庄镇', '4', '2321');
INSERT INTO `tp_region` VALUES ('2323', '万全镇', '4', '2321');
INSERT INTO `tp_region` VALUES ('2324', '洗马林镇', '4', '2321');
INSERT INTO `tp_region` VALUES ('2325', '郭磊庄镇', '4', '2321');
INSERT INTO `tp_region` VALUES ('2326', '膳房堡乡', '4', '2321');
INSERT INTO `tp_region` VALUES ('2327', '北新屯乡', '4', '2321');
INSERT INTO `tp_region` VALUES ('2328', '宣平堡乡', '4', '2321');
INSERT INTO `tp_region` VALUES ('2329', '高庙堡乡', '4', '2321');
INSERT INTO `tp_region` VALUES ('2330', '旧堡乡', '4', '2321');
INSERT INTO `tp_region` VALUES ('2331', '安家堡乡', '4', '2321');
INSERT INTO `tp_region` VALUES ('2332', '北沙城乡', '4', '2321');
INSERT INTO `tp_region` VALUES ('2333', '怀来县', '3', '2142');
INSERT INTO `tp_region` VALUES ('2334', '沙城镇', '4', '2333');
INSERT INTO `tp_region` VALUES ('2335', '北辛堡镇', '4', '2333');
INSERT INTO `tp_region` VALUES ('2336', '新保安镇', '4', '2333');
INSERT INTO `tp_region` VALUES ('2337', '东花园镇', '4', '2333');
INSERT INTO `tp_region` VALUES ('2338', '官厅镇', '4', '2333');
INSERT INTO `tp_region` VALUES ('2339', '桑园镇', '4', '2333');
INSERT INTO `tp_region` VALUES ('2340', '存瑞镇', '4', '2333');
INSERT INTO `tp_region` VALUES ('2341', '土木镇', '4', '2333');
INSERT INTO `tp_region` VALUES ('2342', '大黄庄镇', '4', '2333');
INSERT INTO `tp_region` VALUES ('2343', '西八里镇', '4', '2333');
INSERT INTO `tp_region` VALUES ('2344', '小南辛堡镇', '4', '2333');
INSERT INTO `tp_region` VALUES ('2345', '狼山乡', '4', '2333');
INSERT INTO `tp_region` VALUES ('2346', '鸡鸣驿乡', '4', '2333');
INSERT INTO `tp_region` VALUES ('2347', '东八里乡', '4', '2333');
INSERT INTO `tp_region` VALUES ('2348', '瑞云观乡', '4', '2333');
INSERT INTO `tp_region` VALUES ('2349', '孙庄子乡', '4', '2333');
INSERT INTO `tp_region` VALUES ('2350', '王家楼回族乡', '4', '2333');
INSERT INTO `tp_region` VALUES ('2351', '涿鹿县', '3', '2142');
INSERT INTO `tp_region` VALUES ('2352', '涿鹿镇', '4', '2351');
INSERT INTO `tp_region` VALUES ('2353', '张家堡镇', '4', '2351');
INSERT INTO `tp_region` VALUES ('2354', '武家沟镇', '4', '2351');
INSERT INTO `tp_region` VALUES ('2355', '五堡镇', '4', '2351');
INSERT INTO `tp_region` VALUES ('2356', '保岱镇', '4', '2351');
INSERT INTO `tp_region` VALUES ('2357', '矾山镇', '4', '2351');
INSERT INTO `tp_region` VALUES ('2358', '大堡镇', '4', '2351');
INSERT INTO `tp_region` VALUES ('2359', '河东镇', '4', '2351');
INSERT INTO `tp_region` VALUES ('2360', '东小庄乡', '4', '2351');
INSERT INTO `tp_region` VALUES ('2361', '栾庄乡', '4', '2351');
INSERT INTO `tp_region` VALUES ('2362', '温泉屯乡', '4', '2351');
INSERT INTO `tp_region` VALUES ('2363', '辉耀乡', '4', '2351');
INSERT INTO `tp_region` VALUES ('2364', '黑山寺乡', '4', '2351');
INSERT INTO `tp_region` VALUES ('2365', '卧佛寺乡', '4', '2351');
INSERT INTO `tp_region` VALUES ('2366', '谢家堡乡', '4', '2351');
INSERT INTO `tp_region` VALUES ('2367', '大河南乡', '4', '2351');
INSERT INTO `tp_region` VALUES ('2368', '蟒石口乡', '4', '2351');
INSERT INTO `tp_region` VALUES ('2369', '赤城县', '3', '2142');
INSERT INTO `tp_region` VALUES ('2370', '赤城镇', '4', '2369');
INSERT INTO `tp_region` VALUES ('2371', '田家窑镇', '4', '2369');
INSERT INTO `tp_region` VALUES ('2372', '龙关镇', '4', '2369');
INSERT INTO `tp_region` VALUES ('2373', '雕鄂镇', '4', '2369');
INSERT INTO `tp_region` VALUES ('2374', '独石口镇', '4', '2369');
INSERT INTO `tp_region` VALUES ('2375', '白草镇', '4', '2369');
INSERT INTO `tp_region` VALUES ('2376', '龙门所镇', '4', '2369');
INSERT INTO `tp_region` VALUES ('2377', '后城镇', '4', '2369');
INSERT INTO `tp_region` VALUES ('2378', '东卯镇', '4', '2369');
INSERT INTO `tp_region` VALUES ('2379', '炮梁乡', '4', '2369');
INSERT INTO `tp_region` VALUES ('2380', '大海陀乡', '4', '2369');
INSERT INTO `tp_region` VALUES ('2381', '镇宁堡乡', '4', '2369');
INSERT INTO `tp_region` VALUES ('2382', '马营乡', '4', '2369');
INSERT INTO `tp_region` VALUES ('2383', '云州乡', '4', '2369');
INSERT INTO `tp_region` VALUES ('2384', '三道川乡', '4', '2369');
INSERT INTO `tp_region` VALUES ('2385', '东万口乡', '4', '2369');
INSERT INTO `tp_region` VALUES ('2386', '茨营子乡', '4', '2369');
INSERT INTO `tp_region` VALUES ('2387', '样田乡', '4', '2369');
INSERT INTO `tp_region` VALUES ('2388', '崇礼县', '3', '2142');
INSERT INTO `tp_region` VALUES ('2389', '西湾子街道办', '4', '2388');
INSERT INTO `tp_region` VALUES ('2390', '西湾子镇', '4', '2388');
INSERT INTO `tp_region` VALUES ('2391', '高家营镇', '4', '2388');
INSERT INTO `tp_region` VALUES ('2392', '四台嘴乡', '4', '2388');
INSERT INTO `tp_region` VALUES ('2393', '红旗营乡', '4', '2388');
INSERT INTO `tp_region` VALUES ('2394', '石窑子乡', '4', '2388');
INSERT INTO `tp_region` VALUES ('2395', '驿马图乡', '4', '2388');
INSERT INTO `tp_region` VALUES ('2396', '石嘴子乡', '4', '2388');
INSERT INTO `tp_region` VALUES ('2397', '狮子沟乡', '4', '2388');
INSERT INTO `tp_region` VALUES ('2398', '清三营乡', '4', '2388');
INSERT INTO `tp_region` VALUES ('2399', '白旗乡', '4', '2388');
INSERT INTO `tp_region` VALUES ('2400', '承德市', '2', '636');
INSERT INTO `tp_region` VALUES ('2401', '市辖区', '3', '2400');
INSERT INTO `tp_region` VALUES ('2402', '双桥区', '3', '2400');
INSERT INTO `tp_region` VALUES ('2403', '西大街街道', '4', '2402');
INSERT INTO `tp_region` VALUES ('2404', '头道牌楼街道', '4', '2402');
INSERT INTO `tp_region` VALUES ('2405', '潘家沟街道', '4', '2402');
INSERT INTO `tp_region` VALUES ('2406', '中华路街道', '4', '2402');
INSERT INTO `tp_region` VALUES ('2407', '新华路街道', '4', '2402');
INSERT INTO `tp_region` VALUES ('2408', '石洞子沟街道', '4', '2402');
INSERT INTO `tp_region` VALUES ('2409', '桥东街道', '4', '2402');
INSERT INTO `tp_region` VALUES ('2410', '水泉沟镇', '4', '2402');
INSERT INTO `tp_region` VALUES ('2411', '狮子沟镇', '4', '2402');
INSERT INTO `tp_region` VALUES ('2412', '牛圈子沟镇', '4', '2402');
INSERT INTO `tp_region` VALUES ('2413', '大石庙镇', '4', '2402');
INSERT INTO `tp_region` VALUES ('2414', '冯营子镇', '4', '2402');
INSERT INTO `tp_region` VALUES ('2415', '双滦区', '3', '2400');
INSERT INTO `tp_region` VALUES ('2416', '双塔山街道', '4', '2415');
INSERT INTO `tp_region` VALUES ('2417', '滦河街道', '4', '2415');
INSERT INTO `tp_region` VALUES ('2418', '双塔山镇', '4', '2415');
INSERT INTO `tp_region` VALUES ('2419', '滦河镇', '4', '2415');
INSERT INTO `tp_region` VALUES ('2420', '大庙镇', '4', '2415');
INSERT INTO `tp_region` VALUES ('2421', '偏桥子镇', '4', '2415');
INSERT INTO `tp_region` VALUES ('2422', '鹰手营子矿区', '3', '2400');
INSERT INTO `tp_region` VALUES ('2423', '鹰手营子镇', '4', '2422');
INSERT INTO `tp_region` VALUES ('2424', '北马圈子镇', '4', '2422');
INSERT INTO `tp_region` VALUES ('2425', '寿王坟镇', '4', '2422');
INSERT INTO `tp_region` VALUES ('2426', '汪家庄镇', '4', '2422');
INSERT INTO `tp_region` VALUES ('2427', '承德县', '3', '2400');
INSERT INTO `tp_region` VALUES ('2428', '下板城镇', '4', '2427');
INSERT INTO `tp_region` VALUES ('2429', '上板城镇', '4', '2427');
INSERT INTO `tp_region` VALUES ('2430', '甲山镇', '4', '2427');
INSERT INTO `tp_region` VALUES ('2431', '六沟镇', '4', '2427');
INSERT INTO `tp_region` VALUES ('2432', '三沟镇', '4', '2427');
INSERT INTO `tp_region` VALUES ('2433', '头沟镇', '4', '2427');
INSERT INTO `tp_region` VALUES ('2434', '高寺台镇', '4', '2427');
INSERT INTO `tp_region` VALUES ('2435', '双峰寺镇', '4', '2427');
INSERT INTO `tp_region` VALUES ('2436', '东小白旗乡', '4', '2427');
INSERT INTO `tp_region` VALUES ('2437', '鞍匠乡', '4', '2427');
INSERT INTO `tp_region` VALUES ('2438', '刘杖子乡', '4', '2427');
INSERT INTO `tp_region` VALUES ('2439', '新杖子乡', '4', '2427');
INSERT INTO `tp_region` VALUES ('2440', '孟家院乡', '4', '2427');
INSERT INTO `tp_region` VALUES ('2441', '大营子乡', '4', '2427');
INSERT INTO `tp_region` VALUES ('2442', '八家乡', '4', '2427');
INSERT INTO `tp_region` VALUES ('2443', '上谷乡', '4', '2427');
INSERT INTO `tp_region` VALUES ('2444', '满杖子乡', '4', '2427');
INSERT INTO `tp_region` VALUES ('2445', '石灰窑乡', '4', '2427');
INSERT INTO `tp_region` VALUES ('2446', '五道河乡', '4', '2427');
INSERT INTO `tp_region` VALUES ('2447', '岔沟乡', '4', '2427');
INSERT INTO `tp_region` VALUES ('2448', '岗子满族乡', '4', '2427');
INSERT INTO `tp_region` VALUES ('2449', '磴上乡', '4', '2427');
INSERT INTO `tp_region` VALUES ('2450', '两家满族乡', '4', '2427');
INSERT INTO `tp_region` VALUES ('2451', '三家乡', '4', '2427');
INSERT INTO `tp_region` VALUES ('2452', '仓子乡', '4', '2427');
INSERT INTO `tp_region` VALUES ('2453', '兴隆县', '3', '2400');
INSERT INTO `tp_region` VALUES ('2454', '兴隆镇', '4', '2453');
INSERT INTO `tp_region` VALUES ('2455', '半壁山镇', '4', '2453');
INSERT INTO `tp_region` VALUES ('2456', '挂兰峪镇', '4', '2453');
INSERT INTO `tp_region` VALUES ('2457', '青松岭镇', '4', '2453');
INSERT INTO `tp_region` VALUES ('2458', '六道河镇', '4', '2453');
INSERT INTO `tp_region` VALUES ('2459', '平安堡镇', '4', '2453');
INSERT INTO `tp_region` VALUES ('2460', '北营房镇', '4', '2453');
INSERT INTO `tp_region` VALUES ('2461', '南天门满族乡', '4', '2453');
INSERT INTO `tp_region` VALUES ('2462', '孤山子乡', '4', '2453');
INSERT INTO `tp_region` VALUES ('2463', '八卦岭满族乡', '4', '2453');
INSERT INTO `tp_region` VALUES ('2464', '陡子峪乡', '4', '2453');
INSERT INTO `tp_region` VALUES ('2465', '上石洞乡', '4', '2453');
INSERT INTO `tp_region` VALUES ('2466', '北水泉乡', '4', '2453');
INSERT INTO `tp_region` VALUES ('2467', '李家营乡', '4', '2453');
INSERT INTO `tp_region` VALUES ('2468', '大杖子乡', '4', '2453');
INSERT INTO `tp_region` VALUES ('2469', '蘑菇峪乡', '4', '2453');
INSERT INTO `tp_region` VALUES ('2470', '三道河乡', '4', '2453');
INSERT INTO `tp_region` VALUES ('2471', '蓝旗营乡', '4', '2453');
INSERT INTO `tp_region` VALUES ('2472', '安子岭乡', '4', '2453');
INSERT INTO `tp_region` VALUES ('2473', '大水泉乡', '4', '2453');
INSERT INTO `tp_region` VALUES ('2474', '平泉县', '3', '2400');
INSERT INTO `tp_region` VALUES ('2475', '平泉镇', '4', '2474');
INSERT INTO `tp_region` VALUES ('2476', '黄土梁子镇', '4', '2474');
INSERT INTO `tp_region` VALUES ('2477', '榆树林子镇', '4', '2474');
INSERT INTO `tp_region` VALUES ('2478', '杨树岭镇', '4', '2474');
INSERT INTO `tp_region` VALUES ('2479', '七沟镇', '4', '2474');
INSERT INTO `tp_region` VALUES ('2480', '小寺沟镇', '4', '2474');
INSERT INTO `tp_region` VALUES ('2481', '党坝镇', '4', '2474');
INSERT INTO `tp_region` VALUES ('2482', '卧龙镇', '4', '2474');
INSERT INTO `tp_region` VALUES ('2483', '南五十家子镇', '4', '2474');
INSERT INTO `tp_region` VALUES ('2484', '王土房乡', '4', '2474');
INSERT INTO `tp_region` VALUES ('2485', '柳溪满族乡', '4', '2474');
INSERT INTO `tp_region` VALUES ('2486', '七家岱满族乡', '4', '2474');
INSERT INTO `tp_region` VALUES ('2487', '平房满族蒙古族乡', '4', '2474');
INSERT INTO `tp_region` VALUES ('2488', '蒙和乌苏蒙古族乡', '4', '2474');
INSERT INTO `tp_region` VALUES ('2489', '茅兰沟满族蒙古族乡', '4', '2474');
INSERT INTO `tp_region` VALUES ('2490', '台头山乡', '4', '2474');
INSERT INTO `tp_region` VALUES ('2491', '松树台乡', '4', '2474');
INSERT INTO `tp_region` VALUES ('2492', '道虎沟乡', '4', '2474');
INSERT INTO `tp_region` VALUES ('2493', '郭杖子满族乡', '4', '2474');
INSERT INTO `tp_region` VALUES ('2494', '滦平县', '3', '2400');
INSERT INTO `tp_region` VALUES ('2495', '滦平镇', '4', '2494');
INSERT INTO `tp_region` VALUES ('2496', '长山峪镇', '4', '2494');
INSERT INTO `tp_region` VALUES ('2497', '红旗镇', '4', '2494');
INSERT INTO `tp_region` VALUES ('2498', '金沟屯镇', '4', '2494');
INSERT INTO `tp_region` VALUES ('2499', '虎什哈镇', '4', '2494');
INSERT INTO `tp_region` VALUES ('2500', '巴克什营镇', '4', '2494');
INSERT INTO `tp_region` VALUES ('2501', '张百湾镇', '4', '2494');
INSERT INTO `tp_region` VALUES ('2502', '平坊满族乡', '4', '2494');
INSERT INTO `tp_region` VALUES ('2503', '安纯沟门满族乡', '4', '2494');
INSERT INTO `tp_region` VALUES ('2504', '西地满族乡', '4', '2494');
INSERT INTO `tp_region` VALUES ('2505', '陈栅子乡', '4', '2494');
INSERT INTO `tp_region` VALUES ('2506', '付营子乡', '4', '2494');
INSERT INTO `tp_region` VALUES ('2507', '小营满族乡', '4', '2494');
INSERT INTO `tp_region` VALUES ('2508', '西沟满族乡', '4', '2494');
INSERT INTO `tp_region` VALUES ('2509', '邓厂满族乡', '4', '2494');
INSERT INTO `tp_region` VALUES ('2510', '五道营子满族乡', '4', '2494');
INSERT INTO `tp_region` VALUES ('2511', '马营子满族乡', '4', '2494');
INSERT INTO `tp_region` VALUES ('2512', '付家店满族乡', '4', '2494');
INSERT INTO `tp_region` VALUES ('2513', '火斗山乡', '4', '2494');
INSERT INTO `tp_region` VALUES ('2514', '两间房乡', '4', '2494');
INSERT INTO `tp_region` VALUES ('2515', '涝洼乡', '4', '2494');
INSERT INTO `tp_region` VALUES ('2516', '大屯满族乡', '4', '2494');
INSERT INTO `tp_region` VALUES ('2517', '隆化县', '3', '2400');
INSERT INTO `tp_region` VALUES ('2518', '隆化镇', '4', '2517');
INSERT INTO `tp_region` VALUES ('2519', '韩麻营镇', '4', '2517');
INSERT INTO `tp_region` VALUES ('2520', '中关镇', '4', '2517');
INSERT INTO `tp_region` VALUES ('2521', '七家镇', '4', '2517');
INSERT INTO `tp_region` VALUES ('2522', '汤头沟镇', '4', '2517');
INSERT INTO `tp_region` VALUES ('2523', '张三营镇', '4', '2517');
INSERT INTO `tp_region` VALUES ('2524', '唐三营镇', '4', '2517');
INSERT INTO `tp_region` VALUES ('2525', '蓝旗镇', '4', '2517');
INSERT INTO `tp_region` VALUES ('2526', '步古沟镇', '4', '2517');
INSERT INTO `tp_region` VALUES ('2527', '郭家屯镇', '4', '2517');
INSERT INTO `tp_region` VALUES ('2528', '荒地乡', '4', '2517');
INSERT INTO `tp_region` VALUES ('2529', '章吉营乡', '4', '2517');
INSERT INTO `tp_region` VALUES ('2530', '茅荆坝乡', '4', '2517');
INSERT INTO `tp_region` VALUES ('2531', '尹家营满族乡', '4', '2517');
INSERT INTO `tp_region` VALUES ('2532', '庙子沟蒙古族满族乡', '4', '2517');
INSERT INTO `tp_region` VALUES ('2533', '偏坡营满族乡', '4', '2517');
INSERT INTO `tp_region` VALUES ('2534', '山湾乡', '4', '2517');
INSERT INTO `tp_region` VALUES ('2535', '八达营蒙古族乡', '4', '2517');
INSERT INTO `tp_region` VALUES ('2536', '太平庄满族乡', '4', '2517');
INSERT INTO `tp_region` VALUES ('2537', '旧屯满族乡', '4', '2517');
INSERT INTO `tp_region` VALUES ('2538', '西阿超满族蒙古族乡', '4', '2517');
INSERT INTO `tp_region` VALUES ('2539', '白虎沟满族蒙古族乡', '4', '2517');
INSERT INTO `tp_region` VALUES ('2540', '碱房乡', '4', '2517');
INSERT INTO `tp_region` VALUES ('2541', '韩家店乡', '4', '2517');
INSERT INTO `tp_region` VALUES ('2542', '湾沟门乡', '4', '2517');
INSERT INTO `tp_region` VALUES ('2543', '丰宁满族自治县', '3', '2400');
INSERT INTO `tp_region` VALUES ('2544', '大阁镇', '4', '2543');
INSERT INTO `tp_region` VALUES ('2545', '大滩镇', '4', '2543');
INSERT INTO `tp_region` VALUES ('2546', '鱼儿山镇', '4', '2543');
INSERT INTO `tp_region` VALUES ('2547', '土城镇', '4', '2543');
INSERT INTO `tp_region` VALUES ('2548', '黄旗镇', '4', '2543');
INSERT INTO `tp_region` VALUES ('2549', '凤山镇', '4', '2543');
INSERT INTO `tp_region` VALUES ('2550', '波罗诺镇', '4', '2543');
INSERT INTO `tp_region` VALUES ('2551', '黑山咀镇', '4', '2543');
INSERT INTO `tp_region` VALUES ('2552', '天桥镇', '4', '2543');
INSERT INTO `tp_region` VALUES ('2553', '万胜永乡', '4', '2543');
INSERT INTO `tp_region` VALUES ('2554', '四岔口乡', '4', '2543');
INSERT INTO `tp_region` VALUES ('2555', '苏家店乡', '4', '2543');
INSERT INTO `tp_region` VALUES ('2556', '外沟门乡', '4', '2543');
INSERT INTO `tp_region` VALUES ('2557', '草原乡', '4', '2543');
INSERT INTO `tp_region` VALUES ('2558', '窟窿山乡', '4', '2543');
INSERT INTO `tp_region` VALUES ('2559', '小坝子乡', '4', '2543');
INSERT INTO `tp_region` VALUES ('2560', '五道营乡', '4', '2543');
INSERT INTO `tp_region` VALUES ('2561', '南关蒙古族乡', '4', '2543');
INSERT INTO `tp_region` VALUES ('2562', '选将营乡', '4', '2543');
INSERT INTO `tp_region` VALUES ('2563', '西官营乡', '4', '2543');
INSERT INTO `tp_region` VALUES ('2564', '王营乡', '4', '2543');
INSERT INTO `tp_region` VALUES ('2565', '北头营乡', '4', '2543');
INSERT INTO `tp_region` VALUES ('2566', '胡麻营乡', '4', '2543');
INSERT INTO `tp_region` VALUES ('2567', '石人沟乡', '4', '2543');
INSERT INTO `tp_region` VALUES ('2568', '汤河乡', '4', '2543');
INSERT INTO `tp_region` VALUES ('2569', '杨木栅子乡', '4', '2543');
INSERT INTO `tp_region` VALUES ('2570', '宽城满族自治县', '3', '2400');
INSERT INTO `tp_region` VALUES ('2571', '宽城镇', '4', '2570');
INSERT INTO `tp_region` VALUES ('2572', '龙须门镇', '4', '2570');
INSERT INTO `tp_region` VALUES ('2573', '峪耳崖镇', '4', '2570');
INSERT INTO `tp_region` VALUES ('2574', '板城镇', '4', '2570');
INSERT INTO `tp_region` VALUES ('2575', '汤道河镇', '4', '2570');
INSERT INTO `tp_region` VALUES ('2576', '化皮溜子乡', '4', '2570');
INSERT INTO `tp_region` VALUES ('2577', '塌山乡', '4', '2570');
INSERT INTO `tp_region` VALUES ('2578', '饽罗台乡', '4', '2570');
INSERT INTO `tp_region` VALUES ('2579', '孟子岭乡', '4', '2570');
INSERT INTO `tp_region` VALUES ('2580', '独石沟乡', '4', '2570');
INSERT INTO `tp_region` VALUES ('2581', '碾子峪乡', '4', '2570');
INSERT INTO `tp_region` VALUES ('2582', '东大地乡', '4', '2570');
INSERT INTO `tp_region` VALUES ('2583', '铧尖乡', '4', '2570');
INSERT INTO `tp_region` VALUES ('2584', '东黄花川乡', '4', '2570');
INSERT INTO `tp_region` VALUES ('2585', '亮甲台乡', '4', '2570');
INSERT INTO `tp_region` VALUES ('2586', '苇子沟乡', '4', '2570');
INSERT INTO `tp_region` VALUES ('2587', '大字沟门乡', '4', '2570');
INSERT INTO `tp_region` VALUES ('2588', '大石柱子乡', '4', '2570');
INSERT INTO `tp_region` VALUES ('2589', '围场满族蒙古族自治县', '3', '2400');
INSERT INTO `tp_region` VALUES ('2590', '围场镇', '4', '2589');
INSERT INTO `tp_region` VALUES ('2591', '四合永镇', '4', '2589');
INSERT INTO `tp_region` VALUES ('2592', '克勒沟镇', '4', '2589');
INSERT INTO `tp_region` VALUES ('2593', '棋盘山镇', '4', '2589');
INSERT INTO `tp_region` VALUES ('2594', '半截塔镇', '4', '2589');
INSERT INTO `tp_region` VALUES ('2595', '朝阳地镇', '4', '2589');
INSERT INTO `tp_region` VALUES ('2596', '朝阳湾镇', '4', '2589');
INSERT INTO `tp_region` VALUES ('2597', '道坝子乡', '4', '2589');
INSERT INTO `tp_region` VALUES ('2598', '龙头山乡', '4', '2589');
INSERT INTO `tp_region` VALUES ('2599', '腰站乡', '4', '2589');
INSERT INTO `tp_region` VALUES ('2600', '黄土坎乡', '4', '2589');
INSERT INTO `tp_region` VALUES ('2601', '四道沟乡', '4', '2589');
INSERT INTO `tp_region` VALUES ('2602', '兰旗卡伦乡', '4', '2589');
INSERT INTO `tp_region` VALUES ('2603', '银窝沟乡', '4', '2589');
INSERT INTO `tp_region` VALUES ('2604', '新地乡', '4', '2589');
INSERT INTO `tp_region` VALUES ('2605', '广发永乡', '4', '2589');
INSERT INTO `tp_region` VALUES ('2606', '育太和乡', '4', '2589');
INSERT INTO `tp_region` VALUES ('2607', '郭家湾乡', '4', '2589');
INSERT INTO `tp_region` VALUES ('2608', '杨家湾乡', '4', '2589');
INSERT INTO `tp_region` VALUES ('2609', '大唤起乡', '4', '2589');
INSERT INTO `tp_region` VALUES ('2610', '哈里哈乡', '4', '2589');
INSERT INTO `tp_region` VALUES ('2611', '新拨乡', '4', '2589');
INSERT INTO `tp_region` VALUES ('2612', '张家湾乡', '4', '2589');
INSERT INTO `tp_region` VALUES ('2613', '宝元栈乡', '4', '2589');
INSERT INTO `tp_region` VALUES ('2614', '山湾子乡', '4', '2589');
INSERT INTO `tp_region` VALUES ('2615', '三义永乡', '4', '2589');
INSERT INTO `tp_region` VALUES ('2616', '姜家店乡', '4', '2589');
INSERT INTO `tp_region` VALUES ('2617', '下伙房乡', '4', '2589');
INSERT INTO `tp_region` VALUES ('2618', '燕格柏乡', '4', '2589');
INSERT INTO `tp_region` VALUES ('2619', '牌楼乡', '4', '2589');
INSERT INTO `tp_region` VALUES ('2620', '城子乡', '4', '2589');
INSERT INTO `tp_region` VALUES ('2621', '老窝铺乡', '4', '2589');
INSERT INTO `tp_region` VALUES ('2622', '御道口乡', '4', '2589');
INSERT INTO `tp_region` VALUES ('2623', '石桌子乡', '4', '2589');
INSERT INTO `tp_region` VALUES ('2624', '大头山乡', '4', '2589');
INSERT INTO `tp_region` VALUES ('2625', '南山嘴乡', '4', '2589');
INSERT INTO `tp_region` VALUES ('2626', '西龙头乡', '4', '2589');
INSERT INTO `tp_region` VALUES ('2627', '塞罕坝机械林场虚拟镇', '4', '2589');
INSERT INTO `tp_region` VALUES ('2628', '国营御道口牧场虚拟乡', '4', '2589');
INSERT INTO `tp_region` VALUES ('2629', '沧州市', '2', '636');
INSERT INTO `tp_region` VALUES ('2630', '市辖区', '3', '2629');
INSERT INTO `tp_region` VALUES ('2631', '新华区', '3', '2629');
INSERT INTO `tp_region` VALUES ('2632', '建设北街街道', '4', '2631');
INSERT INTO `tp_region` VALUES ('2633', '车站街道', '4', '2631');
INSERT INTO `tp_region` VALUES ('2634', '南大街街道', '4', '2631');
INSERT INTO `tp_region` VALUES ('2635', '东环街道', '4', '2631');
INSERT INTO `tp_region` VALUES ('2636', '道东街道', '4', '2631');
INSERT INTO `tp_region` VALUES ('2637', '小赵庄乡', '4', '2631');
INSERT INTO `tp_region` VALUES ('2638', '沧州开发区', '4', '2631');
INSERT INTO `tp_region` VALUES ('2639', '运河区', '3', '2629');
INSERT INTO `tp_region` VALUES ('2640', '水月寺街道', '4', '2639');
INSERT INTO `tp_region` VALUES ('2641', '南环中路街道', '4', '2639');
INSERT INTO `tp_region` VALUES ('2642', '南湖街道', '4', '2639');
INSERT INTO `tp_region` VALUES ('2643', '市场街道', '4', '2639');
INSERT INTO `tp_region` VALUES ('2644', '西环中街街道', '4', '2639');
INSERT INTO `tp_region` VALUES ('2645', '公园街道', '4', '2639');
INSERT INTO `tp_region` VALUES ('2646', '小王庄镇', '4', '2639');
INSERT INTO `tp_region` VALUES ('2647', '南陈屯乡', '4', '2639');
INSERT INTO `tp_region` VALUES ('2648', '沧县', '3', '2629');
INSERT INTO `tp_region` VALUES ('2649', '旧州镇', '4', '2648');
INSERT INTO `tp_region` VALUES ('2650', '兴济镇', '4', '2648');
INSERT INTO `tp_region` VALUES ('2651', '杜生镇', '4', '2648');
INSERT INTO `tp_region` VALUES ('2652', '崔尔庄镇', '4', '2648');
INSERT INTO `tp_region` VALUES ('2653', '薛官屯乡', '4', '2648');
INSERT INTO `tp_region` VALUES ('2654', '捷地回族乡', '4', '2648');
INSERT INTO `tp_region` VALUES ('2655', '张官屯乡', '4', '2648');
INSERT INTO `tp_region` VALUES ('2656', '李天木回族乡', '4', '2648');
INSERT INTO `tp_region` VALUES ('2657', '风化店乡', '4', '2648');
INSERT INTO `tp_region` VALUES ('2658', '姚官屯乡', '4', '2648');
INSERT INTO `tp_region` VALUES ('2659', '杜林回族乡', '4', '2648');
INSERT INTO `tp_region` VALUES ('2660', '汪家铺乡', '4', '2648');
INSERT INTO `tp_region` VALUES ('2661', '刘家庙乡', '4', '2648');
INSERT INTO `tp_region` VALUES ('2662', '仵龙堂乡', '4', '2648');
INSERT INTO `tp_region` VALUES ('2663', '大官厅乡', '4', '2648');
INSERT INTO `tp_region` VALUES ('2664', '高川乡', '4', '2648');
INSERT INTO `tp_region` VALUES ('2665', '黄递铺乡', '4', '2648');
INSERT INTO `tp_region` VALUES ('2666', '大褚村回族乡', '4', '2648');
INSERT INTO `tp_region` VALUES ('2667', '纸房头乡', '4', '2648');
INSERT INTO `tp_region` VALUES ('2668', '青县', '3', '2629');
INSERT INTO `tp_region` VALUES ('2669', '清州镇', '4', '2668');
INSERT INTO `tp_region` VALUES ('2670', '金牛镇', '4', '2668');
INSERT INTO `tp_region` VALUES ('2671', '新兴镇', '4', '2668');
INSERT INTO `tp_region` VALUES ('2672', '流河镇', '4', '2668');
INSERT INTO `tp_region` VALUES ('2673', '木门店镇', '4', '2668');
INSERT INTO `tp_region` VALUES ('2674', '马厂镇', '4', '2668');
INSERT INTO `tp_region` VALUES ('2675', '上伍乡', '4', '2668');
INSERT INTO `tp_region` VALUES ('2676', '曹寺乡', '4', '2668');
INSERT INTO `tp_region` VALUES ('2677', '盘古乡', '4', '2668');
INSERT INTO `tp_region` VALUES ('2678', '陈嘴乡', '4', '2668');
INSERT INTO `tp_region` VALUES ('2679', '农场虚拟乡', '4', '2668');
INSERT INTO `tp_region` VALUES ('2680', '东光县', '3', '2629');
INSERT INTO `tp_region` VALUES ('2681', '东光镇', '4', '2680');
INSERT INTO `tp_region` VALUES ('2682', '连镇镇', '4', '2680');
INSERT INTO `tp_region` VALUES ('2683', '找王镇', '4', '2680');
INSERT INTO `tp_region` VALUES ('2684', '秦村镇', '4', '2680');
INSERT INTO `tp_region` VALUES ('2685', '灯明寺镇', '4', '2680');
INSERT INTO `tp_region` VALUES ('2686', '南霞口镇', '4', '2680');
INSERT INTO `tp_region` VALUES ('2687', '大单镇', '4', '2680');
INSERT INTO `tp_region` VALUES ('2688', '龙王李乡', '4', '2680');
INSERT INTO `tp_region` VALUES ('2689', '于桥乡', '4', '2680');
INSERT INTO `tp_region` VALUES ('2690', '海兴县', '3', '2629');
INSERT INTO `tp_region` VALUES ('2691', '苏基镇', '4', '2690');
INSERT INTO `tp_region` VALUES ('2692', '辛集镇', '4', '2690');
INSERT INTO `tp_region` VALUES ('2693', '高湾镇', '4', '2690');
INSERT INTO `tp_region` VALUES ('2694', '赵毛陶乡', '4', '2690');
INSERT INTO `tp_region` VALUES ('2695', '香坊乡', '4', '2690');
INSERT INTO `tp_region` VALUES ('2696', '小山乡', '4', '2690');
INSERT INTO `tp_region` VALUES ('2697', '张会亭乡', '4', '2690');
INSERT INTO `tp_region` VALUES ('2698', '海兴县农场', '4', '2690');
INSERT INTO `tp_region` VALUES ('2699', '青先农场', '4', '2690');
INSERT INTO `tp_region` VALUES ('2700', '青锋农场', '4', '2690');
INSERT INTO `tp_region` VALUES ('2701', '盐山县', '3', '2629');
INSERT INTO `tp_region` VALUES ('2702', '盐山镇', '4', '2701');
INSERT INTO `tp_region` VALUES ('2703', '望树镇', '4', '2701');
INSERT INTO `tp_region` VALUES ('2704', '庆云镇', '4', '2701');
INSERT INTO `tp_region` VALUES ('2705', '韩集镇', '4', '2701');
INSERT INTO `tp_region` VALUES ('2706', '千童镇', '4', '2701');
INSERT INTO `tp_region` VALUES ('2707', '圣佛镇', '4', '2701');
INSERT INTO `tp_region` VALUES ('2708', '边务乡', '4', '2701');
INSERT INTO `tp_region` VALUES ('2709', '小营乡', '4', '2701');
INSERT INTO `tp_region` VALUES ('2710', '杨集乡', '4', '2701');
INSERT INTO `tp_region` VALUES ('2711', '孟店乡', '4', '2701');
INSERT INTO `tp_region` VALUES ('2712', '常庄乡', '4', '2701');
INSERT INTO `tp_region` VALUES ('2713', '小庄乡', '4', '2701');
INSERT INTO `tp_region` VALUES ('2714', '肃宁县', '3', '2629');
INSERT INTO `tp_region` VALUES ('2715', '肃宁镇', '4', '2714');
INSERT INTO `tp_region` VALUES ('2716', '梁家村镇', '4', '2714');
INSERT INTO `tp_region` VALUES ('2717', '窝北镇', '4', '2714');
INSERT INTO `tp_region` VALUES ('2718', '尚村镇', '4', '2714');
INSERT INTO `tp_region` VALUES ('2719', '万里镇', '4', '2714');
INSERT INTO `tp_region` VALUES ('2720', '师素乡', '4', '2714');
INSERT INTO `tp_region` VALUES ('2721', '河北留善寺乡', '4', '2714');
INSERT INTO `tp_region` VALUES ('2722', '付家佐乡', '4', '2714');
INSERT INTO `tp_region` VALUES ('2723', '邵庄乡', '4', '2714');
INSERT INTO `tp_region` VALUES ('2724', '南皮县', '3', '2629');
INSERT INTO `tp_region` VALUES ('2725', '南皮镇', '4', '2724');
INSERT INTO `tp_region` VALUES ('2726', '冯家口镇', '4', '2724');
INSERT INTO `tp_region` VALUES ('2727', '寨子镇', '4', '2724');
INSERT INTO `tp_region` VALUES ('2728', '鲍官屯镇', '4', '2724');
INSERT INTO `tp_region` VALUES ('2729', '王寺镇', '4', '2724');
INSERT INTO `tp_region` VALUES ('2730', '乌马营镇', '4', '2724');
INSERT INTO `tp_region` VALUES ('2731', '大浪淀乡', '4', '2724');
INSERT INTO `tp_region` VALUES ('2732', '刘八里乡', '4', '2724');
INSERT INTO `tp_region` VALUES ('2733', '潞灌乡', '4', '2724');
INSERT INTO `tp_region` VALUES ('2734', '吴桥县', '3', '2629');
INSERT INTO `tp_region` VALUES ('2735', '桑园镇', '4', '2734');
INSERT INTO `tp_region` VALUES ('2736', '铁城镇', '4', '2734');
INSERT INTO `tp_region` VALUES ('2737', '于集镇', '4', '2734');
INSERT INTO `tp_region` VALUES ('2738', '梁集镇', '4', '2734');
INSERT INTO `tp_region` VALUES ('2739', '安陵镇', '4', '2734');
INSERT INTO `tp_region` VALUES ('2740', '曹家洼乡', '4', '2734');
INSERT INTO `tp_region` VALUES ('2741', '宋门乡', '4', '2734');
INSERT INTO `tp_region` VALUES ('2742', '杨家寺乡', '4', '2734');
INSERT INTO `tp_region` VALUES ('2743', '沟店铺乡', '4', '2734');
INSERT INTO `tp_region` VALUES ('2744', '何庄乡', '4', '2734');
INSERT INTO `tp_region` VALUES ('2745', '献县', '3', '2629');
INSERT INTO `tp_region` VALUES ('2746', '乐寿镇', '4', '2745');
INSERT INTO `tp_region` VALUES ('2747', '淮镇镇', '4', '2745');
INSERT INTO `tp_region` VALUES ('2748', '郭庄镇', '4', '2745');
INSERT INTO `tp_region` VALUES ('2749', '河城街镇', '4', '2745');
INSERT INTO `tp_region` VALUES ('2750', '韩村乡', '4', '2745');
INSERT INTO `tp_region` VALUES ('2751', '陌南乡', '4', '2745');
INSERT INTO `tp_region` VALUES ('2752', '陈庄乡', '4', '2745');
INSERT INTO `tp_region` VALUES ('2753', '徐留高乡', '4', '2745');
INSERT INTO `tp_region` VALUES ('2754', '商林乡', '4', '2745');
INSERT INTO `tp_region` VALUES ('2755', '段村乡', '4', '2745');
INSERT INTO `tp_region` VALUES ('2756', '张村乡', '4', '2745');
INSERT INTO `tp_region` VALUES ('2757', '临河乡', '4', '2745');
INSERT INTO `tp_region` VALUES ('2758', '小平王乡', '4', '2745');
INSERT INTO `tp_region` VALUES ('2759', '十五级乡', '4', '2745');
INSERT INTO `tp_region` VALUES ('2760', '垒头乡', '4', '2745');
INSERT INTO `tp_region` VALUES ('2761', '南河头乡', '4', '2745');
INSERT INTO `tp_region` VALUES ('2762', '西城乡', '4', '2745');
INSERT INTO `tp_region` VALUES ('2763', '本斋回族乡', '4', '2745');
INSERT INTO `tp_region` VALUES ('2764', '农场', '4', '2745');
INSERT INTO `tp_region` VALUES ('2765', '孟村回族自治县', '3', '2629');
INSERT INTO `tp_region` VALUES ('2766', '孟村镇', '4', '2765');
INSERT INTO `tp_region` VALUES ('2767', '新县镇', '4', '2765');
INSERT INTO `tp_region` VALUES ('2768', '辛店镇', '4', '2765');
INSERT INTO `tp_region` VALUES ('2769', '高寨镇', '4', '2765');
INSERT INTO `tp_region` VALUES ('2770', '宋庄子乡', '4', '2765');
INSERT INTO `tp_region` VALUES ('2771', '牛进庄乡', '4', '2765');
INSERT INTO `tp_region` VALUES ('2772', '泊头市', '3', '2629');
INSERT INTO `tp_region` VALUES ('2773', '解放街道', '4', '2772');
INSERT INTO `tp_region` VALUES ('2774', '河东街道', '4', '2772');
INSERT INTO `tp_region` VALUES ('2775', '古楼街道', '4', '2772');
INSERT INTO `tp_region` VALUES ('2776', '泊镇', '4', '2772');
INSERT INTO `tp_region` VALUES ('2777', '交河镇', '4', '2772');
INSERT INTO `tp_region` VALUES ('2778', '齐桥镇', '4', '2772');
INSERT INTO `tp_region` VALUES ('2779', '寺门村镇', '4', '2772');
INSERT INTO `tp_region` VALUES ('2780', '郝村镇', '4', '2772');
INSERT INTO `tp_region` VALUES ('2781', '富镇镇', '4', '2772');
INSERT INTO `tp_region` VALUES ('2782', '文庙镇', '4', '2772');
INSERT INTO `tp_region` VALUES ('2783', '洼里王镇', '4', '2772');
INSERT INTO `tp_region` VALUES ('2784', '王武庄乡', '4', '2772');
INSERT INTO `tp_region` VALUES ('2785', '营子乡', '4', '2772');
INSERT INTO `tp_region` VALUES ('2786', '四营乡', '4', '2772');
INSERT INTO `tp_region` VALUES ('2787', '西辛店乡', '4', '2772');
INSERT INTO `tp_region` VALUES ('2788', '任邱市', '3', '2629');
INSERT INTO `tp_region` VALUES ('2789', '新华路街道', '4', '2788');
INSERT INTO `tp_region` VALUES ('2790', '西环路街道', '4', '2788');
INSERT INTO `tp_region` VALUES ('2791', '永丰路街道', '4', '2788');
INSERT INTO `tp_region` VALUES ('2792', '出岸镇', '4', '2788');
INSERT INTO `tp_region` VALUES ('2793', '石门桥镇', '4', '2788');
INSERT INTO `tp_region` VALUES ('2794', '吕公堡镇', '4', '2788');
INSERT INTO `tp_region` VALUES ('2795', '长丰镇', '4', '2788');
INSERT INTO `tp_region` VALUES ('2796', '莫州镇', '4', '2788');
INSERT INTO `tp_region` VALUES ('2797', '苟各庄镇', '4', '2788');
INSERT INTO `tp_region` VALUES ('2798', '梁召镇', '4', '2788');
INSERT INTO `tp_region` VALUES ('2799', '辛中驿镇', '4', '2788');
INSERT INTO `tp_region` VALUES ('2800', '麻家坞乡', '4', '2788');
INSERT INTO `tp_region` VALUES ('2801', '议论堡乡', '4', '2788');
INSERT INTO `tp_region` VALUES ('2802', '青塔乡', '4', '2788');
INSERT INTO `tp_region` VALUES ('2803', '北辛庄乡', '4', '2788');
INSERT INTO `tp_region` VALUES ('2804', '七间房乡', '4', '2788');
INSERT INTO `tp_region` VALUES ('2805', '北汉乡', '4', '2788');
INSERT INTO `tp_region` VALUES ('2806', '于村乡', '4', '2788');
INSERT INTO `tp_region` VALUES ('2807', '华北石油管理局虚拟街道', '4', '2788');
INSERT INTO `tp_region` VALUES ('2808', '开发区管理委员会', '4', '2788');
INSERT INTO `tp_region` VALUES ('2809', '黄骅市', '3', '2629');
INSERT INTO `tp_region` VALUES ('2810', '骅东街道', '4', '2809');
INSERT INTO `tp_region` VALUES ('2811', '骅中街道', '4', '2809');
INSERT INTO `tp_region` VALUES ('2812', '骅西街道', '4', '2809');
INSERT INTO `tp_region` VALUES ('2813', '黄骅镇', '4', '2809');
INSERT INTO `tp_region` VALUES ('2814', '南排河镇', '4', '2809');
INSERT INTO `tp_region` VALUES ('2815', '吕桥镇', '4', '2809');
INSERT INTO `tp_region` VALUES ('2816', '旧城镇', '4', '2809');
INSERT INTO `tp_region` VALUES ('2817', '羊二庄回族乡', '4', '2809');
INSERT INTO `tp_region` VALUES ('2818', '常郭乡', '4', '2809');
INSERT INTO `tp_region` VALUES ('2819', '滕庄子乡', '4', '2809');
INSERT INTO `tp_region` VALUES ('2820', '官庄乡', '4', '2809');
INSERT INTO `tp_region` VALUES ('2821', '齐家务乡', '4', '2809');
INSERT INTO `tp_region` VALUES ('2822', '港城开发区新村乡', '4', '2809');
INSERT INTO `tp_region` VALUES ('2823', '羊三木乡', '4', '2809');
INSERT INTO `tp_region` VALUES ('2824', '南大港管理区虚拟乡', '4', '2809');
INSERT INTO `tp_region` VALUES ('2825', '国营中捷农场虚拟乡', '4', '2809');
INSERT INTO `tp_region` VALUES ('2826', '黄骅港开发区虚拟乡', '4', '2809');
INSERT INTO `tp_region` VALUES ('2827', '临港化工园区', '4', '2809');
INSERT INTO `tp_region` VALUES ('2828', '河间市', '3', '2629');
INSERT INTO `tp_region` VALUES ('2829', '瀛州镇', '4', '2828');
INSERT INTO `tp_region` VALUES ('2830', '米各庄镇', '4', '2828');
INSERT INTO `tp_region` VALUES ('2831', '景和镇', '4', '2828');
INSERT INTO `tp_region` VALUES ('2832', '卧佛堂镇', '4', '2828');
INSERT INTO `tp_region` VALUES ('2833', '束城镇', '4', '2828');
INSERT INTO `tp_region` VALUES ('2834', '留古寺镇', '4', '2828');
INSERT INTO `tp_region` VALUES ('2835', '沙河桥镇', '4', '2828');
INSERT INTO `tp_region` VALUES ('2836', '故仙乡', '4', '2828');
INSERT INTO `tp_region` VALUES ('2837', '黎民居乡', '4', '2828');
INSERT INTO `tp_region` VALUES ('2838', '兴村乡', '4', '2828');
INSERT INTO `tp_region` VALUES ('2839', '沙洼乡', '4', '2828');
INSERT INTO `tp_region` VALUES ('2840', '西九吉乡', '4', '2828');
INSERT INTO `tp_region` VALUES ('2841', '北石槽乡', '4', '2828');
INSERT INTO `tp_region` VALUES ('2842', '诗经村乡', '4', '2828');
INSERT INTO `tp_region` VALUES ('2843', '郭家村乡', '4', '2828');
INSERT INTO `tp_region` VALUES ('2844', '时村乡', '4', '2828');
INSERT INTO `tp_region` VALUES ('2845', '行别营乡', '4', '2828');
INSERT INTO `tp_region` VALUES ('2846', '尊祖庄乡', '4', '2828');
INSERT INTO `tp_region` VALUES ('2847', '龙华店乡', '4', '2828');
INSERT INTO `tp_region` VALUES ('2848', '果子洼乡', '4', '2828');
INSERT INTO `tp_region` VALUES ('2849', '廊坊市', '2', '636');
INSERT INTO `tp_region` VALUES ('2850', '市辖区', '3', '2849');
INSERT INTO `tp_region` VALUES ('2851', '安次区', '3', '2849');
INSERT INTO `tp_region` VALUES ('2852', '银河南路街道', '4', '2851');
INSERT INTO `tp_region` VALUES ('2853', '光明西道街道', '4', '2851');
INSERT INTO `tp_region` VALUES ('2854', '落垡镇', '4', '2851');
INSERT INTO `tp_region` VALUES ('2855', '码头镇', '4', '2851');
INSERT INTO `tp_region` VALUES ('2856', '葛渔城镇', '4', '2851');
INSERT INTO `tp_region` VALUES ('2857', '东沽港镇', '4', '2851');
INSERT INTO `tp_region` VALUES ('2858', '杨税务乡', '4', '2851');
INSERT INTO `tp_region` VALUES ('2859', '仇庄乡', '4', '2851');
INSERT INTO `tp_region` VALUES ('2860', '调河头乡', '4', '2851');
INSERT INTO `tp_region` VALUES ('2861', '北史家务乡', '4', '2851');
INSERT INTO `tp_region` VALUES ('2862', '广阳区', '3', '2849');
INSERT INTO `tp_region` VALUES ('2863', '银河北路街道', '4', '2862');
INSERT INTO `tp_region` VALUES ('2864', '爱民东道街道', '4', '2862');
INSERT INTO `tp_region` VALUES ('2865', '解放道街道', '4', '2862');
INSERT INTO `tp_region` VALUES ('2866', '新开路街道', '4', '2862');
INSERT INTO `tp_region` VALUES ('2867', '南尖塔镇', '4', '2862');
INSERT INTO `tp_region` VALUES ('2868', '万庄镇', '4', '2862');
INSERT INTO `tp_region` VALUES ('2869', '九州镇', '4', '2862');
INSERT INTO `tp_region` VALUES ('2870', '北旺乡', '4', '2862');
INSERT INTO `tp_region` VALUES ('2871', '廊坊经济技术开发区', '4', '2862');
INSERT INTO `tp_region` VALUES ('2872', '新世纪步行街管理委员会', '4', '2862');
INSERT INTO `tp_region` VALUES ('2873', '固安县', '3', '2849');
INSERT INTO `tp_region` VALUES ('2874', '固安镇', '4', '2873');
INSERT INTO `tp_region` VALUES ('2875', '宫村镇', '4', '2873');
INSERT INTO `tp_region` VALUES ('2876', '柳泉镇', '4', '2873');
INSERT INTO `tp_region` VALUES ('2877', '牛驼镇', '4', '2873');
INSERT INTO `tp_region` VALUES ('2878', '马庄镇', '4', '2873');
INSERT INTO `tp_region` VALUES ('2879', '东湾乡', '4', '2873');
INSERT INTO `tp_region` VALUES ('2880', '彭村乡', '4', '2873');
INSERT INTO `tp_region` VALUES ('2881', '渠沟乡', '4', '2873');
INSERT INTO `tp_region` VALUES ('2882', '礼让店乡', '4', '2873');
INSERT INTO `tp_region` VALUES ('2883', '永清县', '3', '2849');
INSERT INTO `tp_region` VALUES ('2884', '街道', '4', '2883');
INSERT INTO `tp_region` VALUES ('2885', '永清镇', '4', '2883');
INSERT INTO `tp_region` VALUES ('2886', '韩村镇', '4', '2883');
INSERT INTO `tp_region` VALUES ('2887', '后奕镇', '4', '2883');
INSERT INTO `tp_region` VALUES ('2888', '别古庄镇', '4', '2883');
INSERT INTO `tp_region` VALUES ('2889', '里澜城镇', '4', '2883');
INSERT INTO `tp_region` VALUES ('2890', '管家务回族乡', '4', '2883');
INSERT INTO `tp_region` VALUES ('2891', '曹家务乡', '4', '2883');
INSERT INTO `tp_region` VALUES ('2892', '龙虎庄乡', '4', '2883');
INSERT INTO `tp_region` VALUES ('2893', '刘街乡', '4', '2883');
INSERT INTO `tp_region` VALUES ('2894', '三圣口乡', '4', '2883');
INSERT INTO `tp_region` VALUES ('2895', '香河县', '3', '2849');
INSERT INTO `tp_region` VALUES ('2896', '淑阳镇', '4', '2895');
INSERT INTO `tp_region` VALUES ('2897', '蒋辛屯镇', '4', '2895');
INSERT INTO `tp_region` VALUES ('2898', '渠口镇', '4', '2895');
INSERT INTO `tp_region` VALUES ('2899', '安头屯镇', '4', '2895');
INSERT INTO `tp_region` VALUES ('2900', '安平镇', '4', '2895');
INSERT INTO `tp_region` VALUES ('2901', '刘宋镇', '4', '2895');
INSERT INTO `tp_region` VALUES ('2902', '五百户镇', '4', '2895');
INSERT INTO `tp_region` VALUES ('2903', '钱旺乡', '4', '2895');
INSERT INTO `tp_region` VALUES ('2904', '钳屯乡', '4', '2895');
INSERT INTO `tp_region` VALUES ('2905', '香河开发区', '4', '2895');
INSERT INTO `tp_region` VALUES ('2906', '大城县', '3', '2849');
INSERT INTO `tp_region` VALUES ('2907', '平舒镇', '4', '2906');
INSERT INTO `tp_region` VALUES ('2908', '旺村镇', '4', '2906');
INSERT INTO `tp_region` VALUES ('2909', '大尚屯镇', '4', '2906');
INSERT INTO `tp_region` VALUES ('2910', '南赵扶镇', '4', '2906');
INSERT INTO `tp_region` VALUES ('2911', '留各庄镇', '4', '2906');
INSERT INTO `tp_region` VALUES ('2912', '权村镇', '4', '2906');
INSERT INTO `tp_region` VALUES ('2913', '里坦镇', '4', '2906');
INSERT INTO `tp_region` VALUES ('2914', '北位乡', '4', '2906');
INSERT INTO `tp_region` VALUES ('2915', '大广安乡', '4', '2906');
INSERT INTO `tp_region` VALUES ('2916', '臧屯乡', '4', '2906');
INSERT INTO `tp_region` VALUES ('2917', '摩配园区管委会', '4', '2906');
INSERT INTO `tp_region` VALUES ('2918', '文安县', '3', '2849');
INSERT INTO `tp_region` VALUES ('2919', '文安镇', '4', '2918');
INSERT INTO `tp_region` VALUES ('2920', '新镇镇', '4', '2918');
INSERT INTO `tp_region` VALUES ('2921', '苏桥镇', '4', '2918');
INSERT INTO `tp_region` VALUES ('2922', '大柳河镇', '4', '2918');
INSERT INTO `tp_region` VALUES ('2923', '左各庄镇', '4', '2918');
INSERT INTO `tp_region` VALUES ('2924', '滩里镇', '4', '2918');
INSERT INTO `tp_region` VALUES ('2925', '史各庄镇', '4', '2918');
INSERT INTO `tp_region` VALUES ('2926', '赵各庄镇', '4', '2918');
INSERT INTO `tp_region` VALUES ('2927', '兴隆宫镇', '4', '2918');
INSERT INTO `tp_region` VALUES ('2928', '大留镇镇', '4', '2918');
INSERT INTO `tp_region` VALUES ('2929', '孙氏镇', '4', '2918');
INSERT INTO `tp_region` VALUES ('2930', '德归镇', '4', '2918');
INSERT INTO `tp_region` VALUES ('2931', '大围河回族满族乡', '4', '2918');
INSERT INTO `tp_region` VALUES ('2932', '大厂回族自治县', '3', '2849');
INSERT INTO `tp_region` VALUES ('2933', '大厂镇', '4', '2932');
INSERT INTO `tp_region` VALUES ('2934', '夏垫镇', '4', '2932');
INSERT INTO `tp_region` VALUES ('2935', '祁各庄镇', '4', '2932');
INSERT INTO `tp_region` VALUES ('2936', '邵府乡', '4', '2932');
INSERT INTO `tp_region` VALUES ('2937', '陈府乡', '4', '2932');
INSERT INTO `tp_region` VALUES ('2938', '工业园区', '4', '2932');
INSERT INTO `tp_region` VALUES ('2939', '霸州市', '3', '2849');
INSERT INTO `tp_region` VALUES ('2940', '霸州镇', '4', '2939');
INSERT INTO `tp_region` VALUES ('2941', '南孟镇', '4', '2939');
INSERT INTO `tp_region` VALUES ('2942', '信安镇', '4', '2939');
INSERT INTO `tp_region` VALUES ('2943', '堂二里镇', '4', '2939');
INSERT INTO `tp_region` VALUES ('2944', '煎茶铺镇', '4', '2939');
INSERT INTO `tp_region` VALUES ('2945', '胜芳镇', '4', '2939');
INSERT INTO `tp_region` VALUES ('2946', '杨芬港镇', '4', '2939');
INSERT INTO `tp_region` VALUES ('2947', '岔河集乡', '4', '2939');
INSERT INTO `tp_region` VALUES ('2948', '康仙庄乡', '4', '2939');
INSERT INTO `tp_region` VALUES ('2949', '东杨庄乡', '4', '2939');
INSERT INTO `tp_region` VALUES ('2950', '王庄子乡', '4', '2939');
INSERT INTO `tp_region` VALUES ('2951', '东段乡', '4', '2939');
INSERT INTO `tp_region` VALUES ('2952', '霸州经济技术开发区', '4', '2939');
INSERT INTO `tp_region` VALUES ('2953', '三河市', '3', '2849');
INSERT INTO `tp_region` VALUES ('2954', '南城街道', '4', '2953');
INSERT INTO `tp_region` VALUES ('2955', '北城街道', '4', '2953');
INSERT INTO `tp_region` VALUES ('2956', '泃阳镇', '4', '2953');
INSERT INTO `tp_region` VALUES ('2957', '李旗庄镇', '4', '2953');
INSERT INTO `tp_region` VALUES ('2958', '杨庄镇', '4', '2953');
INSERT INTO `tp_region` VALUES ('2959', '皇庄镇', '4', '2953');
INSERT INTO `tp_region` VALUES ('2960', '新集镇', '4', '2953');
INSERT INTO `tp_region` VALUES ('2961', '段甲岭镇', '4', '2953');
INSERT INTO `tp_region` VALUES ('2962', '黄土庄镇', '4', '2953');
INSERT INTO `tp_region` VALUES ('2963', '高楼镇', '4', '2953');
INSERT INTO `tp_region` VALUES ('2964', '齐心庄镇', '4', '2953');
INSERT INTO `tp_region` VALUES ('2965', '燕郊镇', '4', '2953');
INSERT INTO `tp_region` VALUES ('2966', '燕郊经济技术开发区', '4', '2953');
INSERT INTO `tp_region` VALUES ('2967', '三河市农业高新技术园区', '4', '2953');
INSERT INTO `tp_region` VALUES ('2968', '衡水市', '2', '636');
INSERT INTO `tp_region` VALUES ('2969', '市辖区', '3', '2968');
INSERT INTO `tp_region` VALUES ('2970', '桃城区', '3', '2968');
INSERT INTO `tp_region` VALUES ('2971', '河西街道', '4', '2970');
INSERT INTO `tp_region` VALUES ('2972', '河东街道', '4', '2970');
INSERT INTO `tp_region` VALUES ('2973', '路北街道', '4', '2970');
INSERT INTO `tp_region` VALUES ('2974', '中华街道', '4', '2970');
INSERT INTO `tp_region` VALUES ('2975', '郑家河沿镇', '4', '2970');
INSERT INTO `tp_region` VALUES ('2976', '赵家圈镇', '4', '2970');
INSERT INTO `tp_region` VALUES ('2977', '何家庄乡', '4', '2970');
INSERT INTO `tp_region` VALUES ('2978', '大麻森乡', '4', '2970');
INSERT INTO `tp_region` VALUES ('2979', '邓家庄乡', '4', '2970');
INSERT INTO `tp_region` VALUES ('2980', '彭杜村乡', '4', '2970');
INSERT INTO `tp_region` VALUES ('2981', '衡水高新技术产业开发区', '4', '2970');
INSERT INTO `tp_region` VALUES ('2982', '衡水湖自然保护区管理处', '4', '2970');
INSERT INTO `tp_region` VALUES ('2983', '枣强县', '3', '2968');
INSERT INTO `tp_region` VALUES ('2984', '枣强镇', '4', '2983');
INSERT INTO `tp_region` VALUES ('2985', '恩察镇', '4', '2983');
INSERT INTO `tp_region` VALUES ('2986', '大营镇', '4', '2983');
INSERT INTO `tp_region` VALUES ('2987', '嘉会镇', '4', '2983');
INSERT INTO `tp_region` VALUES ('2988', '马屯镇', '4', '2983');
INSERT INTO `tp_region` VALUES ('2989', '肖张镇', '4', '2983');
INSERT INTO `tp_region` VALUES ('2990', '张秀屯乡', '4', '2983');
INSERT INTO `tp_region` VALUES ('2991', '新屯乡', '4', '2983');
INSERT INTO `tp_region` VALUES ('2992', '王均乡', '4', '2983');
INSERT INTO `tp_region` VALUES ('2993', '唐林乡', '4', '2983');
INSERT INTO `tp_region` VALUES ('2994', '王常乡', '4', '2983');
INSERT INTO `tp_region` VALUES ('2995', '武邑县', '3', '2968');
INSERT INTO `tp_region` VALUES ('2996', '武邑镇', '4', '2995');
INSERT INTO `tp_region` VALUES ('2997', '清凉店镇', '4', '2995');
INSERT INTO `tp_region` VALUES ('2998', '审坡镇', '4', '2995');
INSERT INTO `tp_region` VALUES ('2999', '赵桥镇', '4', '2995');
INSERT INTO `tp_region` VALUES ('3000', '韩庄镇', '4', '2995');
INSERT INTO `tp_region` VALUES ('3001', '肖桥头镇', '4', '2995');
INSERT INTO `tp_region` VALUES ('3002', '龙店乡', '4', '2995');
INSERT INTO `tp_region` VALUES ('3003', '圈头乡', '4', '2995');
INSERT INTO `tp_region` VALUES ('3004', '大紫塔乡', '4', '2995');
INSERT INTO `tp_region` VALUES ('3005', '武强县', '3', '2968');
INSERT INTO `tp_region` VALUES ('3006', '武强镇', '4', '3005');
INSERT INTO `tp_region` VALUES ('3007', '街关镇', '4', '3005');
INSERT INTO `tp_region` VALUES ('3008', '豆村乡', '4', '3005');
INSERT INTO `tp_region` VALUES ('3009', '北代乡', '4', '3005');
INSERT INTO `tp_region` VALUES ('3010', '孙庄乡', '4', '3005');
INSERT INTO `tp_region` VALUES ('3011', '周家窝乡', '4', '3005');
INSERT INTO `tp_region` VALUES ('3012', '饶阳县', '3', '2968');
INSERT INTO `tp_region` VALUES ('3013', '饶阳镇', '4', '3012');
INSERT INTO `tp_region` VALUES ('3014', '大尹村镇', '4', '3012');
INSERT INTO `tp_region` VALUES ('3015', '五公镇', '4', '3012');
INSERT INTO `tp_region` VALUES ('3016', '王同岳乡', '4', '3012');
INSERT INTO `tp_region` VALUES ('3017', '大官亭乡', '4', '3012');
INSERT INTO `tp_region` VALUES ('3018', '留楚乡', '4', '3012');
INSERT INTO `tp_region` VALUES ('3019', '东里满乡', '4', '3012');
INSERT INTO `tp_region` VALUES ('3020', '安平县', '3', '2968');
INSERT INTO `tp_region` VALUES ('3021', '安平镇', '4', '3020');
INSERT INTO `tp_region` VALUES ('3022', '马店镇', '4', '3020');
INSERT INTO `tp_region` VALUES ('3023', '南王庄镇', '4', '3020');
INSERT INTO `tp_region` VALUES ('3024', '大何庄乡', '4', '3020');
INSERT INTO `tp_region` VALUES ('3025', '程油子乡', '4', '3020');
INSERT INTO `tp_region` VALUES ('3026', '西两洼乡', '4', '3020');
INSERT INTO `tp_region` VALUES ('3027', '大子文乡', '4', '3020');
INSERT INTO `tp_region` VALUES ('3028', '东黄城乡', '4', '3020');
INSERT INTO `tp_region` VALUES ('3029', '故城县', '3', '2968');
INSERT INTO `tp_region` VALUES ('3030', '郑口镇', '4', '3029');
INSERT INTO `tp_region` VALUES ('3031', '夏庄镇', '4', '3029');
INSERT INTO `tp_region` VALUES ('3032', '青罕镇', '4', '3029');
INSERT INTO `tp_region` VALUES ('3033', '故城镇', '4', '3029');
INSERT INTO `tp_region` VALUES ('3034', '武官寨镇', '4', '3029');
INSERT INTO `tp_region` VALUES ('3035', '饶阳店镇', '4', '3029');
INSERT INTO `tp_region` VALUES ('3036', '军屯镇', '4', '3029');
INSERT INTO `tp_region` VALUES ('3037', '建国镇', '4', '3029');
INSERT INTO `tp_region` VALUES ('3038', '西半屯镇', '4', '3029');
INSERT INTO `tp_region` VALUES ('3039', '辛庄乡', '4', '3029');
INSERT INTO `tp_region` VALUES ('3040', '里老乡', '4', '3029');
INSERT INTO `tp_region` VALUES ('3041', '房庄乡', '4', '3029');
INSERT INTO `tp_region` VALUES ('3042', '三朗乡', '4', '3029');
INSERT INTO `tp_region` VALUES ('3043', '景县', '3', '2968');
INSERT INTO `tp_region` VALUES ('3044', '景州镇', '4', '3043');
INSERT INTO `tp_region` VALUES ('3045', '龙华镇', '4', '3043');
INSERT INTO `tp_region` VALUES ('3046', '广川镇', '4', '3043');
INSERT INTO `tp_region` VALUES ('3047', '王瞳镇', '4', '3043');
INSERT INTO `tp_region` VALUES ('3048', '洚河流镇', '4', '3043');
INSERT INTO `tp_region` VALUES ('3049', '安陵镇', '4', '3043');
INSERT INTO `tp_region` VALUES ('3050', '杜桥镇', '4', '3043');
INSERT INTO `tp_region` VALUES ('3051', '王谦寺镇', '4', '3043');
INSERT INTO `tp_region` VALUES ('3052', '北留智镇', '4', '3043');
INSERT INTO `tp_region` VALUES ('3053', '留智庙镇', '4', '3043');
INSERT INTO `tp_region` VALUES ('3054', '刘集乡', '4', '3043');
INSERT INTO `tp_region` VALUES ('3055', '连镇乡', '4', '3043');
INSERT INTO `tp_region` VALUES ('3056', '梁集乡', '4', '3043');
INSERT INTO `tp_region` VALUES ('3057', '温城乡', '4', '3043');
INSERT INTO `tp_region` VALUES ('3058', '后留名府乡', '4', '3043');
INSERT INTO `tp_region` VALUES ('3059', '青兰乡', '4', '3043');
INSERT INTO `tp_region` VALUES ('3060', '阜城县', '3', '2968');
INSERT INTO `tp_region` VALUES ('3061', '阜城镇', '4', '3060');
INSERT INTO `tp_region` VALUES ('3062', '古城镇', '4', '3060');
INSERT INTO `tp_region` VALUES ('3063', '码头镇', '4', '3060');
INSERT INTO `tp_region` VALUES ('3064', '霞口镇', '4', '3060');
INSERT INTO `tp_region` VALUES ('3065', '崔家庙镇', '4', '3060');
INSERT INTO `tp_region` VALUES ('3066', '漫河乡', '4', '3060');
INSERT INTO `tp_region` VALUES ('3067', '建桥乡', '4', '3060');
INSERT INTO `tp_region` VALUES ('3068', '蒋坊乡', '4', '3060');
INSERT INTO `tp_region` VALUES ('3069', '大白乡', '4', '3060');
INSERT INTO `tp_region` VALUES ('3070', '王集乡', '4', '3060');
INSERT INTO `tp_region` VALUES ('3071', '冀州市', '3', '2968');
INSERT INTO `tp_region` VALUES ('3072', '冀州镇', '4', '3071');
INSERT INTO `tp_region` VALUES ('3073', '魏屯镇', '4', '3071');
INSERT INTO `tp_region` VALUES ('3074', '官道李镇', '4', '3071');
INSERT INTO `tp_region` VALUES ('3075', '南午村镇', '4', '3071');
INSERT INTO `tp_region` VALUES ('3076', '周村镇', '4', '3071');
INSERT INTO `tp_region` VALUES ('3077', '码头李镇', '4', '3071');
INSERT INTO `tp_region` VALUES ('3078', '西王镇', '4', '3071');
INSERT INTO `tp_region` VALUES ('3079', '门庄乡', '4', '3071');
INSERT INTO `tp_region` VALUES ('3080', '徐家庄乡', '4', '3071');
INSERT INTO `tp_region` VALUES ('3081', '北漳淮乡', '4', '3071');
INSERT INTO `tp_region` VALUES ('3082', '小寨乡', '4', '3071');
INSERT INTO `tp_region` VALUES ('3083', '深州市', '3', '2968');
INSERT INTO `tp_region` VALUES ('3084', '唐奉镇', '4', '3083');
INSERT INTO `tp_region` VALUES ('3085', '深州镇', '4', '3083');
INSERT INTO `tp_region` VALUES ('3086', '辰时镇', '4', '3083');
INSERT INTO `tp_region` VALUES ('3087', '榆科镇', '4', '3083');
INSERT INTO `tp_region` VALUES ('3088', '魏桥镇', '4', '3083');
INSERT INTO `tp_region` VALUES ('3089', '大堤镇', '4', '3083');
INSERT INTO `tp_region` VALUES ('3090', '前磨头镇', '4', '3083');
INSERT INTO `tp_region` VALUES ('3091', '王家井镇', '4', '3083');
INSERT INTO `tp_region` VALUES ('3092', '护驾迟镇', '4', '3083');
INSERT INTO `tp_region` VALUES ('3093', '兵曹乡', '4', '3083');
INSERT INTO `tp_region` VALUES ('3094', '穆村乡', '4', '3083');
INSERT INTO `tp_region` VALUES ('3095', '东安庄乡', '4', '3083');
INSERT INTO `tp_region` VALUES ('3096', '北溪村乡', '4', '3083');
INSERT INTO `tp_region` VALUES ('3097', '大冯营乡', '4', '3083');
INSERT INTO `tp_region` VALUES ('3098', '乔屯乡', '4', '3083');
INSERT INTO `tp_region` VALUES ('3099', '太古庄乡', '4', '3083');
INSERT INTO `tp_region` VALUES ('3100', '大屯乡', '4', '3083');
INSERT INTO `tp_region` VALUES ('3101', '河北省深州监狱', '4', '3083');
INSERT INTO `tp_region` VALUES ('3102', '山西', '1', '0');
INSERT INTO `tp_region` VALUES ('3103', '太原市', '2', '3102');
INSERT INTO `tp_region` VALUES ('3104', '市辖区', '3', '3103');
INSERT INTO `tp_region` VALUES ('3105', '小店区(人口含高新经济区)', '3', '3103');
INSERT INTO `tp_region` VALUES ('3106', '坞城街道', '4', '3105');
INSERT INTO `tp_region` VALUES ('3107', '营盘街道', '4', '3105');
INSERT INTO `tp_region` VALUES ('3108', '北营街道', '4', '3105');
INSERT INTO `tp_region` VALUES ('3109', '平阳路街道', '4', '3105');
INSERT INTO `tp_region` VALUES ('3110', '黄陵街道', '4', '3105');
INSERT INTO `tp_region` VALUES ('3111', '小店街道', '4', '3105');
INSERT INTO `tp_region` VALUES ('3112', '北格镇', '4', '3105');
INSERT INTO `tp_region` VALUES ('3113', '西温庄乡', '4', '3105');
INSERT INTO `tp_region` VALUES ('3114', '刘家堡乡', '4', '3105');
INSERT INTO `tp_region` VALUES ('3115', '太原高新技术产业开发区', '4', '3105');
INSERT INTO `tp_region` VALUES ('3116', '太原经济技术开发区', '4', '3105');
INSERT INTO `tp_region` VALUES ('3117', '迎泽区', '3', '3103');
INSERT INTO `tp_region` VALUES ('3118', '柳巷街道', '4', '3117');
INSERT INTO `tp_region` VALUES ('3119', '文庙街道', '4', '3117');
INSERT INTO `tp_region` VALUES ('3120', '庙前街道', '4', '3117');
INSERT INTO `tp_region` VALUES ('3121', '迎泽街道', '4', '3117');
INSERT INTO `tp_region` VALUES ('3122', '桥东街道', '4', '3117');
INSERT INTO `tp_region` VALUES ('3123', '老军营街道', '4', '3117');
INSERT INTO `tp_region` VALUES ('3124', '郝庄镇', '4', '3117');
INSERT INTO `tp_region` VALUES ('3125', '民营区', '4', '3117');
INSERT INTO `tp_region` VALUES ('3126', '杏花岭区', '3', '3103');
INSERT INTO `tp_region` VALUES ('3127', '巨轮街道', '4', '3126');
INSERT INTO `tp_region` VALUES ('3128', '三桥街道', '4', '3126');
INSERT INTO `tp_region` VALUES ('3129', '鼓楼街道', '4', '3126');
INSERT INTO `tp_region` VALUES ('3130', '杏花岭街道', '4', '3126');
INSERT INTO `tp_region` VALUES ('3131', '坝陵桥街道', '4', '3126');
INSERT INTO `tp_region` VALUES ('3132', '大东关街道', '4', '3126');
INSERT INTO `tp_region` VALUES ('3133', '职工新街街道', '4', '3126');
INSERT INTO `tp_region` VALUES ('3134', '敦化坊街道', '4', '3126');
INSERT INTO `tp_region` VALUES ('3135', '涧河街道', '4', '3126');
INSERT INTO `tp_region` VALUES ('3136', '杨家峪街道', '4', '3126');
INSERT INTO `tp_region` VALUES ('3137', '中涧河乡', '4', '3126');
INSERT INTO `tp_region` VALUES ('3138', '小返乡', '4', '3126');
INSERT INTO `tp_region` VALUES ('3139', '民营区', '4', '3126');
INSERT INTO `tp_region` VALUES ('3140', '尖草坪区', '3', '3103');
INSERT INTO `tp_region` VALUES ('3141', '尖草坪街道', '4', '3140');
INSERT INTO `tp_region` VALUES ('3142', '光社街道', '4', '3140');
INSERT INTO `tp_region` VALUES ('3143', '上兰街道', '4', '3140');
INSERT INTO `tp_region` VALUES ('3144', '南寨街道', '4', '3140');
INSERT INTO `tp_region` VALUES ('3145', '迎新街道', '4', '3140');
INSERT INTO `tp_region` VALUES ('3146', '古城街道', '4', '3140');
INSERT INTO `tp_region` VALUES ('3147', '汇丰街道', '4', '3140');
INSERT INTO `tp_region` VALUES ('3148', '柴村街道', '4', '3140');
INSERT INTO `tp_region` VALUES ('3149', '新城街道', '4', '3140');
INSERT INTO `tp_region` VALUES ('3150', '向阳镇', '4', '3140');
INSERT INTO `tp_region` VALUES ('3151', '阳曲镇', '4', '3140');
INSERT INTO `tp_region` VALUES ('3152', '马头水乡', '4', '3140');
INSERT INTO `tp_region` VALUES ('3153', '柏板乡', '4', '3140');
INSERT INTO `tp_region` VALUES ('3154', '西焉乡', '4', '3140');
INSERT INTO `tp_region` VALUES ('3155', '万柏林区', '3', '3103');
INSERT INTO `tp_region` VALUES ('3156', '千峰街道', '4', '3155');
INSERT INTO `tp_region` VALUES ('3157', '下元街道', '4', '3155');
INSERT INTO `tp_region` VALUES ('3158', '和平街道', '4', '3155');
INSERT INTO `tp_region` VALUES ('3159', '兴华街道', '4', '3155');
INSERT INTO `tp_region` VALUES ('3160', '万柏林街道', '4', '3155');
INSERT INTO `tp_region` VALUES ('3161', '杜儿坪街道', '4', '3155');
INSERT INTO `tp_region` VALUES ('3162', '白家庄街道', '4', '3155');
INSERT INTO `tp_region` VALUES ('3163', '南寒街道', '4', '3155');
INSERT INTO `tp_region` VALUES ('3164', '东社街道', '4', '3155');
INSERT INTO `tp_region` VALUES ('3165', '化客头街道', '4', '3155');
INSERT INTO `tp_region` VALUES ('3166', '小井峪街道', '4', '3155');
INSERT INTO `tp_region` VALUES ('3167', '西铭街道', '4', '3155');
INSERT INTO `tp_region` VALUES ('3168', '长风街道', '4', '3155');
INSERT INTO `tp_region` VALUES ('3169', '神堂沟街道', '4', '3155');
INSERT INTO `tp_region` VALUES ('3170', '王封乡', '4', '3155');
INSERT INTO `tp_region` VALUES ('3171', '晋源区', '3', '3103');
INSERT INTO `tp_region` VALUES ('3172', '义井街道', '4', '3171');
INSERT INTO `tp_region` VALUES ('3173', '罗城街道', '4', '3171');
INSERT INTO `tp_region` VALUES ('3174', '晋源街道', '4', '3171');
INSERT INTO `tp_region` VALUES ('3175', '金胜镇', '4', '3171');
INSERT INTO `tp_region` VALUES ('3176', '晋祠镇', '4', '3171');
INSERT INTO `tp_region` VALUES ('3177', '姚村镇', '4', '3171');
INSERT INTO `tp_region` VALUES ('3178', '清徐县', '3', '3103');
INSERT INTO `tp_region` VALUES ('3179', '清源镇', '4', '3178');
INSERT INTO `tp_region` VALUES ('3180', '徐沟镇', '4', '3178');
INSERT INTO `tp_region` VALUES ('3181', '东于镇', '4', '3178');
INSERT INTO `tp_region` VALUES ('3182', '孟封镇', '4', '3178');
INSERT INTO `tp_region` VALUES ('3183', '马峪乡', '4', '3178');
INSERT INTO `tp_region` VALUES ('3184', '柳杜乡', '4', '3178');
INSERT INTO `tp_region` VALUES ('3185', '西谷乡', '4', '3178');
INSERT INTO `tp_region` VALUES ('3186', '王答乡', '4', '3178');
INSERT INTO `tp_region` VALUES ('3187', '集义乡', '4', '3178');
INSERT INTO `tp_region` VALUES ('3188', '阳曲县', '3', '3103');
INSERT INTO `tp_region` VALUES ('3189', '黄寨镇', '4', '3188');
INSERT INTO `tp_region` VALUES ('3190', '大盂镇', '4', '3188');
INSERT INTO `tp_region` VALUES ('3191', '东黄水镇', '4', '3188');
INSERT INTO `tp_region` VALUES ('3192', '泥屯镇', '4', '3188');
INSERT INTO `tp_region` VALUES ('3193', '阳曲县社区建设管理办公室', '4', '3188');
INSERT INTO `tp_region` VALUES ('3194', '高村乡', '4', '3188');
INSERT INTO `tp_region` VALUES ('3195', '侯村乡', '4', '3188');
INSERT INTO `tp_region` VALUES ('3196', '凌井店乡', '4', '3188');
INSERT INTO `tp_region` VALUES ('3197', '西凌井乡', '4', '3188');
INSERT INTO `tp_region` VALUES ('3198', '北小店乡', '4', '3188');
INSERT INTO `tp_region` VALUES ('3199', '杨兴乡', '4', '3188');
INSERT INTO `tp_region` VALUES ('3200', '娄烦县', '3', '3103');
INSERT INTO `tp_region` VALUES ('3201', '娄烦镇', '4', '3200');
INSERT INTO `tp_region` VALUES ('3202', '静游镇', '4', '3200');
INSERT INTO `tp_region` VALUES ('3203', '杜交曲镇', '4', '3200');
INSERT INTO `tp_region` VALUES ('3204', '庙湾乡', '4', '3200');
INSERT INTO `tp_region` VALUES ('3205', '马家庄乡', '4', '3200');
INSERT INTO `tp_region` VALUES ('3206', '盖家庄乡', '4', '3200');
INSERT INTO `tp_region` VALUES ('3207', '米峪镇乡', '4', '3200');
INSERT INTO `tp_region` VALUES ('3208', '天池店乡', '4', '3200');
INSERT INTO `tp_region` VALUES ('3209', '古交市', '3', '3103');
INSERT INTO `tp_region` VALUES ('3210', '东曲街道', '4', '3209');
INSERT INTO `tp_region` VALUES ('3211', '西曲街道', '4', '3209');
INSERT INTO `tp_region` VALUES ('3212', '桃园街道', '4', '3209');
INSERT INTO `tp_region` VALUES ('3213', '屯兰街道', '4', '3209');
INSERT INTO `tp_region` VALUES ('3214', '河口镇', '4', '3209');
INSERT INTO `tp_region` VALUES ('3215', '镇城底镇', '4', '3209');
INSERT INTO `tp_region` VALUES ('3216', '马兰镇', '4', '3209');
INSERT INTO `tp_region` VALUES ('3217', '阁上乡', '4', '3209');
INSERT INTO `tp_region` VALUES ('3218', '加乐泉乡', '4', '3209');
INSERT INTO `tp_region` VALUES ('3219', '梭峪乡', '4', '3209');
INSERT INTO `tp_region` VALUES ('3220', '岔口乡', '4', '3209');
INSERT INTO `tp_region` VALUES ('3221', '常安乡', '4', '3209');
INSERT INTO `tp_region` VALUES ('3222', '原相乡', '4', '3209');
INSERT INTO `tp_region` VALUES ('3223', '邢家社乡', '4', '3209');
INSERT INTO `tp_region` VALUES ('3224', '大同市', '2', '3102');
INSERT INTO `tp_region` VALUES ('3225', '市辖区', '3', '3224');
INSERT INTO `tp_region` VALUES ('3226', '大同市城区', '3', '3224');
INSERT INTO `tp_region` VALUES ('3227', '南关街道', '4', '3226');
INSERT INTO `tp_region` VALUES ('3228', '北关街道', '4', '3226');
INSERT INTO `tp_region` VALUES ('3229', '东街街道', '4', '3226');
INSERT INTO `tp_region` VALUES ('3230', '西街街道', '4', '3226');
INSERT INTO `tp_region` VALUES ('3231', '南街街道', '4', '3226');
INSERT INTO `tp_region` VALUES ('3232', '北街街道', '4', '3226');
INSERT INTO `tp_region` VALUES ('3233', '新建南路街道', '4', '3226');
INSERT INTO `tp_region` VALUES ('3234', '新建北路街道', '4', '3226');
INSERT INTO `tp_region` VALUES ('3235', '大庆路街道', '4', '3226');
INSERT INTO `tp_region` VALUES ('3236', '新华街街道', '4', '3226');
INSERT INTO `tp_region` VALUES ('3237', '西花园街道', '4', '3226');
INSERT INTO `tp_region` VALUES ('3238', '老平旺街道', '4', '3226');
INSERT INTO `tp_region` VALUES ('3239', '向阳里街道', '4', '3226');
INSERT INTO `tp_region` VALUES ('3240', '振华街街道', '4', '3226');
INSERT INTO `tp_region` VALUES ('3241', '矿区', '3', '3224');
INSERT INTO `tp_region` VALUES ('3242', '新胜街道', '4', '3241');
INSERT INTO `tp_region` VALUES ('3243', '新平旺街道', '4', '3241');
INSERT INTO `tp_region` VALUES ('3244', '煤峪口街道', '4', '3241');
INSERT INTO `tp_region` VALUES ('3245', '永定庄街道', '4', '3241');
INSERT INTO `tp_region` VALUES ('3246', '同家梁街道', '4', '3241');
INSERT INTO `tp_region` VALUES ('3247', '四老沟街道', '4', '3241');
INSERT INTO `tp_region` VALUES ('3248', '忻州窑街道', '4', '3241');
INSERT INTO `tp_region` VALUES ('3249', '白洞街道', '4', '3241');
INSERT INTO `tp_region` VALUES ('3250', '雁崖街道', '4', '3241');
INSERT INTO `tp_region` VALUES ('3251', '挖金湾街道', '4', '3241');
INSERT INTO `tp_region` VALUES ('3252', '晋华宫街道', '4', '3241');
INSERT INTO `tp_region` VALUES ('3253', '马脊梁街道', '4', '3241');
INSERT INTO `tp_region` VALUES ('3254', '大斗沟街道', '4', '3241');
INSERT INTO `tp_region` VALUES ('3255', '王村街道', '4', '3241');
INSERT INTO `tp_region` VALUES ('3256', '姜家湾街道', '4', '3241');
INSERT INTO `tp_region` VALUES ('3257', '新泉路街道', '4', '3241');
INSERT INTO `tp_region` VALUES ('3258', '民胜街道', '4', '3241');
INSERT INTO `tp_region` VALUES ('3259', '口泉街道', '4', '3241');
INSERT INTO `tp_region` VALUES ('3260', '马口街道', '4', '3241');
INSERT INTO `tp_region` VALUES ('3261', '燕子山街道', '4', '3241');
INSERT INTO `tp_region` VALUES ('3262', '杏儿沟街道', '4', '3241');
INSERT INTO `tp_region` VALUES ('3263', '青磁窑街道', '4', '3241');
INSERT INTO `tp_region` VALUES ('3264', '平泉路街道', '4', '3241');
INSERT INTO `tp_region` VALUES ('3265', '四台沟街道', '4', '3241');
INSERT INTO `tp_region` VALUES ('3266', '南郊区', '3', '3224');
INSERT INTO `tp_region` VALUES ('3267', '古店镇', '4', '3266');
INSERT INTO `tp_region` VALUES ('3268', '高山镇', '4', '3266');
INSERT INTO `tp_region` VALUES ('3269', '云冈镇', '4', '3266');
INSERT INTO `tp_region` VALUES ('3270', '口泉乡', '4', '3266');
INSERT INTO `tp_region` VALUES ('3271', '新旺乡', '4', '3266');
INSERT INTO `tp_region` VALUES ('3272', '水泊寺乡', '4', '3266');
INSERT INTO `tp_region` VALUES ('3273', '马军营乡', '4', '3266');
INSERT INTO `tp_region` VALUES ('3274', '西韩岭乡', '4', '3266');
INSERT INTO `tp_region` VALUES ('3275', '平旺乡', '4', '3266');
INSERT INTO `tp_region` VALUES ('3276', '鸦儿崖乡', '4', '3266');
INSERT INTO `tp_region` VALUES ('3277', '新荣区', '3', '3224');
INSERT INTO `tp_region` VALUES ('3278', '新荣区社区服务管理中心', '4', '3277');
INSERT INTO `tp_region` VALUES ('3279', '新荣镇', '4', '3277');
INSERT INTO `tp_region` VALUES ('3280', '破鲁堡乡', '4', '3277');
INSERT INTO `tp_region` VALUES ('3281', '郭家窑乡', '4', '3277');
INSERT INTO `tp_region` VALUES ('3282', '花元屯乡', '4', '3277');
INSERT INTO `tp_region` VALUES ('3283', '西村乡', '4', '3277');
INSERT INTO `tp_region` VALUES ('3284', '上深涧乡', '4', '3277');
INSERT INTO `tp_region` VALUES ('3285', '堡子湾乡', '4', '3277');
INSERT INTO `tp_region` VALUES ('3286', '阳高县', '3', '3224');
INSERT INTO `tp_region` VALUES ('3287', '龙泉镇', '4', '3286');
INSERT INTO `tp_region` VALUES ('3288', '罗文皂镇', '4', '3286');
INSERT INTO `tp_region` VALUES ('3289', '大白登镇', '4', '3286');
INSERT INTO `tp_region` VALUES ('3290', '王官屯镇', '4', '3286');
INSERT INTO `tp_region` VALUES ('3291', '古城镇', '4', '3286');
INSERT INTO `tp_region` VALUES ('3292', '东小村镇', '4', '3286');
INSERT INTO `tp_region` VALUES ('3293', '友宰镇', '4', '3286');
INSERT INTO `tp_region` VALUES ('3294', '长城乡', '4', '3286');
INSERT INTO `tp_region` VALUES ('3295', '北徐屯乡', '4', '3286');
INSERT INTO `tp_region` VALUES ('3296', '狮子屯乡', '4', '3286');
INSERT INTO `tp_region` VALUES ('3297', '下深井乡', '4', '3286');
INSERT INTO `tp_region` VALUES ('3298', '马家皂乡', '4', '3286');
INSERT INTO `tp_region` VALUES ('3299', '鳌石乡', '4', '3286');
INSERT INTO `tp_region` VALUES ('3300', '天镇县', '3', '3224');
INSERT INTO `tp_region` VALUES ('3301', '玉泉镇', '4', '3300');
INSERT INTO `tp_region` VALUES ('3302', '谷前堡镇', '4', '3300');
INSERT INTO `tp_region` VALUES ('3303', '米薪关镇', '4', '3300');
INSERT INTO `tp_region` VALUES ('3304', '逯家湾镇', '4', '3300');
INSERT INTO `tp_region` VALUES ('3305', '新平镇', '4', '3300');
INSERT INTO `tp_region` VALUES ('3306', '卅里铺乡', '4', '3300');
INSERT INTO `tp_region` VALUES ('3307', '南河堡乡', '4', '3300');
INSERT INTO `tp_region` VALUES ('3308', '贾家屯乡', '4', '3300');
INSERT INTO `tp_region` VALUES ('3309', '赵家沟乡', '4', '3300');
INSERT INTO `tp_region` VALUES ('3310', '南高崖乡', '4', '3300');
INSERT INTO `tp_region` VALUES ('3311', '张西河乡', '4', '3300');
INSERT INTO `tp_region` VALUES ('3312', '广灵县', '3', '3224');
INSERT INTO `tp_region` VALUES ('3313', '壶泉镇', '4', '3312');
INSERT INTO `tp_region` VALUES ('3314', '南村镇', '4', '3312');
INSERT INTO `tp_region` VALUES ('3315', '斗泉乡', '4', '3312');
INSERT INTO `tp_region` VALUES ('3316', '蕉山乡', '4', '3312');
INSERT INTO `tp_region` VALUES ('3317', '加斗乡', '4', '3312');
INSERT INTO `tp_region` VALUES ('3318', '宜兴乡', '4', '3312');
INSERT INTO `tp_region` VALUES ('3319', '作疃乡', '4', '3312');
INSERT INTO `tp_region` VALUES ('3320', '梁庄乡', '4', '3312');
INSERT INTO `tp_region` VALUES ('3321', '望狐乡', '4', '3312');
INSERT INTO `tp_region` VALUES ('3322', '灵丘县', '3', '3224');
INSERT INTO `tp_region` VALUES ('3323', '武灵镇', '4', '3322');
INSERT INTO `tp_region` VALUES ('3324', '东河南镇', '4', '3322');
INSERT INTO `tp_region` VALUES ('3325', '上寨镇', '4', '3322');
INSERT INTO `tp_region` VALUES ('3326', '落水河乡', '4', '3322');
INSERT INTO `tp_region` VALUES ('3327', '史庄乡', '4', '3322');
INSERT INTO `tp_region` VALUES ('3328', '赵北乡', '4', '3322');
INSERT INTO `tp_region` VALUES ('3329', '石家田乡', '4', '3322');
INSERT INTO `tp_region` VALUES ('3330', '柳科乡', '4', '3322');
INSERT INTO `tp_region` VALUES ('3331', '白崖台乡', '4', '3322');
INSERT INTO `tp_region` VALUES ('3332', '红石塄乡', '4', '3322');
INSERT INTO `tp_region` VALUES ('3333', '下关乡', '4', '3322');
INSERT INTO `tp_region` VALUES ('3334', '独峪乡', '4', '3322');
INSERT INTO `tp_region` VALUES ('3335', '浑源县', '3', '3224');
INSERT INTO `tp_region` VALUES ('3336', '永安镇', '4', '3335');
INSERT INTO `tp_region` VALUES ('3337', '西坊城镇', '4', '3335');
INSERT INTO `tp_region` VALUES ('3338', '蔡村镇', '4', '3335');
INSERT INTO `tp_region` VALUES ('3339', '沙圪坨镇', '4', '3335');
INSERT INTO `tp_region` VALUES ('3340', '王庄堡镇', '4', '3335');
INSERT INTO `tp_region` VALUES ('3341', '大磁窑镇', '4', '3335');
INSERT INTO `tp_region` VALUES ('3342', '东坊城乡', '4', '3335');
INSERT INTO `tp_region` VALUES ('3343', '裴村乡', '4', '3335');
INSERT INTO `tp_region` VALUES ('3344', '驼峰乡', '4', '3335');
INSERT INTO `tp_region` VALUES ('3345', '西留村乡', '4', '3335');
INSERT INTO `tp_region` VALUES ('3346', '下韩村乡', '4', '3335');
INSERT INTO `tp_region` VALUES ('3347', '南榆林乡', '4', '3335');
INSERT INTO `tp_region` VALUES ('3348', '吴城乡', '4', '3335');
INSERT INTO `tp_region` VALUES ('3349', '黄花滩乡', '4', '3335');
INSERT INTO `tp_region` VALUES ('3350', '大仁庄乡', '4', '3335');
INSERT INTO `tp_region` VALUES ('3351', '千佛岭乡', '4', '3335');
INSERT INTO `tp_region` VALUES ('3352', '官儿乡', '4', '3335');
INSERT INTO `tp_region` VALUES ('3353', '青磁窑乡', '4', '3335');
INSERT INTO `tp_region` VALUES ('3354', '左云县', '3', '3224');
INSERT INTO `tp_region` VALUES ('3355', '云兴镇', '4', '3354');
INSERT INTO `tp_region` VALUES ('3356', '鹊儿山镇', '4', '3354');
INSERT INTO `tp_region` VALUES ('3357', '店湾镇', '4', '3354');
INSERT INTO `tp_region` VALUES ('3358', '管家堡乡', '4', '3354');
INSERT INTO `tp_region` VALUES ('3359', '张家场乡', '4', '3354');
INSERT INTO `tp_region` VALUES ('3360', '三屯乡', '4', '3354');
INSERT INTO `tp_region` VALUES ('3361', '马道头乡', '4', '3354');
INSERT INTO `tp_region` VALUES ('3362', '小京庄乡', '4', '3354');
INSERT INTO `tp_region` VALUES ('3363', '水窑乡', '4', '3354');
INSERT INTO `tp_region` VALUES ('3364', '大同县', '3', '3224');
INSERT INTO `tp_region` VALUES ('3365', '湖东街道', '4', '3364');
INSERT INTO `tp_region` VALUES ('3366', '东街街道', '4', '3364');
INSERT INTO `tp_region` VALUES ('3367', '西街街道', '4', '3364');
INSERT INTO `tp_region` VALUES ('3368', '西坪镇', '4', '3364');
INSERT INTO `tp_region` VALUES ('3369', '倍加造镇', '4', '3364');
INSERT INTO `tp_region` VALUES ('3370', '周士庄镇', '4', '3364');
INSERT INTO `tp_region` VALUES ('3371', '吉家庄乡', '4', '3364');
INSERT INTO `tp_region` VALUES ('3372', '峰峪乡', '4', '3364');
INSERT INTO `tp_region` VALUES ('3373', '杜庄乡', '4', '3364');
INSERT INTO `tp_region` VALUES ('3374', '党留庄乡', '4', '3364');
INSERT INTO `tp_region` VALUES ('3375', '瓜园乡', '4', '3364');
INSERT INTO `tp_region` VALUES ('3376', '巨乐乡', '4', '3364');
INSERT INTO `tp_region` VALUES ('3377', '许堡乡', '4', '3364');
INSERT INTO `tp_region` VALUES ('3378', '经济技术开发区', '4', '3364');
INSERT INTO `tp_region` VALUES ('3379', '阳泉市', '2', '3102');
INSERT INTO `tp_region` VALUES ('3380', '市辖区', '3', '3379');
INSERT INTO `tp_region` VALUES ('3381', '城区', '3', '3379');
INSERT INTO `tp_region` VALUES ('3382', '上站街道', '4', '3381');
INSERT INTO `tp_region` VALUES ('3383', '下站街道', '4', '3381');
INSERT INTO `tp_region` VALUES ('3384', '北大街街道', '4', '3381');
INSERT INTO `tp_region` VALUES ('3385', '南山路街道', '4', '3381');
INSERT INTO `tp_region` VALUES ('3386', '义井街道', '4', '3381');
INSERT INTO `tp_region` VALUES ('3387', '坡底街道', '4', '3381');
INSERT INTO `tp_region` VALUES ('3388', '矿区', '3', '3379');
INSERT INTO `tp_region` VALUES ('3389', '平潭街街道', '4', '3388');
INSERT INTO `tp_region` VALUES ('3390', '桥头街道', '4', '3388');
INSERT INTO `tp_region` VALUES ('3391', '蔡洼街道', '4', '3388');
INSERT INTO `tp_region` VALUES ('3392', '赛鱼街道', '4', '3388');
INSERT INTO `tp_region` VALUES ('3393', '沙坪街道', '4', '3388');
INSERT INTO `tp_region` VALUES ('3394', '贵石沟街道', '4', '3388');
INSERT INTO `tp_region` VALUES ('3395', '郊区', '3', '3379');
INSERT INTO `tp_region` VALUES ('3396', '荫营镇', '4', '3395');
INSERT INTO `tp_region` VALUES ('3397', '河底镇', '4', '3395');
INSERT INTO `tp_region` VALUES ('3398', '义井镇', '4', '3395');
INSERT INTO `tp_region` VALUES ('3399', '平坦镇', '4', '3395');
INSERT INTO `tp_region` VALUES ('3400', '西南舁乡', '4', '3395');
INSERT INTO `tp_region` VALUES ('3401', '杨家庄乡', '4', '3395');
INSERT INTO `tp_region` VALUES ('3402', '李家庄乡', '4', '3395');
INSERT INTO `tp_region` VALUES ('3403', '旧街乡', '4', '3395');
INSERT INTO `tp_region` VALUES ('3404', '开发区', '4', '3395');
INSERT INTO `tp_region` VALUES ('3405', '平定县', '3', '3379');
INSERT INTO `tp_region` VALUES ('3406', '冠山镇', '4', '3405');
INSERT INTO `tp_region` VALUES ('3407', '冶西镇', '4', '3405');
INSERT INTO `tp_region` VALUES ('3408', '锁簧镇', '4', '3405');
INSERT INTO `tp_region` VALUES ('3409', '张庄镇', '4', '3405');
INSERT INTO `tp_region` VALUES ('3410', '东回镇', '4', '3405');
INSERT INTO `tp_region` VALUES ('3411', '柏井镇', '4', '3405');
INSERT INTO `tp_region` VALUES ('3412', '娘子关镇', '4', '3405');
INSERT INTO `tp_region` VALUES ('3413', '巨城镇', '4', '3405');
INSERT INTO `tp_region` VALUES ('3414', '石门口乡', '4', '3405');
INSERT INTO `tp_region` VALUES ('3415', '岔口乡', '4', '3405');
INSERT INTO `tp_region` VALUES ('3416', '盂县', '3', '3379');
INSERT INTO `tp_region` VALUES ('3417', '秀水镇', '4', '3416');
INSERT INTO `tp_region` VALUES ('3418', '孙家庄镇', '4', '3416');
INSERT INTO `tp_region` VALUES ('3419', '路家村镇', '4', '3416');
INSERT INTO `tp_region` VALUES ('3420', '南娄镇', '4', '3416');
INSERT INTO `tp_region` VALUES ('3421', '牛村镇', '4', '3416');
INSERT INTO `tp_region` VALUES ('3422', '长池镇', '4', '3416');
INSERT INTO `tp_region` VALUES ('3423', '上社镇', '4', '3416');
INSERT INTO `tp_region` VALUES ('3424', '西烟镇', '4', '3416');
INSERT INTO `tp_region` VALUES ('3425', '仙人乡', '4', '3416');
INSERT INTO `tp_region` VALUES ('3426', '北下庄乡', '4', '3416');
INSERT INTO `tp_region` VALUES ('3427', '下社乡', '4', '3416');
INSERT INTO `tp_region` VALUES ('3428', '梁家寨乡', '4', '3416');
INSERT INTO `tp_region` VALUES ('3429', '西潘乡', '4', '3416');
INSERT INTO `tp_region` VALUES ('3430', '东梁乡', '4', '3416');
INSERT INTO `tp_region` VALUES ('3431', '长治市', '2', '3102');
INSERT INTO `tp_region` VALUES ('3432', '市辖区', '3', '3431');
INSERT INTO `tp_region` VALUES ('3433', '长治市城区', '3', '3431');
INSERT INTO `tp_region` VALUES ('3434', '东街街道', '4', '3433');
INSERT INTO `tp_region` VALUES ('3435', '西街街道', '4', '3433');
INSERT INTO `tp_region` VALUES ('3436', '英雄南路街道', '4', '3433');
INSERT INTO `tp_region` VALUES ('3437', '英雄中路街道', '4', '3433');
INSERT INTO `tp_region` VALUES ('3438', '紫金路街道', '4', '3433');
INSERT INTO `tp_region` VALUES ('3439', '太东街道', '4', '3433');
INSERT INTO `tp_region` VALUES ('3440', '太西街道', '4', '3433');
INSERT INTO `tp_region` VALUES ('3441', '延安南路街道', '4', '3433');
INSERT INTO `tp_region` VALUES ('3442', '常青街道', '4', '3433');
INSERT INTO `tp_region` VALUES ('3443', '五马街道', '4', '3433');
INSERT INTO `tp_region` VALUES ('3444', '长治市高新技术开发区', '4', '3433');
INSERT INTO `tp_region` VALUES ('3445', '长治市郊区', '3', '3431');
INSERT INTO `tp_region` VALUES ('3446', '长北街道', '4', '3445');
INSERT INTO `tp_region` VALUES ('3447', '故县街道', '4', '3445');
INSERT INTO `tp_region` VALUES ('3448', '老顶山镇', '4', '3445');
INSERT INTO `tp_region` VALUES ('3449', '堠北庄镇', '4', '3445');
INSERT INTO `tp_region` VALUES ('3450', '大辛庄镇', '4', '3445');
INSERT INTO `tp_region` VALUES ('3451', '马厂镇', '4', '3445');
INSERT INTO `tp_region` VALUES ('3452', '黄碾镇', '4', '3445');
INSERT INTO `tp_region` VALUES ('3453', '西白兔乡', '4', '3445');
INSERT INTO `tp_region` VALUES ('3454', '长治县', '3', '3431');
INSERT INTO `tp_region` VALUES ('3455', '韩店镇', '4', '3454');
INSERT INTO `tp_region` VALUES ('3456', '苏店镇', '4', '3454');
INSERT INTO `tp_region` VALUES ('3457', '荫城镇', '4', '3454');
INSERT INTO `tp_region` VALUES ('3458', '西火镇', '4', '3454');
INSERT INTO `tp_region` VALUES ('3459', '八义镇', '4', '3454');
INSERT INTO `tp_region` VALUES ('3460', '贾掌镇', '4', '3454');
INSERT INTO `tp_region` VALUES ('3461', '郝家庄乡', '4', '3454');
INSERT INTO `tp_region` VALUES ('3462', '西池乡', '4', '3454');
INSERT INTO `tp_region` VALUES ('3463', '北呈乡', '4', '3454');
INSERT INTO `tp_region` VALUES ('3464', '东和乡', '4', '3454');
INSERT INTO `tp_region` VALUES ('3465', '南宋乡', '4', '3454');
INSERT INTO `tp_region` VALUES ('3466', '襄垣县', '3', '3431');
INSERT INTO `tp_region` VALUES ('3467', '古韩镇', '4', '3466');
INSERT INTO `tp_region` VALUES ('3468', '王桥镇', '4', '3466');
INSERT INTO `tp_region` VALUES ('3469', '侯堡镇', '4', '3466');
INSERT INTO `tp_region` VALUES ('3470', '夏店镇', '4', '3466');
INSERT INTO `tp_region` VALUES ('3471', '虎（音si）亭镇', '4', '3466');
INSERT INTO `tp_region` VALUES ('3472', '西营镇', '4', '3466');
INSERT INTO `tp_region` VALUES ('3473', '王村镇', '4', '3466');
INSERT INTO `tp_region` VALUES ('3474', '下良镇', '4', '3466');
INSERT INTO `tp_region` VALUES ('3475', '善福乡', '4', '3466');
INSERT INTO `tp_region` VALUES ('3476', '北底乡', '4', '3466');
INSERT INTO `tp_region` VALUES ('3477', '上马乡', '4', '3466');
INSERT INTO `tp_region` VALUES ('3478', '屯留县', '3', '3431');
INSERT INTO `tp_region` VALUES ('3479', '麟绛镇', '4', '3478');
INSERT INTO `tp_region` VALUES ('3480', '上村镇', '4', '3478');
INSERT INTO `tp_region` VALUES ('3481', '渔泽镇', '4', '3478');
INSERT INTO `tp_region` VALUES ('3482', '余吾镇', '4', '3478');
INSERT INTO `tp_region` VALUES ('3483', '吾元镇', '4', '3478');
INSERT INTO `tp_region` VALUES ('3484', '张店镇', '4', '3478');
INSERT INTO `tp_region` VALUES ('3485', '丰宜镇', '4', '3478');
INSERT INTO `tp_region` VALUES ('3486', '李高乡', '4', '3478');
INSERT INTO `tp_region` VALUES ('3487', '路村乡', '4', '3478');
INSERT INTO `tp_region` VALUES ('3488', '河神庙乡', '4', '3478');
INSERT INTO `tp_region` VALUES ('3489', '西贾乡', '4', '3478');
INSERT INTO `tp_region` VALUES ('3490', '西流寨开发区', '4', '3478');
INSERT INTO `tp_region` VALUES ('3491', '康庄工业园区', '4', '3478');
INSERT INTO `tp_region` VALUES ('3492', '上莲开发区', '4', '3478');
INSERT INTO `tp_region` VALUES ('3493', '平顺县', '3', '3431');
INSERT INTO `tp_region` VALUES ('3494', '青羊镇', '4', '3493');
INSERT INTO `tp_region` VALUES ('3495', '龙溪镇', '4', '3493');
INSERT INTO `tp_region` VALUES ('3496', '石城镇', '4', '3493');
INSERT INTO `tp_region` VALUES ('3497', '苗庄镇', '4', '3493');
INSERT INTO `tp_region` VALUES ('3498', '杏城镇', '4', '3493');
INSERT INTO `tp_region` VALUES ('3499', '西沟乡', '4', '3493');
INSERT INTO `tp_region` VALUES ('3500', '东寺头乡', '4', '3493');
INSERT INTO `tp_region` VALUES ('3501', '虹梯关乡', '4', '3493');
INSERT INTO `tp_region` VALUES ('3502', '阳高乡', '4', '3493');
INSERT INTO `tp_region` VALUES ('3503', '北耽车乡', '4', '3493');
INSERT INTO `tp_region` VALUES ('3504', '中五井乡', '4', '3493');
INSERT INTO `tp_region` VALUES ('3505', '北社乡', '4', '3493');
INSERT INTO `tp_region` VALUES ('3506', '黎城县', '3', '3431');
INSERT INTO `tp_region` VALUES ('3507', '黎侯镇', '4', '3506');
INSERT INTO `tp_region` VALUES ('3508', '东阳关镇', '4', '3506');
INSERT INTO `tp_region` VALUES ('3509', '上遥镇', '4', '3506');
INSERT INTO `tp_region` VALUES ('3510', '西井镇', '4', '3506');
INSERT INTO `tp_region` VALUES ('3511', '黄崖洞镇', '4', '3506');
INSERT INTO `tp_region` VALUES ('3512', '西仵乡', '4', '3506');
INSERT INTO `tp_region` VALUES ('3513', '停河铺乡', '4', '3506');
INSERT INTO `tp_region` VALUES ('3514', '程家山乡', '4', '3506');
INSERT INTO `tp_region` VALUES ('3515', '洪井乡', '4', '3506');
INSERT INTO `tp_region` VALUES ('3516', '壶关县', '3', '3431');
INSERT INTO `tp_region` VALUES ('3517', '龙泉镇', '4', '3516');
INSERT INTO `tp_region` VALUES ('3518', '百尺镇', '4', '3516');
INSERT INTO `tp_region` VALUES ('3519', '店上镇', '4', '3516');
INSERT INTO `tp_region` VALUES ('3520', '晋庄镇', '4', '3516');
INSERT INTO `tp_region` VALUES ('3521', '树掌镇', '4', '3516');
INSERT INTO `tp_region` VALUES ('3522', '集店乡', '4', '3516');
INSERT INTO `tp_region` VALUES ('3523', '黄山乡', '4', '3516');
INSERT INTO `tp_region` VALUES ('3524', '东井岭乡', '4', '3516');
INSERT INTO `tp_region` VALUES ('3525', '石坡乡', '4', '3516');
INSERT INTO `tp_region` VALUES ('3526', '五龙山乡', '4', '3516');
INSERT INTO `tp_region` VALUES ('3527', '鹅屋乡', '4', '3516');
INSERT INTO `tp_region` VALUES ('3528', '桥上乡', '4', '3516');
INSERT INTO `tp_region` VALUES ('3529', '常平经济开发区', '4', '3516');
INSERT INTO `tp_region` VALUES ('3530', '长子县', '3', '3431');
INSERT INTO `tp_region` VALUES ('3531', '丹朱镇', '4', '3530');
INSERT INTO `tp_region` VALUES ('3532', '鲍店镇', '4', '3530');
INSERT INTO `tp_region` VALUES ('3533', '石哲镇', '4', '3530');
INSERT INTO `tp_region` VALUES ('3534', '大堡头镇', '4', '3530');
INSERT INTO `tp_region` VALUES ('3535', '慈林镇', '4', '3530');
INSERT INTO `tp_region` VALUES ('3536', '色头镇', '4', '3530');
INSERT INTO `tp_region` VALUES ('3537', '南漳镇', '4', '3530');
INSERT INTO `tp_region` VALUES ('3538', '岚水乡', '4', '3530');
INSERT INTO `tp_region` VALUES ('3539', '碾张乡', '4', '3530');
INSERT INTO `tp_region` VALUES ('3540', '常张乡', '4', '3530');
INSERT INTO `tp_region` VALUES ('3541', '南陈乡', '4', '3530');
INSERT INTO `tp_region` VALUES ('3542', '宋村乡', '4', '3530');
INSERT INTO `tp_region` VALUES ('3543', '武乡县', '3', '3431');
INSERT INTO `tp_region` VALUES ('3544', '丰州镇', '4', '3543');
INSERT INTO `tp_region` VALUES ('3545', '洪水镇', '4', '3543');
INSERT INTO `tp_region` VALUES ('3546', '蟠龙镇', '4', '3543');
INSERT INTO `tp_region` VALUES ('3547', '监漳镇', '4', '3543');
INSERT INTO `tp_region` VALUES ('3548', '故城镇', '4', '3543');
INSERT INTO `tp_region` VALUES ('3549', '墨镫乡', '4', '3543');
INSERT INTO `tp_region` VALUES ('3550', '韩北乡', '4', '3543');
INSERT INTO `tp_region` VALUES ('3551', '大有乡', '4', '3543');
INSERT INTO `tp_region` VALUES ('3552', '贾豁乡', '4', '3543');
INSERT INTO `tp_region` VALUES ('3553', '故县乡', '4', '3543');
INSERT INTO `tp_region` VALUES ('3554', '上司乡', '4', '3543');
INSERT INTO `tp_region` VALUES ('3555', '石北乡', '4', '3543');
INSERT INTO `tp_region` VALUES ('3556', '涌泉乡', '4', '3543');
INSERT INTO `tp_region` VALUES ('3557', '分水岭乡', '4', '3543');
INSERT INTO `tp_region` VALUES ('3558', '沁县', '3', '3431');
INSERT INTO `tp_region` VALUES ('3559', '定昌镇', '4', '3558');
INSERT INTO `tp_region` VALUES ('3560', '郭村镇', '4', '3558');
INSERT INTO `tp_region` VALUES ('3561', '故县镇', '4', '3558');
INSERT INTO `tp_region` VALUES ('3562', '新店镇', '4', '3558');
INSERT INTO `tp_region` VALUES ('3563', '漳源镇', '4', '3558');
INSERT INTO `tp_region` VALUES ('3564', '册村镇', '4', '3558');
INSERT INTO `tp_region` VALUES ('3565', '段柳乡', '4', '3558');
INSERT INTO `tp_region` VALUES ('3566', '松村乡', '4', '3558');
INSERT INTO `tp_region` VALUES ('3567', '次村乡', '4', '3558');
INSERT INTO `tp_region` VALUES ('3568', '牛寺乡', '4', '3558');
INSERT INTO `tp_region` VALUES ('3569', '南里乡', '4', '3558');
INSERT INTO `tp_region` VALUES ('3570', '南泉乡', '4', '3558');
INSERT INTO `tp_region` VALUES ('3571', '杨安乡', '4', '3558');
INSERT INTO `tp_region` VALUES ('3572', '沁源县', '3', '3431');
INSERT INTO `tp_region` VALUES ('3573', '沁河镇', '4', '3572');
INSERT INTO `tp_region` VALUES ('3574', '郭道镇', '4', '3572');
INSERT INTO `tp_region` VALUES ('3575', '灵空山镇', '4', '3572');
INSERT INTO `tp_region` VALUES ('3576', '王和镇', '4', '3572');
INSERT INTO `tp_region` VALUES ('3577', '李元镇', '4', '3572');
INSERT INTO `tp_region` VALUES ('3578', '中峪乡', '4', '3572');
INSERT INTO `tp_region` VALUES ('3579', '法中乡', '4', '3572');
INSERT INTO `tp_region` VALUES ('3580', '交口乡', '4', '3572');
INSERT INTO `tp_region` VALUES ('3581', '聪子峪乡', '4', '3572');
INSERT INTO `tp_region` VALUES ('3582', '韩洪乡', '4', '3572');
INSERT INTO `tp_region` VALUES ('3583', '官滩乡', '4', '3572');
INSERT INTO `tp_region` VALUES ('3584', '景凤乡', '4', '3572');
INSERT INTO `tp_region` VALUES ('3585', '赤石桥乡', '4', '3572');
INSERT INTO `tp_region` VALUES ('3586', '王陶乡', '4', '3572');
INSERT INTO `tp_region` VALUES ('3587', '潞城市', '3', '3431');
INSERT INTO `tp_region` VALUES ('3588', '潞华', '4', '3587');
INSERT INTO `tp_region` VALUES ('3589', '成家川', '4', '3587');
INSERT INTO `tp_region` VALUES ('3590', '店上镇', '4', '3587');
INSERT INTO `tp_region` VALUES ('3591', '微子镇', '4', '3587');
INSERT INTO `tp_region` VALUES ('3592', '辛安泉镇', '4', '3587');
INSERT INTO `tp_region` VALUES ('3593', '翟店镇', '4', '3587');
INSERT INTO `tp_region` VALUES ('3594', '合室乡', '4', '3587');
INSERT INTO `tp_region` VALUES ('3595', '黄牛蹄乡', '4', '3587');
INSERT INTO `tp_region` VALUES ('3596', '史回乡', '4', '3587');
INSERT INTO `tp_region` VALUES ('3597', '晋城市', '2', '3102');
INSERT INTO `tp_region` VALUES ('3598', '市辖区', '3', '3597');
INSERT INTO `tp_region` VALUES ('3599', '晋城市城区', '3', '3597');
INSERT INTO `tp_region` VALUES ('3600', '东街街道', '4', '3599');
INSERT INTO `tp_region` VALUES ('3601', '西街街道', '4', '3599');
INSERT INTO `tp_region` VALUES ('3602', '南街街道', '4', '3599');
INSERT INTO `tp_region` VALUES ('3603', '北街街道', '4', '3599');
INSERT INTO `tp_region` VALUES ('3604', '矿区街道', '4', '3599');
INSERT INTO `tp_region` VALUES ('3605', '钟家庄街道', '4', '3599');
INSERT INTO `tp_region` VALUES ('3606', '西上庄街道', '4', '3599');
INSERT INTO `tp_region` VALUES ('3607', '北石店镇', '4', '3599');
INSERT INTO `tp_region` VALUES ('3608', '沁水县', '3', '3597');
INSERT INTO `tp_region` VALUES ('3609', '龙港镇', '4', '3608');
INSERT INTO `tp_region` VALUES ('3610', '中村镇', '4', '3608');
INSERT INTO `tp_region` VALUES ('3611', '郑庄镇', '4', '3608');
INSERT INTO `tp_region` VALUES ('3612', '端氏镇', '4', '3608');
INSERT INTO `tp_region` VALUES ('3613', '嘉峰镇', '4', '3608');
INSERT INTO `tp_region` VALUES ('3614', '郑村镇', '4', '3608');
INSERT INTO `tp_region` VALUES ('3615', '柿庄镇', '4', '3608');
INSERT INTO `tp_region` VALUES ('3616', '樊村河乡', '4', '3608');
INSERT INTO `tp_region` VALUES ('3617', '土沃乡', '4', '3608');
INSERT INTO `tp_region` VALUES ('3618', '张村乡', '4', '3608');
INSERT INTO `tp_region` VALUES ('3619', '苏庄乡', '4', '3608');
INSERT INTO `tp_region` VALUES ('3620', '胡底乡', '4', '3608');
INSERT INTO `tp_region` VALUES ('3621', '固县乡', '4', '3608');
INSERT INTO `tp_region` VALUES ('3622', '十里乡', '4', '3608');
INSERT INTO `tp_region` VALUES ('3623', '阳城县', '3', '3597');
INSERT INTO `tp_region` VALUES ('3624', '东城街道', '4', '3623');
INSERT INTO `tp_region` VALUES ('3625', '凤城镇', '4', '3623');
INSERT INTO `tp_region` VALUES ('3626', '北留镇', '4', '3623');
INSERT INTO `tp_region` VALUES ('3627', '润城镇', '4', '3623');
INSERT INTO `tp_region` VALUES ('3628', '町店镇', '4', '3623');
INSERT INTO `tp_region` VALUES ('3629', '芹池镇', '4', '3623');
INSERT INTO `tp_region` VALUES ('3630', '次营镇', '4', '3623');
INSERT INTO `tp_region` VALUES ('3631', '横河镇', '4', '3623');
INSERT INTO `tp_region` VALUES ('3632', '河北镇', '4', '3623');
INSERT INTO `tp_region` VALUES ('3633', '蟒河镇', '4', '3623');
INSERT INTO `tp_region` VALUES ('3634', '东冶镇', '4', '3623');
INSERT INTO `tp_region` VALUES ('3635', '白桑乡', '4', '3623');
INSERT INTO `tp_region` VALUES ('3636', '寺头乡', '4', '3623');
INSERT INTO `tp_region` VALUES ('3637', '西河乡', '4', '3623');
INSERT INTO `tp_region` VALUES ('3638', '演礼乡', '4', '3623');
INSERT INTO `tp_region` VALUES ('3639', '固隆乡', '4', '3623');
INSERT INTO `tp_region` VALUES ('3640', '董封乡', '4', '3623');
INSERT INTO `tp_region` VALUES ('3641', '驾岭乡', '4', '3623');
INSERT INTO `tp_region` VALUES ('3642', '陵川县', '3', '3597');
INSERT INTO `tp_region` VALUES ('3643', '崇文镇', '4', '3642');
INSERT INTO `tp_region` VALUES ('3644', '礼义镇', '4', '3642');
INSERT INTO `tp_region` VALUES ('3645', '附城镇', '4', '3642');
INSERT INTO `tp_region` VALUES ('3646', '西河底镇', '4', '3642');
INSERT INTO `tp_region` VALUES ('3647', '平城镇', '4', '3642');
INSERT INTO `tp_region` VALUES ('3648', '杨村镇', '4', '3642');
INSERT INTO `tp_region` VALUES ('3649', '潞城镇', '4', '3642');
INSERT INTO `tp_region` VALUES ('3650', '夺火乡', '4', '3642');
INSERT INTO `tp_region` VALUES ('3651', '马圪当乡', '4', '3642');
INSERT INTO `tp_region` VALUES ('3652', '古郊乡', '4', '3642');
INSERT INTO `tp_region` VALUES ('3653', '六泉乡', '4', '3642');
INSERT INTO `tp_region` VALUES ('3654', '秦家庄乡', '4', '3642');
INSERT INTO `tp_region` VALUES ('3655', '泽州县', '3', '3597');
INSERT INTO `tp_region` VALUES ('3656', '南村镇', '4', '3655');
INSERT INTO `tp_region` VALUES ('3657', '下村镇', '4', '3655');
INSERT INTO `tp_region` VALUES ('3658', '大东沟镇', '4', '3655');
INSERT INTO `tp_region` VALUES ('3659', '周村镇', '4', '3655');
INSERT INTO `tp_region` VALUES ('3660', '犁川镇', '4', '3655');
INSERT INTO `tp_region` VALUES ('3661', '晋庙铺镇', '4', '3655');
INSERT INTO `tp_region` VALUES ('3662', '金村镇', '4', '3655');
INSERT INTO `tp_region` VALUES ('3663', '高都镇', '4', '3655');
INSERT INTO `tp_region` VALUES ('3664', '巴公镇', '4', '3655');
INSERT INTO `tp_region` VALUES ('3665', '大阳镇', '4', '3655');
INSERT INTO `tp_region` VALUES ('3666', '山河镇', '4', '3655');
INSERT INTO `tp_region` VALUES ('3667', '大箕镇', '4', '3655');
INSERT INTO `tp_region` VALUES ('3668', '柳树口镇', '4', '3655');
INSERT INTO `tp_region` VALUES ('3669', '北义城镇', '4', '3655');
INSERT INTO `tp_region` VALUES ('3670', '川底乡', '4', '3655');
INSERT INTO `tp_region` VALUES ('3671', '李寨乡', '4', '3655');
INSERT INTO `tp_region` VALUES ('3672', '南岭乡', '4', '3655');
INSERT INTO `tp_region` VALUES ('3673', '高平市', '3', '3597');
INSERT INTO `tp_region` VALUES ('3674', '北城街道', '4', '3673');
INSERT INTO `tp_region` VALUES ('3675', '东城街道', '4', '3673');
INSERT INTO `tp_region` VALUES ('3676', '南城街道', '4', '3673');
INSERT INTO `tp_region` VALUES ('3677', '米山镇', '4', '3673');
INSERT INTO `tp_region` VALUES ('3678', '三甲镇', '4', '3673');
INSERT INTO `tp_region` VALUES ('3679', '神农镇', '4', '3673');
INSERT INTO `tp_region` VALUES ('3680', '陈区镇', '4', '3673');
INSERT INTO `tp_region` VALUES ('3681', '北诗镇', '4', '3673');
INSERT INTO `tp_region` VALUES ('3682', '河西镇', '4', '3673');
INSERT INTO `tp_region` VALUES ('3683', '马村镇', '4', '3673');
INSERT INTO `tp_region` VALUES ('3684', '野川镇', '4', '3673');
INSERT INTO `tp_region` VALUES ('3685', '寺庄镇', '4', '3673');
INSERT INTO `tp_region` VALUES ('3686', '建宁乡', '4', '3673');
INSERT INTO `tp_region` VALUES ('3687', '石末乡', '4', '3673');
INSERT INTO `tp_region` VALUES ('3688', '原村乡', '4', '3673');
INSERT INTO `tp_region` VALUES ('3689', '永录乡', '4', '3673');
INSERT INTO `tp_region` VALUES ('3690', '朔州市', '2', '3102');
INSERT INTO `tp_region` VALUES ('3691', '市辖区', '3', '3690');
INSERT INTO `tp_region` VALUES ('3692', '朔城区', '3', '3690');
INSERT INTO `tp_region` VALUES ('3693', '朔城区北城街道', '4', '3692');
INSERT INTO `tp_region` VALUES ('3694', '朔城区南城街道', '4', '3692');
INSERT INTO `tp_region` VALUES ('3695', '朔城区神头街道', '4', '3692');
INSERT INTO `tp_region` VALUES ('3696', '朔城区北旺庄街道', '4', '3692');
INSERT INTO `tp_region` VALUES ('3697', '朔城区神头镇', '4', '3692');
INSERT INTO `tp_region` VALUES ('3698', '朔城区利民镇', '4', '3692');
INSERT INTO `tp_region` VALUES ('3699', '朔城区下团堡乡', '4', '3692');
INSERT INTO `tp_region` VALUES ('3700', '朔城区小平易乡', '4', '3692');
INSERT INTO `tp_region` VALUES ('3701', '朔城区滋润乡', '4', '3692');
INSERT INTO `tp_region` VALUES ('3702', '朔城区福善庄乡', '4', '3692');
INSERT INTO `tp_region` VALUES ('3703', '朔城区南榆林乡', '4', '3692');
INSERT INTO `tp_region` VALUES ('3704', '朔城区贾庄乡', '4', '3692');
INSERT INTO `tp_region` VALUES ('3705', '朔城区沙塄河乡', '4', '3692');
INSERT INTO `tp_region` VALUES ('3706', '朔城区窑子头乡', '4', '3692');
INSERT INTO `tp_region` VALUES ('3707', '朔城区张蔡庄乡', '4', '3692');
INSERT INTO `tp_region` VALUES ('3708', '朔州市开发区管委会', '4', '3692');
INSERT INTO `tp_region` VALUES ('3709', '平鲁区', '3', '3690');
INSERT INTO `tp_region` VALUES ('3710', '平鲁区井坪镇', '4', '3709');
INSERT INTO `tp_region` VALUES ('3711', '平鲁区凤凰城镇', '4', '3709');
INSERT INTO `tp_region` VALUES ('3712', '平鲁区白堂乡', '4', '3709');
INSERT INTO `tp_region` VALUES ('3713', '平鲁区陶村乡', '4', '3709');
INSERT INTO `tp_region` VALUES ('3714', '平鲁区下水头乡', '4', '3709');
INSERT INTO `tp_region` VALUES ('3715', '平鲁区双碾乡', '4', '3709');
INSERT INTO `tp_region` VALUES ('3716', '平鲁区阻虎乡', '4', '3709');
INSERT INTO `tp_region` VALUES ('3717', '平鲁区高石庄乡', '4', '3709');
INSERT INTO `tp_region` VALUES ('3718', '平鲁区西水界乡', '4', '3709');
INSERT INTO `tp_region` VALUES ('3719', '平鲁区下面高乡', '4', '3709');
INSERT INTO `tp_region` VALUES ('3720', '平鲁区下木角乡', '4', '3709');
INSERT INTO `tp_region` VALUES ('3721', '平鲁区向阳堡乡', '4', '3709');
INSERT INTO `tp_region` VALUES ('3722', '平鲁区榆岭乡', '4', '3709');
INSERT INTO `tp_region` VALUES ('3723', '山阴县', '3', '3690');
INSERT INTO `tp_region` VALUES ('3724', '东城管委会', '4', '3723');
INSERT INTO `tp_region` VALUES ('3725', '西城管委会', '4', '3723');
INSERT INTO `tp_region` VALUES ('3726', '玉井镇', '4', '3723');
INSERT INTO `tp_region` VALUES ('3727', '北周庄镇', '4', '3723');
INSERT INTO `tp_region` VALUES ('3728', '古城镇', '4', '3723');
INSERT INTO `tp_region` VALUES ('3729', '吴马营乡', '4', '3723');
INSERT INTO `tp_region` VALUES ('3730', '马营乡', '4', '3723');
INSERT INTO `tp_region` VALUES ('3731', '下喇叭乡', '4', '3723');
INSERT INTO `tp_region` VALUES ('3732', '合盛堡乡', '4', '3723');
INSERT INTO `tp_region` VALUES ('3733', '岱岳乡', '4', '3723');
INSERT INTO `tp_region` VALUES ('3734', '安荣乡', '4', '3723');
INSERT INTO `tp_region` VALUES ('3735', '薛OO乡', '4', '3723');
INSERT INTO `tp_region` VALUES ('3736', '后所乡', '4', '3723');
INSERT INTO `tp_region` VALUES ('3737', '张家庄乡', '4', '3723');
INSERT INTO `tp_region` VALUES ('3738', '马营庄乡', '4', '3723');
INSERT INTO `tp_region` VALUES ('3739', '应县', '3', '3690');
INSERT INTO `tp_region` VALUES ('3740', '金城镇', '4', '3739');
INSERT INTO `tp_region` VALUES ('3741', '南河种镇', '4', '3739');
INSERT INTO `tp_region` VALUES ('3742', '下社镇', '4', '3739');
INSERT INTO `tp_region` VALUES ('3743', '镇子梁乡', '4', '3739');
INSERT INTO `tp_region` VALUES ('3744', '义井乡', '4', '3739');
INSERT INTO `tp_region` VALUES ('3745', '藏寨乡', '4', '3739');
INSERT INTO `tp_region` VALUES ('3746', '大黄巍乡', '4', '3739');
INSERT INTO `tp_region` VALUES ('3747', '杏寨乡', '4', '3739');
INSERT INTO `tp_region` VALUES ('3748', '下马峪乡', '4', '3739');
INSERT INTO `tp_region` VALUES ('3749', '南泉乡', '4', '3739');
INSERT INTO `tp_region` VALUES ('3750', '大临河乡', '4', '3739');
INSERT INTO `tp_region` VALUES ('3751', '白马石乡', '4', '3739');
INSERT INTO `tp_region` VALUES ('3752', '右玉县', '3', '3690');
INSERT INTO `tp_region` VALUES ('3753', '新城镇', '4', '3752');
INSERT INTO `tp_region` VALUES ('3754', '右卫镇', '4', '3752');
INSERT INTO `tp_region` VALUES ('3755', '威远镇', '4', '3752');
INSERT INTO `tp_region` VALUES ('3756', '元堡子镇', '4', '3752');
INSERT INTO `tp_region` VALUES ('3757', '牛心堡乡', '4', '3752');
INSERT INTO `tp_region` VALUES ('3758', '白头里乡', '4', '3752');
INSERT INTO `tp_region` VALUES ('3759', '高家堡乡', '4', '3752');
INSERT INTO `tp_region` VALUES ('3760', '丁家窑乡', '4', '3752');
INSERT INTO `tp_region` VALUES ('3761', '杨千河乡', '4', '3752');
INSERT INTO `tp_region` VALUES ('3762', '李达窑乡', '4', '3752');
INSERT INTO `tp_region` VALUES ('3763', '怀仁县', '3', '3690');
INSERT INTO `tp_region` VALUES ('3764', '云中镇', '4', '3763');
INSERT INTO `tp_region` VALUES ('3765', '吴家窑镇', '4', '3763');
INSERT INTO `tp_region` VALUES ('3766', '金沙滩镇', '4', '3763');
INSERT INTO `tp_region` VALUES ('3767', '毛家皂镇', '4', '3763');
INSERT INTO `tp_region` VALUES ('3768', '何家堡乡', '4', '3763');
INSERT INTO `tp_region` VALUES ('3769', '新家园乡', '4', '3763');
INSERT INTO `tp_region` VALUES ('3770', '亲和乡', '4', '3763');
INSERT INTO `tp_region` VALUES ('3771', '海北头乡', '4', '3763');
INSERT INTO `tp_region` VALUES ('3772', '马辛庄乡', '4', '3763');
INSERT INTO `tp_region` VALUES ('3773', '河头乡', '4', '3763');
INSERT INTO `tp_region` VALUES ('3774', '金沙滩农牧场', '4', '3763');
INSERT INTO `tp_region` VALUES ('3775', '金沙滩林场', '4', '3763');
INSERT INTO `tp_region` VALUES ('3776', '晋中市', '2', '3102');
INSERT INTO `tp_region` VALUES ('3777', '市辖区', '3', '3776');
INSERT INTO `tp_region` VALUES ('3778', '榆次区', '3', '3776');
INSERT INTO `tp_region` VALUES ('3779', '北关街道', '4', '3778');
INSERT INTO `tp_region` VALUES ('3780', '锦纶街道', '4', '3778');
INSERT INTO `tp_region` VALUES ('3781', '新华街道', '4', '3778');
INSERT INTO `tp_region` VALUES ('3782', '西南街道', '4', '3778');
INSERT INTO `tp_region` VALUES ('3783', '路西街道', '4', '3778');
INSERT INTO `tp_region` VALUES ('3784', '经纬街道', '4', '3778');
INSERT INTO `tp_region` VALUES ('3785', '安宁街道', '4', '3778');
INSERT INTO `tp_region` VALUES ('3786', '新建街道', '4', '3778');
INSERT INTO `tp_region` VALUES ('3787', '晋华街道', '4', '3778');
INSERT INTO `tp_region` VALUES ('3788', '乌金山镇', '4', '3778');
INSERT INTO `tp_region` VALUES ('3789', '东阳镇', '4', '3778');
INSERT INTO `tp_region` VALUES ('3790', '什贴镇', '4', '3778');
INSERT INTO `tp_region` VALUES ('3791', '长凝镇', '4', '3778');
INSERT INTO `tp_region` VALUES ('3792', '北田镇', '4', '3778');
INSERT INTO `tp_region` VALUES ('3793', '修文镇', '4', '3778');
INSERT INTO `tp_region` VALUES ('3794', '郭家堡乡', '4', '3778');
INSERT INTO `tp_region` VALUES ('3795', '张庆乡', '4', '3778');
INSERT INTO `tp_region` VALUES ('3796', '庄子乡', '4', '3778');
INSERT INTO `tp_region` VALUES ('3797', '东赵乡', '4', '3778');
INSERT INTO `tp_region` VALUES ('3798', '晋中经济开发区', '4', '3778');
INSERT INTO `tp_region` VALUES ('3799', '榆社县', '3', '3776');
INSERT INTO `tp_region` VALUES ('3800', '城区街道管理委员会', '4', '3799');
INSERT INTO `tp_region` VALUES ('3801', '箕城镇', '4', '3799');
INSERT INTO `tp_region` VALUES ('3802', '云竹镇', '4', '3799');
INSERT INTO `tp_region` VALUES ('3803', '郝北镇', '4', '3799');
INSERT INTO `tp_region` VALUES ('3804', '社城镇', '4', '3799');
INSERT INTO `tp_region` VALUES ('3805', '河峪乡', '4', '3799');
INSERT INTO `tp_region` VALUES ('3806', '北寨乡', '4', '3799');
INSERT INTO `tp_region` VALUES ('3807', '西马乡', '4', '3799');
INSERT INTO `tp_region` VALUES ('3808', '岚峪乡', '4', '3799');
INSERT INTO `tp_region` VALUES ('3809', '讲堂乡', '4', '3799');
INSERT INTO `tp_region` VALUES ('3810', '左权县', '3', '3776');
INSERT INTO `tp_region` VALUES ('3811', '县城街道社区管理委员会', '4', '3810');
INSERT INTO `tp_region` VALUES ('3812', '辽阳镇', '4', '3810');
INSERT INTO `tp_region` VALUES ('3813', '桐峪镇', '4', '3810');
INSERT INTO `tp_region` VALUES ('3814', '麻田镇', '4', '3810');
INSERT INTO `tp_region` VALUES ('3815', '芹泉镇', '4', '3810');
INSERT INTO `tp_region` VALUES ('3816', '拐儿镇', '4', '3810');
INSERT INTO `tp_region` VALUES ('3817', '寒王乡', '4', '3810');
INSERT INTO `tp_region` VALUES ('3818', '石匣乡', '4', '3810');
INSERT INTO `tp_region` VALUES ('3819', '龙泉乡', '4', '3810');
INSERT INTO `tp_region` VALUES ('3820', '粟城乡', '4', '3810');
INSERT INTO `tp_region` VALUES ('3821', '羊角乡', '4', '3810');
INSERT INTO `tp_region` VALUES ('3822', '和顺县', '3', '3776');
INSERT INTO `tp_region` VALUES ('3823', '义兴镇', '4', '3822');
INSERT INTO `tp_region` VALUES ('3824', '李阳镇', '4', '3822');
INSERT INTO `tp_region` VALUES ('3825', '松烟镇', '4', '3822');
INSERT INTO `tp_region` VALUES ('3826', '青城镇', '4', '3822');
INSERT INTO `tp_region` VALUES ('3827', '横岭镇', '4', '3822');
INSERT INTO `tp_region` VALUES ('3828', '喂马乡', '4', '3822');
INSERT INTO `tp_region` VALUES ('3829', '平松乡', '4', '3822');
INSERT INTO `tp_region` VALUES ('3830', '牛川乡', '4', '3822');
INSERT INTO `tp_region` VALUES ('3831', '马坊乡', '4', '3822');
INSERT INTO `tp_region` VALUES ('3832', '阳光占乡', '4', '3822');
INSERT INTO `tp_region` VALUES ('3833', '昔阳县', '3', '3776');
INSERT INTO `tp_region` VALUES ('3834', '乐平镇', '4', '3833');
INSERT INTO `tp_region` VALUES ('3835', '皋落镇', '4', '3833');
INSERT INTO `tp_region` VALUES ('3836', '冶头镇', '4', '3833');
INSERT INTO `tp_region` VALUES ('3837', '沾尚镇', '4', '3833');
INSERT INTO `tp_region` VALUES ('3838', '大寨镇', '4', '3833');
INSERT INTO `tp_region` VALUES ('3839', '李家庄乡', '4', '3833');
INSERT INTO `tp_region` VALUES ('3840', '界都乡', '4', '3833');
INSERT INTO `tp_region` VALUES ('3841', '三都乡', '4', '3833');
INSERT INTO `tp_region` VALUES ('3842', '赵壁乡', '4', '3833');
INSERT INTO `tp_region` VALUES ('3843', '孔氏乡', '4', '3833');
INSERT INTO `tp_region` VALUES ('3844', '阎庄乡', '4', '3833');
INSERT INTO `tp_region` VALUES ('3845', '西寨乡', '4', '3833');
INSERT INTO `tp_region` VALUES ('3846', '寿阳县', '3', '3776');
INSERT INTO `tp_region` VALUES ('3847', '朝阳镇', '4', '3846');
INSERT INTO `tp_region` VALUES ('3848', '南燕竹镇', '4', '3846');
INSERT INTO `tp_region` VALUES ('3849', '宗艾镇', '4', '3846');
INSERT INTO `tp_region` VALUES ('3850', '平头镇', '4', '3846');
INSERT INTO `tp_region` VALUES ('3851', '松塔镇', '4', '3846');
INSERT INTO `tp_region` VALUES ('3852', '西洛镇', '4', '3846');
INSERT INTO `tp_region` VALUES ('3853', '尹灵芝镇', '4', '3846');
INSERT INTO `tp_region` VALUES ('3854', '平舒乡', '4', '3846');
INSERT INTO `tp_region` VALUES ('3855', '解愁乡', '4', '3846');
INSERT INTO `tp_region` VALUES ('3856', '温家庄乡', '4', '3846');
INSERT INTO `tp_region` VALUES ('3857', '景尚乡', '4', '3846');
INSERT INTO `tp_region` VALUES ('3858', '上湖乡', '4', '3846');
INSERT INTO `tp_region` VALUES ('3859', '羊头崖乡', '4', '3846');
INSERT INTO `tp_region` VALUES ('3860', '马首乡', '4', '3846');
INSERT INTO `tp_region` VALUES ('3861', '太谷县', '3', '3776');
INSERT INTO `tp_region` VALUES ('3862', '明星镇', '4', '3861');
INSERT INTO `tp_region` VALUES ('3863', '胡村镇', '4', '3861');
INSERT INTO `tp_region` VALUES ('3864', '范村镇', '4', '3861');
INSERT INTO `tp_region` VALUES ('3865', '侯城乡', '4', '3861');
INSERT INTO `tp_region` VALUES ('3866', '北汪乡', '4', '3861');
INSERT INTO `tp_region` VALUES ('3867', '水秀乡', '4', '3861');
INSERT INTO `tp_region` VALUES ('3868', '阳邑乡', '4', '3861');
INSERT INTO `tp_region` VALUES ('3869', '小白乡', '4', '3861');
INSERT INTO `tp_region` VALUES ('3870', '任村乡', '4', '3861');
INSERT INTO `tp_region` VALUES ('3871', '祁县', '3', '3776');
INSERT INTO `tp_region` VALUES ('3872', '昭馀镇', '4', '3871');
INSERT INTO `tp_region` VALUES ('3873', '东观镇', '4', '3871');
INSERT INTO `tp_region` VALUES ('3874', '古县镇', '4', '3871');
INSERT INTO `tp_region` VALUES ('3875', '贾令镇', '4', '3871');
INSERT INTO `tp_region` VALUES ('3876', '城赵镇', '4', '3871');
INSERT INTO `tp_region` VALUES ('3877', '来远镇', '4', '3871');
INSERT INTO `tp_region` VALUES ('3878', '西六支乡', '4', '3871');
INSERT INTO `tp_region` VALUES ('3879', '峪口乡', '4', '3871');
INSERT INTO `tp_region` VALUES ('3880', '平遥县', '3', '3776');
INSERT INTO `tp_region` VALUES ('3881', '古陶镇', '4', '3880');
INSERT INTO `tp_region` VALUES ('3882', '段村镇', '4', '3880');
INSERT INTO `tp_region` VALUES ('3883', '东泉镇', '4', '3880');
INSERT INTO `tp_region` VALUES ('3884', '洪善镇', '4', '3880');
INSERT INTO `tp_region` VALUES ('3885', '宁固镇', '4', '3880');
INSERT INTO `tp_region` VALUES ('3886', '南政乡', '4', '3880');
INSERT INTO `tp_region` VALUES ('3887', '中都乡', '4', '3880');
INSERT INTO `tp_region` VALUES ('3888', '岳壁乡', '4', '3880');
INSERT INTO `tp_region` VALUES ('3889', '卜宜乡', '4', '3880');
INSERT INTO `tp_region` VALUES ('3890', '孟山乡', '4', '3880');
INSERT INTO `tp_region` VALUES ('3891', '朱坑乡', '4', '3880');
INSERT INTO `tp_region` VALUES ('3892', '襄垣乡', '4', '3880');
INSERT INTO `tp_region` VALUES ('3893', '杜家庄乡', '4', '3880');
INSERT INTO `tp_region` VALUES ('3894', '香乐乡', '4', '3880');
INSERT INTO `tp_region` VALUES ('3895', '灵石县', '3', '3776');
INSERT INTO `tp_region` VALUES ('3896', '翠峰镇', '4', '3895');
INSERT INTO `tp_region` VALUES ('3897', '静升镇', '4', '3895');
INSERT INTO `tp_region` VALUES ('3898', '两渡镇', '4', '3895');
INSERT INTO `tp_region` VALUES ('3899', '夏门镇', '4', '3895');
INSERT INTO `tp_region` VALUES ('3900', '南关镇', '4', '3895');
INSERT INTO `tp_region` VALUES ('3901', '段纯镇', '4', '3895');
INSERT INTO `tp_region` VALUES ('3902', '马和乡', '4', '3895');
INSERT INTO `tp_region` VALUES ('3903', '英武乡', '4', '3895');
INSERT INTO `tp_region` VALUES ('3904', '王禹乡', '4', '3895');
INSERT INTO `tp_region` VALUES ('3905', '坛镇乡', '4', '3895');
INSERT INTO `tp_region` VALUES ('3906', '梁家焉乡', '4', '3895');
INSERT INTO `tp_region` VALUES ('3907', '交口乡', '4', '3895');
INSERT INTO `tp_region` VALUES ('3908', '介休市', '3', '3776');
INSERT INTO `tp_region` VALUES ('3909', '北关街道', '4', '3908');
INSERT INTO `tp_region` VALUES ('3910', '西关街道', '4', '3908');
INSERT INTO `tp_region` VALUES ('3911', '东南街道', '4', '3908');
INSERT INTO `tp_region` VALUES ('3912', '西南街道', '4', '3908');
INSERT INTO `tp_region` VALUES ('3913', '北坛街道', '4', '3908');
INSERT INTO `tp_region` VALUES ('3914', '义安镇', '4', '3908');
INSERT INTO `tp_region` VALUES ('3915', '张兰镇', '4', '3908');
INSERT INTO `tp_region` VALUES ('3916', '连福镇', '4', '3908');
INSERT INTO `tp_region` VALUES ('3917', '洪山镇', '4', '3908');
INSERT INTO `tp_region` VALUES ('3918', '龙凤镇', '4', '3908');
INSERT INTO `tp_region` VALUES ('3919', '绵山镇', '4', '3908');
INSERT INTO `tp_region` VALUES ('3920', '义棠镇', '4', '3908');
INSERT INTO `tp_region` VALUES ('3921', '城关乡', '4', '3908');
INSERT INTO `tp_region` VALUES ('3922', '宋古乡', '4', '3908');
INSERT INTO `tp_region` VALUES ('3923', '三佳乡', '4', '3908');
INSERT INTO `tp_region` VALUES ('3924', '山西省种羊场', '4', '3908');
INSERT INTO `tp_region` VALUES ('3925', '运城市', '2', '3102');
INSERT INTO `tp_region` VALUES ('3926', '市辖区', '3', '3925');
INSERT INTO `tp_region` VALUES ('3927', '盐湖区', '3', '3925');
INSERT INTO `tp_region` VALUES ('3928', '中城街道', '4', '3927');
INSERT INTO `tp_region` VALUES ('3929', '东城街道', '4', '3927');
INSERT INTO `tp_region` VALUES ('3930', '西城街道', '4', '3927');
INSERT INTO `tp_region` VALUES ('3931', '南城街道', '4', '3927');
INSERT INTO `tp_region` VALUES ('3932', '北城街道', '4', '3927');
INSERT INTO `tp_region` VALUES ('3933', '安邑街道', '4', '3927');
INSERT INTO `tp_region` VALUES ('3934', '大渠街道', '4', '3927');
INSERT INTO `tp_region` VALUES ('3935', '姚孟街道', '4', '3927');
INSERT INTO `tp_region` VALUES ('3936', '解州镇政府', '4', '3927');
INSERT INTO `tp_region` VALUES ('3937', '龙居镇政府', '4', '3927');
INSERT INTO `tp_region` VALUES ('3938', '北相镇政府', '4', '3927');
INSERT INTO `tp_region` VALUES ('3939', '泓芝驿镇政府', '4', '3927');
INSERT INTO `tp_region` VALUES ('3940', '三路里镇政府', '4', '3927');
INSERT INTO `tp_region` VALUES ('3941', '陶村镇政府', '4', '3927');
INSERT INTO `tp_region` VALUES ('3942', '东郭镇政府', '4', '3927');
INSERT INTO `tp_region` VALUES ('3943', '席张乡政府', '4', '3927');
INSERT INTO `tp_region` VALUES ('3944', '金井乡政府', '4', '3927');
INSERT INTO `tp_region` VALUES ('3945', '王范乡政府', '4', '3927');
INSERT INTO `tp_region` VALUES ('3946', '冯村乡政府', '4', '3927');
INSERT INTO `tp_region` VALUES ('3947', '上郭乡政府', '4', '3927');
INSERT INTO `tp_region` VALUES ('3948', '上王乡政府', '4', '3927');
INSERT INTO `tp_region` VALUES ('3949', '禹都经济技术开发区', '4', '3927');
INSERT INTO `tp_region` VALUES ('3950', '临猗县', '3', '3925');
INSERT INTO `tp_region` VALUES ('3951', '猗氏镇', '4', '3950');
INSERT INTO `tp_region` VALUES ('3952', '嵋阳镇', '4', '3950');
INSERT INTO `tp_region` VALUES ('3953', '临晋镇', '4', '3950');
INSERT INTO `tp_region` VALUES ('3954', '七级镇', '4', '3950');
INSERT INTO `tp_region` VALUES ('3955', '东张镇', '4', '3950');
INSERT INTO `tp_region` VALUES ('3956', '孙吉镇', '4', '3950');
INSERT INTO `tp_region` VALUES ('3957', '三管镇', '4', '3950');
INSERT INTO `tp_region` VALUES ('3958', '耽子镇', '4', '3950');
INSERT INTO `tp_region` VALUES ('3959', '楚候乡', '4', '3950');
INSERT INTO `tp_region` VALUES ('3960', '庙上乡', '4', '3950');
INSERT INTO `tp_region` VALUES ('3961', '角杯乡', '4', '3950');
INSERT INTO `tp_region` VALUES ('3962', '北辛乡', '4', '3950');
INSERT INTO `tp_region` VALUES ('3963', '北景乡', '4', '3950');
INSERT INTO `tp_region` VALUES ('3964', '牛杜工贸区', '4', '3950');
INSERT INTO `tp_region` VALUES ('3965', '卓里工贸区', '4', '3950');
INSERT INTO `tp_region` VALUES ('3966', '闫家庄工贸区', '4', '3950');
INSERT INTO `tp_region` VALUES ('3967', '万荣县', '3', '3925');
INSERT INTO `tp_region` VALUES ('3968', '解店镇', '4', '3967');
INSERT INTO `tp_region` VALUES ('3969', '通化镇', '4', '3967');
INSERT INTO `tp_region` VALUES ('3970', '汉薛镇', '4', '3967');
INSERT INTO `tp_region` VALUES ('3971', '荣河镇', '4', '3967');
INSERT INTO `tp_region` VALUES ('3972', '万泉乡', '4', '3967');
INSERT INTO `tp_region` VALUES ('3973', '里望乡', '4', '3967');
INSERT INTO `tp_region` VALUES ('3974', '西村乡', '4', '3967');
INSERT INTO `tp_region` VALUES ('3975', '南张乡', '4', '3967');
INSERT INTO `tp_region` VALUES ('3976', '高村乡', '4', '3967');
INSERT INTO `tp_region` VALUES ('3977', '皇甫乡', '4', '3967');
INSERT INTO `tp_region` VALUES ('3978', '贾村乡', '4', '3967');
INSERT INTO `tp_region` VALUES ('3979', '王显乡', '4', '3967');
INSERT INTO `tp_region` VALUES ('3980', '光华乡', '4', '3967');
INSERT INTO `tp_region` VALUES ('3981', '裴庄乡', '4', '3967');
INSERT INTO `tp_region` VALUES ('3982', '闻喜县', '3', '3925');
INSERT INTO `tp_region` VALUES ('3983', '桐城镇', '4', '3982');
INSERT INTO `tp_region` VALUES ('3984', '郭家庄镇', '4', '3982');
INSERT INTO `tp_region` VALUES ('3985', '凹底镇', '4', '3982');
INSERT INTO `tp_region` VALUES ('3986', '薛店镇', '4', '3982');
INSERT INTO `tp_region` VALUES ('3987', '东镇镇', '4', '3982');
INSERT INTO `tp_region` VALUES ('3988', '礼元镇', '4', '3982');
INSERT INTO `tp_region` VALUES ('3989', '河底镇', '4', '3982');
INSERT INTO `tp_region` VALUES ('3990', '神柏乡', '4', '3982');
INSERT INTO `tp_region` VALUES ('3991', '阳隅乡', '4', '3982');
INSERT INTO `tp_region` VALUES ('3992', '侯村乡', '4', '3982');
INSERT INTO `tp_region` VALUES ('3993', '裴社乡', '4', '3982');
INSERT INTO `tp_region` VALUES ('3994', '后宫乡', '4', '3982');
INSERT INTO `tp_region` VALUES ('3995', '石门乡', '4', '3982');
INSERT INTO `tp_region` VALUES ('3996', '稷山县', '3', '3925');
INSERT INTO `tp_region` VALUES ('3997', '稷峰镇', '4', '3996');
INSERT INTO `tp_region` VALUES ('3998', '西社镇', '4', '3996');
INSERT INTO `tp_region` VALUES ('3999', '化峪镇', '4', '3996');
INSERT INTO `tp_region` VALUES ('4000', '翟店镇', '4', '3996');
INSERT INTO `tp_region` VALUES ('4001', '清河镇', '4', '3996');
INSERT INTO `tp_region` VALUES ('4002', '蔡村乡', '4', '3996');
INSERT INTO `tp_region` VALUES ('4003', '太阳乡', '4', '3996');
INSERT INTO `tp_region` VALUES ('4004', '新绛县', '3', '3925');
INSERT INTO `tp_region` VALUES ('4005', '龙兴镇', '4', '4004');
INSERT INTO `tp_region` VALUES ('4006', '三泉镇', '4', '4004');
INSERT INTO `tp_region` VALUES ('4007', '泽掌镇', '4', '4004');
INSERT INTO `tp_region` VALUES ('4008', '北张镇', '4', '4004');
INSERT INTO `tp_region` VALUES ('4009', '横桥镇', '4', '4004');
INSERT INTO `tp_region` VALUES ('4010', '万安镇', '4', '4004');
INSERT INTO `tp_region` VALUES ('4011', '阳王镇', '4', '4004');
INSERT INTO `tp_region` VALUES ('4012', '古交乡', '4', '4004');
INSERT INTO `tp_region` VALUES ('4013', '绛县', '3', '3925');
INSERT INTO `tp_region` VALUES ('4014', '古绛镇', '4', '4013');
INSERT INTO `tp_region` VALUES ('4015', '横水镇', '4', '4013');
INSERT INTO `tp_region` VALUES ('4016', '陈村镇', '4', '4013');
INSERT INTO `tp_region` VALUES ('4017', '卫庄镇', '4', '4013');
INSERT INTO `tp_region` VALUES ('4018', '么里镇', '4', '4013');
INSERT INTO `tp_region` VALUES ('4019', '南樊镇', '4', '4013');
INSERT INTO `tp_region` VALUES ('4020', '安峪镇', '4', '4013');
INSERT INTO `tp_region` VALUES ('4021', '大交镇', '4', '4013');
INSERT INTO `tp_region` VALUES ('4022', '郝庄乡', '4', '4013');
INSERT INTO `tp_region` VALUES ('4023', '冷口乡', '4', '4013');
INSERT INTO `tp_region` VALUES ('4024', '垣曲县', '3', '3925');
INSERT INTO `tp_region` VALUES ('4025', '新城镇', '4', '4024');
INSERT INTO `tp_region` VALUES ('4026', '历山镇', '4', '4024');
INSERT INTO `tp_region` VALUES ('4027', '古城镇', '4', '4024');
INSERT INTO `tp_region` VALUES ('4028', '王茅镇', '4', '4024');
INSERT INTO `tp_region` VALUES ('4029', '毛家镇', '4', '4024');
INSERT INTO `tp_region` VALUES ('4030', '蒲掌乡', '4', '4024');
INSERT INTO `tp_region` VALUES ('4031', '英言乡', '4', '4024');
INSERT INTO `tp_region` VALUES ('4032', '解峪乡', '4', '4024');
INSERT INTO `tp_region` VALUES ('4033', '华峰乡', '4', '4024');
INSERT INTO `tp_region` VALUES ('4034', '长直乡', '4', '4024');
INSERT INTO `tp_region` VALUES ('4035', '皋落乡', '4', '4024');
INSERT INTO `tp_region` VALUES ('4036', '夏县', '3', '3925');
INSERT INTO `tp_region` VALUES ('4037', '瑶峰镇', '4', '4036');
INSERT INTO `tp_region` VALUES ('4038', '庙前镇', '4', '4036');
INSERT INTO `tp_region` VALUES ('4039', '裴介镇', '4', '4036');
INSERT INTO `tp_region` VALUES ('4040', '水头镇', '4', '4036');
INSERT INTO `tp_region` VALUES ('4041', '埝掌镇', '4', '4036');
INSERT INTO `tp_region` VALUES ('4042', '泗交镇', '4', '4036');
INSERT INTO `tp_region` VALUES ('4043', '尉郭乡', '4', '4036');
INSERT INTO `tp_region` VALUES ('4044', '禹王乡', '4', '4036');
INSERT INTO `tp_region` VALUES ('4045', '胡张乡', '4', '4036');
INSERT INTO `tp_region` VALUES ('4046', '南大里乡', '4', '4036');
INSERT INTO `tp_region` VALUES ('4047', '祁家河乡', '4', '4036');
INSERT INTO `tp_region` VALUES ('4048', '平陆县', '3', '3925');
INSERT INTO `tp_region` VALUES ('4049', '圣人涧镇', '4', '4048');
INSERT INTO `tp_region` VALUES ('4050', '常乐镇', '4', '4048');
INSERT INTO `tp_region` VALUES ('4051', '张店镇', '4', '4048');
INSERT INTO `tp_region` VALUES ('4052', '张村镇', '4', '4048');
INSERT INTO `tp_region` VALUES ('4053', '曹川镇', '4', '4048');
INSERT INTO `tp_region` VALUES ('4054', '三门镇', '4', '4048');
INSERT INTO `tp_region` VALUES ('4055', '洪池乡', '4', '4048');
INSERT INTO `tp_region` VALUES ('4056', '杜马乡', '4', '4048');
INSERT INTO `tp_region` VALUES ('4057', '部官乡', '4', '4048');
INSERT INTO `tp_region` VALUES ('4058', '坡底乡', '4', '4048');
INSERT INTO `tp_region` VALUES ('4059', '芮城县', '3', '3925');
INSERT INTO `tp_region` VALUES ('4060', '古巍镇', '4', '4059');
INSERT INTO `tp_region` VALUES ('4061', '风陵渡镇', '4', '4059');
INSERT INTO `tp_region` VALUES ('4062', '陌南镇', '4', '4059');
INSERT INTO `tp_region` VALUES ('4063', '西陌镇', '4', '4059');
INSERT INTO `tp_region` VALUES ('4064', '永乐镇', '4', '4059');
INSERT INTO `tp_region` VALUES ('4065', '大王镇', '4', '4059');
INSERT INTO `tp_region` VALUES ('4066', '阳城镇', '4', '4059');
INSERT INTO `tp_region` VALUES ('4067', '东垆乡', '4', '4059');
INSERT INTO `tp_region` VALUES ('4068', '南卫乡', '4', '4059');
INSERT INTO `tp_region` VALUES ('4069', '学张乡', '4', '4059');
INSERT INTO `tp_region` VALUES ('4070', '永济市', '3', '3925');
INSERT INTO `tp_region` VALUES ('4071', '城西街道', '4', '4070');
INSERT INTO `tp_region` VALUES ('4072', '城北街道', '4', '4070');
INSERT INTO `tp_region` VALUES ('4073', '城东街道', '4', '4070');
INSERT INTO `tp_region` VALUES ('4074', '于乡镇', '4', '4070');
INSERT INTO `tp_region` VALUES ('4075', '卿头镇', '4', '4070');
INSERT INTO `tp_region` VALUES ('4076', '开张镇', '4', '4070');
INSERT INTO `tp_region` VALUES ('4077', '栲栳镇', '4', '4070');
INSERT INTO `tp_region` VALUES ('4078', '蒲州镇', '4', '4070');
INSERT INTO `tp_region` VALUES ('4079', '韩阳镇', '4', '4070');
INSERT INTO `tp_region` VALUES ('4080', '张营镇', '4', '4070');
INSERT INTO `tp_region` VALUES ('4081', '农场虚拟区', '4', '4070');
INSERT INTO `tp_region` VALUES ('4082', '河津市', '3', '3925');
INSERT INTO `tp_region` VALUES ('4083', '城区街道', '4', '4082');
INSERT INTO `tp_region` VALUES ('4084', '清涧街道', '4', '4082');
INSERT INTO `tp_region` VALUES ('4085', '樊村镇', '4', '4082');
INSERT INTO `tp_region` VALUES ('4086', '僧楼镇', '4', '4082');
INSERT INTO `tp_region` VALUES ('4087', '小梁乡', '4', '4082');
INSERT INTO `tp_region` VALUES ('4088', '柴家乡', '4', '4082');
INSERT INTO `tp_region` VALUES ('4089', '赵家庄乡', '4', '4082');
INSERT INTO `tp_region` VALUES ('4090', '下化乡', '4', '4082');
INSERT INTO `tp_region` VALUES ('4091', '阳村乡', '4', '4082');
INSERT INTO `tp_region` VALUES ('4092', '山西铝厂虚拟镇', '4', '4082');
INSERT INTO `tp_region` VALUES ('4093', '忻州市', '2', '3102');
INSERT INTO `tp_region` VALUES ('4094', '市辖区', '3', '4093');
INSERT INTO `tp_region` VALUES ('4095', '忻府区', '3', '4093');
INSERT INTO `tp_region` VALUES ('4096', '南城街道', '4', '4095');
INSERT INTO `tp_region` VALUES ('4097', '长征街街道', '4', '4095');
INSERT INTO `tp_region` VALUES ('4098', '新建路街道', '4', '4095');
INSERT INTO `tp_region` VALUES ('4099', '播明镇', '4', '4095');
INSERT INTO `tp_region` VALUES ('4100', '奇村镇', '4', '4095');
INSERT INTO `tp_region` VALUES ('4101', '三交镇', '4', '4095');
INSERT INTO `tp_region` VALUES ('4102', '庄磨镇', '4', '4095');
INSERT INTO `tp_region` VALUES ('4103', '豆罗镇', '4', '4095');
INSERT INTO `tp_region` VALUES ('4104', '董村镇', '4', '4095');
INSERT INTO `tp_region` VALUES ('4105', '曹张乡', '4', '4095');
INSERT INTO `tp_region` VALUES ('4106', '高城乡', '4', '4095');
INSERT INTO `tp_region` VALUES ('4107', '秦城乡', '4', '4095');
INSERT INTO `tp_region` VALUES ('4108', '解原乡', '4', '4095');
INSERT INTO `tp_region` VALUES ('4109', '合索乡', '4', '4095');
INSERT INTO `tp_region` VALUES ('4110', '阳坡乡', '4', '4095');
INSERT INTO `tp_region` VALUES ('4111', '兰村乡', '4', '4095');
INSERT INTO `tp_region` VALUES ('4112', '紫岩乡', '4', '4095');
INSERT INTO `tp_region` VALUES ('4113', '西张乡', '4', '4095');
INSERT INTO `tp_region` VALUES ('4114', '东楼乡', '4', '4095');
INSERT INTO `tp_region` VALUES ('4115', '北义井乡', '4', '4095');
INSERT INTO `tp_region` VALUES ('4116', '定襄县', '3', '4093');
INSERT INTO `tp_region` VALUES ('4117', '晋昌镇', '4', '4116');
INSERT INTO `tp_region` VALUES ('4118', '河边镇', '4', '4116');
INSERT INTO `tp_region` VALUES ('4119', '宏道镇', '4', '4116');
INSERT INTO `tp_region` VALUES ('4120', '杨芳乡', '4', '4116');
INSERT INTO `tp_region` VALUES ('4121', '南王乡', '4', '4116');
INSERT INTO `tp_region` VALUES ('4122', '蒋村乡', '4', '4116');
INSERT INTO `tp_region` VALUES ('4123', '神山乡', '4', '4116');
INSERT INTO `tp_region` VALUES ('4124', '季庄乡', '4', '4116');
INSERT INTO `tp_region` VALUES ('4125', '受录乡', '4', '4116');
INSERT INTO `tp_region` VALUES ('4126', '五台县', '3', '4093');
INSERT INTO `tp_region` VALUES ('4127', '台城镇', '4', '4126');
INSERT INTO `tp_region` VALUES ('4128', '台怀镇', '4', '4126');
INSERT INTO `tp_region` VALUES ('4129', '耿镇镇', '4', '4126');
INSERT INTO `tp_region` VALUES ('4130', '豆村镇', '4', '4126');
INSERT INTO `tp_region` VALUES ('4131', '白家庄镇', '4', '4126');
INSERT INTO `tp_region` VALUES ('4132', '东冶镇', '4', '4126');
INSERT INTO `tp_region` VALUES ('4133', '沟南乡', '4', '4126');
INSERT INTO `tp_region` VALUES ('4134', '东雷乡', '4', '4126');
INSERT INTO `tp_region` VALUES ('4135', '高洪口乡', '4', '4126');
INSERT INTO `tp_region` VALUES ('4136', '门限石乡', '4', '4126');
INSERT INTO `tp_region` VALUES ('4137', '陈家庄乡', '4', '4126');
INSERT INTO `tp_region` VALUES ('4138', '建安乡', '4', '4126');
INSERT INTO `tp_region` VALUES ('4139', '神西乡', '4', '4126');
INSERT INTO `tp_region` VALUES ('4140', '蒋坊乡', '4', '4126');
INSERT INTO `tp_region` VALUES ('4141', '灵境乡', '4', '4126');
INSERT INTO `tp_region` VALUES ('4142', '阳白乡', '4', '4126');
INSERT INTO `tp_region` VALUES ('4143', '茹村乡', '4', '4126');
INSERT INTO `tp_region` VALUES ('4144', '石咀乡', '4', '4126');
INSERT INTO `tp_region` VALUES ('4145', '金岗库乡', '4', '4126');
INSERT INTO `tp_region` VALUES ('4146', '代县', '3', '4093');
INSERT INTO `tp_region` VALUES ('4147', '上馆镇', '4', '4146');
INSERT INTO `tp_region` VALUES ('4148', '阳明堡镇', '4', '4146');
INSERT INTO `tp_region` VALUES ('4149', '峨口镇', '4', '4146');
INSERT INTO `tp_region` VALUES ('4150', '聂营镇', '4', '4146');
INSERT INTO `tp_region` VALUES ('4151', '枣林镇', '4', '4146');
INSERT INTO `tp_region` VALUES ('4152', '滩上镇', '4', '4146');
INSERT INTO `tp_region` VALUES ('4153', '新高乡', '4', '4146');
INSERT INTO `tp_region` VALUES ('4154', '峪口乡', '4', '4146');
INSERT INTO `tp_region` VALUES ('4155', '磨坊乡', '4', '4146');
INSERT INTO `tp_region` VALUES ('4156', '胡峪乡', '4', '4146');
INSERT INTO `tp_region` VALUES ('4157', '雁门关乡', '4', '4146');
INSERT INTO `tp_region` VALUES ('4158', '繁峙县', '3', '4093');
INSERT INTO `tp_region` VALUES ('4159', '繁城镇', '4', '4158');
INSERT INTO `tp_region` VALUES ('4160', '砂河镇', '4', '4158');
INSERT INTO `tp_region` VALUES ('4161', '大营镇', '4', '4158');
INSERT INTO `tp_region` VALUES ('4162', '下茹越乡', '4', '4158');
INSERT INTO `tp_region` VALUES ('4163', '杏园乡', '4', '4158');
INSERT INTO `tp_region` VALUES ('4164', '光裕堡乡', '4', '4158');
INSERT INTO `tp_region` VALUES ('4165', '集义庄乡', '4', '4158');
INSERT INTO `tp_region` VALUES ('4166', '东山乡', '4', '4158');
INSERT INTO `tp_region` VALUES ('4167', '金山铺乡', '4', '4158');
INSERT INTO `tp_region` VALUES ('4168', '柏家庄乡', '4', '4158');
INSERT INTO `tp_region` VALUES ('4169', '横涧乡', '4', '4158');
INSERT INTO `tp_region` VALUES ('4170', '神堂堡乡', '4', '4158');
INSERT INTO `tp_region` VALUES ('4171', '岩头乡', '4', '4158');
INSERT INTO `tp_region` VALUES ('4172', '宁武县', '3', '4093');
INSERT INTO `tp_region` VALUES ('4173', '街道', '4', '4172');
INSERT INTO `tp_region` VALUES ('4174', '凤凰镇', '4', '4172');
INSERT INTO `tp_region` VALUES ('4175', '阳方口镇', '4', '4172');
INSERT INTO `tp_region` VALUES ('4176', '东寨镇', '4', '4172');
INSERT INTO `tp_region` VALUES ('4177', '石家庄镇', '4', '4172');
INSERT INTO `tp_region` VALUES ('4178', '薛家洼乡', '4', '4172');
INSERT INTO `tp_region` VALUES ('4179', '余庄乡', '4', '4172');
INSERT INTO `tp_region` VALUES ('4180', '涔山乡', '4', '4172');
INSERT INTO `tp_region` VALUES ('4181', '化北屯乡', '4', '4172');
INSERT INTO `tp_region` VALUES ('4182', '西马坊乡', '4', '4172');
INSERT INTO `tp_region` VALUES ('4183', '新堡乡', '4', '4172');
INSERT INTO `tp_region` VALUES ('4184', '迭台寺乡', '4', '4172');
INSERT INTO `tp_region` VALUES ('4185', '圪廖乡', '4', '4172');
INSERT INTO `tp_region` VALUES ('4186', '怀道乡', '4', '4172');
INSERT INTO `tp_region` VALUES ('4187', '东马坊乡', '4', '4172');
INSERT INTO `tp_region` VALUES ('4188', '阳方口煤矿生活区', '4', '4172');
INSERT INTO `tp_region` VALUES ('4189', '静乐县', '3', '4093');
INSERT INTO `tp_region` VALUES ('4190', '鹅城镇', '4', '4189');
INSERT INTO `tp_region` VALUES ('4191', '杜家村镇', '4', '4189');
INSERT INTO `tp_region` VALUES ('4192', '康家会镇', '4', '4189');
INSERT INTO `tp_region` VALUES ('4193', '丰润镇', '4', '4189');
INSERT INTO `tp_region` VALUES ('4194', '堂尔上乡', '4', '4189');
INSERT INTO `tp_region` VALUES ('4195', '中庄乡', '4', '4189');
INSERT INTO `tp_region` VALUES ('4196', '双路乡', '4', '4189');
INSERT INTO `tp_region` VALUES ('4197', '段家寨乡', '4', '4189');
INSERT INTO `tp_region` VALUES ('4198', '辛村乡', '4', '4189');
INSERT INTO `tp_region` VALUES ('4199', '王村乡', '4', '4189');
INSERT INTO `tp_region` VALUES ('4200', '神峪沟乡', '4', '4189');
INSERT INTO `tp_region` VALUES ('4201', '娘子神乡', '4', '4189');
INSERT INTO `tp_region` VALUES ('4202', '娑婆乡', '4', '4189');
INSERT INTO `tp_region` VALUES ('4203', '赤泥洼乡', '4', '4189');
INSERT INTO `tp_region` VALUES ('4204', '神池县', '3', '4093');
INSERT INTO `tp_region` VALUES ('4205', '龙泉镇', '4', '4204');
INSERT INTO `tp_region` VALUES ('4206', '义井镇', '4', '4204');
INSERT INTO `tp_region` VALUES ('4207', '八角镇', '4', '4204');
INSERT INTO `tp_region` VALUES ('4208', '东湖乡', '4', '4204');
INSERT INTO `tp_region` VALUES ('4209', '太平庄乡', '4', '4204');
INSERT INTO `tp_region` VALUES ('4210', '虎北乡', '4', '4204');
INSERT INTO `tp_region` VALUES ('4211', '贺职乡', '4', '4204');
INSERT INTO `tp_region` VALUES ('4212', '长畛乡', '4', '4204');
INSERT INTO `tp_region` VALUES ('4213', '烈堡乡', '4', '4204');
INSERT INTO `tp_region` VALUES ('4214', '大严备乡', '4', '4204');
INSERT INTO `tp_region` VALUES ('4215', '五寨县', '3', '4093');
INSERT INTO `tp_region` VALUES ('4216', '砚城镇', '4', '4215');
INSERT INTO `tp_region` VALUES ('4217', '小河头镇', '4', '4215');
INSERT INTO `tp_region` VALUES ('4218', '三岔镇', '4', '4215');
INSERT INTO `tp_region` VALUES ('4219', '前所乡', '4', '4215');
INSERT INTO `tp_region` VALUES ('4220', '李家坪乡', '4', '4215');
INSERT INTO `tp_region` VALUES ('4221', '孙家坪乡', '4', '4215');
INSERT INTO `tp_region` VALUES ('4222', '梁家坪乡', '4', '4215');
INSERT INTO `tp_region` VALUES ('4223', '胡会乡', '4', '4215');
INSERT INTO `tp_region` VALUES ('4224', '新寨乡', '4', '4215');
INSERT INTO `tp_region` VALUES ('4225', '韩家楼乡', '4', '4215');
INSERT INTO `tp_region` VALUES ('4226', '东秀庄乡', '4', '4215');
INSERT INTO `tp_region` VALUES ('4227', '杏岭子乡', '4', '4215');
INSERT INTO `tp_region` VALUES ('4228', '岢岚县', '3', '4093');
INSERT INTO `tp_region` VALUES ('4229', '岚漪镇', '4', '4228');
INSERT INTO `tp_region` VALUES ('4230', '三井镇', '4', '4228');
INSERT INTO `tp_region` VALUES ('4231', '神堂坪乡', '4', '4228');
INSERT INTO `tp_region` VALUES ('4232', '高家会乡', '4', '4228');
INSERT INTO `tp_region` VALUES ('4233', '李家沟乡', '4', '4228');
INSERT INTO `tp_region` VALUES ('4234', '水峪贯乡', '4', '4228');
INSERT INTO `tp_region` VALUES ('4235', '西豹峪乡', '4', '4228');
INSERT INTO `tp_region` VALUES ('4236', '温泉乡', '4', '4228');
INSERT INTO `tp_region` VALUES ('4237', '阳坪乡', '4', '4228');
INSERT INTO `tp_region` VALUES ('4238', '大涧乡', '4', '4228');
INSERT INTO `tp_region` VALUES ('4239', '宋家沟乡', '4', '4228');
INSERT INTO `tp_region` VALUES ('4240', '王家岔乡', '4', '4228');
INSERT INTO `tp_region` VALUES ('4241', '河曲县', '3', '4093');
INSERT INTO `tp_region` VALUES ('4242', '文笔镇', '4', '4241');
INSERT INTO `tp_region` VALUES ('4243', '楼子营镇', '4', '4241');
INSERT INTO `tp_region` VALUES ('4244', '刘家塔镇', '4', '4241');
INSERT INTO `tp_region` VALUES ('4245', '巡镇镇', '4', '4241');
INSERT INTO `tp_region` VALUES ('4246', '鹿固乡', '4', '4241');
INSERT INTO `tp_region` VALUES ('4247', '前川乡', '4', '4241');
INSERT INTO `tp_region` VALUES ('4248', '单寨乡', '4', '4241');
INSERT INTO `tp_region` VALUES ('4249', '土沟乡', '4', '4241');
INSERT INTO `tp_region` VALUES ('4250', '旧县乡', '4', '4241');
INSERT INTO `tp_region` VALUES ('4251', '沙坪乡', '4', '4241');
INSERT INTO `tp_region` VALUES ('4252', '社梁乡', '4', '4241');
INSERT INTO `tp_region` VALUES ('4253', '沙泉乡', '4', '4241');
INSERT INTO `tp_region` VALUES ('4254', '赵家沟乡', '4', '4241');
INSERT INTO `tp_region` VALUES ('4255', '保德县', '3', '4093');
INSERT INTO `tp_region` VALUES ('4256', '东关镇', '4', '4255');
INSERT INTO `tp_region` VALUES ('4257', '义门镇', '4', '4255');
INSERT INTO `tp_region` VALUES ('4258', '桥头镇', '4', '4255');
INSERT INTO `tp_region` VALUES ('4259', '杨家湾镇', '4', '4255');
INSERT INTO `tp_region` VALUES ('4260', '腰庄乡', '4', '4255');
INSERT INTO `tp_region` VALUES ('4261', '韩家川乡', '4', '4255');
INSERT INTO `tp_region` VALUES ('4262', '林遮峪乡', '4', '4255');
INSERT INTO `tp_region` VALUES ('4263', '冯家川乡', '4', '4255');
INSERT INTO `tp_region` VALUES ('4264', '土崖塔乡', '4', '4255');
INSERT INTO `tp_region` VALUES ('4265', '孙家沟乡', '4', '4255');
INSERT INTO `tp_region` VALUES ('4266', '窑洼乡', '4', '4255');
INSERT INTO `tp_region` VALUES ('4267', '尧圪台乡', '4', '4255');
INSERT INTO `tp_region` VALUES ('4268', '南河沟乡', '4', '4255');
INSERT INTO `tp_region` VALUES ('4269', '偏关县', '3', '4093');
INSERT INTO `tp_region` VALUES ('4270', '新关镇', '4', '4269');
INSERT INTO `tp_region` VALUES ('4271', '天峰坪镇', '4', '4269');
INSERT INTO `tp_region` VALUES ('4272', '老营镇', '4', '4269');
INSERT INTO `tp_region` VALUES ('4273', '万家寨镇', '4', '4269');
INSERT INTO `tp_region` VALUES ('4274', '窑头乡', '4', '4269');
INSERT INTO `tp_region` VALUES ('4275', '楼沟乡', '4', '4269');
INSERT INTO `tp_region` VALUES ('4276', '尚峪乡', '4', '4269');
INSERT INTO `tp_region` VALUES ('4277', '南堡子乡', '4', '4269');
INSERT INTO `tp_region` VALUES ('4278', '水泉乡', '4', '4269');
INSERT INTO `tp_region` VALUES ('4279', '陈家营乡', '4', '4269');
INSERT INTO `tp_region` VALUES ('4280', '原平市', '3', '4093');
INSERT INTO `tp_region` VALUES ('4281', '北城街道', '4', '4280');
INSERT INTO `tp_region` VALUES ('4282', '南城街道', '4', '4280');
INSERT INTO `tp_region` VALUES ('4283', '东社镇', '4', '4280');
INSERT INTO `tp_region` VALUES ('4284', '苏龙口镇', '4', '4280');
INSERT INTO `tp_region` VALUES ('4285', '崞阳镇', '4', '4280');
INSERT INTO `tp_region` VALUES ('4286', '大牛店镇', '4', '4280');
INSERT INTO `tp_region` VALUES ('4287', '闫庄镇', '4', '4280');
INSERT INTO `tp_region` VALUES ('4288', '长梁沟镇', '4', '4280');
INSERT INTO `tp_region` VALUES ('4289', '轩岗镇', '4', '4280');
INSERT INTO `tp_region` VALUES ('4290', '新原乡', '4', '4280');
INSERT INTO `tp_region` VALUES ('4291', '南白乡', '4', '4280');
INSERT INTO `tp_region` VALUES ('4292', '子干乡', '4', '4280');
INSERT INTO `tp_region` VALUES ('4293', '中阳乡', '4', '4280');
INSERT INTO `tp_region` VALUES ('4294', '沿沟乡', '4', '4280');
INSERT INTO `tp_region` VALUES ('4295', '大林乡', '4', '4280');
INSERT INTO `tp_region` VALUES ('4296', '西镇乡', '4', '4280');
INSERT INTO `tp_region` VALUES ('4297', '解村乡', '4', '4280');
INSERT INTO `tp_region` VALUES ('4298', '王家庄乡', '4', '4280');
INSERT INTO `tp_region` VALUES ('4299', '楼板寨乡', '4', '4280');
INSERT INTO `tp_region` VALUES ('4300', '段家堡乡', '4', '4280');
INSERT INTO `tp_region` VALUES ('4301', '山西鲁能晋北铝业工矿区', '4', '4280');
INSERT INTO `tp_region` VALUES ('4302', '原平市石豹沟煤矿工矿区', '4', '4280');
INSERT INTO `tp_region` VALUES ('4303', '同煤集团轩岗煤电有限公司工矿区', '4', '4280');
INSERT INTO `tp_region` VALUES ('4304', '临汾市', '2', '3102');
INSERT INTO `tp_region` VALUES ('4305', '市辖区', '3', '4304');
INSERT INTO `tp_region` VALUES ('4306', '尧都区', '3', '4304');
INSERT INTO `tp_region` VALUES ('4307', '解放路街道', '4', '4306');
INSERT INTO `tp_region` VALUES ('4308', '鼓楼西街街道', '4', '4306');
INSERT INTO `tp_region` VALUES ('4309', '水塔街街道', '4', '4306');
INSERT INTO `tp_region` VALUES ('4310', '南街街道', '4', '4306');
INSERT INTO `tp_region` VALUES ('4311', '乡贤街街道', '4', '4306');
INSERT INTO `tp_region` VALUES ('4312', '辛寺街街道', '4', '4306');
INSERT INTO `tp_region` VALUES ('4313', '铁路东街道', '4', '4306');
INSERT INTO `tp_region` VALUES ('4314', '车站街街道', '4', '4306');
INSERT INTO `tp_region` VALUES ('4315', '汾河街道', '4', '4306');
INSERT INTO `tp_region` VALUES ('4316', '屯里镇', '4', '4306');
INSERT INTO `tp_region` VALUES ('4317', '乔李镇', '4', '4306');
INSERT INTO `tp_region` VALUES ('4318', '大阳镇', '4', '4306');
INSERT INTO `tp_region` VALUES ('4319', '县底镇', '4', '4306');
INSERT INTO `tp_region` VALUES ('4320', '刘村镇', '4', '4306');
INSERT INTO `tp_region` VALUES ('4321', '金殿镇', '4', '4306');
INSERT INTO `tp_region` VALUES ('4322', '吴村镇', '4', '4306');
INSERT INTO `tp_region` VALUES ('4323', '土门镇', '4', '4306');
INSERT INTO `tp_region` VALUES ('4324', '魏村镇', '4', '4306');
INSERT INTO `tp_region` VALUES ('4325', '尧庙镇', '4', '4306');
INSERT INTO `tp_region` VALUES ('4326', '段店乡', '4', '4306');
INSERT INTO `tp_region` VALUES ('4327', '贾得乡', '4', '4306');
INSERT INTO `tp_region` VALUES ('4328', '贺家庄乡', '4', '4306');
INSERT INTO `tp_region` VALUES ('4329', '一平垣乡', '4', '4306');
INSERT INTO `tp_region` VALUES ('4330', '枕头乡', '4', '4306');
INSERT INTO `tp_region` VALUES ('4331', '河底乡', '4', '4306');
INSERT INTO `tp_region` VALUES ('4332', '滨河办事处(临汾经济开发区)', '4', '4306');
INSERT INTO `tp_region` VALUES ('4333', '曲沃县', '3', '4304');
INSERT INTO `tp_region` VALUES ('4334', '乐昌镇', '4', '4333');
INSERT INTO `tp_region` VALUES ('4335', '史村镇', '4', '4333');
INSERT INTO `tp_region` VALUES ('4336', '曲村镇', '4', '4333');
INSERT INTO `tp_region` VALUES ('4337', '高显镇', '4', '4333');
INSERT INTO `tp_region` VALUES ('4338', '里村镇', '4', '4333');
INSERT INTO `tp_region` VALUES ('4339', '北董乡', '4', '4333');
INSERT INTO `tp_region` VALUES ('4340', '杨谈乡', '4', '4333');
INSERT INTO `tp_region` VALUES ('4341', '翼城县', '3', '4304');
INSERT INTO `tp_region` VALUES ('4342', '唐兴镇', '4', '4341');
INSERT INTO `tp_region` VALUES ('4343', '南梁镇', '4', '4341');
INSERT INTO `tp_region` VALUES ('4344', '里寨镇', '4', '4341');
INSERT INTO `tp_region` VALUES ('4345', '隆化镇', '4', '4341');
INSERT INTO `tp_region` VALUES ('4346', '桥上镇', '4', '4341');
INSERT INTO `tp_region` VALUES ('4347', '西闫镇', '4', '4341');
INSERT INTO `tp_region` VALUES ('4348', '中卫乡', '4', '4341');
INSERT INTO `tp_region` VALUES ('4349', '南唐乡', '4', '4341');
INSERT INTO `tp_region` VALUES ('4350', '王庄乡', '4', '4341');
INSERT INTO `tp_region` VALUES ('4351', '浇底乡', '4', '4341');
INSERT INTO `tp_region` VALUES ('4352', '襄汾县', '3', '4304');
INSERT INTO `tp_region` VALUES ('4353', '新城镇', '4', '4352');
INSERT INTO `tp_region` VALUES ('4354', '赵康镇', '4', '4352');
INSERT INTO `tp_region` VALUES ('4355', '汾城镇', '4', '4352');
INSERT INTO `tp_region` VALUES ('4356', '南贾镇', '4', '4352');
INSERT INTO `tp_region` VALUES ('4357', '古城镇', '4', '4352');
INSERT INTO `tp_region` VALUES ('4358', '襄陵镇', '4', '4352');
INSERT INTO `tp_region` VALUES ('4359', '邓庄镇', '4', '4352');
INSERT INTO `tp_region` VALUES ('4360', '陶寺乡', '4', '4352');
INSERT INTO `tp_region` VALUES ('4361', '永固乡', '4', '4352');
INSERT INTO `tp_region` VALUES ('4362', '景毛乡', '4', '4352');
INSERT INTO `tp_region` VALUES ('4363', '西贾乡', '4', '4352');
INSERT INTO `tp_region` VALUES ('4364', '南辛店乡', '4', '4352');
INSERT INTO `tp_region` VALUES ('4365', '大邓乡', '4', '4352');
INSERT INTO `tp_region` VALUES ('4366', '洪洞县', '3', '4304');
INSERT INTO `tp_region` VALUES ('4367', '大槐树镇', '4', '4366');
INSERT INTO `tp_region` VALUES ('4368', '甘亭镇', '4', '4366');
INSERT INTO `tp_region` VALUES ('4369', '曲亭镇', '4', '4366');
INSERT INTO `tp_region` VALUES ('4370', '苏堡镇', '4', '4366');
INSERT INTO `tp_region` VALUES ('4371', '广胜寺镇', '4', '4366');
INSERT INTO `tp_region` VALUES ('4372', '明姜镇', '4', '4366');
INSERT INTO `tp_region` VALUES ('4373', '赵城镇', '4', '4366');
INSERT INTO `tp_region` VALUES ('4374', '万安镇', '4', '4366');
INSERT INTO `tp_region` VALUES ('4375', '刘家垣镇', '4', '4366');
INSERT INTO `tp_region` VALUES ('4376', '淹底乡', '4', '4366');
INSERT INTO `tp_region` VALUES ('4377', '兴唐寺乡', '4', '4366');
INSERT INTO `tp_region` VALUES ('4378', '堤村乡', '4', '4366');
INSERT INTO `tp_region` VALUES ('4379', '辛村乡', '4', '4366');
INSERT INTO `tp_region` VALUES ('4380', '龙马乡', '4', '4366');
INSERT INTO `tp_region` VALUES ('4381', '山头乡', '4', '4366');
INSERT INTO `tp_region` VALUES ('4382', '左木乡', '4', '4366');
INSERT INTO `tp_region` VALUES ('4383', '古县', '3', '4304');
INSERT INTO `tp_region` VALUES ('4384', '岳阳镇', '4', '4383');
INSERT INTO `tp_region` VALUES ('4385', '北平镇', '4', '4383');
INSERT INTO `tp_region` VALUES ('4386', '古阳镇', '4', '4383');
INSERT INTO `tp_region` VALUES ('4387', '旧县镇', '4', '4383');
INSERT INTO `tp_region` VALUES ('4388', '石壁乡', '4', '4383');
INSERT INTO `tp_region` VALUES ('4389', '永乐乡', '4', '4383');
INSERT INTO `tp_region` VALUES ('4390', '南垣乡', '4', '4383');
INSERT INTO `tp_region` VALUES ('4391', '安泽县', '3', '4304');
INSERT INTO `tp_region` VALUES ('4392', '府城镇', '4', '4391');
INSERT INTO `tp_region` VALUES ('4393', '和川镇', '4', '4391');
INSERT INTO `tp_region` VALUES ('4394', '唐城镇', '4', '4391');
INSERT INTO `tp_region` VALUES ('4395', '冀氏镇', '4', '4391');
INSERT INTO `tp_region` VALUES ('4396', '马必乡', '4', '4391');
INSERT INTO `tp_region` VALUES ('4397', '杜村乡', '4', '4391');
INSERT INTO `tp_region` VALUES ('4398', '良马乡', '4', '4391');
INSERT INTO `tp_region` VALUES ('4399', '浮山县', '3', '4304');
INSERT INTO `tp_region` VALUES ('4400', '天坛镇', '4', '4399');
INSERT INTO `tp_region` VALUES ('4401', '响水河镇', '4', '4399');
INSERT INTO `tp_region` VALUES ('4402', '张庄乡', '4', '4399');
INSERT INTO `tp_region` VALUES ('4403', '东张乡', '4', '4399');
INSERT INTO `tp_region` VALUES ('4404', '槐埝乡', '4', '4399');
INSERT INTO `tp_region` VALUES ('4405', '北王乡', '4', '4399');
INSERT INTO `tp_region` VALUES ('4406', '北韩乡', '4', '4399');
INSERT INTO `tp_region` VALUES ('4407', '米家垣乡', '4', '4399');
INSERT INTO `tp_region` VALUES ('4408', '寨圪塔乡', '4', '4399');
INSERT INTO `tp_region` VALUES ('4409', '吉县', '3', '4304');
INSERT INTO `tp_region` VALUES ('4410', '吉昌镇', '4', '4409');
INSERT INTO `tp_region` VALUES ('4411', '屯里镇', '4', '4409');
INSERT INTO `tp_region` VALUES ('4412', '壶口镇', '4', '4409');
INSERT INTO `tp_region` VALUES ('4413', '车城乡', '4', '4409');
INSERT INTO `tp_region` VALUES ('4414', '文城乡', '4', '4409');
INSERT INTO `tp_region` VALUES ('4415', '东城乡', '4', '4409');
INSERT INTO `tp_region` VALUES ('4416', '柏山寺乡', '4', '4409');
INSERT INTO `tp_region` VALUES ('4417', '中垛乡', '4', '4409');
INSERT INTO `tp_region` VALUES ('4418', '乡宁县', '3', '4304');
INSERT INTO `tp_region` VALUES ('4419', '昌宁镇', '4', '4418');
INSERT INTO `tp_region` VALUES ('4420', '光华镇', '4', '4418');
INSERT INTO `tp_region` VALUES ('4421', '台头镇', '4', '4418');
INSERT INTO `tp_region` VALUES ('4422', '管头镇', '4', '4418');
INSERT INTO `tp_region` VALUES ('4423', '西坡镇', '4', '4418');
INSERT INTO `tp_region` VALUES ('4424', '双鹤乡', '4', '4418');
INSERT INTO `tp_region` VALUES ('4425', '关王庙乡', '4', '4418');
INSERT INTO `tp_region` VALUES ('4426', '尉庄乡', '4', '4418');
INSERT INTO `tp_region` VALUES ('4427', '西交口乡', '4', '4418');
INSERT INTO `tp_region` VALUES ('4428', '枣岭乡', '4', '4418');
INSERT INTO `tp_region` VALUES ('4429', '大宁县', '3', '4304');
INSERT INTO `tp_region` VALUES ('4430', '昕水镇', '4', '4429');
INSERT INTO `tp_region` VALUES ('4431', '曲峨镇', '4', '4429');
INSERT INTO `tp_region` VALUES ('4432', '三多乡', '4', '4429');
INSERT INTO `tp_region` VALUES ('4433', '太德乡', '4', '4429');
INSERT INTO `tp_region` VALUES ('4434', '徐家垛乡', '4', '4429');
INSERT INTO `tp_region` VALUES ('4435', '太古乡', '4', '4429');
INSERT INTO `tp_region` VALUES ('4436', '隰县', '3', '4304');
INSERT INTO `tp_region` VALUES ('4437', '龙泉镇', '4', '4436');
INSERT INTO `tp_region` VALUES ('4438', '午城镇', '4', '4436');
INSERT INTO `tp_region` VALUES ('4439', '黄土镇', '4', '4436');
INSERT INTO `tp_region` VALUES ('4440', '阳头升乡', '4', '4436');
INSERT INTO `tp_region` VALUES ('4441', '寨子乡', '4', '4436');
INSERT INTO `tp_region` VALUES ('4442', '陡坡乡', '4', '4436');
INSERT INTO `tp_region` VALUES ('4443', '下李乡', '4', '4436');
INSERT INTO `tp_region` VALUES ('4444', '城南乡', '4', '4436');
INSERT INTO `tp_region` VALUES ('4445', '永和县', '3', '4304');
INSERT INTO `tp_region` VALUES ('4446', '芝河镇', '4', '4445');
INSERT INTO `tp_region` VALUES ('4447', '桑壁镇', '4', '4445');
INSERT INTO `tp_region` VALUES ('4448', '阁底乡', '4', '4445');
INSERT INTO `tp_region` VALUES ('4449', '南庄乡', '4', '4445');
INSERT INTO `tp_region` VALUES ('4450', '打石腰乡', '4', '4445');
INSERT INTO `tp_region` VALUES ('4451', '坡头乡', '4', '4445');
INSERT INTO `tp_region` VALUES ('4452', '交口乡', '4', '4445');
INSERT INTO `tp_region` VALUES ('4453', '蒲县', '3', '4304');
INSERT INTO `tp_region` VALUES ('4454', '蒲城镇', '4', '4453');
INSERT INTO `tp_region` VALUES ('4455', '薛关镇', '4', '4453');
INSERT INTO `tp_region` VALUES ('4456', '黑龙关镇', '4', '4453');
INSERT INTO `tp_region` VALUES ('4457', '克城镇', '4', '4453');
INSERT INTO `tp_region` VALUES ('4458', '山中乡', '4', '4453');
INSERT INTO `tp_region` VALUES ('4459', '古县乡', '4', '4453');
INSERT INTO `tp_region` VALUES ('4460', '红道乡', '4', '4453');
INSERT INTO `tp_region` VALUES ('4461', '乔家湾乡', '4', '4453');
INSERT INTO `tp_region` VALUES ('4462', '太林乡', '4', '4453');
INSERT INTO `tp_region` VALUES ('4463', '汾西县', '3', '4304');
INSERT INTO `tp_region` VALUES ('4464', '永安镇', '4', '4463');
INSERT INTO `tp_region` VALUES ('4465', '对竹镇', '4', '4463');
INSERT INTO `tp_region` VALUES ('4466', '勍香镇', '4', '4463');
INSERT INTO `tp_region` VALUES ('4467', '和平镇', '4', '4463');
INSERT INTO `tp_region` VALUES ('4468', '僧念镇', '4', '4463');
INSERT INTO `tp_region` VALUES ('4469', '佃坪乡', '4', '4463');
INSERT INTO `tp_region` VALUES ('4470', '团柏乡', '4', '4463');
INSERT INTO `tp_region` VALUES ('4471', '邢家要乡', '4', '4463');
INSERT INTO `tp_region` VALUES ('4472', '侯马市', '3', '4304');
INSERT INTO `tp_region` VALUES ('4473', '路东街道', '4', '4472');
INSERT INTO `tp_region` VALUES ('4474', '路西街道', '4', '4472');
INSERT INTO `tp_region` VALUES ('4475', '浍滨街道', '4', '4472');
INSERT INTO `tp_region` VALUES ('4476', '上马街道', '4', '4472');
INSERT INTO `tp_region` VALUES ('4477', '张村街道', '4', '4472');
INSERT INTO `tp_region` VALUES ('4478', '新田乡', '4', '4472');
INSERT INTO `tp_region` VALUES ('4479', '高村乡', '4', '4472');
INSERT INTO `tp_region` VALUES ('4480', '凤城乡', '4', '4472');
INSERT INTO `tp_region` VALUES ('4481', '霍州市', '3', '4304');
INSERT INTO `tp_region` VALUES ('4482', '鼓楼街道', '4', '4481');
INSERT INTO `tp_region` VALUES ('4483', '北环路街道', '4', '4481');
INSERT INTO `tp_region` VALUES ('4484', '南环路街道', '4', '4481');
INSERT INTO `tp_region` VALUES ('4485', '开元街道办事', '4', '4481');
INSERT INTO `tp_region` VALUES ('4486', '退沙街道', '4', '4481');
INSERT INTO `tp_region` VALUES ('4487', '白龙镇', '4', '4481');
INSERT INTO `tp_region` VALUES ('4488', '辛置镇', '4', '4481');
INSERT INTO `tp_region` VALUES ('4489', '大张镇', '4', '4481');
INSERT INTO `tp_region` VALUES ('4490', '李曹镇', '4', '4481');
INSERT INTO `tp_region` VALUES ('4491', '陶唐峪乡', '4', '4481');
INSERT INTO `tp_region` VALUES ('4492', '三教乡', '4', '4481');
INSERT INTO `tp_region` VALUES ('4493', '师庄乡', '4', '4481');
INSERT INTO `tp_region` VALUES ('4494', '吕梁市', '2', '3102');
INSERT INTO `tp_region` VALUES ('4495', '市辖区', '3', '4494');
INSERT INTO `tp_region` VALUES ('4496', '离石区', '3', '4494');
INSERT INTO `tp_region` VALUES ('4497', '滨河街道', '4', '4496');
INSERT INTO `tp_region` VALUES ('4498', '凤山街道', '4', '4496');
INSERT INTO `tp_region` VALUES ('4499', '莲花池街道', '4', '4496');
INSERT INTO `tp_region` VALUES ('4500', '城北街道', '4', '4496');
INSERT INTO `tp_region` VALUES ('4501', '田家会街道', '4', '4496');
INSERT INTO `tp_region` VALUES ('4502', '交口街道', '4', '4496');
INSERT INTO `tp_region` VALUES ('4503', '西属巴街道', '4', '4496');
INSERT INTO `tp_region` VALUES ('4504', '吴城镇', '4', '4496');
INSERT INTO `tp_region` VALUES ('4505', '信义镇', '4', '4496');
INSERT INTO `tp_region` VALUES ('4506', '红眼川乡', '4', '4496');
INSERT INTO `tp_region` VALUES ('4507', '枣林乡', '4', '4496');
INSERT INTO `tp_region` VALUES ('4508', '坪头乡', '4', '4496');
INSERT INTO `tp_region` VALUES ('4509', '文水县', '3', '4494');
INSERT INTO `tp_region` VALUES ('4510', '凤城镇', '4', '4509');
INSERT INTO `tp_region` VALUES ('4511', '开栅镇', '4', '4509');
INSERT INTO `tp_region` VALUES ('4512', '南庄镇', '4', '4509');
INSERT INTO `tp_region` VALUES ('4513', '南安镇', '4', '4509');
INSERT INTO `tp_region` VALUES ('4514', '刘胡兰镇', '4', '4509');
INSERT INTO `tp_region` VALUES ('4515', '下曲镇', '4', '4509');
INSERT INTO `tp_region` VALUES ('4516', '孝义镇', '4', '4509');
INSERT INTO `tp_region` VALUES ('4517', '南武乡', '4', '4509');
INSERT INTO `tp_region` VALUES ('4518', '西城乡', '4', '4509');
INSERT INTO `tp_region` VALUES ('4519', '北张乡', '4', '4509');
INSERT INTO `tp_region` VALUES ('4520', '马西乡', '4', '4509');
INSERT INTO `tp_region` VALUES ('4521', '西槽头乡', '4', '4509');
INSERT INTO `tp_region` VALUES ('4522', '交城县', '3', '4494');
INSERT INTO `tp_region` VALUES ('4523', '天宁镇', '4', '4522');
INSERT INTO `tp_region` VALUES ('4524', '夏家营镇', '4', '4522');
INSERT INTO `tp_region` VALUES ('4525', '西营镇', '4', '4522');
INSERT INTO `tp_region` VALUES ('4526', '水峪贯镇', '4', '4522');
INSERT INTO `tp_region` VALUES ('4527', '西社镇', '4', '4522');
INSERT INTO `tp_region` VALUES ('4528', '庞泉沟镇', '4', '4522');
INSERT INTO `tp_region` VALUES ('4529', '洪相乡', '4', '4522');
INSERT INTO `tp_region` VALUES ('4530', '岭底乡', '4', '4522');
INSERT INTO `tp_region` VALUES ('4531', '东坡底乡', '4', '4522');
INSERT INTO `tp_region` VALUES ('4532', '会立乡', '4', '4522');
INSERT INTO `tp_region` VALUES ('4533', '兴县', '3', '4494');
INSERT INTO `tp_region` VALUES ('4534', '蔚汾镇', '4', '4533');
INSERT INTO `tp_region` VALUES ('4535', '魏家滩镇', '4', '4533');
INSERT INTO `tp_region` VALUES ('4536', '瓦塘镇', '4', '4533');
INSERT INTO `tp_region` VALUES ('4537', '康宁镇', '4', '4533');
INSERT INTO `tp_region` VALUES ('4538', '高家村镇', '4', '4533');
INSERT INTO `tp_region` VALUES ('4539', '罗峪口镇', '4', '4533');
INSERT INTO `tp_region` VALUES ('4540', '蔡家会镇', '4', '4533');
INSERT INTO `tp_region` VALUES ('4541', '交楼申乡', '4', '4533');
INSERT INTO `tp_region` VALUES ('4542', '恶虎滩乡', '4', '4533');
INSERT INTO `tp_region` VALUES ('4543', '东会乡', '4', '4533');
INSERT INTO `tp_region` VALUES ('4544', '固贤乡', '4', '4533');
INSERT INTO `tp_region` VALUES ('4545', '奥家湾乡', '4', '4533');
INSERT INTO `tp_region` VALUES ('4546', '蔡家崖乡', '4', '4533');
INSERT INTO `tp_region` VALUES ('4547', '贺家会乡', '4', '4533');
INSERT INTO `tp_region` VALUES ('4548', '孟家坪乡', '4', '4533');
INSERT INTO `tp_region` VALUES ('4549', '赵家坪乡', '4', '4533');
INSERT INTO `tp_region` VALUES ('4550', '圪垯上乡', '4', '4533');
INSERT INTO `tp_region` VALUES ('4551', '临县', '3', '4494');
INSERT INTO `tp_region` VALUES ('4552', '临泉镇', '4', '4551');
INSERT INTO `tp_region` VALUES ('4553', '白文镇', '4', '4551');
INSERT INTO `tp_region` VALUES ('4554', '城庄镇', '4', '4551');
INSERT INTO `tp_region` VALUES ('4555', '兔坂镇', '4', '4551');
INSERT INTO `tp_region` VALUES ('4556', '克虎镇', '4', '4551');
INSERT INTO `tp_region` VALUES ('4557', '三交镇', '4', '4551');
INSERT INTO `tp_region` VALUES ('4558', '湍水头镇', '4', '4551');
INSERT INTO `tp_region` VALUES ('4559', '林家坪镇', '4', '4551');
INSERT INTO `tp_region` VALUES ('4560', '招贤镇', '4', '4551');
INSERT INTO `tp_region` VALUES ('4561', '碛口镇', '4', '4551');
INSERT INTO `tp_region` VALUES ('4562', '刘家会镇', '4', '4551');
INSERT INTO `tp_region` VALUES ('4563', '丛罗峪镇', '4', '4551');
INSERT INTO `tp_region` VALUES ('4564', '曲峪镇', '4', '4551');
INSERT INTO `tp_region` VALUES ('4565', '木瓜坪乡', '4', '4551');
INSERT INTO `tp_region` VALUES ('4566', '安业乡', '4', '4551');
INSERT INTO `tp_region` VALUES ('4567', '玉坪乡', '4', '4551');
INSERT INTO `tp_region` VALUES ('4568', '青凉寺乡', '4', '4551');
INSERT INTO `tp_region` VALUES ('4569', '石白头乡', '4', '4551');
INSERT INTO `tp_region` VALUES ('4570', '雷家碛乡', '4', '4551');
INSERT INTO `tp_region` VALUES ('4571', '第八堡乡', '4', '4551');
INSERT INTO `tp_region` VALUES ('4572', '大禹乡', '4', '4551');
INSERT INTO `tp_region` VALUES ('4573', '车赶乡', '4', '4551');
INSERT INTO `tp_region` VALUES ('4574', '安家庄乡', '4', '4551');
INSERT INTO `tp_region` VALUES ('4575', '柳林县', '3', '4494');
INSERT INTO `tp_region` VALUES ('4576', '柳林镇', '4', '4575');
INSERT INTO `tp_region` VALUES ('4577', '穆村镇', '4', '4575');
INSERT INTO `tp_region` VALUES ('4578', '薛村镇', '4', '4575');
INSERT INTO `tp_region` VALUES ('4579', '庄上镇', '4', '4575');
INSERT INTO `tp_region` VALUES ('4580', '留誉镇', '4', '4575');
INSERT INTO `tp_region` VALUES ('4581', '三交镇', '4', '4575');
INSERT INTO `tp_region` VALUES ('4582', '成家庄镇', '4', '4575');
INSERT INTO `tp_region` VALUES ('4583', '孟门镇', '4', '4575');
INSERT INTO `tp_region` VALUES ('4584', '李家湾乡', '4', '4575');
INSERT INTO `tp_region` VALUES ('4585', '贾家垣乡', '4', '4575');
INSERT INTO `tp_region` VALUES ('4586', '陈家湾乡', '4', '4575');
INSERT INTO `tp_region` VALUES ('4587', '金家庄乡', '4', '4575');
INSERT INTO `tp_region` VALUES ('4588', '高家沟乡', '4', '4575');
INSERT INTO `tp_region` VALUES ('4589', '石西乡', '4', '4575');
INSERT INTO `tp_region` VALUES ('4590', '王家沟乡', '4', '4575');
INSERT INTO `tp_region` VALUES ('4591', '石楼县', '3', '4494');
INSERT INTO `tp_region` VALUES ('4592', '灵泉镇', '4', '4591');
INSERT INTO `tp_region` VALUES ('4593', '罗村镇', '4', '4591');
INSERT INTO `tp_region` VALUES ('4594', '义牒镇', '4', '4591');
INSERT INTO `tp_region` VALUES ('4595', '小蒜镇', '4', '4591');
INSERT INTO `tp_region` VALUES ('4596', '龙交乡', '4', '4591');
INSERT INTO `tp_region` VALUES ('4597', '和合乡', '4', '4591');
INSERT INTO `tp_region` VALUES ('4598', '前山乡', '4', '4591');
INSERT INTO `tp_region` VALUES ('4599', '曹家垣乡', '4', '4591');
INSERT INTO `tp_region` VALUES ('4600', '裴沟乡', '4', '4591');
INSERT INTO `tp_region` VALUES ('4601', '岚县', '3', '4494');
INSERT INTO `tp_region` VALUES ('4602', '东村镇', '4', '4601');
INSERT INTO `tp_region` VALUES ('4603', '岚城镇', '4', '4601');
INSERT INTO `tp_region` VALUES ('4604', '普明镇', '4', '4601');
INSERT INTO `tp_region` VALUES ('4605', '界河口镇', '4', '4601');
INSERT INTO `tp_region` VALUES ('4606', '土峪乡', '4', '4601');
INSERT INTO `tp_region` VALUES ('4607', '上明乡', '4', '4601');
INSERT INTO `tp_region` VALUES ('4608', '王狮乡', '4', '4601');
INSERT INTO `tp_region` VALUES ('4609', '梁家庄乡', '4', '4601');
INSERT INTO `tp_region` VALUES ('4610', '顺会乡', '4', '4601');
INSERT INTO `tp_region` VALUES ('4611', '河口乡', '4', '4601');
INSERT INTO `tp_region` VALUES ('4612', '社科乡', '4', '4601');
INSERT INTO `tp_region` VALUES ('4613', '大蛇头乡', '4', '4601');
INSERT INTO `tp_region` VALUES ('4614', '方山县', '3', '4494');
INSERT INTO `tp_region` VALUES ('4615', '圪洞镇', '4', '4614');
INSERT INTO `tp_region` VALUES ('4616', '马坊镇', '4', '4614');
INSERT INTO `tp_region` VALUES ('4617', '峪口镇', '4', '4614');
INSERT INTO `tp_region` VALUES ('4618', '大武镇', '4', '4614');
INSERT INTO `tp_region` VALUES ('4619', '北武当镇', '4', '4614');
INSERT INTO `tp_region` VALUES ('4620', '积翠乡', '4', '4614');
INSERT INTO `tp_region` VALUES ('4621', '麻地会乡', '4', '4614');
INSERT INTO `tp_region` VALUES ('4622', '中阳县', '3', '4494');
INSERT INTO `tp_region` VALUES ('4623', '宁乡镇', '4', '4622');
INSERT INTO `tp_region` VALUES ('4624', '金罗镇', '4', '4622');
INSERT INTO `tp_region` VALUES ('4625', '枝柯镇', '4', '4622');
INSERT INTO `tp_region` VALUES ('4626', '武家庄镇', '4', '4622');
INSERT INTO `tp_region` VALUES ('4627', '暖泉镇', '4', '4622');
INSERT INTO `tp_region` VALUES ('4628', '张子山乡', '4', '4622');
INSERT INTO `tp_region` VALUES ('4629', '下枣林乡', '4', '4622');
INSERT INTO `tp_region` VALUES ('4630', '交口县', '3', '4494');
INSERT INTO `tp_region` VALUES ('4631', '水头镇', '4', '4630');
INSERT INTO `tp_region` VALUES ('4632', '康城镇', '4', '4630');
INSERT INTO `tp_region` VALUES ('4633', '双池镇', '4', '4630');
INSERT INTO `tp_region` VALUES ('4634', '桃红坡镇', '4', '4630');
INSERT INTO `tp_region` VALUES ('4635', '石口乡', '4', '4630');
INSERT INTO `tp_region` VALUES ('4636', '回龙乡', '4', '4630');
INSERT INTO `tp_region` VALUES ('4637', '温泉乡', '4', '4630');
INSERT INTO `tp_region` VALUES ('4638', '孝义市', '3', '4494');
INSERT INTO `tp_region` VALUES ('4639', '新义街道', '4', '4638');
INSERT INTO `tp_region` VALUES ('4640', '中阳楼街道', '4', '4638');
INSERT INTO `tp_region` VALUES ('4641', '振兴街道', '4', '4638');
INSERT INTO `tp_region` VALUES ('4642', '东许街道', '4', '4638');
INSERT INTO `tp_region` VALUES ('4643', '兑镇镇', '4', '4638');
INSERT INTO `tp_region` VALUES ('4644', '阳泉曲镇', '4', '4638');
INSERT INTO `tp_region` VALUES ('4645', '下堡镇', '4', '4638');
INSERT INTO `tp_region` VALUES ('4646', '西辛庄镇', '4', '4638');
INSERT INTO `tp_region` VALUES ('4647', '高阳镇', '4', '4638');
INSERT INTO `tp_region` VALUES ('4648', '梧桐镇', '4', '4638');
INSERT INTO `tp_region` VALUES ('4649', '柱濮镇', '4', '4638');
INSERT INTO `tp_region` VALUES ('4650', '大孝堡乡', '4', '4638');
INSERT INTO `tp_region` VALUES ('4651', '下栅乡', '4', '4638');
INSERT INTO `tp_region` VALUES ('4652', '驿马乡', '4', '4638');
INSERT INTO `tp_region` VALUES ('4653', '南阳乡', '4', '4638');
INSERT INTO `tp_region` VALUES ('4654', '杜村乡', '4', '4638');
INSERT INTO `tp_region` VALUES ('4655', '汾阳市', '3', '4494');
INSERT INTO `tp_region` VALUES ('4656', '文峰街道', '4', '4655');
INSERT INTO `tp_region` VALUES ('4657', '太和桥街道', '4', '4655');
INSERT INTO `tp_region` VALUES ('4658', '贾家庄镇', '4', '4655');
INSERT INTO `tp_region` VALUES ('4659', '杏花村镇', '4', '4655');
INSERT INTO `tp_region` VALUES ('4660', '冀村镇', '4', '4655');
INSERT INTO `tp_region` VALUES ('4661', '肖家庄镇', '4', '4655');
INSERT INTO `tp_region` VALUES ('4662', '演武镇', '4', '4655');
INSERT INTO `tp_region` VALUES ('4663', '三泉镇', '4', '4655');
INSERT INTO `tp_region` VALUES ('4664', '石庄镇', '4', '4655');
INSERT INTO `tp_region` VALUES ('4665', '杨家庄镇', '4', '4655');
INSERT INTO `tp_region` VALUES ('4666', '峪道河镇', '4', '4655');
INSERT INTO `tp_region` VALUES ('4667', '西河乡', '4', '4655');
INSERT INTO `tp_region` VALUES ('4668', '阳城乡', '4', '4655');
INSERT INTO `tp_region` VALUES ('4669', '栗家庄乡', '4', '4655');
INSERT INTO `tp_region` VALUES ('4670', '内蒙古自治区', '1', '0');
INSERT INTO `tp_region` VALUES ('4671', '呼和浩特市', '2', '4670');
INSERT INTO `tp_region` VALUES ('4672', '市辖区', '3', '4671');
INSERT INTO `tp_region` VALUES ('4673', '新城区', '3', '4671');
INSERT INTO `tp_region` VALUES ('4674', '海拉尔东路街道', '4', '4673');
INSERT INTO `tp_region` VALUES ('4675', '锡林路', '4', '4673');
INSERT INTO `tp_region` VALUES ('4676', '中山东路街道', '4', '4673');
INSERT INTO `tp_region` VALUES ('4677', '东街街道', '4', '4673');
INSERT INTO `tp_region` VALUES ('4678', '西街街道', '4', '4673');
INSERT INTO `tp_region` VALUES ('4679', '东风路街道', '4', '4673');
INSERT INTO `tp_region` VALUES ('4680', '迎新路街道', '4', '4673');
INSERT INTO `tp_region` VALUES ('4681', '毫沁营镇', '4', '4673');
INSERT INTO `tp_region` VALUES ('4682', '保合少镇', '4', '4673');
INSERT INTO `tp_region` VALUES ('4683', '新城区鸿盛高科技园区', '4', '4673');
INSERT INTO `tp_region` VALUES ('4684', '回民区', '3', '4671');
INSERT INTO `tp_region` VALUES ('4685', '新华西路', '4', '4684');
INSERT INTO `tp_region` VALUES ('4686', '中山西路', '4', '4684');
INSERT INTO `tp_region` VALUES ('4687', '光明路', '4', '4684');
INSERT INTO `tp_region` VALUES ('4688', '海拉尔西路', '4', '4684');
INSERT INTO `tp_region` VALUES ('4689', '环河街', '4', '4684');
INSERT INTO `tp_region` VALUES ('4690', '通道街', '4', '4684');
INSERT INTO `tp_region` VALUES ('4691', '钢铁路', '4', '4684');
INSERT INTO `tp_region` VALUES ('4692', '攸攸板镇', '4', '4684');
INSERT INTO `tp_region` VALUES ('4693', '玉泉区', '3', '4671');
INSERT INTO `tp_region` VALUES ('4694', '小召前街', '4', '4693');
INSERT INTO `tp_region` VALUES ('4695', '兴隆巷', '4', '4693');
INSERT INTO `tp_region` VALUES ('4696', '长和廊', '4', '4693');
INSERT INTO `tp_region` VALUES ('4697', '石东路', '4', '4693');
INSERT INTO `tp_region` VALUES ('4698', '大南街', '4', '4693');
INSERT INTO `tp_region` VALUES ('4699', '鄂尔多斯路', '4', '4693');
INSERT INTO `tp_region` VALUES ('4700', '西菜园', '4', '4693');
INSERT INTO `tp_region` VALUES ('4701', '小黑河镇', '4', '4693');
INSERT INTO `tp_region` VALUES ('4702', '赛罕区', '3', '4671');
INSERT INTO `tp_region` VALUES ('4703', '人民路街道', '4', '4702');
INSERT INTO `tp_region` VALUES ('4704', '大学西路街道', '4', '4702');
INSERT INTO `tp_region` VALUES ('4705', '乌兰察布路街道', '4', '4702');
INSERT INTO `tp_region` VALUES ('4706', '大学东路街道', '4', '4702');
INSERT INTO `tp_region` VALUES ('4707', '中专路街道', '4', '4702');
INSERT INTO `tp_region` VALUES ('4708', '巧报镇', '4', '4702');
INSERT INTO `tp_region` VALUES ('4709', '榆林镇', '4', '4702');
INSERT INTO `tp_region` VALUES ('4710', '巴彦镇', '4', '4702');
INSERT INTO `tp_region` VALUES ('4711', '黄合少镇', '4', '4702');
INSERT INTO `tp_region` VALUES ('4712', '金河镇', '4', '4702');
INSERT INTO `tp_region` VALUES ('4713', '西把栅乡', '4', '4702');
INSERT INTO `tp_region` VALUES ('4714', '金桥经济技术开发区', '4', '4702');
INSERT INTO `tp_region` VALUES ('4715', '土左旗', '3', '4671');
INSERT INTO `tp_region` VALUES ('4716', '察素齐镇', '4', '4715');
INSERT INTO `tp_region` VALUES ('4717', '毕克齐镇', '4', '4715');
INSERT INTO `tp_region` VALUES ('4718', '善岱镇', '4', '4715');
INSERT INTO `tp_region` VALUES ('4719', '台阁牧镇', '4', '4715');
INSERT INTO `tp_region` VALUES ('4720', '白庙子镇', '4', '4715');
INSERT INTO `tp_region` VALUES ('4721', '沙尔沁乡', '4', '4715');
INSERT INTO `tp_region` VALUES ('4722', '北什轴乡', '4', '4715');
INSERT INTO `tp_region` VALUES ('4723', '塔布赛乡', '4', '4715');
INSERT INTO `tp_region` VALUES ('4724', '只几梁乡', '4', '4715');
INSERT INTO `tp_region` VALUES ('4725', '呼和浩特经济技术开发区金川区', '4', '4715');
INSERT INTO `tp_region` VALUES ('4726', '呼和浩特金山经济技术开发区', '4', '4715');
INSERT INTO `tp_region` VALUES ('4727', '托克托县', '3', '4671');
INSERT INTO `tp_region` VALUES ('4728', '双河镇', '4', '4727');
INSERT INTO `tp_region` VALUES ('4729', '新营子镇', '4', '4727');
INSERT INTO `tp_region` VALUES ('4730', '五申镇', '4', '4727');
INSERT INTO `tp_region` VALUES ('4731', '伍什家镇', '4', '4727');
INSERT INTO `tp_region` VALUES ('4732', '古城镇', '4', '4727');
INSERT INTO `tp_region` VALUES ('4733', '和林格尔县', '3', '4671');
INSERT INTO `tp_region` VALUES ('4734', '城关镇', '4', '4733');
INSERT INTO `tp_region` VALUES ('4735', '盛乐镇', '4', '4733');
INSERT INTO `tp_region` VALUES ('4736', '新店子镇', '4', '4733');
INSERT INTO `tp_region` VALUES ('4737', '舍必崖乡', '4', '4733');
INSERT INTO `tp_region` VALUES ('4738', '大红城乡', '4', '4733');
INSERT INTO `tp_region` VALUES ('4739', '羊群沟乡', '4', '4733');
INSERT INTO `tp_region` VALUES ('4740', '黑老夭乡', '4', '4733');
INSERT INTO `tp_region` VALUES ('4741', '盛乐经济工业园区', '4', '4733');
INSERT INTO `tp_region` VALUES ('4742', '清水河县', '3', '4671');
INSERT INTO `tp_region` VALUES ('4743', '城关镇', '4', '4742');
INSERT INTO `tp_region` VALUES ('4744', '宏河镇', '4', '4742');
INSERT INTO `tp_region` VALUES ('4745', '喇嘛湾镇', '4', '4742');
INSERT INTO `tp_region` VALUES ('4746', '窑沟乡', '4', '4742');
INSERT INTO `tp_region` VALUES ('4747', '北堡乡', '4', '4742');
INSERT INTO `tp_region` VALUES ('4748', '韮菜庄乡', '4', '4742');
INSERT INTO `tp_region` VALUES ('4749', '武川县', '3', '4671');
INSERT INTO `tp_region` VALUES ('4750', '可镇', '4', '4749');
INSERT INTO `tp_region` VALUES ('4751', '哈乐镇', '4', '4749');
INSERT INTO `tp_region` VALUES ('4752', '西乌兰不浪镇', '4', '4749');
INSERT INTO `tp_region` VALUES ('4753', '大青山乡', '4', '4749');
INSERT INTO `tp_region` VALUES ('4754', '上秃亥乡', '4', '4749');
INSERT INTO `tp_region` VALUES ('4755', '德胜沟乡', '4', '4749');
INSERT INTO `tp_region` VALUES ('4756', '二份子乡', '4', '4749');
INSERT INTO `tp_region` VALUES ('4757', '哈拉合少乡', '4', '4749');
INSERT INTO `tp_region` VALUES ('4758', '工业园区', '4', '4749');
INSERT INTO `tp_region` VALUES ('4759', '包头市', '2', '4670');
INSERT INTO `tp_region` VALUES ('4760', '市辖区', '3', '4759');
INSERT INTO `tp_region` VALUES ('4761', '东河区', '3', '4759');
INSERT INTO `tp_region` VALUES ('4762', '和平街道', '4', '4761');
INSERT INTO `tp_region` VALUES ('4763', '财神庙街道', '4', '4761');
INSERT INTO `tp_region` VALUES ('4764', '西脑包街道', '4', '4761');
INSERT INTO `tp_region` VALUES ('4765', '南门外街道', '4', '4761');
INSERT INTO `tp_region` VALUES ('4766', '南圪洞街道', '4', '4761');
INSERT INTO `tp_region` VALUES ('4767', '东站街道', '4', '4761');
INSERT INTO `tp_region` VALUES ('4768', '回民街道', '4', '4761');
INSERT INTO `tp_region` VALUES ('4769', '二里半街道', '4', '4761');
INSERT INTO `tp_region` VALUES ('4770', '河东街道', '4', '4761');
INSERT INTO `tp_region` VALUES ('4771', '铁西街道', '4', '4761');
INSERT INTO `tp_region` VALUES ('4772', '东兴街道', '4', '4761');
INSERT INTO `tp_region` VALUES ('4773', '杨圪楞街道', '4', '4761');
INSERT INTO `tp_region` VALUES ('4774', '河东镇', '4', '4761');
INSERT INTO `tp_region` VALUES ('4775', '昆都仑区', '3', '4759');
INSERT INTO `tp_region` VALUES ('4776', '少先路街道', '4', '4775');
INSERT INTO `tp_region` VALUES ('4777', '张家营子街道', '4', '4775');
INSERT INTO `tp_region` VALUES ('4778', '沼潭街道', '4', '4775');
INSERT INTO `tp_region` VALUES ('4779', '林荫路街道', '4', '4775');
INSERT INTO `tp_region` VALUES ('4780', '友谊大街街道', '4', '4775');
INSERT INTO `tp_region` VALUES ('4781', '阿尔丁大街街道', '4', '4775');
INSERT INTO `tp_region` VALUES ('4782', '团结大街街道', '4', '4775');
INSERT INTO `tp_region` VALUES ('4783', '鞍山道街道', '4', '4775');
INSERT INTO `tp_region` VALUES ('4784', '前进道街道', '4', '4775');
INSERT INTO `tp_region` VALUES ('4785', '市府东路街道', '4', '4775');
INSERT INTO `tp_region` VALUES ('4786', '白云路街道', '4', '4775');
INSERT INTO `tp_region` VALUES ('4787', '黄河西路街道', '4', '4775');
INSERT INTO `tp_region` VALUES ('4788', '昆工路街道', '4', '4775');
INSERT INTO `tp_region` VALUES ('4789', '昆河镇', '4', '4775');
INSERT INTO `tp_region` VALUES ('4790', '包钢厂区虚拟', '4', '4775');
INSERT INTO `tp_region` VALUES ('4791', '青山区', '3', '4759');
INSERT INTO `tp_region` VALUES ('4792', '先锋道街道', '4', '4791');
INSERT INTO `tp_region` VALUES ('4793', '幸福路街道', '4', '4791');
INSERT INTO `tp_region` VALUES ('4794', '万青路街道', '4', '4791');
INSERT INTO `tp_region` VALUES ('4795', '富强路街道', '4', '4791');
INSERT INTO `tp_region` VALUES ('4796', '科学路街道', '4', '4791');
INSERT INTO `tp_region` VALUES ('4797', '青山路街道', '4', '4791');
INSERT INTO `tp_region` VALUES ('4798', '自由路街道', '4', '4791');
INSERT INTO `tp_region` VALUES ('4799', '乌素图街道', '4', '4791');
INSERT INTO `tp_region` VALUES ('4800', '青福镇', '4', '4791');
INSERT INTO `tp_region` VALUES ('4801', '万水泉镇', '4', '4791');
INSERT INTO `tp_region` VALUES ('4802', '包头稀土高新区新建区虚拟', '4', '4791');
INSERT INTO `tp_region` VALUES ('4803', '石拐区', '3', '4759');
INSERT INTO `tp_region` VALUES ('4804', '石拐街道', '4', '4803');
INSERT INTO `tp_region` VALUES ('4805', '大发街道', '4', '4803');
INSERT INTO `tp_region` VALUES ('4806', '大磁街道', '4', '4803');
INSERT INTO `tp_region` VALUES ('4807', '五当沟街道', '4', '4803');
INSERT INTO `tp_region` VALUES ('4808', '白狐沟街道', '4', '4803');
INSERT INTO `tp_region` VALUES ('4809', '五当召镇', '4', '4803');
INSERT INTO `tp_region` VALUES ('4810', '白云鄂博矿区', '3', '4759');
INSERT INTO `tp_region` VALUES ('4811', '矿山路街道', '4', '4810');
INSERT INTO `tp_region` VALUES ('4812', '通阳道街道', '4', '4810');
INSERT INTO `tp_region` VALUES ('4813', '九原区', '3', '4759');
INSERT INTO `tp_region` VALUES ('4814', '沙河街道', '4', '4813');
INSERT INTO `tp_region` VALUES ('4815', '麻池镇', '4', '4813');
INSERT INTO `tp_region` VALUES ('4816', '哈林格尔镇', '4', '4813');
INSERT INTO `tp_region` VALUES ('4817', '沙尔沁镇', '4', '4813');
INSERT INTO `tp_region` VALUES ('4818', '兴胜镇', '4', '4813');
INSERT INTO `tp_region` VALUES ('4819', '哈业胡同镇', '4', '4813');
INSERT INTO `tp_region` VALUES ('4820', '阿嘎如泰苏木乡', '4', '4813');
INSERT INTO `tp_region` VALUES ('4821', '包头市国营青年农场', '4', '4813');
INSERT INTO `tp_region` VALUES ('4822', '包头市奶业公司', '4', '4813');
INSERT INTO `tp_region` VALUES ('4823', '土默特右旗', '3', '4759');
INSERT INTO `tp_region` VALUES ('4824', '萨拉齐镇', '4', '4823');
INSERT INTO `tp_region` VALUES ('4825', '双龙镇', '4', '4823');
INSERT INTO `tp_region` VALUES ('4826', '美岱召镇', '4', '4823');
INSERT INTO `tp_region` VALUES ('4827', '沟门镇', '4', '4823');
INSERT INTO `tp_region` VALUES ('4828', '将军尧镇', '4', '4823');
INSERT INTO `tp_region` VALUES ('4829', '海子乡', '4', '4823');
INSERT INTO `tp_region` VALUES ('4830', '明沙淖乡', '4', '4823');
INSERT INTO `tp_region` VALUES ('4831', '苏波盖乡', '4', '4823');
INSERT INTO `tp_region` VALUES ('4832', '九峰山生态管理委员会', '4', '4823');
INSERT INTO `tp_region` VALUES ('4833', '固阳县', '3', '4759');
INSERT INTO `tp_region` VALUES ('4834', '金山镇', '4', '4833');
INSERT INTO `tp_region` VALUES ('4835', '西斗铺镇', '4', '4833');
INSERT INTO `tp_region` VALUES ('4836', '下湿壕镇', '4', '4833');
INSERT INTO `tp_region` VALUES ('4837', '银号镇', '4', '4833');
INSERT INTO `tp_region` VALUES ('4838', '怀朔镇', '4', '4833');
INSERT INTO `tp_region` VALUES ('4839', '兴顺西镇', '4', '4833');
INSERT INTO `tp_region` VALUES ('4840', '达茂联合旗', '3', '4759');
INSERT INTO `tp_region` VALUES ('4841', '满都拉镇', '4', '4840');
INSERT INTO `tp_region` VALUES ('4842', '希拉穆仁镇', '4', '4840');
INSERT INTO `tp_region` VALUES ('4843', '百灵庙镇', '4', '4840');
INSERT INTO `tp_region` VALUES ('4844', '石宝镇', '4', '4840');
INSERT INTO `tp_region` VALUES ('4845', '乌克忽洞镇', '4', '4840');
INSERT INTO `tp_region` VALUES ('4846', '明安镇', '4', '4840');
INSERT INTO `tp_region` VALUES ('4847', '巴音花镇', '4', '4840');
INSERT INTO `tp_region` VALUES ('4848', '达尔罕苏木乡', '4', '4840');
INSERT INTO `tp_region` VALUES ('4849', '乌海市', '2', '4670');
INSERT INTO `tp_region` VALUES ('4850', '乌海市辖区', '3', '4849');
INSERT INTO `tp_region` VALUES ('4851', '海勃湾区', '3', '4849');
INSERT INTO `tp_region` VALUES ('4852', '凤凰岭街道', '4', '4851');
INSERT INTO `tp_region` VALUES ('4853', '海北街道', '4', '4851');
INSERT INTO `tp_region` VALUES ('4854', '新华街道', '4', '4851');
INSERT INTO `tp_region` VALUES ('4855', '新华西街道', '4', '4851');
INSERT INTO `tp_region` VALUES ('4856', '卡布其街道', '4', '4851');
INSERT INTO `tp_region` VALUES ('4857', '滨河街道', '4', '4851');
INSERT INTO `tp_region` VALUES ('4858', '千里山镇', '4', '4851');
INSERT INTO `tp_region` VALUES ('4859', '海南区', '3', '4849');
INSERT INTO `tp_region` VALUES ('4860', '拉僧仲街道', '4', '4859');
INSERT INTO `tp_region` VALUES ('4861', '西卓子山街道', '4', '4859');
INSERT INTO `tp_region` VALUES ('4862', '公乌素镇', '4', '4859');
INSERT INTO `tp_region` VALUES ('4863', '拉僧庙镇', '4', '4859');
INSERT INTO `tp_region` VALUES ('4864', '巴音陶亥镇', '4', '4859');
INSERT INTO `tp_region` VALUES ('4865', '乌达区', '3', '4849');
INSERT INTO `tp_region` VALUES ('4866', '三道坎街道', '4', '4865');
INSERT INTO `tp_region` VALUES ('4867', '五虎山街道', '4', '4865');
INSERT INTO `tp_region` VALUES ('4868', '新达街道', '4', '4865');
INSERT INTO `tp_region` VALUES ('4869', '巴音赛街道', '4', '4865');
INSERT INTO `tp_region` VALUES ('4870', '梁家沟街道', '4', '4865');
INSERT INTO `tp_region` VALUES ('4871', '苏海图街道', '4', '4865');
INSERT INTO `tp_region` VALUES ('4872', '滨海街道', '4', '4865');
INSERT INTO `tp_region` VALUES ('4873', '乌兰淖尔镇', '4', '4865');
INSERT INTO `tp_region` VALUES ('4874', '赤峰市', '2', '4670');
INSERT INTO `tp_region` VALUES ('4875', '市辖区', '3', '4874');
INSERT INTO `tp_region` VALUES ('4876', '红山区', '3', '4874');
INSERT INTO `tp_region` VALUES ('4877', '西屯街道', '4', '4876');
INSERT INTO `tp_region` VALUES ('4878', '三中街街道', '4', '4876');
INSERT INTO `tp_region` VALUES ('4879', '永巨街道', '4', '4876');
INSERT INTO `tp_region` VALUES ('4880', '东城街道', '4', '4876');
INSERT INTO `tp_region` VALUES ('4881', '南新街街道', '4', '4876');
INSERT INTO `tp_region` VALUES ('4882', '站前街道', '4', '4876');
INSERT INTO `tp_region` VALUES ('4883', '铁南街道', '4', '4876');
INSERT INTO `tp_region` VALUES ('4884', '长青街道', '4', '4876');
INSERT INTO `tp_region` VALUES ('4885', '哈达街道', '4', '4876');
INSERT INTO `tp_region` VALUES ('4886', '红庙子镇', '4', '4876');
INSERT INTO `tp_region` VALUES ('4887', '文钟镇', '4', '4876');
INSERT INTO `tp_region` VALUES ('4888', '元宝山区', '3', '4874');
INSERT INTO `tp_region` VALUES ('4889', '西露天街道', '4', '4888');
INSERT INTO `tp_region` VALUES ('4890', '平庄城区街道', '4', '4888');
INSERT INTO `tp_region` VALUES ('4891', '风水沟镇', '4', '4888');
INSERT INTO `tp_region` VALUES ('4892', '元宝山镇', '4', '4888');
INSERT INTO `tp_region` VALUES ('4893', '美丽河镇', '4', '4888');
INSERT INTO `tp_region` VALUES ('4894', '平庄镇', '4', '4888');
INSERT INTO `tp_region` VALUES ('4895', '五家镇', '4', '4888');
INSERT INTO `tp_region` VALUES ('4896', '松山区', '3', '4874');
INSERT INTO `tp_region` VALUES ('4897', '振兴街道', '4', '4896');
INSERT INTO `tp_region` VALUES ('4898', '向阳街道', '4', '4896');
INSERT INTO `tp_region` VALUES ('4899', '松州街道', '4', '4896');
INSERT INTO `tp_region` VALUES ('4900', '铁东街道', '4', '4896');
INSERT INTO `tp_region` VALUES ('4901', '玉龙街道', '4', '4896');
INSERT INTO `tp_region` VALUES ('4902', '富河街道', '4', '4896');
INSERT INTO `tp_region` VALUES ('4903', '兴安街道', '4', '4896');
INSERT INTO `tp_region` VALUES ('4904', '全宁街道', '4', '4896');
INSERT INTO `tp_region` VALUES ('4905', '穆家营子镇', '4', '4896');
INSERT INTO `tp_region` VALUES ('4906', '初头朗镇', '4', '4896');
INSERT INTO `tp_region` VALUES ('4907', '大庙镇', '4', '4896');
INSERT INTO `tp_region` VALUES ('4908', '王府镇', '4', '4896');
INSERT INTO `tp_region` VALUES ('4909', '老府镇', '4', '4896');
INSERT INTO `tp_region` VALUES ('4910', '哈拉道口镇', '4', '4896');
INSERT INTO `tp_region` VALUES ('4911', '上官地镇', '4', '4896');
INSERT INTO `tp_region` VALUES ('4912', '安庆镇', '4', '4896');
INSERT INTO `tp_region` VALUES ('4913', '太平地镇', '4', '4896');
INSERT INTO `tp_region` VALUES ('4914', '当铺地满族乡', '4', '4896');
INSERT INTO `tp_region` VALUES ('4915', '夏家店乡', '4', '4896');
INSERT INTO `tp_region` VALUES ('4916', '城子乡', '4', '4896');
INSERT INTO `tp_region` VALUES ('4917', '大夫营子乡', '4', '4896');
INSERT INTO `tp_region` VALUES ('4918', '岗子乡', '4', '4896');
INSERT INTO `tp_region` VALUES ('4919', '阿鲁科尔沁旗', '3', '4874');
INSERT INTO `tp_region` VALUES ('4920', '天山', '4', '4919');
INSERT INTO `tp_region` VALUES ('4921', '天山镇', '4', '4919');
INSERT INTO `tp_region` VALUES ('4922', '天山口镇', '4', '4919');
INSERT INTO `tp_region` VALUES ('4923', '双胜镇', '4', '4919');
INSERT INTO `tp_region` VALUES ('4924', '坤都镇', '4', '4919');
INSERT INTO `tp_region` VALUES ('4925', '巴彦花镇', '4', '4919');
INSERT INTO `tp_region` VALUES ('4926', '绍根镇', '4', '4919');
INSERT INTO `tp_region` VALUES ('4927', '新民乡', '4', '4919');
INSERT INTO `tp_region` VALUES ('4928', '先锋乡', '4', '4919');
INSERT INTO `tp_region` VALUES ('4929', '罕苏木苏木乡', '4', '4919');
INSERT INTO `tp_region` VALUES ('4930', '赛汉塔拉苏木乡', '4', '4919');
INSERT INTO `tp_region` VALUES ('4931', '巴拉奇如德苏木乡', '4', '4919');
INSERT INTO `tp_region` VALUES ('4932', '巴林左旗', '3', '4874');
INSERT INTO `tp_region` VALUES ('4933', '林东西城街道', '4', '4932');
INSERT INTO `tp_region` VALUES ('4934', '林东东城街道', '4', '4932');
INSERT INTO `tp_region` VALUES ('4935', '林东镇', '4', '4932');
INSERT INTO `tp_region` VALUES ('4936', '隆昌镇', '4', '4932');
INSERT INTO `tp_region` VALUES ('4937', '十三敖包镇', '4', '4932');
INSERT INTO `tp_region` VALUES ('4938', '碧流台镇', '4', '4932');
INSERT INTO `tp_region` VALUES ('4939', '富河镇', '4', '4932');
INSERT INTO `tp_region` VALUES ('4940', '白音诺尔镇', '4', '4932');
INSERT INTO `tp_region` VALUES ('4941', '哈拉哈达镇', '4', '4932');
INSERT INTO `tp_region` VALUES ('4942', '查干哈达苏木乡', '4', '4932');
INSERT INTO `tp_region` VALUES ('4943', '乌兰达坝苏木乡', '4', '4932');
INSERT INTO `tp_region` VALUES ('4944', '巴林右旗', '3', '4874');
INSERT INTO `tp_region` VALUES ('4945', '大板镇', '4', '4944');
INSERT INTO `tp_region` VALUES ('4946', '索博日嘎镇', '4', '4944');
INSERT INTO `tp_region` VALUES ('4947', '宝日勿苏镇', '4', '4944');
INSERT INTO `tp_region` VALUES ('4948', '查干诺尔镇', '4', '4944');
INSERT INTO `tp_region` VALUES ('4949', '查干沐沦镇', '4', '4944');
INSERT INTO `tp_region` VALUES ('4950', '西拉沐沦苏木乡', '4', '4944');
INSERT INTO `tp_region` VALUES ('4951', '巴彦塔拉苏木乡', '4', '4944');
INSERT INTO `tp_region` VALUES ('4952', '幸福之路苏木乡', '4', '4944');
INSERT INTO `tp_region` VALUES ('4953', '林西县', '3', '4874');
INSERT INTO `tp_region` VALUES ('4954', '林西街道', '4', '4953');
INSERT INTO `tp_region` VALUES ('4955', '林西镇', '4', '4953');
INSERT INTO `tp_region` VALUES ('4956', '新城子镇', '4', '4953');
INSERT INTO `tp_region` VALUES ('4957', '新林镇', '4', '4953');
INSERT INTO `tp_region` VALUES ('4958', '五十家子镇', '4', '4953');
INSERT INTO `tp_region` VALUES ('4959', '官地镇', '4', '4953');
INSERT INTO `tp_region` VALUES ('4960', '大井镇', '4', '4953');
INSERT INTO `tp_region` VALUES ('4961', '统部镇', '4', '4953');
INSERT INTO `tp_region` VALUES ('4962', '大营子乡', '4', '4953');
INSERT INTO `tp_region` VALUES ('4963', '克什克腾旗', '3', '4874');
INSERT INTO `tp_region` VALUES ('4964', '经棚镇', '4', '4963');
INSERT INTO `tp_region` VALUES ('4965', '宇宙地镇', '4', '4963');
INSERT INTO `tp_region` VALUES ('4966', '土城子镇', '4', '4963');
INSERT INTO `tp_region` VALUES ('4967', '同兴镇', '4', '4963');
INSERT INTO `tp_region` VALUES ('4968', '万合永镇', '4', '4963');
INSERT INTO `tp_region` VALUES ('4969', '芝瑞镇', '4', '4963');
INSERT INTO `tp_region` VALUES ('4970', '达来诺日镇', '4', '4963');
INSERT INTO `tp_region` VALUES ('4971', '新开地乡', '4', '4963');
INSERT INTO `tp_region` VALUES ('4972', '红山子乡', '4', '4963');
INSERT INTO `tp_region` VALUES ('4973', '达日罕乌拉苏木乡', '4', '4963');
INSERT INTO `tp_region` VALUES ('4974', '巴彦查干苏木乡', '4', '4963');
INSERT INTO `tp_region` VALUES ('4975', '翁牛特旗', '3', '4874');
INSERT INTO `tp_region` VALUES ('4976', '乌丹镇', '4', '4975');
INSERT INTO `tp_region` VALUES ('4977', '乌敦套海镇', '4', '4975');
INSERT INTO `tp_region` VALUES ('4978', '五分地镇', '4', '4975');
INSERT INTO `tp_region` VALUES ('4979', '桥头镇', '4', '4975');
INSERT INTO `tp_region` VALUES ('4980', '广德公镇', '4', '4975');
INSERT INTO `tp_region` VALUES ('4981', '梧桐花镇', '4', '4975');
INSERT INTO `tp_region` VALUES ('4982', '海日苏镇', '4', '4975');
INSERT INTO `tp_region` VALUES ('4983', '亿合公镇', '4', '4975');
INSERT INTO `tp_region` VALUES ('4984', '解放营子乡', '4', '4975');
INSERT INTO `tp_region` VALUES ('4985', '阿什罕苏木乡', '4', '4975');
INSERT INTO `tp_region` VALUES ('4986', '白音他拉苏木乡', '4', '4975');
INSERT INTO `tp_region` VALUES ('4987', '白音套海苏木乡', '4', '4975');
INSERT INTO `tp_region` VALUES ('4988', '喀喇沁旗', '3', '4874');
INSERT INTO `tp_region` VALUES ('4989', '锦山镇', '4', '4988');
INSERT INTO `tp_region` VALUES ('4990', '美林镇', '4', '4988');
INSERT INTO `tp_region` VALUES ('4991', '王爷府镇', '4', '4988');
INSERT INTO `tp_region` VALUES ('4992', '小牛群镇', '4', '4988');
INSERT INTO `tp_region` VALUES ('4993', '牛家营子镇', '4', '4988');
INSERT INTO `tp_region` VALUES ('4994', '乃林镇', '4', '4988');
INSERT INTO `tp_region` VALUES ('4995', '西桥镇', '4', '4988');
INSERT INTO `tp_region` VALUES ('4996', '十家满族乡', '4', '4988');
INSERT INTO `tp_region` VALUES ('4997', '乃林果树农场', '4', '4988');
INSERT INTO `tp_region` VALUES ('4998', '马鞍山羊场', '4', '4988');
INSERT INTO `tp_region` VALUES ('4999', '宁城县', '3', '4874');
INSERT INTO `tp_region` VALUES ('5000', '天义镇政府', '4', '4999');
INSERT INTO `tp_region` VALUES ('5001', '小城子镇政府', '4', '4999');
INSERT INTO `tp_region` VALUES ('5002', '大城子镇政府', '4', '4999');
INSERT INTO `tp_region` VALUES ('5003', '八里罕镇政府', '4', '4999');
INSERT INTO `tp_region` VALUES ('5004', '黑里河镇政府', '4', '4999');
INSERT INTO `tp_region` VALUES ('5005', '甸子镇政府', '4', '4999');
INSERT INTO `tp_region` VALUES ('5006', '大双庙镇政府', '4', '4999');
INSERT INTO `tp_region` VALUES ('5007', '汐子镇政府', '4', '4999');
INSERT INTO `tp_region` VALUES ('5008', '大明镇政府', '4', '4999');
INSERT INTO `tp_region` VALUES ('5009', '忙农镇政府', '4', '4999');
INSERT INTO `tp_region` VALUES ('5010', '三座店乡政府', '4', '4999');
INSERT INTO `tp_region` VALUES ('5011', '必斯营子乡政府', '4', '4999');
INSERT INTO `tp_region` VALUES ('5012', '五化乡政府', '4', '4999');
INSERT INTO `tp_region` VALUES ('5013', '敖汉旗', '3', '4874');
INSERT INTO `tp_region` VALUES ('5014', '新惠镇', '4', '5013');
INSERT INTO `tp_region` VALUES ('5015', '四家子镇', '4', '5013');
INSERT INTO `tp_region` VALUES ('5016', '长胜镇', '4', '5013');
INSERT INTO `tp_region` VALUES ('5017', '贝子府镇', '4', '5013');
INSERT INTO `tp_region` VALUES ('5018', '四道湾子镇', '4', '5013');
INSERT INTO `tp_region` VALUES ('5019', '下洼镇', '4', '5013');
INSERT INTO `tp_region` VALUES ('5020', '金厂沟梁镇', '4', '5013');
INSERT INTO `tp_region` VALUES ('5021', '宝国吐乡', '4', '5013');
INSERT INTO `tp_region` VALUES ('5022', '牛古吐乡', '4', '5013');
INSERT INTO `tp_region` VALUES ('5023', '木头营子乡', '4', '5013');
INSERT INTO `tp_region` VALUES ('5024', '古鲁板蒿乡', '4', '5013');
INSERT INTO `tp_region` VALUES ('5025', '丰收乡', '4', '5013');
INSERT INTO `tp_region` VALUES ('5026', '玛尼罕乡', '4', '5013');
INSERT INTO `tp_region` VALUES ('5027', '萨力巴乡', '4', '5013');
INSERT INTO `tp_region` VALUES ('5028', '敖润苏莫苏木乡', '4', '5013');
INSERT INTO `tp_region` VALUES ('5029', '通辽市', '2', '4670');
INSERT INTO `tp_region` VALUES ('5030', '市辖区', '3', '5029');
INSERT INTO `tp_region` VALUES ('5031', '科尔沁区', '3', '5029');
INSERT INTO `tp_region` VALUES ('5032', '科尔沁街道', '4', '5031');
INSERT INTO `tp_region` VALUES ('5033', '西门街道', '4', '5031');
INSERT INTO `tp_region` VALUES ('5034', '永清街道', '4', '5031');
INSERT INTO `tp_region` VALUES ('5035', '明仁街道', '4', '5031');
INSERT INTO `tp_region` VALUES ('5036', '施介街道', '4', '5031');
INSERT INTO `tp_region` VALUES ('5037', '清真街道', '4', '5031');
INSERT INTO `tp_region` VALUES ('5038', '东郊街道', '4', '5031');
INSERT INTO `tp_region` VALUES ('5039', '铁路街道', '4', '5031');
INSERT INTO `tp_region` VALUES ('5040', '红星街道', '4', '5031');
INSERT INTO `tp_region` VALUES ('5041', '霍林街道', '4', '5031');
INSERT INTO `tp_region` VALUES ('5042', '建国街道', '4', '5031');
INSERT INTO `tp_region` VALUES ('5043', '河西街道', '4', '5031');
INSERT INTO `tp_region` VALUES ('5044', '电厂街道', '4', '5031');
INSERT INTO `tp_region` VALUES ('5045', '大林镇', '4', '5031');
INSERT INTO `tp_region` VALUES ('5046', '钱家店镇', '4', '5031');
INSERT INTO `tp_region` VALUES ('5047', '余粮堡镇', '4', '5031');
INSERT INTO `tp_region` VALUES ('5048', '木里图镇', '4', '5031');
INSERT INTO `tp_region` VALUES ('5049', '丰田镇', '4', '5031');
INSERT INTO `tp_region` VALUES ('5050', '清河镇', '4', '5031');
INSERT INTO `tp_region` VALUES ('5051', '育新镇', '4', '5031');
INSERT INTO `tp_region` VALUES ('5052', '庆和镇', '4', '5031');
INSERT INTO `tp_region` VALUES ('5053', '敖力布皋镇', '4', '5031');
INSERT INTO `tp_region` VALUES ('5054', '辽河镇', '4', '5031');
INSERT INTO `tp_region` VALUES ('5055', '莫力庙苏木乡', '4', '5031');
INSERT INTO `tp_region` VALUES ('5056', '哲南农场', '4', '5031');
INSERT INTO `tp_region` VALUES ('5057', '三义堂农场', '4', '5031');
INSERT INTO `tp_region` VALUES ('5058', '高林屯种畜场', '4', '5031');
INSERT INTO `tp_region` VALUES ('5059', '胡力海原种繁殖场', '4', '5031');
INSERT INTO `tp_region` VALUES ('5060', '莫力庙羊场', '4', '5031');
INSERT INTO `tp_region` VALUES ('5061', '半截店牧场', '4', '5031');
INSERT INTO `tp_region` VALUES ('5062', '科尔沁左翼中旗', '3', '5029');
INSERT INTO `tp_region` VALUES ('5063', '保康镇', '4', '5062');
INSERT INTO `tp_region` VALUES ('5064', '宝龙山镇', '4', '5062');
INSERT INTO `tp_region` VALUES ('5065', '舍伯吐镇', '4', '5062');
INSERT INTO `tp_region` VALUES ('5066', '巴彦塔拉镇', '4', '5062');
INSERT INTO `tp_region` VALUES ('5067', '门达镇', '4', '5062');
INSERT INTO `tp_region` VALUES ('5068', '架玛吐镇', '4', '5062');
INSERT INTO `tp_region` VALUES ('5069', '腰林毛都镇', '4', '5062');
INSERT INTO `tp_region` VALUES ('5070', '希伯花镇', '4', '5062');
INSERT INTO `tp_region` VALUES ('5071', '花吐古拉镇', '4', '5062');
INSERT INTO `tp_region` VALUES ('5072', '代力吉镇', '4', '5062');
INSERT INTO `tp_region` VALUES ('5073', '努日木镇', '4', '5062');
INSERT INTO `tp_region` VALUES ('5074', '花胡硕苏木乡', '4', '5062');
INSERT INTO `tp_region` VALUES ('5075', '协代苏木乡', '4', '5062');
INSERT INTO `tp_region` VALUES ('5076', '白兴吐苏木乡', '4', '5062');
INSERT INTO `tp_region` VALUES ('5077', '图布信苏木乡', '4', '5062');
INSERT INTO `tp_region` VALUES ('5078', '东苏林场', '4', '5062');
INSERT INTO `tp_region` VALUES ('5079', '科左后旗', '3', '5029');
INSERT INTO `tp_region` VALUES ('5080', '甘旗卡镇', '4', '5079');
INSERT INTO `tp_region` VALUES ('5081', '吉尔嘎朗镇', '4', '5079');
INSERT INTO `tp_region` VALUES ('5082', '金宝屯镇', '4', '5079');
INSERT INTO `tp_region` VALUES ('5083', '常胜镇', '4', '5079');
INSERT INTO `tp_region` VALUES ('5084', '查日苏镇', '4', '5079');
INSERT INTO `tp_region` VALUES ('5085', '双胜镇', '4', '5079');
INSERT INTO `tp_region` VALUES ('5086', '阿古拉镇', '4', '5079');
INSERT INTO `tp_region` VALUES ('5087', '朝鲁吐镇', '4', '5079');
INSERT INTO `tp_region` VALUES ('5088', '努古斯台镇', '4', '5079');
INSERT INTO `tp_region` VALUES ('5089', '海鲁吐镇', '4', '5079');
INSERT INTO `tp_region` VALUES ('5090', '阿都沁苏木乡', '4', '5079');
INSERT INTO `tp_region` VALUES ('5091', '茂道吐苏木乡', '4', '5079');
INSERT INTO `tp_region` VALUES ('5092', '胜利农场', '4', '5079');
INSERT INTO `tp_region` VALUES ('5093', '孟根达坝牧场', '4', '5079');
INSERT INTO `tp_region` VALUES ('5094', '查金台牧场', '4', '5079');
INSERT INTO `tp_region` VALUES ('5095', '原种场', '4', '5079');
INSERT INTO `tp_region` VALUES ('5096', '大青沟管理局', '4', '5079');
INSERT INTO `tp_region` VALUES ('5097', '哈日乌苏种畜场', '4', '5079');
INSERT INTO `tp_region` VALUES ('5098', '乌兰敖道渔场', '4', '5079');
INSERT INTO `tp_region` VALUES ('5099', '金宝屯林场', '4', '5079');
INSERT INTO `tp_region` VALUES ('5100', '朝鲁吐林场', '4', '5079');
INSERT INTO `tp_region` VALUES ('5101', '茂道吐林场', '4', '5079');
INSERT INTO `tp_region` VALUES ('5102', '伊胡塔林场', '4', '5079');
INSERT INTO `tp_region` VALUES ('5103', '乌旦塔拉林场', '4', '5079');
INSERT INTO `tp_region` VALUES ('5104', '开鲁县', '3', '5029');
INSERT INTO `tp_region` VALUES ('5105', '开鲁镇', '4', '5104');
INSERT INTO `tp_region` VALUES ('5106', '大榆树镇', '4', '5104');
INSERT INTO `tp_region` VALUES ('5107', '黑龙坝镇', '4', '5104');
INSERT INTO `tp_region` VALUES ('5108', '麦新镇', '4', '5104');
INSERT INTO `tp_region` VALUES ('5109', '义和塔拉镇', '4', '5104');
INSERT INTO `tp_region` VALUES ('5110', '建华镇', '4', '5104');
INSERT INTO `tp_region` VALUES ('5111', '小街基镇', '4', '5104');
INSERT INTO `tp_region` VALUES ('5112', '东风镇', '4', '5104');
INSERT INTO `tp_region` VALUES ('5113', '吉日嘎郎吐镇', '4', '5104');
INSERT INTO `tp_region` VALUES ('5114', '东来镇', '4', '5104');
INSERT INTO `tp_region` VALUES ('5115', '清河牧场', '4', '5104');
INSERT INTO `tp_region` VALUES ('5116', '辽河农场', '4', '5104');
INSERT INTO `tp_region` VALUES ('5117', '保安农场', '4', '5104');
INSERT INTO `tp_region` VALUES ('5118', '库伦旗', '3', '5029');
INSERT INTO `tp_region` VALUES ('5119', '库伦镇', '4', '5118');
INSERT INTO `tp_region` VALUES ('5120', '扣河子镇', '4', '5118');
INSERT INTO `tp_region` VALUES ('5121', '白音花镇', '4', '5118');
INSERT INTO `tp_region` VALUES ('5122', '六家子镇', '4', '5118');
INSERT INTO `tp_region` VALUES ('5123', '额勒顺镇', '4', '5118');
INSERT INTO `tp_region` VALUES ('5124', '茫汗苏木乡', '4', '5118');
INSERT INTO `tp_region` VALUES ('5125', '奈曼旗', '3', '5029');
INSERT INTO `tp_region` VALUES ('5126', '大沁他拉镇', '4', '5125');
INSERT INTO `tp_region` VALUES ('5127', '八仙筒镇', '4', '5125');
INSERT INTO `tp_region` VALUES ('5128', '青龙山镇', '4', '5125');
INSERT INTO `tp_region` VALUES ('5129', '新镇', '4', '5125');
INSERT INTO `tp_region` VALUES ('5130', '治安镇', '4', '5125');
INSERT INTO `tp_region` VALUES ('5131', '东明镇', '4', '5125');
INSERT INTO `tp_region` VALUES ('5132', '土城子镇', '4', '5125');
INSERT INTO `tp_region` VALUES ('5133', '义隆永镇', '4', '5125');
INSERT INTO `tp_region` VALUES ('5134', '固日班花苏木乡', '4', '5125');
INSERT INTO `tp_region` VALUES ('5135', '苇莲苏苏木乡', '4', '5125');
INSERT INTO `tp_region` VALUES ('5136', '明仁苏木乡', '4', '5125');
INSERT INTO `tp_region` VALUES ('5137', '黄花塔拉苏木乡', '4', '5125');
INSERT INTO `tp_region` VALUES ('5138', '国有六号农场', '4', '5125');
INSERT INTO `tp_region` VALUES ('5139', '扎鲁特旗', '3', '5029');
INSERT INTO `tp_region` VALUES ('5140', '鲁北镇', '4', '5139');
INSERT INTO `tp_region` VALUES ('5141', '黄花山镇', '4', '5139');
INSERT INTO `tp_region` VALUES ('5142', '嘎亥图镇', '4', '5139');
INSERT INTO `tp_region` VALUES ('5143', '巨日合镇', '4', '5139');
INSERT INTO `tp_region` VALUES ('5144', '巴雅尔图胡硕镇', '4', '5139');
INSERT INTO `tp_region` VALUES ('5145', '香山镇', '4', '5139');
INSERT INTO `tp_region` VALUES ('5146', '阿日昆都冷镇', '4', '5139');
INSERT INTO `tp_region` VALUES ('5147', '巴彦塔拉苏木乡', '4', '5139');
INSERT INTO `tp_region` VALUES ('5148', '乌力吉木仁苏木乡', '4', '5139');
INSERT INTO `tp_region` VALUES ('5149', '道老杜苏木乡', '4', '5139');
INSERT INTO `tp_region` VALUES ('5150', '格日朝鲁苏木乡', '4', '5139');
INSERT INTO `tp_region` VALUES ('5151', '乌额格其牧场', '4', '5139');
INSERT INTO `tp_region` VALUES ('5152', '香山农场', '4', '5139');
INSERT INTO `tp_region` VALUES ('5153', '乌日根塔拉农场', '4', '5139');
INSERT INTO `tp_region` VALUES ('5154', '嘎达苏种畜场', '4', '5139');
INSERT INTO `tp_region` VALUES ('5155', '霍林郭勒市', '3', '5029');
INSERT INTO `tp_region` VALUES ('5156', '珠斯花街道', '4', '5155');
INSERT INTO `tp_region` VALUES ('5157', '莫斯台街道', '4', '5155');
INSERT INTO `tp_region` VALUES ('5158', '宝日呼吉尔街道', '4', '5155');
INSERT INTO `tp_region` VALUES ('5159', '沙尔呼热街道', '4', '5155');
INSERT INTO `tp_region` VALUES ('5160', '达来胡硕街道', '4', '5155');
INSERT INTO `tp_region` VALUES ('5161', '东蒙农牧业有限责任公司', '4', '5155');
INSERT INTO `tp_region` VALUES ('5162', '鄂尔多斯市', '2', '4670');
INSERT INTO `tp_region` VALUES ('5163', '东胜区', '3', '5162');
INSERT INTO `tp_region` VALUES ('5164', '交通街道', '4', '5163');
INSERT INTO `tp_region` VALUES ('5165', '公园街道', '4', '5163');
INSERT INTO `tp_region` VALUES ('5166', '林荫街道', '4', '5163');
INSERT INTO `tp_region` VALUES ('5167', '建设街道', '4', '5163');
INSERT INTO `tp_region` VALUES ('5168', '富兴街道', '4', '5163');
INSERT INTO `tp_region` VALUES ('5169', '天骄街道', '4', '5163');
INSERT INTO `tp_region` VALUES ('5170', '哈巴格希街道', '4', '5163');
INSERT INTO `tp_region` VALUES ('5171', '诃额伦街道', '4', '5163');
INSERT INTO `tp_region` VALUES ('5172', '巴音孟克街道', '4', '5163');
INSERT INTO `tp_region` VALUES ('5173', '泊尔江海子镇', '4', '5163');
INSERT INTO `tp_region` VALUES ('5174', '罕台镇', '4', '5163');
INSERT INTO `tp_region` VALUES ('5175', '塔拉壕镇', '4', '5163');
INSERT INTO `tp_region` VALUES ('5176', '达拉特旗', '3', '5162');
INSERT INTO `tp_region` VALUES ('5177', '树林召镇', '4', '5176');
INSERT INTO `tp_region` VALUES ('5178', '吉格斯太镇', '4', '5176');
INSERT INTO `tp_region` VALUES ('5179', '白泥井镇', '4', '5176');
INSERT INTO `tp_region` VALUES ('5180', '王爱召镇', '4', '5176');
INSERT INTO `tp_region` VALUES ('5181', '昭君镇', '4', '5176');
INSERT INTO `tp_region` VALUES ('5182', '恩格贝镇', '4', '5176');
INSERT INTO `tp_region` VALUES ('5183', '中和西镇', '4', '5176');
INSERT INTO `tp_region` VALUES ('5184', '展旦召苏木乡', '4', '5176');
INSERT INTO `tp_region` VALUES ('5185', '准格尔旗', '3', '5162');
INSERT INTO `tp_region` VALUES ('5186', '薛家湾镇', '4', '5185');
INSERT INTO `tp_region` VALUES ('5187', '沙圪堵镇', '4', '5185');
INSERT INTO `tp_region` VALUES ('5188', '大路镇', '4', '5185');
INSERT INTO `tp_region` VALUES ('5189', '纳日松镇', '4', '5185');
INSERT INTO `tp_region` VALUES ('5190', '龙口镇', '4', '5185');
INSERT INTO `tp_region` VALUES ('5191', '准格尔召镇', '4', '5185');
INSERT INTO `tp_region` VALUES ('5192', '暖水乡', '4', '5185');
INSERT INTO `tp_region` VALUES ('5193', '十二连城乡', '4', '5185');
INSERT INTO `tp_region` VALUES ('5194', '布尔陶亥苏木乡', '4', '5185');
INSERT INTO `tp_region` VALUES ('5195', '鄂托克前旗', '3', '5162');
INSERT INTO `tp_region` VALUES ('5196', '敖勒召其镇', '4', '5195');
INSERT INTO `tp_region` VALUES ('5197', '上海庙镇', '4', '5195');
INSERT INTO `tp_region` VALUES ('5198', '城川镇', '4', '5195');
INSERT INTO `tp_region` VALUES ('5199', '昂素镇', '4', '5195');
INSERT INTO `tp_region` VALUES ('5200', '上海庙经济开发区', '4', '5195');
INSERT INTO `tp_region` VALUES ('5201', '鄂托克旗', '3', '5162');
INSERT INTO `tp_region` VALUES ('5202', '乌兰镇', '4', '5201');
INSERT INTO `tp_region` VALUES ('5203', '棋盘井镇', '4', '5201');
INSERT INTO `tp_region` VALUES ('5204', '蒙西镇', '4', '5201');
INSERT INTO `tp_region` VALUES ('5205', '木凯淖尔镇', '4', '5201');
INSERT INTO `tp_region` VALUES ('5206', '苏米图苏木乡', '4', '5201');
INSERT INTO `tp_region` VALUES ('5207', '阿尔巴斯苏木乡', '4', '5201');
INSERT INTO `tp_region` VALUES ('5208', '鄂托克旗赛乌素草籽场', '4', '5201');
INSERT INTO `tp_region` VALUES ('5209', '内蒙古白绒山羊种羊场', '4', '5201');
INSERT INTO `tp_region` VALUES ('5210', '杭锦旗', '3', '5162');
INSERT INTO `tp_region` VALUES ('5211', '锡尼镇', '4', '5210');
INSERT INTO `tp_region` VALUES ('5212', '巴拉贡镇', '4', '5210');
INSERT INTO `tp_region` VALUES ('5213', '吉日嘎朗图镇', '4', '5210');
INSERT INTO `tp_region` VALUES ('5214', '独贵塔拉镇', '4', '5210');
INSERT INTO `tp_region` VALUES ('5215', '呼和木都镇', '4', '5210');
INSERT INTO `tp_region` VALUES ('5216', '杭锦淖尔乡', '4', '5210');
INSERT INTO `tp_region` VALUES ('5217', '伊和乌素苏木乡', '4', '5210');
INSERT INTO `tp_region` VALUES ('5218', '哈拉淖农场', '4', '5210');
INSERT INTO `tp_region` VALUES ('5219', '乌审旗', '3', '5162');
INSERT INTO `tp_region` VALUES ('5220', '嘎鲁图镇', '4', '5219');
INSERT INTO `tp_region` VALUES ('5221', '乌审召镇', '4', '5219');
INSERT INTO `tp_region` VALUES ('5222', '图克镇', '4', '5219');
INSERT INTO `tp_region` VALUES ('5223', '乌兰陶勒盖镇', '4', '5219');
INSERT INTO `tp_region` VALUES ('5224', '无定河镇', '4', '5219');
INSERT INTO `tp_region` VALUES ('5225', '苏力德苏木乡', '4', '5219');
INSERT INTO `tp_region` VALUES ('5226', '种羊场', '4', '5219');
INSERT INTO `tp_region` VALUES ('5227', '五个林场', '4', '5219');
INSERT INTO `tp_region` VALUES ('5228', '伊金霍洛旗', '3', '5162');
INSERT INTO `tp_region` VALUES ('5229', '阿勒腾席热镇', '4', '5228');
INSERT INTO `tp_region` VALUES ('5230', '札萨克镇', '4', '5228');
INSERT INTO `tp_region` VALUES ('5231', '乌兰木伦镇', '4', '5228');
INSERT INTO `tp_region` VALUES ('5232', '纳林陶亥镇', '4', '5228');
INSERT INTO `tp_region` VALUES ('5233', '苏布尔嘎镇', '4', '5228');
INSERT INTO `tp_region` VALUES ('5234', '红庆河镇', '4', '5228');
INSERT INTO `tp_region` VALUES ('5235', '伊金霍洛镇', '4', '5228');
INSERT INTO `tp_region` VALUES ('5236', '呼伦贝尔市', '2', '4670');
INSERT INTO `tp_region` VALUES ('5237', '市辖区', '3', '5236');
INSERT INTO `tp_region` VALUES ('5238', '海拉尔区', '3', '5236');
INSERT INTO `tp_region` VALUES ('5239', '正阳', '4', '5238');
INSERT INTO `tp_region` VALUES ('5240', '健康街道', '4', '5238');
INSERT INTO `tp_region` VALUES ('5241', '靠山街道', '4', '5238');
INSERT INTO `tp_region` VALUES ('5242', '胜利街道', '4', '5238');
INSERT INTO `tp_region` VALUES ('5243', '呼伦街道', '4', '5238');
INSERT INTO `tp_region` VALUES ('5244', '奋斗街道', '4', '5238');
INSERT INTO `tp_region` VALUES ('5245', '建设街道', '4', '5238');
INSERT INTO `tp_region` VALUES ('5246', '哈克镇', '4', '5238');
INSERT INTO `tp_region` VALUES ('5247', '谢尔塔拉种牛场', '4', '5238');
INSERT INTO `tp_region` VALUES ('5248', '哈克牧业有限公司', '4', '5238');
INSERT INTO `tp_region` VALUES ('5249', '阿荣旗', '3', '5236');
INSERT INTO `tp_region` VALUES ('5250', '那吉镇', '4', '5249');
INSERT INTO `tp_region` VALUES ('5251', '六合镇', '4', '5249');
INSERT INTO `tp_region` VALUES ('5252', '亚东镇', '4', '5249');
INSERT INTO `tp_region` VALUES ('5253', '霍尔奇镇', '4', '5249');
INSERT INTO `tp_region` VALUES ('5254', '向阳峪镇', '4', '5249');
INSERT INTO `tp_region` VALUES ('5255', '得力其鄂温克民族乡', '4', '5249');
INSERT INTO `tp_region` VALUES ('5256', '查巴奇鄂温克民族乡', '4', '5249');
INSERT INTO `tp_region` VALUES ('5257', '音河达斡尔鄂温克民族乡', '4', '5249');
INSERT INTO `tp_region` VALUES ('5258', '新发朝鲜民族乡', '4', '5249');
INSERT INTO `tp_region` VALUES ('5259', '那吉屯农场', '4', '5249');
INSERT INTO `tp_region` VALUES ('5260', '格尼河农场', '4', '5249');
INSERT INTO `tp_region` VALUES ('5261', '阿荣旗林业局', '4', '5249');
INSERT INTO `tp_region` VALUES ('5262', '莫力达瓦达斡尔族自治旗', '3', '5236');
INSERT INTO `tp_region` VALUES ('5263', '尼尔基镇', '4', '5262');
INSERT INTO `tp_region` VALUES ('5264', '红彦镇', '4', '5262');
INSERT INTO `tp_region` VALUES ('5265', '宝山镇', '4', '5262');
INSERT INTO `tp_region` VALUES ('5266', '哈达阳镇', '4', '5262');
INSERT INTO `tp_region` VALUES ('5267', '阿尔拉镇', '4', '5262');
INSERT INTO `tp_region` VALUES ('5268', '西瓦尔图镇', '4', '5262');
INSERT INTO `tp_region` VALUES ('5269', '腾克镇', '4', '5262');
INSERT INTO `tp_region` VALUES ('5270', '塔温敖宝镇', '4', '5262');
INSERT INTO `tp_region` VALUES ('5271', '巴彦鄂温克民族乡', '4', '5262');
INSERT INTO `tp_region` VALUES ('5272', '杜拉尔鄂温克民族乡', '4', '5262');
INSERT INTO `tp_region` VALUES ('5273', '国营甘河农场', '4', '5262');
INSERT INTO `tp_region` VALUES ('5274', '国营巴彦农场', '4', '5262');
INSERT INTO `tp_region` VALUES ('5275', '国营欧肯河农场', '4', '5262');
INSERT INTO `tp_region` VALUES ('5276', '国营东方红农场', '4', '5262');
INSERT INTO `tp_region` VALUES ('5277', '鄂伦春自治旗', '3', '5236');
INSERT INTO `tp_region` VALUES ('5278', '阿里河镇', '4', '5277');
INSERT INTO `tp_region` VALUES ('5279', '大杨树镇', '4', '5277');
INSERT INTO `tp_region` VALUES ('5280', '甘河镇', '4', '5277');
INSERT INTO `tp_region` VALUES ('5281', '托扎敏镇', '4', '5277');
INSERT INTO `tp_region` VALUES ('5282', '诺敏镇', '4', '5277');
INSERT INTO `tp_region` VALUES ('5283', '乌鲁布铁镇', '4', '5277');
INSERT INTO `tp_region` VALUES ('5284', '古里乡', '4', '5277');
INSERT INTO `tp_region` VALUES ('5285', '大兴安岭管理局诺敏河农场', '4', '5277');
INSERT INTO `tp_region` VALUES ('5286', '大兴安岭农场宜里农场', '4', '5277');
INSERT INTO `tp_region` VALUES ('5287', '大兴安岭农场管理局扎赉河农场', '4', '5277');
INSERT INTO `tp_region` VALUES ('5288', '大兴安岭农场管理局古里农场', '4', '5277');
INSERT INTO `tp_region` VALUES ('5289', '加格达奇区', '4', '5277');
INSERT INTO `tp_region` VALUES ('5290', '松岭地区', '4', '5277');
INSERT INTO `tp_region` VALUES ('5291', '大杨树林业局', '4', '5277');
INSERT INTO `tp_region` VALUES ('5292', '甘河林业局', '4', '5277');
INSERT INTO `tp_region` VALUES ('5293', '克一河林业局', '4', '5277');
INSERT INTO `tp_region` VALUES ('5294', '吉文林业局', '4', '5277');
INSERT INTO `tp_region` VALUES ('5295', '阿里河林业局', '4', '5277');
INSERT INTO `tp_region` VALUES ('5296', '大兴安岭农工商联合公司', '4', '5277');
INSERT INTO `tp_region` VALUES ('5297', '大兴安岭农场管理局东方红农场', '4', '5277');
INSERT INTO `tp_region` VALUES ('5298', '大兴安岭农场管理局欧肯河农场', '4', '5277');
INSERT INTO `tp_region` VALUES ('5299', '大兴安岭林管局毕拉河林业局', '4', '5277');
INSERT INTO `tp_region` VALUES ('5300', '大兴安岭林管局伊图里河林业局', '4', '5277');
INSERT INTO `tp_region` VALUES ('5301', '大兴安岭林管局库都尔林业局', '4', '5277');
INSERT INTO `tp_region` VALUES ('5302', '大兴安岭林管局乌尔其汗林业局', '4', '5277');
INSERT INTO `tp_region` VALUES ('5303', '鄂温克族自治旗', '3', '5236');
INSERT INTO `tp_region` VALUES ('5304', '巴彦托海镇', '4', '5303');
INSERT INTO `tp_region` VALUES ('5305', '巴雁镇', '4', '5303');
INSERT INTO `tp_region` VALUES ('5306', '伊敏河镇', '4', '5303');
INSERT INTO `tp_region` VALUES ('5307', '锡尼河镇', '4', '5303');
INSERT INTO `tp_region` VALUES ('5308', '巴彦塔拉达斡尔民族乡', '4', '5303');
INSERT INTO `tp_region` VALUES ('5309', '伊敏苏木乡', '4', '5303');
INSERT INTO `tp_region` VALUES ('5310', '辉苏木乡', '4', '5303');
INSERT INTO `tp_region` VALUES ('5311', '巴彦托海经济开发区', '4', '5303');
INSERT INTO `tp_region` VALUES ('5312', '伊敏河高载能工业园区', '4', '5303');
INSERT INTO `tp_region` VALUES ('5313', '大雁马铃薯高新技术示范园区', '4', '5303');
INSERT INTO `tp_region` VALUES ('5314', '陈巴尔虎旗镇', '3', '5236');
INSERT INTO `tp_region` VALUES ('5315', '陈旗巴彦库仁镇', '4', '5314');
INSERT INTO `tp_region` VALUES ('5316', '陈旗宝日希勒镇', '4', '5314');
INSERT INTO `tp_region` VALUES ('5317', '陈旗呼和诺尔镇', '4', '5314');
INSERT INTO `tp_region` VALUES ('5318', '陈旗乌珠尔苏木乡', '4', '5314');
INSERT INTO `tp_region` VALUES ('5319', '陈旗鄂温克民族苏木乡', '4', '5314');
INSERT INTO `tp_region` VALUES ('5320', '陈旗国营哈达图农牧场', '4', '5314');
INSERT INTO `tp_region` VALUES ('5321', '陈旗国营浩特陶海农牧场', '4', '5314');
INSERT INTO `tp_region` VALUES ('5322', '陈旗国营特泥河农牧场', '4', '5314');
INSERT INTO `tp_region` VALUES ('5323', '新巴尔虎左旗', '3', '5236');
INSERT INTO `tp_region` VALUES ('5324', '阿木古郎镇', '4', '5323');
INSERT INTO `tp_region` VALUES ('5325', '嵯岗镇', '4', '5323');
INSERT INTO `tp_region` VALUES ('5326', '乌布尔宝力格苏木乡', '4', '5323');
INSERT INTO `tp_region` VALUES ('5327', '吉布胡郎图苏木乡', '4', '5323');
INSERT INTO `tp_region` VALUES ('5328', '新宝力格苏木乡', '4', '5323');
INSERT INTO `tp_region` VALUES ('5329', '嵯岗镇双娃牧场', '4', '5323');
INSERT INTO `tp_region` VALUES ('5330', '新巴尔虎右旗', '3', '5236');
INSERT INTO `tp_region` VALUES ('5331', '阿拉坦额莫勒镇', '4', '5330');
INSERT INTO `tp_region` VALUES ('5332', '阿日哈沙特镇', '4', '5330');
INSERT INTO `tp_region` VALUES ('5333', '新巴尔虎右旗呼伦镇', '4', '5330');
INSERT INTO `tp_region` VALUES ('5334', '贝尔苏木乡', '4', '5330');
INSERT INTO `tp_region` VALUES ('5335', '克尔伦苏木乡', '4', '5330');
INSERT INTO `tp_region` VALUES ('5336', '敖尔金牧场', '4', '5330');
INSERT INTO `tp_region` VALUES ('5337', '满洲里市', '3', '5236');
INSERT INTO `tp_region` VALUES ('5338', '东山街道', '4', '5337');
INSERT INTO `tp_region` VALUES ('5339', '道南街道', '4', '5337');
INSERT INTO `tp_region` VALUES ('5340', '道北街道', '4', '5337');
INSERT INTO `tp_region` VALUES ('5341', '兴华街道', '4', '5337');
INSERT INTO `tp_region` VALUES ('5342', '满洲里市第一', '4', '5337');
INSERT INTO `tp_region` VALUES ('5343', '满洲里市第二', '4', '5337');
INSERT INTO `tp_region` VALUES ('5344', '满洲里市第三', '4', '5337');
INSERT INTO `tp_region` VALUES ('5345', '满洲里市第四', '4', '5337');
INSERT INTO `tp_region` VALUES ('5346', '满洲里市第五', '4', '5337');
INSERT INTO `tp_region` VALUES ('5347', '满洲里市灵泉街道', '4', '5337');
INSERT INTO `tp_region` VALUES ('5348', '新开河街道', '4', '5337');
INSERT INTO `tp_region` VALUES ('5349', '满洲里市互市贸易区', '4', '5337');
INSERT INTO `tp_region` VALUES ('5350', '满洲里市经济合作区', '4', '5337');
INSERT INTO `tp_region` VALUES ('5351', '满洲里市东湖区', '4', '5337');
INSERT INTO `tp_region` VALUES ('5352', '满洲里市扎煤公司', '4', '5337');
INSERT INTO `tp_region` VALUES ('5353', '扎赉诺尔矿区', '4', '5337');
INSERT INTO `tp_region` VALUES ('5354', '牙克石市', '3', '5236');
INSERT INTO `tp_region` VALUES ('5355', '胜利街道', '4', '5354');
INSERT INTO `tp_region` VALUES ('5356', '红旗街道', '4', '5354');
INSERT INTO `tp_region` VALUES ('5357', '新工街道', '4', '5354');
INSERT INTO `tp_region` VALUES ('5358', '永兴街道', '4', '5354');
INSERT INTO `tp_region` VALUES ('5359', '建设街道', '4', '5354');
INSERT INTO `tp_region` VALUES ('5360', '暖泉街道', '4', '5354');
INSERT INTO `tp_region` VALUES ('5361', '牧原街道', '4', '5354');
INSERT INTO `tp_region` VALUES ('5362', '免渡河镇', '4', '5354');
INSERT INTO `tp_region` VALUES ('5363', '博克图镇', '4', '5354');
INSERT INTO `tp_region` VALUES ('5364', '绰源镇', '4', '5354');
INSERT INTO `tp_region` VALUES ('5365', '乌尔其汉镇', '4', '5354');
INSERT INTO `tp_region` VALUES ('5366', '库都尔镇', '4', '5354');
INSERT INTO `tp_region` VALUES ('5367', '图里河镇', '4', '5354');
INSERT INTO `tp_region` VALUES ('5368', '莫拐农场', '4', '5354');
INSERT INTO `tp_region` VALUES ('5369', '牙克石农场', '4', '5354');
INSERT INTO `tp_region` VALUES ('5370', '免渡河农场', '4', '5354');
INSERT INTO `tp_region` VALUES ('5371', '扎兰屯市', '3', '5236');
INSERT INTO `tp_region` VALUES ('5372', '兴华街道', '4', '5371');
INSERT INTO `tp_region` VALUES ('5373', '正阳街道', '4', '5371');
INSERT INTO `tp_region` VALUES ('5374', '繁荣街道', '4', '5371');
INSERT INTO `tp_region` VALUES ('5375', '向阳街道', '4', '5371');
INSERT INTO `tp_region` VALUES ('5376', '高台子街道', '4', '5371');
INSERT INTO `tp_region` VALUES ('5377', '铁东街道', '4', '5371');
INSERT INTO `tp_region` VALUES ('5378', '河西街道', '4', '5371');
INSERT INTO `tp_region` VALUES ('5379', '磨菇气镇', '4', '5371');
INSERT INTO `tp_region` VALUES ('5380', '洼堤镇', '4', '5371');
INSERT INTO `tp_region` VALUES ('5381', '卧牛河镇', '4', '5371');
INSERT INTO `tp_region` VALUES ('5382', '成吉思汗镇', '4', '5371');
INSERT INTO `tp_region` VALUES ('5383', '大河湾镇', '4', '5371');
INSERT INTO `tp_region` VALUES ('5384', '浩饶山镇', '4', '5371');
INSERT INTO `tp_region` VALUES ('5385', '达斡尔民族乡', '4', '5371');
INSERT INTO `tp_region` VALUES ('5386', '南木鄂伦春民族乡', '4', '5371');
INSERT INTO `tp_region` VALUES ('5387', '萨马街鄂温克民族乡', '4', '5371');
INSERT INTO `tp_region` VALUES ('5388', '大河湾农场', '4', '5371');
INSERT INTO `tp_region` VALUES ('5389', '绰尔河农场', '4', '5371');
INSERT INTO `tp_region` VALUES ('5390', '扎兰屯马场', '4', '5371');
INSERT INTO `tp_region` VALUES ('5391', '成吉思汗监狱农场', '4', '5371');
INSERT INTO `tp_region` VALUES ('5392', '公安部后勤供应处农场', '4', '5371');
INSERT INTO `tp_region` VALUES ('5393', '南木林业局', '4', '5371');
INSERT INTO `tp_region` VALUES ('5394', '柴河林业局', '4', '5371');
INSERT INTO `tp_region` VALUES ('5395', '扎兰屯市林业局', '4', '5371');
INSERT INTO `tp_region` VALUES ('5396', '市原种场', '4', '5371');
INSERT INTO `tp_region` VALUES ('5397', '额尔古纳市', '3', '5236');
INSERT INTO `tp_region` VALUES ('5398', '拉布达林街道', '4', '5397');
INSERT INTO `tp_region` VALUES ('5399', '上库力街道', '4', '5397');
INSERT INTO `tp_region` VALUES ('5400', '莫尔道嘎镇', '4', '5397');
INSERT INTO `tp_region` VALUES ('5401', '黑山头镇', '4', '5397');
INSERT INTO `tp_region` VALUES ('5402', '三河回族乡', '4', '5397');
INSERT INTO `tp_region` VALUES ('5403', '室韦俄罗斯族民族乡', '4', '5397');
INSERT INTO `tp_region` VALUES ('5404', '海拉尔农垦集团有限公司拉布大林农场分公司', '4', '5397');
INSERT INTO `tp_region` VALUES ('5405', '三河金騋农牧有限责任公司', '4', '5397');
INSERT INTO `tp_region` VALUES ('5406', '海拉尔农垦集团有限责任公司上库力农场分公司', '4', '5397');
INSERT INTO `tp_region` VALUES ('5407', '海拉尔农垦集团有限责任公司苏沁牧场分公司', '4', '5397');
INSERT INTO `tp_region` VALUES ('5408', '海拉尔农垦集团有限责任公司恩和牧场分公司', '4', '5397');
INSERT INTO `tp_region` VALUES ('5409', '室韦牧场', '4', '5397');
INSERT INTO `tp_region` VALUES ('5410', '根河市', '3', '5236');
INSERT INTO `tp_region` VALUES ('5411', '河东街道', '4', '5410');
INSERT INTO `tp_region` VALUES ('5412', '河西街道', '4', '5410');
INSERT INTO `tp_region` VALUES ('5413', '森工路街道', '4', '5410');
INSERT INTO `tp_region` VALUES ('5414', '金河镇', '4', '5410');
INSERT INTO `tp_region` VALUES ('5415', '阿龙山镇', '4', '5410');
INSERT INTO `tp_region` VALUES ('5416', '满归镇', '4', '5410');
INSERT INTO `tp_region` VALUES ('5417', '敖鲁古雅乡', '4', '5410');
INSERT INTO `tp_region` VALUES ('5418', '巴彦淖尔市', '2', '4670');
INSERT INTO `tp_region` VALUES ('5419', '市辖区', '3', '5418');
INSERT INTO `tp_region` VALUES ('5420', '临河区', '3', '5418');
INSERT INTO `tp_region` VALUES ('5421', '团结', '4', '5420');
INSERT INTO `tp_region` VALUES ('5422', '车站', '4', '5420');
INSERT INTO `tp_region` VALUES ('5423', '先锋', '4', '5420');
INSERT INTO `tp_region` VALUES ('5424', '解放', '4', '5420');
INSERT INTO `tp_region` VALUES ('5425', '新华', '4', '5420');
INSERT INTO `tp_region` VALUES ('5426', '东环', '4', '5420');
INSERT INTO `tp_region` VALUES ('5427', '铁南', '4', '5420');
INSERT INTO `tp_region` VALUES ('5428', '西环路', '4', '5420');
INSERT INTO `tp_region` VALUES ('5429', '北环', '4', '5420');
INSERT INTO `tp_region` VALUES ('5430', '曙光', '4', '5420');
INSERT INTO `tp_region` VALUES ('5431', '狼山镇', '4', '5420');
INSERT INTO `tp_region` VALUES ('5432', '新华镇', '4', '5420');
INSERT INTO `tp_region` VALUES ('5433', '干召庙镇', '4', '5420');
INSERT INTO `tp_region` VALUES ('5434', '乌兰图克镇', '4', '5420');
INSERT INTO `tp_region` VALUES ('5435', '双河镇', '4', '5420');
INSERT INTO `tp_region` VALUES ('5436', '城关镇', '4', '5420');
INSERT INTO `tp_region` VALUES ('5437', '白脑包镇', '4', '5420');
INSERT INTO `tp_region` VALUES ('5438', '狼山农场', '4', '5420');
INSERT INTO `tp_region` VALUES ('5439', '临河农场', '4', '5420');
INSERT INTO `tp_region` VALUES ('5440', '五原县', '3', '5418');
INSERT INTO `tp_region` VALUES ('5441', '隆兴昌镇', '4', '5440');
INSERT INTO `tp_region` VALUES ('5442', '塔尔湖镇', '4', '5440');
INSERT INTO `tp_region` VALUES ('5443', '套海镇', '4', '5440');
INSERT INTO `tp_region` VALUES ('5444', '新公中镇', '4', '5440');
INSERT INTO `tp_region` VALUES ('5445', '天吉太镇', '4', '5440');
INSERT INTO `tp_region` VALUES ('5446', '胜丰镇', '4', '5440');
INSERT INTO `tp_region` VALUES ('5447', '银定图镇', '4', '5440');
INSERT INTO `tp_region` VALUES ('5448', '巴盟国营建丰农场', '4', '5440');
INSERT INTO `tp_region` VALUES ('5449', '内蒙古东土城劳动教养管理所', '4', '5440');
INSERT INTO `tp_region` VALUES ('5450', '磴口县', '3', '5418');
INSERT INTO `tp_region` VALUES ('5451', '巴彦高勒镇', '4', '5450');
INSERT INTO `tp_region` VALUES ('5452', '隆盛合镇', '4', '5450');
INSERT INTO `tp_region` VALUES ('5453', '渡口镇', '4', '5450');
INSERT INTO `tp_region` VALUES ('5454', '沙金套海苏木乡', '4', '5450');
INSERT INTO `tp_region` VALUES ('5455', '乌兰布和农场', '4', '5450');
INSERT INTO `tp_region` VALUES ('5456', '巴彦套海农场', '4', '5450');
INSERT INTO `tp_region` VALUES ('5457', '哈腾套海农场', '4', '5450');
INSERT INTO `tp_region` VALUES ('5458', '包尔盖农场', '4', '5450');
INSERT INTO `tp_region` VALUES ('5459', '纳林套海农场', '4', '5450');
INSERT INTO `tp_region` VALUES ('5460', '沙漠林业实验中心', '4', '5450');
INSERT INTO `tp_region` VALUES ('5461', '乌拉特前旗', '3', '5418');
INSERT INTO `tp_region` VALUES ('5462', '乌拉山镇', '4', '5461');
INSERT INTO `tp_region` VALUES ('5463', '白彦花镇', '4', '5461');
INSERT INTO `tp_region` VALUES ('5464', '先锋镇', '4', '5461');
INSERT INTO `tp_region` VALUES ('5465', '新安镇', '4', '5461');
INSERT INTO `tp_region` VALUES ('5466', '西小召镇', '4', '5461');
INSERT INTO `tp_region` VALUES ('5467', '大佘太镇', '4', '5461');
INSERT INTO `tp_region` VALUES ('5468', '明安镇', '4', '5461');
INSERT INTO `tp_region` VALUES ('5469', '小佘太镇', '4', '5461');
INSERT INTO `tp_region` VALUES ('5470', '额尔登布拉格苏木乡', '4', '5461');
INSERT INTO `tp_region` VALUES ('5471', '巴彦淖尔市中滩农场', '4', '5461');
INSERT INTO `tp_region` VALUES ('5472', '巴彦淖尔市西山咀农场', '4', '5461');
INSERT INTO `tp_region` VALUES ('5473', '巴彦淖尔市新安农场', '4', '5461');
INSERT INTO `tp_region` VALUES ('5474', '巴彦淖尔市苏独仑农场', '4', '5461');
INSERT INTO `tp_region` VALUES ('5475', '巴彦淖尔市大佘太牧场', '4', '5461');
INSERT INTO `tp_region` VALUES ('5476', '巴彦淖尔市乌梁素海渔场', '4', '5461');
INSERT INTO `tp_region` VALUES ('5477', '乌拉特中旗', '3', '5418');
INSERT INTO `tp_region` VALUES ('5478', '海流图镇', '4', '5477');
INSERT INTO `tp_region` VALUES ('5479', '乌加河镇', '4', '5477');
INSERT INTO `tp_region` VALUES ('5480', '德岭山镇', '4', '5477');
INSERT INTO `tp_region` VALUES ('5481', '石哈河镇', '4', '5477');
INSERT INTO `tp_region` VALUES ('5482', '呼鲁斯太苏木乡', '4', '5477');
INSERT INTO `tp_region` VALUES ('5483', '川井苏木乡', '4', '5477');
INSERT INTO `tp_region` VALUES ('5484', '巴音乌兰苏木乡', '4', '5477');
INSERT INTO `tp_region` VALUES ('5485', '新忽热苏木乡', '4', '5477');
INSERT INTO `tp_region` VALUES ('5486', '牧羊海牧场', '4', '5477');
INSERT INTO `tp_region` VALUES ('5487', '同和太种畜场', '4', '5477');
INSERT INTO `tp_region` VALUES ('5488', '巴盟乌北林场', '4', '5477');
INSERT INTO `tp_region` VALUES ('5489', '乌拉特后旗', '3', '5418');
INSERT INTO `tp_region` VALUES ('5490', '巴音宝力格镇', '4', '5489');
INSERT INTO `tp_region` VALUES ('5491', '呼和温都尔镇', '4', '5489');
INSERT INTO `tp_region` VALUES ('5492', '潮格温都尔镇', '4', '5489');
INSERT INTO `tp_region` VALUES ('5493', '获各琦苏木乡', '4', '5489');
INSERT INTO `tp_region` VALUES ('5494', '巴音前达门苏木乡', '4', '5489');
INSERT INTO `tp_region` VALUES ('5495', '杭锦后旗', '3', '5418');
INSERT INTO `tp_region` VALUES ('5496', '陕坝镇', '4', '5495');
INSERT INTO `tp_region` VALUES ('5497', '头道桥镇', '4', '5495');
INSERT INTO `tp_region` VALUES ('5498', '二道桥镇', '4', '5495');
INSERT INTO `tp_region` VALUES ('5499', '三道桥镇', '4', '5495');
INSERT INTO `tp_region` VALUES ('5500', '蛮会镇', '4', '5495');
INSERT INTO `tp_region` VALUES ('5501', '团结镇', '4', '5495');
INSERT INTO `tp_region` VALUES ('5502', '双庙镇', '4', '5495');
INSERT INTO `tp_region` VALUES ('5503', '沙海镇', '4', '5495');
INSERT INTO `tp_region` VALUES ('5504', '巴市太阳庙农场', '4', '5495');
INSERT INTO `tp_region` VALUES ('5505', '乌兰察布市', '2', '4670');
INSERT INTO `tp_region` VALUES ('5506', '市辖区', '3', '5505');
INSERT INTO `tp_region` VALUES ('5507', '集宁区', '3', '5505');
INSERT INTO `tp_region` VALUES ('5508', '新体路街道', '4', '5507');
INSERT INTO `tp_region` VALUES ('5509', '桥东街道', '4', '5507');
INSERT INTO `tp_region` VALUES ('5510', '前进路街道', '4', '5507');
INSERT INTO `tp_region` VALUES ('5511', '常青街道', '4', '5507');
INSERT INTO `tp_region` VALUES ('5512', '虎山街道', '4', '5507');
INSERT INTO `tp_region` VALUES ('5513', '桥西街道', '4', '5507');
INSERT INTO `tp_region` VALUES ('5514', '新华街街道', '4', '5507');
INSERT INTO `tp_region` VALUES ('5515', '泉山街道', '4', '5507');
INSERT INTO `tp_region` VALUES ('5516', '白海子镇', '4', '5507');
INSERT INTO `tp_region` VALUES ('5517', '马莲渠乡', '4', '5507');
INSERT INTO `tp_region` VALUES ('5518', '卓资县', '3', '5505');
INSERT INTO `tp_region` VALUES ('5519', '卓资山镇', '4', '5518');
INSERT INTO `tp_region` VALUES ('5520', '旗下营镇', '4', '5518');
INSERT INTO `tp_region` VALUES ('5521', '十八台镇', '4', '5518');
INSERT INTO `tp_region` VALUES ('5522', '巴音锡勒镇', '4', '5518');
INSERT INTO `tp_region` VALUES ('5523', '梨花镇', '4', '5518');
INSERT INTO `tp_region` VALUES ('5524', '大榆树乡', '4', '5518');
INSERT INTO `tp_region` VALUES ('5525', '红召乡', '4', '5518');
INSERT INTO `tp_region` VALUES ('5526', '化德县', '3', '5505');
INSERT INTO `tp_region` VALUES ('5527', '长顺镇', '4', '5526');
INSERT INTO `tp_region` VALUES ('5528', '朝阳镇', '4', '5526');
INSERT INTO `tp_region` VALUES ('5529', '七号镇', '4', '5526');
INSERT INTO `tp_region` VALUES ('5530', '德包图乡', '4', '5526');
INSERT INTO `tp_region` VALUES ('5531', '公腊胡洞乡', '4', '5526');
INSERT INTO `tp_region` VALUES ('5532', '商都县', '3', '5505');
INSERT INTO `tp_region` VALUES ('5533', '七台镇', '4', '5532');
INSERT INTO `tp_region` VALUES ('5534', '十八顷镇', '4', '5532');
INSERT INTO `tp_region` VALUES ('5535', '大黑沙土镇', '4', '5532');
INSERT INTO `tp_region` VALUES ('5536', '西井子镇', '4', '5532');
INSERT INTO `tp_region` VALUES ('5537', '屯垦队镇', '4', '5532');
INSERT INTO `tp_region` VALUES ('5538', '小海子镇', '4', '5532');
INSERT INTO `tp_region` VALUES ('5539', '大库伦乡', '4', '5532');
INSERT INTO `tp_region` VALUES ('5540', '卯都乡', '4', '5532');
INSERT INTO `tp_region` VALUES ('5541', '玻璃忽镜乡', '4', '5532');
INSERT INTO `tp_region` VALUES ('5542', '兴和县', '3', '5505');
INSERT INTO `tp_region` VALUES ('5543', '城关镇', '4', '5542');
INSERT INTO `tp_region` VALUES ('5544', '张皋镇', '4', '5542');
INSERT INTO `tp_region` VALUES ('5545', '赛乌素镇', '4', '5542');
INSERT INTO `tp_region` VALUES ('5546', '鄂尔栋镇', '4', '5542');
INSERT INTO `tp_region` VALUES ('5547', '店子镇', '4', '5542');
INSERT INTO `tp_region` VALUES ('5548', '大库联乡', '4', '5542');
INSERT INTO `tp_region` VALUES ('5549', '民族团结乡', '4', '5542');
INSERT INTO `tp_region` VALUES ('5550', '南部矿区管委会', '4', '5542');
INSERT INTO `tp_region` VALUES ('5551', '凉城县', '3', '5505');
INSERT INTO `tp_region` VALUES ('5552', '岱海镇', '4', '5551');
INSERT INTO `tp_region` VALUES ('5553', '六苏木镇', '4', '5551');
INSERT INTO `tp_region` VALUES ('5554', '麦胡图镇', '4', '5551');
INSERT INTO `tp_region` VALUES ('5555', '永兴镇', '4', '5551');
INSERT INTO `tp_region` VALUES ('5556', '蛮汉镇', '4', '5551');
INSERT INTO `tp_region` VALUES ('5557', '天成乡', '4', '5551');
INSERT INTO `tp_region` VALUES ('5558', '曹碾满族乡', '4', '5551');
INSERT INTO `tp_region` VALUES ('5559', '岱海循环工业发展区', '4', '5551');
INSERT INTO `tp_region` VALUES ('5560', '蛮汉山林场', '4', '5551');
INSERT INTO `tp_region` VALUES ('5561', '岱海林场', '4', '5551');
INSERT INTO `tp_region` VALUES ('5562', '察哈尔右翼前旗', '3', '5505');
INSERT INTO `tp_region` VALUES ('5563', '土贵乌拉镇', '4', '5562');
INSERT INTO `tp_region` VALUES ('5564', '平地泉镇', '4', '5562');
INSERT INTO `tp_region` VALUES ('5565', '玫瑰营镇', '4', '5562');
INSERT INTO `tp_region` VALUES ('5566', '巴音塔拉镇', '4', '5562');
INSERT INTO `tp_region` VALUES ('5567', '乌拉哈乌拉乡', '4', '5562');
INSERT INTO `tp_region` VALUES ('5568', '黄茂营乡', '4', '5562');
INSERT INTO `tp_region` VALUES ('5569', '三岔口乡', '4', '5562');
INSERT INTO `tp_region` VALUES ('5570', '移民区管委会', '4', '5562');
INSERT INTO `tp_region` VALUES ('5571', '察右中旗', '3', '5505');
INSERT INTO `tp_region` VALUES ('5572', '科布尔镇', '4', '5571');
INSERT INTO `tp_region` VALUES ('5573', '铁沙盖镇', '4', '5571');
INSERT INTO `tp_region` VALUES ('5574', '黄羊城镇', '4', '5571');
INSERT INTO `tp_region` VALUES ('5575', '广益隆镇', '4', '5571');
INSERT INTO `tp_region` VALUES ('5576', '乌素图镇', '4', '5571');
INSERT INTO `tp_region` VALUES ('5577', '大滩乡', '4', '5571');
INSERT INTO `tp_region` VALUES ('5578', '宏盘乡', '4', '5571');
INSERT INTO `tp_region` VALUES ('5579', '巴音乡', '4', '5571');
INSERT INTO `tp_region` VALUES ('5580', '库联苏木乡', '4', '5571');
INSERT INTO `tp_region` VALUES ('5581', '乌兰哈页苏木乡', '4', '5571');
INSERT INTO `tp_region` VALUES ('5582', '察哈尔右翼后旗', '3', '5505');
INSERT INTO `tp_region` VALUES ('5583', '白音察干镇', '4', '5582');
INSERT INTO `tp_region` VALUES ('5584', '察哈尔右翼后旗土牧尔台镇', '4', '5582');
INSERT INTO `tp_region` VALUES ('5585', '察哈尔右翼后旗红格尔图镇', '4', '5582');
INSERT INTO `tp_region` VALUES ('5586', '察哈尔右翼后旗贲红镇', '4', '5582');
INSERT INTO `tp_region` VALUES ('5587', '察哈尔右翼后旗当郎忽洞苏木乡', '4', '5582');
INSERT INTO `tp_region` VALUES ('5588', '察哈尔右翼后旗乌兰哈达苏木乡', '4', '5582');
INSERT INTO `tp_region` VALUES ('5589', '察哈尔右翼后旗锡勒乡', '4', '5582');
INSERT INTO `tp_region` VALUES ('5590', '四子王旗', '3', '5505');
INSERT INTO `tp_region` VALUES ('5591', '四子王旗乌兰花镇', '4', '5590');
INSERT INTO `tp_region` VALUES ('5592', '四子王旗吉生太镇', '4', '5590');
INSERT INTO `tp_region` VALUES ('5593', '四子王旗库伦图镇', '4', '5590');
INSERT INTO `tp_region` VALUES ('5594', '四子王旗供济堂镇', '4', '5590');
INSERT INTO `tp_region` VALUES ('5595', '四子王旗白音朝克图镇', '4', '5590');
INSERT INTO `tp_region` VALUES ('5596', '四子王旗红格尔苏木乡', '4', '5590');
INSERT INTO `tp_region` VALUES ('5597', '四子王旗江岸苏木乡', '4', '5590');
INSERT INTO `tp_region` VALUES ('5598', '四子王旗查干补力格苏木乡', '4', '5590');
INSERT INTO `tp_region` VALUES ('5599', '四子王旗脑木更苏木乡', '4', '5590');
INSERT INTO `tp_region` VALUES ('5600', '四子王旗东八号乡', '4', '5590');
INSERT INTO `tp_region` VALUES ('5601', '四子王旗忽鸡图乡', '4', '5590');
INSERT INTO `tp_region` VALUES ('5602', '四子王旗乌兰牧场', '4', '5590');
INSERT INTO `tp_region` VALUES ('5603', '丰镇市', '3', '5505');
INSERT INTO `tp_region` VALUES ('5604', '新城区街道', '4', '5603');
INSERT INTO `tp_region` VALUES ('5605', '旧城区街道', '4', '5603');
INSERT INTO `tp_region` VALUES ('5606', '北城区街道', '4', '5603');
INSERT INTO `tp_region` VALUES ('5607', '工业区街道', '4', '5603');
INSERT INTO `tp_region` VALUES ('5608', '南城区街道', '4', '5603');
INSERT INTO `tp_region` VALUES ('5609', '隆盛庄镇', '4', '5603');
INSERT INTO `tp_region` VALUES ('5610', '黑土台镇', '4', '5603');
INSERT INTO `tp_region` VALUES ('5611', '红砂坝镇', '4', '5603');
INSERT INTO `tp_region` VALUES ('5612', '巨宝庄镇', '4', '5603');
INSERT INTO `tp_region` VALUES ('5613', '三义泉镇', '4', '5603');
INSERT INTO `tp_region` VALUES ('5614', '浑源窑乡', '4', '5603');
INSERT INTO `tp_region` VALUES ('5615', '官屯堡乡', '4', '5603');
INSERT INTO `tp_region` VALUES ('5616', '兴安盟', '2', '4670');
INSERT INTO `tp_region` VALUES ('5617', '乌兰浩特市', '3', '5616');
INSERT INTO `tp_region` VALUES ('5618', '爱国街道', '4', '5617');
INSERT INTO `tp_region` VALUES ('5619', '和平街道', '4', '5617');
INSERT INTO `tp_region` VALUES ('5620', '兴安街道', '4', '5617');
INSERT INTO `tp_region` VALUES ('5621', '胜利街道', '4', '5617');
INSERT INTO `tp_region` VALUES ('5622', '铁西街道', '4', '5617');
INSERT INTO `tp_region` VALUES ('5623', '都林街道', '4', '5617');
INSERT INTO `tp_region` VALUES ('5624', '五一街道', '4', '5617');
INSERT INTO `tp_region` VALUES ('5625', '永联街道', '4', '5617');
INSERT INTO `tp_region` VALUES ('5626', '乌兰哈达镇', '4', '5617');
INSERT INTO `tp_region` VALUES ('5627', '居力很镇', '4', '5617');
INSERT INTO `tp_region` VALUES ('5628', '乌兰哈达原种场', '4', '5617');
INSERT INTO `tp_region` VALUES ('5629', '阿尔山市', '3', '5616');
INSERT INTO `tp_region` VALUES ('5630', '林海街道', '4', '5629');
INSERT INTO `tp_region` VALUES ('5631', '新城街道', '4', '5629');
INSERT INTO `tp_region` VALUES ('5632', '温泉街道', '4', '5629');
INSERT INTO `tp_region` VALUES ('5633', '天池镇', '4', '5629');
INSERT INTO `tp_region` VALUES ('5634', '白狼镇', '4', '5629');
INSERT INTO `tp_region` VALUES ('5635', '五岔沟镇', '4', '5629');
INSERT INTO `tp_region` VALUES ('5636', '科右前旗', '3', '5616');
INSERT INTO `tp_region` VALUES ('5637', '科尔沁镇', '4', '5636');
INSERT INTO `tp_region` VALUES ('5638', '索伦镇', '4', '5636');
INSERT INTO `tp_region` VALUES ('5639', '德佰斯镇', '4', '5636');
INSERT INTO `tp_region` VALUES ('5640', '大石寨镇', '4', '5636');
INSERT INTO `tp_region` VALUES ('5641', '归流河镇', '4', '5636');
INSERT INTO `tp_region` VALUES ('5642', '葛根庙镇', '4', '5636');
INSERT INTO `tp_region` VALUES ('5643', '察尔森镇', '4', '5636');
INSERT INTO `tp_region` VALUES ('5644', '额尔格图镇', '4', '5636');
INSERT INTO `tp_region` VALUES ('5645', '满族屯满族乡', '4', '5636');
INSERT INTO `tp_region` VALUES ('5646', '乌兰毛都苏木乡', '4', '5636');
INSERT INTO `tp_region` VALUES ('5647', '阿力得尔苏木乡', '4', '5636');
INSERT INTO `tp_region` VALUES ('5648', '跃进马场', '4', '5636');
INSERT INTO `tp_region` VALUES ('5649', '索伦牧场', '4', '5636');
INSERT INTO `tp_region` VALUES ('5650', '呼和马场', '4', '5636');
INSERT INTO `tp_region` VALUES ('5651', '阿力得尔牧场', '4', '5636');
INSERT INTO `tp_region` VALUES ('5652', '公主陵牧场', '4', '5636');
INSERT INTO `tp_region` VALUES ('5653', '绿水种畜场', '4', '5636');
INSERT INTO `tp_region` VALUES ('5654', '前旗驻乌兰浩特市虚拟区域', '4', '5636');
INSERT INTO `tp_region` VALUES ('5655', '科右中旗', '3', '5616');
INSERT INTO `tp_region` VALUES ('5656', '巴彦呼舒镇', '4', '5655');
INSERT INTO `tp_region` VALUES ('5657', '巴仁哲里木镇', '4', '5655');
INSERT INTO `tp_region` VALUES ('5658', '吐列毛都镇', '4', '5655');
INSERT INTO `tp_region` VALUES ('5659', '杜尔基镇', '4', '5655');
INSERT INTO `tp_region` VALUES ('5660', '高力板镇', '4', '5655');
INSERT INTO `tp_region` VALUES ('5661', '好腰苏木镇', '4', '5655');
INSERT INTO `tp_region` VALUES ('5662', '代钦塔拉苏木乡', '4', '5655');
INSERT INTO `tp_region` VALUES ('5663', '新佳木苏木乡', '4', '5655');
INSERT INTO `tp_region` VALUES ('5664', '布敦化牧场', '4', '5655');
INSERT INTO `tp_region` VALUES ('5665', '吐列毛杜农场', '4', '5655');
INSERT INTO `tp_region` VALUES ('5666', '铅矿管理区', '4', '5655');
INSERT INTO `tp_region` VALUES ('5667', '铜矿管理区', '4', '5655');
INSERT INTO `tp_region` VALUES ('5668', '红星林场', '4', '5655');
INSERT INTO `tp_region` VALUES ('5669', '杜尔基林场', '4', '5655');
INSERT INTO `tp_region` VALUES ('5670', '义和塔拉林场', '4', '5655');
INSERT INTO `tp_region` VALUES ('5671', '代钦塔拉林场', '4', '5655');
INSERT INTO `tp_region` VALUES ('5672', '好腰苏木林场', '4', '5655');
INSERT INTO `tp_region` VALUES ('5673', '哈日努拉防火站', '4', '5655');
INSERT INTO `tp_region` VALUES ('5674', '种畜场', '4', '5655');
INSERT INTO `tp_region` VALUES ('5675', '良种繁殖场', '4', '5655');
INSERT INTO `tp_region` VALUES ('5676', '草籽繁殖场', '4', '5655');
INSERT INTO `tp_region` VALUES ('5677', '扎赉特旗', '3', '5616');
INSERT INTO `tp_region` VALUES ('5678', '音德尔镇', '4', '5677');
INSERT INTO `tp_region` VALUES ('5679', '新林镇', '4', '5677');
INSERT INTO `tp_region` VALUES ('5680', '巴彦高勒镇', '4', '5677');
INSERT INTO `tp_region` VALUES ('5681', '胡尔勒镇', '4', '5677');
INSERT INTO `tp_region` VALUES ('5682', '阿尔本格勒镇', '4', '5677');
INSERT INTO `tp_region` VALUES ('5683', '巴达尔胡镇', '4', '5677');
INSERT INTO `tp_region` VALUES ('5684', '图牧吉镇', '4', '5677');
INSERT INTO `tp_region` VALUES ('5685', '好力保乡', '4', '5677');
INSERT INTO `tp_region` VALUES ('5686', '巴彦乌兰苏木乡', '4', '5677');
INSERT INTO `tp_region` VALUES ('5687', '图牧吉劳管所', '4', '5677');
INSERT INTO `tp_region` VALUES ('5688', '内蒙劳改局东部分局', '4', '5677');
INSERT INTO `tp_region` VALUES ('5689', '种畜场', '4', '5677');
INSERT INTO `tp_region` VALUES ('5690', '八一牧场', '4', '5677');
INSERT INTO `tp_region` VALUES ('5691', '巴达尔胡农场', '4', '5677');
INSERT INTO `tp_region` VALUES ('5692', '突泉县', '3', '5616');
INSERT INTO `tp_region` VALUES ('5693', '突泉镇', '4', '5692');
INSERT INTO `tp_region` VALUES ('5694', '六户镇', '4', '5692');
INSERT INTO `tp_region` VALUES ('5695', '东杜尔基镇', '4', '5692');
INSERT INTO `tp_region` VALUES ('5696', '永安镇', '4', '5692');
INSERT INTO `tp_region` VALUES ('5697', '水泉镇', '4', '5692');
INSERT INTO `tp_region` VALUES ('5698', '宝石镇', '4', '5692');
INSERT INTO `tp_region` VALUES ('5699', '东杜尔基国营农场', '4', '5692');
INSERT INTO `tp_region` VALUES ('5700', '东杜尔基良种场', '4', '5692');
INSERT INTO `tp_region` VALUES ('5701', '莲花山铜矿', '4', '5692');
INSERT INTO `tp_region` VALUES ('5702', '锡林郭勒盟', '2', '4670');
INSERT INTO `tp_region` VALUES ('5703', '二连浩特市', '3', '5702');
INSERT INTO `tp_region` VALUES ('5704', '乌兰街道', '4', '5703');
INSERT INTO `tp_region` VALUES ('5705', '锡林街道', '4', '5703');
INSERT INTO `tp_region` VALUES ('5706', '东城街道', '4', '5703');
INSERT INTO `tp_region` VALUES ('5707', '格日勒敖都苏木乡', '4', '5703');
INSERT INTO `tp_region` VALUES ('5708', '赛乌苏科技园区', '4', '5703');
INSERT INTO `tp_region` VALUES ('5709', '锡林浩特市', '3', '5702');
INSERT INTO `tp_region` VALUES ('5710', '希日塔拉街道', '4', '5709');
INSERT INTO `tp_region` VALUES ('5711', '宝力根街道', '4', '5709');
INSERT INTO `tp_region` VALUES ('5712', '杭盖街道', '4', '5709');
INSERT INTO `tp_region` VALUES ('5713', '楚古兰街道', '4', '5709');
INSERT INTO `tp_region` VALUES ('5714', '额尔敦街道', '4', '5709');
INSERT INTO `tp_region` VALUES ('5715', '南郊街道', '4', '5709');
INSERT INTO `tp_region` VALUES ('5716', '阿尔善宝拉格镇', '4', '5709');
INSERT INTO `tp_region` VALUES ('5717', '宝力根苏木乡乡', '4', '5709');
INSERT INTO `tp_region` VALUES ('5718', '朝克乌拉苏木乡乡', '4', '5709');
INSERT INTO `tp_region` VALUES ('5719', '巴彦锡勒', '4', '5709');
INSERT INTO `tp_region` VALUES ('5720', '白音库伦牧场', '4', '5709');
INSERT INTO `tp_region` VALUES ('5721', '贝力克牧场', '4', '5709');
INSERT INTO `tp_region` VALUES ('5722', '毛登牧场', '4', '5709');
INSERT INTO `tp_region` VALUES ('5723', '阿巴嘎旗', '3', '5702');
INSERT INTO `tp_region` VALUES ('5724', '别力古台镇', '4', '5723');
INSERT INTO `tp_region` VALUES ('5725', '洪格尔高勒镇', '4', '5723');
INSERT INTO `tp_region` VALUES ('5726', '查干淖尔镇', '4', '5723');
INSERT INTO `tp_region` VALUES ('5727', '那仁宝拉格苏木乡', '4', '5723');
INSERT INTO `tp_region` VALUES ('5728', '伊和高勒苏木乡乡', '4', '5723');
INSERT INTO `tp_region` VALUES ('5729', '吉尔嘎郎图苏木乡', '4', '5723');
INSERT INTO `tp_region` VALUES ('5730', '玛尼图煤矿', '4', '5723');
INSERT INTO `tp_region` VALUES ('5731', '苏尼特左旗', '3', '5702');
INSERT INTO `tp_region` VALUES ('5732', '满都拉图镇', '4', '5731');
INSERT INTO `tp_region` VALUES ('5733', '查干敖包中心镇', '4', '5731');
INSERT INTO `tp_region` VALUES ('5734', '巴彦淖尔镇', '4', '5731');
INSERT INTO `tp_region` VALUES ('5735', '巴彦乌拉苏木乡', '4', '5731');
INSERT INTO `tp_region` VALUES ('5736', '赛罕高毕苏木乡', '4', '5731');
INSERT INTO `tp_region` VALUES ('5737', '恩格尔河灌区', '4', '5731');
INSERT INTO `tp_region` VALUES ('5738', '苏尼特右旗', '3', '5702');
INSERT INTO `tp_region` VALUES ('5739', '赛汉塔拉镇', '4', '5738');
INSERT INTO `tp_region` VALUES ('5740', '朱日和镇', '4', '5738');
INSERT INTO `tp_region` VALUES ('5741', '乌日根塔拉镇', '4', '5738');
INSERT INTO `tp_region` VALUES ('5742', '桑宝力格苏木乡', '4', '5738');
INSERT INTO `tp_region` VALUES ('5743', '额仁淖尔苏木乡', '4', '5738');
INSERT INTO `tp_region` VALUES ('5744', '赛罕乌力吉苏木乡', '4', '5738');
INSERT INTO `tp_region` VALUES ('5745', '东乌珠穆沁旗', '3', '5702');
INSERT INTO `tp_region` VALUES ('5746', '乌里雅斯太镇', '4', '5745');
INSERT INTO `tp_region` VALUES ('5747', '道特淖尔镇', '4', '5745');
INSERT INTO `tp_region` VALUES ('5748', '嘎达布其镇', '4', '5745');
INSERT INTO `tp_region` VALUES ('5749', '满都胡宝拉格镇', '4', '5745');
INSERT INTO `tp_region` VALUES ('5750', '额吉淖尔镇', '4', '5745');
INSERT INTO `tp_region` VALUES ('5751', '巴音胡硕镇', '4', '5745');
INSERT INTO `tp_region` VALUES ('5752', '呼热图淖尔苏木乡', '4', '5745');
INSERT INTO `tp_region` VALUES ('5753', '萨麦苏木乡', '4', '5745');
INSERT INTO `tp_region` VALUES ('5754', '哈拉盖图农牧场', '4', '5745');
INSERT INTO `tp_region` VALUES ('5755', '贺斯格乌拉农牧场', '4', '5745');
INSERT INTO `tp_region` VALUES ('5756', '乌拉盖牧场', '4', '5745');
INSERT INTO `tp_region` VALUES ('5757', '水库农牧业经营公司场', '4', '5745');
INSERT INTO `tp_region` VALUES ('5758', '西乌珠穆沁旗', '3', '5702');
INSERT INTO `tp_region` VALUES ('5759', '巴拉嘎尔高勒镇', '4', '5758');
INSERT INTO `tp_region` VALUES ('5760', '巴彦花镇', '4', '5758');
INSERT INTO `tp_region` VALUES ('5761', '吉仁高勒镇', '4', '5758');
INSERT INTO `tp_region` VALUES ('5762', '浩勒图高勒镇', '4', '5758');
INSERT INTO `tp_region` VALUES ('5763', '高日罕镇', '4', '5758');
INSERT INTO `tp_region` VALUES ('5764', '巴彦胡舒苏木乡', '4', '5758');
INSERT INTO `tp_region` VALUES ('5765', '林业总场', '4', '5758');
INSERT INTO `tp_region` VALUES ('5766', '太仆寺旗', '3', '5702');
INSERT INTO `tp_region` VALUES ('5767', '宝昌镇', '4', '5766');
INSERT INTO `tp_region` VALUES ('5768', '千斤沟镇', '4', '5766');
INSERT INTO `tp_region` VALUES ('5769', '红旗镇', '4', '5766');
INSERT INTO `tp_region` VALUES ('5770', '骆驼山镇', '4', '5766');
INSERT INTO `tp_region` VALUES ('5771', '幸福乡', '4', '5766');
INSERT INTO `tp_region` VALUES ('5772', '贡宝拉格苏木乡', '4', '5766');
INSERT INTO `tp_region` VALUES ('5773', '万寿滩良种场', '4', '5766');
INSERT INTO `tp_region` VALUES ('5774', '镶黄旗', '3', '5702');
INSERT INTO `tp_region` VALUES ('5775', '新宝拉格镇', '4', '5774');
INSERT INTO `tp_region` VALUES ('5776', '巴彦塔拉镇', '4', '5774');
INSERT INTO `tp_region` VALUES ('5777', '翁贡乌拉苏木乡', '4', '5774');
INSERT INTO `tp_region` VALUES ('5778', '正镶白旗', '3', '5702');
INSERT INTO `tp_region` VALUES ('5779', '明安图镇', '4', '5778');
INSERT INTO `tp_region` VALUES ('5780', '星耀镇', '4', '5778');
INSERT INTO `tp_region` VALUES ('5781', '伊和淖尔苏木乡', '4', '5778');
INSERT INTO `tp_region` VALUES ('5782', '乌兰查布苏木乡', '4', '5778');
INSERT INTO `tp_region` VALUES ('5783', '额里图种畜场', '4', '5778');
INSERT INTO `tp_region` VALUES ('5784', '哲日根图林场', '4', '5778');
INSERT INTO `tp_region` VALUES ('5785', '正蓝旗', '3', '5702');
INSERT INTO `tp_region` VALUES ('5786', '上都镇', '4', '5785');
INSERT INTO `tp_region` VALUES ('5787', '桑根达来镇', '4', '5785');
INSERT INTO `tp_region` VALUES ('5788', '哈毕日嘎镇', '4', '5785');
INSERT INTO `tp_region` VALUES ('5789', '宝绍岱苏木乡', '4', '5785');
INSERT INTO `tp_region` VALUES ('5790', '那日图苏木乡', '4', '5785');
INSERT INTO `tp_region` VALUES ('5791', '赛音胡都嘎苏木乡', '4', '5785');
INSERT INTO `tp_region` VALUES ('5792', '五一种畜场总场', '4', '5785');
INSERT INTO `tp_region` VALUES ('5793', '黑城子示范区', '4', '5785');
INSERT INTO `tp_region` VALUES ('5794', '多伦县', '3', '5702');
INSERT INTO `tp_region` VALUES ('5795', '大北沟镇', '4', '5794');
INSERT INTO `tp_region` VALUES ('5796', '多伦淖尔镇', '4', '5794');
INSERT INTO `tp_region` VALUES ('5797', '大河口乡', '4', '5794');
INSERT INTO `tp_region` VALUES ('5798', '蔡木山乡', '4', '5794');
INSERT INTO `tp_region` VALUES ('5799', '阿拉善盟', '2', '4670');
INSERT INTO `tp_region` VALUES ('5800', '阿拉善左旗', '3', '5799');
INSERT INTO `tp_region` VALUES ('5801', '温都尔勒图镇', '4', '5800');
INSERT INTO `tp_region` VALUES ('5802', '乌斯太镇', '4', '5800');
INSERT INTO `tp_region` VALUES ('5803', '巴润别立镇', '4', '5800');
INSERT INTO `tp_region` VALUES ('5804', '巴彦浩特镇', '4', '5800');
INSERT INTO `tp_region` VALUES ('5805', '嘉尔嘎勒赛汉镇', '4', '5800');
INSERT INTO `tp_region` VALUES ('5806', '吉兰泰镇', '4', '5800');
INSERT INTO `tp_region` VALUES ('5807', '宗别立镇', '4', '5800');
INSERT INTO `tp_region` VALUES ('5808', '敖伦布拉格镇', '4', '5800');
INSERT INTO `tp_region` VALUES ('5809', '巴彦木仁苏木乡', '4', '5800');
INSERT INTO `tp_region` VALUES ('5810', '腾格里苏木乡', '4', '5800');
INSERT INTO `tp_region` VALUES ('5811', '乌力吉苏木乡', '4', '5800');
INSERT INTO `tp_region` VALUES ('5812', '巴彦诺尔公苏木乡', '4', '5800');
INSERT INTO `tp_region` VALUES ('5813', '额尔克哈什哈苏木乡', '4', '5800');
INSERT INTO `tp_region` VALUES ('5814', '阿拉善右旗', '3', '5799');
INSERT INTO `tp_region` VALUES ('5815', '额肯呼都格镇', '4', '5814');
INSERT INTO `tp_region` VALUES ('5816', '雅布赖镇', '4', '5814');
INSERT INTO `tp_region` VALUES ('5817', '阿拉腾敖包镇', '4', '5814');
INSERT INTO `tp_region` VALUES ('5818', '孟根布拉格苏木乡', '4', '5814');
INSERT INTO `tp_region` VALUES ('5819', '阿拉腾朝克苏木乡', '4', '5814');
INSERT INTO `tp_region` VALUES ('5820', '额济纳旗', '3', '5799');
INSERT INTO `tp_region` VALUES ('5821', '达来呼布镇', '4', '5820');
INSERT INTO `tp_region` VALUES ('5822', '额济纳旗东风镇', '4', '5820');
INSERT INTO `tp_region` VALUES ('5823', '额济纳旗赛汉陶来苏木乡', '4', '5820');
INSERT INTO `tp_region` VALUES ('5824', '额济纳旗马鬃山苏木乡', '4', '5820');
INSERT INTO `tp_region` VALUES ('5825', '额济纳旗苏泊淖尔苏木乡', '4', '5820');
INSERT INTO `tp_region` VALUES ('5826', '额济纳旗巴彦陶来农场', '4', '5820');
INSERT INTO `tp_region` VALUES ('5827', '辽宁省', '1', '0');
INSERT INTO `tp_region` VALUES ('5828', '沈阳市', '2', '5827');
INSERT INTO `tp_region` VALUES ('5829', '市辖区', '3', '5828');
INSERT INTO `tp_region` VALUES ('5830', '和平区', '3', '5828');
INSERT INTO `tp_region` VALUES ('5831', '砂山街道', '4', '5830');
INSERT INTO `tp_region` VALUES ('5832', '新华街道', '4', '5830');
INSERT INTO `tp_region` VALUES ('5833', '吴淞街道', '4', '5830');
INSERT INTO `tp_region` VALUES ('5834', '西塔街道', '4', '5830');
INSERT INTO `tp_region` VALUES ('5835', '北道口街道', '4', '5830');
INSERT INTO `tp_region` VALUES ('5836', '遂川街道', '4', '5830');
INSERT INTO `tp_region` VALUES ('5837', '八经街道', '4', '5830');
INSERT INTO `tp_region` VALUES ('5838', '马路湾街道', '4', '5830');
INSERT INTO `tp_region` VALUES ('5839', '集贤街道', '4', '5830');
INSERT INTO `tp_region` VALUES ('5840', '新兴街道', '4', '5830');
INSERT INTO `tp_region` VALUES ('5841', '南湖街道', '4', '5830');
INSERT INTO `tp_region` VALUES ('5842', '长白街道', '4', '5830');
INSERT INTO `tp_region` VALUES ('5843', '太原街街道', '4', '5830');
INSERT INTO `tp_region` VALUES ('5844', '北市场街道', '4', '5830');
INSERT INTO `tp_region` VALUES ('5845', '南市场街道', '4', '5830');
INSERT INTO `tp_region` VALUES ('5846', '中山街道', '4', '5830');
INSERT INTO `tp_region` VALUES ('5847', '沈水湾街道', '4', '5830');
INSERT INTO `tp_region` VALUES ('5848', '沈河区', '3', '5828');
INSERT INTO `tp_region` VALUES ('5849', '大西街道', '4', '5848');
INSERT INTO `tp_region` VALUES ('5850', '滨河街道', '4', '5848');
INSERT INTO `tp_region` VALUES ('5851', '万莲街道', '4', '5848');
INSERT INTO `tp_region` VALUES ('5852', '大南街道', '4', '5848');
INSERT INTO `tp_region` VALUES ('5853', '山东庙街道', '4', '5848');
INSERT INTO `tp_region` VALUES ('5854', '朱剪炉街道', '4', '5848');
INSERT INTO `tp_region` VALUES ('5855', '新北站街道', '4', '5848');
INSERT INTO `tp_region` VALUES ('5856', '风雨坛街道', '4', '5848');
INSERT INTO `tp_region` VALUES ('5857', '皇城街道', '4', '5848');
INSERT INTO `tp_region` VALUES ('5858', '五里河街道', '4', '5848');
INSERT INTO `tp_region` VALUES ('5859', '大东区', '3', '5828');
INSERT INTO `tp_region` VALUES ('5860', '小北街道', '4', '5859');
INSERT INTO `tp_region` VALUES ('5861', '大北街道', '4', '5859');
INSERT INTO `tp_region` VALUES ('5862', '万泉街道', '4', '5859');
INSERT INTO `tp_region` VALUES ('5863', '洮昌街道', '4', '5859');
INSERT INTO `tp_region` VALUES ('5864', '文官街道', '4', '5859');
INSERT INTO `tp_region` VALUES ('5865', '二台子街道', '4', '5859');
INSERT INTO `tp_region` VALUES ('5866', '津桥街道', '4', '5859');
INSERT INTO `tp_region` VALUES ('5867', '东站街道', '4', '5859');
INSERT INTO `tp_region` VALUES ('5868', '辽沈街道', '4', '5859');
INSERT INTO `tp_region` VALUES ('5869', '珠林街道', '4', '5859');
INSERT INTO `tp_region` VALUES ('5870', '长安街道', '4', '5859');
INSERT INTO `tp_region` VALUES ('5871', '新东街道', '4', '5859');
INSERT INTO `tp_region` VALUES ('5872', '东塔街道', '4', '5859');
INSERT INTO `tp_region` VALUES ('5873', '皇姑区', '3', '5828');
INSERT INTO `tp_region` VALUES ('5874', '三台子街道', '4', '5873');
INSERT INTO `tp_region` VALUES ('5875', '陵北街道', '4', '5873');
INSERT INTO `tp_region` VALUES ('5876', '辽河街道', '4', '5873');
INSERT INTO `tp_region` VALUES ('5877', '黑龙江街道', '4', '5873');
INSERT INTO `tp_region` VALUES ('5878', '泰山街道', '4', '5873');
INSERT INTO `tp_region` VALUES ('5879', '祟山街道', '4', '5873');
INSERT INTO `tp_region` VALUES ('5880', '长江街道', '4', '5873');
INSERT INTO `tp_region` VALUES ('5881', '黄河街道', '4', '5873');
INSERT INTO `tp_region` VALUES ('5882', '昆山街道', '4', '5873');
INSERT INTO `tp_region` VALUES ('5883', '亚明街道', '4', '5873');
INSERT INTO `tp_region` VALUES ('5884', '克俭街道', '4', '5873');
INSERT INTO `tp_region` VALUES ('5885', '三洞桥街道', '4', '5873');
INSERT INTO `tp_region` VALUES ('5886', '华山街道', '4', '5873');
INSERT INTO `tp_region` VALUES ('5887', '寿泉街道', '4', '5873');
INSERT INTO `tp_region` VALUES ('5888', '塔湾街道', '4', '5873');
INSERT INTO `tp_region` VALUES ('5889', '怒江街道', '4', '5873');
INSERT INTO `tp_region` VALUES ('5890', '明廉街道', '4', '5873');
INSERT INTO `tp_region` VALUES ('5891', '向工街道', '4', '5873');
INSERT INTO `tp_region` VALUES ('5892', '新乐街道', '4', '5873');
INSERT INTO `tp_region` VALUES ('5893', '太平街道', '4', '5873');
INSERT INTO `tp_region` VALUES ('5894', '铁西区', '3', '5828');
INSERT INTO `tp_region` VALUES ('5895', '卫工街道', '4', '5894');
INSERT INTO `tp_region` VALUES ('5896', '工人村街道', '4', '5894');
INSERT INTO `tp_region` VALUES ('5897', '七路街道', '4', '5894');
INSERT INTO `tp_region` VALUES ('5898', '启工街道', '4', '5894');
INSERT INTO `tp_region` VALUES ('5899', '笃工街道', '4', '5894');
INSERT INTO `tp_region` VALUES ('5900', '兴华街道', '4', '5894');
INSERT INTO `tp_region` VALUES ('5901', '兴工街道', '4', '5894');
INSERT INTO `tp_region` VALUES ('5902', '霁虹街道', '4', '5894');
INSERT INTO `tp_region` VALUES ('5903', '凌空街道', '4', '5894');
INSERT INTO `tp_region` VALUES ('5904', '轻重工街道', '4', '5894');
INSERT INTO `tp_region` VALUES ('5905', '艳粉路官街道', '4', '5894');
INSERT INTO `tp_region` VALUES ('5906', '兴齐保工街道', '4', '5894');
INSERT INTO `tp_region` VALUES ('5907', '齐贤兴顺街道', '4', '5894');
INSERT INTO `tp_region` VALUES ('5908', '云峰贵和街道', '4', '5894');
INSERT INTO `tp_region` VALUES ('5909', '苏家屯区', '3', '5828');
INSERT INTO `tp_region` VALUES ('5910', '解放街道', '4', '5909');
INSERT INTO `tp_region` VALUES ('5911', '铁友街道', '4', '5909');
INSERT INTO `tp_region` VALUES ('5912', '民主街道', '4', '5909');
INSERT INTO `tp_region` VALUES ('5913', '临湖街道', '4', '5909');
INSERT INTO `tp_region` VALUES ('5914', '中兴街道', '4', '5909');
INSERT INTO `tp_region` VALUES ('5915', '湖西街道', '4', '5909');
INSERT INTO `tp_region` VALUES ('5916', '城郊街道', '4', '5909');
INSERT INTO `tp_region` VALUES ('5917', '八一镇', '4', '5909');
INSERT INTO `tp_region` VALUES ('5918', '红菱堡镇', '4', '5909');
INSERT INTO `tp_region` VALUES ('5919', '林盛堡镇', '4', '5909');
INSERT INTO `tp_region` VALUES ('5920', '沙河铺镇', '4', '5909');
INSERT INTO `tp_region` VALUES ('5921', '十里河镇', '4', '5909');
INSERT INTO `tp_region` VALUES ('5922', '陈相屯镇', '4', '5909');
INSERT INTO `tp_region` VALUES ('5923', '姚千户屯镇', '4', '5909');
INSERT INTO `tp_region` VALUES ('5924', '王纲堡乡', '4', '5909');
INSERT INTO `tp_region` VALUES ('5925', '永乐乡', '4', '5909');
INSERT INTO `tp_region` VALUES ('5926', '大沟乡', '4', '5909');
INSERT INTO `tp_region` VALUES ('5927', '白清寨乡', '4', '5909');
INSERT INTO `tp_region` VALUES ('5928', '佟沟乡', '4', '5909');
INSERT INTO `tp_region` VALUES ('5929', '市浑河农场', '4', '5909');
INSERT INTO `tp_region` VALUES ('5930', '沈阳塔山农业科技发展有限公司', '4', '5909');
INSERT INTO `tp_region` VALUES ('5931', '区示范农场', '4', '5909');
INSERT INTO `tp_region` VALUES ('5932', '省稻作研究所', '4', '5909');
INSERT INTO `tp_region` VALUES ('5933', '区塔山林场', '4', '5909');
INSERT INTO `tp_region` VALUES ('5934', '东陵区', '3', '5828');
INSERT INTO `tp_region` VALUES ('5935', '南塔街道', '4', '5934');
INSERT INTO `tp_region` VALUES ('5936', '泉园街道', '4', '5934');
INSERT INTO `tp_region` VALUES ('5937', '丰乐街道', '4', '5934');
INSERT INTO `tp_region` VALUES ('5938', '马官桥街道', '4', '5934');
INSERT INTO `tp_region` VALUES ('5939', '东陵街道', '4', '5934');
INSERT INTO `tp_region` VALUES ('5940', '英达街道', '4', '5934');
INSERT INTO `tp_region` VALUES ('5941', '前进街道', '4', '5934');
INSERT INTO `tp_region` VALUES ('5942', '东湖街道（浑南新区）', '4', '5934');
INSERT INTO `tp_region` VALUES ('5943', '五三街道（浑南新区）', '4', '5934');
INSERT INTO `tp_region` VALUES ('5944', '浑河站东街道', '4', '5934');
INSERT INTO `tp_region` VALUES ('5945', '浑河站西街道', '4', '5934');
INSERT INTO `tp_region` VALUES ('5946', '高坎街道（棋盘山开发区）', '4', '5934');
INSERT INTO `tp_region` VALUES ('5947', '满堂街道（棋盘山）', '4', '5934');
INSERT INTO `tp_region` VALUES ('5948', '深井子镇', '4', '5934');
INSERT INTO `tp_region` VALUES ('5949', '祝家屯镇', '4', '5934');
INSERT INTO `tp_region` VALUES ('5950', '白塔堡镇', '4', '5934');
INSERT INTO `tp_region` VALUES ('5951', '桃仙镇', '4', '5934');
INSERT INTO `tp_region` VALUES ('5952', '李相镇', '4', '5934');
INSERT INTO `tp_region` VALUES ('5953', '王滨沟乡', '4', '5934');
INSERT INTO `tp_region` VALUES ('5954', '新城子区', '3', '5828');
INSERT INTO `tp_region` VALUES ('5955', '新城子街道', '4', '5954');
INSERT INTO `tp_region` VALUES ('5956', '清水台街道', '4', '5954');
INSERT INTO `tp_region` VALUES ('5957', '辉山街道（农业高新区）', '4', '5954');
INSERT INTO `tp_region` VALUES ('5958', '道义镇', '4', '5954');
INSERT INTO `tp_region` VALUES ('5959', '兴隆台锡伯族镇', '4', '5954');
INSERT INTO `tp_region` VALUES ('5960', '清水台镇', '4', '5954');
INSERT INTO `tp_region` VALUES ('5961', '蒲河镇', '4', '5954');
INSERT INTO `tp_region` VALUES ('5962', '虎石台镇', '4', '5954');
INSERT INTO `tp_region` VALUES ('5963', '财落镇', '4', '5954');
INSERT INTO `tp_region` VALUES ('5964', '新城子乡', '4', '5954');
INSERT INTO `tp_region` VALUES ('5965', '黄家锡伯族乡', '4', '5954');
INSERT INTO `tp_region` VALUES ('5966', '石佛寺朝鲜族锡伯族乡', '4', '5954');
INSERT INTO `tp_region` VALUES ('5967', '尹家乡', '4', '5954');
INSERT INTO `tp_region` VALUES ('5968', '马刚乡', '4', '5954');
INSERT INTO `tp_region` VALUES ('5969', '青年农场', '4', '5954');
INSERT INTO `tp_region` VALUES ('5970', '前进农场', '4', '5954');
INSERT INTO `tp_region` VALUES ('5971', '育新农场', '4', '5954');
INSERT INTO `tp_region` VALUES ('5972', '新城子区马刚林场', '4', '5954');
INSERT INTO `tp_region` VALUES ('5973', '新城子区示范农场', '4', '5954');
INSERT INTO `tp_region` VALUES ('5974', '新城子区种畜场', '4', '5954');
INSERT INTO `tp_region` VALUES ('5975', '于洪区', '3', '5828');
INSERT INTO `tp_region` VALUES ('5976', '迎宾路街道', '4', '5975');
INSERT INTO `tp_region` VALUES ('5977', '北塔街道', '4', '5975');
INSERT INTO `tp_region` VALUES ('5978', '陵西街道', '4', '5975');
INSERT INTO `tp_region` VALUES ('5979', '于洪街道', '4', '5975');
INSERT INTO `tp_region` VALUES ('5980', '杨士街道', '4', '5975');
INSERT INTO `tp_region` VALUES ('5981', '北陵街道', '4', '5975');
INSERT INTO `tp_region` VALUES ('5982', '陵东街道', '4', '5975');
INSERT INTO `tp_region` VALUES ('5983', '沙岭街道', '4', '5975');
INSERT INTO `tp_region` VALUES ('5984', '平罗镇', '4', '5975');
INSERT INTO `tp_region` VALUES ('5985', '马三家子镇', '4', '5975');
INSERT INTO `tp_region` VALUES ('5986', '大潘镇', '4', '5975');
INSERT INTO `tp_region` VALUES ('5987', '造化镇', '4', '5975');
INSERT INTO `tp_region` VALUES ('5988', '翟家镇', '4', '5975');
INSERT INTO `tp_region` VALUES ('5989', '彰驿站镇', '4', '5975');
INSERT INTO `tp_region` VALUES ('5990', '高花镇', '4', '5975');
INSERT INTO `tp_region` VALUES ('5991', '大兴朝鲜族乡', '4', '5975');
INSERT INTO `tp_region` VALUES ('5992', '大青中朝友谊乡', '4', '5975');
INSERT INTO `tp_region` VALUES ('5993', '光辉乡', '4', '5975');
INSERT INTO `tp_region` VALUES ('5994', '马三家劳动教养院', '4', '5975');
INSERT INTO `tp_region` VALUES ('5995', '光辉农场', '4', '5975');
INSERT INTO `tp_region` VALUES ('5996', '北陵农场', '4', '5975');
INSERT INTO `tp_region` VALUES ('5997', '监狱城', '4', '5975');
INSERT INTO `tp_region` VALUES ('5998', '辽中县', '3', '5828');
INSERT INTO `tp_region` VALUES ('5999', '辽中镇', '4', '5998');
INSERT INTO `tp_region` VALUES ('6000', '于家房镇', '4', '5998');
INSERT INTO `tp_region` VALUES ('6001', '朱家房镇', '4', '5998');
INSERT INTO `tp_region` VALUES ('6002', '冷子堡镇', '4', '5998');
INSERT INTO `tp_region` VALUES ('6003', '刘二堡镇', '4', '5998');
INSERT INTO `tp_region` VALUES ('6004', '茨榆坨镇', '4', '5998');
INSERT INTO `tp_region` VALUES ('6005', '新民屯镇', '4', '5998');
INSERT INTO `tp_region` VALUES ('6006', '满都户镇', '4', '5998');
INSERT INTO `tp_region` VALUES ('6007', '杨士岗镇', '4', '5998');
INSERT INTO `tp_region` VALUES ('6008', '肖寨门镇', '4', '5998');
INSERT INTO `tp_region` VALUES ('6009', '长滩镇', '4', '5998');
INSERT INTO `tp_region` VALUES ('6010', '四方台镇', '4', '5998');
INSERT INTO `tp_region` VALUES ('6011', '城郊乡', '4', '5998');
INSERT INTO `tp_region` VALUES ('6012', '六间房乡', '4', '5998');
INSERT INTO `tp_region` VALUES ('6013', '养士堡乡', '4', '5998');
INSERT INTO `tp_region` VALUES ('6014', '潘家堡乡', '4', '5998');
INSERT INTO `tp_region` VALUES ('6015', '老观坨乡', '4', '5998');
INSERT INTO `tp_region` VALUES ('6016', '老大房乡', '4', '5998');
INSERT INTO `tp_region` VALUES ('6017', '大黑岗子乡', '4', '5998');
INSERT INTO `tp_region` VALUES ('6018', '牛心坨乡', '4', '5998');
INSERT INTO `tp_region` VALUES ('6019', '四方台子农场', '4', '5998');
INSERT INTO `tp_region` VALUES ('6020', '康平县', '3', '5828');
INSERT INTO `tp_region` VALUES ('6021', '康平镇', '4', '6020');
INSERT INTO `tp_region` VALUES ('6022', '小城子镇', '4', '6020');
INSERT INTO `tp_region` VALUES ('6023', '张强镇', '4', '6020');
INSERT INTO `tp_region` VALUES ('6024', '方家屯镇', '4', '6020');
INSERT INTO `tp_region` VALUES ('6025', '东关屯镇', '4', '6020');
INSERT INTO `tp_region` VALUES ('6026', '郝官屯镇', '4', '6020');
INSERT INTO `tp_region` VALUES ('6027', '二牛所口镇', '4', '6020');
INSERT INTO `tp_region` VALUES ('6028', '北四家子乡', '4', '6020');
INSERT INTO `tp_region` VALUES ('6029', '两家子乡', '4', '6020');
INSERT INTO `tp_region` VALUES ('6030', '山东屯乡', '4', '6020');
INSERT INTO `tp_region` VALUES ('6031', '海洲窝堡乡', '4', '6020');
INSERT INTO `tp_region` VALUES ('6032', '沙金台蒙古族满族乡', '4', '6020');
INSERT INTO `tp_region` VALUES ('6033', '柳树屯蒙古族满族乡', '4', '6020');
INSERT INTO `tp_region` VALUES ('6034', '西关屯蒙古族满族乡', '4', '6020');
INSERT INTO `tp_region` VALUES ('6035', '东升满族蒙古族乡', '4', '6020');
INSERT INTO `tp_region` VALUES ('6036', '辽宁省康平监狱', '4', '6020');
INSERT INTO `tp_region` VALUES ('6037', '三台子畜牧场', '4', '6020');
INSERT INTO `tp_region` VALUES ('6038', '法库县', '3', '5828');
INSERT INTO `tp_region` VALUES ('6039', '法库镇', '4', '6038');
INSERT INTO `tp_region` VALUES ('6040', '大孤家子镇', '4', '6038');
INSERT INTO `tp_region` VALUES ('6041', '三面船镇', '4', '6038');
INSERT INTO `tp_region` VALUES ('6042', '秀水河子镇', '4', '6038');
INSERT INTO `tp_region` VALUES ('6043', '叶茂台镇', '4', '6038');
INSERT INTO `tp_region` VALUES ('6044', '登仕堡子镇', '4', '6038');
INSERT INTO `tp_region` VALUES ('6045', '柏家沟镇', '4', '6038');
INSERT INTO `tp_region` VALUES ('6046', '丁家房镇', '4', '6038');
INSERT INTO `tp_region` VALUES ('6047', '慈恩寺乡', '4', '6038');
INSERT INTO `tp_region` VALUES ('6048', '孟家乡', '4', '6038');
INSERT INTO `tp_region` VALUES ('6049', '和平乡', '4', '6038');
INSERT INTO `tp_region` VALUES ('6050', '十间房乡', '4', '6038');
INSERT INTO `tp_region` VALUES ('6051', '冯贝堡乡', '4', '6038');
INSERT INTO `tp_region` VALUES ('6052', '依牛堡子乡', '4', '6038');
INSERT INTO `tp_region` VALUES ('6053', '五台子乡', '4', '6038');
INSERT INTO `tp_region` VALUES ('6054', '四家子蒙古族乡', '4', '6038');
INSERT INTO `tp_region` VALUES ('6055', '双台子乡', '4', '6038');
INSERT INTO `tp_region` VALUES ('6056', '卧牛石乡', '4', '6038');
INSERT INTO `tp_region` VALUES ('6057', '包家屯乡', '4', '6038');
INSERT INTO `tp_region` VALUES ('6058', '新民市', '3', '5828');
INSERT INTO `tp_region` VALUES ('6059', '东城街道', '4', '6058');
INSERT INTO `tp_region` VALUES ('6060', '辽滨街道', '4', '6058');
INSERT INTO `tp_region` VALUES ('6061', '西城街道', '4', '6058');
INSERT INTO `tp_region` VALUES ('6062', '新柳街道', '4', '6058');
INSERT INTO `tp_region` VALUES ('6063', '新城街道', '4', '6058');
INSERT INTO `tp_region` VALUES ('6064', '大红旗镇', '4', '6058');
INSERT INTO `tp_region` VALUES ('6065', '梁山镇', '4', '6058');
INSERT INTO `tp_region` VALUES ('6066', '公主屯镇', '4', '6058');
INSERT INTO `tp_region` VALUES ('6067', '兴隆镇', '4', '6058');
INSERT INTO `tp_region` VALUES ('6068', '前当堡镇', '4', '6058');
INSERT INTO `tp_region` VALUES ('6069', '大民屯镇', '4', '6058');
INSERT INTO `tp_region` VALUES ('6070', '大柳屯镇', '4', '6058');
INSERT INTO `tp_region` VALUES ('6071', '兴隆堡镇', '4', '6058');
INSERT INTO `tp_region` VALUES ('6072', '胡台镇', '4', '6058');
INSERT INTO `tp_region` VALUES ('6073', '法哈牛镇', '4', '6058');
INSERT INTO `tp_region` VALUES ('6074', '柳河沟镇', '4', '6058');
INSERT INTO `tp_region` VALUES ('6075', '高台子乡', '4', '6058');
INSERT INTO `tp_region` VALUES ('6076', '金五台子乡', '4', '6058');
INSERT INTO `tp_region` VALUES ('6077', '红旗乡', '4', '6058');
INSERT INTO `tp_region` VALUES ('6078', '卢家屯乡', '4', '6058');
INSERT INTO `tp_region` VALUES ('6079', '姚堡乡', '4', '6058');
INSERT INTO `tp_region` VALUES ('6080', '周坨子乡', '4', '6058');
INSERT INTO `tp_region` VALUES ('6081', '于家窝堡乡', '4', '6058');
INSERT INTO `tp_region` VALUES ('6082', '新农乡', '4', '6058');
INSERT INTO `tp_region` VALUES ('6083', '东蛇山子乡', '4', '6058');
INSERT INTO `tp_region` VALUES ('6084', '陶家屯乡', '4', '6058');
INSERT INTO `tp_region` VALUES ('6085', '罗家房乡', '4', '6058');
INSERT INTO `tp_region` VALUES ('6086', '三道岗子乡', '4', '6058');
INSERT INTO `tp_region` VALUES ('6087', '张家屯乡', '4', '6058');
INSERT INTO `tp_region` VALUES ('6088', '大连市', '2', '5827');
INSERT INTO `tp_region` VALUES ('6089', '市辖区', '3', '6088');
INSERT INTO `tp_region` VALUES ('6090', '中山区', '3', '6088');
INSERT INTO `tp_region` VALUES ('6091', '海军广场街道', '4', '6090');
INSERT INTO `tp_region` VALUES ('6092', '桂林街道', '4', '6090');
INSERT INTO `tp_region` VALUES ('6093', '人民路街道', '4', '6090');
INSERT INTO `tp_region` VALUES ('6094', '青泥洼桥街道', '4', '6090');
INSERT INTO `tp_region` VALUES ('6095', '昆明街道', '4', '6090');
INSERT INTO `tp_region` VALUES ('6096', '葵英街道', '4', '6090');
INSERT INTO `tp_region` VALUES ('6097', '桃源街道', '4', '6090');
INSERT INTO `tp_region` VALUES ('6098', '老虎滩街道', '4', '6090');
INSERT INTO `tp_region` VALUES ('6099', '西岗区', '3', '6088');
INSERT INTO `tp_region` VALUES ('6100', '香炉礁街道', '4', '6099');
INSERT INTO `tp_region` VALUES ('6101', '站北街道', '4', '6099');
INSERT INTO `tp_region` VALUES ('6102', '日新街道', '4', '6099');
INSERT INTO `tp_region` VALUES ('6103', '北京街道', '4', '6099');
INSERT INTO `tp_region` VALUES ('6104', '八一路街道', '4', '6099');
INSERT INTO `tp_region` VALUES ('6105', '人民广场街道', '4', '6099');
INSERT INTO `tp_region` VALUES ('6106', '白云街道', '4', '6099');
INSERT INTO `tp_region` VALUES ('6107', '沙河口区', '3', '6088');
INSERT INTO `tp_region` VALUES ('6108', '中山公园街道', '4', '6107');
INSERT INTO `tp_region` VALUES ('6109', '白山路街道', '4', '6107');
INSERT INTO `tp_region` VALUES ('6110', '兴工街道', '4', '6107');
INSERT INTO `tp_region` VALUES ('6111', '春柳街道', '4', '6107');
INSERT INTO `tp_region` VALUES ('6112', '马栏街道', '4', '6107');
INSERT INTO `tp_region` VALUES ('6113', '南沙河口街道', '4', '6107');
INSERT INTO `tp_region` VALUES ('6114', '黑石礁街道', '4', '6107');
INSERT INTO `tp_region` VALUES ('6115', '李家街道', '4', '6107');
INSERT INTO `tp_region` VALUES ('6116', '星海湾街道', '4', '6107');
INSERT INTO `tp_region` VALUES ('6117', '甘井子区', '3', '6088');
INSERT INTO `tp_region` VALUES ('6118', '周水子街道', '4', '6117');
INSERT INTO `tp_region` VALUES ('6119', '椒金山街道', '4', '6117');
INSERT INTO `tp_region` VALUES ('6120', '甘井子街道', '4', '6117');
INSERT INTO `tp_region` VALUES ('6121', '南关岭街道', '4', '6117');
INSERT INTO `tp_region` VALUES ('6122', '泡崖街道', '4', '6117');
INSERT INTO `tp_region` VALUES ('6123', '中华路街道', '4', '6117');
INSERT INTO `tp_region` VALUES ('6124', '兴华街道', '4', '6117');
INSERT INTO `tp_region` VALUES ('6125', '机场街道', '4', '6117');
INSERT INTO `tp_region` VALUES ('6126', '辛寨子街道', '4', '6117');
INSERT INTO `tp_region` VALUES ('6127', '红旗街道', '4', '6117');
INSERT INTO `tp_region` VALUES ('6128', '凌水街道', '4', '6117');
INSERT INTO `tp_region` VALUES ('6129', '大连湾街道', '4', '6117');
INSERT INTO `tp_region` VALUES ('6130', '泉水街道', '4', '6117');
INSERT INTO `tp_region` VALUES ('6131', '革镇堡镇', '4', '6117');
INSERT INTO `tp_region` VALUES ('6132', '营城子镇', '4', '6117');
INSERT INTO `tp_region` VALUES ('6133', '大连华侨果树农场', '4', '6117');
INSERT INTO `tp_region` VALUES ('6134', '大连华侨兴达实业公司', '4', '6117');
INSERT INTO `tp_region` VALUES ('6135', '大连华侨鑫山企业公司', '4', '6117');
INSERT INTO `tp_region` VALUES ('6136', '大连南关岭农场', '4', '6117');
INSERT INTO `tp_region` VALUES ('6137', '旅顺口区', '3', '6088');
INSERT INTO `tp_region` VALUES ('6138', '登峰街道', '4', '6137');
INSERT INTO `tp_region` VALUES ('6139', '市场街道', '4', '6137');
INSERT INTO `tp_region` VALUES ('6140', '得胜街道', '4', '6137');
INSERT INTO `tp_region` VALUES ('6141', '光荣街道', '4', '6137');
INSERT INTO `tp_region` VALUES ('6142', '水师营街道', '4', '6137');
INSERT INTO `tp_region` VALUES ('6143', '龙王塘街道', '4', '6137');
INSERT INTO `tp_region` VALUES ('6144', '铁山街道', '4', '6137');
INSERT INTO `tp_region` VALUES ('6145', '江西街道', '4', '6137');
INSERT INTO `tp_region` VALUES ('6146', '双岛湾街道', '4', '6137');
INSERT INTO `tp_region` VALUES ('6147', '三涧堡街道', '4', '6137');
INSERT INTO `tp_region` VALUES ('6148', '长城街道', '4', '6137');
INSERT INTO `tp_region` VALUES ('6149', '龙头街道', '4', '6137');
INSERT INTO `tp_region` VALUES ('6150', '北海街道', '4', '6137');
INSERT INTO `tp_region` VALUES ('6151', '旅顺开发区', '4', '6137');
INSERT INTO `tp_region` VALUES ('6152', '大连奶牛场', '4', '6137');
INSERT INTO `tp_region` VALUES ('6153', '金州区', '3', '6088');
INSERT INTO `tp_region` VALUES ('6154', '拥政街道', '4', '6153');
INSERT INTO `tp_region` VALUES ('6155', '友谊街道', '4', '6153');
INSERT INTO `tp_region` VALUES ('6156', '光明街道', '4', '6153');
INSERT INTO `tp_region` VALUES ('6157', '马桥子街道', '4', '6153');
INSERT INTO `tp_region` VALUES ('6158', '海青岛街道', '4', '6153');
INSERT INTO `tp_region` VALUES ('6159', '大孤山街道', '4', '6153');
INSERT INTO `tp_region` VALUES ('6160', '中长街道', '4', '6153');
INSERT INTO `tp_region` VALUES ('6161', '站前街道', '4', '6153');
INSERT INTO `tp_region` VALUES ('6162', '先进街道', '4', '6153');
INSERT INTO `tp_region` VALUES ('6163', '董家沟街道', '4', '6153');
INSERT INTO `tp_region` VALUES ('6164', '金满街道', '4', '6153');
INSERT INTO `tp_region` VALUES ('6165', '湾里街道', '4', '6153');
INSERT INTO `tp_region` VALUES ('6166', '大李家镇', '4', '6153');
INSERT INTO `tp_region` VALUES ('6167', '得胜镇', '4', '6153');
INSERT INTO `tp_region` VALUES ('6168', '华家屯镇', '4', '6153');
INSERT INTO `tp_region` VALUES ('6169', '二十里堡镇', '4', '6153');
INSERT INTO `tp_region` VALUES ('6170', '三十里堡镇', '4', '6153');
INSERT INTO `tp_region` VALUES ('6171', '亮甲店镇', '4', '6153');
INSERT INTO `tp_region` VALUES ('6172', '登沙河镇', '4', '6153');
INSERT INTO `tp_region` VALUES ('6173', '杏树屯镇', '4', '6153');
INSERT INTO `tp_region` VALUES ('6174', '石河满族镇', '4', '6153');
INSERT INTO `tp_region` VALUES ('6175', '大魏家镇', '4', '6153');
INSERT INTO `tp_region` VALUES ('6176', '向应镇', '4', '6153');
INSERT INTO `tp_region` VALUES ('6177', '七顶山满族乡', '4', '6153');
INSERT INTO `tp_region` VALUES ('6178', '长海县', '3', '6088');
INSERT INTO `tp_region` VALUES ('6179', '大长山岛镇', '4', '6178');
INSERT INTO `tp_region` VALUES ('6180', '獐子岛镇', '4', '6178');
INSERT INTO `tp_region` VALUES ('6181', '小长山乡', '4', '6178');
INSERT INTO `tp_region` VALUES ('6182', '广鹿乡', '4', '6178');
INSERT INTO `tp_region` VALUES ('6183', '海洋乡', '4', '6178');
INSERT INTO `tp_region` VALUES ('6184', '瓦房店市', '3', '6088');
INSERT INTO `tp_region` VALUES ('6185', '新华', '4', '6184');
INSERT INTO `tp_region` VALUES ('6186', '文兰', '4', '6184');
INSERT INTO `tp_region` VALUES ('6187', '岭东', '4', '6184');
INSERT INTO `tp_region` VALUES ('6188', '共济', '4', '6184');
INSERT INTO `tp_region` VALUES ('6189', '铁东', '4', '6184');
INSERT INTO `tp_region` VALUES ('6190', '祝华', '4', '6184');
INSERT INTO `tp_region` VALUES ('6191', '岗店', '4', '6184');
INSERT INTO `tp_region` VALUES ('6192', '太阳街道', '4', '6184');
INSERT INTO `tp_region` VALUES ('6193', '长兴岛', '4', '6184');
INSERT INTO `tp_region` VALUES ('6194', '复州城镇', '4', '6184');
INSERT INTO `tp_region` VALUES ('6195', '复州湾镇', '4', '6184');
INSERT INTO `tp_region` VALUES ('6196', '松树镇', '4', '6184');
INSERT INTO `tp_region` VALUES ('6197', '得利寺镇', '4', '6184');
INSERT INTO `tp_region` VALUES ('6198', '万家岭镇', '4', '6184');
INSERT INTO `tp_region` VALUES ('6199', '许屯镇', '4', '6184');
INSERT INTO `tp_region` VALUES ('6200', '永宁镇', '4', '6184');
INSERT INTO `tp_region` VALUES ('6201', '谢屯镇', '4', '6184');
INSERT INTO `tp_region` VALUES ('6202', '炮台镇', '4', '6184');
INSERT INTO `tp_region` VALUES ('6203', '李店镇', '4', '6184');
INSERT INTO `tp_region` VALUES ('6204', '老虎屯镇', '4', '6184');
INSERT INTO `tp_region` VALUES ('6205', '东岗镇', '4', '6184');
INSERT INTO `tp_region` VALUES ('6206', '李官镇', '4', '6184');
INSERT INTO `tp_region` VALUES ('6207', '仙浴湾镇', '4', '6184');
INSERT INTO `tp_region` VALUES ('6208', '赵屯乡', '4', '6184');
INSERT INTO `tp_region` VALUES ('6209', '土城乡', '4', '6184');
INSERT INTO `tp_region` VALUES ('6210', '阎店乡', '4', '6184');
INSERT INTO `tp_region` VALUES ('6211', '西杨乡', '4', '6184');
INSERT INTO `tp_region` VALUES ('6212', '驼山乡', '4', '6184');
INSERT INTO `tp_region` VALUES ('6213', '三台满族乡', '4', '6184');
INSERT INTO `tp_region` VALUES ('6214', '交流岛乡', '4', '6184');
INSERT INTO `tp_region` VALUES ('6215', '泡崖乡', '4', '6184');
INSERT INTO `tp_region` VALUES ('6216', '杨家满族乡', '4', '6184');
INSERT INTO `tp_region` VALUES ('6217', '普兰店市', '3', '6088');
INSERT INTO `tp_region` VALUES ('6218', '丰荣街道', '4', '6217');
INSERT INTO `tp_region` VALUES ('6219', '铁西街道', '4', '6217');
INSERT INTO `tp_region` VALUES ('6220', '太平街道', '4', '6217');
INSERT INTO `tp_region` VALUES ('6221', '南山街道', '4', '6217');
INSERT INTO `tp_region` VALUES ('6222', '皮口镇', '4', '6217');
INSERT INTO `tp_region` VALUES ('6223', '城子坦镇', '4', '6217');
INSERT INTO `tp_region` VALUES ('6224', '大刘家镇', '4', '6217');
INSERT INTO `tp_region` VALUES ('6225', '杨树房镇', '4', '6217');
INSERT INTO `tp_region` VALUES ('6226', '双塔镇', '4', '6217');
INSERT INTO `tp_region` VALUES ('6227', '安波镇', '4', '6217');
INSERT INTO `tp_region` VALUES ('6228', '四平镇', '4', '6217');
INSERT INTO `tp_region` VALUES ('6229', '沙包镇', '4', '6217');
INSERT INTO `tp_region` VALUES ('6230', '瓦窝镇', '4', '6217');
INSERT INTO `tp_region` VALUES ('6231', '元台镇', '4', '6217');
INSERT INTO `tp_region` VALUES ('6232', '大谭镇', '4', '6217');
INSERT INTO `tp_region` VALUES ('6233', '夹河庙镇', '4', '6217');
INSERT INTO `tp_region` VALUES ('6234', '莲山镇', '4', '6217');
INSERT INTO `tp_region` VALUES ('6235', '星台镇', '4', '6217');
INSERT INTO `tp_region` VALUES ('6236', '墨盘乡', '4', '6217');
INSERT INTO `tp_region` VALUES ('6237', '同益乡', '4', '6217');
INSERT INTO `tp_region` VALUES ('6238', '乐甲满族乡', '4', '6217');
INSERT INTO `tp_region` VALUES ('6239', '庄河市', '3', '6088');
INSERT INTO `tp_region` VALUES ('6240', '城关街道', '4', '6239');
INSERT INTO `tp_region` VALUES ('6241', '新华街道', '4', '6239');
INSERT INTO `tp_region` VALUES ('6242', '兴达街道', '4', '6239');
INSERT INTO `tp_region` VALUES ('6243', '昌盛街道', '4', '6239');
INSERT INTO `tp_region` VALUES ('6244', '青堆镇', '4', '6239');
INSERT INTO `tp_region` VALUES ('6245', '徐岭镇', '4', '6239');
INSERT INTO `tp_region` VALUES ('6246', '黑岛镇', '4', '6239');
INSERT INTO `tp_region` VALUES ('6247', '栗子房镇', '4', '6239');
INSERT INTO `tp_region` VALUES ('6248', '大营镇', '4', '6239');
INSERT INTO `tp_region` VALUES ('6249', '塔岭满族镇', '4', '6239');
INSERT INTO `tp_region` VALUES ('6250', '仙人洞镇', '4', '6239');
INSERT INTO `tp_region` VALUES ('6251', '蓉花山镇', '4', '6239');
INSERT INTO `tp_region` VALUES ('6252', '长岭镇', '4', '6239');
INSERT INTO `tp_region` VALUES ('6253', '荷花山镇', '4', '6239');
INSERT INTO `tp_region` VALUES ('6254', '城山镇', '4', '6239');
INSERT INTO `tp_region` VALUES ('6255', '光明山镇', '4', '6239');
INSERT INTO `tp_region` VALUES ('6256', '大郑镇', '4', '6239');
INSERT INTO `tp_region` VALUES ('6257', '明阳镇', '4', '6239');
INSERT INTO `tp_region` VALUES ('6258', '吴炉镇', '4', '6239');
INSERT INTO `tp_region` VALUES ('6259', '王家镇', '4', '6239');
INSERT INTO `tp_region` VALUES ('6260', '鞍子山乡', '4', '6239');
INSERT INTO `tp_region` VALUES ('6261', '太平岭满族乡', '4', '6239');
INSERT INTO `tp_region` VALUES ('6262', '步云山乡', '4', '6239');
INSERT INTO `tp_region` VALUES ('6263', '桂云花满族乡', '4', '6239');
INSERT INTO `tp_region` VALUES ('6264', '兰店乡', '4', '6239');
INSERT INTO `tp_region` VALUES ('6265', '石城乡', '4', '6239');
INSERT INTO `tp_region` VALUES ('6266', '鞍山市', '2', '5827');
INSERT INTO `tp_region` VALUES ('6267', '市辖区', '3', '6266');
INSERT INTO `tp_region` VALUES ('6268', '铁东区', '3', '6266');
INSERT INTO `tp_region` VALUES ('6269', '长甸', '4', '6268');
INSERT INTO `tp_region` VALUES ('6270', '解放', '4', '6268');
INSERT INTO `tp_region` VALUES ('6271', '山南', '4', '6268');
INSERT INTO `tp_region` VALUES ('6272', '园林', '4', '6268');
INSERT INTO `tp_region` VALUES ('6273', '胜利', '4', '6268');
INSERT INTO `tp_region` VALUES ('6274', '站前', '4', '6268');
INSERT INTO `tp_region` VALUES ('6275', '钢城', '4', '6268');
INSERT INTO `tp_region` VALUES ('6276', '和平', '4', '6268');
INSERT INTO `tp_region` VALUES ('6277', '对炉', '4', '6268');
INSERT INTO `tp_region` VALUES ('6278', '东长甸', '4', '6268');
INSERT INTO `tp_region` VALUES ('6279', '湖南', '4', '6268');
INSERT INTO `tp_region` VALUES ('6280', '常青', '4', '6268');
INSERT INTO `tp_region` VALUES ('6281', '新兴', '4', '6268');
INSERT INTO `tp_region` VALUES ('6282', '铁西区', '3', '6266');
INSERT INTO `tp_region` VALUES ('6283', '启明街道', '4', '6282');
INSERT INTO `tp_region` VALUES ('6284', '繁荣街道', '4', '6282');
INSERT INTO `tp_region` VALUES ('6285', '八家子街道', '4', '6282');
INSERT INTO `tp_region` VALUES ('6286', '兴盛街道', '4', '6282');
INSERT INTO `tp_region` VALUES ('6287', '共和街道', '4', '6282');
INSERT INTO `tp_region` VALUES ('6288', '永乐街道', '4', '6282');
INSERT INTO `tp_region` VALUES ('6289', '北陶官街道', '4', '6282');
INSERT INTO `tp_region` VALUES ('6290', '南华街道', '4', '6282');
INSERT INTO `tp_region` VALUES ('6291', '大陆街道', '4', '6282');
INSERT INTO `tp_region` VALUES ('6292', '新陶官街道', '4', '6282');
INSERT INTO `tp_region` VALUES ('6293', '立山区', '3', '6266');
INSERT INTO `tp_region` VALUES ('6294', '友好', '4', '6293');
INSERT INTO `tp_region` VALUES ('6295', '双山', '4', '6293');
INSERT INTO `tp_region` VALUES ('6296', '立山', '4', '6293');
INSERT INTO `tp_region` VALUES ('6297', '曙光', '4', '6293');
INSERT INTO `tp_region` VALUES ('6298', '灵山', '4', '6293');
INSERT INTO `tp_region` VALUES ('6299', '深南', '4', '6293');
INSERT INTO `tp_region` VALUES ('6300', '深北', '4', '6293');
INSERT INTO `tp_region` VALUES ('6301', '沙河', '4', '6293');
INSERT INTO `tp_region` VALUES ('6302', '沙河镇', '4', '6293');
INSERT INTO `tp_region` VALUES ('6303', '千山区', '3', '6266');
INSERT INTO `tp_region` VALUES ('6304', '旧堡街道', '4', '6303');
INSERT INTO `tp_region` VALUES ('6305', '大孤山街道', '4', '6303');
INSERT INTO `tp_region` VALUES ('6306', '东鞍山镇', '4', '6303');
INSERT INTO `tp_region` VALUES ('6307', '唐家房镇', '4', '6303');
INSERT INTO `tp_region` VALUES ('6308', '大孤山镇', '4', '6303');
INSERT INTO `tp_region` VALUES ('6309', '千山镇', '4', '6303');
INSERT INTO `tp_region` VALUES ('6310', '齐大山镇', '4', '6303');
INSERT INTO `tp_region` VALUES ('6311', '达道湾镇', '4', '6303');
INSERT INTO `tp_region` VALUES ('6312', '宁远镇', '4', '6303');
INSERT INTO `tp_region` VALUES ('6313', '汤岗子镇', '4', '6303');
INSERT INTO `tp_region` VALUES ('6314', '鞍山高新区', '4', '6303');
INSERT INTO `tp_region` VALUES ('6315', '千山风景区管理委员会', '4', '6303');
INSERT INTO `tp_region` VALUES ('6316', '台安县', '3', '6266');
INSERT INTO `tp_region` VALUES ('6317', '台安镇', '4', '6316');
INSERT INTO `tp_region` VALUES ('6318', '西佛镇', '4', '6316');
INSERT INTO `tp_region` VALUES ('6319', '新开河镇', '4', '6316');
INSERT INTO `tp_region` VALUES ('6320', '黄沙坨镇', '4', '6316');
INSERT INTO `tp_region` VALUES ('6321', '高力房镇', '4', '6316');
INSERT INTO `tp_region` VALUES ('6322', '桑林镇', '4', '6316');
INSERT INTO `tp_region` VALUES ('6323', '富家镇', '4', '6316');
INSERT INTO `tp_region` VALUES ('6324', '达牛镇', '4', '6316');
INSERT INTO `tp_region` VALUES ('6325', '韭菜台镇', '4', '6316');
INSERT INTO `tp_region` VALUES ('6326', '新台镇', '4', '6316');
INSERT INTO `tp_region` VALUES ('6327', '桓洞镇', '4', '6316');
INSERT INTO `tp_region` VALUES ('6328', '新华农场', '4', '6316');
INSERT INTO `tp_region` VALUES ('6329', '洪家农牧场', '4', '6316');
INSERT INTO `tp_region` VALUES ('6330', '西平林场', '4', '6316');
INSERT INTO `tp_region` VALUES ('6331', '岫岩县', '3', '6266');
INSERT INTO `tp_region` VALUES ('6332', '岫岩镇', '4', '6331');
INSERT INTO `tp_region` VALUES ('6333', '三家子镇', '4', '6331');
INSERT INTO `tp_region` VALUES ('6334', '石庙子镇', '4', '6331');
INSERT INTO `tp_region` VALUES ('6335', '黄花甸镇', '4', '6331');
INSERT INTO `tp_region` VALUES ('6336', '大营子镇', '4', '6331');
INSERT INTO `tp_region` VALUES ('6337', '苏子沟镇', '4', '6331');
INSERT INTO `tp_region` VALUES ('6338', '偏岭镇', '4', '6331');
INSERT INTO `tp_region` VALUES ('6339', '哈达碑镇', '4', '6331');
INSERT INTO `tp_region` VALUES ('6340', '新甸镇', '4', '6331');
INSERT INTO `tp_region` VALUES ('6341', '洋河镇', '4', '6331');
INSERT INTO `tp_region` VALUES ('6342', '杨家堡镇', '4', '6331');
INSERT INTO `tp_region` VALUES ('6343', '汤沟镇', '4', '6331');
INSERT INTO `tp_region` VALUES ('6344', '石灰窑镇', '4', '6331');
INSERT INTO `tp_region` VALUES ('6345', '前营子镇', '4', '6331');
INSERT INTO `tp_region` VALUES ('6346', '龙潭镇', '4', '6331');
INSERT INTO `tp_region` VALUES ('6347', '牧牛乡', '4', '6331');
INSERT INTO `tp_region` VALUES ('6348', '韭菜沟乡', '4', '6331');
INSERT INTO `tp_region` VALUES ('6349', '大房身乡', '4', '6331');
INSERT INTO `tp_region` VALUES ('6350', '朝阳乡', '4', '6331');
INSERT INTO `tp_region` VALUES ('6351', '红旗营子乡', '4', '6331');
INSERT INTO `tp_region` VALUES ('6352', '岭沟乡', '4', '6331');
INSERT INTO `tp_region` VALUES ('6353', '哨子河乡', '4', '6331');
INSERT INTO `tp_region` VALUES ('6354', '海城市', '3', '6266');
INSERT INTO `tp_region` VALUES ('6355', '海州街道', '4', '6354');
INSERT INTO `tp_region` VALUES ('6356', '兴海街道', '4', '6354');
INSERT INTO `tp_region` VALUES ('6357', '响堂街道', '4', '6354');
INSERT INTO `tp_region` VALUES ('6358', '东四街道', '4', '6354');
INSERT INTO `tp_region` VALUES ('6359', '孤山镇', '4', '6354');
INSERT INTO `tp_region` VALUES ('6360', '岔沟镇', '4', '6354');
INSERT INTO `tp_region` VALUES ('6361', '接文镇', '4', '6354');
INSERT INTO `tp_region` VALUES ('6362', '析木镇', '4', '6354');
INSERT INTO `tp_region` VALUES ('6363', '马风镇', '4', '6354');
INSERT INTO `tp_region` VALUES ('6364', '牌楼镇', '4', '6354');
INSERT INTO `tp_region` VALUES ('6365', '八里镇', '4', '6354');
INSERT INTO `tp_region` VALUES ('6366', '毛祁镇', '4', '6354');
INSERT INTO `tp_region` VALUES ('6367', '英落镇', '4', '6354');
INSERT INTO `tp_region` VALUES ('6368', '感王镇', '4', '6354');
INSERT INTO `tp_region` VALUES ('6369', '西柳镇', '4', '6354');
INSERT INTO `tp_region` VALUES ('6370', '中小镇', '4', '6354');
INSERT INTO `tp_region` VALUES ('6371', '王石镇', '4', '6354');
INSERT INTO `tp_region` VALUES ('6372', '南台镇', '4', '6354');
INSERT INTO `tp_region` VALUES ('6373', '甘泉镇', '4', '6354');
INSERT INTO `tp_region` VALUES ('6374', '大屯镇', '4', '6354');
INSERT INTO `tp_region` VALUES ('6375', '腾鳌镇', '4', '6354');
INSERT INTO `tp_region` VALUES ('6376', '东四方台温泉管理区', '4', '6354');
INSERT INTO `tp_region` VALUES ('6377', '耿庄镇', '4', '6354');
INSERT INTO `tp_region` VALUES ('6378', '牛庄镇', '4', '6354');
INSERT INTO `tp_region` VALUES ('6379', '西四镇', '4', '6354');
INSERT INTO `tp_region` VALUES ('6380', '望台镇', '4', '6354');
INSERT INTO `tp_region` VALUES ('6381', '温香镇', '4', '6354');
INSERT INTO `tp_region` VALUES ('6382', '高坨镇', '4', '6354');
INSERT INTO `tp_region` VALUES ('6383', '海城经济开发区', '4', '6354');
INSERT INTO `tp_region` VALUES ('6384', '抚顺市', '2', '5827');
INSERT INTO `tp_region` VALUES ('6385', '市辖区', '3', '6384');
INSERT INTO `tp_region` VALUES ('6386', '新抚区', '3', '6384');
INSERT INTO `tp_region` VALUES ('6387', '站前街道', '4', '6386');
INSERT INTO `tp_region` VALUES ('6388', '东公园街道', '4', '6386');
INSERT INTO `tp_region` VALUES ('6389', '福民街道', '4', '6386');
INSERT INTO `tp_region` VALUES ('6390', '新抚街道', '4', '6386');
INSERT INTO `tp_region` VALUES ('6391', '榆林街道', '4', '6386');
INSERT INTO `tp_region` VALUES ('6392', '永安台街道', '4', '6386');
INSERT INTO `tp_region` VALUES ('6393', '千金街道', '4', '6386');
INSERT INTO `tp_region` VALUES ('6394', '南阳街道', '4', '6386');
INSERT INTO `tp_region` VALUES ('6395', '东洲区', '3', '6384');
INSERT INTO `tp_region` VALUES ('6396', '东洲街道', '4', '6395');
INSERT INTO `tp_region` VALUES ('6397', '张甸街道', '4', '6395');
INSERT INTO `tp_region` VALUES ('6398', '搭连街道', '4', '6395');
INSERT INTO `tp_region` VALUES ('6399', '龙凤街道', '4', '6395');
INSERT INTO `tp_region` VALUES ('6400', '新屯街道', '4', '6395');
INSERT INTO `tp_region` VALUES ('6401', '万新街道', '4', '6395');
INSERT INTO `tp_region` VALUES ('6402', '老虎台街道', '4', '6395');
INSERT INTO `tp_region` VALUES ('6403', '平山街道', '4', '6395');
INSERT INTO `tp_region` VALUES ('6404', '南花园街道', '4', '6395');
INSERT INTO `tp_region` VALUES ('6405', '刘山街道', '4', '6395');
INSERT INTO `tp_region` VALUES ('6406', '章党街道', '4', '6395');
INSERT INTO `tp_region` VALUES ('6407', '千金乡', '4', '6395');
INSERT INTO `tp_region` VALUES ('6408', '碾盘乡', '4', '6395');
INSERT INTO `tp_region` VALUES ('6409', '望花区', '3', '6384');
INSERT INTO `tp_region` VALUES ('6410', '田屯街道', '4', '6409');
INSERT INTO `tp_region` VALUES ('6411', '工农街道', '4', '6409');
INSERT INTO `tp_region` VALUES ('6412', '建设街道', '4', '6409');
INSERT INTO `tp_region` VALUES ('6413', '和平街道', '4', '6409');
INSERT INTO `tp_region` VALUES ('6414', '光明街道', '4', '6409');
INSERT INTO `tp_region` VALUES ('6415', '朴屯街道', '4', '6409');
INSERT INTO `tp_region` VALUES ('6416', '演武街道', '4', '6409');
INSERT INTO `tp_region` VALUES ('6417', '五老屯街道', '4', '6409');
INSERT INTO `tp_region` VALUES ('6418', '古城子街道', '4', '6409');
INSERT INTO `tp_region` VALUES ('6419', '新民街道', '4', '6409');
INSERT INTO `tp_region` VALUES ('6420', '李石街道', '4', '6409');
INSERT INTO `tp_region` VALUES ('6421', '塔峪镇', '4', '6409');
INSERT INTO `tp_region` VALUES ('6422', '顺城区', '3', '6384');
INSERT INTO `tp_region` VALUES ('6423', '河东街道', '4', '6422');
INSERT INTO `tp_region` VALUES ('6424', '长春街道', '4', '6422');
INSERT INTO `tp_region` VALUES ('6425', '葛布街道', '4', '6422');
INSERT INTO `tp_region` VALUES ('6426', '将军堡街道', '4', '6422');
INSERT INTO `tp_region` VALUES ('6427', '新华街道', '4', '6422');
INSERT INTO `tp_region` VALUES ('6428', '抚顺城街道', '4', '6422');
INSERT INTO `tp_region` VALUES ('6429', '前甸镇', '4', '6422');
INSERT INTO `tp_region` VALUES ('6430', '河北乡', '4', '6422');
INSERT INTO `tp_region` VALUES ('6431', '会元乡', '4', '6422');
INSERT INTO `tp_region` VALUES ('6432', '抚顺县', '3', '6384');
INSERT INTO `tp_region` VALUES ('6433', '石文镇', '4', '6432');
INSERT INTO `tp_region` VALUES ('6434', '后安镇', '4', '6432');
INSERT INTO `tp_region` VALUES ('6435', '章党镇', '4', '6432');
INSERT INTO `tp_region` VALUES ('6436', '哈达镇', '4', '6432');
INSERT INTO `tp_region` VALUES ('6437', '马圈子乡', '4', '6432');
INSERT INTO `tp_region` VALUES ('6438', '上马乡', '4', '6432');
INSERT INTO `tp_region` VALUES ('6439', '救兵乡', '4', '6432');
INSERT INTO `tp_region` VALUES ('6440', '峡河乡', '4', '6432');
INSERT INTO `tp_region` VALUES ('6441', '海浪乡', '4', '6432');
INSERT INTO `tp_region` VALUES ('6442', '拉古满族乡', '4', '6432');
INSERT INTO `tp_region` VALUES ('6443', '兰山乡', '4', '6432');
INSERT INTO `tp_region` VALUES ('6444', '汤图满族乡', '4', '6432');
INSERT INTO `tp_region` VALUES ('6445', '新宾满族自治县', '3', '6384');
INSERT INTO `tp_region` VALUES ('6446', '新宾镇', '4', '6445');
INSERT INTO `tp_region` VALUES ('6447', '旺清门镇', '4', '6445');
INSERT INTO `tp_region` VALUES ('6448', '永陵镇', '4', '6445');
INSERT INTO `tp_region` VALUES ('6449', '平顶山镇', '4', '6445');
INSERT INTO `tp_region` VALUES ('6450', '大四平镇', '4', '6445');
INSERT INTO `tp_region` VALUES ('6451', '苇子峪镇', '4', '6445');
INSERT INTO `tp_region` VALUES ('6452', '木奇镇', '4', '6445');
INSERT INTO `tp_region` VALUES ('6453', '上夹河镇', '4', '6445');
INSERT INTO `tp_region` VALUES ('6454', '南杂木镇', '4', '6445');
INSERT INTO `tp_region` VALUES ('6455', '红升乡', '4', '6445');
INSERT INTO `tp_region` VALUES ('6456', '响水河子乡', '4', '6445');
INSERT INTO `tp_region` VALUES ('6457', '红庙子乡', '4', '6445');
INSERT INTO `tp_region` VALUES ('6458', '北四平乡', '4', '6445');
INSERT INTO `tp_region` VALUES ('6459', '榆树乡', '4', '6445');
INSERT INTO `tp_region` VALUES ('6460', '下夹河乡', '4', '6445');
INSERT INTO `tp_region` VALUES ('6461', '清原满族自治县', '3', '6384');
INSERT INTO `tp_region` VALUES ('6462', '清原镇', '4', '6461');
INSERT INTO `tp_region` VALUES ('6463', '红透山镇', '4', '6461');
INSERT INTO `tp_region` VALUES ('6464', '草市镇', '4', '6461');
INSERT INTO `tp_region` VALUES ('6465', '英额门镇', '4', '6461');
INSERT INTO `tp_region` VALUES ('6466', '南口前镇', '4', '6461');
INSERT INTO `tp_region` VALUES ('6467', '南山城镇', '4', '6461');
INSERT INTO `tp_region` VALUES ('6468', '湾甸子镇', '4', '6461');
INSERT INTO `tp_region` VALUES ('6469', '大孤家镇', '4', '6461');
INSERT INTO `tp_region` VALUES ('6470', '夏家堡镇', '4', '6461');
INSERT INTO `tp_region` VALUES ('6471', '土口子乡', '4', '6461');
INSERT INTO `tp_region` VALUES ('6472', '北三家乡', '4', '6461');
INSERT INTO `tp_region` VALUES ('6473', '敖家堡乡', '4', '6461');
INSERT INTO `tp_region` VALUES ('6474', '大苏河乡', '4', '6461');
INSERT INTO `tp_region` VALUES ('6475', '枸乃甸乡', '4', '6461');
INSERT INTO `tp_region` VALUES ('6476', '本溪市', '2', '5827');
INSERT INTO `tp_region` VALUES ('6477', '市辖区', '3', '6476');
INSERT INTO `tp_region` VALUES ('6478', '平山区', '3', '6476');
INSERT INTO `tp_region` VALUES ('6479', '南地街道', '4', '6478');
INSERT INTO `tp_region` VALUES ('6480', '工人街道', '4', '6478');
INSERT INTO `tp_region` VALUES ('6481', '平山街道', '4', '6478');
INSERT INTO `tp_region` VALUES ('6482', '东明街道', '4', '6478');
INSERT INTO `tp_region` VALUES ('6483', '崔东街道', '4', '6478');
INSERT INTO `tp_region` VALUES ('6484', '站前街道', '4', '6478');
INSERT INTO `tp_region` VALUES ('6485', '千金街道', '4', '6478');
INSERT INTO `tp_region` VALUES ('6486', '北台街道', '4', '6478');
INSERT INTO `tp_region` VALUES ('6487', '桥头镇', '4', '6478');
INSERT INTO `tp_region` VALUES ('6488', '溪湖区', '3', '6476');
INSERT INTO `tp_region` VALUES ('6489', '河东街道', '4', '6488');
INSERT INTO `tp_region` VALUES ('6490', '河西街道', '4', '6488');
INSERT INTO `tp_region` VALUES ('6491', '彩屯街道', '4', '6488');
INSERT INTO `tp_region` VALUES ('6492', '竖井街道', '4', '6488');
INSERT INTO `tp_region` VALUES ('6493', '彩北街道', '4', '6488');
INSERT INTO `tp_region` VALUES ('6494', '东风街道', '4', '6488');
INSERT INTO `tp_region` VALUES ('6495', '火连寨镇', '4', '6488');
INSERT INTO `tp_region` VALUES ('6496', '歪头山镇', '4', '6488');
INSERT INTO `tp_region` VALUES ('6497', '石桥子镇', '4', '6488');
INSERT INTO `tp_region` VALUES ('6498', '张其寨乡', '4', '6488');
INSERT INTO `tp_region` VALUES ('6499', '明山区', '3', '6476');
INSERT INTO `tp_region` VALUES ('6500', '金山街道', '4', '6499');
INSERT INTO `tp_region` VALUES ('6501', '北地街道', '4', '6499');
INSERT INTO `tp_region` VALUES ('6502', '高峪街道', '4', '6499');
INSERT INTO `tp_region` VALUES ('6503', '明山街道', '4', '6499');
INSERT INTO `tp_region` VALUES ('6504', '东兴街道', '4', '6499');
INSERT INTO `tp_region` VALUES ('6505', '新明街道', '4', '6499');
INSERT INTO `tp_region` VALUES ('6506', '牛心台街道', '4', '6499');
INSERT INTO `tp_region` VALUES ('6507', '卧龙街道', '4', '6499');
INSERT INTO `tp_region` VALUES ('6508', '高台子镇', '4', '6499');
INSERT INTO `tp_region` VALUES ('6509', '南芬区', '3', '6476');
INSERT INTO `tp_region` VALUES ('6510', '南芬街道', '4', '6509');
INSERT INTO `tp_region` VALUES ('6511', '铁山街道', '4', '6509');
INSERT INTO `tp_region` VALUES ('6512', '郭家街道', '4', '6509');
INSERT INTO `tp_region` VALUES ('6513', '下马塘镇', '4', '6509');
INSERT INTO `tp_region` VALUES ('6514', '思山岭满族乡', '4', '6509');
INSERT INTO `tp_region` VALUES ('6515', '本溪满族自治县', '3', '6476');
INSERT INTO `tp_region` VALUES ('6516', '观音阁街道', '4', '6515');
INSERT INTO `tp_region` VALUES ('6517', '小市镇', '4', '6515');
INSERT INTO `tp_region` VALUES ('6518', '草河掌镇', '4', '6515');
INSERT INTO `tp_region` VALUES ('6519', '草河城镇', '4', '6515');
INSERT INTO `tp_region` VALUES ('6520', '草河口镇', '4', '6515');
INSERT INTO `tp_region` VALUES ('6521', '连山关镇', '4', '6515');
INSERT INTO `tp_region` VALUES ('6522', '清河城镇', '4', '6515');
INSERT INTO `tp_region` VALUES ('6523', '田师傅镇', '4', '6515');
INSERT INTO `tp_region` VALUES ('6524', '南甸镇', '4', '6515');
INSERT INTO `tp_region` VALUES ('6525', '碱厂镇', '4', '6515');
INSERT INTO `tp_region` VALUES ('6526', '高官镇', '4', '6515');
INSERT INTO `tp_region` VALUES ('6527', '东营房乡', '4', '6515');
INSERT INTO `tp_region` VALUES ('6528', '桓仁满族自治县', '3', '6476');
INSERT INTO `tp_region` VALUES ('6529', '江城街道', '4', '6528');
INSERT INTO `tp_region` VALUES ('6530', '桓仁镇', '4', '6528');
INSERT INTO `tp_region` VALUES ('6531', '普乐堡镇', '4', '6528');
INSERT INTO `tp_region` VALUES ('6532', '二棚甸子镇', '4', '6528');
INSERT INTO `tp_region` VALUES ('6533', '沙尖子镇', '4', '6528');
INSERT INTO `tp_region` VALUES ('6534', '五里甸子镇', '4', '6528');
INSERT INTO `tp_region` VALUES ('6535', '八里甸子镇', '4', '6528');
INSERT INTO `tp_region` VALUES ('6536', '华来镇', '4', '6528');
INSERT INTO `tp_region` VALUES ('6537', '古城镇', '4', '6528');
INSERT INTO `tp_region` VALUES ('6538', '雅河朝鲜族乡', '4', '6528');
INSERT INTO `tp_region` VALUES ('6539', '向阳乡', '4', '6528');
INSERT INTO `tp_region` VALUES ('6540', '黑沟乡', '4', '6528');
INSERT INTO `tp_region` VALUES ('6541', '北甸子乡', '4', '6528');
INSERT INTO `tp_region` VALUES ('6542', '丹东市', '2', '5827');
INSERT INTO `tp_region` VALUES ('6543', '市辖区', '3', '6542');
INSERT INTO `tp_region` VALUES ('6544', '元宝区', '3', '6542');
INSERT INTO `tp_region` VALUES ('6545', '六道口街道', '4', '6544');
INSERT INTO `tp_region` VALUES ('6546', '七道街道', '4', '6544');
INSERT INTO `tp_region` VALUES ('6547', '八道街道', '4', '6544');
INSERT INTO `tp_region` VALUES ('6548', '九道街道', '4', '6544');
INSERT INTO `tp_region` VALUES ('6549', '广济街道', '4', '6544');
INSERT INTO `tp_region` VALUES ('6550', '兴东街道', '4', '6544');
INSERT INTO `tp_region` VALUES ('6551', '金山镇', '4', '6544');
INSERT INTO `tp_region` VALUES ('6552', '振兴区', '3', '6542');
INSERT INTO `tp_region` VALUES ('6553', '头道桥街道', '4', '6552');
INSERT INTO `tp_region` VALUES ('6554', '站前街道', '4', '6552');
INSERT INTO `tp_region` VALUES ('6555', '临江街道', '4', '6552');
INSERT INTO `tp_region` VALUES ('6556', '六道街道', '4', '6552');
INSERT INTO `tp_region` VALUES ('6557', '帽盔山街道', '4', '6552');
INSERT INTO `tp_region` VALUES ('6558', '纤维街道', '4', '6552');
INSERT INTO `tp_region` VALUES ('6559', '永昌街道', '4', '6552');
INSERT INTO `tp_region` VALUES ('6560', '花园街道', '4', '6552');
INSERT INTO `tp_region` VALUES ('6561', '浪头镇', '4', '6552');
INSERT INTO `tp_region` VALUES ('6562', '安民镇', '4', '6552');
INSERT INTO `tp_region` VALUES ('6563', '振安区', '3', '6542');
INSERT INTO `tp_region` VALUES ('6564', '鸭绿江街道', '4', '6563');
INSERT INTO `tp_region` VALUES ('6565', '金矿街道', '4', '6563');
INSERT INTO `tp_region` VALUES ('6566', '珍珠街道', '4', '6563');
INSERT INTO `tp_region` VALUES ('6567', '太平湾街道', '4', '6563');
INSERT INTO `tp_region` VALUES ('6568', '同兴镇', '4', '6563');
INSERT INTO `tp_region` VALUES ('6569', '五龙背镇', '4', '6563');
INSERT INTO `tp_region` VALUES ('6570', '楼房镇', '4', '6563');
INSERT INTO `tp_region` VALUES ('6571', '九连城镇', '4', '6563');
INSERT INTO `tp_region` VALUES ('6572', '汤山城镇', '4', '6563');
INSERT INTO `tp_region` VALUES ('6573', '宽甸满族自治县', '3', '6542');
INSERT INTO `tp_region` VALUES ('6574', '宽甸镇', '4', '6573');
INSERT INTO `tp_region` VALUES ('6575', '灌水镇', '4', '6573');
INSERT INTO `tp_region` VALUES ('6576', '硼海镇', '4', '6573');
INSERT INTO `tp_region` VALUES ('6577', '红石镇', '4', '6573');
INSERT INTO `tp_region` VALUES ('6578', '毛甸子镇', '4', '6573');
INSERT INTO `tp_region` VALUES ('6579', '长甸镇', '4', '6573');
INSERT INTO `tp_region` VALUES ('6580', '永甸镇', '4', '6573');
INSERT INTO `tp_region` VALUES ('6581', '太平哨镇', '4', '6573');
INSERT INTO `tp_region` VALUES ('6582', '青山沟镇', '4', '6573');
INSERT INTO `tp_region` VALUES ('6583', '牛毛坞镇', '4', '6573');
INSERT INTO `tp_region` VALUES ('6584', '大川头镇', '4', '6573');
INSERT INTO `tp_region` VALUES ('6585', '青椅山镇', '4', '6573');
INSERT INTO `tp_region` VALUES ('6586', '杨木川镇', '4', '6573');
INSERT INTO `tp_region` VALUES ('6587', '虎山镇', '4', '6573');
INSERT INTO `tp_region` VALUES ('6588', '振江镇', '4', '6573');
INSERT INTO `tp_region` VALUES ('6589', '步达远镇', '4', '6573');
INSERT INTO `tp_region` VALUES ('6590', '大西岔镇', '4', '6573');
INSERT INTO `tp_region` VALUES ('6591', '八河川镇', '4', '6573');
INSERT INTO `tp_region` VALUES ('6592', '双山子镇', '4', '6573');
INSERT INTO `tp_region` VALUES ('6593', '石湖沟乡', '4', '6573');
INSERT INTO `tp_region` VALUES ('6594', '古楼子乡', '4', '6573');
INSERT INTO `tp_region` VALUES ('6595', '下露河朝鲜族乡', '4', '6573');
INSERT INTO `tp_region` VALUES ('6596', '东港市', '3', '6542');
INSERT INTO `tp_region` VALUES ('6597', '大东街道', '4', '6596');
INSERT INTO `tp_region` VALUES ('6598', '新兴街道', '4', '6596');
INSERT INTO `tp_region` VALUES ('6599', '新城街道', '4', '6596');
INSERT INTO `tp_region` VALUES ('6600', '孤山镇', '4', '6596');
INSERT INTO `tp_region` VALUES ('6601', '汤池镇', '4', '6596');
INSERT INTO `tp_region` VALUES ('6602', '前阳镇', '4', '6596');
INSERT INTO `tp_region` VALUES ('6603', '长安镇', '4', '6596');
INSERT INTO `tp_region` VALUES ('6604', '十字街镇', '4', '6596');
INSERT INTO `tp_region` VALUES ('6605', '长山镇', '4', '6596');
INSERT INTO `tp_region` VALUES ('6606', '北井子镇', '4', '6596');
INSERT INTO `tp_region` VALUES ('6607', '椅圈镇', '4', '6596');
INSERT INTO `tp_region` VALUES ('6608', '黄土坎镇', '4', '6596');
INSERT INTO `tp_region` VALUES ('6609', '马家店镇', '4', '6596');
INSERT INTO `tp_region` VALUES ('6610', '龙王庙满族锡伯族镇', '4', '6596');
INSERT INTO `tp_region` VALUES ('6611', '小甸子镇', '4', '6596');
INSERT INTO `tp_region` VALUES ('6612', '菩萨庙镇', '4', '6596');
INSERT INTO `tp_region` VALUES ('6613', '黑沟镇', '4', '6596');
INSERT INTO `tp_region` VALUES ('6614', '新农镇', '4', '6596');
INSERT INTO `tp_region` VALUES ('6615', '合隆乡', '4', '6596');
INSERT INTO `tp_region` VALUES ('6616', '示范农场', '4', '6596');
INSERT INTO `tp_region` VALUES ('6617', '黄土坎农场', '4', '6596');
INSERT INTO `tp_region` VALUES ('6618', '海洋红农场', '4', '6596');
INSERT INTO `tp_region` VALUES ('6619', '兴隆农场', '4', '6596');
INSERT INTO `tp_region` VALUES ('6620', '五四农场', '4', '6596');
INSERT INTO `tp_region` VALUES ('6621', '凤城市', '3', '6542');
INSERT INTO `tp_region` VALUES ('6622', '凤凰城街道', '4', '6621');
INSERT INTO `tp_region` VALUES ('6623', '凤山街道', '4', '6621');
INSERT INTO `tp_region` VALUES ('6624', '草河街道', '4', '6621');
INSERT INTO `tp_region` VALUES ('6625', '宝山镇', '4', '6621');
INSERT INTO `tp_region` VALUES ('6626', '白旗镇', '4', '6621');
INSERT INTO `tp_region` VALUES ('6627', '沙里寨镇', '4', '6621');
INSERT INTO `tp_region` VALUES ('6628', '红旗镇', '4', '6621');
INSERT INTO `tp_region` VALUES ('6629', '蓝旗镇', '4', '6621');
INSERT INTO `tp_region` VALUES ('6630', '边门镇', '4', '6621');
INSERT INTO `tp_region` VALUES ('6631', '大堡蒙古族镇', '4', '6621');
INSERT INTO `tp_region` VALUES ('6632', '东汤镇', '4', '6621');
INSERT INTO `tp_region` VALUES ('6633', '石城镇', '4', '6621');
INSERT INTO `tp_region` VALUES ('6634', '大兴镇', '4', '6621');
INSERT INTO `tp_region` VALUES ('6635', '爱阳镇', '4', '6621');
INSERT INTO `tp_region` VALUES ('6636', '赛马镇', '4', '6621');
INSERT INTO `tp_region` VALUES ('6637', '弟兄山镇', '4', '6621');
INSERT INTO `tp_region` VALUES ('6638', '鸡冠山镇', '4', '6621');
INSERT INTO `tp_region` VALUES ('6639', '刘家河镇', '4', '6621');
INSERT INTO `tp_region` VALUES ('6640', '通远堡镇', '4', '6621');
INSERT INTO `tp_region` VALUES ('6641', '四门子镇', '4', '6621');
INSERT INTO `tp_region` VALUES ('6642', '青城子镇', '4', '6621');
INSERT INTO `tp_region` VALUES ('6643', '锦州市', '2', '5827');
INSERT INTO `tp_region` VALUES ('6644', '市辖区', '3', '6643');
INSERT INTO `tp_region` VALUES ('6645', '古塔区', '3', '6643');
INSERT INTO `tp_region` VALUES ('6646', '天安街道', '4', '6645');
INSERT INTO `tp_region` VALUES ('6647', '石油街道', '4', '6645');
INSERT INTO `tp_region` VALUES ('6648', '北街街道', '4', '6645');
INSERT INTO `tp_region` VALUES ('6649', '敬业街道', '4', '6645');
INSERT INTO `tp_region` VALUES ('6650', '保安街道', '4', '6645');
INSERT INTO `tp_region` VALUES ('6651', '南街街道', '4', '6645');
INSERT INTO `tp_region` VALUES ('6652', '饶阳街道', '4', '6645');
INSERT INTO `tp_region` VALUES ('6653', '站前街道', '4', '6645');
INSERT INTO `tp_region` VALUES ('6654', '士英街道', '4', '6645');
INSERT INTO `tp_region` VALUES ('6655', '凌河区', '3', '6643');
INSERT INTO `tp_region` VALUES ('6656', '正大街道', '4', '6655');
INSERT INTO `tp_region` VALUES ('6657', '石桥子街道', '4', '6655');
INSERT INTO `tp_region` VALUES ('6658', '龙江街道', '4', '6655');
INSERT INTO `tp_region` VALUES ('6659', '榴花街道', '4', '6655');
INSERT INTO `tp_region` VALUES ('6660', '铁新街道', '4', '6655');
INSERT INTO `tp_region` VALUES ('6661', '凌安街道', '4', '6655');
INSERT INTO `tp_region` VALUES ('6662', '菊园街道', '4', '6655');
INSERT INTO `tp_region` VALUES ('6663', '康宁街道', '4', '6655');
INSERT INTO `tp_region` VALUES ('6664', '锦铁街道', '4', '6655');
INSERT INTO `tp_region` VALUES ('6665', '马家街道', '4', '6655');
INSERT INTO `tp_region` VALUES ('6666', '百股街道', '4', '6655');
INSERT INTO `tp_region` VALUES ('6667', '锦州北山农工商总公司', '4', '6655');
INSERT INTO `tp_region` VALUES ('6668', '太和区', '3', '6643');
INSERT INTO `tp_region` VALUES ('6669', '太和街道', '4', '6668');
INSERT INTO `tp_region` VALUES ('6670', '兴隆街道', '4', '6668');
INSERT INTO `tp_region` VALUES ('6671', '汤河子街道', '4', '6668');
INSERT INTO `tp_region` VALUES ('6672', '凌西街道', '4', '6668');
INSERT INTO `tp_region` VALUES ('6673', '凌南街道', '4', '6668');
INSERT INTO `tp_region` VALUES ('6674', '大薛街道', '4', '6668');
INSERT INTO `tp_region` VALUES ('6675', '王家街道', '4', '6668');
INSERT INTO `tp_region` VALUES ('6676', '天桥街道', '4', '6668');
INSERT INTO `tp_region` VALUES ('6677', '杏山街道', '4', '6668');
INSERT INTO `tp_region` VALUES ('6678', '女儿河乡', '4', '6668');
INSERT INTO `tp_region` VALUES ('6679', '钟屯乡', '4', '6668');
INSERT INTO `tp_region` VALUES ('6680', '营盘乡', '4', '6668');
INSERT INTO `tp_region` VALUES ('6681', '新民乡', '4', '6668');
INSERT INTO `tp_region` VALUES ('6682', '锦州市果树农场', '4', '6668');
INSERT INTO `tp_region` VALUES ('6683', '黑山县', '3', '6643');
INSERT INTO `tp_region` VALUES ('6684', '黑山镇', '4', '6683');
INSERT INTO `tp_region` VALUES ('6685', '芳山镇', '4', '6683');
INSERT INTO `tp_region` VALUES ('6686', '白厂门镇', '4', '6683');
INSERT INTO `tp_region` VALUES ('6687', '常兴镇', '4', '6683');
INSERT INTO `tp_region` VALUES ('6688', '姜屯镇', '4', '6683');
INSERT INTO `tp_region` VALUES ('6689', '励家镇', '4', '6683');
INSERT INTO `tp_region` VALUES ('6690', '绕阳河镇', '4', '6683');
INSERT INTO `tp_region` VALUES ('6691', '半拉门镇', '4', '6683');
INSERT INTO `tp_region` VALUES ('6692', '无梁殿镇', '4', '6683');
INSERT INTO `tp_region` VALUES ('6693', '胡家镇', '4', '6683');
INSERT INTO `tp_region` VALUES ('6694', '新立屯镇', '4', '6683');
INSERT INTO `tp_region` VALUES ('6695', '八道壕镇', '4', '6683');
INSERT INTO `tp_region` VALUES ('6696', '大虎山镇', '4', '6683');
INSERT INTO `tp_region` VALUES ('6697', '四家子镇', '4', '6683');
INSERT INTO `tp_region` VALUES ('6698', '新兴镇', '4', '6683');
INSERT INTO `tp_region` VALUES ('6699', '太和镇', '4', '6683');
INSERT INTO `tp_region` VALUES ('6700', '英城子乡', '4', '6683');
INSERT INTO `tp_region` VALUES ('6701', '镇安乡', '4', '6683');
INSERT INTO `tp_region` VALUES ('6702', '段家乡', '4', '6683');
INSERT INTO `tp_region` VALUES ('6703', '大兴乡', '4', '6683');
INSERT INTO `tp_region` VALUES ('6704', '薛屯乡', '4', '6683');
INSERT INTO `tp_region` VALUES ('6705', '辽宁省锦州市小东种畜场', '4', '6683');
INSERT INTO `tp_region` VALUES ('6706', '义县', '3', '6643');
INSERT INTO `tp_region` VALUES ('6707', '义州镇', '4', '6706');
INSERT INTO `tp_region` VALUES ('6708', '刘龙台镇', '4', '6706');
INSERT INTO `tp_region` VALUES ('6709', '七里河镇', '4', '6706');
INSERT INTO `tp_region` VALUES ('6710', '大榆树堡镇', '4', '6706');
INSERT INTO `tp_region` VALUES ('6711', '稍户营子镇', '4', '6706');
INSERT INTO `tp_region` VALUES ('6712', '九道岭镇', '4', '6706');
INSERT INTO `tp_region` VALUES ('6713', '高台子镇', '4', '6706');
INSERT INTO `tp_region` VALUES ('6714', '瓦子峪镇', '4', '6706');
INSERT INTO `tp_region` VALUES ('6715', '城关满族乡', '4', '6706');
INSERT INTO `tp_region` VALUES ('6716', '头道河满族乡', '4', '6706');
INSERT INTO `tp_region` VALUES ('6717', '地藏寺满族乡', '4', '6706');
INSERT INTO `tp_region` VALUES ('6718', '留龙沟满族乡', '4', '6706');
INSERT INTO `tp_region` VALUES ('6719', '大定堡满族乡', '4', '6706');
INSERT INTO `tp_region` VALUES ('6720', '前杨乡', '4', '6706');
INSERT INTO `tp_region` VALUES ('6721', '白庙子乡', '4', '6706');
INSERT INTO `tp_region` VALUES ('6722', '聚粮屯乡', '4', '6706');
INSERT INTO `tp_region` VALUES ('6723', '张家堡乡', '4', '6706');
INSERT INTO `tp_region` VALUES ('6724', '头台满族乡', '4', '6706');
INSERT INTO `tp_region` VALUES ('6725', '凌海市', '3', '6643');
INSERT INTO `tp_region` VALUES ('6726', '大凌河街道', '4', '6725');
INSERT INTO `tp_region` VALUES ('6727', '金城街道', '4', '6725');
INSERT INTO `tp_region` VALUES ('6728', '石山镇', '4', '6725');
INSERT INTO `tp_region` VALUES ('6729', '余积镇', '4', '6725');
INSERT INTO `tp_region` VALUES ('6730', '双羊镇', '4', '6725');
INSERT INTO `tp_region` VALUES ('6731', '班吉塔镇', '4', '6725');
INSERT INTO `tp_region` VALUES ('6732', '沈家台镇', '4', '6725');
INSERT INTO `tp_region` VALUES ('6733', '三台子镇', '4', '6725');
INSERT INTO `tp_region` VALUES ('6734', '右卫满族镇', '4', '6725');
INSERT INTO `tp_region` VALUES ('6735', '阎家镇', '4', '6725');
INSERT INTO `tp_region` VALUES ('6736', '新庄子镇', '4', '6725');
INSERT INTO `tp_region` VALUES ('6737', '娘娘宫镇', '4', '6725');
INSERT INTO `tp_region` VALUES ('6738', '翠岩镇', '4', '6725');
INSERT INTO `tp_region` VALUES ('6739', '松山镇', '4', '6725');
INSERT INTO `tp_region` VALUES ('6740', '大业乡', '4', '6725');
INSERT INTO `tp_region` VALUES ('6741', '西八千乡', '4', '6725');
INSERT INTO `tp_region` VALUES ('6742', '建业乡', '4', '6725');
INSERT INTO `tp_region` VALUES ('6743', '温滴楼满族乡', '4', '6725');
INSERT INTO `tp_region` VALUES ('6744', '板石沟乡', '4', '6725');
INSERT INTO `tp_region` VALUES ('6745', '白台子乡', '4', '6725');
INSERT INTO `tp_region` VALUES ('6746', '谢屯乡', '4', '6725');
INSERT INTO `tp_region` VALUES ('6747', '安屯乡', '4', '6725');
INSERT INTO `tp_region` VALUES ('6748', '辽宁省金城原种场', '4', '6725');
INSERT INTO `tp_region` VALUES ('6749', '大有农场', '4', '6725');
INSERT INTO `tp_region` VALUES ('6750', '北镇市', '3', '6643');
INSERT INTO `tp_region` VALUES ('6751', '北镇街道', '4', '6750');
INSERT INTO `tp_region` VALUES ('6752', '观音阁街道', '4', '6750');
INSERT INTO `tp_region` VALUES ('6753', '大市镇', '4', '6750');
INSERT INTO `tp_region` VALUES ('6754', '罗罗堡镇', '4', '6750');
INSERT INTO `tp_region` VALUES ('6755', '常兴店镇', '4', '6750');
INSERT INTO `tp_region` VALUES ('6756', '正安镇', '4', '6750');
INSERT INTO `tp_region` VALUES ('6757', '闾阳镇', '4', '6750');
INSERT INTO `tp_region` VALUES ('6758', '中安镇', '4', '6750');
INSERT INTO `tp_region` VALUES ('6759', '廖屯镇', '4', '6750');
INSERT INTO `tp_region` VALUES ('6760', '赵屯镇', '4', '6750');
INSERT INTO `tp_region` VALUES ('6761', '青堆子镇', '4', '6750');
INSERT INTO `tp_region` VALUES ('6762', '高山子镇', '4', '6750');
INSERT INTO `tp_region` VALUES ('6763', '沟帮子镇', '4', '6750');
INSERT INTO `tp_region` VALUES ('6764', '富屯乡', '4', '6750');
INSERT INTO `tp_region` VALUES ('6765', '鲍家乡', '4', '6750');
INSERT INTO `tp_region` VALUES ('6766', '大屯乡', '4', '6750');
INSERT INTO `tp_region` VALUES ('6767', '吴家乡', '4', '6750');
INSERT INTO `tp_region` VALUES ('6768', '柳家乡', '4', '6750');
INSERT INTO `tp_region` VALUES ('6769', '广宁乡', '4', '6750');
INSERT INTO `tp_region` VALUES ('6770', '新立农场', '4', '6750');
INSERT INTO `tp_region` VALUES ('6771', '营口市', '2', '5827');
INSERT INTO `tp_region` VALUES ('6772', '市辖区', '3', '6771');
INSERT INTO `tp_region` VALUES ('6773', '站前区', '3', '6771');
INSERT INTO `tp_region` VALUES ('6774', '八田地街道', '4', '6773');
INSERT INTO `tp_region` VALUES ('6775', '建丰街道', '4', '6773');
INSERT INTO `tp_region` VALUES ('6776', '建设街道', '4', '6773');
INSERT INTO `tp_region` VALUES ('6777', '跃进街道', '4', '6773');
INSERT INTO `tp_region` VALUES ('6778', '东风街道', '4', '6773');
INSERT INTO `tp_region` VALUES ('6779', '新兴街道', '4', '6773');
INSERT INTO `tp_region` VALUES ('6780', '新建街道', '4', '6773');
INSERT INTO `tp_region` VALUES ('6781', '西市区', '3', '6771');
INSERT INTO `tp_region` VALUES ('6782', '胜利街道', '4', '6781');
INSERT INTO `tp_region` VALUES ('6783', '清华街道', '4', '6781');
INSERT INTO `tp_region` VALUES ('6784', '滨海街道', '4', '6781');
INSERT INTO `tp_region` VALUES ('6785', '得胜街道', '4', '6781');
INSERT INTO `tp_region` VALUES ('6786', '五台子街道', '4', '6781');
INSERT INTO `tp_region` VALUES ('6787', '渔市街道', '4', '6781');
INSERT INTO `tp_region` VALUES ('6788', '河北街道', '4', '6781');
INSERT INTO `tp_region` VALUES ('6789', '鲅鱼圈区', '3', '6771');
INSERT INTO `tp_region` VALUES ('6790', '红海街道', '4', '6789');
INSERT INTO `tp_region` VALUES ('6791', '海星街道', '4', '6789');
INSERT INTO `tp_region` VALUES ('6792', '望海街道', '4', '6789');
INSERT INTO `tp_region` VALUES ('6793', '海东街道', '4', '6789');
INSERT INTO `tp_region` VALUES ('6794', '熊岳镇', '4', '6789');
INSERT INTO `tp_region` VALUES ('6795', '芦屯镇', '4', '6789');
INSERT INTO `tp_region` VALUES ('6796', '红旗满族镇', '4', '6789');
INSERT INTO `tp_region` VALUES ('6797', '老边区', '3', '6771');
INSERT INTO `tp_region` VALUES ('6798', '老边街道', '4', '6797');
INSERT INTO `tp_region` VALUES ('6799', '城东街道', '4', '6797');
INSERT INTO `tp_region` VALUES ('6800', '路南镇', '4', '6797');
INSERT INTO `tp_region` VALUES ('6801', '柳树镇', '4', '6797');
INSERT INTO `tp_region` VALUES ('6802', '边城镇', '4', '6797');
INSERT INTO `tp_region` VALUES ('6803', '二道镇', '4', '6797');
INSERT INTO `tp_region` VALUES ('6804', '盖州市', '3', '6771');
INSERT INTO `tp_region` VALUES ('6805', '鼓楼街道', '4', '6804');
INSERT INTO `tp_region` VALUES ('6806', '西城街道', '4', '6804');
INSERT INTO `tp_region` VALUES ('6807', '东城街道', '4', '6804');
INSERT INTO `tp_region` VALUES ('6808', '太阳升街道', '4', '6804');
INSERT INTO `tp_region` VALUES ('6809', '团山街道', '4', '6804');
INSERT INTO `tp_region` VALUES ('6810', '西海街道', '4', '6804');
INSERT INTO `tp_region` VALUES ('6811', '高屯镇', '4', '6804');
INSERT INTO `tp_region` VALUES ('6812', '沙岗镇', '4', '6804');
INSERT INTO `tp_region` VALUES ('6813', '九垅地镇', '4', '6804');
INSERT INTO `tp_region` VALUES ('6814', '九寨镇', '4', '6804');
INSERT INTO `tp_region` VALUES ('6815', '万福镇', '4', '6804');
INSERT INTO `tp_region` VALUES ('6816', '卧龙泉镇', '4', '6804');
INSERT INTO `tp_region` VALUES ('6817', '青石岭镇', '4', '6804');
INSERT INTO `tp_region` VALUES ('6818', '暖泉镇', '4', '6804');
INSERT INTO `tp_region` VALUES ('6819', '归州满族镇', '4', '6804');
INSERT INTO `tp_region` VALUES ('6820', '榜式堡镇', '4', '6804');
INSERT INTO `tp_region` VALUES ('6821', '团甸镇', '4', '6804');
INSERT INTO `tp_region` VALUES ('6822', '双台镇', '4', '6804');
INSERT INTO `tp_region` VALUES ('6823', '杨运镇', '4', '6804');
INSERT INTO `tp_region` VALUES ('6824', '徐屯镇', '4', '6804');
INSERT INTO `tp_region` VALUES ('6825', '什字街镇', '4', '6804');
INSERT INTO `tp_region` VALUES ('6826', '矿洞沟镇', '4', '6804');
INSERT INTO `tp_region` VALUES ('6827', '陈屯镇', '4', '6804');
INSERT INTO `tp_region` VALUES ('6828', '梁屯镇', '4', '6804');
INSERT INTO `tp_region` VALUES ('6829', '小石棚乡', '4', '6804');
INSERT INTO `tp_region` VALUES ('6830', '果园乡', '4', '6804');
INSERT INTO `tp_region` VALUES ('6831', '二台乡', '4', '6804');
INSERT INTO `tp_region` VALUES ('6832', '大石桥市', '3', '6771');
INSERT INTO `tp_region` VALUES ('6833', '石桥街道', '4', '6832');
INSERT INTO `tp_region` VALUES ('6834', '青花街道', '4', '6832');
INSERT INTO `tp_region` VALUES ('6835', '金桥街道', '4', '6832');
INSERT INTO `tp_region` VALUES ('6836', '钢都街道', '4', '6832');
INSERT INTO `tp_region` VALUES ('6837', '南楼街道', '4', '6832');
INSERT INTO `tp_region` VALUES ('6838', '水源镇', '4', '6832');
INSERT INTO `tp_region` VALUES ('6839', '沟沿镇', '4', '6832');
INSERT INTO `tp_region` VALUES ('6840', '石佛镇', '4', '6832');
INSERT INTO `tp_region` VALUES ('6841', '高坎镇', '4', '6832');
INSERT INTO `tp_region` VALUES ('6842', '旗口镇', '4', '6832');
INSERT INTO `tp_region` VALUES ('6843', '虎庄镇', '4', '6832');
INSERT INTO `tp_region` VALUES ('6844', '官屯镇', '4', '6832');
INSERT INTO `tp_region` VALUES ('6845', '博洛铺镇', '4', '6832');
INSERT INTO `tp_region` VALUES ('6846', '永安镇', '4', '6832');
INSERT INTO `tp_region` VALUES ('6847', '汤池镇', '4', '6832');
INSERT INTO `tp_region` VALUES ('6848', '建一镇', '4', '6832');
INSERT INTO `tp_region` VALUES ('6849', '黄土岭镇', '4', '6832');
INSERT INTO `tp_region` VALUES ('6850', '周家镇', '4', '6832');
INSERT INTO `tp_region` VALUES ('6851', '阜新市', '2', '5827');
INSERT INTO `tp_region` VALUES ('6852', '市辖区', '3', '6851');
INSERT INTO `tp_region` VALUES ('6853', '海州区', '3', '6851');
INSERT INTO `tp_region` VALUES ('6854', '新兴街道', '4', '6853');
INSERT INTO `tp_region` VALUES ('6855', '和平街道', '4', '6853');
INSERT INTO `tp_region` VALUES ('6856', '西山街道', '4', '6853');
INSERT INTO `tp_region` VALUES ('6857', '河北街道', '4', '6853');
INSERT INTO `tp_region` VALUES ('6858', '站前街道', '4', '6853');
INSERT INTO `tp_region` VALUES ('6859', '西阜新街道', '4', '6853');
INSERT INTO `tp_region` VALUES ('6860', '五龙街道', '4', '6853');
INSERT INTO `tp_region` VALUES ('6861', '平安西部街道', '4', '6853');
INSERT INTO `tp_region` VALUES ('6862', '工人村街道', '4', '6853');
INSERT INTO `tp_region` VALUES ('6863', '东梁街道', '4', '6853');
INSERT INTO `tp_region` VALUES ('6864', '韩家店镇', '4', '6853');
INSERT INTO `tp_region` VALUES ('6865', '新邱区', '3', '6851');
INSERT INTO `tp_region` VALUES ('6866', '街基街道', '4', '6865');
INSERT INTO `tp_region` VALUES ('6867', '中部街道', '4', '6865');
INSERT INTO `tp_region` VALUES ('6868', '北部街道', '4', '6865');
INSERT INTO `tp_region` VALUES ('6869', '南部街道', '4', '6865');
INSERT INTO `tp_region` VALUES ('6870', '长营子蒙古族镇', '4', '6865');
INSERT INTO `tp_region` VALUES ('6871', '太平区', '3', '6851');
INSERT INTO `tp_region` VALUES ('6872', '红树街道', '4', '6871');
INSERT INTO `tp_region` VALUES ('6873', '煤海街道', '4', '6871');
INSERT INTO `tp_region` VALUES ('6874', '高德街道', '4', '6871');
INSERT INTO `tp_region` VALUES ('6875', '孙家湾街道', '4', '6871');
INSERT INTO `tp_region` VALUES ('6876', '城南街道', '4', '6871');
INSERT INTO `tp_region` VALUES ('6877', '水泉镇', '4', '6871');
INSERT INTO `tp_region` VALUES ('6878', '清河门区', '3', '6851');
INSERT INTO `tp_region` VALUES ('6879', '清河街道', '4', '6878');
INSERT INTO `tp_region` VALUES ('6880', '六台街道', '4', '6878');
INSERT INTO `tp_region` VALUES ('6881', '艾友街道', '4', '6878');
INSERT INTO `tp_region` VALUES ('6882', '新北街道', '4', '6878');
INSERT INTO `tp_region` VALUES ('6883', '河西镇', '4', '6878');
INSERT INTO `tp_region` VALUES ('6884', '乌龙坝镇', '4', '6878');
INSERT INTO `tp_region` VALUES ('6885', '细河区', '3', '6851');
INSERT INTO `tp_region` VALUES ('6886', '西苑街道', '4', '6885');
INSERT INTO `tp_region` VALUES ('6887', '北苑街道', '4', '6885');
INSERT INTO `tp_region` VALUES ('6888', '东苑街道', '4', '6885');
INSERT INTO `tp_region` VALUES ('6889', '学院街道', '4', '6885');
INSERT INTO `tp_region` VALUES ('6890', '中苑街道', '4', '6885');
INSERT INTO `tp_region` VALUES ('6891', '华东街道', '4', '6885');
INSERT INTO `tp_region` VALUES ('6892', '四合镇', '4', '6885');
INSERT INTO `tp_region` VALUES ('6893', '阜新蒙古族自治县', '3', '6851');
INSERT INTO `tp_region` VALUES ('6894', '阜新镇', '4', '6893');
INSERT INTO `tp_region` VALUES ('6895', '东梁镇', '4', '6893');
INSERT INTO `tp_region` VALUES ('6896', '佛寺镇', '4', '6893');
INSERT INTO `tp_region` VALUES ('6897', '伊吗图镇', '4', '6893');
INSERT INTO `tp_region` VALUES ('6898', '旧庙镇', '4', '6893');
INSERT INTO `tp_region` VALUES ('6899', '务欢池镇', '4', '6893');
INSERT INTO `tp_region` VALUES ('6900', '建设镇', '4', '6893');
INSERT INTO `tp_region` VALUES ('6901', '大巴镇', '4', '6893');
INSERT INTO `tp_region` VALUES ('6902', '泡子镇', '4', '6893');
INSERT INTO `tp_region` VALUES ('6903', '十家子镇', '4', '6893');
INSERT INTO `tp_region` VALUES ('6904', '王府镇', '4', '6893');
INSERT INTO `tp_region` VALUES ('6905', '于寺镇', '4', '6893');
INSERT INTO `tp_region` VALUES ('6906', '富荣镇', '4', '6893');
INSERT INTO `tp_region` VALUES ('6907', '新民镇', '4', '6893');
INSERT INTO `tp_region` VALUES ('6908', '福兴地镇', '4', '6893');
INSERT INTO `tp_region` VALUES ('6909', '平安地镇', '4', '6893');
INSERT INTO `tp_region` VALUES ('6910', '沙拉镇', '4', '6893');
INSERT INTO `tp_region` VALUES ('6911', '大固本镇', '4', '6893');
INSERT INTO `tp_region` VALUES ('6912', '大五家子镇', '4', '6893');
INSERT INTO `tp_region` VALUES ('6913', '大板镇', '4', '6893');
INSERT INTO `tp_region` VALUES ('6914', '蜘蛛山乡', '4', '6893');
INSERT INTO `tp_region` VALUES ('6915', '卧凤沟乡', '4', '6893');
INSERT INTO `tp_region` VALUES ('6916', '八家子乡', '4', '6893');
INSERT INTO `tp_region` VALUES ('6917', '哈达户稍乡', '4', '6893');
INSERT INTO `tp_region` VALUES ('6918', '塔营子乡', '4', '6893');
INSERT INTO `tp_region` VALUES ('6919', '扎兰营子乡', '4', '6893');
INSERT INTO `tp_region` VALUES ('6920', '招束沟乡', '4', '6893');
INSERT INTO `tp_region` VALUES ('6921', '苍土乡', '4', '6893');
INSERT INTO `tp_region` VALUES ('6922', '老河土乡', '4', '6893');
INSERT INTO `tp_region` VALUES ('6923', '七家子乡', '4', '6893');
INSERT INTO `tp_region` VALUES ('6924', '红帽子乡', '4', '6893');
INSERT INTO `tp_region` VALUES ('6925', '紫都台乡', '4', '6893');
INSERT INTO `tp_region` VALUES ('6926', '化石戈乡', '4', '6893');
INSERT INTO `tp_region` VALUES ('6927', '太平乡', '4', '6893');
INSERT INTO `tp_region` VALUES ('6928', '国华乡', '4', '6893');
INSERT INTO `tp_region` VALUES ('6929', '泡子', '4', '6893');
INSERT INTO `tp_region` VALUES ('6930', '彰武县', '3', '6851');
INSERT INTO `tp_region` VALUES ('6931', '彰武镇', '4', '6930');
INSERT INTO `tp_region` VALUES ('6932', '哈尔套镇', '4', '6930');
INSERT INTO `tp_region` VALUES ('6933', '章古台镇', '4', '6930');
INSERT INTO `tp_region` VALUES ('6934', '五峰镇', '4', '6930');
INSERT INTO `tp_region` VALUES ('6935', '冯家镇', '4', '6930');
INSERT INTO `tp_region` VALUES ('6936', '后新秋镇', '4', '6930');
INSERT INTO `tp_region` VALUES ('6937', '东六家子镇', '4', '6930');
INSERT INTO `tp_region` VALUES ('6938', '阿尔乡镇', '4', '6930');
INSERT INTO `tp_region` VALUES ('6939', '苇子沟蒙古族乡', '4', '6930');
INSERT INTO `tp_region` VALUES ('6940', '二道河子蒙古族乡', '4', '6930');
INSERT INTO `tp_region` VALUES ('6941', '西六家子蒙古族满族乡', '4', '6930');
INSERT INTO `tp_region` VALUES ('6942', '两家子乡', '4', '6930');
INSERT INTO `tp_region` VALUES ('6943', '双庙乡', '4', '6930');
INSERT INTO `tp_region` VALUES ('6944', '平安乡', '4', '6930');
INSERT INTO `tp_region` VALUES ('6945', '满堂红乡', '4', '6930');
INSERT INTO `tp_region` VALUES ('6946', '四堡子乡', '4', '6930');
INSERT INTO `tp_region` VALUES ('6947', '丰田乡', '4', '6930');
INSERT INTO `tp_region` VALUES ('6948', '大德乡', '4', '6930');
INSERT INTO `tp_region` VALUES ('6949', '大冷蒙古族乡', '4', '6930');
INSERT INTO `tp_region` VALUES ('6950', '前福兴地乡', '4', '6930');
INSERT INTO `tp_region` VALUES ('6951', '兴隆堡乡', '4', '6930');
INSERT INTO `tp_region` VALUES ('6952', '兴隆山乡', '4', '6930');
INSERT INTO `tp_region` VALUES ('6953', '大四家子乡', '4', '6930');
INSERT INTO `tp_region` VALUES ('6954', '四合城乡', '4', '6930');
INSERT INTO `tp_region` VALUES ('6955', '辽阳市', '2', '5827');
INSERT INTO `tp_region` VALUES ('6956', '市辖区', '3', '6955');
INSERT INTO `tp_region` VALUES ('6957', '白塔区', '3', '6955');
INSERT INTO `tp_region` VALUES ('6958', '星火街道', '4', '6957');
INSERT INTO `tp_region` VALUES ('6959', '胜利街道', '4', '6957');
INSERT INTO `tp_region` VALUES ('6960', '跃进街道', '4', '6957');
INSERT INTO `tp_region` VALUES ('6961', '卫国路街道', '4', '6957');
INSERT INTO `tp_region` VALUES ('6962', '站前街道', '4', '6957');
INSERT INTO `tp_region` VALUES ('6963', '铁西街道', '4', '6957');
INSERT INTO `tp_region` VALUES ('6964', '文圣区', '3', '6955');
INSERT INTO `tp_region` VALUES ('6965', '武圣街道', '4', '6964');
INSERT INTO `tp_region` VALUES ('6966', '文圣街道', '4', '6964');
INSERT INTO `tp_region` VALUES ('6967', '襄平街道', '4', '6964');
INSERT INTO `tp_region` VALUES ('6968', '庆阳街道', '4', '6964');
INSERT INTO `tp_region` VALUES ('6969', '南门街道', '4', '6964');
INSERT INTO `tp_region` VALUES ('6970', '东兴街道', '4', '6964');
INSERT INTO `tp_region` VALUES ('6971', '宏伟区', '3', '6955');
INSERT INTO `tp_region` VALUES ('6972', '工农街道', '4', '6971');
INSERT INTO `tp_region` VALUES ('6973', '光华街道', '4', '6971');
INSERT INTO `tp_region` VALUES ('6974', '新村街道', '4', '6971');
INSERT INTO `tp_region` VALUES ('6975', '长征街道', '4', '6971');
INSERT INTO `tp_region` VALUES ('6976', '曙光镇', '4', '6971');
INSERT INTO `tp_region` VALUES ('6977', '弓长岭区', '3', '6955');
INSERT INTO `tp_region` VALUES ('6978', '苏家街道', '4', '6977');
INSERT INTO `tp_region` VALUES ('6979', '团山街道', '4', '6977');
INSERT INTO `tp_region` VALUES ('6980', '安平街道', '4', '6977');
INSERT INTO `tp_region` VALUES ('6981', '汤河镇', '4', '6977');
INSERT INTO `tp_region` VALUES ('6982', '安平乡', '4', '6977');
INSERT INTO `tp_region` VALUES ('6983', '太子河区', '3', '6955');
INSERT INTO `tp_region` VALUES ('6984', '新华街道', '4', '6983');
INSERT INTO `tp_region` VALUES ('6985', '望水台街道', '4', '6983');
INSERT INTO `tp_region` VALUES ('6986', '祁家镇', '4', '6983');
INSERT INTO `tp_region` VALUES ('6987', '东京陵乡', '4', '6983');
INSERT INTO `tp_region` VALUES ('6988', '东宁卫乡', '4', '6983');
INSERT INTO `tp_region` VALUES ('6989', '辽阳县', '3', '6955');
INSERT INTO `tp_region` VALUES ('6990', '首山镇', '4', '6989');
INSERT INTO `tp_region` VALUES ('6991', '刘二堡镇', '4', '6989');
INSERT INTO `tp_region` VALUES ('6992', '小屯镇', '4', '6989');
INSERT INTO `tp_region` VALUES ('6993', '小北河镇', '4', '6989');
INSERT INTO `tp_region` VALUES ('6994', '黄泥洼镇', '4', '6989');
INSERT INTO `tp_region` VALUES ('6995', '沙岭镇', '4', '6989');
INSERT INTO `tp_region` VALUES ('6996', '唐马寨镇', '4', '6989');
INSERT INTO `tp_region` VALUES ('6997', '穆家镇', '4', '6989');
INSERT INTO `tp_region` VALUES ('6998', '柳壕镇', '4', '6989');
INSERT INTO `tp_region` VALUES ('6999', '兰家镇', '4', '6989');
INSERT INTO `tp_region` VALUES ('7000', '河栏镇', '4', '6989');
INSERT INTO `tp_region` VALUES ('7001', '隆昌镇', '4', '6989');
INSERT INTO `tp_region` VALUES ('7002', '八会镇', '4', '6989');
INSERT INTO `tp_region` VALUES ('7003', '寒岭镇', '4', '6989');
INSERT INTO `tp_region` VALUES ('7004', '下达河乡', '4', '6989');
INSERT INTO `tp_region` VALUES ('7005', '吉洞峪满族乡', '4', '6989');
INSERT INTO `tp_region` VALUES ('7006', '甜水满族乡', '4', '6989');
INSERT INTO `tp_region` VALUES ('7007', '灯塔市', '3', '6955');
INSERT INTO `tp_region` VALUES ('7008', '烟台街道', '4', '7007');
INSERT INTO `tp_region` VALUES ('7009', '万宝桥街道', '4', '7007');
INSERT INTO `tp_region` VALUES ('7010', '古城子街道', '4', '7007');
INSERT INTO `tp_region` VALUES ('7011', '佟二堡镇', '4', '7007');
INSERT INTO `tp_region` VALUES ('7012', '铧子镇', '4', '7007');
INSERT INTO `tp_region` VALUES ('7013', '张台子镇', '4', '7007');
INSERT INTO `tp_region` VALUES ('7014', '西大窑镇', '4', '7007');
INSERT INTO `tp_region` VALUES ('7015', '沈旦堡镇', '4', '7007');
INSERT INTO `tp_region` VALUES ('7016', '西马峰镇', '4', '7007');
INSERT INTO `tp_region` VALUES ('7017', '柳条寨镇', '4', '7007');
INSERT INTO `tp_region` VALUES ('7018', '柳河子镇', '4', '7007');
INSERT INTO `tp_region` VALUES ('7019', '罗大台镇', '4', '7007');
INSERT INTO `tp_region` VALUES ('7020', '王家镇', '4', '7007');
INSERT INTO `tp_region` VALUES ('7021', '大河南镇', '4', '7007');
INSERT INTO `tp_region` VALUES ('7022', '五星镇', '4', '7007');
INSERT INTO `tp_region` VALUES ('7023', '鸡冠山乡', '4', '7007');
INSERT INTO `tp_region` VALUES ('7024', '盘锦市', '2', '5827');
INSERT INTO `tp_region` VALUES ('7025', '市辖区', '3', '7024');
INSERT INTO `tp_region` VALUES ('7026', '双台子区', '3', '7024');
INSERT INTO `tp_region` VALUES ('7027', '东风街道', '4', '7026');
INSERT INTO `tp_region` VALUES ('7028', '胜利街道', '4', '7026');
INSERT INTO `tp_region` VALUES ('7029', '建设街道', '4', '7026');
INSERT INTO `tp_region` VALUES ('7030', '红旗街道', '4', '7026');
INSERT INTO `tp_region` VALUES ('7031', '辽河街道', '4', '7026');
INSERT INTO `tp_region` VALUES ('7032', '石油街道', '4', '7026');
INSERT INTO `tp_region` VALUES ('7033', '化工街道', '4', '7026');
INSERT INTO `tp_region` VALUES ('7034', '铁东街道', '4', '7026');
INSERT INTO `tp_region` VALUES ('7035', '双盛街道', '4', '7026');
INSERT INTO `tp_region` VALUES ('7036', '兴隆台区', '3', '7024');
INSERT INTO `tp_region` VALUES ('7037', '振兴街道', '4', '7036');
INSERT INTO `tp_region` VALUES ('7038', '兴隆街道', '4', '7036');
INSERT INTO `tp_region` VALUES ('7039', '渤海街道', '4', '7036');
INSERT INTO `tp_region` VALUES ('7040', '新工街道', '4', '7036');
INSERT INTO `tp_region` VALUES ('7041', '于楼街道', '4', '7036');
INSERT INTO `tp_region` VALUES ('7042', '友谊街道', '4', '7036');
INSERT INTO `tp_region` VALUES ('7043', '曙光街道', '4', '7036');
INSERT INTO `tp_region` VALUES ('7044', '欢喜街道', '4', '7036');
INSERT INTO `tp_region` VALUES ('7045', '平安街道', '4', '7036');
INSERT INTO `tp_region` VALUES ('7046', '新生街道', '4', '7036');
INSERT INTO `tp_region` VALUES ('7047', '红村街道', '4', '7036');
INSERT INTO `tp_region` VALUES ('7048', '高升街道', '4', '7036');
INSERT INTO `tp_region` VALUES ('7049', '沈采街道', '4', '7036');
INSERT INTO `tp_region` VALUES ('7050', '锦采街道', '4', '7036');
INSERT INTO `tp_region` VALUES ('7051', '茨采街道', '4', '7036');
INSERT INTO `tp_region` VALUES ('7052', '创新街道', '4', '7036');
INSERT INTO `tp_region` VALUES ('7053', '兴盛街道', '4', '7036');
INSERT INTO `tp_region` VALUES ('7054', '兴海街道', '4', '7036');
INSERT INTO `tp_region` VALUES ('7055', '大洼县', '3', '7024');
INSERT INTO `tp_region` VALUES ('7056', '大洼镇', '4', '7055');
INSERT INTO `tp_region` VALUES ('7057', '田庄台镇', '4', '7055');
INSERT INTO `tp_region` VALUES ('7058', '二界沟镇', '4', '7055');
INSERT INTO `tp_region` VALUES ('7059', '东风镇', '4', '7055');
INSERT INTO `tp_region` VALUES ('7060', '新开镇', '4', '7055');
INSERT INTO `tp_region` VALUES ('7061', '田家镇', '4', '7055');
INSERT INTO `tp_region` VALUES ('7062', '清水镇', '4', '7055');
INSERT INTO `tp_region` VALUES ('7063', '新兴镇', '4', '7055');
INSERT INTO `tp_region` VALUES ('7064', '西安镇', '4', '7055');
INSERT INTO `tp_region` VALUES ('7065', '新立镇', '4', '7055');
INSERT INTO `tp_region` VALUES ('7066', '王家乡', '4', '7055');
INSERT INTO `tp_region` VALUES ('7067', '唐家乡', '4', '7055');
INSERT INTO `tp_region` VALUES ('7068', '荣兴乡', '4', '7055');
INSERT INTO `tp_region` VALUES ('7069', '平安乡', '4', '7055');
INSERT INTO `tp_region` VALUES ('7070', '赵圈河乡', '4', '7055');
INSERT INTO `tp_region` VALUES ('7071', '辽滨开发区', '4', '7055');
INSERT INTO `tp_region` VALUES ('7072', '盘山县', '3', '7024');
INSERT INTO `tp_region` VALUES ('7073', '沙岭镇', '4', '7072');
INSERT INTO `tp_region` VALUES ('7074', '高升镇', '4', '7072');
INSERT INTO `tp_region` VALUES ('7075', '胡家镇', '4', '7072');
INSERT INTO `tp_region` VALUES ('7076', '石新镇', '4', '7072');
INSERT INTO `tp_region` VALUES ('7077', '东郭镇', '4', '7072');
INSERT INTO `tp_region` VALUES ('7078', '羊圈子镇', '4', '7072');
INSERT INTO `tp_region` VALUES ('7079', '古城子镇', '4', '7072');
INSERT INTO `tp_region` VALUES ('7080', '坝墙子镇', '4', '7072');
INSERT INTO `tp_region` VALUES ('7081', '太平镇', '4', '7072');
INSERT INTO `tp_region` VALUES ('7082', '陈家乡', '4', '7072');
INSERT INTO `tp_region` VALUES ('7083', '吴家乡', '4', '7072');
INSERT INTO `tp_region` VALUES ('7084', '陆家乡', '4', '7072');
INSERT INTO `tp_region` VALUES ('7085', '甜水乡', '4', '7072');
INSERT INTO `tp_region` VALUES ('7086', '大荒乡', '4', '7072');
INSERT INTO `tp_region` VALUES ('7087', '盘山县林场', '4', '7072');
INSERT INTO `tp_region` VALUES ('7088', '铁岭市', '2', '5827');
INSERT INTO `tp_region` VALUES ('7089', '市辖区', '3', '7088');
INSERT INTO `tp_region` VALUES ('7090', '银州区', '3', '7088');
INSERT INTO `tp_region` VALUES ('7091', '红旗街道', '4', '7090');
INSERT INTO `tp_region` VALUES ('7092', '工人街道', '4', '7090');
INSERT INTO `tp_region` VALUES ('7093', '铁西街道', '4', '7090');
INSERT INTO `tp_region` VALUES ('7094', '铜钟街道', '4', '7090');
INSERT INTO `tp_region` VALUES ('7095', '柴河街道', '4', '7090');
INSERT INTO `tp_region` VALUES ('7096', '岭东街道', '4', '7090');
INSERT INTO `tp_region` VALUES ('7097', '龙山乡', '4', '7090');
INSERT INTO `tp_region` VALUES ('7098', '铁岭经济开发区', '4', '7090');
INSERT INTO `tp_region` VALUES ('7099', '清河区', '3', '7088');
INSERT INTO `tp_region` VALUES ('7100', '红旗街道', '4', '7099');
INSERT INTO `tp_region` VALUES ('7101', '向阳街道', '4', '7099');
INSERT INTO `tp_region` VALUES ('7102', '张相镇', '4', '7099');
INSERT INTO `tp_region` VALUES ('7103', '杨木林子乡', '4', '7099');
INSERT INTO `tp_region` VALUES ('7104', '聂家满族乡', '4', '7099');
INSERT INTO `tp_region` VALUES ('7105', '铁岭县', '3', '7088');
INSERT INTO `tp_region` VALUES ('7106', '新台子镇', '4', '7105');
INSERT INTO `tp_region` VALUES ('7107', '阿吉镇', '4', '7105');
INSERT INTO `tp_region` VALUES ('7108', '平顶堡镇', '4', '7105');
INSERT INTO `tp_region` VALUES ('7109', '大甸子镇', '4', '7105');
INSERT INTO `tp_region` VALUES ('7110', '凡河镇', '4', '7105');
INSERT INTO `tp_region` VALUES ('7111', '腰堡镇', '4', '7105');
INSERT INTO `tp_region` VALUES ('7112', '镇西堡镇', '4', '7105');
INSERT INTO `tp_region` VALUES ('7113', '蔡牛乡', '4', '7105');
INSERT INTO `tp_region` VALUES ('7114', '双井子乡', '4', '7105');
INSERT INTO `tp_region` VALUES ('7115', '熊官屯乡', '4', '7105');
INSERT INTO `tp_region` VALUES ('7116', '李千户乡', '4', '7105');
INSERT INTO `tp_region` VALUES ('7117', '横道河子乡', '4', '7105');
INSERT INTO `tp_region` VALUES ('7118', '鸡冠山乡', '4', '7105');
INSERT INTO `tp_region` VALUES ('7119', '白旗寨满族乡', '4', '7105');
INSERT INTO `tp_region` VALUES ('7120', '种畜场', '4', '7105');
INSERT INTO `tp_region` VALUES ('7121', '西丰县', '3', '7088');
INSERT INTO `tp_region` VALUES ('7122', '西丰镇', '4', '7121');
INSERT INTO `tp_region` VALUES ('7123', '平岗镇', '4', '7121');
INSERT INTO `tp_region` VALUES ('7124', '郜家店镇', '4', '7121');
INSERT INTO `tp_region` VALUES ('7125', '凉泉镇', '4', '7121');
INSERT INTO `tp_region` VALUES ('7126', '振兴镇', '4', '7121');
INSERT INTO `tp_region` VALUES ('7127', '安民镇', '4', '7121');
INSERT INTO `tp_region` VALUES ('7128', '天德镇', '4', '7121');
INSERT INTO `tp_region` VALUES ('7129', '房木镇', '4', '7121');
INSERT INTO `tp_region` VALUES ('7130', '陶然乡', '4', '7121');
INSERT INTO `tp_region` VALUES ('7131', '柏榆乡', '4', '7121');
INSERT INTO `tp_region` VALUES ('7132', '德兴乡', '4', '7121');
INSERT INTO `tp_region` VALUES ('7133', '钓鱼乡', '4', '7121');
INSERT INTO `tp_region` VALUES ('7134', '明德乡', '4', '7121');
INSERT INTO `tp_region` VALUES ('7135', '成平满族乡', '4', '7121');
INSERT INTO `tp_region` VALUES ('7136', '和隆满族乡', '4', '7121');
INSERT INTO `tp_region` VALUES ('7137', '营厂乡', '4', '7121');
INSERT INTO `tp_region` VALUES ('7138', '金星乡', '4', '7121');
INSERT INTO `tp_region` VALUES ('7139', '更刻乡', '4', '7121');
INSERT INTO `tp_region` VALUES ('7140', '昌图县', '3', '7088');
INSERT INTO `tp_region` VALUES ('7141', '昌图镇', '4', '7140');
INSERT INTO `tp_region` VALUES ('7142', '老城镇', '4', '7140');
INSERT INTO `tp_region` VALUES ('7143', '八面城镇', '4', '7140');
INSERT INTO `tp_region` VALUES ('7144', '三江口镇', '4', '7140');
INSERT INTO `tp_region` VALUES ('7145', '金家镇', '4', '7140');
INSERT INTO `tp_region` VALUES ('7146', '宝力镇', '4', '7140');
INSERT INTO `tp_region` VALUES ('7147', '泉头满族镇', '4', '7140');
INSERT INTO `tp_region` VALUES ('7148', '双庙子镇', '4', '7140');
INSERT INTO `tp_region` VALUES ('7149', '亮中桥镇', '4', '7140');
INSERT INTO `tp_region` VALUES ('7150', '马仲河镇', '4', '7140');
INSERT INTO `tp_region` VALUES ('7151', '毛家店镇', '4', '7140');
INSERT INTO `tp_region` VALUES ('7152', '老四平镇', '4', '7140');
INSERT INTO `tp_region` VALUES ('7153', '大洼镇', '4', '7140');
INSERT INTO `tp_region` VALUES ('7154', '头道镇', '4', '7140');
INSERT INTO `tp_region` VALUES ('7155', '此路树镇', '4', '7140');
INSERT INTO `tp_region` VALUES ('7156', '付家镇', '4', '7140');
INSERT INTO `tp_region` VALUES ('7157', '四合镇', '4', '7140');
INSERT INTO `tp_region` VALUES ('7158', '朝阳镇', '4', '7140');
INSERT INTO `tp_region` VALUES ('7159', '古榆树镇', '4', '7140');
INSERT INTO `tp_region` VALUES ('7160', '七家子镇', '4', '7140');
INSERT INTO `tp_region` VALUES ('7161', '东嘎镇', '4', '7140');
INSERT INTO `tp_region` VALUES ('7162', '四面城镇', '4', '7140');
INSERT INTO `tp_region` VALUES ('7163', '前双井子镇', '4', '7140');
INSERT INTO `tp_region` VALUES ('7164', '大兴乡', '4', '7140');
INSERT INTO `tp_region` VALUES ('7165', '十八家子乡', '4', '7140');
INSERT INTO `tp_region` VALUES ('7166', '通江口乡', '4', '7140');
INSERT INTO `tp_region` VALUES ('7167', '大四家子乡', '4', '7140');
INSERT INTO `tp_region` VALUES ('7168', '后窑乡', '4', '7140');
INSERT INTO `tp_region` VALUES ('7169', '长发乡', '4', '7140');
INSERT INTO `tp_region` VALUES ('7170', '太平乡', '4', '7140');
INSERT INTO `tp_region` VALUES ('7171', '下二台乡', '4', '7140');
INSERT INTO `tp_region` VALUES ('7172', '平安堡乡', '4', '7140');
INSERT INTO `tp_region` VALUES ('7173', '曲家店乡', '4', '7140');
INSERT INTO `tp_region` VALUES ('7174', '三江口农场', '4', '7140');
INSERT INTO `tp_region` VALUES ('7175', '宝力农场', '4', '7140');
INSERT INTO `tp_region` VALUES ('7176', '新乡农场', '4', '7140');
INSERT INTO `tp_region` VALUES ('7177', '付家林场', '4', '7140');
INSERT INTO `tp_region` VALUES ('7178', '忙牛马场', '4', '7140');
INSERT INTO `tp_region` VALUES ('7179', '两家子农场', '4', '7140');
INSERT INTO `tp_region` VALUES ('7180', '调兵山市', '3', '7088');
INSERT INTO `tp_region` VALUES ('7181', '兀术街道', '4', '7180');
INSERT INTO `tp_region` VALUES ('7182', '调兵山街道', '4', '7180');
INSERT INTO `tp_region` VALUES ('7183', '晓明镇', '4', '7180');
INSERT INTO `tp_region` VALUES ('7184', '大明镇', '4', '7180');
INSERT INTO `tp_region` VALUES ('7185', '晓南镇', '4', '7180');
INSERT INTO `tp_region` VALUES ('7186', '开原市', '3', '7088');
INSERT INTO `tp_region` VALUES ('7187', '新城街道', '4', '7186');
INSERT INTO `tp_region` VALUES ('7188', '老城街道', '4', '7186');
INSERT INTO `tp_region` VALUES ('7189', '兴开街道', '4', '7186');
INSERT INTO `tp_region` VALUES ('7190', '威远堡镇', '4', '7186');
INSERT INTO `tp_region` VALUES ('7191', '庆云堡镇', '4', '7186');
INSERT INTO `tp_region` VALUES ('7192', '中固镇', '4', '7186');
INSERT INTO `tp_region` VALUES ('7193', '八棵树镇', '4', '7186');
INSERT INTO `tp_region` VALUES ('7194', '金沟子镇', '4', '7186');
INSERT INTO `tp_region` VALUES ('7195', '八宝镇', '4', '7186');
INSERT INTO `tp_region` VALUES ('7196', '业民镇', '4', '7186');
INSERT INTO `tp_region` VALUES ('7197', '莲花镇', '4', '7186');
INSERT INTO `tp_region` VALUES ('7198', '靠山镇', '4', '7186');
INSERT INTO `tp_region` VALUES ('7199', '城东乡', '4', '7186');
INSERT INTO `tp_region` VALUES ('7200', '三家子乡', '4', '7186');
INSERT INTO `tp_region` VALUES ('7201', '马家寨乡', '4', '7186');
INSERT INTO `tp_region` VALUES ('7202', '上肥地乡', '4', '7186');
INSERT INTO `tp_region` VALUES ('7203', '下肥地乡', '4', '7186');
INSERT INTO `tp_region` VALUES ('7204', '黄旗寨乡', '4', '7186');
INSERT INTO `tp_region` VALUES ('7205', '松山堡乡', '4', '7186');
INSERT INTO `tp_region` VALUES ('7206', '李家台乡', '4', '7186');
INSERT INTO `tp_region` VALUES ('7207', '林丰乡', '4', '7186');
INSERT INTO `tp_region` VALUES ('7208', '朝阳市', '2', '5827');
INSERT INTO `tp_region` VALUES ('7209', '市辖区', '3', '7208');
INSERT INTO `tp_region` VALUES ('7210', '双塔区', '3', '7208');
INSERT INTO `tp_region` VALUES ('7211', '南塔街道', '4', '7210');
INSERT INTO `tp_region` VALUES ('7212', '北塔街道', '4', '7210');
INSERT INTO `tp_region` VALUES ('7213', '前进街道', '4', '7210');
INSERT INTO `tp_region` VALUES ('7214', '凌河街道', '4', '7210');
INSERT INTO `tp_region` VALUES ('7215', '光明街道', '4', '7210');
INSERT INTO `tp_region` VALUES ('7216', '凌凤街道', '4', '7210');
INSERT INTO `tp_region` VALUES ('7217', '龙山街道', '4', '7210');
INSERT INTO `tp_region` VALUES ('7218', '站南街道', '4', '7210');
INSERT INTO `tp_region` VALUES ('7219', '红旗街道', '4', '7210');
INSERT INTO `tp_region` VALUES ('7220', '燕北街道', '4', '7210');
INSERT INTO `tp_region` VALUES ('7221', '桃花吐镇', '4', '7210');
INSERT INTO `tp_region` VALUES ('7222', '他拉皋镇', '4', '7210');
INSERT INTO `tp_region` VALUES ('7223', '长宝营子乡', '4', '7210');
INSERT INTO `tp_region` VALUES ('7224', '孙家湾乡', '4', '7210');
INSERT INTO `tp_region` VALUES ('7225', '龙城区', '3', '7208');
INSERT INTO `tp_region` VALUES ('7226', '向阳街道', '4', '7225');
INSERT INTO `tp_region` VALUES ('7227', '半拉山街道', '4', '7225');
INSERT INTO `tp_region` VALUES ('7228', '马山街道', '4', '7225');
INSERT INTO `tp_region` VALUES ('7229', '新华街道', '4', '7225');
INSERT INTO `tp_region` VALUES ('7230', '海龙街道', '4', '7225');
INSERT INTO `tp_region` VALUES ('7231', '开发区龙泉街道', '4', '7225');
INSERT INTO `tp_region` VALUES ('7232', '七道泉子镇', '4', '7225');
INSERT INTO `tp_region` VALUES ('7233', '西大营子镇', '4', '7225');
INSERT INTO `tp_region` VALUES ('7234', '召都巴镇', '4', '7225');
INSERT INTO `tp_region` VALUES ('7235', '大平房镇', '4', '7225');
INSERT INTO `tp_region` VALUES ('7236', '边杖子乡', '4', '7225');
INSERT INTO `tp_region` VALUES ('7237', '联合乡', '4', '7225');
INSERT INTO `tp_region` VALUES ('7238', '朝阳县', '3', '7208');
INSERT INTO `tp_region` VALUES ('7239', '波罗赤镇', '4', '7238');
INSERT INTO `tp_region` VALUES ('7240', '木头城子镇', '4', '7238');
INSERT INTO `tp_region` VALUES ('7241', '二十家子镇', '4', '7238');
INSERT INTO `tp_region` VALUES ('7242', '羊山镇', '4', '7238');
INSERT INTO `tp_region` VALUES ('7243', '六家子镇', '4', '7238');
INSERT INTO `tp_region` VALUES ('7244', '瓦房子镇', '4', '7238');
INSERT INTO `tp_region` VALUES ('7245', '大庙镇', '4', '7238');
INSERT INTO `tp_region` VALUES ('7246', '柳城镇', '4', '7238');
INSERT INTO `tp_region` VALUES ('7247', '南双庙乡', '4', '7238');
INSERT INTO `tp_region` VALUES ('7248', '古山子乡', '4', '7238');
INSERT INTO `tp_region` VALUES ('7249', '西五家子乡', '4', '7238');
INSERT INTO `tp_region` VALUES ('7250', '北沟门子乡', '4', '7238');
INSERT INTO `tp_region` VALUES ('7251', '杨树湾乡', '4', '7238');
INSERT INTO `tp_region` VALUES ('7252', '东大道乡', '4', '7238');
INSERT INTO `tp_region` VALUES ('7253', '乌兰河硕蒙古族乡', '4', '7238');
INSERT INTO `tp_region` VALUES ('7254', '台子乡', '4', '7238');
INSERT INTO `tp_region` VALUES ('7255', '胜利乡', '4', '7238');
INSERT INTO `tp_region` VALUES ('7256', '东大屯乡', '4', '7238');
INSERT INTO `tp_region` VALUES ('7257', '松岭门乡', '4', '7238');
INSERT INTO `tp_region` VALUES ('7258', '根德营子乡', '4', '7238');
INSERT INTO `tp_region` VALUES ('7259', '西营子乡', '4', '7238');
INSERT INTO `tp_region` VALUES ('7260', '七道岭乡', '4', '7238');
INSERT INTO `tp_region` VALUES ('7261', '北四家子乡', '4', '7238');
INSERT INTO `tp_region` VALUES ('7262', '王营子乡', '4', '7238');
INSERT INTO `tp_region` VALUES ('7263', '黑牛营子乡', '4', '7238');
INSERT INTO `tp_region` VALUES ('7264', '尚志乡', '4', '7238');
INSERT INTO `tp_region` VALUES ('7265', '长在营子乡', '4', '7238');
INSERT INTO `tp_region` VALUES ('7266', '国营贾家店农场', '4', '7238');
INSERT INTO `tp_region` VALUES ('7267', '建平县', '3', '7208');
INSERT INTO `tp_region` VALUES ('7268', '叶柏寿街道', '4', '7267');
INSERT INTO `tp_region` VALUES ('7269', '红山街道', '4', '7267');
INSERT INTO `tp_region` VALUES ('7270', '铁南街道', '4', '7267');
INSERT INTO `tp_region` VALUES ('7271', '万寿街道', '4', '7267');
INSERT INTO `tp_region` VALUES ('7272', '富山街道', '4', '7267');
INSERT INTO `tp_region` VALUES ('7273', '朱碌科镇', '4', '7267');
INSERT INTO `tp_region` VALUES ('7274', '建平镇', '4', '7267');
INSERT INTO `tp_region` VALUES ('7275', '黑水镇', '4', '7267');
INSERT INTO `tp_region` VALUES ('7276', '喀喇沁镇', '4', '7267');
INSERT INTO `tp_region` VALUES ('7277', '北二十家子镇', '4', '7267');
INSERT INTO `tp_region` VALUES ('7278', '沙海镇', '4', '7267');
INSERT INTO `tp_region` VALUES ('7279', '哈拉道口镇', '4', '7267');
INSERT INTO `tp_region` VALUES ('7280', '榆树林子镇', '4', '7267');
INSERT INTO `tp_region` VALUES ('7281', '老官地镇', '4', '7267');
INSERT INTO `tp_region` VALUES ('7282', '深井镇', '4', '7267');
INSERT INTO `tp_region` VALUES ('7283', '奎德素镇', '4', '7267');
INSERT INTO `tp_region` VALUES ('7284', '小塘镇', '4', '7267');
INSERT INTO `tp_region` VALUES ('7285', '马场镇', '4', '7267');
INSERT INTO `tp_region` VALUES ('7286', '昌隆镇', '4', '7267');
INSERT INTO `tp_region` VALUES ('7287', '张家营子镇', '4', '7267');
INSERT INTO `tp_region` VALUES ('7288', '青松岭乡', '4', '7267');
INSERT INTO `tp_region` VALUES ('7289', '杨树岭乡', '4', '7267');
INSERT INTO `tp_region` VALUES ('7290', '罗福沟乡', '4', '7267');
INSERT INTO `tp_region` VALUES ('7291', '烧锅营子乡', '4', '7267');
INSERT INTO `tp_region` VALUES ('7292', '太平庄乡', '4', '7267');
INSERT INTO `tp_region` VALUES ('7293', '白山乡', '4', '7267');
INSERT INTO `tp_region` VALUES ('7294', '三家蒙古族乡', '4', '7267');
INSERT INTO `tp_region` VALUES ('7295', '义成功乡', '4', '7267');
INSERT INTO `tp_region` VALUES ('7296', '青峰山乡', '4', '7267');
INSERT INTO `tp_region` VALUES ('7297', '八家国营农场', '4', '7267');
INSERT INTO `tp_region` VALUES ('7298', '热水国营畜牧农场', '4', '7267');
INSERT INTO `tp_region` VALUES ('7299', '喀喇沁左翼蒙古族自治县', '3', '7208');
INSERT INTO `tp_region` VALUES ('7300', '大城子镇', '4', '7299');
INSERT INTO `tp_region` VALUES ('7301', '南公营子镇', '4', '7299');
INSERT INTO `tp_region` VALUES ('7302', '山嘴子镇', '4', '7299');
INSERT INTO `tp_region` VALUES ('7303', '南哨镇', '4', '7299');
INSERT INTO `tp_region` VALUES ('7304', '公营子镇', '4', '7299');
INSERT INTO `tp_region` VALUES ('7305', '白塔子镇', '4', '7299');
INSERT INTO `tp_region` VALUES ('7306', '中三家镇', '4', '7299');
INSERT INTO `tp_region` VALUES ('7307', '老爷庙镇', '4', '7299');
INSERT INTO `tp_region` VALUES ('7308', '六官营子镇', '4', '7299');
INSERT INTO `tp_region` VALUES ('7309', '平房子镇', '4', '7299');
INSERT INTO `tp_region` VALUES ('7310', '十二德堡乡', '4', '7299');
INSERT INTO `tp_region` VALUES ('7311', '尤杖子乡', '4', '7299');
INSERT INTO `tp_region` VALUES ('7312', '东哨乡', '4', '7299');
INSERT INTO `tp_region` VALUES ('7313', '羊角沟乡', '4', '7299');
INSERT INTO `tp_region` VALUES ('7314', '草场乡', '4', '7299');
INSERT INTO `tp_region` VALUES ('7315', '坤都营子乡', '4', '7299');
INSERT INTO `tp_region` VALUES ('7316', '大营子乡', '4', '7299');
INSERT INTO `tp_region` VALUES ('7317', '兴隆庄乡', '4', '7299');
INSERT INTO `tp_region` VALUES ('7318', '甘招乡', '4', '7299');
INSERT INTO `tp_region` VALUES ('7319', '卧虎沟乡', '4', '7299');
INSERT INTO `tp_region` VALUES ('7320', '水泉乡', '4', '7299');
INSERT INTO `tp_region` VALUES ('7321', '国营官大海农场', '4', '7299');
INSERT INTO `tp_region` VALUES ('7322', '北票市', '3', '7208');
INSERT INTO `tp_region` VALUES ('7323', '城关街道', '4', '7322');
INSERT INTO `tp_region` VALUES ('7324', '南山街道', '4', '7322');
INSERT INTO `tp_region` VALUES ('7325', '冠山街道', '4', '7322');
INSERT INTO `tp_region` VALUES ('7326', '桥北街道', '4', '7322');
INSERT INTO `tp_region` VALUES ('7327', '三宝街道', '4', '7322');
INSERT INTO `tp_region` VALUES ('7328', '台吉街道', '4', '7322');
INSERT INTO `tp_region` VALUES ('7329', '双河街道', '4', '7322');
INSERT INTO `tp_region` VALUES ('7330', '西官营镇', '4', '7322');
INSERT INTO `tp_region` VALUES ('7331', '大板镇', '4', '7322');
INSERT INTO `tp_region` VALUES ('7332', '上园镇', '4', '7322');
INSERT INTO `tp_region` VALUES ('7333', '宝国老镇', '4', '7322');
INSERT INTO `tp_region` VALUES ('7334', '黑城子镇', '4', '7322');
INSERT INTO `tp_region` VALUES ('7335', '五间房镇', '4', '7322');
INSERT INTO `tp_region` VALUES ('7336', '台吉镇', '4', '7322');
INSERT INTO `tp_region` VALUES ('7337', '长皋乡', '4', '7322');
INSERT INTO `tp_region` VALUES ('7338', '常河营乡', '4', '7322');
INSERT INTO `tp_region` VALUES ('7339', '小塔子乡', '4', '7322');
INSERT INTO `tp_region` VALUES ('7340', '马友营蒙古族乡', '4', '7322');
INSERT INTO `tp_region` VALUES ('7341', '蒙古营乡', '4', '7322');
INSERT INTO `tp_region` VALUES ('7342', '泉巨永乡', '4', '7322');
INSERT INTO `tp_region` VALUES ('7343', '大三家乡', '4', '7322');
INSERT INTO `tp_region` VALUES ('7344', '东官营乡', '4', '7322');
INSERT INTO `tp_region` VALUES ('7345', '龙潭乡', '4', '7322');
INSERT INTO `tp_region` VALUES ('7346', '哈尔脑乡', '4', '7322');
INSERT INTO `tp_region` VALUES ('7347', '南八家子乡', '4', '7322');
INSERT INTO `tp_region` VALUES ('7348', '章吉营乡', '4', '7322');
INSERT INTO `tp_region` VALUES ('7349', '三宝营乡', '4', '7322');
INSERT INTO `tp_region` VALUES ('7350', '巴图营乡', '4', '7322');
INSERT INTO `tp_region` VALUES ('7351', '台吉营乡', '4', '7322');
INSERT INTO `tp_region` VALUES ('7352', '北塔子乡', '4', '7322');
INSERT INTO `tp_region` VALUES ('7353', '娄家店乡', '4', '7322');
INSERT INTO `tp_region` VALUES ('7354', '北四家乡', '4', '7322');
INSERT INTO `tp_region` VALUES ('7355', '凉水河蒙古族乡', '4', '7322');
INSERT INTO `tp_region` VALUES ('7356', '三宝乡', '4', '7322');
INSERT INTO `tp_region` VALUES ('7357', '下府经济开发区', '4', '7322');
INSERT INTO `tp_region` VALUES ('7358', '大黑山特别行政管理区', '4', '7322');
INSERT INTO `tp_region` VALUES ('7359', '兴顺德国营农场', '4', '7322');
INSERT INTO `tp_region` VALUES ('7360', '凌源市', '3', '7208');
INSERT INTO `tp_region` VALUES ('7361', '东城街道', '4', '7360');
INSERT INTO `tp_region` VALUES ('7362', '北街街道', '4', '7360');
INSERT INTO `tp_region` VALUES ('7363', '南街街道', '4', '7360');
INSERT INTO `tp_region` VALUES ('7364', '红山街道', '4', '7360');
INSERT INTO `tp_region` VALUES ('7365', '热水汤街道', '4', '7360');
INSERT INTO `tp_region` VALUES ('7366', '工业园区街道', '4', '7360');
INSERT INTO `tp_region` VALUES ('7367', '万元店镇', '4', '7360');
INSERT INTO `tp_region` VALUES ('7368', '宋杖子镇', '4', '7360');
INSERT INTO `tp_region` VALUES ('7369', '三十家子镇', '4', '7360');
INSERT INTO `tp_region` VALUES ('7370', '杨杖子镇', '4', '7360');
INSERT INTO `tp_region` VALUES ('7371', '刀尔登镇', '4', '7360');
INSERT INTO `tp_region` VALUES ('7372', '松岭子镇', '4', '7360');
INSERT INTO `tp_region` VALUES ('7373', '四官营子镇', '4', '7360');
INSERT INTO `tp_region` VALUES ('7374', '沟门子镇', '4', '7360');
INSERT INTO `tp_region` VALUES ('7375', '凌北镇', '4', '7360');
INSERT INTO `tp_region` VALUES ('7376', '小城子镇', '4', '7360');
INSERT INTO `tp_region` VALUES ('7377', '四合当镇', '4', '7360');
INSERT INTO `tp_region` VALUES ('7378', '城关镇', '4', '7360');
INSERT INTO `tp_region` VALUES ('7379', '乌兰白镇', '4', '7360');
INSERT INTO `tp_region` VALUES ('7380', '大王杖子乡', '4', '7360');
INSERT INTO `tp_region` VALUES ('7381', '刘杖子乡', '4', '7360');
INSERT INTO `tp_region` VALUES ('7382', '前进乡', '4', '7360');
INSERT INTO `tp_region` VALUES ('7383', '大河北乡', '4', '7360');
INSERT INTO `tp_region` VALUES ('7384', '三道河子乡', '4', '7360');
INSERT INTO `tp_region` VALUES ('7385', '牛营子乡', '4', '7360');
INSERT INTO `tp_region` VALUES ('7386', '北炉乡', '4', '7360');
INSERT INTO `tp_region` VALUES ('7387', '瓦房店乡', '4', '7360');
INSERT INTO `tp_region` VALUES ('7388', '三家子乡', '4', '7360');
INSERT INTO `tp_region` VALUES ('7389', '佛爷洞乡', '4', '7360');
INSERT INTO `tp_region` VALUES ('7390', '河坎子乡', '4', '7360');
INSERT INTO `tp_region` VALUES ('7391', '葫芦岛市', '2', '5827');
INSERT INTO `tp_region` VALUES ('7392', '市辖区', '3', '7391');
INSERT INTO `tp_region` VALUES ('7393', '连山区', '3', '7391');
INSERT INTO `tp_region` VALUES ('7394', '连山街道', '4', '7393');
INSERT INTO `tp_region` VALUES ('7395', '站前街道', '4', '7393');
INSERT INTO `tp_region` VALUES ('7396', '渤海街道', '4', '7393');
INSERT INTO `tp_region` VALUES ('7397', '兴工街道', '4', '7393');
INSERT INTO `tp_region` VALUES ('7398', '石油街道', '4', '7393');
INSERT INTO `tp_region` VALUES ('7399', '化工街道', '4', '7393');
INSERT INTO `tp_region` VALUES ('7400', '化机街道', '4', '7393');
INSERT INTO `tp_region` VALUES ('7401', '水泥街道', '4', '7393');
INSERT INTO `tp_region` VALUES ('7402', '杨家杖子街道', '4', '7393');
INSERT INTO `tp_region` VALUES ('7403', '锦郊街道', '4', '7393');
INSERT INTO `tp_region` VALUES ('7404', '虹螺岘镇', '4', '7393');
INSERT INTO `tp_region` VALUES ('7405', '高桥镇', '4', '7393');
INSERT INTO `tp_region` VALUES ('7406', '钢屯镇', '4', '7393');
INSERT INTO `tp_region` VALUES ('7407', '寺儿堡镇', '4', '7393');
INSERT INTO `tp_region` VALUES ('7408', '新台门蒙古族镇', '4', '7393');
INSERT INTO `tp_region` VALUES ('7409', '金星镇', '4', '7393');
INSERT INTO `tp_region` VALUES ('7410', '台集屯镇', '4', '7393');
INSERT INTO `tp_region` VALUES ('7411', '沙河营乡', '4', '7393');
INSERT INTO `tp_region` VALUES ('7412', '孤竹营子乡', '4', '7393');
INSERT INTO `tp_region` VALUES ('7413', '白马石乡', '4', '7393');
INSERT INTO `tp_region` VALUES ('7414', '山神庙子乡', '4', '7393');
INSERT INTO `tp_region` VALUES ('7415', '塔山乡', '4', '7393');
INSERT INTO `tp_region` VALUES ('7416', '张相公屯乡', '4', '7393');
INSERT INTO `tp_region` VALUES ('7417', '杨郊乡', '4', '7393');
INSERT INTO `tp_region` VALUES ('7418', '大兴乡', '4', '7393');
INSERT INTO `tp_region` VALUES ('7419', '龙港区', '3', '7391');
INSERT INTO `tp_region` VALUES ('7420', '葫芦岛街道', '4', '7419');
INSERT INTO `tp_region` VALUES ('7421', '东街道', '4', '7419');
INSERT INTO `tp_region` VALUES ('7422', '西街道', '4', '7419');
INSERT INTO `tp_region` VALUES ('7423', '望海寺街道', '4', '7419');
INSERT INTO `tp_region` VALUES ('7424', '龙湾街道', '4', '7419');
INSERT INTO `tp_region` VALUES ('7425', '滨海街道', '4', '7419');
INSERT INTO `tp_region` VALUES ('7426', '双龙街道', '4', '7419');
INSERT INTO `tp_region` VALUES ('7427', '玉皇街道', '4', '7419');
INSERT INTO `tp_region` VALUES ('7428', '连湾街道', '4', '7419');
INSERT INTO `tp_region` VALUES ('7429', '北港街道', '4', '7419');
INSERT INTO `tp_region` VALUES ('7430', '双树镇', '4', '7419');
INSERT INTO `tp_region` VALUES ('7431', '葫芦岛经济开发区', '4', '7419');
INSERT INTO `tp_region` VALUES ('7432', '葫芦岛市专利技术园区', '4', '7419');
INSERT INTO `tp_region` VALUES ('7433', '南票区', '3', '7391');
INSERT INTO `tp_region` VALUES ('7434', '赵家屯街道', '4', '7433');
INSERT INTO `tp_region` VALUES ('7435', '沙锅屯街道', '4', '7433');
INSERT INTO `tp_region` VALUES ('7436', '邱皮沟街道', '4', '7433');
INSERT INTO `tp_region` VALUES ('7437', '苇子沟街道', '4', '7433');
INSERT INTO `tp_region` VALUES ('7438', '三家子街道', '4', '7433');
INSERT INTO `tp_region` VALUES ('7439', '小凌河街道', '4', '7433');
INSERT INTO `tp_region` VALUES ('7440', '九龙街道', '4', '7433');
INSERT INTO `tp_region` VALUES ('7441', '缸窑岭镇', '4', '7433');
INSERT INTO `tp_region` VALUES ('7442', '暖池塘镇', '4', '7433');
INSERT INTO `tp_region` VALUES ('7443', '沙锅屯乡', '4', '7433');
INSERT INTO `tp_region` VALUES ('7444', '黄土坎乡', '4', '7433');
INSERT INTO `tp_region` VALUES ('7445', '乌金塘水库', '4', '7433');
INSERT INTO `tp_region` VALUES ('7446', '绥中县', '3', '7391');
INSERT INTO `tp_region` VALUES ('7447', '绥中镇', '4', '7446');
INSERT INTO `tp_region` VALUES ('7448', '西甸子镇', '4', '7446');
INSERT INTO `tp_region` VALUES ('7449', '宽帮满族镇', '4', '7446');
INSERT INTO `tp_region` VALUES ('7450', '大王庙满族镇', '4', '7446');
INSERT INTO `tp_region` VALUES ('7451', '万家镇', '4', '7446');
INSERT INTO `tp_region` VALUES ('7452', '前所镇', '4', '7446');
INSERT INTO `tp_region` VALUES ('7453', '高岭镇', '4', '7446');
INSERT INTO `tp_region` VALUES ('7454', '前卫镇', '4', '7446');
INSERT INTO `tp_region` VALUES ('7455', '荒地满族镇', '4', '7446');
INSERT INTO `tp_region` VALUES ('7456', '塔山屯镇', '4', '7446');
INSERT INTO `tp_region` VALUES ('7457', '高台镇', '4', '7446');
INSERT INTO `tp_region` VALUES ('7458', '王宝镇', '4', '7446');
INSERT INTO `tp_region` VALUES ('7459', '沙河镇', '4', '7446');
INSERT INTO `tp_region` VALUES ('7460', '小庄子镇', '4', '7446');
INSERT INTO `tp_region` VALUES ('7461', '西平坡满族乡', '4', '7446');
INSERT INTO `tp_region` VALUES ('7462', '葛家满族乡', '4', '7446');
INSERT INTO `tp_region` VALUES ('7463', '高甸子满族乡', '4', '7446');
INSERT INTO `tp_region` VALUES ('7464', '范家满族乡', '4', '7446');
INSERT INTO `tp_region` VALUES ('7465', '明水满族乡', '4', '7446');
INSERT INTO `tp_region` VALUES ('7466', '秋子沟乡', '4', '7446');
INSERT INTO `tp_region` VALUES ('7467', '加碑岩乡', '4', '7446');
INSERT INTO `tp_region` VALUES ('7468', '永安堡乡', '4', '7446');
INSERT INTO `tp_region` VALUES ('7469', '李家堡乡', '4', '7446');
INSERT INTO `tp_region` VALUES ('7470', '网户满族乡', '4', '7446');
INSERT INTO `tp_region` VALUES ('7471', '城郊乡', '4', '7446');
INSERT INTO `tp_region` VALUES ('7472', '大台山果树农场', '4', '7446');
INSERT INTO `tp_region` VALUES ('7473', '前所果树农场', '4', '7446');
INSERT INTO `tp_region` VALUES ('7474', '建昌县', '3', '7391');
INSERT INTO `tp_region` VALUES ('7475', '建昌镇', '4', '7474');
INSERT INTO `tp_region` VALUES ('7476', '八家子镇', '4', '7474');
INSERT INTO `tp_region` VALUES ('7477', '喇嘛洞镇', '4', '7474');
INSERT INTO `tp_region` VALUES ('7478', '药王庙镇', '4', '7474');
INSERT INTO `tp_region` VALUES ('7479', '汤神庙镇', '4', '7474');
INSERT INTO `tp_region` VALUES ('7480', '玲珑塔镇', '4', '7474');
INSERT INTO `tp_region` VALUES ('7481', '大屯镇', '4', '7474');
INSERT INTO `tp_region` VALUES ('7482', '牛亡牛营子乡', '4', '7474');
INSERT INTO `tp_region` VALUES ('7483', '素珠营子乡', '4', '7474');
INSERT INTO `tp_region` VALUES ('7484', '石佛乡', '4', '7474');
INSERT INTO `tp_region` VALUES ('7485', '王宝营子乡', '4', '7474');
INSERT INTO `tp_region` VALUES ('7486', '老达杖子乡', '4', '7474');
INSERT INTO `tp_region` VALUES ('7487', '要路沟乡', '4', '7474');
INSERT INTO `tp_region` VALUES ('7488', '魏家岭乡', '4', '7474');
INSERT INTO `tp_region` VALUES ('7489', '西碱厂乡', '4', '7474');
INSERT INTO `tp_region` VALUES ('7490', '头道营子乡', '4', '7474');
INSERT INTO `tp_region` VALUES ('7491', '新开岭乡', '4', '7474');
INSERT INTO `tp_region` VALUES ('7492', '贺杖子乡', '4', '7474');
INSERT INTO `tp_region` VALUES ('7493', '养马甸子乡', '4', '7474');
INSERT INTO `tp_region` VALUES ('7494', '和尚房子乡', '4', '7474');
INSERT INTO `tp_region` VALUES ('7495', '杨树湾子乡', '4', '7474');
INSERT INTO `tp_region` VALUES ('7496', '黑山科乡', '4', '7474');
INSERT INTO `tp_region` VALUES ('7497', '雷家店乡', '4', '7474');
INSERT INTO `tp_region` VALUES ('7498', '小德营子乡', '4', '7474');
INSERT INTO `tp_region` VALUES ('7499', '二道湾子蒙古族乡', '4', '7474');
INSERT INTO `tp_region` VALUES ('7500', '巴什罕乡', '4', '7474');
INSERT INTO `tp_region` VALUES ('7501', '娘娘庙乡', '4', '7474');
INSERT INTO `tp_region` VALUES ('7502', '谷杖子乡', '4', '7474');
INSERT INTO `tp_region` VALUES ('7503', '兴城市', '3', '7391');
INSERT INTO `tp_region` VALUES ('7504', '古城街道', '4', '7503');
INSERT INTO `tp_region` VALUES ('7505', '宁远街道', '4', '7503');
INSERT INTO `tp_region` VALUES ('7506', '城东街道', '4', '7503');
INSERT INTO `tp_region` VALUES ('7507', '温泉街道', '4', '7503');
INSERT INTO `tp_region` VALUES ('7508', '钓鱼台街道', '4', '7503');
INSERT INTO `tp_region` VALUES ('7509', '华山街道', '4', '7503');
INSERT INTO `tp_region` VALUES ('7510', '四家屯街道', '4', '7503');
INSERT INTO `tp_region` VALUES ('7511', '曹庄镇', '4', '7503');
INSERT INTO `tp_region` VALUES ('7512', '沙后所满族镇', '4', '7503');
INSERT INTO `tp_region` VALUES ('7513', '东辛庄满族镇', '4', '7503');
INSERT INTO `tp_region` VALUES ('7514', '郭家满族镇', '4', '7503');
INSERT INTO `tp_region` VALUES ('7515', '羊安满族乡', '4', '7503');
INSERT INTO `tp_region` VALUES ('7516', '元台子满族乡', '4', '7503');
INSERT INTO `tp_region` VALUES ('7517', '白塔满族乡', '4', '7503');
INSERT INTO `tp_region` VALUES ('7518', '望海满族乡', '4', '7503');
INSERT INTO `tp_region` VALUES ('7519', '刘台子满族乡', '4', '7503');
INSERT INTO `tp_region` VALUES ('7520', '大寨满族乡', '4', '7503');
INSERT INTO `tp_region` VALUES ('7521', '南大山满族乡', '4', '7503');
INSERT INTO `tp_region` VALUES ('7522', '围屏满族乡', '4', '7503');
INSERT INTO `tp_region` VALUES ('7523', '高家岭满族乡', '4', '7503');
INSERT INTO `tp_region` VALUES ('7524', '碱厂满族乡', '4', '7503');
INSERT INTO `tp_region` VALUES ('7525', '三道沟满族乡', '4', '7503');
INSERT INTO `tp_region` VALUES ('7526', '红崖子满族乡', '4', '7503');
INSERT INTO `tp_region` VALUES ('7527', '旧门满族乡', '4', '7503');
INSERT INTO `tp_region` VALUES ('7528', '药王满族乡', '4', '7503');
INSERT INTO `tp_region` VALUES ('7529', '海滨满族乡', '4', '7503');
INSERT INTO `tp_region` VALUES ('7530', '菊花岛乡', '4', '7503');
INSERT INTO `tp_region` VALUES ('7531', '吉林省', '1', '0');
INSERT INTO `tp_region` VALUES ('7532', '长春市', '2', '7531');
INSERT INTO `tp_region` VALUES ('7533', '长春市辖区', '3', '7532');
INSERT INTO `tp_region` VALUES ('7534', '南关区', '3', '7532');
INSERT INTO `tp_region` VALUES ('7535', '南岭街道', '4', '7534');
INSERT INTO `tp_region` VALUES ('7536', '自强街道', '4', '7534');
INSERT INTO `tp_region` VALUES ('7537', '民康街道', '4', '7534');
INSERT INTO `tp_region` VALUES ('7538', '新春街道', '4', '7534');
INSERT INTO `tp_region` VALUES ('7539', '长通街道', '4', '7534');
INSERT INTO `tp_region` VALUES ('7540', '全安街道', '4', '7534');
INSERT INTO `tp_region` VALUES ('7541', '曙光街道', '4', '7534');
INSERT INTO `tp_region` VALUES ('7542', '永吉街道', '4', '7534');
INSERT INTO `tp_region` VALUES ('7543', '桃源街道', '4', '7534');
INSERT INTO `tp_region` VALUES ('7544', '鸿城街道', '4', '7534');
INSERT INTO `tp_region` VALUES ('7545', '临河街道办事处（长春经济技术开发区）（国家级）', '4', '7534');
INSERT INTO `tp_region` VALUES ('7546', '永兴街道办事处（净月潭旅游经济开发区）（省级）', '4', '7534');
INSERT INTO `tp_region` VALUES ('7547', '净月街道办事处（净月潭旅游经济开发区）（省级）', '4', '7534');
INSERT INTO `tp_region` VALUES ('7548', '新立城镇（净月潭旅游经济开发区）（省级）', '4', '7534');
INSERT INTO `tp_region` VALUES ('7549', '新湖镇（净月潭旅游经济开发区）（省级）', '4', '7534');
INSERT INTO `tp_region` VALUES ('7550', '玉潭镇（净月潭旅游经济开发区）（省级）', '4', '7534');
INSERT INTO `tp_region` VALUES ('7551', '幸福乡', '4', '7534');
INSERT INTO `tp_region` VALUES ('7552', '宽城区', '3', '7532');
INSERT INTO `tp_region` VALUES ('7553', '新发街道', '4', '7552');
INSERT INTO `tp_region` VALUES ('7554', '站前街道', '4', '7552');
INSERT INTO `tp_region` VALUES ('7555', '南广街道', '4', '7552');
INSERT INTO `tp_region` VALUES ('7556', '东广街道', '4', '7552');
INSERT INTO `tp_region` VALUES ('7557', '群英街道', '4', '7552');
INSERT INTO `tp_region` VALUES ('7558', '兴业街道', '4', '7552');
INSERT INTO `tp_region` VALUES ('7559', '凯旋街道', '4', '7552');
INSERT INTO `tp_region` VALUES ('7560', '团山街道', '4', '7552');
INSERT INTO `tp_region` VALUES ('7561', '柳影街道', '4', '7552');
INSERT INTO `tp_region` VALUES ('7562', '兰家镇', '4', '7552');
INSERT INTO `tp_region` VALUES ('7563', '米沙子镇', '4', '7552');
INSERT INTO `tp_region` VALUES ('7564', '万宝镇', '4', '7552');
INSERT INTO `tp_region` VALUES ('7565', '兴隆山镇（长春经济技术开发区）（国家级）', '4', '7552');
INSERT INTO `tp_region` VALUES ('7566', '合隆镇（合隆经济开发区）（省级）', '4', '7552');
INSERT INTO `tp_region` VALUES ('7567', '奋进乡', '4', '7552');
INSERT INTO `tp_region` VALUES ('7568', '兴业农场', '4', '7552');
INSERT INTO `tp_region` VALUES ('7569', '朝阳区', '3', '7532');
INSERT INTO `tp_region` VALUES ('7570', '南站街道', '4', '7569');
INSERT INTO `tp_region` VALUES ('7571', '桂林街道', '4', '7569');
INSERT INTO `tp_region` VALUES ('7572', '南湖街道', '4', '7569');
INSERT INTO `tp_region` VALUES ('7573', '永昌街道', '4', '7569');
INSERT INTO `tp_region` VALUES ('7574', '重庆街道', '4', '7569');
INSERT INTO `tp_region` VALUES ('7575', '清和街道', '4', '7569');
INSERT INTO `tp_region` VALUES ('7576', '红旗街道', '4', '7569');
INSERT INTO `tp_region` VALUES ('7577', '湖西街道', '4', '7569');
INSERT INTO `tp_region` VALUES ('7578', '富锋街道', '4', '7569');
INSERT INTO `tp_region` VALUES ('7579', '乐山镇', '4', '7569');
INSERT INTO `tp_region` VALUES ('7580', '永春镇', '4', '7569');
INSERT INTO `tp_region` VALUES ('7581', '双德乡（长春高新技术产业开发区）（国家级）', '4', '7569');
INSERT INTO `tp_region` VALUES ('7582', '二道区', '3', '7532');
INSERT INTO `tp_region` VALUES ('7583', '东盛街道', '4', '7582');
INSERT INTO `tp_region` VALUES ('7584', '吉林街道', '4', '7582');
INSERT INTO `tp_region` VALUES ('7585', '荣光街道', '4', '7582');
INSERT INTO `tp_region` VALUES ('7586', '东站街道', '4', '7582');
INSERT INTO `tp_region` VALUES ('7587', '远达街道', '4', '7582');
INSERT INTO `tp_region` VALUES ('7588', '八里堡街道', '4', '7582');
INSERT INTO `tp_region` VALUES ('7589', '东方广场街道办事处（长春经济技术开发区）（国家级）', '4', '7582');
INSERT INTO `tp_region` VALUES ('7590', '英俊镇', '4', '7582');
INSERT INTO `tp_region` VALUES ('7591', '劝农山镇', '4', '7582');
INSERT INTO `tp_region` VALUES ('7592', '泉眼镇', '4', '7582');
INSERT INTO `tp_region` VALUES ('7593', '龙嘉镇（东湖生态经济开发区）（省级）', '4', '7582');
INSERT INTO `tp_region` VALUES ('7594', '卡伦湖镇（东湖生态经济开发区）（省级）', '4', '7582');
INSERT INTO `tp_region` VALUES ('7595', '东湖镇（东湖生态经济开发区）（省级）', '4', '7582');
INSERT INTO `tp_region` VALUES ('7596', '四家乡', '4', '7582');
INSERT INTO `tp_region` VALUES ('7597', '绿园区', '3', '7532');
INSERT INTO `tp_region` VALUES ('7598', '正阳街道', '4', '7597');
INSERT INTO `tp_region` VALUES ('7599', '普阳街道', '4', '7597');
INSERT INTO `tp_region` VALUES ('7600', '春城街道', '4', '7597');
INSERT INTO `tp_region` VALUES ('7601', '铁西街道', '4', '7597');
INSERT INTO `tp_region` VALUES ('7602', '青年街道', '4', '7597');
INSERT INTO `tp_region` VALUES ('7603', '锦程街道办事处（长春汽车产业开发区）（省级）', '4', '7597');
INSERT INTO `tp_region` VALUES ('7604', '东风街道办事处（长春汽车产业开发区）（省级）', '4', '7597');
INSERT INTO `tp_region` VALUES ('7605', '合心镇', '4', '7597');
INSERT INTO `tp_region` VALUES ('7606', '西新镇', '4', '7597');
INSERT INTO `tp_region` VALUES ('7607', '城西镇', '4', '7597');
INSERT INTO `tp_region` VALUES ('7608', '长春汽车产业开发区（省级）', '4', '7597');
INSERT INTO `tp_region` VALUES ('7609', '绿园经济开发区（省级）', '4', '7597');
INSERT INTO `tp_region` VALUES ('7610', '双阳区', '3', '7532');
INSERT INTO `tp_region` VALUES ('7611', '云山街道', '4', '7610');
INSERT INTO `tp_region` VALUES ('7612', '平湖街道', '4', '7610');
INSERT INTO `tp_region` VALUES ('7613', '奢岭街道', '4', '7610');
INSERT INTO `tp_region` VALUES ('7614', '山河街道', '4', '7610');
INSERT INTO `tp_region` VALUES ('7615', '齐家镇', '4', '7610');
INSERT INTO `tp_region` VALUES ('7616', '太平镇', '4', '7610');
INSERT INTO `tp_region` VALUES ('7617', '鹿乡镇', '4', '7610');
INSERT INTO `tp_region` VALUES ('7618', '双营乡（梅花鹿产业经济开发区）（省级）', '4', '7610');
INSERT INTO `tp_region` VALUES ('7619', '农安县', '3', '7532');
INSERT INTO `tp_region` VALUES ('7620', '农安镇', '4', '7619');
INSERT INTO `tp_region` VALUES ('7621', '伏龙泉镇', '4', '7619');
INSERT INTO `tp_region` VALUES ('7622', '哈拉海镇', '4', '7619');
INSERT INTO `tp_region` VALUES ('7623', '靠山镇', '4', '7619');
INSERT INTO `tp_region` VALUES ('7624', '开安镇', '4', '7619');
INSERT INTO `tp_region` VALUES ('7625', '烧锅镇', '4', '7619');
INSERT INTO `tp_region` VALUES ('7626', '高家店镇', '4', '7619');
INSERT INTO `tp_region` VALUES ('7627', '华家镇', '4', '7619');
INSERT INTO `tp_region` VALUES ('7628', '三盛玉镇', '4', '7619');
INSERT INTO `tp_region` VALUES ('7629', '巴吉垒镇', '4', '7619');
INSERT INTO `tp_region` VALUES ('7630', '前岗乡', '4', '7619');
INSERT INTO `tp_region` VALUES ('7631', '龙王乡', '4', '7619');
INSERT INTO `tp_region` VALUES ('7632', '三岗乡', '4', '7619');
INSERT INTO `tp_region` VALUES ('7633', '万顺乡', '4', '7619');
INSERT INTO `tp_region` VALUES ('7634', '杨树林乡', '4', '7619');
INSERT INTO `tp_region` VALUES ('7635', '永安乡', '4', '7619');
INSERT INTO `tp_region` VALUES ('7636', '青山口乡', '4', '7619');
INSERT INTO `tp_region` VALUES ('7637', '黄鱼圈乡', '4', '7619');
INSERT INTO `tp_region` VALUES ('7638', '新农乡', '4', '7619');
INSERT INTO `tp_region` VALUES ('7639', '万金塔乡', '4', '7619');
INSERT INTO `tp_region` VALUES ('7640', '小城子乡', '4', '7619');
INSERT INTO `tp_region` VALUES ('7641', '洼中高农场', '4', '7619');
INSERT INTO `tp_region` VALUES ('7642', '九台市', '3', '7532');
INSERT INTO `tp_region` VALUES ('7643', '九台街道', '4', '7642');
INSERT INTO `tp_region` VALUES ('7644', '营城街道', '4', '7642');
INSERT INTO `tp_region` VALUES ('7645', '九郊街道', '4', '7642');
INSERT INTO `tp_region` VALUES ('7646', '沐石河镇', '4', '7642');
INSERT INTO `tp_region` VALUES ('7647', '城子街镇', '4', '7642');
INSERT INTO `tp_region` VALUES ('7648', '其塔木镇', '4', '7642');
INSERT INTO `tp_region` VALUES ('7649', '上河湾镇', '4', '7642');
INSERT INTO `tp_region` VALUES ('7650', '西营城镇', '4', '7642');
INSERT INTO `tp_region` VALUES ('7651', '土们岭镇', '4', '7642');
INSERT INTO `tp_region` VALUES ('7652', '苇子沟镇', '4', '7642');
INSERT INTO `tp_region` VALUES ('7653', '兴隆镇', '4', '7642');
INSERT INTO `tp_region` VALUES ('7654', '纪家镇', '4', '7642');
INSERT INTO `tp_region` VALUES ('7655', '波泥河镇', '4', '7642');
INSERT INTO `tp_region` VALUES ('7656', '胡家回族乡', '4', '7642');
INSERT INTO `tp_region` VALUES ('7657', '莽卡满族乡', '4', '7642');
INSERT INTO `tp_region` VALUES ('7658', '榆树市', '3', '7532');
INSERT INTO `tp_region` VALUES ('7659', '华昌街道', '4', '7658');
INSERT INTO `tp_region` VALUES ('7660', '正阳街道', '4', '7658');
INSERT INTO `tp_region` VALUES ('7661', '培英街道', '4', '7658');
INSERT INTO `tp_region` VALUES ('7662', '城郊街道', '4', '7658');
INSERT INTO `tp_region` VALUES ('7663', '五棵树镇', '4', '7658');
INSERT INTO `tp_region` VALUES ('7664', '弓棚镇', '4', '7658');
INSERT INTO `tp_region` VALUES ('7665', '闵家镇', '4', '7658');
INSERT INTO `tp_region` VALUES ('7666', '大坡镇', '4', '7658');
INSERT INTO `tp_region` VALUES ('7667', '黑林镇', '4', '7658');
INSERT INTO `tp_region` VALUES ('7668', '土桥镇', '4', '7658');
INSERT INTO `tp_region` VALUES ('7669', '新立镇', '4', '7658');
INSERT INTO `tp_region` VALUES ('7670', '大岭镇', '4', '7658');
INSERT INTO `tp_region` VALUES ('7671', '向阳镇', '4', '7658');
INSERT INTO `tp_region` VALUES ('7672', '泗河镇', '4', '7658');
INSERT INTO `tp_region` VALUES ('7673', '八号镇', '4', '7658');
INSERT INTO `tp_region` VALUES ('7674', '刘家镇', '4', '7658');
INSERT INTO `tp_region` VALUES ('7675', '秀水镇', '4', '7658');
INSERT INTO `tp_region` VALUES ('7676', '保寿镇', '4', '7658');
INSERT INTO `tp_region` VALUES ('7677', '新庄镇', '4', '7658');
INSERT INTO `tp_region` VALUES ('7678', '育民乡', '4', '7658');
INSERT INTO `tp_region` VALUES ('7679', '红星乡', '4', '7658');
INSERT INTO `tp_region` VALUES ('7680', '太安乡', '4', '7658');
INSERT INTO `tp_region` VALUES ('7681', '先峰乡', '4', '7658');
INSERT INTO `tp_region` VALUES ('7682', '青山乡', '4', '7658');
INSERT INTO `tp_region` VALUES ('7683', '延和朝鲜族乡', '4', '7658');
INSERT INTO `tp_region` VALUES ('7684', '恩育乡', '4', '7658');
INSERT INTO `tp_region` VALUES ('7685', '城发乡', '4', '7658');
INSERT INTO `tp_region` VALUES ('7686', '环城乡', '4', '7658');
INSERT INTO `tp_region` VALUES ('7687', '德惠市', '3', '7532');
INSERT INTO `tp_region` VALUES ('7688', '胜利街道', '4', '7687');
INSERT INTO `tp_region` VALUES ('7689', '建设街道', '4', '7687');
INSERT INTO `tp_region` VALUES ('7690', '惠发街道', '4', '7687');
INSERT INTO `tp_region` VALUES ('7691', '夏家店街道', '4', '7687');
INSERT INTO `tp_region` VALUES ('7692', '大青嘴镇', '4', '7687');
INSERT INTO `tp_region` VALUES ('7693', '郭家镇', '4', '7687');
INSERT INTO `tp_region` VALUES ('7694', '松花江镇', '4', '7687');
INSERT INTO `tp_region` VALUES ('7695', '达家沟镇', '4', '7687');
INSERT INTO `tp_region` VALUES ('7696', '大房身镇', '4', '7687');
INSERT INTO `tp_region` VALUES ('7697', '岔路口镇', '4', '7687');
INSERT INTO `tp_region` VALUES ('7698', '朱城子镇', '4', '7687');
INSERT INTO `tp_region` VALUES ('7699', '布海镇', '4', '7687');
INSERT INTO `tp_region` VALUES ('7700', '天台镇', '4', '7687');
INSERT INTO `tp_region` VALUES ('7701', '菜园子镇', '4', '7687');
INSERT INTO `tp_region` VALUES ('7702', '同太乡', '4', '7687');
INSERT INTO `tp_region` VALUES ('7703', '边岗乡', '4', '7687');
INSERT INTO `tp_region` VALUES ('7704', '五台乡', '4', '7687');
INSERT INTO `tp_region` VALUES ('7705', '朝阳乡', '4', '7687');
INSERT INTO `tp_region` VALUES ('7706', '吉林市', '2', '7531');
INSERT INTO `tp_region` VALUES ('7707', '吉林市辖区', '3', '7706');
INSERT INTO `tp_region` VALUES ('7708', '昌邑区', '3', '7706');
INSERT INTO `tp_region` VALUES ('7709', '兴华街道', '4', '7708');
INSERT INTO `tp_region` VALUES ('7710', '文庙街道', '4', '7708');
INSERT INTO `tp_region` VALUES ('7711', '东局子街道', '4', '7708');
INSERT INTO `tp_region` VALUES ('7712', '新地号街道', '4', '7708');
INSERT INTO `tp_region` VALUES ('7713', '延安街道', '4', '7708');
INSERT INTO `tp_region` VALUES ('7714', '站前街道', '4', '7708');
INSERT INTO `tp_region` VALUES ('7715', '民主街道', '4', '7708');
INSERT INTO `tp_region` VALUES ('7716', '莲花街道', '4', '7708');
INSERT INTO `tp_region` VALUES ('7717', '通江街道', '4', '7708');
INSERT INTO `tp_region` VALUES ('7718', '哈达湾街道', '4', '7708');
INSERT INTO `tp_region` VALUES ('7719', '新建街道', '4', '7708');
INSERT INTO `tp_region` VALUES ('7720', '延江街道', '4', '7708');
INSERT INTO `tp_region` VALUES ('7721', '双吉街道', '4', '7708');
INSERT INTO `tp_region` VALUES ('7722', '九站街道办事处(吉林经济技术开发区)（省级）', '4', '7708');
INSERT INTO `tp_region` VALUES ('7723', '吉林东市商贸示范区（省级）', '4', '7708');
INSERT INTO `tp_region` VALUES ('7724', '孤店子镇', '4', '7708');
INSERT INTO `tp_region` VALUES ('7725', '桦皮厂镇', '4', '7708');
INSERT INTO `tp_region` VALUES ('7726', '左家镇', '4', '7708');
INSERT INTO `tp_region` VALUES ('7727', '两家子满族乡', '4', '7708');
INSERT INTO `tp_region` VALUES ('7728', '土城子满族朝鲜族乡', '4', '7708');
INSERT INTO `tp_region` VALUES ('7729', '吉林哈达湾工业开发区', '4', '7708');
INSERT INTO `tp_region` VALUES ('7730', '吉林市昌邑区幸福经济管理区', '4', '7708');
INSERT INTO `tp_region` VALUES ('7731', '龙潭区', '3', '7706');
INSERT INTO `tp_region` VALUES ('7732', '龙华街道', '4', '7731');
INSERT INTO `tp_region` VALUES ('7733', '湘潭街道', '4', '7731');
INSERT INTO `tp_region` VALUES ('7734', '铁东街道', '4', '7731');
INSERT INTO `tp_region` VALUES ('7735', '泡子沿街道', '4', '7731');
INSERT INTO `tp_region` VALUES ('7736', '龙潭街道', '4', '7731');
INSERT INTO `tp_region` VALUES ('7737', '新吉林街道', '4', '7731');
INSERT INTO `tp_region` VALUES ('7738', '山前街道', '4', '7731');
INSERT INTO `tp_region` VALUES ('7739', '新安街道', '4', '7731');
INSERT INTO `tp_region` VALUES ('7740', '遵义街道', '4', '7731');
INSERT INTO `tp_region` VALUES ('7741', '榆树街道', '4', '7731');
INSERT INTO `tp_region` VALUES ('7742', '靠山街道', '4', '7731');
INSERT INTO `tp_region` VALUES ('7743', '东城街道', '4', '7731');
INSERT INTO `tp_region` VALUES ('7744', '承德街道', '4', '7731');
INSERT INTO `tp_region` VALUES ('7745', '吉林龙潭经济开发区（省级）', '4', '7731');
INSERT INTO `tp_region` VALUES ('7746', '乌拉街镇', '4', '7731');
INSERT INTO `tp_region` VALUES ('7747', '缸窑镇', '4', '7731');
INSERT INTO `tp_region` VALUES ('7748', '江密峰镇', '4', '7731');
INSERT INTO `tp_region` VALUES ('7749', '大口钦镇', '4', '7731');
INSERT INTO `tp_region` VALUES ('7750', '江北乡', '4', '7731');
INSERT INTO `tp_region` VALUES ('7751', '金珠乡', '4', '7731');
INSERT INTO `tp_region` VALUES ('7752', '船营区', '3', '7706');
INSERT INTO `tp_region` VALUES ('7753', '德胜街道', '4', '7752');
INSERT INTO `tp_region` VALUES ('7754', '南京街道', '4', '7752');
INSERT INTO `tp_region` VALUES ('7755', '大东街道', '4', '7752');
INSERT INTO `tp_region` VALUES ('7756', '青岛街道', '4', '7752');
INSERT INTO `tp_region` VALUES ('7757', '向阳街道', '4', '7752');
INSERT INTO `tp_region` VALUES ('7758', '北极街道', '4', '7752');
INSERT INTO `tp_region` VALUES ('7759', '致和街道', '4', '7752');
INSERT INTO `tp_region` VALUES ('7760', '长春路街道', '4', '7752');
INSERT INTO `tp_region` VALUES ('7761', '临江街道', '4', '7752');
INSERT INTO `tp_region` VALUES ('7762', '北山街道', '4', '7752');
INSERT INTO `tp_region` VALUES ('7763', '黄旗屯街道', '4', '7752');
INSERT INTO `tp_region` VALUES ('7764', '大绥河镇', '4', '7752');
INSERT INTO `tp_region` VALUES ('7765', '搜登站镇', '4', '7752');
INSERT INTO `tp_region` VALUES ('7766', '越北镇', '4', '7752');
INSERT INTO `tp_region` VALUES ('7767', '欢喜乡', '4', '7752');
INSERT INTO `tp_region` VALUES ('7768', '丰满区', '3', '7706');
INSERT INTO `tp_region` VALUES ('7769', '泰山街道', '4', '7768');
INSERT INTO `tp_region` VALUES ('7770', '江南街道', '4', '7768');
INSERT INTO `tp_region` VALUES ('7771', '石井街道', '4', '7768');
INSERT INTO `tp_region` VALUES ('7772', '沿丰街道', '4', '7768');
INSERT INTO `tp_region` VALUES ('7773', '丰满街道', '4', '7768');
INSERT INTO `tp_region` VALUES ('7775', '红旗街道办事处（丰满经济开发区）（省级）', '4', '7768');
INSERT INTO `tp_region` VALUES ('7776', '旺起镇', '4', '7768');
INSERT INTO `tp_region` VALUES ('7777', '江南乡', '4', '7768');
INSERT INTO `tp_region` VALUES ('7778', '前二道乡', '4', '7768');
INSERT INTO `tp_region` VALUES ('7779', '小白山乡（丰满经济开发区）（省级）', '4', '7768');
INSERT INTO `tp_region` VALUES ('7780', '朱雀山风景区', '4', '7768');
INSERT INTO `tp_region` VALUES ('7781', '永吉县', '3', '7706');
INSERT INTO `tp_region` VALUES ('7782', '口前镇', '4', '7781');
INSERT INTO `tp_region` VALUES ('7783', '双河镇', '4', '7781');
INSERT INTO `tp_region` VALUES ('7784', '西阳镇', '4', '7781');
INSERT INTO `tp_region` VALUES ('7785', '北大湖镇', '4', '7781');
INSERT INTO `tp_region` VALUES ('7786', '一拉溪镇', '4', '7781');
INSERT INTO `tp_region` VALUES ('7787', '岔路河镇（岔路河特色农业经济开发区）（省级）', '4', '7781');
INSERT INTO `tp_region` VALUES ('7788', '万昌镇（岔路河特色农业经济开发区）（省级）', '4', '7781');
INSERT INTO `tp_region` VALUES ('7789', '永吉经济开发区（省级）', '4', '7781');
INSERT INTO `tp_region` VALUES ('7790', '金家乡', '4', '7781');
INSERT INTO `tp_region` VALUES ('7791', '黄榆乡', '4', '7781');
INSERT INTO `tp_region` VALUES ('7792', '蛟河市', '3', '7706');
INSERT INTO `tp_region` VALUES ('7793', '民主街道', '4', '7792');
INSERT INTO `tp_region` VALUES ('7794', '长安街道', '4', '7792');
INSERT INTO `tp_region` VALUES ('7795', '河南街道', '4', '7792');
INSERT INTO `tp_region` VALUES ('7796', '奶子山街道', '4', '7792');
INSERT INTO `tp_region` VALUES ('7797', '拉法街道', '4', '7792');
INSERT INTO `tp_region` VALUES ('7798', '河北街道', '4', '7792');
INSERT INTO `tp_region` VALUES ('7799', '新农街道', '4', '7792');
INSERT INTO `tp_region` VALUES ('7800', '新站镇', '4', '7792');
INSERT INTO `tp_region` VALUES ('7801', '天岗镇', '4', '7792');
INSERT INTO `tp_region` VALUES ('7802', '白石山镇', '4', '7792');
INSERT INTO `tp_region` VALUES ('7803', '漂河镇', '4', '7792');
INSERT INTO `tp_region` VALUES ('7804', '黄松甸镇', '4', '7792');
INSERT INTO `tp_region` VALUES ('7805', '天北镇', '4', '7792');
INSERT INTO `tp_region` VALUES ('7806', '松江镇', '4', '7792');
INSERT INTO `tp_region` VALUES ('7807', '庆岭镇', '4', '7792');
INSERT INTO `tp_region` VALUES ('7808', '乌林朝鲜族乡', '4', '7792');
INSERT INTO `tp_region` VALUES ('7809', '前进乡', '4', '7792');
INSERT INTO `tp_region` VALUES ('7810', '桦甸市', '3', '7706');
INSERT INTO `tp_region` VALUES ('7811', '明桦街道', '4', '7810');
INSERT INTO `tp_region` VALUES ('7812', '永吉街道', '4', '7810');
INSERT INTO `tp_region` VALUES ('7813', '胜利街道', '4', '7810');
INSERT INTO `tp_region` VALUES ('7814', '新华街道', '4', '7810');
INSERT INTO `tp_region` VALUES ('7815', '启新街道', '4', '7810');
INSERT INTO `tp_region` VALUES ('7816', '桦甸经济开发区（省级）', '4', '7810');
INSERT INTO `tp_region` VALUES ('7817', '夹皮沟镇', '4', '7810');
INSERT INTO `tp_region` VALUES ('7818', '二道甸子镇', '4', '7810');
INSERT INTO `tp_region` VALUES ('7819', '红石砬子镇', '4', '7810');
INSERT INTO `tp_region` VALUES ('7820', '八道河子镇', '4', '7810');
INSERT INTO `tp_region` VALUES ('7821', '常山镇', '4', '7810');
INSERT INTO `tp_region` VALUES ('7822', '桦郊乡', '4', '7810');
INSERT INTO `tp_region` VALUES ('7823', '横道河子乡', '4', '7810');
INSERT INTO `tp_region` VALUES ('7824', '金沙乡', '4', '7810');
INSERT INTO `tp_region` VALUES ('7825', '桦树林子乡', '4', '7810');
INSERT INTO `tp_region` VALUES ('7826', '公吉乡', '4', '7810');
INSERT INTO `tp_region` VALUES ('7827', '苏密沟乡', '4', '7810');
INSERT INTO `tp_region` VALUES ('7828', '舒兰市', '3', '7706');
INSERT INTO `tp_region` VALUES ('7829', '北城街道', '4', '7828');
INSERT INTO `tp_region` VALUES ('7830', '南城街道', '4', '7828');
INSERT INTO `tp_region` VALUES ('7831', '环城街道', '4', '7828');
INSERT INTO `tp_region` VALUES ('7832', '吉舒街道', '4', '7828');
INSERT INTO `tp_region` VALUES ('7833', '铁东街道', '4', '7828');
INSERT INTO `tp_region` VALUES ('7834', '法特镇', '4', '7828');
INSERT INTO `tp_region` VALUES ('7835', '白旗镇', '4', '7828');
INSERT INTO `tp_region` VALUES ('7836', '溪河镇', '4', '7828');
INSERT INTO `tp_region` VALUES ('7837', '朝阳镇', '4', '7828');
INSERT INTO `tp_region` VALUES ('7838', '小城镇', '4', '7828');
INSERT INTO `tp_region` VALUES ('7839', '上营镇', '4', '7828');
INSERT INTO `tp_region` VALUES ('7840', '水曲柳镇', '4', '7828');
INSERT INTO `tp_region` VALUES ('7841', '平安镇', '4', '7828');
INSERT INTO `tp_region` VALUES ('7842', '金马镇', '4', '7828');
INSERT INTO `tp_region` VALUES ('7843', '开原镇', '4', '7828');
INSERT INTO `tp_region` VALUES ('7844', '莲花乡', '4', '7828');
INSERT INTO `tp_region` VALUES ('7845', '亮甲山乡', '4', '7828');
INSERT INTO `tp_region` VALUES ('7846', '新安乡', '4', '7828');
INSERT INTO `tp_region` VALUES ('7847', '七里乡', '4', '7828');
INSERT INTO `tp_region` VALUES ('7848', '天德乡', '4', '7828');
INSERT INTO `tp_region` VALUES ('7849', '磐石市', '3', '7706');
INSERT INTO `tp_region` VALUES ('7850', '福安街道', '4', '7849');
INSERT INTO `tp_region` VALUES ('7851', '东宁街道', '4', '7849');
INSERT INTO `tp_region` VALUES ('7852', '河南街道', '4', '7849');
INSERT INTO `tp_region` VALUES ('7853', '磐石经济开发区（省级）', '4', '7849');
INSERT INTO `tp_region` VALUES ('7854', '烟筒山镇', '4', '7849');
INSERT INTO `tp_region` VALUES ('7855', '红旗岭镇', '4', '7849');
INSERT INTO `tp_region` VALUES ('7856', '明城镇', '4', '7849');
INSERT INTO `tp_region` VALUES ('7857', '石嘴镇', '4', '7849');
INSERT INTO `tp_region` VALUES ('7858', '驿马镇', '4', '7849');
INSERT INTO `tp_region` VALUES ('7859', '牛心镇', '4', '7849');
INSERT INTO `tp_region` VALUES ('7860', '呼兰镇', '4', '7849');
INSERT INTO `tp_region` VALUES ('7861', '吉昌镇', '4', '7849');
INSERT INTO `tp_region` VALUES ('7862', '松山镇', '4', '7849');
INSERT INTO `tp_region` VALUES ('7863', '黑石镇', '4', '7849');
INSERT INTO `tp_region` VALUES ('7864', '朝阳山镇', '4', '7849');
INSERT INTO `tp_region` VALUES ('7865', '富太镇', '4', '7849');
INSERT INTO `tp_region` VALUES ('7866', '取柴河镇', '4', '7849');
INSERT INTO `tp_region` VALUES ('7867', '宝山乡', '4', '7849');
INSERT INTO `tp_region` VALUES ('7868', '四平市', '2', '7531');
INSERT INTO `tp_region` VALUES ('7869', '四平市辖区', '3', '7868');
INSERT INTO `tp_region` VALUES ('7870', '铁西区', '3', '7868');
INSERT INTO `tp_region` VALUES ('7871', '仁兴街道', '4', '7870');
INSERT INTO `tp_region` VALUES ('7872', '英雄街道', '4', '7870');
INSERT INTO `tp_region` VALUES ('7873', '站前街道', '4', '7870');
INSERT INTO `tp_region` VALUES ('7874', '北沟街道', '4', '7870');
INSERT INTO `tp_region` VALUES ('7875', '地直街道', '4', '7870');
INSERT INTO `tp_region` VALUES ('7876', '红嘴高新技术开发区（省级）', '4', '7870');
INSERT INTO `tp_region` VALUES ('7877', '平西乡', '4', '7870');
INSERT INTO `tp_region` VALUES ('7878', '铁东区', '3', '7868');
INSERT INTO `tp_region` VALUES ('7879', '平东街道', '4', '7878');
INSERT INTO `tp_region` VALUES ('7880', '北市场街道', '4', '7878');
INSERT INTO `tp_region` VALUES ('7881', '七马路街道', '4', '7878');
INSERT INTO `tp_region` VALUES ('7882', '四马路街道', '4', '7878');
INSERT INTO `tp_region` VALUES ('7883', '解放街道', '4', '7878');
INSERT INTO `tp_region` VALUES ('7884', '北门街道', '4', '7878');
INSERT INTO `tp_region` VALUES ('7885', '黄土坑街道', '4', '7878');
INSERT INTO `tp_region` VALUES ('7886', '平南街道', '4', '7878');
INSERT INTO `tp_region` VALUES ('7887', '山门镇', '4', '7878');
INSERT INTO `tp_region` VALUES ('7888', '石岭镇', '4', '7878');
INSERT INTO `tp_region` VALUES ('7889', '叶赫满族镇', '4', '7878');
INSERT INTO `tp_region` VALUES ('7890', '四平经济开发区（省级）', '4', '7878');
INSERT INTO `tp_region` VALUES ('7891', '城东乡', '4', '7878');
INSERT INTO `tp_region` VALUES ('7892', '梨树县', '3', '7868');
INSERT INTO `tp_region` VALUES ('7893', '梨树镇', '4', '7892');
INSERT INTO `tp_region` VALUES ('7894', '郭家店镇', '4', '7892');
INSERT INTO `tp_region` VALUES ('7895', '榆树台镇', '4', '7892');
INSERT INTO `tp_region` VALUES ('7896', '孤家子镇（四平辽河农垦管理区）', '4', '7892');
INSERT INTO `tp_region` VALUES ('7897', '小城子镇', '4', '7892');
INSERT INTO `tp_region` VALUES ('7898', '喇嘛甸镇', '4', '7892');
INSERT INTO `tp_region` VALUES ('7899', '蔡家镇', '4', '7892');
INSERT INTO `tp_region` VALUES ('7900', '刘家馆子镇', '4', '7892');
INSERT INTO `tp_region` VALUES ('7901', '十家堡镇', '4', '7892');
INSERT INTO `tp_region` VALUES ('7902', '孟家岭镇', '4', '7892');
INSERT INTO `tp_region` VALUES ('7903', '万发镇', '4', '7892');
INSERT INTO `tp_region` VALUES ('7904', '东河镇', '4', '7892');
INSERT INTO `tp_region` VALUES ('7905', '沈洋镇', '4', '7892');
INSERT INTO `tp_region` VALUES ('7906', '林海镇', '4', '7892');
INSERT INTO `tp_region` VALUES ('7907', '小宽镇', '4', '7892');
INSERT INTO `tp_region` VALUES ('7908', '白山乡', '4', '7892');
INSERT INTO `tp_region` VALUES ('7909', '泉眼岭乡', '4', '7892');
INSERT INTO `tp_region` VALUES ('7910', '胜利乡', '4', '7892');
INSERT INTO `tp_region` VALUES ('7911', '四棵树乡', '4', '7892');
INSERT INTO `tp_region` VALUES ('7912', '双河乡', '4', '7892');
INSERT INTO `tp_region` VALUES ('7913', '金山乡', '4', '7892');
INSERT INTO `tp_region` VALUES ('7914', '国营梨树农场（四平辽河农垦管理区）', '4', '7892');
INSERT INTO `tp_region` VALUES ('7915', '梨树经济开发区', '4', '7892');
INSERT INTO `tp_region` VALUES ('7916', '伊通满族自治县', '3', '7868');
INSERT INTO `tp_region` VALUES ('7917', '伊通镇', '4', '7916');
INSERT INTO `tp_region` VALUES ('7918', '二道镇', '4', '7916');
INSERT INTO `tp_region` VALUES ('7919', '伊丹镇', '4', '7916');
INSERT INTO `tp_region` VALUES ('7920', '马鞍镇', '4', '7916');
INSERT INTO `tp_region` VALUES ('7921', '景台镇', '4', '7916');
INSERT INTO `tp_region` VALUES ('7922', '靠山镇', '4', '7916');
INSERT INTO `tp_region` VALUES ('7923', '大孤山镇', '4', '7916');
INSERT INTO `tp_region` VALUES ('7924', '小孤山镇', '4', '7916');
INSERT INTO `tp_region` VALUES ('7925', '营城子镇', '4', '7916');
INSERT INTO `tp_region` VALUES ('7926', '西苇镇', '4', '7916');
INSERT INTO `tp_region` VALUES ('7927', '河源镇', '4', '7916');
INSERT INTO `tp_region` VALUES ('7928', '黄岭子镇', '4', '7916');
INSERT INTO `tp_region` VALUES ('7929', '新兴乡', '4', '7916');
INSERT INTO `tp_region` VALUES ('7930', '莫里乡', '4', '7916');
INSERT INTO `tp_region` VALUES ('7931', '三道乡', '4', '7916');
INSERT INTO `tp_region` VALUES ('7932', '伊通经济开发区', '4', '7916');
INSERT INTO `tp_region` VALUES ('7933', '公主岭市', '3', '7868');
INSERT INTO `tp_region` VALUES ('7934', '河南街道', '4', '7933');
INSERT INTO `tp_region` VALUES ('7935', '河北街道', '4', '7933');
INSERT INTO `tp_region` VALUES ('7936', '东三街道', '4', '7933');
INSERT INTO `tp_region` VALUES ('7937', '岭东街道', '4', '7933');
INSERT INTO `tp_region` VALUES ('7938', '铁北街道', '4', '7933');
INSERT INTO `tp_region` VALUES ('7939', '岭西街道', '4', '7933');
INSERT INTO `tp_region` VALUES ('7940', '刘房子街道', '4', '7933');
INSERT INTO `tp_region` VALUES ('7941', '南崴子街道', '4', '7933');
INSERT INTO `tp_region` VALUES ('7942', '环岭街道', '4', '7933');
INSERT INTO `tp_region` VALUES ('7943', '苇子沟街道', '4', '7933');
INSERT INTO `tp_region` VALUES ('7944', '二十家子镇', '4', '7933');
INSERT INTO `tp_region` VALUES ('7945', '黑林子镇', '4', '7933');
INSERT INTO `tp_region` VALUES ('7946', '陶家屯镇', '4', '7933');
INSERT INTO `tp_region` VALUES ('7947', '范家屯镇', '4', '7933');
INSERT INTO `tp_region` VALUES ('7948', '响水镇', '4', '7933');
INSERT INTO `tp_region` VALUES ('7949', '大岭镇', '4', '7933');
INSERT INTO `tp_region` VALUES ('7950', '怀德镇', '4', '7933');
INSERT INTO `tp_region` VALUES ('7951', '双城堡镇', '4', '7933');
INSERT INTO `tp_region` VALUES ('7952', '双龙镇', '4', '7933');
INSERT INTO `tp_region` VALUES ('7953', '杨大城子镇', '4', '7933');
INSERT INTO `tp_region` VALUES ('7954', '毛城子镇', '4', '7933');
INSERT INTO `tp_region` VALUES ('7955', '玻璃城子镇', '4', '7933');
INSERT INTO `tp_region` VALUES ('7956', '朝阳坡镇', '4', '7933');
INSERT INTO `tp_region` VALUES ('7957', '大榆树镇', '4', '7933');
INSERT INTO `tp_region` VALUES ('7958', '秦家屯镇', '4', '7933');
INSERT INTO `tp_region` VALUES ('7959', '八屋镇', '4', '7933');
INSERT INTO `tp_region` VALUES ('7960', '十屋镇', '4', '7933');
INSERT INTO `tp_region` VALUES ('7961', '桑树台镇', '4', '7933');
INSERT INTO `tp_region` VALUES ('7962', '龙山乡', '4', '7933');
INSERT INTO `tp_region` VALUES ('7963', '永发乡', '4', '7933');
INSERT INTO `tp_region` VALUES ('7964', '双辽市', '3', '7868');
INSERT INTO `tp_region` VALUES ('7965', '郑家屯街道', '4', '7964');
INSERT INTO `tp_region` VALUES ('7966', '辽西街道', '4', '7964');
INSERT INTO `tp_region` VALUES ('7967', '辽南街道', '4', '7964');
INSERT INTO `tp_region` VALUES ('7968', '辽北街道', '4', '7964');
INSERT INTO `tp_region` VALUES ('7969', '辽东街道', '4', '7964');
INSERT INTO `tp_region` VALUES ('7970', '红旗街道', '4', '7964');
INSERT INTO `tp_region` VALUES ('7971', '茂林镇', '4', '7964');
INSERT INTO `tp_region` VALUES ('7972', '双山镇', '4', '7964');
INSERT INTO `tp_region` VALUES ('7973', '卧虎镇', '4', '7964');
INSERT INTO `tp_region` VALUES ('7974', '服先镇', '4', '7964');
INSERT INTO `tp_region` VALUES ('7975', '王奔镇', '4', '7964');
INSERT INTO `tp_region` VALUES ('7976', '玻璃山镇', '4', '7964');
INSERT INTO `tp_region` VALUES ('7977', '兴隆镇', '4', '7964');
INSERT INTO `tp_region` VALUES ('7978', '东明镇', '4', '7964');
INSERT INTO `tp_region` VALUES ('7979', '那木乡', '4', '7964');
INSERT INTO `tp_region` VALUES ('7980', '柳条乡', '4', '7964');
INSERT INTO `tp_region` VALUES ('7981', '新立乡', '4', '7964');
INSERT INTO `tp_region` VALUES ('7982', '永加乡', '4', '7964');
INSERT INTO `tp_region` VALUES ('7983', '双辽农场（四平辽河农垦管理区）', '4', '7964');
INSERT INTO `tp_region` VALUES ('7984', '双辽种羊场（四平辽河农垦管理区）', '4', '7964');
INSERT INTO `tp_region` VALUES ('7985', '双辽经济开发区', '4', '7964');
INSERT INTO `tp_region` VALUES ('7986', '辽源市', '2', '7531');
INSERT INTO `tp_region` VALUES ('7987', '辽源市辖区', '3', '7986');
INSERT INTO `tp_region` VALUES ('7988', '龙山区', '3', '7986');
INSERT INTO `tp_region` VALUES ('7989', '南康街道', '4', '7988');
INSERT INTO `tp_region` VALUES ('7990', '北寿街道', '4', '7988');
INSERT INTO `tp_region` VALUES ('7991', '东吉街道', '4', '7988');
INSERT INTO `tp_region` VALUES ('7992', '西宁街道', '4', '7988');
INSERT INTO `tp_region` VALUES ('7993', '站前街道', '4', '7988');
INSERT INTO `tp_region` VALUES ('7994', '新兴街道', '4', '7988');
INSERT INTO `tp_region` VALUES ('7995', '福镇街道', '4', '7988');
INSERT INTO `tp_region` VALUES ('7996', '向阳街道', '4', '7988');
INSERT INTO `tp_region` VALUES ('7997', '辽源民营经济开发区（省级）', '4', '7988');
INSERT INTO `tp_region` VALUES ('7998', '寿山镇', '4', '7988');
INSERT INTO `tp_region` VALUES ('7999', '工农乡', '4', '7988');
INSERT INTO `tp_region` VALUES ('8000', '西安区', '3', '7986');
INSERT INTO `tp_region` VALUES ('8001', '仙城街道', '4', '8000');
INSERT INTO `tp_region` VALUES ('8002', '太安街道', '4', '8000');
INSERT INTO `tp_region` VALUES ('8003', '东山街道', '4', '8000');
INSERT INTO `tp_region` VALUES ('8004', '安家街道', '4', '8000');
INSERT INTO `tp_region` VALUES ('8005', '先锋街道', '4', '8000');
INSERT INTO `tp_region` VALUES ('8006', '富国街道', '4', '8000');
INSERT INTO `tp_region` VALUES ('8007', '灯塔乡', '4', '8000');
INSERT INTO `tp_region` VALUES ('8008', '东丰县', '3', '7986');
INSERT INTO `tp_region` VALUES ('8009', '东丰镇', '4', '8008');
INSERT INTO `tp_region` VALUES ('8010', '大阳镇', '4', '8008');
INSERT INTO `tp_region` VALUES ('8011', '横道河镇', '4', '8008');
INSERT INTO `tp_region` VALUES ('8012', '那丹伯镇', '4', '8008');
INSERT INTO `tp_region` VALUES ('8013', '猴石镇', '4', '8008');
INSERT INTO `tp_region` VALUES ('8014', '杨木林镇', '4', '8008');
INSERT INTO `tp_region` VALUES ('8015', '小四平镇', '4', '8008');
INSERT INTO `tp_region` VALUES ('8016', '黄河镇', '4', '8008');
INSERT INTO `tp_region` VALUES ('8017', '拉拉河镇', '4', '8008');
INSERT INTO `tp_region` VALUES ('8018', '沙河镇', '4', '8008');
INSERT INTO `tp_region` VALUES ('8019', '南屯基镇', '4', '8008');
INSERT INTO `tp_region` VALUES ('8020', '大兴镇', '4', '8008');
INSERT INTO `tp_region` VALUES ('8021', '三合满族朝鲜族乡', '4', '8008');
INSERT INTO `tp_region` VALUES ('8022', '二龙山乡', '4', '8008');
INSERT INTO `tp_region` VALUES ('8023', '东辽县', '3', '7986');
INSERT INTO `tp_region` VALUES ('8024', '白泉镇', '4', '8023');
INSERT INTO `tp_region` VALUES ('8025', '渭津镇', '4', '8023');
INSERT INTO `tp_region` VALUES ('8026', '安石镇', '4', '8023');
INSERT INTO `tp_region` VALUES ('8027', '辽河源镇', '4', '8023');
INSERT INTO `tp_region` VALUES ('8028', '泉太镇', '4', '8023');
INSERT INTO `tp_region` VALUES ('8029', '建安镇', '4', '8023');
INSERT INTO `tp_region` VALUES ('8030', '安恕镇', '4', '8023');
INSERT INTO `tp_region` VALUES ('8031', '平岗镇', '4', '8023');
INSERT INTO `tp_region` VALUES ('8032', '云顶镇', '4', '8023');
INSERT INTO `tp_region` VALUES ('8033', '凌云乡', '4', '8023');
INSERT INTO `tp_region` VALUES ('8034', '甲山乡', '4', '8023');
INSERT INTO `tp_region` VALUES ('8035', '足民乡', '4', '8023');
INSERT INTO `tp_region` VALUES ('8036', '金洲乡', '4', '8023');
INSERT INTO `tp_region` VALUES ('8037', '通化市', '2', '7531');
INSERT INTO `tp_region` VALUES ('8038', '通化市辖区', '3', '8037');
INSERT INTO `tp_region` VALUES ('8039', '东昌区', '3', '8037');
INSERT INTO `tp_region` VALUES ('8040', '东昌街道', '4', '8039');
INSERT INTO `tp_region` VALUES ('8041', '民主街道', '4', '8039');
INSERT INTO `tp_region` VALUES ('8042', '老站街道', '4', '8039');
INSERT INTO `tp_region` VALUES ('8043', '团结街道', '4', '8039');
INSERT INTO `tp_region` VALUES ('8044', '新站街道', '4', '8039');
INSERT INTO `tp_region` VALUES ('8045', '光明街道', '4', '8039');
INSERT INTO `tp_region` VALUES ('8046', '龙泉街道', '4', '8039');
INSERT INTO `tp_region` VALUES ('8047', '金厂镇', '4', '8039');
INSERT INTO `tp_region` VALUES ('8048', '环通乡', '4', '8039');
INSERT INTO `tp_region` VALUES ('8049', '江东乡', '4', '8039');
INSERT INTO `tp_region` VALUES ('8050', '通化市经济开发区管委会', '4', '8039');
INSERT INTO `tp_region` VALUES ('8051', '二道江区', '3', '8037');
INSERT INTO `tp_region` VALUES ('8052', '桃园街道', '4', '8051');
INSERT INTO `tp_region` VALUES ('8053', '东通化街道', '4', '8051');
INSERT INTO `tp_region` VALUES ('8054', '鸭园镇', '4', '8051');
INSERT INTO `tp_region` VALUES ('8055', '铁厂镇', '4', '8051');
INSERT INTO `tp_region` VALUES ('8056', '五道江镇', '4', '8051');
INSERT INTO `tp_region` VALUES ('8057', '二道江乡', '4', '8051');
INSERT INTO `tp_region` VALUES ('8058', '通化县', '3', '8037');
INSERT INTO `tp_region` VALUES ('8059', '快大茂镇', '4', '8058');
INSERT INTO `tp_region` VALUES ('8060', '二密镇', '4', '8058');
INSERT INTO `tp_region` VALUES ('8061', '果松镇', '4', '8058');
INSERT INTO `tp_region` VALUES ('8062', '石湖镇', '4', '8058');
INSERT INTO `tp_region` VALUES ('8063', '大安镇', '4', '8058');
INSERT INTO `tp_region` VALUES ('8064', '光华镇', '4', '8058');
INSERT INTO `tp_region` VALUES ('8065', '兴林镇', '4', '8058');
INSERT INTO `tp_region` VALUES ('8066', '英额布镇', '4', '8058');
INSERT INTO `tp_region` VALUES ('8067', '三棵榆树镇', '4', '8058');
INSERT INTO `tp_region` VALUES ('8068', '江甸镇', '4', '8058');
INSERT INTO `tp_region` VALUES ('8069', '富江乡', '4', '8058');
INSERT INTO `tp_region` VALUES ('8070', '四棚乡', '4', '8058');
INSERT INTO `tp_region` VALUES ('8071', '东来乡', '4', '8058');
INSERT INTO `tp_region` VALUES ('8072', '大泉源满族朝鲜族乡', '4', '8058');
INSERT INTO `tp_region` VALUES ('8073', '金斗朝鲜族满族乡', '4', '8058');
INSERT INTO `tp_region` VALUES ('8074', '通化县工业集中区', '4', '8058');
INSERT INTO `tp_region` VALUES ('8075', '东宝新村', '4', '8058');
INSERT INTO `tp_region` VALUES ('8076', '辉南县', '3', '8037');
INSERT INTO `tp_region` VALUES ('8077', '朝阳镇', '4', '8076');
INSERT INTO `tp_region` VALUES ('8078', '辉南镇', '4', '8076');
INSERT INTO `tp_region` VALUES ('8079', '样子哨镇', '4', '8076');
INSERT INTO `tp_region` VALUES ('8080', '杉松岗镇', '4', '8076');
INSERT INTO `tp_region` VALUES ('8081', '石道河镇', '4', '8076');
INSERT INTO `tp_region` VALUES ('8082', '辉发城镇', '4', '8076');
INSERT INTO `tp_region` VALUES ('8083', '抚民镇', '4', '8076');
INSERT INTO `tp_region` VALUES ('8084', '金川镇', '4', '8076');
INSERT INTO `tp_region` VALUES ('8085', '团林镇', '4', '8076');
INSERT INTO `tp_region` VALUES ('8086', '庆阳镇', '4', '8076');
INSERT INTO `tp_region` VALUES ('8087', '楼街朝鲜族乡', '4', '8076');
INSERT INTO `tp_region` VALUES ('8088', '柳河县', '3', '8037');
INSERT INTO `tp_region` VALUES ('8089', '柳河镇', '4', '8088');
INSERT INTO `tp_region` VALUES ('8090', '三源浦朝鲜族镇', '4', '8088');
INSERT INTO `tp_region` VALUES ('8091', '五道沟镇', '4', '8088');
INSERT INTO `tp_region` VALUES ('8092', '驼腰岭镇', '4', '8088');
INSERT INTO `tp_region` VALUES ('8093', '孤山子镇', '4', '8088');
INSERT INTO `tp_region` VALUES ('8094', '圣水河子镇', '4', '8088');
INSERT INTO `tp_region` VALUES ('8095', '罗通山镇', '4', '8088');
INSERT INTO `tp_region` VALUES ('8096', '安口镇', '4', '8088');
INSERT INTO `tp_region` VALUES ('8097', '向阳镇', '4', '8088');
INSERT INTO `tp_region` VALUES ('8098', '红石镇', '4', '8088');
INSERT INTO `tp_region` VALUES ('8099', '凉水河子镇', '4', '8088');
INSERT INTO `tp_region` VALUES ('8100', '亨通镇', '4', '8088');
INSERT INTO `tp_region` VALUES ('8101', '柳南乡', '4', '8088');
INSERT INTO `tp_region` VALUES ('8102', '时家店乡', '4', '8088');
INSERT INTO `tp_region` VALUES ('8103', '姜家店朝鲜族乡', '4', '8088');
INSERT INTO `tp_region` VALUES ('8104', '梅河口市', '3', '8037');
INSERT INTO `tp_region` VALUES ('8105', '新华街道', '4', '8104');
INSERT INTO `tp_region` VALUES ('8106', '光明街道', '4', '8104');
INSERT INTO `tp_region` VALUES ('8107', '和平街道办事处（梅河口市经济贸易开发区）（省级）', '4', '8104');
INSERT INTO `tp_region` VALUES ('8108', '解放街道办事处（梅河口市经济贸易开发区）（省级）', '4', '8104');
INSERT INTO `tp_region` VALUES ('8109', '福民街道办事处（梅河口市经济贸易开发区）（省级）', '4', '8104');
INSERT INTO `tp_region` VALUES ('8110', '山城镇', '4', '8104');
INSERT INTO `tp_region` VALUES ('8111', '红梅镇', '4', '8104');
INSERT INTO `tp_region` VALUES ('8112', '海龙镇', '4', '8104');
INSERT INTO `tp_region` VALUES ('8113', '新合镇', '4', '8104');
INSERT INTO `tp_region` VALUES ('8114', '曙光镇', '4', '8104');
INSERT INTO `tp_region` VALUES ('8115', '中和镇', '4', '8104');
INSERT INTO `tp_region` VALUES ('8116', '黑山头镇', '4', '8104');
INSERT INTO `tp_region` VALUES ('8117', '水道镇', '4', '8104');
INSERT INTO `tp_region` VALUES ('8118', '进化镇', '4', '8104');
INSERT INTO `tp_region` VALUES ('8119', '一座营镇', '4', '8104');
INSERT INTO `tp_region` VALUES ('8120', '康大营镇', '4', '8104');
INSERT INTO `tp_region` VALUES ('8121', '牛心顶镇', '4', '8104');
INSERT INTO `tp_region` VALUES ('8122', '杏岭乡', '4', '8104');
INSERT INTO `tp_region` VALUES ('8123', '李炉乡', '4', '8104');
INSERT INTO `tp_region` VALUES ('8124', '湾龙乡', '4', '8104');
INSERT INTO `tp_region` VALUES ('8125', '双兴乡', '4', '8104');
INSERT INTO `tp_region` VALUES ('8126', '兴华乡', '4', '8104');
INSERT INTO `tp_region` VALUES ('8127', '小杨满族朝鲜族乡', '4', '8104');
INSERT INTO `tp_region` VALUES ('8128', '吉乐乡', '4', '8104');
INSERT INTO `tp_region` VALUES ('8129', '集安市', '3', '8037');
INSERT INTO `tp_region` VALUES ('8130', '团结街道', '4', '8129');
INSERT INTO `tp_region` VALUES ('8131', '黎明街道', '4', '8129');
INSERT INTO `tp_region` VALUES ('8132', '通胜街道', '4', '8129');
INSERT INTO `tp_region` VALUES ('8133', '青石镇', '4', '8129');
INSERT INTO `tp_region` VALUES ('8134', '榆林镇', '4', '8129');
INSERT INTO `tp_region` VALUES ('8135', '花甸镇', '4', '8129');
INSERT INTO `tp_region` VALUES ('8136', '头道镇', '4', '8129');
INSERT INTO `tp_region` VALUES ('8137', '清河镇', '4', '8129');
INSERT INTO `tp_region` VALUES ('8138', '台上镇', '4', '8129');
INSERT INTO `tp_region` VALUES ('8139', '财源镇', '4', '8129');
INSERT INTO `tp_region` VALUES ('8140', '大路镇', '4', '8129');
INSERT INTO `tp_region` VALUES ('8141', '太王镇', '4', '8129');
INSERT INTO `tp_region` VALUES ('8142', '麻线乡', '4', '8129');
INSERT INTO `tp_region` VALUES ('8143', '凉水朝鲜族乡', '4', '8129');
INSERT INTO `tp_region` VALUES ('8144', '白山市', '2', '7531');
INSERT INTO `tp_region` VALUES ('8145', '白山市辖区', '3', '8144');
INSERT INTO `tp_region` VALUES ('8146', '八道江区', '3', '8144');
INSERT INTO `tp_region` VALUES ('8147', '新建街道', '4', '8146');
INSERT INTO `tp_region` VALUES ('8148', '通沟街道', '4', '8146');
INSERT INTO `tp_region` VALUES ('8149', '东兴街道', '4', '8146');
INSERT INTO `tp_region` VALUES ('8150', '红旗街道', '4', '8146');
INSERT INTO `tp_region` VALUES ('8151', '城南街道', '4', '8146');
INSERT INTO `tp_region` VALUES ('8152', '江北街道', '4', '8146');
INSERT INTO `tp_region` VALUES ('8153', '河口街道', '4', '8146');
INSERT INTO `tp_region` VALUES ('8154', '板石街道', '4', '8146');
INSERT INTO `tp_region` VALUES ('8155', '七道江镇', '4', '8146');
INSERT INTO `tp_region` VALUES ('8156', '六道江镇', '4', '8146');
INSERT INTO `tp_region` VALUES ('8157', '红土崖镇', '4', '8146');
INSERT INTO `tp_region` VALUES ('8158', '三道沟镇', '4', '8146');
INSERT INTO `tp_region` VALUES ('8159', '江源区', '3', '8144');
INSERT INTO `tp_region` VALUES ('8160', '孙家堡子镇', '4', '8159');
INSERT INTO `tp_region` VALUES ('8161', '三岔子镇', '4', '8159');
INSERT INTO `tp_region` VALUES ('8162', '湾沟镇', '4', '8159');
INSERT INTO `tp_region` VALUES ('8163', '松树镇', '4', '8159');
INSERT INTO `tp_region` VALUES ('8164', '砟子镇', '4', '8159');
INSERT INTO `tp_region` VALUES ('8165', '石人镇', '4', '8159');
INSERT INTO `tp_region` VALUES ('8166', '大阳岔镇', '4', '8159');
INSERT INTO `tp_region` VALUES ('8167', '大石人镇', '4', '8159');
INSERT INTO `tp_region` VALUES ('8168', '抚松县', '3', '8144');
INSERT INTO `tp_region` VALUES ('8169', '抚松镇', '4', '8168');
INSERT INTO `tp_region` VALUES ('8170', '松江河镇', '4', '8168');
INSERT INTO `tp_region` VALUES ('8171', '泉阳镇', '4', '8168');
INSERT INTO `tp_region` VALUES ('8172', '露水河镇', '4', '8168');
INSERT INTO `tp_region` VALUES ('8173', '仙人桥镇', '4', '8168');
INSERT INTO `tp_region` VALUES ('8174', '万良镇', '4', '8168');
INSERT INTO `tp_region` VALUES ('8175', '新屯子镇', '4', '8168');
INSERT INTO `tp_region` VALUES ('8176', '东岗镇', '4', '8168');
INSERT INTO `tp_region` VALUES ('8177', '漫江镇', '4', '8168');
INSERT INTO `tp_region` VALUES ('8178', '北岗镇', '4', '8168');
INSERT INTO `tp_region` VALUES ('8179', '兴参镇', '4', '8168');
INSERT INTO `tp_region` VALUES ('8180', '兴隆乡', '4', '8168');
INSERT INTO `tp_region` VALUES ('8181', '抽水乡', '4', '8168');
INSERT INTO `tp_region` VALUES ('8182', '沿江乡', '4', '8168');
INSERT INTO `tp_region` VALUES ('8183', '靖宇县', '3', '8144');
INSERT INTO `tp_region` VALUES ('8184', '靖宇镇', '4', '8183');
INSERT INTO `tp_region` VALUES ('8185', '三道湖镇', '4', '8183');
INSERT INTO `tp_region` VALUES ('8186', '龙泉镇', '4', '8183');
INSERT INTO `tp_region` VALUES ('8187', '那尔轰镇', '4', '8183');
INSERT INTO `tp_region` VALUES ('8188', '花园口镇', '4', '8183');
INSERT INTO `tp_region` VALUES ('8189', '景山镇', '4', '8183');
INSERT INTO `tp_region` VALUES ('8190', '赤松乡', '4', '8183');
INSERT INTO `tp_region` VALUES ('8191', '蒙江乡', '4', '8183');
INSERT INTO `tp_region` VALUES ('8192', '长白朝鲜族自治县', '3', '8144');
INSERT INTO `tp_region` VALUES ('8193', '长白镇', '4', '8192');
INSERT INTO `tp_region` VALUES ('8194', '八道沟镇', '4', '8192');
INSERT INTO `tp_region` VALUES ('8195', '十四道沟镇', '4', '8192');
INSERT INTO `tp_region` VALUES ('8196', '马鹿沟镇', '4', '8192');
INSERT INTO `tp_region` VALUES ('8197', '宝泉山镇', '4', '8192');
INSERT INTO `tp_region` VALUES ('8198', '新房子镇', '4', '8192');
INSERT INTO `tp_region` VALUES ('8199', '金华乡', '4', '8192');
INSERT INTO `tp_region` VALUES ('8200', '十二道沟乡', '4', '8192');
INSERT INTO `tp_region` VALUES ('8202', '临江市', '3', '8144');
INSERT INTO `tp_region` VALUES ('8203', '建国街道', '4', '8202');
INSERT INTO `tp_region` VALUES ('8204', '新市街道', '4', '8202');
INSERT INTO `tp_region` VALUES ('8205', '兴隆街道', '4', '8202');
INSERT INTO `tp_region` VALUES ('8206', '大湖街道', '4', '8202');
INSERT INTO `tp_region` VALUES ('8207', '森工街道', '4', '8202');
INSERT INTO `tp_region` VALUES ('8208', '大栗子街道', '4', '8202');
INSERT INTO `tp_region` VALUES ('8209', '桦树镇', '4', '8202');
INSERT INTO `tp_region` VALUES ('8210', '六道沟镇', '4', '8202');
INSERT INTO `tp_region` VALUES ('8211', '苇沙河镇', '4', '8202');
INSERT INTO `tp_region` VALUES ('8212', '花山镇', '4', '8202');
INSERT INTO `tp_region` VALUES ('8213', '闹枝镇', '4', '8202');
INSERT INTO `tp_region` VALUES ('8214', '四道沟镇', '4', '8202');
INSERT INTO `tp_region` VALUES ('8215', '蚂蚁河乡', '4', '8202');
INSERT INTO `tp_region` VALUES ('8216', '松原市', '2', '7531');
INSERT INTO `tp_region` VALUES ('8217', '松原市辖区', '3', '8216');
INSERT INTO `tp_region` VALUES ('8218', '宁江区', '3', '8216');
INSERT INTO `tp_region` VALUES ('8219', '团结街道', '4', '8218');
INSERT INTO `tp_region` VALUES ('8220', '文化街道', '4', '8218');
INSERT INTO `tp_region` VALUES ('8221', '民主街道', '4', '8218');
INSERT INTO `tp_region` VALUES ('8222', '临江街道', '4', '8218');
INSERT INTO `tp_region` VALUES ('8223', '新区街道', '4', '8218');
INSERT INTO `tp_region` VALUES ('8224', '前进街道', '4', '8218');
INSERT INTO `tp_region` VALUES ('8225', '和平街道', '4', '8218');
INSERT INTO `tp_region` VALUES ('8226', '工农街道', '4', '8218');
INSERT INTO `tp_region` VALUES ('8227', '沿江街道', '4', '8218');
INSERT INTO `tp_region` VALUES ('8228', '铁西街道', '4', '8218');
INSERT INTO `tp_region` VALUES ('8229', '繁荣街道', '4', '8218');
INSERT INTO `tp_region` VALUES ('8230', '建设街道', '4', '8218');
INSERT INTO `tp_region` VALUES ('8231', '石化街道', '4', '8218');
INSERT INTO `tp_region` VALUES ('8232', '大洼镇', '4', '8218');
INSERT INTO `tp_region` VALUES ('8233', '善友镇', '4', '8218');
INSERT INTO `tp_region` VALUES ('8234', '毛都站镇', '4', '8218');
INSERT INTO `tp_region` VALUES ('8235', '伯都纳镇', '4', '8218');
INSERT INTO `tp_region` VALUES ('8236', '新城乡', '4', '8218');
INSERT INTO `tp_region` VALUES ('8237', '兴原乡', '4', '8218');
INSERT INTO `tp_region` VALUES ('8238', '华侨农场', '4', '8218');
INSERT INTO `tp_region` VALUES ('8239', '前郭尔罗斯蒙古族自治县', '3', '8216');
INSERT INTO `tp_region` VALUES ('8240', '前郭尔罗斯镇', '4', '8239');
INSERT INTO `tp_region` VALUES ('8241', '长山镇', '4', '8239');
INSERT INTO `tp_region` VALUES ('8242', '海渤日戈镇', '4', '8239');
INSERT INTO `tp_region` VALUES ('8243', '乌兰图嘎镇', '4', '8239');
INSERT INTO `tp_region` VALUES ('8244', '查干花镇', '4', '8239');
INSERT INTO `tp_region` VALUES ('8245', '王府站镇', '4', '8239');
INSERT INTO `tp_region` VALUES ('8246', '八郎镇', '4', '8239');
INSERT INTO `tp_region` VALUES ('8247', '哈拉毛都镇', '4', '8239');
INSERT INTO `tp_region` VALUES ('8248', '宝甸乡', '4', '8239');
INSERT INTO `tp_region` VALUES ('8249', '平凤乡', '4', '8239');
INSERT INTO `tp_region` VALUES ('8250', '蒙古艾里乡', '4', '8239');
INSERT INTO `tp_region` VALUES ('8251', '达里巴乡', '4', '8239');
INSERT INTO `tp_region` VALUES ('8252', '吉拉吐乡', '4', '8239');
INSERT INTO `tp_region` VALUES ('8253', '白依拉嘎乡', '4', '8239');
INSERT INTO `tp_region` VALUES ('8254', '洪泉乡', '4', '8239');
INSERT INTO `tp_region` VALUES ('8255', '额如乡', '4', '8239');
INSERT INTO `tp_region` VALUES ('8256', '套浩太乡', '4', '8239');
INSERT INTO `tp_region` VALUES ('8257', '长龙乡', '4', '8239');
INSERT INTO `tp_region` VALUES ('8258', '乌兰塔拉乡', '4', '8239');
INSERT INTO `tp_region` VALUES ('8259', '东三家子乡', '4', '8239');
INSERT INTO `tp_region` VALUES ('8260', '浩特芒哈乡', '4', '8239');
INSERT INTO `tp_region` VALUES ('8261', '乌兰敖都乡', '4', '8239');
INSERT INTO `tp_region` VALUES ('8262', '红旗农场', '4', '8239');
INSERT INTO `tp_region` VALUES ('8263', '红光农场', '4', '8239');
INSERT INTO `tp_region` VALUES ('8264', '红星牧场', '4', '8239');
INSERT INTO `tp_region` VALUES ('8265', '查干花种畜场', '4', '8239');
INSERT INTO `tp_region` VALUES ('8266', '长岭县', '3', '8216');
INSERT INTO `tp_region` VALUES ('8267', '长岭镇', '4', '8266');
INSERT INTO `tp_region` VALUES ('8268', '太平川镇', '4', '8266');
INSERT INTO `tp_region` VALUES ('8269', '巨宝镇', '4', '8266');
INSERT INTO `tp_region` VALUES ('8270', '太平山镇', '4', '8266');
INSERT INTO `tp_region` VALUES ('8271', '前七号镇', '4', '8266');
INSERT INTO `tp_region` VALUES ('8272', '新安镇', '4', '8266');
INSERT INTO `tp_region` VALUES ('8273', '三青山镇', '4', '8266');
INSERT INTO `tp_region` VALUES ('8274', '大兴镇', '4', '8266');
INSERT INTO `tp_region` VALUES ('8275', '北正镇', '4', '8266');
INSERT INTO `tp_region` VALUES ('8276', '流水镇', '4', '8266');
INSERT INTO `tp_region` VALUES ('8277', '永久镇', '4', '8266');
INSERT INTO `tp_region` VALUES ('8278', '利发盛镇', '4', '8266');
INSERT INTO `tp_region` VALUES ('8279', '集体乡', '4', '8266');
INSERT INTO `tp_region` VALUES ('8280', '光明乡', '4', '8266');
INSERT INTO `tp_region` VALUES ('8281', '三县堡乡', '4', '8266');
INSERT INTO `tp_region` VALUES ('8282', '海青乡', '4', '8266');
INSERT INTO `tp_region` VALUES ('8283', '前进乡', '4', '8266');
INSERT INTO `tp_region` VALUES ('8284', '东岭乡', '4', '8266');
INSERT INTO `tp_region` VALUES ('8285', '腰坨子乡', '4', '8266');
INSERT INTO `tp_region` VALUES ('8286', '八十八乡', '4', '8266');
INSERT INTO `tp_region` VALUES ('8287', '三团乡', '4', '8266');
INSERT INTO `tp_region` VALUES ('8288', '三十号乡', '4', '8266');
INSERT INTO `tp_region` VALUES ('8289', '长岭种马场', '4', '8266');
INSERT INTO `tp_region` VALUES ('8290', '太平川（镇）农业园区', '4', '8266');
INSERT INTO `tp_region` VALUES ('8291', '北正（镇）牧业园区', '4', '8266');
INSERT INTO `tp_region` VALUES ('8292', '双龙工业园区', '4', '8266');
INSERT INTO `tp_region` VALUES ('8293', '长岭经济开发区', '4', '8266');
INSERT INTO `tp_region` VALUES ('8294', '太平川机械林场', '4', '8266');
INSERT INTO `tp_region` VALUES ('8295', '三团机械林场', '4', '8266');
INSERT INTO `tp_region` VALUES ('8296', '东岭机械林场', '4', '8266');
INSERT INTO `tp_region` VALUES ('8297', '十四号种畜场', '4', '8266');
INSERT INTO `tp_region` VALUES ('8298', '良种繁育场', '4', '8266');
INSERT INTO `tp_region` VALUES ('8299', '前七号机械林场', '4', '8266');
INSERT INTO `tp_region` VALUES ('8300', '乾安县', '3', '8216');
INSERT INTO `tp_region` VALUES ('8301', '乾安镇', '4', '8300');
INSERT INTO `tp_region` VALUES ('8302', '大布苏镇', '4', '8300');
INSERT INTO `tp_region` VALUES ('8303', '水字镇', '4', '8300');
INSERT INTO `tp_region` VALUES ('8304', '让字镇', '4', '8300');
INSERT INTO `tp_region` VALUES ('8305', '所字镇', '4', '8300');
INSERT INTO `tp_region` VALUES ('8306', '安字镇', '4', '8300');
INSERT INTO `tp_region` VALUES ('8307', '余字乡', '4', '8300');
INSERT INTO `tp_region` VALUES ('8308', '道字乡', '4', '8300');
INSERT INTO `tp_region` VALUES ('8309', '严字乡', '4', '8300');
INSERT INTO `tp_region` VALUES ('8310', '赞字乡', '4', '8300');
INSERT INTO `tp_region` VALUES ('8311', '扶余县', '3', '8216');
INSERT INTO `tp_region` VALUES ('8312', '三岔河镇', '4', '8311');
INSERT INTO `tp_region` VALUES ('8313', '长春岭镇', '4', '8311');
INSERT INTO `tp_region` VALUES ('8314', '五家站镇', '4', '8311');
INSERT INTO `tp_region` VALUES ('8315', '陶赖昭镇', '4', '8311');
INSERT INTO `tp_region` VALUES ('8316', '蔡家沟镇', '4', '8311');
INSERT INTO `tp_region` VALUES ('8317', '弓棚子镇', '4', '8311');
INSERT INTO `tp_region` VALUES ('8318', '三井子镇', '4', '8311');
INSERT INTO `tp_region` VALUES ('8319', '增盛镇', '4', '8311');
INSERT INTO `tp_region` VALUES ('8320', '新万发镇', '4', '8311');
INSERT INTO `tp_region` VALUES ('8321', '大林子镇', '4', '8311');
INSERT INTO `tp_region` VALUES ('8322', '新源镇', '4', '8311');
INSERT INTO `tp_region` VALUES ('8323', '三骏满族蒙古族锡伯族乡', '4', '8311');
INSERT INTO `tp_region` VALUES ('8324', '永平乡', '4', '8311');
INSERT INTO `tp_region` VALUES ('8325', '社里乡', '4', '8311');
INSERT INTO `tp_region` VALUES ('8326', '新站乡', '4', '8311');
INSERT INTO `tp_region` VALUES ('8327', '更新乡', '4', '8311');
INSERT INTO `tp_region` VALUES ('8328', '伊家店乡', '4', '8311');
INSERT INTO `tp_region` VALUES ('8329', '肖家乡', '4', '8311');
INSERT INTO `tp_region` VALUES ('8330', '伊家店农场', '4', '8311');
INSERT INTO `tp_region` VALUES ('8331', '拉林灌区管理局', '4', '8311');
INSERT INTO `tp_region` VALUES ('8332', '下岱吉灌区管理局', '4', '8311');
INSERT INTO `tp_region` VALUES ('8333', '白城市', '2', '7531');
INSERT INTO `tp_region` VALUES ('8334', '白城市辖区', '3', '8333');
INSERT INTO `tp_region` VALUES ('8335', '洮北区', '3', '8333');
INSERT INTO `tp_region` VALUES ('8336', '海明街道', '4', '8335');
INSERT INTO `tp_region` VALUES ('8337', '长庆街道', '4', '8335');
INSERT INTO `tp_region` VALUES ('8338', '瑞光街道', '4', '8335');
INSERT INTO `tp_region` VALUES ('8339', '明仁街道', '4', '8335');
INSERT INTO `tp_region` VALUES ('8340', '铁东街道', '4', '8335');
INSERT INTO `tp_region` VALUES ('8341', '城南街道', '4', '8335');
INSERT INTO `tp_region` VALUES ('8342', '新立街道', '4', '8335');
INSERT INTO `tp_region` VALUES ('8343', '幸福街道', '4', '8335');
INSERT INTO `tp_region` VALUES ('8344', '新华街道', '4', '8335');
INSERT INTO `tp_region` VALUES ('8345', '保平街道', '4', '8335');
INSERT INTO `tp_region` VALUES ('8346', '白城经济开发区（省级）', '4', '8335');
INSERT INTO `tp_region` VALUES ('8347', '平安镇', '4', '8335');
INSERT INTO `tp_region` VALUES ('8348', '青山镇', '4', '8335');
INSERT INTO `tp_region` VALUES ('8349', '林海镇', '4', '8335');
INSERT INTO `tp_region` VALUES ('8350', '洮河镇', '4', '8335');
INSERT INTO `tp_region` VALUES ('8351', '平台镇', '4', '8335');
INSERT INTO `tp_region` VALUES ('8352', '到保镇', '4', '8335');
INSERT INTO `tp_region` VALUES ('8353', '岭下镇（查干浩特旅游经济开发区）（省级）', '4', '8335');
INSERT INTO `tp_region` VALUES ('8354', '东风乡', '4', '8335');
INSERT INTO `tp_region` VALUES ('8355', '三合乡', '4', '8335');
INSERT INTO `tp_region` VALUES ('8356', '东胜乡', '4', '8335');
INSERT INTO `tp_region` VALUES ('8357', '金祥乡', '4', '8335');
INSERT INTO `tp_region` VALUES ('8358', '德顺蒙古族乡', '4', '8335');
INSERT INTO `tp_region` VALUES ('8359', '民营经济发展区', '4', '8335');
INSERT INTO `tp_region` VALUES ('8360', '白城市工业园区', '4', '8335');
INSERT INTO `tp_region` VALUES ('8361', '镇南种羊场', '4', '8335');
INSERT INTO `tp_region` VALUES ('8362', '镇赉县', '3', '8333');
INSERT INTO `tp_region` VALUES ('8363', '镇赉镇', '4', '8362');
INSERT INTO `tp_region` VALUES ('8364', '坦途镇', '4', '8362');
INSERT INTO `tp_region` VALUES ('8365', '东屏镇', '4', '8362');
INSERT INTO `tp_region` VALUES ('8366', '大屯镇', '4', '8362');
INSERT INTO `tp_region` VALUES ('8367', '沿江镇', '4', '8362');
INSERT INTO `tp_region` VALUES ('8368', '五棵树镇', '4', '8362');
INSERT INTO `tp_region` VALUES ('8369', '黑鱼泡镇', '4', '8362');
INSERT INTO `tp_region` VALUES ('8370', '哈吐气蒙古族乡', '4', '8362');
INSERT INTO `tp_region` VALUES ('8371', '莫莫格蒙古族乡', '4', '8362');
INSERT INTO `tp_region` VALUES ('8372', '建平乡', '4', '8362');
INSERT INTO `tp_region` VALUES ('8373', '嘎什根乡', '4', '8362');
INSERT INTO `tp_region` VALUES ('8374', '镇赉监狱分局', '4', '8362');
INSERT INTO `tp_region` VALUES ('8375', '通榆县', '3', '8333');
INSERT INTO `tp_region` VALUES ('8376', '开通镇', '4', '8375');
INSERT INTO `tp_region` VALUES ('8377', '瞻榆镇', '4', '8375');
INSERT INTO `tp_region` VALUES ('8378', '双岗镇', '4', '8375');
INSERT INTO `tp_region` VALUES ('8379', '兴隆山镇', '4', '8375');
INSERT INTO `tp_region` VALUES ('8380', '边昭镇', '4', '8375');
INSERT INTO `tp_region` VALUES ('8381', '鸿兴镇', '4', '8375');
INSERT INTO `tp_region` VALUES ('8382', '新华镇', '4', '8375');
INSERT INTO `tp_region` VALUES ('8383', '乌兰花镇', '4', '8375');
INSERT INTO `tp_region` VALUES ('8384', '新发乡', '4', '8375');
INSERT INTO `tp_region` VALUES ('8385', '新兴乡', '4', '8375');
INSERT INTO `tp_region` VALUES ('8386', '向海蒙古族乡', '4', '8375');
INSERT INTO `tp_region` VALUES ('8387', '包拉温都蒙古族乡', '4', '8375');
INSERT INTO `tp_region` VALUES ('8388', '团结乡', '4', '8375');
INSERT INTO `tp_region` VALUES ('8389', '十花道乡', '4', '8375');
INSERT INTO `tp_region` VALUES ('8390', '八面乡', '4', '8375');
INSERT INTO `tp_region` VALUES ('8391', '苏公坨乡', '4', '8375');
INSERT INTO `tp_region` VALUES ('8392', '通榆经济开发区', '4', '8375');
INSERT INTO `tp_region` VALUES ('8393', '洮南市', '3', '8333');
INSERT INTO `tp_region` VALUES ('8394', '团结街道', '4', '8393');
INSERT INTO `tp_region` VALUES ('8395', '富文街道', '4', '8393');
INSERT INTO `tp_region` VALUES ('8396', '光明街道', '4', '8393');
INSERT INTO `tp_region` VALUES ('8397', '兴隆街道', '4', '8393');
INSERT INTO `tp_region` VALUES ('8398', '永康街道', '4', '8393');
INSERT INTO `tp_region` VALUES ('8399', '通达街道', '4', '8393');
INSERT INTO `tp_region` VALUES ('8400', '洮府街道', '4', '8393');
INSERT INTO `tp_region` VALUES ('8401', '向阳街道', '4', '8393');
INSERT INTO `tp_region` VALUES ('8402', '瓦房镇', '4', '8393');
INSERT INTO `tp_region` VALUES ('8403', '万宝镇', '4', '8393');
INSERT INTO `tp_region` VALUES ('8404', '黑水镇', '4', '8393');
INSERT INTO `tp_region` VALUES ('8405', '那金镇', '4', '8393');
INSERT INTO `tp_region` VALUES ('8406', '安定镇', '4', '8393');
INSERT INTO `tp_region` VALUES ('8407', '胡力吐蒙古族乡', '4', '8393');
INSERT INTO `tp_region` VALUES ('8408', '万宝乡', '4', '8393');
INSERT INTO `tp_region` VALUES ('8409', '聚宝乡', '4', '8393');
INSERT INTO `tp_region` VALUES ('8410', '东升乡', '4', '8393');
INSERT INTO `tp_region` VALUES ('8411', '野马乡', '4', '8393');
INSERT INTO `tp_region` VALUES ('8412', '永茂乡', '4', '8393');
INSERT INTO `tp_region` VALUES ('8413', '蛟流河乡', '4', '8393');
INSERT INTO `tp_region` VALUES ('8414', '大通乡', '4', '8393');
INSERT INTO `tp_region` VALUES ('8415', '福顺乡', '4', '8393');
INSERT INTO `tp_region` VALUES ('8416', '二龙乡', '4', '8393');
INSERT INTO `tp_region` VALUES ('8417', '呼和车力蒙古族乡', '4', '8393');
INSERT INTO `tp_region` VALUES ('8418', '洮南市种雏场', '4', '8393');
INSERT INTO `tp_region` VALUES ('8419', '洮南市甜菜育种研究所', '4', '8393');
INSERT INTO `tp_region` VALUES ('8420', '大安市', '3', '8333');
INSERT INTO `tp_region` VALUES ('8421', '慧阳街道', '4', '8420');
INSERT INTO `tp_region` VALUES ('8422', '临江街道', '4', '8420');
INSERT INTO `tp_region` VALUES ('8423', '长虹街道', '4', '8420');
INSERT INTO `tp_region` VALUES ('8424', '锦华街道', '4', '8420');
INSERT INTO `tp_region` VALUES ('8425', '安北街道', '4', '8420');
INSERT INTO `tp_region` VALUES ('8426', '大安经济开发区（省级）', '4', '8420');
INSERT INTO `tp_region` VALUES ('8427', '月亮泡镇', '4', '8420');
INSERT INTO `tp_region` VALUES ('8428', '安广镇', '4', '8420');
INSERT INTO `tp_region` VALUES ('8429', '丰收镇', '4', '8420');
INSERT INTO `tp_region` VALUES ('8430', '新平安镇', '4', '8420');
INSERT INTO `tp_region` VALUES ('8431', '两家子镇', '4', '8420');
INSERT INTO `tp_region` VALUES ('8432', '舍力镇', '4', '8420');
INSERT INTO `tp_region` VALUES ('8433', '大岗子镇', '4', '8420');
INSERT INTO `tp_region` VALUES ('8434', '叉干镇', '4', '8420');
INSERT INTO `tp_region` VALUES ('8435', '龙沼镇', '4', '8420');
INSERT INTO `tp_region` VALUES ('8436', '太山镇', '4', '8420');
INSERT INTO `tp_region` VALUES ('8437', '烧锅镇', '4', '8420');
INSERT INTO `tp_region` VALUES ('8438', '乐胜镇', '4', '8420');
INSERT INTO `tp_region` VALUES ('8439', '四棵树乡', '4', '8420');
INSERT INTO `tp_region` VALUES ('8440', '联合乡', '4', '8420');
INSERT INTO `tp_region` VALUES ('8441', '大赉乡', '4', '8420');
INSERT INTO `tp_region` VALUES ('8442', '红岗子乡', '4', '8420');
INSERT INTO `tp_region` VALUES ('8443', '海坨乡', '4', '8420');
INSERT INTO `tp_region` VALUES ('8444', '新艾里蒙古族乡', '4', '8420');
INSERT INTO `tp_region` VALUES ('8445', '延边朝鲜族自治州', '2', '7531');
INSERT INTO `tp_region` VALUES ('8446', '延吉市', '3', '8445');
INSERT INTO `tp_region` VALUES ('8447', '朝阳街道', '4', '8446');
INSERT INTO `tp_region` VALUES ('8448', '北山街道', '4', '8446');
INSERT INTO `tp_region` VALUES ('8449', '新兴街道', '4', '8446');
INSERT INTO `tp_region` VALUES ('8450', '公园街道', '4', '8446');
INSERT INTO `tp_region` VALUES ('8451', '河南街道', '4', '8446');
INSERT INTO `tp_region` VALUES ('8452', '建工街道', '4', '8446');
INSERT INTO `tp_region` VALUES ('8453', '小营镇', '4', '8446');
INSERT INTO `tp_region` VALUES ('8454', '依兰镇', '4', '8446');
INSERT INTO `tp_region` VALUES ('8455', '三道湾镇', '4', '8446');
INSERT INTO `tp_region` VALUES ('8456', '图们市', '3', '8445');
INSERT INTO `tp_region` VALUES ('8457', '向上街道', '4', '8456');
INSERT INTO `tp_region` VALUES ('8458', '新华街道', '4', '8456');
INSERT INTO `tp_region` VALUES ('8459', '月宫街道', '4', '8456');
INSERT INTO `tp_region` VALUES ('8460', '月晴镇', '4', '8456');
INSERT INTO `tp_region` VALUES ('8461', '石岘镇', '4', '8456');
INSERT INTO `tp_region` VALUES ('8462', '长安镇', '4', '8456');
INSERT INTO `tp_region` VALUES ('8463', '凉水镇', '4', '8456');
INSERT INTO `tp_region` VALUES ('8464', '敦化市', '3', '8445');
INSERT INTO `tp_region` VALUES ('8465', '渤海街道', '4', '8464');
INSERT INTO `tp_region` VALUES ('8466', '胜利街道', '4', '8464');
INSERT INTO `tp_region` VALUES ('8467', '民主街道', '4', '8464');
INSERT INTO `tp_region` VALUES ('8468', '丹江街道', '4', '8464');
INSERT INTO `tp_region` VALUES ('8469', '大石头镇', '4', '8464');
INSERT INTO `tp_region` VALUES ('8470', '黄泥河镇', '4', '8464');
INSERT INTO `tp_region` VALUES ('8471', '官地镇', '4', '8464');
INSERT INTO `tp_region` VALUES ('8472', '沙河沿镇', '4', '8464');
INSERT INTO `tp_region` VALUES ('8473', '秋梨沟镇', '4', '8464');
INSERT INTO `tp_region` VALUES ('8474', '额穆镇', '4', '8464');
INSERT INTO `tp_region` VALUES ('8475', '贤儒镇', '4', '8464');
INSERT INTO `tp_region` VALUES ('8476', '大蒲柴河镇', '4', '8464');
INSERT INTO `tp_region` VALUES ('8477', '雁鸣湖镇', '4', '8464');
INSERT INTO `tp_region` VALUES ('8478', '江源镇', '4', '8464');
INSERT INTO `tp_region` VALUES ('8479', '江南镇', '4', '8464');
INSERT INTO `tp_region` VALUES ('8480', '大桥乡', '4', '8464');
INSERT INTO `tp_region` VALUES ('8481', '黑石乡', '4', '8464');
INSERT INTO `tp_region` VALUES ('8482', '青沟子乡', '4', '8464');
INSERT INTO `tp_region` VALUES ('8483', '翰章乡', '4', '8464');
INSERT INTO `tp_region` VALUES ('8484', '红石乡', '4', '8464');
INSERT INTO `tp_region` VALUES ('8485', '丹峰林业有限公司', '4', '8464');
INSERT INTO `tp_region` VALUES ('8486', '黄泥河林业局', '4', '8464');
INSERT INTO `tp_region` VALUES ('8487', '延边林业集团亚光有限公司', '4', '8464');
INSERT INTO `tp_region` VALUES ('8488', '敦化市林业局', '4', '8464');
INSERT INTO `tp_region` VALUES ('8489', '珲春市', '3', '8445');
INSERT INTO `tp_region` VALUES ('8490', '靖和街道', '4', '8489');
INSERT INTO `tp_region` VALUES ('8491', '新安街道', '4', '8489');
INSERT INTO `tp_region` VALUES ('8492', '河南街道', '4', '8489');
INSERT INTO `tp_region` VALUES ('8493', '近海街道办事处（珲春边境经济合作区）（国家级）', '4', '8489');
INSERT INTO `tp_region` VALUES ('8494', '春化镇', '4', '8489');
INSERT INTO `tp_region` VALUES ('8495', '敬信镇', '4', '8489');
INSERT INTO `tp_region` VALUES ('8496', '板石镇', '4', '8489');
INSERT INTO `tp_region` VALUES ('8497', '英安镇', '4', '8489');
INSERT INTO `tp_region` VALUES ('8498', '马川子乡', '4', '8489');
INSERT INTO `tp_region` VALUES ('8499', '杨泡满族乡', '4', '8489');
INSERT INTO `tp_region` VALUES ('8500', '三家子满族乡', '4', '8489');
INSERT INTO `tp_region` VALUES ('8501', '密江乡', '4', '8489');
INSERT INTO `tp_region` VALUES ('8502', '哈达门乡', '4', '8489');
INSERT INTO `tp_region` VALUES ('8503', '珲春林业局', '4', '8489');
INSERT INTO `tp_region` VALUES ('8504', '龙井市', '3', '8445');
INSERT INTO `tp_region` VALUES ('8505', '安民街道', '4', '8504');
INSERT INTO `tp_region` VALUES ('8506', '龙门街道', '4', '8504');
INSERT INTO `tp_region` VALUES ('8507', '开山屯镇', '4', '8504');
INSERT INTO `tp_region` VALUES ('8508', '朝阳川镇', '4', '8504');
INSERT INTO `tp_region` VALUES ('8509', '老头沟镇', '4', '8504');
INSERT INTO `tp_region` VALUES ('8510', '三合镇', '4', '8504');
INSERT INTO `tp_region` VALUES ('8511', '东盛涌镇', '4', '8504');
INSERT INTO `tp_region` VALUES ('8512', '智新镇', '4', '8504');
INSERT INTO `tp_region` VALUES ('8513', '德新乡', '4', '8504');
INSERT INTO `tp_region` VALUES ('8514', '白金乡', '4', '8504');
INSERT INTO `tp_region` VALUES ('8515', '和龙市', '3', '8445');
INSERT INTO `tp_region` VALUES ('8516', '民慧街道', '4', '8515');
INSERT INTO `tp_region` VALUES ('8517', '光明街道', '4', '8515');
INSERT INTO `tp_region` VALUES ('8518', '文化街道', '4', '8515');
INSERT INTO `tp_region` VALUES ('8519', '八家子镇', '4', '8515');
INSERT INTO `tp_region` VALUES ('8520', '福洞镇', '4', '8515');
INSERT INTO `tp_region` VALUES ('8521', '头道镇', '4', '8515');
INSERT INTO `tp_region` VALUES ('8522', '西城镇', '4', '8515');
INSERT INTO `tp_region` VALUES ('8523', '南坪镇', '4', '8515');
INSERT INTO `tp_region` VALUES ('8524', '东城镇', '4', '8515');
INSERT INTO `tp_region` VALUES ('8525', '崇善镇', '4', '8515');
INSERT INTO `tp_region` VALUES ('8526', '龙城镇', '4', '8515');
INSERT INTO `tp_region` VALUES ('8527', '和龙林业局', '4', '8515');
INSERT INTO `tp_region` VALUES ('8528', '八家子林业局', '4', '8515');
INSERT INTO `tp_region` VALUES ('8529', '和龙市林业局', '4', '8515');
INSERT INTO `tp_region` VALUES ('8530', '汪清县', '3', '8445');
INSERT INTO `tp_region` VALUES ('8531', '东城街道', '4', '8530');
INSERT INTO `tp_region` VALUES ('8532', '西城街道', '4', '8530');
INSERT INTO `tp_region` VALUES ('8533', '汪清镇', '4', '8530');
INSERT INTO `tp_region` VALUES ('8534', '大兴沟镇', '4', '8530');
INSERT INTO `tp_region` VALUES ('8535', '天桥岭镇', '4', '8530');
INSERT INTO `tp_region` VALUES ('8536', '罗子沟镇', '4', '8530');
INSERT INTO `tp_region` VALUES ('8537', '百草沟镇', '4', '8530');
INSERT INTO `tp_region` VALUES ('8538', '春阳镇', '4', '8530');
INSERT INTO `tp_region` VALUES ('8539', '复兴镇', '4', '8530');
INSERT INTO `tp_region` VALUES ('8540', '东光镇', '4', '8530');
INSERT INTO `tp_region` VALUES ('8541', '鸡冠乡', '4', '8530');
INSERT INTO `tp_region` VALUES ('8542', '汪清林业局', '4', '8530');
INSERT INTO `tp_region` VALUES ('8543', '天桥岭林业局', '4', '8530');
INSERT INTO `tp_region` VALUES ('8544', '大兴沟林业局', '4', '8530');
INSERT INTO `tp_region` VALUES ('8545', '安图县', '3', '8445');
INSERT INTO `tp_region` VALUES ('8546', '明月镇', '4', '8545');
INSERT INTO `tp_region` VALUES ('8547', '松江镇', '4', '8545');
INSERT INTO `tp_region` VALUES ('8548', '二道白河镇', '4', '8545');
INSERT INTO `tp_region` VALUES ('8549', '两江镇', '4', '8545');
INSERT INTO `tp_region` VALUES ('8550', '石门镇', '4', '8545');
INSERT INTO `tp_region` VALUES ('8551', '万宝镇', '4', '8545');
INSERT INTO `tp_region` VALUES ('8552', '亮兵镇', '4', '8545');
INSERT INTO `tp_region` VALUES ('8553', '新合乡', '4', '8545');
INSERT INTO `tp_region` VALUES ('8554', '永庆乡', '4', '8545');
INSERT INTO `tp_region` VALUES ('8555', '白河林业局', '4', '8545');
INSERT INTO `tp_region` VALUES ('8556', '安图林业有限公司', '4', '8545');
INSERT INTO `tp_region` VALUES ('8557', '安图县林业局', '4', '8545');
INSERT INTO `tp_region` VALUES ('8558', '黑龙江省', '1', '0');
INSERT INTO `tp_region` VALUES ('8559', '哈尔滨市', '2', '8558');
INSERT INTO `tp_region` VALUES ('8560', '市辖区', '3', '8559');
INSERT INTO `tp_region` VALUES ('8561', '道里区', '3', '8559');
INSERT INTO `tp_region` VALUES ('8562', '兆麟街道', '4', '8561');
INSERT INTO `tp_region` VALUES ('8563', '新阳路街道', '4', '8561');
INSERT INTO `tp_region` VALUES ('8564', '抚顺街道', '4', '8561');
INSERT INTO `tp_region` VALUES ('8565', '共乐街道', '4', '8561');
INSERT INTO `tp_region` VALUES ('8566', '新华街道', '4', '8561');
INSERT INTO `tp_region` VALUES ('8567', '城乡路街道', '4', '8561');
INSERT INTO `tp_region` VALUES ('8568', '工农街道', '4', '8561');
INSERT INTO `tp_region` VALUES ('8569', '尚志街道', '4', '8561');
INSERT INTO `tp_region` VALUES ('8570', '斯大林街道', '4', '8561');
INSERT INTO `tp_region` VALUES ('8571', '通江街道', '4', '8561');
INSERT INTO `tp_region` VALUES ('8572', '经纬街道', '4', '8561');
INSERT INTO `tp_region` VALUES ('8573', '工程街道', '4', '8561');
INSERT INTO `tp_region` VALUES ('8574', '安静街道', '4', '8561');
INSERT INTO `tp_region` VALUES ('8575', '安和街道', '4', '8561');
INSERT INTO `tp_region` VALUES ('8576', '正阳河街道', '4', '8561');
INSERT INTO `tp_region` VALUES ('8577', '建国街道', '4', '8561');
INSERT INTO `tp_region` VALUES ('8578', '康安街道', '4', '8561');
INSERT INTO `tp_region` VALUES ('8579', '太平镇', '4', '8561');
INSERT INTO `tp_region` VALUES ('8580', '新发镇', '4', '8561');
INSERT INTO `tp_region` VALUES ('8581', '新农镇', '4', '8561');
INSERT INTO `tp_region` VALUES ('8582', '榆树镇', '4', '8561');
INSERT INTO `tp_region` VALUES ('8583', '群力乡', '4', '8561');
INSERT INTO `tp_region` VALUES ('8584', '阎家岗农场', '4', '8561');
INSERT INTO `tp_region` VALUES ('8585', '南岗区', '3', '8559');
INSERT INTO `tp_region` VALUES ('8586', '花园街道', '4', '8585');
INSERT INTO `tp_region` VALUES ('8587', '奋斗路街道', '4', '8585');
INSERT INTO `tp_region` VALUES ('8588', '革新街道', '4', '8585');
INSERT INTO `tp_region` VALUES ('8589', '文化街道', '4', '8585');
INSERT INTO `tp_region` VALUES ('8590', '大成街道', '4', '8585');
INSERT INTO `tp_region` VALUES ('8591', '芦家街道', '4', '8585');
INSERT INTO `tp_region` VALUES ('8592', '荣市街道', '4', '8585');
INSERT INTO `tp_region` VALUES ('8593', '燎原街道', '4', '8585');
INSERT INTO `tp_region` VALUES ('8594', '松花江街道', '4', '8585');
INSERT INTO `tp_region` VALUES ('8595', '曲线街道', '4', '8585');
INSERT INTO `tp_region` VALUES ('8596', '通达街道', '4', '8585');
INSERT INTO `tp_region` VALUES ('8597', '七政街道', '4', '8585');
INSERT INTO `tp_region` VALUES ('8598', '和兴路街道', '4', '8585');
INSERT INTO `tp_region` VALUES ('8599', '哈西街道', '4', '8585');
INSERT INTO `tp_region` VALUES ('8600', '保健路街道', '4', '8585');
INSERT INTO `tp_region` VALUES ('8601', '先锋路街道', '4', '8585');
INSERT INTO `tp_region` VALUES ('8602', '新春街道', '4', '8585');
INSERT INTO `tp_region` VALUES ('8603', '王岗镇', '4', '8585');
INSERT INTO `tp_region` VALUES ('8604', '红旗满族乡', '4', '8585');
INSERT INTO `tp_region` VALUES ('8605', '跃进乡', '4', '8585');
INSERT INTO `tp_region` VALUES ('8606', '道外区', '3', '8559');
INSERT INTO `tp_region` VALUES ('8607', '靖宇街道', '4', '8606');
INSERT INTO `tp_region` VALUES ('8608', '太古街道', '4', '8606');
INSERT INTO `tp_region` VALUES ('8609', '东莱街道', '4', '8606');
INSERT INTO `tp_region` VALUES ('8610', '滨江街道', '4', '8606');
INSERT INTO `tp_region` VALUES ('8611', '仁里街道', '4', '8606');
INSERT INTO `tp_region` VALUES ('8612', '崇俭街道', '4', '8606');
INSERT INTO `tp_region` VALUES ('8613', '振江街道', '4', '8606');
INSERT INTO `tp_region` VALUES ('8614', '东原街道', '4', '8606');
INSERT INTO `tp_region` VALUES ('8615', '大兴街道', '4', '8606');
INSERT INTO `tp_region` VALUES ('8616', '胜利街道', '4', '8606');
INSERT INTO `tp_region` VALUES ('8617', '南马街道', '4', '8606');
INSERT INTO `tp_region` VALUES ('8618', '民强街道', '4', '8606');
INSERT INTO `tp_region` VALUES ('8619', '大有坊街道', '4', '8606');
INSERT INTO `tp_region` VALUES ('8620', '南直路街道', '4', '8606');
INSERT INTO `tp_region` VALUES ('8621', '化工街道', '4', '8606');
INSERT INTO `tp_region` VALUES ('8622', '火车头街道', '4', '8606');
INSERT INTO `tp_region` VALUES ('8623', '新一街道', '4', '8606');
INSERT INTO `tp_region` VALUES ('8624', '三棵树大街街道', '4', '8606');
INSERT INTO `tp_region` VALUES ('8625', '水泥路街道', '4', '8606');
INSERT INTO `tp_region` VALUES ('8626', '太平大街街道', '4', '8606');
INSERT INTO `tp_region` VALUES ('8627', '黎华街道', '4', '8606');
INSERT INTO `tp_region` VALUES ('8628', '新乐街道', '4', '8606');
INSERT INTO `tp_region` VALUES ('8629', '永源镇', '4', '8606');
INSERT INTO `tp_region` VALUES ('8630', '巨源镇', '4', '8606');
INSERT INTO `tp_region` VALUES ('8631', '团结镇', '4', '8606');
INSERT INTO `tp_region` VALUES ('8632', '民主乡', '4', '8606');
INSERT INTO `tp_region` VALUES ('8633', '平房区', '3', '8559');
INSERT INTO `tp_region` VALUES ('8634', '兴建街道', '4', '8633');
INSERT INTO `tp_region` VALUES ('8635', '保国街道', '4', '8633');
INSERT INTO `tp_region` VALUES ('8636', '联盟街道', '4', '8633');
INSERT INTO `tp_region` VALUES ('8637', '友协街道', '4', '8633');
INSERT INTO `tp_region` VALUES ('8638', '新疆街道', '4', '8633');
INSERT INTO `tp_region` VALUES ('8639', '新伟街道', '4', '8633');
INSERT INTO `tp_region` VALUES ('8640', '平房镇', '4', '8633');
INSERT INTO `tp_region` VALUES ('8641', '平新镇', '4', '8633');
INSERT INTO `tp_region` VALUES ('8642', '松北区', '3', '8559');
INSERT INTO `tp_region` VALUES ('8643', '三电街道', '4', '8642');
INSERT INTO `tp_region` VALUES ('8644', '太阳岛街道', '4', '8642');
INSERT INTO `tp_region` VALUES ('8645', '松浦街道', '4', '8642');
INSERT INTO `tp_region` VALUES ('8646', '万宝街道', '4', '8642');
INSERT INTO `tp_region` VALUES ('8647', '松北街道', '4', '8642');
INSERT INTO `tp_region` VALUES ('8648', '对青山镇', '4', '8642');
INSERT INTO `tp_region` VALUES ('8649', '乐业镇', '4', '8642');
INSERT INTO `tp_region` VALUES ('8650', '香坊区', '3', '8559');
INSERT INTO `tp_region` VALUES ('8651', '香坊大街街道', '4', '8650');
INSERT INTO `tp_region` VALUES ('8652', '安埠街道', '4', '8650');
INSERT INTO `tp_region` VALUES ('8653', '通天街道', '4', '8650');
INSERT INTO `tp_region` VALUES ('8654', '新香坊街道', '4', '8650');
INSERT INTO `tp_region` VALUES ('8655', '铁东街道', '4', '8650');
INSERT INTO `tp_region` VALUES ('8656', '新成街道', '4', '8650');
INSERT INTO `tp_region` VALUES ('8657', '红旗街道', '4', '8650');
INSERT INTO `tp_region` VALUES ('8658', '六顺街道', '4', '8650');
INSERT INTO `tp_region` VALUES ('8659', '建筑街道', '4', '8650');
INSERT INTO `tp_region` VALUES ('8660', '哈平路街道', '4', '8650');
INSERT INTO `tp_region` VALUES ('8661', '安乐街道', '4', '8650');
INSERT INTO `tp_region` VALUES ('8662', '健康路街道', '4', '8650');
INSERT INTO `tp_region` VALUES ('8663', '大庆路街道', '4', '8650');
INSERT INTO `tp_region` VALUES ('8664', '进乡街道', '4', '8650');
INSERT INTO `tp_region` VALUES ('8665', '通乡街道', '4', '8650');
INSERT INTO `tp_region` VALUES ('8666', '和平路街道', '4', '8650');
INSERT INTO `tp_region` VALUES ('8667', '民生路街道', '4', '8650');
INSERT INTO `tp_region` VALUES ('8668', '文政街道', '4', '8650');
INSERT INTO `tp_region` VALUES ('8669', '王兆街道', '4', '8650');
INSERT INTO `tp_region` VALUES ('8670', '黎明街道', '4', '8650');
INSERT INTO `tp_region` VALUES ('8671', '成高子镇', '4', '8650');
INSERT INTO `tp_region` VALUES ('8672', '幸福镇', '4', '8650');
INSERT INTO `tp_region` VALUES ('8673', '朝阳镇', '4', '8650');
INSERT INTO `tp_region` VALUES ('8674', '向阳乡', '4', '8650');
INSERT INTO `tp_region` VALUES ('8675', '香坊实验农场', '4', '8650');
INSERT INTO `tp_region` VALUES ('8676', '呼兰区', '3', '8559');
INSERT INTO `tp_region` VALUES ('8677', '呼兰街道', '4', '8676');
INSERT INTO `tp_region` VALUES ('8678', '兰河街道', '4', '8676');
INSERT INTO `tp_region` VALUES ('8679', '利民街道', '4', '8676');
INSERT INTO `tp_region` VALUES ('8680', '腰卜街道', '4', '8676');
INSERT INTO `tp_region` VALUES ('8681', '康金镇', '4', '8676');
INSERT INTO `tp_region` VALUES ('8682', '沈家镇', '4', '8676');
INSERT INTO `tp_region` VALUES ('8683', '二八镇', '4', '8676');
INSERT INTO `tp_region` VALUES ('8684', '石人镇', '4', '8676');
INSERT INTO `tp_region` VALUES ('8685', '白奎镇', '4', '8676');
INSERT INTO `tp_region` VALUES ('8686', '方台镇', '4', '8676');
INSERT INTO `tp_region` VALUES ('8687', '莲花镇', '4', '8676');
INSERT INTO `tp_region` VALUES ('8688', '大用镇', '4', '8676');
INSERT INTO `tp_region` VALUES ('8689', '双井镇', '4', '8676');
INSERT INTO `tp_region` VALUES ('8690', '长岭镇', '4', '8676');
INSERT INTO `tp_region` VALUES ('8691', '杨林乡', '4', '8676');
INSERT INTO `tp_region` VALUES ('8692', '许卜乡', '4', '8676');
INSERT INTO `tp_region` VALUES ('8693', '孟家乡', '4', '8676');
INSERT INTO `tp_region` VALUES ('8694', '阿城区', '3', '8559');
INSERT INTO `tp_region` VALUES ('8695', '和平街道', '4', '8694');
INSERT INTO `tp_region` VALUES ('8696', '胜利街道', '4', '8694');
INSERT INTO `tp_region` VALUES ('8697', '通城街道', '4', '8694');
INSERT INTO `tp_region` VALUES ('8698', '河东街道', '4', '8694');
INSERT INTO `tp_region` VALUES ('8699', '阿什河街道', '4', '8694');
INSERT INTO `tp_region` VALUES ('8700', '玉泉镇', '4', '8694');
INSERT INTO `tp_region` VALUES ('8701', '蜚克图镇', '4', '8694');
INSERT INTO `tp_region` VALUES ('8702', '亚沟镇', '4', '8694');
INSERT INTO `tp_region` VALUES ('8703', '交界镇', '4', '8694');
INSERT INTO `tp_region` VALUES ('8704', '小岭镇', '4', '8694');
INSERT INTO `tp_region` VALUES ('8705', '平山镇', '4', '8694');
INSERT INTO `tp_region` VALUES ('8706', '松峰山镇', '4', '8694');
INSERT INTO `tp_region` VALUES ('8707', '新华镇', '4', '8694');
INSERT INTO `tp_region` VALUES ('8708', '双丰镇', '4', '8694');
INSERT INTO `tp_region` VALUES ('8709', '杨树乡', '4', '8694');
INSERT INTO `tp_region` VALUES ('8710', '舍利乡', '4', '8694');
INSERT INTO `tp_region` VALUES ('8711', '料甸满族乡', '4', '8694');
INSERT INTO `tp_region` VALUES ('8712', '红星乡', '4', '8694');
INSERT INTO `tp_region` VALUES ('8713', '大岭乡', '4', '8694');
INSERT INTO `tp_region` VALUES ('8714', '依兰县', '3', '8559');
INSERT INTO `tp_region` VALUES ('8715', '依兰镇', '4', '8714');
INSERT INTO `tp_region` VALUES ('8716', '达连河镇', '4', '8714');
INSERT INTO `tp_region` VALUES ('8717', '江湾镇', '4', '8714');
INSERT INTO `tp_region` VALUES ('8718', '三道岗镇', '4', '8714');
INSERT INTO `tp_region` VALUES ('8719', '道台桥镇', '4', '8714');
INSERT INTO `tp_region` VALUES ('8720', '宏克利镇', '4', '8714');
INSERT INTO `tp_region` VALUES ('8721', '团山子乡', '4', '8714');
INSERT INTO `tp_region` VALUES ('8722', '愚公乡', '4', '8714');
INSERT INTO `tp_region` VALUES ('8723', '迎兰朝鲜族乡', '4', '8714');
INSERT INTO `tp_region` VALUES ('8724', '依兰县林业局', '4', '8714');
INSERT INTO `tp_region` VALUES ('8725', '依兰农场', '4', '8714');
INSERT INTO `tp_region` VALUES ('8726', '松花江农场', '4', '8714');
INSERT INTO `tp_region` VALUES ('8727', '红旗良种厂', '4', '8714');
INSERT INTO `tp_region` VALUES ('8728', '依兰县农委', '4', '8714');
INSERT INTO `tp_region` VALUES ('8729', '方正县', '3', '8559');
INSERT INTO `tp_region` VALUES ('8730', '方正镇', '4', '8729');
INSERT INTO `tp_region` VALUES ('8731', '会发镇', '4', '8729');
INSERT INTO `tp_region` VALUES ('8732', '大罗密镇', '4', '8729');
INSERT INTO `tp_region` VALUES ('8733', '天门乡', '4', '8729');
INSERT INTO `tp_region` VALUES ('8734', '松南乡', '4', '8729');
INSERT INTO `tp_region` VALUES ('8735', '德善乡', '4', '8729');
INSERT INTO `tp_region` VALUES ('8736', '宝兴乡', '4', '8729');
INSERT INTO `tp_region` VALUES ('8737', '伊汉通乡', '4', '8729');
INSERT INTO `tp_region` VALUES ('8738', '方正林业局', '4', '8729');
INSERT INTO `tp_region` VALUES ('8739', '沙河农场', '4', '8729');
INSERT INTO `tp_region` VALUES ('8740', '宾县', '3', '8559');
INSERT INTO `tp_region` VALUES ('8741', '宾州镇', '4', '8740');
INSERT INTO `tp_region` VALUES ('8742', '居仁镇', '4', '8740');
INSERT INTO `tp_region` VALUES ('8743', '宾西镇', '4', '8740');
INSERT INTO `tp_region` VALUES ('8744', '糖坊镇', '4', '8740');
INSERT INTO `tp_region` VALUES ('8745', '宾安镇', '4', '8740');
INSERT INTO `tp_region` VALUES ('8746', '新甸镇', '4', '8740');
INSERT INTO `tp_region` VALUES ('8747', '胜利镇', '4', '8740');
INSERT INTO `tp_region` VALUES ('8748', '宁远镇', '4', '8740');
INSERT INTO `tp_region` VALUES ('8749', '摆渡镇', '4', '8740');
INSERT INTO `tp_region` VALUES ('8750', '平坊镇', '4', '8740');
INSERT INTO `tp_region` VALUES ('8751', '满井镇', '4', '8740');
INSERT INTO `tp_region` VALUES ('8752', '常安镇', '4', '8740');
INSERT INTO `tp_region` VALUES ('8753', '永和乡', '4', '8740');
INSERT INTO `tp_region` VALUES ('8754', '鸟河乡', '4', '8740');
INSERT INTO `tp_region` VALUES ('8755', '民和乡', '4', '8740');
INSERT INTO `tp_region` VALUES ('8756', '经建乡', '4', '8740');
INSERT INTO `tp_region` VALUES ('8757', '三宝乡', '4', '8740');
INSERT INTO `tp_region` VALUES ('8758', '巴彦县', '3', '8559');
INSERT INTO `tp_region` VALUES ('8759', '巴彦镇', '4', '8758');
INSERT INTO `tp_region` VALUES ('8760', '兴隆镇', '4', '8758');
INSERT INTO `tp_region` VALUES ('8761', '西集镇', '4', '8758');
INSERT INTO `tp_region` VALUES ('8762', '洼兴镇', '4', '8758');
INSERT INTO `tp_region` VALUES ('8763', '龙泉镇', '4', '8758');
INSERT INTO `tp_region` VALUES ('8764', '巴彦港镇', '4', '8758');
INSERT INTO `tp_region` VALUES ('8765', '龙庙镇', '4', '8758');
INSERT INTO `tp_region` VALUES ('8766', '万发镇', '4', '8758');
INSERT INTO `tp_region` VALUES ('8767', '天增镇', '4', '8758');
INSERT INTO `tp_region` VALUES ('8768', '黑山镇', '4', '8758');
INSERT INTO `tp_region` VALUES ('8769', '松花江乡', '4', '8758');
INSERT INTO `tp_region` VALUES ('8770', '富江乡', '4', '8758');
INSERT INTO `tp_region` VALUES ('8771', '华山乡', '4', '8758');
INSERT INTO `tp_region` VALUES ('8772', '丰乐乡', '4', '8758');
INSERT INTO `tp_region` VALUES ('8773', '德祥乡', '4', '8758');
INSERT INTO `tp_region` VALUES ('8774', '红光乡', '4', '8758');
INSERT INTO `tp_region` VALUES ('8775', '山后乡', '4', '8758');
INSERT INTO `tp_region` VALUES ('8776', '镇东乡', '4', '8758');
INSERT INTO `tp_region` VALUES ('8777', '兴隆林业局', '4', '8758');
INSERT INTO `tp_region` VALUES ('8778', '木兰县', '3', '8559');
INSERT INTO `tp_region` VALUES ('8779', '木兰镇', '4', '8778');
INSERT INTO `tp_region` VALUES ('8780', '东兴镇', '4', '8778');
INSERT INTO `tp_region` VALUES ('8781', '大贵镇', '4', '8778');
INSERT INTO `tp_region` VALUES ('8782', '利东镇', '4', '8778');
INSERT INTO `tp_region` VALUES ('8783', '柳河镇', '4', '8778');
INSERT INTO `tp_region` VALUES ('8784', '新民镇', '4', '8778');
INSERT INTO `tp_region` VALUES ('8785', '建国乡', '4', '8778');
INSERT INTO `tp_region` VALUES ('8786', '吉兴乡', '4', '8778');
INSERT INTO `tp_region` VALUES ('8787', '兴隆林业局', '4', '8778');
INSERT INTO `tp_region` VALUES ('8788', '通河县', '3', '8559');
INSERT INTO `tp_region` VALUES ('8789', '通河镇', '4', '8788');
INSERT INTO `tp_region` VALUES ('8790', '乌鸦泡镇', '4', '8788');
INSERT INTO `tp_region` VALUES ('8791', '清河镇', '4', '8788');
INSERT INTO `tp_region` VALUES ('8792', '浓河镇', '4', '8788');
INSERT INTO `tp_region` VALUES ('8793', '凤山镇', '4', '8788');
INSERT INTO `tp_region` VALUES ('8794', '祥顺镇', '4', '8788');
INSERT INTO `tp_region` VALUES ('8795', '三站乡', '4', '8788');
INSERT INTO `tp_region` VALUES ('8796', '富林乡', '4', '8788');
INSERT INTO `tp_region` VALUES ('8797', '清河林业局', '4', '8788');
INSERT INTO `tp_region` VALUES ('8798', '兴隆林业局', '4', '8788');
INSERT INTO `tp_region` VALUES ('8799', '岔林河农场', '4', '8788');
INSERT INTO `tp_region` VALUES ('8800', '延寿县', '3', '8559');
INSERT INTO `tp_region` VALUES ('8801', '延寿镇', '4', '8800');
INSERT INTO `tp_region` VALUES ('8802', '六团镇', '4', '8800');
INSERT INTO `tp_region` VALUES ('8803', '中和镇', '4', '8800');
INSERT INTO `tp_region` VALUES ('8804', '加信镇', '4', '8800');
INSERT INTO `tp_region` VALUES ('8805', '延河镇', '4', '8800');
INSERT INTO `tp_region` VALUES ('8806', '安山乡', '4', '8800');
INSERT INTO `tp_region` VALUES ('8807', '寿山乡', '4', '8800');
INSERT INTO `tp_region` VALUES ('8808', '玉河乡', '4', '8800');
INSERT INTO `tp_region` VALUES ('8809', '青川乡', '4', '8800');
INSERT INTO `tp_region` VALUES ('8810', '太平川', '4', '8800');
INSERT INTO `tp_region` VALUES ('8811', '庆阳农场', '4', '8800');
INSERT INTO `tp_region` VALUES ('8812', '双城市', '3', '8559');
INSERT INTO `tp_region` VALUES ('8813', '双城市街道社区管委会', '4', '8812');
INSERT INTO `tp_region` VALUES ('8814', '双城镇', '4', '8812');
INSERT INTO `tp_region` VALUES ('8815', '兰棱镇', '4', '8812');
INSERT INTO `tp_region` VALUES ('8816', '周家镇', '4', '8812');
INSERT INTO `tp_region` VALUES ('8817', '五家镇', '4', '8812');
INSERT INTO `tp_region` VALUES ('8818', '韩甸镇', '4', '8812');
INSERT INTO `tp_region` VALUES ('8819', '单城镇', '4', '8812');
INSERT INTO `tp_region` VALUES ('8820', '东官镇', '4', '8812');
INSERT INTO `tp_region` VALUES ('8821', '农丰满族锡伯族镇', '4', '8812');
INSERT INTO `tp_region` VALUES ('8822', '杏山镇', '4', '8812');
INSERT INTO `tp_region` VALUES ('8823', '朝阳乡', '4', '8812');
INSERT INTO `tp_region` VALUES ('8824', '金城乡', '4', '8812');
INSERT INTO `tp_region` VALUES ('8825', '青岭满族乡', '4', '8812');
INSERT INTO `tp_region` VALUES ('8826', '联兴满族乡', '4', '8812');
INSERT INTO `tp_region` VALUES ('8827', '幸福满族乡', '4', '8812');
INSERT INTO `tp_region` VALUES ('8828', '新兴满族乡', '4', '8812');
INSERT INTO `tp_region` VALUES ('8829', '公正满族乡', '4', '8812');
INSERT INTO `tp_region` VALUES ('8830', '永胜乡', '4', '8812');
INSERT INTO `tp_region` VALUES ('8831', '临江乡', '4', '8812');
INSERT INTO `tp_region` VALUES ('8832', '水泉乡', '4', '8812');
INSERT INTO `tp_region` VALUES ('8833', '乐群满族乡', '4', '8812');
INSERT INTO `tp_region` VALUES ('8834', '团结满族乡', '4', '8812');
INSERT INTO `tp_region` VALUES ('8835', '万隆乡', '4', '8812');
INSERT INTO `tp_region` VALUES ('8836', '希勤满族乡', '4', '8812');
INSERT INTO `tp_region` VALUES ('8837', '同心满族乡', '4', '8812');
INSERT INTO `tp_region` VALUES ('8838', '尚志市', '3', '8559');
INSERT INTO `tp_region` VALUES ('8839', '尚志镇', '4', '8838');
INSERT INTO `tp_region` VALUES ('8840', '一面坡镇', '4', '8838');
INSERT INTO `tp_region` VALUES ('8841', '苇河镇', '4', '8838');
INSERT INTO `tp_region` VALUES ('8842', '亚布力镇', '4', '8838');
INSERT INTO `tp_region` VALUES ('8843', '帽儿山镇', '4', '8838');
INSERT INTO `tp_region` VALUES ('8844', '亮河镇', '4', '8838');
INSERT INTO `tp_region` VALUES ('8845', '庆阳镇', '4', '8838');
INSERT INTO `tp_region` VALUES ('8846', '石头河子镇', '4', '8838');
INSERT INTO `tp_region` VALUES ('8847', '元宝镇', '4', '8838');
INSERT INTO `tp_region` VALUES ('8848', '黑龙宫镇', '4', '8838');
INSERT INTO `tp_region` VALUES ('8849', '长寿乡', '4', '8838');
INSERT INTO `tp_region` VALUES ('8850', '乌吉密乡', '4', '8838');
INSERT INTO `tp_region` VALUES ('8851', '鱼池乡', '4', '8838');
INSERT INTO `tp_region` VALUES ('8852', '珍珠山乡', '4', '8838');
INSERT INTO `tp_region` VALUES ('8853', '老街基乡', '4', '8838');
INSERT INTO `tp_region` VALUES ('8854', '马延乡', '4', '8838');
INSERT INTO `tp_region` VALUES ('8855', '河东乡', '4', '8838');
INSERT INTO `tp_region` VALUES ('8856', '苇河林业局', '4', '8838');
INSERT INTO `tp_region` VALUES ('8857', '亚布力林业局', '4', '8838');
INSERT INTO `tp_region` VALUES ('8858', '五常市', '3', '8559');
INSERT INTO `tp_region` VALUES ('8859', '五常镇', '4', '8858');
INSERT INTO `tp_region` VALUES ('8860', '拉林满族镇', '4', '8858');
INSERT INTO `tp_region` VALUES ('8861', '山河镇', '4', '8858');
INSERT INTO `tp_region` VALUES ('8862', '小山子镇', '4', '8858');
INSERT INTO `tp_region` VALUES ('8863', '安家镇', '4', '8858');
INSERT INTO `tp_region` VALUES ('8864', '牛家满族镇', '4', '8858');
INSERT INTO `tp_region` VALUES ('8865', '杜家镇', '4', '8858');
INSERT INTO `tp_region` VALUES ('8866', '背荫河镇', '4', '8858');
INSERT INTO `tp_region` VALUES ('8867', '冲河镇', '4', '8858');
INSERT INTO `tp_region` VALUES ('8868', '沙河子镇', '4', '8858');
INSERT INTO `tp_region` VALUES ('8869', '向阳镇', '4', '8858');
INSERT INTO `tp_region` VALUES ('8870', '兴盛乡', '4', '8858');
INSERT INTO `tp_region` VALUES ('8871', '志广乡', '4', '8858');
INSERT INTO `tp_region` VALUES ('8872', '卫国乡', '4', '8858');
INSERT INTO `tp_region` VALUES ('8873', '常堡乡', '4', '8858');
INSERT INTO `tp_region` VALUES ('8874', '民意乡', '4', '8858');
INSERT INTO `tp_region` VALUES ('8875', '龙凤山乡', '4', '8858');
INSERT INTO `tp_region` VALUES ('8876', '红旗满族乡', '4', '8858');
INSERT INTO `tp_region` VALUES ('8877', '八家子乡', '4', '8858');
INSERT INTO `tp_region` VALUES ('8878', '民乐朝鲜族乡', '4', '8858');
INSERT INTO `tp_region` VALUES ('8879', '营城子满族乡', '4', '8858');
INSERT INTO `tp_region` VALUES ('8880', '长山乡', '4', '8858');
INSERT INTO `tp_region` VALUES ('8881', '兴隆乡', '4', '8858');
INSERT INTO `tp_region` VALUES ('8882', '二河乡', '4', '8858');
INSERT INTO `tp_region` VALUES ('8883', '山河屯林业局', '4', '8858');
INSERT INTO `tp_region` VALUES ('8884', '齐齐哈尔市', '2', '8558');
INSERT INTO `tp_region` VALUES ('8885', '市辖区', '3', '8884');
INSERT INTO `tp_region` VALUES ('8886', '龙沙区', '3', '8884');
INSERT INTO `tp_region` VALUES ('8887', '五龙街道', '4', '8886');
INSERT INTO `tp_region` VALUES ('8888', '湖滨街道', '4', '8886');
INSERT INTO `tp_region` VALUES ('8889', '江安街道', '4', '8886');
INSERT INTO `tp_region` VALUES ('8890', '正阳街道', '4', '8886');
INSERT INTO `tp_region` VALUES ('8891', '彩虹街道', '4', '8886');
INSERT INTO `tp_region` VALUES ('8892', '南航街道', '4', '8886');
INSERT INTO `tp_region` VALUES ('8893', '龙沙区直辖地域', '4', '8886');
INSERT INTO `tp_region` VALUES ('8894', '建华区', '3', '8884');
INSERT INTO `tp_region` VALUES ('8895', '中华街道', '4', '8894');
INSERT INTO `tp_region` VALUES ('8896', '西大桥街道', '4', '8894');
INSERT INTO `tp_region` VALUES ('8897', '卜奎街道', '4', '8894');
INSERT INTO `tp_region` VALUES ('8898', '建设街道', '4', '8894');
INSERT INTO `tp_region` VALUES ('8899', '文化街道', '4', '8894');
INSERT INTO `tp_region` VALUES ('8900', '建华区直辖地域', '4', '8894');
INSERT INTO `tp_region` VALUES ('8901', '铁锋区', '3', '8884');
INSERT INTO `tp_region` VALUES ('8902', '站前街道', '4', '8901');
INSERT INTO `tp_region` VALUES ('8903', '南浦街道', '4', '8901');
INSERT INTO `tp_region` VALUES ('8904', '通东街道', '4', '8901');
INSERT INTO `tp_region` VALUES ('8905', '光荣街道', '4', '8901');
INSERT INTO `tp_region` VALUES ('8906', '龙华街道', '4', '8901');
INSERT INTO `tp_region` VALUES ('8907', '北局宅街道', '4', '8901');
INSERT INTO `tp_region` VALUES ('8908', '东湖街道', '4', '8901');
INSERT INTO `tp_region` VALUES ('8909', '扎龙乡', '4', '8901');
INSERT INTO `tp_region` VALUES ('8910', '齐齐哈尔种畜场', '4', '8901');
INSERT INTO `tp_region` VALUES ('8911', '昂昂溪区', '3', '8884');
INSERT INTO `tp_region` VALUES ('8912', '新兴街道', '4', '8911');
INSERT INTO `tp_region` VALUES ('8913', '新建街道', '4', '8911');
INSERT INTO `tp_region` VALUES ('8914', '林机街道', '4', '8911');
INSERT INTO `tp_region` VALUES ('8915', '道北街道', '4', '8911');
INSERT INTO `tp_region` VALUES ('8916', '水师营满族镇', '4', '8911');
INSERT INTO `tp_region` VALUES ('8917', '三间房镇', '4', '8911');
INSERT INTO `tp_region` VALUES ('8918', '富拉尔基区', '3', '8884');
INSERT INTO `tp_region` VALUES ('8919', '红岸街道', '4', '8918');
INSERT INTO `tp_region` VALUES ('8920', '沿江街道', '4', '8918');
INSERT INTO `tp_region` VALUES ('8921', '电力街道', '4', '8918');
INSERT INTO `tp_region` VALUES ('8922', '幸福街道', '4', '8918');
INSERT INTO `tp_region` VALUES ('8923', '红宝石街道', '4', '8918');
INSERT INTO `tp_region` VALUES ('8924', '北兴街道', '4', '8918');
INSERT INTO `tp_region` VALUES ('8925', '铁北街道', '4', '8918');
INSERT INTO `tp_region` VALUES ('8926', '长青乡', '4', '8918');
INSERT INTO `tp_region` VALUES ('8927', '杜尔门沁达翰尔族乡', '4', '8918');
INSERT INTO `tp_region` VALUES ('8928', '碾子山区', '3', '8884');
INSERT INTO `tp_region` VALUES ('8929', '东安街道', '4', '8928');
INSERT INTO `tp_region` VALUES ('8930', '富强街道', '4', '8928');
INSERT INTO `tp_region` VALUES ('8931', '跃进街道', '4', '8928');
INSERT INTO `tp_region` VALUES ('8932', '繁荣街道', '4', '8928');
INSERT INTO `tp_region` VALUES ('8933', '碾子山区直辖地域', '4', '8928');
INSERT INTO `tp_region` VALUES ('8934', '梅里斯达斡尔族区', '3', '8884');
INSERT INTO `tp_region` VALUES ('8935', '梅里斯街道', '4', '8934');
INSERT INTO `tp_region` VALUES ('8936', '雅尔塞镇', '4', '8934');
INSERT INTO `tp_region` VALUES ('8937', '卧牛吐镇', '4', '8934');
INSERT INTO `tp_region` VALUES ('8938', '达呼店镇', '4', '8934');
INSERT INTO `tp_region` VALUES ('8939', '共和镇', '4', '8934');
INSERT INTO `tp_region` VALUES ('8940', '莽格吐乡', '4', '8934');
INSERT INTO `tp_region` VALUES ('8941', '梅里斯乡', '4', '8934');
INSERT INTO `tp_region` VALUES ('8942', '哈拉海农场', '4', '8934');
INSERT INTO `tp_region` VALUES ('8943', '龙江县', '3', '8884');
INSERT INTO `tp_region` VALUES ('8944', '龙江镇', '4', '8943');
INSERT INTO `tp_region` VALUES ('8945', '景星镇', '4', '8943');
INSERT INTO `tp_region` VALUES ('8946', '龙兴镇', '4', '8943');
INSERT INTO `tp_region` VALUES ('8947', '山泉镇', '4', '8943');
INSERT INTO `tp_region` VALUES ('8948', '七棵树镇', '4', '8943');
INSERT INTO `tp_region` VALUES ('8949', '白山乡', '4', '8943');
INSERT INTO `tp_region` VALUES ('8950', '黑岗乡', '4', '8943');
INSERT INTO `tp_region` VALUES ('8951', '广厚乡', '4', '8943');
INSERT INTO `tp_region` VALUES ('8952', '华民乡', '4', '8943');
INSERT INTO `tp_region` VALUES ('8953', '哈拉海乡', '4', '8943');
INSERT INTO `tp_region` VALUES ('8954', '杏山乡', '4', '8943');
INSERT INTO `tp_region` VALUES ('8955', '头站乡', '4', '8943');
INSERT INTO `tp_region` VALUES ('8956', '鲁河乡', '4', '8943');
INSERT INTO `tp_region` VALUES ('8957', '济沁河乡', '4', '8943');
INSERT INTO `tp_region` VALUES ('8958', '依安县', '3', '8884');
INSERT INTO `tp_region` VALUES ('8959', '依安镇', '4', '8958');
INSERT INTO `tp_region` VALUES ('8960', '依龙镇', '4', '8958');
INSERT INTO `tp_region` VALUES ('8961', '双阳镇', '4', '8958');
INSERT INTO `tp_region` VALUES ('8962', '三兴镇', '4', '8958');
INSERT INTO `tp_region` VALUES ('8963', '中心镇', '4', '8958');
INSERT INTO `tp_region` VALUES ('8964', '富饶乡', '4', '8958');
INSERT INTO `tp_region` VALUES ('8965', '解放乡', '4', '8958');
INSERT INTO `tp_region` VALUES ('8966', '阳春乡', '4', '8958');
INSERT INTO `tp_region` VALUES ('8967', '新发乡', '4', '8958');
INSERT INTO `tp_region` VALUES ('8968', '太东乡', '4', '8958');
INSERT INTO `tp_region` VALUES ('8969', '上游乡', '4', '8958');
INSERT INTO `tp_region` VALUES ('8970', '红星乡', '4', '8958');
INSERT INTO `tp_region` VALUES ('8971', '先锋乡', '4', '8958');
INSERT INTO `tp_region` VALUES ('8972', '新屯乡', '4', '8958');
INSERT INTO `tp_region` VALUES ('8973', '新兴乡', '4', '8958');
INSERT INTO `tp_region` VALUES ('8974', '依安农场', '4', '8958');
INSERT INTO `tp_region` VALUES ('8975', '黑龙江红旗马场', '4', '8958');
INSERT INTO `tp_region` VALUES ('8976', '泰来县', '3', '8884');
INSERT INTO `tp_region` VALUES ('8977', '泰来镇', '4', '8976');
INSERT INTO `tp_region` VALUES ('8978', '平洋镇', '4', '8976');
INSERT INTO `tp_region` VALUES ('8979', '汤池镇', '4', '8976');
INSERT INTO `tp_region` VALUES ('8980', '江桥蒙古族镇', '4', '8976');
INSERT INTO `tp_region` VALUES ('8981', '塔子城镇', '4', '8976');
INSERT INTO `tp_region` VALUES ('8982', '大兴镇', '4', '8976');
INSERT INTO `tp_region` VALUES ('8983', '和平镇', '4', '8976');
INSERT INTO `tp_region` VALUES ('8984', '克利镇', '4', '8976');
INSERT INTO `tp_region` VALUES ('8985', '胜利蒙古族乡', '4', '8976');
INSERT INTO `tp_region` VALUES ('8986', '宁姜蒙古族乡', '4', '8976');
INSERT INTO `tp_region` VALUES ('8987', '葡萄场', '4', '8976');
INSERT INTO `tp_region` VALUES ('8988', '果树场', '4', '8976');
INSERT INTO `tp_region` VALUES ('8989', '泰来县一苗圃', '4', '8976');
INSERT INTO `tp_region` VALUES ('8990', '泰来县二苗圃', '4', '8976');
INSERT INTO `tp_region` VALUES ('8991', '东方红机械林场', '4', '8976');
INSERT INTO `tp_region` VALUES ('8992', '泰来农场', '4', '8976');
INSERT INTO `tp_region` VALUES ('8993', '第一良种场', '4', '8976');
INSERT INTO `tp_region` VALUES ('8994', '第二良种场', '4', '8976');
INSERT INTO `tp_region` VALUES ('8995', '宏胜种畜场', '4', '8976');
INSERT INTO `tp_region` VALUES ('8996', '二龙涛农场', '4', '8976');
INSERT INTO `tp_region` VALUES ('8997', '六三监狱', '4', '8976');
INSERT INTO `tp_region` VALUES ('8998', '甘南县', '3', '8884');
INSERT INTO `tp_region` VALUES ('8999', '甘南镇', '4', '8998');
INSERT INTO `tp_region` VALUES ('9000', '音河镇', '4', '8998');
INSERT INTO `tp_region` VALUES ('9001', '平阳镇', '4', '8998');
INSERT INTO `tp_region` VALUES ('9002', '东阳镇', '4', '8998');
INSERT INTO `tp_region` VALUES ('9003', '巨宝镇', '4', '8998');
INSERT INTO `tp_region` VALUES ('9004', '长山乡', '4', '8998');
INSERT INTO `tp_region` VALUES ('9005', '中兴乡', '4', '8998');
INSERT INTO `tp_region` VALUES ('9006', '兴隆乡', '4', '8998');
INSERT INTO `tp_region` VALUES ('9007', '宝山乡', '4', '8998');
INSERT INTO `tp_region` VALUES ('9008', '查哈阳乡', '4', '8998');
INSERT INTO `tp_region` VALUES ('9009', '查哈阳农场', '4', '8998');
INSERT INTO `tp_region` VALUES ('9010', '北京市双河农场', '4', '8998');
INSERT INTO `tp_region` VALUES ('9011', '富裕县', '3', '8884');
INSERT INTO `tp_region` VALUES ('9012', '富裕镇', '4', '9011');
INSERT INTO `tp_region` VALUES ('9013', '富路镇', '4', '9011');
INSERT INTO `tp_region` VALUES ('9014', '富海镇', '4', '9011');
INSERT INTO `tp_region` VALUES ('9015', '二道湾镇', '4', '9011');
INSERT INTO `tp_region` VALUES ('9016', '龙安桥镇', '4', '9011');
INSERT INTO `tp_region` VALUES ('9017', '繁荣乡', '4', '9011');
INSERT INTO `tp_region` VALUES ('9018', '绍文乡', '4', '9011');
INSERT INTO `tp_region` VALUES ('9019', '忠厚乡', '4', '9011');
INSERT INTO `tp_region` VALUES ('9020', '友谊乡', '4', '9011');
INSERT INTO `tp_region` VALUES ('9021', '塔哈乡', '4', '9011');
INSERT INTO `tp_region` VALUES ('9022', '富裕牧场', '4', '9011');
INSERT INTO `tp_region` VALUES ('9023', '繁荣种畜场', '4', '9011');
INSERT INTO `tp_region` VALUES ('9024', '克山县', '3', '8884');
INSERT INTO `tp_region` VALUES ('9025', '克山镇', '4', '9024');
INSERT INTO `tp_region` VALUES ('9026', '北兴镇', '4', '9024');
INSERT INTO `tp_region` VALUES ('9027', '西城镇', '4', '9024');
INSERT INTO `tp_region` VALUES ('9028', '古城镇', '4', '9024');
INSERT INTO `tp_region` VALUES ('9029', '北联镇', '4', '9024');
INSERT INTO `tp_region` VALUES ('9030', '西河镇', '4', '9024');
INSERT INTO `tp_region` VALUES ('9031', '河南乡', '4', '9024');
INSERT INTO `tp_region` VALUES ('9032', '双河乡', '4', '9024');
INSERT INTO `tp_region` VALUES ('9033', '河北乡', '4', '9024');
INSERT INTO `tp_region` VALUES ('9034', '古北乡', '4', '9024');
INSERT INTO `tp_region` VALUES ('9035', '西联乡', '4', '9024');
INSERT INTO `tp_region` VALUES ('9036', '发展乡', '4', '9024');
INSERT INTO `tp_region` VALUES ('9037', '西建乡', '4', '9024');
INSERT INTO `tp_region` VALUES ('9038', '向华乡', '4', '9024');
INSERT INTO `tp_region` VALUES ('9039', '曙光乡', '4', '9024');
INSERT INTO `tp_region` VALUES ('9040', '克山县河北林场', '4', '9024');
INSERT INTO `tp_region` VALUES ('9041', '克山县涌泉林场', '4', '9024');
INSERT INTO `tp_region` VALUES ('9042', '克山县北联林场', '4', '9024');
INSERT INTO `tp_region` VALUES ('9043', '克山农场', '4', '9024');
INSERT INTO `tp_region` VALUES ('9044', '克山县第一良种场', '4', '9024');
INSERT INTO `tp_region` VALUES ('9045', '克山县第二良种场', '4', '9024');
INSERT INTO `tp_region` VALUES ('9046', '克山县种畜场', '4', '9024');
INSERT INTO `tp_region` VALUES ('9047', '克山县种猪场', '4', '9024');
INSERT INTO `tp_region` VALUES ('9048', '克东县', '3', '8884');
INSERT INTO `tp_region` VALUES ('9049', '克东镇', '4', '9048');
INSERT INTO `tp_region` VALUES ('9050', '宝泉镇', '4', '9048');
INSERT INTO `tp_region` VALUES ('9051', '乾丰镇', '4', '9048');
INSERT INTO `tp_region` VALUES ('9052', '玉岗镇', '4', '9048');
INSERT INTO `tp_region` VALUES ('9053', '金城乡', '4', '9048');
INSERT INTO `tp_region` VALUES ('9054', '润津乡', '4', '9048');
INSERT INTO `tp_region` VALUES ('9055', '昌盛乡', '4', '9048');
INSERT INTO `tp_region` VALUES ('9056', '第一苗圃', '4', '9048');
INSERT INTO `tp_region` VALUES ('9057', '第二苗圃', '4', '9048');
INSERT INTO `tp_region` VALUES ('9058', '爱华林场', '4', '9048');
INSERT INTO `tp_region` VALUES ('9059', '发展林场', '4', '9048');
INSERT INTO `tp_region` VALUES ('9060', '东兴林场', '4', '9048');
INSERT INTO `tp_region` VALUES ('9061', '红旗奶山羊场', '4', '9048');
INSERT INTO `tp_region` VALUES ('9062', '第一良种场', '4', '9048');
INSERT INTO `tp_region` VALUES ('9063', '第二良种繁殖场', '4', '9048');
INSERT INTO `tp_region` VALUES ('9064', '果树繁殖场', '4', '9048');
INSERT INTO `tp_region` VALUES ('9065', '种猪场', '4', '9048');
INSERT INTO `tp_region` VALUES ('9066', '建业农场', '4', '9048');
INSERT INTO `tp_region` VALUES ('9067', '拜泉县', '3', '8884');
INSERT INTO `tp_region` VALUES ('9068', '拜泉镇', '4', '9067');
INSERT INTO `tp_region` VALUES ('9069', '三道镇', '4', '9067');
INSERT INTO `tp_region` VALUES ('9070', '兴农镇', '4', '9067');
INSERT INTO `tp_region` VALUES ('9071', '长春镇', '4', '9067');
INSERT INTO `tp_region` VALUES ('9072', '龙泉镇', '4', '9067');
INSERT INTO `tp_region` VALUES ('9073', '国富镇', '4', '9067');
INSERT INTO `tp_region` VALUES ('9074', '富强镇', '4', '9067');
INSERT INTO `tp_region` VALUES ('9075', '新生乡', '4', '9067');
INSERT INTO `tp_region` VALUES ('9076', '兴国乡', '4', '9067');
INSERT INTO `tp_region` VALUES ('9077', '上升乡', '4', '9067');
INSERT INTO `tp_region` VALUES ('9078', '兴华乡', '4', '9067');
INSERT INTO `tp_region` VALUES ('9079', '大众乡', '4', '9067');
INSERT INTO `tp_region` VALUES ('9080', '丰产乡', '4', '9067');
INSERT INTO `tp_region` VALUES ('9081', '永勤乡', '4', '9067');
INSERT INTO `tp_region` VALUES ('9082', '爱农乡', '4', '9067');
INSERT INTO `tp_region` VALUES ('9083', '时中乡', '4', '9067');
INSERT INTO `tp_region` VALUES ('9084', '讷河市', '3', '8884');
INSERT INTO `tp_region` VALUES ('9085', '讷河镇', '4', '9084');
INSERT INTO `tp_region` VALUES ('9086', '拉哈镇', '4', '9084');
INSERT INTO `tp_region` VALUES ('9087', '二克浅镇', '4', '9084');
INSERT INTO `tp_region` VALUES ('9088', '学田镇', '4', '9084');
INSERT INTO `tp_region` VALUES ('9089', '龙河镇', '4', '9084');
INSERT INTO `tp_region` VALUES ('9090', '讷南镇', '4', '9084');
INSERT INTO `tp_region` VALUES ('9091', '六合镇', '4', '9084');
INSERT INTO `tp_region` VALUES ('9092', '长发镇', '4', '9084');
INSERT INTO `tp_region` VALUES ('9093', '通南镇', '4', '9084');
INSERT INTO `tp_region` VALUES ('9094', '同义镇', '4', '9084');
INSERT INTO `tp_region` VALUES ('9095', '九井镇', '4', '9084');
INSERT INTO `tp_region` VALUES ('9096', '老莱镇', '4', '9084');
INSERT INTO `tp_region` VALUES ('9097', '孔国乡', '4', '9084');
INSERT INTO `tp_region` VALUES ('9098', '和盛乡', '4', '9084');
INSERT INTO `tp_region` VALUES ('9099', '同心乡', '4', '9084');
INSERT INTO `tp_region` VALUES ('9100', '兴旺鄂温克族乡', '4', '9084');
INSERT INTO `tp_region` VALUES ('9101', '龙河镇保安林场', '4', '9084');
INSERT INTO `tp_region` VALUES ('9102', '龙河镇茂山林场', '4', '9084');
INSERT INTO `tp_region` VALUES ('9103', '龙河镇国庆林场', '4', '9084');
INSERT INTO `tp_region` VALUES ('9104', '学田镇富源林场', '4', '9084');
INSERT INTO `tp_region` VALUES ('9105', '老莱镇宽余林场', '4', '9084');
INSERT INTO `tp_region` VALUES ('9106', '新江林场', '4', '9084');
INSERT INTO `tp_region` VALUES ('9107', '讷河镇一良苗圃', '4', '9084');
INSERT INTO `tp_region` VALUES ('9108', '黑龙江省老莱监狱', '4', '9084');
INSERT INTO `tp_region` VALUES ('9109', '六合镇黎明奶牛场', '4', '9084');
INSERT INTO `tp_region` VALUES ('9110', '孔国乡进化种猪场', '4', '9084');
INSERT INTO `tp_region` VALUES ('9111', '二克浅镇二里种畜场', '4', '9084');
INSERT INTO `tp_region` VALUES ('9112', '龙河镇青色草原种畜场', '4', '9084');
INSERT INTO `tp_region` VALUES ('9113', '第一良种场', '4', '9084');
INSERT INTO `tp_region` VALUES ('9114', '第二良种场', '4', '9084');
INSERT INTO `tp_region` VALUES ('9115', '第三良种场', '4', '9084');
INSERT INTO `tp_region` VALUES ('9116', '第四良种场', '4', '9084');
INSERT INTO `tp_region` VALUES ('9117', '鸡西市', '2', '8558');
INSERT INTO `tp_region` VALUES ('9118', '市辖区', '3', '9117');
INSERT INTO `tp_region` VALUES ('9119', '鸡冠区', '3', '9117');
INSERT INTO `tp_region` VALUES ('9120', '向阳街道', '4', '9119');
INSERT INTO `tp_region` VALUES ('9121', '南山街道', '4', '9119');
INSERT INTO `tp_region` VALUES ('9122', '立新街道', '4', '9119');
INSERT INTO `tp_region` VALUES ('9123', '东风街道', '4', '9119');
INSERT INTO `tp_region` VALUES ('9124', '红军路街道', '4', '9119');
INSERT INTO `tp_region` VALUES ('9125', '西鸡西街道', '4', '9119');
INSERT INTO `tp_region` VALUES ('9126', '西山街道', '4', '9119');
INSERT INTO `tp_region` VALUES ('9127', '红星乡', '4', '9119');
INSERT INTO `tp_region` VALUES ('9128', '西郊乡', '4', '9119');
INSERT INTO `tp_region` VALUES ('9129', '恒山区', '3', '9117');
INSERT INTO `tp_region` VALUES ('9130', '桦木林街道', '4', '9129');
INSERT INTO `tp_region` VALUES ('9131', '大恒山街道', '4', '9129');
INSERT INTO `tp_region` VALUES ('9132', '小恒山街道', '4', '9129');
INSERT INTO `tp_region` VALUES ('9133', '二道河子街道', '4', '9129');
INSERT INTO `tp_region` VALUES ('9134', '张新街道', '4', '9129');
INSERT INTO `tp_region` VALUES ('9135', '奋斗街道', '4', '9129');
INSERT INTO `tp_region` VALUES ('9136', '柳毛街道', '4', '9129');
INSERT INTO `tp_region` VALUES ('9137', '红旗乡', '4', '9129');
INSERT INTO `tp_region` VALUES ('9138', '柳毛乡', '4', '9129');
INSERT INTO `tp_region` VALUES ('9139', '滴道区', '3', '9117');
INSERT INTO `tp_region` VALUES ('9140', '东兴街道', '4', '9139');
INSERT INTO `tp_region` VALUES ('9141', '矿里街道', '4', '9139');
INSERT INTO `tp_region` VALUES ('9142', '洗煤街道', '4', '9139');
INSERT INTO `tp_region` VALUES ('9143', '大通沟街道', '4', '9139');
INSERT INTO `tp_region` VALUES ('9144', '滴道河乡', '4', '9139');
INSERT INTO `tp_region` VALUES ('9145', '兰岭乡', '4', '9139');
INSERT INTO `tp_region` VALUES ('9146', '梨树区', '3', '9117');
INSERT INTO `tp_region` VALUES ('9147', '街里街道', '4', '9146');
INSERT INTO `tp_region` VALUES ('9148', '穆棱街道', '4', '9146');
INSERT INTO `tp_region` VALUES ('9149', '平岗街道', '4', '9146');
INSERT INTO `tp_region` VALUES ('9150', '碱场街道', '4', '9146');
INSERT INTO `tp_region` VALUES ('9151', '石磷街道', '4', '9146');
INSERT INTO `tp_region` VALUES ('9152', '梨树区直辖地域', '4', '9146');
INSERT INTO `tp_region` VALUES ('9153', '城子河区', '3', '9117');
INSERT INTO `tp_region` VALUES ('9154', '城子河街道', '4', '9153');
INSERT INTO `tp_region` VALUES ('9155', '正阳街道', '4', '9153');
INSERT INTO `tp_region` VALUES ('9156', '东海街道', '4', '9153');
INSERT INTO `tp_region` VALUES ('9157', '城西街道', '4', '9153');
INSERT INTO `tp_region` VALUES ('9158', '杏花街道', '4', '9153');
INSERT INTO `tp_region` VALUES ('9159', '长青乡', '4', '9153');
INSERT INTO `tp_region` VALUES ('9160', '永丰乡', '4', '9153');
INSERT INTO `tp_region` VALUES ('9161', '麻山区', '3', '9117');
INSERT INTO `tp_region` VALUES ('9162', '麻山街道', '4', '9161');
INSERT INTO `tp_region` VALUES ('9163', '麻山区直辖地域', '4', '9161');
INSERT INTO `tp_region` VALUES ('9164', '鸡东县', '3', '9117');
INSERT INTO `tp_region` VALUES ('9165', '鸡东镇', '4', '9164');
INSERT INTO `tp_region` VALUES ('9166', '平阳镇', '4', '9164');
INSERT INTO `tp_region` VALUES ('9167', '向阳镇', '4', '9164');
INSERT INTO `tp_region` VALUES ('9168', '哈达镇', '4', '9164');
INSERT INTO `tp_region` VALUES ('9169', '永安镇', '4', '9164');
INSERT INTO `tp_region` VALUES ('9170', '永和镇', '4', '9164');
INSERT INTO `tp_region` VALUES ('9171', '东海镇', '4', '9164');
INSERT INTO `tp_region` VALUES ('9172', '兴农镇', '4', '9164');
INSERT INTO `tp_region` VALUES ('9173', '鸡林乡', '4', '9164');
INSERT INTO `tp_region` VALUES ('9174', '明德乡', '4', '9164');
INSERT INTO `tp_region` VALUES ('9175', '下亮子乡', '4', '9164');
INSERT INTO `tp_region` VALUES ('9176', '林业局', '4', '9164');
INSERT INTO `tp_region` VALUES ('9177', '八五一零农场', '4', '9164');
INSERT INTO `tp_region` VALUES ('9178', '虎林市', '3', '9117');
INSERT INTO `tp_region` VALUES ('9179', '虎林镇', '4', '9178');
INSERT INTO `tp_region` VALUES ('9180', '东方红镇', '4', '9178');
INSERT INTO `tp_region` VALUES ('9181', '迎春镇', '4', '9178');
INSERT INTO `tp_region` VALUES ('9182', '虎头镇', '4', '9178');
INSERT INTO `tp_region` VALUES ('9183', '杨岗镇', '4', '9178');
INSERT INTO `tp_region` VALUES ('9184', '东风镇', '4', '9178');
INSERT INTO `tp_region` VALUES ('9185', '宝东镇', '4', '9178');
INSERT INTO `tp_region` VALUES ('9186', '新乐乡', '4', '9178');
INSERT INTO `tp_region` VALUES ('9187', '伟光乡', '4', '9178');
INSERT INTO `tp_region` VALUES ('9188', '忠诚乡', '4', '9178');
INSERT INTO `tp_region` VALUES ('9189', '珍宝岛乡', '4', '9178');
INSERT INTO `tp_region` VALUES ('9190', '阿北乡', '4', '9178');
INSERT INTO `tp_region` VALUES ('9191', '东方红林业局', '4', '9178');
INSERT INTO `tp_region` VALUES ('9192', '迎春林业局', '4', '9178');
INSERT INTO `tp_region` VALUES ('9193', '八五零农场', '4', '9178');
INSERT INTO `tp_region` VALUES ('9194', '八五四农场', '4', '9178');
INSERT INTO `tp_region` VALUES ('9195', '八五六农场', '4', '9178');
INSERT INTO `tp_region` VALUES ('9196', '八五八农场', '4', '9178');
INSERT INTO `tp_region` VALUES ('9197', '庆丰农场', '4', '9178');
INSERT INTO `tp_region` VALUES ('9198', '云山农场', '4', '9178');
INSERT INTO `tp_region` VALUES ('9199', '密山市', '3', '9117');
INSERT INTO `tp_region` VALUES ('9200', '中心街道', '4', '9199');
INSERT INTO `tp_region` VALUES ('9201', '密山镇', '4', '9199');
INSERT INTO `tp_region` VALUES ('9202', '连珠山镇', '4', '9199');
INSERT INTO `tp_region` VALUES ('9203', '当壁镇', '4', '9199');
INSERT INTO `tp_region` VALUES ('9204', '知一镇', '4', '9199');
INSERT INTO `tp_region` VALUES ('9205', '黑台镇', '4', '9199');
INSERT INTO `tp_region` VALUES ('9206', '兴凯镇', '4', '9199');
INSERT INTO `tp_region` VALUES ('9207', '裴德镇', '4', '9199');
INSERT INTO `tp_region` VALUES ('9208', '柳毛乡', '4', '9199');
INSERT INTO `tp_region` VALUES ('9209', '杨木乡', '4', '9199');
INSERT INTO `tp_region` VALUES ('9210', '兴凯湖乡', '4', '9199');
INSERT INTO `tp_region` VALUES ('9211', '承紫河乡', '4', '9199');
INSERT INTO `tp_region` VALUES ('9212', '白泡子乡', '4', '9199');
INSERT INTO `tp_region` VALUES ('9213', '二人班乡', '4', '9199');
INSERT INTO `tp_region` VALUES ('9214', '太平乡', '4', '9199');
INSERT INTO `tp_region` VALUES ('9215', '和平乡', '4', '9199');
INSERT INTO `tp_region` VALUES ('9216', '富源乡', '4', '9199');
INSERT INTO `tp_region` VALUES ('9217', '牡丹江分局局直', '4', '9199');
INSERT INTO `tp_region` VALUES ('9218', '八五五农场', '4', '9199');
INSERT INTO `tp_region` VALUES ('9219', '八五七农场', '4', '9199');
INSERT INTO `tp_region` VALUES ('9220', '八五一一农场', '4', '9199');
INSERT INTO `tp_region` VALUES ('9221', '兴凯湖农场', '4', '9199');
INSERT INTO `tp_region` VALUES ('9222', '鹤岗市', '2', '8558');
INSERT INTO `tp_region` VALUES ('9223', '市辖区', '3', '9222');
INSERT INTO `tp_region` VALUES ('9224', '向阳区', '3', '9222');
INSERT INTO `tp_region` VALUES ('9225', '北山街道', '4', '9224');
INSERT INTO `tp_region` VALUES ('9226', '红军街道', '4', '9224');
INSERT INTO `tp_region` VALUES ('9227', '光明街道', '4', '9224');
INSERT INTO `tp_region` VALUES ('9228', '胜利街道', '4', '9224');
INSERT INTO `tp_region` VALUES ('9229', '南翼街道', '4', '9224');
INSERT INTO `tp_region` VALUES ('9230', '工农区', '3', '9222');
INSERT INTO `tp_region` VALUES ('9231', '育才街道', '4', '9230');
INSERT INTO `tp_region` VALUES ('9232', '红旗街道', '4', '9230');
INSERT INTO `tp_region` VALUES ('9233', '新南街道', '4', '9230');
INSERT INTO `tp_region` VALUES ('9234', '湖滨街道', '4', '9230');
INSERT INTO `tp_region` VALUES ('9235', '解放街道', '4', '9230');
INSERT INTO `tp_region` VALUES ('9236', '团结街道', '4', '9230');
INSERT INTO `tp_region` VALUES ('9237', '南山区', '3', '9222');
INSERT INTO `tp_region` VALUES ('9238', '铁西街道', '4', '9237');
INSERT INTO `tp_region` VALUES ('9239', '铁东街道', '4', '9237');
INSERT INTO `tp_region` VALUES ('9240', '六号街道', '4', '9237');
INSERT INTO `tp_region` VALUES ('9241', '大陆街道', '4', '9237');
INSERT INTO `tp_region` VALUES ('9242', '富力街道', '4', '9237');
INSERT INTO `tp_region` VALUES ('9243', '麓林山街道', '4', '9237');
INSERT INTO `tp_region` VALUES ('9244', '兴安区', '3', '9222');
INSERT INTO `tp_region` VALUES ('9245', '兴安路街道', '4', '9244');
INSERT INTO `tp_region` VALUES ('9246', '兴建路街道', '4', '9244');
INSERT INTO `tp_region` VALUES ('9247', '兴长路街道', '4', '9244');
INSERT INTO `tp_region` VALUES ('9248', '峻德路街道', '4', '9244');
INSERT INTO `tp_region` VALUES ('9249', '河东路街道', '4', '9244');
INSERT INTO `tp_region` VALUES ('9250', '东山区', '3', '9222');
INSERT INTO `tp_region` VALUES ('9251', '工人村街道', '4', '9250');
INSERT INTO `tp_region` VALUES ('9252', '新一街道', '4', '9250');
INSERT INTO `tp_region` VALUES ('9253', '三街街道', '4', '9250');
INSERT INTO `tp_region` VALUES ('9254', '东山街道', '4', '9250');
INSERT INTO `tp_region` VALUES ('9255', '新华镇', '4', '9250');
INSERT INTO `tp_region` VALUES ('9256', '红旗乡', '4', '9250');
INSERT INTO `tp_region` VALUES ('9257', '蔬园乡', '4', '9250');
INSERT INTO `tp_region` VALUES ('9258', '东方红乡', '4', '9250');
INSERT INTO `tp_region` VALUES ('9259', '鹤岗市林业局', '4', '9250');
INSERT INTO `tp_region` VALUES ('9260', '新华农场', '4', '9250');
INSERT INTO `tp_region` VALUES ('9261', '兴山区', '3', '9222');
INSERT INTO `tp_region` VALUES ('9262', '岭北街道', '4', '9261');
INSERT INTO `tp_region` VALUES ('9263', '岭南街道', '4', '9261');
INSERT INTO `tp_region` VALUES ('9264', '沟北街道', '4', '9261');
INSERT INTO `tp_region` VALUES ('9265', '沟南街道', '4', '9261');
INSERT INTO `tp_region` VALUES ('9266', '萝北县', '3', '9222');
INSERT INTO `tp_region` VALUES ('9267', '凤翔镇', '4', '9266');
INSERT INTO `tp_region` VALUES ('9268', '鹤北镇', '4', '9266');
INSERT INTO `tp_region` VALUES ('9269', '名山镇', '4', '9266');
INSERT INTO `tp_region` VALUES ('9270', '团结镇', '4', '9266');
INSERT INTO `tp_region` VALUES ('9271', '肇兴镇', '4', '9266');
INSERT INTO `tp_region` VALUES ('9272', '东明朝鲜族乡', '4', '9266');
INSERT INTO `tp_region` VALUES ('9273', '太平沟乡', '4', '9266');
INSERT INTO `tp_region` VALUES ('9274', '环山乡', '4', '9266');
INSERT INTO `tp_region` VALUES ('9275', '鹤北林业局', '4', '9266');
INSERT INTO `tp_region` VALUES ('9276', '宝泉岭分局局直', '4', '9266');
INSERT INTO `tp_region` VALUES ('9277', '江滨农场', '4', '9266');
INSERT INTO `tp_region` VALUES ('9278', '军川农场', '4', '9266');
INSERT INTO `tp_region` VALUES ('9279', '名山农场', '4', '9266');
INSERT INTO `tp_region` VALUES ('9280', '延军农场', '4', '9266');
INSERT INTO `tp_region` VALUES ('9281', '共青农场', '4', '9266');
INSERT INTO `tp_region` VALUES ('9282', '宝泉岭农场', '4', '9266');
INSERT INTO `tp_region` VALUES ('9283', '绥滨县', '3', '9222');
INSERT INTO `tp_region` VALUES ('9284', '绥滨镇', '4', '9283');
INSERT INTO `tp_region` VALUES ('9285', '绥东镇', '4', '9283');
INSERT INTO `tp_region` VALUES ('9286', '忠仁镇', '4', '9283');
INSERT INTO `tp_region` VALUES ('9287', '连生乡', '4', '9283');
INSERT INTO `tp_region` VALUES ('9288', '北岗乡', '4', '9283');
INSERT INTO `tp_region` VALUES ('9289', '富强乡', '4', '9283');
INSERT INTO `tp_region` VALUES ('9290', '北山乡', '4', '9283');
INSERT INTO `tp_region` VALUES ('9291', '福兴乡', '4', '9283');
INSERT INTO `tp_region` VALUES ('9292', '新富乡', '4', '9283');
INSERT INTO `tp_region` VALUES ('9293', '二九０农场', '4', '9283');
INSERT INTO `tp_region` VALUES ('9294', '绥滨农场', '4', '9283');
INSERT INTO `tp_region` VALUES ('9295', '普阳农场', '4', '9283');
INSERT INTO `tp_region` VALUES ('9296', '双鸭山市', '2', '8558');
INSERT INTO `tp_region` VALUES ('9297', '市辖区', '3', '9296');
INSERT INTO `tp_region` VALUES ('9298', '尖山区', '3', '9296');
INSERT INTO `tp_region` VALUES ('9299', '二马路街道', '4', '9298');
INSERT INTO `tp_region` VALUES ('9300', '八马路街道', '4', '9298');
INSERT INTO `tp_region` VALUES ('9301', '中心站街道', '4', '9298');
INSERT INTO `tp_region` VALUES ('9302', '富安街道', '4', '9298');
INSERT INTO `tp_region` VALUES ('9303', '窑地街道', '4', '9298');
INSERT INTO `tp_region` VALUES ('9304', '长安街道', '4', '9298');
INSERT INTO `tp_region` VALUES ('9305', '铁西街道', '4', '9298');
INSERT INTO `tp_region` VALUES ('9306', '安邦乡', '4', '9298');
INSERT INTO `tp_region` VALUES ('9307', '岭东区', '3', '9296');
INSERT INTO `tp_region` VALUES ('9308', '中山街道', '4', '9307');
INSERT INTO `tp_region` VALUES ('9309', '北山街道', '4', '9307');
INSERT INTO `tp_region` VALUES ('9310', '南山街道', '4', '9307');
INSERT INTO `tp_region` VALUES ('9311', '东山街道', '4', '9307');
INSERT INTO `tp_region` VALUES ('9312', '中心街道', '4', '9307');
INSERT INTO `tp_region` VALUES ('9313', '西山街道', '4', '9307');
INSERT INTO `tp_region` VALUES ('9314', '长胜乡', '4', '9307');
INSERT INTO `tp_region` VALUES ('9315', '岭东区青山旅游公司', '4', '9307');
INSERT INTO `tp_region` VALUES ('9316', '岭东区岭东经营所', '4', '9307');
INSERT INTO `tp_region` VALUES ('9317', '四方台区', '3', '9296');
INSERT INTO `tp_region` VALUES ('9318', '振兴中路街道', '4', '9317');
INSERT INTO `tp_region` VALUES ('9319', '振兴东路街道', '4', '9317');
INSERT INTO `tp_region` VALUES ('9320', '集贤街道', '4', '9317');
INSERT INTO `tp_region` VALUES ('9321', '东荣街道', '4', '9317');
INSERT INTO `tp_region` VALUES ('9322', '太保镇', '4', '9317');
INSERT INTO `tp_region` VALUES ('9323', '宝山区', '3', '9296');
INSERT INTO `tp_region` VALUES ('9324', '红旗街道', '4', '9323');
INSERT INTO `tp_region` VALUES ('9325', '跃进街道', '4', '9323');
INSERT INTO `tp_region` VALUES ('9326', '东保卫街道', '4', '9323');
INSERT INTO `tp_region` VALUES ('9327', '七星街道', '4', '9323');
INSERT INTO `tp_region` VALUES ('9328', '双阳街道', '4', '9323');
INSERT INTO `tp_region` VALUES ('9329', '新安街道', '4', '9323');
INSERT INTO `tp_region` VALUES ('9330', '电厂街道', '4', '9323');
INSERT INTO `tp_region` VALUES ('9331', '七星镇', '4', '9323');
INSERT INTO `tp_region` VALUES ('9332', '双鸭山林业局宝山经营所', '4', '9323');
INSERT INTO `tp_region` VALUES ('9333', '双鸭山林业局大叶沟林场', '4', '9323');
INSERT INTO `tp_region` VALUES ('9334', '双鸭山农场', '4', '9323');
INSERT INTO `tp_region` VALUES ('9335', '集贤县', '3', '9296');
INSERT INTO `tp_region` VALUES ('9336', '福利镇', '4', '9335');
INSERT INTO `tp_region` VALUES ('9337', '集贤镇', '4', '9335');
INSERT INTO `tp_region` VALUES ('9338', '升昌镇', '4', '9335');
INSERT INTO `tp_region` VALUES ('9339', '丰乐镇', '4', '9335');
INSERT INTO `tp_region` VALUES ('9340', '太平镇', '4', '9335');
INSERT INTO `tp_region` VALUES ('9341', '腰屯乡', '4', '9335');
INSERT INTO `tp_region` VALUES ('9342', '兴安乡', '4', '9335');
INSERT INTO `tp_region` VALUES ('9343', '永安乡', '4', '9335');
INSERT INTO `tp_region` VALUES ('9344', '太平林场', '4', '9335');
INSERT INTO `tp_region` VALUES ('9345', '丰乐林场', '4', '9335');
INSERT INTO `tp_region` VALUES ('9346', '七星林场', '4', '9335');
INSERT INTO `tp_region` VALUES ('9347', '峻山林场', '4', '9335');
INSERT INTO `tp_region` VALUES ('9348', '爱林林场', '4', '9335');
INSERT INTO `tp_region` VALUES ('9349', '腰屯林场', '4', '9335');
INSERT INTO `tp_region` VALUES ('9350', '升平煤矿', '4', '9335');
INSERT INTO `tp_region` VALUES ('9351', '二九一农场', '4', '9335');
INSERT INTO `tp_region` VALUES ('9352', '良种场', '4', '9335');
INSERT INTO `tp_region` VALUES ('9353', '种畜场', '4', '9335');
INSERT INTO `tp_region` VALUES ('9354', '果树示范场', '4', '9335');
INSERT INTO `tp_region` VALUES ('9355', '黑龙江省笔架山监狱', '4', '9335');
INSERT INTO `tp_region` VALUES ('9356', '友谊县', '3', '9296');
INSERT INTO `tp_region` VALUES ('9357', '友谊镇', '4', '9356');
INSERT INTO `tp_region` VALUES ('9358', '兴隆镇', '4', '9356');
INSERT INTO `tp_region` VALUES ('9359', '龙山镇', '4', '9356');
INSERT INTO `tp_region` VALUES ('9360', '凤岗镇', '4', '9356');
INSERT INTO `tp_region` VALUES ('9361', '兴盛乡', '4', '9356');
INSERT INTO `tp_region` VALUES ('9362', '东建乡', '4', '9356');
INSERT INTO `tp_region` VALUES ('9363', '庆丰乡', '4', '9356');
INSERT INTO `tp_region` VALUES ('9364', '建设乡', '4', '9356');
INSERT INTO `tp_region` VALUES ('9365', '友邻乡', '4', '9356');
INSERT INTO `tp_region` VALUES ('9366', '新镇乡', '4', '9356');
INSERT INTO `tp_region` VALUES ('9367', '成富朝鲜族满族乡', '4', '9356');
INSERT INTO `tp_region` VALUES ('9368', '红兴隆分局局直', '4', '9356');
INSERT INTO `tp_region` VALUES ('9369', '友谊农场', '4', '9356');
INSERT INTO `tp_region` VALUES ('9370', '宝清县', '3', '9296');
INSERT INTO `tp_region` VALUES ('9371', '宝清镇', '4', '9370');
INSERT INTO `tp_region` VALUES ('9372', '七星泡镇', '4', '9370');
INSERT INTO `tp_region` VALUES ('9373', '青原镇', '4', '9370');
INSERT INTO `tp_region` VALUES ('9374', '夹信子镇', '4', '9370');
INSERT INTO `tp_region` VALUES ('9375', '龙头镇', '4', '9370');
INSERT INTO `tp_region` VALUES ('9376', '小城子镇', '4', '9370');
INSERT INTO `tp_region` VALUES ('9377', '朝阳乡', '4', '9370');
INSERT INTO `tp_region` VALUES ('9378', '万金山乡', '4', '9370');
INSERT INTO `tp_region` VALUES ('9379', '尖山子乡', '4', '9370');
INSERT INTO `tp_region` VALUES ('9380', '七星河乡', '4', '9370');
INSERT INTO `tp_region` VALUES ('9381', '双鸭山林业局上游经营所', '4', '9370');
INSERT INTO `tp_region` VALUES ('9382', '双鸭山林业局南瓮泉经营所', '4', '9370');
INSERT INTO `tp_region` VALUES ('9383', '双鸭山林业局七一林场', '4', '9370');
INSERT INTO `tp_region` VALUES ('9384', '双鸭山林业局七星河林场', '4', '9370');
INSERT INTO `tp_region` VALUES ('9385', '双鸭山林业局红旗林场', '4', '9370');
INSERT INTO `tp_region` VALUES ('9386', '双鸭山林业局三岔河林场', '4', '9370');
INSERT INTO `tp_region` VALUES ('9387', '双鸭山林业局青龙林场', '4', '9370');
INSERT INTO `tp_region` VALUES ('9388', '双鸭山林业局宝石经营所', '4', '9370');
INSERT INTO `tp_region` VALUES ('9389', '双鸭山林业局七星河金矿', '4', '9370');
INSERT INTO `tp_region` VALUES ('9390', '五九七农场', '4', '9370');
INSERT INTO `tp_region` VALUES ('9391', '八五二农场', '4', '9370');
INSERT INTO `tp_region` VALUES ('9392', '八五三农场', '4', '9370');
INSERT INTO `tp_region` VALUES ('9393', '饶河县', '3', '9296');
INSERT INTO `tp_region` VALUES ('9394', '饶河镇', '4', '9393');
INSERT INTO `tp_region` VALUES ('9395', '小佳河镇', '4', '9393');
INSERT INTO `tp_region` VALUES ('9396', '西丰镇', '4', '9393');
INSERT INTO `tp_region` VALUES ('9397', '五林洞镇', '4', '9393');
INSERT INTO `tp_region` VALUES ('9398', '西林子乡', '4', '9393');
INSERT INTO `tp_region` VALUES ('9399', '四排乡', '4', '9393');
INSERT INTO `tp_region` VALUES ('9400', '大佳河乡', '4', '9393');
INSERT INTO `tp_region` VALUES ('9401', '山里乡', '4', '9393');
INSERT INTO `tp_region` VALUES ('9402', '大通河乡', '4', '9393');
INSERT INTO `tp_region` VALUES ('9403', '小佳河林场', '4', '9393');
INSERT INTO `tp_region` VALUES ('9404', '威山林场', '4', '9393');
INSERT INTO `tp_region` VALUES ('9405', '西丰林场', '4', '9393');
INSERT INTO `tp_region` VALUES ('9406', '大牙克林场', '4', '9393');
INSERT INTO `tp_region` VALUES ('9407', '石场林场', '4', '9393');
INSERT INTO `tp_region` VALUES ('9408', '宝马山林场', '4', '9393');
INSERT INTO `tp_region` VALUES ('9409', '大岱林场', '4', '9393');
INSERT INTO `tp_region` VALUES ('9410', '永幸林场', '4', '9393');
INSERT INTO `tp_region` VALUES ('9411', '奇源林场', '4', '9393');
INSERT INTO `tp_region` VALUES ('9412', '芦源林场', '4', '9393');
INSERT INTO `tp_region` VALUES ('9413', '五林洞林场', '4', '9393');
INSERT INTO `tp_region` VALUES ('9414', '饶河农场', '4', '9393');
INSERT INTO `tp_region` VALUES ('9415', '红旗岭农场', '4', '9393');
INSERT INTO `tp_region` VALUES ('9416', '八五九农场', '4', '9393');
INSERT INTO `tp_region` VALUES ('9417', '胜利农场', '4', '9393');
INSERT INTO `tp_region` VALUES ('9418', '红卫农场', '4', '9393');
INSERT INTO `tp_region` VALUES ('9419', '大庆市', '2', '8558');
INSERT INTO `tp_region` VALUES ('9420', '市辖区', '3', '9419');
INSERT INTO `tp_region` VALUES ('9421', '萨尔图区', '3', '9419');
INSERT INTO `tp_region` VALUES ('9422', '萨尔图街道', '4', '9421');
INSERT INTO `tp_region` VALUES ('9423', '铁人街道', '4', '9421');
INSERT INTO `tp_region` VALUES ('9424', '友谊街道', '4', '9421');
INSERT INTO `tp_region` VALUES ('9425', '富强街道', '4', '9421');
INSERT INTO `tp_region` VALUES ('9426', '拥军街道', '4', '9421');
INSERT INTO `tp_region` VALUES ('9427', '会战街道', '4', '9421');
INSERT INTO `tp_region` VALUES ('9428', '火炬街道', '4', '9421');
INSERT INTO `tp_region` VALUES ('9429', '东风街道', '4', '9421');
INSERT INTO `tp_region` VALUES ('9430', '东安街道', '4', '9421');
INSERT INTO `tp_region` VALUES ('9431', '龙凤区', '3', '9419');
INSERT INTO `tp_region` VALUES ('9432', '龙凤街道', '4', '9431');
INSERT INTO `tp_region` VALUES ('9433', '兴化街道', '4', '9431');
INSERT INTO `tp_region` VALUES ('9434', '卧里屯街道', '4', '9431');
INSERT INTO `tp_region` VALUES ('9435', '东光街道', '4', '9431');
INSERT INTO `tp_region` VALUES ('9436', '三永街道', '4', '9431');
INSERT INTO `tp_region` VALUES ('9437', '开发区黎明街道', '4', '9431');
INSERT INTO `tp_region` VALUES ('9438', '龙凤镇', '4', '9431');
INSERT INTO `tp_region` VALUES ('9439', '高新区农场', '4', '9431');
INSERT INTO `tp_region` VALUES ('9440', '让胡路区', '3', '9419');
INSERT INTO `tp_region` VALUES ('9441', '龙岗街道', '4', '9440');
INSERT INTO `tp_region` VALUES ('9442', '银浪街道', '4', '9440');
INSERT INTO `tp_region` VALUES ('9443', '奋斗街道', '4', '9440');
INSERT INTO `tp_region` VALUES ('9444', '庆新街道', '4', '9440');
INSERT INTO `tp_region` VALUES ('9445', '西宾街道', '4', '9440');
INSERT INTO `tp_region` VALUES ('9446', '乘风街道', '4', '9440');
INSERT INTO `tp_region` VALUES ('9447', '喇嘛甸镇', '4', '9440');
INSERT INTO `tp_region` VALUES ('9448', '红骥牧场', '4', '9440');
INSERT INTO `tp_region` VALUES ('9449', '星火牧场', '4', '9440');
INSERT INTO `tp_region` VALUES ('9450', '银浪牧场', '4', '9440');
INSERT INTO `tp_region` VALUES ('9451', '红岗区', '3', '9419');
INSERT INTO `tp_region` VALUES ('9452', '红岗街道', '4', '9451');
INSERT INTO `tp_region` VALUES ('9453', '八百垧街道', '4', '9451');
INSERT INTO `tp_region` VALUES ('9454', '杏南街道', '4', '9451');
INSERT INTO `tp_region` VALUES ('9455', '解放街道', '4', '9451');
INSERT INTO `tp_region` VALUES ('9456', '创业街道', '4', '9451');
INSERT INTO `tp_region` VALUES ('9457', '杏树岗镇', '4', '9451');
INSERT INTO `tp_region` VALUES ('9458', '大同区', '3', '9419');
INSERT INTO `tp_region` VALUES ('9459', '庆葡街道', '4', '9458');
INSERT INTO `tp_region` VALUES ('9460', '高台子镇街道', '4', '9458');
INSERT INTO `tp_region` VALUES ('9461', '林源镇街道', '4', '9458');
INSERT INTO `tp_region` VALUES ('9462', '立志街道', '4', '9458');
INSERT INTO `tp_region` VALUES ('9463', '新华街道', '4', '9458');
INSERT INTO `tp_region` VALUES ('9464', '大同镇街道', '4', '9458');
INSERT INTO `tp_region` VALUES ('9465', '大同镇', '4', '9458');
INSERT INTO `tp_region` VALUES ('9466', '高台子镇', '4', '9458');
INSERT INTO `tp_region` VALUES ('9467', '太阳升镇', '4', '9458');
INSERT INTO `tp_region` VALUES ('9468', '林源镇', '4', '9458');
INSERT INTO `tp_region` VALUES ('9469', '祝三乡', '4', '9458');
INSERT INTO `tp_region` VALUES ('9470', '老山头乡', '4', '9458');
INSERT INTO `tp_region` VALUES ('9471', '八井子乡', '4', '9458');
INSERT INTO `tp_region` VALUES ('9472', '双榆树乡', '4', '9458');
INSERT INTO `tp_region` VALUES ('9473', '和平牧场', '4', '9458');
INSERT INTO `tp_region` VALUES ('9474', '肇州县', '3', '9419');
INSERT INTO `tp_region` VALUES ('9475', '肇州镇', '4', '9474');
INSERT INTO `tp_region` VALUES ('9476', '永乐镇', '4', '9474');
INSERT INTO `tp_region` VALUES ('9477', '丰乐镇', '4', '9474');
INSERT INTO `tp_region` VALUES ('9478', '朝阳沟镇', '4', '9474');
INSERT INTO `tp_region` VALUES ('9479', '兴城镇', '4', '9474');
INSERT INTO `tp_region` VALUES ('9480', '二井镇', '4', '9474');
INSERT INTO `tp_region` VALUES ('9481', '双发乡', '4', '9474');
INSERT INTO `tp_region` VALUES ('9482', '托古乡', '4', '9474');
INSERT INTO `tp_region` VALUES ('9483', '朝阳乡', '4', '9474');
INSERT INTO `tp_region` VALUES ('9484', '永胜乡', '4', '9474');
INSERT INTO `tp_region` VALUES ('9485', '榆树乡', '4', '9474');
INSERT INTO `tp_region` VALUES ('9486', '新福乡', '4', '9474');
INSERT INTO `tp_region` VALUES ('9487', '乐园良种场', '4', '9474');
INSERT INTO `tp_region` VALUES ('9488', '卫星种畜场', '4', '9474');
INSERT INTO `tp_region` VALUES ('9489', '肇源县', '3', '9419');
INSERT INTO `tp_region` VALUES ('9490', '肇源镇', '4', '9489');
INSERT INTO `tp_region` VALUES ('9491', '三站镇', '4', '9489');
INSERT INTO `tp_region` VALUES ('9492', '二站镇', '4', '9489');
INSERT INTO `tp_region` VALUES ('9493', '茂兴镇', '4', '9489');
INSERT INTO `tp_region` VALUES ('9494', '古龙镇', '4', '9489');
INSERT INTO `tp_region` VALUES ('9495', '新站镇', '4', '9489');
INSERT INTO `tp_region` VALUES ('9496', '头台镇', '4', '9489');
INSERT INTO `tp_region` VALUES ('9497', '福兴乡', '4', '9489');
INSERT INTO `tp_region` VALUES ('9498', '薄荷台乡', '4', '9489');
INSERT INTO `tp_region` VALUES ('9499', '和平乡', '4', '9489');
INSERT INTO `tp_region` VALUES ('9500', '古恰乡', '4', '9489');
INSERT INTO `tp_region` VALUES ('9501', '超等乡', '4', '9489');
INSERT INTO `tp_region` VALUES ('9502', '民意乡', '4', '9489');
INSERT INTO `tp_region` VALUES ('9503', '义顺乡', '4', '9489');
INSERT INTO `tp_region` VALUES ('9504', '浩德乡', '4', '9489');
INSERT INTO `tp_region` VALUES ('9505', '大兴乡', '4', '9489');
INSERT INTO `tp_region` VALUES ('9506', '肇源农场', '4', '9489');
INSERT INTO `tp_region` VALUES ('9507', '种畜场', '4', '9489');
INSERT INTO `tp_region` VALUES ('9508', '茂兴湖渔场', '4', '9489');
INSERT INTO `tp_region` VALUES ('9509', '新立良种繁育场', '4', '9489');
INSERT INTO `tp_region` VALUES ('9510', '立陡山良种场', '4', '9489');
INSERT INTO `tp_region` VALUES ('9511', '八家河渔场', '4', '9489');
INSERT INTO `tp_region` VALUES ('9512', '果树示范场', '4', '9489');
INSERT INTO `tp_region` VALUES ('9513', '经济作物示范场', '4', '9489');
INSERT INTO `tp_region` VALUES ('9514', '林甸县', '3', '9419');
INSERT INTO `tp_region` VALUES ('9515', '林甸镇', '4', '9514');
INSERT INTO `tp_region` VALUES ('9516', '红旗镇', '4', '9514');
INSERT INTO `tp_region` VALUES ('9517', '东兴乡', '4', '9514');
INSERT INTO `tp_region` VALUES ('9518', '宏伟乡', '4', '9514');
INSERT INTO `tp_region` VALUES ('9519', '三合乡', '4', '9514');
INSERT INTO `tp_region` VALUES ('9520', '花园乡', '4', '9514');
INSERT INTO `tp_region` VALUES ('9521', '四合乡', '4', '9514');
INSERT INTO `tp_region` VALUES ('9522', '黎明乡', '4', '9514');
INSERT INTO `tp_region` VALUES ('9523', '林甸县长青林场', '4', '9514');
INSERT INTO `tp_region` VALUES ('9524', '巨浪牧场', '4', '9514');
INSERT INTO `tp_region` VALUES ('9525', '黑龙江省林甸县国营苇场', '4', '9514');
INSERT INTO `tp_region` VALUES ('9526', '林甸县新兴马场', '4', '9514');
INSERT INTO `tp_region` VALUES ('9527', '杜尔伯特县', '3', '9419');
INSERT INTO `tp_region` VALUES ('9528', '泰康镇', '4', '9527');
INSERT INTO `tp_region` VALUES ('9529', '胡吉吐莫镇', '4', '9527');
INSERT INTO `tp_region` VALUES ('9530', '烟筒屯镇', '4', '9527');
INSERT INTO `tp_region` VALUES ('9531', '他拉哈镇', '4', '9527');
INSERT INTO `tp_region` VALUES ('9532', '一心乡', '4', '9527');
INSERT INTO `tp_region` VALUES ('9533', '克尔台乡', '4', '9527');
INSERT INTO `tp_region` VALUES ('9534', '白音诺勒乡', '4', '9527');
INSERT INTO `tp_region` VALUES ('9535', '敖林西伯乡', '4', '9527');
INSERT INTO `tp_region` VALUES ('9536', '巴彦查干乡', '4', '9527');
INSERT INTO `tp_region` VALUES ('9537', '腰新乡', '4', '9527');
INSERT INTO `tp_region` VALUES ('9538', '江湾乡', '4', '9527');
INSERT INTO `tp_region` VALUES ('9539', '绿色草原牧场', '4', '9527');
INSERT INTO `tp_region` VALUES ('9540', '黑龙江省大山种羊场', '4', '9527');
INSERT INTO `tp_region` VALUES ('9541', '靠山种畜场', '4', '9527');
INSERT INTO `tp_region` VALUES ('9542', '对山奶牛场', '4', '9527');
INSERT INTO `tp_region` VALUES ('9543', '红旗种畜场', '4', '9527');
INSERT INTO `tp_region` VALUES ('9544', '连环湖渔业有限公司', '4', '9527');
INSERT INTO `tp_region` VALUES ('9545', '石人沟渔业有限公司', '4', '9527');
INSERT INTO `tp_region` VALUES ('9546', '齐家泡渔业有限公司', '4', '9527');
INSERT INTO `tp_region` VALUES ('9547', '四家子林场', '4', '9527');
INSERT INTO `tp_region` VALUES ('9548', '新店林场', '4', '9527');
INSERT INTO `tp_region` VALUES ('9549', '野生饲养场', '4', '9527');
INSERT INTO `tp_region` VALUES ('9550', '第一良种场', '4', '9527');
INSERT INTO `tp_region` VALUES ('9551', '一心苗圃', '4', '9527');
INSERT INTO `tp_region` VALUES ('9552', '一心果树场', '4', '9527');
INSERT INTO `tp_region` VALUES ('9553', '伊春市', '2', '8558');
INSERT INTO `tp_region` VALUES ('9554', '市辖区', '3', '9553');
INSERT INTO `tp_region` VALUES ('9555', '伊春区', '3', '9553');
INSERT INTO `tp_region` VALUES ('9556', '旭日街道', '4', '9555');
INSERT INTO `tp_region` VALUES ('9557', '红升街道', '4', '9555');
INSERT INTO `tp_region` VALUES ('9558', '前进街道', '4', '9555');
INSERT INTO `tp_region` VALUES ('9559', '朝阳街道', '4', '9555');
INSERT INTO `tp_region` VALUES ('9560', '东升街道', '4', '9555');
INSERT INTO `tp_region` VALUES ('9561', '南岔区', '3', '9553');
INSERT INTO `tp_region` VALUES ('9562', '西水街道', '4', '9561');
INSERT INTO `tp_region` VALUES ('9563', '联合街道', '4', '9561');
INSERT INTO `tp_region` VALUES ('9564', '东升街道', '4', '9561');
INSERT INTO `tp_region` VALUES ('9565', '晨明镇', '4', '9561');
INSERT INTO `tp_region` VALUES ('9566', '浩良河镇', '4', '9561');
INSERT INTO `tp_region` VALUES ('9567', '迎春乡', '4', '9561');
INSERT INTO `tp_region` VALUES ('9568', '三岔河林场', '4', '9561');
INSERT INTO `tp_region` VALUES ('9569', '四合营林场', '4', '9561');
INSERT INTO `tp_region` VALUES ('9570', '亮子河林场', '4', '9561');
INSERT INTO `tp_region` VALUES ('9571', '石头河林场', '4', '9561');
INSERT INTO `tp_region` VALUES ('9572', '岩石经营所', '4', '9561');
INSERT INTO `tp_region` VALUES ('9573', '奋斗经营所', '4', '9561');
INSERT INTO `tp_region` VALUES ('9574', '桦阳经营所', '4', '9561');
INSERT INTO `tp_region` VALUES ('9575', '浩良河经营所', '4', '9561');
INSERT INTO `tp_region` VALUES ('9576', '太平经营所', '4', '9561');
INSERT INTO `tp_region` VALUES ('9577', '南岔经营所', '4', '9561');
INSERT INTO `tp_region` VALUES ('9578', '威岭经营所', '4', '9561');
INSERT INTO `tp_region` VALUES ('9579', '松青经营所', '4', '9561');
INSERT INTO `tp_region` VALUES ('9580', '柳树经营所', '4', '9561');
INSERT INTO `tp_region` VALUES ('9581', '友好区', '3', '9553');
INSERT INTO `tp_region` VALUES ('9582', '友好街道', '4', '9581');
INSERT INTO `tp_region` VALUES ('9583', '双子河街道', '4', '9581');
INSERT INTO `tp_region` VALUES ('9584', '铁林街道', '4', '9581');
INSERT INTO `tp_region` VALUES ('9585', '三合经营所', '4', '9581');
INSERT INTO `tp_region` VALUES ('9586', '松园林场', '4', '9581');
INSERT INTO `tp_region` VALUES ('9587', '中心经营所', '4', '9581');
INSERT INTO `tp_region` VALUES ('9588', '永青经营所', '4', '9581');
INSERT INTO `tp_region` VALUES ('9589', '碧云经营所', '4', '9581');
INSERT INTO `tp_region` VALUES ('9590', '友谊经营所', '4', '9581');
INSERT INTO `tp_region` VALUES ('9591', '青杨经营所', '4', '9581');
INSERT INTO `tp_region` VALUES ('9592', '岭峰林场', '4', '9581');
INSERT INTO `tp_region` VALUES ('9593', '奋斗林场', '4', '9581');
INSERT INTO `tp_region` VALUES ('9594', '东卡林场', '4', '9581');
INSERT INTO `tp_region` VALUES ('9595', '鸡爪河林场', '4', '9581');
INSERT INTO `tp_region` VALUES ('9596', '绿源林场', '4', '9581');
INSERT INTO `tp_region` VALUES ('9597', '广川经营所', '4', '9581');
INSERT INTO `tp_region` VALUES ('9598', '朝阳经营所', '4', '9581');
INSERT INTO `tp_region` VALUES ('9599', '西林区', '3', '9553');
INSERT INTO `tp_region` VALUES ('9600', '西林街道', '4', '9599');
INSERT INTO `tp_region` VALUES ('9601', '新兴街道', '4', '9599');
INSERT INTO `tp_region` VALUES ('9602', '苔青街道', '4', '9599');
INSERT INTO `tp_region` VALUES ('9603', '翠峦区', '3', '9553');
INSERT INTO `tp_region` VALUES ('9604', '向阳街道', '4', '9603');
INSERT INTO `tp_region` VALUES ('9605', '曙光街道', '4', '9603');
INSERT INTO `tp_region` VALUES ('9606', '解放经营所', '4', '9603');
INSERT INTO `tp_region` VALUES ('9607', '昆仑气林场', '4', '9603');
INSERT INTO `tp_region` VALUES ('9608', '开源河林场', '4', '9603');
INSERT INTO `tp_region` VALUES ('9609', '么河经营所', '4', '9603');
INSERT INTO `tp_region` VALUES ('9610', '冲锋经营所', '4', '9603');
INSERT INTO `tp_region` VALUES ('9611', '翠峦河经营所', '4', '9603');
INSERT INTO `tp_region` VALUES ('9612', '抚育河经营所', '4', '9603');
INSERT INTO `tp_region` VALUES ('9613', '尖山河经营所', '4', '9603');
INSERT INTO `tp_region` VALUES ('9614', '新青区', '3', '9553');
INSERT INTO `tp_region` VALUES ('9615', '新青街道', '4', '9614');
INSERT INTO `tp_region` VALUES ('9616', '兴安街道', '4', '9614');
INSERT INTO `tp_region` VALUES ('9617', '红林经营所', '4', '9614');
INSERT INTO `tp_region` VALUES ('9618', '松林林场', '4', '9614');
INSERT INTO `tp_region` VALUES ('9619', '泉林林场', '4', '9614');
INSERT INTO `tp_region` VALUES ('9620', '水源林场', '4', '9614');
INSERT INTO `tp_region` VALUES ('9621', '笑山林场', '4', '9614');
INSERT INTO `tp_region` VALUES ('9622', '汤林林场', '4', '9614');
INSERT INTO `tp_region` VALUES ('9623', '桦林经营所', '4', '9614');
INSERT INTO `tp_region` VALUES ('9624', '青林林场', '4', '9614');
INSERT INTO `tp_region` VALUES ('9625', '结源林场', '4', '9614');
INSERT INTO `tp_region` VALUES ('9626', '北沟林场', '4', '9614');
INSERT INTO `tp_region` VALUES ('9627', '南沟林场', '4', '9614');
INSERT INTO `tp_region` VALUES ('9628', '乌拉嘎经营所', '4', '9614');
INSERT INTO `tp_region` VALUES ('9629', '柳树河林场', '4', '9614');
INSERT INTO `tp_region` VALUES ('9630', '北影林场', '4', '9614');
INSERT INTO `tp_region` VALUES ('9631', '美溪区', '3', '9553');
INSERT INTO `tp_region` VALUES ('9632', '美溪街道', '4', '9631');
INSERT INTO `tp_region` VALUES ('9633', '大西林林场', '4', '9631');
INSERT INTO `tp_region` VALUES ('9634', '五道库经营所', '4', '9631');
INSERT INTO `tp_region` VALUES ('9635', '缓岭经营所', '4', '9631');
INSERT INTO `tp_region` VALUES ('9636', '对青山经营所', '4', '9631');
INSERT INTO `tp_region` VALUES ('9637', '群峦经营所', '4', '9631');
INSERT INTO `tp_region` VALUES ('9638', '兰新经营所', '4', '9631');
INSERT INTO `tp_region` VALUES ('9639', '顺利河林场', '4', '9631');
INSERT INTO `tp_region` VALUES ('9640', '松岭经营所', '4', '9631');
INSERT INTO `tp_region` VALUES ('9641', '青山口林场', '4', '9631');
INSERT INTO `tp_region` VALUES ('9642', '金沙河林场', '4', '9631');
INSERT INTO `tp_region` VALUES ('9643', '桦皮羌子林场', '4', '9631');
INSERT INTO `tp_region` VALUES ('9644', '碧仓库林场', '4', '9631');
INSERT INTO `tp_region` VALUES ('9645', '三股流经营所', '4', '9631');
INSERT INTO `tp_region` VALUES ('9646', '卧龙河林场', '4', '9631');
INSERT INTO `tp_region` VALUES ('9647', '金山屯区', '3', '9553');
INSERT INTO `tp_region` VALUES ('9648', '奋斗街道', '4', '9647');
INSERT INTO `tp_region` VALUES ('9649', '金山街道', '4', '9647');
INSERT INTO `tp_region` VALUES ('9650', '白山林场', '4', '9647');
INSERT INTO `tp_region` VALUES ('9651', '丰岭林场', '4', '9647');
INSERT INTO `tp_region` VALUES ('9652', '丰林林场', '4', '9647');
INSERT INTO `tp_region` VALUES ('9653', '丰沟经营所', '4', '9647');
INSERT INTO `tp_region` VALUES ('9654', '丰茂林场', '4', '9647');
INSERT INTO `tp_region` VALUES ('9655', '横山经营所', '4', '9647');
INSERT INTO `tp_region` VALUES ('9656', '丰丽林场', '4', '9647');
INSERT INTO `tp_region` VALUES ('9657', '大昆仑经营所', '4', '9647');
INSERT INTO `tp_region` VALUES ('9658', '小昆仑林场', '4', '9647');
INSERT INTO `tp_region` VALUES ('9659', '育林经营所', '4', '9647');
INSERT INTO `tp_region` VALUES ('9660', '五营区', '3', '9553');
INSERT INTO `tp_region` VALUES ('9661', '五营街道', '4', '9660');
INSERT INTO `tp_region` VALUES ('9662', '五星街道', '4', '9660');
INSERT INTO `tp_region` VALUES ('9663', '翠北林场', '4', '9660');
INSERT INTO `tp_region` VALUES ('9664', '前丰林场', '4', '9660');
INSERT INTO `tp_region` VALUES ('9665', '永丰经营所', '4', '9660');
INSERT INTO `tp_region` VALUES ('9666', '平原经营所', '4', '9660');
INSERT INTO `tp_region` VALUES ('9667', '丽丰经营所', '4', '9660');
INSERT INTO `tp_region` VALUES ('9668', '杨树河经营所', '4', '9660');
INSERT INTO `tp_region` VALUES ('9669', '平山经营所', '4', '9660');
INSERT INTO `tp_region` VALUES ('9670', '丽林经营所', '4', '9660');
INSERT INTO `tp_region` VALUES ('9671', '乌马河区', '3', '9553');
INSERT INTO `tp_region` VALUES ('9672', '乌马河街道', '4', '9671');
INSERT INTO `tp_region` VALUES ('9673', '伊敏林场', '4', '9671');
INSERT INTO `tp_region` VALUES ('9674', '伊东经营所', '4', '9671');
INSERT INTO `tp_region` VALUES ('9675', '东方红经营所', '4', '9671');
INSERT INTO `tp_region` VALUES ('9676', '翠岭经营所', '4', '9671');
INSERT INTO `tp_region` VALUES ('9677', '河北经营所', '4', '9671');
INSERT INTO `tp_region` VALUES ('9678', '青山林场', '4', '9671');
INSERT INTO `tp_region` VALUES ('9679', '育苗经营所', '4', '9671');
INSERT INTO `tp_region` VALUES ('9680', '安全经营所', '4', '9671');
INSERT INTO `tp_region` VALUES ('9681', '伊青经营所', '4', '9671');
INSERT INTO `tp_region` VALUES ('9682', '前进经营所', '4', '9671');
INSERT INTO `tp_region` VALUES ('9683', '西岭林场', '4', '9671');
INSERT INTO `tp_region` VALUES ('9684', '伊林经营所', '4', '9671');
INSERT INTO `tp_region` VALUES ('9685', '汤旺河区', '3', '9553');
INSERT INTO `tp_region` VALUES ('9686', '河南街道', '4', '9685');
INSERT INTO `tp_region` VALUES ('9687', '河北街道', '4', '9685');
INSERT INTO `tp_region` VALUES ('9688', '日新林场', '4', '9685');
INSERT INTO `tp_region` VALUES ('9689', '石林林场', '4', '9685');
INSERT INTO `tp_region` VALUES ('9690', '东升林场', '4', '9685');
INSERT INTO `tp_region` VALUES ('9691', '二龙山林场', '4', '9685');
INSERT INTO `tp_region` VALUES ('9692', '高峰林场', '4', '9685');
INSERT INTO `tp_region` VALUES ('9693', '二清河林场', '4', '9685');
INSERT INTO `tp_region` VALUES ('9694', '守虎山林场', '4', '9685');
INSERT INTO `tp_region` VALUES ('9695', '泉石林场', '4', '9685');
INSERT INTO `tp_region` VALUES ('9696', '峻岭林场', '4', '9685');
INSERT INTO `tp_region` VALUES ('9697', '育林经营所', '4', '9685');
INSERT INTO `tp_region` VALUES ('9698', '团结经营所', '4', '9685');
INSERT INTO `tp_region` VALUES ('9699', '磨石山经营所', '4', '9685');
INSERT INTO `tp_region` VALUES ('9700', '中心苗卜', '4', '9685');
INSERT INTO `tp_region` VALUES ('9701', '克林经营所', '4', '9685');
INSERT INTO `tp_region` VALUES ('9702', '带岭区', '3', '9553');
INSERT INTO `tp_region` VALUES ('9703', '带岭街道', '4', '9702');
INSERT INTO `tp_region` VALUES ('9704', '大青川林场', '4', '9702');
INSERT INTO `tp_region` VALUES ('9705', '东方红林场', '4', '9702');
INSERT INTO `tp_region` VALUES ('9706', '秀水林场', '4', '9702');
INSERT INTO `tp_region` VALUES ('9707', '永翠林场', '4', '9702');
INSERT INTO `tp_region` VALUES ('9708', '明月林场', '4', '9702');
INSERT INTO `tp_region` VALUES ('9709', '红光林场', '4', '9702');
INSERT INTO `tp_region` VALUES ('9710', '碧水林场', '4', '9702');
INSERT INTO `tp_region` VALUES ('9711', '北列林场', '4', '9702');
INSERT INTO `tp_region` VALUES ('9712', '南列林场', '4', '9702');
INSERT INTO `tp_region` VALUES ('9713', '寒月林场', '4', '9702');
INSERT INTO `tp_region` VALUES ('9714', '环山林场', '4', '9702');
INSERT INTO `tp_region` VALUES ('9715', '乌伊岭区', '3', '9553');
INSERT INTO `tp_region` VALUES ('9716', '乌伊岭街道', '4', '9715');
INSERT INTO `tp_region` VALUES ('9717', '上游林场', '4', '9715');
INSERT INTO `tp_region` VALUES ('9718', '美峰林场', '4', '9715');
INSERT INTO `tp_region` VALUES ('9719', '翠峰林场', '4', '9715');
INSERT INTO `tp_region` VALUES ('9720', '建新林场', '4', '9715');
INSERT INTO `tp_region` VALUES ('9721', '移山林场', '4', '9715');
INSERT INTO `tp_region` VALUES ('9722', '林海林场', '4', '9715');
INSERT INTO `tp_region` VALUES ('9723', '桔源林场', '4', '9715');
INSERT INTO `tp_region` VALUES ('9724', '东克林林场', '4', '9715');
INSERT INTO `tp_region` VALUES ('9725', '福民林场', '4', '9715');
INSERT INTO `tp_region` VALUES ('9726', '阿廷河林场', '4', '9715');
INSERT INTO `tp_region` VALUES ('9727', '永胜经营所', '4', '9715');
INSERT INTO `tp_region` VALUES ('9728', '前卫林场', '4', '9715');
INSERT INTO `tp_region` VALUES ('9729', '红星区', '3', '9553');
INSERT INTO `tp_region` VALUES ('9730', '红星街道', '4', '9729');
INSERT INTO `tp_region` VALUES ('9731', '清水河经营所', '4', '9729');
INSERT INTO `tp_region` VALUES ('9732', '五星河经营所', '4', '9729');
INSERT INTO `tp_region` VALUES ('9733', '汤洪岭林场', '4', '9729');
INSERT INTO `tp_region` VALUES ('9734', '汤北林场', '4', '9729');
INSERT INTO `tp_region` VALUES ('9735', '霍吉河林场', '4', '9729');
INSERT INTO `tp_region` VALUES ('9736', '二杨经营所', '4', '9729');
INSERT INTO `tp_region` VALUES ('9737', '三杨林场', '4', '9729');
INSERT INTO `tp_region` VALUES ('9738', '汤南林场', '4', '9729');
INSERT INTO `tp_region` VALUES ('9739', '共青经营所', '4', '9729');
INSERT INTO `tp_region` VALUES ('9740', '库斯特林场', '4', '9729');
INSERT INTO `tp_region` VALUES ('9741', '二皮河经营所', '4', '9729');
INSERT INTO `tp_region` VALUES ('9742', '上甘岭区', '3', '9553');
INSERT INTO `tp_region` VALUES ('9743', '红山街道', '4', '9742');
INSERT INTO `tp_region` VALUES ('9744', '山峰林场', '4', '9742');
INSERT INTO `tp_region` VALUES ('9745', '阳光林场', '4', '9742');
INSERT INTO `tp_region` VALUES ('9746', '新风林场', '4', '9742');
INSERT INTO `tp_region` VALUES ('9747', '卫国林场', '4', '9742');
INSERT INTO `tp_region` VALUES ('9748', '查山经营所', '4', '9742');
INSERT INTO `tp_region` VALUES ('9749', '长青经营所', '4', '9742');
INSERT INTO `tp_region` VALUES ('9750', '青山农场', '4', '9742');
INSERT INTO `tp_region` VALUES ('9751', '溪水经营所', '4', '9742');
INSERT INTO `tp_region` VALUES ('9752', '蔚兰经营所', '4', '9742');
INSERT INTO `tp_region` VALUES ('9753', '永绪经营所', '4', '9742');
INSERT INTO `tp_region` VALUES ('9754', '美林经营所', '4', '9742');
INSERT INTO `tp_region` VALUES ('9755', '红山经营所', '4', '9742');
INSERT INTO `tp_region` VALUES ('9756', '嘉荫县', '3', '9553');
INSERT INTO `tp_region` VALUES ('9757', '朝阳镇', '4', '9756');
INSERT INTO `tp_region` VALUES ('9758', '乌云镇', '4', '9756');
INSERT INTO `tp_region` VALUES ('9759', '乌拉嘎镇', '4', '9756');
INSERT INTO `tp_region` VALUES ('9760', '常胜乡', '4', '9756');
INSERT INTO `tp_region` VALUES ('9761', '向阳乡', '4', '9756');
INSERT INTO `tp_region` VALUES ('9762', '沪嘉乡', '4', '9756');
INSERT INTO `tp_region` VALUES ('9763', '红光乡', '4', '9756');
INSERT INTO `tp_region` VALUES ('9764', '保兴乡', '4', '9756');
INSERT INTO `tp_region` VALUES ('9765', '青山乡', '4', '9756');
INSERT INTO `tp_region` VALUES ('9766', '太平林场', '4', '9756');
INSERT INTO `tp_region` VALUES ('9767', '红旗林场', '4', '9756');
INSERT INTO `tp_region` VALUES ('9768', '清河林场', '4', '9756');
INSERT INTO `tp_region` VALUES ('9769', '连江林场', '4', '9756');
INSERT INTO `tp_region` VALUES ('9770', '马连林场', '4', '9756');
INSERT INTO `tp_region` VALUES ('9771', '嘉荫农场', '4', '9756');
INSERT INTO `tp_region` VALUES ('9772', '铁力市', '3', '9553');
INSERT INTO `tp_region` VALUES ('9773', '铁力镇', '4', '9772');
INSERT INTO `tp_region` VALUES ('9774', '双丰镇', '4', '9772');
INSERT INTO `tp_region` VALUES ('9775', '桃山镇', '4', '9772');
INSERT INTO `tp_region` VALUES ('9776', '朗乡镇', '4', '9772');
INSERT INTO `tp_region` VALUES ('9777', '年丰乡', '4', '9772');
INSERT INTO `tp_region` VALUES ('9778', '工农乡', '4', '9772');
INSERT INTO `tp_region` VALUES ('9779', '王杨乡', '4', '9772');
INSERT INTO `tp_region` VALUES ('9780', '铁力林业局', '4', '9772');
INSERT INTO `tp_region` VALUES ('9781', '双丰林业局', '4', '9772');
INSERT INTO `tp_region` VALUES ('9782', '桃山林业局', '4', '9772');
INSERT INTO `tp_region` VALUES ('9783', '朗乡林业局', '4', '9772');
INSERT INTO `tp_region` VALUES ('9784', '铁力农场', '4', '9772');
INSERT INTO `tp_region` VALUES ('9785', '佳木斯市', '2', '8558');
INSERT INTO `tp_region` VALUES ('9786', '市辖区', '3', '9785');
INSERT INTO `tp_region` VALUES ('9787', '向阳区', '3', '9785');
INSERT INTO `tp_region` VALUES ('9788', '西林街道', '4', '9787');
INSERT INTO `tp_region` VALUES ('9789', '保卫街道', '4', '9787');
INSERT INTO `tp_region` VALUES ('9790', '桥南街道', '4', '9787');
INSERT INTO `tp_region` VALUES ('9791', '西南岗街道', '4', '9787');
INSERT INTO `tp_region` VALUES ('9792', '建设街道', '4', '9787');
INSERT INTO `tp_region` VALUES ('9793', '长安街道', '4', '9787');
INSERT INTO `tp_region` VALUES ('9794', '向阳区直辖地域', '4', '9787');
INSERT INTO `tp_region` VALUES ('9795', '前进区', '3', '9785');
INSERT INTO `tp_region` VALUES ('9796', '站前街道', '4', '9795');
INSERT INTO `tp_region` VALUES ('9797', '永安街道', '4', '9795');
INSERT INTO `tp_region` VALUES ('9798', '奋斗街道', '4', '9795');
INSERT INTO `tp_region` VALUES ('9799', '南岗街道', '4', '9795');
INSERT INTO `tp_region` VALUES ('9800', '亮子河街道', '4', '9795');
INSERT INTO `tp_region` VALUES ('9801', '田园街道', '4', '9795');
INSERT INTO `tp_region` VALUES ('9802', '东风区', '3', '9785');
INSERT INTO `tp_region` VALUES ('9803', '晓云街道', '4', '9802');
INSERT INTO `tp_region` VALUES ('9804', '佳东街道', '4', '9802');
INSERT INTO `tp_region` VALUES ('9805', '造纸街道', '4', '9802');
INSERT INTO `tp_region` VALUES ('9806', '佳南街道', '4', '9802');
INSERT INTO `tp_region` VALUES ('9807', '建国街道', '4', '9802');
INSERT INTO `tp_region` VALUES ('9808', '松江乡', '4', '9802');
INSERT INTO `tp_region` VALUES ('9809', '建国乡', '4', '9802');
INSERT INTO `tp_region` VALUES ('9810', '郊区', '3', '9785');
INSERT INTO `tp_region` VALUES ('9811', '佳西街道', '4', '9810');
INSERT INTO `tp_region` VALUES ('9812', '友谊街道', '4', '9810');
INSERT INTO `tp_region` VALUES ('9813', '大来镇', '4', '9810');
INSERT INTO `tp_region` VALUES ('9814', '敖其镇', '4', '9810');
INSERT INTO `tp_region` VALUES ('9815', '望江镇', '4', '9810');
INSERT INTO `tp_region` VALUES ('9816', '长发镇', '4', '9810');
INSERT INTO `tp_region` VALUES ('9817', '莲江口镇', '4', '9810');
INSERT INTO `tp_region` VALUES ('9818', '长青乡', '4', '9810');
INSERT INTO `tp_region` VALUES ('9819', '沿江乡', '4', '9810');
INSERT INTO `tp_region` VALUES ('9820', '西格木乡', '4', '9810');
INSERT INTO `tp_region` VALUES ('9821', '平安乡', '4', '9810');
INSERT INTO `tp_region` VALUES ('9822', '四丰乡', '4', '9810');
INSERT INTO `tp_region` VALUES ('9823', '群胜乡', '4', '9810');
INSERT INTO `tp_region` VALUES ('9824', '莲江口监狱', '4', '9810');
INSERT INTO `tp_region` VALUES ('9825', '桦南县', '3', '9785');
INSERT INTO `tp_region` VALUES ('9826', '驼腰子镇', '4', '9825');
INSERT INTO `tp_region` VALUES ('9827', '石头河子镇', '4', '9825');
INSERT INTO `tp_region` VALUES ('9828', '桦南镇', '4', '9825');
INSERT INTO `tp_region` VALUES ('9829', '土龙山镇', '4', '9825');
INSERT INTO `tp_region` VALUES ('9830', '孟家岗镇', '4', '9825');
INSERT INTO `tp_region` VALUES ('9831', '闫家镇', '4', '9825');
INSERT INTO `tp_region` VALUES ('9832', '金沙乡', '4', '9825');
INSERT INTO `tp_region` VALUES ('9833', '梨树乡', '4', '9825');
INSERT INTO `tp_region` VALUES ('9834', '明义乡', '4', '9825');
INSERT INTO `tp_region` VALUES ('9835', '大八浪乡', '4', '9825');
INSERT INTO `tp_region` VALUES ('9836', '桦南林业局', '4', '9825');
INSERT INTO `tp_region` VALUES ('9837', '曙光农场', '4', '9825');
INSERT INTO `tp_region` VALUES ('9838', '桦南种畜场', '4', '9825');
INSERT INTO `tp_region` VALUES ('9839', '桦川县', '3', '9785');
INSERT INTO `tp_region` VALUES ('9840', '横头山镇', '4', '9839');
INSERT INTO `tp_region` VALUES ('9841', '苏家店镇', '4', '9839');
INSERT INTO `tp_region` VALUES ('9842', '悦来镇', '4', '9839');
INSERT INTO `tp_region` VALUES ('9843', '新城镇', '4', '9839');
INSERT INTO `tp_region` VALUES ('9844', '东河乡', '4', '9839');
INSERT INTO `tp_region` VALUES ('9845', '梨丰乡', '4', '9839');
INSERT INTO `tp_region` VALUES ('9846', '创业乡', '4', '9839');
INSERT INTO `tp_region` VALUES ('9847', '星火乡', '4', '9839');
INSERT INTO `tp_region` VALUES ('9848', '四马架乡', '4', '9839');
INSERT INTO `tp_region` VALUES ('9849', '江川农场', '4', '9839');
INSERT INTO `tp_region` VALUES ('9850', '宝山农场', '4', '9839');
INSERT INTO `tp_region` VALUES ('9851', '汤原县', '3', '9785');
INSERT INTO `tp_region` VALUES ('9852', '香兰镇', '4', '9851');
INSERT INTO `tp_region` VALUES ('9853', '鹤立镇', '4', '9851');
INSERT INTO `tp_region` VALUES ('9854', '竹帘镇', '4', '9851');
INSERT INTO `tp_region` VALUES ('9855', '汤原镇', '4', '9851');
INSERT INTO `tp_region` VALUES ('9856', '汤旺乡', '4', '9851');
INSERT INTO `tp_region` VALUES ('9857', '胜利乡', '4', '9851');
INSERT INTO `tp_region` VALUES ('9858', '吉祥乡', '4', '9851');
INSERT INTO `tp_region` VALUES ('9859', '振兴乡', '4', '9851');
INSERT INTO `tp_region` VALUES ('9860', '太平川乡', '4', '9851');
INSERT INTO `tp_region` VALUES ('9861', '永发乡', '4', '9851');
INSERT INTO `tp_region` VALUES ('9862', '鹤立林业局', '4', '9851');
INSERT INTO `tp_region` VALUES ('9863', '香兰监狱', '4', '9851');
INSERT INTO `tp_region` VALUES ('9864', '汤原农场', '4', '9851');
INSERT INTO `tp_region` VALUES ('9865', '梧桐河农场', '4', '9851');
INSERT INTO `tp_region` VALUES ('9866', '抚远县', '3', '9785');
INSERT INTO `tp_region` VALUES ('9867', '抚远镇', '4', '9866');
INSERT INTO `tp_region` VALUES ('9868', '寒葱沟镇', '4', '9866');
INSERT INTO `tp_region` VALUES ('9869', '浓桥镇', '4', '9866');
INSERT INTO `tp_region` VALUES ('9870', '抓吉镇', '4', '9866');
INSERT INTO `tp_region` VALUES ('9871', '通江乡', '4', '9866');
INSERT INTO `tp_region` VALUES ('9872', '浓江乡', '4', '9866');
INSERT INTO `tp_region` VALUES ('9873', '海青乡', '4', '9866');
INSERT INTO `tp_region` VALUES ('9874', '别拉洪乡', '4', '9866');
INSERT INTO `tp_region` VALUES ('9875', '鸭南乡', '4', '9866');
INSERT INTO `tp_region` VALUES ('9876', '前哨农场', '4', '9866');
INSERT INTO `tp_region` VALUES ('9877', '前锋农场', '4', '9866');
INSERT INTO `tp_region` VALUES ('9878', '二道河农场', '4', '9866');
INSERT INTO `tp_region` VALUES ('9879', '同江市', '3', '9785');
INSERT INTO `tp_region` VALUES ('9880', '杏林街道', '4', '9879');
INSERT INTO `tp_region` VALUES ('9881', '和兴街道', '4', '9879');
INSERT INTO `tp_region` VALUES ('9882', '安康街道', '4', '9879');
INSERT INTO `tp_region` VALUES ('9883', '幸福街道', '4', '9879');
INSERT INTO `tp_region` VALUES ('9884', '同江镇', '4', '9879');
INSERT INTO `tp_region` VALUES ('9885', '乐业镇', '4', '9879');
INSERT INTO `tp_region` VALUES ('9886', '三村镇', '4', '9879');
INSERT INTO `tp_region` VALUES ('9887', '临江镇', '4', '9879');
INSERT INTO `tp_region` VALUES ('9888', '向阳乡', '4', '9879');
INSERT INTO `tp_region` VALUES ('9889', '青河乡', '4', '9879');
INSERT INTO `tp_region` VALUES ('9890', '街津口乡', '4', '9879');
INSERT INTO `tp_region` VALUES ('9891', '八岔乡', '4', '9879');
INSERT INTO `tp_region` VALUES ('9892', '金川乡', '4', '9879');
INSERT INTO `tp_region` VALUES ('9893', '银川乡', '4', '9879');
INSERT INTO `tp_region` VALUES ('9894', '街津口林场', '4', '9879');
INSERT INTO `tp_region` VALUES ('9895', '鸭北林场', '4', '9879');
INSERT INTO `tp_region` VALUES ('9896', '勤得利农场', '4', '9879');
INSERT INTO `tp_region` VALUES ('9897', '青龙山农场', '4', '9879');
INSERT INTO `tp_region` VALUES ('9898', '前进农场', '4', '9879');
INSERT INTO `tp_region` VALUES ('9899', '洪河农场', '4', '9879');
INSERT INTO `tp_region` VALUES ('9900', '鸭绿河农场', '4', '9879');
INSERT INTO `tp_region` VALUES ('9901', '浓江农场', '4', '9879');
INSERT INTO `tp_region` VALUES ('9902', '良种场', '4', '9879');
INSERT INTO `tp_region` VALUES ('9903', '果树场', '4', '9879');
INSERT INTO `tp_region` VALUES ('9904', '马场', '4', '9879');
INSERT INTO `tp_region` VALUES ('9905', '干校', '4', '9879');
INSERT INTO `tp_region` VALUES ('9906', '知青农场', '4', '9879');
INSERT INTO `tp_region` VALUES ('9907', '富锦市', '3', '9785');
INSERT INTO `tp_region` VALUES ('9908', '城市街道社区委员会', '4', '9907');
INSERT INTO `tp_region` VALUES ('9909', '城关街道社区建设委员会', '4', '9907');
INSERT INTO `tp_region` VALUES ('9910', '长安镇', '4', '9907');
INSERT INTO `tp_region` VALUES ('9911', '砚山镇', '4', '9907');
INSERT INTO `tp_region` VALUES ('9912', '头林镇', '4', '9907');
INSERT INTO `tp_region` VALUES ('9913', '兴隆岗镇', '4', '9907');
INSERT INTO `tp_region` VALUES ('9914', '宏胜镇', '4', '9907');
INSERT INTO `tp_region` VALUES ('9915', '向阳川镇', '4', '9907');
INSERT INTO `tp_region` VALUES ('9916', '二龙山镇', '4', '9907');
INSERT INTO `tp_region` VALUES ('9917', '上街基镇', '4', '9907');
INSERT INTO `tp_region` VALUES ('9918', '锦山镇', '4', '9907');
INSERT INTO `tp_region` VALUES ('9919', '大榆树镇', '4', '9907');
INSERT INTO `tp_region` VALUES ('9920', '石砬山林场', '4', '9907');
INSERT INTO `tp_region` VALUES ('9921', '东风岗林场', '4', '9907');
INSERT INTO `tp_region` VALUES ('9922', '太东林场', '4', '9907');
INSERT INTO `tp_region` VALUES ('9923', '工农林场', '4', '9907');
INSERT INTO `tp_region` VALUES ('9924', '建三江分局局直', '4', '9907');
INSERT INTO `tp_region` VALUES ('9925', '七星农场', '4', '9907');
INSERT INTO `tp_region` VALUES ('9926', '大兴农场', '4', '9907');
INSERT INTO `tp_region` VALUES ('9927', '创业农场', '4', '9907');
INSERT INTO `tp_region` VALUES ('9928', '种猪场', '4', '9907');
INSERT INTO `tp_region` VALUES ('9929', '种蓄场', '4', '9907');
INSERT INTO `tp_region` VALUES ('9930', '七台河市', '2', '8558');
INSERT INTO `tp_region` VALUES ('9931', '市辖区', '3', '9930');
INSERT INTO `tp_region` VALUES ('9932', '新兴区', '3', '9930');
INSERT INTO `tp_region` VALUES ('9933', '兴华街道', '4', '9932');
INSERT INTO `tp_region` VALUES ('9934', '新城街道', '4', '9932');
INSERT INTO `tp_region` VALUES ('9935', '新立街道', '4', '9932');
INSERT INTO `tp_region` VALUES ('9936', '新建街道', '4', '9932');
INSERT INTO `tp_region` VALUES ('9937', '北山街道', '4', '9932');
INSERT INTO `tp_region` VALUES ('9938', '河南街道', '4', '9932');
INSERT INTO `tp_region` VALUES ('9939', '新合街道', '4', '9932');
INSERT INTO `tp_region` VALUES ('9940', '缸窑沟街道', '4', '9932');
INSERT INTO `tp_region` VALUES ('9941', '新安街道', '4', '9932');
INSERT INTO `tp_region` VALUES ('9942', '越秀街道', '4', '9932');
INSERT INTO `tp_region` VALUES ('9943', '红旗镇', '4', '9932');
INSERT INTO `tp_region` VALUES ('9944', '桃山区', '3', '9930');
INSERT INTO `tp_region` VALUES ('9945', '桃南街道', '4', '9944');
INSERT INTO `tp_region` VALUES ('9946', '桃北街道', '4', '9944');
INSERT INTO `tp_region` VALUES ('9947', '桃西街道', '4', '9944');
INSERT INTO `tp_region` VALUES ('9948', '兴岗街道', '4', '9944');
INSERT INTO `tp_region` VALUES ('9949', '桃东街道', '4', '9944');
INSERT INTO `tp_region` VALUES ('9950', '桃山街道', '4', '9944');
INSERT INTO `tp_region` VALUES ('9951', '万宝河镇', '4', '9944');
INSERT INTO `tp_region` VALUES ('9952', '茄子河区', '3', '9930');
INSERT INTO `tp_region` VALUES ('9953', '东风街道', '4', '9952');
INSERT INTO `tp_region` VALUES ('9954', '向阳街道', '4', '9952');
INSERT INTO `tp_region` VALUES ('9955', '富强街道', '4', '9952');
INSERT INTO `tp_region` VALUES ('9956', '新富街道', '4', '9952');
INSERT INTO `tp_region` VALUES ('9957', '龙湖街道', '4', '9952');
INSERT INTO `tp_region` VALUES ('9958', '茄子河镇', '4', '9952');
INSERT INTO `tp_region` VALUES ('9959', '宏伟镇', '4', '9952');
INSERT INTO `tp_region` VALUES ('9960', '铁山乡', '4', '9952');
INSERT INTO `tp_region` VALUES ('9961', '中心河乡', '4', '9952');
INSERT INTO `tp_region` VALUES ('9962', '勃利县', '3', '9930');
INSERT INTO `tp_region` VALUES ('9963', '新起街道', '4', '9962');
INSERT INTO `tp_region` VALUES ('9964', '新华街道', '4', '9962');
INSERT INTO `tp_region` VALUES ('9965', '元明街道', '4', '9962');
INSERT INTO `tp_region` VALUES ('9966', '铁西街道', '4', '9962');
INSERT INTO `tp_region` VALUES ('9967', '城西街道', '4', '9962');
INSERT INTO `tp_region` VALUES ('9968', '勃利镇', '4', '9962');
INSERT INTO `tp_region` VALUES ('9969', '小五站镇', '4', '9962');
INSERT INTO `tp_region` VALUES ('9970', '大四站镇', '4', '9962');
INSERT INTO `tp_region` VALUES ('9971', '双河镇', '4', '9962');
INSERT INTO `tp_region` VALUES ('9972', '倭肯镇', '4', '9962');
INSERT INTO `tp_region` VALUES ('9973', '青山乡', '4', '9962');
INSERT INTO `tp_region` VALUES ('9974', '长兴乡', '4', '9962');
INSERT INTO `tp_region` VALUES ('9975', '永恒乡', '4', '9962');
INSERT INTO `tp_region` VALUES ('9976', '抢垦乡', '4', '9962');
INSERT INTO `tp_region` VALUES ('9977', '杏树朝鲜族乡', '4', '9962');
INSERT INTO `tp_region` VALUES ('9978', '吉兴朝鲜族满族乡', '4', '9962');
INSERT INTO `tp_region` VALUES ('9979', '北兴农场', '4', '9962');
INSERT INTO `tp_region` VALUES ('9980', '种畜场', '4', '9962');
INSERT INTO `tp_region` VALUES ('9981', '牡丹江市', '2', '8558');
INSERT INTO `tp_region` VALUES ('9982', '市辖区', '3', '9981');
INSERT INTO `tp_region` VALUES ('9983', '东安区', '3', '9981');
INSERT INTO `tp_region` VALUES ('9984', '新安街道', '4', '9983');
INSERT INTO `tp_region` VALUES ('9985', '长安街道', '4', '9983');
INSERT INTO `tp_region` VALUES ('9986', '七星街道', '4', '9983');
INSERT INTO `tp_region` VALUES ('9987', '五星街道', '4', '9983');
INSERT INTO `tp_region` VALUES ('9988', '兴隆镇', '4', '9983');
INSERT INTO `tp_region` VALUES ('9989', '阳明区', '3', '9981');
INSERT INTO `tp_region` VALUES ('9990', '阳明街道', '4', '9989');
INSERT INTO `tp_region` VALUES ('9991', '前进街道', '4', '9989');
INSERT INTO `tp_region` VALUES ('9992', '新兴街道', '4', '9989');
INSERT INTO `tp_region` VALUES ('9993', '桦林橡胶厂街道', '4', '9989');
INSERT INTO `tp_region` VALUES ('9994', '铁岭镇', '4', '9989');
INSERT INTO `tp_region` VALUES ('9995', '桦林镇', '4', '9989');
INSERT INTO `tp_region` VALUES ('9996', '爱民区', '3', '9981');
INSERT INTO `tp_region` VALUES ('9997', '向阳街道', '4', '9996');
INSERT INTO `tp_region` VALUES ('9998', '黄花街道', '4', '9996');
INSERT INTO `tp_region` VALUES ('9999', '铁北街道', '4', '9996');
INSERT INTO `tp_region` VALUES ('10000', '新华街道', '4', '9996');
INSERT INTO `tp_region` VALUES ('10001', '大庆街道', '4', '9996');
INSERT INTO `tp_region` VALUES ('10002', '兴平街道', '4', '9996');
INSERT INTO `tp_region` VALUES ('10003', '北山街道', '4', '9996');
INSERT INTO `tp_region` VALUES ('10004', '北安乡', '4', '9996');
INSERT INTO `tp_region` VALUES ('10005', '西安区', '3', '9981');
INSERT INTO `tp_region` VALUES ('10006', '先锋街道', '4', '10005');
INSERT INTO `tp_region` VALUES ('10007', '火炬街道', '4', '10005');
INSERT INTO `tp_region` VALUES ('10008', '立新街道', '4', '10005');
INSERT INTO `tp_region` VALUES ('10009', '牡丹街道', '4', '10005');
INSERT INTO `tp_region` VALUES ('10010', '江滨街道', '4', '10005');
INSERT INTO `tp_region` VALUES ('10011', '沿江街道', '4', '10005');
INSERT INTO `tp_region` VALUES ('10012', '温春镇', '4', '10005');
INSERT INTO `tp_region` VALUES ('10013', '沿江乡', '4', '10005');
INSERT INTO `tp_region` VALUES ('10014', '东宁县', '3', '9981');
INSERT INTO `tp_region` VALUES ('10015', '东宁镇', '4', '10014');
INSERT INTO `tp_region` VALUES ('10016', '三岔口镇', '4', '10014');
INSERT INTO `tp_region` VALUES ('10017', '大肚川镇', '4', '10014');
INSERT INTO `tp_region` VALUES ('10018', '老黑山镇', '4', '10014');
INSERT INTO `tp_region` VALUES ('10019', '道河镇', '4', '10014');
INSERT INTO `tp_region` VALUES ('10020', '绥阳镇', '4', '10014');
INSERT INTO `tp_region` VALUES ('10021', '绥阳林业局', '4', '10014');
INSERT INTO `tp_region` VALUES ('10022', '林口县', '3', '9981');
INSERT INTO `tp_region` VALUES ('10023', '林口镇', '4', '10022');
INSERT INTO `tp_region` VALUES ('10024', '古城镇', '4', '10022');
INSERT INTO `tp_region` VALUES ('10025', '刁翎镇', '4', '10022');
INSERT INTO `tp_region` VALUES ('10026', '五林镇', '4', '10022');
INSERT INTO `tp_region` VALUES ('10027', '朱家镇', '4', '10022');
INSERT INTO `tp_region` VALUES ('10028', '柳树镇', '4', '10022');
INSERT INTO `tp_region` VALUES ('10029', '三道通镇', '4', '10022');
INSERT INTO `tp_region` VALUES ('10030', '龙爪镇', '4', '10022');
INSERT INTO `tp_region` VALUES ('10031', '莲花镇', '4', '10022');
INSERT INTO `tp_region` VALUES ('10032', '奎山乡', '4', '10022');
INSERT INTO `tp_region` VALUES ('10033', '青山乡', '4', '10022');
INSERT INTO `tp_region` VALUES ('10034', '建堂乡', '4', '10022');
INSERT INTO `tp_region` VALUES ('10035', '林口林业局', '4', '10022');
INSERT INTO `tp_region` VALUES ('10036', '绥芬河市', '3', '9981');
INSERT INTO `tp_region` VALUES ('10037', '绥芬河镇', '4', '10036');
INSERT INTO `tp_region` VALUES ('10038', '阜宁镇', '4', '10036');
INSERT INTO `tp_region` VALUES ('10039', '海林市', '3', '9981');
INSERT INTO `tp_region` VALUES ('10040', '海林镇', '4', '10039');
INSERT INTO `tp_region` VALUES ('10041', '长汀镇', '4', '10039');
INSERT INTO `tp_region` VALUES ('10042', '横道镇', '4', '10039');
INSERT INTO `tp_region` VALUES ('10043', '山市镇', '4', '10039');
INSERT INTO `tp_region` VALUES ('10044', '柴河镇', '4', '10039');
INSERT INTO `tp_region` VALUES ('10045', '二道镇', '4', '10039');
INSERT INTO `tp_region` VALUES ('10046', '新安朝鲜族镇', '4', '10039');
INSERT INTO `tp_region` VALUES ('10047', '三道镇', '4', '10039');
INSERT INTO `tp_region` VALUES ('10048', '海南朝鲜族乡', '4', '10039');
INSERT INTO `tp_region` VALUES ('10049', '牡林工程公司街道', '4', '10039');
INSERT INTO `tp_region` VALUES ('10050', '柴河林机厂街道', '4', '10039');
INSERT INTO `tp_region` VALUES ('10051', '大海林林业局', '4', '10039');
INSERT INTO `tp_region` VALUES ('10052', '海林林业局', '4', '10039');
INSERT INTO `tp_region` VALUES ('10053', '柴河林业局', '4', '10039');
INSERT INTO `tp_region` VALUES ('10054', '海林农场', '4', '10039');
INSERT INTO `tp_region` VALUES ('10055', '山市种奶牛场', '4', '10039');
INSERT INTO `tp_region` VALUES ('10056', '宁安市', '3', '9981');
INSERT INTO `tp_region` VALUES ('10057', '城区街道', '4', '10056');
INSERT INTO `tp_region` VALUES ('10058', '宁安镇', '4', '10056');
INSERT INTO `tp_region` VALUES ('10059', '东京城镇', '4', '10056');
INSERT INTO `tp_region` VALUES ('10060', '渤海镇', '4', '10056');
INSERT INTO `tp_region` VALUES ('10061', '石岩镇', '4', '10056');
INSERT INTO `tp_region` VALUES ('10062', '沙兰镇', '4', '10056');
INSERT INTO `tp_region` VALUES ('10063', '海浪镇', '4', '10056');
INSERT INTO `tp_region` VALUES ('10064', '兰岗镇', '4', '10056');
INSERT INTO `tp_region` VALUES ('10065', '江南朝鲜族满族乡', '4', '10056');
INSERT INTO `tp_region` VALUES ('10066', '卧龙朝鲜族乡', '4', '10056');
INSERT INTO `tp_region` VALUES ('10067', '马河乡', '4', '10056');
INSERT INTO `tp_region` VALUES ('10068', '镜泊乡', '4', '10056');
INSERT INTO `tp_region` VALUES ('10069', '三陵乡', '4', '10056');
INSERT INTO `tp_region` VALUES ('10070', '东京城林业局', '4', '10056');
INSERT INTO `tp_region` VALUES ('10071', '宁安农场', '4', '10056');
INSERT INTO `tp_region` VALUES ('10072', '穆棱市', '3', '9981');
INSERT INTO `tp_region` VALUES ('10073', '八面通镇', '4', '10072');
INSERT INTO `tp_region` VALUES ('10074', '穆棱镇', '4', '10072');
INSERT INTO `tp_region` VALUES ('10075', '下城子镇', '4', '10072');
INSERT INTO `tp_region` VALUES ('10076', '马桥河镇', '4', '10072');
INSERT INTO `tp_region` VALUES ('10077', '兴源镇', '4', '10072');
INSERT INTO `tp_region` VALUES ('10078', '磨刀石镇', '4', '10072');
INSERT INTO `tp_region` VALUES ('10079', '福录乡', '4', '10072');
INSERT INTO `tp_region` VALUES ('10080', '河西乡', '4', '10072');
INSERT INTO `tp_region` VALUES ('10081', '共和乡', '4', '10072');
INSERT INTO `tp_region` VALUES ('10082', '八面通林业局', '4', '10072');
INSERT INTO `tp_region` VALUES ('10083', '穆棱林业局', '4', '10072');
INSERT INTO `tp_region` VALUES ('10084', '黑河市', '2', '8558');
INSERT INTO `tp_region` VALUES ('10085', '市辖区', '3', '10084');
INSERT INTO `tp_region` VALUES ('10086', '爱辉区', '3', '10084');
INSERT INTO `tp_region` VALUES ('10087', '花园街道', '4', '10086');
INSERT INTO `tp_region` VALUES ('10088', '兴安街道', '4', '10086');
INSERT INTO `tp_region` VALUES ('10089', '海兰街道', '4', '10086');
INSERT INTO `tp_region` VALUES ('10090', '西兴街道', '4', '10086');
INSERT INTO `tp_region` VALUES ('10091', '西岗子镇', '4', '10086');
INSERT INTO `tp_region` VALUES ('10092', '爱辉镇', '4', '10086');
INSERT INTO `tp_region` VALUES ('10093', '罕达汽镇', '4', '10086');
INSERT INTO `tp_region` VALUES ('10094', '幸福乡', '4', '10086');
INSERT INTO `tp_region` VALUES ('10095', '四嘉子乡', '4', '10086');
INSERT INTO `tp_region` VALUES ('10096', '坤河乡', '4', '10086');
INSERT INTO `tp_region` VALUES ('10097', '上马厂乡', '4', '10086');
INSERT INTO `tp_region` VALUES ('10098', '张地营子乡', '4', '10086');
INSERT INTO `tp_region` VALUES ('10099', '西峰山乡', '4', '10086');
INSERT INTO `tp_region` VALUES ('10100', '新生乡', '4', '10086');
INSERT INTO `tp_region` VALUES ('10101', '二站乡', '4', '10086');
INSERT INTO `tp_region` VALUES ('10102', '宋集屯煤矿', '4', '10086');
INSERT INTO `tp_region` VALUES ('10103', '西岗子煤矿', '4', '10086');
INSERT INTO `tp_region` VALUES ('10104', '东方红煤矿', '4', '10086');
INSERT INTO `tp_region` VALUES ('10105', '大平林场', '4', '10086');
INSERT INTO `tp_region` VALUES ('10106', '七二七林场', '4', '10086');
INSERT INTO `tp_region` VALUES ('10107', '望峰林场', '4', '10086');
INSERT INTO `tp_region` VALUES ('10108', '卡伦山林场', '4', '10086');
INSERT INTO `tp_region` VALUES ('10109', '胜山林场', '4', '10086');
INSERT INTO `tp_region` VALUES ('10110', '二站林场', '4', '10086');
INSERT INTO `tp_region` VALUES ('10111', '三站林场', '4', '10086');
INSERT INTO `tp_region` VALUES ('10112', '大岭林场', '4', '10086');
INSERT INTO `tp_region` VALUES ('10113', '桦皮窑林场', '4', '10086');
INSERT INTO `tp_region` VALUES ('10114', '滨南林场', '4', '10086');
INSERT INTO `tp_region` VALUES ('10115', '江防林场', '4', '10086');
INSERT INTO `tp_region` VALUES ('10116', '西岗子试验林场', '4', '10086');
INSERT INTO `tp_region` VALUES ('10117', '种畜场', '4', '10086');
INSERT INTO `tp_region` VALUES ('10118', '第二良种场', '4', '10086');
INSERT INTO `tp_region` VALUES ('10119', '第一良种场', '4', '10086');
INSERT INTO `tp_region` VALUES ('10120', '大新屯储木场', '4', '10086');
INSERT INTO `tp_region` VALUES ('10121', '锦河农场', '4', '10086');
INSERT INTO `tp_region` VALUES ('10122', '嫩江县', '3', '10084');
INSERT INTO `tp_region` VALUES ('10123', '嫩江镇', '4', '10122');
INSERT INTO `tp_region` VALUES ('10124', '伊拉哈镇', '4', '10122');
INSERT INTO `tp_region` VALUES ('10125', '双山镇', '4', '10122');
INSERT INTO `tp_region` VALUES ('10126', '多宝山镇', '4', '10122');
INSERT INTO `tp_region` VALUES ('10127', '海江镇', '4', '10122');
INSERT INTO `tp_region` VALUES ('10128', '前进镇', '4', '10122');
INSERT INTO `tp_region` VALUES ('10129', '长福镇', '4', '10122');
INSERT INTO `tp_region` VALUES ('10130', '科洛镇', '4', '10122');
INSERT INTO `tp_region` VALUES ('10131', '临江乡', '4', '10122');
INSERT INTO `tp_region` VALUES ('10132', '联兴乡', '4', '10122');
INSERT INTO `tp_region` VALUES ('10133', '白云乡', '4', '10122');
INSERT INTO `tp_region` VALUES ('10134', '塔溪乡', '4', '10122');
INSERT INTO `tp_region` VALUES ('10135', '霍龙门乡', '4', '10122');
INSERT INTO `tp_region` VALUES ('10136', '多宝山铜矿', '4', '10122');
INSERT INTO `tp_region` VALUES ('10137', '九三分局局直', '4', '10122');
INSERT INTO `tp_region` VALUES ('10138', '鹤山农场', '4', '10122');
INSERT INTO `tp_region` VALUES ('10139', '大西江农场', '4', '10122');
INSERT INTO `tp_region` VALUES ('10140', '尖山农场', '4', '10122');
INSERT INTO `tp_region` VALUES ('10141', '荣军农场', '4', '10122');
INSERT INTO `tp_region` VALUES ('10142', '红五月农场', '4', '10122');
INSERT INTO `tp_region` VALUES ('10143', '七星泡农场', '4', '10122');
INSERT INTO `tp_region` VALUES ('10144', '嫩江农场', '4', '10122');
INSERT INTO `tp_region` VALUES ('10145', '山河农场', '4', '10122');
INSERT INTO `tp_region` VALUES ('10146', '嫩北农场', '4', '10122');
INSERT INTO `tp_region` VALUES ('10147', '建边农场', '4', '10122');
INSERT INTO `tp_region` VALUES ('10148', '种畜场', '4', '10122');
INSERT INTO `tp_region` VALUES ('10149', '马铃薯原种繁殖场', '4', '10122');
INSERT INTO `tp_region` VALUES ('10150', '逊克县', '3', '10084');
INSERT INTO `tp_region` VALUES ('10151', '奇克街道', '4', '10150');
INSERT INTO `tp_region` VALUES ('10152', '边疆镇', '4', '10150');
INSERT INTO `tp_region` VALUES ('10153', '逊河镇', '4', '10150');
INSERT INTO `tp_region` VALUES ('10154', '干岔子乡', '4', '10150');
INSERT INTO `tp_region` VALUES ('10155', '松树沟乡', '4', '10150');
INSERT INTO `tp_region` VALUES ('10156', '车陆乡', '4', '10150');
INSERT INTO `tp_region` VALUES ('10157', '新鄂乡', '4', '10150');
INSERT INTO `tp_region` VALUES ('10158', '新兴乡', '4', '10150');
INSERT INTO `tp_region` VALUES ('10159', '克林乡', '4', '10150');
INSERT INTO `tp_region` VALUES ('10160', '宝山乡', '4', '10150');
INSERT INTO `tp_region` VALUES ('10161', '道干林场', '4', '10150');
INSERT INTO `tp_region` VALUES ('10162', '干岔子林场', '4', '10150');
INSERT INTO `tp_region` VALUES ('10163', '新立林场', '4', '10150');
INSERT INTO `tp_region` VALUES ('10164', '三间房林场', '4', '10150');
INSERT INTO `tp_region` VALUES ('10165', '良种场', '4', '10150');
INSERT INTO `tp_region` VALUES ('10166', '种畜场', '4', '10150');
INSERT INTO `tp_region` VALUES ('10167', '逊克农场', '4', '10150');
INSERT INTO `tp_region` VALUES ('10168', '孙吴县', '3', '10084');
INSERT INTO `tp_region` VALUES ('10169', '孙吴城区街道', '4', '10168');
INSERT INTO `tp_region` VALUES ('10170', '孙吴镇', '4', '10168');
INSERT INTO `tp_region` VALUES ('10171', '辰清镇', '4', '10168');
INSERT INTO `tp_region` VALUES ('10172', '西兴乡', '4', '10168');
INSERT INTO `tp_region` VALUES ('10173', '沿江满族乡', '4', '10168');
INSERT INTO `tp_region` VALUES ('10174', '腰屯乡', '4', '10168');
INSERT INTO `tp_region` VALUES ('10175', '卧牛河乡', '4', '10168');
INSERT INTO `tp_region` VALUES ('10176', '群山乡', '4', '10168');
INSERT INTO `tp_region` VALUES ('10177', '奋斗乡', '4', '10168');
INSERT INTO `tp_region` VALUES ('10178', '红旗乡', '4', '10168');
INSERT INTO `tp_region` VALUES ('10179', '正阳山乡', '4', '10168');
INSERT INTO `tp_region` VALUES ('10180', '清溪乡', '4', '10168');
INSERT INTO `tp_region` VALUES ('10181', '前进林场', '4', '10168');
INSERT INTO `tp_region` VALUES ('10182', '大河口林场', '4', '10168');
INSERT INTO `tp_region` VALUES ('10183', '正阳林场', '4', '10168');
INSERT INTO `tp_region` VALUES ('10184', '平山林场', '4', '10168');
INSERT INTO `tp_region` VALUES ('10185', '沿江林场', '4', '10168');
INSERT INTO `tp_region` VALUES ('10186', '辰清林场', '4', '10168');
INSERT INTO `tp_region` VALUES ('10187', '红旗林场', '4', '10168');
INSERT INTO `tp_region` VALUES ('10188', '向阳林场', '4', '10168');
INSERT INTO `tp_region` VALUES ('10189', '良种场', '4', '10168');
INSERT INTO `tp_region` VALUES ('10190', '种畜场', '4', '10168');
INSERT INTO `tp_region` VALUES ('10191', '红色边疆农场', '4', '10168');
INSERT INTO `tp_region` VALUES ('10192', '北安市', '3', '10084');
INSERT INTO `tp_region` VALUES ('10193', '兆麟街道', '4', '10192');
INSERT INTO `tp_region` VALUES ('10194', '和平街道', '4', '10192');
INSERT INTO `tp_region` VALUES ('10195', '北岗街道', '4', '10192');
INSERT INTO `tp_region` VALUES ('10196', '庆华街道', '4', '10192');
INSERT INTO `tp_region` VALUES ('10197', '铁西街道', '4', '10192');
INSERT INTO `tp_region` VALUES ('10198', '铁南街道', '4', '10192');
INSERT INTO `tp_region` VALUES ('10199', '通北镇', '4', '10192');
INSERT INTO `tp_region` VALUES ('10200', '赵光镇', '4', '10192');
INSERT INTO `tp_region` VALUES ('10201', '海星镇', '4', '10192');
INSERT INTO `tp_region` VALUES ('10202', '石泉镇', '4', '10192');
INSERT INTO `tp_region` VALUES ('10203', '二井镇', '4', '10192');
INSERT INTO `tp_region` VALUES ('10204', '城郊乡', '4', '10192');
INSERT INTO `tp_region` VALUES ('10205', '东胜乡', '4', '10192');
INSERT INTO `tp_region` VALUES ('10206', '杨家乡', '4', '10192');
INSERT INTO `tp_region` VALUES ('10207', '主星乡', '4', '10192');
INSERT INTO `tp_region` VALUES ('10208', '通北林业局', '4', '10192');
INSERT INTO `tp_region` VALUES ('10209', '北安分局局直', '4', '10192');
INSERT INTO `tp_region` VALUES ('10210', '长水河农场', '4', '10192');
INSERT INTO `tp_region` VALUES ('10211', '赵光农场', '4', '10192');
INSERT INTO `tp_region` VALUES ('10212', '红星农场', '4', '10192');
INSERT INTO `tp_region` VALUES ('10213', '建设农场', '4', '10192');
INSERT INTO `tp_region` VALUES ('10214', '五大连池市', '3', '10084');
INSERT INTO `tp_region` VALUES ('10215', '青山街道', '4', '10214');
INSERT INTO `tp_region` VALUES ('10216', '龙镇', '4', '10214');
INSERT INTO `tp_region` VALUES ('10217', '和平镇', '4', '10214');
INSERT INTO `tp_region` VALUES ('10218', '五大连池镇', '4', '10214');
INSERT INTO `tp_region` VALUES ('10219', '新发乡', '4', '10214');
INSERT INTO `tp_region` VALUES ('10220', '兴隆乡', '4', '10214');
INSERT INTO `tp_region` VALUES ('10221', '建设乡', '4', '10214');
INSERT INTO `tp_region` VALUES ('10222', '太平乡', '4', '10214');
INSERT INTO `tp_region` VALUES ('10223', '双泉乡', '4', '10214');
INSERT INTO `tp_region` VALUES ('10224', '团结乡', '4', '10214');
INSERT INTO `tp_region` VALUES ('10225', '兴安乡', '4', '10214');
INSERT INTO `tp_region` VALUES ('10226', '朝阳乡', '4', '10214');
INSERT INTO `tp_region` VALUES ('10227', '花园劳教所', '4', '10214');
INSERT INTO `tp_region` VALUES ('10228', '永丰监狱', '4', '10214');
INSERT INTO `tp_region` VALUES ('10229', '华山监狱', '4', '10214');
INSERT INTO `tp_region` VALUES ('10230', '凤凰山监狱', '4', '10214');
INSERT INTO `tp_region` VALUES ('10231', '元青山林场', '4', '10214');
INSERT INTO `tp_region` VALUES ('10232', '三九六林场', '4', '10214');
INSERT INTO `tp_region` VALUES ('10233', '小兴安林场', '4', '10214');
INSERT INTO `tp_region` VALUES ('10234', '二龙山林场', '4', '10214');
INSERT INTO `tp_region` VALUES ('10235', '朝阳林场', '4', '10214');
INSERT INTO `tp_region` VALUES ('10236', '引龙河林场', '4', '10214');
INSERT INTO `tp_region` VALUES ('10237', '焦得布林场', '4', '10214');
INSERT INTO `tp_region` VALUES ('10238', '沾河林业局', '4', '10214');
INSERT INTO `tp_region` VALUES ('10239', '莲花管理委员会', '4', '10214');
INSERT INTO `tp_region` VALUES ('10240', '二龙山蚕种场', '4', '10214');
INSERT INTO `tp_region` VALUES ('10241', '五大连池原种场', '4', '10214');
INSERT INTO `tp_region` VALUES ('10242', '畜牧场', '4', '10214');
INSERT INTO `tp_region` VALUES ('10243', '第二良种场', '4', '10214');
INSERT INTO `tp_region` VALUES ('10244', '龙门农场', '4', '10214');
INSERT INTO `tp_region` VALUES ('10245', '襄河农场', '4', '10214');
INSERT INTO `tp_region` VALUES ('10246', '龙镇农场', '4', '10214');
INSERT INTO `tp_region` VALUES ('10247', '二龙山农场', '4', '10214');
INSERT INTO `tp_region` VALUES ('10248', '引龙河农场', '4', '10214');
INSERT INTO `tp_region` VALUES ('10249', '尾山农场', '4', '10214');
INSERT INTO `tp_region` VALUES ('10250', '格球山农场', '4', '10214');
INSERT INTO `tp_region` VALUES ('10251', '大庆农场', '4', '10214');
INSERT INTO `tp_region` VALUES ('10252', '绥化市', '2', '8558');
INSERT INTO `tp_region` VALUES ('10253', '市辖区', '3', '10252');
INSERT INTO `tp_region` VALUES ('10254', '北林区', '3', '10252');
INSERT INTO `tp_region` VALUES ('10255', '紫来', '4', '10254');
INSERT INTO `tp_region` VALUES ('10256', '爱路', '4', '10254');
INSERT INTO `tp_region` VALUES ('10257', '大有', '4', '10254');
INSERT INTO `tp_region` VALUES ('10258', '吉泰', '4', '10254');
INSERT INTO `tp_region` VALUES ('10259', '东兴', '4', '10254');
INSERT INTO `tp_region` VALUES ('10260', '北林办事处居民委员会', '4', '10254');
INSERT INTO `tp_region` VALUES ('10261', '宝山镇', '4', '10254');
INSERT INTO `tp_region` VALUES ('10262', '绥胜镇', '4', '10254');
INSERT INTO `tp_region` VALUES ('10263', '西长发镇', '4', '10254');
INSERT INTO `tp_region` VALUES ('10264', '永安镇', '4', '10254');
INSERT INTO `tp_region` VALUES ('10265', '太平川镇', '4', '10254');
INSERT INTO `tp_region` VALUES ('10266', '秦家镇', '4', '10254');
INSERT INTO `tp_region` VALUES ('10267', '双河镇', '4', '10254');
INSERT INTO `tp_region` VALUES ('10268', '三河镇', '4', '10254');
INSERT INTO `tp_region` VALUES ('10269', '四方台镇', '4', '10254');
INSERT INTO `tp_region` VALUES ('10270', '津河镇', '4', '10254');
INSERT INTO `tp_region` VALUES ('10271', '张维镇', '4', '10254');
INSERT INTO `tp_region` VALUES ('10272', '东津镇', '4', '10254');
INSERT INTO `tp_region` VALUES ('10273', '红旗乡', '4', '10254');
INSERT INTO `tp_region` VALUES ('10274', '连岗乡', '4', '10254');
INSERT INTO `tp_region` VALUES ('10275', '新华乡', '4', '10254');
INSERT INTO `tp_region` VALUES ('10276', '兴福乡', '4', '10254');
INSERT INTO `tp_region` VALUES ('10277', '东富乡', '4', '10254');
INSERT INTO `tp_region` VALUES ('10278', '三井乡', '4', '10254');
INSERT INTO `tp_region` VALUES ('10279', '五营乡', '4', '10254');
INSERT INTO `tp_region` VALUES ('10280', '兴和乡', '4', '10254');
INSERT INTO `tp_region` VALUES ('10281', '望奎县', '3', '10252');
INSERT INTO `tp_region` VALUES ('10282', '望奎镇', '4', '10281');
INSERT INTO `tp_region` VALUES ('10283', '通江镇', '4', '10281');
INSERT INTO `tp_region` VALUES ('10284', '卫星镇', '4', '10281');
INSERT INTO `tp_region` VALUES ('10285', '海丰镇', '4', '10281');
INSERT INTO `tp_region` VALUES ('10286', '莲花镇', '4', '10281');
INSERT INTO `tp_region` VALUES ('10287', '惠七满族镇', '4', '10281');
INSERT INTO `tp_region` VALUES ('10288', '先锋镇', '4', '10281');
INSERT INTO `tp_region` VALUES ('10289', '东郊乡', '4', '10281');
INSERT INTO `tp_region` VALUES ('10290', '灵山满族乡', '4', '10281');
INSERT INTO `tp_region` VALUES ('10291', '后三乡', '4', '10281');
INSERT INTO `tp_region` VALUES ('10292', '火箭乡', '4', '10281');
INSERT INTO `tp_region` VALUES ('10293', '灯塔乡', '4', '10281');
INSERT INTO `tp_region` VALUES ('10294', '东升乡', '4', '10281');
INSERT INTO `tp_region` VALUES ('10295', '恭六乡', '4', '10281');
INSERT INTO `tp_region` VALUES ('10296', '厢白满族乡', '4', '10281');
INSERT INTO `tp_region` VALUES ('10297', '白四林场', '4', '10281');
INSERT INTO `tp_region` VALUES ('10298', '种畜场', '4', '10281');
INSERT INTO `tp_region` VALUES ('10299', '第一良种场', '4', '10281');
INSERT INTO `tp_region` VALUES ('10300', '第二良种场', '4', '10281');
INSERT INTO `tp_region` VALUES ('10301', '兰西县', '3', '10252');
INSERT INTO `tp_region` VALUES ('10302', '兰西镇', '4', '10301');
INSERT INTO `tp_region` VALUES ('10303', '榆林镇', '4', '10301');
INSERT INTO `tp_region` VALUES ('10304', '临江镇', '4', '10301');
INSERT INTO `tp_region` VALUES ('10305', '平山镇', '4', '10301');
INSERT INTO `tp_region` VALUES ('10306', '康荣乡', '4', '10301');
INSERT INTO `tp_region` VALUES ('10307', '燎原乡', '4', '10301');
INSERT INTO `tp_region` VALUES ('10308', '北安乡', '4', '10301');
INSERT INTO `tp_region` VALUES ('10309', '长江乡', '4', '10301');
INSERT INTO `tp_region` VALUES ('10310', '兰河乡', '4', '10301');
INSERT INTO `tp_region` VALUES ('10311', '红星乡', '4', '10301');
INSERT INTO `tp_region` VALUES ('10312', '红光乡', '4', '10301');
INSERT INTO `tp_region` VALUES ('10313', '长岗乡', '4', '10301');
INSERT INTO `tp_region` VALUES ('10314', '远大乡', '4', '10301');
INSERT INTO `tp_region` VALUES ('10315', '星火乡', '4', '10301');
INSERT INTO `tp_region` VALUES ('10316', '奋斗乡', '4', '10301');
INSERT INTO `tp_region` VALUES ('10317', '第一原种场', '4', '10301');
INSERT INTO `tp_region` VALUES ('10318', '第二原种场', '4', '10301');
INSERT INTO `tp_region` VALUES ('10319', '肉用种羊场', '4', '10301');
INSERT INTO `tp_region` VALUES ('10320', '青冈县', '3', '10252');
INSERT INTO `tp_region` VALUES ('10321', '青冈镇', '4', '10320');
INSERT INTO `tp_region` VALUES ('10322', '中和镇', '4', '10320');
INSERT INTO `tp_region` VALUES ('10323', '祯祥镇', '4', '10320');
INSERT INTO `tp_region` VALUES ('10324', '兴华镇', '4', '10320');
INSERT INTO `tp_region` VALUES ('10325', '永丰镇', '4', '10320');
INSERT INTO `tp_region` VALUES ('10326', '芦河镇', '4', '10320');
INSERT INTO `tp_region` VALUES ('10327', '劳动乡', '4', '10320');
INSERT INTO `tp_region` VALUES ('10328', '建设乡', '4', '10320');
INSERT INTO `tp_region` VALUES ('10329', '新村乡', '4', '10320');
INSERT INTO `tp_region` VALUES ('10330', '昌盛乡', '4', '10320');
INSERT INTO `tp_region` VALUES ('10331', '柞岗乡', '4', '10320');
INSERT INTO `tp_region` VALUES ('10332', '民政乡', '4', '10320');
INSERT INTO `tp_region` VALUES ('10333', '德胜乡', '4', '10320');
INSERT INTO `tp_region` VALUES ('10334', '迎春乡', '4', '10320');
INSERT INTO `tp_region` VALUES ('10335', '连丰乡', '4', '10320');
INSERT INTO `tp_region` VALUES ('10336', '青冈县林场', '4', '10320');
INSERT INTO `tp_region` VALUES ('10337', '青冈县互利营林站', '4', '10320');
INSERT INTO `tp_region` VALUES ('10338', '青冈县果树场', '4', '10320');
INSERT INTO `tp_region` VALUES ('10339', '青冈县种马场', '4', '10320');
INSERT INTO `tp_region` VALUES ('10340', '青冈县种羊场', '4', '10320');
INSERT INTO `tp_region` VALUES ('10341', '青冈县原种场', '4', '10320');
INSERT INTO `tp_region` VALUES ('10342', '庆安县', '3', '10252');
INSERT INTO `tp_region` VALUES ('10343', '庆安镇', '4', '10342');
INSERT INTO `tp_region` VALUES ('10344', '民乐镇', '4', '10342');
INSERT INTO `tp_region` VALUES ('10345', '大罗镇', '4', '10342');
INSERT INTO `tp_region` VALUES ('10346', '平安镇', '4', '10342');
INSERT INTO `tp_region` VALUES ('10347', '勤劳镇', '4', '10342');
INSERT INTO `tp_region` VALUES ('10348', '久胜镇', '4', '10342');
INSERT INTO `tp_region` VALUES ('10349', '建民乡', '4', '10342');
INSERT INTO `tp_region` VALUES ('10350', '巨宝山乡', '4', '10342');
INSERT INTO `tp_region` VALUES ('10351', '新胜乡', '4', '10342');
INSERT INTO `tp_region` VALUES ('10352', '丰收乡', '4', '10342');
INSERT INTO `tp_region` VALUES ('10353', '发展乡', '4', '10342');
INSERT INTO `tp_region` VALUES ('10354', '同乐乡', '4', '10342');
INSERT INTO `tp_region` VALUES ('10355', '致富乡', '4', '10342');
INSERT INTO `tp_region` VALUES ('10356', '欢胜乡', '4', '10342');
INSERT INTO `tp_region` VALUES ('10357', '国有林场管理局', '4', '10342');
INSERT INTO `tp_region` VALUES ('10358', '柳河林校', '4', '10342');
INSERT INTO `tp_region` VALUES ('10359', '柳河农场', '4', '10342');
INSERT INTO `tp_region` VALUES ('10360', '明水县', '3', '10252');
INSERT INTO `tp_region` VALUES ('10361', '明水镇', '4', '10360');
INSERT INTO `tp_region` VALUES ('10362', '兴仁镇', '4', '10360');
INSERT INTO `tp_region` VALUES ('10363', '永兴镇', '4', '10360');
INSERT INTO `tp_region` VALUES ('10364', '崇德镇', '4', '10360');
INSERT INTO `tp_region` VALUES ('10365', '通达镇', '4', '10360');
INSERT INTO `tp_region` VALUES ('10366', '双兴乡', '4', '10360');
INSERT INTO `tp_region` VALUES ('10367', '永久乡', '4', '10360');
INSERT INTO `tp_region` VALUES ('10368', '树人乡', '4', '10360');
INSERT INTO `tp_region` VALUES ('10369', '光荣乡', '4', '10360');
INSERT INTO `tp_region` VALUES ('10370', '繁荣乡', '4', '10360');
INSERT INTO `tp_region` VALUES ('10371', '通泉乡', '4', '10360');
INSERT INTO `tp_region` VALUES ('10372', '育林乡', '4', '10360');
INSERT INTO `tp_region` VALUES ('10373', '国营林场', '4', '10360');
INSERT INTO `tp_region` VALUES ('10374', '县联社马场', '4', '10360');
INSERT INTO `tp_region` VALUES ('10375', '明水种畜场', '4', '10360');
INSERT INTO `tp_region` VALUES ('10376', '育林畜牧场', '4', '10360');
INSERT INTO `tp_region` VALUES ('10377', '国营第一良种', '4', '10360');
INSERT INTO `tp_region` VALUES ('10378', '国营第二良种', '4', '10360');
INSERT INTO `tp_region` VALUES ('10379', '国营第三良种', '4', '10360');
INSERT INTO `tp_region` VALUES ('10380', '绥棱县', '3', '10252');
INSERT INTO `tp_region` VALUES ('10381', '绥棱镇', '4', '10380');
INSERT INTO `tp_region` VALUES ('10382', '上集镇', '4', '10380');
INSERT INTO `tp_region` VALUES ('10383', '四海店镇', '4', '10380');
INSERT INTO `tp_region` VALUES ('10384', '双岔河镇', '4', '10380');
INSERT INTO `tp_region` VALUES ('10385', '靠山乡', '4', '10380');
INSERT INTO `tp_region` VALUES ('10386', '后头乡', '4', '10380');
INSERT INTO `tp_region` VALUES ('10387', '长山乡', '4', '10380');
INSERT INTO `tp_region` VALUES ('10388', '克音河乡', '4', '10380');
INSERT INTO `tp_region` VALUES ('10389', '绥中乡', '4', '10380');
INSERT INTO `tp_region` VALUES ('10390', '泥尔河乡', '4', '10380');
INSERT INTO `tp_region` VALUES ('10391', '阁山乡', '4', '10380');
INSERT INTO `tp_region` VALUES ('10392', '阁山林场', '4', '10380');
INSERT INTO `tp_region` VALUES ('10393', '四海店林场', '4', '10380');
INSERT INTO `tp_region` VALUES ('10394', '三吉台林场', '4', '10380');
INSERT INTO `tp_region` VALUES ('10395', '半截河林场', '4', '10380');
INSERT INTO `tp_region` VALUES ('10396', '绥棱林业局', '4', '10380');
INSERT INTO `tp_region` VALUES ('10397', '绥棱农场', '4', '10380');
INSERT INTO `tp_region` VALUES ('10398', '种马场', '4', '10380');
INSERT INTO `tp_region` VALUES ('10399', '良种场', '4', '10380');
INSERT INTO `tp_region` VALUES ('10400', '奶山羊场', '4', '10380');
INSERT INTO `tp_region` VALUES ('10401', '安达市', '3', '10252');
INSERT INTO `tp_region` VALUES ('10402', '铁西街道', '4', '10401');
INSERT INTO `tp_region` VALUES ('10403', '新兴街道', '4', '10401');
INSERT INTO `tp_region` VALUES ('10404', '安虹街道', '4', '10401');
INSERT INTO `tp_region` VALUES ('10405', '安达镇', '4', '10401');
INSERT INTO `tp_region` VALUES ('10406', '任民镇', '4', '10401');
INSERT INTO `tp_region` VALUES ('10407', '万宝山镇', '4', '10401');
INSERT INTO `tp_region` VALUES ('10408', '昌德镇', '4', '10401');
INSERT INTO `tp_region` VALUES ('10409', '升平镇', '4', '10401');
INSERT INTO `tp_region` VALUES ('10410', '羊草镇', '4', '10401');
INSERT INTO `tp_region` VALUES ('10411', '老虎岗镇', '4', '10401');
INSERT INTO `tp_region` VALUES ('10412', '中本镇', '4', '10401');
INSERT INTO `tp_region` VALUES ('10413', '太平庄镇', '4', '10401');
INSERT INTO `tp_region` VALUES ('10414', '吉兴岗镇', '4', '10401');
INSERT INTO `tp_region` VALUES ('10415', '火石山乡', '4', '10401');
INSERT INTO `tp_region` VALUES ('10416', '卧里屯乡', '4', '10401');
INSERT INTO `tp_region` VALUES ('10417', '青肯泡乡', '4', '10401');
INSERT INTO `tp_region` VALUES ('10418', '先源乡', '4', '10401');
INSERT INTO `tp_region` VALUES ('10419', '安达畜牧场', '4', '10401');
INSERT INTO `tp_region` VALUES ('10420', '种畜场', '4', '10401');
INSERT INTO `tp_region` VALUES ('10421', '原种场', '4', '10401');
INSERT INTO `tp_region` VALUES ('10422', '种牛场', '4', '10401');
INSERT INTO `tp_region` VALUES ('10423', '红旗泡水库管理所', '4', '10401');
INSERT INTO `tp_region` VALUES ('10424', '东湖水库管理站', '4', '10401');
INSERT INTO `tp_region` VALUES ('10425', '肇东市', '3', '10252');
INSERT INTO `tp_region` VALUES ('10426', '朝阳区', '4', '10425');
INSERT INTO `tp_region` VALUES ('10427', '东升区', '4', '10425');
INSERT INTO `tp_region` VALUES ('10428', '西园区', '4', '10425');
INSERT INTO `tp_region` VALUES ('10429', '正阳区', '4', '10425');
INSERT INTO `tp_region` VALUES ('10430', '肇东镇', '4', '10425');
INSERT INTO `tp_region` VALUES ('10431', '昌五镇', '4', '10425');
INSERT INTO `tp_region` VALUES ('10432', '宋站镇', '4', '10425');
INSERT INTO `tp_region` VALUES ('10433', '五站镇', '4', '10425');
INSERT INTO `tp_region` VALUES ('10434', '尚家镇', '4', '10425');
INSERT INTO `tp_region` VALUES ('10435', '姜家镇', '4', '10425');
INSERT INTO `tp_region` VALUES ('10436', '里木店镇', '4', '10425');
INSERT INTO `tp_region` VALUES ('10437', '四站镇', '4', '10425');
INSERT INTO `tp_region` VALUES ('10438', '涝洲镇', '4', '10425');
INSERT INTO `tp_region` VALUES ('10439', '五里明镇', '4', '10425');
INSERT INTO `tp_region` VALUES ('10440', '黎明镇', '4', '10425');
INSERT INTO `tp_region` VALUES ('10441', '太平乡', '4', '10425');
INSERT INTO `tp_region` VALUES ('10442', '海城乡', '4', '10425');
INSERT INTO `tp_region` VALUES ('10443', '向阳乡', '4', '10425');
INSERT INTO `tp_region` VALUES ('10444', '洪河乡', '4', '10425');
INSERT INTO `tp_region` VALUES ('10445', '跃进乡', '4', '10425');
INSERT INTO `tp_region` VALUES ('10446', '西八里乡', '4', '10425');
INSERT INTO `tp_region` VALUES ('10447', '德昌乡', '4', '10425');
INSERT INTO `tp_region` VALUES ('10448', '宣化乡', '4', '10425');
INSERT INTO `tp_region` VALUES ('10449', '安民乡', '4', '10425');
INSERT INTO `tp_region` VALUES ('10450', '明久乡', '4', '10425');
INSERT INTO `tp_region` VALUES ('10451', '四方山农场', '4', '10425');
INSERT INTO `tp_region` VALUES ('10452', '海伦市', '3', '10252');
INSERT INTO `tp_region` VALUES ('10453', '海伦镇', '4', '10452');
INSERT INTO `tp_region` VALUES ('10454', '海北镇', '4', '10452');
INSERT INTO `tp_region` VALUES ('10455', '伦河镇', '4', '10452');
INSERT INTO `tp_region` VALUES ('10456', '共合镇', '4', '10452');
INSERT INTO `tp_region` VALUES ('10457', '海兴镇', '4', '10452');
INSERT INTO `tp_region` VALUES ('10458', '祥富镇', '4', '10452');
INSERT INTO `tp_region` VALUES ('10459', '东风镇', '4', '10452');
INSERT INTO `tp_region` VALUES ('10460', '前进乡', '4', '10452');
INSERT INTO `tp_region` VALUES ('10461', '向荣乡', '4', '10452');
INSERT INTO `tp_region` VALUES ('10462', '长发乡', '4', '10452');
INSERT INTO `tp_region` VALUES ('10463', '东林乡', '4', '10452');
INSERT INTO `tp_region` VALUES ('10464', '海南乡', '4', '10452');
INSERT INTO `tp_region` VALUES ('10465', '共荣乡', '4', '10452');
INSERT INTO `tp_region` VALUES ('10466', '乐业乡', '4', '10452');
INSERT INTO `tp_region` VALUES ('10467', '福民乡', '4', '10452');
INSERT INTO `tp_region` VALUES ('10468', '丰山乡', '4', '10452');
INSERT INTO `tp_region` VALUES ('10469', '永富乡', '4', '10452');
INSERT INTO `tp_region` VALUES ('10470', '百祥乡', '4', '10452');
INSERT INTO `tp_region` VALUES ('10471', '联发乡', '4', '10452');
INSERT INTO `tp_region` VALUES ('10472', '永和乡', '4', '10452');
INSERT INTO `tp_region` VALUES ('10473', '爱民乡', '4', '10452');
INSERT INTO `tp_region` VALUES ('10474', '扎音河乡', '4', '10452');
INSERT INTO `tp_region` VALUES ('10475', '双录乡', '4', '10452');
INSERT INTO `tp_region` VALUES ('10476', '林场公司', '4', '10452');
INSERT INTO `tp_region` VALUES ('10477', '东方红水库地区', '4', '10452');
INSERT INTO `tp_region` VALUES ('10478', '海伦农场', '4', '10452');
INSERT INTO `tp_region` VALUES ('10479', '红光农场', '4', '10452');
INSERT INTO `tp_region` VALUES ('10480', '海伦绥化种畜场', '4', '10452');
INSERT INTO `tp_region` VALUES ('10481', '海伦二粮种场', '4', '10452');
INSERT INTO `tp_region` VALUES ('10482', '海伦市种畜场', '4', '10452');
INSERT INTO `tp_region` VALUES ('10483', '大兴安岭地区', '2', '8558');
INSERT INTO `tp_region` VALUES ('10484', '加格达奇区', '3', '10483');
INSERT INTO `tp_region` VALUES ('10485', '街道东山社区', '4', '10484');
INSERT INTO `tp_region` VALUES ('10486', '街道卫东社区', '4', '10484');
INSERT INTO `tp_region` VALUES ('10487', '街道红旗社区', '4', '10484');
INSERT INTO `tp_region` VALUES ('10488', '街道长虹社区', '4', '10484');
INSERT INTO `tp_region` VALUES ('10489', '街道曙光社区', '4', '10484');
INSERT INTO `tp_region` VALUES ('10490', '街道光明社区', '4', '10484');
INSERT INTO `tp_region` VALUES ('10491', '加北乡', '4', '10484');
INSERT INTO `tp_region` VALUES ('10492', '白桦乡', '4', '10484');
INSERT INTO `tp_region` VALUES ('10493', '加格达奇林业局', '4', '10484');
INSERT INTO `tp_region` VALUES ('10494', '林田农业开发区', '4', '10484');
INSERT INTO `tp_region` VALUES ('10495', '松岭区', '3', '10483');
INSERT INTO `tp_region` VALUES ('10496', '小扬气镇', '4', '10495');
INSERT INTO `tp_region` VALUES ('10497', '劲松镇', '4', '10495');
INSERT INTO `tp_region` VALUES ('10498', '古源镇', '4', '10495');
INSERT INTO `tp_region` VALUES ('10499', '松岭林业局', '4', '10495');
INSERT INTO `tp_region` VALUES ('10500', '新林区', '3', '10483');
INSERT INTO `tp_region` VALUES ('10501', '新林镇', '4', '10500');
INSERT INTO `tp_region` VALUES ('10502', '翠岗镇', '4', '10500');
INSERT INTO `tp_region` VALUES ('10503', '塔源镇', '4', '10500');
INSERT INTO `tp_region` VALUES ('10504', '大乌苏镇', '4', '10500');
INSERT INTO `tp_region` VALUES ('10505', '塔尔根镇', '4', '10500');
INSERT INTO `tp_region` VALUES ('10506', '碧洲镇', '4', '10500');
INSERT INTO `tp_region` VALUES ('10507', '宏图镇', '4', '10500');
INSERT INTO `tp_region` VALUES ('10508', '新林林业局', '4', '10500');
INSERT INTO `tp_region` VALUES ('10509', '呼中区', '3', '10483');
INSERT INTO `tp_region` VALUES ('10510', '呼中镇', '4', '10509');
INSERT INTO `tp_region` VALUES ('10511', '碧水镇', '4', '10509');
INSERT INTO `tp_region` VALUES ('10512', '呼源镇', '4', '10509');
INSERT INTO `tp_region` VALUES ('10513', '宏伟镇', '4', '10509');
INSERT INTO `tp_region` VALUES ('10514', '呼中林业局', '4', '10509');
INSERT INTO `tp_region` VALUES ('10515', '呼玛县', '3', '10483');
INSERT INTO `tp_region` VALUES ('10516', '呼玛镇', '4', '10515');
INSERT INTO `tp_region` VALUES ('10517', '韩家园镇', '4', '10515');
INSERT INTO `tp_region` VALUES ('10518', '三卡乡', '4', '10515');
INSERT INTO `tp_region` VALUES ('10519', '金山乡', '4', '10515');
INSERT INTO `tp_region` VALUES ('10520', '兴华乡', '4', '10515');
INSERT INTO `tp_region` VALUES ('10521', '鸥浦乡', '4', '10515');
INSERT INTO `tp_region` VALUES ('10522', '白银纳鄂伦春族民族乡', '4', '10515');
INSERT INTO `tp_region` VALUES ('10523', '北疆乡', '4', '10515');
INSERT INTO `tp_region` VALUES ('10524', '韩家园林业局', '4', '10515');
INSERT INTO `tp_region` VALUES ('10525', '塔河县', '3', '10483');
INSERT INTO `tp_region` VALUES ('10526', '塔河镇', '4', '10525');
INSERT INTO `tp_region` VALUES ('10527', '瓦拉干镇', '4', '10525');
INSERT INTO `tp_region` VALUES ('10528', '盘古镇', '4', '10525');
INSERT INTO `tp_region` VALUES ('10529', '十八站鄂伦春族民族乡', '4', '10525');
INSERT INTO `tp_region` VALUES ('10530', '依西肯乡', '4', '10525');
INSERT INTO `tp_region` VALUES ('10531', '开库康乡', '4', '10525');
INSERT INTO `tp_region` VALUES ('10532', '十八站林业局', '4', '10525');
INSERT INTO `tp_region` VALUES ('10533', '塔河林业局', '4', '10525');
INSERT INTO `tp_region` VALUES ('10534', '漠河县', '3', '10483');
INSERT INTO `tp_region` VALUES ('10535', '西林吉镇', '4', '10534');
INSERT INTO `tp_region` VALUES ('10536', '图强镇', '4', '10534');
INSERT INTO `tp_region` VALUES ('10537', '劲涛镇', '4', '10534');
INSERT INTO `tp_region` VALUES ('10538', '兴安镇', '4', '10534');
INSERT INTO `tp_region` VALUES ('10539', '北极乡', '4', '10534');
INSERT INTO `tp_region` VALUES ('10540', '西林吉林业局', '4', '10534');
INSERT INTO `tp_region` VALUES ('10541', '图强林业局', '4', '10534');
INSERT INTO `tp_region` VALUES ('10542', '阿木尔林业局', '4', '10534');
INSERT INTO `tp_region` VALUES ('10543', '上海市', '1', '0');
INSERT INTO `tp_region` VALUES ('10544', '市辖区', '2', '10543');
INSERT INTO `tp_region` VALUES ('10545', '黄浦区', '3', '10544');
INSERT INTO `tp_region` VALUES ('10546', '南京东路街道', '4', '10545');
INSERT INTO `tp_region` VALUES ('10547', '金陵东路街道', '4', '10545');
INSERT INTO `tp_region` VALUES ('10548', '外滩街道', '4', '10545');
INSERT INTO `tp_region` VALUES ('10549', '人民广场街道', '4', '10545');
INSERT INTO `tp_region` VALUES ('10550', '半淞园路街道', '4', '10545');
INSERT INTO `tp_region` VALUES ('10551', '董家渡街道', '4', '10545');
INSERT INTO `tp_region` VALUES ('10552', '小东门街道', '4', '10545');
INSERT INTO `tp_region` VALUES ('10553', '豫园街道', '4', '10545');
INSERT INTO `tp_region` VALUES ('10554', '老西门街道', '4', '10545');
INSERT INTO `tp_region` VALUES ('10555', '卢湾区', '3', '10544');
INSERT INTO `tp_region` VALUES ('10556', '五里桥街道', '4', '10555');
INSERT INTO `tp_region` VALUES ('10557', '打浦桥街道', '4', '10555');
INSERT INTO `tp_region` VALUES ('10558', '淮海中路街道', '4', '10555');
INSERT INTO `tp_region` VALUES ('10559', '瑞金二路街道', '4', '10555');
INSERT INTO `tp_region` VALUES ('10560', '徐汇区', '3', '10544');
INSERT INTO `tp_region` VALUES ('10561', '天平路街道', '4', '10560');
INSERT INTO `tp_region` VALUES ('10562', '湖南路街道', '4', '10560');
INSERT INTO `tp_region` VALUES ('10563', '斜土路街道', '4', '10560');
INSERT INTO `tp_region` VALUES ('10564', '枫林路街道', '4', '10560');
INSERT INTO `tp_region` VALUES ('10565', '长桥街道', '4', '10560');
INSERT INTO `tp_region` VALUES ('10566', '田林街道', '4', '10560');
INSERT INTO `tp_region` VALUES ('10567', '虹梅路街道', '4', '10560');
INSERT INTO `tp_region` VALUES ('10568', '康健新村街道', '4', '10560');
INSERT INTO `tp_region` VALUES ('10569', '徐家汇街道', '4', '10560');
INSERT INTO `tp_region` VALUES ('10570', '凌云路街道', '4', '10560');
INSERT INTO `tp_region` VALUES ('10571', '龙华街道', '4', '10560');
INSERT INTO `tp_region` VALUES ('10572', '漕河泾街道', '4', '10560');
INSERT INTO `tp_region` VALUES ('10573', '华泾镇', '4', '10560');
INSERT INTO `tp_region` VALUES ('10574', '漕河泾新兴技术开发区', '4', '10560');
INSERT INTO `tp_region` VALUES ('10575', '长宁区', '3', '10544');
INSERT INTO `tp_region` VALUES ('10576', '华阳路街道', '4', '10575');
INSERT INTO `tp_region` VALUES ('10577', '江苏路街道', '4', '10575');
INSERT INTO `tp_region` VALUES ('10578', '新华路街道', '4', '10575');
INSERT INTO `tp_region` VALUES ('10579', '周家桥街道', '4', '10575');
INSERT INTO `tp_region` VALUES ('10580', '天山路街道', '4', '10575');
INSERT INTO `tp_region` VALUES ('10581', '仙霞新村街道', '4', '10575');
INSERT INTO `tp_region` VALUES ('10582', '虹桥街道', '4', '10575');
INSERT INTO `tp_region` VALUES ('10583', '程家桥街道', '4', '10575');
INSERT INTO `tp_region` VALUES ('10584', '北新泾街道', '4', '10575');
INSERT INTO `tp_region` VALUES ('10585', '新泾镇', '4', '10575');
INSERT INTO `tp_region` VALUES ('10586', '静安区', '3', '10544');
INSERT INTO `tp_region` VALUES ('10587', '江宁路街道', '4', '10586');
INSERT INTO `tp_region` VALUES ('10588', '石门二路街道', '4', '10586');
INSERT INTO `tp_region` VALUES ('10589', '南京西路街道', '4', '10586');
INSERT INTO `tp_region` VALUES ('10590', '静安寺街道', '4', '10586');
INSERT INTO `tp_region` VALUES ('10591', '曹家渡街道', '4', '10586');
INSERT INTO `tp_region` VALUES ('10592', '普陀区', '3', '10544');
INSERT INTO `tp_region` VALUES ('10593', '曹杨新村街道', '4', '10592');
INSERT INTO `tp_region` VALUES ('10594', '长风新村街道', '4', '10592');
INSERT INTO `tp_region` VALUES ('10595', '长寿路街道', '4', '10592');
INSERT INTO `tp_region` VALUES ('10596', '甘泉路街道', '4', '10592');
INSERT INTO `tp_region` VALUES ('10597', '石泉路街道', '4', '10592');
INSERT INTO `tp_region` VALUES ('10598', '宜川路街道', '4', '10592');
INSERT INTO `tp_region` VALUES ('10599', '真如镇', '4', '10592');
INSERT INTO `tp_region` VALUES ('10600', '长征镇', '4', '10592');
INSERT INTO `tp_region` VALUES ('10601', '桃浦镇', '4', '10592');
INSERT INTO `tp_region` VALUES ('10602', '闸北区', '3', '10544');
INSERT INTO `tp_region` VALUES ('10603', '天目西路街道', '4', '10602');
INSERT INTO `tp_region` VALUES ('10604', '北站街道', '4', '10602');
INSERT INTO `tp_region` VALUES ('10605', '宝山路街道', '4', '10602');
INSERT INTO `tp_region` VALUES ('10606', '共和新路街道', '4', '10602');
INSERT INTO `tp_region` VALUES ('10607', '大宁路街道', '4', '10602');
INSERT INTO `tp_region` VALUES ('10608', '彭浦新村街道', '4', '10602');
INSERT INTO `tp_region` VALUES ('10609', '临汾路街道', '4', '10602');
INSERT INTO `tp_region` VALUES ('10610', '芷江西路街道', '4', '10602');
INSERT INTO `tp_region` VALUES ('10611', '彭浦镇', '4', '10602');
INSERT INTO `tp_region` VALUES ('10612', '虹口区', '3', '10544');
INSERT INTO `tp_region` VALUES ('10613', '乍浦路街道', '4', '10612');
INSERT INTO `tp_region` VALUES ('10614', '新港路街道', '4', '10612');
INSERT INTO `tp_region` VALUES ('10615', '欧阳路街道', '4', '10612');
INSERT INTO `tp_region` VALUES ('10616', '曲阳路街道', '4', '10612');
INSERT INTO `tp_region` VALUES ('10617', '广中路街道', '4', '10612');
INSERT INTO `tp_region` VALUES ('10618', '嘉兴路街道', '4', '10612');
INSERT INTO `tp_region` VALUES ('10619', '凉城新村街道', '4', '10612');
INSERT INTO `tp_region` VALUES ('10620', '四川北路街道', '4', '10612');
INSERT INTO `tp_region` VALUES ('10621', '提篮桥街道', '4', '10612');
INSERT INTO `tp_region` VALUES ('10622', '江湾镇', '4', '10612');
INSERT INTO `tp_region` VALUES ('10623', '杨浦区', '3', '10544');
INSERT INTO `tp_region` VALUES ('10624', '定海路街道', '4', '10623');
INSERT INTO `tp_region` VALUES ('10625', '平凉路街道', '4', '10623');
INSERT INTO `tp_region` VALUES ('10626', '江浦路街道', '4', '10623');
INSERT INTO `tp_region` VALUES ('10627', '四平路街道', '4', '10623');
INSERT INTO `tp_region` VALUES ('10628', '控江路街道', '4', '10623');
INSERT INTO `tp_region` VALUES ('10629', '长白新村街道', '4', '10623');
INSERT INTO `tp_region` VALUES ('10630', '延吉新村街道', '4', '10623');
INSERT INTO `tp_region` VALUES ('10631', '殷行街道', '4', '10623');
INSERT INTO `tp_region` VALUES ('10632', '大桥街道', '4', '10623');
INSERT INTO `tp_region` VALUES ('10633', '五角场街道', '4', '10623');
INSERT INTO `tp_region` VALUES ('10634', '新江湾城街道', '4', '10623');
INSERT INTO `tp_region` VALUES ('10635', '五角场镇', '4', '10623');
INSERT INTO `tp_region` VALUES ('10636', '闵行区', '3', '10544');
INSERT INTO `tp_region` VALUES ('10637', '江川路街道', '4', '10636');
INSERT INTO `tp_region` VALUES ('10638', '龙柏街道', '4', '10636');
INSERT INTO `tp_region` VALUES ('10639', '古美街道', '4', '10636');
INSERT INTO `tp_region` VALUES ('10640', '莘庄镇', '4', '10636');
INSERT INTO `tp_region` VALUES ('10641', '七宝镇', '4', '10636');
INSERT INTO `tp_region` VALUES ('10642', '颛桥镇', '4', '10636');
INSERT INTO `tp_region` VALUES ('10643', '华漕镇', '4', '10636');
INSERT INTO `tp_region` VALUES ('10644', '虹桥镇', '4', '10636');
INSERT INTO `tp_region` VALUES ('10645', '梅陇镇', '4', '10636');
INSERT INTO `tp_region` VALUES ('10646', '吴泾镇', '4', '10636');
INSERT INTO `tp_region` VALUES ('10647', '马桥镇', '4', '10636');
INSERT INTO `tp_region` VALUES ('10648', '浦江镇', '4', '10636');
INSERT INTO `tp_region` VALUES ('10649', '莘庄工业区', '4', '10636');
INSERT INTO `tp_region` VALUES ('10650', '宝山区', '3', '10544');
INSERT INTO `tp_region` VALUES ('10651', '友谊路街道', '4', '10650');
INSERT INTO `tp_region` VALUES ('10652', '吴淞街道', '4', '10650');
INSERT INTO `tp_region` VALUES ('10653', '张庙街道', '4', '10650');
INSERT INTO `tp_region` VALUES ('10654', '罗店镇', '4', '10650');
INSERT INTO `tp_region` VALUES ('10655', '大场镇', '4', '10650');
INSERT INTO `tp_region` VALUES ('10656', '杨行镇', '4', '10650');
INSERT INTO `tp_region` VALUES ('10657', '月浦镇', '4', '10650');
INSERT INTO `tp_region` VALUES ('10658', '罗泾镇', '4', '10650');
INSERT INTO `tp_region` VALUES ('10659', '顾村镇', '4', '10650');
INSERT INTO `tp_region` VALUES ('10660', '高境镇', '4', '10650');
INSERT INTO `tp_region` VALUES ('10661', '庙行镇', '4', '10650');
INSERT INTO `tp_region` VALUES ('10662', '淞南镇', '4', '10650');
INSERT INTO `tp_region` VALUES ('10663', '宝山城市工业园区', '4', '10650');
INSERT INTO `tp_region` VALUES ('10664', '嘉定区', '3', '10544');
INSERT INTO `tp_region` VALUES ('10665', '新成路街道', '4', '10664');
INSERT INTO `tp_region` VALUES ('10666', '真新新村街道', '4', '10664');
INSERT INTO `tp_region` VALUES ('10667', '菊园新区', '4', '10664');
INSERT INTO `tp_region` VALUES ('10668', '嘉定镇街道', '4', '10664');
INSERT INTO `tp_region` VALUES ('10669', '南翔镇', '4', '10664');
INSERT INTO `tp_region` VALUES ('10670', '安亭镇', '4', '10664');
INSERT INTO `tp_region` VALUES ('10671', '马陆镇', '4', '10664');
INSERT INTO `tp_region` VALUES ('10672', '徐行镇', '4', '10664');
INSERT INTO `tp_region` VALUES ('10673', '华亭镇', '4', '10664');
INSERT INTO `tp_region` VALUES ('10674', '外冈镇', '4', '10664');
INSERT INTO `tp_region` VALUES ('10675', '黄渡镇', '4', '10664');
INSERT INTO `tp_region` VALUES ('10676', '江桥镇', '4', '10664');
INSERT INTO `tp_region` VALUES ('10677', '嘉定工业区', '4', '10664');
INSERT INTO `tp_region` VALUES ('10678', '浦东新区', '3', '10544');
INSERT INTO `tp_region` VALUES ('10679', '潍坊新村街道', '4', '10678');
INSERT INTO `tp_region` VALUES ('10680', '陆家嘴街道', '4', '10678');
INSERT INTO `tp_region` VALUES ('10681', '周家渡街道', '4', '10678');
INSERT INTO `tp_region` VALUES ('10682', '塘桥街道', '4', '10678');
INSERT INTO `tp_region` VALUES ('10683', '上钢新村街道', '4', '10678');
INSERT INTO `tp_region` VALUES ('10684', '南码头路街道', '4', '10678');
INSERT INTO `tp_region` VALUES ('10685', '沪东新村街道', '4', '10678');
INSERT INTO `tp_region` VALUES ('10686', '金杨新村街道', '4', '10678');
INSERT INTO `tp_region` VALUES ('10687', '洋泾街道', '4', '10678');
INSERT INTO `tp_region` VALUES ('10688', '浦兴路街道', '4', '10678');
INSERT INTO `tp_region` VALUES ('10689', '东明路街道', '4', '10678');
INSERT INTO `tp_region` VALUES ('10690', '花木街道', '4', '10678');
INSERT INTO `tp_region` VALUES ('10691', '川沙新镇', '4', '10678');
INSERT INTO `tp_region` VALUES ('10692', '高桥镇', '4', '10678');
INSERT INTO `tp_region` VALUES ('10693', '北蔡镇', '4', '10678');
INSERT INTO `tp_region` VALUES ('10694', '合庆镇', '4', '10678');
INSERT INTO `tp_region` VALUES ('10695', '唐镇', '4', '10678');
INSERT INTO `tp_region` VALUES ('10696', '曹路镇', '4', '10678');
INSERT INTO `tp_region` VALUES ('10697', '金桥镇', '4', '10678');
INSERT INTO `tp_region` VALUES ('10698', '高行镇', '4', '10678');
INSERT INTO `tp_region` VALUES ('10699', '高东镇', '4', '10678');
INSERT INTO `tp_region` VALUES ('10700', '张江镇', '4', '10678');
INSERT INTO `tp_region` VALUES ('10701', '三林镇', '4', '10678');
INSERT INTO `tp_region` VALUES ('10702', '外高桥保税区', '4', '10678');
INSERT INTO `tp_region` VALUES ('10703', '金桥出口加工区', '4', '10678');
INSERT INTO `tp_region` VALUES ('10704', '金山区', '3', '10544');
INSERT INTO `tp_region` VALUES ('10705', '石化街道', '4', '10704');
INSERT INTO `tp_region` VALUES ('10706', '朱泾镇', '4', '10704');
INSERT INTO `tp_region` VALUES ('10707', '枫泾镇', '4', '10704');
INSERT INTO `tp_region` VALUES ('10708', '张堰镇', '4', '10704');
INSERT INTO `tp_region` VALUES ('10709', '亭林镇', '4', '10704');
INSERT INTO `tp_region` VALUES ('10710', '吕巷镇', '4', '10704');
INSERT INTO `tp_region` VALUES ('10711', '廊下镇', '4', '10704');
INSERT INTO `tp_region` VALUES ('10712', '金山卫镇', '4', '10704');
INSERT INTO `tp_region` VALUES ('10713', '漕泾镇', '4', '10704');
INSERT INTO `tp_region` VALUES ('10714', '山阳镇', '4', '10704');
INSERT INTO `tp_region` VALUES ('10715', '松江区', '3', '10544');
INSERT INTO `tp_region` VALUES ('10716', '岳阳街道', '4', '10715');
INSERT INTO `tp_region` VALUES ('10717', '永丰街道', '4', '10715');
INSERT INTO `tp_region` VALUES ('10718', '方松街道', '4', '10715');
INSERT INTO `tp_region` VALUES ('10719', '中山街道', '4', '10715');
INSERT INTO `tp_region` VALUES ('10720', '泗泾镇', '4', '10715');
INSERT INTO `tp_region` VALUES ('10721', '佘山镇', '4', '10715');
INSERT INTO `tp_region` VALUES ('10722', '车墩镇', '4', '10715');
INSERT INTO `tp_region` VALUES ('10723', '新桥镇', '4', '10715');
INSERT INTO `tp_region` VALUES ('10724', '洞泾镇', '4', '10715');
INSERT INTO `tp_region` VALUES ('10725', '九亭镇', '4', '10715');
INSERT INTO `tp_region` VALUES ('10726', '泖港镇', '4', '10715');
INSERT INTO `tp_region` VALUES ('10727', '石湖荡镇', '4', '10715');
INSERT INTO `tp_region` VALUES ('10728', '新浜镇', '4', '10715');
INSERT INTO `tp_region` VALUES ('10729', '叶榭镇', '4', '10715');
INSERT INTO `tp_region` VALUES ('10730', '松江工业区', '4', '10715');
INSERT INTO `tp_region` VALUES ('10731', '佘山度假区', '4', '10715');
INSERT INTO `tp_region` VALUES ('10732', '五厍农业园区', '4', '10715');
INSERT INTO `tp_region` VALUES ('10733', '上海松江科技园区', '4', '10715');
INSERT INTO `tp_region` VALUES ('10734', '上海松江出口加工区', '4', '10715');
INSERT INTO `tp_region` VALUES ('10735', '青浦区', '3', '10544');
INSERT INTO `tp_region` VALUES ('10736', '夏阳街道', '4', '10735');
INSERT INTO `tp_region` VALUES ('10737', '盈浦街道', '4', '10735');
INSERT INTO `tp_region` VALUES ('10738', '香花桥街道', '4', '10735');
INSERT INTO `tp_region` VALUES ('10739', '朱家角镇', '4', '10735');
INSERT INTO `tp_region` VALUES ('10740', '练塘镇', '4', '10735');
INSERT INTO `tp_region` VALUES ('10741', '金泽镇', '4', '10735');
INSERT INTO `tp_region` VALUES ('10742', '赵巷镇', '4', '10735');
INSERT INTO `tp_region` VALUES ('10743', '徐泾镇', '4', '10735');
INSERT INTO `tp_region` VALUES ('10744', '华新镇', '4', '10735');
INSERT INTO `tp_region` VALUES ('10745', '重固镇', '4', '10735');
INSERT INTO `tp_region` VALUES ('10746', '白鹤镇', '4', '10735');
INSERT INTO `tp_region` VALUES ('10747', '南汇区', '3', '10544');
INSERT INTO `tp_region` VALUES ('10748', '惠南镇', '4', '10747');
INSERT INTO `tp_region` VALUES ('10749', '周浦镇', '4', '10747');
INSERT INTO `tp_region` VALUES ('10750', '新场镇', '4', '10747');
INSERT INTO `tp_region` VALUES ('10751', '大团镇', '4', '10747');
INSERT INTO `tp_region` VALUES ('10752', '芦潮港镇', '4', '10747');
INSERT INTO `tp_region` VALUES ('10753', '康桥镇', '4', '10747');
INSERT INTO `tp_region` VALUES ('10754', '航头镇', '4', '10747');
INSERT INTO `tp_region` VALUES ('10755', '六灶镇', '4', '10747');
INSERT INTO `tp_region` VALUES ('10756', '祝桥镇', '4', '10747');
INSERT INTO `tp_region` VALUES ('10757', '泥城镇', '4', '10747');
INSERT INTO `tp_region` VALUES ('10758', '宣桥镇', '4', '10747');
INSERT INTO `tp_region` VALUES ('10759', '书院镇', '4', '10747');
INSERT INTO `tp_region` VALUES ('10760', '万祥镇', '4', '10747');
INSERT INTO `tp_region` VALUES ('10761', '老港镇', '4', '10747');
INSERT INTO `tp_region` VALUES ('10762', '芦潮港农场', '4', '10747');
INSERT INTO `tp_region` VALUES ('10763', '东海农场', '4', '10747');
INSERT INTO `tp_region` VALUES ('10764', '朝阳农场', '4', '10747');
INSERT INTO `tp_region` VALUES ('10765', '奉贤区', '3', '10544');
INSERT INTO `tp_region` VALUES ('10766', '南桥镇', '4', '10765');
INSERT INTO `tp_region` VALUES ('10767', '奉城镇', '4', '10765');
INSERT INTO `tp_region` VALUES ('10768', '庄行镇', '4', '10765');
INSERT INTO `tp_region` VALUES ('10769', '金汇镇', '4', '10765');
INSERT INTO `tp_region` VALUES ('10770', '四团镇', '4', '10765');
INSERT INTO `tp_region` VALUES ('10771', '青村镇', '4', '10765');
INSERT INTO `tp_region` VALUES ('10772', '柘林镇', '4', '10765');
INSERT INTO `tp_region` VALUES ('10773', '海湾镇', '4', '10765');
INSERT INTO `tp_region` VALUES ('10774', '上海工业综合开发区', '4', '10765');
INSERT INTO `tp_region` VALUES ('10775', '上海化学工业区奉贤分区', '4', '10765');
INSERT INTO `tp_region` VALUES ('10776', '海湾旅游区', '4', '10765');
INSERT INTO `tp_region` VALUES ('10777', '奉贤区现代农业园区', '4', '10765');
INSERT INTO `tp_region` VALUES ('10778', '上海海港综合经济开发区', '4', '10765');
INSERT INTO `tp_region` VALUES ('10779', '县', '2', '10543');
INSERT INTO `tp_region` VALUES ('10780', '崇明县', '3', '10779');
INSERT INTO `tp_region` VALUES ('10781', '城桥镇', '4', '10780');
INSERT INTO `tp_region` VALUES ('10782', '堡镇', '4', '10780');
INSERT INTO `tp_region` VALUES ('10783', '新河镇', '4', '10780');
INSERT INTO `tp_region` VALUES ('10784', '庙镇', '4', '10780');
INSERT INTO `tp_region` VALUES ('10785', '竖新镇', '4', '10780');
INSERT INTO `tp_region` VALUES ('10786', '向化镇', '4', '10780');
INSERT INTO `tp_region` VALUES ('10787', '三星镇', '4', '10780');
INSERT INTO `tp_region` VALUES ('10788', '港沿镇', '4', '10780');
INSERT INTO `tp_region` VALUES ('10789', '中兴镇', '4', '10780');
INSERT INTO `tp_region` VALUES ('10790', '陈家镇', '4', '10780');
INSERT INTO `tp_region` VALUES ('10791', '绿华镇', '4', '10780');
INSERT INTO `tp_region` VALUES ('10792', '港西镇', '4', '10780');
INSERT INTO `tp_region` VALUES ('10793', '建设镇', '4', '10780');
INSERT INTO `tp_region` VALUES ('10794', '新村乡', '4', '10780');
INSERT INTO `tp_region` VALUES ('10795', '长兴乡', '4', '10780');
INSERT INTO `tp_region` VALUES ('10796', '横沙乡', '4', '10780');
INSERT INTO `tp_region` VALUES ('10797', '跃进农场', '4', '10780');
INSERT INTO `tp_region` VALUES ('10798', '新海农场', '4', '10780');
INSERT INTO `tp_region` VALUES ('10799', '红星农场', '4', '10780');
INSERT INTO `tp_region` VALUES ('10800', '长征农场', '4', '10780');
INSERT INTO `tp_region` VALUES ('10801', '东风农场', '4', '10780');
INSERT INTO `tp_region` VALUES ('10802', '长江农场', '4', '10780');
INSERT INTO `tp_region` VALUES ('10803', '前进农场', '4', '10780');
INSERT INTO `tp_region` VALUES ('10804', '前哨农场', '4', '10780');
INSERT INTO `tp_region` VALUES ('10805', '前卫农场', '4', '10780');
INSERT INTO `tp_region` VALUES ('10806', '东平林场', '4', '10780');
INSERT INTO `tp_region` VALUES ('10807', '上实现代农业园区', '4', '10780');
INSERT INTO `tp_region` VALUES ('10808', '江苏省', '1', '0');
INSERT INTO `tp_region` VALUES ('10809', '南京市', '2', '10808');
INSERT INTO `tp_region` VALUES ('10810', '市辖区', '3', '10809');
INSERT INTO `tp_region` VALUES ('10811', '玄武区', '3', '10809');
INSERT INTO `tp_region` VALUES ('10812', '梅园新村街道', '4', '10811');
INSERT INTO `tp_region` VALUES ('10813', '新街口街道', '4', '10811');
INSERT INTO `tp_region` VALUES ('10814', '玄武门街道', '4', '10811');
INSERT INTO `tp_region` VALUES ('10815', '后宰门街道', '4', '10811');
INSERT INTO `tp_region` VALUES ('10816', '锁金村街道', '4', '10811');
INSERT INTO `tp_region` VALUES ('10817', '红山街道', '4', '10811');
INSERT INTO `tp_region` VALUES ('10818', '孝陵卫街道', '4', '10811');
INSERT INTO `tp_region` VALUES ('10819', '玄武湖街道', '4', '10811');
INSERT INTO `tp_region` VALUES ('10820', '白下区', '3', '10809');
INSERT INTO `tp_region` VALUES ('10821', '五老村街道', '4', '10820');
INSERT INTO `tp_region` VALUES ('10822', '淮海路街道', '4', '10820');
INSERT INTO `tp_region` VALUES ('10823', '建康路街道', '4', '10820');
INSERT INTO `tp_region` VALUES ('10824', '洪武路街道', '4', '10820');
INSERT INTO `tp_region` VALUES ('10825', '大光路街道', '4', '10820');
INSERT INTO `tp_region` VALUES ('10826', '瑞金路街道', '4', '10820');
INSERT INTO `tp_region` VALUES ('10827', '苜蓿园街道', '4', '10820');
INSERT INTO `tp_region` VALUES ('10828', '光华路街道', '4', '10820');
INSERT INTO `tp_region` VALUES ('10829', '朝天宫街道', '4', '10820');
INSERT INTO `tp_region` VALUES ('10830', '止马营街道', '4', '10820');
INSERT INTO `tp_region` VALUES ('10831', '秦淮区', '3', '10809');
INSERT INTO `tp_region` VALUES ('10832', '秦虹街道', '4', '10831');
INSERT INTO `tp_region` VALUES ('10833', '夫子庙街道', '4', '10831');
INSERT INTO `tp_region` VALUES ('10834', '红花街道', '4', '10831');
INSERT INTO `tp_region` VALUES ('10835', '双塘街道', '4', '10831');
INSERT INTO `tp_region` VALUES ('10836', '中华门街道', '4', '10831');
INSERT INTO `tp_region` VALUES ('10837', '建邺区', '3', '10809');
INSERT INTO `tp_region` VALUES ('10838', '滨湖街道', '4', '10837');
INSERT INTO `tp_region` VALUES ('10839', '沙洲街道', '4', '10837');
INSERT INTO `tp_region` VALUES ('10840', '双闸街道', '4', '10837');
INSERT INTO `tp_region` VALUES ('10841', '江心洲街道', '4', '10837');
INSERT INTO `tp_region` VALUES ('10842', '南湖街道', '4', '10837');
INSERT INTO `tp_region` VALUES ('10843', '兴隆街道', '4', '10837');
INSERT INTO `tp_region` VALUES ('10844', '南苑街道', '4', '10837');
INSERT INTO `tp_region` VALUES ('10845', '鼓楼区', '3', '10809');
INSERT INTO `tp_region` VALUES ('10846', '宁海路街道', '4', '10845');
INSERT INTO `tp_region` VALUES ('10847', '华侨路街道', '4', '10845');
INSERT INTO `tp_region` VALUES ('10848', '湖南路街道', '4', '10845');
INSERT INTO `tp_region` VALUES ('10849', '中央门街道', '4', '10845');
INSERT INTO `tp_region` VALUES ('10850', '挹江门街道', '4', '10845');
INSERT INTO `tp_region` VALUES ('10851', '江东街道', '4', '10845');
INSERT INTO `tp_region` VALUES ('10852', '莫愁街道', '4', '10845');
INSERT INTO `tp_region` VALUES ('10853', '下关区', '3', '10809');
INSERT INTO `tp_region` VALUES ('10854', '阅江楼街道', '4', '10853');
INSERT INTO `tp_region` VALUES ('10855', '热河南路街道', '4', '10853');
INSERT INTO `tp_region` VALUES ('10856', '幕府山街道', '4', '10853');
INSERT INTO `tp_region` VALUES ('10857', '建宁路街道', '4', '10853');
INSERT INTO `tp_region` VALUES ('10858', '宝塔桥街道', '4', '10853');
INSERT INTO `tp_region` VALUES ('10859', '小市街道', '4', '10853');
INSERT INTO `tp_region` VALUES ('10860', '浦口区', '3', '10809');
INSERT INTO `tp_region` VALUES ('10861', '泰山街道', '4', '10860');
INSERT INTO `tp_region` VALUES ('10862', '顶山街道', '4', '10860');
INSERT INTO `tp_region` VALUES ('10863', '沿江街道', '4', '10860');
INSERT INTO `tp_region` VALUES ('10864', '江浦街道', '4', '10860');
INSERT INTO `tp_region` VALUES ('10865', '高新花苑虚拟街道', '4', '10860');
INSERT INTO `tp_region` VALUES ('10866', '桥林镇', '4', '10860');
INSERT INTO `tp_region` VALUES ('10867', '永宁镇', '4', '10860');
INSERT INTO `tp_region` VALUES ('10868', '汤泉镇', '4', '10860');
INSERT INTO `tp_region` VALUES ('10869', '星甸镇', '4', '10860');
INSERT INTO `tp_region` VALUES ('10870', '石桥镇', '4', '10860');
INSERT INTO `tp_region` VALUES ('10871', '乌江镇', '4', '10860');
INSERT INTO `tp_region` VALUES ('10872', '盘城镇', '4', '10860');
INSERT INTO `tp_region` VALUES ('10873', '老山林场', '4', '10860');
INSERT INTO `tp_region` VALUES ('10874', '汤泉农场', '4', '10860');
INSERT INTO `tp_region` VALUES ('10875', '珍珠泉管委会', '4', '10860');
INSERT INTO `tp_region` VALUES ('10876', '栖霞区', '3', '10809');
INSERT INTO `tp_region` VALUES ('10877', '尧化街道', '4', '10876');
INSERT INTO `tp_region` VALUES ('10878', '马群街道', '4', '10876');
INSERT INTO `tp_region` VALUES ('10879', '迈皋桥街道', '4', '10876');
INSERT INTO `tp_region` VALUES ('10880', '燕子矶街道', '4', '10876');
INSERT INTO `tp_region` VALUES ('10881', '栖霞街道', '4', '10876');
INSERT INTO `tp_region` VALUES ('10882', '龙潭街道', '4', '10876');
INSERT INTO `tp_region` VALUES ('10883', '仙林街道', '4', '10876');
INSERT INTO `tp_region` VALUES ('10884', '靖安街道', '4', '10876');
INSERT INTO `tp_region` VALUES ('10885', '八卦洲街道', '4', '10876');
INSERT INTO `tp_region` VALUES ('10886', '龙潭监狱', '4', '10876');
INSERT INTO `tp_region` VALUES ('10887', '栖霞区技术经济开发区', '4', '10876');
INSERT INTO `tp_region` VALUES ('10888', '南京龙潭物流园', '4', '10876');
INSERT INTO `tp_region` VALUES ('10889', '南京市靖安三江口工业园', '4', '10876');
INSERT INTO `tp_region` VALUES ('10890', '南京迈皋桥创业园', '4', '10876');
INSERT INTO `tp_region` VALUES ('10891', '南京市马群科技园', '4', '10876');
INSERT INTO `tp_region` VALUES ('10892', '南京仙林大学城', '4', '10876');
INSERT INTO `tp_region` VALUES ('10893', '南京经济技术开发区', '4', '10876');
INSERT INTO `tp_region` VALUES ('10894', '雨花台区', '3', '10809');
INSERT INTO `tp_region` VALUES ('10895', '宁南街道', '4', '10894');
INSERT INTO `tp_region` VALUES ('10896', '赛虹桥街道', '4', '10894');
INSERT INTO `tp_region` VALUES ('10897', '雨花新村街道', '4', '10894');
INSERT INTO `tp_region` VALUES ('10898', '西善桥街道', '4', '10894');
INSERT INTO `tp_region` VALUES ('10899', '板桥街道', '4', '10894');
INSERT INTO `tp_region` VALUES ('10900', '铁心桥街道', '4', '10894');
INSERT INTO `tp_region` VALUES ('10901', '梅山街道', '4', '10894');
INSERT INTO `tp_region` VALUES ('10902', '雨花经济技术开发区', '4', '10894');
INSERT INTO `tp_region` VALUES ('10903', '江宁区', '3', '10809');
INSERT INTO `tp_region` VALUES ('10904', '东山街道', '4', '10903');
INSERT INTO `tp_region` VALUES ('10905', '秣陵街道', '4', '10903');
INSERT INTO `tp_region` VALUES ('10906', '汤山街道', '4', '10903');
INSERT INTO `tp_region` VALUES ('10907', '淳化街道', '4', '10903');
INSERT INTO `tp_region` VALUES ('10908', '禄口街道', '4', '10903');
INSERT INTO `tp_region` VALUES ('10909', '江宁街道', '4', '10903');
INSERT INTO `tp_region` VALUES ('10910', '谷里街道', '4', '10903');
INSERT INTO `tp_region` VALUES ('10911', '湖熟镇', '4', '10903');
INSERT INTO `tp_region` VALUES ('10912', '横溪镇', '4', '10903');
INSERT INTO `tp_region` VALUES ('10913', '江宁科学园', '4', '10903');
INSERT INTO `tp_region` VALUES ('10914', '青龙山林场', '4', '10903');
INSERT INTO `tp_region` VALUES ('10915', '江宁开发区', '4', '10903');
INSERT INTO `tp_region` VALUES ('10916', '六合区', '3', '10809');
INSERT INTO `tp_region` VALUES ('10917', '卸甲甸街道', '4', '10916');
INSERT INTO `tp_region` VALUES ('10918', '西厂门街道', '4', '10916');
INSERT INTO `tp_region` VALUES ('10919', '山潘街道', '4', '10916');
INSERT INTO `tp_region` VALUES ('10920', '葛塘街道', '4', '10916');
INSERT INTO `tp_region` VALUES ('10921', '长芦街道', '4', '10916');
INSERT INTO `tp_region` VALUES ('10922', '雄州镇', '4', '10916');
INSERT INTO `tp_region` VALUES ('10923', '冶山镇', '4', '10916');
INSERT INTO `tp_region` VALUES ('10924', '八百桥镇', '4', '10916');
INSERT INTO `tp_region` VALUES ('10925', '横梁镇', '4', '10916');
INSERT INTO `tp_region` VALUES ('10926', '东沟镇', '4', '10916');
INSERT INTO `tp_region` VALUES ('10927', '龙袍镇', '4', '10916');
INSERT INTO `tp_region` VALUES ('10928', '玉带镇', '4', '10916');
INSERT INTO `tp_region` VALUES ('10929', '瓜埠镇', '4', '10916');
INSERT INTO `tp_region` VALUES ('10930', '新集镇', '4', '10916');
INSERT INTO `tp_region` VALUES ('10931', '程桥镇', '4', '10916');
INSERT INTO `tp_region` VALUES ('10932', '竹镇镇', '4', '10916');
INSERT INTO `tp_region` VALUES ('10933', '马集镇', '4', '10916');
INSERT INTO `tp_region` VALUES ('10934', '马鞍镇', '4', '10916');
INSERT INTO `tp_region` VALUES ('10935', '新篁镇', '4', '10916');
INSERT INTO `tp_region` VALUES ('10936', '六合开发区', '4', '10916');
INSERT INTO `tp_region` VALUES ('10937', '溧水县', '3', '10809');
INSERT INTO `tp_region` VALUES ('10938', '永阳镇', '4', '10937');
INSERT INTO `tp_region` VALUES ('10939', '白马镇', '4', '10937');
INSERT INTO `tp_region` VALUES ('10940', '东屏镇', '4', '10937');
INSERT INTO `tp_region` VALUES ('10941', '柘塘镇', '4', '10937');
INSERT INTO `tp_region` VALUES ('10942', '石湫镇', '4', '10937');
INSERT INTO `tp_region` VALUES ('10943', '洪蓝镇', '4', '10937');
INSERT INTO `tp_region` VALUES ('10944', '晶桥镇', '4', '10937');
INSERT INTO `tp_region` VALUES ('10945', '和凤镇', '4', '10937');
INSERT INTO `tp_region` VALUES ('10946', '溧水县开发区', '4', '10937');
INSERT INTO `tp_region` VALUES ('10947', '高淳县', '3', '10809');
INSERT INTO `tp_region` VALUES ('10948', '淳溪镇', '4', '10947');
INSERT INTO `tp_region` VALUES ('10949', '阳江镇', '4', '10947');
INSERT INTO `tp_region` VALUES ('10950', '砖墙镇', '4', '10947');
INSERT INTO `tp_region` VALUES ('10951', '古柏镇', '4', '10947');
INSERT INTO `tp_region` VALUES ('10952', '漆桥镇', '4', '10947');
INSERT INTO `tp_region` VALUES ('10953', '固城镇', '4', '10947');
INSERT INTO `tp_region` VALUES ('10954', '东坝镇', '4', '10947');
INSERT INTO `tp_region` VALUES ('10955', '桠溪镇', '4', '10947');
INSERT INTO `tp_region` VALUES ('10956', '高淳县团结圩良种繁育场', '4', '10947');
INSERT INTO `tp_region` VALUES ('10957', '高淳县茶叶实验场', '4', '10947');
INSERT INTO `tp_region` VALUES ('10958', '高淳监狱', '4', '10947');
INSERT INTO `tp_region` VALUES ('10959', '高淳县傅家坛林场', '4', '10947');
INSERT INTO `tp_region` VALUES ('10960', '无锡市', '2', '10808');
INSERT INTO `tp_region` VALUES ('10961', '市辖区', '3', '10960');
INSERT INTO `tp_region` VALUES ('10962', '崇安区', '3', '10960');
INSERT INTO `tp_region` VALUES ('10963', '崇安寺街道', '4', '10962');
INSERT INTO `tp_region` VALUES ('10964', '通江街道', '4', '10962');
INSERT INTO `tp_region` VALUES ('10965', '广瑞路街道', '4', '10962');
INSERT INTO `tp_region` VALUES ('10966', '上马墩街道', '4', '10962');
INSERT INTO `tp_region` VALUES ('10967', '江海街道', '4', '10962');
INSERT INTO `tp_region` VALUES ('10968', '广益街道', '4', '10962');
INSERT INTO `tp_region` VALUES ('10969', '南长区', '3', '10960');
INSERT INTO `tp_region` VALUES ('10970', '迎龙桥街道', '4', '10969');
INSERT INTO `tp_region` VALUES ('10971', '南禅寺街道', '4', '10969');
INSERT INTO `tp_region` VALUES ('10972', '清名桥街道', '4', '10969');
INSERT INTO `tp_region` VALUES ('10973', '金星街道', '4', '10969');
INSERT INTO `tp_region` VALUES ('10974', '金匮街道', '4', '10969');
INSERT INTO `tp_region` VALUES ('10975', '扬名街道', '4', '10969');
INSERT INTO `tp_region` VALUES ('10976', '北塘区', '3', '10960');
INSERT INTO `tp_region` VALUES ('10977', '黄巷街道', '4', '10976');
INSERT INTO `tp_region` VALUES ('10978', '山北街道', '4', '10976');
INSERT INTO `tp_region` VALUES ('10979', '北大街街道', '4', '10976');
INSERT INTO `tp_region` VALUES ('10980', '惠山街道', '4', '10976');
INSERT INTO `tp_region` VALUES ('10981', '锡山区', '3', '10960');
INSERT INTO `tp_region` VALUES ('10982', '东亭街道', '4', '10981');
INSERT INTO `tp_region` VALUES ('10983', '安镇镇', '4', '10981');
INSERT INTO `tp_region` VALUES ('10984', '羊尖镇', '4', '10981');
INSERT INTO `tp_region` VALUES ('10985', '鹅湖镇', '4', '10981');
INSERT INTO `tp_region` VALUES ('10986', '东北塘镇', '4', '10981');
INSERT INTO `tp_region` VALUES ('10987', '锡北镇', '4', '10981');
INSERT INTO `tp_region` VALUES ('10988', '东港镇', '4', '10981');
INSERT INTO `tp_region` VALUES ('10989', '无锡锡山开发区', '4', '10981');
INSERT INTO `tp_region` VALUES ('10990', '惠山区', '3', '10960');
INSERT INTO `tp_region` VALUES ('10991', '堰桥街道', '4', '10990');
INSERT INTO `tp_region` VALUES ('10992', '长安街道', '4', '10990');
INSERT INTO `tp_region` VALUES ('10993', '前洲镇', '4', '10990');
INSERT INTO `tp_region` VALUES ('10994', '玉祁镇', '4', '10990');
INSERT INTO `tp_region` VALUES ('10995', '洛社镇', '4', '10990');
INSERT INTO `tp_region` VALUES ('10996', '钱桥镇', '4', '10990');
INSERT INTO `tp_region` VALUES ('10997', '阳山镇', '4', '10990');
INSERT INTO `tp_region` VALUES ('10998', '无锡惠山经济开发区', '4', '10990');
INSERT INTO `tp_region` VALUES ('10999', '滨湖区', '3', '10960');
INSERT INTO `tp_region` VALUES ('11000', '河埒街道', '4', '10999');
INSERT INTO `tp_region` VALUES ('11001', '荣巷街道', '4', '10999');
INSERT INTO `tp_region` VALUES ('11002', '蠡园街道', '4', '10999');
INSERT INTO `tp_region` VALUES ('11003', '蠡湖街道', '4', '10999');
INSERT INTO `tp_region` VALUES ('11004', '滨湖街道', '4', '10999');
INSERT INTO `tp_region` VALUES ('11005', '华庄街道', '4', '10999');
INSERT INTO `tp_region` VALUES ('11006', '太湖街道', '4', '10999');
INSERT INTO `tp_region` VALUES ('11007', '雪浪街道', '4', '10999');
INSERT INTO `tp_region` VALUES ('11008', '旺庄街道', '4', '10999');
INSERT INTO `tp_region` VALUES ('11009', '硕放街道', '4', '10999');
INSERT INTO `tp_region` VALUES ('11010', '南站街道', '4', '10999');
INSERT INTO `tp_region` VALUES ('11011', '坊前街道', '4', '10999');
INSERT INTO `tp_region` VALUES ('11012', '马山镇', '4', '10999');
INSERT INTO `tp_region` VALUES ('11013', '胡埭镇', '4', '10999');
INSERT INTO `tp_region` VALUES ('11014', '梅村镇', '4', '10999');
INSERT INTO `tp_region` VALUES ('11015', '鸿山镇', '4', '10999');
INSERT INTO `tp_region` VALUES ('11016', '无锡新加坡工业园', '4', '10999');
INSERT INTO `tp_region` VALUES ('11017', '无锡高新技术产业开发区', '4', '10999');
INSERT INTO `tp_region` VALUES ('11018', '江阴市', '3', '10960');
INSERT INTO `tp_region` VALUES ('11019', '澄江镇', '4', '11018');
INSERT INTO `tp_region` VALUES ('11020', '璜土镇', '4', '11018');
INSERT INTO `tp_region` VALUES ('11021', '利港镇', '4', '11018');
INSERT INTO `tp_region` VALUES ('11022', '申港镇', '4', '11018');
INSERT INTO `tp_region` VALUES ('11023', '夏港镇', '4', '11018');
INSERT INTO `tp_region` VALUES ('11024', '月城镇', '4', '11018');
INSERT INTO `tp_region` VALUES ('11025', '青阳镇', '4', '11018');
INSERT INTO `tp_region` VALUES ('11026', '霞客镇', '4', '11018');
INSERT INTO `tp_region` VALUES ('11027', '南闸镇', '4', '11018');
INSERT INTO `tp_region` VALUES ('11028', '云亭镇', '4', '11018');
INSERT INTO `tp_region` VALUES ('11029', '华士镇', '4', '11018');
INSERT INTO `tp_region` VALUES ('11030', '周庄镇', '4', '11018');
INSERT INTO `tp_region` VALUES ('11031', '新桥镇', '4', '11018');
INSERT INTO `tp_region` VALUES ('11032', '长泾镇', '4', '11018');
INSERT INTO `tp_region` VALUES ('11033', '顾山镇', '4', '11018');
INSERT INTO `tp_region` VALUES ('11034', '祝塘镇', '4', '11018');
INSERT INTO `tp_region` VALUES ('11035', '江阴经济开发区新城东', '4', '11018');
INSERT INTO `tp_region` VALUES ('11036', '江阴经济开发区港口', '4', '11018');
INSERT INTO `tp_region` VALUES ('11037', '江阴经济开发区石庄', '4', '11018');
INSERT INTO `tp_region` VALUES ('11038', '江阴经济开发区靖江园区', '4', '11018');
INSERT INTO `tp_region` VALUES ('11039', '宜兴市', '3', '10960');
INSERT INTO `tp_region` VALUES ('11040', '宜城街道', '4', '11039');
INSERT INTO `tp_region` VALUES ('11041', '屺亭街道', '4', '11039');
INSERT INTO `tp_region` VALUES ('11042', '张渚镇', '4', '11039');
INSERT INTO `tp_region` VALUES ('11043', '西渚镇', '4', '11039');
INSERT INTO `tp_region` VALUES ('11044', '太华镇', '4', '11039');
INSERT INTO `tp_region` VALUES ('11045', '徐舍镇', '4', '11039');
INSERT INTO `tp_region` VALUES ('11046', '鲸塘镇', '4', '11039');
INSERT INTO `tp_region` VALUES ('11047', '芳庄镇', '4', '11039');
INSERT INTO `tp_region` VALUES ('11048', '官林镇', '4', '11039');
INSERT INTO `tp_region` VALUES ('11049', '杨巷镇', '4', '11039');
INSERT INTO `tp_region` VALUES ('11050', '新建镇', '4', '11039');
INSERT INTO `tp_region` VALUES ('11051', '和桥镇', '4', '11039');
INSERT INTO `tp_region` VALUES ('11052', '高塍镇', '4', '11039');
INSERT INTO `tp_region` VALUES ('11053', '万石镇', '4', '11039');
INSERT INTO `tp_region` VALUES ('11054', '周铁镇', '4', '11039');
INSERT INTO `tp_region` VALUES ('11055', '芳桥镇', '4', '11039');
INSERT INTO `tp_region` VALUES ('11056', '新庄镇', '4', '11039');
INSERT INTO `tp_region` VALUES ('11057', '丁蜀镇', '4', '11039');
INSERT INTO `tp_region` VALUES ('11058', '大浦镇', '4', '11039');
INSERT INTO `tp_region` VALUES ('11059', '湖父镇', '4', '11039');
INSERT INTO `tp_region` VALUES ('11060', '新街镇', '4', '11039');
INSERT INTO `tp_region` VALUES ('11061', '环科园', '4', '11039');
INSERT INTO `tp_region` VALUES ('11062', '宜兴经济开发区', '4', '11039');
INSERT INTO `tp_region` VALUES ('11063', '芙蓉茶场', '4', '11039');
INSERT INTO `tp_region` VALUES ('11064', '宜兴市林场', '4', '11039');
INSERT INTO `tp_region` VALUES ('11065', '宜兴市大贤岭林场', '4', '11039');
INSERT INTO `tp_region` VALUES ('11066', '无锡市茶叶研究所', '4', '11039');
INSERT INTO `tp_region` VALUES ('11067', '徐州市', '2', '10808');
INSERT INTO `tp_region` VALUES ('11068', '市辖区', '3', '11067');
INSERT INTO `tp_region` VALUES ('11069', '鼓楼区', '3', '11067');
INSERT INTO `tp_region` VALUES ('11070', '黄楼街道', '4', '11069');
INSERT INTO `tp_region` VALUES ('11071', '丰财街道', '4', '11069');
INSERT INTO `tp_region` VALUES ('11072', '琵琶街道', '4', '11069');
INSERT INTO `tp_region` VALUES ('11073', '牌楼街道', '4', '11069');
INSERT INTO `tp_region` VALUES ('11074', '铜沛街道', '4', '11069');
INSERT INTO `tp_region` VALUES ('11075', '环城街道', '4', '11069');
INSERT INTO `tp_region` VALUES ('11076', '金山桥街道', '4', '11069');
INSERT INTO `tp_region` VALUES ('11077', '东环街道', '4', '11069');
INSERT INTO `tp_region` VALUES ('11078', '大黄山街道', '4', '11069');
INSERT INTO `tp_region` VALUES ('11079', '大庙镇', '4', '11069');
INSERT INTO `tp_region` VALUES ('11080', '大黄山镇', '4', '11069');
INSERT INTO `tp_region` VALUES ('11081', '云龙区', '3', '11067');
INSERT INTO `tp_region` VALUES ('11082', '彭城街道', '4', '11081');
INSERT INTO `tp_region` VALUES ('11083', '子房街道', '4', '11081');
INSERT INTO `tp_region` VALUES ('11084', '黄山街道', '4', '11081');
INSERT INTO `tp_region` VALUES ('11085', '骆驼山街道', '4', '11081');
INSERT INTO `tp_region` VALUES ('11086', '大郭庄街道', '4', '11081');
INSERT INTO `tp_region` VALUES ('11087', '翠屏山街道', '4', '11081');
INSERT INTO `tp_region` VALUES ('11088', '潘塘街道', '4', '11081');
INSERT INTO `tp_region` VALUES ('11089', '九里区', '3', '11067');
INSERT INTO `tp_region` VALUES ('11090', '庞庄街道', '4', '11089');
INSERT INTO `tp_region` VALUES ('11091', '利国街道', '4', '11089');
INSERT INTO `tp_region` VALUES ('11092', '桃园街道', '4', '11089');
INSERT INTO `tp_region` VALUES ('11093', '三河尖街道', '4', '11089');
INSERT INTO `tp_region` VALUES ('11094', '垞城街道', '4', '11089');
INSERT INTO `tp_region` VALUES ('11095', '义安街道', '4', '11089');
INSERT INTO `tp_region` VALUES ('11096', '张集街道', '4', '11089');
INSERT INTO `tp_region` VALUES ('11097', '电厂街道', '4', '11089');
INSERT INTO `tp_region` VALUES ('11098', '张双楼街道', '4', '11089');
INSERT INTO `tp_region` VALUES ('11099', '九里街道', '4', '11089');
INSERT INTO `tp_region` VALUES ('11100', '拾屯街道', '4', '11089');
INSERT INTO `tp_region` VALUES ('11101', '苏山街道', '4', '11089');
INSERT INTO `tp_region` VALUES ('11102', '火花街道', '4', '11089');
INSERT INTO `tp_region` VALUES ('11103', '贾汪区', '3', '11067');
INSERT INTO `tp_region` VALUES ('11104', '老矿街道', '4', '11103');
INSERT INTO `tp_region` VALUES ('11105', '夏桥街道', '4', '11103');
INSERT INTO `tp_region` VALUES ('11106', '贾汪镇', '4', '11103');
INSERT INTO `tp_region` VALUES ('11107', '青山泉镇', '4', '11103');
INSERT INTO `tp_region` VALUES ('11108', '大吴镇', '4', '11103');
INSERT INTO `tp_region` VALUES ('11109', '紫庄镇', '4', '11103');
INSERT INTO `tp_region` VALUES ('11110', '塔山镇', '4', '11103');
INSERT INTO `tp_region` VALUES ('11111', '汴塘镇', '4', '11103');
INSERT INTO `tp_region` VALUES ('11112', '江庄镇', '4', '11103');
INSERT INTO `tp_region` VALUES ('11113', '工业园区管委会', '4', '11103');
INSERT INTO `tp_region` VALUES ('11114', '鹿庄粮棉原种场', '4', '11103');
INSERT INTO `tp_region` VALUES ('11115', '泉山区', '3', '11067');
INSERT INTO `tp_region` VALUES ('11116', '王陵街道', '4', '11115');
INSERT INTO `tp_region` VALUES ('11117', '永安街道', '4', '11115');
INSERT INTO `tp_region` VALUES ('11118', '湖滨街道', '4', '11115');
INSERT INTO `tp_region` VALUES ('11119', '段庄街道', '4', '11115');
INSERT INTO `tp_region` VALUES ('11120', '翟山街道', '4', '11115');
INSERT INTO `tp_region` VALUES ('11121', '奎山街道', '4', '11115');
INSERT INTO `tp_region` VALUES ('11122', '和平街道', '4', '11115');
INSERT INTO `tp_region` VALUES ('11123', '泰山街道', '4', '11115');
INSERT INTO `tp_region` VALUES ('11124', '金山街道', '4', '11115');
INSERT INTO `tp_region` VALUES ('11125', '七里沟街道', '4', '11115');
INSERT INTO `tp_region` VALUES ('11126', '丰县', '3', '11067');
INSERT INTO `tp_region` VALUES ('11127', '凤城镇', '4', '11126');
INSERT INTO `tp_region` VALUES ('11128', '首羡镇', '4', '11126');
INSERT INTO `tp_region` VALUES ('11129', '顺河镇', '4', '11126');
INSERT INTO `tp_region` VALUES ('11130', '常店镇', '4', '11126');
INSERT INTO `tp_region` VALUES ('11131', '欢口镇', '4', '11126');
INSERT INTO `tp_region` VALUES ('11132', '师寨镇', '4', '11126');
INSERT INTO `tp_region` VALUES ('11133', '华山镇', '4', '11126');
INSERT INTO `tp_region` VALUES ('11134', '梁寨镇', '4', '11126');
INSERT INTO `tp_region` VALUES ('11135', '范楼镇', '4', '11126');
INSERT INTO `tp_region` VALUES ('11136', '孙楼镇', '4', '11126');
INSERT INTO `tp_region` VALUES ('11137', '宋楼镇', '4', '11126');
INSERT INTO `tp_region` VALUES ('11138', '大沙河镇', '4', '11126');
INSERT INTO `tp_region` VALUES ('11139', '王沟镇', '4', '11126');
INSERT INTO `tp_region` VALUES ('11140', '赵庄镇', '4', '11126');
INSERT INTO `tp_region` VALUES ('11141', '大沙河林场', '4', '11126');
INSERT INTO `tp_region` VALUES ('11142', '沛县', '3', '11067');
INSERT INTO `tp_region` VALUES ('11143', '龙固镇', '4', '11142');
INSERT INTO `tp_region` VALUES ('11144', '杨屯镇', '4', '11142');
INSERT INTO `tp_region` VALUES ('11145', '大屯镇', '4', '11142');
INSERT INTO `tp_region` VALUES ('11146', '沛城镇', '4', '11142');
INSERT INTO `tp_region` VALUES ('11147', '胡寨镇', '4', '11142');
INSERT INTO `tp_region` VALUES ('11148', '魏庙镇', '4', '11142');
INSERT INTO `tp_region` VALUES ('11149', '五段镇', '4', '11142');
INSERT INTO `tp_region` VALUES ('11150', '张庄镇', '4', '11142');
INSERT INTO `tp_region` VALUES ('11151', '张寨镇', '4', '11142');
INSERT INTO `tp_region` VALUES ('11152', '敬安镇', '4', '11142');
INSERT INTO `tp_region` VALUES ('11153', '河口镇', '4', '11142');
INSERT INTO `tp_region` VALUES ('11154', '栖山镇', '4', '11142');
INSERT INTO `tp_region` VALUES ('11155', '鹿楼镇', '4', '11142');
INSERT INTO `tp_region` VALUES ('11156', '朱寨镇', '4', '11142');
INSERT INTO `tp_region` VALUES ('11157', '安国镇', '4', '11142');
INSERT INTO `tp_region` VALUES ('11158', '中煤集团大屯煤电(集团)公司', '4', '11142');
INSERT INTO `tp_region` VALUES ('11159', '经济开发区', '4', '11142');
INSERT INTO `tp_region` VALUES ('11160', '铜山县', '3', '11067');
INSERT INTO `tp_region` VALUES ('11161', '铜山镇', '4', '11160');
INSERT INTO `tp_region` VALUES ('11162', '何桥镇', '4', '11160');
INSERT INTO `tp_region` VALUES ('11163', '黄集镇', '4', '11160');
INSERT INTO `tp_region` VALUES ('11164', '马坡镇', '4', '11160');
INSERT INTO `tp_region` VALUES ('11165', '郑集镇', '4', '11160');
INSERT INTO `tp_region` VALUES ('11166', '柳新镇', '4', '11160');
INSERT INTO `tp_region` VALUES ('11167', '刘集镇', '4', '11160');
INSERT INTO `tp_region` VALUES ('11168', '大彭镇', '4', '11160');
INSERT INTO `tp_region` VALUES ('11169', '汉王镇', '4', '11160');
INSERT INTO `tp_region` VALUES ('11170', '三堡镇', '4', '11160');
INSERT INTO `tp_region` VALUES ('11171', '棠张镇', '4', '11160');
INSERT INTO `tp_region` VALUES ('11172', '张集镇', '4', '11160');
INSERT INTO `tp_region` VALUES ('11173', '房村镇', '4', '11160');
INSERT INTO `tp_region` VALUES ('11174', '伊庄镇', '4', '11160');
INSERT INTO `tp_region` VALUES ('11175', '单集镇', '4', '11160');
INSERT INTO `tp_region` VALUES ('11176', '徐庄镇', '4', '11160');
INSERT INTO `tp_region` VALUES ('11177', '大许镇', '4', '11160');
INSERT INTO `tp_region` VALUES ('11178', '茅村镇', '4', '11160');
INSERT INTO `tp_region` VALUES ('11179', '柳泉镇', '4', '11160');
INSERT INTO `tp_region` VALUES ('11180', '利国镇', '4', '11160');
INSERT INTO `tp_region` VALUES ('11181', '国营沿湖农', '4', '11160');
INSERT INTO `tp_region` VALUES ('11182', '睢宁县', '3', '11067');
INSERT INTO `tp_region` VALUES ('11183', '睢城镇', '4', '11182');
INSERT INTO `tp_region` VALUES ('11184', '王集镇', '4', '11182');
INSERT INTO `tp_region` VALUES ('11185', '双沟镇', '4', '11182');
INSERT INTO `tp_region` VALUES ('11186', '岚山镇', '4', '11182');
INSERT INTO `tp_region` VALUES ('11187', '李集镇', '4', '11182');
INSERT INTO `tp_region` VALUES ('11188', '桃园镇', '4', '11182');
INSERT INTO `tp_region` VALUES ('11189', '官山镇', '4', '11182');
INSERT INTO `tp_region` VALUES ('11190', '高作镇', '4', '11182');
INSERT INTO `tp_region` VALUES ('11191', '沙集镇', '4', '11182');
INSERT INTO `tp_region` VALUES ('11192', '凌城镇', '4', '11182');
INSERT INTO `tp_region` VALUES ('11193', '邱集镇', '4', '11182');
INSERT INTO `tp_region` VALUES ('11194', '古邳镇', '4', '11182');
INSERT INTO `tp_region` VALUES ('11195', '姚集镇', '4', '11182');
INSERT INTO `tp_region` VALUES ('11196', '魏集镇', '4', '11182');
INSERT INTO `tp_region` VALUES ('11197', '梁集镇', '4', '11182');
INSERT INTO `tp_region` VALUES ('11198', '庆安镇', '4', '11182');
INSERT INTO `tp_region` VALUES ('11199', '经济开发区', '4', '11182');
INSERT INTO `tp_region` VALUES ('11200', '新沂市', '3', '11067');
INSERT INTO `tp_region` VALUES ('11201', '新安镇', '4', '11200');
INSERT INTO `tp_region` VALUES ('11202', '瓦窑镇', '4', '11200');
INSERT INTO `tp_region` VALUES ('11203', '港头镇', '4', '11200');
INSERT INTO `tp_region` VALUES ('11204', '唐店镇', '4', '11200');
INSERT INTO `tp_region` VALUES ('11205', '合沟镇', '4', '11200');
INSERT INTO `tp_region` VALUES ('11206', '草桥镇', '4', '11200');
INSERT INTO `tp_region` VALUES ('11207', '窑湾镇', '4', '11200');
INSERT INTO `tp_region` VALUES ('11208', '棋盘镇', '4', '11200');
INSERT INTO `tp_region` VALUES ('11209', '新店镇', '4', '11200');
INSERT INTO `tp_region` VALUES ('11210', '邵店镇', '4', '11200');
INSERT INTO `tp_region` VALUES ('11211', '北沟镇', '4', '11200');
INSERT INTO `tp_region` VALUES ('11212', '时集镇', '4', '11200');
INSERT INTO `tp_region` VALUES ('11213', '高流镇', '4', '11200');
INSERT INTO `tp_region` VALUES ('11214', '阿湖镇', '4', '11200');
INSERT INTO `tp_region` VALUES ('11215', '双塘镇', '4', '11200');
INSERT INTO `tp_region` VALUES ('11216', '马岭山镇', '4', '11200');
INSERT INTO `tp_region` VALUES ('11217', '经济开发区', '4', '11200');
INSERT INTO `tp_region` VALUES ('11218', '邳州市', '3', '11067');
INSERT INTO `tp_region` VALUES ('11219', '运河镇', '4', '11218');
INSERT INTO `tp_region` VALUES ('11220', '邳城镇', '4', '11218');
INSERT INTO `tp_region` VALUES ('11221', '官湖镇', '4', '11218');
INSERT INTO `tp_region` VALUES ('11222', '四户镇', '4', '11218');
INSERT INTO `tp_region` VALUES ('11223', '宿羊山镇', '4', '11218');
INSERT INTO `tp_region` VALUES ('11224', '八义集镇', '4', '11218');
INSERT INTO `tp_region` VALUES ('11225', '土山镇', '4', '11218');
INSERT INTO `tp_region` VALUES ('11226', '碾庄镇', '4', '11218');
INSERT INTO `tp_region` VALUES ('11227', '港上镇', '4', '11218');
INSERT INTO `tp_region` VALUES ('11228', '邹庄镇', '4', '11218');
INSERT INTO `tp_region` VALUES ('11229', '占城镇', '4', '11218');
INSERT INTO `tp_region` VALUES ('11230', '新河镇', '4', '11218');
INSERT INTO `tp_region` VALUES ('11231', '八路镇', '4', '11218');
INSERT INTO `tp_region` VALUES ('11232', '炮车镇', '4', '11218');
INSERT INTO `tp_region` VALUES ('11233', '铁富镇', '4', '11218');
INSERT INTO `tp_region` VALUES ('11234', '岔河镇', '4', '11218');
INSERT INTO `tp_region` VALUES ('11235', '戴圩镇', '4', '11218');
INSERT INTO `tp_region` VALUES ('11236', '陈楼镇', '4', '11218');
INSERT INTO `tp_region` VALUES ('11237', '邢楼镇', '4', '11218');
INSERT INTO `tp_region` VALUES ('11238', '戴庄镇', '4', '11218');
INSERT INTO `tp_region` VALUES ('11239', '车辐山镇', '4', '11218');
INSERT INTO `tp_region` VALUES ('11240', '燕子埠镇', '4', '11218');
INSERT INTO `tp_region` VALUES ('11241', '赵墩镇', '4', '11218');
INSERT INTO `tp_region` VALUES ('11242', '议堂镇', '4', '11218');
INSERT INTO `tp_region` VALUES ('11243', '邳城农场', '4', '11218');
INSERT INTO `tp_region` VALUES ('11244', '张楼农场', '4', '11218');
INSERT INTO `tp_region` VALUES ('11245', '常州市', '2', '10808');
INSERT INTO `tp_region` VALUES ('11246', '常州市区', '3', '11245');
INSERT INTO `tp_region` VALUES ('11247', '天宁区', '3', '11245');
INSERT INTO `tp_region` VALUES ('11248', '雕庄街道', '4', '11247');
INSERT INTO `tp_region` VALUES ('11249', '青龙街道', '4', '11247');
INSERT INTO `tp_region` VALUES ('11250', '茶山街道', '4', '11247');
INSERT INTO `tp_region` VALUES ('11251', '红梅街道', '4', '11247');
INSERT INTO `tp_region` VALUES ('11252', '天宁街道', '4', '11247');
INSERT INTO `tp_region` VALUES ('11253', '兰陵街道', '4', '11247');
INSERT INTO `tp_region` VALUES ('11254', '钟楼区', '3', '11245');
INSERT INTO `tp_region` VALUES ('11255', '五星街道', '4', '11254');
INSERT INTO `tp_region` VALUES ('11256', '永红街道', '4', '11254');
INSERT INTO `tp_region` VALUES ('11257', '北港街道', '4', '11254');
INSERT INTO `tp_region` VALUES ('11258', '西林街道', '4', '11254');
INSERT INTO `tp_region` VALUES ('11259', '南大街街道', '4', '11254');
INSERT INTO `tp_region` VALUES ('11260', '荷花池街道', '4', '11254');
INSERT INTO `tp_region` VALUES ('11261', '新闸镇', '4', '11254');
INSERT INTO `tp_region` VALUES ('11262', '戚墅堰区', '3', '11245');
INSERT INTO `tp_region` VALUES ('11263', '戚墅堰街道', '4', '11262');
INSERT INTO `tp_region` VALUES ('11264', '丁堰镇', '4', '11262');
INSERT INTO `tp_region` VALUES ('11265', '潞城镇', '4', '11262');
INSERT INTO `tp_region` VALUES ('11266', '新北区', '3', '11245');
INSERT INTO `tp_region` VALUES ('11267', '河海街道', '4', '11266');
INSERT INTO `tp_region` VALUES ('11268', '三井街道', '4', '11266');
INSERT INTO `tp_region` VALUES ('11269', '龙虎塘街道', '4', '11266');
INSERT INTO `tp_region` VALUES ('11270', '春江镇', '4', '11266');
INSERT INTO `tp_region` VALUES ('11271', '孟河镇', '4', '11266');
INSERT INTO `tp_region` VALUES ('11272', '新桥镇', '4', '11266');
INSERT INTO `tp_region` VALUES ('11273', '薛家镇', '4', '11266');
INSERT INTO `tp_region` VALUES ('11274', '罗溪镇', '4', '11266');
INSERT INTO `tp_region` VALUES ('11275', '西夏墅镇', '4', '11266');
INSERT INTO `tp_region` VALUES ('11276', '武进区', '3', '11245');
INSERT INTO `tp_region` VALUES ('11277', '湖塘镇', '4', '11276');
INSERT INTO `tp_region` VALUES ('11278', '牛塘镇', '4', '11276');
INSERT INTO `tp_region` VALUES ('11279', '洛阳镇', '4', '11276');
INSERT INTO `tp_region` VALUES ('11280', '遥观镇', '4', '11276');
INSERT INTO `tp_region` VALUES ('11281', '横林镇', '4', '11276');
INSERT INTO `tp_region` VALUES ('11282', '横山桥镇', '4', '11276');
INSERT INTO `tp_region` VALUES ('11283', '芙蓉镇', '4', '11276');
INSERT INTO `tp_region` VALUES ('11284', '焦溪镇', '4', '11276');
INSERT INTO `tp_region` VALUES ('11285', '郑陆镇', '4', '11276');
INSERT INTO `tp_region` VALUES ('11286', '雪堰镇', '4', '11276');
INSERT INTO `tp_region` VALUES ('11287', '潘家镇', '4', '11276');
INSERT INTO `tp_region` VALUES ('11288', '漕桥镇', '4', '11276');
INSERT INTO `tp_region` VALUES ('11289', '前黄镇', '4', '11276');
INSERT INTO `tp_region` VALUES ('11290', '礼嘉镇', '4', '11276');
INSERT INTO `tp_region` VALUES ('11291', '寨桥镇', '4', '11276');
INSERT INTO `tp_region` VALUES ('11292', '邹区镇', '4', '11276');
INSERT INTO `tp_region` VALUES ('11293', '卜弋镇', '4', '11276');
INSERT INTO `tp_region` VALUES ('11294', '夏溪镇', '4', '11276');
INSERT INTO `tp_region` VALUES ('11295', '嘉泽镇', '4', '11276');
INSERT INTO `tp_region` VALUES ('11296', '湟里镇', '4', '11276');
INSERT INTO `tp_region` VALUES ('11297', '东安镇', '4', '11276');
INSERT INTO `tp_region` VALUES ('11298', '奔牛镇', '4', '11276');
INSERT INTO `tp_region` VALUES ('11299', '武进经济开发区', '4', '11276');
INSERT INTO `tp_region` VALUES ('11300', '运村农科良种场', '4', '11276');
INSERT INTO `tp_region` VALUES ('11301', '奔牛稻麦原种场', '4', '11276');
INSERT INTO `tp_region` VALUES ('11302', '郑陆良种繁育场', '4', '11276');
INSERT INTO `tp_region` VALUES ('11303', '夏溪良种繁育场', '4', '11276');
INSERT INTO `tp_region` VALUES ('11304', '蚕种场', '4', '11276');
INSERT INTO `tp_region` VALUES ('11305', '前黄苗圃', '4', '11276');
INSERT INTO `tp_region` VALUES ('11306', '水产养殖场', '4', '11276');
INSERT INTO `tp_region` VALUES ('11307', '种兔场', '4', '11276');
INSERT INTO `tp_region` VALUES ('11308', '横山苗圃', '4', '11276');
INSERT INTO `tp_region` VALUES ('11309', '公路苗圃', '4', '11276');
INSERT INTO `tp_region` VALUES ('11310', '高新区', '4', '11276');
INSERT INTO `tp_region` VALUES ('11311', '溧阳市', '3', '11245');
INSERT INTO `tp_region` VALUES ('11312', '溧城镇', '4', '11311');
INSERT INTO `tp_region` VALUES ('11313', '埭头镇', '4', '11311');
INSERT INTO `tp_region` VALUES ('11314', '上黄镇', '4', '11311');
INSERT INTO `tp_region` VALUES ('11315', '戴埠镇', '4', '11311');
INSERT INTO `tp_region` VALUES ('11316', '横涧镇', '4', '11311');
INSERT INTO `tp_region` VALUES ('11317', '天目湖镇', '4', '11311');
INSERT INTO `tp_region` VALUES ('11318', '别桥镇', '4', '11311');
INSERT INTO `tp_region` VALUES ('11319', '绸缪镇', '4', '11311');
INSERT INTO `tp_region` VALUES ('11320', '上兴镇', '4', '11311');
INSERT INTO `tp_region` VALUES ('11321', '上沛镇', '4', '11311');
INSERT INTO `tp_region` VALUES ('11322', '竹箦镇', '4', '11311');
INSERT INTO `tp_region` VALUES ('11323', '后周镇', '4', '11311');
INSERT INTO `tp_region` VALUES ('11324', '前马镇', '4', '11311');
INSERT INTO `tp_region` VALUES ('11325', '南渡镇', '4', '11311');
INSERT INTO `tp_region` VALUES ('11326', '新昌镇', '4', '11311');
INSERT INTO `tp_region` VALUES ('11327', '社渚镇', '4', '11311');
INSERT INTO `tp_region` VALUES ('11328', '周城镇', '4', '11311');
INSERT INTO `tp_region` VALUES ('11329', '常州监狱', '4', '11311');
INSERT INTO `tp_region` VALUES ('11330', '溧阳监狱', '4', '11311');
INSERT INTO `tp_region` VALUES ('11331', '金坛市', '3', '11245');
INSERT INTO `tp_region` VALUES ('11332', '金城镇', '4', '11331');
INSERT INTO `tp_region` VALUES ('11333', '白塔镇', '4', '11331');
INSERT INTO `tp_region` VALUES ('11334', '河头镇', '4', '11331');
INSERT INTO `tp_region` VALUES ('11335', '水北镇', '4', '11331');
INSERT INTO `tp_region` VALUES ('11336', '儒林镇', '4', '11331');
INSERT INTO `tp_region` VALUES ('11337', '尧塘镇', '4', '11331');
INSERT INTO `tp_region` VALUES ('11338', '直溪镇', '4', '11331');
INSERT INTO `tp_region` VALUES ('11339', '建昌镇', '4', '11331');
INSERT INTO `tp_region` VALUES ('11340', '朱林镇', '4', '11331');
INSERT INTO `tp_region` VALUES ('11341', '薛埠镇', '4', '11331');
INSERT INTO `tp_region` VALUES ('11342', '茅麓镇', '4', '11331');
INSERT INTO `tp_region` VALUES ('11343', '社头镇', '4', '11331');
INSERT INTO `tp_region` VALUES ('11344', '指前镇', '4', '11331');
INSERT INTO `tp_region` VALUES ('11345', '洮西镇', '4', '11331');
INSERT INTO `tp_region` VALUES ('11346', '西岗镇', '4', '11331');
INSERT INTO `tp_region` VALUES ('11347', '开发区', '4', '11331');
INSERT INTO `tp_region` VALUES ('11348', '苏州市', '2', '10808');
INSERT INTO `tp_region` VALUES ('11349', '市辖区', '3', '11348');
INSERT INTO `tp_region` VALUES ('11350', '沧浪区', '3', '11348');
INSERT INTO `tp_region` VALUES ('11351', '双塔街道', '4', '11350');
INSERT INTO `tp_region` VALUES ('11352', '南门街道', '4', '11350');
INSERT INTO `tp_region` VALUES ('11353', '胥江街道', '4', '11350');
INSERT INTO `tp_region` VALUES ('11354', '吴门桥街道', '4', '11350');
INSERT INTO `tp_region` VALUES ('11355', '葑门街道', '4', '11350');
INSERT INTO `tp_region` VALUES ('11356', '友新街道', '4', '11350');
INSERT INTO `tp_region` VALUES ('11357', '平江区', '3', '11348');
INSERT INTO `tp_region` VALUES ('11358', '观前街道', '4', '11357');
INSERT INTO `tp_region` VALUES ('11359', '平江路街道', '4', '11357');
INSERT INTO `tp_region` VALUES ('11360', '苏锦街道', '4', '11357');
INSERT INTO `tp_region` VALUES ('11361', '娄门街道', '4', '11357');
INSERT INTO `tp_region` VALUES ('11362', '城北街道', '4', '11357');
INSERT INTO `tp_region` VALUES ('11363', '桃花坞街道', '4', '11357');
INSERT INTO `tp_region` VALUES ('11364', '娄葑镇', '4', '11357');
INSERT INTO `tp_region` VALUES ('11365', '唯亭镇', '4', '11357');
INSERT INTO `tp_region` VALUES ('11366', '胜浦镇', '4', '11357');
INSERT INTO `tp_region` VALUES ('11367', '虚拟镇', '4', '11357');
INSERT INTO `tp_region` VALUES ('11368', '金阊区', '3', '11348');
INSERT INTO `tp_region` VALUES ('11369', '石路街道', '4', '11368');
INSERT INTO `tp_region` VALUES ('11370', '彩香街道', '4', '11368');
INSERT INTO `tp_region` VALUES ('11371', '留园街道', '4', '11368');
INSERT INTO `tp_region` VALUES ('11372', '虎丘街道', '4', '11368');
INSERT INTO `tp_region` VALUES ('11373', '白洋湾街道', '4', '11368');
INSERT INTO `tp_region` VALUES ('11374', '苏州高新区虎丘区', '3', '11348');
INSERT INTO `tp_region` VALUES ('11375', '横塘街道', '4', '11374');
INSERT INTO `tp_region` VALUES ('11376', '狮山街道', '4', '11374');
INSERT INTO `tp_region` VALUES ('11377', '枫桥街道', '4', '11374');
INSERT INTO `tp_region` VALUES ('11378', '镇湖街道', '4', '11374');
INSERT INTO `tp_region` VALUES ('11379', '浒墅关镇', '4', '11374');
INSERT INTO `tp_region` VALUES ('11380', '通安镇', '4', '11374');
INSERT INTO `tp_region` VALUES ('11381', '东渚镇', '4', '11374');
INSERT INTO `tp_region` VALUES ('11382', '高新区浒墅关开发分区', '4', '11374');
INSERT INTO `tp_region` VALUES ('11383', '苏州高新区出口加工区', '4', '11374');
INSERT INTO `tp_region` VALUES ('11384', '苏州高新技术创业服务中心', '4', '11374');
INSERT INTO `tp_region` VALUES ('11385', '苏州高新物流中心', '4', '11374');
INSERT INTO `tp_region` VALUES ('11386', '苏州科技城', '4', '11374');
INSERT INTO `tp_region` VALUES ('11387', '吴中区', '3', '11348');
INSERT INTO `tp_region` VALUES ('11388', '长桥街道', '4', '11387');
INSERT INTO `tp_region` VALUES ('11389', '越溪街道', '4', '11387');
INSERT INTO `tp_region` VALUES ('11390', '郭巷街道', '4', '11387');
INSERT INTO `tp_region` VALUES ('11391', '横泾街道', '4', '11387');
INSERT INTO `tp_region` VALUES ('11392', '香山街道', '4', '11387');
INSERT INTO `tp_region` VALUES ('11393', '苏苑街道', '4', '11387');
INSERT INTO `tp_region` VALUES ('11394', '龙西街道', '4', '11387');
INSERT INTO `tp_region` VALUES ('11395', '城南街道', '4', '11387');
INSERT INTO `tp_region` VALUES ('11396', '甪直镇', '4', '11387');
INSERT INTO `tp_region` VALUES ('11397', '车坊镇', '4', '11387');
INSERT INTO `tp_region` VALUES ('11398', '藏书镇', '4', '11387');
INSERT INTO `tp_region` VALUES ('11399', '木渎镇', '4', '11387');
INSERT INTO `tp_region` VALUES ('11400', '胥口镇', '4', '11387');
INSERT INTO `tp_region` VALUES ('11401', '浦庄镇', '4', '11387');
INSERT INTO `tp_region` VALUES ('11402', '渡村镇', '4', '11387');
INSERT INTO `tp_region` VALUES ('11403', '东山镇', '4', '11387');
INSERT INTO `tp_region` VALUES ('11404', '光福镇', '4', '11387');
INSERT INTO `tp_region` VALUES ('11405', '西山镇', '4', '11387');
INSERT INTO `tp_region` VALUES ('11406', '江苏省太湖采石公司', '4', '11387');
INSERT INTO `tp_region` VALUES ('11407', '吴中区林场', '4', '11387');
INSERT INTO `tp_region` VALUES ('11408', '西山农业园区', '4', '11387');
INSERT INTO `tp_region` VALUES ('11409', '相城区', '3', '11348');
INSERT INTO `tp_region` VALUES ('11410', '元和街道', '4', '11409');
INSERT INTO `tp_region` VALUES ('11411', '太平街道', '4', '11409');
INSERT INTO `tp_region` VALUES ('11412', '黄桥街道', '4', '11409');
INSERT INTO `tp_region` VALUES ('11413', '望亭镇', '4', '11409');
INSERT INTO `tp_region` VALUES ('11414', '黄埭镇', '4', '11409');
INSERT INTO `tp_region` VALUES ('11415', '渭塘镇', '4', '11409');
INSERT INTO `tp_region` VALUES ('11416', '北桥镇', '4', '11409');
INSERT INTO `tp_region` VALUES ('11417', '阳澄湖镇', '4', '11409');
INSERT INTO `tp_region` VALUES ('11418', '开发区', '4', '11409');
INSERT INTO `tp_region` VALUES ('11419', '常熟市', '3', '11348');
INSERT INTO `tp_region` VALUES ('11420', '虞山镇', '4', '11419');
INSERT INTO `tp_region` VALUES ('11421', '梅李镇', '4', '11419');
INSERT INTO `tp_region` VALUES ('11422', '海虞镇', '4', '11419');
INSERT INTO `tp_region` VALUES ('11423', '新港镇', '4', '11419');
INSERT INTO `tp_region` VALUES ('11424', '古里镇', '4', '11419');
INSERT INTO `tp_region` VALUES ('11425', '沙家浜镇', '4', '11419');
INSERT INTO `tp_region` VALUES ('11426', '支塘镇', '4', '11419');
INSERT INTO `tp_region` VALUES ('11427', '董浜镇', '4', '11419');
INSERT INTO `tp_region` VALUES ('11428', '辛庄镇', '4', '11419');
INSERT INTO `tp_region` VALUES ('11429', '尚湖镇', '4', '11419');
INSERT INTO `tp_region` VALUES ('11430', '虞山林场', '4', '11419');
INSERT INTO `tp_region` VALUES ('11431', '常熟经济开发区', '4', '11419');
INSERT INTO `tp_region` VALUES ('11432', '常熟东南开发区', '4', '11419');
INSERT INTO `tp_region` VALUES ('11433', '张家港市', '3', '11348');
INSERT INTO `tp_region` VALUES ('11434', '杨舍镇', '4', '11433');
INSERT INTO `tp_region` VALUES ('11435', '塘桥镇', '4', '11433');
INSERT INTO `tp_region` VALUES ('11436', '金港镇', '4', '11433');
INSERT INTO `tp_region` VALUES ('11437', '锦丰镇', '4', '11433');
INSERT INTO `tp_region` VALUES ('11438', '乐余镇', '4', '11433');
INSERT INTO `tp_region` VALUES ('11439', '凤凰镇', '4', '11433');
INSERT INTO `tp_region` VALUES ('11440', '南丰镇', '4', '11433');
INSERT INTO `tp_region` VALUES ('11441', '大新镇', '4', '11433');
INSERT INTO `tp_region` VALUES ('11442', '常阴沙管理区', '4', '11433');
INSERT INTO `tp_region` VALUES ('11443', '江苏省张家港经济技术开发区', '4', '11433');
INSERT INTO `tp_region` VALUES ('11444', '张家港市沿江开发办', '4', '11433');
INSERT INTO `tp_region` VALUES ('11445', '张家港保税区', '4', '11433');
INSERT INTO `tp_region` VALUES ('11446', '张家港市稻麦良种场', '4', '11433');
INSERT INTO `tp_region` VALUES ('11447', '张家港市畜禽良种场', '4', '11433');
INSERT INTO `tp_region` VALUES ('11448', '昆山市', '3', '11348');
INSERT INTO `tp_region` VALUES ('11449', '玉山镇', '4', '11448');
INSERT INTO `tp_region` VALUES ('11450', '巴城镇', '4', '11448');
INSERT INTO `tp_region` VALUES ('11451', '周市镇', '4', '11448');
INSERT INTO `tp_region` VALUES ('11452', '陆家镇', '4', '11448');
INSERT INTO `tp_region` VALUES ('11453', '花桥镇', '4', '11448');
INSERT INTO `tp_region` VALUES ('11454', '淀山湖镇', '4', '11448');
INSERT INTO `tp_region` VALUES ('11455', '张浦镇', '4', '11448');
INSERT INTO `tp_region` VALUES ('11456', '周庄镇', '4', '11448');
INSERT INTO `tp_region` VALUES ('11457', '千灯镇', '4', '11448');
INSERT INTO `tp_region` VALUES ('11458', '锦溪镇', '4', '11448');
INSERT INTO `tp_region` VALUES ('11459', '开发区', '4', '11448');
INSERT INTO `tp_region` VALUES ('11460', '吴江市', '3', '11348');
INSERT INTO `tp_region` VALUES ('11461', '松陵镇', '4', '11460');
INSERT INTO `tp_region` VALUES ('11462', '同里镇', '4', '11460');
INSERT INTO `tp_region` VALUES ('11463', '平望镇', '4', '11460');
INSERT INTO `tp_region` VALUES ('11464', '盛泽镇', '4', '11460');
INSERT INTO `tp_region` VALUES ('11465', '横扇镇', '4', '11460');
INSERT INTO `tp_region` VALUES ('11466', '七都镇', '4', '11460');
INSERT INTO `tp_region` VALUES ('11467', '震泽镇', '4', '11460');
INSERT INTO `tp_region` VALUES ('11468', '桃源镇', '4', '11460');
INSERT INTO `tp_region` VALUES ('11469', '汾湖镇', '4', '11460');
INSERT INTO `tp_region` VALUES ('11470', '经济开发区', '4', '11460');
INSERT INTO `tp_region` VALUES ('11471', '东方丝绸市场', '4', '11460');
INSERT INTO `tp_region` VALUES ('11472', '太仓市', '3', '11348');
INSERT INTO `tp_region` VALUES ('11473', '城厢镇', '4', '11472');
INSERT INTO `tp_region` VALUES ('11474', '沙溪镇', '4', '11472');
INSERT INTO `tp_region` VALUES ('11475', '浏河镇', '4', '11472');
INSERT INTO `tp_region` VALUES ('11476', '浮桥镇', '4', '11472');
INSERT INTO `tp_region` VALUES ('11477', '璜泾镇', '4', '11472');
INSERT INTO `tp_region` VALUES ('11478', '双凤镇', '4', '11472');
INSERT INTO `tp_region` VALUES ('11479', '陆渡镇', '4', '11472');
INSERT INTO `tp_region` VALUES ('11480', '经济开发区', '4', '11472');
INSERT INTO `tp_region` VALUES ('11481', '港区', '4', '11472');
INSERT INTO `tp_region` VALUES ('11482', '南通市', '2', '10808');
INSERT INTO `tp_region` VALUES ('11483', '市辖区', '3', '11482');
INSERT INTO `tp_region` VALUES ('11484', '崇川区', '3', '11482');
INSERT INTO `tp_region` VALUES ('11485', '城东街道', '4', '11484');
INSERT INTO `tp_region` VALUES ('11486', '和平桥街道', '4', '11484');
INSERT INTO `tp_region` VALUES ('11487', '任港街道', '4', '11484');
INSERT INTO `tp_region` VALUES ('11488', '新城桥街道', '4', '11484');
INSERT INTO `tp_region` VALUES ('11489', '虹桥街道', '4', '11484');
INSERT INTO `tp_region` VALUES ('11490', '学田街道', '4', '11484');
INSERT INTO `tp_region` VALUES ('11491', '钟秀街道', '4', '11484');
INSERT INTO `tp_region` VALUES ('11492', '文峰街道', '4', '11484');
INSERT INTO `tp_region` VALUES ('11493', '中兴街道', '4', '11484');
INSERT INTO `tp_region` VALUES ('11494', '观音山镇', '4', '11484');
INSERT INTO `tp_region` VALUES ('11495', '狼山镇', '4', '11484');
INSERT INTO `tp_region` VALUES ('11496', '新开镇', '4', '11484');
INSERT INTO `tp_region` VALUES ('11497', '竹行镇', '4', '11484');
INSERT INTO `tp_region` VALUES ('11498', '小海镇', '4', '11484');
INSERT INTO `tp_region` VALUES ('11499', '江苏省国营南通农场', '4', '11484');
INSERT INTO `tp_region` VALUES ('11500', '南通市富民港良种场', '4', '11484');
INSERT INTO `tp_region` VALUES ('11501', '南通市富民港种畜场', '4', '11484');
INSERT INTO `tp_region` VALUES ('11502', '港闸区', '3', '11482');
INSERT INTO `tp_region` VALUES ('11503', '永兴街道', '4', '11502');
INSERT INTO `tp_region` VALUES ('11504', '唐闸镇街道', '4', '11502');
INSERT INTO `tp_region` VALUES ('11505', '天生港镇街道', '4', '11502');
INSERT INTO `tp_region` VALUES ('11506', '秦灶街道', '4', '11502');
INSERT INTO `tp_region` VALUES ('11507', '陈桥乡', '4', '11502');
INSERT INTO `tp_region` VALUES ('11508', '幸福乡', '4', '11502');
INSERT INTO `tp_region` VALUES ('11509', '港闸开发区', '4', '11502');
INSERT INTO `tp_region` VALUES ('11510', '海安县', '3', '11482');
INSERT INTO `tp_region` VALUES ('11511', '海安镇', '4', '11510');
INSERT INTO `tp_region` VALUES ('11512', '城东镇', '4', '11510');
INSERT INTO `tp_region` VALUES ('11513', '曲塘镇', '4', '11510');
INSERT INTO `tp_region` VALUES ('11514', '李堡镇', '4', '11510');
INSERT INTO `tp_region` VALUES ('11515', '老坝港镇', '4', '11510');
INSERT INTO `tp_region` VALUES ('11516', '角斜镇', '4', '11510');
INSERT INTO `tp_region` VALUES ('11517', '西场镇', '4', '11510');
INSERT INTO `tp_region` VALUES ('11518', '大公镇', '4', '11510');
INSERT INTO `tp_region` VALUES ('11519', '孙庄镇', '4', '11510');
INSERT INTO `tp_region` VALUES ('11520', '雅周镇', '4', '11510');
INSERT INTO `tp_region` VALUES ('11521', '胡集镇', '4', '11510');
INSERT INTO `tp_region` VALUES ('11522', '白甸镇', '4', '11510');
INSERT INTO `tp_region` VALUES ('11523', '南莫镇', '4', '11510');
INSERT INTO `tp_region` VALUES ('11524', '墩头镇', '4', '11510');
INSERT INTO `tp_region` VALUES ('11525', '海安县农场', '4', '11510');
INSERT INTO `tp_region` VALUES ('11526', '如东', '3', '11482');
INSERT INTO `tp_region` VALUES ('11527', '栟茶镇', '4', '11526');
INSERT INTO `tp_region` VALUES ('11528', '洋口镇', '4', '11526');
INSERT INTO `tp_region` VALUES ('11529', '苴镇', '4', '11526');
INSERT INTO `tp_region` VALUES ('11530', '长沙镇', '4', '11526');
INSERT INTO `tp_region` VALUES ('11531', '大豫镇', '4', '11526');
INSERT INTO `tp_region` VALUES ('11532', '掘港镇', '4', '11526');
INSERT INTO `tp_region` VALUES ('11533', '兵房镇', '4', '11526');
INSERT INTO `tp_region` VALUES ('11534', '马塘镇', '4', '11526');
INSERT INTO `tp_region` VALUES ('11535', '丰利镇', '4', '11526');
INSERT INTO `tp_region` VALUES ('11536', '曹埠镇', '4', '11526');
INSERT INTO `tp_region` VALUES ('11537', '岔河镇', '4', '11526');
INSERT INTO `tp_region` VALUES ('11538', '双甸镇', '4', '11526');
INSERT INTO `tp_region` VALUES ('11539', '新店镇', '4', '11526');
INSERT INTO `tp_region` VALUES ('11540', '河口镇', '4', '11526');
INSERT INTO `tp_region` VALUES ('11541', '袁庄镇', '4', '11526');
INSERT INTO `tp_region` VALUES ('11542', '启东市', '3', '11482');
INSERT INTO `tp_region` VALUES ('11543', '汇龙镇', '4', '11542');
INSERT INTO `tp_region` VALUES ('11544', '大兴镇', '4', '11542');
INSERT INTO `tp_region` VALUES ('11545', '南阳镇', '4', '11542');
INSERT INTO `tp_region` VALUES ('11546', '惠丰镇', '4', '11542');
INSERT INTO `tp_region` VALUES ('11547', '民主镇', '4', '11542');
INSERT INTO `tp_region` VALUES ('11548', '北新镇', '4', '11542');
INSERT INTO `tp_region` VALUES ('11549', '久隆镇', '4', '11542');
INSERT INTO `tp_region` VALUES ('11550', '王鲍镇', '4', '11542');
INSERT INTO `tp_region` VALUES ('11551', '合作镇', '4', '11542');
INSERT INTO `tp_region` VALUES ('11552', '志良镇', '4', '11542');
INSERT INTO `tp_region` VALUES ('11553', '吕四港镇', '4', '11542');
INSERT INTO `tp_region` VALUES ('11554', '天汾镇', '4', '11542');
INSERT INTO `tp_region` VALUES ('11555', '兆民镇', '4', '11542');
INSERT INTO `tp_region` VALUES ('11556', '海复镇', '4', '11542');
INSERT INTO `tp_region` VALUES ('11557', '少直镇', '4', '11542');
INSERT INTO `tp_region` VALUES ('11558', '向阳镇', '4', '11542');
INSERT INTO `tp_region` VALUES ('11559', '东元镇', '4', '11542');
INSERT INTO `tp_region` VALUES ('11560', '近海镇', '4', '11542');
INSERT INTO `tp_region` VALUES ('11561', '寅阳镇', '4', '11542');
INSERT INTO `tp_region` VALUES ('11562', '和合镇', '4', '11542');
INSERT INTO `tp_region` VALUES ('11563', '惠萍镇', '4', '11542');
INSERT INTO `tp_region` VALUES ('11564', '新安镇', '4', '11542');
INSERT INTO `tp_region` VALUES ('11565', '东海镇', '4', '11542');
INSERT INTO `tp_region` VALUES ('11566', '启隆乡', '4', '11542');
INSERT INTO `tp_region` VALUES ('11567', '启东经济开发区', '4', '11542');
INSERT INTO `tp_region` VALUES ('11568', '如皋市', '3', '11482');
INSERT INTO `tp_region` VALUES ('11569', '如城镇', '4', '11568');
INSERT INTO `tp_region` VALUES ('11570', '柴湾镇', '4', '11568');
INSERT INTO `tp_region` VALUES ('11571', '雪岸镇', '4', '11568');
INSERT INTO `tp_region` VALUES ('11572', '东陈镇', '4', '11568');
INSERT INTO `tp_region` VALUES ('11573', '丁堰镇', '4', '11568');
INSERT INTO `tp_region` VALUES ('11574', '白蒲镇', '4', '11568');
INSERT INTO `tp_region` VALUES ('11575', '林梓镇', '4', '11568');
INSERT INTO `tp_region` VALUES ('11576', '下原镇', '4', '11568');
INSERT INTO `tp_region` VALUES ('11577', '九华镇', '4', '11568');
INSERT INTO `tp_region` VALUES ('11578', '郭园镇', '4', '11568');
INSERT INTO `tp_region` VALUES ('11579', '石庄镇', '4', '11568');
INSERT INTO `tp_region` VALUES ('11580', '长江镇', '4', '11568');
INSERT INTO `tp_region` VALUES ('11581', '吴窑镇', '4', '11568');
INSERT INTO `tp_region` VALUES ('11582', '江安镇', '4', '11568');
INSERT INTO `tp_region` VALUES ('11583', '高明镇', '4', '11568');
INSERT INTO `tp_region` VALUES ('11584', '常青镇', '4', '11568');
INSERT INTO `tp_region` VALUES ('11585', '搬经镇', '4', '11568');
INSERT INTO `tp_region` VALUES ('11586', '磨头镇', '4', '11568');
INSERT INTO `tp_region` VALUES ('11587', '桃园镇', '4', '11568');
INSERT INTO `tp_region` VALUES ('11588', '袁桥镇', '4', '11568');
INSERT INTO `tp_region` VALUES ('11589', '如皋市经济开发区', '4', '11568');
INSERT INTO `tp_region` VALUES ('11590', '如皋港开发区', '4', '11568');
INSERT INTO `tp_region` VALUES ('11591', '南通市粮棉原种场', '4', '11568');
INSERT INTO `tp_region` VALUES ('11592', '如皋市蚕种场', '4', '11568');
INSERT INTO `tp_region` VALUES ('11593', '如皋市良种场', '4', '11568');
INSERT INTO `tp_region` VALUES ('11594', '如皋市棉花原种场', '4', '11568');
INSERT INTO `tp_region` VALUES ('11595', '如皋市种猪场', '4', '11568');
INSERT INTO `tp_region` VALUES ('11596', '如皋市农科所', '4', '11568');
INSERT INTO `tp_region` VALUES ('11597', '如皋市江滨医院', '4', '11568');
INSERT INTO `tp_region` VALUES ('11598', '如皋市中心沙水产养殖场', '4', '11568');
INSERT INTO `tp_region` VALUES ('11599', '如皋市九华水产养殖场', '4', '11568');
INSERT INTO `tp_region` VALUES ('11600', '通州市', '3', '11482');
INSERT INTO `tp_region` VALUES ('11601', '金沙镇', '4', '11600');
INSERT INTO `tp_region` VALUES ('11602', '西亭镇', '4', '11600');
INSERT INTO `tp_region` VALUES ('11603', '二甲镇', '4', '11600');
INSERT INTO `tp_region` VALUES ('11604', '东社镇', '4', '11600');
INSERT INTO `tp_region` VALUES ('11605', '三余镇', '4', '11600');
INSERT INTO `tp_region` VALUES ('11606', '北兴桥镇', '4', '11600');
INSERT INTO `tp_region` VALUES ('11607', '海晏镇', '4', '11600');
INSERT INTO `tp_region` VALUES ('11608', '十总镇', '4', '11600');
INSERT INTO `tp_region` VALUES ('11609', '骑岸镇', '4', '11600');
INSERT INTO `tp_region` VALUES ('11610', '五甲镇', '4', '11600');
INSERT INTO `tp_region` VALUES ('11611', '石港镇', '4', '11600');
INSERT INTO `tp_region` VALUES ('11612', '四安镇', '4', '11600');
INSERT INTO `tp_region` VALUES ('11613', '刘桥镇', '4', '11600');
INSERT INTO `tp_region` VALUES ('11614', '新联镇', '4', '11600');
INSERT INTO `tp_region` VALUES ('11615', '平潮镇', '4', '11600');
INSERT INTO `tp_region` VALUES ('11616', '平东镇', '4', '11600');
INSERT INTO `tp_region` VALUES ('11617', '五接镇', '4', '11600');
INSERT INTO `tp_region` VALUES ('11618', '兴仁镇', '4', '11600');
INSERT INTO `tp_region` VALUES ('11619', '兴东镇', '4', '11600');
INSERT INTO `tp_region` VALUES ('11620', '张芝山镇', '4', '11600');
INSERT INTO `tp_region` VALUES ('11621', '川港镇', '4', '11600');
INSERT INTO `tp_region` VALUES ('11622', '先锋镇', '4', '11600');
INSERT INTO `tp_region` VALUES ('11623', '姜灶镇', '4', '11600');
INSERT INTO `tp_region` VALUES ('11624', '通州市开发区', '4', '11600');
INSERT INTO `tp_region` VALUES ('11625', '环本农场', '4', '11600');
INSERT INTO `tp_region` VALUES ('11626', '通州港区管委会', '4', '11600');
INSERT INTO `tp_region` VALUES ('11627', '海门市', '3', '11482');
INSERT INTO `tp_region` VALUES ('11628', '海门镇', '4', '11627');
INSERT INTO `tp_region` VALUES ('11629', '三星镇', '4', '11627');
INSERT INTO `tp_region` VALUES ('11630', '天补镇', '4', '11627');
INSERT INTO `tp_region` VALUES ('11631', '三和镇', '4', '11627');
INSERT INTO `tp_region` VALUES ('11632', '德胜镇', '4', '11627');
INSERT INTO `tp_region` VALUES ('11633', '三厂镇', '4', '11627');
INSERT INTO `tp_region` VALUES ('11634', '常乐镇', '4', '11627');
INSERT INTO `tp_region` VALUES ('11635', '麒麟镇', '4', '11627');
INSERT INTO `tp_region` VALUES ('11636', '悦来镇', '4', '11627');
INSERT INTO `tp_region` VALUES ('11637', '万年镇', '4', '11627');
INSERT INTO `tp_region` VALUES ('11638', '三阳镇', '4', '11627');
INSERT INTO `tp_region` VALUES ('11639', '四甲镇', '4', '11627');
INSERT INTO `tp_region` VALUES ('11640', '货隆镇', '4', '11627');
INSERT INTO `tp_region` VALUES ('11641', '余东镇', '4', '11627');
INSERT INTO `tp_region` VALUES ('11642', '正余镇', '4', '11627');
INSERT INTO `tp_region` VALUES ('11643', '包场镇', '4', '11627');
INSERT INTO `tp_region` VALUES ('11644', '刘浩镇', '4', '11627');
INSERT INTO `tp_region` VALUES ('11645', '东灶港镇', '4', '11627');
INSERT INTO `tp_region` VALUES ('11646', '临江镇', '4', '11627');
INSERT INTO `tp_region` VALUES ('11647', '王浩镇', '4', '11627');
INSERT INTO `tp_region` VALUES ('11648', '树勋镇', '4', '11627');
INSERT INTO `tp_region` VALUES ('11649', '海永乡', '4', '11627');
INSERT INTO `tp_region` VALUES ('11650', '海门市经济技术开发区', '4', '11627');
INSERT INTO `tp_region` VALUES ('11651', '海门市永隆沙农场', '4', '11627');
INSERT INTO `tp_region` VALUES ('11652', '海门市大东农场', '4', '11627');
INSERT INTO `tp_region` VALUES ('11653', '海门市畜禽良种场', '4', '11627');
INSERT INTO `tp_region` VALUES ('11654', '海门市种羊场', '4', '11627');
INSERT INTO `tp_region` VALUES ('11655', '海门市包场渔场', '4', '11627');
INSERT INTO `tp_region` VALUES ('11656', '海门市长江芦荡养殖场', '4', '11627');
INSERT INTO `tp_region` VALUES ('11657', '海门市沿江渔场', '4', '11627');
INSERT INTO `tp_region` VALUES ('11658', '海门市三厂苗圃', '4', '11627');
INSERT INTO `tp_region` VALUES ('11659', '海门市农科所', '4', '11627');
INSERT INTO `tp_region` VALUES ('11660', '海门市海门盐场', '4', '11627');
INSERT INTO `tp_region` VALUES ('11661', '海门市财政局芦荡管理所', '4', '11627');
INSERT INTO `tp_region` VALUES ('11662', '江苏省国营江心沙农场', '4', '11627');
INSERT INTO `tp_region` VALUES ('11663', '连云港市', '2', '10808');
INSERT INTO `tp_region` VALUES ('11664', '市辖区', '3', '11663');
INSERT INTO `tp_region` VALUES ('11665', '连云区', '3', '11663');
INSERT INTO `tp_region` VALUES ('11666', '墟沟街道', '4', '11665');
INSERT INTO `tp_region` VALUES ('11667', '连云街道', '4', '11665');
INSERT INTO `tp_region` VALUES ('11668', '云山街道', '4', '11665');
INSERT INTO `tp_region` VALUES ('11669', '板桥街道', '4', '11665');
INSERT INTO `tp_region` VALUES ('11670', '连岛街道', '4', '11665');
INSERT INTO `tp_region` VALUES ('11671', '中云街道', '4', '11665');
INSERT INTO `tp_region` VALUES ('11672', '猴嘴街道', '4', '11665');
INSERT INTO `tp_region` VALUES ('11673', '朝阳镇', '4', '11665');
INSERT INTO `tp_region` VALUES ('11674', '宿城乡', '4', '11665');
INSERT INTO `tp_region` VALUES ('11675', '高公岛乡', '4', '11665');
INSERT INTO `tp_region` VALUES ('11676', '前三岛乡', '4', '11665');
INSERT INTO `tp_region` VALUES ('11677', '连云港碱厂', '4', '11665');
INSERT INTO `tp_region` VALUES ('11678', '新浦区', '3', '11663');
INSERT INTO `tp_region` VALUES ('11679', '浦东街道', '4', '11678');
INSERT INTO `tp_region` VALUES ('11680', '浦西街道', '4', '11678');
INSERT INTO `tp_region` VALUES ('11681', '新东街道', '4', '11678');
INSERT INTO `tp_region` VALUES ('11682', '新南街道', '4', '11678');
INSERT INTO `tp_region` VALUES ('11683', '路南街道', '4', '11678');
INSERT INTO `tp_region` VALUES ('11684', '新海街道', '4', '11678');
INSERT INTO `tp_region` VALUES ('11685', '南城镇', '4', '11678');
INSERT INTO `tp_region` VALUES ('11686', '云台乡', '4', '11678');
INSERT INTO `tp_region` VALUES ('11687', '花果山乡', '4', '11678');
INSERT INTO `tp_region` VALUES ('11688', '宁海乡', '4', '11678');
INSERT INTO `tp_region` VALUES ('11689', '云台农场', '4', '11678');
INSERT INTO `tp_region` VALUES ('11690', '南云台林场', '4', '11678');
INSERT INTO `tp_region` VALUES ('11691', '花果山风景区', '4', '11678');
INSERT INTO `tp_region` VALUES ('11692', '海州区', '3', '11663');
INSERT INTO `tp_region` VALUES ('11693', '海州街道', '4', '11692');
INSERT INTO `tp_region` VALUES ('11694', '幸福路街道', '4', '11692');
INSERT INTO `tp_region` VALUES ('11695', '朐阳街道', '4', '11692');
INSERT INTO `tp_region` VALUES ('11696', '洪门街道', '4', '11692');
INSERT INTO `tp_region` VALUES ('11697', '新坝镇', '4', '11692');
INSERT INTO `tp_region` VALUES ('11698', '锦屏镇', '4', '11692');
INSERT INTO `tp_region` VALUES ('11699', '赣榆县', '3', '11663');
INSERT INTO `tp_region` VALUES ('11700', '青口镇', '4', '11699');
INSERT INTO `tp_region` VALUES ('11701', '柘汪镇', '4', '11699');
INSERT INTO `tp_region` VALUES ('11702', '石桥镇', '4', '11699');
INSERT INTO `tp_region` VALUES ('11703', '金山镇', '4', '11699');
INSERT INTO `tp_region` VALUES ('11704', '黑林镇', '4', '11699');
INSERT INTO `tp_region` VALUES ('11705', '厉庄镇', '4', '11699');
INSERT INTO `tp_region` VALUES ('11706', '海头镇', '4', '11699');
INSERT INTO `tp_region` VALUES ('11707', '塔山镇', '4', '11699');
INSERT INTO `tp_region` VALUES ('11708', '赣马镇', '4', '11699');
INSERT INTO `tp_region` VALUES ('11709', '班庄镇', '4', '11699');
INSERT INTO `tp_region` VALUES ('11710', '城头镇', '4', '11699');
INSERT INTO `tp_region` VALUES ('11711', '门河镇', '4', '11699');
INSERT INTO `tp_region` VALUES ('11712', '城西镇', '4', '11699');
INSERT INTO `tp_region` VALUES ('11713', '欢墩镇', '4', '11699');
INSERT INTO `tp_region` VALUES ('11714', '宋庄镇', '4', '11699');
INSERT INTO `tp_region` VALUES ('11715', '沙河镇', '4', '11699');
INSERT INTO `tp_region` VALUES ('11716', '墩尚镇', '4', '11699');
INSERT INTO `tp_region` VALUES ('11717', '罗阳镇', '4', '11699');
INSERT INTO `tp_region` VALUES ('11718', '沙河子园艺场', '4', '11699');
INSERT INTO `tp_region` VALUES ('11719', '青口盐场', '4', '11699');
INSERT INTO `tp_region` VALUES ('11720', '江苏省赣榆海洋经济开发区', '4', '11699');
INSERT INTO `tp_region` VALUES ('11721', '江苏省赣榆经济开发区', '4', '11699');
INSERT INTO `tp_region` VALUES ('11722', '东海县', '3', '11663');
INSERT INTO `tp_region` VALUES ('11723', '牛山镇', '4', '11722');
INSERT INTO `tp_region` VALUES ('11724', '白塔埠镇', '4', '11722');
INSERT INTO `tp_region` VALUES ('11725', '浦南镇', '4', '11722');
INSERT INTO `tp_region` VALUES ('11726', '黄川镇', '4', '11722');
INSERT INTO `tp_region` VALUES ('11727', '石梁河镇', '4', '11722');
INSERT INTO `tp_region` VALUES ('11728', '青湖镇', '4', '11722');
INSERT INTO `tp_region` VALUES ('11729', '石榴镇', '4', '11722');
INSERT INTO `tp_region` VALUES ('11730', '温泉镇', '4', '11722');
INSERT INTO `tp_region` VALUES ('11731', '双店镇', '4', '11722');
INSERT INTO `tp_region` VALUES ('11732', '桃林镇', '4', '11722');
INSERT INTO `tp_region` VALUES ('11733', '洪庄镇', '4', '11722');
INSERT INTO `tp_region` VALUES ('11734', '安峰镇', '4', '11722');
INSERT INTO `tp_region` VALUES ('11735', '房山镇', '4', '11722');
INSERT INTO `tp_region` VALUES ('11736', '平明镇', '4', '11722');
INSERT INTO `tp_region` VALUES ('11737', '驼峰乡', '4', '11722');
INSERT INTO `tp_region` VALUES ('11738', '南辰乡', '4', '11722');
INSERT INTO `tp_region` VALUES ('11739', '横沟乡', '4', '11722');
INSERT INTO `tp_region` VALUES ('11740', '李埝乡', '4', '11722');
INSERT INTO `tp_region` VALUES ('11741', '山左口乡', '4', '11722');
INSERT INTO `tp_region` VALUES ('11742', '石湖乡', '4', '11722');
INSERT INTO `tp_region` VALUES ('11743', '曲阳乡', '4', '11722');
INSERT INTO `tp_region` VALUES ('11744', '张湾乡', '4', '11722');
INSERT INTO `tp_region` VALUES ('11745', '岗埠农场', '4', '11722');
INSERT INTO `tp_region` VALUES ('11746', '江苏东海经济开发区', '4', '11722');
INSERT INTO `tp_region` VALUES ('11747', '灌云县', '3', '11663');
INSERT INTO `tp_region` VALUES ('11748', '伊山镇', '4', '11747');
INSERT INTO `tp_region` VALUES ('11749', '板浦镇', '4', '11747');
INSERT INTO `tp_region` VALUES ('11750', '杨集镇', '4', '11747');
INSERT INTO `tp_region` VALUES ('11751', '燕尾港镇', '4', '11747');
INSERT INTO `tp_region` VALUES ('11752', '同兴镇', '4', '11747');
INSERT INTO `tp_region` VALUES ('11753', '四队镇', '4', '11747');
INSERT INTO `tp_region` VALUES ('11754', '圩丰镇', '4', '11747');
INSERT INTO `tp_region` VALUES ('11755', '龙苴镇', '4', '11747');
INSERT INTO `tp_region` VALUES ('11756', '伊芦乡', '4', '11747');
INSERT INTO `tp_region` VALUES ('11757', '鲁河乡', '4', '11747');
INSERT INTO `tp_region` VALUES ('11758', '图河乡', '4', '11747');
INSERT INTO `tp_region` VALUES ('11759', '沂北乡', '4', '11747');
INSERT INTO `tp_region` VALUES ('11760', '下车乡', '4', '11747');
INSERT INTO `tp_region` VALUES ('11761', '白蚬乡', '4', '11747');
INSERT INTO `tp_region` VALUES ('11762', '东王集乡', '4', '11747');
INSERT INTO `tp_region` VALUES ('11763', '侍庄乡', '4', '11747');
INSERT INTO `tp_region` VALUES ('11764', '小伊乡', '4', '11747');
INSERT INTO `tp_region` VALUES ('11765', '穆圩乡', '4', '11747');
INSERT INTO `tp_region` VALUES ('11766', '陡沟乡', '4', '11747');
INSERT INTO `tp_region` VALUES ('11767', '南岗乡', '4', '11747');
INSERT INTO `tp_region` VALUES ('11768', '东辛农场', '4', '11747');
INSERT INTO `tp_region` VALUES ('11769', '五图河农场', '4', '11747');
INSERT INTO `tp_region` VALUES ('11770', '灌西盐场', '4', '11747');
INSERT INTO `tp_region` VALUES ('11771', '灌南县', '3', '11663');
INSERT INTO `tp_region` VALUES ('11772', '新安镇', '4', '11771');
INSERT INTO `tp_region` VALUES ('11773', '堆沟港镇', '4', '11771');
INSERT INTO `tp_region` VALUES ('11774', '长茂镇', '4', '11771');
INSERT INTO `tp_region` VALUES ('11775', '北陈集镇', '4', '11771');
INSERT INTO `tp_region` VALUES ('11776', '张店镇', '4', '11771');
INSERT INTO `tp_region` VALUES ('11777', '三口镇', '4', '11771');
INSERT INTO `tp_region` VALUES ('11778', '孟兴庄镇', '4', '11771');
INSERT INTO `tp_region` VALUES ('11779', '汤沟镇', '4', '11771');
INSERT INTO `tp_region` VALUES ('11780', '百禄镇', '4', '11771');
INSERT INTO `tp_region` VALUES ('11781', '五队乡', '4', '11771');
INSERT INTO `tp_region` VALUES ('11782', '田楼乡', '4', '11771');
INSERT INTO `tp_region` VALUES ('11783', '李集乡', '4', '11771');
INSERT INTO `tp_region` VALUES ('11784', '新集乡', '4', '11771');
INSERT INTO `tp_region` VALUES ('11785', '花园乡', '4', '11771');
INSERT INTO `tp_region` VALUES ('11786', '淮安市', '2', '10808');
INSERT INTO `tp_region` VALUES ('11787', '市辖区', '3', '11786');
INSERT INTO `tp_region` VALUES ('11788', '清河区', '3', '11786');
INSERT INTO `tp_region` VALUES ('11789', '北京路街道', '4', '11788');
INSERT INTO `tp_region` VALUES ('11790', '长西街道', '4', '11788');
INSERT INTO `tp_region` VALUES ('11791', '淮海街道', '4', '11788');
INSERT INTO `tp_region` VALUES ('11792', '长东街道', '4', '11788');
INSERT INTO `tp_region` VALUES ('11793', '西安路街道', '4', '11788');
INSERT INTO `tp_region` VALUES ('11794', '水渡口街道', '4', '11788');
INSERT INTO `tp_region` VALUES ('11795', '东湖街道', '4', '11788');
INSERT INTO `tp_region` VALUES ('11796', '新港街道', '4', '11788');
INSERT INTO `tp_region` VALUES ('11797', '广州路街道', '4', '11788');
INSERT INTO `tp_region` VALUES ('11798', '钵池乡', '4', '11788');
INSERT INTO `tp_region` VALUES ('11799', '徐杨乡', '4', '11788');
INSERT INTO `tp_region` VALUES ('11800', '京沪路', '4', '11788');
INSERT INTO `tp_region` VALUES ('11801', '楚州区', '3', '11786');
INSERT INTO `tp_region` VALUES ('11802', '淮城镇', '4', '11801');
INSERT INTO `tp_region` VALUES ('11803', '平桥镇', '4', '11801');
INSERT INTO `tp_region` VALUES ('11804', '上河镇', '4', '11801');
INSERT INTO `tp_region` VALUES ('11805', '马甸镇', '4', '11801');
INSERT INTO `tp_region` VALUES ('11806', '朱桥镇', '4', '11801');
INSERT INTO `tp_region` VALUES ('11807', '溪河镇', '4', '11801');
INSERT INTO `tp_region` VALUES ('11808', '施河镇', '4', '11801');
INSERT INTO `tp_region` VALUES ('11809', '车桥镇', '4', '11801');
INSERT INTO `tp_region` VALUES ('11810', '泾口镇', '4', '11801');
INSERT INTO `tp_region` VALUES ('11811', '流均镇', '4', '11801');
INSERT INTO `tp_region` VALUES ('11812', '博里镇', '4', '11801');
INSERT INTO `tp_region` VALUES ('11813', '仇桥镇', '4', '11801');
INSERT INTO `tp_region` VALUES ('11814', '复兴镇', '4', '11801');
INSERT INTO `tp_region` VALUES ('11815', '苏嘴镇', '4', '11801');
INSERT INTO `tp_region` VALUES ('11816', '钦工镇', '4', '11801');
INSERT INTO `tp_region` VALUES ('11817', '顺河镇', '4', '11801');
INSERT INTO `tp_region` VALUES ('11818', '季桥镇', '4', '11801');
INSERT INTO `tp_region` VALUES ('11819', '席桥镇', '4', '11801');
INSERT INTO `tp_region` VALUES ('11820', '林集镇', '4', '11801');
INSERT INTO `tp_region` VALUES ('11821', '南闸镇', '4', '11801');
INSERT INTO `tp_region` VALUES ('11822', '范集镇', '4', '11801');
INSERT INTO `tp_region` VALUES ('11823', '建淮乡', '4', '11801');
INSERT INTO `tp_region` VALUES ('11824', '茭陵乡', '4', '11801');
INSERT INTO `tp_region` VALUES ('11825', '宋集乡', '4', '11801');
INSERT INTO `tp_region` VALUES ('11826', '城东乡', '4', '11801');
INSERT INTO `tp_region` VALUES ('11827', '南马厂乡', '4', '11801');
INSERT INTO `tp_region` VALUES ('11828', '三堡乡', '4', '11801');
INSERT INTO `tp_region` VALUES ('11829', '白马湖农场', '4', '11801');
INSERT INTO `tp_region` VALUES ('11830', '淮阴区', '3', '11786');
INSERT INTO `tp_region` VALUES ('11831', '王营镇', '4', '11830');
INSERT INTO `tp_region` VALUES ('11832', '赵集镇', '4', '11830');
INSERT INTO `tp_region` VALUES ('11833', '吴城镇', '4', '11830');
INSERT INTO `tp_region` VALUES ('11834', '南陈集镇', '4', '11830');
INSERT INTO `tp_region` VALUES ('11835', '码头镇', '4', '11830');
INSERT INTO `tp_region` VALUES ('11836', '王兴镇', '4', '11830');
INSERT INTO `tp_region` VALUES ('11837', '棉花庄镇', '4', '11830');
INSERT INTO `tp_region` VALUES ('11838', '丁集镇', '4', '11830');
INSERT INTO `tp_region` VALUES ('11839', '五里镇', '4', '11830');
INSERT INTO `tp_region` VALUES ('11840', '徐溜镇', '4', '11830');
INSERT INTO `tp_region` VALUES ('11841', '渔沟镇', '4', '11830');
INSERT INTO `tp_region` VALUES ('11842', '吴集镇', '4', '11830');
INSERT INTO `tp_region` VALUES ('11843', '西宋集镇', '4', '11830');
INSERT INTO `tp_region` VALUES ('11844', '三树镇', '4', '11830');
INSERT INTO `tp_region` VALUES ('11845', '韩桥乡', '4', '11830');
INSERT INTO `tp_region` VALUES ('11846', '新渡乡', '4', '11830');
INSERT INTO `tp_region` VALUES ('11847', '老张集乡', '4', '11830');
INSERT INTO `tp_region` VALUES ('11848', '凌桥乡', '4', '11830');
INSERT INTO `tp_region` VALUES ('11849', '袁集乡', '4', '11830');
INSERT INTO `tp_region` VALUES ('11850', '刘老庄乡', '4', '11830');
INSERT INTO `tp_region` VALUES ('11851', '古寨乡', '4', '11830');
INSERT INTO `tp_region` VALUES ('11852', '工业园管理委员会', '4', '11830');
INSERT INTO `tp_region` VALUES ('11853', '清浦区', '3', '11786');
INSERT INTO `tp_region` VALUES ('11854', '清江街道', '4', '11853');
INSERT INTO `tp_region` VALUES ('11855', '浦楼街道', '4', '11853');
INSERT INTO `tp_region` VALUES ('11856', '闸口街道', '4', '11853');
INSERT INTO `tp_region` VALUES ('11857', '清安街道', '4', '11853');
INSERT INTO `tp_region` VALUES ('11858', '和平镇', '4', '11853');
INSERT INTO `tp_region` VALUES ('11859', '武墩镇', '4', '11853');
INSERT INTO `tp_region` VALUES ('11860', '盐河镇', '4', '11853');
INSERT INTO `tp_region` VALUES ('11861', '城南乡', '4', '11853');
INSERT INTO `tp_region` VALUES ('11862', '黄码乡', '4', '11853');
INSERT INTO `tp_region` VALUES ('11863', '涟水县', '3', '11786');
INSERT INTO `tp_region` VALUES ('11864', '涟城镇', '4', '11863');
INSERT INTO `tp_region` VALUES ('11865', '高沟镇', '4', '11863');
INSERT INTO `tp_region` VALUES ('11866', '唐集镇', '4', '11863');
INSERT INTO `tp_region` VALUES ('11867', '保滩镇', '4', '11863');
INSERT INTO `tp_region` VALUES ('11868', '大东镇', '4', '11863');
INSERT INTO `tp_region` VALUES ('11869', '五港镇', '4', '11863');
INSERT INTO `tp_region` VALUES ('11870', '梁岔镇', '4', '11863');
INSERT INTO `tp_region` VALUES ('11871', '石湖镇', '4', '11863');
INSERT INTO `tp_region` VALUES ('11872', '朱码镇', '4', '11863');
INSERT INTO `tp_region` VALUES ('11873', '岔庙镇', '4', '11863');
INSERT INTO `tp_region` VALUES ('11874', '东胡集镇', '4', '11863');
INSERT INTO `tp_region` VALUES ('11875', '南集镇', '4', '11863');
INSERT INTO `tp_region` VALUES ('11876', '义兴镇', '4', '11863');
INSERT INTO `tp_region` VALUES ('11877', '成集镇', '4', '11863');
INSERT INTO `tp_region` VALUES ('11878', '红窑镇', '4', '11863');
INSERT INTO `tp_region` VALUES ('11879', '陈师镇', '4', '11863');
INSERT INTO `tp_region` VALUES ('11880', '前进镇', '4', '11863');
INSERT INTO `tp_region` VALUES ('11881', '徐集乡', '4', '11863');
INSERT INTO `tp_region` VALUES ('11882', '黄营乡', '4', '11863');
INSERT INTO `tp_region` VALUES ('11883', '杨口', '4', '11863');
INSERT INTO `tp_region` VALUES ('11884', '方渡', '4', '11863');
INSERT INTO `tp_region` VALUES ('11885', '南禄', '4', '11863');
INSERT INTO `tp_region` VALUES ('11886', '小李集', '4', '11863');
INSERT INTO `tp_region` VALUES ('11887', '河网', '4', '11863');
INSERT INTO `tp_region` VALUES ('11888', '时码', '4', '11863');
INSERT INTO `tp_region` VALUES ('11889', '北集', '4', '11863');
INSERT INTO `tp_region` VALUES ('11890', '灰墩', '4', '11863');
INSERT INTO `tp_region` VALUES ('11891', '余圩', '4', '11863');
INSERT INTO `tp_region` VALUES ('11892', '浅集', '4', '11863');
INSERT INTO `tp_region` VALUES ('11893', '蒋庵', '4', '11863');
INSERT INTO `tp_region` VALUES ('11894', '经济开发新区', '4', '11863');
INSERT INTO `tp_region` VALUES ('11895', '经济开发区', '4', '11863');
INSERT INTO `tp_region` VALUES ('11896', '洪泽县', '3', '11786');
INSERT INTO `tp_region` VALUES ('11897', '高良涧镇', '4', '11896');
INSERT INTO `tp_region` VALUES ('11898', '蒋坝镇', '4', '11896');
INSERT INTO `tp_region` VALUES ('11899', '仁和镇', '4', '11896');
INSERT INTO `tp_region` VALUES ('11900', '岔河镇', '4', '11896');
INSERT INTO `tp_region` VALUES ('11901', '西顺河镇', '4', '11896');
INSERT INTO `tp_region` VALUES ('11902', '老子山镇', '4', '11896');
INSERT INTO `tp_region` VALUES ('11903', '三河镇', '4', '11896');
INSERT INTO `tp_region` VALUES ('11904', '朱坝镇', '4', '11896');
INSERT INTO `tp_region` VALUES ('11905', '黄集镇', '4', '11896');
INSERT INTO `tp_region` VALUES ('11906', '万集镇', '4', '11896');
INSERT INTO `tp_region` VALUES ('11907', '东双沟镇', '4', '11896');
INSERT INTO `tp_region` VALUES ('11908', '共和镇', '4', '11896');
INSERT INTO `tp_region` VALUES ('11909', '盱眙县', '3', '11786');
INSERT INTO `tp_region` VALUES ('11910', '盱城镇', '4', '11909');
INSERT INTO `tp_region` VALUES ('11911', '马坝镇', '4', '11909');
INSERT INTO `tp_region` VALUES ('11912', '官滩镇', '4', '11909');
INSERT INTO `tp_region` VALUES ('11913', '旧铺镇', '4', '11909');
INSERT INTO `tp_region` VALUES ('11914', '桂五镇', '4', '11909');
INSERT INTO `tp_region` VALUES ('11915', '管镇镇', '4', '11909');
INSERT INTO `tp_region` VALUES ('11916', '河桥镇', '4', '11909');
INSERT INTO `tp_region` VALUES ('11917', '鲍集镇', '4', '11909');
INSERT INTO `tp_region` VALUES ('11918', '黄花塘镇', '4', '11909');
INSERT INTO `tp_region` VALUES ('11919', '明祖陵镇', '4', '11909');
INSERT INTO `tp_region` VALUES ('11920', '铁佛镇', '4', '11909');
INSERT INTO `tp_region` VALUES ('11921', '淮河镇', '4', '11909');
INSERT INTO `tp_region` VALUES ('11922', '仇集镇', '4', '11909');
INSERT INTO `tp_region` VALUES ('11923', '观音寺镇', '4', '11909');
INSERT INTO `tp_region` VALUES ('11924', '维桥乡', '4', '11909');
INSERT INTO `tp_region` VALUES ('11925', '穆店乡', '4', '11909');
INSERT INTO `tp_region` VALUES ('11926', '王店乡', '4', '11909');
INSERT INTO `tp_region` VALUES ('11927', '古桑乡', '4', '11909');
INSERT INTO `tp_region` VALUES ('11928', '兴隆乡', '4', '11909');
INSERT INTO `tp_region` VALUES ('11929', '三河农场', '4', '11909');
INSERT INTO `tp_region` VALUES ('11930', '淮化集团', '4', '11909');
INSERT INTO `tp_region` VALUES ('11931', '金湖县', '3', '11786');
INSERT INTO `tp_region` VALUES ('11932', '黎城镇', '4', '11931');
INSERT INTO `tp_region` VALUES ('11933', '金南镇', '4', '11931');
INSERT INTO `tp_region` VALUES ('11934', '闵桥镇', '4', '11931');
INSERT INTO `tp_region` VALUES ('11935', '塔集镇', '4', '11931');
INSERT INTO `tp_region` VALUES ('11936', '银集镇', '4', '11931');
INSERT INTO `tp_region` VALUES ('11937', '涂沟镇', '4', '11931');
INSERT INTO `tp_region` VALUES ('11938', '前锋镇', '4', '11931');
INSERT INTO `tp_region` VALUES ('11939', '吕良镇', '4', '11931');
INSERT INTO `tp_region` VALUES ('11940', '陈桥镇', '4', '11931');
INSERT INTO `tp_region` VALUES ('11941', '金北镇', '4', '11931');
INSERT INTO `tp_region` VALUES ('11942', '戴楼镇', '4', '11931');
INSERT INTO `tp_region` VALUES ('11943', '宝应湖农场', '4', '11931');
INSERT INTO `tp_region` VALUES ('11944', '复兴圩农场', '4', '11931');
INSERT INTO `tp_region` VALUES ('11945', '粮棉原种场', '4', '11931');
INSERT INTO `tp_region` VALUES ('11946', '江苏金湖经济开发区', '4', '11931');
INSERT INTO `tp_region` VALUES ('11947', '盐城市', '2', '10808');
INSERT INTO `tp_region` VALUES ('11948', '市辖区', '3', '11947');
INSERT INTO `tp_region` VALUES ('11949', '亭湖区', '3', '11947');
INSERT INTO `tp_region` VALUES ('11950', '五星街道', '4', '11949');
INSERT INTO `tp_region` VALUES ('11951', '文峰街道', '4', '11949');
INSERT INTO `tp_region` VALUES ('11952', '先锋街道', '4', '11949');
INSERT INTO `tp_region` VALUES ('11953', '毓龙街道', '4', '11949');
INSERT INTO `tp_region` VALUES ('11954', '张庄街道', '4', '11949');
INSERT INTO `tp_region` VALUES ('11955', '黄海街道', '4', '11949');
INSERT INTO `tp_region` VALUES ('11956', '新洋街道', '4', '11949');
INSERT INTO `tp_region` VALUES ('11957', '大洋街道', '4', '11949');
INSERT INTO `tp_region` VALUES ('11958', '南洋镇', '4', '11949');
INSERT INTO `tp_region` VALUES ('11959', '亭湖区青墩镇', '4', '11949');
INSERT INTO `tp_region` VALUES ('11960', '新兴镇', '4', '11949');
INSERT INTO `tp_region` VALUES ('11961', '永丰镇', '4', '11949');
INSERT INTO `tp_region` VALUES ('11962', '便仓镇', '4', '11949');
INSERT INTO `tp_region` VALUES ('11963', '伍佑镇', '4', '11949');
INSERT INTO `tp_region` VALUES ('11964', '步凤镇', '4', '11949');
INSERT INTO `tp_region` VALUES ('11965', '开发区', '4', '11949');
INSERT INTO `tp_region` VALUES ('11966', '市开发区', '4', '11949');
INSERT INTO `tp_region` VALUES ('11967', '盐都区', '3', '11947');
INSERT INTO `tp_region` VALUES ('11968', '大纵湖镇', '4', '11967');
INSERT INTO `tp_region` VALUES ('11969', '北龙港镇', '4', '11967');
INSERT INTO `tp_region` VALUES ('11970', '楼王镇', '4', '11967');
INSERT INTO `tp_region` VALUES ('11971', '学富镇', '4', '11967');
INSERT INTO `tp_region` VALUES ('11972', '义丰镇', '4', '11967');
INSERT INTO `tp_region` VALUES ('11973', '尚庄镇', '4', '11967');
INSERT INTO `tp_region` VALUES ('11974', '葛武镇', '4', '11967');
INSERT INTO `tp_region` VALUES ('11975', '北蒋镇', '4', '11967');
INSERT INTO `tp_region` VALUES ('11976', '秦南镇', '4', '11967');
INSERT INTO `tp_region` VALUES ('11977', '龙冈镇', '4', '11967');
INSERT INTO `tp_region` VALUES ('11978', '潘黄镇', '4', '11967');
INSERT INTO `tp_region` VALUES ('11979', '郭猛镇', '4', '11967');
INSERT INTO `tp_region` VALUES ('11980', '大冈镇', '4', '11967');
INSERT INTO `tp_region` VALUES ('11981', '新区街道', '4', '11967');
INSERT INTO `tp_region` VALUES ('11982', '响水县', '3', '11947');
INSERT INTO `tp_region` VALUES ('11983', '响水镇', '4', '11982');
INSERT INTO `tp_region` VALUES ('11984', '陈家港镇', '4', '11982');
INSERT INTO `tp_region` VALUES ('11985', '小尖镇', '4', '11982');
INSERT INTO `tp_region` VALUES ('11986', '黄圩镇', '4', '11982');
INSERT INTO `tp_region` VALUES ('11987', '大有镇', '4', '11982');
INSERT INTO `tp_region` VALUES ('11988', '双港镇', '4', '11982');
INSERT INTO `tp_region` VALUES ('11989', '南河镇', '4', '11982');
INSERT INTO `tp_region` VALUES ('11990', '运河镇', '4', '11982');
INSERT INTO `tp_region` VALUES ('11991', '张集乡', '4', '11982');
INSERT INTO `tp_region` VALUES ('11992', '六套乡', '4', '11982');
INSERT INTO `tp_region` VALUES ('11993', '七套乡', '4', '11982');
INSERT INTO `tp_region` VALUES ('11994', '老舍乡', '4', '11982');
INSERT INTO `tp_region` VALUES ('11995', '县开发区', '4', '11982');
INSERT INTO `tp_region` VALUES ('11996', '省属黄海农场', '4', '11982');
INSERT INTO `tp_region` VALUES ('11997', '省属灌东盐场', '4', '11982');
INSERT INTO `tp_region` VALUES ('11998', '滨海县', '3', '11947');
INSERT INTO `tp_region` VALUES ('11999', '东坎镇', '4', '11998');
INSERT INTO `tp_region` VALUES ('12000', '五汛镇', '4', '11998');
INSERT INTO `tp_region` VALUES ('12001', '蔡桥镇', '4', '11998');
INSERT INTO `tp_region` VALUES ('12002', '正红镇', '4', '11998');
INSERT INTO `tp_region` VALUES ('12003', '通榆镇', '4', '11998');
INSERT INTO `tp_region` VALUES ('12004', '界牌镇', '4', '11998');
INSERT INTO `tp_region` VALUES ('12005', '八巨镇', '4', '11998');
INSERT INTO `tp_region` VALUES ('12006', '八滩镇', '4', '11998');
INSERT INTO `tp_region` VALUES ('12007', '滨海港镇', '4', '11998');
INSERT INTO `tp_region` VALUES ('12008', '滨淮镇', '4', '11998');
INSERT INTO `tp_region` VALUES ('12009', '天场乡', '4', '11998');
INSERT INTO `tp_region` VALUES ('12010', '大套乡', '4', '11998');
INSERT INTO `tp_region` VALUES ('12011', '陈涛乡', '4', '11998');
INSERT INTO `tp_region` VALUES ('12012', '振东乡', '4', '11998');
INSERT INTO `tp_region` VALUES ('12013', '樊集乡', '4', '11998');
INSERT INTO `tp_region` VALUES ('12014', '滨淮农场', '4', '11998');
INSERT INTO `tp_region` VALUES ('12015', '新滩盐场', '4', '11998');
INSERT INTO `tp_region` VALUES ('12016', '开发区工业园', '4', '11998');
INSERT INTO `tp_region` VALUES ('12017', '阜宁县', '3', '11947');
INSERT INTO `tp_region` VALUES ('12018', '阜城镇', '4', '12017');
INSERT INTO `tp_region` VALUES ('12019', '沟墩镇', '4', '12017');
INSERT INTO `tp_region` VALUES ('12020', '吴滩镇', '4', '12017');
INSERT INTO `tp_region` VALUES ('12021', '合利镇', '4', '12017');
INSERT INTO `tp_region` VALUES ('12022', '陈良镇', '4', '12017');
INSERT INTO `tp_region` VALUES ('12023', '施庄镇', '4', '12017');
INSERT INTO `tp_region` VALUES ('12024', '三灶镇', '4', '12017');
INSERT INTO `tp_region` VALUES ('12025', '郭墅镇', '4', '12017');
INSERT INTO `tp_region` VALUES ('12026', '新沟镇', '4', '12017');
INSERT INTO `tp_region` VALUES ('12027', '陈集镇', '4', '12017');
INSERT INTO `tp_region` VALUES ('12028', '羊寨镇', '4', '12017');
INSERT INTO `tp_region` VALUES ('12029', '芦蒲镇', '4', '12017');
INSERT INTO `tp_region` VALUES ('12030', '硕集镇', '4', '12017');
INSERT INTO `tp_region` VALUES ('12031', '板湖镇', '4', '12017');
INSERT INTO `tp_region` VALUES ('12032', '东沟镇', '4', '12017');
INSERT INTO `tp_region` VALUES ('12033', '益林镇', '4', '12017');
INSERT INTO `tp_region` VALUES ('12034', '公兴镇', '4', '12017');
INSERT INTO `tp_region` VALUES ('12035', '杨集镇', '4', '12017');
INSERT INTO `tp_region` VALUES ('12036', '古河镇', '4', '12017');
INSERT INTO `tp_region` VALUES ('12037', '罗桥镇', '4', '12017');
INSERT INTO `tp_region` VALUES ('12038', '开发区', '4', '12017');
INSERT INTO `tp_region` VALUES ('12039', '化工园区', '4', '12017');
INSERT INTO `tp_region` VALUES ('12040', '射阳县', '3', '11947');
INSERT INTO `tp_region` VALUES ('12041', '合德镇', '4', '12040');
INSERT INTO `tp_region` VALUES ('12042', '临海镇', '4', '12040');
INSERT INTO `tp_region` VALUES ('12043', '千秋镇', '4', '12040');
INSERT INTO `tp_region` VALUES ('12044', '通洋镇', '4', '12040');
INSERT INTO `tp_region` VALUES ('12045', '四明镇', '4', '12040');
INSERT INTO `tp_region` VALUES ('12046', '阜余镇', '4', '12040');
INSERT INTO `tp_region` VALUES ('12047', '海河镇', '4', '12040');
INSERT INTO `tp_region` VALUES ('12048', '陈洋镇', '4', '12040');
INSERT INTO `tp_region` VALUES ('12049', '海通镇', '4', '12040');
INSERT INTO `tp_region` VALUES ('12050', '兴桥镇', '4', '12040');
INSERT INTO `tp_region` VALUES ('12051', '新坍镇', '4', '12040');
INSERT INTO `tp_region` VALUES ('12052', '长荡镇', '4', '12040');
INSERT INTO `tp_region` VALUES ('12053', '盘湾镇', '4', '12040');
INSERT INTO `tp_region` VALUES ('12054', '特庸镇', '4', '12040');
INSERT INTO `tp_region` VALUES ('12055', '洋马镇', '4', '12040');
INSERT INTO `tp_region` VALUES ('12056', '黄尖镇', '4', '12040');
INSERT INTO `tp_region` VALUES ('12057', '盐东镇', '4', '12040');
INSERT INTO `tp_region` VALUES ('12058', '黄沙港镇', '4', '12040');
INSERT INTO `tp_region` VALUES ('12059', '耦耕镇', '4', '12040');
INSERT INTO `tp_region` VALUES ('12060', '开发区', '4', '12040');
INSERT INTO `tp_region` VALUES ('12061', '淮海农场', '4', '12040');
INSERT INTO `tp_region` VALUES ('12062', '临海农场', '4', '12040');
INSERT INTO `tp_region` VALUES ('12063', '新洋农场', '4', '12040');
INSERT INTO `tp_region` VALUES ('12064', '射阳盐场', '4', '12040');
INSERT INTO `tp_region` VALUES ('12065', '农业经济开发区', '4', '12040');
INSERT INTO `tp_region` VALUES ('12066', '建湖县', '3', '11947');
INSERT INTO `tp_region` VALUES ('12067', '近湖镇', '4', '12066');
INSERT INTO `tp_region` VALUES ('12068', '建阳镇', '4', '12066');
INSERT INTO `tp_region` VALUES ('12069', '蒋营镇', '4', '12066');
INSERT INTO `tp_region` VALUES ('12070', '恒济镇', '4', '12066');
INSERT INTO `tp_region` VALUES ('12071', '颜单镇', '4', '12066');
INSERT INTO `tp_region` VALUES ('12072', '沿河镇', '4', '12066');
INSERT INTO `tp_region` VALUES ('12073', '芦沟镇', '4', '12066');
INSERT INTO `tp_region` VALUES ('12074', '庆丰镇', '4', '12066');
INSERT INTO `tp_region` VALUES ('12075', '上冈镇', '4', '12066');
INSERT INTO `tp_region` VALUES ('12076', '冈东镇', '4', '12066');
INSERT INTO `tp_region` VALUES ('12077', '草堰口镇', '4', '12066');
INSERT INTO `tp_region` VALUES ('12078', '冈西镇', '4', '12066');
INSERT INTO `tp_region` VALUES ('12079', '钟庄镇', '4', '12066');
INSERT INTO `tp_region` VALUES ('12080', '宝塔镇', '4', '12066');
INSERT INTO `tp_region` VALUES ('12081', '高作镇', '4', '12066');
INSERT INTO `tp_region` VALUES ('12082', '经济开发区', '4', '12066');
INSERT INTO `tp_region` VALUES ('12083', '东台市', '3', '11947');
INSERT INTO `tp_region` VALUES ('12084', '溱东镇', '4', '12083');
INSERT INTO `tp_region` VALUES ('12085', '时堰镇', '4', '12083');
INSERT INTO `tp_region` VALUES ('12086', '后港镇', '4', '12083');
INSERT INTO `tp_region` VALUES ('12087', '台南镇', '4', '12083');
INSERT INTO `tp_region` VALUES ('12088', '广山镇', '4', '12083');
INSERT INTO `tp_region` VALUES ('12089', '廉贻镇', '4', '12083');
INSERT INTO `tp_region` VALUES ('12090', '五烈镇', '4', '12083');
INSERT INTO `tp_region` VALUES ('12091', '梁垛镇', '4', '12083');
INSERT INTO `tp_region` VALUES ('12092', '安丰镇', '4', '12083');
INSERT INTO `tp_region` VALUES ('12093', '南沈灶镇', '4', '12083');
INSERT INTO `tp_region` VALUES ('12094', '富安镇', '4', '12083');
INSERT INTO `tp_region` VALUES ('12095', '富东镇', '4', '12083');
INSERT INTO `tp_region` VALUES ('12096', '唐洋镇', '4', '12083');
INSERT INTO `tp_region` VALUES ('12097', '新街镇', '4', '12083');
INSERT INTO `tp_region` VALUES ('12098', '许河镇', '4', '12083');
INSERT INTO `tp_region` VALUES ('12099', '三仓镇', '4', '12083');
INSERT INTO `tp_region` VALUES ('12100', '新曹镇', '4', '12083');
INSERT INTO `tp_region` VALUES ('12101', '曹丿镇', '4', '12083');
INSERT INTO `tp_region` VALUES ('12102', '头灶镇', '4', '12083');
INSERT INTO `tp_region` VALUES ('12103', '四灶镇', '4', '12083');
INSERT INTO `tp_region` VALUES ('12104', '海丰镇', '4', '12083');
INSERT INTO `tp_region` VALUES ('12105', '弶港镇', '4', '12083');
INSERT INTO `tp_region` VALUES ('12106', '东台镇', '4', '12083');
INSERT INTO `tp_region` VALUES ('12107', '国营新曹农场', '4', '12083');
INSERT INTO `tp_region` VALUES ('12108', '国营弶港农场', '4', '12083');
INSERT INTO `tp_region` VALUES ('12109', '蚕种场', '4', '12083');
INSERT INTO `tp_region` VALUES ('12110', '林场', '4', '12083');
INSERT INTO `tp_region` VALUES ('12111', '黄海原种场', '4', '12083');
INSERT INTO `tp_region` VALUES ('12112', '渔舍农场', '4', '12083');
INSERT INTO `tp_region` VALUES ('12113', '种畜场', '4', '12083');
INSERT INTO `tp_region` VALUES ('12114', '金东台农场', '4', '12083');
INSERT INTO `tp_region` VALUES ('12115', '原种场', '4', '12083');
INSERT INTO `tp_region` VALUES ('12116', '开发区', '4', '12083');
INSERT INTO `tp_region` VALUES ('12117', '大丰市', '3', '11947');
INSERT INTO `tp_region` VALUES ('12118', '大中镇', '4', '12117');
INSERT INTO `tp_region` VALUES ('12119', '草堰镇', '4', '12117');
INSERT INTO `tp_region` VALUES ('12120', '白驹镇', '4', '12117');
INSERT INTO `tp_region` VALUES ('12121', '刘庄镇', '4', '12117');
INSERT INTO `tp_region` VALUES ('12122', '西团镇', '4', '12117');
INSERT INTO `tp_region` VALUES ('12123', '小海镇', '4', '12117');
INSERT INTO `tp_region` VALUES ('12124', '大桥镇', '4', '12117');
INSERT INTO `tp_region` VALUES ('12125', '草庙镇', '4', '12117');
INSERT INTO `tp_region` VALUES ('12126', '万盈镇', '4', '12117');
INSERT INTO `tp_region` VALUES ('12127', '南阳镇', '4', '12117');
INSERT INTO `tp_region` VALUES ('12128', '裕华镇', '4', '12117');
INSERT INTO `tp_region` VALUES ('12129', '新丰镇', '4', '12117');
INSERT INTO `tp_region` VALUES ('12130', '三龙镇', '4', '12117');
INSERT INTO `tp_region` VALUES ('12131', '方强镇', '4', '12117');
INSERT INTO `tp_region` VALUES ('12132', '大中农场', '4', '12117');
INSERT INTO `tp_region` VALUES ('12133', '方强农场', '4', '12117');
INSERT INTO `tp_region` VALUES ('12134', '东坝头农场', '4', '12117');
INSERT INTO `tp_region` VALUES ('12135', '扬州市', '2', '10808');
INSERT INTO `tp_region` VALUES ('12136', '市辖区', '3', '12135');
INSERT INTO `tp_region` VALUES ('12137', '广陵区', '3', '12135');
INSERT INTO `tp_region` VALUES ('12138', '东关街道', '4', '12137');
INSERT INTO `tp_region` VALUES ('12139', '汶河街道', '4', '12137');
INSERT INTO `tp_region` VALUES ('12140', '文峰街道', '4', '12137');
INSERT INTO `tp_region` VALUES ('12141', '曲江街道', '4', '12137');
INSERT INTO `tp_region` VALUES ('12142', '湾头镇', '4', '12137');
INSERT INTO `tp_region` VALUES ('12143', '汤汪乡', '4', '12137');
INSERT INTO `tp_region` VALUES ('12144', '邗江区', '3', '12135');
INSERT INTO `tp_region` VALUES ('12145', '邗上街道', '4', '12144');
INSERT INTO `tp_region` VALUES ('12146', '蒋王街道', '4', '12144');
INSERT INTO `tp_region` VALUES ('12147', '汊河街道', '4', '12144');
INSERT INTO `tp_region` VALUES ('12148', '公道镇', '4', '12144');
INSERT INTO `tp_region` VALUES ('12149', '方巷镇', '4', '12144');
INSERT INTO `tp_region` VALUES ('12150', '槐泗镇', '4', '12144');
INSERT INTO `tp_region` VALUES ('12151', '瓜洲镇', '4', '12144');
INSERT INTO `tp_region` VALUES ('12152', '杭集镇', '4', '12144');
INSERT INTO `tp_region` VALUES ('12153', '李典镇', '4', '12144');
INSERT INTO `tp_region` VALUES ('12154', '沙头镇', '4', '12144');
INSERT INTO `tp_region` VALUES ('12155', '头桥镇', '4', '12144');
INSERT INTO `tp_region` VALUES ('12156', '甘泉镇', '4', '12144');
INSERT INTO `tp_region` VALUES ('12157', '泰安镇', '4', '12144');
INSERT INTO `tp_region` VALUES ('12158', '杨庙镇', '4', '12144');
INSERT INTO `tp_region` VALUES ('12159', '邗江工业园', '4', '12144');
INSERT INTO `tp_region` VALUES ('12160', '维扬区', '3', '12135');
INSERT INTO `tp_region` VALUES ('12161', '双桥街道', '4', '12160');
INSERT INTO `tp_region` VALUES ('12162', '梅岭街道', '4', '12160');
INSERT INTO `tp_region` VALUES ('12163', '瘦西湖街道', '4', '12160');
INSERT INTO `tp_region` VALUES ('12164', '扬子津街道', '4', '12160');
INSERT INTO `tp_region` VALUES ('12165', '文汇街道', '4', '12160');
INSERT INTO `tp_region` VALUES ('12166', '新盛街道', '4', '12160');
INSERT INTO `tp_region` VALUES ('12167', '西湖镇', '4', '12160');
INSERT INTO `tp_region` VALUES ('12168', '施桥镇', '4', '12160');
INSERT INTO `tp_region` VALUES ('12169', '八里镇', '4', '12160');
INSERT INTO `tp_region` VALUES ('12170', '平山乡', '4', '12160');
INSERT INTO `tp_region` VALUES ('12171', '双桥乡', '4', '12160');
INSERT INTO `tp_region` VALUES ('12172', '城北乡', '4', '12160');
INSERT INTO `tp_region` VALUES ('12173', '平山茶场', '4', '12160');
INSERT INTO `tp_region` VALUES ('12174', '维扬经济开发区', '4', '12160');
INSERT INTO `tp_region` VALUES ('12175', '宝应县', '3', '12135');
INSERT INTO `tp_region` VALUES ('12176', '安宜镇', '4', '12175');
INSERT INTO `tp_region` VALUES ('12177', '范水镇', '4', '12175');
INSERT INTO `tp_region` VALUES ('12178', '夏集镇', '4', '12175');
INSERT INTO `tp_region` VALUES ('12179', '柳堡镇', '4', '12175');
INSERT INTO `tp_region` VALUES ('12180', '射阳湖镇', '4', '12175');
INSERT INTO `tp_region` VALUES ('12181', '广洋湖镇', '4', '12175');
INSERT INTO `tp_region` VALUES ('12182', '鲁垛镇', '4', '12175');
INSERT INTO `tp_region` VALUES ('12183', '小官庄镇', '4', '12175');
INSERT INTO `tp_region` VALUES ('12184', '望直港镇', '4', '12175');
INSERT INTO `tp_region` VALUES ('12185', '曹甸镇', '4', '12175');
INSERT INTO `tp_region` VALUES ('12186', '西安丰镇', '4', '12175');
INSERT INTO `tp_region` VALUES ('12187', '山阳镇', '4', '12175');
INSERT INTO `tp_region` VALUES ('12188', '黄塍镇', '4', '12175');
INSERT INTO `tp_region` VALUES ('12189', '泾河镇', '4', '12175');
INSERT INTO `tp_region` VALUES ('12190', '开发区管委会', '4', '12175');
INSERT INTO `tp_region` VALUES ('12191', '仪征市', '3', '12135');
INSERT INTO `tp_region` VALUES ('12192', '真州镇', '4', '12191');
INSERT INTO `tp_region` VALUES ('12193', '青山镇', '4', '12191');
INSERT INTO `tp_region` VALUES ('12194', '朴席镇', '4', '12191');
INSERT INTO `tp_region` VALUES ('12195', '新集镇', '4', '12191');
INSERT INTO `tp_region` VALUES ('12196', '新城镇', '4', '12191');
INSERT INTO `tp_region` VALUES ('12197', '马集镇', '4', '12191');
INSERT INTO `tp_region` VALUES ('12198', '刘集镇', '4', '12191');
INSERT INTO `tp_region` VALUES ('12199', '陈集镇', '4', '12191');
INSERT INTO `tp_region` VALUES ('12200', '大仪镇', '4', '12191');
INSERT INTO `tp_region` VALUES ('12201', '谢集乡', '4', '12191');
INSERT INTO `tp_region` VALUES ('12202', '月塘乡', '4', '12191');
INSERT INTO `tp_region` VALUES ('12203', '开发区', '4', '12191');
INSERT INTO `tp_region` VALUES ('12204', '原种场', '4', '12191');
INSERT INTO `tp_region` VALUES ('12205', '蚕种场', '4', '12191');
INSERT INTO `tp_region` VALUES ('12206', '园艺试验场', '4', '12191');
INSERT INTO `tp_region` VALUES ('12207', '水产试验场', '4', '12191');
INSERT INTO `tp_region` VALUES ('12208', '捺山茶场', '4', '12191');
INSERT INTO `tp_region` VALUES ('12209', '蚕桑场', '4', '12191');
INSERT INTO `tp_region` VALUES ('12210', '滨江', '4', '12191');
INSERT INTO `tp_region` VALUES ('12211', '十二圩', '4', '12191');
INSERT INTO `tp_region` VALUES ('12212', '高邮市', '3', '12135');
INSERT INTO `tp_region` VALUES ('12213', '高邮镇', '4', '12212');
INSERT INTO `tp_region` VALUES ('12214', '龙虬镇', '4', '12212');
INSERT INTO `tp_region` VALUES ('12215', '马棚镇', '4', '12212');
INSERT INTO `tp_region` VALUES ('12216', '车逻镇', '4', '12212');
INSERT INTO `tp_region` VALUES ('12217', '八桥镇', '4', '12212');
INSERT INTO `tp_region` VALUES ('12218', '汉留镇', '4', '12212');
INSERT INTO `tp_region` VALUES ('12219', '汤庄镇', '4', '12212');
INSERT INTO `tp_region` VALUES ('12220', '卸甲镇', '4', '12212');
INSERT INTO `tp_region` VALUES ('12221', '三垛镇', '4', '12212');
INSERT INTO `tp_region` VALUES ('12222', '甘垛镇', '4', '12212');
INSERT INTO `tp_region` VALUES ('12223', '司徒镇', '4', '12212');
INSERT INTO `tp_region` VALUES ('12224', '横泾镇', '4', '12212');
INSERT INTO `tp_region` VALUES ('12225', '界首镇', '4', '12212');
INSERT INTO `tp_region` VALUES ('12226', '周山镇', '4', '12212');
INSERT INTO `tp_region` VALUES ('12227', '周巷镇', '4', '12212');
INSERT INTO `tp_region` VALUES ('12228', '临泽镇', '4', '12212');
INSERT INTO `tp_region` VALUES ('12229', '送桥镇', '4', '12212');
INSERT INTO `tp_region` VALUES ('12230', '郭集镇', '4', '12212');
INSERT INTO `tp_region` VALUES ('12231', '天山镇', '4', '12212');
INSERT INTO `tp_region` VALUES ('12232', '菱塘回族乡', '4', '12212');
INSERT INTO `tp_region` VALUES ('12233', '鸭业园区', '4', '12212');
INSERT INTO `tp_region` VALUES ('12234', '经济开发区', '4', '12212');
INSERT INTO `tp_region` VALUES ('12235', '江都市', '3', '12135');
INSERT INTO `tp_region` VALUES ('12236', '仙女镇', '4', '12235');
INSERT INTO `tp_region` VALUES ('12237', '小纪镇', '4', '12235');
INSERT INTO `tp_region` VALUES ('12238', '武坚镇', '4', '12235');
INSERT INTO `tp_region` VALUES ('12239', '樊川镇', '4', '12235');
INSERT INTO `tp_region` VALUES ('12240', '真武镇', '4', '12235');
INSERT INTO `tp_region` VALUES ('12241', '宜陵镇', '4', '12235');
INSERT INTO `tp_region` VALUES ('12242', '丁沟镇', '4', '12235');
INSERT INTO `tp_region` VALUES ('12243', '郭村镇', '4', '12235');
INSERT INTO `tp_region` VALUES ('12244', '邵伯镇', '4', '12235');
INSERT INTO `tp_region` VALUES ('12245', '丁伙镇', '4', '12235');
INSERT INTO `tp_region` VALUES ('12246', '大桥镇', '4', '12235');
INSERT INTO `tp_region` VALUES ('12247', '吴桥镇', '4', '12235');
INSERT INTO `tp_region` VALUES ('12248', '浦头镇', '4', '12235');
INSERT INTO `tp_region` VALUES ('12249', '镇江市', '2', '10808');
INSERT INTO `tp_region` VALUES ('12250', '市区', '3', '12249');
INSERT INTO `tp_region` VALUES ('12251', '京口区', '3', '12249');
INSERT INTO `tp_region` VALUES ('12252', '正东路街道', '4', '12251');
INSERT INTO `tp_region` VALUES ('12253', '健康路街道', '4', '12251');
INSERT INTO `tp_region` VALUES ('12254', '大市口街道', '4', '12251');
INSERT INTO `tp_region` VALUES ('12255', '四牌楼街道', '4', '12251');
INSERT INTO `tp_region` VALUES ('12256', '丁卯街道', '4', '12251');
INSERT INTO `tp_region` VALUES ('12257', '大港街道', '4', '12251');
INSERT INTO `tp_region` VALUES ('12258', '象山镇', '4', '12251');
INSERT INTO `tp_region` VALUES ('12259', '谏壁镇', '4', '12251');
INSERT INTO `tp_region` VALUES ('12260', '姚桥镇', '4', '12251');
INSERT INTO `tp_region` VALUES ('12261', '大路镇', '4', '12251');
INSERT INTO `tp_region` VALUES ('12262', '丁岗镇', '4', '12251');
INSERT INTO `tp_region` VALUES ('12263', '京口科技工业园', '4', '12251');
INSERT INTO `tp_region` VALUES ('12264', '江苏省共青团农场', '4', '12251');
INSERT INTO `tp_region` VALUES ('12265', '润州区', '3', '12249');
INSERT INTO `tp_region` VALUES ('12266', '宝塔路街道', '4', '12265');
INSERT INTO `tp_region` VALUES ('12267', '和平路街道', '4', '12265');
INSERT INTO `tp_region` VALUES ('12268', '金山街道', '4', '12265');
INSERT INTO `tp_region` VALUES ('12269', '七里甸街道', '4', '12265');
INSERT INTO `tp_region` VALUES ('12270', '蒋乔镇', '4', '12265');
INSERT INTO `tp_region` VALUES ('12271', '民营经济管理委员会', '4', '12265');
INSERT INTO `tp_region` VALUES ('12272', '润州工业园区', '4', '12265');
INSERT INTO `tp_region` VALUES ('12273', '丹徒区', '3', '12249');
INSERT INTO `tp_region` VALUES ('12274', '高桥镇', '4', '12273');
INSERT INTO `tp_region` VALUES ('12275', '辛丰镇', '4', '12273');
INSERT INTO `tp_region` VALUES ('12276', '谷阳镇', '4', '12273');
INSERT INTO `tp_region` VALUES ('12277', '上党镇', '4', '12273');
INSERT INTO `tp_region` VALUES ('12278', '宝堰镇', '4', '12273');
INSERT INTO `tp_region` VALUES ('12279', '高资镇', '4', '12273');
INSERT INTO `tp_region` VALUES ('12280', '世业镇', '4', '12273');
INSERT INTO `tp_region` VALUES ('12281', '丹徒区长山林场', '4', '12273');
INSERT INTO `tp_region` VALUES ('12282', '丹阳市', '3', '12249');
INSERT INTO `tp_region` VALUES ('12283', '司徒镇', '4', '12282');
INSERT INTO `tp_region` VALUES ('12284', '延陵镇', '4', '12282');
INSERT INTO `tp_region` VALUES ('12285', '珥陵镇', '4', '12282');
INSERT INTO `tp_region` VALUES ('12286', '导墅镇', '4', '12282');
INSERT INTO `tp_region` VALUES ('12287', '皇塘镇', '4', '12282');
INSERT INTO `tp_region` VALUES ('12288', '吕城镇', '4', '12282');
INSERT INTO `tp_region` VALUES ('12289', '陵口镇', '4', '12282');
INSERT INTO `tp_region` VALUES ('12290', '访仙镇', '4', '12282');
INSERT INTO `tp_region` VALUES ('12291', '界牌镇', '4', '12282');
INSERT INTO `tp_region` VALUES ('12292', '新桥镇', '4', '12282');
INSERT INTO `tp_region` VALUES ('12293', '后巷镇', '4', '12282');
INSERT INTO `tp_region` VALUES ('12294', '埤城镇', '4', '12282');
INSERT INTO `tp_region` VALUES ('12295', '云阳镇', '4', '12282');
INSERT INTO `tp_region` VALUES ('12296', '丹阳经济技术开发区', '4', '12282');
INSERT INTO `tp_region` VALUES ('12297', '丹阳林场', '4', '12282');
INSERT INTO `tp_region` VALUES ('12298', '茶叶实验场', '4', '12282');
INSERT INTO `tp_region` VALUES ('12299', '江苏省练湖农场', '4', '12282');
INSERT INTO `tp_region` VALUES ('12300', '扬中市', '3', '12249');
INSERT INTO `tp_region` VALUES ('12301', '三茅镇', '4', '12300');
INSERT INTO `tp_region` VALUES ('12302', '新坝镇', '4', '12300');
INSERT INTO `tp_region` VALUES ('12303', '油坊镇', '4', '12300');
INSERT INTO `tp_region` VALUES ('12304', '八桥镇', '4', '12300');
INSERT INTO `tp_region` VALUES ('12305', '西来桥镇', '4', '12300');
INSERT INTO `tp_region` VALUES ('12306', '经济开发区', '4', '12300');
INSERT INTO `tp_region` VALUES ('12307', '扬中市良种繁育场', '4', '12300');
INSERT INTO `tp_region` VALUES ('12308', '扬中市种猪场', '4', '12300');
INSERT INTO `tp_region` VALUES ('12309', '扬中市渔业社', '4', '12300');
INSERT INTO `tp_region` VALUES ('12310', '雷公岛水产养殖场', '4', '12300');
INSERT INTO `tp_region` VALUES ('12311', '扬中市西沙芦柳管理所', '4', '12300');
INSERT INTO `tp_region` VALUES ('12312', '句容市', '3', '12249');
INSERT INTO `tp_region` VALUES ('12313', '华阳镇', '4', '12312');
INSERT INTO `tp_region` VALUES ('12314', '黄梅镇', '4', '12312');
INSERT INTO `tp_region` VALUES ('12315', '下蜀镇', '4', '12312');
INSERT INTO `tp_region` VALUES ('12316', '白兔镇', '4', '12312');
INSERT INTO `tp_region` VALUES ('12317', '边城镇', '4', '12312');
INSERT INTO `tp_region` VALUES ('12318', '茅山镇', '4', '12312');
INSERT INTO `tp_region` VALUES ('12319', '后白镇', '4', '12312');
INSERT INTO `tp_region` VALUES ('12320', '郭庄镇', '4', '12312');
INSERT INTO `tp_region` VALUES ('12321', '天王镇', '4', '12312');
INSERT INTO `tp_region` VALUES ('12322', '宝华镇', '4', '12312');
INSERT INTO `tp_region` VALUES ('12323', '开发区', '4', '12312');
INSERT INTO `tp_region` VALUES ('12324', '句容市东山良种场', '4', '12312');
INSERT INTO `tp_region` VALUES ('12325', '句容市棉花原种场', '4', '12312');
INSERT INTO `tp_region` VALUES ('12326', '句容市下蜀茶场', '4', '12312');
INSERT INTO `tp_region` VALUES ('12327', '句容市林场', '4', '12312');
INSERT INTO `tp_region` VALUES ('12328', '句容市赵庄林苗场', '4', '12312');
INSERT INTO `tp_region` VALUES ('12329', '句容市九华茶场', '4', '12312');
INSERT INTO `tp_region` VALUES ('12330', '句容市东进林场', '4', '12312');
INSERT INTO `tp_region` VALUES ('12331', '句容市茅山茶场', '4', '12312');
INSERT INTO `tp_region` VALUES ('12332', '句容市张庙茶场', '4', '12312');
INSERT INTO `tp_region` VALUES ('12333', '句容市高庙茶场', '4', '12312');
INSERT INTO `tp_region` VALUES ('12334', '句容市浮山果园', '4', '12312');
INSERT INTO `tp_region` VALUES ('12335', '句容市方山茶场', '4', '12312');
INSERT INTO `tp_region` VALUES ('12336', '句容市磨盘山林场', '4', '12312');
INSERT INTO `tp_region` VALUES ('12337', '句容市后白良种场', '4', '12312');
INSERT INTO `tp_region` VALUES ('12338', '句容市二圣种猪场', '4', '12312');
INSERT INTO `tp_region` VALUES ('12339', '句容监狱', '4', '12312');
INSERT INTO `tp_region` VALUES ('12340', '江苏省第一少年管教所', '4', '12312');
INSERT INTO `tp_region` VALUES ('12341', '江苏省第二少年管教所', '4', '12312');
INSERT INTO `tp_region` VALUES ('12342', '句东农场', '4', '12312');
INSERT INTO `tp_region` VALUES ('12343', '泰州市', '2', '10808');
INSERT INTO `tp_region` VALUES ('12344', '市辖区', '3', '12343');
INSERT INTO `tp_region` VALUES ('12345', '海陵区', '3', '12343');
INSERT INTO `tp_region` VALUES ('12346', '城东街道', '4', '12345');
INSERT INTO `tp_region` VALUES ('12347', '城西街道', '4', '12345');
INSERT INTO `tp_region` VALUES ('12348', '城南街道', '4', '12345');
INSERT INTO `tp_region` VALUES ('12349', '城中街道', '4', '12345');
INSERT INTO `tp_region` VALUES ('12350', '城北街道', '4', '12345');
INSERT INTO `tp_region` VALUES ('12351', '泰山街道', '4', '12345');
INSERT INTO `tp_region` VALUES ('12352', '京泰路街道', '4', '12345');
INSERT INTO `tp_region` VALUES ('12353', '凤凰路街道', '4', '12345');
INSERT INTO `tp_region` VALUES ('12354', '农业开发区街道', '4', '12345');
INSERT INTO `tp_region` VALUES ('12355', '九龙镇', '4', '12345');
INSERT INTO `tp_region` VALUES ('12356', '寺巷镇', '4', '12345');
INSERT INTO `tp_region` VALUES ('12357', '林场', '4', '12345');
INSERT INTO `tp_region` VALUES ('12358', '水产养殖场', '4', '12345');
INSERT INTO `tp_region` VALUES ('12359', '畜牧养殖试验场', '4', '12345');
INSERT INTO `tp_region` VALUES ('12360', '迎春果场', '4', '12345');
INSERT INTO `tp_region` VALUES ('12361', '海陵工业园区', '4', '12345');
INSERT INTO `tp_region` VALUES ('12362', '高港区', '3', '12343');
INSERT INTO `tp_region` VALUES ('12363', '口岸街道', '4', '12362');
INSERT INTO `tp_region` VALUES ('12364', '刁铺街道', '4', '12362');
INSERT INTO `tp_region` VALUES ('12365', '许庄街道', '4', '12362');
INSERT INTO `tp_region` VALUES ('12366', '永安洲镇', '4', '12362');
INSERT INTO `tp_region` VALUES ('12367', '白马镇', '4', '12362');
INSERT INTO `tp_region` VALUES ('12368', '野徐镇', '4', '12362');
INSERT INTO `tp_region` VALUES ('12369', '滨江工业园', '4', '12362');
INSERT INTO `tp_region` VALUES ('12370', '兴化市', '3', '12343');
INSERT INTO `tp_region` VALUES ('12371', '戴窑镇', '4', '12370');
INSERT INTO `tp_region` VALUES ('12372', '合陈镇', '4', '12370');
INSERT INTO `tp_region` VALUES ('12373', '永丰镇', '4', '12370');
INSERT INTO `tp_region` VALUES ('12374', '新垛镇', '4', '12370');
INSERT INTO `tp_region` VALUES ('12375', '安丰镇', '4', '12370');
INSERT INTO `tp_region` VALUES ('12376', '海南镇', '4', '12370');
INSERT INTO `tp_region` VALUES ('12377', '钓鱼镇', '4', '12370');
INSERT INTO `tp_region` VALUES ('12378', '大邹镇', '4', '12370');
INSERT INTO `tp_region` VALUES ('12379', '沙沟镇', '4', '12370');
INSERT INTO `tp_region` VALUES ('12380', '中堡镇', '4', '12370');
INSERT INTO `tp_region` VALUES ('12381', '李中镇', '4', '12370');
INSERT INTO `tp_region` VALUES ('12382', '西郊镇', '4', '12370');
INSERT INTO `tp_region` VALUES ('12383', '临城镇', '4', '12370');
INSERT INTO `tp_region` VALUES ('12384', '垛田镇', '4', '12370');
INSERT INTO `tp_region` VALUES ('12385', '竹泓镇', '4', '12370');
INSERT INTO `tp_region` VALUES ('12386', '沈沦镇', '4', '12370');
INSERT INTO `tp_region` VALUES ('12387', '大垛镇', '4', '12370');
INSERT INTO `tp_region` VALUES ('12388', '荻垛镇', '4', '12370');
INSERT INTO `tp_region` VALUES ('12389', '陶庄镇', '4', '12370');
INSERT INTO `tp_region` VALUES ('12390', '昌荣镇', '4', '12370');
INSERT INTO `tp_region` VALUES ('12391', '茅山镇', '4', '12370');
INSERT INTO `tp_region` VALUES ('12392', '周庄镇', '4', '12370');
INSERT INTO `tp_region` VALUES ('12393', '陈堡镇', '4', '12370');
INSERT INTO `tp_region` VALUES ('12394', '戴南镇', '4', '12370');
INSERT INTO `tp_region` VALUES ('12395', '张郭镇', '4', '12370');
INSERT INTO `tp_region` VALUES ('12396', '昭阳镇', '4', '12370');
INSERT INTO `tp_region` VALUES ('12397', '大营镇', '4', '12370');
INSERT INTO `tp_region` VALUES ('12398', '下圩镇', '4', '12370');
INSERT INTO `tp_region` VALUES ('12399', '城东镇', '4', '12370');
INSERT INTO `tp_region` VALUES ('12400', '老圩乡', '4', '12370');
INSERT INTO `tp_region` VALUES ('12401', '周奋乡', '4', '12370');
INSERT INTO `tp_region` VALUES ('12402', '缸顾乡', '4', '12370');
INSERT INTO `tp_region` VALUES ('12403', '西鲍乡', '4', '12370');
INSERT INTO `tp_region` VALUES ('12404', '林湖乡', '4', '12370');
INSERT INTO `tp_region` VALUES ('12405', '开发区', '4', '12370');
INSERT INTO `tp_region` VALUES ('12406', '良种场', '4', '12370');
INSERT INTO `tp_region` VALUES ('12407', '靖江市', '3', '12343');
INSERT INTO `tp_region` VALUES ('12408', '靖城镇', '4', '12407');
INSERT INTO `tp_region` VALUES ('12409', '新桥镇', '4', '12407');
INSERT INTO `tp_region` VALUES ('12410', '东兴镇', '4', '12407');
INSERT INTO `tp_region` VALUES ('12411', '斜桥镇', '4', '12407');
INSERT INTO `tp_region` VALUES ('12412', '西来镇', '4', '12407');
INSERT INTO `tp_region` VALUES ('12413', '季市镇', '4', '12407');
INSERT INTO `tp_region` VALUES ('12414', '孤山镇', '4', '12407');
INSERT INTO `tp_region` VALUES ('12415', '红光镇', '4', '12407');
INSERT INTO `tp_region` VALUES ('12416', '生祠镇', '4', '12407');
INSERT INTO `tp_region` VALUES ('12417', '马桥镇', '4', '12407');
INSERT INTO `tp_region` VALUES ('12418', '城南', '4', '12407');
INSERT INTO `tp_region` VALUES ('12419', '新港园区', '4', '12407');
INSERT INTO `tp_region` VALUES ('12420', '城北园区', '4', '12407');
INSERT INTO `tp_region` VALUES ('12421', '江阴园区', '4', '12407');
INSERT INTO `tp_region` VALUES ('12422', '渔业公司', '4', '12407');
INSERT INTO `tp_region` VALUES ('12423', '泰兴市', '3', '12343');
INSERT INTO `tp_region` VALUES ('12424', '黄桥镇', '4', '12423');
INSERT INTO `tp_region` VALUES ('12425', '分界镇', '4', '12423');
INSERT INTO `tp_region` VALUES ('12426', '古溪镇', '4', '12423');
INSERT INTO `tp_region` VALUES ('12427', '横垛镇', '4', '12423');
INSERT INTO `tp_region` VALUES ('12428', '元竹镇', '4', '12423');
INSERT INTO `tp_region` VALUES ('12429', '珊瑚镇', '4', '12423');
INSERT INTO `tp_region` VALUES ('12430', '广陵镇', '4', '12423');
INSERT INTO `tp_region` VALUES ('12431', '南沙镇', '4', '12423');
INSERT INTO `tp_region` VALUES ('12432', '曲霞镇', '4', '12423');
INSERT INTO `tp_region` VALUES ('12433', '张桥镇', '4', '12423');
INSERT INTO `tp_region` VALUES ('12434', '溪桥镇', '4', '12423');
INSERT INTO `tp_region` VALUES ('12435', '刘陈镇', '4', '12423');
INSERT INTO `tp_region` VALUES ('12436', '河失镇', '4', '12423');
INSERT INTO `tp_region` VALUES ('12437', '新街镇', '4', '12423');
INSERT INTO `tp_region` VALUES ('12438', '姚王镇', '4', '12423');
INSERT INTO `tp_region` VALUES ('12439', '宣堡镇', '4', '12423');
INSERT INTO `tp_region` VALUES ('12440', '胡庄镇', '4', '12423');
INSERT INTO `tp_region` VALUES ('12441', '马甸镇', '4', '12423');
INSERT INTO `tp_region` VALUES ('12442', '泰兴镇', '4', '12423');
INSERT INTO `tp_region` VALUES ('12443', '七圩镇', '4', '12423');
INSERT INTO `tp_region` VALUES ('12444', '蒋华镇', '4', '12423');
INSERT INTO `tp_region` VALUES ('12445', '大生镇', '4', '12423');
INSERT INTO `tp_region` VALUES ('12446', '过船镇', '4', '12423');
INSERT INTO `tp_region` VALUES ('12447', '根思乡', '4', '12423');
INSERT INTO `tp_region` VALUES ('12448', '开发区虚拟镇', '4', '12423');
INSERT INTO `tp_region` VALUES ('12449', '泰兴市农科所', '4', '12423');
INSERT INTO `tp_region` VALUES ('12450', '姜堰市', '3', '12343');
INSERT INTO `tp_region` VALUES ('12451', '姜堰镇', '4', '12450');
INSERT INTO `tp_region` VALUES ('12452', '溱潼镇', '4', '12450');
INSERT INTO `tp_region` VALUES ('12453', '蒋垛镇', '4', '12450');
INSERT INTO `tp_region` VALUES ('12454', '顾高镇', '4', '12450');
INSERT INTO `tp_region` VALUES ('12455', '大伦镇', '4', '12450');
INSERT INTO `tp_region` VALUES ('12456', '张甸镇', '4', '12450');
INSERT INTO `tp_region` VALUES ('12457', '大泗镇', '4', '12450');
INSERT INTO `tp_region` VALUES ('12458', '梁徐镇', '4', '12450');
INSERT INTO `tp_region` VALUES ('12459', '苏陈镇', '4', '12450');
INSERT INTO `tp_region` VALUES ('12460', '桥头镇', '4', '12450');
INSERT INTO `tp_region` VALUES ('12461', '淤溪镇', '4', '12450');
INSERT INTO `tp_region` VALUES ('12462', '白米镇', '4', '12450');
INSERT INTO `tp_region` VALUES ('12463', '娄庄镇', '4', '12450');
INSERT INTO `tp_region` VALUES ('12464', '沈高镇', '4', '12450');
INSERT INTO `tp_region` VALUES ('12465', '兴泰镇', '4', '12450');
INSERT INTO `tp_region` VALUES ('12466', '俞垛镇', '4', '12450');
INSERT INTO `tp_region` VALUES ('12467', '华港镇', '4', '12450');
INSERT INTO `tp_region` VALUES ('12468', '罡杨镇', '4', '12450');
INSERT INTO `tp_region` VALUES ('12469', '开发区', '4', '12450');
INSERT INTO `tp_region` VALUES ('12470', '溱湖风景区', '4', '12450');
INSERT INTO `tp_region` VALUES ('12471', '林场', '4', '12450');
INSERT INTO `tp_region` VALUES ('12472', '种猪场', '4', '12450');
INSERT INTO `tp_region` VALUES ('12473', '林业站', '4', '12450');
INSERT INTO `tp_region` VALUES ('12474', '渔业社', '4', '12450');
INSERT INTO `tp_region` VALUES ('12475', '宿迁市', '2', '10808');
INSERT INTO `tp_region` VALUES ('12476', '市辖区', '3', '12475');
INSERT INTO `tp_region` VALUES ('12477', '宿城区', '3', '12475');
INSERT INTO `tp_region` VALUES ('12478', '幸福街道', '4', '12477');
INSERT INTO `tp_region` VALUES ('12479', '项里街道', '4', '12477');
INSERT INTO `tp_region` VALUES ('12480', '河滨街道', '4', '12477');
INSERT INTO `tp_region` VALUES ('12481', '古城街道', '4', '12477');
INSERT INTO `tp_region` VALUES ('12482', '双庄镇', '4', '12477');
INSERT INTO `tp_region` VALUES ('12483', '耿车镇', '4', '12477');
INSERT INTO `tp_region` VALUES ('12484', '埠子镇', '4', '12477');
INSERT INTO `tp_region` VALUES ('12485', '龙河镇', '4', '12477');
INSERT INTO `tp_region` VALUES ('12486', '洋北镇', '4', '12477');
INSERT INTO `tp_region` VALUES ('12487', '仓集镇', '4', '12477');
INSERT INTO `tp_region` VALUES ('12488', '洋河镇', '4', '12477');
INSERT INTO `tp_region` VALUES ('12489', '中扬镇', '4', '12477');
INSERT INTO `tp_region` VALUES ('12490', '郑楼镇', '4', '12477');
INSERT INTO `tp_region` VALUES ('12491', '陈集镇', '4', '12477');
INSERT INTO `tp_region` VALUES ('12492', '罗圩乡', '4', '12477');
INSERT INTO `tp_region` VALUES ('12493', '南蔡乡', '4', '12477');
INSERT INTO `tp_region` VALUES ('12494', '屠园乡', '4', '12477');
INSERT INTO `tp_region` VALUES ('12495', '三棵树乡', '4', '12477');
INSERT INTO `tp_region` VALUES ('12496', '宿豫区', '3', '12475');
INSERT INTO `tp_region` VALUES ('12497', '顺河镇', '4', '12496');
INSERT INTO `tp_region` VALUES ('12498', '晓店镇', '4', '12496');
INSERT INTO `tp_region` VALUES ('12499', '蔡集镇', '4', '12496');
INSERT INTO `tp_region` VALUES ('12500', '王官集镇', '4', '12496');
INSERT INTO `tp_region` VALUES ('12501', '皂河镇', '4', '12496');
INSERT INTO `tp_region` VALUES ('12502', '仰化镇', '4', '12496');
INSERT INTO `tp_region` VALUES ('12503', '大兴镇', '4', '12496');
INSERT INTO `tp_region` VALUES ('12504', '丁嘴镇', '4', '12496');
INSERT INTO `tp_region` VALUES ('12505', '来龙镇', '4', '12496');
INSERT INTO `tp_region` VALUES ('12506', '黄墩镇', '4', '12496');
INSERT INTO `tp_region` VALUES ('12507', '陆集镇', '4', '12496');
INSERT INTO `tp_region` VALUES ('12508', '关庙镇', '4', '12496');
INSERT INTO `tp_region` VALUES ('12509', '侍岭镇', '4', '12496');
INSERT INTO `tp_region` VALUES ('12510', '新庄镇', '4', '12496');
INSERT INTO `tp_region` VALUES ('12511', '井头乡', '4', '12496');
INSERT INTO `tp_region` VALUES ('12512', '曹集乡', '4', '12496');
INSERT INTO `tp_region` VALUES ('12513', '保安乡', '4', '12496');
INSERT INTO `tp_region` VALUES ('12514', '嶂山林场', '4', '12496');
INSERT INTO `tp_region` VALUES ('12515', '沭阳县', '3', '12475');
INSERT INTO `tp_region` VALUES ('12516', '沭城镇', '4', '12515');
INSERT INTO `tp_region` VALUES ('12517', '陇集镇', '4', '12515');
INSERT INTO `tp_region` VALUES ('12518', '胡集镇', '4', '12515');
INSERT INTO `tp_region` VALUES ('12519', '钱集镇', '4', '12515');
INSERT INTO `tp_region` VALUES ('12520', '塘沟镇', '4', '12515');
INSERT INTO `tp_region` VALUES ('12521', '马厂镇', '4', '12515');
INSERT INTO `tp_region` VALUES ('12522', '沂涛镇', '4', '12515');
INSERT INTO `tp_region` VALUES ('12523', '庙头镇', '4', '12515');
INSERT INTO `tp_region` VALUES ('12524', '韩山镇', '4', '12515');
INSERT INTO `tp_region` VALUES ('12525', '华冲镇', '4', '12515');
INSERT INTO `tp_region` VALUES ('12526', '桑墟镇', '4', '12515');
INSERT INTO `tp_region` VALUES ('12527', '悦来镇', '4', '12515');
INSERT INTO `tp_region` VALUES ('12528', '刘集镇', '4', '12515');
INSERT INTO `tp_region` VALUES ('12529', '李恒镇', '4', '12515');
INSERT INTO `tp_region` VALUES ('12530', '扎下镇', '4', '12515');
INSERT INTO `tp_region` VALUES ('12531', '颜集镇', '4', '12515');
INSERT INTO `tp_region` VALUES ('12532', '潼阳镇', '4', '12515');
INSERT INTO `tp_region` VALUES ('12533', '龙庙镇', '4', '12515');
INSERT INTO `tp_region` VALUES ('12534', '高墟镇', '4', '12515');
INSERT INTO `tp_region` VALUES ('12535', '耿圩镇', '4', '12515');
INSERT INTO `tp_region` VALUES ('12536', '汤涧镇', '4', '12515');
INSERT INTO `tp_region` VALUES ('12537', '新河镇', '4', '12515');
INSERT INTO `tp_region` VALUES ('12538', '贤官镇', '4', '12515');
INSERT INTO `tp_region` VALUES ('12539', '吴集镇', '4', '12515');
INSERT INTO `tp_region` VALUES ('12540', '湖东镇', '4', '12515');
INSERT INTO `tp_region` VALUES ('12541', '青伊湖镇', '4', '12515');
INSERT INTO `tp_region` VALUES ('12542', '北丁集乡', '4', '12515');
INSERT INTO `tp_region` VALUES ('12543', '周集乡', '4', '12515');
INSERT INTO `tp_region` VALUES ('12544', '东小店乡', '4', '12515');
INSERT INTO `tp_region` VALUES ('12545', '张圩乡', '4', '12515');
INSERT INTO `tp_region` VALUES ('12546', '茆圩乡', '4', '12515');
INSERT INTO `tp_region` VALUES ('12547', '西圩乡', '4', '12515');
INSERT INTO `tp_region` VALUES ('12548', '万匹乡', '4', '12515');
INSERT INTO `tp_region` VALUES ('12549', '官墩乡', '4', '12515');
INSERT INTO `tp_region` VALUES ('12550', '青伊湖农场', '4', '12515');
INSERT INTO `tp_region` VALUES ('12551', '泗阳县', '3', '12475');
INSERT INTO `tp_region` VALUES ('12552', '众兴镇', '4', '12551');
INSERT INTO `tp_region` VALUES ('12553', '爱园镇', '4', '12551');
INSERT INTO `tp_region` VALUES ('12554', '王集镇', '4', '12551');
INSERT INTO `tp_region` VALUES ('12555', '裴圩镇', '4', '12551');
INSERT INTO `tp_region` VALUES ('12556', '新袁镇', '4', '12551');
INSERT INTO `tp_region` VALUES ('12557', '李口镇', '4', '12551');
INSERT INTO `tp_region` VALUES ('12558', '临河镇', '4', '12551');
INSERT INTO `tp_region` VALUES ('12559', '穿城镇', '4', '12551');
INSERT INTO `tp_region` VALUES ('12560', '张家圩镇', '4', '12551');
INSERT INTO `tp_region` VALUES ('12561', '高渡镇', '4', '12551');
INSERT INTO `tp_region` VALUES ('12562', '卢集镇', '4', '12551');
INSERT INTO `tp_region` VALUES ('12563', '庄圩乡', '4', '12551');
INSERT INTO `tp_region` VALUES ('12564', '里仁乡', '4', '12551');
INSERT INTO `tp_region` VALUES ('12565', '三庄乡', '4', '12551');
INSERT INTO `tp_region` VALUES ('12566', '南刘集乡', '4', '12551');
INSERT INTO `tp_region` VALUES ('12567', '八集乡', '4', '12551');
INSERT INTO `tp_region` VALUES ('12568', '泗阳农场', '4', '12551');
INSERT INTO `tp_region` VALUES ('12569', '棉花原种场', '4', '12551');
INSERT INTO `tp_region` VALUES ('12570', '泗洪县', '3', '12475');
INSERT INTO `tp_region` VALUES ('12571', '青阳镇', '4', '12570');
INSERT INTO `tp_region` VALUES ('12572', '双沟镇', '4', '12570');
INSERT INTO `tp_region` VALUES ('12573', '上塘镇', '4', '12570');
INSERT INTO `tp_region` VALUES ('12574', '魏营镇', '4', '12570');
INSERT INTO `tp_region` VALUES ('12575', '临淮镇', '4', '12570');
INSERT INTO `tp_region` VALUES ('12576', '半城镇', '4', '12570');
INSERT INTO `tp_region` VALUES ('12577', '孙园镇', '4', '12570');
INSERT INTO `tp_region` VALUES ('12578', '梅花镇', '4', '12570');
INSERT INTO `tp_region` VALUES ('12579', '归仁镇', '4', '12570');
INSERT INTO `tp_region` VALUES ('12580', '金锁镇', '4', '12570');
INSERT INTO `tp_region` VALUES ('12581', '朱湖镇', '4', '12570');
INSERT INTO `tp_region` VALUES ('12582', '界集镇', '4', '12570');
INSERT INTO `tp_region` VALUES ('12583', '太平镇', '4', '12570');
INSERT INTO `tp_region` VALUES ('12584', '龙集镇', '4', '12570');
INSERT INTO `tp_region` VALUES ('12585', '四河乡', '4', '12570');
INSERT INTO `tp_region` VALUES ('12586', '峰山乡', '4', '12570');
INSERT INTO `tp_region` VALUES ('12587', '天岗湖乡', '4', '12570');
INSERT INTO `tp_region` VALUES ('12588', '车门乡', '4', '12570');
INSERT INTO `tp_region` VALUES ('12589', '瑶沟乡', '4', '12570');
INSERT INTO `tp_region` VALUES ('12590', '石集乡', '4', '12570');
INSERT INTO `tp_region` VALUES ('12591', '城头乡', '4', '12570');
INSERT INTO `tp_region` VALUES ('12592', '陈圩乡', '4', '12570');
INSERT INTO `tp_region` VALUES ('12593', '曹庙乡', '4', '12570');
INSERT INTO `tp_region` VALUES ('12594', '五里江农场', '4', '12570');
INSERT INTO `tp_region` VALUES ('12595', '洪泽湖农场', '4', '12570');
INSERT INTO `tp_region` VALUES ('12596', '浙江省', '1', '0');
INSERT INTO `tp_region` VALUES ('12597', '杭州市', '2', '12596');
INSERT INTO `tp_region` VALUES ('12598', '市辖区', '3', '12597');
INSERT INTO `tp_region` VALUES ('12599', '上城区', '3', '12597');
INSERT INTO `tp_region` VALUES ('12600', '清波街道', '4', '12599');
INSERT INTO `tp_region` VALUES ('12601', '湖滨街道', '4', '12599');
INSERT INTO `tp_region` VALUES ('12602', '小营街道', '4', '12599');
INSERT INTO `tp_region` VALUES ('12603', '南星街道', '4', '12599');
INSERT INTO `tp_region` VALUES ('12604', '紫阳街道', '4', '12599');
INSERT INTO `tp_region` VALUES ('12605', '望江街道', '4', '12599');
INSERT INTO `tp_region` VALUES ('12606', '下城区', '3', '12597');
INSERT INTO `tp_region` VALUES ('12607', '长庆街道', '4', '12606');
INSERT INTO `tp_region` VALUES ('12608', '武林街道', '4', '12606');
INSERT INTO `tp_region` VALUES ('12609', '天水街道', '4', '12606');
INSERT INTO `tp_region` VALUES ('12610', '潮鸣街道', '4', '12606');
INSERT INTO `tp_region` VALUES ('12611', '朝晖街道', '4', '12606');
INSERT INTO `tp_region` VALUES ('12612', '文晖街道', '4', '12606');
INSERT INTO `tp_region` VALUES ('12613', '东新街道', '4', '12606');
INSERT INTO `tp_region` VALUES ('12614', '石桥街道', '4', '12606');
INSERT INTO `tp_region` VALUES ('12615', '江干区', '3', '12597');
INSERT INTO `tp_region` VALUES ('12616', '凯旋街道', '4', '12615');
INSERT INTO `tp_region` VALUES ('12617', '采荷街道', '4', '12615');
INSERT INTO `tp_region` VALUES ('12618', '闸弄口街道', '4', '12615');
INSERT INTO `tp_region` VALUES ('12619', '四季青街道', '4', '12615');
INSERT INTO `tp_region` VALUES ('12620', '白杨街道', '4', '12615');
INSERT INTO `tp_region` VALUES ('12621', '下沙街道', '4', '12615');
INSERT INTO `tp_region` VALUES ('12622', '彭埠镇', '4', '12615');
INSERT INTO `tp_region` VALUES ('12623', '笕桥镇', '4', '12615');
INSERT INTO `tp_region` VALUES ('12624', '丁桥镇', '4', '12615');
INSERT INTO `tp_region` VALUES ('12625', '九堡镇', '4', '12615');
INSERT INTO `tp_region` VALUES ('12626', '拱墅区', '3', '12597');
INSERT INTO `tp_region` VALUES ('12627', '米市巷街道', '4', '12626');
INSERT INTO `tp_region` VALUES ('12628', '湖墅街道', '4', '12626');
INSERT INTO `tp_region` VALUES ('12629', '小河街道', '4', '12626');
INSERT INTO `tp_region` VALUES ('12630', '和睦街道', '4', '12626');
INSERT INTO `tp_region` VALUES ('12631', '拱宸桥街道', '4', '12626');
INSERT INTO `tp_region` VALUES ('12632', '大关街道', '4', '12626');
INSERT INTO `tp_region` VALUES ('12633', '上塘街道', '4', '12626');
INSERT INTO `tp_region` VALUES ('12634', '康桥镇', '4', '12626');
INSERT INTO `tp_region` VALUES ('12635', '半山镇', '4', '12626');
INSERT INTO `tp_region` VALUES ('12636', '祥符镇', '4', '12626');
INSERT INTO `tp_region` VALUES ('12637', '西湖区', '3', '12597');
INSERT INTO `tp_region` VALUES ('12638', '北山街道', '4', '12637');
INSERT INTO `tp_region` VALUES ('12639', '灵隐街道', '4', '12637');
INSERT INTO `tp_region` VALUES ('12640', '西溪街道', '4', '12637');
INSERT INTO `tp_region` VALUES ('12641', '翠苑街道', '4', '12637');
INSERT INTO `tp_region` VALUES ('12642', '文新街道', '4', '12637');
INSERT INTO `tp_region` VALUES ('12643', '古荡街道', '4', '12637');
INSERT INTO `tp_region` VALUES ('12644', '西湖街道', '4', '12637');
INSERT INTO `tp_region` VALUES ('12645', '留下镇', '4', '12637');
INSERT INTO `tp_region` VALUES ('12646', '转塘镇', '4', '12637');
INSERT INTO `tp_region` VALUES ('12647', '袁浦镇', '4', '12637');
INSERT INTO `tp_region` VALUES ('12648', '龙坞镇', '4', '12637');
INSERT INTO `tp_region` VALUES ('12649', '三墩镇', '4', '12637');
INSERT INTO `tp_region` VALUES ('12650', '周浦乡', '4', '12637');
INSERT INTO `tp_region` VALUES ('12651', '蒋村乡', '4', '12637');
INSERT INTO `tp_region` VALUES ('12652', '滨江区', '3', '12597');
INSERT INTO `tp_region` VALUES ('12653', '西兴街道', '4', '12652');
INSERT INTO `tp_region` VALUES ('12654', '长河街道', '4', '12652');
INSERT INTO `tp_region` VALUES ('12655', '浦沿街道', '4', '12652');
INSERT INTO `tp_region` VALUES ('12656', '萧山区', '3', '12597');
INSERT INTO `tp_region` VALUES ('12657', '城厢街道', '4', '12656');
INSERT INTO `tp_region` VALUES ('12658', '北干街道', '4', '12656');
INSERT INTO `tp_region` VALUES ('12659', '蜀山街道', '4', '12656');
INSERT INTO `tp_region` VALUES ('12660', '新塘街道', '4', '12656');
INSERT INTO `tp_region` VALUES ('12661', '楼塔镇', '4', '12656');
INSERT INTO `tp_region` VALUES ('12662', '河上镇', '4', '12656');
INSERT INTO `tp_region` VALUES ('12663', '戴村镇', '4', '12656');
INSERT INTO `tp_region` VALUES ('12664', '浦阳镇', '4', '12656');
INSERT INTO `tp_region` VALUES ('12665', '进化镇', '4', '12656');
INSERT INTO `tp_region` VALUES ('12666', '临浦镇', '4', '12656');
INSERT INTO `tp_region` VALUES ('12667', '义桥镇', '4', '12656');
INSERT INTO `tp_region` VALUES ('12668', '所前镇', '4', '12656');
INSERT INTO `tp_region` VALUES ('12669', '衙前镇', '4', '12656');
INSERT INTO `tp_region` VALUES ('12670', '闻堰镇', '4', '12656');
INSERT INTO `tp_region` VALUES ('12671', '宁围镇', '4', '12656');
INSERT INTO `tp_region` VALUES ('12672', '新街镇', '4', '12656');
INSERT INTO `tp_region` VALUES ('12673', '坎山镇', '4', '12656');
INSERT INTO `tp_region` VALUES ('12674', '瓜沥镇', '4', '12656');
INSERT INTO `tp_region` VALUES ('12675', '党山镇', '4', '12656');
INSERT INTO `tp_region` VALUES ('12676', '益农镇', '4', '12656');
INSERT INTO `tp_region` VALUES ('12677', '靖江镇', '4', '12656');
INSERT INTO `tp_region` VALUES ('12678', '南阳镇', '4', '12656');
INSERT INTO `tp_region` VALUES ('12679', '义蓬镇', '4', '12656');
INSERT INTO `tp_region` VALUES ('12680', '河庄镇', '4', '12656');
INSERT INTO `tp_region` VALUES ('12681', '党湾镇', '4', '12656');
INSERT INTO `tp_region` VALUES ('12682', '新湾镇', '4', '12656');
INSERT INTO `tp_region` VALUES ('12683', '萧山经济开发区', '4', '12656');
INSERT INTO `tp_region` VALUES ('12684', '围垦区', '4', '12656');
INSERT INTO `tp_region` VALUES ('12685', '余杭区', '3', '12597');
INSERT INTO `tp_region` VALUES ('12686', '临平街道', '4', '12685');
INSERT INTO `tp_region` VALUES ('12687', '南苑街道', '4', '12685');
INSERT INTO `tp_region` VALUES ('12688', '东湖街道', '4', '12685');
INSERT INTO `tp_region` VALUES ('12689', '星桥街道', '4', '12685');
INSERT INTO `tp_region` VALUES ('12690', '乔司镇', '4', '12685');
INSERT INTO `tp_region` VALUES ('12691', '运河镇', '4', '12685');
INSERT INTO `tp_region` VALUES ('12692', '塘栖镇', '4', '12685');
INSERT INTO `tp_region` VALUES ('12693', '崇贤镇', '4', '12685');
INSERT INTO `tp_region` VALUES ('12694', '仁和镇', '4', '12685');
INSERT INTO `tp_region` VALUES ('12695', '良渚镇', '4', '12685');
INSERT INTO `tp_region` VALUES ('12696', '闲林镇', '4', '12685');
INSERT INTO `tp_region` VALUES ('12697', '仓前镇', '4', '12685');
INSERT INTO `tp_region` VALUES ('12698', '余杭镇', '4', '12685');
INSERT INTO `tp_region` VALUES ('12699', '径山镇', '4', '12685');
INSERT INTO `tp_region` VALUES ('12700', '瓶窑镇', '4', '12685');
INSERT INTO `tp_region` VALUES ('12701', '鸬鸟镇', '4', '12685');
INSERT INTO `tp_region` VALUES ('12702', '百丈镇', '4', '12685');
INSERT INTO `tp_region` VALUES ('12703', '黄湖镇', '4', '12685');
INSERT INTO `tp_region` VALUES ('12704', '中泰乡', '4', '12685');
INSERT INTO `tp_region` VALUES ('12705', '桐庐县', '3', '12597');
INSERT INTO `tp_region` VALUES ('12706', '桐君街道', '4', '12705');
INSERT INTO `tp_region` VALUES ('12707', '旧县街道', '4', '12705');
INSERT INTO `tp_region` VALUES ('12708', '富春江镇', '4', '12705');
INSERT INTO `tp_region` VALUES ('12709', '横村镇', '4', '12705');
INSERT INTO `tp_region` VALUES ('12710', '凤川镇', '4', '12705');
INSERT INTO `tp_region` VALUES ('12711', '分水镇', '4', '12705');
INSERT INTO `tp_region` VALUES ('12712', '瑶琳镇', '4', '12705');
INSERT INTO `tp_region` VALUES ('12713', '百江镇', '4', '12705');
INSERT INTO `tp_region` VALUES ('12714', '江南镇', '4', '12705');
INSERT INTO `tp_region` VALUES ('12715', '莪山畲族自治乡', '4', '12705');
INSERT INTO `tp_region` VALUES ('12716', '钟山乡', '4', '12705');
INSERT INTO `tp_region` VALUES ('12717', '新合乡', '4', '12705');
INSERT INTO `tp_region` VALUES ('12718', '合村乡', '4', '12705');
INSERT INTO `tp_region` VALUES ('12719', '淳安县', '3', '12597');
INSERT INTO `tp_region` VALUES ('12720', '千岛湖镇', '4', '12719');
INSERT INTO `tp_region` VALUES ('12721', '文昌镇', '4', '12719');
INSERT INTO `tp_region` VALUES ('12722', '石林镇', '4', '12719');
INSERT INTO `tp_region` VALUES ('12723', '临岐镇', '4', '12719');
INSERT INTO `tp_region` VALUES ('12724', '威坪镇', '4', '12719');
INSERT INTO `tp_region` VALUES ('12725', '姜家镇', '4', '12719');
INSERT INTO `tp_region` VALUES ('12726', '梓桐镇', '4', '12719');
INSERT INTO `tp_region` VALUES ('12727', '汾口镇', '4', '12719');
INSERT INTO `tp_region` VALUES ('12728', '中洲镇', '4', '12719');
INSERT INTO `tp_region` VALUES ('12729', '大墅镇', '4', '12719');
INSERT INTO `tp_region` VALUES ('12730', '枫树岭镇', '4', '12719');
INSERT INTO `tp_region` VALUES ('12731', '里商乡', '4', '12719');
INSERT INTO `tp_region` VALUES ('12732', '金峰乡', '4', '12719');
INSERT INTO `tp_region` VALUES ('12733', '富文乡', '4', '12719');
INSERT INTO `tp_region` VALUES ('12734', '左口乡', '4', '12719');
INSERT INTO `tp_region` VALUES ('12735', '屏门乡', '4', '12719');
INSERT INTO `tp_region` VALUES ('12736', '瑶山乡', '4', '12719');
INSERT INTO `tp_region` VALUES ('12737', '王阜乡', '4', '12719');
INSERT INTO `tp_region` VALUES ('12738', '宋村乡', '4', '12719');
INSERT INTO `tp_region` VALUES ('12739', '鸠坑乡', '4', '12719');
INSERT INTO `tp_region` VALUES ('12740', '浪川乡', '4', '12719');
INSERT INTO `tp_region` VALUES ('12741', '界首乡', '4', '12719');
INSERT INTO `tp_region` VALUES ('12742', '安阳乡', '4', '12719');
INSERT INTO `tp_region` VALUES ('12743', '建德市', '3', '12597');
INSERT INTO `tp_region` VALUES ('12744', '新安江街道', '4', '12743');
INSERT INTO `tp_region` VALUES ('12745', '洋溪街道', '4', '12743');
INSERT INTO `tp_region` VALUES ('12746', '更楼街道', '4', '12743');
INSERT INTO `tp_region` VALUES ('12747', '莲花镇', '4', '12743');
INSERT INTO `tp_region` VALUES ('12748', '乾潭镇', '4', '12743');
INSERT INTO `tp_region` VALUES ('12749', '梅城镇', '4', '12743');
INSERT INTO `tp_region` VALUES ('12750', '杨村桥镇', '4', '12743');
INSERT INTO `tp_region` VALUES ('12751', '下涯镇', '4', '12743');
INSERT INTO `tp_region` VALUES ('12752', '大洋镇', '4', '12743');
INSERT INTO `tp_region` VALUES ('12753', '三都镇', '4', '12743');
INSERT INTO `tp_region` VALUES ('12754', '寿昌镇', '4', '12743');
INSERT INTO `tp_region` VALUES ('12755', '航头镇', '4', '12743');
INSERT INTO `tp_region` VALUES ('12756', '大慈岩镇', '4', '12743');
INSERT INTO `tp_region` VALUES ('12757', '大同镇', '4', '12743');
INSERT INTO `tp_region` VALUES ('12758', '李家镇', '4', '12743');
INSERT INTO `tp_region` VALUES ('12759', '钦堂乡', '4', '12743');
INSERT INTO `tp_region` VALUES ('12760', '富阳市', '3', '12597');
INSERT INTO `tp_region` VALUES ('12761', '富春街道', '4', '12760');
INSERT INTO `tp_region` VALUES ('12762', '春江街道', '4', '12760');
INSERT INTO `tp_region` VALUES ('12763', '东洲街道', '4', '12760');
INSERT INTO `tp_region` VALUES ('12764', '鹿山街道', '4', '12760');
INSERT INTO `tp_region` VALUES ('12765', '万市镇', '4', '12760');
INSERT INTO `tp_region` VALUES ('12766', '洞桥镇', '4', '12760');
INSERT INTO `tp_region` VALUES ('12767', '新登镇', '4', '12760');
INSERT INTO `tp_region` VALUES ('12768', '渌渚镇', '4', '12760');
INSERT INTO `tp_region` VALUES ('12769', '胥口镇', '4', '12760');
INSERT INTO `tp_region` VALUES ('12770', '永昌镇', '4', '12760');
INSERT INTO `tp_region` VALUES ('12771', '大源镇', '4', '12760');
INSERT INTO `tp_region` VALUES ('12772', '灵桥镇', '4', '12760');
INSERT INTO `tp_region` VALUES ('12773', '里山镇', '4', '12760');
INSERT INTO `tp_region` VALUES ('12774', '常绿镇', '4', '12760');
INSERT INTO `tp_region` VALUES ('12775', '场口镇', '4', '12760');
INSERT INTO `tp_region` VALUES ('12776', '常安镇', '4', '12760');
INSERT INTO `tp_region` VALUES ('12777', '龙门镇', '4', '12760');
INSERT INTO `tp_region` VALUES ('12778', '高桥镇', '4', '12760');
INSERT INTO `tp_region` VALUES ('12779', '受降镇', '4', '12760');
INSERT INTO `tp_region` VALUES ('12780', '新桐乡', '4', '12760');
INSERT INTO `tp_region` VALUES ('12781', '上官乡', '4', '12760');
INSERT INTO `tp_region` VALUES ('12782', '渔山乡', '4', '12760');
INSERT INTO `tp_region` VALUES ('12783', '环山乡', '4', '12760');
INSERT INTO `tp_region` VALUES ('12784', '湖源乡', '4', '12760');
INSERT INTO `tp_region` VALUES ('12785', '春建乡', '4', '12760');
INSERT INTO `tp_region` VALUES ('12786', '临安市', '3', '12597');
INSERT INTO `tp_region` VALUES ('12787', '锦城街道', '4', '12786');
INSERT INTO `tp_region` VALUES ('12788', '玲珑街道', '4', '12786');
INSERT INTO `tp_region` VALUES ('12789', '青山湖街道', '4', '12786');
INSERT INTO `tp_region` VALUES ('12790', '上甘街道', '4', '12786');
INSERT INTO `tp_region` VALUES ('12791', '三口镇', '4', '12786');
INSERT INTO `tp_region` VALUES ('12792', '横畈镇', '4', '12786');
INSERT INTO `tp_region` VALUES ('12793', '高虹镇', '4', '12786');
INSERT INTO `tp_region` VALUES ('12794', '太湖源镇', '4', '12786');
INSERT INTO `tp_region` VALUES ('12795', '於潜镇', '4', '12786');
INSERT INTO `tp_region` VALUES ('12796', '藻溪镇', '4', '12786');
INSERT INTO `tp_region` VALUES ('12797', '太阳镇', '4', '12786');
INSERT INTO `tp_region` VALUES ('12798', '潜川镇', '4', '12786');
INSERT INTO `tp_region` VALUES ('12799', '昌化镇', '4', '12786');
INSERT INTO `tp_region` VALUES ('12800', '河桥镇', '4', '12786');
INSERT INTO `tp_region` VALUES ('12801', '龙岗镇', '4', '12786');
INSERT INTO `tp_region` VALUES ('12802', '湍口镇', '4', '12786');
INSERT INTO `tp_region` VALUES ('12803', '清凉峰镇', '4', '12786');
INSERT INTO `tp_region` VALUES ('12804', '岛石镇', '4', '12786');
INSERT INTO `tp_region` VALUES ('12805', '大峡谷镇', '4', '12786');
INSERT INTO `tp_region` VALUES ('12806', '板桥乡', '4', '12786');
INSERT INTO `tp_region` VALUES ('12807', '西天目乡', '4', '12786');
INSERT INTO `tp_region` VALUES ('12808', '千洪乡', '4', '12786');
INSERT INTO `tp_region` VALUES ('12809', '横路乡', '4', '12786');
INSERT INTO `tp_region` VALUES ('12810', '乐平乡', '4', '12786');
INSERT INTO `tp_region` VALUES ('12811', '马啸乡', '4', '12786');
INSERT INTO `tp_region` VALUES ('12812', '新桥乡', '4', '12786');
INSERT INTO `tp_region` VALUES ('12813', '宁波市', '2', '12596');
INSERT INTO `tp_region` VALUES ('12814', '市辖区', '3', '12813');
INSERT INTO `tp_region` VALUES ('12815', '海曙区', '3', '12813');
INSERT INTO `tp_region` VALUES ('12816', '南门街道', '4', '12815');
INSERT INTO `tp_region` VALUES ('12817', '江厦街道', '4', '12815');
INSERT INTO `tp_region` VALUES ('12818', '西门街道', '4', '12815');
INSERT INTO `tp_region` VALUES ('12819', '月湖街道', '4', '12815');
INSERT INTO `tp_region` VALUES ('12820', '鼓楼街道', '4', '12815');
INSERT INTO `tp_region` VALUES ('12821', '白云街道', '4', '12815');
INSERT INTO `tp_region` VALUES ('12822', '段塘街道', '4', '12815');
INSERT INTO `tp_region` VALUES ('12823', '望春街道', '4', '12815');
INSERT INTO `tp_region` VALUES ('12824', '江东区', '3', '12813');
INSERT INTO `tp_region` VALUES ('12825', '百丈街道', '4', '12824');
INSERT INTO `tp_region` VALUES ('12826', '东胜街道', '4', '12824');
INSERT INTO `tp_region` VALUES ('12827', '明楼街道', '4', '12824');
INSERT INTO `tp_region` VALUES ('12828', '白鹤街道', '4', '12824');
INSERT INTO `tp_region` VALUES ('12829', '东柳街道', '4', '12824');
INSERT INTO `tp_region` VALUES ('12830', '东郊街道', '4', '12824');
INSERT INTO `tp_region` VALUES ('12831', '福明街道', '4', '12824');
INSERT INTO `tp_region` VALUES ('12832', '江北区', '3', '12813');
INSERT INTO `tp_region` VALUES ('12833', '中马街道', '4', '12832');
INSERT INTO `tp_region` VALUES ('12834', '白沙街道', '4', '12832');
INSERT INTO `tp_region` VALUES ('12835', '孔浦街道', '4', '12832');
INSERT INTO `tp_region` VALUES ('12836', '文教街道', '4', '12832');
INSERT INTO `tp_region` VALUES ('12837', '甬江街道', '4', '12832');
INSERT INTO `tp_region` VALUES ('12838', '庄桥街道', '4', '12832');
INSERT INTO `tp_region` VALUES ('12839', '洪塘街道', '4', '12832');
INSERT INTO `tp_region` VALUES ('12840', '慈城镇', '4', '12832');
INSERT INTO `tp_region` VALUES ('12841', '北仑区', '3', '12813');
INSERT INTO `tp_region` VALUES ('12842', '大榭街道', '4', '12841');
INSERT INTO `tp_region` VALUES ('12843', '新碶街道', '4', '12841');
INSERT INTO `tp_region` VALUES ('12844', '小港街道', '4', '12841');
INSERT INTO `tp_region` VALUES ('12845', '大碶街道', '4', '12841');
INSERT INTO `tp_region` VALUES ('12846', '霞浦街道', '4', '12841');
INSERT INTO `tp_region` VALUES ('12847', '柴桥街道', '4', '12841');
INSERT INTO `tp_region` VALUES ('12848', '白峰镇', '4', '12841');
INSERT INTO `tp_region` VALUES ('12849', '春晓镇', '4', '12841');
INSERT INTO `tp_region` VALUES ('12850', '梅山乡', '4', '12841');
INSERT INTO `tp_region` VALUES ('12851', '镇海区', '3', '12813');
INSERT INTO `tp_region` VALUES ('12852', '招宝山街道', '4', '12851');
INSERT INTO `tp_region` VALUES ('12853', '蛟川街道', '4', '12851');
INSERT INTO `tp_region` VALUES ('12854', '骆驼街道', '4', '12851');
INSERT INTO `tp_region` VALUES ('12855', '庄市街道', '4', '12851');
INSERT INTO `tp_region` VALUES ('12856', '澥浦镇', '4', '12851');
INSERT INTO `tp_region` VALUES ('12857', '九龙湖镇', '4', '12851');
INSERT INTO `tp_region` VALUES ('12858', '鄞州区', '3', '12813');
INSERT INTO `tp_region` VALUES ('12859', '下应街道', '4', '12858');
INSERT INTO `tp_region` VALUES ('12860', '钟公庙街道', '4', '12858');
INSERT INTO `tp_region` VALUES ('12861', '石碶街道', '4', '12858');
INSERT INTO `tp_region` VALUES ('12862', '梅墟街道', '4', '12858');
INSERT INTO `tp_region` VALUES ('12863', '瞻岐镇', '4', '12858');
INSERT INTO `tp_region` VALUES ('12864', '咸祥镇', '4', '12858');
INSERT INTO `tp_region` VALUES ('12865', '塘溪镇', '4', '12858');
INSERT INTO `tp_region` VALUES ('12866', '东钱湖镇', '4', '12858');
INSERT INTO `tp_region` VALUES ('12867', '东吴镇', '4', '12858');
INSERT INTO `tp_region` VALUES ('12868', '五乡镇', '4', '12858');
INSERT INTO `tp_region` VALUES ('12869', '邱隘镇', '4', '12858');
INSERT INTO `tp_region` VALUES ('12870', '云龙镇', '4', '12858');
INSERT INTO `tp_region` VALUES ('12871', '横溪镇', '4', '12858');
INSERT INTO `tp_region` VALUES ('12872', '姜山镇', '4', '12858');
INSERT INTO `tp_region` VALUES ('12873', '高桥镇', '4', '12858');
INSERT INTO `tp_region` VALUES ('12874', '横街镇', '4', '12858');
INSERT INTO `tp_region` VALUES ('12875', '集仕港镇', '4', '12858');
INSERT INTO `tp_region` VALUES ('12876', '古林镇', '4', '12858');
INSERT INTO `tp_region` VALUES ('12877', '洞桥镇', '4', '12858');
INSERT INTO `tp_region` VALUES ('12878', '鄞江镇', '4', '12858');
INSERT INTO `tp_region` VALUES ('12879', '章水镇', '4', '12858');
INSERT INTO `tp_region` VALUES ('12880', '龙观乡', '4', '12858');
INSERT INTO `tp_region` VALUES ('12881', '象山县', '3', '12813');
INSERT INTO `tp_region` VALUES ('12882', '丹东街道', '4', '12881');
INSERT INTO `tp_region` VALUES ('12883', '丹西街道', '4', '12881');
INSERT INTO `tp_region` VALUES ('12884', '爵溪街道', '4', '12881');
INSERT INTO `tp_region` VALUES ('12885', '石浦镇', '4', '12881');
INSERT INTO `tp_region` VALUES ('12886', '西周镇', '4', '12881');
INSERT INTO `tp_region` VALUES ('12887', '鹤浦镇', '4', '12881');
INSERT INTO `tp_region` VALUES ('12888', '贤庠镇', '4', '12881');
INSERT INTO `tp_region` VALUES ('12889', '墙头镇', '4', '12881');
INSERT INTO `tp_region` VALUES ('12890', '泗洲头镇', '4', '12881');
INSERT INTO `tp_region` VALUES ('12891', '定塘镇', '4', '12881');
INSERT INTO `tp_region` VALUES ('12892', '涂茨镇', '4', '12881');
INSERT INTO `tp_region` VALUES ('12893', '大徐镇', '4', '12881');
INSERT INTO `tp_region` VALUES ('12894', '新桥镇', '4', '12881');
INSERT INTO `tp_region` VALUES ('12895', '东陈乡', '4', '12881');
INSERT INTO `tp_region` VALUES ('12896', '晓塘乡', '4', '12881');
INSERT INTO `tp_region` VALUES ('12897', '黄避岙乡', '4', '12881');
INSERT INTO `tp_region` VALUES ('12898', '茅洋乡', '4', '12881');
INSERT INTO `tp_region` VALUES ('12899', '高塘岛乡', '4', '12881');
INSERT INTO `tp_region` VALUES ('12900', '宁海县', '3', '12813');
INSERT INTO `tp_region` VALUES ('12901', '跃龙街道', '4', '12900');
INSERT INTO `tp_region` VALUES ('12902', '桃源街道', '4', '12900');
INSERT INTO `tp_region` VALUES ('12903', '梅林街道', '4', '12900');
INSERT INTO `tp_region` VALUES ('12904', '桥头胡街道', '4', '12900');
INSERT INTO `tp_region` VALUES ('12905', '长街镇', '4', '12900');
INSERT INTO `tp_region` VALUES ('12906', '力洋镇', '4', '12900');
INSERT INTO `tp_region` VALUES ('12907', '一市镇', '4', '12900');
INSERT INTO `tp_region` VALUES ('12908', '岔路镇', '4', '12900');
INSERT INTO `tp_region` VALUES ('12909', '前童镇', '4', '12900');
INSERT INTO `tp_region` VALUES ('12910', '桑洲镇', '4', '12900');
INSERT INTO `tp_region` VALUES ('12911', '黄坛镇', '4', '12900');
INSERT INTO `tp_region` VALUES ('12912', '大佳何镇', '4', '12900');
INSERT INTO `tp_region` VALUES ('12913', '强蛟镇', '4', '12900');
INSERT INTO `tp_region` VALUES ('12914', '西店镇', '4', '12900');
INSERT INTO `tp_region` VALUES ('12915', '深圳镇', '4', '12900');
INSERT INTO `tp_region` VALUES ('12916', '胡陈乡', '4', '12900');
INSERT INTO `tp_region` VALUES ('12917', '茶院乡', '4', '12900');
INSERT INTO `tp_region` VALUES ('12918', '越溪乡', '4', '12900');
INSERT INTO `tp_region` VALUES ('12919', '余姚市', '3', '12813');
INSERT INTO `tp_region` VALUES ('12920', '梨洲街道', '4', '12919');
INSERT INTO `tp_region` VALUES ('12921', '凤山街道', '4', '12919');
INSERT INTO `tp_region` VALUES ('12922', '兰江街道', '4', '12919');
INSERT INTO `tp_region` VALUES ('12923', '阳明街道', '4', '12919');
INSERT INTO `tp_region` VALUES ('12924', '低塘街道', '4', '12919');
INSERT INTO `tp_region` VALUES ('12925', '朗霞街道', '4', '12919');
INSERT INTO `tp_region` VALUES ('12926', '临山镇', '4', '12919');
INSERT INTO `tp_region` VALUES ('12927', '黄家埠镇', '4', '12919');
INSERT INTO `tp_region` VALUES ('12928', '小曹娥镇', '4', '12919');
INSERT INTO `tp_region` VALUES ('12929', '泗门镇', '4', '12919');
INSERT INTO `tp_region` VALUES ('12930', '马渚镇', '4', '12919');
INSERT INTO `tp_region` VALUES ('12931', '牟山镇', '4', '12919');
INSERT INTO `tp_region` VALUES ('12932', '丈亭镇', '4', '12919');
INSERT INTO `tp_region` VALUES ('12933', '三七市镇', '4', '12919');
INSERT INTO `tp_region` VALUES ('12934', '河姆渡镇', '4', '12919');
INSERT INTO `tp_region` VALUES ('12935', '大隐镇', '4', '12919');
INSERT INTO `tp_region` VALUES ('12936', '陆埠镇', '4', '12919');
INSERT INTO `tp_region` VALUES ('12937', '梁弄镇', '4', '12919');
INSERT INTO `tp_region` VALUES ('12938', '大岚镇', '4', '12919');
INSERT INTO `tp_region` VALUES ('12939', '四明山镇', '4', '12919');
INSERT INTO `tp_region` VALUES ('12940', '鹿亭乡', '4', '12919');
INSERT INTO `tp_region` VALUES ('12941', '慈溪市', '3', '12813');
INSERT INTO `tp_region` VALUES ('12942', '浒山街道', '4', '12941');
INSERT INTO `tp_region` VALUES ('12943', '宗汉街道', '4', '12941');
INSERT INTO `tp_region` VALUES ('12944', '坎墩街道', '4', '12941');
INSERT INTO `tp_region` VALUES ('12945', '龙山镇', '4', '12941');
INSERT INTO `tp_region` VALUES ('12946', '三北镇', '4', '12941');
INSERT INTO `tp_region` VALUES ('12947', '范市镇', '4', '12941');
INSERT INTO `tp_region` VALUES ('12948', '掌起镇', '4', '12941');
INSERT INTO `tp_region` VALUES ('12949', '观海卫镇', '4', '12941');
INSERT INTO `tp_region` VALUES ('12950', '附海镇', '4', '12941');
INSERT INTO `tp_region` VALUES ('12951', '桥头镇', '4', '12941');
INSERT INTO `tp_region` VALUES ('12952', '匡堰镇', '4', '12941');
INSERT INTO `tp_region` VALUES ('12953', '逍林镇', '4', '12941');
INSERT INTO `tp_region` VALUES ('12954', '新浦镇', '4', '12941');
INSERT INTO `tp_region` VALUES ('12955', '胜山镇', '4', '12941');
INSERT INTO `tp_region` VALUES ('12956', '横河镇', '4', '12941');
INSERT INTO `tp_region` VALUES ('12957', '崇寿镇', '4', '12941');
INSERT INTO `tp_region` VALUES ('12958', '庵东镇', '4', '12941');
INSERT INTO `tp_region` VALUES ('12959', '天元镇', '4', '12941');
INSERT INTO `tp_region` VALUES ('12960', '长河镇', '4', '12941');
INSERT INTO `tp_region` VALUES ('12961', '周巷镇', '4', '12941');
INSERT INTO `tp_region` VALUES ('12962', '奉化市', '3', '12813');
INSERT INTO `tp_region` VALUES ('12963', '锦屏街道', '4', '12962');
INSERT INTO `tp_region` VALUES ('12964', '岳林街道', '4', '12962');
INSERT INTO `tp_region` VALUES ('12965', '江口街道', '4', '12962');
INSERT INTO `tp_region` VALUES ('12966', '西坞街道', '4', '12962');
INSERT INTO `tp_region` VALUES ('12967', '萧王庙街道', '4', '12962');
INSERT INTO `tp_region` VALUES ('12968', '溪口镇', '4', '12962');
INSERT INTO `tp_region` VALUES ('12969', '尚田镇', '4', '12962');
INSERT INTO `tp_region` VALUES ('12970', '莼湖镇', '4', '12962');
INSERT INTO `tp_region` VALUES ('12971', '裘村镇', '4', '12962');
INSERT INTO `tp_region` VALUES ('12972', '大堰镇', '4', '12962');
INSERT INTO `tp_region` VALUES ('12973', '松岙镇', '4', '12962');
INSERT INTO `tp_region` VALUES ('12974', '温州市', '2', '12596');
INSERT INTO `tp_region` VALUES ('12975', '市辖区', '3', '12974');
INSERT INTO `tp_region` VALUES ('12976', '鹿城区', '3', '12974');
INSERT INTO `tp_region` VALUES ('12977', '洪殿街道', '4', '12976');
INSERT INTO `tp_region` VALUES ('12978', '五马街道', '4', '12976');
INSERT INTO `tp_region` VALUES ('12979', '蒲鞋市街道', '4', '12976');
INSERT INTO `tp_region` VALUES ('12980', '莲池街道', '4', '12976');
INSERT INTO `tp_region` VALUES ('12981', '广化街道', '4', '12976');
INSERT INTO `tp_region` VALUES ('12982', '水心街道', '4', '12976');
INSERT INTO `tp_region` VALUES ('12983', '南浦街道', '4', '12976');
INSERT INTO `tp_region` VALUES ('12984', '南门街道', '4', '12976');
INSERT INTO `tp_region` VALUES ('12985', '江滨街道', '4', '12976');
INSERT INTO `tp_region` VALUES ('12986', '黎明街道', '4', '12976');
INSERT INTO `tp_region` VALUES ('12987', '绣山街道', '4', '12976');
INSERT INTO `tp_region` VALUES ('12988', '黄龙街道', '4', '12976');
INSERT INTO `tp_region` VALUES ('12989', '双屿镇', '4', '12976');
INSERT INTO `tp_region` VALUES ('12990', '藤桥镇', '4', '12976');
INSERT INTO `tp_region` VALUES ('12991', '临江镇', '4', '12976');
INSERT INTO `tp_region` VALUES ('12992', '七都镇', '4', '12976');
INSERT INTO `tp_region` VALUES ('12993', '南郊乡', '4', '12976');
INSERT INTO `tp_region` VALUES ('12994', '仰义乡', '4', '12976');
INSERT INTO `tp_region` VALUES ('12995', '双潮乡', '4', '12976');
INSERT INTO `tp_region` VALUES ('12996', '上戍乡', '4', '12976');
INSERT INTO `tp_region` VALUES ('12997', '岙底乡', '4', '12976');
INSERT INTO `tp_region` VALUES ('12998', '龙湾区', '3', '12974');
INSERT INTO `tp_region` VALUES ('12999', '永中街道', '4', '12998');
INSERT INTO `tp_region` VALUES ('13000', '蒲州街道', '4', '12998');
INSERT INTO `tp_region` VALUES ('13001', '海滨街道', '4', '12998');
INSERT INTO `tp_region` VALUES ('13002', '永兴街道', '4', '12998');
INSERT INTO `tp_region` VALUES ('13003', '海城街道', '4', '12998');
INSERT INTO `tp_region` VALUES ('13004', '状元镇', '4', '12998');
INSERT INTO `tp_region` VALUES ('13005', '瑶溪镇', '4', '12998');
INSERT INTO `tp_region` VALUES ('13006', '沙城镇', '4', '12998');
INSERT INTO `tp_region` VALUES ('13007', '天河镇', '4', '12998');
INSERT INTO `tp_region` VALUES ('13008', '灵昆镇', '4', '12998');
INSERT INTO `tp_region` VALUES ('13009', '瓯海区', '3', '12974');
INSERT INTO `tp_region` VALUES ('13010', '景山街道', '4', '13009');
INSERT INTO `tp_region` VALUES ('13011', '梧田街道', '4', '13009');
INSERT INTO `tp_region` VALUES ('13012', '南白象街道', '4', '13009');
INSERT INTO `tp_region` VALUES ('13013', '茶山街道', '4', '13009');
INSERT INTO `tp_region` VALUES ('13014', '娄桥街道', '4', '13009');
INSERT INTO `tp_region` VALUES ('13015', '新桥街道', '4', '13009');
INSERT INTO `tp_region` VALUES ('13016', '三垟街道', '4', '13009');
INSERT INTO `tp_region` VALUES ('13017', '瞿溪镇', '4', '13009');
INSERT INTO `tp_region` VALUES ('13018', '郭溪镇', '4', '13009');
INSERT INTO `tp_region` VALUES ('13019', '潘桥镇', '4', '13009');
INSERT INTO `tp_region` VALUES ('13020', '泽雅镇', '4', '13009');
INSERT INTO `tp_region` VALUES ('13021', '丽岙镇', '4', '13009');
INSERT INTO `tp_region` VALUES ('13022', '仙岩镇', '4', '13009');
INSERT INTO `tp_region` VALUES ('13023', '洞头县', '3', '12974');
INSERT INTO `tp_region` VALUES ('13024', '北岙镇', '4', '13023');
INSERT INTO `tp_region` VALUES ('13025', '大门镇', '4', '13023');
INSERT INTO `tp_region` VALUES ('13026', '东屏镇', '4', '13023');
INSERT INTO `tp_region` VALUES ('13027', '元觉乡', '4', '13023');
INSERT INTO `tp_region` VALUES ('13028', '霓屿乡', '4', '13023');
INSERT INTO `tp_region` VALUES ('13029', '鹿西乡', '4', '13023');
INSERT INTO `tp_region` VALUES ('13030', '永嘉县', '3', '12974');
INSERT INTO `tp_region` VALUES ('13031', '上塘镇', '4', '13030');
INSERT INTO `tp_region` VALUES ('13032', '瓯北镇', '4', '13030');
INSERT INTO `tp_region` VALUES ('13033', '桥头镇', '4', '13030');
INSERT INTO `tp_region` VALUES ('13034', '乌牛镇', '4', '13030');
INSERT INTO `tp_region` VALUES ('13035', '桥下镇', '4', '13030');
INSERT INTO `tp_region` VALUES ('13036', '大若岩镇', '4', '13030');
INSERT INTO `tp_region` VALUES ('13037', '碧莲镇', '4', '13030');
INSERT INTO `tp_region` VALUES ('13038', '巽宅镇', '4', '13030');
INSERT INTO `tp_region` VALUES ('13039', '岩头镇', '4', '13030');
INSERT INTO `tp_region` VALUES ('13040', '枫林镇', '4', '13030');
INSERT INTO `tp_region` VALUES ('13041', '岩坦镇', '4', '13030');
INSERT INTO `tp_region` VALUES ('13042', '沙头镇', '4', '13030');
INSERT INTO `tp_region` VALUES ('13043', '西溪乡', '4', '13030');
INSERT INTO `tp_region` VALUES ('13044', '徐岙乡', '4', '13030');
INSERT INTO `tp_region` VALUES ('13045', '昆阳乡', '4', '13030');
INSERT INTO `tp_region` VALUES ('13046', '茗岙乡', '4', '13030');
INSERT INTO `tp_region` VALUES ('13047', '山坑乡', '4', '13030');
INSERT INTO `tp_region` VALUES ('13048', '应坑乡', '4', '13030');
INSERT INTO `tp_region` VALUES ('13049', '大岙乡', '4', '13030');
INSERT INTO `tp_region` VALUES ('13050', '溪下乡', '4', '13030');
INSERT INTO `tp_region` VALUES ('13051', '界坑乡', '4', '13030');
INSERT INTO `tp_region` VALUES ('13052', '西岙乡', '4', '13030');
INSERT INTO `tp_region` VALUES ('13053', '石染乡', '4', '13030');
INSERT INTO `tp_region` VALUES ('13054', '五(氵束鸟）乡', '4', '13030');
INSERT INTO `tp_region` VALUES ('13055', '表山乡', '4', '13030');
INSERT INTO `tp_region` VALUES ('13056', '东皋乡', '4', '13030');
INSERT INTO `tp_region` VALUES ('13057', '鹤盛乡', '4', '13030');
INSERT INTO `tp_region` VALUES ('13058', '西源乡', '4', '13030');
INSERT INTO `tp_region` VALUES ('13059', '岭头乡', '4', '13030');
INSERT INTO `tp_region` VALUES ('13060', '溪口乡', '4', '13030');
INSERT INTO `tp_region` VALUES ('13061', '鲤溪乡', '4', '13030');
INSERT INTO `tp_region` VALUES ('13062', '张溪乡', '4', '13030');
INSERT INTO `tp_region` VALUES ('13063', '黄南乡', '4', '13030');
INSERT INTO `tp_region` VALUES ('13064', '潘坑乡', '4', '13030');
INSERT INTO `tp_region` VALUES ('13065', '陡门乡', '4', '13030');
INSERT INTO `tp_region` VALUES ('13066', '花坦乡', '4', '13030');
INSERT INTO `tp_region` VALUES ('13067', '渠口乡', '4', '13030');
INSERT INTO `tp_region` VALUES ('13068', '下寮乡', '4', '13030');
INSERT INTO `tp_region` VALUES ('13069', '平阳县', '3', '12974');
INSERT INTO `tp_region` VALUES ('13070', '昆阳镇', '4', '13069');
INSERT INTO `tp_region` VALUES ('13071', '鳌江镇', '4', '13069');
INSERT INTO `tp_region` VALUES ('13072', '水头镇', '4', '13069');
INSERT INTO `tp_region` VALUES ('13073', '萧江镇', '4', '13069');
INSERT INTO `tp_region` VALUES ('13074', '麻步镇', '4', '13069');
INSERT INTO `tp_region` VALUES ('13075', '腾蛟镇', '4', '13069');
INSERT INTO `tp_region` VALUES ('13076', '钱仓镇', '4', '13069');
INSERT INTO `tp_region` VALUES ('13077', '山门镇', '4', '13069');
INSERT INTO `tp_region` VALUES ('13078', '顺溪镇', '4', '13069');
INSERT INTO `tp_region` VALUES ('13079', '南雁镇', '4', '13069');
INSERT INTO `tp_region` VALUES ('13080', '凤卧镇', '4', '13069');
INSERT INTO `tp_region` VALUES ('13081', '鹤溪镇', '4', '13069');
INSERT INTO `tp_region` VALUES ('13082', '宋桥镇', '4', '13069');
INSERT INTO `tp_region` VALUES ('13083', '宋埠镇', '4', '13069');
INSERT INTO `tp_region` VALUES ('13084', '榆垟镇', '4', '13069');
INSERT INTO `tp_region` VALUES ('13085', '郑楼镇', '4', '13069');
INSERT INTO `tp_region` VALUES ('13086', '南麂镇', '4', '13069');
INSERT INTO `tp_region` VALUES ('13087', '西湾乡', '4', '13069');
INSERT INTO `tp_region` VALUES ('13088', '梅溪乡', '4', '13069');
INSERT INTO `tp_region` VALUES ('13089', '梅源乡', '4', '13069');
INSERT INTO `tp_region` VALUES ('13090', '桃源乡', '4', '13069');
INSERT INTO `tp_region` VALUES ('13091', '凤巢乡', '4', '13069');
INSERT INTO `tp_region` VALUES ('13092', '龙尾乡', '4', '13069');
INSERT INTO `tp_region` VALUES ('13093', '南湖乡', '4', '13069');
INSERT INTO `tp_region` VALUES ('13094', '朝阳乡', '4', '13069');
INSERT INTO `tp_region` VALUES ('13095', '闹村乡', '4', '13069');
INSERT INTO `tp_region` VALUES ('13096', '晓坑乡', '4', '13069');
INSERT INTO `tp_region` VALUES ('13097', '怀溪乡', '4', '13069');
INSERT INTO `tp_region` VALUES ('13098', '青街畲族乡', '4', '13069');
INSERT INTO `tp_region` VALUES ('13099', '维新乡', '4', '13069');
INSERT INTO `tp_region` VALUES ('13100', '吴垟乡', '4', '13069');
INSERT INTO `tp_region` VALUES ('13101', '苍南县', '3', '12974');
INSERT INTO `tp_region` VALUES ('13102', '灵溪镇', '4', '13101');
INSERT INTO `tp_region` VALUES ('13103', '龙港镇', '4', '13101');
INSERT INTO `tp_region` VALUES ('13104', '宜山镇', '4', '13101');
INSERT INTO `tp_region` VALUES ('13105', '钱库镇', '4', '13101');
INSERT INTO `tp_region` VALUES ('13106', '芦浦镇', '4', '13101');
INSERT INTO `tp_region` VALUES ('13107', '望里镇', '4', '13101');
INSERT INTO `tp_region` VALUES ('13108', '金乡镇', '4', '13101');
INSERT INTO `tp_region` VALUES ('13109', '舥艚镇', '4', '13101');
INSERT INTO `tp_region` VALUES ('13110', '炎亭镇', '4', '13101');
INSERT INTO `tp_region` VALUES ('13111', '大渔镇', '4', '13101');
INSERT INTO `tp_region` VALUES ('13112', '藻溪镇', '4', '13101');
INSERT INTO `tp_region` VALUES ('13113', '桥墩镇', '4', '13101');
INSERT INTO `tp_region` VALUES ('13114', '莒溪镇', '4', '13101');
INSERT INTO `tp_region` VALUES ('13115', '观美镇', '4', '13101');
INSERT INTO `tp_region` VALUES ('13116', '矾山镇', '4', '13101');
INSERT INTO `tp_region` VALUES ('13117', '赤溪镇', '4', '13101');
INSERT INTO `tp_region` VALUES ('13118', '马站镇', '4', '13101');
INSERT INTO `tp_region` VALUES ('13119', '霞关镇', '4', '13101');
INSERT INTO `tp_region` VALUES ('13120', '沿浦镇', '4', '13101');
INSERT INTO `tp_region` VALUES ('13121', '南宋镇', '4', '13101');
INSERT INTO `tp_region` VALUES ('13122', '云岩乡', '4', '13101');
INSERT INTO `tp_region` VALUES ('13123', '仙居乡', '4', '13101');
INSERT INTO `tp_region` VALUES ('13124', '新安乡', '4', '13101');
INSERT INTO `tp_region` VALUES ('13125', '括山乡', '4', '13101');
INSERT INTO `tp_region` VALUES ('13126', '石砰乡', '4', '13101');
INSERT INTO `tp_region` VALUES ('13127', '凤池乡', '4', '13101');
INSERT INTO `tp_region` VALUES ('13128', '浦亭乡', '4', '13101');
INSERT INTO `tp_region` VALUES ('13129', '五凤乡', '4', '13101');
INSERT INTO `tp_region` VALUES ('13130', '腾垟乡', '4', '13101');
INSERT INTO `tp_region` VALUES ('13131', '昌禅乡', '4', '13101');
INSERT INTO `tp_region` VALUES ('13132', '中墩乡', '4', '13101');
INSERT INTO `tp_region` VALUES ('13133', '龙沙乡', '4', '13101');
INSERT INTO `tp_region` VALUES ('13134', '凤阳畲族乡', '4', '13101');
INSERT INTO `tp_region` VALUES ('13135', '蒲城乡', '4', '13101');
INSERT INTO `tp_region` VALUES ('13136', '岱岭畲族乡', '4', '13101');
INSERT INTO `tp_region` VALUES ('13137', '渔寮乡', '4', '13101');
INSERT INTO `tp_region` VALUES ('13138', '文成县', '3', '12974');
INSERT INTO `tp_region` VALUES ('13139', '大峃镇', '4', '13138');
INSERT INTO `tp_region` VALUES ('13140', '百丈漈镇', '4', '13138');
INSERT INTO `tp_region` VALUES ('13141', '南田镇', '4', '13138');
INSERT INTO `tp_region` VALUES ('13142', '西坑畲族镇', '4', '13138');
INSERT INTO `tp_region` VALUES ('13143', '黄坦镇', '4', '13138');
INSERT INTO `tp_region` VALUES ('13144', '珊溪镇', '4', '13138');
INSERT INTO `tp_region` VALUES ('13145', '巨屿镇', '4', '13138');
INSERT INTO `tp_region` VALUES ('13146', '玉壶镇', '4', '13138');
INSERT INTO `tp_region` VALUES ('13147', '樟台乡', '4', '13138');
INSERT INTO `tp_region` VALUES ('13148', '金炉乡', '4', '13138');
INSERT INTO `tp_region` VALUES ('13149', '龙川乡', '4', '13138');
INSERT INTO `tp_region` VALUES ('13150', '里阳乡', '4', '13138');
INSERT INTO `tp_region` VALUES ('13151', '二源乡', '4', '13138');
INSERT INTO `tp_region` VALUES ('13152', '黄寮乡', '4', '13138');
INSERT INTO `tp_region` VALUES ('13153', '十源乡', '4', '13138');
INSERT INTO `tp_region` VALUES ('13154', '石垟乡', '4', '13138');
INSERT INTO `tp_region` VALUES ('13155', '下垟乡', '4', '13138');
INSERT INTO `tp_region` VALUES ('13156', '岭后乡', '4', '13138');
INSERT INTO `tp_region` VALUES ('13157', '富岙乡', '4', '13138');
INSERT INTO `tp_region` VALUES ('13158', '云湖乡', '4', '13138');
INSERT INTO `tp_region` VALUES ('13159', '仰山乡', '4', '13138');
INSERT INTO `tp_region` VALUES ('13160', '桂山乡', '4', '13138');
INSERT INTO `tp_region` VALUES ('13161', '峃口乡', '4', '13138');
INSERT INTO `tp_region` VALUES ('13162', '金垟乡', '4', '13138');
INSERT INTO `tp_region` VALUES ('13163', '双桂乡', '4', '13138');
INSERT INTO `tp_region` VALUES ('13164', '周山畲族乡', '4', '13138');
INSERT INTO `tp_region` VALUES ('13165', '公阳乡', '4', '13138');
INSERT INTO `tp_region` VALUES ('13166', '平和乡', '4', '13138');
INSERT INTO `tp_region` VALUES ('13167', '周壤乡', '4', '13138');
INSERT INTO `tp_region` VALUES ('13168', '上林乡', '4', '13138');
INSERT INTO `tp_region` VALUES ('13169', '东溪乡', '4', '13138');
INSERT INTO `tp_region` VALUES ('13170', '金星乡', '4', '13138');
INSERT INTO `tp_region` VALUES ('13171', '朱雅乡', '4', '13138');
INSERT INTO `tp_region` VALUES ('13172', '泰顺县', '3', '12974');
INSERT INTO `tp_region` VALUES ('13173', '罗阳镇', '4', '13172');
INSERT INTO `tp_region` VALUES ('13174', '司前畲族镇', '4', '13172');
INSERT INTO `tp_region` VALUES ('13175', '百丈镇', '4', '13172');
INSERT INTO `tp_region` VALUES ('13176', '筱村镇', '4', '13172');
INSERT INTO `tp_region` VALUES ('13177', '泗溪镇', '4', '13172');
INSERT INTO `tp_region` VALUES ('13178', '彭溪镇', '4', '13172');
INSERT INTO `tp_region` VALUES ('13179', '雅阳镇', '4', '13172');
INSERT INTO `tp_region` VALUES ('13180', '仕阳镇', '4', '13172');
INSERT INTO `tp_region` VALUES ('13181', '龟湖镇', '4', '13172');
INSERT INTO `tp_region` VALUES ('13182', '三魁镇', '4', '13172');
INSERT INTO `tp_region` VALUES ('13183', '西旸镇', '4', '13172');
INSERT INTO `tp_region` VALUES ('13184', '岭北乡', '4', '13172');
INSERT INTO `tp_region` VALUES ('13185', '仙稔乡', '4', '13172');
INSERT INTO `tp_region` VALUES ('13186', '南院乡', '4', '13172');
INSERT INTO `tp_region` VALUES ('13187', '碑排乡', '4', '13172');
INSERT INTO `tp_region` VALUES ('13188', '竹里畲族乡', '4', '13172');
INSERT INTO `tp_region` VALUES ('13189', '黄桥乡', '4', '13172');
INSERT INTO `tp_region` VALUES ('13190', '峰门乡', '4', '13172');
INSERT INTO `tp_region` VALUES ('13191', '包垟乡', '4', '13172');
INSERT INTO `tp_region` VALUES ('13192', '新浦乡', '4', '13172');
INSERT INTO `tp_region` VALUES ('13193', '联云乡', '4', '13172');
INSERT INTO `tp_region` VALUES ('13194', '翁山乡', '4', '13172');
INSERT INTO `tp_region` VALUES ('13195', '凤垟乡', '4', '13172');
INSERT INTO `tp_region` VALUES ('13196', '横坑乡', '4', '13172');
INSERT INTO `tp_region` VALUES ('13197', '九峰乡', '4', '13172');
INSERT INTO `tp_region` VALUES ('13198', '峰文乡', '4', '13172');
INSERT INTO `tp_region` VALUES ('13199', '月湖乡', '4', '13172');
INSERT INTO `tp_region` VALUES ('13200', '松垟乡', '4', '13172');
INSERT INTO `tp_region` VALUES ('13201', '柳峰乡', '4', '13172');
INSERT INTO `tp_region` VALUES ('13202', '雪溪乡', '4', '13172');
INSERT INTO `tp_region` VALUES ('13203', '万排乡', '4', '13172');
INSERT INTO `tp_region` VALUES ('13204', '东溪乡', '4', '13172');
INSERT INTO `tp_region` VALUES ('13205', '大安乡', '4', '13172');
INSERT INTO `tp_region` VALUES ('13206', '垟溪乡', '4', '13172');
INSERT INTO `tp_region` VALUES ('13207', '洲岭乡', '4', '13172');
INSERT INTO `tp_region` VALUES ('13208', '下洪乡', '4', '13172');
INSERT INTO `tp_region` VALUES ('13209', '瑞安市', '3', '12974');
INSERT INTO `tp_region` VALUES ('13210', '安阳街道', '4', '13209');
INSERT INTO `tp_region` VALUES ('13211', '玉海街道', '4', '13209');
INSERT INTO `tp_region` VALUES ('13212', '锦湖街道', '4', '13209');
INSERT INTO `tp_region` VALUES ('13213', '东山街道', '4', '13209');
INSERT INTO `tp_region` VALUES ('13214', '上望街道', '4', '13209');
INSERT INTO `tp_region` VALUES ('13215', '潘岱街道', '4', '13209');
INSERT INTO `tp_region` VALUES ('13216', '塘下镇', '4', '13209');
INSERT INTO `tp_region` VALUES ('13217', '莘塍镇', '4', '13209');
INSERT INTO `tp_region` VALUES ('13218', '汀田镇', '4', '13209');
INSERT INTO `tp_region` VALUES ('13219', '飞云镇', '4', '13209');
INSERT INTO `tp_region` VALUES ('13220', '仙降镇', '4', '13209');
INSERT INTO `tp_region` VALUES ('13221', '马屿镇', '4', '13209');
INSERT INTO `tp_region` VALUES ('13222', '曹村镇', '4', '13209');
INSERT INTO `tp_region` VALUES ('13223', '陶山镇', '4', '13209');
INSERT INTO `tp_region` VALUES ('13224', '碧山镇', '4', '13209');
INSERT INTO `tp_region` VALUES ('13225', '湖岭镇', '4', '13209');
INSERT INTO `tp_region` VALUES ('13226', '龙湖镇', '4', '13209');
INSERT INTO `tp_region` VALUES ('13227', '平阳坑镇', '4', '13209');
INSERT INTO `tp_region` VALUES ('13228', '荆谷乡', '4', '13209');
INSERT INTO `tp_region` VALUES ('13229', '梅屿乡', '4', '13209');
INSERT INTO `tp_region` VALUES ('13230', '顺泰乡', '4', '13209');
INSERT INTO `tp_region` VALUES ('13231', '大南乡', '4', '13209');
INSERT INTO `tp_region` VALUES ('13232', '桐浦乡', '4', '13209');
INSERT INTO `tp_region` VALUES ('13233', '永安乡', '4', '13209');
INSERT INTO `tp_region` VALUES ('13234', '桂峰乡', '4', '13209');
INSERT INTO `tp_region` VALUES ('13235', '芳庄乡', '4', '13209');
INSERT INTO `tp_region` VALUES ('13236', '林溪乡', '4', '13209');
INSERT INTO `tp_region` VALUES ('13237', '金川乡', '4', '13209');
INSERT INTO `tp_region` VALUES ('13238', '潮基乡', '4', '13209');
INSERT INTO `tp_region` VALUES ('13239', '鹿木乡', '4', '13209');
INSERT INTO `tp_region` VALUES ('13240', '高楼乡', '4', '13209');
INSERT INTO `tp_region` VALUES ('13241', '营前乡', '4', '13209');
INSERT INTO `tp_region` VALUES ('13242', '东岩乡', '4', '13209');
INSERT INTO `tp_region` VALUES ('13243', '宁益乡', '4', '13209');
INSERT INTO `tp_region` VALUES ('13244', '枫岭乡', '4', '13209');
INSERT INTO `tp_region` VALUES ('13245', '北麂乡', '4', '13209');
INSERT INTO `tp_region` VALUES ('13246', '北龙乡', '4', '13209');
INSERT INTO `tp_region` VALUES ('13247', '飞云江农场', '4', '13209');
INSERT INTO `tp_region` VALUES ('13248', '乐清市', '3', '12974');
INSERT INTO `tp_region` VALUES ('13249', '乐成镇', '4', '13248');
INSERT INTO `tp_region` VALUES ('13250', '大荆镇', '4', '13248');
INSERT INTO `tp_region` VALUES ('13251', '仙溪镇', '4', '13248');
INSERT INTO `tp_region` VALUES ('13252', '湖雾镇', '4', '13248');
INSERT INTO `tp_region` VALUES ('13253', '雁荡镇', '4', '13248');
INSERT INTO `tp_region` VALUES ('13254', '芙蓉镇', '4', '13248');
INSERT INTO `tp_region` VALUES ('13255', '清江镇', '4', '13248');
INSERT INTO `tp_region` VALUES ('13256', '南塘镇', '4', '13248');
INSERT INTO `tp_region` VALUES ('13257', '虹桥镇', '4', '13248');
INSERT INTO `tp_region` VALUES ('13258', '南岳镇', '4', '13248');
INSERT INTO `tp_region` VALUES ('13259', '蒲岐镇', '4', '13248');
INSERT INTO `tp_region` VALUES ('13260', '淡溪镇', '4', '13248');
INSERT INTO `tp_region` VALUES ('13261', '石帆镇', '4', '13248');
INSERT INTO `tp_region` VALUES ('13262', '白石镇', '4', '13248');
INSERT INTO `tp_region` VALUES ('13263', '柳市镇', '4', '13248');
INSERT INTO `tp_region` VALUES ('13264', '北白象镇', '4', '13248');
INSERT INTO `tp_region` VALUES ('13265', '象阳镇', '4', '13248');
INSERT INTO `tp_region` VALUES ('13266', '翁垟镇', '4', '13248');
INSERT INTO `tp_region` VALUES ('13267', '磐石镇', '4', '13248');
INSERT INTO `tp_region` VALUES ('13268', '七里港镇', '4', '13248');
INSERT INTO `tp_region` VALUES ('13269', '黄华镇', '4', '13248');
INSERT INTO `tp_region` VALUES ('13270', '智仁乡', '4', '13248');
INSERT INTO `tp_region` VALUES ('13271', '镇安乡', '4', '13248');
INSERT INTO `tp_region` VALUES ('13272', '福溪乡', '4', '13248');
INSERT INTO `tp_region` VALUES ('13273', '双峰乡', '4', '13248');
INSERT INTO `tp_region` VALUES ('13274', '龙西乡', '4', '13248');
INSERT INTO `tp_region` VALUES ('13275', '雁湖乡', '4', '13248');
INSERT INTO `tp_region` VALUES ('13276', '岭底乡', '4', '13248');
INSERT INTO `tp_region` VALUES ('13277', '四都乡', '4', '13248');
INSERT INTO `tp_region` VALUES ('13278', '天成乡', '4', '13248');
INSERT INTO `tp_region` VALUES ('13279', '城北乡', '4', '13248');
INSERT INTO `tp_region` VALUES ('13280', '嘉兴市', '2', '12596');
INSERT INTO `tp_region` VALUES ('13281', '市辖区', '3', '13280');
INSERT INTO `tp_region` VALUES ('13282', '南湖区', '3', '13280');
INSERT INTO `tp_region` VALUES ('13283', '建设街道', '4', '13282');
INSERT INTO `tp_region` VALUES ('13284', '解放街道', '4', '13282');
INSERT INTO `tp_region` VALUES ('13285', '新嘉街道', '4', '13282');
INSERT INTO `tp_region` VALUES ('13286', '南湖街道', '4', '13282');
INSERT INTO `tp_region` VALUES ('13287', '新兴街道', '4', '13282');
INSERT INTO `tp_region` VALUES ('13288', '城南街道', '4', '13282');
INSERT INTO `tp_region` VALUES ('13289', '东栅街道', '4', '13282');
INSERT INTO `tp_region` VALUES ('13290', '凤桥镇', '4', '13282');
INSERT INTO `tp_region` VALUES ('13291', '余新镇', '4', '13282');
INSERT INTO `tp_region` VALUES ('13292', '新丰镇', '4', '13282');
INSERT INTO `tp_region` VALUES ('13293', '七星镇', '4', '13282');
INSERT INTO `tp_region` VALUES ('13294', '大桥镇', '4', '13282');
INSERT INTO `tp_region` VALUES ('13295', '秀洲区', '3', '13280');
INSERT INTO `tp_region` VALUES ('13296', '新城街道', '4', '13295');
INSERT INTO `tp_region` VALUES ('13297', '嘉北街道', '4', '13295');
INSERT INTO `tp_region` VALUES ('13298', '塘汇街道', '4', '13295');
INSERT INTO `tp_region` VALUES ('13299', '王江泾镇', '4', '13295');
INSERT INTO `tp_region` VALUES ('13300', '油车港镇', '4', '13295');
INSERT INTO `tp_region` VALUES ('13301', '新塍镇', '4', '13295');
INSERT INTO `tp_region` VALUES ('13302', '王店镇', '4', '13295');
INSERT INTO `tp_region` VALUES ('13303', '洪合镇', '4', '13295');
INSERT INTO `tp_region` VALUES ('13304', '嘉善县', '3', '13280');
INSERT INTO `tp_region` VALUES ('13305', '魏塘镇', '4', '13304');
INSERT INTO `tp_region` VALUES ('13306', '惠民镇', '4', '13304');
INSERT INTO `tp_region` VALUES ('13307', '大云镇', '4', '13304');
INSERT INTO `tp_region` VALUES ('13308', '西塘镇', '4', '13304');
INSERT INTO `tp_region` VALUES ('13309', '丁栅镇', '4', '13304');
INSERT INTO `tp_region` VALUES ('13310', '干窑镇', '4', '13304');
INSERT INTO `tp_region` VALUES ('13311', '姚庄镇', '4', '13304');
INSERT INTO `tp_region` VALUES ('13312', '陶庄镇', '4', '13304');
INSERT INTO `tp_region` VALUES ('13313', '天凝镇', '4', '13304');
INSERT INTO `tp_region` VALUES ('13314', '洪溪镇', '4', '13304');
INSERT INTO `tp_region` VALUES ('13315', '杨庙镇', '4', '13304');
INSERT INTO `tp_region` VALUES ('13316', '海盐县', '3', '13280');
INSERT INTO `tp_region` VALUES ('13317', '武原镇', '4', '13316');
INSERT INTO `tp_region` VALUES ('13318', '沈荡镇', '4', '13316');
INSERT INTO `tp_region` VALUES ('13319', '百步镇', '4', '13316');
INSERT INTO `tp_region` VALUES ('13320', '于城镇', '4', '13316');
INSERT INTO `tp_region` VALUES ('13321', '秦山镇', '4', '13316');
INSERT INTO `tp_region` VALUES ('13322', '澉浦镇', '4', '13316');
INSERT INTO `tp_region` VALUES ('13323', '通元镇', '4', '13316');
INSERT INTO `tp_region` VALUES ('13324', '西塘桥镇', '4', '13316');
INSERT INTO `tp_region` VALUES ('13325', '海宁市', '3', '13280');
INSERT INTO `tp_region` VALUES ('13326', '硖石街道', '4', '13325');
INSERT INTO `tp_region` VALUES ('13327', '海洲街道', '4', '13325');
INSERT INTO `tp_region` VALUES ('13328', '海昌街道', '4', '13325');
INSERT INTO `tp_region` VALUES ('13329', '马桥街道', '4', '13325');
INSERT INTO `tp_region` VALUES ('13330', '许村镇', '4', '13325');
INSERT INTO `tp_region` VALUES ('13331', '长安镇', '4', '13325');
INSERT INTO `tp_region` VALUES ('13332', '周王庙镇', '4', '13325');
INSERT INTO `tp_region` VALUES ('13333', '丁桥镇', '4', '13325');
INSERT INTO `tp_region` VALUES ('13334', '斜桥镇', '4', '13325');
INSERT INTO `tp_region` VALUES ('13335', '黄湾镇', '4', '13325');
INSERT INTO `tp_region` VALUES ('13336', '盐官镇', '4', '13325');
INSERT INTO `tp_region` VALUES ('13337', '袁花镇', '4', '13325');
INSERT INTO `tp_region` VALUES ('13338', '尖山新区', '4', '13325');
INSERT INTO `tp_region` VALUES ('13339', '平湖市', '3', '13280');
INSERT INTO `tp_region` VALUES ('13340', '当湖街道', '4', '13339');
INSERT INTO `tp_region` VALUES ('13341', '钟埭街道', '4', '13339');
INSERT INTO `tp_region` VALUES ('13342', '曹桥街道', '4', '13339');
INSERT INTO `tp_region` VALUES ('13343', '乍浦镇', '4', '13339');
INSERT INTO `tp_region` VALUES ('13344', '新埭镇', '4', '13339');
INSERT INTO `tp_region` VALUES ('13345', '新仓镇', '4', '13339');
INSERT INTO `tp_region` VALUES ('13346', '黄姑镇', '4', '13339');
INSERT INTO `tp_region` VALUES ('13347', '全塘镇', '4', '13339');
INSERT INTO `tp_region` VALUES ('13348', '广陈镇', '4', '13339');
INSERT INTO `tp_region` VALUES ('13349', '林埭镇', '4', '13339');
INSERT INTO `tp_region` VALUES ('13350', '桐乡市', '3', '13280');
INSERT INTO `tp_region` VALUES ('13351', '梧桐街道', '4', '13350');
INSERT INTO `tp_region` VALUES ('13352', '龙翔街道', '4', '13350');
INSERT INTO `tp_region` VALUES ('13353', '凤鸣街道', '4', '13350');
INSERT INTO `tp_region` VALUES ('13354', '乌镇镇', '4', '13350');
INSERT INTO `tp_region` VALUES ('13355', '濮院镇', '4', '13350');
INSERT INTO `tp_region` VALUES ('13356', '屠甸镇', '4', '13350');
INSERT INTO `tp_region` VALUES ('13357', '石门镇', '4', '13350');
INSERT INTO `tp_region` VALUES ('13358', '河山镇', '4', '13350');
INSERT INTO `tp_region` VALUES ('13359', '洲泉镇', '4', '13350');
INSERT INTO `tp_region` VALUES ('13360', '大麻镇', '4', '13350');
INSERT INTO `tp_region` VALUES ('13361', '崇福镇', '4', '13350');
INSERT INTO `tp_region` VALUES ('13362', '高桥镇', '4', '13350');
INSERT INTO `tp_region` VALUES ('13363', '同福乡', '4', '13350');
INSERT INTO `tp_region` VALUES ('13364', '湖州市', '2', '12596');
INSERT INTO `tp_region` VALUES ('13365', '市辖区', '3', '13364');
INSERT INTO `tp_region` VALUES ('13366', '吴兴区', '3', '13364');
INSERT INTO `tp_region` VALUES ('13367', '月河街道', '4', '13366');
INSERT INTO `tp_region` VALUES ('13368', '朝阳街道', '4', '13366');
INSERT INTO `tp_region` VALUES ('13369', '爱山街道', '4', '13366');
INSERT INTO `tp_region` VALUES ('13370', '飞英街道', '4', '13366');
INSERT INTO `tp_region` VALUES ('13371', '龙泉街道', '4', '13366');
INSERT INTO `tp_region` VALUES ('13372', '凤凰街道', '4', '13366');
INSERT INTO `tp_region` VALUES ('13373', '织里镇', '4', '13366');
INSERT INTO `tp_region` VALUES ('13374', '八里店镇', '4', '13366');
INSERT INTO `tp_region` VALUES ('13375', '妙西镇', '4', '13366');
INSERT INTO `tp_region` VALUES ('13376', '杨家埠镇', '4', '13366');
INSERT INTO `tp_region` VALUES ('13377', '埭溪镇', '4', '13366');
INSERT INTO `tp_region` VALUES ('13378', '东林镇', '4', '13366');
INSERT INTO `tp_region` VALUES ('13379', '道场乡', '4', '13366');
INSERT INTO `tp_region` VALUES ('13380', '环渚乡', '4', '13366');
INSERT INTO `tp_region` VALUES ('13381', '白雀乡', '4', '13366');
INSERT INTO `tp_region` VALUES ('13382', '南浔区', '3', '13364');
INSERT INTO `tp_region` VALUES ('13383', '南浔镇', '4', '13382');
INSERT INTO `tp_region` VALUES ('13384', '双林镇', '4', '13382');
INSERT INTO `tp_region` VALUES ('13385', '练市镇', '4', '13382');
INSERT INTO `tp_region` VALUES ('13386', '善琏镇', '4', '13382');
INSERT INTO `tp_region` VALUES ('13387', '旧馆镇', '4', '13382');
INSERT INTO `tp_region` VALUES ('13388', '菱湖镇', '4', '13382');
INSERT INTO `tp_region` VALUES ('13389', '和孚镇', '4', '13382');
INSERT INTO `tp_region` VALUES ('13390', '千金镇', '4', '13382');
INSERT INTO `tp_region` VALUES ('13391', '石淙镇', '4', '13382');
INSERT INTO `tp_region` VALUES ('13392', '德清县', '3', '13364');
INSERT INTO `tp_region` VALUES ('13393', '武康镇', '4', '13392');
INSERT INTO `tp_region` VALUES ('13394', '乾元镇', '4', '13392');
INSERT INTO `tp_region` VALUES ('13395', '新市镇', '4', '13392');
INSERT INTO `tp_region` VALUES ('13396', '洛舍镇', '4', '13392');
INSERT INTO `tp_region` VALUES ('13397', '钟管镇', '4', '13392');
INSERT INTO `tp_region` VALUES ('13398', '莫干山镇', '4', '13392');
INSERT INTO `tp_region` VALUES ('13399', '雷甸镇', '4', '13392');
INSERT INTO `tp_region` VALUES ('13400', '禹越镇', '4', '13392');
INSERT INTO `tp_region` VALUES ('13401', '新安镇', '4', '13392');
INSERT INTO `tp_region` VALUES ('13402', '筏头乡', '4', '13392');
INSERT INTO `tp_region` VALUES ('13403', '三合乡', '4', '13392');
INSERT INTO `tp_region` VALUES ('13404', '长兴县', '3', '13364');
INSERT INTO `tp_region` VALUES ('13405', '雉城镇', '4', '13404');
INSERT INTO `tp_region` VALUES ('13406', '洪桥镇', '4', '13404');
INSERT INTO `tp_region` VALUES ('13407', '李家巷镇', '4', '13404');
INSERT INTO `tp_region` VALUES ('13408', '夹浦镇', '4', '13404');
INSERT INTO `tp_region` VALUES ('13409', '林城镇', '4', '13404');
INSERT INTO `tp_region` VALUES ('13410', '泗安镇', '4', '13404');
INSERT INTO `tp_region` VALUES ('13411', '虹星桥镇', '4', '13404');
INSERT INTO `tp_region` VALUES ('13412', '和平镇', '4', '13404');
INSERT INTO `tp_region` VALUES ('13413', '小浦镇', '4', '13404');
INSERT INTO `tp_region` VALUES ('13414', '煤山镇', '4', '13404');
INSERT INTO `tp_region` VALUES ('13415', '水口乡', '4', '13404');
INSERT INTO `tp_region` VALUES ('13416', '二界岭乡', '4', '13404');
INSERT INTO `tp_region` VALUES ('13417', '吕山乡', '4', '13404');
INSERT INTO `tp_region` VALUES ('13418', '吴山乡', '4', '13404');
INSERT INTO `tp_region` VALUES ('13419', '白岘乡', '4', '13404');
INSERT INTO `tp_region` VALUES ('13420', '槐坎乡', '4', '13404');
INSERT INTO `tp_region` VALUES ('13421', '安吉县', '3', '13364');
INSERT INTO `tp_region` VALUES ('13422', '递铺镇', '4', '13421');
INSERT INTO `tp_region` VALUES ('13423', '梅溪镇', '4', '13421');
INSERT INTO `tp_region` VALUES ('13424', '良朋镇', '4', '13421');
INSERT INTO `tp_region` VALUES ('13425', '鄣吴镇', '4', '13421');
INSERT INTO `tp_region` VALUES ('13426', '杭垓镇', '4', '13421');
INSERT INTO `tp_region` VALUES ('13427', '孝丰镇', '4', '13421');
INSERT INTO `tp_region` VALUES ('13428', '报福镇', '4', '13421');
INSERT INTO `tp_region` VALUES ('13429', '章村镇', '4', '13421');
INSERT INTO `tp_region` VALUES ('13430', '天荒坪镇', '4', '13421');
INSERT INTO `tp_region` VALUES ('13431', '高禹镇', '4', '13421');
INSERT INTO `tp_region` VALUES ('13432', '昆铜乡', '4', '13421');
INSERT INTO `tp_region` VALUES ('13433', '溪龙乡', '4', '13421');
INSERT INTO `tp_region` VALUES ('13434', '皈山乡', '4', '13421');
INSERT INTO `tp_region` VALUES ('13435', '上墅乡', '4', '13421');
INSERT INTO `tp_region` VALUES ('13436', '山川乡', '4', '13421');
INSERT INTO `tp_region` VALUES ('13437', '绍兴市', '2', '12596');
INSERT INTO `tp_region` VALUES ('13438', '市辖区', '3', '13437');
INSERT INTO `tp_region` VALUES ('13439', '越城区', '3', '13437');
INSERT INTO `tp_region` VALUES ('13440', '塔山街道', '4', '13439');
INSERT INTO `tp_region` VALUES ('13441', '府山街道', '4', '13439');
INSERT INTO `tp_region` VALUES ('13442', '蕺山街道', '4', '13439');
INSERT INTO `tp_region` VALUES ('13443', '北海街道', '4', '13439');
INSERT INTO `tp_region` VALUES ('13444', '城南街道', '4', '13439');
INSERT INTO `tp_region` VALUES ('13445', '稽山街道', '4', '13439');
INSERT INTO `tp_region` VALUES ('13446', '东湖镇', '4', '13439');
INSERT INTO `tp_region` VALUES ('13447', '灵芝镇', '4', '13439');
INSERT INTO `tp_region` VALUES ('13448', '东浦镇', '4', '13439');
INSERT INTO `tp_region` VALUES ('13449', '鉴湖镇', '4', '13439');
INSERT INTO `tp_region` VALUES ('13450', '皋埠镇', '4', '13439');
INSERT INTO `tp_region` VALUES ('13451', '马山镇', '4', '13439');
INSERT INTO `tp_region` VALUES ('13452', '斗门镇', '4', '13439');
INSERT INTO `tp_region` VALUES ('13453', '绍兴县', '3', '13437');
INSERT INTO `tp_region` VALUES ('13454', '柯桥街道', '4', '13453');
INSERT INTO `tp_region` VALUES ('13455', '柯岩街道', '4', '13453');
INSERT INTO `tp_region` VALUES ('13456', '华舍街道', '4', '13453');
INSERT INTO `tp_region` VALUES ('13457', '湖塘街道', '4', '13453');
INSERT INTO `tp_region` VALUES ('13458', '齐贤镇', '4', '13453');
INSERT INTO `tp_region` VALUES ('13459', '钱清镇', '4', '13453');
INSERT INTO `tp_region` VALUES ('13460', '孙端镇', '4', '13453');
INSERT INTO `tp_region` VALUES ('13461', '福全镇', '4', '13453');
INSERT INTO `tp_region` VALUES ('13462', '马鞍镇', '4', '13453');
INSERT INTO `tp_region` VALUES ('13463', '平水镇', '4', '13453');
INSERT INTO `tp_region` VALUES ('13464', '安昌镇', '4', '13453');
INSERT INTO `tp_region` VALUES ('13465', '王坛镇', '4', '13453');
INSERT INTO `tp_region` VALUES ('13466', '兰亭镇', '4', '13453');
INSERT INTO `tp_region` VALUES ('13467', '稽东镇', '4', '13453');
INSERT INTO `tp_region` VALUES ('13468', '杨汛桥镇', '4', '13453');
INSERT INTO `tp_region` VALUES ('13469', '漓渚镇', '4', '13453');
INSERT INTO `tp_region` VALUES ('13470', '富盛镇', '4', '13453');
INSERT INTO `tp_region` VALUES ('13471', '陶堰镇', '4', '13453');
INSERT INTO `tp_region` VALUES ('13472', '夏履镇', '4', '13453');
INSERT INTO `tp_region` VALUES ('13473', '新昌县', '3', '13437');
INSERT INTO `tp_region` VALUES ('13474', '羽林街道', '4', '13473');
INSERT INTO `tp_region` VALUES ('13475', '南明街道', '4', '13473');
INSERT INTO `tp_region` VALUES ('13476', '七星街道', '4', '13473');
INSERT INTO `tp_region` VALUES ('13477', '澄潭镇', '4', '13473');
INSERT INTO `tp_region` VALUES ('13478', '梅渚镇', '4', '13473');
INSERT INTO `tp_region` VALUES ('13479', '回山镇', '4', '13473');
INSERT INTO `tp_region` VALUES ('13480', '大市聚镇', '4', '13473');
INSERT INTO `tp_region` VALUES ('13481', '小将镇', '4', '13473');
INSERT INTO `tp_region` VALUES ('13482', '沙溪镇', '4', '13473');
INSERT INTO `tp_region` VALUES ('13483', '镜岭镇', '4', '13473');
INSERT INTO `tp_region` VALUES ('13484', '儒岙镇', '4', '13473');
INSERT INTO `tp_region` VALUES ('13485', '城南乡', '4', '13473');
INSERT INTO `tp_region` VALUES ('13486', '东茗乡', '4', '13473');
INSERT INTO `tp_region` VALUES ('13487', '双彩乡', '4', '13473');
INSERT INTO `tp_region` VALUES ('13488', '新林乡', '4', '13473');
INSERT INTO `tp_region` VALUES ('13489', '巧英乡', '4', '13473');
INSERT INTO `tp_region` VALUES ('13490', '诸暨市', '3', '13437');
INSERT INTO `tp_region` VALUES ('13491', '暨阳街道', '4', '13490');
INSERT INTO `tp_region` VALUES ('13492', '浣东街道', '4', '13490');
INSERT INTO `tp_region` VALUES ('13493', '陶朱街道', '4', '13490');
INSERT INTO `tp_region` VALUES ('13494', '大唐镇', '4', '13490');
INSERT INTO `tp_region` VALUES ('13495', '应店街镇', '4', '13490');
INSERT INTO `tp_region` VALUES ('13496', '次坞镇', '4', '13490');
INSERT INTO `tp_region` VALUES ('13497', '店口镇', '4', '13490');
INSERT INTO `tp_region` VALUES ('13498', '阮市镇', '4', '13490');
INSERT INTO `tp_region` VALUES ('13499', '直埠镇', '4', '13490');
INSERT INTO `tp_region` VALUES ('13500', '江藻镇', '4', '13490');
INSERT INTO `tp_region` VALUES ('13501', '山下湖镇', '4', '13490');
INSERT INTO `tp_region` VALUES ('13502', '枫桥镇', '4', '13490');
INSERT INTO `tp_region` VALUES ('13503', '赵家镇', '4', '13490');
INSERT INTO `tp_region` VALUES ('13504', '马剑镇', '4', '13490');
INSERT INTO `tp_region` VALUES ('13505', '五泄镇', '4', '13490');
INSERT INTO `tp_region` VALUES ('13506', '草塔镇', '4', '13490');
INSERT INTO `tp_region` VALUES ('13507', '王家井镇', '4', '13490');
INSERT INTO `tp_region` VALUES ('13508', '牌头镇', '4', '13490');
INSERT INTO `tp_region` VALUES ('13509', '同山镇', '4', '13490');
INSERT INTO `tp_region` VALUES ('13510', '安华镇', '4', '13490');
INSERT INTO `tp_region` VALUES ('13511', '街亭镇', '4', '13490');
INSERT INTO `tp_region` VALUES ('13512', '璜山镇', '4', '13490');
INSERT INTO `tp_region` VALUES ('13513', '陈宅镇', '4', '13490');
INSERT INTO `tp_region` VALUES ('13514', '岭北镇', '4', '13490');
INSERT INTO `tp_region` VALUES ('13515', '浬浦镇', '4', '13490');
INSERT INTO `tp_region` VALUES ('13516', '东白湖镇', '4', '13490');
INSERT INTO `tp_region` VALUES ('13517', '东和乡', '4', '13490');
INSERT INTO `tp_region` VALUES ('13518', '上虞市', '3', '13437');
INSERT INTO `tp_region` VALUES ('13519', '百官街道', '4', '13518');
INSERT INTO `tp_region` VALUES ('13520', '曹娥街道', '4', '13518');
INSERT INTO `tp_region` VALUES ('13521', '东关街道', '4', '13518');
INSERT INTO `tp_region` VALUES ('13522', '道墟镇', '4', '13518');
INSERT INTO `tp_region` VALUES ('13523', '长塘镇', '4', '13518');
INSERT INTO `tp_region` VALUES ('13524', '上浦镇', '4', '13518');
INSERT INTO `tp_region` VALUES ('13525', '汤浦镇', '4', '13518');
INSERT INTO `tp_region` VALUES ('13526', '章镇镇', '4', '13518');
INSERT INTO `tp_region` VALUES ('13527', '下管镇', '4', '13518');
INSERT INTO `tp_region` VALUES ('13528', '丰惠镇', '4', '13518');
INSERT INTO `tp_region` VALUES ('13529', '永和镇', '4', '13518');
INSERT INTO `tp_region` VALUES ('13530', '梁湖镇', '4', '13518');
INSERT INTO `tp_region` VALUES ('13531', '驿亭镇', '4', '13518');
INSERT INTO `tp_region` VALUES ('13532', '小越镇', '4', '13518');
INSERT INTO `tp_region` VALUES ('13533', '谢塘镇', '4', '13518');
INSERT INTO `tp_region` VALUES ('13534', '盖北镇', '4', '13518');
INSERT INTO `tp_region` VALUES ('13535', '崧厦镇', '4', '13518');
INSERT INTO `tp_region` VALUES ('13536', '沥海镇', '4', '13518');
INSERT INTO `tp_region` VALUES ('13537', '岭南乡', '4', '13518');
INSERT INTO `tp_region` VALUES ('13538', '陈溪乡', '4', '13518');
INSERT INTO `tp_region` VALUES ('13539', '丁宅乡', '4', '13518');
INSERT INTO `tp_region` VALUES ('13540', '围垦场', '4', '13518');
INSERT INTO `tp_region` VALUES ('13541', '农发场', '4', '13518');
INSERT INTO `tp_region` VALUES ('13542', '嵊州市', '3', '13437');
INSERT INTO `tp_region` VALUES ('13543', '剡湖街道', '4', '13542');
INSERT INTO `tp_region` VALUES ('13544', '三江街道', '4', '13542');
INSERT INTO `tp_region` VALUES ('13545', '鹿山街道', '4', '13542');
INSERT INTO `tp_region` VALUES ('13546', '浦口街道', '4', '13542');
INSERT INTO `tp_region` VALUES ('13547', '甘霖镇', '4', '13542');
INSERT INTO `tp_region` VALUES ('13548', '长乐镇', '4', '13542');
INSERT INTO `tp_region` VALUES ('13549', '崇仁镇', '4', '13542');
INSERT INTO `tp_region` VALUES ('13550', '黄泽镇', '4', '13542');
INSERT INTO `tp_region` VALUES ('13551', '三界镇', '4', '13542');
INSERT INTO `tp_region` VALUES ('13552', '石璜镇', '4', '13542');
INSERT INTO `tp_region` VALUES ('13553', '谷来镇', '4', '13542');
INSERT INTO `tp_region` VALUES ('13554', '仙岩镇', '4', '13542');
INSERT INTO `tp_region` VALUES ('13555', '金庭镇', '4', '13542');
INSERT INTO `tp_region` VALUES ('13556', '北漳镇', '4', '13542');
INSERT INTO `tp_region` VALUES ('13557', '下王镇', '4', '13542');
INSERT INTO `tp_region` VALUES ('13558', '贵门乡', '4', '13542');
INSERT INTO `tp_region` VALUES ('13559', '里南乡', '4', '13542');
INSERT INTO `tp_region` VALUES ('13560', '竹溪乡', '4', '13542');
INSERT INTO `tp_region` VALUES ('13561', '雅璜乡', '4', '13542');
INSERT INTO `tp_region` VALUES ('13562', '王院乡', '4', '13542');
INSERT INTO `tp_region` VALUES ('13563', '通源乡', '4', '13542');
INSERT INTO `tp_region` VALUES ('13564', '金华市', '2', '12596');
INSERT INTO `tp_region` VALUES ('13565', '市辖区', '3', '13564');
INSERT INTO `tp_region` VALUES ('13566', '婺城区', '3', '13564');
INSERT INTO `tp_region` VALUES ('13567', '城东街道', '4', '13566');
INSERT INTO `tp_region` VALUES ('13568', '城中街道', '4', '13566');
INSERT INTO `tp_region` VALUES ('13569', '城西街道', '4', '13566');
INSERT INTO `tp_region` VALUES ('13570', '城北街道', '4', '13566');
INSERT INTO `tp_region` VALUES ('13571', '江南街道', '4', '13566');
INSERT INTO `tp_region` VALUES ('13572', '三江街道', '4', '13566');
INSERT INTO `tp_region` VALUES ('13573', '西关街道', '4', '13566');
INSERT INTO `tp_region` VALUES ('13574', '秋滨街道', '4', '13566');
INSERT INTO `tp_region` VALUES ('13575', '新狮街道', '4', '13566');
INSERT INTO `tp_region` VALUES ('13576', '罗店镇', '4', '13566');
INSERT INTO `tp_region` VALUES ('13577', '雅畈镇', '4', '13566');
INSERT INTO `tp_region` VALUES ('13578', '安地镇', '4', '13566');
INSERT INTO `tp_region` VALUES ('13579', '白龙桥镇', '4', '13566');
INSERT INTO `tp_region` VALUES ('13580', '琅琊镇', '4', '13566');
INSERT INTO `tp_region` VALUES ('13581', '蒋堂镇', '4', '13566');
INSERT INTO `tp_region` VALUES ('13582', '汤溪镇', '4', '13566');
INSERT INTO `tp_region` VALUES ('13583', '罗埠镇', '4', '13566');
INSERT INTO `tp_region` VALUES ('13584', '洋埠镇', '4', '13566');
INSERT INTO `tp_region` VALUES ('13585', '乾西乡', '4', '13566');
INSERT INTO `tp_region` VALUES ('13586', '竹马乡', '4', '13566');
INSERT INTO `tp_region` VALUES ('13587', '长山乡', '4', '13566');
INSERT INTO `tp_region` VALUES ('13588', '箬阳乡', '4', '13566');
INSERT INTO `tp_region` VALUES ('13589', '沙畈乡', '4', '13566');
INSERT INTO `tp_region` VALUES ('13590', '塔石乡', '4', '13566');
INSERT INTO `tp_region` VALUES ('13591', '岭上乡', '4', '13566');
INSERT INTO `tp_region` VALUES ('13592', '莘畈乡', '4', '13566');
INSERT INTO `tp_region` VALUES ('13593', '苏孟乡', '4', '13566');
INSERT INTO `tp_region` VALUES ('13594', '金东区', '3', '13564');
INSERT INTO `tp_region` VALUES ('13595', '多湖街道', '4', '13594');
INSERT INTO `tp_region` VALUES ('13596', '东孝街道', '4', '13594');
INSERT INTO `tp_region` VALUES ('13597', '孝顺镇', '4', '13594');
INSERT INTO `tp_region` VALUES ('13598', '傅村镇', '4', '13594');
INSERT INTO `tp_region` VALUES ('13599', '曹宅镇', '4', '13594');
INSERT INTO `tp_region` VALUES ('13600', '澧浦镇', '4', '13594');
INSERT INTO `tp_region` VALUES ('13601', '岭下镇', '4', '13594');
INSERT INTO `tp_region` VALUES ('13602', '江东镇', '4', '13594');
INSERT INTO `tp_region` VALUES ('13603', '塘雅镇', '4', '13594');
INSERT INTO `tp_region` VALUES ('13604', '赤松镇', '4', '13594');
INSERT INTO `tp_region` VALUES ('13605', '源东乡', '4', '13594');
INSERT INTO `tp_region` VALUES ('13606', '武义县', '3', '13564');
INSERT INTO `tp_region` VALUES ('13607', '白洋街道', '4', '13606');
INSERT INTO `tp_region` VALUES ('13608', '壶山街道', '4', '13606');
INSERT INTO `tp_region` VALUES ('13609', '熟溪街道', '4', '13606');
INSERT INTO `tp_region` VALUES ('13610', '柳城畲族镇', '4', '13606');
INSERT INTO `tp_region` VALUES ('13611', '履坦镇', '4', '13606');
INSERT INTO `tp_region` VALUES ('13612', '桐琴镇', '4', '13606');
INSERT INTO `tp_region` VALUES ('13613', '泉溪镇', '4', '13606');
INSERT INTO `tp_region` VALUES ('13614', '新宅镇', '4', '13606');
INSERT INTO `tp_region` VALUES ('13615', '王宅镇', '4', '13606');
INSERT INTO `tp_region` VALUES ('13616', '桃溪镇', '4', '13606');
INSERT INTO `tp_region` VALUES ('13617', '茭道镇', '4', '13606');
INSERT INTO `tp_region` VALUES ('13618', '大田乡', '4', '13606');
INSERT INTO `tp_region` VALUES ('13619', '白姆乡', '4', '13606');
INSERT INTO `tp_region` VALUES ('13620', '俞源乡', '4', '13606');
INSERT INTO `tp_region` VALUES ('13621', '坦洪乡', '4', '13606');
INSERT INTO `tp_region` VALUES ('13622', '西联乡', '4', '13606');
INSERT INTO `tp_region` VALUES ('13623', '三港乡', '4', '13606');
INSERT INTO `tp_region` VALUES ('13624', '大溪口乡', '4', '13606');
INSERT INTO `tp_region` VALUES ('13625', '浦江县', '3', '13564');
INSERT INTO `tp_region` VALUES ('13626', '浦南街道', '4', '13625');
INSERT INTO `tp_region` VALUES ('13627', '仙华街道', '4', '13625');
INSERT INTO `tp_region` VALUES ('13628', '浦阳街道', '4', '13625');
INSERT INTO `tp_region` VALUES ('13629', '黄宅镇', '4', '13625');
INSERT INTO `tp_region` VALUES ('13630', '白马镇', '4', '13625');
INSERT INTO `tp_region` VALUES ('13631', '郑家坞镇', '4', '13625');
INSERT INTO `tp_region` VALUES ('13632', '郑宅镇', '4', '13625');
INSERT INTO `tp_region` VALUES ('13633', '岩头镇', '4', '13625');
INSERT INTO `tp_region` VALUES ('13634', '檀溪镇', '4', '13625');
INSERT INTO `tp_region` VALUES ('13635', '杭坪镇', '4', '13625');
INSERT INTO `tp_region` VALUES ('13636', '大畈乡', '4', '13625');
INSERT INTO `tp_region` VALUES ('13637', '中余乡', '4', '13625');
INSERT INTO `tp_region` VALUES ('13638', '前吴乡', '4', '13625');
INSERT INTO `tp_region` VALUES ('13639', '花桥乡', '4', '13625');
INSERT INTO `tp_region` VALUES ('13640', '虞宅乡', '4', '13625');
INSERT INTO `tp_region` VALUES ('13641', '磐安县', '3', '13564');
INSERT INTO `tp_region` VALUES ('13642', '安文镇', '4', '13641');
INSERT INTO `tp_region` VALUES ('13643', '新渥镇', '4', '13641');
INSERT INTO `tp_region` VALUES ('13644', '尖山镇', '4', '13641');
INSERT INTO `tp_region` VALUES ('13645', '仁川镇', '4', '13641');
INSERT INTO `tp_region` VALUES ('13646', '大盘镇', '4', '13641');
INSERT INTO `tp_region` VALUES ('13647', '方前镇', '4', '13641');
INSERT INTO `tp_region` VALUES ('13648', '玉山镇', '4', '13641');
INSERT INTO `tp_region` VALUES ('13649', '尚湖镇', '4', '13641');
INSERT INTO `tp_region` VALUES ('13650', '冷水镇', '4', '13641');
INSERT INTO `tp_region` VALUES ('13651', '深泽乡', '4', '13641');
INSERT INTO `tp_region` VALUES ('13652', '双峰乡', '4', '13641');
INSERT INTO `tp_region` VALUES ('13653', '双溪乡', '4', '13641');
INSERT INTO `tp_region` VALUES ('13654', '墨林乡', '4', '13641');
INSERT INTO `tp_region` VALUES ('13655', '窈川乡', '4', '13641');
INSERT INTO `tp_region` VALUES ('13656', '盘峰乡', '4', '13641');
INSERT INTO `tp_region` VALUES ('13657', '高二乡', '4', '13641');
INSERT INTO `tp_region` VALUES ('13658', '维新乡', '4', '13641');
INSERT INTO `tp_region` VALUES ('13659', '胡宅乡', '4', '13641');
INSERT INTO `tp_region` VALUES ('13660', '万苍乡', '4', '13641');
INSERT INTO `tp_region` VALUES ('13661', '九和乡', '4', '13641');
INSERT INTO `tp_region` VALUES ('13662', '兰溪市', '3', '13564');
INSERT INTO `tp_region` VALUES ('13663', '兰江街道', '4', '13662');
INSERT INTO `tp_region` VALUES ('13664', '云山街道', '4', '13662');
INSERT INTO `tp_region` VALUES ('13665', '永昌街道', '4', '13662');
INSERT INTO `tp_region` VALUES ('13666', '赤溪街道', '4', '13662');
INSERT INTO `tp_region` VALUES ('13667', '女埠街道', '4', '13662');
INSERT INTO `tp_region` VALUES ('13668', '上华街道', '4', '13662');
INSERT INTO `tp_region` VALUES ('13669', '游埠镇', '4', '13662');
INSERT INTO `tp_region` VALUES ('13670', '诸葛镇', '4', '13662');
INSERT INTO `tp_region` VALUES ('13671', '黄店镇', '4', '13662');
INSERT INTO `tp_region` VALUES ('13672', '香溪镇', '4', '13662');
INSERT INTO `tp_region` VALUES ('13673', '马涧镇', '4', '13662');
INSERT INTO `tp_region` VALUES ('13674', '梅江镇', '4', '13662');
INSERT INTO `tp_region` VALUES ('13675', '灵洞乡', '4', '13662');
INSERT INTO `tp_region` VALUES ('13676', '水亭畲族乡', '4', '13662');
INSERT INTO `tp_region` VALUES ('13677', '柏社乡', '4', '13662');
INSERT INTO `tp_region` VALUES ('13678', '义乌市', '3', '13564');
INSERT INTO `tp_region` VALUES ('13679', '稠城街道', '4', '13678');
INSERT INTO `tp_region` VALUES ('13680', '江东街道', '4', '13678');
INSERT INTO `tp_region` VALUES ('13681', '稠江街道', '4', '13678');
INSERT INTO `tp_region` VALUES ('13682', '北苑街道', '4', '13678');
INSERT INTO `tp_region` VALUES ('13683', '后宅街道', '4', '13678');
INSERT INTO `tp_region` VALUES ('13684', '城西街道', '4', '13678');
INSERT INTO `tp_region` VALUES ('13685', '廿三里街道', '4', '13678');
INSERT INTO `tp_region` VALUES ('13686', '佛堂镇', '4', '13678');
INSERT INTO `tp_region` VALUES ('13687', '赤岸镇', '4', '13678');
INSERT INTO `tp_region` VALUES ('13688', '义亭镇', '4', '13678');
INSERT INTO `tp_region` VALUES ('13689', '上溪镇', '4', '13678');
INSERT INTO `tp_region` VALUES ('13690', '苏溪镇', '4', '13678');
INSERT INTO `tp_region` VALUES ('13691', '大陈镇', '4', '13678');
INSERT INTO `tp_region` VALUES ('13692', '东阳市', '3', '13564');
INSERT INTO `tp_region` VALUES ('13693', '吴宁街道', '4', '13692');
INSERT INTO `tp_region` VALUES ('13694', '南市街道', '4', '13692');
INSERT INTO `tp_region` VALUES ('13695', '白云街道', '4', '13692');
INSERT INTO `tp_region` VALUES ('13696', '江北街道', '4', '13692');
INSERT INTO `tp_region` VALUES ('13697', '城东街道', '4', '13692');
INSERT INTO `tp_region` VALUES ('13698', '六石街道', '4', '13692');
INSERT INTO `tp_region` VALUES ('13699', '巍山镇', '4', '13692');
INSERT INTO `tp_region` VALUES ('13700', '虎鹿镇', '4', '13692');
INSERT INTO `tp_region` VALUES ('13701', '歌山镇', '4', '13692');
INSERT INTO `tp_region` VALUES ('13702', '佐村镇', '4', '13692');
INSERT INTO `tp_region` VALUES ('13703', '东阳江镇', '4', '13692');
INSERT INTO `tp_region` VALUES ('13704', '湖溪镇', '4', '13692');
INSERT INTO `tp_region` VALUES ('13705', '马宅镇', '4', '13692');
INSERT INTO `tp_region` VALUES ('13706', '千祥镇', '4', '13692');
INSERT INTO `tp_region` VALUES ('13707', '南马镇', '4', '13692');
INSERT INTO `tp_region` VALUES ('13708', '画水镇', '4', '13692');
INSERT INTO `tp_region` VALUES ('13709', '横店镇', '4', '13692');
INSERT INTO `tp_region` VALUES ('13710', '三单乡', '4', '13692');
INSERT INTO `tp_region` VALUES ('13711', '永康市', '3', '13564');
INSERT INTO `tp_region` VALUES ('13712', '东城街道', '4', '13711');
INSERT INTO `tp_region` VALUES ('13713', '西城街道', '4', '13711');
INSERT INTO `tp_region` VALUES ('13714', '江南街道', '4', '13711');
INSERT INTO `tp_region` VALUES ('13715', '芝英街道', '4', '13711');
INSERT INTO `tp_region` VALUES ('13716', '石柱镇', '4', '13711');
INSERT INTO `tp_region` VALUES ('13717', '前仓镇', '4', '13711');
INSERT INTO `tp_region` VALUES ('13718', '舟山镇', '4', '13711');
INSERT INTO `tp_region` VALUES ('13719', '古山镇', '4', '13711');
INSERT INTO `tp_region` VALUES ('13720', '方岩镇', '4', '13711');
INSERT INTO `tp_region` VALUES ('13721', '龙山镇', '4', '13711');
INSERT INTO `tp_region` VALUES ('13722', '西溪镇', '4', '13711');
INSERT INTO `tp_region` VALUES ('13723', '象珠镇', '4', '13711');
INSERT INTO `tp_region` VALUES ('13724', '唐先镇', '4', '13711');
INSERT INTO `tp_region` VALUES ('13725', '花街镇', '4', '13711');
INSERT INTO `tp_region` VALUES ('13726', '衢州市', '2', '12596');
INSERT INTO `tp_region` VALUES ('13727', '市辖区', '3', '13726');
INSERT INTO `tp_region` VALUES ('13728', '柯城区', '3', '13726');
INSERT INTO `tp_region` VALUES ('13729', '新新街道', '4', '13728');
INSERT INTO `tp_region` VALUES ('13730', '府山街道', '4', '13728');
INSERT INTO `tp_region` VALUES ('13731', '荷花街道', '4', '13728');
INSERT INTO `tp_region` VALUES ('13732', '信安街道', '4', '13728');
INSERT INTO `tp_region` VALUES ('13733', '白云街道', '4', '13728');
INSERT INTO `tp_region` VALUES ('13734', '双港街道', '4', '13728');
INSERT INTO `tp_region` VALUES ('13735', '花园街道', '4', '13728');
INSERT INTO `tp_region` VALUES ('13736', '石梁镇', '4', '13728');
INSERT INTO `tp_region` VALUES ('13737', '航埠镇', '4', '13728');
INSERT INTO `tp_region` VALUES ('13738', '黄家乡', '4', '13728');
INSERT INTO `tp_region` VALUES ('13739', '七里乡', '4', '13728');
INSERT INTO `tp_region` VALUES ('13740', '九华乡', '4', '13728');
INSERT INTO `tp_region` VALUES ('13741', '沟溪乡', '4', '13728');
INSERT INTO `tp_region` VALUES ('13742', '华墅乡', '4', '13728');
INSERT INTO `tp_region` VALUES ('13743', '姜家山乡', '4', '13728');
INSERT INTO `tp_region` VALUES ('13744', '万田乡', '4', '13728');
INSERT INTO `tp_region` VALUES ('13745', '石室乡', '4', '13728');
INSERT INTO `tp_region` VALUES ('13746', '衢江区', '3', '13726');
INSERT INTO `tp_region` VALUES ('13747', '樟潭街道', '4', '13746');
INSERT INTO `tp_region` VALUES ('13748', '浮石街道', '4', '13746');
INSERT INTO `tp_region` VALUES ('13749', '上方镇', '4', '13746');
INSERT INTO `tp_region` VALUES ('13750', '峡川镇', '4', '13746');
INSERT INTO `tp_region` VALUES ('13751', '莲花镇', '4', '13746');
INSERT INTO `tp_region` VALUES ('13752', '全旺镇', '4', '13746');
INSERT INTO `tp_region` VALUES ('13753', '大洲镇', '4', '13746');
INSERT INTO `tp_region` VALUES ('13754', '后溪镇', '4', '13746');
INSERT INTO `tp_region` VALUES ('13755', '廿里镇', '4', '13746');
INSERT INTO `tp_region` VALUES ('13756', '湖南镇', '4', '13746');
INSERT INTO `tp_region` VALUES ('13757', '高家镇', '4', '13746');
INSERT INTO `tp_region` VALUES ('13758', '杜泽镇', '4', '13746');
INSERT INTO `tp_region` VALUES ('13759', '灰坪乡', '4', '13746');
INSERT INTO `tp_region` VALUES ('13760', '太真乡', '4', '13746');
INSERT INTO `tp_region` VALUES ('13761', '双桥乡', '4', '13746');
INSERT INTO `tp_region` VALUES ('13762', '周家乡', '4', '13746');
INSERT INTO `tp_region` VALUES ('13763', '云溪乡', '4', '13746');
INSERT INTO `tp_region` VALUES ('13764', '横路乡', '4', '13746');
INSERT INTO `tp_region` VALUES ('13765', '举村乡', '4', '13746');
INSERT INTO `tp_region` VALUES ('13766', '岭洋乡', '4', '13746');
INSERT INTO `tp_region` VALUES ('13767', '黄坛口乡', '4', '13746');
INSERT INTO `tp_region` VALUES ('13768', '常山县', '3', '13726');
INSERT INTO `tp_region` VALUES ('13769', '辉埠镇', '4', '13768');
INSERT INTO `tp_region` VALUES ('13770', '白石镇', '4', '13768');
INSERT INTO `tp_region` VALUES ('13771', '天马镇', '4', '13768');
INSERT INTO `tp_region` VALUES ('13772', '招贤镇', '4', '13768');
INSERT INTO `tp_region` VALUES ('13773', '青石镇', '4', '13768');
INSERT INTO `tp_region` VALUES ('13774', '芳村镇', '4', '13768');
INSERT INTO `tp_region` VALUES ('13775', '球川镇', '4', '13768');
INSERT INTO `tp_region` VALUES ('13776', '何家乡', '4', '13768');
INSERT INTO `tp_region` VALUES ('13777', '同弓乡', '4', '13768');
INSERT INTO `tp_region` VALUES ('13778', '大桥头乡', '4', '13768');
INSERT INTO `tp_region` VALUES ('13779', '宋畈乡', '4', '13768');
INSERT INTO `tp_region` VALUES ('13780', '东案乡', '4', '13768');
INSERT INTO `tp_region` VALUES ('13781', '新昌乡', '4', '13768');
INSERT INTO `tp_region` VALUES ('13782', '新桥乡', '4', '13768');
INSERT INTO `tp_region` VALUES ('13783', '开化县', '3', '13726');
INSERT INTO `tp_region` VALUES ('13784', '桐村镇', '4', '13783');
INSERT INTO `tp_region` VALUES ('13785', '杨林镇', '4', '13783');
INSERT INTO `tp_region` VALUES ('13786', '苏庄镇', '4', '13783');
INSERT INTO `tp_region` VALUES ('13787', '齐溪镇', '4', '13783');
INSERT INTO `tp_region` VALUES ('13788', '城关镇', '4', '13783');
INSERT INTO `tp_region` VALUES ('13789', '华埠镇', '4', '13783');
INSERT INTO `tp_region` VALUES ('13790', '马金镇', '4', '13783');
INSERT INTO `tp_region` VALUES ('13791', '村头镇', '4', '13783');
INSERT INTO `tp_region` VALUES ('13792', '池淮镇', '4', '13783');
INSERT INTO `tp_region` VALUES ('13793', '中村乡', '4', '13783');
INSERT INTO `tp_region` VALUES ('13794', '长虹乡', '4', '13783');
INSERT INTO `tp_region` VALUES ('13795', '张湾乡', '4', '13783');
INSERT INTO `tp_region` VALUES ('13796', '何田乡', '4', '13783');
INSERT INTO `tp_region` VALUES ('13797', '塘坞乡', '4', '13783');
INSERT INTO `tp_region` VALUES ('13798', '林山乡', '4', '13783');
INSERT INTO `tp_region` VALUES ('13799', '音坑乡', '4', '13783');
INSERT INTO `tp_region` VALUES ('13800', '大溪边乡', '4', '13783');
INSERT INTO `tp_region` VALUES ('13801', '金村乡', '4', '13783');
INSERT INTO `tp_region` VALUES ('13802', '龙游县', '3', '13726');
INSERT INTO `tp_region` VALUES ('13803', '龙洲街道', '4', '13802');
INSERT INTO `tp_region` VALUES ('13804', '东华街道', '4', '13802');
INSERT INTO `tp_region` VALUES ('13805', '湖镇镇', '4', '13802');
INSERT INTO `tp_region` VALUES ('13806', '小南海镇', '4', '13802');
INSERT INTO `tp_region` VALUES ('13807', '詹家镇', '4', '13802');
INSERT INTO `tp_region` VALUES ('13808', '溪口镇', '4', '13802');
INSERT INTO `tp_region` VALUES ('13809', '横山镇', '4', '13802');
INSERT INTO `tp_region` VALUES ('13810', '塔石镇', '4', '13802');
INSERT INTO `tp_region` VALUES ('13811', '罗家乡', '4', '13802');
INSERT INTO `tp_region` VALUES ('13812', '庙下乡', '4', '13802');
INSERT INTO `tp_region` VALUES ('13813', '石佛乡', '4', '13802');
INSERT INTO `tp_region` VALUES ('13814', '社阳乡', '4', '13802');
INSERT INTO `tp_region` VALUES ('13815', '大街乡', '4', '13802');
INSERT INTO `tp_region` VALUES ('13816', '沐尘畲族乡', '4', '13802');
INSERT INTO `tp_region` VALUES ('13817', '模环乡', '4', '13802');
INSERT INTO `tp_region` VALUES ('13818', '江山市', '3', '13726');
INSERT INTO `tp_region` VALUES ('13819', '双塔街道', '4', '13818');
INSERT INTO `tp_region` VALUES ('13820', '虎山街道', '4', '13818');
INSERT INTO `tp_region` VALUES ('13821', '四都镇', '4', '13818');
INSERT INTO `tp_region` VALUES ('13822', '清湖镇', '4', '13818');
INSERT INTO `tp_region` VALUES ('13823', '坛石镇', '4', '13818');
INSERT INTO `tp_region` VALUES ('13824', '大桥镇', '4', '13818');
INSERT INTO `tp_region` VALUES ('13825', '淤头镇', '4', '13818');
INSERT INTO `tp_region` VALUES ('13826', '新塘边镇', '4', '13818');
INSERT INTO `tp_region` VALUES ('13827', '廿八都镇', '4', '13818');
INSERT INTO `tp_region` VALUES ('13828', '长台镇', '4', '13818');
INSERT INTO `tp_region` VALUES ('13829', '上余镇', '4', '13818');
INSERT INTO `tp_region` VALUES ('13830', '贺村镇', '4', '13818');
INSERT INTO `tp_region` VALUES ('13831', '凤林镇', '4', '13818');
INSERT INTO `tp_region` VALUES ('13832', '峡口镇', '4', '13818');
INSERT INTO `tp_region` VALUES ('13833', '石门镇', '4', '13818');
INSERT INTO `tp_region` VALUES ('13834', '大陈乡', '4', '13818');
INSERT INTO `tp_region` VALUES ('13835', '碗窑乡', '4', '13818');
INSERT INTO `tp_region` VALUES ('13836', '保安乡', '4', '13818');
INSERT INTO `tp_region` VALUES ('13837', '双溪口乡', '4', '13818');
INSERT INTO `tp_region` VALUES ('13838', '张村乡', '4', '13818');
INSERT INTO `tp_region` VALUES ('13839', '塘源口乡', '4', '13818');
INSERT INTO `tp_region` VALUES ('13840', '舟山市', '2', '12596');
INSERT INTO `tp_region` VALUES ('13841', '市辖区', '3', '13840');
INSERT INTO `tp_region` VALUES ('13842', '定海区', '3', '13840');
INSERT INTO `tp_region` VALUES ('13843', '解放街道', '4', '13842');
INSERT INTO `tp_region` VALUES ('13844', '昌国街道', '4', '13842');
INSERT INTO `tp_region` VALUES ('13845', '环南街道', '4', '13842');
INSERT INTO `tp_region` VALUES ('13846', '城东街道', '4', '13842');
INSERT INTO `tp_region` VALUES ('13847', '盐仓街道', '4', '13842');
INSERT INTO `tp_region` VALUES ('13848', '临城街道', '4', '13842');
INSERT INTO `tp_region` VALUES ('13849', '金塘镇', '4', '13842');
INSERT INTO `tp_region` VALUES ('13850', '小沙镇', '4', '13842');
INSERT INTO `tp_region` VALUES ('13851', '岑港镇', '4', '13842');
INSERT INTO `tp_region` VALUES ('13852', '双桥镇', '4', '13842');
INSERT INTO `tp_region` VALUES ('13853', '白泉镇', '4', '13842');
INSERT INTO `tp_region` VALUES ('13854', '干览镇', '4', '13842');
INSERT INTO `tp_region` VALUES ('13855', '马岙镇', '4', '13842');
INSERT INTO `tp_region` VALUES ('13856', '长白乡', '4', '13842');
INSERT INTO `tp_region` VALUES ('13857', '册子乡', '4', '13842');
INSERT INTO `tp_region` VALUES ('13858', '北蝉乡', '4', '13842');
INSERT INTO `tp_region` VALUES ('13859', '普陀区', '3', '13840');
INSERT INTO `tp_region` VALUES ('13860', '沈家门街道', '4', '13859');
INSERT INTO `tp_region` VALUES ('13861', '勾山街道', '4', '13859');
INSERT INTO `tp_region` VALUES ('13862', '东港街道', '4', '13859');
INSERT INTO `tp_region` VALUES ('13863', '六横镇', '4', '13859');
INSERT INTO `tp_region` VALUES ('13864', '朱家尖镇', '4', '13859');
INSERT INTO `tp_region` VALUES ('13865', '虾峙镇', '4', '13859');
INSERT INTO `tp_region` VALUES ('13866', '展茅镇', '4', '13859');
INSERT INTO `tp_region` VALUES ('13867', '桃花镇', '4', '13859');
INSERT INTO `tp_region` VALUES ('13868', '东极镇', '4', '13859');
INSERT INTO `tp_region` VALUES ('13869', '普陀山镇', '4', '13859');
INSERT INTO `tp_region` VALUES ('13870', '蚂蚁岛乡', '4', '13859');
INSERT INTO `tp_region` VALUES ('13871', '登步乡', '4', '13859');
INSERT INTO `tp_region` VALUES ('13872', '白沙乡', '4', '13859');
INSERT INTO `tp_region` VALUES ('13873', '佛渡乡', '4', '13859');
INSERT INTO `tp_region` VALUES ('13874', '岱山县', '3', '13840');
INSERT INTO `tp_region` VALUES ('13875', '高亭镇', '4', '13874');
INSERT INTO `tp_region` VALUES ('13876', '东沙镇', '4', '13874');
INSERT INTO `tp_region` VALUES ('13877', '岱东镇', '4', '13874');
INSERT INTO `tp_region` VALUES ('13878', '岱西镇', '4', '13874');
INSERT INTO `tp_region` VALUES ('13879', '长涂镇', '4', '13874');
INSERT INTO `tp_region` VALUES ('13880', '衢山镇', '4', '13874');
INSERT INTO `tp_region` VALUES ('13881', '秀山乡', '4', '13874');
INSERT INTO `tp_region` VALUES ('13882', '嵊泗县', '3', '13840');
INSERT INTO `tp_region` VALUES ('13883', '菜园镇', '4', '13882');
INSERT INTO `tp_region` VALUES ('13884', '嵊山镇', '4', '13882');
INSERT INTO `tp_region` VALUES ('13885', '洋山镇', '4', '13882');
INSERT INTO `tp_region` VALUES ('13886', '五龙乡', '4', '13882');
INSERT INTO `tp_region` VALUES ('13887', '黄龙乡', '4', '13882');
INSERT INTO `tp_region` VALUES ('13888', '枸杞乡', '4', '13882');
INSERT INTO `tp_region` VALUES ('13889', '花鸟乡', '4', '13882');
INSERT INTO `tp_region` VALUES ('13890', '台州市', '2', '12596');
INSERT INTO `tp_region` VALUES ('13891', '市辖区', '3', '13890');
INSERT INTO `tp_region` VALUES ('13892', '椒江区', '3', '13890');
INSERT INTO `tp_region` VALUES ('13893', '海门街道', '4', '13892');
INSERT INTO `tp_region` VALUES ('13894', '白云街道', '4', '13892');
INSERT INTO `tp_region` VALUES ('13895', '葭沚街道', '4', '13892');
INSERT INTO `tp_region` VALUES ('13896', '洪家街道', '4', '13892');
INSERT INTO `tp_region` VALUES ('13897', '三甲街道', '4', '13892');
INSERT INTO `tp_region` VALUES ('13898', '下陈街道', '4', '13892');
INSERT INTO `tp_region` VALUES ('13899', '前所街道', '4', '13892');
INSERT INTO `tp_region` VALUES ('13900', '章安街道', '4', '13892');
INSERT INTO `tp_region` VALUES ('13901', '大陈镇', '4', '13892');
INSERT INTO `tp_region` VALUES ('13902', '椒江农场', '4', '13892');
INSERT INTO `tp_region` VALUES ('13903', '黄岩区', '3', '13890');
INSERT INTO `tp_region` VALUES ('13904', '东城街道', '4', '13903');
INSERT INTO `tp_region` VALUES ('13905', '南城街道', '4', '13903');
INSERT INTO `tp_region` VALUES ('13906', '西城街道', '4', '13903');
INSERT INTO `tp_region` VALUES ('13907', '北城街道', '4', '13903');
INSERT INTO `tp_region` VALUES ('13908', '新前街道', '4', '13903');
INSERT INTO `tp_region` VALUES ('13909', '澄江街道', '4', '13903');
INSERT INTO `tp_region` VALUES ('13910', '江口街道', '4', '13903');
INSERT INTO `tp_region` VALUES ('13911', '高桥街道', '4', '13903');
INSERT INTO `tp_region` VALUES ('13912', '宁溪镇', '4', '13903');
INSERT INTO `tp_region` VALUES ('13913', '北洋镇', '4', '13903');
INSERT INTO `tp_region` VALUES ('13914', '头陀镇', '4', '13903');
INSERT INTO `tp_region` VALUES ('13915', '院桥镇', '4', '13903');
INSERT INTO `tp_region` VALUES ('13916', '沙埠镇', '4', '13903');
INSERT INTO `tp_region` VALUES ('13917', '屿头乡', '4', '13903');
INSERT INTO `tp_region` VALUES ('13918', '上郑乡', '4', '13903');
INSERT INTO `tp_region` VALUES ('13919', '富山乡', '4', '13903');
INSERT INTO `tp_region` VALUES ('13920', '茅畲乡', '4', '13903');
INSERT INTO `tp_region` VALUES ('13921', '上垟乡', '4', '13903');
INSERT INTO `tp_region` VALUES ('13922', '平田乡', '4', '13903');
INSERT INTO `tp_region` VALUES ('13923', '路桥区', '3', '13890');
INSERT INTO `tp_region` VALUES ('13924', '路南街道', '4', '13923');
INSERT INTO `tp_region` VALUES ('13925', '路桥街道', '4', '13923');
INSERT INTO `tp_region` VALUES ('13926', '路北街道', '4', '13923');
INSERT INTO `tp_region` VALUES ('13927', '螺洋街道', '4', '13923');
INSERT INTO `tp_region` VALUES ('13928', '桐屿街道', '4', '13923');
INSERT INTO `tp_region` VALUES ('13929', '峰江街道', '4', '13923');
INSERT INTO `tp_region` VALUES ('13930', '新桥镇', '4', '13923');
INSERT INTO `tp_region` VALUES ('13931', '横街镇', '4', '13923');
INSERT INTO `tp_region` VALUES ('13932', '金清镇', '4', '13923');
INSERT INTO `tp_region` VALUES ('13933', '蓬街镇', '4', '13923');
INSERT INTO `tp_region` VALUES ('13934', '玉环县', '3', '13890');
INSERT INTO `tp_region` VALUES ('13935', '珠港镇', '4', '13934');
INSERT INTO `tp_region` VALUES ('13936', '清港镇', '4', '13934');
INSERT INTO `tp_region` VALUES ('13937', '楚门镇', '4', '13934');
INSERT INTO `tp_region` VALUES ('13938', '干江镇', '4', '13934');
INSERT INTO `tp_region` VALUES ('13939', '沙门镇', '4', '13934');
INSERT INTO `tp_region` VALUES ('13940', '芦浦镇', '4', '13934');
INSERT INTO `tp_region` VALUES ('13941', '龙溪乡', '4', '13934');
INSERT INTO `tp_region` VALUES ('13942', '鸡山乡', '4', '13934');
INSERT INTO `tp_region` VALUES ('13943', '海山乡', '4', '13934');
INSERT INTO `tp_region` VALUES ('13944', '三门县', '3', '13890');
INSERT INTO `tp_region` VALUES ('13945', '海游镇', '4', '13944');
INSERT INTO `tp_region` VALUES ('13946', '沙柳镇', '4', '13944');
INSERT INTO `tp_region` VALUES ('13947', '珠岙镇', '4', '13944');
INSERT INTO `tp_region` VALUES ('13948', '亭旁镇', '4', '13944');
INSERT INTO `tp_region` VALUES ('13949', '六敖镇', '4', '13944');
INSERT INTO `tp_region` VALUES ('13950', '健跳镇', '4', '13944');
INSERT INTO `tp_region` VALUES ('13951', '横渡镇', '4', '13944');
INSERT INTO `tp_region` VALUES ('13952', '浬浦镇', '4', '13944');
INSERT INTO `tp_region` VALUES ('13953', '花桥镇', '4', '13944');
INSERT INTO `tp_region` VALUES ('13954', '小雄镇', '4', '13944');
INSERT INTO `tp_region` VALUES ('13955', '高枧乡', '4', '13944');
INSERT INTO `tp_region` VALUES ('13956', '沿赤乡', '4', '13944');
INSERT INTO `tp_region` VALUES ('13957', '泗淋乡', '4', '13944');
INSERT INTO `tp_region` VALUES ('13958', '蛇蟠乡', '4', '13944');
INSERT INTO `tp_region` VALUES ('13959', '天台县', '3', '13890');
INSERT INTO `tp_region` VALUES ('13960', '赤城街道', '4', '13959');
INSERT INTO `tp_region` VALUES ('13961', '始丰街道', '4', '13959');
INSERT INTO `tp_region` VALUES ('13962', '福溪街道', '4', '13959');
INSERT INTO `tp_region` VALUES ('13963', '白鹤镇', '4', '13959');
INSERT INTO `tp_region` VALUES ('13964', '石梁镇', '4', '13959');
INSERT INTO `tp_region` VALUES ('13965', '街头镇', '4', '13959');
INSERT INTO `tp_region` VALUES ('13966', '平桥镇', '4', '13959');
INSERT INTO `tp_region` VALUES ('13967', '坦头镇', '4', '13959');
INSERT INTO `tp_region` VALUES ('13968', '三合镇', '4', '13959');
INSERT INTO `tp_region` VALUES ('13969', '洪畴镇', '4', '13959');
INSERT INTO `tp_region` VALUES ('13970', '三州乡', '4', '13959');
INSERT INTO `tp_region` VALUES ('13971', '龙溪乡', '4', '13959');
INSERT INTO `tp_region` VALUES ('13972', '雷峰乡', '4', '13959');
INSERT INTO `tp_region` VALUES ('13973', '南屏乡', '4', '13959');
INSERT INTO `tp_region` VALUES ('13974', '泳溪乡', '4', '13959');
INSERT INTO `tp_region` VALUES ('13975', '仙居县', '3', '13890');
INSERT INTO `tp_region` VALUES ('13976', '安洲街道', '4', '13975');
INSERT INTO `tp_region` VALUES ('13977', '南峰街道', '4', '13975');
INSERT INTO `tp_region` VALUES ('13978', '福应街道', '4', '13975');
INSERT INTO `tp_region` VALUES ('13979', '横溪镇', '4', '13975');
INSERT INTO `tp_region` VALUES ('13980', '埠头镇', '4', '13975');
INSERT INTO `tp_region` VALUES ('13981', '白塔镇', '4', '13975');
INSERT INTO `tp_region` VALUES ('13982', '田市镇', '4', '13975');
INSERT INTO `tp_region` VALUES ('13983', '官路镇', '4', '13975');
INSERT INTO `tp_region` VALUES ('13984', '下各镇', '4', '13975');
INSERT INTO `tp_region` VALUES ('13985', '朱溪镇', '4', '13975');
INSERT INTO `tp_region` VALUES ('13986', '安岭乡', '4', '13975');
INSERT INTO `tp_region` VALUES ('13987', '溪港乡', '4', '13975');
INSERT INTO `tp_region` VALUES ('13988', '湫山乡', '4', '13975');
INSERT INTO `tp_region` VALUES ('13989', '淡竹乡', '4', '13975');
INSERT INTO `tp_region` VALUES ('13990', '皤滩乡', '4', '13975');
INSERT INTO `tp_region` VALUES ('13991', '上张乡', '4', '13975');
INSERT INTO `tp_region` VALUES ('13992', '步路乡', '4', '13975');
INSERT INTO `tp_region` VALUES ('13993', '广度乡', '4', '13975');
INSERT INTO `tp_region` VALUES ('13994', '大战乡', '4', '13975');
INSERT INTO `tp_region` VALUES ('13995', '双庙乡', '4', '13975');
INSERT INTO `tp_region` VALUES ('13996', '温岭市', '3', '13890');
INSERT INTO `tp_region` VALUES ('13997', '太平街道', '4', '13996');
INSERT INTO `tp_region` VALUES ('13998', '城东街道', '4', '13996');
INSERT INTO `tp_region` VALUES ('13999', '城西街道', '4', '13996');
INSERT INTO `tp_region` VALUES ('14000', '城北街道', '4', '13996');
INSERT INTO `tp_region` VALUES ('14001', '横峰街道', '4', '13996');
INSERT INTO `tp_region` VALUES ('14002', '泽国镇', '4', '13996');
INSERT INTO `tp_region` VALUES ('14003', '大溪镇', '4', '13996');
INSERT INTO `tp_region` VALUES ('14004', '松门镇', '4', '13996');
INSERT INTO `tp_region` VALUES ('14005', '箬横镇', '4', '13996');
INSERT INTO `tp_region` VALUES ('14006', '新河镇', '4', '13996');
INSERT INTO `tp_region` VALUES ('14007', '石塘镇', '4', '13996');
INSERT INTO `tp_region` VALUES ('14008', '滨海镇', '4', '13996');
INSERT INTO `tp_region` VALUES ('14009', '温峤镇', '4', '13996');
INSERT INTO `tp_region` VALUES ('14010', '城南镇', '4', '13996');
INSERT INTO `tp_region` VALUES ('14011', '石桥头镇', '4', '13996');
INSERT INTO `tp_region` VALUES ('14012', '坞根镇', '4', '13996');
INSERT INTO `tp_region` VALUES ('14013', '临海市', '3', '13890');
INSERT INTO `tp_region` VALUES ('14014', '古城街道', '4', '14013');
INSERT INTO `tp_region` VALUES ('14015', '大洋街道', '4', '14013');
INSERT INTO `tp_region` VALUES ('14016', '江南街道', '4', '14013');
INSERT INTO `tp_region` VALUES ('14017', '大田街道', '4', '14013');
INSERT INTO `tp_region` VALUES ('14018', '邵家渡街道', '4', '14013');
INSERT INTO `tp_region` VALUES ('14019', '汛桥镇', '4', '14013');
INSERT INTO `tp_region` VALUES ('14020', '东塍镇', '4', '14013');
INSERT INTO `tp_region` VALUES ('14021', '汇溪镇', '4', '14013');
INSERT INTO `tp_region` VALUES ('14022', '小芝镇', '4', '14013');
INSERT INTO `tp_region` VALUES ('14023', '河头镇', '4', '14013');
INSERT INTO `tp_region` VALUES ('14024', '白水洋镇', '4', '14013');
INSERT INTO `tp_region` VALUES ('14025', '括苍镇', '4', '14013');
INSERT INTO `tp_region` VALUES ('14026', '永丰镇', '4', '14013');
INSERT INTO `tp_region` VALUES ('14027', '尤溪镇', '4', '14013');
INSERT INTO `tp_region` VALUES ('14028', '涌泉镇', '4', '14013');
INSERT INTO `tp_region` VALUES ('14029', '沿江镇', '4', '14013');
INSERT INTO `tp_region` VALUES ('14030', '杜桥镇', '4', '14013');
INSERT INTO `tp_region` VALUES ('14031', '上盘镇', '4', '14013');
INSERT INTO `tp_region` VALUES ('14032', '桃渚镇', '4', '14013');
INSERT INTO `tp_region` VALUES ('14033', '丽水市', '2', '12596');
INSERT INTO `tp_region` VALUES ('14034', '市辖区', '3', '14033');
INSERT INTO `tp_region` VALUES ('14035', '莲都区', '3', '14033');
INSERT INTO `tp_region` VALUES ('14036', '紫金街道', '4', '14035');
INSERT INTO `tp_region` VALUES ('14037', '岩泉街道', '4', '14035');
INSERT INTO `tp_region` VALUES ('14038', '万象街道', '4', '14035');
INSERT INTO `tp_region` VALUES ('14039', '白云街道', '4', '14035');
INSERT INTO `tp_region` VALUES ('14040', '水阁街道', '4', '14035');
INSERT INTO `tp_region` VALUES ('14041', '富岭街道', '4', '14035');
INSERT INTO `tp_region` VALUES ('14042', '碧湖镇', '4', '14035');
INSERT INTO `tp_region` VALUES ('14043', '联城镇', '4', '14035');
INSERT INTO `tp_region` VALUES ('14044', '大港头镇', '4', '14035');
INSERT INTO `tp_region` VALUES ('14045', '老竹畲族镇', '4', '14035');
INSERT INTO `tp_region` VALUES ('14046', '雅溪镇', '4', '14035');
INSERT INTO `tp_region` VALUES ('14047', '太平乡', '4', '14035');
INSERT INTO `tp_region` VALUES ('14048', '仙渡乡', '4', '14035');
INSERT INTO `tp_region` VALUES ('14049', '峰源乡', '4', '14035');
INSERT INTO `tp_region` VALUES ('14050', '高溪乡', '4', '14035');
INSERT INTO `tp_region` VALUES ('14051', '丽新畲族乡', '4', '14035');
INSERT INTO `tp_region` VALUES ('14052', '双黄乡', '4', '14035');
INSERT INTO `tp_region` VALUES ('14053', '黄村乡', '4', '14035');
INSERT INTO `tp_region` VALUES ('14054', '青田县', '3', '14033');
INSERT INTO `tp_region` VALUES ('14055', '鹤城镇', '4', '14054');
INSERT INTO `tp_region` VALUES ('14056', '温溪镇', '4', '14054');
INSERT INTO `tp_region` VALUES ('14057', '东源镇', '4', '14054');
INSERT INTO `tp_region` VALUES ('14058', '高湖镇', '4', '14054');
INSERT INTO `tp_region` VALUES ('14059', '船寮镇', '4', '14054');
INSERT INTO `tp_region` VALUES ('14060', '海口镇', '4', '14054');
INSERT INTO `tp_region` VALUES ('14061', '腊口镇', '4', '14054');
INSERT INTO `tp_region` VALUES ('14062', '北山镇', '4', '14054');
INSERT INTO `tp_region` VALUES ('14063', '山口镇', '4', '14054');
INSERT INTO `tp_region` VALUES ('14064', '仁庄镇', '4', '14054');
INSERT INTO `tp_region` VALUES ('14065', '万山乡', '4', '14054');
INSERT INTO `tp_region` VALUES ('14066', '黄垟乡', '4', '14054');
INSERT INTO `tp_region` VALUES ('14067', '季宅乡', '4', '14054');
INSERT INTO `tp_region` VALUES ('14068', '高市乡', '4', '14054');
INSERT INTO `tp_region` VALUES ('14069', '海溪乡', '4', '14054');
INSERT INTO `tp_region` VALUES ('14070', '章村乡', '4', '14054');
INSERT INTO `tp_region` VALUES ('14071', '祯旺乡', '4', '14054');
INSERT INTO `tp_region` VALUES ('14072', '祯埠乡', '4', '14054');
INSERT INTO `tp_region` VALUES ('14073', '舒桥乡', '4', '14054');
INSERT INTO `tp_region` VALUES ('14074', '巨浦乡', '4', '14054');
INSERT INTO `tp_region` VALUES ('14075', '岭根乡', '4', '14054');
INSERT INTO `tp_region` VALUES ('14076', '万阜乡', '4', '14054');
INSERT INTO `tp_region` VALUES ('14077', '方山乡', '4', '14054');
INSERT INTO `tp_region` VALUES ('14078', '汤垟乡', '4', '14054');
INSERT INTO `tp_region` VALUES ('14079', '贵岙乡', '4', '14054');
INSERT INTO `tp_region` VALUES ('14080', '小舟山乡', '4', '14054');
INSERT INTO `tp_region` VALUES ('14081', '吴坑乡', '4', '14054');
INSERT INTO `tp_region` VALUES ('14082', '仁宫乡', '4', '14054');
INSERT INTO `tp_region` VALUES ('14083', '章旦乡', '4', '14054');
INSERT INTO `tp_region` VALUES ('14084', '阜山乡', '4', '14054');
INSERT INTO `tp_region` VALUES ('14085', '石溪乡', '4', '14054');
INSERT INTO `tp_region` VALUES ('14086', '缙云县', '3', '14033');
INSERT INTO `tp_region` VALUES ('14087', '五云镇', '4', '14086');
INSERT INTO `tp_region` VALUES ('14088', '壶镇镇', '4', '14086');
INSERT INTO `tp_region` VALUES ('14089', '新建镇', '4', '14086');
INSERT INTO `tp_region` VALUES ('14090', '舒洪镇', '4', '14086');
INSERT INTO `tp_region` VALUES ('14091', '新碧镇', '4', '14086');
INSERT INTO `tp_region` VALUES ('14092', '大洋镇', '4', '14086');
INSERT INTO `tp_region` VALUES ('14093', '东渡镇', '4', '14086');
INSERT INTO `tp_region` VALUES ('14094', '东方镇', '4', '14086');
INSERT INTO `tp_region` VALUES ('14095', '大源镇', '4', '14086');
INSERT INTO `tp_region` VALUES ('14096', '新川乡', '4', '14086');
INSERT INTO `tp_region` VALUES ('14097', '双川乡', '4', '14086');
INSERT INTO `tp_region` VALUES ('14098', '城北乡', '4', '14086');
INSERT INTO `tp_region` VALUES ('14099', '七里乡', '4', '14086');
INSERT INTO `tp_region` VALUES ('14100', '白竹乡', '4', '14086');
INSERT INTO `tp_region` VALUES ('14101', '雁岭乡', '4', '14086');
INSERT INTO `tp_region` VALUES ('14102', '前路乡', '4', '14086');
INSERT INTO `tp_region` VALUES ('14103', '三溪乡', '4', '14086');
INSERT INTO `tp_region` VALUES ('14104', '溶江乡', '4', '14086');
INSERT INTO `tp_region` VALUES ('14105', '双溪口乡', '4', '14086');
INSERT INTO `tp_region` VALUES ('14106', '胡源乡', '4', '14086');
INSERT INTO `tp_region` VALUES ('14107', '方溪乡', '4', '14086');
INSERT INTO `tp_region` VALUES ('14108', '石笕乡', '4', '14086');
INSERT INTO `tp_region` VALUES ('14109', '南溪乡', '4', '14086');
INSERT INTO `tp_region` VALUES ('14110', '木栗乡', '4', '14086');
INSERT INTO `tp_region` VALUES ('14111', '遂昌县', '3', '14033');
INSERT INTO `tp_region` VALUES ('14112', '妙高镇', '4', '14111');
INSERT INTO `tp_region` VALUES ('14113', '云峰镇', '4', '14111');
INSERT INTO `tp_region` VALUES ('14114', '新路湾镇', '4', '14111');
INSERT INTO `tp_region` VALUES ('14115', '北界镇', '4', '14111');
INSERT INTO `tp_region` VALUES ('14116', '金竹镇', '4', '14111');
INSERT INTO `tp_region` VALUES ('14117', '大柘镇', '4', '